import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestRadioStats(DeviceTestCase):

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_0_3_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.0.3.01")
        exp_info = {
            'model': 'UFiber OLT4',
            'rf_tx_power': None,
            'sta_count': 2,
            'sw_version': '4.0.3',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_connect': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT4',
                'sw_version': '4.0.3'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.0.5.01")
        exp_info = {
            'model': 'UFiber OLT4',
            'rf_tx_power': None,
            'sta_count': 12,
            'sw_version': '4.0.5',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_connect': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT4',
                'sw_version': '4.0.5'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_1_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.1.0.01")
        exp_info = {
            'model': 'UFiber OLT4',
            'rf_tx_power': None,
            'sta_count': 42,
            'sw_version': '4.1.0',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_connect': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT4',
                'sw_version': '4.1.0'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.0.5.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 105,
            'sw_version': '4.0.5',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_connect': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT',
                'sw_version': '4.0.5'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_1_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.1.0.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 63,
            'sw_version': '4.1.0',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_connect': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT',
                'sw_version': '4.1.0'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_2_1_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.2.1.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 89,
            'sw_version': '4.2.1',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 50}
        exp_sta_stats = {
            '68:d7:9a:06:53:61': {
                'dev_macs': ['40:ed:00:42:96:7d'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:53:61',
                'name': 'brandi_pederson'
            },
            '68:d7:9a:06:53:bf': {
                'dev_macs': ['74:ac:b9:8d:ce:d8'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:53:bf',
                'name': 'ron_gallardo'
            },
            '68:d7:9a:06:fe:93': {
                'dev_macs': ['98:da:c4:8e:86:ab'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:fe:93',
                'name': 'nick_lundquist'
            },
            '68:d7:9a:06:ff:31': {
                'dev_macs': ['74:ac:b9:75:d1:6c'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:ff:31',
                'name': 'cathy_thompson'
            },
            '70:a7:41:32:f4:4c': {
                'dev_macs': ['5c:62:8b:ab:6a:bc'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f4:4c',
                'name': 'douglas_owens'
            },
            '70:a7:41:32:f4:8c': {
                'dev_macs': ['84:d8:1b:7a:da:60'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f4:8c',
                'name': 'brenda_chenal'
            },
            '70:a7:41:32:f5:10': {
                'dev_macs': ['48:22:54:57:18:bb'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f5:10',
                'name': 'terra_nomeland'
            },
            '70:a7:41:32:f5:7c': {
                'dev_macs': ['48:22:54:38:a7:ce'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f5:7c',
                'name': 'aaron_thole'
            },
            '70:a7:41:32:f5:d8': {
                'dev_macs': ['48:22:54:45:b9:48'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f5:d8',
                'name': 'atc_agency'
            },
            '70:a7:41:32:f6:54': {
                'dev_macs': ['48:22:54:57:23:6e'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f6:54',
                'name': 'nicole_richter'
            },
            '70:a7:41:33:2b:fc': {
                'dev_macs': ['48:22:54:38:a2:82'],
                'ip_address': None,
                'mac_address': '70:a7:41:33:2b:fc',
                'name': 'jo_degeer'
            },
            '70:a7:41:33:2c:b8': {
                'dev_macs': ['48:22:54:57:20:e9'],
                'ip_address': None,
                'mac_address': '70:a7:41:33:2c:b8',
                'name': 'corinne_mcnielly'
            },
            '70:a7:41:33:2c:d0': {
                'dev_macs': ['74:ac:b9:83:c0:00'],
                'ip_address': None,
                'mac_address': '70:a7:41:33:2c:d0',
                'name': 'pauline_miller'
            },
            '74:ac:b9:06:a7:ca': {
                'dev_macs': ['68:d7:9a:af:f1:39'],
                'ip_address': None,
                'mac_address': '74:ac:b9:06:a7:ca',
                'name': 'matt_johnson'
            },
            '78:45:58:95:c0:f4': {
                'dev_macs': ['5c:62:8b:ab:68:c4'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c0:f4',
                'name': 'connie_ecklund'
            },
            '78:45:58:95:c3:08': {
                'dev_macs': ['40:ed:00:42:8f:ea'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c3:08',
                'name': 'larry_hedlund'
            },
            '78:45:58:95:c3:6c': {
                'dev_macs': ['48:22:54:57:33:c7'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c3:6c',
                'name': 'dawn_meadows'
            },
            '78:45:58:95:c3:ac': {
                'dev_macs': ['5c:62:8b:ab:6f:45'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c3:ac',
                'name': 'laurie_hopp'
            },
            '78:45:58:95:c3:b0': {
                'dev_macs': ['a0:36:bc:1a:6b:68'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c3:b0',
                'name': 'justin_campbell'
            },
            '78:45:58:95:d3:80': {
                'dev_macs': ['5c:62:8b:ab:73:80'],
                'ip_address': None,
                'mac_address': '78:45:58:95:d3:80',
                'name': 'susan_olson'
            },
            '78:45:58:95:d4:78': {
                'dev_macs': ['5c:62:8b:ab:6b:19'],
                'ip_address': None,
                'mac_address': '78:45:58:95:d4:78',
                'name': 'lucy_swanson'
            },
            '78:45:58:95:d4:90': {
                'dev_macs': ['5c:62:8b:ab:66:39'],
                'ip_address': None,
                'mac_address': '78:45:58:95:d4:90',
                'name': 'marissa_woletz'
            },
            'b4:fb:e4:e6:d7:28': {
                'dev_macs': ['ac:15:a2:b2:16:08'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:d7:28',
                'name': 'james_brewster'
            },
            'b4:fb:e4:e6:d7:33': {
                'dev_macs': ['24:4b:fe:62:40:58'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:d7:33',
                'name': 'sarah_jorgenson'
            },
            'b4:fb:e4:e6:d7:37': {
                'dev_macs': ['68:d7:9a:af:f8:70'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:d7:37',
                'name': 'sundown_saloon'
            },
            'b4:fb:e4:e6:df:f5': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:df:f5',
                'name': 'sarah15_ltd'
            },
            'b4:fb:e4:e6:e2:86': {
                'dev_macs': ['b0:95:75:3d:59:a1'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e2:86',
                'name': 'pam_engen'
            },
            'b4:fb:e4:e6:e7:28': {
                'dev_macs': ['74:ac:b9:83:bc:b0'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e7:28',
                'name': 'sarah15_showroom'
            },
            'b4:fb:e4:e6:e7:2e': {
                'dev_macs': ['54:af:97:4f:f3:48'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e7:2e',
                'name': 'tim_olson'
            },
            'b4:fb:e4:e6:e7:3d': {
                'dev_macs': ['74:ac:b9:fd:b8:54'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e7:3d',
                'name': 'rich_brande'
            },
            'b4:fb:e4:e6:e7:c4': {
                'dev_macs': ['74:ac:b9:fd:b8:e4'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e7:c4',
                'name': 'veda_gade'
            },
            'b4:fb:e4:e6:e8:16': {
                'dev_macs': ['74:ac:b9:75:d0:a6'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e8:16',
                'name': 'lewis_vfw'
            },
            'b4:fb:e4:e6:e8:5f': {
                'dev_macs': ['74:ac:b9:75:d3:99'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e8:5f',
                'name': 'christine_strak'
            },
            'b4:fb:e4:e6:e8:9b': {
                'dev_macs': ['74:ac:b9:fd:b2:16'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e8:9b',
                'name': 'lance_howard'
            },
            'b4:fb:e4:e6:e8:fb': {
                'dev_macs': ['74:ac:b9:75:ce:21'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e8:fb',
                'name': 'elaine_thomas'
            },
            'd0:21:f9:1a:cd:38': {
                'dev_macs': ['48:22:54:38:a2:79'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:1a:cd:38',
                'name': 'lisa_olson'
            },
            'f4:92:bf:06:0a:54': {
                'dev_macs': ['74:ac:b9:83:c0:13'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:54',
                'name': 'frank_backlin'
            },
            'f4:92:bf:06:0a:56': {
                'dev_macs': ['54:af:97:4f:7e:74'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:56',
                'name': 'larry_bergeron'
            },
            'f4:92:bf:06:0a:5c': {
                'dev_macs': ['54:af:97:4f:aa:24'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:5c',
                'name': 'adam_lein'
            },
            'f4:92:bf:06:0a:5f': {
                'dev_macs': ['00:31:92:f6:78:6c'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:5f',
                'name': 'joshua_corrigan'
            },
            'f4:92:bf:06:0a:a3': {
                'dev_macs': ['24:5a:4c:d5:05:3d'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:a3',
                'name': 'rick_anderson'
            },
            'f4:92:bf:06:0a:a4': {
                'dev_macs': ['24:5a:4c:d5:04:e5'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:a4',
                'name': 'nancy_chenal'
            },
            'f4:92:bf:06:0a:a5': {
                'dev_macs': ['24:5a:4c:d5:04:70'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:a5',
                'name': 'mike_knauber'
            },
            'f4:92:bf:06:0a:a6': {
                'dev_macs': ['f4:92:bf:4b:d1:c9'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:a6',
                'name': 'barb_burke'
            },
            'f4:92:bf:06:0a:ab': {
                'dev_macs': ['10:da:43:7a:d3:56'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:ab',
                'name': 'shari_chadwick'
            },
            'f4:92:bf:06:0a:c0': {
                'dev_macs': [
                    '18:e8:29:8c:44:67', 'b4:fb:e4:4f:2f:fe', 'b4:fb:e4:4f:31:2c',
                    'b4:fb:e4:6a:7c:2f', 'e0:63:da:4e:c1:4d', 'e0:63:da:4f:c1:4d',
                    'f4:92:bf:d2:89:aa'
                ],
                'ip_address':
                None,
                'mac_address':
                'f4:92:bf:06:0a:c0',
                'name':
                'SNDW01-ONU'
            },
            'f4:92:bf:06:0a:c3': {
                'dev_macs': ['54:af:97:4f:c8:88'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:c3',
                'name': 'michelle_bengtson'
            },
            'f4:92:bf:06:0b:a4': {
                'dev_macs': ['54:af:97:4f:8c:d4'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:a4',
                'name': 'ryan_tschumperlin'
            },
            'f4:92:bf:06:0b:ce': {
                'dev_macs': ['54:af:97:4f:8c:3c'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:ce',
                'name': 'neal_chapman'
            },
            'f4:92:bf:06:0b:d2': {
                'dev_macs': ['d8:47:32:da:c7:51'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:d2',
                'name': 'bart_chouinard'
            },
            'f4:92:bf:06:0b:d9': {
                'dev_macs': ['54:af:97:4f:e3:f0'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:d9',
                'name': 'jennifer_campbell'
            },
            'f4:92:bf:06:0b:e3': {
                'dev_macs': ['24:5a:4c:e7:3b:9f'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:e3',
                'name': 'teresa_blok'
            },
            'f4:92:bf:06:0b:e4': {
                'dev_macs': ['24:5a:4c:e3:af:af'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:e4',
                'name': 'wayne_gustafson'
            },
            'f4:92:bf:06:0b:f3': {
                'dev_macs': ['54:af:97:4f:7e:0c'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:f3',
                'name': 'jeffrey_schefelker'
            },
            'f4:92:bf:06:0b:f5': {
                'dev_macs': ['54:af:97:4f:8c:34'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:f5',
                'name': 'kathy_griffin'
            },
            'f4:92:bf:06:0c:03': {
                'dev_macs': ['54:af:97:4f:8b:d0'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:03',
                'name': 'lesa_beeler'
            },
            'f4:92:bf:06:0c:32': {
                'dev_macs': ['24:5a:4c:d5:01:ee'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:32',
                'name': 'ed_peterson'
            },
            'f4:92:bf:06:0c:39': {
                'dev_macs': ['54:af:97:4f:ac:18'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:39',
                'name': 'jason_craig'
            },
            'f4:92:bf:06:0c:5b': {
                'dev_macs': ['54:af:97:4f:a6:d4'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:5b',
                'name': 'troy_lee'
            },
            'f4:92:bf:06:0c:8b': {
                'dev_macs': ['24:5a:4c:e3:b0:25'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:8b',
                'name': 'rob_anderson'
            },
            'f4:92:bf:06:0c:8f': {
                'dev_macs': ['24:f5:a2:90:24:c6'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:8f',
                'name': 'jessica_pett'
            },
            'f4:92:bf:06:0c:b8': {
                'dev_macs': ['38:94:ed:aa:2f:a2'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:b8',
                'name': 'ben_rathbun'
            },
            'f4:92:bf:06:0c:c4': {
                'dev_macs': ['18:e8:29:37:a4:fb'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:c4',
                'name': 'darvaia_stinar'
            },
            'f4:92:bf:06:0c:c8': {
                'dev_macs': ['24:5a:4c:e3:b1:90'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:c8',
                'name': 'mike_freeberg'
            },
            'f4:92:bf:06:0d:89': {
                'dev_macs': ['24:5a:4c:e7:3c:68'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0d:89',
                'name': 'edward_feidt'
            },
            'f4:92:bf:06:0d:c4': {
                'dev_macs': ['14:91:82:12:6c:5d'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0d:c4',
                'name': 'eric_carlson'
            },
            'f4:92:bf:06:0d:d8': {
                'dev_macs': ['74:83:c2:eb:89:b3'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0d:d8',
                'name': 'jackie_schommer'
            },
            'f4:92:bf:06:e0:be': {
                'dev_macs': ['54:af:97:4f:c7:dc'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e0:be',
                'name': 'judith_shafer'
            },
            'f4:92:bf:06:e4:04': {
                'dev_macs': ['54:af:97:50:09:3c'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e4:04',
                'name': 'jean_porter'
            },
            'f4:92:bf:06:e4:2f': {
                'dev_macs': ['54:af:97:50:06:b0'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e4:2f',
                'name': 'sarah_radomsky'
            },
            'f4:92:bf:06:e4:56': {
                'dev_macs': ['54:af:97:4f:df:94'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e4:56',
                'name': 'marshall_davis'
            },
            'f4:92:bf:06:e5:2d': {
                'dev_macs': ['54:af:97:4f:c7:e8'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e5:2d',
                'name': 'steven_stoner'
            },
            'f4:92:bf:06:e5:99': {
                'dev_macs': ['10:da:43:a9:55:e3'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e5:99',
                'name': 'bruce_lundquist'
            },
            'f4:92:bf:06:e5:f8': {
                'dev_macs': ['ac:15:a2:b2:0f:24'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e5:f8',
                'name': 'luis_karl'
            },
            'f4:92:bf:06:e6:3a': {
                'dev_macs': ['54:af:97:4f:c8:84'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e6:3a',
                'name': 'louann_skillings'
            },
            'f4:92:bf:06:e7:25': {
                'dev_macs': ['10:0c:6b:e1:63:48'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:25',
                'name': 'cory_wondra'
            },
            'f4:92:bf:06:e7:3e': {
                'dev_macs': ['54:af:97:4f:e0:30'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:3e',
                'name': 'kim_rognrud'
            },
            'f4:92:bf:06:e7:49': {
                'dev_macs': ['54:af:97:50:0f:54'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:49',
                'name': 'denise_nelson'
            },
            'f4:92:bf:06:e7:55': {
                'dev_macs': ['54:af:97:50:01:dc'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:55',
                'name': 'jim_renno'
            },
            'f4:92:bf:06:e7:5c': {
                'dev_macs': ['54:af:97:4f:d7:78'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:5c',
                'name': 'mark_schumacher'
            },
            'f4:92:bf:06:f0:dc': {
                'dev_macs': ['48:22:54:38:a3:69'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f0:dc',
                'name': 'lisa_lundeenbrooks'
            },
            'f4:92:bf:06:f2:98': {
                'dev_macs': ['74:ac:b9:fd:b8:50'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f2:98',
                'name': 'adam_hedlund'
            },
            'f4:92:bf:06:f3:19': {
                'dev_macs': ['9c:53:22:89:56:b2'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f3:19',
                'name': 'tina_douglas'
            },
            'f4:92:bf:06:f4:d9': {
                'dev_macs': ['48:22:54:38:a3:39'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f4:d9',
                'name': 'suzanne_starcevich'
            },
            'f4:92:bf:06:f5:0f': {
                'dev_macs': ['54:af:97:4f:f5:c4'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f5:0f',
                'name': 'diane_mork'
            },
            'f4:92:bf:06:f5:1a': {
                'dev_macs': ['9c:53:22:89:4d:70'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f5:1a',
                'name': 'chad_thomas'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                50.0,
                'interfaces': [{
                    'admin_up': True,
                    'id': 'eth0',
                    'in_discards': '13615765',
                    'in_errors': '2714',
                    'in_nucast_pkts': '0',
                    'in_octets': '187627648941',
                    'in_ucast_pkts': '1103479743',
                    'in_unknown_protos': '0',
                    'name': 'MGMT',
                    'oper_up': True,
                    'out_discards': '0',
                    'out_errors': '1',
                    'out_nucast_pkts': '0',
                    'out_octets': '423959147837',
                    'out_ucast_pkts': '823772131',
                    'poller_hash': 'YjRmYmU0NTAzYjhhZXRoMGludGY='
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon1',
                    'in_errors':
                    '0',
                    'in_octets':
                    '4189052261426',
                    'in_ucast_pkts':
                    '19803009057',
                    'links': [{
                        'bridged_mac_addresses': ['84:d8:1b:7a:da:60'],
                        'in_octets': '222461380262',
                        'out_octets': '3849134107222',
                        'poller_hash': 'NzBhNzQxMzJmNDhjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:83:c0:13'],
                        'in_octets': '111764754227',
                        'out_octets': '3319896763602',
                        'poller_hash': 'ZjQ5MmJmMDYwYTU0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:aa:24'],
                        'in_octets': '11928576097',
                        'out_octets': '175714892507',
                        'poller_hash': 'ZjQ5MmJmMDYwYTVjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:c8:88'],
                        'in_octets': '8965376115',
                        'out_octets': '243062662871',
                        'poller_hash': 'ZjQ5MmJmMDYwYWMzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:8c:d4'],
                        'in_octets': '6098156361',
                        'out_octets': '106792795550',
                        'poller_hash': 'ZjQ5MmJmMDYwYmE0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:e3:f0'],
                        'in_octets': '7093446055',
                        'out_octets': '118738709706',
                        'poller_hash': 'ZjQ5MmJmMDYwYmQ5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['18:e8:29:37:a4:fb'],
                        'in_octets': '15625512575',
                        'out_octets': '299112485055',
                        'poller_hash': 'ZjQ5MmJmMDYwY2M0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['14:91:82:12:6c:5d'],
                        'in_octets': '3088512466',
                        'out_octets': '32803386862',
                        'poller_hash': 'ZjQ5MmJmMDYwZGM0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:83:c2:eb:89:b3'],
                        'in_octets': '27896807920',
                        'out_octets': '208297711695',
                        'poller_hash': 'ZjQ5MmJmMDYwZGQ4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon1',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '63741905074100',
                    'out_ucast_pkts':
                    '56333961347',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uMWludGY=',
                    'pons': [{
                        'id':
                        '1',
                        'links': [{
                            'connected_time': '4733215',
                            'fiber_length': 10823,
                            'poller_hash': 'NzBhNzQxMzJmNDhjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10687697',
                            'fiber_length': 9570,
                            'poller_hash': 'ZjQ5MmJmMDYwYTU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5255521',
                            'fiber_length': 9382,
                            'poller_hash': 'ZjQ5MmJmMDYwYTVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 13287,
                            'poller_hash': 'ZjQ5MmJmMDYwYWMzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 10549,
                            'poller_hash': 'ZjQ5MmJmMDYwYmE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1085902',
                            'fiber_length': 10126,
                            'poller_hash': 'ZjQ5MmJmMDYwYmQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2589910',
                            'fiber_length': 10653,
                            'poller_hash': 'ZjQ5MmJmMDYwY2M0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '231971',
                            'fiber_length': 9799,
                            'poller_hash': 'ZjQ5MmJmMDYwZGM0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 12573,
                            'poller_hash': 'ZjQ5MmJmMDYwZGQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon2',
                    'in_errors':
                    '0',
                    'in_octets':
                    '4065137599156',
                    'in_ucast_pkts':
                    '17205107754',
                    'links': [{
                        'bridged_mac_addresses': ['74:ac:b9:83:c0:00'],
                        'in_octets': '21808323770',
                        'out_octets': '1068117378952',
                        'poller_hash': 'NzBhNzQxMzMyY2QwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['5c:62:8b:ab:6f:45'],
                        'in_octets': '3965917114',
                        'out_octets': '46449359742',
                        'poller_hash': 'Nzg0NTU4OTVjM2FjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:75:d1:6c'],
                        'in_octets': '11458675648',
                        'out_octets': '362985476692',
                        'poller_hash': 'NjhkNzlhMDZmZjMxcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:7e:74'],
                        'in_octets': '3228637671',
                        'out_octets': '49350620497',
                        'poller_hash': 'ZjQ5MmJmMDYwYTU2cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['f4:92:bf:4b:d1:c9'],
                        'in_octets': '15428891751',
                        'out_octets': '24727742883',
                        'poller_hash': 'ZjQ5MmJmMDYwYWE2cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:8c:3c'],
                        'in_octets': '384893936',
                        'out_octets': '296509311',
                        'poller_hash': 'ZjQ5MmJmMDYwYmNlcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:8c:34'],
                        'in_octets': '37869131747',
                        'out_octets': '847913610460',
                        'poller_hash': 'ZjQ5MmJmMDYwYmY1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:5a:4c:d5:01:ee'],
                        'in_octets': '46691526639',
                        'out_octets': '514400993381',
                        'poller_hash': 'ZjQ5MmJmMDYwYzMycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:a6:d4'],
                        'in_octets': '569467655952',
                        'out_octets': '396073241457',
                        'poller_hash': 'ZjQ5MmJmMDYwYzVicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:5a:4c:e7:3c:68'],
                        'in_octets': '2588687025',
                        'out_octets': '42718453903',
                        'poller_hash': 'ZjQ5MmJmMDYwZDg5cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '62144129580810',
                    'out_ucast_pkts':
                    '53406723784',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uMmludGY=',
                    'pons': [{
                        'id':
                        '2',
                        'links': [{
                            'connected_time': '1101972',
                            'fiber_length': 356,
                            'poller_hash': 'NzBhNzQxMzMyY2QwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '767428',
                            'fiber_length': 1238,
                            'poller_hash': 'Nzg0NTU4OTVjM2FjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '415944',
                            'fiber_length': 1535,
                            'poller_hash': 'NjhkNzlhMDZmZjMxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '929970',
                            'fiber_length': 7149,
                            'poller_hash': 'ZjQ5MmJmMDYwYTU2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 1203,
                            'poller_hash': 'ZjQ5MmJmMDYwYWE2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3545451',
                            'fiber_length': 993,
                            'poller_hash': 'ZjQ5MmJmMDYwYmNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9388152',
                            'fiber_length': 4086,
                            'poller_hash': 'ZjQ5MmJmMDYwYmY1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7081734',
                            'fiber_length': 6556,
                            'poller_hash': 'ZjQ5MmJmMDYwYzMycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10687697',
                            'fiber_length': 6956,
                            'poller_hash': 'ZjQ5MmJmMDYwYzVicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '580746',
                            'fiber_length': 1087,
                            'poller_hash': 'ZjQ5MmJmMDYwZDg5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon3',
                    'in_errors':
                    '0',
                    'in_octets':
                    '4984518037469',
                    'in_ucast_pkts':
                    '22284664859',
                    'links': [{
                        'bridged_mac_addresses': ['48:22:54:57:18:bb'],
                        'in_octets': '1870565314',
                        'out_octets': '81002587634',
                        'poller_hash': 'NzBhNzQxMzJmNTEwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['48:22:54:38:a2:82'],
                        'in_octets': '9952355709',
                        'out_octets': '488053817808',
                        'poller_hash': 'NzBhNzQxMzMyYmZjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['48:22:54:57:20:e9'],
                        'in_octets': '49917708030',
                        'out_octets': '480299524792',
                        'poller_hash': 'NzBhNzQxMzMyY2I4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['48:22:54:57:33:c7'],
                        'in_octets': '93966740222',
                        'out_octets': '615106324750',
                        'poller_hash': 'Nzg0NTU4OTVjMzZjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['a0:36:bc:1a:6b:68'],
                        'in_octets': '21693880245',
                        'out_octets': '1062438998472',
                        'poller_hash': 'Nzg0NTU4OTVjM2IwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:8d:ce:d8'],
                        'in_octets': '2868103384',
                        'out_octets': '62357381027',
                        'poller_hash': 'NjhkNzlhMDY1M2JmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['68:d7:9a:af:f1:39'],
                        'in_octets': '656121422531',
                        'out_octets': '10615202891754',
                        'poller_hash': 'NzRhY2I5MDZhN2NhcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': [
                            '18:e8:29:8c:44:67', 'b4:fb:e4:4f:2f:fe',
                            'b4:fb:e4:4f:31:2c', 'b4:fb:e4:6a:7c:2f',
                            'e0:63:da:4e:c1:4d', 'e0:63:da:4f:c1:4d',
                            'f4:92:bf:d2:89:aa'
                        ],
                        'in_octets':
                        '286889795472',
                        'out_octets':
                        '1008130759425',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWMwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:f5:a2:90:24:c6'],
                        'in_octets': '93942891299',
                        'out_octets': '855601086055',
                        'poller_hash': 'ZjQ5MmJmMDYwYzhmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:50:09:3c'],
                        'in_octets': '17888404761',
                        'out_octets': '352025510070',
                        'poller_hash': 'ZjQ5MmJmMDZlNDA0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:df:94'],
                        'in_octets': '2516227918',
                        'out_octets': '37351004210',
                        'poller_hash': 'ZjQ5MmJmMDZlNDU2cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:c7:e8'],
                        'in_octets': '41199525945',
                        'out_octets': '673463910431',
                        'poller_hash': 'ZjQ5MmJmMDZlNTJkcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['ac:15:a2:b2:0f:24'],
                        'in_octets': '48254841861',
                        'out_octets': '2510522673470',
                        'poller_hash': 'ZjQ5MmJmMDZlNWY4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:d7:78'],
                        'in_octets': '14773019171',
                        'out_octets': '333970562947',
                        'poller_hash': 'ZjQ5MmJmMDZlNzVjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['9c:53:22:89:56:b2'],
                        'in_octets': '32197629888',
                        'out_octets': '1031592999146',
                        'poller_hash': 'ZjQ5MmJmMDZmMzE5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['9c:53:22:89:4d:70'],
                        'in_octets': '7450548046',
                        'out_octets': '130979488301',
                        'poller_hash': 'ZjQ5MmJmMDZmNTFhcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['68:d7:9a:af:f8:70'],
                        'in_octets': '48724513380',
                        'out_octets': '226908179626',
                        'poller_hash': 'YjRmYmU0ZTZkNzM3cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon3',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '82451686830701',
                    'out_ucast_pkts':
                    '68685949384',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uM2ludGY=',
                    'pons': [{
                        'id':
                        '3',
                        'links': [{
                            'connected_time': '144430',
                            'fiber_length': 401,
                            'poller_hash': 'NzBhNzQxMzJmNTEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 3998,
                            'poller_hash': 'NzBhNzQxMzMyYmZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 1655,
                            'poller_hash': 'NzBhNzQxMzMyY2I4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4147878',
                            'fiber_length': 2635,
                            'poller_hash': 'Nzg0NTU4OTVjMzZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2502009',
                            'fiber_length': 4162,
                            'poller_hash': 'Nzg0NTU4OTVjM2IwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '131380',
                            'fiber_length': 2476,
                            'poller_hash': 'NjhkNzlhMDY1M2JmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '17542490',
                            'fiber_length': 651,
                            'poller_hash': 'NzRhY2I5MDZhN2NhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '32820169',
                            'fiber_length': 2404,
                            'poller_hash': 'ZjQ5MmJmMDYwYWMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 507,
                            'poller_hash': 'ZjQ5MmJmMDYwYzhmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 4029,
                            'poller_hash': 'ZjQ5MmJmMDZlNDA0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '314732',
                            'fiber_length': 2991,
                            'poller_hash': 'ZjQ5MmJmMDZlNDU2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 4064,
                            'poller_hash': 'ZjQ5MmJmMDZlNTJkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 3833,
                            'poller_hash': 'ZjQ5MmJmMDZlNWY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2718991',
                            'fiber_length': 800,
                            'poller_hash': 'ZjQ5MmJmMDZlNzVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2735041',
                            'fiber_length': 644,
                            'poller_hash': 'ZjQ5MmJmMDZmMzE5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 3353,
                            'poller_hash': 'ZjQ5MmJmMDZmNTFhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3915985',
                            'fiber_length': 2450,
                            'poller_hash': 'YjRmYmU0ZTZkNzM3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon4',
                    'in_errors':
                    '0',
                    'in_octets':
                    '10808593119543',
                    'in_ucast_pkts':
                    '39501190629',
                    'links': [{
                        'bridged_mac_addresses': ['48:22:54:38:a7:ce'],
                        'in_octets': '8080434118',
                        'out_octets': '311147212731',
                        'poller_hash': 'NzBhNzQxMzJmNTdjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['48:22:54:57:23:6e'],
                        'in_octets': '38561419547',
                        'out_octets': '1206856652724',
                        'poller_hash': 'NzBhNzQxMzJmNjU0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['5c:62:8b:ab:68:c4'],
                        'in_octets': '10113597175',
                        'out_octets': '631194097615',
                        'poller_hash': 'Nzg0NTU4OTVjMGY0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['5c:62:8b:ab:66:39'],
                        'in_octets': '6939365487',
                        'out_octets': '34503963233',
                        'poller_hash': 'Nzg0NTU4OTVkNDkwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:5a:4c:d5:05:3d'],
                        'in_octets': '48191616857',
                        'out_octets': '748100643863',
                        'poller_hash': 'ZjQ5MmJmMDYwYWEzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:5a:4c:d5:04:e5'],
                        'in_octets': '231734211008',
                        'out_octets': '1290564132006',
                        'poller_hash': 'ZjQ5MmJmMDYwYWE0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:5a:4c:d5:04:70'],
                        'in_octets': '234235459162',
                        'out_octets': '3081515418301',
                        'poller_hash': 'ZjQ5MmJmMDYwYWE1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['10:da:43:7a:d3:56'],
                        'in_octets': '70436261425',
                        'out_octets': '1990196695797',
                        'poller_hash': 'ZjQ5MmJmMDYwYWFicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['d8:47:32:da:c7:51'],
                        'in_octets': '2405435622',
                        'out_octets': '68138729320',
                        'poller_hash': 'ZjQ5MmJmMDYwYmQycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:5a:4c:e7:3b:9f'],
                        'in_octets': '9846408154',
                        'out_octets': '64674445492',
                        'poller_hash': 'ZjQ5MmJmMDYwYmUzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:5a:4c:e3:af:af'],
                        'in_octets': '10184826899',
                        'out_octets': '291225455440',
                        'poller_hash': 'ZjQ5MmJmMDYwYmU0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:7e:0c'],
                        'in_octets': '18712593205',
                        'out_octets': '254366955439',
                        'poller_hash': 'ZjQ5MmJmMDYwYmYzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:8b:d0'],
                        'in_octets': '8094178403',
                        'out_octets': '66615357827',
                        'poller_hash': 'ZjQ5MmJmMDYwYzAzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:ac:18'],
                        'in_octets': '46607020203',
                        'out_octets': '305207258415',
                        'poller_hash': 'ZjQ5MmJmMDYwYzM5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:5a:4c:e3:b0:25'],
                        'in_octets': '41585133775',
                        'out_octets': '767047358429',
                        'poller_hash': 'ZjQ5MmJmMDYwYzhicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['38:94:ed:aa:2f:a2'],
                        'in_octets': '29895627635',
                        'out_octets': '319637726358',
                        'poller_hash': 'ZjQ5MmJmMDYwY2I4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:5a:4c:e3:b1:90'],
                        'in_octets': '181560676436',
                        'out_octets': '454658110267',
                        'poller_hash': 'ZjQ5MmJmMDYwY2M4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:e0:30'],
                        'in_octets': '24061190613',
                        'out_octets': '875916588153',
                        'poller_hash': 'ZjQ5MmJmMDZlNzNlcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:50:01:dc'],
                        'in_octets': '2685243941',
                        'out_octets': '72158810188',
                        'poller_hash': 'ZjQ5MmJmMDZlNzU1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['48:22:54:38:a3:69'],
                        'in_octets': '11569552211',
                        'out_octets': '342658834887',
                        'poller_hash': 'ZjQ5MmJmMDZmMGRjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:fd:b8:54'],
                        'in_octets': '143891962160',
                        'out_octets': '2153845937130',
                        'poller_hash': 'YjRmYmU0ZTZlNzNkcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon4',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '115080032451807',
                    'out_ucast_pkts':
                    '96309904252',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uNGludGY=',
                    'pons': [{
                        'id':
                        '4',
                        'links': [{
                            'connected_time': '1703649',
                            'fiber_length': 18518,
                            'poller_hash': 'NzBhNzQxMzJmNTdjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4400731',
                            'fiber_length': 355,
                            'poller_hash': 'NzBhNzQxMzJmNjU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 526,
                            'poller_hash': 'Nzg0NTU4OTVjMGY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '139980',
                            'fiber_length': 419,
                            'poller_hash': 'Nzg0NTU4OTVkNDkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6011281',
                            'fiber_length': 10989,
                            'poller_hash': 'ZjQ5MmJmMDYwYWEzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394672',
                            'fiber_length': 11011,
                            'poller_hash': 'ZjQ5MmJmMDYwYWE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10687697',
                            'fiber_length': 15323,
                            'poller_hash': 'ZjQ5MmJmMDYwYWE1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9395072',
                            'fiber_length': 15294,
                            'poller_hash': 'ZjQ5MmJmMDYwYWFicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 17606,
                            'poller_hash': 'ZjQ5MmJmMDYwYmQycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 15476,
                            'poller_hash': 'ZjQ5MmJmMDYwYmUzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703649',
                            'fiber_length': 18141,
                            'poller_hash': 'ZjQ5MmJmMDYwYmU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394671',
                            'fiber_length': 11429,
                            'poller_hash': 'ZjQ5MmJmMDYwYmYzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394662',
                            'fiber_length': 11416,
                            'poller_hash': 'ZjQ5MmJmMDYwYzAzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394671',
                            'fiber_length': 11441,
                            'poller_hash': 'ZjQ5MmJmMDYwYzM5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3017725',
                            'fiber_length': 11115,
                            'poller_hash': 'ZjQ5MmJmMDYwYzhicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 15707,
                            'poller_hash': 'ZjQ5MmJmMDYwY2I4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394671',
                            'fiber_length': 11268,
                            'poller_hash': 'ZjQ5MmJmMDYwY2M4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4034357',
                            'fiber_length': 823,
                            'poller_hash': 'ZjQ5MmJmMDZlNzNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 18691,
                            'poller_hash': 'ZjQ5MmJmMDZlNzU1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 17588,
                            'poller_hash': 'ZjQ5MmJmMDZmMGRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 370,
                            'poller_hash': 'YjRmYmU0ZTZlNzNkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon5',
                    'in_errors':
                    '0',
                    'in_octets':
                    '9158326990757',
                    'in_ucast_pkts':
                    '28492029152',
                    'links': [{
                        'bridged_mac_addresses': ['40:ed:00:42:96:7d'],
                        'in_octets': '61538569267',
                        'out_octets': '2083065968776',
                        'poller_hash': 'NjhkNzlhMDY1MzYxcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:31:92:f6:78:6c'],
                        'in_octets': '15174113650',
                        'out_octets': '138426127587',
                        'poller_hash': 'ZjQ5MmJmMDYwYTVmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:4b:fe:62:40:58'],
                        'in_octets': '30791492050',
                        'out_octets': '344350385160',
                        'poller_hash': 'YjRmYmU0ZTZkNzMzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:f3:48'],
                        'in_octets': '29988333305',
                        'out_octets': '1230012998216',
                        'poller_hash': 'YjRmYmU0ZTZlNzJlcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:fd:b8:e4'],
                        'in_octets': '407301660',
                        'out_octets': '8148840961',
                        'poller_hash': 'YjRmYmU0ZTZlN2M0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:75:d0:a6'],
                        'in_octets': '54186737319',
                        'out_octets': '1595930280165',
                        'poller_hash': 'YjRmYmU0ZTZlODE2cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:75:d3:99'],
                        'in_octets': '511199320123',
                        'out_octets': '1138527495450',
                        'poller_hash': 'YjRmYmU0ZTZlODVmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:fd:b2:16'],
                        'in_octets': '33940226416',
                        'out_octets': '137006998777',
                        'poller_hash': 'YjRmYmU0ZTZlODlicGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon5',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '77087474445243',
                    'out_ucast_pkts':
                    '71231951349',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uNWludGY=',
                    'pons': [{
                        'id':
                        '5',
                        'links': [{
                            'connected_time': '4044297',
                            'fiber_length': 3458,
                            'poller_hash': 'NjhkNzlhMDY1MzYxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4044287',
                            'fiber_length': 3045,
                            'poller_hash': 'ZjQ5MmJmMDYwYTVmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '799058',
                            'fiber_length': 1218,
                            'poller_hash': 'YjRmYmU0ZTZkNzMzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4044277',
                            'fiber_length': 3466,
                            'poller_hash': 'YjRmYmU0ZTZlNzJlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '58129',
                            'fiber_length': 2933,
                            'poller_hash': 'YjRmYmU0ZTZlN2M0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 611,
                            'poller_hash': 'YjRmYmU0ZTZlODE2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4044287',
                            'fiber_length': 4320,
                            'poller_hash': 'YjRmYmU0ZTZlODVmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2393197',
                            'fiber_length': 2896,
                            'poller_hash': 'YjRmYmU0ZTZlODlicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon6',
                    'in_errors':
                    '0',
                    'in_octets':
                    '6585668951255',
                    'in_ucast_pkts':
                    '21368420958',
                    'links': [{
                        'bridged_mac_addresses': ['5c:62:8b:ab:6a:bc'],
                        'in_octets': '12889658994',
                        'out_octets': '474807784979',
                        'poller_hash': 'NzBhNzQxMzJmNDRjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['48:22:54:45:b9:48'],
                        'in_octets': '53481170163',
                        'out_octets': '1817054145489',
                        'poller_hash': 'NzBhNzQxMzJmNWQ4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['5c:62:8b:ab:73:80'],
                        'in_octets': '26739296554',
                        'out_octets': '596894349104',
                        'poller_hash': 'Nzg0NTU4OTVkMzgwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:c7:dc'],
                        'in_octets': '20106793170',
                        'out_octets': '799506207056',
                        'poller_hash': 'ZjQ5MmJmMDZlMGJlcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:50:06:b0'],
                        'in_octets': '100218969278',
                        'out_octets': '1649284105874',
                        'poller_hash': 'ZjQ5MmJmMDZlNDJmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:c8:84'],
                        'in_octets': '49206395961',
                        'out_octets': '1217535082077',
                        'poller_hash': 'ZjQ5MmJmMDZlNjNhcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['10:0c:6b:e1:63:48'],
                        'in_octets': '45484282143',
                        'out_octets': '865593485595',
                        'poller_hash': 'ZjQ5MmJmMDZlNzI1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:50:0f:54'],
                        'in_octets': '22052831664',
                        'out_octets': '148587210657',
                        'poller_hash': 'ZjQ5MmJmMDZlNzQ5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['48:22:54:38:a3:39'],
                        'in_octets': '35833393893',
                        'out_octets': '445010687552',
                        'poller_hash': 'ZjQ5MmJmMDZmNGQ5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:f5:c4'],
                        'in_octets': '6903138178',
                        'out_octets': '72174486170',
                        'poller_hash': 'ZjQ5MmJmMDZmNTBmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['ac:15:a2:b2:16:08'],
                        'in_octets': '26297243907',
                        'out_octets': '308568394681',
                        'poller_hash': 'YjRmYmU0ZTZkNzI4cGVlcmludGY='
                    }, {
                        'in_octets': '0',
                        'out_octets': '0',
                        'poller_hash': 'YjRmYmU0ZTZkZmY1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['b0:95:75:3d:59:a1'],
                        'in_octets': '38940730145',
                        'out_octets': '297984857264',
                        'poller_hash': 'YjRmYmU0ZTZlMjg2cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:83:bc:b0'],
                        'in_octets': '37345066606',
                        'out_octets': '192032241569',
                        'poller_hash': 'YjRmYmU0ZTZlNzI4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:75:ce:21'],
                        'in_octets': '5543285944',
                        'out_octets': '30194536974',
                        'poller_hash': 'YjRmYmU0ZTZlOGZicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['48:22:54:38:a2:79'],
                        'in_octets': '24900785839',
                        'out_octets': '432410612283',
                        'poller_hash': 'ZDAyMWY5MWFjZDM4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon6',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '80304823153103',
                    'out_ucast_pkts':
                    '68671226933',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uNmludGY=',
                    'pons': [{
                        'id':
                        '6',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 5613,
                            'poller_hash': 'NzBhNzQxMzJmNDRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 3246,
                            'poller_hash': 'NzBhNzQxMzJmNWQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 6528,
                            'poller_hash': 'Nzg0NTU4OTVkMzgwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1282814',
                            'fiber_length': 6060,
                            'poller_hash': 'ZjQ5MmJmMDZlMGJlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 7061,
                            'poller_hash': 'ZjQ5MmJmMDZlNDJmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4044287',
                            'fiber_length': 5635,
                            'poller_hash': 'ZjQ5MmJmMDZlNjNhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 5341,
                            'poller_hash': 'ZjQ5MmJmMDZlNzI1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 5702,
                            'poller_hash': 'ZjQ5MmJmMDZlNzQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1362655',
                            'fiber_length': 4638,
                            'poller_hash': 'ZjQ5MmJmMDZmNGQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 4751,
                            'poller_hash': 'ZjQ5MmJmMDZmNTBmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '799058',
                            'fiber_length': 3746,
                            'poller_hash': 'YjRmYmU0ZTZkNzI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '799058',
                            'fiber_length': 3727,
                            'poller_hash': 'YjRmYmU0ZTZkZmY1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1786550',
                            'fiber_length': 3120,
                            'poller_hash': 'YjRmYmU0ZTZlMjg2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '799058',
                            'fiber_length': 3735,
                            'poller_hash': 'YjRmYmU0ZTZlNzI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '746687',
                            'fiber_length': 2933,
                            'poller_hash': 'YjRmYmU0ZTZlOGZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2237305',
                            'fiber_length': 5324,
                            'poller_hash': 'ZDAyMWY5MWFjZDM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon7',
                    'in_errors':
                    '0',
                    'in_octets':
                    '178308',
                    'in_ucast_pkts':
                    '882',
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon7',
                    'oper_up':
                    False,
                    'out_errors':
                    '0',
                    'out_octets':
                    '699846243443',
                    'out_ucast_pkts':
                    '9095864406',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uN2ludGY=',
                    'pons': [{
                        'id': '7',
                        'max_distance': 20000,
                        'maximum_loss': -12.0,
                        'minimum_loss': -30.0,
                        'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis3',
                        'pon_technology': 'GPON',
                        'rx_link_rate': '1244160000',
                        'split_ratio': 128,
                        'tx_link_rate': '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon8',
                    'in_errors':
                    '0',
                    'in_octets':
                    '106250154232',
                    'in_ucast_pkts':
                    '626086928',
                    'links': [{
                        'bridged_mac_addresses': ['40:ed:00:42:8f:ea'],
                        'in_octets': '18909417133',
                        'out_octets': '84043068539',
                        'poller_hash': 'Nzg0NTU4OTVjMzA4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['5c:62:8b:ab:6b:19'],
                        'in_octets': '2483381931',
                        'out_octets': '19877537988',
                        'poller_hash': 'Nzg0NTU4OTVkNDc4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['98:da:c4:8e:86:ab'],
                        'in_octets': '17123883502',
                        'out_octets': '384995526756',
                        'poller_hash': 'NjhkNzlhMDZmZTkzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['10:da:43:a9:55:e3'],
                        'in_octets': '25176369735',
                        'out_octets': '891036245817',
                        'poller_hash': 'ZjQ5MmJmMDZlNTk5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:fd:b8:50'],
                        'in_octets': '32624369913',
                        'out_octets': '394319264326',
                        'poller_hash': 'ZjQ5MmJmMDZmMjk4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon8',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '2644835208953',
                    'out_ucast_pkts':
                    '10542868966',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uOGludGY=',
                    'pons': [{
                        'id':
                        '8',
                        'links': [{
                            'connected_time': '3532081',
                            'fiber_length': 9329,
                            'poller_hash': 'Nzg0NTU4OTVjMzA4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1116712',
                            'fiber_length': 7992,
                            'poller_hash': 'Nzg0NTU4OTVkNDc4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2476078',
                            'fiber_length': 7849,
                            'poller_hash': 'NjhkNzlhMDZmZTkzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3532080',
                            'fiber_length': 19937,
                            'poller_hash': 'ZjQ5MmJmMDZlNTk5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3532080',
                            'fiber_length': 8195,
                            'poller_hash': 'ZjQ5MmJmMDZmMjk4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp1',
                    'in_octets': '336846084827683',
                    'in_ucast_pkts': '256867207664',
                    'manufacturer': 'MikroTik',
                    'model': 'XS+DA0001',
                    'name': 'SFP+ 1',
                    'oper_up': True,
                    'out_octets': '25647616061166',
                    'out_ucast_pkts': '92707513904',
                    'poller_hash': 'YjRmYmU0NTAzYjhhc2ZwMWludGY=',
                    'speed': '10000000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp2',
                    'in_octets': '98379232116061',
                    'in_ucast_pkts': '78014425095',
                    'name': 'SFP+ 2',
                    'oper_up': False,
                    'out_octets': '8495235281238',
                    'out_ucast_pkts': '28598397167',
                    'poller_hash': 'YjRmYmU0NTAzYjhhc2ZwMmludGY='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                20.0,
                'model':
                'UFiber OLT',
                'serial_number':
                'UBNTe4503b8a',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:50:3b:8a',
                'temperature':
                13.75,
                'uptime':
                '43465206'
            },
            'peers': [{
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3849134107222',
                    'links': [{
                        'in_octets': '3849134107222',
                        'out_octets': '222461380262',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '222461380262',
                    'poller_hash':
                    'NzBhNzQxMzJmNDhjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4733215',
                            'fiber_length': 10823,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.684,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.794
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzJmNDhjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '222461380262',
                    'mac_address': '70:a7:41:33:f4:8c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3849134107222',
                    'poller_hash': 'NzBhNzQxMzJmNDhjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'brenda_chenal',
                'serial_number':
                'UBNT4132f48c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f4:8c',
                'temperature':
                15.0,
                'uptime':
                '4733273'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3319896763602',
                    'links': [{
                        'in_octets': '3319896763602',
                        'out_octets': '111764754227',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '111764754227',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYTU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '10687697',
                            'fiber_length': 9570,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.676
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYTU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '111764754227',
                    'mac_address': 'f4:92:bf:07:0a:54',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3319896763602',
                    'poller_hash': 'ZjQ5MmJmMDYwYTU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'frank_backlin',
                'serial_number':
                'UBNTbf060a54',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:54',
                'temperature':
                18.0,
                'uptime':
                '10687756'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '175714892507',
                    'links': [{
                        'in_octets': '175714892507',
                        'out_octets': '11928576097',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11928576097',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYTVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '5255521',
                            'fiber_length': 9382,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.084
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYTVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '11928576097',
                    'mac_address': 'f4:92:bf:07:0a:5c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '175714892507',
                    'poller_hash': 'ZjQ5MmJmMDYwYTVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'adam_lein',
                'serial_number':
                'UBNTbf060a5c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:5c',
                'temperature':
                13.0,
                'uptime':
                '5255574'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '243062662871',
                    'links': [{
                        'in_octets': '243062662871',
                        'out_octets': '8965376115',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8965376115',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWMzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 13287,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.486,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.054
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWMzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '8965376115',
                    'mac_address': 'f4:92:bf:07:0a:c3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '243062662871',
                    'poller_hash': 'ZjQ5MmJmMDYwYWMzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'michelle_bengtson',
                'serial_number':
                'UBNTbf060ac3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:c3',
                'temperature':
                8.0,
                'uptime':
                '1703732'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '106792795550',
                    'links': [{
                        'in_octets': '106792795550',
                        'out_octets': '6098156361',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6098156361',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmE0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 10549,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.674,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.354
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmE0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '6098156361',
                    'mac_address': 'f4:92:bf:07:0b:a4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '106792795550',
                    'poller_hash': 'ZjQ5MmJmMDYwYmE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'ryan_tschumperlin',
                'serial_number':
                'UBNTbf060ba4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:a4',
                'temperature':
                14.0,
                'uptime':
                '1703737'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '118738709706',
                    'links': [{
                        'in_octets': '118738709706',
                        'out_octets': '7093446055',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7093446055',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmQ5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1085902',
                            'fiber_length': 10126,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.29
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmQ5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '7093446055',
                    'mac_address': 'f4:92:bf:07:0b:d9',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '118738709706',
                    'poller_hash': 'ZjQ5MmJmMDYwYmQ5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jennifer_campbell',
                'serial_number':
                'UBNTbf060bd9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:d9',
                'temperature':
                13.0,
                'uptime':
                '1085955'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '299112485055',
                    'links': [{
                        'in_octets': '299112485055',
                        'out_octets': '15625512575',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15625512575',
                    'poller_hash':
                    'ZjQ5MmJmMDYwY2M0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2589910',
                            'fiber_length': 10653,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.364,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.958
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwY2M0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '15625512575',
                    'mac_address': 'f4:92:bf:07:0c:c4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '299112485055',
                    'poller_hash': 'ZjQ5MmJmMDYwY2M0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'darvaia_stinar',
                'serial_number':
                'UBNTbf060cc4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:c4',
                'temperature':
                15.0,
                'uptime':
                '2589970'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '32803386862',
                    'links': [{
                        'in_octets': '32803386862',
                        'out_octets': '3088512466',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3088512466',
                    'poller_hash':
                    'ZjQ5MmJmMDYwZGM0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '231971',
                            'fiber_length': 9799,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.932
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwZGM0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '3088512466',
                    'mac_address': 'f4:92:bf:07:0d:c4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '32803386862',
                    'poller_hash': 'ZjQ5MmJmMDYwZGM0ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'eric_carlson',
                'serial_number':
                'UBNTbf060dc4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0d:c4',
                'temperature':
                8.0,
                'uptime':
                '232025'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '208297711695',
                    'links': [{
                        'in_octets': '208297711695',
                        'out_octets': '27896807920',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27896807920',
                    'poller_hash':
                    'ZjQ5MmJmMDYwZGQ4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 12573,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.19,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.34
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwZGQ4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '27896807920',
                    'mac_address': 'f4:92:bf:07:0d:d8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '208297711695',
                    'poller_hash': 'ZjQ5MmJmMDYwZGQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'jackie_schommer',
                'serial_number':
                'UBNTbf060dd8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0d:d8',
                'temperature':
                13.0,
                'uptime':
                '1703735'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1068117378952',
                    'links': [{
                        'in_octets': '1068117378952',
                        'out_octets': '21808323770',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '21808323770',
                    'poller_hash':
                    'NzBhNzQxMzMyY2QwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1101972',
                            'fiber_length': 356,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.716,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.436
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzMyY2QwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '21808323770',
                    'mac_address': '70:a7:41:34:2c:d0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1068117378952',
                    'poller_hash': 'NzBhNzQxMzMyY2QwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'pauline_miller',
                'serial_number':
                'UBNT41332cd0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:33:2c:d0',
                'temperature':
                14.0,
                'uptime':
                '1102029'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '46449359742',
                    'links': [{
                        'in_octets': '46449359742',
                        'out_octets': '3965917114',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3965917114',
                    'poller_hash':
                    'Nzg0NTU4OTVjM2FjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '767428',
                            'fiber_length': 1238,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.45,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.262
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OTVjM2FjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '3965917114',
                    'mac_address': '78:45:58:96:c3:ac',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '46449359742',
                    'poller_hash': 'Nzg0NTU4OTVjM2FjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'laurie_hopp',
                'serial_number':
                'UBNT5895c3ac',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c3:ac',
                'temperature':
                11.0,
                'uptime':
                '767483'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '362985476692',
                    'links': [{
                        'in_octets': '362985476692',
                        'out_octets': '11458675648',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11458675648',
                    'poller_hash':
                    'NjhkNzlhMDZmZjMxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '415944',
                            'fiber_length': 1535,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.496,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.346
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDZmZjMxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '11458675648',
                    'mac_address': '68:d7:9a:07:ff:31',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '362985476692',
                    'poller_hash': 'NjhkNzlhMDZmZjMxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'cathy_thompson',
                'serial_number':
                'UBNT9a06ff31',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '68:d7:9a:06:ff:31',
                'temperature':
                14.0,
                'uptime':
                '416001'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '49350620497',
                    'links': [{
                        'in_octets': '49350620497',
                        'out_octets': '3228637671',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3228637671',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYTU2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '929970',
                            'fiber_length': 7149,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.988,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.382
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYTU2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '3228637671',
                    'mac_address': 'f4:92:bf:07:0a:56',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '49350620497',
                    'poller_hash': 'ZjQ5MmJmMDYwYTU2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'larry_bergeron',
                'serial_number':
                'UBNTbf060a56',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:56',
                'temperature':
                15.0,
                'uptime':
                '930026'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '24727742883',
                    'links': [{
                        'in_octets': '24727742883',
                        'out_octets': '15428891751',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15428891751',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWE2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 1203,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.214,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.154
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWE2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '15428891751',
                    'mac_address': 'f4:92:bf:07:0a:a6',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '24727742883',
                    'poller_hash': 'ZjQ5MmJmMDYwYWE2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'barb_burke',
                'serial_number':
                'UBNTbf060aa6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:a6',
                'temperature':
                17.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '296509311',
                    'links': [{
                        'in_octets': '296509311',
                        'out_octets': '384893936',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '384893936',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmNlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3545451',
                            'fiber_length': 993,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.574,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.292
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmNlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '384893936',
                    'mac_address': 'f4:92:bf:07:0b:ce',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '296509311',
                    'poller_hash': 'ZjQ5MmJmMDYwYmNlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'neal_chapman',
                'serial_number':
                'UBNTbf060bce',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:ce',
                'temperature':
                8.0,
                'uptime':
                '3545511'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '847913610460',
                    'links': [{
                        'in_octets': '847913610460',
                        'out_octets': '37869131747',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '37869131747',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmY1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9388152',
                            'fiber_length': 4086,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.782
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmY1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '37869131747',
                    'mac_address': 'f4:92:bf:07:0b:f5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '847913610460',
                    'poller_hash': 'ZjQ5MmJmMDYwYmY1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'kathy_griffin',
                'serial_number':
                'UBNTbf060bf5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:f5',
                'temperature':
                8.0,
                'uptime':
                '9388208'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '514400993381',
                    'links': [{
                        'in_octets': '514400993381',
                        'out_octets': '46691526639',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '46691526639',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzMycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7081734',
                            'fiber_length': 6556,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.27,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.42
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzMycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '46691526639',
                    'mac_address': 'f4:92:bf:07:0c:32',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '514400993381',
                    'poller_hash': 'ZjQ5MmJmMDYwYzMyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'ed_peterson',
                'serial_number':
                'UBNTbf060c32',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:32',
                'temperature':
                14.0,
                'uptime':
                '7081788'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '396073241457',
                    'links': [{
                        'in_octets': '396073241457',
                        'out_octets': '569467655952',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '569467655952',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzVicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '10687697',
                            'fiber_length': 6956,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.458,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.892
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzVicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '569467655952',
                    'mac_address': 'f4:92:bf:07:0c:5b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '396073241457',
                    'poller_hash': 'ZjQ5MmJmMDYwYzViZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'troy_lee',
                'serial_number':
                'UBNTbf060c5b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:5b',
                'temperature':
                16.0,
                'uptime':
                '10687758'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '42718453903',
                    'links': [{
                        'in_octets': '42718453903',
                        'out_octets': '2588687025',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2588687025',
                    'poller_hash':
                    'ZjQ5MmJmMDYwZDg5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '580746',
                            'fiber_length': 1087,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.288,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.05
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwZDg5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '2588687025',
                    'mac_address': 'f4:92:bf:07:0d:89',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '42718453903',
                    'poller_hash': 'ZjQ5MmJmMDYwZDg5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'edward_feidt',
                'serial_number':
                'UBNTbf060d89',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0d:89',
                'temperature':
                15.0,
                'uptime':
                '580804'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '81002587634',
                    'links': [{
                        'in_octets': '81002587634',
                        'out_octets': '1870565314',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1870565314',
                    'poller_hash':
                    'NzBhNzQxMzJmNTEwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '144430',
                            'fiber_length': 401,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.534,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.27
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzJmNTEwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '1870565314',
                    'mac_address': '70:a7:41:33:f5:10',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '81002587634',
                    'poller_hash': 'NzBhNzQxMzJmNTEwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'terra_nomeland',
                'serial_number':
                'UBNT4132f510',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f5:10',
                'temperature':
                8.0,
                'uptime':
                '144483'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '488053817808',
                    'links': [{
                        'in_octets': '488053817808',
                        'out_octets': '9952355709',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9952355709',
                    'poller_hash':
                    'NzBhNzQxMzMyYmZjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 3998,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.304,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.1
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzMyYmZjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '9952355709',
                    'mac_address': '70:a7:41:34:2b:fc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '488053817808',
                    'poller_hash': 'NzBhNzQxMzMyYmZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jo_degeer',
                'serial_number':
                'UBNT41332bfc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:33:2b:fc',
                'temperature':
                14.0,
                'uptime':
                '4752054'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '480299524792',
                    'links': [{
                        'in_octets': '480299524792',
                        'out_octets': '49917708030',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '49917708030',
                    'poller_hash':
                    'NzBhNzQxMzMyY2I4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 1655,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.974,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.054
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzMyY2I4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '49917708030',
                    'mac_address': '70:a7:41:34:2c:b8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '480299524792',
                    'poller_hash': 'NzBhNzQxMzMyY2I4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'corinne_mcnielly',
                'serial_number':
                'UBNT41332cb8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:33:2c:b8',
                'temperature':
                12.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '615106324750',
                    'links': [{
                        'in_octets': '615106324750',
                        'out_octets': '93966740222',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '93966740222',
                    'poller_hash':
                    'Nzg0NTU4OTVjMzZjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4147878',
                            'fiber_length': 2635,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.926,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.612
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OTVjMzZjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '93966740222',
                    'mac_address': '78:45:58:96:c3:6c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '615106324750',
                    'poller_hash': 'Nzg0NTU4OTVjMzZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'dawn_meadows',
                'serial_number':
                'UBNT5895c36c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c3:6c',
                'temperature':
                3.0,
                'uptime':
                '4147940'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1062438998472',
                    'links': [{
                        'in_octets': '1062438998472',
                        'out_octets': '21693880245',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '21693880245',
                    'poller_hash':
                    'Nzg0NTU4OTVjM2IwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2502009',
                            'fiber_length': 4162,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.772,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.954
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OTVjM2IwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '21693880245',
                    'mac_address': '78:45:58:96:c3:b0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1062438998472',
                    'poller_hash': 'Nzg0NTU4OTVjM2IwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'justin_campbell',
                'serial_number':
                'UBNT5895c3b0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c3:b0',
                'temperature':
                23.0,
                'uptime':
                '2502066'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '62357381027',
                    'links': [{
                        'in_octets': '62357381027',
                        'out_octets': '2868103384',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2868103384',
                    'poller_hash':
                    'NjhkNzlhMDY1M2JmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '131380',
                            'fiber_length': 2476,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.882,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.898
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY1M2JmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '2868103384',
                    'mac_address': '68:d7:9a:07:53:bf',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '62357381027',
                    'poller_hash': 'NjhkNzlhMDY1M2JmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'ron_gallardo',
                'serial_number':
                'UBNT9a0653bf',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '68:d7:9a:06:53:bf',
                'temperature':
                15.0,
                'uptime':
                '131433'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '10615202891754',
                    'links': [{
                        'in_octets': '10615202891754',
                        'out_octets': '656121422531',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '656121422531',
                    'poller_hash':
                    'NzRhY2I5MDZhN2NhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '17542490',
                            'fiber_length': 651,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.57,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.276
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5MDZhN2NhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '656121422531',
                    'mac_address': '74:ac:b9:07:a7:ca',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '10615202891754',
                    'poller_hash': 'NzRhY2I5MDZhN2NhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'matt_johnson',
                'serial_number':
                'UBNTb906a7ca',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '74:ac:b9:06:a7:ca',
                'temperature':
                13.0,
                'uptime':
                '17674336'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1008130759425',
                    'links': [{
                        'in_octets': '1008130759425',
                        'out_octets': '286889795472',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '286889795472',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWMwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '32820169',
                            'fiber_length': 2404,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.3,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.784
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWMwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '286889795472',
                    'mac_address': 'f4:92:bf:07:0a:c0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1008130759425',
                    'poller_hash': 'ZjQ5MmJmMDYwYWMwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'SNDW01-ONU',
                'serial_number':
                'UBNTbf060ac0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:c0',
                'temperature':
                7.0,
                'uptime':
                '35327034'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '855601086055',
                    'links': [{
                        'in_octets': '855601086055',
                        'out_octets': '93942891299',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '93942891299',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzhmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 507,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.234,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.558
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzhmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '93942891299',
                    'mac_address': 'f4:92:bf:07:0c:8f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '855601086055',
                    'poller_hash': 'ZjQ5MmJmMDYwYzhmZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jessica_pett',
                'serial_number':
                'UBNTbf060c8f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:8f',
                'temperature':
                9.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '352025510070',
                    'links': [{
                        'in_octets': '352025510070',
                        'out_octets': '17888404761',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17888404761',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNDA0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 4029,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.272,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.78
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNDA0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '17888404761',
                    'mac_address': 'f4:92:bf:07:e4:04',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '352025510070',
                    'poller_hash': 'ZjQ5MmJmMDZlNDA0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jean_porter',
                'serial_number':
                'UBNTbf06e404',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e4:04',
                'temperature':
                8.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '37351004210',
                    'links': [{
                        'in_octets': '37351004210',
                        'out_octets': '2516227918',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2516227918',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNDU2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '314732',
                            'fiber_length': 2991,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.686,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.682
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNDU2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '2516227918',
                    'mac_address': 'f4:92:bf:07:e4:56',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '37351004210',
                    'poller_hash': 'ZjQ5MmJmMDZlNDU2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'marshall_davis',
                'serial_number':
                'UBNTbf06e456',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e4:56',
                'temperature':
                10.0,
                'uptime':
                '314789'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '673463910431',
                    'links': [{
                        'in_octets': '673463910431',
                        'out_octets': '41199525945',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '41199525945',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNTJkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 4064,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.556,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.056
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNTJkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '41199525945',
                    'mac_address': 'f4:92:bf:07:e5:2d',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '673463910431',
                    'poller_hash': 'ZjQ5MmJmMDZlNTJkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'steven_stoner',
                'serial_number':
                'UBNTbf06e52d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e5:2d',
                'temperature':
                9.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2510522673470',
                    'links': [{
                        'in_octets': '2510522673470',
                        'out_octets': '48254841861',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48254841861',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNWY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 3833,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.016,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.502
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNWY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '48254841861',
                    'mac_address': 'f4:92:bf:07:e5:f8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2510522673470',
                    'poller_hash': 'ZjQ5MmJmMDZlNWY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'luis_karl',
                'serial_number':
                'UBNTbf06e5f8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e5:f8',
                'temperature':
                16.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '333970562947',
                    'links': [{
                        'in_octets': '333970562947',
                        'out_octets': '14773019171',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14773019171',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2718991',
                            'fiber_length': 800,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.914,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.604
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '14773019171',
                    'mac_address': 'f4:92:bf:07:e7:5c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '333970562947',
                    'poller_hash': 'ZjQ5MmJmMDZlNzVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'mark_schumacher',
                'serial_number':
                'UBNTbf06e75c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:5c',
                'temperature':
                13.0,
                'uptime':
                '2719048'
            }, {
                'admin_disabled':
                False,
                'cpu':
                9.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1031592999146',
                    'links': [{
                        'in_octets': '1031592999146',
                        'out_octets': '32197629888',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '32197629888',
                    'poller_hash':
                    'ZjQ5MmJmMDZmMzE5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2735041',
                            'fiber_length': 644,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.686,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.934
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmMzE5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '32197629888',
                    'mac_address': 'f4:92:bf:07:f3:19',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1031592999146',
                    'poller_hash': 'ZjQ5MmJmMDZmMzE5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'tina_douglas',
                'serial_number':
                'UBNTbf06f319',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f3:19',
                'temperature':
                8.0,
                'uptime':
                '2735094'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '130979488301',
                    'links': [{
                        'in_octets': '130979488301',
                        'out_octets': '7450548046',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7450548046',
                    'poller_hash':
                    'ZjQ5MmJmMDZmNTFhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 3353,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.878,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.066
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmNTFhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '7450548046',
                    'mac_address': 'f4:92:bf:07:f5:1a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '130979488301',
                    'poller_hash': 'ZjQ5MmJmMDZmNTFhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'chad_thomas',
                'serial_number':
                'UBNTbf06f51a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f5:1a',
                'temperature':
                8.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '226908179626',
                    'links': [{
                        'in_octets': '226908179626',
                        'out_octets': '48724513380',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48724513380',
                    'poller_hash':
                    'YjRmYmU0ZTZkNzM3cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3915985',
                            'fiber_length': 2450,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.002,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.106
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZkNzM3cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '48724513380',
                    'mac_address': 'b4:fb:e4:e7:d7:37',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '226908179626',
                    'poller_hash': 'YjRmYmU0ZTZkNzM3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'sundown_saloon',
                'serial_number':
                'UBNTe4e6d737',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:d7:37',
                'temperature':
                23.0,
                'uptime':
                '3916046'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '311147212731',
                    'links': [{
                        'in_octets': '311147212731',
                        'out_octets': '8080434118',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8080434118',
                    'poller_hash':
                    'NzBhNzQxMzJmNTdjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703649',
                            'fiber_length': 18518,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.766,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.58
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzJmNTdjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '8080434118',
                    'mac_address': '70:a7:41:33:f5:7c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '311147212731',
                    'poller_hash': 'NzBhNzQxMzJmNTdjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'aaron_thole',
                'serial_number':
                'UBNT4132f57c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f5:7c',
                'temperature':
                18.0,
                'uptime':
                '1703735'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1206856652724',
                    'links': [{
                        'in_octets': '1206856652724',
                        'out_octets': '38561419547',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '38561419547',
                    'poller_hash':
                    'NzBhNzQxMzJmNjU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4400731',
                            'fiber_length': 355,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.38
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzJmNjU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '38561419547',
                    'mac_address': '70:a7:41:33:f6:54',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1206856652724',
                    'poller_hash': 'NzBhNzQxMzJmNjU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'nicole_richter',
                'serial_number':
                'UBNT4132f654',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f6:54',
                'temperature':
                14.0,
                'uptime':
                '4400786'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '631194097615',
                    'links': [{
                        'in_octets': '631194097615',
                        'out_octets': '10113597175',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10113597175',
                    'poller_hash':
                    'Nzg0NTU4OTVjMGY0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 526,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.252,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.788
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OTVjMGY0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '10113597175',
                    'mac_address': '78:45:58:96:c0:f4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '631194097615',
                    'poller_hash': 'Nzg0NTU4OTVjMGY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'connie_ecklund',
                'serial_number':
                'UBNT5895c0f4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c0:f4',
                'temperature':
                7.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '34503963233',
                    'links': [{
                        'in_octets': '34503963233',
                        'out_octets': '6939365487',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6939365487',
                    'poller_hash':
                    'Nzg0NTU4OTVkNDkwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '139980',
                            'fiber_length': 419,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.568,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.286
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OTVkNDkwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '6939365487',
                    'mac_address': '78:45:58:96:d4:90',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '34503963233',
                    'poller_hash': 'Nzg0NTU4OTVkNDkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'marissa_woletz',
                'serial_number':
                'UBNT5895d490',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:d4:90',
                'temperature':
                12.0,
                'uptime':
                '140040'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '748100643863',
                    'links': [{
                        'in_octets': '748100643863',
                        'out_octets': '48191616857',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48191616857',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWEzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '6011281',
                            'fiber_length': 10989,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.704,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.258
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWEzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '48191616857',
                    'mac_address': 'f4:92:bf:07:0a:a3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '748100643863',
                    'poller_hash': 'ZjQ5MmJmMDYwYWEzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'rick_anderson',
                'serial_number':
                'UBNTbf060aa3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:a3',
                'temperature':
                16.0,
                'uptime':
                '6011333'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1290564132006',
                    'links': [{
                        'in_octets': '1290564132006',
                        'out_octets': '231734211008',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '231734211008',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWE0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394672',
                            'fiber_length': 11011,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.506,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.614
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWE0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '231734211008',
                    'mac_address': 'f4:92:bf:07:0a:a4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1290564132006',
                    'poller_hash': 'ZjQ5MmJmMDYwYWE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'nancy_chenal',
                'serial_number':
                'UBNTbf060aa4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:a4',
                'temperature':
                13.0,
                'uptime':
                '9394731'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3081515418301',
                    'links': [{
                        'in_octets': '3081515418301',
                        'out_octets': '234235459162',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '234235459162',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWE1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '10687697',
                            'fiber_length': 15323,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.25
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWE1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '234235459162',
                    'mac_address': 'f4:92:bf:07:0a:a5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3081515418301',
                    'poller_hash': 'ZjQ5MmJmMDYwYWE1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'mike_knauber',
                'serial_number':
                'UBNTbf060aa5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:a5',
                'temperature':
                12.0,
                'uptime':
                '10687756'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1990196695797',
                    'links': [{
                        'in_octets': '1990196695797',
                        'out_octets': '70436261425',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '70436261425',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWFicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9395072',
                            'fiber_length': 15294,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.44,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.512
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWFicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '70436261425',
                    'mac_address': 'f4:92:bf:07:0a:ab',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1990196695797',
                    'poller_hash': 'ZjQ5MmJmMDYwYWFiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'shari_chadwick',
                'serial_number':
                'UBNTbf060aab',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:ab',
                'temperature':
                17.0,
                'uptime':
                '9395134'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '68138729320',
                    'links': [{
                        'in_octets': '68138729320',
                        'out_octets': '2405435622',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2405435622',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmQycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 17606,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.168
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmQycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '2405435622',
                    'mac_address': 'f4:92:bf:07:0b:d2',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '68138729320',
                    'poller_hash': 'ZjQ5MmJmMDYwYmQyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'bart_chouinard',
                'serial_number':
                'UBNTbf060bd2',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:d2',
                'temperature':
                16.0,
                'uptime':
                '1703734'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '64674445492',
                    'links': [{
                        'in_octets': '64674445492',
                        'out_octets': '9846408154',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9846408154',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmUzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 15476,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.87,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.712
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmUzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '9846408154',
                    'mac_address': 'f4:92:bf:07:0b:e3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '64674445492',
                    'poller_hash': 'ZjQ5MmJmMDYwYmUzZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'teresa_blok',
                'serial_number':
                'UBNTbf060be3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:e3',
                'temperature':
                10.0,
                'uptime':
                '1703735'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '291225455440',
                    'links': [{
                        'in_octets': '291225455440',
                        'out_octets': '10184826899',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10184826899',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703649',
                            'fiber_length': 18141,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.016
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '10184826899',
                    'mac_address': 'f4:92:bf:07:0b:e4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '291225455440',
                    'poller_hash': 'ZjQ5MmJmMDYwYmU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'wayne_gustafson',
                'serial_number':
                'UBNTbf060be4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:e4',
                'temperature':
                12.0,
                'uptime':
                '1703736'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '254366955439',
                    'links': [{
                        'in_octets': '254366955439',
                        'out_octets': '18712593205',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18712593205',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmYzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394671',
                            'fiber_length': 11429,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.96
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmYzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '18712593205',
                    'mac_address': 'f4:92:bf:07:0b:f3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '254366955439',
                    'poller_hash': 'ZjQ5MmJmMDYwYmYzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jeffrey_schefelker',
                'serial_number':
                'UBNTbf060bf3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:f3',
                'temperature':
                12.0,
                'uptime':
                '9394732'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '66615357827',
                    'links': [{
                        'in_octets': '66615357827',
                        'out_octets': '8094178403',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8094178403',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzAzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394662',
                            'fiber_length': 11416,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.704,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.286
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzAzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '8094178403',
                    'mac_address': 'f4:92:bf:07:0c:03',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '66615357827',
                    'poller_hash': 'ZjQ5MmJmMDYwYzAzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'lesa_beeler',
                'serial_number':
                'UBNTbf060c03',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:03',
                'temperature':
                15.0,
                'uptime':
                '9394731'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '305207258415',
                    'links': [{
                        'in_octets': '305207258415',
                        'out_octets': '46607020203',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '46607020203',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzM5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394671',
                            'fiber_length': 11441,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.788,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.886
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzM5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '46607020203',
                    'mac_address': 'f4:92:bf:07:0c:39',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '305207258415',
                    'poller_hash': 'ZjQ5MmJmMDYwYzM5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jason_craig',
                'serial_number':
                'UBNTbf060c39',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:39',
                'temperature':
                9.0,
                'uptime':
                '9394731'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '767047358429',
                    'links': [{
                        'in_octets': '767047358429',
                        'out_octets': '41585133775',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '41585133775',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzhicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3017725',
                            'fiber_length': 11115,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.022,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.726
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzhicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '41585133775',
                    'mac_address': 'f4:92:bf:07:0c:8b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '767047358429',
                    'poller_hash': 'ZjQ5MmJmMDYwYzhiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'rob_anderson',
                'serial_number':
                'UBNTbf060c8b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:8b',
                'temperature':
                14.0,
                'uptime':
                '3017781'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '319637726358',
                    'links': [{
                        'in_octets': '319637726358',
                        'out_octets': '29895627635',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '29895627635',
                    'poller_hash':
                    'ZjQ5MmJmMDYwY2I4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 15707,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.314,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.932
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwY2I4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '29895627635',
                    'mac_address': 'f4:92:bf:07:0c:b8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '319637726358',
                    'poller_hash': 'ZjQ5MmJmMDYwY2I4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'ben_rathbun',
                'serial_number':
                'UBNTbf060cb8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:b8',
                'temperature':
                20.0,
                'uptime':
                '1703735'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '454658110267',
                    'links': [{
                        'in_octets': '454658110267',
                        'out_octets': '181560676436',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '181560676436',
                    'poller_hash':
                    'ZjQ5MmJmMDYwY2M4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394671',
                            'fiber_length': 11268,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.654,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.19
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwY2M4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '181560676436',
                    'mac_address': 'f4:92:bf:07:0c:c8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '454658110267',
                    'poller_hash': 'ZjQ5MmJmMDYwY2M4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'mike_freeberg',
                'serial_number':
                'UBNTbf060cc8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:c8',
                'temperature':
                19.0,
                'uptime':
                '9394732'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '875916588153',
                    'links': [{
                        'in_octets': '875916588153',
                        'out_octets': '24061190613',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24061190613',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzNlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4034357',
                            'fiber_length': 823,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.258,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.666
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzNlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '24061190613',
                    'mac_address': 'f4:92:bf:07:e7:3e',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '875916588153',
                    'poller_hash': 'ZjQ5MmJmMDZlNzNlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'kim_rognrud',
                'serial_number':
                'UBNTbf06e73e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:3e',
                'temperature':
                8.0,
                'uptime':
                '4034410'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '72158810188',
                    'links': [{
                        'in_octets': '72158810188',
                        'out_octets': '2685243941',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2685243941',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzU1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 18691,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.978,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.9
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzU1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '2685243941',
                    'mac_address': 'f4:92:bf:07:e7:55',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '72158810188',
                    'poller_hash': 'ZjQ5MmJmMDZlNzU1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jim_renno',
                'serial_number':
                'UBNTbf06e755',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:55',
                'temperature':
                16.0,
                'uptime':
                '1703736'
            }, {
                'admin_disabled':
                False,
                'cpu':
                9.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '342658834887',
                    'links': [{
                        'in_octets': '342658834887',
                        'out_octets': '11569552211',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11569552211',
                    'poller_hash':
                    'ZjQ5MmJmMDZmMGRjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 17588,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.602
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmMGRjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '11569552211',
                    'mac_address': 'f4:92:bf:07:f0:dc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '342658834887',
                    'poller_hash': 'ZjQ5MmJmMDZmMGRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'lisa_lundeenbrooks',
                'serial_number':
                'UBNTbf06f0dc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f0:dc',
                'temperature':
                13.0,
                'uptime':
                '1703736'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2153845937130',
                    'links': [{
                        'in_octets': '2153845937130',
                        'out_octets': '143891962160',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '143891962160',
                    'poller_hash':
                    'YjRmYmU0ZTZlNzNkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 370,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.478,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.968
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlNzNkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '143891962160',
                    'mac_address': 'b4:fb:e4:e7:e7:3d',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2153845937130',
                    'poller_hash': 'YjRmYmU0ZTZlNzNkZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'rich_brande',
                'serial_number':
                'UBNTe4e6e73d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e7:3d',
                'temperature':
                15.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2083065968776',
                    'links': [{
                        'in_octets': '2083065968776',
                        'out_octets': '61538569267',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '61538569267',
                    'poller_hash':
                    'NjhkNzlhMDY1MzYxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044297',
                            'fiber_length': 3458,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.894,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.958
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY1MzYxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '61538569267',
                    'mac_address': '68:d7:9a:07:53:61',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2083065968776',
                    'poller_hash': 'NjhkNzlhMDY1MzYxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'brandi_pederson',
                'serial_number':
                'UBNT9a065361',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '68:d7:9a:06:53:61',
                'temperature':
                5.0,
                'uptime':
                '4044348'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '138426127587',
                    'links': [{
                        'in_octets': '138426127587',
                        'out_octets': '15174113650',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15174113650',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYTVmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044287',
                            'fiber_length': 3045,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.604,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.918
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYwYTVmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '15174113650',
                    'mac_address': 'f4:92:bf:07:0a:5f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '138426127587',
                    'poller_hash': 'ZjQ5MmJmMDYwYTVmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'joshua_corrigan',
                'serial_number':
                'UBNTbf060a5f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:5f',
                'temperature':
                14.0,
                'uptime':
                '4044348'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '344350385160',
                    'links': [{
                        'in_octets': '344350385160',
                        'out_octets': '30791492050',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '30791492050',
                    'poller_hash':
                    'YjRmYmU0ZTZkNzMzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '799058',
                            'fiber_length': 1218,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.924,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.184
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZkNzMzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '30791492050',
                    'mac_address': 'b4:fb:e4:e7:d7:33',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '344350385160',
                    'poller_hash': 'YjRmYmU0ZTZkNzMzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'sarah_jorgenson',
                'serial_number':
                'UBNTe4e6d733',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:d7:33',
                'temperature':
                23.0,
                'uptime':
                '799112'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1230012998216',
                    'links': [{
                        'in_octets': '1230012998216',
                        'out_octets': '29988333305',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '29988333305',
                    'poller_hash':
                    'YjRmYmU0ZTZlNzJlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044277',
                            'fiber_length': 3466,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.0,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.712
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlNzJlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '29988333305',
                    'mac_address': 'b4:fb:e4:e7:e7:2e',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1230012998216',
                    'poller_hash': 'YjRmYmU0ZTZlNzJlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'tim_olson',
                'serial_number':
                'UBNTe4e6e72e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e7:2e',
                'temperature':
                12.0,
                'uptime':
                '4044347'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '8148840961',
                    'links': [{
                        'in_octets': '8148840961',
                        'out_octets': '407301660',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '407301660',
                    'poller_hash':
                    'YjRmYmU0ZTZlN2M0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '58129',
                            'fiber_length': 2933,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.03,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.978
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlN2M0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '407301660',
                    'mac_address': 'b4:fb:e4:e7:e7:c4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '8148840961',
                    'poller_hash': 'YjRmYmU0ZTZlN2M0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'veda_gade',
                'serial_number':
                'UBNTe4e6e7c4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e7:c4',
                'temperature':
                22.0,
                'uptime':
                '58190'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1595930280165',
                    'links': [{
                        'in_octets': '1595930280165',
                        'out_octets': '54186737319',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '54186737319',
                    'poller_hash':
                    'YjRmYmU0ZTZlODE2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 611,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.238,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.302
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlODE2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '54186737319',
                    'mac_address': 'b4:fb:e4:e7:e8:16',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1595930280165',
                    'poller_hash': 'YjRmYmU0ZTZlODE2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'lewis_vfw',
                'serial_number':
                'UBNTe4e6e816',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e8:16',
                'temperature':
                18.0,
                'uptime':
                '4752053'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1138527495450',
                    'links': [{
                        'in_octets': '1138527495450',
                        'out_octets': '511199320123',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '511199320123',
                    'poller_hash':
                    'YjRmYmU0ZTZlODVmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044287',
                            'fiber_length': 4320,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.1,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.726
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlODVmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '511199320123',
                    'mac_address': 'b4:fb:e4:e7:e8:5f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1138527495450',
                    'poller_hash': 'YjRmYmU0ZTZlODVmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'christine_strak',
                'serial_number':
                'UBNTe4e6e85f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e8:5f',
                'temperature':
                21.0,
                'uptime':
                '4044348'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '137006998777',
                    'links': [{
                        'in_octets': '137006998777',
                        'out_octets': '33940226416',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '33940226416',
                    'poller_hash':
                    'YjRmYmU0ZTZlODlicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2393197',
                            'fiber_length': 2896,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.326,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.11
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlODlicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '33940226416',
                    'mac_address': 'b4:fb:e4:e7:e8:9b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '137006998777',
                    'poller_hash': 'YjRmYmU0ZTZlODliZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'lance_howard',
                'serial_number':
                'UBNTe4e6e89b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e8:9b',
                'temperature':
                24.0,
                'uptime':
                '4045022'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '474807784979',
                    'links': [{
                        'in_octets': '474807784979',
                        'out_octets': '12889658994',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12889658994',
                    'poller_hash':
                    'NzBhNzQxMzJmNDRjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 5613,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.516,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.026
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzJmNDRjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '12889658994',
                    'mac_address': '70:a7:41:33:f4:4c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '474807784979',
                    'poller_hash': 'NzBhNzQxMzJmNDRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'douglas_owens',
                'serial_number':
                'UBNT4132f44c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f4:4c',
                'temperature':
                6.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1817054145489',
                    'links': [{
                        'in_octets': '1817054145489',
                        'out_octets': '53481170163',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '53481170163',
                    'poller_hash':
                    'NzBhNzQxMzJmNWQ4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 3246,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.126,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.848
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzJmNWQ4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '53481170163',
                    'mac_address': '70:a7:41:33:f5:d8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1817054145489',
                    'poller_hash': 'NzBhNzQxMzJmNWQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'atc_agency',
                'serial_number':
                'UBNT4132f5d8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f5:d8',
                'temperature':
                17.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '596894349104',
                    'links': [{
                        'in_octets': '596894349104',
                        'out_octets': '26739296554',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '26739296554',
                    'poller_hash':
                    'Nzg0NTU4OTVkMzgwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 6528,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.064,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.698
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OTVkMzgwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '26739296554',
                    'mac_address': '78:45:58:96:d3:80',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '596894349104',
                    'poller_hash': 'Nzg0NTU4OTVkMzgwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'susan_olson',
                'serial_number':
                'UBNT5895d380',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:d3:80',
                'temperature':
                12.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '799506207056',
                    'links': [{
                        'in_octets': '799506207056',
                        'out_octets': '20106793170',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '20106793170',
                    'poller_hash':
                    'ZjQ5MmJmMDZlMGJlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1282814',
                            'fiber_length': 6060,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.374,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.024
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlMGJlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '20106793170',
                    'mac_address': 'f4:92:bf:07:e0:be',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '799506207056',
                    'poller_hash': 'ZjQ5MmJmMDZlMGJlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'judith_shafer',
                'serial_number':
                'UBNTbf06e0be',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e0:be',
                'temperature':
                13.0,
                'uptime':
                '1282867'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1649284105874',
                    'links': [{
                        'in_octets': '1649284105874',
                        'out_octets': '100218969278',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '100218969278',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNDJmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 7061,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.12,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.58
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNDJmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '100218969278',
                    'mac_address': 'f4:92:bf:07:e4:2f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1649284105874',
                    'poller_hash': 'ZjQ5MmJmMDZlNDJmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'sarah_radomsky',
                'serial_number':
                'UBNTbf06e42f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e4:2f',
                'temperature':
                10.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1217535082077',
                    'links': [{
                        'in_octets': '1217535082077',
                        'out_octets': '49206395961',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '49206395961',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNjNhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044287',
                            'fiber_length': 5635,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.448,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.73
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNjNhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '49206395961',
                    'mac_address': 'f4:92:bf:07:e6:3a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1217535082077',
                    'poller_hash': 'ZjQ5MmJmMDZlNjNhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'louann_skillings',
                'serial_number':
                'UBNTbf06e63a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e6:3a',
                'temperature':
                11.0,
                'uptime':
                '4044348'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '865593485595',
                    'links': [{
                        'in_octets': '865593485595',
                        'out_octets': '45484282143',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '45484282143',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzI1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 5341,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.032,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.592
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzI1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '45484282143',
                    'mac_address': 'f4:92:bf:07:e7:25',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '865593485595',
                    'poller_hash': 'ZjQ5MmJmMDZlNzI1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'cory_wondra',
                'serial_number':
                'UBNTbf06e725',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:25',
                'temperature':
                12.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '148587210657',
                    'links': [{
                        'in_octets': '148587210657',
                        'out_octets': '22052831664',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '22052831664',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzQ5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 5702,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.672,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.144
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzQ5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '22052831664',
                    'mac_address': 'f4:92:bf:07:e7:49',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '148587210657',
                    'poller_hash': 'ZjQ5MmJmMDZlNzQ5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'denise_nelson',
                'serial_number':
                'UBNTbf06e749',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:49',
                'temperature':
                14.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '445010687552',
                    'links': [{
                        'in_octets': '445010687552',
                        'out_octets': '35833393893',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '35833393893',
                    'poller_hash':
                    'ZjQ5MmJmMDZmNGQ5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1362655',
                            'fiber_length': 4638,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.152,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.88
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmNGQ5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '35833393893',
                    'mac_address': 'f4:92:bf:07:f4:d9',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '445010687552',
                    'poller_hash': 'ZjQ5MmJmMDZmNGQ5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'suzanne_starcevich',
                'serial_number':
                'UBNTbf06f4d9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f4:d9',
                'temperature':
                18.0,
                'uptime':
                '1362713'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '72174486170',
                    'links': [{
                        'in_octets': '72174486170',
                        'out_octets': '6903138178',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6903138178',
                    'poller_hash':
                    'ZjQ5MmJmMDZmNTBmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 4751,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.614,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.364
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmNTBmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '6903138178',
                    'mac_address': 'f4:92:bf:07:f5:0f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '72174486170',
                    'poller_hash': 'ZjQ5MmJmMDZmNTBmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'diane_mork',
                'serial_number':
                'UBNTbf06f50f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f5:0f',
                'temperature':
                10.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '308568394681',
                    'links': [{
                        'in_octets': '308568394681',
                        'out_octets': '26297243907',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '26297243907',
                    'poller_hash':
                    'YjRmYmU0ZTZkNzI4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '799058',
                            'fiber_length': 3746,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.528
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZkNzI4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '26297243907',
                    'mac_address': 'b4:fb:e4:e7:d7:28',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '308568394681',
                    'poller_hash': 'YjRmYmU0ZTZkNzI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'james_brewster',
                'serial_number':
                'UBNTe4e6d728',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:d7:28',
                'temperature':
                22.0,
                'uptime':
                '799114'
            }, {
                'admin_disabled':
                True,
                'cpu':
                0.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '0',
                    'links': [{
                        'in_octets': '0',
                        'out_octets': '0',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '0',
                    'poller_hash':
                    'YjRmYmU0ZTZkZmY1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '799058',
                            'fiber_length': 3727,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.124,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.562
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZkZmY1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '0',
                    'poller_hash': 'YjRmYmU0ZTZkZmY1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'sarah15_ltd',
                'serial_number':
                'UBNTe4e6dff5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:df:f5',
                'temperature':
                23.0,
                'uptime':
                '799112'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '297984857264',
                    'links': [{
                        'in_octets': '297984857264',
                        'out_octets': '38940730145',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '38940730145',
                    'poller_hash':
                    'YjRmYmU0ZTZlMjg2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1786550',
                            'fiber_length': 3120,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.832,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.766
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlMjg2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '38940730145',
                    'mac_address': 'b4:fb:e4:e7:e2:86',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '297984857264',
                    'poller_hash': 'YjRmYmU0ZTZlMjg2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'pam_engen',
                'serial_number':
                'UBNTe4e6e286',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e2:86',
                'temperature':
                20.0,
                'uptime':
                '1786606'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '192032241569',
                    'links': [{
                        'in_octets': '192032241569',
                        'out_octets': '37345066606',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '37345066606',
                    'poller_hash':
                    'YjRmYmU0ZTZlNzI4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '799058',
                            'fiber_length': 3735,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.634,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.828
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlNzI4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '37345066606',
                    'mac_address': 'b4:fb:e4:e7:e7:28',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '192032241569',
                    'poller_hash': 'YjRmYmU0ZTZlNzI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'sarah15_showroom',
                'serial_number':
                'UBNTe4e6e728',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e7:28',
                'temperature':
                23.0,
                'uptime':
                '799114'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '30194536974',
                    'links': [{
                        'in_octets': '30194536974',
                        'out_octets': '5543285944',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5543285944',
                    'poller_hash':
                    'YjRmYmU0ZTZlOGZicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '746687',
                            'fiber_length': 2933,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.12,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.78
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlOGZicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '5543285944',
                    'mac_address': 'b4:fb:e4:e7:e8:fb',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '30194536974',
                    'poller_hash': 'YjRmYmU0ZTZlOGZiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'elaine_thomas',
                'serial_number':
                'UBNTe4e6e8fb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e8:fb',
                'temperature':
                25.0,
                'uptime':
                '746745'
            }, {
                'admin_disabled':
                False,
                'cpu':
                9.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '432410612283',
                    'links': [{
                        'in_octets': '432410612283',
                        'out_octets': '24900785839',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24900785839',
                    'poller_hash':
                    'ZDAyMWY5MWFjZDM4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2237305',
                            'fiber_length': 5324,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.75,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.692
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5MWFjZDM4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '24900785839',
                    'mac_address': 'd0:21:f9:1b:cd:38',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '432410612283',
                    'poller_hash': 'ZDAyMWY5MWFjZDM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'lisa_olson',
                'serial_number':
                'UBNTf91acd38',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'd0:21:f9:1a:cd:38',
                'temperature':
                21.0,
                'uptime':
                '2237365'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '84043068539',
                    'links': [{
                        'in_octets': '84043068539',
                        'out_octets': '18909417133',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18909417133',
                    'poller_hash':
                    'Nzg0NTU4OTVjMzA4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3532081',
                            'fiber_length': 9329,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.1,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.044
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OTVjMzA4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '18909417133',
                    'mac_address': '78:45:58:96:c3:08',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '84043068539',
                    'poller_hash': 'Nzg0NTU4OTVjMzA4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'larry_hedlund',
                'serial_number':
                'UBNT5895c308',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c3:08',
                'temperature':
                10.0,
                'uptime':
                '4489301'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '19877537988',
                    'links': [{
                        'in_octets': '19877537988',
                        'out_octets': '2483381931',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2483381931',
                    'poller_hash':
                    'Nzg0NTU4OTVkNDc4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1116712',
                            'fiber_length': 7992,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.43,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.582
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OTVkNDc4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '2483381931',
                    'mac_address': '78:45:58:96:d4:78',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '19877537988',
                    'poller_hash': 'Nzg0NTU4OTVkNDc4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'lucy_swanson',
                'serial_number':
                'UBNT5895d478',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:d4:78',
                'temperature':
                8.0,
                'uptime':
                '1116766'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '384995526756',
                    'links': [{
                        'in_octets': '384995526756',
                        'out_octets': '17123883502',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17123883502',
                    'poller_hash':
                    'NjhkNzlhMDZmZTkzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2476078',
                            'fiber_length': 7849,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.706,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.68
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDZmZTkzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '17123883502',
                    'mac_address': '68:d7:9a:07:fe:93',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '384995526756',
                    'poller_hash': 'NjhkNzlhMDZmZTkzZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'nick_lundquist',
                'serial_number':
                'UBNT9a06fe93',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '68:d7:9a:06:fe:93',
                'temperature':
                12.0,
                'uptime':
                '2476139'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '891036245817',
                    'links': [{
                        'in_octets': '891036245817',
                        'out_octets': '25176369735',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '25176369735',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNTk5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3532080',
                            'fiber_length': 19937,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.538
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNTk5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '25176369735',
                    'mac_address': 'f4:92:bf:07:e5:99',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '891036245817',
                    'poller_hash': 'ZjQ5MmJmMDZlNTk5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'bruce_lundquist',
                'serial_number':
                'UBNTbf06e599',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e5:99',
                'temperature':
                25.0,
                'uptime':
                '4384770'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '394319264326',
                    'links': [{
                        'in_octets': '394319264326',
                        'out_octets': '32624369913',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '32624369913',
                    'poller_hash':
                    'ZjQ5MmJmMDZmMjk4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3532080',
                            'fiber_length': 8195,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.222,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.938
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmMjk4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '32624369913',
                    'mac_address': 'f4:92:bf:07:f2:98',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '394319264326',
                    'poller_hash': 'ZjQ5MmJmMDZmMjk4ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'adam_hedlund',
                'serial_number':
                'UBNTbf06f298',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f2:98',
                'temperature':
                6.0,
                'uptime':
                '6395712'
            }]
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_3_1_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.3.1.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 143,
            'sw_version': '4.3.1',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 32}
        exp_sta_stats = {
            '18:e8:29:0b:3f:88': {
                'dev_macs': ['34:60:f9:c1:b9:7d'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:3f:88',
                'name': '38188HuntsEndPl'
            },
            '18:e8:29:0b:3f:e4': {
                'dev_macs': ['04:42:1a:18:75:70'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:3f:e4',
                'name': '19287LincolnRoad-Shed'
            },
            '18:e8:29:0b:3f:f0': {
                'dev_macs': ['48:22:54:38:18:95'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:3f:f0',
                'name': '19443JodhpurDr'
            },
            '18:e8:29:0b:40:b0': {
                'dev_macs': [
                    '00:18:61:51:af:cd', '14:20:5e:05:d6:7a', '18:b4:30:0c:45:20',
                    '32:55:13:a6:c9:5a', '38:b8:00:62:b8:49', '60:22:32:42:e8:f0',
                    '64:16:66:d5:76:95', '84:ea:ed:6a:fc:fe', '9a:47:44:34:1e:83',
                    'bc:d7:d4:6a:e0:f0', 'c8:ff:77:4a:fb:76', 'cc:08:fa:60:33:84',
                    'e0:63:da:14:80:ee'
                ],
                'ip_address':
                None,
                'mac_address':
                '18:e8:29:0b:40:b0',
                'name':
                '19965LincolnRoad'
            },
            '18:e8:29:0b:41:20': {
                'dev_macs': [
                    '0a:cf:8d:4b:cd:a4', '18:16:c9:d9:44:bc', '1c:53:f9:ac:14:0d',
                    '1c:53:f9:b5:8e:56', '20:1f:3b:7f:9e:08', '20:1f:3b:9a:8f:27',
                    '34:98:b5:a3:c0:9d', '34:98:b5:a4:43:33', '34:98:b5:a4:44:77',
                    '36:98:b5:a3:c0:a0', '40:bd:32:6e:84:db', '64:cc:22:bf:07:61',
                    '64:cc:22:bf:08:11', '68:3e:26:ec:86:6e', '68:fc:ca:b4:8e:d4',
                    '9c:b6:d0:d6:16:d7', 'a4:bb:6d:5d:9f:a5', 'a8:a2:37:89:0c:19',
                    'a8:a2:37:89:0c:2d', 'aa:14:fa:68:96:0a', 'd8:d0:90:1c:c0:23',
                    'ee:61:84:68:12:3e'
                ],
                'ip_address':
                None,
                'mac_address':
                '18:e8:29:0b:41:20',
                'name':
                '20013LincolnRoad'
            },
            '18:e8:29:0b:41:94': {
                'dev_macs': [
                    '40:16:3b:3d:4b:50', '48:a9:d2:72:42:77', '9c:5a:44:c6:a3:43',
                    '9c:5a:44:cb:37:23', 'd8:0d:17:f5:f5:50'
                ],
                'ip_address':
                None,
                'mac_address':
                '18:e8:29:0b:41:94',
                'name':
                '19287LincolnRoad-House'
            },
            '18:e8:29:0b:41:e8': {
                'dev_macs': ['54:af:97:17:c2:e1'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:41:e8',
                'name': '38195HuntsEndPl'
            },
            '18:e8:29:0b:4b:64': {
                'dev_macs': ['0c:51:01:e2:25:46'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:4b:64',
                'name': '19783GreggsvilleRoad'
            },
            '74:83:c2:68:e0:2b': {
                'dev_macs': ['54:af:97:f8:b7:35'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:2b',
                'name': '19369LancerCircle'
            },
            '74:83:c2:68:e0:3f': {
                'dev_macs': ['54:af:97:12:12:8b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:3f',
                'name': '38153HuntsEndPl'
            },
            '74:83:c2:68:e0:42': {
                'dev_macs': ['6c:cd:d6:27:b4:fa'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:42',
                'name': '38202HuntsEndPl'
            },
            '74:83:c2:68:e0:43': {
                'dev_macs': ['34:98:b5:a3:e7:e5'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:43',
                'name': '19144ShelburneGlebeRd'
            },
            '74:83:c2:68:e0:50': {
                'dev_macs': ['34:60:f9:5d:75:d9'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:50',
                'name': '19464JodhpurDr'
            },
            '74:83:c2:68:e0:59': {
                'dev_macs': ['54:af:97:79:cd:05'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:59',
                'name': '19749LincolnRoad-House'
            },
            '74:83:c2:68:e0:78': {
                'dev_macs': ['54:af:97:4f:e0:f0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:78',
                'name': '19749LincolnRoad-Garage'
            },
            '74:83:c2:68:e0:79': {
                'dev_macs': ['30:34:22:21:73:21'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:79',
                'name': '19351LincolnRoad'
            },
            '74:83:c2:68:e0:7b': {
                'dev_macs': ['2c:30:33:60:5c:57'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:7b',
                'name': '19163LincolnRd'
            },
            '74:83:c2:68:e0:87': {
                'dev_macs': ['cc:40:d0:4d:3b:d0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:87',
                'name': '38174NorthForkRd'
            },
            '74:83:c2:68:e0:93': {
                'dev_macs': ['78:d2:94:c3:e5:89'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:93',
                'name': '19110ShelburneGlebeRd'
            },
            '74:83:c2:68:e0:a1': {
                'dev_macs': ['68:d7:9a:5c:fa:4c'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:a1',
                'name': '19320LancerCircle'
            },
            '74:83:c2:68:e0:b3': {
                'dev_macs': ['14:59:c0:42:7d:3b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:b3',
                'name': '19231LancerCircle'
            },
            '74:83:c2:68:e0:bf': {
                'dev_macs': ['30:34:22:09:59:a0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:bf',
                'name': '19203LincolnRoad'
            },
            '74:83:c2:68:e0:dc': {
                'dev_macs': ['9c:c9:eb:f5:90:63'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:dc',
                'name': '19008LincolnRd'
            },
            '74:83:c2:68:e0:df': {
                'dev_macs': ['b4:b0:24:42:6e:5d'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:df',
                'name': '19243LancerCircle'
            },
            '74:83:c2:68:e0:e3': {
                'dev_macs': ['7c:d9:5c:99:1f:fc'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:e3',
                'name': '37967ForestMillsRd'
            },
            '74:83:c2:68:e0:eb': {
                'dev_macs': ['c8:9e:43:c2:57:b6'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:eb',
                'name': '20152GreggsvilleRd'
            },
            '74:83:c2:68:e0:ec': {
                'dev_macs': ['e8:48:b8:20:a9:5f'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:ec',
                'name': '38057ForestMillsRoad-Cottage'
            },
            '74:83:c2:68:e0:fd': {
                'dev_macs': ['b0:39:56:f5:46:06'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:fd',
                'name': '20200ShelburneGlebeRd'
            },
            '74:83:c2:68:e1:00': {
                'dev_macs': ['a4:97:33:b0:73:d0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:00',
                'name': '19110LancerCircle'
            },
            '74:83:c2:68:e1:10': {
                'dev_macs': ['6c:cd:d6:03:8c:1f', 'a8:51:ab:95:30:9f'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:10',
                'name': '19167LancerCircle'
            },
            '74:83:c2:68:e1:4a': {
                'dev_macs': ['04:42:1a:9a:fd:a0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:4a',
                'name': '19061LancerCircle'
            },
            '74:83:c2:68:e1:71': {
                'dev_macs': ['54:af:97:4f:fa:30'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:71',
                'name': '19964PleasantMeadowLn'
            },
            '74:83:c2:68:e1:73': {
                'dev_macs': ['3c:37:86:69:e1:ad'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:73',
                'name': '38011NorthForkRd'
            },
            '74:83:c2:68:e1:77': {
                'dev_macs': ['e0:b2:60:30:36:f9'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:77',
                'name': '19277OaklandGreenRd'
            },
            '74:83:c2:68:e1:a1': {
                'dev_macs': ['80:da:13:ac:5b:c1'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:a1',
                'name': '19815GreggsvilleRoad'
            },
            '74:83:c2:68:e1:ad': {
                'dev_macs': ['78:d2:94:12:bd:4d', 'cc:f4:11:80:c8:97'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:ad',
                'name': '37626NorthForkRd'
            },
            '74:83:c2:68:e1:bb': {
                'dev_macs': ['c8:9e:43:9c:0d:5a'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:bb',
                'name': '19396LincolnRd'
            },
            '74:83:c2:68:e1:ca': {
                'dev_macs': ['40:ed:00:43:69:94'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:ca',
                'name': '38313NorthForkRd'
            },
            '74:83:c2:68:e1:cb': {
                'dev_macs': ['38:94:ed:43:ac:3d'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:cb',
                'name': '19432JodhpurDr'
            },
            '74:83:c2:68:e1:cd': {
                'dev_macs': ['54:af:97:4f:fe:24'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:cd',
                'name': '19299OaklandGreenRd'
            },
            '74:83:c2:68:e1:ce': {
                'dev_macs': ['74:ac:b9:4e:87:ef'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:ce',
                'name': '19249LincolnRoad'
            },
            '74:83:c2:68:e1:d4': {
                'dev_macs': ['54:af:97:0f:d8:f5'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:d4',
                'name': '37972NorthForkRd'
            },
            '74:83:c2:68:e1:d5': {
                'dev_macs': ['e8:da:00:15:b6:5b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:d5',
                'name': '38307NorthForkRd'
            },
            '74:83:c2:68:e1:f4': {
                'dev_macs': ['38:94:ed:69:f0:aa'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:f4',
                'name': '38110NorthForkRd'
            },
            '74:83:c2:68:e1:fc': {
                'dev_macs': ['24:4b:fe:40:71:31'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:fc',
                'name': '20248GrerggsvilleRoad'
            },
            '74:83:c2:68:e1:ff': {
                'dev_macs': ['54:af:97:4f:d4:34'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:ff',
                'name': '38158NorthForkRd'
            },
            '74:83:c2:68:e2:02': {
                'dev_macs': ['78:d2:94:ab:9a:cd'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:02',
                'name': '19430LancerCir'
            },
            '74:83:c2:68:e2:03': {
                'dev_macs':
                ['90:9a:4a:d0:74:1a', '9c:a2:f4:4e:5a:4d', 'c0:74:ad:74:89:cb'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:03',
                'name': '19080LancerCircle'
            },
            '74:83:c2:68:e2:1b': {
                'dev_macs': ['e8:da:00:15:d7:f7'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:1b',
                'name': '20017ShelburneGlebeRd'
            },
            '74:83:c2:68:e2:98': {
                'dev_macs': ['c8:9e:43:ab:11:cd'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:98',
                'name': '20011PleasantMeadowsLane'
            },
            '74:83:c2:68:e2:a1': {
                'dev_macs': ['c8:9e:43:b6:00:bf'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:a1',
                'name': '19070LincolnRoad'
            },
            '74:83:c2:68:e2:a3': {
                'dev_macs': ['c8:9e:43:67:5f:fb'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:a3',
                'name': '19675LincolnRoad'
            },
            '74:83:c2:68:e2:b7': {
                'dev_macs': ['38:94:ed:b3:38:7a'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:b7',
                'name': '19221LincolnRd'
            },
            '74:83:c2:68:e2:b8': {
                'dev_macs': ['54:af:97:4f:e2:ec'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:b8',
                'name': '38134HuntsEndPl'
            },
            '74:83:c2:68:e2:bd': {
                'dev_macs': ['14:91:82:71:43:86'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:bd',
                'name': '19209LincolnRoad'
            },
            '74:83:c2:68:e2:c5': {
                'dev_macs': ['74:ac:b9:d2:b2:81'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:c5',
                'name': '19391LancerCircle'
            },
            '74:83:c2:68:e2:e5': {
                'dev_macs': ['44:a5:6e:63:3e:48'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:e5',
                'name': '37967ForestMillsRd'
            },
            '74:83:c2:68:e3:11': {
                'dev_macs': [
                    'b4:b7:42:a0:04:ca', 'e0:63:da:25:0c:e8', 'e0:63:da:25:0c:e9',
                    'e0:63:da:73:04:04'
                ],
                'ip_address':
                None,
                'mac_address':
                '74:83:c2:68:e3:11',
                'name':
                '19249LincolnRoad-Cottage'
            },
            '74:83:c2:68:e3:21': {
                'dev_macs': ['24:05:88:40:ef:31'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:21',
                'name': '19382LancerCircle'
            },
            '74:83:c2:68:e3:25': {
                'dev_macs': ['d8:47:32:98:46:73'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:25',
                'name': '19060LincolnRoad'
            },
            '74:83:c2:68:e3:2e': {
                'dev_macs': ['74:ac:b9:58:9d:ce'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:2e',
                'name': '19226LancerCircle'
            },
            '74:83:c2:68:e3:32': {
                'dev_macs': ['1c:61:b4:b1:23:c5'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:32',
                'name': '38298HuntsEndPl'
            },
            '74:83:c2:68:e3:35': {
                'dev_macs': ['18:90:88:a2:12:e1'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:35',
                'name': '19625LincolnRoad'
            },
            '74:83:c2:68:e3:3a': {
                'dev_macs': ['c8:9e:43:a5:85:ee'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:3a',
                'name': '19215LincolnRoad'
            },
            '74:83:c2:68:e3:3b': {
                'dev_macs': ['3c:37:86:14:45:65'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:3b',
                'name': '19496JodhpurDr'
            },
            '74:83:c2:68:e3:49': {
                'dev_macs': ['e8:9f:80:1c:82:49'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:49',
                'name': '38166HuntsEndPl'
            },
            '74:83:c2:68:e3:4c': {
                'dev_macs': ['28:87:ba:76:91:c1'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:4c',
                'name': '19783GreggsvilleRoad-Cottage'
            },
            '74:83:c2:68:e3:50': {
                'dev_macs': ['6c:cd:d6:e1:de:09'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:50',
                'name': '19058LancerCircle'
            },
            '74:83:c2:68:e3:54': {
                'dev_macs': ['3c:37:86:fb:37:1b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:54',
                'name': '19105LancerCircle'
            },
            '74:83:c2:f0:20:00': {
                'dev_macs': ['24:f5:a2:0a:88:9a'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:20:00',
                'name': '19002LincolnRd'
            },
            '74:83:c2:f0:27:58': {
                'dev_macs': ['08:36:c9:7c:52:ab'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:27:58',
                'name': '38236NorthForkRd-House'
            },
            '74:83:c2:f0:27:b4': {
                'dev_macs': ['00:ab:48:c5:87:e1', '74:83:c2:f5:fb:74'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:27:b4',
                'name': '20124CreekspringCt'
            },
            '74:83:c2:f0:29:0c': {
                'dev_macs': ['34:98:b5:73:34:ea'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:29:0c',
                'name': '38236NorthForkRd-Garage'
            },
            '74:83:c2:f0:29:b8': {
                'dev_macs': ['90:9a:4a:cd:e0:b9'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:29:b8',
                'name': '19281SwanCt'
            },
            '74:83:c2:f0:29:c8': {
                'dev_macs': ['d4:6a:91:bd:8c:0d'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:29:c8',
                'name': '38253NorthForkRd'
            },
            '74:83:c2:f0:29:cc': {
                'dev_macs': ['c8:9e:43:dc:8b:ce'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:29:cc',
                'name': '19108NicholsonFarmLn'
            },
            '74:83:c2:f0:2a:38': {
                'dev_macs': ['10:0c:6b:f7:57:de'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:2a:38',
                'name': '19821GreggsvilleRoad'
            },
            '74:83:c2:f0:30:f4': {
                'dev_macs': ['cc:40:d0:8b:14:bd'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:30:f4',
                'name': '19985ShelburneGlebeRd'
            },
            '74:83:c2:f0:31:00': {
                'dev_macs': ['94:18:65:6a:7f:ea'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:31:00',
                'name': '36675WoodDuckCt'
            },
            '74:83:c2:f0:31:34': {
                'dev_macs': ['78:45:58:3c:52:27'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:31:34',
                'name': '19165SwanCt'
            },
            '74:83:c2:f0:31:40': {
                'dev_macs': ['e8:da:00:15:f8:d9'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:31:40',
                'name': '38213NorthForkRd'
            },
            '74:83:c2:f0:31:50': {
                'dev_macs': ['8c:3b:ad:41:48:bc'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:31:50',
                'name': '19130PintailCt'
            },
            '74:83:c2:f0:3d:e0': {
                'dev_macs': ['28:80:88:d6:ea:5f'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:3d:e0',
                'name': '36448ShoemakerSchoolRd'
            },
            '74:83:c2:f0:3e:68': {
                'dev_macs': ['d0:17:c2:58:52:20'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:3e:68',
                'name': '19140PintailCt'
            },
            '74:83:c2:f0:3f:b4': {
                'dev_macs': ['28:80:88:43:ee:f4'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:3f:b4',
                'name': '38276HuntsEndPl'
            },
            '74:83:c2:f0:3f:d0': {
                'dev_macs': ['08:b4:b1:89:ba:86'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:3f:d0',
                'name': '19204LancerCircle'
            },
            '74:83:c2:f0:41:0c': {
                'dev_macs': ['78:8c:b5:3c:5d:41'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:41:0c',
                'name': '19275SwanCt'
            },
            '74:83:c2:f0:44:cc': {
                'dev_macs': ['38:94:ed:63:b2:20'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:44:cc',
                'name': '19827GreggsvilleRoad'
            },
            '74:83:c2:f0:46:08': {
                'dev_macs': ['68:d7:9a:d0:77:c5'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:46:08',
                'name': '19981GreggsvilleRoad'
            },
            '74:83:c2:f0:46:ac': {
                'dev_macs': ['54:af:97:50:00:e0'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:46:ac',
                'name': '19564GreggsvilleRd'
            },
            '74:83:c2:f0:50:68': {
                'dev_macs': ['2c:b0:5d:33:25:e1'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:50:68',
                'name': '19185PintailCt'
            },
            '74:83:c2:f0:54:d0': {
                'dev_macs': ['2c:b0:5d:49:d6:c1'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:54:d0',
                'name': '19060LincolnRoad-MilkHouse'
            },
            '74:83:c2:f0:54:e8': {
                'dev_macs': ['58:ef:68:44:55:b4'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:54:e8',
                'name': '19669LincolnRoad'
            },
            '74:83:c2:f0:55:00': {
                'dev_macs': ['f8:1a:2b:22:af:94'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:55:00',
                'name': '19600LincolnRoad'
            },
            '74:83:c2:f0:68:e4': {
                'dev_macs': ['34:98:b5:d4:80:7f'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:68:e4',
                'name': '37330WileyChaseLn'
            },
            '74:83:c2:f0:69:0c': {
                'dev_macs': ['00:14:f6:90:45:d1'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:69:0c',
                'name': '19179LancerCircle'
            },
            '74:83:c2:f0:69:68': {
                'dev_macs': ['08:36:c9:2d:84:f1', 'c0:74:ad:74:89:8e'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:69:68',
                'name': '19199LancerCircle'
            },
            '74:83:c2:f0:6d:48': {
                'dev_macs': ['78:8c:b5:11:fb:6f'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:6d:48',
                'name': '38085ForestMillsRd'
            },
            '74:83:c2:f0:6d:64': {
                'dev_macs': ['cc:f4:11:31:74:66'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:6d:64',
                'name': '38104NorthForkRd'
            },
            '74:83:c2:f0:6d:84': {
                'dev_macs': ['44:a5:6e:4d:c6:66'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:6d:84',
                'name': '38057ForestMillsRd'
            },
            '74:83:c2:f0:6d:8c': {
                'dev_macs': ['a0:04:60:cb:75:ec'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:6d:8c',
                'name': '19155LancerCircle'
            },
            '74:83:c2:f0:70:58': {
                'dev_macs': ['78:d2:94:3f:e6:4c'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:70:58',
                'name': '38359NorthForkRd'
            },
            '74:83:c2:f0:70:74': {
                'dev_macs': ['d0:21:f9:66:56:bf'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:70:74',
                'name': '19582GreggsvilleRoad'
            },
            '74:83:c2:f0:70:80': {
                'dev_macs': ['7c:d9:5c:9f:8d:6e'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:70:80',
                'name': '19348LancerCircle'
            },
            '74:83:c2:f0:70:98': {
                'dev_macs': ['c8:9e:43:5c:89:93'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:70:98',
                'name': '19987GreggsvilleRoad'
            },
            '74:ac:b9:99:e8:e2': {
                'dev_macs': [
                    '08:12:a5:7f:11:d9', 'c4:de:e2:d5:3d:04', '74:d8:3e:b7:d1:e9',
                    'dc:e5:5b:a3:ea:06', 'c2:1f:92:42:c4:fa', '0c:ee:99:3f:91:95',
                    '40:a2:db:85:74:8b', '30:89:4a:b2:60:65', 'ac:0b:fb:63:1f:6c',
                    '44:61:32:04:62:1d', '08:e9:f6:63:41:42', '46:52:68:8b:ab:d5',
                    '10:27:f5:a8:1c:e5', 'b8:13:32:e0:a3:4e', '24:41:8c:65:78:68',
                    'f0:de:f1:08:fb:85', 'c0:33:5e:63:74:11', 'ac:0b:fb:63:1e:90',
                    '8c:85:80:9e:9b:3d', '08:e9:f6:a7:1c:1e', '44:61:32:34:37:a7',
                    'd8:28:c9:8f:95:e6', '84:c7:ea:35:9f:c9', '44:61:32:82:33:76',
                    '80:f5:b5:8b:2e:b1', 'a0:ce:c8:fa:f1:48', 'dc:a6:32:0a:b8:1f',
                    '68:ec:8a:05:b5:57', '8c:85:80:bf:d2:0d', '66:9e:36:ba:4a:d5',
                    '14:f5:f9:fa:99:95', 'd8:28:c9:a3:96:e2', '1c:c1:de:6e:ea:75'
                ],
                'ip_address':
                None,
                'mac_address':
                '74:ac:b9:99:e8:e2',
                'name':
                'UBNTb999e8e2'
            },
            'd0:21:f9:9a:52:74': {
                'dev_macs': ['28:80:88:2a:29:8b'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:52:74',
                'name': '19976ShelburneGlebeRd'
            },
            'd0:21:f9:9a:63:98': {
                'dev_macs': ['40:ed:00:ad:d0:29'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:63:98',
                'name': '19151PintailCt'
            },
            'd0:21:f9:9a:64:90': {
                'dev_macs': ['44:a5:6e:55:57:56'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:64:90',
                'name': '38211NorthForkRd'
            },
            'd0:21:f9:9a:65:18': {
                'dev_macs': ['10:27:f5:16:c3:0a'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:18',
                'name': '19164PintailCt'
            },
            'd0:21:f9:9a:65:48': {
                'dev_macs': ['f0:9f:c2:ac:7c:b7'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:48',
                'name': '19116NicholsonFarmLn'
            },
            'd0:21:f9:9a:65:5c': {
                'dev_macs': ['e4:3a:65:17:44:56'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:5c',
                'name': '19260SwanCt'
            },
            'd0:21:f9:9a:65:70': {
                'dev_macs': ['54:af:97:02:c2:60'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:70',
                'name': '36460ShoemakerSchoolRd'
            },
            'd0:21:f9:9a:65:74': {
                'dev_macs': ['20:6d:31:31:65:a3'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:74',
                'name': '19184SwanCt'
            },
            'd0:21:f9:9a:65:84': {
                'dev_macs': ['34:98:b5:9a:84:7e'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:84',
                'name': '19040NicholsonFarmLn'
            },
            'd0:21:f9:9a:65:d0': {
                'dev_macs': ['70:81:05:aa:58:40'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:d0',
                'name': '36415ShoemakerSchoolRd'
            },
            'd0:21:f9:9a:66:68': {
                'dev_macs': ['3c:52:a1:19:13:59'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:66:68',
                'name': '19193PintailCt'
            },
            'd0:21:f9:9a:68:b0': {
                'dev_macs': ['10:0c:6b:56:3c:17'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:68:b0',
                'name': '36466ShoemakerSchoolRd'
            },
            'd0:21:f9:9a:69:d8': {
                'dev_macs': ['88:3d:24:7c:35:aa'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:69:d8',
                'name': '38244HuntsEndPl'
            },
            'd0:21:f9:9a:69:e4': {
                'dev_macs': ['38:94:ed:36:64:1e'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:69:e4',
                'name': '19192OaklandGreenRd'
            },
            'd0:21:f9:9a:6a:44': {
                'dev_macs': ['c0:c9:e3:8e:22:61'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:44',
                'name': '19328LincolnRd'
            },
            'd0:21:f9:9a:6a:64': {
                'dev_macs': ['e0:63:da:82:1d:fe'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:64',
                'name': '19150NicholsonFarmLn'
            },
            'd0:21:f9:9a:6a:88': {
                'dev_macs': [],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:88',
                'name': '38287NorthForkRd-Shed'
            },
            'd0:21:f9:9a:6a:90': {
                'dev_macs': ['b4:b0:24:87:39:f5'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:90',
                'name': '38287NorthForkRd-House'
            },
            'd0:21:f9:9a:6a:b4': {
                'dev_macs': ['54:af:97:4f:f3:bc'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:b4',
                'name': '19704GreggsvilleRoad'
            },
            'd0:21:f9:9a:6a:f0': {
                'dev_macs': ['54:af:97:4f:fe:74'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:f0',
                'name': '19906ShelburneGlebeRd'
            },
            'd0:21:f9:9a:6b:6c': {
                'dev_macs': ['54:af:97:4f:d4:f0'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6b:6c',
                'name': '19423LincolnRd'
            },
            'd0:21:f9:9a:6b:70': {
                'dev_macs': ['c8:7f:54:63:07:68'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6b:70',
                'name': '18783TelegraphSpringsRd'
            },
            'd0:21:f9:9a:6b:7c': {
                'dev_macs': ['cc:40:d0:50:ba:84'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6b:7c',
                'name': '19323OaklandGreenRd'
            },
            'd0:21:f9:9a:6b:ac': {
                'dev_macs': ['54:af:97:4f:c7:bc'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6b:ac',
                'name': '19970ShelburneGlebeRd'
            },
            'd0:21:f9:9a:6c:80': {
                'dev_macs': ['c8:7f:54:49:35:80'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6c:80',
                'name': '19514LincolnRd'
            },
            'd0:21:f9:9a:6c:e8': {
                'dev_macs': ['e8:9f:80:a5:e3:85'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6c:e8',
                'name': '19411ShelburneGlebeRoad'
            },
            'd0:21:f9:9a:6d:cc': {
                'dev_macs': ['c8:9e:43:bc:71:32'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6d:cc',
                'name': '38110GospondLn'
            },
            'd0:21:f9:9a:6e:24': {
                'dev_macs': ['e8:da:00:15:ab:c3'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6e:24',
                'name': '19269OaklandsGreenRd'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                32.0,
                'interfaces': [{
                    'admin_up': True,
                    'id': 'eth0',
                    'in_discards': '62497419',
                    'in_errors': '40957',
                    'in_nucast_pkts': '0',
                    'in_octets': '87605360817',
                    'in_ucast_pkts': '562563993',
                    'in_unknown_protos': '0',
                    'name': 'MGMT',
                    'oper_up': True,
                    'out_discards': '0',
                    'out_errors': '0',
                    'out_nucast_pkts': '0',
                    'out_octets': '210328930463',
                    'out_ucast_pkts': '362118407',
                    'poller_hash': 'YjRmYmU0NTA0YTQ3ZXRoMGludGY='
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon1',
                    'in_errors':
                    '0',
                    'in_octets':
                    '0',
                    'in_ucast_pkts':
                    '0',
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon1',
                    'oper_up':
                    False,
                    'out_errors':
                    '0',
                    'out_octets':
                    '34633628620',
                    'out_ucast_pkts':
                    '289511559',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uMWludGY=',
                    'pons': [{
                        'id': '1',
                        'max_distance': 20000,
                        'maximum_loss': -12.0,
                        'minimum_loss': -30.0,
                        'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysx',
                        'pon_technology': 'GPON',
                        'rx_link_rate': '1244160000',
                        'split_ratio': 128,
                        'tx_link_rate': '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon2',
                    'in_errors':
                    '0',
                    'in_octets':
                    '18861105900786',
                    'in_ucast_pkts':
                    '53057523128',
                    'links': [{
                        'bridged_mac_addresses': ['54:af:97:f8:b7:35'],
                        'in_octets': '100324308108',
                        'out_octets': '820035615528',
                        'poller_hash': 'NzQ4M2MyNjhlMDJicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['2c:30:33:60:5c:57'],
                        'in_octets': '139565314813',
                        'out_octets': '2996558436399',
                        'poller_hash': 'NzQ4M2MyNjhlMDdicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['68:d7:9a:5c:fa:4c'],
                        'in_octets': '132749350490',
                        'out_octets': '2646054293568',
                        'poller_hash': 'NzQ4M2MyNjhlMGExcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['14:59:c0:42:7d:3b'],
                        'in_octets': '244424999842',
                        'out_octets': '2186440045060',
                        'poller_hash': 'NzQ4M2MyNjhlMGIzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['30:34:22:09:59:a0'],
                        'in_octets': '1245160880098',
                        'out_octets': '5121959123389',
                        'poller_hash': 'NzQ4M2MyNjhlMGJmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['b4:b0:24:42:6e:5d'],
                        'in_octets': '119670939285',
                        'out_octets': '1494023287910',
                        'poller_hash': 'NzQ4M2MyNjhlMGRmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['a4:97:33:b0:73:d0'],
                        'in_octets': '56555672526',
                        'out_octets': '286769245927',
                        'poller_hash': 'NzQ4M2MyNjhlMTAwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['6c:cd:d6:03:8c:1f', 'a8:51:ab:95:30:9f'],
                        'in_octets':
                        '220206239381',
                        'out_octets':
                        '2521309511179',
                        'poller_hash':
                        'NzQ4M2MyNjhlMTEwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['04:42:1a:9a:fd:a0'],
                        'in_octets': '243091001033',
                        'out_octets': '4340435272320',
                        'poller_hash': 'NzQ4M2MyNjhlMTRhcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['78:d2:94:ab:9a:cd'],
                        'in_octets': '124236330502',
                        'out_octets': '1657403497298',
                        'poller_hash': 'NzQ4M2MyNjhlMjAycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['90:9a:4a:d0:74:1a', '9c:a2:f4:4e:5a:4d', 'c0:74:ad:74:89:cb'],
                        'in_octets':
                        '170671770826',
                        'out_octets':
                        '953751967501',
                        'poller_hash':
                        'NzQ4M2MyNjhlMjAzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:9e:43:b6:00:bf'],
                        'in_octets': '55062873390',
                        'out_octets': '1244149056605',
                        'poller_hash': 'NzQ4M2MyNjhlMmExcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['38:94:ed:b3:38:7a'],
                        'in_octets': '142162920578',
                        'out_octets': '3137160207456',
                        'poller_hash': 'NzQ4M2MyNjhlMmI3cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['14:91:82:71:43:86'],
                        'in_octets': '156238978100',
                        'out_octets': '2043343390962',
                        'poller_hash': 'NzQ4M2MyNjhlMmJkcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:d2:b2:81'],
                        'in_octets': '42324369713',
                        'out_octets': '614804305940',
                        'poller_hash': 'NzQ4M2MyNjhlMmM1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': [
                            'b4:b7:42:a0:04:ca', 'e0:63:da:25:0c:e8',
                            'e0:63:da:25:0c:e9', 'e0:63:da:73:04:04'
                        ],
                        'in_octets':
                        '47317801454',
                        'out_octets':
                        '1153229350068',
                        'poller_hash':
                        'NzQ4M2MyNjhlMzExcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:05:88:40:ef:31'],
                        'in_octets': '23711662173',
                        'out_octets': '146270831483',
                        'poller_hash': 'NzQ4M2MyNjhlMzIxcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['d8:47:32:98:46:73'],
                        'in_octets': '310042254680',
                        'out_octets': '6781398714211',
                        'poller_hash': 'NzQ4M2MyNjhlMzI1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:58:9d:ce'],
                        'in_octets': '867392745646',
                        'out_octets': '13890809517327',
                        'poller_hash': 'NzQ4M2MyNjhlMzJlcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:9e:43:a5:85:ee'],
                        'in_octets': '74580086771',
                        'out_octets': '3834216953694',
                        'poller_hash': 'NzQ4M2MyNjhlMzNhcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['6c:cd:d6:e1:de:09'],
                        'in_octets': '7789426259',
                        'out_octets': '84525278369',
                        'poller_hash': 'NzQ4M2MyNjhlMzUwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['3c:37:86:fb:37:1b'],
                        'in_octets': '48042507592',
                        'out_octets': '493138803253',
                        'poller_hash': 'NzQ4M2MyNjhlMzU0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['08:b4:b1:89:ba:86'],
                        'in_octets': '380791876350',
                        'out_octets': '3053223141963',
                        'poller_hash': 'NzQ4M2MyZjAzZmQwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:50:00:e0'],
                        'in_octets': '163682568555',
                        'out_octets': '2505658355768',
                        'poller_hash': 'NzQ4M2MyZjA0NmFjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['2c:b0:5d:49:d6:c1'],
                        'in_octets': '1377723100',
                        'out_octets': '27467042447',
                        'poller_hash': 'NzQ4M2MyZjA1NGQwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:14:f6:90:45:d1'],
                        'in_octets': '266497356947',
                        'out_octets': '1514329790933',
                        'poller_hash': 'NzQ4M2MyZjA2OTBjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['08:36:c9:2d:84:f1', 'c0:74:ad:74:89:8e'],
                        'in_octets':
                        '53380893648',
                        'out_octets':
                        '561107653217',
                        'poller_hash':
                        'NzQ4M2MyZjA2OTY4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['a0:04:60:cb:75:ec'],
                        'in_octets': '220258027678',
                        'out_octets': '3804670312341',
                        'poller_hash': 'NzQ4M2MyZjA2ZDhjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['7c:d9:5c:9f:8d:6e'],
                        'in_octets': '1457082746013',
                        'out_octets': '2762125828926',
                        'poller_hash': 'NzQ4M2MyZjA3MDgwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '181850517829583',
                    'out_ucast_pkts':
                    '142261491214',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uMmludGY=',
                    'pons': [{
                        'id':
                        '2',
                        'links': [{
                            'connected_time': '2759250',
                            'fiber_length': 7280,
                            'poller_hash': 'NzQ4M2MyNjhlMDJicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681701',
                            'fiber_length': 7682,
                            'poller_hash': 'NzQ4M2MyNjhlMDdicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7145418',
                            'fiber_length': 8543,
                            'poller_hash': 'NzQ4M2MyNjhlMGExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 8683,
                            'poller_hash': 'NzQ4M2MyNjhlMGIzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 7281,
                            'poller_hash': 'NzQ4M2MyNjhlMGJmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681699',
                            'fiber_length': 8658,
                            'poller_hash': 'NzQ4M2MyNjhlMGRmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '836113',
                            'fiber_length': 8602,
                            'poller_hash': 'NzQ4M2MyNjhlMTAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 8405,
                            'poller_hash': 'NzQ4M2MyNjhlMTEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7148288',
                            'fiber_length': 8000,
                            'poller_hash': 'NzQ4M2MyNjhlMTRhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6381381',
                            'fiber_length': 8129,
                            'poller_hash': 'NzQ4M2MyNjhlMjAycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7146208',
                            'fiber_length': 8411,
                            'poller_hash': 'NzQ4M2MyNjhlMjAzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4218443',
                            'fiber_length': 8084,
                            'poller_hash': 'NzQ4M2MyNjhlMmExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 7481,
                            'poller_hash': 'NzQ4M2MyNjhlMmI3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681701',
                            'fiber_length': 7201,
                            'poller_hash': 'NzQ4M2MyNjhlMmJkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7146288',
                            'fiber_length': 7332,
                            'poller_hash': 'NzQ4M2MyNjhlMmM1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 7574,
                            'poller_hash': 'NzQ4M2MyNjhlMzExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3588447',
                            'fiber_length': 8354,
                            'poller_hash': 'NzQ4M2MyNjhlMzIxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681701',
                            'fiber_length': 8032,
                            'poller_hash': 'NzQ4M2MyNjhlMzI1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8847462',
                            'fiber_length': 8516,
                            'poller_hash': 'NzQ4M2MyNjhlMzJlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7147428',
                            'fiber_length': 7166,
                            'poller_hash': 'NzQ4M2MyNjhlMzNhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833813',
                            'fiber_length': 8012,
                            'poller_hash': 'NzQ4M2MyNjhlMzUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '834653',
                            'fiber_length': 8447,
                            'poller_hash': 'NzQ4M2MyNjhlMzU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681699',
                            'fiber_length': 8653,
                            'poller_hash': 'NzQ4M2MyZjAzZmQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8847472',
                            'fiber_length': 7592,
                            'poller_hash': 'NzQ4M2MyZjA0NmFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '691952',
                            'fiber_length': 7976,
                            'poller_hash': 'NzQ4M2MyZjA1NGQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681691',
                            'fiber_length': 8458,
                            'poller_hash': 'NzQ4M2MyZjA2OTBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681741',
                            'fiber_length': 8467,
                            'poller_hash': 'NzQ4M2MyZjA2OTY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681691',
                            'fiber_length': 8285,
                            'poller_hash': 'NzQ4M2MyZjA2ZDhjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7147508',
                            'fiber_length': 8366,
                            'poller_hash': 'NzQ4M2MyZjA3MDgwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon3',
                    'in_errors':
                    '0',
                    'in_octets':
                    '8305785854059',
                    'in_ucast_pkts':
                    '23559095865',
                    'links': [{
                        'bridged_mac_addresses': [
                            '00:18:61:51:af:cd', '14:20:5e:05:d6:7a',
                            '18:b4:30:0c:45:20', '32:55:13:a6:c9:5a',
                            '38:b8:00:62:b8:49', '60:22:32:42:e8:f0',
                            '64:16:66:d5:76:95', '84:ea:ed:6a:fc:fe',
                            '9a:47:44:34:1e:83', 'bc:d7:d4:6a:e0:f0',
                            'c8:ff:77:4a:fb:76', 'cc:08:fa:60:33:84',
                            'e0:63:da:14:80:ee'
                        ],
                        'in_octets':
                        '135159672477',
                        'out_octets':
                        '4449250945461',
                        'poller_hash':
                        'MThlODI5MGI0MGIwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': [
                            '0a:cf:8d:4b:cd:a4', '18:16:c9:d9:44:bc',
                            '1c:53:f9:ac:14:0d', '1c:53:f9:b5:8e:56',
                            '20:1f:3b:7f:9e:08', '20:1f:3b:9a:8f:27',
                            '34:98:b5:a3:c0:9d', '34:98:b5:a4:43:33',
                            '34:98:b5:a4:44:77', '36:98:b5:a3:c0:a0',
                            '40:bd:32:6e:84:db', '64:cc:22:bf:07:61',
                            '64:cc:22:bf:08:11', '68:3e:26:ec:86:6e',
                            '68:fc:ca:b4:8e:d4', '9c:b6:d0:d6:16:d7',
                            'a4:bb:6d:5d:9f:a5', 'a8:a2:37:89:0c:19',
                            'a8:a2:37:89:0c:2d', 'aa:14:fa:68:96:0a',
                            'd8:d0:90:1c:c0:23', 'ee:61:84:68:12:3e'
                        ],
                        'in_octets':
                        '51362830391',
                        'out_octets':
                        '211228825396',
                        'poller_hash':
                        'MThlODI5MGI0MTIwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['0c:51:01:e2:25:46'],
                        'in_octets': '24321650043',
                        'out_octets': '409324676445',
                        'poller_hash': 'MThlODI5MGI0YjY0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['cc:40:d0:4d:3b:d0'],
                        'in_octets': '16611088826',
                        'out_octets': '350004142230',
                        'poller_hash': 'NzQ4M2MyNjhlMDg3cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:9e:43:c2:57:b6'],
                        'in_octets': '2080765286',
                        'out_octets': '20620738694',
                        'poller_hash': 'NzQ4M2MyNjhlMGVicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['b0:39:56:f5:46:06'],
                        'in_octets': '4215472299',
                        'out_octets': '26293224067',
                        'poller_hash': 'NzQ4M2MyNjhlMGZkcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:fa:30'],
                        'in_octets': '26904249977',
                        'out_octets': '95730254474',
                        'poller_hash': 'NzQ4M2MyNjhlMTcxcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['3c:37:86:69:e1:ad'],
                        'in_octets': '34168718507',
                        'out_octets': '1706048813812',
                        'poller_hash': 'NzQ4M2MyNjhlMTczcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['80:da:13:ac:5b:c1'],
                        'in_octets': '48278002484',
                        'out_octets': '757764942767',
                        'poller_hash': 'NzQ4M2MyNjhlMWExcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['78:d2:94:12:bd:4d', 'cc:f4:11:80:c8:97'],
                        'in_octets':
                        '49335455458',
                        'out_octets':
                        '695144533896',
                        'poller_hash':
                        'NzQ4M2MyNjhlMWFkcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:0f:d8:f5'],
                        'in_octets': '53982139677',
                        'out_octets': '766285594570',
                        'poller_hash': 'NzQ4M2MyNjhlMWQ0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:4b:fe:40:71:31'],
                        'in_octets': '523200308521',
                        'out_octets': '3860192578640',
                        'poller_hash': 'NzQ4M2MyNjhlMWZjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:d4:34'],
                        'in_octets': '40030214157',
                        'out_octets': '708880775335',
                        'poller_hash': 'NzQ4M2MyNjhlMWZmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:9e:43:ab:11:cd'],
                        'in_octets': '43335531017',
                        'out_octets': '177884781681',
                        'poller_hash': 'NzQ4M2MyNjhlMjk4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['28:87:ba:76:91:c1'],
                        'in_octets': '7069294602',
                        'out_octets': '308509214080',
                        'poller_hash': 'NzQ4M2MyNjhlMzRjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['00:ab:48:c5:87:e1', '74:83:c2:f5:fb:74'],
                        'in_octets':
                        '65073454145',
                        'out_octets':
                        '104838036906',
                        'poller_hash':
                        'NzQ4M2MyZjAyN2I0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['10:0c:6b:f7:57:de'],
                        'in_octets': '13348139927',
                        'out_octets': '191949510392',
                        'poller_hash': 'NzQ4M2MyZjAyYTM4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['38:94:ed:63:b2:20'],
                        'in_octets': '209604634055',
                        'out_octets': '4006844975783',
                        'poller_hash': 'NzQ4M2MyZjA0NGNjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['68:d7:9a:d0:77:c5'],
                        'in_octets': '3981305981',
                        'out_octets': '33589122215',
                        'poller_hash': 'NzQ4M2MyZjA0NjA4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['cc:f4:11:31:74:66'],
                        'in_octets': '232663434544',
                        'out_octets': '567256137139',
                        'poller_hash': 'NzQ4M2MyZjA2ZDY0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['78:d2:94:3f:e6:4c'],
                        'in_octets': '76445609371',
                        'out_octets': '487864309994',
                        'poller_hash': 'NzQ4M2MyZjA3MDU4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:9e:43:5c:89:93'],
                        'in_octets': '1190357340',
                        'out_octets': '9467383439',
                        'poller_hash': 'NzQ4M2MyZjA3MDk4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:f3:bc'],
                        'in_octets': '135928020386',
                        'out_octets': '1473137823819',
                        'poller_hash': 'ZDAyMWY5OWE2YWI0cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon3',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '79668035551272',
                    'out_ucast_pkts':
                    '60095606357',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uM2ludGY=',
                    'pons': [{
                        'id':
                        '3',
                        'links': [{
                            'connected_time': '17755237',
                            'fiber_length': 5292,
                            'poller_hash': 'MThlODI5MGI0MGIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '967264',
                            'fiber_length': 5238,
                            'poller_hash': 'MThlODI5MGI0MTIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8847472',
                            'fiber_length': 4002,
                            'poller_hash': 'MThlODI5MGI0YjY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2272,
                            'poller_hash': 'NzQ4M2MyNjhlMDg3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '698752',
                            'fiber_length': 3576,
                            'poller_hash': 'NzQ4M2MyNjhlMGVicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 1533,
                            'poller_hash': 'NzQ4M2MyNjhlMGZkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '835543',
                            'fiber_length': 4871,
                            'poller_hash': 'NzQ4M2MyNjhlMTcxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278473',
                            'fiber_length': 1462,
                            'poller_hash': 'NzQ4M2MyNjhlMTczcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833203',
                            'fiber_length': 4097,
                            'poller_hash': 'NzQ4M2MyNjhlMWExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833573',
                            'fiber_length': 4906,
                            'poller_hash': 'NzQ4M2MyNjhlMWFkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 1709,
                            'poller_hash': 'NzQ4M2MyNjhlMWQ0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '17755238',
                            'fiber_length': 3689,
                            'poller_hash': 'NzQ4M2MyNjhlMWZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2169,
                            'poller_hash': 'NzQ4M2MyNjhlMWZmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 4759,
                            'poller_hash': 'NzQ4M2MyNjhlMjk4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '700192',
                            'fiber_length': 3971,
                            'poller_hash': 'NzQ4M2MyNjhlMzRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '698752',
                            'fiber_length': 2645,
                            'poller_hash': 'NzQ4M2MyZjAyN2I0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1109896',
                            'fiber_length': 3984,
                            'poller_hash': 'NzQ4M2MyZjAyYTM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8847472',
                            'fiber_length': 3958,
                            'poller_hash': 'NzQ4M2MyZjA0NGNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '698751',
                            'fiber_length': 3508,
                            'poller_hash': 'NzQ4M2MyZjA0NjA4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3867460',
                            'fiber_length': 1748,
                            'poller_hash': 'NzQ4M2MyZjA2ZDY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2706,
                            'poller_hash': 'NzQ4M2MyZjA3MDU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '297008',
                            'fiber_length': 3586,
                            'poller_hash': 'NzQ4M2MyZjA3MDk4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8851422',
                            'fiber_length': 3712,
                            'poller_hash': 'ZDAyMWY5OWE2YWI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon4',
                    'in_errors':
                    '0',
                    'in_octets':
                    '20772955441921',
                    'in_ucast_pkts':
                    '42303149005',
                    'links': [{
                        'bridged_mac_addresses': ['34:60:f9:c1:b9:7d'],
                        'in_octets': '169608291315',
                        'out_octets': '570035358507',
                        'poller_hash': 'MThlODI5MGIzZjg4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['04:42:1a:18:75:70'],
                        'in_octets': '122683183',
                        'out_octets': '926611901',
                        'poller_hash': 'MThlODI5MGIzZmU0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': [
                            '40:16:3b:3d:4b:50', '48:a9:d2:72:42:77',
                            '9c:5a:44:c6:a3:43', '9c:5a:44:cb:37:23',
                            'd8:0d:17:f5:f5:50'
                        ],
                        'in_octets':
                        '27422530030',
                        'out_octets':
                        '1520521028270',
                        'poller_hash':
                        'MThlODI5MGI0MTk0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:17:c2:e1'],
                        'in_octets': '149294437544',
                        'out_octets': '1391468269599',
                        'poller_hash': 'MThlODI5MGI0MWU4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:12:12:8b'],
                        'in_octets': '125174916315',
                        'out_octets': '2700372723631',
                        'poller_hash': 'NzQ4M2MyNjhlMDNmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['6c:cd:d6:27:b4:fa'],
                        'in_octets': '19935658325',
                        'out_octets': '180597411818',
                        'poller_hash': 'NzQ4M2MyNjhlMDQycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:79:cd:05'],
                        'in_octets': '211824214312',
                        'out_octets': '455387477016',
                        'poller_hash': 'NzQ4M2MyNjhlMDU5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:e0:f0'],
                        'in_octets': '13603438797',
                        'out_octets': '90549708770',
                        'poller_hash': 'NzQ4M2MyNjhlMDc4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['30:34:22:21:73:21'],
                        'in_octets': '64076329101',
                        'out_octets': '1016967514777',
                        'poller_hash': 'NzQ4M2MyNjhlMDc5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['9c:c9:eb:f5:90:63'],
                        'in_octets': '66876520295',
                        'out_octets': '567773054791',
                        'poller_hash': 'NzQ4M2MyNjhlMGRjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['7c:d9:5c:99:1f:fc'],
                        'in_octets': '1465726649',
                        'out_octets': '16842167640',
                        'poller_hash': 'NzQ4M2MyNjhlMGUzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e8:48:b8:20:a9:5f'],
                        'in_octets': '2021512725',
                        'out_octets': '97688576095',
                        'poller_hash': 'NzQ4M2MyNjhlMGVjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:ac:b9:4e:87:ef'],
                        'in_octets': '115041542432',
                        'out_octets': '1369270068022',
                        'poller_hash': 'NzQ4M2MyNjhlMWNlcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:9e:43:67:5f:fb'],
                        'in_octets': '67611332935',
                        'out_octets': '1389158163103',
                        'poller_hash': 'NzQ4M2MyNjhlMmEzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:e2:ec'],
                        'in_octets': '117503972309',
                        'out_octets': '1778767070505',
                        'poller_hash': 'NzQ4M2MyNjhlMmI4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['44:a5:6e:63:3e:48'],
                        'in_octets': '185981422',
                        'out_octets': '1770806021',
                        'poller_hash': 'NzQ4M2MyNjhlMmU1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['18:90:88:a2:12:e1'],
                        'in_octets': '32730253043',
                        'out_octets': '279902687032',
                        'poller_hash': 'NzQ4M2MyNjhlMzM1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e8:9f:80:1c:82:49'],
                        'in_octets': '29668853091',
                        'out_octets': '208527310093',
                        'poller_hash': 'NzQ4M2MyNjhlMzQ5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['24:f5:a2:0a:88:9a'],
                        'in_octets': '12359817482',
                        'out_octets': '171373739719',
                        'poller_hash': 'NzQ4M2MyZjAyMDAwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['58:ef:68:44:55:b4'],
                        'in_octets': '5631465143',
                        'out_octets': '106886941423',
                        'poller_hash': 'NzQ4M2MyZjA1NGU4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['f8:1a:2b:22:af:94'],
                        'in_octets': '150564662047',
                        'out_octets': '271005948801',
                        'poller_hash': 'NzQ4M2MyZjA1NTAwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['78:8c:b5:11:fb:6f'],
                        'in_octets': '6157201296',
                        'out_octets': '40596015326',
                        'poller_hash': 'NzQ4M2MyZjA2ZDQ4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['44:a5:6e:4d:c6:66'],
                        'in_octets': '60262533659',
                        'out_octets': '77223524168',
                        'poller_hash': 'NzQ4M2MyZjA2ZDg0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['d0:21:f9:66:56:bf'],
                        'in_octets': '1187778998628',
                        'out_octets': '1496644684944',
                        'poller_hash': 'NzQ4M2MyZjA3MDc0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['88:3d:24:7c:35:aa'],
                        'in_octets': '105811370179',
                        'out_octets': '977788275924',
                        'poller_hash': 'ZDAyMWY5OWE2OWQ4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e8:9f:80:a5:e3:85'],
                        'in_octets': '17537411143',
                        'out_octets': '232152632390',
                        'poller_hash': 'ZDAyMWY5OWE2Y2U4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon4',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '120362762073301',
                    'out_ucast_pkts':
                    '98374756417',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uNGludGY=',
                    'pons': [{
                        'id':
                        '4',
                        'links': [{
                            'connected_time': '4997559',
                            'fiber_length': 11785,
                            'poller_hash': 'MThlODI5MGIzZjg4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '62516',
                            'fiber_length': 8103,
                            'poller_hash': 'MThlODI5MGIzZmU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4885089',
                            'fiber_length': 8315,
                            'poller_hash': 'MThlODI5MGI0MTk0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3080213',
                            'fiber_length': 11743,
                            'poller_hash': 'MThlODI5MGI0MWU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997149',
                            'fiber_length': 11893,
                            'poller_hash': 'NzQ4M2MyNjhlMDNmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '835173',
                            'fiber_length': 11715,
                            'poller_hash': 'NzQ4M2MyNjhlMDQycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2853541',
                            'fiber_length': 8473,
                            'poller_hash': 'NzQ4M2MyNjhlMDU5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 8543,
                            'poller_hash': 'NzQ4M2MyNjhlMDc4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 8138,
                            'poller_hash': 'NzQ4M2MyNjhlMDc5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681691',
                            'fiber_length': 8668,
                            'poller_hash': 'NzQ4M2MyNjhlMGRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146986',
                            'fiber_length': 8878,
                            'poller_hash': 'NzQ4M2MyNjhlMGUzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146986',
                            'fiber_length': 9210,
                            'poller_hash': 'NzQ4M2MyNjhlMGVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681701',
                            'fiber_length': 7755,
                            'poller_hash': 'NzQ4M2MyNjhlMWNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 8679,
                            'poller_hash': 'NzQ4M2MyNjhlMmEzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5019760',
                            'fiber_length': 11944,
                            'poller_hash': 'NzQ4M2MyNjhlMmI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146987',
                            'fiber_length': 8807,
                            'poller_hash': 'NzQ4M2MyNjhlMmU1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 10288,
                            'poller_hash': 'NzQ4M2MyNjhlMzM1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '184477',
                            'fiber_length': 11970,
                            'poller_hash': 'NzQ4M2MyNjhlMzQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '836243',
                            'fiber_length': 8558,
                            'poller_hash': 'NzQ4M2MyZjAyMDAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '835503',
                            'fiber_length': 8733,
                            'poller_hash': 'NzQ4M2MyZjA1NGU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278473',
                            'fiber_length': 9676,
                            'poller_hash': 'NzQ4M2MyZjA1NTAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146986',
                            'fiber_length': 9617,
                            'poller_hash': 'NzQ4M2MyZjA2ZDQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146987',
                            'fiber_length': 9320,
                            'poller_hash': 'NzQ4M2MyZjA2ZDg0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6027238',
                            'fiber_length': 7867,
                            'poller_hash': 'NzQ4M2MyZjA3MDc0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997330',
                            'fiber_length': 11833,
                            'poller_hash': 'ZDAyMWY5OWE2OWQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3936880',
                            'fiber_length': 11288,
                            'poller_hash': 'ZDAyMWY5OWE2Y2U4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon5',
                    'in_errors':
                    '0',
                    'in_octets':
                    '967252330512',
                    'in_ucast_pkts':
                    '2576787019',
                    'links': [{
                        'bridged_mac_addresses': ['90:9a:4a:cd:e0:b9'],
                        'in_octets': '14048582668',
                        'out_octets': '274624776323',
                        'poller_hash': 'NzQ4M2MyZjAyOWI4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['94:18:65:6a:7f:ea'],
                        'in_octets': '16131852330',
                        'out_octets': '63721866874',
                        'poller_hash': 'NzQ4M2MyZjAzMTAwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['78:45:58:3c:52:27'],
                        'in_octets': '9657226005',
                        'out_octets': '84954144187',
                        'poller_hash': 'NzQ4M2MyZjAzMTM0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['8c:3b:ad:41:48:bc'],
                        'in_octets': '3182441623',
                        'out_octets': '39905129205',
                        'poller_hash': 'NzQ4M2MyZjAzMTUwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['28:80:88:d6:ea:5f'],
                        'in_octets': '20265296969',
                        'out_octets': '282946260150',
                        'poller_hash': 'NzQ4M2MyZjAzZGUwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['d0:17:c2:58:52:20'],
                        'in_octets': '110700458158',
                        'out_octets': '444936869400',
                        'poller_hash': 'NzQ4M2MyZjAzZTY4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['78:8c:b5:3c:5d:41'],
                        'in_octets': '35662411941',
                        'out_octets': '291731428977',
                        'poller_hash': 'NzQ4M2MyZjA0MTBjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['2c:b0:5d:33:25:e1'],
                        'in_octets': '6970348369',
                        'out_octets': '49129075877',
                        'poller_hash': 'NzQ4M2MyZjA1MDY4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['40:ed:00:ad:d0:29'],
                        'in_octets': '67829562804',
                        'out_octets': '983279540878',
                        'poller_hash': 'ZDAyMWY5OWE2Mzk4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['10:27:f5:16:c3:0a'],
                        'in_octets': '13102342619',
                        'out_octets': '160422727981',
                        'poller_hash': 'ZDAyMWY5OWE2NTE4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['f0:9f:c2:ac:7c:b7'],
                        'in_octets': '69955251863',
                        'out_octets': '1286202225421',
                        'poller_hash': 'ZDAyMWY5OWE2NTQ4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e4:3a:65:17:44:56'],
                        'in_octets': '1814409027',
                        'out_octets': '38626237646',
                        'poller_hash': 'ZDAyMWY5OWE2NTVjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:02:c2:60'],
                        'in_octets': '61292469972',
                        'out_octets': '958724239744',
                        'poller_hash': 'ZDAyMWY5OWE2NTcwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['20:6d:31:31:65:a3'],
                        'in_octets': '55038145877',
                        'out_octets': '261383580621',
                        'poller_hash': 'ZDAyMWY5OWE2NTc0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['70:81:05:aa:58:40'],
                        'in_octets': '39318486675',
                        'out_octets': '314294341270',
                        'poller_hash': 'ZDAyMWY5OWE2NWQwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['3c:52:a1:19:13:59'],
                        'in_octets': '52196691090',
                        'out_octets': '1052726516247',
                        'poller_hash': 'ZDAyMWY5OWE2NjY4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['10:0c:6b:56:3c:17'],
                        'in_octets': '18167547944',
                        'out_octets': '140582636676',
                        'poller_hash': 'ZDAyMWY5OWE2OGIwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti '
                    'Inc.',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon5',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '9951011981792',
                    'out_ucast_pkts':
                    '7950435012',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uNWludGY=',
                    'pons': [{
                        'id':
                        '5',
                        'links': [{
                            'connected_time': '834233',
                            'fiber_length': 15791,
                            'poller_hash': 'NzQ4M2MyZjAyOWI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833443',
                            'fiber_length': 15424,
                            'poller_hash': 'NzQ4M2MyZjAzMTAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '677602',
                            'fiber_length': 15356,
                            'poller_hash': 'NzQ4M2MyZjAzMTM0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '62106',
                            'fiber_length': 15746,
                            'poller_hash': 'NzQ4M2MyZjAzMTUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '834343',
                            'fiber_length': 16109,
                            'poller_hash': 'NzQ4M2MyZjAzZGUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1557720',
                            'fiber_length': 16027,
                            'poller_hash': 'NzQ4M2MyZjAzZTY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '950444',
                            'fiber_length': 15781,
                            'poller_hash': 'NzQ4M2MyZjA0MTBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2661429',
                            'fiber_length': 16093,
                            'poller_hash': 'NzQ4M2MyZjA1MDY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2661889',
                            'fiber_length': 15923,
                            'poller_hash': 'ZDAyMWY5OWE2Mzk4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833623',
                            'fiber_length': 15882,
                            'poller_hash': 'ZDAyMWY5OWE2NTE4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2764900',
                            'fiber_length': 15566,
                            'poller_hash': 'ZDAyMWY5OWE2NTQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '314588',
                            'fiber_length': 15682,
                            'poller_hash': 'ZDAyMWY5OWE2NTVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2566168',
                            'fiber_length': 16111,
                            'poller_hash': 'ZDAyMWY5OWE2NTcwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '948054',
                            'fiber_length': 15322,
                            'poller_hash': 'ZDAyMWY5OWE2NTc0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2662229',
                            'fiber_length': 15780,
                            'poller_hash': 'ZDAyMWY5OWE2NWQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2160565',
                            'fiber_length': 16158,
                            'poller_hash': 'ZDAyMWY5OWE2NjY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2144715',
                            'fiber_length': 16191,
                            'poller_hash': 'ZDAyMWY5OWE2OGIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon6',
                    'in_errors':
                    '0',
                    'in_octets':
                    '11550533961586',
                    'in_ucast_pkts':
                    '27732987643',
                    'links': [{
                        'bridged_mac_addresses': ['48:22:54:38:18:95'],
                        'in_octets': '64682686650',
                        'out_octets': '1378430172533',
                        'poller_hash': 'MThlODI5MGIzZmYwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': [
                            '08:12:a5:7f:11:d9', 'c4:de:e2:d5:3d:04',
                            '74:d8:3e:b7:d1:e9', 'dc:e5:5b:a3:ea:06',
                            'c2:1f:92:42:c4:fa', '0c:ee:99:3f:91:95',
                            '40:a2:db:85:74:8b', '30:89:4a:b2:60:65',
                            'ac:0b:fb:63:1f:6c', '44:61:32:04:62:1d',
                            '08:e9:f6:63:41:42', '46:52:68:8b:ab:d5',
                            '10:27:f5:a8:1c:e5', 'b8:13:32:e0:a3:4e',
                            '24:41:8c:65:78:68', 'f0:de:f1:08:fb:85',
                            'c0:33:5e:63:74:11', 'ac:0b:fb:63:1e:90',
                            '8c:85:80:9e:9b:3d', '08:e9:f6:a7:1c:1e',
                            '44:61:32:34:37:a7', 'd8:28:c9:8f:95:e6',
                            '84:c7:ea:35:9f:c9', '44:61:32:82:33:76',
                            '80:f5:b5:8b:2e:b1', 'a0:ce:c8:fa:f1:48',
                            'dc:a6:32:0a:b8:1f', '68:ec:8a:05:b5:57',
                            '8c:85:80:bf:d2:0d', '66:9e:36:ba:4a:d5',
                            '14:f5:f9:fa:99:95', 'd8:28:c9:a3:96:e2',
                            '1c:c1:de:6e:ea:75'
                        ],
                        'in_octets':
                        '58935837394',
                        'out_octets':
                        '103243505750',
                        'poller_hash':
                        'NzRhY2I5OTllOGUycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['34:98:b5:a3:e7:e5'],
                        'in_octets': '97716269138',
                        'out_octets': '542051877093',
                        'poller_hash': 'NzQ4M2MyNjhlMDQzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['34:60:f9:5d:75:d9'],
                        'in_octets': '166413636836',
                        'out_octets': '804364868742',
                        'poller_hash': 'NzQ4M2MyNjhlMDUwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e0:b2:60:30:36:f9'],
                        'in_octets': '33046972656',
                        'out_octets': '299499908771',
                        'poller_hash': 'NzQ4M2MyNjhlMTc3cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:9e:43:9c:0d:5a'],
                        'in_octets': '28410002462',
                        'out_octets': '581947443928',
                        'poller_hash': 'NzQ4M2MyNjhlMWJicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['38:94:ed:43:ac:3d'],
                        'in_octets': '35219493695',
                        'out_octets': '339625360998',
                        'poller_hash': 'NzQ4M2MyNjhlMWNicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:fe:24'],
                        'in_octets': '50812142746',
                        'out_octets': '562509529652',
                        'poller_hash': 'NzQ4M2MyNjhlMWNkcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['1c:61:b4:b1:23:c5'],
                        'in_octets': '137985309916',
                        'out_octets': '1198772314150',
                        'poller_hash': 'NzQ4M2MyNjhlMzMycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['3c:37:86:14:45:65'],
                        'in_octets': '51831183827',
                        'out_octets': '489216405112',
                        'poller_hash': 'NzQ4M2MyNjhlMzNicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:9e:43:dc:8b:ce'],
                        'in_octets': '39274623155',
                        'out_octets': '409019139729',
                        'poller_hash': 'NzQ4M2MyZjAyOWNjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['28:80:88:43:ee:f4'],
                        'in_octets': '150142253877',
                        'out_octets': '1611139413248',
                        'poller_hash': 'NzQ4M2MyZjAzZmI0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['34:98:b5:d4:80:7f'],
                        'in_octets': '29177723323',
                        'out_octets': '773416988603',
                        'poller_hash': 'NzQ4M2MyZjA2OGU0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['34:98:b5:9a:84:7e'],
                        'in_octets': '17546018017',
                        'out_octets': '443085698340',
                        'poller_hash': 'ZDAyMWY5OWE2NTg0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['38:94:ed:36:64:1e'],
                        'in_octets': '9572622904',
                        'out_octets': '89696434174',
                        'poller_hash': 'ZDAyMWY5OWE2OWU0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c0:c9:e3:8e:22:61'],
                        'in_octets': '95782914966',
                        'out_octets': '521901715225',
                        'poller_hash': 'ZDAyMWY5OWE2YTQ0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e0:63:da:82:1d:fe'],
                        'in_octets': '18239730929',
                        'out_octets': '156793311470',
                        'poller_hash': 'ZDAyMWY5OWE2YTY0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:d4:f0'],
                        'in_octets': '65745451819',
                        'out_octets': '1629541492753',
                        'poller_hash': 'ZDAyMWY5OWE2YjZjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:7f:54:63:07:68'],
                        'in_octets': '204582276691',
                        'out_octets': '1991524037999',
                        'poller_hash': 'ZDAyMWY5OWE2YjcwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['cc:40:d0:50:ba:84'],
                        'in_octets': '467525045560',
                        'out_octets': '208972267153',
                        'poller_hash': 'ZDAyMWY5OWE2YjdjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:7f:54:49:35:80'],
                        'in_octets': '310969088212',
                        'out_octets': '2905404066142',
                        'poller_hash': 'ZDAyMWY5OWE2YzgwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c8:9e:43:bc:71:32'],
                        'in_octets': '58344509241',
                        'out_octets': '604577138728',
                        'poller_hash': 'ZDAyMWY5OWE2ZGNjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e8:da:00:15:ab:c3'],
                        'in_octets': '124994783885',
                        'out_octets': '3100243215818',
                        'poller_hash': 'ZDAyMWY5OWE2ZTI0cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon6',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '75652798030021',
                    'out_ucast_pkts':
                    '60433007684',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uNmludGY=',
                    'pons': [{
                        'id':
                        '6',
                        'links': [{
                            'connected_time': '3244914',
                            'fiber_length': 12060,
                            'poller_hash': 'MThlODI5MGIzZmYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833693',
                            'fiber_length': 12030,
                            'poller_hash': 'NzRhY2I5OTllOGUycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 11596,
                            'poller_hash': 'NzQ4M2MyNjhlMDQzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7144038',
                            'fiber_length': 11983,
                            'poller_hash': 'NzQ4M2MyNjhlMDUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 11159,
                            'poller_hash': 'NzQ4M2MyNjhlMTc3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 11311,
                            'poller_hash': 'NzQ4M2MyNjhlMWJicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997559',
                            'fiber_length': 12072,
                            'poller_hash': 'NzQ4M2MyNjhlMWNicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3887420',
                            'fiber_length': 11077,
                            'poller_hash': 'NzQ4M2MyNjhlMWNkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 11218,
                            'poller_hash': 'NzQ4M2MyNjhlMzMycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 12015,
                            'poller_hash': 'NzQ4M2MyNjhlMzNicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833613',
                            'fiber_length': 12446,
                            'poller_hash': 'NzQ4M2MyZjAyOWNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997559',
                            'fiber_length': 11484,
                            'poller_hash': 'NzQ4M2MyZjAzZmI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2207095',
                            'fiber_length': 7900,
                            'poller_hash': 'NzQ4M2MyZjA2OGU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2761630',
                            'fiber_length': 12737,
                            'poller_hash': 'ZDAyMWY5OWE2NTg0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '665452',
                            'fiber_length': 10818,
                            'poller_hash': 'ZDAyMWY5OWE2OWU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 10967,
                            'poller_hash': 'ZDAyMWY5OWE2YTQ0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833133',
                            'fiber_length': 12496,
                            'poller_hash': 'ZDAyMWY5OWE2YTY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 8265,
                            'poller_hash': 'ZDAyMWY5OWE2YjZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4069192',
                            'fiber_length': 9924,
                            'poller_hash': 'ZDAyMWY5OWE2YjcwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 10882,
                            'poller_hash': 'ZDAyMWY5OWE2YjdjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7147668',
                            'fiber_length': 11413,
                            'poller_hash': 'ZDAyMWY5OWE2YzgwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997559',
                            'fiber_length': 10202,
                            'poller_hash': 'ZDAyMWY5OWE2ZGNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997559',
                            'fiber_length': 11279,
                            'poller_hash': 'ZDAyMWY5OWE2ZTI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon7',
                    'in_errors':
                    '0',
                    'in_octets':
                    '2094095155860',
                    'in_ucast_pkts':
                    '8314183386',
                    'links': [{
                        'bridged_mac_addresses': ['78:d2:94:c3:e5:89'],
                        'in_octets': '21520436418',
                        'out_octets': '969079701468',
                        'poller_hash': 'NzQ4M2MyNjhlMDkzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['40:ed:00:43:69:94'],
                        'in_octets': '18157842209',
                        'out_octets': '347983704827',
                        'poller_hash': 'NzQ4M2MyNjhlMWNhcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e8:da:00:15:b6:5b'],
                        'in_octets': '23950416454',
                        'out_octets': '638499111925',
                        'poller_hash': 'NzQ4M2MyNjhlMWQ1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['38:94:ed:69:f0:aa'],
                        'in_octets': '19653761561',
                        'out_octets': '881262437368',
                        'poller_hash': 'NzQ4M2MyNjhlMWY0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e8:da:00:15:d7:f7'],
                        'in_octets': '5828413357',
                        'out_octets': '82279656275',
                        'poller_hash': 'NzQ4M2MyNjhlMjFicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['08:36:c9:7c:52:ab'],
                        'in_octets': '10753248487',
                        'out_octets': '278751320357',
                        'poller_hash': 'NzQ4M2MyZjAyNzU4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['34:98:b5:73:34:ea'],
                        'in_octets': '802491631',
                        'out_octets': '8344825064',
                        'poller_hash': 'NzQ4M2MyZjAyOTBjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['d4:6a:91:bd:8c:0d'],
                        'in_octets': '23627117702',
                        'out_octets': '127421559740',
                        'poller_hash': 'NzQ4M2MyZjAyOWM4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['cc:40:d0:8b:14:bd'],
                        'in_octets': '6684940984',
                        'out_octets': '133989600571',
                        'poller_hash': 'NzQ4M2MyZjAzMGY0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['e8:da:00:15:f8:d9'],
                        'in_octets': '51032775231',
                        'out_octets': '546286601691',
                        'poller_hash': 'NzQ4M2MyZjAzMTQwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['28:80:88:2a:29:8b'],
                        'in_octets': '28129386784',
                        'out_octets': '486241716971',
                        'poller_hash': 'ZDAyMWY5OWE1Mjc0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['44:a5:6e:55:57:56'],
                        'in_octets': '336605294975',
                        'out_octets': '689704574249',
                        'poller_hash': 'ZDAyMWY5OWE2NDkwcGVlcmludGY='
                    }, {
                        'in_octets': '94',
                        'out_octets': '0',
                        'poller_hash': 'ZDAyMWY5OWE2YTg4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['b4:b0:24:87:39:f5'],
                        'in_octets': '160497034318',
                        'out_octets': '3762863382520',
                        'poller_hash': 'ZDAyMWY5OWE2YTkwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:fe:74'],
                        'in_octets': '30002950143',
                        'out_octets': '299600356873',
                        'poller_hash': 'ZDAyMWY5OWE2YWYwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['54:af:97:4f:c7:bc'],
                        'in_octets': '28674891079',
                        'out_octets': '327293401453',
                        'poller_hash': 'ZDAyMWY5OWE2YmFjcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti '
                    'Inc.',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon7',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '28736899884549',
                    'out_ucast_pkts':
                    '21657911520',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uN2ludGY=',
                    'pons': [{
                        'id':
                        '7',
                        'links': [{
                            'connected_time': '4261533',
                            'fiber_length': 2762,
                            'poller_hash': 'NzQ4M2MyNjhlMDkzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2306656',
                            'fiber_length': 3260,
                            'poller_hash': 'NzQ4M2MyNjhlMWNhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 2626,
                            'poller_hash': 'NzQ4M2MyNjhlMWQ1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278413',
                            'fiber_length': 1900,
                            'poller_hash': 'NzQ4M2MyNjhlMWY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833603',
                            'fiber_length': 2367,
                            'poller_hash': 'NzQ4M2MyNjhlMjFicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4056632',
                            'fiber_length': 2305,
                            'poller_hash': 'NzQ4M2MyZjAyNzU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2388,
                            'poller_hash': 'NzQ4M2MyZjAyOTBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '423039',
                            'fiber_length': 3392,
                            'poller_hash': 'NzQ4M2MyZjAyOWM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '834323',
                            'fiber_length': 2271,
                            'poller_hash': 'NzQ4M2MyZjAzMGY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2491318',
                            'fiber_length': 3308,
                            'poller_hash': 'NzQ4M2MyZjAzMTQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2559,
                            'poller_hash': 'ZDAyMWY5OWE1Mjc0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2569389',
                            'fiber_length': 2462,
                            'poller_hash': 'ZDAyMWY5OWE2NDkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2679,
                            'poller_hash': 'ZDAyMWY5OWE2YTg4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7146988',
                            'fiber_length': 2619,
                            'poller_hash': 'ZDAyMWY5OWE2YTkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '510630',
                            'fiber_length': 2599,
                            'poller_hash': 'ZDAyMWY5OWE2YWYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 2577,
                            'poller_hash': 'ZDAyMWY5OWE2YmFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon8',
                    'in_errors':
                    '0',
                    'in_octets':
                    '0',
                    'in_ucast_pkts':
                    '0',
                    'model':
                    '',
                    'name':
                    'pon8',
                    'oper_up':
                    False,
                    'out_errors':
                    '0',
                    'out_octets':
                    '34633628620',
                    'out_ucast_pkts':
                    '289511559',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uOGludGY=',
                    'pons': [{
                        'id': '8',
                        'max_distance': 20000,
                        'maximum_loss': -12.0,
                        'minimum_loss': -30.0,
                        'poller_hash': 'YjRmYmU0NTA0YTQ3OA==',
                        'pon_technology': 'GPON',
                        'rx_link_rate': '1244160000',
                        'split_ratio': 128,
                        'tx_link_rate': '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp1',
                    'in_octets': '64999563447566',
                    'in_ucast_pkts': '389399718721',
                    'manufacturer': 'OEM',
                    'model': 'SFP-H10GB-CU1M',
                    'name': 'SFP+ 1',
                    'oper_up': True,
                    'out_octets': '62111558741541',
                    'out_ucast_pkts': '157639782479',
                    'poller_hash': 'YjRmYmU0NTA0YTQ3c2ZwMWludGY=',
                    'speed': '10000000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp2',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'SFP+ 2',
                    'oper_up': False,
                    'out_octets': '0',
                    'out_ucast_pkts': '0',
                    'poller_hash': 'YjRmYmU0NTA0YTQ3c2ZwMmludGY='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                22.0,
                'model':
                'UFiber OLT',
                'serial_number':
                'UBNTe4504a47',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'b4:fb:e4:50:4a:47',
                'temperature':
                38.5,
                'uptime':
                '17755358'
            },
            'peers': [{
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '820035615528',
                    'links': [{
                        'in_octets': '820035615528',
                        'out_octets': '100324308108',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '100324308108',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDJicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2759250',
                            'fiber_length': 7280,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.746,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.842
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDJicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '100324308108',
                    'mac_address': '74:83:c2:69:e0:2b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '820035615528',
                    'poller_hash': 'NzQ4M2MyNjhlMDJiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19369LancerCircle',
                'serial_number':
                'UBNTc268e02b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:2b',
                'temperature':
                43.0,
                'uptime':
                '2759298'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2996558436399',
                    'links': [{
                        'in_octets': '2996558436399',
                        'out_octets': '139565314813',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '139565314813',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDdicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681701',
                            'fiber_length': 7682,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.108,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.438
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDdicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '139565314813',
                    'mac_address': '74:83:c2:69:e0:7b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2996558436399',
                    'poller_hash': 'NzQ4M2MyNjhlMDdiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19163LincolnRd',
                'serial_number':
                'UBNTc268e07b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:7b',
                'temperature':
                45.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2646054293568',
                    'links': [{
                        'in_octets': '2646054293568',
                        'out_octets': '132749350490',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '132749350490',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGExcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7145418',
                            'fiber_length': 8543,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.022,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.624
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMGExcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '132749350490',
                    'mac_address': '74:83:c2:69:e0:a1',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2646054293568',
                    'poller_hash': 'NzQ4M2MyNjhlMGExZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19320LancerCircle',
                'serial_number':
                'UBNTc268e0a1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:a1',
                'temperature':
                45.0,
                'uptime':
                '7145456'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2186440045060',
                    'links': [{
                        'in_octets': '2186440045060',
                        'out_octets': '244424999842',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '244424999842',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGIzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 8683,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.136,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.18
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMGIzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '244424999842',
                    'mac_address': '74:83:c2:69:e0:b3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2186440045060',
                    'poller_hash': 'NzQ4M2MyNjhlMGIzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19231LancerCircle',
                'serial_number':
                'UBNTc268e0b3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:b3',
                'temperature':
                43.0,
                'uptime':
                '8681748'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '5121959123389',
                    'links': [{
                        'in_octets': '5121959123389',
                        'out_octets': '1245160880098',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1245160880098',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGJmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 7281,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.544,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.892
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMGJmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '1245160880098',
                    'mac_address': '74:83:c2:69:e0:bf',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '5121959123389',
                    'poller_hash': 'NzQ4M2MyNjhlMGJmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19203LincolnRoad',
                'serial_number':
                'UBNTc268e0bf',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:bf',
                'temperature':
                46.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1494023287910',
                    'links': [{
                        'in_octets': '1494023287910',
                        'out_octets': '119670939285',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '119670939285',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGRmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681699',
                            'fiber_length': 8658,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.398,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.63
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMGRmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '119670939285',
                    'mac_address': '74:83:c2:69:e0:df',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1494023287910',
                    'poller_hash': 'NzQ4M2MyNjhlMGRmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19243LancerCircle',
                'serial_number':
                'UBNTc268e0df',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:df',
                'temperature':
                45.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '286769245927',
                    'links': [{
                        'in_octets': '286769245927',
                        'out_octets': '56555672526',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '56555672526',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTAwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '836113',
                            'fiber_length': 8602,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.826,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.308
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMTAwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '56555672526',
                    'mac_address': '74:83:c2:69:e1:00',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '286769245927',
                    'poller_hash': 'NzQ4M2MyNjhlMTAwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19110LancerCircle',
                'serial_number':
                'UBNTc268e100',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:00',
                'temperature':
                45.0,
                'uptime':
                '836156'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2521309511179',
                    'links': [{
                        'in_octets': '2521309511179',
                        'out_octets': '220206239381',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '220206239381',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTEwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 8405,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.808,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.556
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMTEwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '220206239381',
                    'mac_address': '74:83:c2:69:e1:10',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2521309511179',
                    'poller_hash': 'NzQ4M2MyNjhlMTEwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19167LancerCircle',
                'serial_number':
                'UBNTc268e110',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:10',
                'temperature':
                46.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4340435272320',
                    'links': [{
                        'in_octets': '4340435272320',
                        'out_octets': '243091001033',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '243091001033',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTRhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7148288',
                            'fiber_length': 8000,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.108,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.644
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMTRhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '243091001033',
                    'mac_address': '74:83:c2:69:e1:4a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4340435272320',
                    'poller_hash': 'NzQ4M2MyNjhlMTRhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19061LancerCircle',
                'serial_number':
                'UBNTc268e14a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:4a',
                'temperature':
                40.0,
                'uptime':
                '7148328'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1657403497298',
                    'links': [{
                        'in_octets': '1657403497298',
                        'out_octets': '124236330502',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '124236330502',
                    'poller_hash':
                    'NzQ4M2MyNjhlMjAycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '6381381',
                            'fiber_length': 8129,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.632,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.806
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMjAycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '124236330502',
                    'mac_address': '74:83:c2:69:e2:02',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1657403497298',
                    'poller_hash': 'NzQ4M2MyNjhlMjAyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19430LancerCir',
                'serial_number':
                'UBNTc268e202',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:02',
                'temperature':
                46.0,
                'uptime':
                '6381423'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '953751967501',
                    'links': [{
                        'in_octets': '953751967501',
                        'out_octets': '170671770826',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '170671770826',
                    'poller_hash':
                    'NzQ4M2MyNjhlMjAzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7146208',
                            'fiber_length': 8411,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.0,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.088
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMjAzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '170671770826',
                    'mac_address': '74:83:c2:69:e2:03',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '953751967501',
                    'poller_hash': 'NzQ4M2MyNjhlMjAzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19080LancerCircle',
                'serial_number':
                'UBNTc268e203',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:03',
                'temperature':
                43.0,
                'uptime':
                '7146250'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1244149056605',
                    'links': [{
                        'in_octets': '1244149056605',
                        'out_octets': '55062873390',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '55062873390',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmExcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4218443',
                            'fiber_length': 8084,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.242,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.066
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMmExcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '55062873390',
                    'mac_address': '74:83:c2:69:e2:a1',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1244149056605',
                    'poller_hash': 'NzQ4M2MyNjhlMmExZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19070LincolnRoad',
                'serial_number':
                'UBNTc268e2a1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:a1',
                'temperature':
                36.0,
                'uptime':
                '4218486'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3137160207456',
                    'links': [{
                        'in_octets': '3137160207456',
                        'out_octets': '142162920578',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '142162920578',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmI3cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 7481,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.01,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.692
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMmI3cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '142162920578',
                    'mac_address': '74:83:c2:69:e2:b7',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3137160207456',
                    'poller_hash': 'NzQ4M2MyNjhlMmI3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19221LincolnRd',
                'serial_number':
                'UBNTc268e2b7',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:b7',
                'temperature':
                41.0,
                'uptime':
                '8681748'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2043343390962',
                    'links': [{
                        'in_octets': '2043343390962',
                        'out_octets': '156238978100',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '156238978100',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmJkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681701',
                            'fiber_length': 7201,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.28,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.07
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMmJkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '156238978100',
                    'mac_address': '74:83:c2:69:e2:bd',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2043343390962',
                    'poller_hash': 'NzQ4M2MyNjhlMmJkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19209LincolnRoad',
                'serial_number':
                'UBNTc268e2bd',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:bd',
                'temperature':
                41.0,
                'uptime':
                '8681748'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '614804305940',
                    'links': [{
                        'in_octets': '614804305940',
                        'out_octets': '42324369713',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '42324369713',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmM1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7146288',
                            'fiber_length': 7332,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.9,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.624
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMmM1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '42324369713',
                    'mac_address': '74:83:c2:69:e2:c5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '614804305940',
                    'poller_hash': 'NzQ4M2MyNjhlMmM1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19391LancerCircle',
                'serial_number':
                'UBNTc268e2c5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:c5',
                'temperature':
                41.0,
                'uptime':
                '7146332'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1153229350068',
                    'links': [{
                        'in_octets': '1153229350068',
                        'out_octets': '47317801454',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '47317801454',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzExcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 7574,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.694,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.06
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzExcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '47317801454',
                    'mac_address': '74:83:c2:69:e3:11',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1153229350068',
                    'poller_hash': 'NzQ4M2MyNjhlMzExZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19249LincolnRoad-Cottage',
                'serial_number':
                'UBNTc268e311',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:11',
                'temperature':
                37.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '146270831483',
                    'links': [{
                        'in_octets': '146270831483',
                        'out_octets': '23711662173',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '23711662173',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzIxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3588447',
                            'fiber_length': 8354,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.446,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.012
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzIxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '23711662173',
                    'mac_address': '74:83:c2:69:e3:21',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '146270831483',
                    'poller_hash': 'NzQ4M2MyNjhlMzIxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19382LancerCircle',
                'serial_number':
                'UBNTc268e321',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:21',
                'temperature':
                41.0,
                'uptime':
                '3588491'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '6781398714211',
                    'links': [{
                        'in_octets': '6781398714211',
                        'out_octets': '310042254680',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '310042254680',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzI1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681701',
                            'fiber_length': 8032,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.252
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzI1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '310042254680',
                    'mac_address': '74:83:c2:69:e3:25',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '6781398714211',
                    'poller_hash': 'NzQ4M2MyNjhlMzI1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19060LincolnRoad',
                'serial_number':
                'UBNTc268e325',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:25',
                'temperature':
                45.0,
                'uptime':
                '8681748'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '13890809517327',
                    'links': [{
                        'in_octets': '13890809517327',
                        'out_octets': '867392745646',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '867392745646',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzJlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8847462',
                            'fiber_length': 8516,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.064,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.378
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzJlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '867392745646',
                    'mac_address': '74:83:c2:69:e3:2e',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '13890809517327',
                    'poller_hash': 'NzQ4M2MyNjhlMzJlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19226LancerCircle',
                'serial_number':
                'UBNTc268e32e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:2e',
                'temperature':
                47.0,
                'uptime':
                '8847510'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3834216953694',
                    'links': [{
                        'in_octets': '3834216953694',
                        'out_octets': '74580086771',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '74580086771',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzNhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7147428',
                            'fiber_length': 7166,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.362,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.0
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzNhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '74580086771',
                    'mac_address': '74:83:c2:69:e3:3a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3834216953694',
                    'poller_hash': 'NzQ4M2MyNjhlMzNhZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19215LincolnRoad',
                'serial_number':
                'UBNTc268e33a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:3a',
                'temperature':
                43.0,
                'uptime':
                '7147471'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '84525278369',
                    'links': [{
                        'in_octets': '84525278369',
                        'out_octets': '7789426259',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7789426259',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzUwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833813',
                            'fiber_length': 8012,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.152,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.996
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzUwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '7789426259',
                    'mac_address': '74:83:c2:69:e3:50',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '84525278369',
                    'poller_hash': 'NzQ4M2MyNjhlMzUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19058LancerCircle',
                'serial_number':
                'UBNTc268e350',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:50',
                'temperature':
                45.0,
                'uptime':
                '833857'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '493138803253',
                    'links': [{
                        'in_octets': '493138803253',
                        'out_octets': '48042507592',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48042507592',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '834653',
                            'fiber_length': 8447,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.538,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.298
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '48042507592',
                    'mac_address': '74:83:c2:69:e3:54',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '493138803253',
                    'poller_hash': 'NzQ4M2MyNjhlMzU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19105LancerCircle',
                'serial_number':
                'UBNTc268e354',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:54',
                'temperature':
                38.0,
                'uptime':
                '834692'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3053223141963',
                    'links': [{
                        'in_octets': '3053223141963',
                        'out_octets': '380791876350',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '380791876350',
                    'poller_hash':
                    'NzQ4M2MyZjAzZmQwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681699',
                            'fiber_length': 8653,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.248,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.75
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAzZmQwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '380791876350',
                    'mac_address': '74:83:c2:f1:3f:d0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3053223141963',
                    'poller_hash': 'NzQ4M2MyZjAzZmQwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19204LancerCircle',
                'serial_number':
                'UBNTc2f03fd0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:3f:d0',
                'temperature':
                45.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2505658355768',
                    'links': [{
                        'in_octets': '2505658355768',
                        'out_octets': '163682568555',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '163682568555',
                    'poller_hash':
                    'NzQ4M2MyZjA0NmFjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8847472',
                            'fiber_length': 7592,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.268,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.052
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA0NmFjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '163682568555',
                    'mac_address': '74:83:c2:f1:46:ac',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2505658355768',
                    'poller_hash': 'NzQ4M2MyZjA0NmFjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19564GreggsvilleRd',
                'serial_number':
                'UBNTc2f046ac',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:46:ac',
                'temperature':
                39.0,
                'uptime':
                '8847513'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '27467042447',
                    'links': [{
                        'in_octets': '27467042447',
                        'out_octets': '1377723100',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1377723100',
                    'poller_hash':
                    'NzQ4M2MyZjA1NGQwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '691952',
                            'fiber_length': 7976,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.516,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.598
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA1NGQwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '1377723100',
                    'mac_address': '74:83:c2:f1:54:d0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '27467042447',
                    'poller_hash': 'NzQ4M2MyZjA1NGQwZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19060LincolnRoad-MilkHouse',
                'serial_number':
                'UBNTc2f054d0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:54:d0',
                'temperature':
                45.0,
                'uptime':
                '691995'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1514329790933',
                    'links': [{
                        'in_octets': '1514329790933',
                        'out_octets': '266497356947',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '266497356947',
                    'poller_hash':
                    'NzQ4M2MyZjA2OTBjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681691',
                            'fiber_length': 8458,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.644,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.38
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA2OTBjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '266497356947',
                    'mac_address': '74:83:c2:f1:69:0c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1514329790933',
                    'poller_hash': 'NzQ4M2MyZjA2OTBjZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19179LancerCircle',
                'serial_number':
                'UBNTc2f0690c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:69:0c',
                'temperature':
                44.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '561107653217',
                    'links': [{
                        'in_octets': '561107653217',
                        'out_octets': '53380893648',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '53380893648',
                    'poller_hash':
                    'NzQ4M2MyZjA2OTY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681741',
                            'fiber_length': 8467,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.586,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.472
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA2OTY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '53380893648',
                    'mac_address': '74:83:c2:f1:69:68',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '561107653217',
                    'poller_hash': 'NzQ4M2MyZjA2OTY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19199LancerCircle',
                'serial_number':
                'UBNTc2f06968',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:69:68',
                'temperature':
                44.0,
                'uptime':
                '8681782'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3804670312341',
                    'links': [{
                        'in_octets': '3804670312341',
                        'out_octets': '220258027678',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '220258027678',
                    'poller_hash':
                    'NzQ4M2MyZjA2ZDhjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681691',
                            'fiber_length': 8285,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.864
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA2ZDhjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '220258027678',
                    'mac_address': '74:83:c2:f1:6d:8c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3804670312341',
                    'poller_hash': 'NzQ4M2MyZjA2ZDhjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19155LancerCircle',
                'serial_number':
                'UBNTc2f06d8c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:6d:8c',
                'temperature':
                41.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2762125828926',
                    'links': [{
                        'in_octets': '2762125828926',
                        'out_octets': '1457082746013',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1457082746013',
                    'poller_hash':
                    'NzQ4M2MyZjA3MDgwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7147508',
                            'fiber_length': 8366,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.486
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA3MDgwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '1457082746013',
                    'mac_address': '74:83:c2:f1:70:80',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2762125828926',
                    'poller_hash': 'NzQ4M2MyZjA3MDgwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19348LancerCircle',
                'serial_number':
                'UBNTc2f07080',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:70:80',
                'temperature':
                51.0,
                'uptime':
                '7147556'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4449250945461',
                    'links': [{
                        'in_octets': '4449250945461',
                        'out_octets': '135159672477',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '135159672477',
                    'poller_hash':
                    'MThlODI5MGI0MGIwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '17755237',
                            'fiber_length': 5292,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.146,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.848
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI0MGIwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '135159672477',
                    'mac_address': '18:e8:29:0c:40:b0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4449250945461',
                    'poller_hash': 'MThlODI5MGI0MGIwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19965LincolnRoad',
                'serial_number':
                'UBNT290b40b0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '18:e8:29:0b:40:b0',
                'temperature':
                38.0,
                'uptime':
                '20510752'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '211228825396',
                    'links': [{
                        'in_octets': '211228825396',
                        'out_octets': '51362830391',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '51362830391',
                    'poller_hash':
                    'MThlODI5MGI0MTIwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '967264',
                            'fiber_length': 5238,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.09
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI0MTIwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '51362830391',
                    'mac_address': '18:e8:29:0c:41:20',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '211228825396',
                    'poller_hash': 'MThlODI5MGI0MTIwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '20013LincolnRoad',
                'serial_number':
                'UBNT290b4120',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '18:e8:29:0b:41:20',
                'temperature':
                47.0,
                'uptime':
                '967304'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '409324676445',
                    'links': [{
                        'in_octets': '409324676445',
                        'out_octets': '24321650043',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24321650043',
                    'poller_hash':
                    'MThlODI5MGI0YjY0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8847472',
                            'fiber_length': 4002,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.228,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.066
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI0YjY0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '24321650043',
                    'mac_address': '18:e8:29:0c:4b:64',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '409324676445',
                    'poller_hash': 'MThlODI5MGI0YjY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19783GreggsvilleRoad',
                'serial_number':
                'UBNT290b4b64',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '18:e8:29:0b:4b:64',
                'temperature':
                43.0,
                'uptime':
                '8847513'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '350004142230',
                    'links': [{
                        'in_octets': '350004142230',
                        'out_octets': '16611088826',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '16611088826',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDg3cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 2272,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.756,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.48
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDg3cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '16611088826',
                    'mac_address': '74:83:c2:69:e0:87',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '350004142230',
                    'poller_hash': 'NzQ4M2MyNjhlMDg3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38174NorthForkRd',
                'serial_number':
                'UBNTc268e087',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:87',
                'temperature':
                36.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '20620738694',
                    'links': [{
                        'in_octets': '20620738694',
                        'out_octets': '2080765286',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2080765286',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGVicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '698752',
                            'fiber_length': 3576,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.756,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.608
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMGVicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '2080765286',
                    'mac_address': '74:83:c2:69:e0:eb',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '20620738694',
                    'poller_hash': 'NzQ4M2MyNjhlMGViZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '20152GreggsvilleRd',
                'serial_number':
                'UBNTc268e0eb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:eb',
                'temperature':
                41.0,
                'uptime':
                '698794'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '26293224067',
                    'links': [{
                        'in_octets': '26293224067',
                        'out_octets': '4215472299',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '4215472299',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGZkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 1533,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.222,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.37
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMGZkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '4215472299',
                    'mac_address': '74:83:c2:69:e0:fd',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '26293224067',
                    'poller_hash': 'NzQ4M2MyNjhlMGZkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '20200ShelburneGlebeRd',
                'serial_number':
                'UBNTc268e0fd',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:fd',
                'temperature':
                52.0,
                'uptime':
                '4278503'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '95730254474',
                    'links': [{
                        'in_octets': '95730254474',
                        'out_octets': '26904249977',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '26904249977',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTcxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '835543',
                            'fiber_length': 4871,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.624,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.46
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMTcxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '26904249977',
                    'mac_address': '74:83:c2:69:e1:71',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '95730254474',
                    'poller_hash': 'NzQ4M2MyNjhlMTcxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19964PleasantMeadowLn',
                'serial_number':
                'UBNTc268e171',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:71',
                'temperature':
                40.0,
                'uptime':
                '835582'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1706048813812',
                    'links': [{
                        'in_octets': '1706048813812',
                        'out_octets': '34168718507',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '34168718507',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTczcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278473',
                            'fiber_length': 1462,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.624,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.1
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMTczcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '34168718507',
                    'mac_address': '74:83:c2:69:e1:73',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1706048813812',
                    'poller_hash': 'NzQ4M2MyNjhlMTczZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38011NorthForkRd',
                'serial_number':
                'UBNTc268e173',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:73',
                'temperature':
                38.0,
                'uptime':
                '4278512'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '757764942767',
                    'links': [{
                        'in_octets': '757764942767',
                        'out_octets': '48278002484',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48278002484',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWExcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833203',
                            'fiber_length': 4097,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.258
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWExcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '48278002484',
                    'mac_address': '74:83:c2:69:e1:a1',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '757764942767',
                    'poller_hash': 'NzQ4M2MyNjhlMWExZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19815GreggsvilleRoad',
                'serial_number':
                'UBNTc268e1a1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:a1',
                'temperature':
                43.0,
                'uptime':
                '833246'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '695144533896',
                    'links': [{
                        'in_octets': '695144533896',
                        'out_octets': '49335455458',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '49335455458',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWFkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833573',
                            'fiber_length': 4906,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.808,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.344
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWFkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '49335455458',
                    'mac_address': '74:83:c2:69:e1:ad',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '695144533896',
                    'poller_hash': 'NzQ4M2MyNjhlMWFkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '37626NorthForkRd',
                'serial_number':
                'UBNTc268e1ad',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:ad',
                'temperature':
                38.0,
                'uptime':
                '833615'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '766285594570',
                    'links': [{
                        'in_octets': '766285594570',
                        'out_octets': '53982139677',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '53982139677',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWQ0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 1709,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.826,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.414
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWQ0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '53982139677',
                    'mac_address': '74:83:c2:69:e1:d4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '766285594570',
                    'poller_hash': 'NzQ4M2MyNjhlMWQ0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '37972NorthForkRd',
                'serial_number':
                'UBNTc268e1d4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:d4',
                'temperature':
                47.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3860192578640',
                    'links': [{
                        'in_octets': '3860192578640',
                        'out_octets': '523200308521',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '523200308521',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWZjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '17755238',
                            'fiber_length': 3689,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.304,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.378
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWZjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '523200308521',
                    'mac_address': '74:83:c2:69:e1:fc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3860192578640',
                    'poller_hash': 'NzQ4M2MyNjhlMWZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '20248GrerggsvilleRoad',
                'serial_number':
                'UBNTc268e1fc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:fc',
                'temperature':
                43.0,
                'uptime':
                '22036691'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '708880775335',
                    'links': [{
                        'in_octets': '708880775335',
                        'out_octets': '40030214157',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '40030214157',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWZmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 2169,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.392,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.744
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWZmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '40030214157',
                    'mac_address': '74:83:c2:69:e1:ff',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '708880775335',
                    'poller_hash': 'NzQ4M2MyNjhlMWZmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38158NorthForkRd',
                'serial_number':
                'UBNTc268e1ff',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:ff',
                'temperature':
                30.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '177884781681',
                    'links': [{
                        'in_octets': '177884781681',
                        'out_octets': '43335531017',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '43335531017',
                    'poller_hash':
                    'NzQ4M2MyNjhlMjk4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 4759,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.546,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.794
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMjk4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '43335531017',
                    'mac_address': '74:83:c2:69:e2:98',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '177884781681',
                    'poller_hash': 'NzQ4M2MyNjhlMjk4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '20011PleasantMeadowsLane',
                'serial_number':
                'UBNTc268e298',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:98',
                'temperature':
                45.0,
                'uptime':
                '4278503'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '308509214080',
                    'links': [{
                        'in_octets': '308509214080',
                        'out_octets': '7069294602',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7069294602',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzRjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '700192',
                            'fiber_length': 3971,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.554,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.206
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzRjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '7069294602',
                    'mac_address': '74:83:c2:69:e3:4c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '308509214080',
                    'poller_hash': 'NzQ4M2MyNjhlMzRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19783GreggsvilleRoad-Cottage',
                'serial_number':
                'UBNTc268e34c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:4c',
                'temperature':
                39.0,
                'uptime':
                '700235'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '104838036906',
                    'links': [{
                        'in_octets': '104838036906',
                        'out_octets': '65073454145',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '65073454145',
                    'poller_hash':
                    'NzQ4M2MyZjAyN2I0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '698752',
                            'fiber_length': 2645,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.518
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAyN2I0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '65073454145',
                    'mac_address': '74:83:c2:f1:27:b4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '104838036906',
                    'poller_hash': 'NzQ4M2MyZjAyN2I0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '20124CreekspringCt',
                'serial_number':
                'UBNTc2f027b4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:27:b4',
                'temperature':
                42.0,
                'uptime':
                '698794'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '191949510392',
                    'links': [{
                        'in_octets': '191949510392',
                        'out_octets': '13348139927',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13348139927',
                    'poller_hash':
                    'NzQ4M2MyZjAyYTM4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1109896',
                            'fiber_length': 3984,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.222,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.88
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAyYTM4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '13348139927',
                    'mac_address': '74:83:c2:f1:2a:38',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '191949510392',
                    'poller_hash': 'NzQ4M2MyZjAyYTM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19821GreggsvilleRoad',
                'serial_number':
                'UBNTc2f02a38',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:2a:38',
                'temperature':
                45.0,
                'uptime':
                '1109935'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4006844975783',
                    'links': [{
                        'in_octets': '4006844975783',
                        'out_octets': '209604634055',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '209604634055',
                    'poller_hash':
                    'NzQ4M2MyZjA0NGNjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8847472',
                            'fiber_length': 3958,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.218,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.512
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA0NGNjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '209604634055',
                    'mac_address': '74:83:c2:f1:44:cc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4006844975783',
                    'poller_hash': 'NzQ4M2MyZjA0NGNjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19827GreggsvilleRoad',
                'serial_number':
                'UBNTc2f044cc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:44:cc',
                'temperature':
                52.0,
                'uptime':
                '8847514'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '33589122215',
                    'links': [{
                        'in_octets': '33589122215',
                        'out_octets': '3981305981',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3981305981',
                    'poller_hash':
                    'NzQ4M2MyZjA0NjA4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '698751',
                            'fiber_length': 3508,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.212
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA0NjA4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '3981305981',
                    'mac_address': '74:83:c2:f1:46:08',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '33589122215',
                    'poller_hash': 'NzQ4M2MyZjA0NjA4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19981GreggsvilleRoad',
                'serial_number':
                'UBNTc2f04608',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:46:08',
                'temperature':
                50.0,
                'uptime':
                '698793'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '567256137139',
                    'links': [{
                        'in_octets': '567256137139',
                        'out_octets': '232663434544',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '232663434544',
                    'poller_hash':
                    'NzQ4M2MyZjA2ZDY0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3867460',
                            'fiber_length': 1748,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.318,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.746
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA2ZDY0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '232663434544',
                    'mac_address': '74:83:c2:f1:6d:64',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '567256137139',
                    'poller_hash': 'NzQ4M2MyZjA2ZDY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38104NorthForkRd',
                'serial_number':
                'UBNTc2f06d64',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:6d:64',
                'temperature':
                42.0,
                'uptime':
                '3867504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '487864309994',
                    'links': [{
                        'in_octets': '487864309994',
                        'out_octets': '76445609371',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '76445609371',
                    'poller_hash':
                    'NzQ4M2MyZjA3MDU4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 2706,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.528
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA3MDU4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '76445609371',
                    'mac_address': '74:83:c2:f1:70:58',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '487864309994',
                    'poller_hash': 'NzQ4M2MyZjA3MDU4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38359NorthForkRd',
                'serial_number':
                'UBNTc2f07058',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:70:58',
                'temperature':
                43.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '9467383439',
                    'links': [{
                        'in_octets': '9467383439',
                        'out_octets': '1190357340',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1190357340',
                    'poller_hash':
                    'NzQ4M2MyZjA3MDk4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '297008',
                            'fiber_length': 3586,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.956,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.122
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA3MDk4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '1190357340',
                    'mac_address': '74:83:c2:f1:70:98',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '9467383439',
                    'poller_hash': 'NzQ4M2MyZjA3MDk4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19987GreggsvilleRoad',
                'serial_number':
                'UBNTc2f07098',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:70:98',
                'temperature':
                51.0,
                'uptime':
                '297046'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1473137823819',
                    'links': [{
                        'in_octets': '1473137823819',
                        'out_octets': '135928020386',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '135928020386',
                    'poller_hash':
                    'ZDAyMWY5OWE2YWI0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8851422',
                            'fiber_length': 3712,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.372
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YWI0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '135928020386',
                    'mac_address': 'd0:21:f9:9b:6a:b4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1473137823819',
                    'poller_hash': 'ZDAyMWY5OWE2YWI0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19704GreggsvilleRoad',
                'serial_number':
                'UBNTf99a6ab4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6a:b4',
                'temperature':
                46.0,
                'uptime':
                '8851468'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '570035358507',
                    'links': [{
                        'in_octets': '570035358507',
                        'out_octets': '169608291315',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '169608291315',
                    'poller_hash':
                    'MThlODI5MGIzZjg4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4997559',
                            'fiber_length': 11785,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.278,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.144
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGIzZjg4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '169608291315',
                    'mac_address': '18:e8:29:0c:3f:88',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '570035358507',
                    'poller_hash': 'MThlODI5MGIzZjg4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38188HuntsEndPl',
                'serial_number':
                'UBNT290b3f88',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '18:e8:29:0b:3f:88',
                'temperature':
                44.0,
                'uptime':
                '4997605'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '926611901',
                    'links': [{
                        'in_octets': '926611901',
                        'out_octets': '122683183',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '122683183',
                    'poller_hash':
                    'MThlODI5MGIzZmU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '62516',
                            'fiber_length': 8103,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.676,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.882
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGIzZmU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '122683183',
                    'mac_address': '18:e8:29:0c:3f:e4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '926611901',
                    'poller_hash': 'MThlODI5MGIzZmU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19287LincolnRoad-Shed',
                'serial_number':
                'UBNT290b3fe4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '18:e8:29:0b:3f:e4',
                'temperature':
                43.0,
                'uptime':
                '62558'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1520521028270',
                    'links': [{
                        'in_octets': '1520521028270',
                        'out_octets': '27422530030',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27422530030',
                    'poller_hash':
                    'MThlODI5MGI0MTk0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4885089',
                            'fiber_length': 8315,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.756,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.866
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI0MTk0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '27422530030',
                    'mac_address': '18:e8:29:0c:41:94',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1520521028270',
                    'poller_hash': 'MThlODI5MGI0MTk0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19287LincolnRoad-House',
                'serial_number':
                'UBNT290b4194',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '18:e8:29:0b:41:94',
                'temperature':
                43.0,
                'uptime':
                '4885132'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1391468269599',
                    'links': [{
                        'in_octets': '1391468269599',
                        'out_octets': '149294437544',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '149294437544',
                    'poller_hash':
                    'MThlODI5MGI0MWU4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3080213',
                            'fiber_length': 11743,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.87,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.838
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI0MWU4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '149294437544',
                    'mac_address': '18:e8:29:0c:41:e8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1391468269599',
                    'poller_hash': 'MThlODI5MGI0MWU4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38195HuntsEndPl',
                'serial_number':
                'UBNT290b41e8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '18:e8:29:0b:41:e8',
                'temperature':
                52.0,
                'uptime':
                '3080257'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2700372723631',
                    'links': [{
                        'in_octets': '2700372723631',
                        'out_octets': '125174916315',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '125174916315',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDNmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4997149',
                            'fiber_length': 11893,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.042,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.386
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDNmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '125174916315',
                    'mac_address': '74:83:c2:69:e0:3f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2700372723631',
                    'poller_hash': 'NzQ4M2MyNjhlMDNmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38153HuntsEndPl',
                'serial_number':
                'UBNTc268e03f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:3f',
                'temperature':
                45.0,
                'uptime':
                '4997193'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '180597411818',
                    'links': [{
                        'in_octets': '180597411818',
                        'out_octets': '19935658325',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '19935658325',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDQycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '835173',
                            'fiber_length': 11715,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.176,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.162
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDQycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '19935658325',
                    'mac_address': '74:83:c2:69:e0:42',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '180597411818',
                    'poller_hash': 'NzQ4M2MyNjhlMDQyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38202HuntsEndPl',
                'serial_number':
                'UBNTc268e042',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:42',
                'temperature':
                46.0,
                'uptime':
                '835221'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '455387477016',
                    'links': [{
                        'in_octets': '455387477016',
                        'out_octets': '211824214312',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '211824214312',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDU5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2853541',
                            'fiber_length': 8473,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.086,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.276
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDU5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '211824214312',
                    'mac_address': '74:83:c2:69:e0:59',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '455387477016',
                    'poller_hash': 'NzQ4M2MyNjhlMDU5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19749LincolnRoad-House',
                'serial_number':
                'UBNTc268e059',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:59',
                'temperature':
                43.0,
                'uptime':
                '2853587'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '90549708770',
                    'links': [{
                        'in_octets': '90549708770',
                        'out_octets': '13603438797',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13603438797',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDc4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 8543,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.808,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.378
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDc4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '13603438797',
                    'mac_address': '74:83:c2:69:e0:78',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '90549708770',
                    'poller_hash': 'NzQ4M2MyNjhlMDc4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19749LincolnRoad-Garage',
                'serial_number':
                'UBNTc268e078',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:78',
                'temperature':
                35.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1016967514777',
                    'links': [{
                        'in_octets': '1016967514777',
                        'out_octets': '64076329101',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '64076329101',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDc5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 8138,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.914,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.748
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDc5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '64076329101',
                    'mac_address': '74:83:c2:69:e0:79',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1016967514777',
                    'poller_hash': 'NzQ4M2MyNjhlMDc5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19351LincolnRoad',
                'serial_number':
                'UBNTc268e079',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:79',
                'temperature':
                39.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '567773054791',
                    'links': [{
                        'in_octets': '567773054791',
                        'out_octets': '66876520295',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '66876520295',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGRjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681691',
                            'fiber_length': 8668,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.76,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.172
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMGRjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '66876520295',
                    'mac_address': '74:83:c2:69:e0:dc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '567773054791',
                    'poller_hash': 'NzQ4M2MyNjhlMGRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19008LincolnRd',
                'serial_number':
                'UBNTc268e0dc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:dc',
                'temperature':
                37.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '16842167640',
                    'links': [{
                        'in_octets': '16842167640',
                        'out_octets': '1465726649',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1465726649',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGUzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '146986',
                            'fiber_length': 8878,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.306
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMGUzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '1465726649',
                    'mac_address': '74:83:c2:69:e0:e3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '16842167640',
                    'poller_hash': 'NzQ4M2MyNjhlMGUzZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '37967ForestMillsRd',
                'serial_number':
                'UBNTc268e0e3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:e3',
                'temperature':
                43.0,
                'uptime':
                '147028'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '97688576095',
                    'links': [{
                        'in_octets': '97688576095',
                        'out_octets': '2021512725',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2021512725',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '146986',
                            'fiber_length': 9210,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.318,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.31
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMGVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '2021512725',
                    'mac_address': '74:83:c2:69:e0:ec',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '97688576095',
                    'poller_hash': 'NzQ4M2MyNjhlMGVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38057ForestMillsRoad-Cottage',
                'serial_number':
                'UBNTc268e0ec',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:ec',
                'temperature':
                45.0,
                'uptime':
                '147028'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1369270068022',
                    'links': [{
                        'in_octets': '1369270068022',
                        'out_octets': '115041542432',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '115041542432',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWNlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681701',
                            'fiber_length': 7755,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.314,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.778
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWNlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '115041542432',
                    'mac_address': '74:83:c2:69:e1:ce',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1369270068022',
                    'poller_hash': 'NzQ4M2MyNjhlMWNlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19249LincolnRoad',
                'serial_number':
                'UBNTc268e1ce',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:ce',
                'temperature':
                41.0,
                'uptime':
                '8681748'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1389158163103',
                    'links': [{
                        'in_octets': '1389158163103',
                        'out_octets': '67611332935',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '67611332935',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmEzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 8679,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.788
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMmEzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '67611332935',
                    'mac_address': '74:83:c2:69:e2:a3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1389158163103',
                    'poller_hash': 'NzQ4M2MyNjhlMmEzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19675LincolnRoad',
                'serial_number':
                'UBNTc268e2a3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:a3',
                'temperature':
                45.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1778767070505',
                    'links': [{
                        'in_octets': '1778767070505',
                        'out_octets': '117503972309',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '117503972309',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmI4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '5019760',
                            'fiber_length': 11944,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.794,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.22
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMmI4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '117503972309',
                    'mac_address': '74:83:c2:69:e2:b8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1778767070505',
                    'poller_hash': 'NzQ4M2MyNjhlMmI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38134HuntsEndPl',
                'serial_number':
                'UBNTc268e2b8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:b8',
                'temperature':
                39.0,
                'uptime':
                '5019802'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1770806021',
                    'links': [{
                        'in_octets': '1770806021',
                        'out_octets': '185981422',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '185981422',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmU1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '146987',
                            'fiber_length': 8807,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.222,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.182
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMmU1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '185981422',
                    'mac_address': '74:83:c2:69:e2:e5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1770806021',
                    'poller_hash': 'NzQ4M2MyNjhlMmU1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '37967ForestMillsRd',
                'serial_number':
                'UBNTc268e2e5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:e5',
                'temperature':
                42.0,
                'uptime':
                '147028'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '279902687032',
                    'links': [{
                        'in_octets': '279902687032',
                        'out_octets': '32730253043',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '32730253043',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzM1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 10288,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.362,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.588
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzM1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '32730253043',
                    'mac_address': '74:83:c2:69:e3:35',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '279902687032',
                    'poller_hash': 'NzQ4M2MyNjhlMzM1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19625LincolnRoad',
                'serial_number':
                'UBNTc268e335',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:35',
                'temperature':
                43.0,
                'uptime':
                '4278503'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '208527310093',
                    'links': [{
                        'in_octets': '208527310093',
                        'out_octets': '29668853091',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '29668853091',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzQ5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '184477',
                            'fiber_length': 11970,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.176,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.24
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzQ5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '29668853091',
                    'mac_address': '74:83:c2:69:e3:49',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '208527310093',
                    'poller_hash': 'NzQ4M2MyNjhlMzQ5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38166HuntsEndPl',
                'serial_number':
                'UBNTc268e349',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:49',
                'temperature':
                46.0,
                'uptime':
                '184520'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '171373739719',
                    'links': [{
                        'in_octets': '171373739719',
                        'out_octets': '12359817482',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12359817482',
                    'poller_hash':
                    'NzQ4M2MyZjAyMDAwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '836243',
                            'fiber_length': 8558,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.248,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.352
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAyMDAwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '12359817482',
                    'mac_address': '74:83:c2:f1:20:00',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '171373739719',
                    'poller_hash': 'NzQ4M2MyZjAyMDAwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19002LincolnRd',
                'serial_number':
                'UBNTc2f02000',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:20:00',
                'temperature':
                48.0,
                'uptime':
                '836291'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '106886941423',
                    'links': [{
                        'in_octets': '106886941423',
                        'out_octets': '5631465143',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5631465143',
                    'poller_hash':
                    'NzQ4M2MyZjA1NGU4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '835503',
                            'fiber_length': 8733,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.208,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.702
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA1NGU4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '5631465143',
                    'mac_address': '74:83:c2:f1:54:e8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '106886941423',
                    'poller_hash': 'NzQ4M2MyZjA1NGU4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19669LincolnRoad',
                'serial_number':
                'UBNTc2f054e8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:54:e8',
                'temperature':
                43.0,
                'uptime':
                '835544'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '271005948801',
                    'links': [{
                        'in_octets': '271005948801',
                        'out_octets': '150564662047',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '150564662047',
                    'poller_hash':
                    'NzQ4M2MyZjA1NTAwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278473',
                            'fiber_length': 9676,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.134,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.824
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA1NTAwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '150564662047',
                    'mac_address': '74:83:c2:f1:55:00',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '271005948801',
                    'poller_hash': 'NzQ4M2MyZjA1NTAwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19600LincolnRoad',
                'serial_number':
                'UBNTc2f05500',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:55:00',
                'temperature':
                46.0,
                'uptime':
                '4278512'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '40596015326',
                    'links': [{
                        'in_octets': '40596015326',
                        'out_octets': '6157201296',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6157201296',
                    'poller_hash':
                    'NzQ4M2MyZjA2ZDQ4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '146986',
                            'fiber_length': 9617,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.624,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.488
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA2ZDQ4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '6157201296',
                    'mac_address': '74:83:c2:f1:6d:48',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '40596015326',
                    'poller_hash': 'NzQ4M2MyZjA2ZDQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38085ForestMillsRd',
                'serial_number':
                'UBNTc2f06d48',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:6d:48',
                'temperature':
                52.0,
                'uptime':
                '147029'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '77223524168',
                    'links': [{
                        'in_octets': '77223524168',
                        'out_octets': '60262533659',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '60262533659',
                    'poller_hash':
                    'NzQ4M2MyZjA2ZDg0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '146987',
                            'fiber_length': 9320,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.746,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.206
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA2ZDg0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '60262533659',
                    'mac_address': '74:83:c2:f1:6d:84',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '77223524168',
                    'poller_hash': 'NzQ4M2MyZjA2ZDg0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38057ForestMillsRd',
                'serial_number':
                'UBNTc2f06d84',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:6d:84',
                'temperature':
                44.0,
                'uptime':
                '147028'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1496644684944',
                    'links': [{
                        'in_octets': '1496644684944',
                        'out_octets': '1187778998628',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1187778998628',
                    'poller_hash':
                    'NzQ4M2MyZjA3MDc0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '6027238',
                            'fiber_length': 7867,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.676
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA3MDc0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '1187778998628',
                    'mac_address': '74:83:c2:f1:70:74',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1496644684944',
                    'poller_hash': 'NzQ4M2MyZjA3MDc0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19582GreggsvilleRoad',
                'serial_number':
                'UBNTc2f07074',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:70:74',
                'temperature':
                70.0,
                'uptime':
                '6027286'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '977788275924',
                    'links': [{
                        'in_octets': '977788275924',
                        'out_octets': '105811370179',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '105811370179',
                    'poller_hash':
                    'ZDAyMWY5OWE2OWQ4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4997330',
                            'fiber_length': 11833,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.564,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.064
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2OWQ4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '105811370179',
                    'mac_address': 'd0:21:f9:9b:69:d8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '977788275924',
                    'poller_hash': 'ZDAyMWY5OWE2OWQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38244HuntsEndPl',
                'serial_number':
                'UBNTf99a69d8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:69:d8',
                'temperature':
                46.0,
                'uptime':
                '4997376'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '232152632390',
                    'links': [{
                        'in_octets': '232152632390',
                        'out_octets': '17537411143',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17537411143',
                    'poller_hash':
                    'ZDAyMWY5OWE2Y2U4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3936880',
                            'fiber_length': 11288,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.554,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.624
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2Y2U4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '17537411143',
                    'mac_address': 'd0:21:f9:9b:6c:e8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '232152632390',
                    'poller_hash': 'ZDAyMWY5OWE2Y2U4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19411ShelburneGlebeRoad',
                'serial_number':
                'UBNTf99a6ce8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6c:e8',
                'temperature':
                37.0,
                'uptime':
                '3936921'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '274624776323',
                    'links': [{
                        'in_octets': '274624776323',
                        'out_octets': '14048582668',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14048582668',
                    'poller_hash':
                    'NzQ4M2MyZjAyOWI4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '834233',
                            'fiber_length': 15791,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.42,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.152
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAyOWI4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '14048582668',
                    'mac_address': '74:83:c2:f1:29:b8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '274624776323',
                    'poller_hash': 'NzQ4M2MyZjAyOWI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19281SwanCt',
                'serial_number':
                'UBNTc2f029b8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:29:b8',
                'temperature':
                47.0,
                'uptime':
                '834279'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '63721866874',
                    'links': [{
                        'in_octets': '63721866874',
                        'out_octets': '16131852330',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '16131852330',
                    'poller_hash':
                    'NzQ4M2MyZjAzMTAwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833443',
                            'fiber_length': 15424,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.168,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.232
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAzMTAwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '16131852330',
                    'mac_address': '74:83:c2:f1:31:00',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '63721866874',
                    'poller_hash': 'NzQ4M2MyZjAzMTAwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '36675WoodDuckCt',
                'serial_number':
                'UBNTc2f03100',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:31:00',
                'temperature':
                54.0,
                'uptime':
                '833485'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '84954144187',
                    'links': [{
                        'in_octets': '84954144187',
                        'out_octets': '9657226005',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9657226005',
                    'poller_hash':
                    'NzQ4M2MyZjAzMTM0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '677602',
                            'fiber_length': 15356,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.606,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.298
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAzMTM0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '9657226005',
                    'mac_address': '74:83:c2:f1:31:34',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '84954144187',
                    'poller_hash': 'NzQ4M2MyZjAzMTM0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19165SwanCt',
                'serial_number':
                'UBNTc2f03134',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:31:34',
                'temperature':
                43.0,
                'uptime':
                '677648'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '39905129205',
                    'links': [{
                        'in_octets': '39905129205',
                        'out_octets': '3182441623',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3182441623',
                    'poller_hash':
                    'NzQ4M2MyZjAzMTUwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '62106',
                            'fiber_length': 15746,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.9,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.886
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAzMTUwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '3182441623',
                    'mac_address': '74:83:c2:f1:31:50',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '39905129205',
                    'poller_hash': 'NzQ4M2MyZjAzMTUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19130PintailCt',
                'serial_number':
                'UBNTc2f03150',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:31:50',
                'temperature':
                47.0,
                'uptime':
                '62148'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '282946260150',
                    'links': [{
                        'in_octets': '282946260150',
                        'out_octets': '20265296969',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '20265296969',
                    'poller_hash':
                    'NzQ4M2MyZjAzZGUwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '834343',
                            'fiber_length': 16109,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.184,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.634
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAzZGUwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '20265296969',
                    'mac_address': '74:83:c2:f1:3d:e0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '282946260150',
                    'poller_hash': 'NzQ4M2MyZjAzZGUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '36448ShoemakerSchoolRd',
                'serial_number':
                'UBNTc2f03de0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:3d:e0',
                'temperature':
                43.0,
                'uptime':
                '834391'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '444936869400',
                    'links': [{
                        'in_octets': '444936869400',
                        'out_octets': '110700458158',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '110700458158',
                    'poller_hash':
                    'NzQ4M2MyZjAzZTY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1557720',
                            'fiber_length': 16027,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.864,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.154
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAzZTY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '110700458158',
                    'mac_address': '74:83:c2:f1:3e:68',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '444936869400',
                    'poller_hash': 'NzQ4M2MyZjAzZTY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19140PintailCt',
                'serial_number':
                'UBNTc2f03e68',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:3e:68',
                'temperature':
                45.0,
                'uptime':
                '1557766'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '291731428977',
                    'links': [{
                        'in_octets': '291731428977',
                        'out_octets': '35662411941',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '35662411941',
                    'poller_hash':
                    'NzQ4M2MyZjA0MTBjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '950444',
                            'fiber_length': 15781,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.62,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.594
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA0MTBjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '35662411941',
                    'mac_address': '74:83:c2:f1:41:0c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '291731428977',
                    'poller_hash': 'NzQ4M2MyZjA0MTBjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19275SwanCt',
                'serial_number':
                'UBNTc2f0410c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:41:0c',
                'temperature':
                46.0,
                'uptime':
                '950483'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '49129075877',
                    'links': [{
                        'in_octets': '49129075877',
                        'out_octets': '6970348369',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6970348369',
                    'poller_hash':
                    'NzQ4M2MyZjA1MDY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2661429',
                            'fiber_length': 16093,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.556,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.304
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA1MDY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '6970348369',
                    'mac_address': '74:83:c2:f1:50:68',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '49129075877',
                    'poller_hash': 'NzQ4M2MyZjA1MDY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19185PintailCt',
                'serial_number':
                'UBNTc2f05068',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:50:68',
                'temperature':
                50.0,
                'uptime':
                '2661468'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '983279540878',
                    'links': [{
                        'in_octets': '983279540878',
                        'out_octets': '67829562804',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '67829562804',
                    'poller_hash':
                    'ZDAyMWY5OWE2Mzk4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2661889',
                            'fiber_length': 15923,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.09,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.682
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2Mzk4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '67829562804',
                    'mac_address': 'd0:21:f9:9b:63:98',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '983279540878',
                    'poller_hash': 'ZDAyMWY5OWE2Mzk4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19151PintailCt',
                'serial_number':
                'UBNTf99a6398',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:63:98',
                'temperature':
                40.0,
                'uptime':
                '2905336'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '160422727981',
                    'links': [{
                        'in_octets': '160422727981',
                        'out_octets': '13102342619',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13102342619',
                    'poller_hash':
                    'ZDAyMWY5OWE2NTE4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833623',
                            'fiber_length': 15882,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.414
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2NTE4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '13102342619',
                    'mac_address': 'd0:21:f9:9b:65:18',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '160422727981',
                    'poller_hash': 'ZDAyMWY5OWE2NTE4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19164PintailCt',
                'serial_number':
                'UBNTf99a6518',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:65:18',
                'temperature':
                46.0,
                'uptime':
                '833664'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1286202225421',
                    'links': [{
                        'in_octets': '1286202225421',
                        'out_octets': '69955251863',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '69955251863',
                    'poller_hash':
                    'ZDAyMWY5OWE2NTQ4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2764900',
                            'fiber_length': 15566,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.156,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.96
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2NTQ4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '69955251863',
                    'mac_address': 'd0:21:f9:9b:65:48',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1286202225421',
                    'poller_hash': 'ZDAyMWY5OWE2NTQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19116NicholsonFarmLn',
                'serial_number':
                'UBNTf99a6548',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:65:48',
                'temperature':
                47.0,
                'uptime':
                '2764939'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '38626237646',
                    'links': [{
                        'in_octets': '38626237646',
                        'out_octets': '1814409027',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1814409027',
                    'poller_hash':
                    'ZDAyMWY5OWE2NTVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '314588',
                            'fiber_length': 15682,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.704,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.956
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2NTVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '1814409027',
                    'mac_address': 'd0:21:f9:9b:65:5c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '38626237646',
                    'poller_hash': 'ZDAyMWY5OWE2NTVjZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19260SwanCt',
                'serial_number':
                'UBNTf99a655c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:65:5c',
                'temperature':
                40.0,
                'uptime':
                '314628'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '958724239744',
                    'links': [{
                        'in_octets': '958724239744',
                        'out_octets': '61292469972',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '61292469972',
                    'poller_hash':
                    'ZDAyMWY5OWE2NTcwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2566168',
                            'fiber_length': 16111,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.624,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.152
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2NTcwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '61292469972',
                    'mac_address': 'd0:21:f9:9b:65:70',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '958724239744',
                    'poller_hash': 'ZDAyMWY5OWE2NTcwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '36460ShoemakerSchoolRd',
                'serial_number':
                'UBNTf99a6570',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:65:70',
                'temperature':
                38.0,
                'uptime':
                '2567416'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '261383580621',
                    'links': [{
                        'in_octets': '261383580621',
                        'out_octets': '55038145877',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '55038145877',
                    'poller_hash':
                    'ZDAyMWY5OWE2NTc0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '948054',
                            'fiber_length': 15322,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.62,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.2
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2NTc0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '55038145877',
                    'mac_address': 'd0:21:f9:9b:65:74',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '261383580621',
                    'poller_hash': 'ZDAyMWY5OWE2NTc0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19184SwanCt',
                'serial_number':
                'UBNTf99a6574',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:65:74',
                'temperature':
                39.0,
                'uptime':
                '948093'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '314294341270',
                    'links': [{
                        'in_octets': '314294341270',
                        'out_octets': '39318486675',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '39318486675',
                    'poller_hash':
                    'ZDAyMWY5OWE2NWQwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2662229',
                            'fiber_length': 15780,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.436,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.204
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2NWQwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '39318486675',
                    'mac_address': 'd0:21:f9:9b:65:d0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '314294341270',
                    'poller_hash': 'ZDAyMWY5OWE2NWQwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '36415ShoemakerSchoolRd',
                'serial_number':
                'UBNTf99a65d0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:65:d0',
                'temperature':
                41.0,
                'uptime':
                '2662268'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1052726516247',
                    'links': [{
                        'in_octets': '1052726516247',
                        'out_octets': '52196691090',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '52196691090',
                    'poller_hash':
                    'ZDAyMWY5OWE2NjY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2160565',
                            'fiber_length': 16158,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.984,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.054
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2NjY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '52196691090',
                    'mac_address': 'd0:21:f9:9b:66:68',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1052726516247',
                    'poller_hash': 'ZDAyMWY5OWE2NjY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19193PintailCt',
                'serial_number':
                'UBNTf99a6668',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:66:68',
                'temperature':
                41.0,
                'uptime':
                '2160610'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '140582636676',
                    'links': [{
                        'in_octets': '140582636676',
                        'out_octets': '18167547944',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18167547944',
                    'poller_hash':
                    'ZDAyMWY5OWE2OGIwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2144715',
                            'fiber_length': 16191,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.544,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.334
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2OGIwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '18167547944',
                    'mac_address': 'd0:21:f9:9b:68:b0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '140582636676',
                    'poller_hash': 'ZDAyMWY5OWE2OGIwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '36466ShoemakerSchoolRd',
                'serial_number':
                'UBNTf99a68b0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:68:b0',
                'temperature':
                38.0,
                'uptime':
                '2144973'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1378430172533',
                    'links': [{
                        'in_octets': '1378430172533',
                        'out_octets': '64682686650',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '64682686650',
                    'poller_hash':
                    'MThlODI5MGIzZmYwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3244914',
                            'fiber_length': 12060,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.318,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.306
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGIzZmYwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '64682686650',
                    'mac_address': '18:e8:29:0c:3f:f0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1378430172533',
                    'poller_hash': 'MThlODI5MGIzZmYwZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19443JodhpurDr',
                'serial_number':
                'UBNT290b3ff0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '18:e8:29:0b:3f:f0',
                'temperature':
                42.0,
                'uptime':
                '3244959'
            }, {
                'admin_disabled':
                False,
                'cpu':
                0.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '103243505750',
                    'links': [{
                        'in_octets': '103243505750',
                        'out_octets': '58935837394',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '58935837394',
                    'poller_hash':
                    'NzRhY2I5OTllOGUycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833693',
                            'fiber_length': 12030,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.728,
                            'tx_link_rate': '1244160000',
                            'tx_power': 4.34
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5OTllOGUycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '58935837394',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '103243505750',
                    'poller_hash': 'NzRhY2I5OTllOGUyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                39.0,
                'model':
                'Instant',
                'name':
                'UBNTb999e8e2',
                'serial_number':
                'UBNTb999e8e2',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:ac:b9:99:e8:e2',
                'temperature':
                70.0,
                'uptime':
                '833810'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '542051877093',
                    'links': [{
                        'in_octets': '542051877093',
                        'out_octets': '97716269138',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '97716269138',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDQzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 11596,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.188,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.758
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDQzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '97716269138',
                    'mac_address': '74:83:c2:69:e0:43',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '542051877093',
                    'poller_hash': 'NzQ4M2MyNjhlMDQzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19144ShelburneGlebeRd',
                'serial_number':
                'UBNTc268e043',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:43',
                'temperature':
                47.0,
                'uptime':
                '4278503'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '804364868742',
                    'links': [{
                        'in_octets': '804364868742',
                        'out_octets': '166413636836',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '166413636836',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDUwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7144038',
                            'fiber_length': 11983,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.664,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.808
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDUwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '166413636836',
                    'mac_address': '74:83:c2:69:e0:50',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '804364868742',
                    'poller_hash': 'NzQ4M2MyNjhlMDUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19464JodhpurDr',
                'serial_number':
                'UBNTc268e050',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:50',
                'temperature':
                45.0,
                'uptime':
                '7144078'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '299499908771',
                    'links': [{
                        'in_octets': '299499908771',
                        'out_octets': '33046972656',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '33046972656',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTc3cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 11159,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.096
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMTc3cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '33046972656',
                    'mac_address': '74:83:c2:69:e1:77',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '299499908771',
                    'poller_hash': 'NzQ4M2MyNjhlMTc3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19277OaklandGreenRd',
                'serial_number':
                'UBNTc268e177',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:77',
                'temperature':
                43.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '581947443928',
                    'links': [{
                        'in_octets': '581947443928',
                        'out_octets': '28410002462',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28410002462',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWJicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278453',
                            'fiber_length': 11311,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.468,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.502
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWJicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '28410002462',
                    'mac_address': '74:83:c2:69:e1:bb',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '581947443928',
                    'poller_hash': 'NzQ4M2MyNjhlMWJiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19396LincolnRd',
                'serial_number':
                'UBNTc268e1bb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:bb',
                'temperature':
                50.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '339625360998',
                    'links': [{
                        'in_octets': '339625360998',
                        'out_octets': '35219493695',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '35219493695',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWNicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4997559',
                            'fiber_length': 12072,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.03,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.222
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWNicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '35219493695',
                    'mac_address': '74:83:c2:69:e1:cb',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '339625360998',
                    'poller_hash': 'NzQ4M2MyNjhlMWNiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19432JodhpurDr',
                'serial_number':
                'UBNTc268e1cb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:cb',
                'temperature':
                41.0,
                'uptime':
                '4997605'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '562509529652',
                    'links': [{
                        'in_octets': '562509529652',
                        'out_octets': '50812142746',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '50812142746',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWNkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3887420',
                            'fiber_length': 11077,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.554,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.976
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWNkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '50812142746',
                    'mac_address': '74:83:c2:69:e1:cd',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '562509529652',
                    'poller_hash': 'NzQ4M2MyNjhlMWNkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19299OaklandGreenRd',
                'serial_number':
                'UBNTc268e1cd',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:cd',
                'temperature':
                29.0,
                'uptime':
                '3887463'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1198772314150',
                    'links': [{
                        'in_octets': '1198772314150',
                        'out_octets': '137985309916',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '137985309916',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzMycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278453',
                            'fiber_length': 11218,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.314,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.966
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzMycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '137985309916',
                    'mac_address': '74:83:c2:69:e3:32',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1198772314150',
                    'poller_hash': 'NzQ4M2MyNjhlMzMyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38298HuntsEndPl',
                'serial_number':
                'UBNTc268e332',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:32',
                'temperature':
                46.0,
                'uptime':
                '4278503'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '489216405112',
                    'links': [{
                        'in_octets': '489216405112',
                        'out_octets': '51831183827',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '51831183827',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzNicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278453',
                            'fiber_length': 12015,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.166,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.18
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMzNicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '51831183827',
                    'mac_address': '74:83:c2:69:e3:3b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '489216405112',
                    'poller_hash': 'NzQ4M2MyNjhlMzNiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19496JodhpurDr',
                'serial_number':
                'UBNTc268e33b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:3b',
                'temperature':
                43.0,
                'uptime':
                '4278505'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '409019139729',
                    'links': [{
                        'in_octets': '409019139729',
                        'out_octets': '39274623155',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '39274623155',
                    'poller_hash':
                    'NzQ4M2MyZjAyOWNjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833613',
                            'fiber_length': 12446,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.456,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.788
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAyOWNjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '39274623155',
                    'mac_address': '74:83:c2:f1:29:cc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '409019139729',
                    'poller_hash': 'NzQ4M2MyZjAyOWNjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19108NicholsonFarmLn',
                'serial_number':
                'UBNTc2f029cc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:29:cc',
                'temperature':
                50.0,
                'uptime':
                '833654'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1611139413248',
                    'links': [{
                        'in_octets': '1611139413248',
                        'out_octets': '150142253877',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '150142253877',
                    'poller_hash':
                    'NzQ4M2MyZjAzZmI0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4997559',
                            'fiber_length': 11484,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.064,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.928
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAzZmI0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '150142253877',
                    'mac_address': '74:83:c2:f1:3f:b4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1611139413248',
                    'poller_hash': 'NzQ4M2MyZjAzZmI0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38276HuntsEndPl',
                'serial_number':
                'UBNTc2f03fb4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:3f:b4',
                'temperature':
                48.0,
                'uptime':
                '4997605'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '773416988603',
                    'links': [{
                        'in_octets': '773416988603',
                        'out_octets': '29177723323',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '29177723323',
                    'poller_hash':
                    'NzQ4M2MyZjA2OGU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2207095',
                            'fiber_length': 7900,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.356,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.138
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjA2OGU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '29177723323',
                    'mac_address': '74:83:c2:f1:68:e4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '773416988603',
                    'poller_hash': 'NzQ4M2MyZjA2OGU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '37330WileyChaseLn',
                'serial_number':
                'UBNTc2f068e4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:68:e4',
                'temperature':
                41.0,
                'uptime':
                '2893945'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '443085698340',
                    'links': [{
                        'in_octets': '443085698340',
                        'out_octets': '17546018017',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17546018017',
                    'poller_hash':
                    'ZDAyMWY5OWE2NTg0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2761630',
                            'fiber_length': 12737,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.086,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.114
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2NTg0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '17546018017',
                    'mac_address': 'd0:21:f9:9b:65:84',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '443085698340',
                    'poller_hash': 'ZDAyMWY5OWE2NTg0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19040NicholsonFarmLn',
                'serial_number':
                'UBNTf99a6584',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:65:84',
                'temperature':
                46.0,
                'uptime':
                '2761668'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '89696434174',
                    'links': [{
                        'in_octets': '89696434174',
                        'out_octets': '9572622904',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9572622904',
                    'poller_hash':
                    'ZDAyMWY5OWE2OWU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '665452',
                            'fiber_length': 10818,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.746,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.22
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2OWU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '9572622904',
                    'mac_address': 'd0:21:f9:9b:69:e4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '89696434174',
                    'poller_hash': 'ZDAyMWY5OWE2OWU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19192OaklandGreenRd',
                'serial_number':
                'UBNTf99a69e4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:69:e4',
                'temperature':
                45.0,
                'uptime':
                '665495'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '521901715225',
                    'links': [{
                        'in_octets': '521901715225',
                        'out_octets': '95782914966',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '95782914966',
                    'poller_hash':
                    'ZDAyMWY5OWE2YTQ0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278453',
                            'fiber_length': 10967,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.798,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.556
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YTQ0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '95782914966',
                    'mac_address': 'd0:21:f9:9b:6a:44',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '521901715225',
                    'poller_hash': 'ZDAyMWY5OWE2YTQ0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19328LincolnRd',
                'serial_number':
                'UBNTf99a6a44',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6a:44',
                'temperature':
                41.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '156793311470',
                    'links': [{
                        'in_octets': '156793311470',
                        'out_octets': '18239730929',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18239730929',
                    'poller_hash':
                    'ZDAyMWY5OWE2YTY0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833133',
                            'fiber_length': 12496,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.798,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.99
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YTY0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '18239730929',
                    'mac_address': 'd0:21:f9:9b:6a:64',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '156793311470',
                    'poller_hash': 'ZDAyMWY5OWE2YTY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19150NicholsonFarmLn',
                'serial_number':
                'UBNTf99a6a64',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6a:64',
                'temperature':
                48.0,
                'uptime':
                '833173'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1629541492753',
                    'links': [{
                        'in_octets': '1629541492753',
                        'out_octets': '65745451819',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '65745451819',
                    'poller_hash':
                    'ZDAyMWY5OWE2YjZjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 8265,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.824,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.334
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YjZjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '65745451819',
                    'mac_address': 'd0:21:f9:9b:6b:6c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1629541492753',
                    'poller_hash': 'ZDAyMWY5OWE2YjZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19423LincolnRd',
                'serial_number':
                'UBNTf99a6b6c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6b:6c',
                'temperature':
                42.0,
                'uptime':
                '4278503'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1991524037999',
                    'links': [{
                        'in_octets': '1991524037999',
                        'out_octets': '204582276691',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '204582276691',
                    'poller_hash':
                    'ZDAyMWY5OWE2YjcwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4069192',
                            'fiber_length': 9924,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.376,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.118
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YjcwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '204582276691',
                    'mac_address': 'd0:21:f9:9b:6b:70',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1991524037999',
                    'poller_hash': 'ZDAyMWY5OWE2YjcwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '18783TelegraphSpringsRd',
                'serial_number':
                'UBNTf99a6b70',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6b:70',
                'temperature':
                41.0,
                'uptime':
                '4559946'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '208972267153',
                    'links': [{
                        'in_octets': '208972267153',
                        'out_octets': '467525045560',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '467525045560',
                    'poller_hash':
                    'ZDAyMWY5OWE2YjdjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 10882,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.96,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.1
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YjdjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '467525045560',
                    'mac_address': 'd0:21:f9:9b:6b:7c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '208972267153',
                    'poller_hash': 'ZDAyMWY5OWE2YjdjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19323OaklandGreenRd',
                'serial_number':
                'UBNTf99a6b7c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6b:7c',
                'temperature':
                45.0,
                'uptime':
                '4278503'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2905404066142',
                    'links': [{
                        'in_octets': '2905404066142',
                        'out_octets': '310969088212',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '310969088212',
                    'poller_hash':
                    'ZDAyMWY5OWE2YzgwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7147668',
                            'fiber_length': 11413,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.086,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.378
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YzgwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '310969088212',
                    'mac_address': 'd0:21:f9:9b:6c:80',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2905404066142',
                    'poller_hash': 'ZDAyMWY5OWE2YzgwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19514LincolnRd',
                'serial_number':
                'UBNTf99a6c80',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6c:80',
                'temperature':
                40.0,
                'uptime':
                '11087297'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '604577138728',
                    'links': [{
                        'in_octets': '604577138728',
                        'out_octets': '58344509241',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '58344509241',
                    'poller_hash':
                    'ZDAyMWY5OWE2ZGNjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4997559',
                            'fiber_length': 10202,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.042,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.23
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2ZGNjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '58344509241',
                    'mac_address': 'd0:21:f9:9b:6d:cc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '604577138728',
                    'poller_hash': 'ZDAyMWY5OWE2ZGNjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38110GospondLn',
                'serial_number':
                'UBNTf99a6dcc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6d:cc',
                'temperature':
                44.0,
                'uptime':
                '4997606'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3100243215818',
                    'links': [{
                        'in_octets': '3100243215818',
                        'out_octets': '124994783885',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '124994783885',
                    'poller_hash':
                    'ZDAyMWY5OWE2ZTI0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4997559',
                            'fiber_length': 11279,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.43,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.29
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2ZTI0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '124994783885',
                    'mac_address': 'd0:21:f9:9b:6e:24',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3100243215818',
                    'poller_hash': 'ZDAyMWY5OWE2ZTI0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19269OaklandsGreenRd',
                'serial_number':
                'UBNTf99a6e24',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6e:24',
                'temperature':
                40.0,
                'uptime':
                '4997605'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '969079701468',
                    'links': [{
                        'in_octets': '969079701468',
                        'out_octets': '21520436418',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '21520436418',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDkzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4261533',
                            'fiber_length': 2762,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.112,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.204
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMDkzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '21520436418',
                    'mac_address': '74:83:c2:69:e0:93',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '969079701468',
                    'poller_hash': 'NzQ4M2MyNjhlMDkzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19110ShelburneGlebeRd',
                'serial_number':
                'UBNTc268e093',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:93',
                'temperature':
                43.0,
                'uptime':
                '4261581'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '347983704827',
                    'links': [{
                        'in_octets': '347983704827',
                        'out_octets': '18157842209',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18157842209',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWNhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2306656',
                            'fiber_length': 3260,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.11,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.4
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWNhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '18157842209',
                    'mac_address': '74:83:c2:69:e1:ca',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '347983704827',
                    'poller_hash': 'NzQ4M2MyNjhlMWNhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38313NorthForkRd',
                'serial_number':
                'UBNTc268e1ca',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:ca',
                'temperature':
                48.0,
                'uptime':
                '2306703'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '638499111925',
                    'links': [{
                        'in_octets': '638499111925',
                        'out_octets': '23950416454',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '23950416454',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWQ1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278453',
                            'fiber_length': 2626,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.142,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.816
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWQ1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '23950416454',
                    'mac_address': '74:83:c2:69:e1:d5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '638499111925',
                    'poller_hash': 'NzQ4M2MyNjhlMWQ1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38307NorthForkRd',
                'serial_number':
                'UBNTc268e1d5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:d5',
                'temperature':
                46.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '881262437368',
                    'links': [{
                        'in_octets': '881262437368',
                        'out_octets': '19653761561',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '19653761561',
                    'poller_hash':
                    'NzQ4M2MyNjhlMWY0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278413',
                            'fiber_length': 1900,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -9.25,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.938
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMWY0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '19653761561',
                    'mac_address': '74:83:c2:69:e1:f4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '881262437368',
                    'poller_hash': 'NzQ4M2MyNjhlMWY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38110NorthForkRd',
                'serial_number':
                'UBNTc268e1f4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:f4',
                'temperature':
                36.0,
                'uptime':
                '4278452'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '82279656275',
                    'links': [{
                        'in_octets': '82279656275',
                        'out_octets': '5828413357',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5828413357',
                    'poller_hash':
                    'NzQ4M2MyNjhlMjFicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833603',
                            'fiber_length': 2367,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.77,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.242
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhlMjFicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '5828413357',
                    'mac_address': '74:83:c2:69:e2:1b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '82279656275',
                    'poller_hash': 'NzQ4M2MyNjhlMjFiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '20017ShelburneGlebeRd',
                'serial_number':
                'UBNTc268e21b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:1b',
                'temperature':
                40.0,
                'uptime':
                '833645'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '278751320357',
                    'links': [{
                        'in_octets': '278751320357',
                        'out_octets': '10753248487',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10753248487',
                    'poller_hash':
                    'NzQ4M2MyZjAyNzU4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4056632',
                            'fiber_length': 2305,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.318,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.31
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAyNzU4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '10753248487',
                    'mac_address': '74:83:c2:f1:27:58',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '278751320357',
                    'poller_hash': 'NzQ4M2MyZjAyNzU4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38236NorthForkRd-House',
                'serial_number':
                'UBNTc2f02758',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:27:58',
                'temperature':
                47.0,
                'uptime':
                '4056679'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '8344825064',
                    'links': [{
                        'in_octets': '8344825064',
                        'out_octets': '802491631',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '802491631',
                    'poller_hash':
                    'NzQ4M2MyZjAyOTBjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 2388,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.916
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAyOTBjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '802491631',
                    'mac_address': '74:83:c2:f1:29:0c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '8344825064',
                    'poller_hash': 'NzQ4M2MyZjAyOTBjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38236NorthForkRd-Garage',
                'serial_number':
                'UBNTc2f0290c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:29:0c',
                'temperature':
                35.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '127421559740',
                    'links': [{
                        'in_octets': '127421559740',
                        'out_octets': '23627117702',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '23627117702',
                    'poller_hash':
                    'NzQ4M2MyZjAyOWM4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '423039',
                            'fiber_length': 3392,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.604,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.136
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAyOWM4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '23627117702',
                    'mac_address': '74:83:c2:f1:29:c8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '127421559740',
                    'poller_hash': 'NzQ4M2MyZjAyOWM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '38253NorthForkRd',
                'serial_number':
                'UBNTc2f029c8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:29:c8',
                'temperature':
                49.0,
                'uptime':
                '4280434'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '133989600571',
                    'links': [{
                        'in_octets': '133989600571',
                        'out_octets': '6684940984',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6684940984',
                    'poller_hash':
                    'NzQ4M2MyZjAzMGY0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '834323',
                            'fiber_length': 2271,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.904,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.236
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAzMGY0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '6684940984',
                    'mac_address': '74:83:c2:f1:30:f4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '133989600571',
                    'poller_hash': 'NzQ4M2MyZjAzMGY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19985ShelburneGlebeRd',
                'serial_number':
                'UBNTc2f030f4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:30:f4',
                'temperature':
                47.0,
                'uptime':
                '834371'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '546286601691',
                    'links': [{
                        'in_octets': '546286601691',
                        'out_octets': '51032775231',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '51032775231',
                    'poller_hash':
                    'NzQ4M2MyZjAzMTQwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2491318',
                            'fiber_length': 3308,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.18,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.584
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjAzMTQwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '51032775231',
                    'mac_address': '74:83:c2:f1:31:40',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '546286601691',
                    'poller_hash': 'NzQ4M2MyZjAzMTQwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38213NorthForkRd',
                'serial_number':
                'UBNTc2f03140',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:31:40',
                'temperature':
                31.0,
                'uptime':
                '2491356'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '486241716971',
                    'links': [{
                        'in_octets': '486241716971',
                        'out_octets': '28129386784',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28129386784',
                    'poller_hash':
                    'ZDAyMWY5OWE1Mjc0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 2559,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.328,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.364
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE1Mjc0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '28129386784',
                    'mac_address': 'd0:21:f9:9b:52:74',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '486241716971',
                    'poller_hash': 'ZDAyMWY5OWE1Mjc0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19976ShelburneGlebeRd',
                'serial_number':
                'UBNTf99a5274',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:52:74',
                'temperature':
                51.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '689704574249',
                    'links': [{
                        'in_octets': '689704574249',
                        'out_octets': '336605294975',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '336605294975',
                    'poller_hash':
                    'ZDAyMWY5OWE2NDkwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2569389',
                            'fiber_length': 2462,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.824,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.274
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2NDkwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '336605294975',
                    'mac_address': 'd0:21:f9:9b:64:90',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '689704574249',
                    'poller_hash': 'ZDAyMWY5OWE2NDkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38211NorthForkRd',
                'serial_number':
                'UBNTf99a6490',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:64:90',
                'temperature':
                41.0,
                'uptime':
                '2569434'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '0',
                    'links': [{
                        'in_octets': '0',
                        'out_octets': '94',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '94',
                    'poller_hash':
                    'ZDAyMWY5OWE2YTg4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278463',
                            'fiber_length': 2679,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.09,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.972
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YTg4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '94',
                    'mac_address': 'd0:21:f9:9b:6a:88',
                    'name': 'eth0',
                    'oper_up': False,
                    'out_octets': '0',
                    'poller_hash': 'ZDAyMWY5OWE2YTg4ZXRoMQ=='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38287NorthForkRd-Shed',
                'serial_number':
                'UBNTf99a6a88',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6a:88',
                'temperature':
                36.0,
                'uptime':
                '4278504'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3762863382520',
                    'links': [{
                        'in_octets': '3762863382520',
                        'out_octets': '160497034318',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '160497034318',
                    'poller_hash':
                    'ZDAyMWY5OWE2YTkwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7146988',
                            'fiber_length': 2619,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.924,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.538
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YTkwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '160497034318',
                    'mac_address': 'd0:21:f9:9b:6a:90',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3762863382520',
                    'poller_hash': 'ZDAyMWY5OWE2YTkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '38287NorthForkRd-House',
                'serial_number':
                'UBNTf99a6a90',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6a:90',
                'temperature':
                48.0,
                'uptime':
                '7147030'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '299600356873',
                    'links': [{
                        'in_octets': '299600356873',
                        'out_octets': '30002950143',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '30002950143',
                    'poller_hash':
                    'ZDAyMWY5OWE2YWYwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '510630',
                            'fiber_length': 2599,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.396
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YWYwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '30002950143',
                    'mac_address': 'd0:21:f9:9b:6a:f0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '299600356873',
                    'poller_hash': 'ZDAyMWY5OWE2YWYwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19906ShelburneGlebeRd',
                'serial_number':
                'UBNTf99a6af0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6a:f0',
                'temperature':
                46.0,
                'uptime':
                '510676'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '327293401453',
                    'links': [{
                        'in_octets': '327293401453',
                        'out_octets': '28674891079',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28674891079',
                    'poller_hash':
                    'ZDAyMWY5OWE2YmFjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4278453',
                            'fiber_length': 2577,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.848,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.236
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE2YmFjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '28674891079',
                    'mac_address': 'd0:21:f9:9b:6b:ac',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '327293401453',
                    'poller_hash': 'ZDAyMWY5OWE2YmFjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19970ShelburneGlebeRd',
                'serial_number':
                'UBNTf99a6bac',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'd0:21:f9:9a:6b:ac',
                'temperature':
                50.0,
                'uptime':
                '4278504'
            }]
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_4_8_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.4.8.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 243,
            'sw_version': '4.4.8',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 30}
        exp_sta_stats = {
            '18:e8:29:0b:7a:b8': {
                'dev_macs': None,
                'ip_address': '100.65.30.104',
                'mac_address': '18:e8:29:0b:7a:b8',
                'name': 'Diana Escarcega - 94943'
            },
            '18:e8:29:0b:7b:20': {
                'dev_macs': None,
                'ip_address': '100.65.28.194',
                'mac_address': '18:e8:29:0b:7b:20',
                'name': 'VMartinez-83158'
            },
            '18:e8:29:0b:96:5c': {
                'dev_macs': None,
                'ip_address': '100.65.3.230',
                'mac_address': '18:e8:29:0b:96:5c',
                'name': 'GWilcox-96157'
            },
            '18:e8:29:0b:97:64': {
                'dev_macs': None,
                'ip_address': '100.65.27.158',
                'mac_address': '18:e8:29:0b:97:64',
                'name': 'PRiley-94133'
            },
            '18:e8:29:0b:97:90': {
                'dev_macs': None,
                'ip_address': '100.65.27.172',
                'mac_address': '18:e8:29:0b:97:90',
                'name': 'Levi Lunsford (Barn) - 92832'
            },
            '18:e8:29:0b:99:6c': {
                'dev_macs': None,
                'ip_address': '107.178.31.98',
                'mac_address': '18:e8:29:0b:99:6c',
                'name': 'TexasPanhandleLogistics-94290'
            },
            '18:e8:29:0b:9b:d8': {
                'dev_macs': None,
                'ip_address': '100.65.7.37',
                'mac_address': '18:e8:29:0b:9b:d8',
                'name': "Mario's Heating and Air "
                'Conditioning - 85808'
            },
            '18:e8:29:0b:ad:cc': {
                'dev_macs': None,
                'ip_address': '52.129.120.82',
                'mac_address': '18:e8:29:0b:ad:cc',
                'name': '605DaqShack-96050'
            },
            '18:e8:29:0b:ae:04': {
                'dev_macs': None,
                'ip_address': '100.65.29.24',
                'mac_address': '18:e8:29:0b:ae:04',
                'name': 'PMedina-95333'
            },
            '18:e8:29:0b:ae:0c': {
                'dev_macs': None,
                'ip_address': '100.65.27.185',
                'mac_address': '18:e8:29:0b:ae:0c',
                'name': 'JPerez-95045'
            },
            '18:e8:29:0b:ae:68': {
                'dev_macs': None,
                'ip_address': '100.65.30.97',
                'mac_address': '18:e8:29:0b:ae:68',
                'name': 'Armando Prieto - 94883'
            },
            '18:e8:29:0b:ae:9c': {
                'dev_macs': None,
                'ip_address': '100.65.27.196',
                'mac_address': '18:e8:29:0b:ae:9c',
                'name': 'KRamirez - 94442'
            },
            '18:e8:29:0b:af:08': {
                'dev_macs': None,
                'ip_address': '100.65.25.132',
                'mac_address': '18:e8:29:0b:af:08',
                'name': 'JCastillo-95065'
            },
            '18:e8:29:0b:b0:3c': {
                'dev_macs': ['c0:ea:e4:8b:e8:41'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:3c',
                'name': 'WBEquipment-76404'
            },
            '18:e8:29:0b:b0:50': {
                'dev_macs': None,
                'ip_address': '100.65.30.7',
                'mac_address': '18:e8:29:0b:b0:50',
                'name': 'PBradley-94852'
            },
            '18:e8:29:0b:b0:74': {
                'dev_macs': None,
                'ip_address': '100.65.26.28',
                'mac_address': '18:e8:29:0b:b0:74',
                'name': 'JAguero-95502'
            },
            '18:e8:29:0b:b0:78': {
                'dev_macs': None,
                'ip_address': '100.65.30.85',
                'mac_address': '18:e8:29:0b:b0:78',
                'name': 'BScottJr -94888'
            },
            '18:e8:29:0b:b0:a4': {
                'dev_macs': None,
                'ip_address': '100.65.29.207',
                'mac_address': '18:e8:29:0b:b0:a4',
                'name': 'OQuintana-94823'
            },
            '18:e8:29:0b:b0:c4': {
                'dev_macs': None,
                'ip_address': '100.65.30.59',
                'mac_address': '18:e8:29:0b:b0:c4',
                'name': 'DPrieto-94861'
            },
            '18:e8:29:0b:b0:d0': {
                'dev_macs': None,
                'ip_address': '100.65.25.209',
                'mac_address': '18:e8:29:0b:b0:d0',
                'name': 'ESaenz-95379'
            },
            '18:e8:29:0b:b0:d8': {
                'dev_macs': None,
                'ip_address': '100.65.29.204',
                'mac_address': '18:e8:29:0b:b0:d8',
                'name': 'IDeLaCruz-95739'
            },
            '18:e8:29:0b:b0:e0': {
                'dev_macs': None,
                'ip_address': '100.65.30.40',
                'mac_address': '18:e8:29:0b:b0:e0',
                'name': 'BGriswold-96935'
            },
            '18:e8:29:0b:d9:f8': {
                'dev_macs': None,
                'ip_address': '52.129.126.53',
                'mac_address': '18:e8:29:0b:d9:f8',
                'name': 'DGoldsmith-95707'
            },
            '18:e8:29:0b:db:28': {
                'dev_macs': None,
                'ip_address': '100.65.30.30',
                'mac_address': '18:e8:29:0b:db:28',
                'name': 'AMartinez - 94229'
            },
            '18:e8:29:0b:db:e0': {
                'dev_macs': None,
                'ip_address': '100.65.30.20',
                'mac_address': '18:e8:29:0b:db:e0',
                'name': 'ADaniel-96546'
            },
            '18:e8:29:0b:dc:68': {
                'dev_macs': None,
                'ip_address': '100.65.27.192',
                'mac_address': '18:e8:29:0b:dc:68',
                'name': 'VLopez-96059'
            },
            '18:e8:29:0b:e0:b0': {
                'dev_macs': None,
                'ip_address': '52.129.126.79',
                'mac_address': '18:e8:29:0b:e0:b0',
                'name': 'GVasquez-90370'
            },
            '18:e8:29:0b:e1:60': {
                'dev_macs': None,
                'ip_address': '100.65.26.55',
                'mac_address': '18:e8:29:0b:e1:60',
                'name': 'HBonilla - 96429'
            },
            '18:e8:29:19:5a:82': {
                'dev_macs': None,
                'ip_address': '100.65.2.73',
                'mac_address': '18:e8:29:19:5a:82',
                'name': 'CGregory-83114'
            },
            '18:e8:29:19:5a:c3': {
                'dev_macs': None,
                'ip_address': '100.65.2.21',
                'mac_address': '18:e8:29:19:5a:c3',
                'name': 'RMartinezSr-83350'
            },
            '18:e8:29:19:5a:c8': {
                'dev_macs': None,
                'ip_address': '100.65.2.63',
                'mac_address': '18:e8:29:19:5a:c8',
                'name': 'AMalapady-83057'
            },
            '18:e8:29:19:5e:d8': {
                'dev_macs': None,
                'ip_address': '100.65.2.157',
                'mac_address': '18:e8:29:19:5e:d8',
                'name': 'DangFineTrucking-82660'
            },
            '18:e8:29:19:5e:f6': {
                'dev_macs': None,
                'ip_address': '100.65.2.113',
                'mac_address': '18:e8:29:19:5e:f6',
                'name': 'RGwinn - 83131'
            },
            '18:e8:29:19:5e:fb': {
                'dev_macs': None,
                'ip_address': '100.65.0.40',
                'mac_address': '18:e8:29:19:5e:fb',
                'name': 'ZPrice-83277'
            },
            '18:e8:29:19:5f:00': {
                'dev_macs': None,
                'ip_address': '52.129.124.85',
                'mac_address': '18:e8:29:19:5f:00',
                'name': 'SchafferCommunityCenter-83330'
            },
            '18:e8:29:19:81:24': {
                'dev_macs': None,
                'ip_address': '100.65.0.52',
                'mac_address': '18:e8:29:19:81:24',
                'name': 'SKinser-81531'
            },
            '18:e8:29:19:81:29': {
                'dev_macs': None,
                'ip_address': '100.65.0.16',
                'mac_address': '18:e8:29:19:81:29',
                'name': 'ONavarro-76397'
            },
            '18:e8:29:19:ae:24': {
                'dev_macs': None,
                'ip_address': '100.65.0.19',
                'mac_address': '18:e8:29:19:ae:24',
                'name': 'JFlynt-81277'
            },
            '18:e8:29:19:b4:5a': {
                'dev_macs': ['18:b1:69:b1:59:d1'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b4:5a',
                'name': 'HigginbothamBrothers-80554'
            },
            '18:e8:29:19:b4:a0': {
                'dev_macs': None,
                'ip_address': '100.65.0.24',
                'mac_address': '18:e8:29:19:b4:a0',
                'name': 'KAljoe-81385'
            },
            '18:e8:29:19:b4:a5': {
                'dev_macs': None,
                'ip_address': '100.65.0.23',
                'mac_address': '18:e8:29:19:b4:a5',
                'name': 'COkamoto-81278'
            },
            '18:e8:29:19:b4:af': {
                'dev_macs': None,
                'ip_address': '100.65.0.121',
                'mac_address': '18:e8:29:19:b4:af',
                'name': 'CRivera-76079'
            },
            '18:e8:29:19:b4:e6': {
                'dev_macs': None,
                'ip_address': '100.65.0.17',
                'mac_address': '18:e8:29:19:b4:e6',
                'name': 'MFlores-81129'
            },
            '18:e8:29:19:b4:eb': {
                'dev_macs': None,
                'ip_address': '100.65.2.220',
                'mac_address': '18:e8:29:19:b4:eb',
                'name': 'ANino_85173'
            },
            '18:e8:29:f5:d3:cd': {
                'dev_macs': ['cc:9c:3e:50:b4:eb'],
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d3:cd',
                'name': 'Happy State Bank-88420'
            },
            '18:e8:29:f5:d3:d4': {
                'dev_macs': None,
                'ip_address': '100.65.28.172',
                'mac_address': '18:e8:29:f5:d3:d4',
                'name': 'LAlvarez-90544'
            },
            '18:e8:29:f5:d4:0f': {
                'dev_macs': None,
                'ip_address': '100.65.25.210',
                'mac_address': '18:e8:29:f5:d4:0f',
                'name': 'JMcLean-88569'
            },
            '18:e8:29:f5:d4:77': {
                'dev_macs': None,
                'ip_address': '100.65.25.28',
                'mac_address': '18:e8:29:f5:d4:77',
                'name': 'NSantellano-87956'
            },
            '18:e8:29:f5:d4:be': {
                'dev_macs': ['3c:ec:ef:6f:29:ce', '3c:ec:ef:6f:30:21'],
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d4:be',
                'name': 'FirstUnitedBankDimmitt-76416'
            },
            '18:e8:29:f5:d4:f6': {
                'dev_macs': None,
                'ip_address': '100.65.25.198',
                'mac_address': '18:e8:29:f5:d4:f6',
                'name': 'RMcDaniel-88515'
            },
            '18:e8:29:f5:d4:fb': {
                'dev_macs': None,
                'ip_address': '100.65.25.245',
                'mac_address': '18:e8:29:f5:d4:fb',
                'name': 'DBall-88672'
            },
            '18:e8:29:f5:d4:fc': {
                'dev_macs': None,
                'ip_address': '100.65.25.191',
                'mac_address': '18:e8:29:f5:d4:fc',
                'name': 'JHunkins-88542'
            },
            '18:e8:29:f5:d4:fe': {
                'dev_macs': None,
                'ip_address': '100.65.25.195',
                'mac_address': '18:e8:29:f5:d4:fe',
                'name': 'SOltivero-88505'
            },
            '68:d7:9a:06:49:c6': {
                'dev_macs': None,
                'ip_address': '100.65.29.147',
                'mac_address': '68:d7:9a:06:49:c6',
                'name': 'JLeal-90888'
            },
            '68:d7:9a:06:67:a9': {
                'dev_macs': None,
                'ip_address': '52.129.120.235',
                'mac_address': '68:d7:9a:06:67:a9',
                'name': 'DProffitt-96297'
            },
            '68:d7:9a:06:67:b9': {
                'dev_macs': None,
                'ip_address': '100.65.28.44',
                'mac_address': '68:d7:9a:06:67:b9',
                'name': 'EHernandez-90300'
            },
            '68:d7:9a:06:67:bd': {
                'dev_macs': None,
                'ip_address': '100.65.28.45',
                'mac_address': '68:d7:9a:06:67:bd',
                'name': 'BHernandez-90268'
            },
            '68:d7:9a:06:80:3d': {
                'dev_macs': None,
                'ip_address': '100.65.28.238',
                'mac_address': '68:d7:9a:06:80:3d',
                'name': 'KProffitt-96064'
            },
            '68:d7:9a:06:80:c0': {
                'dev_macs': None,
                'ip_address': '104.245.73.17',
                'mac_address': '68:d7:9a:06:80:c0',
                'name': 'CornerPlace-91104'
            },
            '68:d7:9a:06:82:3e': {
                'dev_macs': None,
                'ip_address': '100.65.26.33',
                'mac_address': '68:d7:9a:06:82:3e',
                'name': 'ATrevino-94079'
            },
            '68:d7:9a:06:8d:7d': {
                'dev_macs': None,
                'ip_address': '100.65.29.217',
                'mac_address': '68:d7:9a:06:8d:7d',
                'name': 'LQuiroz-91118'
            },
            '70:a7:41:33:44:44': {
                'dev_macs': None,
                'ip_address': '100.65.26.246',
                'mac_address': '70:a7:41:33:44:44',
                'name': 'IVela-94386'
            },
            '70:a7:41:33:45:5c': {
                'dev_macs': None,
                'ip_address': '100.65.40.251',
                'mac_address': '70:a7:41:33:45:5c',
                'name': 'JRedman-96785'
            },
            '70:a7:41:33:46:14': {
                'dev_macs': None,
                'ip_address': '100.65.40.248',
                'mac_address': '70:a7:41:33:46:14',
                'name': 'MThacker-96834'
            },
            '70:a7:41:33:46:e0': {
                'dev_macs': ['04:d5:90:5f:5b:b5'],
                'ip_address': None,
                'mac_address': '70:a7:41:33:46:e0',
                'name': 'Castro County Nursing & '
                'Rehabilitation-80864'
            },
            '70:a7:41:33:46:ec': {
                'dev_macs': None,
                'ip_address': '100.65.41.1',
                'mac_address': '70:a7:41:33:46:ec',
                'name': 'RHunter-96872'
            },
            '70:a7:41:33:47:04': {
                'dev_macs': None,
                'ip_address': '100.65.40.136',
                'mac_address': '70:a7:41:33:47:04',
                'name': 'FMendoza-96851'
            },
            '70:a7:41:33:47:38': {
                'dev_macs': None,
                'ip_address': '107.178.31.25',
                'mac_address': '70:a7:41:33:47:38',
                'name': 'BlueSkyFarms-96500'
            },
            '74:83:c2:43:ec:24': {
                'dev_macs': None,
                'ip_address': '100.65.0.226',
                'mac_address': '74:83:c2:43:ec:24',
                'name': 'JBaker-84690'
            },
            '74:83:c2:43:ec:2e': {
                'dev_macs': None,
                'ip_address': '100.65.5.63',
                'mac_address': '74:83:c2:43:ec:2e',
                'name': 'KGauna-84769'
            },
            '74:83:c2:43:ec:64': {
                'dev_macs': None,
                'ip_address': '100.65.3.124',
                'mac_address': '74:83:c2:43:ec:64',
                'name': 'GReyes-84703'
            },
            '74:83:c2:43:ec:8b': {
                'dev_macs': ['18:b1:69:38:8e:d1'],
                'ip_address': None,
                'mac_address': '74:83:c2:43:ec:8b',
                'name': 'DPharmacy-84631'
            },
            '74:83:c2:43:ed:ae': {
                'dev_macs': None,
                'ip_address': '100.65.7.84',
                'mac_address': '74:83:c2:43:ed:ae',
                'name': 'AJones-87307'
            },
            '74:83:c2:43:f5:32': {
                'dev_macs': None,
                'ip_address': '100.65.2.60',
                'mac_address': '74:83:c2:43:f5:32',
                'name': 'MPena-86308'
            },
            '74:83:c2:43:f5:51': {
                'dev_macs': None,
                'ip_address': '100.65.26.52',
                'mac_address': '74:83:c2:43:f5:51',
                'name': 'CVasquez-88941'
            },
            '74:83:c2:43:f5:69': {
                'dev_macs': None,
                'ip_address': '100.65.30.217',
                'mac_address': '74:83:c2:43:f5:69',
                'name': 'VSteffens - 91882'
            },
            '74:83:c2:43:f5:85': {
                'dev_macs': None,
                'ip_address': '100.65.7.234',
                'mac_address': '74:83:c2:43:f5:85',
                'name': 'DUnderwood-83151'
            },
            '74:83:c2:43:f5:8a': {
                'dev_macs': None,
                'ip_address': '100.65.24.9',
                'mac_address': '74:83:c2:43:f5:8a',
                'name': 'RSilva-86688'
            },
            '74:83:c2:43:f5:9a': {
                'dev_macs': None,
                'ip_address': '100.65.26.18',
                'mac_address': '74:83:c2:43:f5:9a',
                'name': 'EGonzalez-88846'
            },
            '74:83:c2:43:f6:28': {
                'dev_macs': None,
                'ip_address': '100.65.3.42',
                'mac_address': '74:83:c2:43:f6:28',
                'name': 'SSkinner-86381'
            },
            '74:83:c2:43:f6:50': {
                'dev_macs': None,
                'ip_address': '52.129.124.50',
                'mac_address': '74:83:c2:43:f6:50',
                'name': 'JonRiddle-78067'
            },
            '74:83:c2:43:f6:5d': {
                'dev_macs': None,
                'ip_address': '100.65.24.129',
                'mac_address': '74:83:c2:43:f6:5d',
                'name': 'RBonilla-87432'
            },
            '74:83:c2:43:f6:85': {
                'dev_macs': ['50:c7:bf:39:2b:19'],
                'ip_address': None,
                'mac_address': '74:83:c2:43:f6:85',
                'name': 'Bi-Wize-75953'
            },
            '74:83:c2:43:f6:c0': {
                'dev_macs': None,
                'ip_address': '100.65.30.115',
                'mac_address': '74:83:c2:43:f6:c0',
                'name': 'AOrtega-94516'
            },
            '74:83:c2:43:f7:f9': {
                'dev_macs': None,
                'ip_address': '100.65.24.229',
                'mac_address': '74:83:c2:43:f7:f9',
                'name': 'MRios-79846'
            },
            '74:83:c2:43:f7:fb': {
                'dev_macs':
                ['00:d8:61:6c:ea:87', '10:62:e5:1a:6c:1c', 'ac:1f:6b:49:69:77'],
                'ip_address': None,
                'mac_address': '74:83:c2:43:f7:fb',
                'name': 'Lowes10-86941'
            },
            '74:83:c2:43:f8:19': {
                'dev_macs': None,
                'ip_address': '100.65.7.46',
                'mac_address': '74:83:c2:43:f8:19',
                'name': 'AMontelongo-85907'
            },
            '74:83:c2:43:f9:ce': {
                'dev_macs': None,
                'ip_address': '100.65.24.24',
                'mac_address': '74:83:c2:43:f9:ce',
                'name': 'JRamos-86516'
            },
            '74:83:c2:43:f9:f1': {
                'dev_macs': None,
                'ip_address': '100.65.24.203',
                'mac_address': '74:83:c2:43:f9:f1',
                'name': 'CLuna-87700'
            },
            '74:83:c2:68:29:d5': {
                'dev_macs': ['6c:cd:d6:0f:d2:0b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:29:d5',
                'name': 'KRushing-90930'
            },
            '74:83:c2:68:35:41': {
                'dev_macs': None,
                'ip_address': '100.65.5.179',
                'mac_address': '74:83:c2:68:35:41',
                'name': 'JSullivan-85036'
            },
            '74:83:c2:68:35:62': {
                'dev_macs': None,
                'ip_address': '100.65.6.160',
                'mac_address': '74:83:c2:68:35:62',
                'name': 'DJackson-85588'
            },
            '74:83:c2:68:36:4c': {
                'dev_macs': None,
                'ip_address': '100.65.5.184',
                'mac_address': '74:83:c2:68:36:4c',
                'name': 'MRodriguez-85077'
            },
            '74:83:c2:68:99:8e': {
                'dev_macs': None,
                'ip_address': '100.65.26.83',
                'mac_address': '74:83:c2:68:99:8e',
                'name': 'ORivera-89002'
            },
            '74:83:c2:68:99:e8': {
                'dev_macs': None,
                'ip_address': '100.65.30.38',
                'mac_address': '74:83:c2:68:99:e8',
                'name': 'JBell-95810'
            },
            '74:83:c2:68:99:ec': {
                'dev_macs': None,
                'ip_address': '100.65.26.106',
                'mac_address': '74:83:c2:68:99:ec',
                'name': 'ASanchez-89093'
            },
            '74:83:c2:68:9a:06': {
                'dev_macs': None,
                'ip_address': '100.65.26.38',
                'mac_address': '74:83:c2:68:9a:06',
                'name': 'RGonzalez-88892'
            },
            '74:83:c2:68:af:a2': {
                'dev_macs': None,
                'ip_address': '100.65.28.173',
                'mac_address': '74:83:c2:68:af:a2',
                'name': 'CastroCountyNews - 34313'
            },
            '74:83:c2:68:af:b6': {
                'dev_macs': None,
                'ip_address': '100.65.30.61',
                'mac_address': '74:83:c2:68:af:b6',
                'name': 'SAguero-91330'
            },
            '74:83:c2:68:b1:7c': {
                'dev_macs': None,
                'ip_address': '100.65.30.140',
                'mac_address': '74:83:c2:68:b1:7c',
                'name': 'MGardo-91431'
            },
            '74:83:c2:68:b1:8f': {
                'dev_macs': None,
                'ip_address': '100.65.30.161',
                'mac_address': '74:83:c2:68:b1:8f',
                'name': 'DReinart-96211'
            },
            '74:83:c2:68:b2:04': {
                'dev_macs': None,
                'ip_address': '100.65.28.52',
                'mac_address': '74:83:c2:68:b2:04',
                'name': 'CFinck-95040'
            },
            '74:83:c2:68:c4:fc': {
                'dev_macs': None,
                'ip_address': '100.65.27.12',
                'mac_address': '74:83:c2:68:c4:fc',
                'name': 'MEnriquez-89562 '
            },
            '74:83:c2:68:c5:85': {
                'dev_macs': None,
                'ip_address': '100.65.27.37',
                'mac_address': '74:83:c2:68:c5:85',
                'name': 'DimmittFirstAssemblyOfGod-89678'
            },
            '74:83:c2:68:c5:90': {
                'dev_macs': None,
                'ip_address': '100.65.26.115',
                'mac_address': '74:83:c2:68:c5:90',
                'name': 'JGarcia-89164'
            },
            '74:83:c2:68:c5:a9': {
                'dev_macs': None,
                'ip_address': '52.129.124.48',
                'mac_address': '74:83:c2:68:c5:a9',
                'name': 'BovineDiagnostics-89256'
            },
            '74:83:c2:68:c5:f2': {
                'dev_macs': None,
                'ip_address': '100.65.27.33',
                'mac_address': '74:83:c2:68:c5:f2',
                'name': 'AVidal-89682'
            },
            '74:83:c2:68:c6:48': {
                'dev_macs': None,
                'ip_address': '100.65.27.28',
                'mac_address': '74:83:c2:68:c6:48',
                'name': 'MFavela-89741'
            },
            '74:83:c2:68:c6:54': {
                'dev_macs': None,
                'ip_address': '100.65.27.49',
                'mac_address': '74:83:c2:68:c6:54',
                'name': 'JSaenz_89769'
            },
            '74:83:c2:f0:c9:48': {
                'dev_macs': None,
                'ip_address': '100.65.29.107',
                'mac_address': '74:83:c2:f0:c9:48',
                'name': 'MFlores - 95127'
            },
            '74:ac:b9:06:73:1b': {
                'dev_macs': [],
                'ip_address': None,
                'mac_address': '74:ac:b9:06:73:1b',
                'name': 'Velocity/HigginbothamBrothers-96609'
            },
            '74:ac:b9:06:7a:96': {
                'dev_macs': None,
                'ip_address': '100.65.27.117',
                'mac_address': '74:ac:b9:06:7a:96',
                'name': 'SOrtiz-89888'
            },
            '74:ac:b9:06:7a:9a': {
                'dev_macs': None,
                'ip_address': '100.65.27.190',
                'mac_address': '74:ac:b9:06:7a:9a',
                'name': 'CAlag-90013'
            },
            '74:ac:b9:06:7a:a1': {
                'dev_macs': None,
                'ip_address': '100.65.28.255',
                'mac_address': '74:ac:b9:06:7a:a1',
                'name': 'KBlack-90729'
            },
            '74:ac:b9:06:7a:a2': {
                'dev_macs': None,
                'ip_address': '100.65.6.26',
                'mac_address': '74:ac:b9:06:7a:a2',
                'name': 'SCorona-95911'
            },
            '74:ac:b9:06:7a:a4': {
                'dev_macs': None,
                'ip_address': '100.65.29.159',
                'mac_address': '74:ac:b9:06:7a:a4',
                'name': 'SEOntiveros-91061'
            },
            '74:ac:b9:06:a0:c4': {
                'dev_macs': None,
                'ip_address': '100.65.25.125',
                'mac_address': '74:ac:b9:06:a0:c4',
                'name': 'AAcevedo-88266'
            },
            '74:ac:b9:06:a2:d1': {
                'dev_macs': None,
                'ip_address': '100.65.25.244',
                'mac_address': '74:ac:b9:06:a2:d1',
                'name': 'ZMcCasland-90591'
            },
            '78:45:58:06:24:a7': {
                'dev_macs': None,
                'ip_address': '100.65.31.121',
                'mac_address': '78:45:58:06:24:a7',
                'name': 'L&A.Silva-78575 '
            },
            '78:45:58:06:27:26': {
                'dev_macs': None,
                'ip_address': '100.65.31.188',
                'mac_address': '78:45:58:06:27:26',
                'name': 'DNelson -92671'
            },
            '78:45:58:06:27:7d': {
                'dev_macs': None,
                'ip_address': '100.65.31.213',
                'mac_address': '78:45:58:06:27:7d',
                'name': 'MRichardson-92770'
            },
            '78:45:58:06:27:89': {
                'dev_macs': None,
                'ip_address': '100.65.31.181',
                'mac_address': '78:45:58:06:27:89',
                'name': 'DOntiveros-92624'
            },
            '78:45:58:06:27:8f': {
                'dev_macs': None,
                'ip_address': '100.65.0.105',
                'mac_address': '78:45:58:06:27:8f',
                'name': 'AVilllareal-91955'
            },
            '78:45:58:06:27:ad': {
                'dev_macs': None,
                'ip_address': '100.65.31.48',
                'mac_address': '78:45:58:06:27:ad',
                'name': 'Evolve Nutrition - 92144'
            },
            '78:45:58:06:27:b5': {
                'dev_macs': None,
                'ip_address': '100.65.30.242',
                'mac_address': '78:45:58:06:27:b5',
                'name': 'AMartinez-91301'
            },
            '78:45:58:06:27:b7': {
                'dev_macs': None,
                'ip_address': '100.65.31.49',
                'mac_address': '78:45:58:06:27:b7',
                'name': 'BConyers-92189'
            },
            '78:45:58:06:28:0f': {
                'dev_macs': None,
                'ip_address': '100.65.30.119',
                'mac_address': '78:45:58:06:28:0f',
                'name': 'REnriquez-91457'
            },
            '78:45:58:06:28:74': {
                'dev_macs': None,
                'ip_address': '100.65.3.177',
                'mac_address': '78:45:58:06:28:74',
                'name': 'LCleveland-82159'
            },
            '78:45:58:06:28:78': {
                'dev_macs': None,
                'ip_address': '100.65.25.240',
                'mac_address': '78:45:58:06:28:78',
                'name': 'SCarpio-96066'
            },
            '78:45:58:06:28:e0': {
                'dev_macs': None,
                'ip_address': '107.178.31.88',
                'mac_address': '78:45:58:06:28:e0',
                'name': 'Dimmitt Motel-92675'
            },
            '78:45:58:06:29:31': {
                'dev_macs': None,
                'ip_address': '100.65.24.233',
                'mac_address': '78:45:58:06:29:31',
                'name': 'RCadena-92934'
            },
            '78:45:58:9a:53:28': {
                'dev_macs': None,
                'ip_address': '100.65.40.86',
                'mac_address': '78:45:58:9a:53:28',
                'name': 'Salina’s Salon-96068'
            },
            '78:45:58:9a:59:f0': {
                'dev_macs': None,
                'ip_address': '107.178.31.47',
                'mac_address': '78:45:58:9a:59:f0',
                'name': 'BlueSkyFarmsDBA-93136'
            },
            '78:45:58:9a:5b:40': {
                'dev_macs': ['18:fd:74:18:2e:22'],
                'ip_address': None,
                'mac_address': '78:45:58:9a:5b:40',
                'name': 'City of Dimmitt Police Annex '
                '-93658'
            },
            '78:45:58:9a:fd:4c': {
                'dev_macs': None,
                'ip_address': '100.65.3.130',
                'mac_address': '78:45:58:9a:fd:4c',
                'name': 'VLeal-96351'
            },
            '78:45:58:9a:fd:54': {
                'dev_macs': None,
                'ip_address': '100.65.29.222',
                'mac_address': '78:45:58:9a:fd:54',
                'name': 'FMartinez - 95735'
            },
            '78:8a:20:73:d0:4d': {
                'dev_macs': ['00:04:56:13:8d:81'],
                'ip_address': None,
                'mac_address': '78:8a:20:73:d0:4d',
                'name': 'SealesByWalkingG-96794'
            },
            '78:8a:20:c0:41:36': {
                'dev_macs': None,
                'ip_address': '104.245.72.195',
                'mac_address': '78:8a:20:c0:41:36',
                'name': 'VCaballero-79486'
            },
            '78:8a:20:c0:44:24': {
                'dev_macs': None,
                'ip_address': '104.245.73.130',
                'mac_address': '78:8a:20:c0:44:24',
                'name': 'LLunsford-77627'
            },
            '78:8a:20:c0:57:ed': {
                'dev_macs': ['b8:69:f4:57:75:bf'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:57:ed',
                'name': 'NutrienOffice-76414'
            },
            'b4:fb:e4:79:34:35': {
                'dev_macs': ['74:4d:28:54:fb:ec'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:34:35',
                'name': 'PebsworthInsurance-79365'
            },
            'b4:fb:e4:79:34:49': {
                'dev_macs': None,
                'ip_address': '100.65.1.105',
                'mac_address': 'b4:fb:e4:79:34:49',
                'name': 'CPriest-96257'
            },
            'b4:fb:e4:79:34:76': {
                'dev_macs': None,
                'ip_address': '100.65.0.166',
                'mac_address': 'b4:fb:e4:79:34:76',
                'name': 'KSherman-81988'
            },
            'b4:fb:e4:79:35:07': {
                'dev_macs': None,
                'ip_address': '100.65.26.75',
                'mac_address': 'b4:fb:e4:79:35:07',
                'name': 'FUMCParsonage1-81672(temp '
                'inactive)'
            },
            'b4:fb:e4:79:35:3e': {
                'dev_macs': None,
                'ip_address': '100.65.0.223',
                'mac_address': 'b4:fb:e4:79:35:3e',
                'name': 'SusieBradford-81855'
            },
            'b4:fb:e4:79:35:43': {
                'dev_macs': None,
                'ip_address': '100.65.1.21',
                'mac_address': 'b4:fb:e4:79:35:43',
                'name': 'LGarcia-76691'
            },
            'b4:fb:e4:79:38:13': {
                'dev_macs': None,
                'ip_address': '100.65.1.31',
                'mac_address': 'b4:fb:e4:79:38:13',
                'name': 'SNavarro-82075'
            },
            'b4:fb:e4:79:38:90': {
                'dev_macs': None,
                'ip_address': '100.65.0.197',
                'mac_address': 'b4:fb:e4:79:38:90',
                'name': 'JMedrano-81783'
            },
            'b4:fb:e4:79:39:3f': {
                'dev_macs': None,
                'ip_address': '100.65.31.198',
                'mac_address': 'b4:fb:e4:79:39:3f',
                'name': 'Stampede-92676'
            },
            'b4:fb:e4:79:39:8a': {
                'dev_macs': None,
                'ip_address': '100.65.31.220',
                'mac_address': 'b4:fb:e4:79:39:8a',
                'name': 'PHerrera-92802'
            },
            'b4:fb:e4:79:3b:b5': {
                'dev_macs': ['c4:ad:34:cf:b9:4e'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:3b:b5',
                'name': 'CityofDimmittUtilityWarehouse-87769'
            },
            'b4:fb:e4:79:5f:14': {
                'dev_macs': None,
                'ip_address': '100.65.0.57',
                'mac_address': 'b4:fb:e4:79:5f:14',
                'name': 'BKinser-78424'
            },
            'b4:fb:e4:e6:83:0e': {
                'dev_macs': None,
                'ip_address': '100.65.26.234',
                'mac_address': 'b4:fb:e4:e6:83:0e',
                'name': 'SSanchez-80453'
            },
            'b4:fb:e4:e6:ac:a3': {
                'dev_macs': None,
                'ip_address': '100.65.1.187',
                'mac_address': 'b4:fb:e4:e6:ac:a3',
                'name': 'ESilva-76504'
            },
            'b4:fb:e4:e6:b4:5f': {
                'dev_macs': None,
                'ip_address': '100.65.1.218',
                'mac_address': 'b4:fb:e4:e6:b4:5f',
                'name': 'GSnitker-76623'
            },
            'b4:fb:e4:e6:c4:a9': {
                'dev_macs': None,
                'ip_address': '100.65.3.200',
                'mac_address': 'b4:fb:e4:e6:c4:a9',
                'name': 'MOviedo-84381'
            },
            'b4:fb:e4:e6:c5:1c': {
                'dev_macs': None,
                'ip_address': '100.65.3.172',
                'mac_address': 'b4:fb:e4:e6:c5:1c',
                'name': 'MNavarro-83232'
            },
            'b4:fb:e4:e6:c5:62': {
                'dev_macs': None,
                'ip_address': '100.65.2.123',
                'mac_address': 'b4:fb:e4:e6:c5:62',
                'name': 'EChavez-84336'
            },
            'b4:fb:e4:e6:cf:25': {
                'dev_macs': None,
                'ip_address': '100.65.24.62',
                'mac_address': 'b4:fb:e4:e6:cf:25',
                'name': 'BBQ2Go-95462'
            },
            'b4:fb:e4:e6:cf:36': {
                'dev_macs': None,
                'ip_address': '100.65.3.119',
                'mac_address': 'b4:fb:e4:e6:cf:36',
                'name': 'BConyers-82662'
            },
            'b4:fb:e4:e6:cf:3f': {
                'dev_macs':
                ['00:90:7f:dd:9b:47', '00:a0:c8:85:cb:4b', 'c0:06:c3:c9:8e:96'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:cf:3f',
                'name': 'CastroCountyJail-83479'
            },
            'b4:fb:e4:e6:cf:57': {
                'dev_macs': ['08:55:31:6d:ed:bd'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:cf:57',
                'name': 'CityOfDimmittFireDept-89380'
            },
            'b4:fb:e4:e6:cf:58': {
                'dev_macs': None,
                'ip_address': '100.65.0.97',
                'mac_address': 'b4:fb:e4:e6:cf:58',
                'name': 'FBruegel-78174'
            },
            'b4:fb:e4:e6:d7:38': {
                'dev_macs': None,
                'ip_address': '100.65.1.53',
                'mac_address': 'b4:fb:e4:e6:d7:38',
                'name': 'SBuckley-82199'
            },
            'b4:fb:e4:e6:d7:3c': {
                'dev_macs': None,
                'ip_address': '100.65.1.78',
                'mac_address': 'b4:fb:e4:e6:d7:3c',
                'name': 'JPena-82158'
            },
            'b4:fb:e4:e6:df:2b': {
                'dev_macs': None,
                'ip_address': '100.65.2.20',
                'mac_address': 'b4:fb:e4:e6:df:2b',
                'name': 'LCase-94834'
            },
            'b4:fb:e4:e6:df:42': {
                'dev_macs': ['74:4d:28:9d:46:d0'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:df:42',
                'name': 'RSchaffer-76804'
            },
            'b4:fb:e4:e6:e1:ed': {
                'dev_macs': None,
                'ip_address': '100.65.1.111',
                'mac_address': 'b4:fb:e4:e6:e1:ed',
                'name': 'BAcker-82354'
            },
            'b4:fb:e4:e6:e1:fb': {
                'dev_macs': None,
                'ip_address': '100.65.1.209',
                'mac_address': 'b4:fb:e4:e6:e1:fb',
                'name': 'MLaura-79980'
            },
            'b4:fb:e4:e6:e2:12': {
                'dev_macs': None,
                'ip_address': '100.65.1.236',
                'mac_address': 'b4:fb:e4:e6:e2:12',
                'name': 'EPresas-77993'
            },
            'b4:fb:e4:e6:e2:9a': {
                'dev_macs': None,
                'ip_address': '100.65.1.140',
                'mac_address': 'b4:fb:e4:e6:e2:9a',
                'name': 'KPaxton-76553'
            },
            'b4:fb:e4:f9:28:9b': {
                'dev_macs': ['00:01:21:2f:0a:e4'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:28:9b',
                'name': 'FrontierCapitol-76456'
            },
            'b4:fb:e4:f9:4d:03': {
                'dev_macs': None,
                'ip_address': '100.65.24.156',
                'mac_address': 'b4:fb:e4:f9:4d:03',
                'name': 'ATorres-87599'
            },
            'b4:fb:e4:f9:4d:7b': {
                'dev_macs': None,
                'ip_address': '100.65.1.189',
                'mac_address': 'b4:fb:e4:f9:4d:7b',
                'name': 'DSwingburn-86309'
            },
            'b4:fb:e4:f9:4f:0b': {
                'dev_macs': None,
                'ip_address': '100.65.0.4',
                'mac_address': 'b4:fb:e4:f9:4f:0b',
                'name': 'LMonreal-80925'
            },
            'b4:fb:e4:f9:4f:1a': {
                'dev_macs': None,
                'ip_address': '52.129.122.210',
                'mac_address': 'b4:fb:e4:f9:4f:1a',
                'name': 'L&CBradley-76457'
            },
            'b4:fb:e4:f9:4f:24': {
                'dev_macs': None,
                'ip_address': '100.65.7.197',
                'mac_address': 'b4:fb:e4:f9:4f:24',
                'name': 'DBuckley-86490'
            },
            'b4:fb:e4:f9:4f:51': {
                'dev_macs': None,
                'ip_address': '100.65.0.5',
                'mac_address': 'b4:fb:e4:f9:4f:51',
                'name': 'POrtiz-79058'
            },
            'b4:fb:e4:f9:4f:e7': {
                'dev_macs': None,
                'ip_address': '100.65.0.9',
                'mac_address': 'b4:fb:e4:f9:4f:e7',
                'name': 'ModernCarpet-78079'
            },
            'b4:fb:e4:f9:50:3c': {
                'dev_macs': None,
                'ip_address': '100.65.0.3',
                'mac_address': 'b4:fb:e4:f9:50:3c',
                'name': 'CGilbreath-76809'
            },
            'b4:fb:e4:f9:53:25': {
                'dev_macs': None,
                'ip_address': '52.129.125.155',
                'mac_address': 'b4:fb:e4:f9:53:25',
                'name': 'CVandiver-80251'
            },
            'b4:fb:e4:f9:53:5c': {
                'dev_macs': None,
                'ip_address': '104.245.72.218',
                'mac_address': 'b4:fb:e4:f9:53:5c',
                'name': 'MLytle-77547'
            },
            'b4:fb:e4:f9:53:61': {
                'dev_macs': None,
                'ip_address': '52.129.125.54',
                'mac_address': 'b4:fb:e4:f9:53:61',
                'name': 'ScottSheffy-76556'
            },
            'b4:fb:e4:f9:53:8e': {
                'dev_macs': None,
                'ip_address': '104.245.73.44',
                'mac_address': 'b4:fb:e4:f9:53:8e',
                'name': 'CNeinast-80149'
            },
            'b4:fb:e4:f9:53:9d': {
                'dev_macs': None,
                'ip_address': '52.129.125.95',
                'mac_address': 'b4:fb:e4:f9:53:9d',
                'name': 'DEspinosa-78795'
            },
            'b4:fb:e4:f9:53:a2': {
                'dev_macs': [
                    '74:4d:28:55:19:2e', '74:4d:28:bb:a0:1a', '74:4d:28:bb:b5:02',
                    'ec:13:b2:91:09:a2'
                ],
                'ip_address':
                None,
                'mac_address':
                'b4:fb:e4:f9:53:a2',
                'name':
                'TheMavrickontheSquare-92535'
            },
            'b4:fb:e4:f9:54:f6': {
                'dev_macs': None,
                'ip_address': '104.245.74.187',
                'mac_address': 'b4:fb:e4:f9:54:f6',
                'name': 'HJeter-79483'
            },
            'b4:fb:e4:f9:55:32': {
                'dev_macs': ['b8:69:f4:57:79:07'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:55:32',
                'name': 'NutrienWeighStation-79513 '
            },
            'b4:fb:e4:f9:55:a0': {
                'dev_macs': None,
                'ip_address': '100.65.30.21',
                'mac_address': 'b4:fb:e4:f9:55:a0',
                'name': 'AGallegos-91213'
            },
            'b4:fb:e4:f9:57:94': {
                'dev_macs': None,
                'ip_address': '100.65.0.13',
                'mac_address': 'b4:fb:e4:f9:57:94',
                'name': 'HighwayAutoGlass-77130'
            },
            'b4:fb:e4:f9:db:38': {
                'dev_macs': ['00:01:21:46:42:08'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:db:38',
                'name': 'CastroCountyCourtHouse-83475'
            },
            'b4:fb:e4:f9:dc:14': {
                'dev_macs': ['00:90:7f:01:ac:16'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:dc:14',
                'name': 'CastroCountyExtensionOffice - '
                '83481'
            },
            'b4:fb:e4:f9:dc:c8': {
                'dev_macs': ['00:01:21:28:bf:ac'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:dc:c8',
                'name': "Gary'sEngine&Machine-83276"
            },
            'b4:fb:e4:f9:dd:04': {
                'dev_macs': None,
                'ip_address': '100.65.4.64',
                'mac_address': 'b4:fb:e4:f9:dd:04',
                'name': 'LDennis-86492'
            },
            'd0:21:f9:06:17:f4': {
                'dev_macs': None,
                'ip_address': '100.65.40.13',
                'mac_address': 'd0:21:f9:06:17:f4',
                'name': 'JRodriguez-86428'
            },
            'd0:21:f9:06:1f:64': {
                'dev_macs': None,
                'ip_address': '100.65.28.221',
                'mac_address': 'd0:21:f9:06:1f:64',
                'name': 'LJurado-93847'
            },
            'd0:21:f9:9a:83:48': {
                'dev_macs': None,
                'ip_address': '52.129.122.124',
                'mac_address': 'd0:21:f9:9a:83:48',
                'name': 'DProffitt PC-96299'
            },
            'd0:21:f9:9a:84:40': {
                'dev_macs': None,
                'ip_address': '100.65.41.36',
                'mac_address': 'd0:21:f9:9a:84:40',
                'name': 'Nick Lara - 82090'
            },
            'd0:21:f9:9a:84:6c': {
                'dev_macs': None,
                'ip_address': '107.178.31.21',
                'mac_address': 'd0:21:f9:9a:84:6c',
                'name': 'ExtremeDetailing-82089'
            },
            'd0:21:f9:9a:85:34': {
                'dev_macs': None,
                'ip_address': '100.65.40.173',
                'mac_address': 'd0:21:f9:9a:85:34',
                'name': 'TLeinen-96516'
            },
            'd0:21:f9:9a:85:a0': {
                'dev_macs': None,
                'ip_address': '100.65.2.249',
                'mac_address': 'd0:21:f9:9a:85:a0',
                'name': 'JEmerson-77700'
            },
            'd0:21:f9:9a:a5:30': {
                'dev_macs': None,
                'ip_address': '107.178.31.95',
                'mac_address': 'd0:21:f9:9a:a5:30',
                'name': 'Sonic-90402'
            },
            'd0:21:f9:9a:a5:c0': {
                'dev_macs': None,
                'ip_address': '100.65.28.4',
                'mac_address': 'd0:21:f9:9a:a5:c0',
                'name': 'FTaylor-96291'
            },
            'f4:92:bf:06:26:db': {
                'dev_macs': None,
                'ip_address': '100.65.29.209',
                'mac_address': 'f4:92:bf:06:26:db',
                'name': 'DimmitFeed-76493'
            },
            'f4:92:bf:06:40:11': {
                'dev_macs': None,
                'ip_address': '100.65.29.169',
                'mac_address': 'f4:92:bf:06:40:11',
                'name': 'CAnes-91096'
            },
            'f4:92:bf:06:42:47': {
                'dev_macs': None,
                'ip_address': '107.178.31.85',
                'mac_address': 'f4:92:bf:06:42:47',
                'name': 'BudHillFeedlots-92644'
            },
            'f4:92:bf:06:4a:c6': {
                'dev_macs': None,
                'ip_address': '100.65.29.150',
                'mac_address': 'f4:92:bf:06:4a:c6',
                'name': 'MPuente-91050'
            },
            'f4:92:bf:06:4b:55': {
                'dev_macs': None,
                'ip_address': '100.65.31.42',
                'mac_address': 'f4:92:bf:06:4b:55',
                'name': 'EGonzalez-92231'
            },
            'f4:92:bf:06:4b:59': {
                'dev_macs': None,
                'ip_address': '100.65.29.181',
                'mac_address': 'f4:92:bf:06:4b:59',
                'name': 'JEnriquez-91069'
            },
            'f4:92:bf:06:4b:e1': {
                'dev_macs': None,
                'ip_address': '192.168.99.91',
                'mac_address': 'f4:92:bf:06:4b:e1',
                'name': 'ANavarro-91082'
            },
            'f4:92:bf:06:e3:c5': {
                'dev_macs': None,
                'ip_address': '100.65.4.137',
                'mac_address': 'f4:92:bf:06:e3:c5',
                'name': 'LGrand-92803'
            },
            'f4:92:bf:06:e4:d2': {
                'dev_macs': None,
                'ip_address': '100.65.26.73',
                'mac_address': 'f4:92:bf:06:e4:d2',
                'name': 'JCastillo - 93331'
            },
            'f4:92:bf:06:ec:71': {
                'dev_macs': None,
                'ip_address': '100.65.29.42',
                'mac_address': 'f4:92:bf:06:ec:71',
                'name': 'DFisher-94176'
            },
            'f4:92:bf:06:ec:90': {
                'dev_macs': None,
                'ip_address': '100.65.26.188',
                'mac_address': 'f4:92:bf:06:ec:90',
                'name': 'RGauna - 93421'
            },
            'f4:92:bf:06:f2:8f': {
                'dev_macs': None,
                'ip_address': '100.65.24.48',
                'mac_address': 'f4:92:bf:06:f2:8f',
                'name': 'RMartinez - 94393'
            },
            'f4:92:bf:06:f3:e4': {
                'dev_macs': None,
                'ip_address': '100.65.26.252',
                'mac_address': 'f4:92:bf:06:f3:e4',
                'name': 'SSheffy-93345'
            },
            'f4:92:bf:06:f4:26': {
                'dev_macs': None,
                'ip_address': '100.65.27.4',
                'mac_address': 'f4:92:bf:06:f4:26',
                'name': 'JVillarreal-93379'
            },
            'f4:92:bf:06:fe:f8': {
                'dev_macs': None,
                'ip_address': '100.65.24.253',
                'mac_address': 'f4:92:bf:06:fe:f8',
                'name': 'ColonialFuneralHome-82084'
            },
            'fc:ec:da:e0:f2:62': {
                'dev_macs': ['08:55:31:57:7f:84', '48:f8:b3:bc:ed:cb'],
                'ip_address': None,
                'mac_address': 'fc:ec:da:e0:f2:62',
                'name': 'CCAbstractTitle-85531'
            },
            'fc:ec:da:eb:95:10': {
                'dev_macs': None,
                'ip_address': '100.65.2.253',
                'mac_address': 'fc:ec:da:eb:95:10',
                'name': 'BDrennan-83726'
            },
            'fc:ec:da:eb:95:33': {
                'dev_macs': None,
                'ip_address': '100.65.3.192',
                'mac_address': 'fc:ec:da:eb:95:33',
                'name': 'MaryALane-84333'
            },
            'fc:ec:da:eb:95:6a': {
                'dev_macs': ['04:a1:51:90:a7:f8'],
                'ip_address': None,
                'mac_address': 'fc:ec:da:eb:95:6a',
                'name': 'CastroCountyLibrary-83485'
            },
            'fc:ec:da:eb:9b:cd': {
                'dev_macs': [],
                'ip_address': None,
                'mac_address': 'fc:ec:da:eb:9b:cd',
                'name': 'CastroCountyRoss-83484'
            },
            'fc:ec:da:eb:f1:72': {
                'dev_macs': None,
                'ip_address': '100.65.6.211',
                'mac_address': 'fc:ec:da:eb:f1:72',
                'name': 'TWidick-85679'
            },
            'fc:ec:da:eb:f9:fb': {
                'dev_macs': None,
                'ip_address': '100.65.2.208',
                'mac_address': 'fc:ec:da:eb:f9:fb',
                'name': 'JHinjosa-85795'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                30.0,
                'interfaces': [{
                    'admin_up': True,
                    'id': 'eth0',
                    'in_discards': '5329648',
                    'in_errors': '0',
                    'in_nucast_pkts': '0',
                    'in_octets': '221507912166',
                    'in_ucast_pkts': '700605806',
                    'in_unknown_protos': '0',
                    'name': 'MGMT',
                    'oper_up': True,
                    'out_discards': '0',
                    'out_errors': '0',
                    'out_nucast_pkts': '0',
                    'out_octets': '1339845714052',
                    'out_ucast_pkts': '1383949272',
                    'poller_hash': 'Nzg4YTIwMGQ3NTdlZXRoMGludGY=',
                    'speed': '1000000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon1',
                    'in_errors':
                    '0',
                    'in_octets':
                    '6502605190861',
                    'in_ucast_pkts':
                    '24999574741',
                    'links': [{
                        'bridged_mac_addresses': ['b8:69:f4:57:75:bf'],
                        'in_octets': '179849551975',
                        'out_octets': '638956727639',
                        'poller_hash': 'Nzg4YTIwYzA1N2VkcGVlcmludGY='
                    }, {
                        'in_octets': '14085184931',
                        'out_octets': '108035893022',
                        'poller_hash': 'MThlODI5MGJhZGNjcGVlcmludGY='
                    }, {
                        'in_octets': '27114768126',
                        'out_octets': '420422245790',
                        'poller_hash': 'MThlODI5MGJhZTBjcGVlcmludGY='
                    }, {
                        'in_octets': '724992',
                        'out_octets': '889910',
                        'poller_hash': 'MThlODI5MTk1ZWQ4cGVlcmludGY='
                    }, {
                        'in_octets': '3618395657',
                        'out_octets': '226224681865',
                        'poller_hash': 'NzBhNzQxMzM0NjE0cGVlcmludGY='
                    }, {
                        'in_octets': '19453255895',
                        'out_octets': '643741211987',
                        'poller_hash': 'NzBhNzQxMzM0NzA0cGVlcmludGY='
                    }, {
                        'in_octets': '3779497855',
                        'out_octets': '43749674446',
                        'poller_hash': 'Nzg0NTU4MDYyN2FkcGVlcmludGY='
                    }, {
                        'in_octets': '9426014032',
                        'out_octets': '86070300007',
                        'poller_hash': 'NjhkNzlhMDY4MGMwcGVlcmludGY='
                    }, {
                        'in_octets': '8050419182',
                        'out_octets': '208093027582',
                        'poller_hash': 'NzRhY2I5MDY3YWEycGVlcmludGY='
                    }, {
                        'in_octets': '87290701862',
                        'out_octets': '59257439890',
                        'poller_hash': 'ZjQ5MmJmMDYyNmRicGVlcmludGY='
                    }, {
                        'in_octets': '15461302098',
                        'out_octets': '542132930745',
                        'poller_hash': 'ZjQ5MmJmMDZlYzkwcGVlcmludGY='
                    }, {
                        'in_octets': '41377528576',
                        'out_octets': '1206183795600',
                        'poller_hash': 'ZjQ5MmJmMDZmNDI2cGVlcmludGY='
                    }, {
                        'in_octets': '40910398644',
                        'out_octets': '1868780133360',
                        'poller_hash': 'ZmNlY2RhZWJmOWZicGVlcmludGY='
                    }, {
                        'in_octets': '44679978425',
                        'out_octets': '2145749122952',
                        'poller_hash': 'YjRmYmU0NzkzNDQ5cGVlcmludGY='
                    }, {
                        'in_octets': '125842620753',
                        'out_octets': '953788902578',
                        'poller_hash': 'YjRmYmU0NzkzODEzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c4:ad:34:cf:b9:4e'],
                        'in_octets': '8245931261',
                        'out_octets': '58090936365',
                        'poller_hash': 'YjRmYmU0NzkzYmI1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['00:90:7f:dd:9b:47', '00:a0:c8:85:cb:4b', 'c0:06:c3:c9:8e:96'],
                        'in_octets':
                        '1251800419593',
                        'out_octets':
                        '9141049979702',
                        'poller_hash':
                        'YjRmYmU0ZTZjZjNmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['b8:69:f4:57:79:07'],
                        'in_octets': '55763109025',
                        'out_octets': '252653365066',
                        'poller_hash': 'YjRmYmU0Zjk1NTMycGVlcmludGY='
                    }, {
                        'in_octets': '1804895322',
                        'out_octets': '38407107231',
                        'poller_hash': 'YjRmYmU0Zjk1Nzk0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:01:21:28:bf:ac'],
                        'in_octets': '1717409162210',
                        'out_octets': '963132757240',
                        'poller_hash': 'YjRmYmU0ZjlkY2M4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon1',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '63517437709816',
                    'out_ucast_pkts':
                    '55584956540',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uMWludGY=',
                    'pons': [{
                        'id':
                        '1',
                        'links': [{
                            'connected_time': '8211832',
                            'fiber_length': 1320,
                            'poller_hash': 'Nzg4YTIwYzA1N2VkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10285398',
                            'fiber_length': 1516,
                            'poller_hash': 'MThlODI5MGJhZGNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1894960',
                            'fiber_length': 7048,
                            'poller_hash': 'MThlODI5MGJhZTBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '154778',
                            'fiber_length': 2309,
                            'poller_hash': 'MThlODI5MTk1ZWQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1561946',
                            'fiber_length': 7053,
                            'poller_hash': 'NzBhNzQxMzM0NjE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2330376',
                            'fiber_length': 2055,
                            'poller_hash': 'NzBhNzQxMzM0NzA0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10631592',
                            'fiber_length': 2043,
                            'poller_hash': 'Nzg0NTU4MDYyN2FkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5090281',
                            'fiber_length': 2046,
                            'poller_hash': 'NjhkNzlhMDY4MGMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '697625',
                            'fiber_length': 7053,
                            'poller_hash': 'NzRhY2I5MDY3YWEycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7604674',
                            'fiber_length': 2427,
                            'poller_hash': 'ZjQ5MmJmMDYyNmRicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1112060',
                            'fiber_length': 2338,
                            'poller_hash': 'ZjQ5MmJmMDZlYzkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1357543',
                            'fiber_length': 2424,
                            'poller_hash': 'ZjQ5MmJmMDZmNDI2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2770091',
                            'fiber_length': 1812,
                            'poller_hash': 'ZmNlY2RhZWJmOWZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7671675',
                            'fiber_length': 7047,
                            'poller_hash': 'YjRmYmU0NzkzNDQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2770092',
                            'fiber_length': 1838,
                            'poller_hash': 'YjRmYmU0NzkzODEzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2837852',
                            'fiber_length': 1417,
                            'poller_hash': 'YjRmYmU0NzkzYmI1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '18445256',
                            'fiber_length': 1849,
                            'poller_hash': 'YjRmYmU0ZTZjZjNmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122006',
                            'fiber_length': 1489,
                            'poller_hash': 'YjRmYmU0Zjk1NTMycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5254723',
                            'fiber_length': 1698,
                            'poller_hash': 'YjRmYmU0Zjk1Nzk0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997733',
                            'fiber_length': 2269,
                            'poller_hash': 'YjRmYmU0ZjlkY2M4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon2',
                    'in_errors':
                    '0',
                    'in_octets':
                    '21078219630991',
                    'in_ucast_pkts':
                    '43553202210',
                    'links': [{
                        'bridged_mac_addresses': ['00:04:56:13:8d:81'],
                        'in_octets': '6638375779',
                        'out_octets': '9051885600',
                        'poller_hash': 'Nzg4YTIwNzNkMDRkcGVlcmludGY='
                    }, {
                        'in_octets': '48203031319',
                        'out_octets': '196986725734',
                        'poller_hash': 'MThlODI5MGI5YmQ4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c0:ea:e4:8b:e8:41'],
                        'in_octets': '62469214802',
                        'out_octets': '114628485556',
                        'poller_hash': 'MThlODI5MGJiMDNjcGVlcmludGY='
                    }, {
                        'in_octets': '18271868481',
                        'out_octets': '1197908503688',
                        'poller_hash': 'MThlODI5MGJiMGUwcGVlcmludGY='
                    }, {
                        'in_octets': '34745283466',
                        'out_octets': '831964002475',
                        'poller_hash': 'MThlODI5MGJkOWY4cGVlcmludGY='
                    }, {
                        'in_octets': '72343703573',
                        'out_octets': '982932634011',
                        'poller_hash': 'MThlODI5MGJkYjI4cGVlcmludGY='
                    }, {
                        'in_octets': '24745638195',
                        'out_octets': '1116519254825',
                        'poller_hash': 'MThlODI5MTk1ZWZicGVlcmludGY='
                    }, {
                        'in_octets': '136693130145',
                        'out_octets': '605235713138',
                        'poller_hash': 'MThlODI5MTk1ZjAwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['18:b1:69:b1:59:d1'],
                        'in_octets': '117387156998',
                        'out_octets': '231627713235',
                        'poller_hash': 'MThlODI5MTliNDVhcGVlcmludGY='
                    }, {
                        'in_octets': '18448983292',
                        'out_octets': '170550531593',
                        'poller_hash': 'MThlODI5ZjVkNGZicGVlcmludGY='
                    }, {
                        'in_octets': '15335038841',
                        'out_octets': '268140789420',
                        'poller_hash': 'NzBhNzQxMzM0NTVjcGVlcmludGY='
                    }, {
                        'in_octets': '3837806666',
                        'out_octets': '68994168461',
                        'poller_hash': 'NzBhNzQxMzM0NmVjcGVlcmludGY='
                    }, {
                        'in_octets': '13194846514',
                        'out_octets': '406060361177',
                        'poller_hash': 'Nzg0NTU4MDYyNzdkcGVlcmludGY='
                    }, {
                        'in_octets': '3115670170',
                        'out_octets': '37687610599',
                        'poller_hash': 'Nzg0NTU4OWE1MzI4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['18:fd:74:18:2e:22'],
                        'in_octets': '296983902667',
                        'out_octets': '266949474443',
                        'poller_hash': 'Nzg0NTU4OWE1YjQwcGVlcmludGY='
                    }, {
                        'in_octets': '6220961177',
                        'out_octets': '76290298954',
                        'poller_hash': 'NjhkNzlhMDY2N2E5cGVlcmludGY='
                    }, {
                        'in_octets': '10910353252',
                        'out_octets': '290485823710',
                        'poller_hash': 'NjhkNzlhMDY4MjNlcGVlcmludGY='
                    }, {
                        'in_octets': '94',
                        'out_octets': '0',
                        'poller_hash': 'NzRhY2I5MDY3MzFicGVlcmludGY='
                    }, {
                        'in_octets': '27678239346',
                        'out_octets': '654488670780',
                        'poller_hash': 'ZjQ5MmJmMDY0YjU1cGVlcmludGY='
                    }, {
                        'in_octets': '16690572524',
                        'out_octets': '363453761035',
                        'poller_hash': 'NzQ4M2MyNDNmNTg1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['00:d8:61:6c:ea:87', '10:62:e5:1a:6c:1c', 'ac:1f:6b:49:69:77'],
                        'in_octets':
                        '51559726570',
                        'out_octets':
                        '47229884893',
                        'poller_hash':
                        'NzQ4M2MyNDNmN2ZicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['6c:cd:d6:0f:d2:0b'],
                        'in_octets': '12647139104',
                        'out_octets': '193153843467',
                        'poller_hash': 'NzQ4M2MyNjgyOWQ1cGVlcmludGY='
                    }, {
                        'in_octets': '15301645109',
                        'out_octets': '34167819865',
                        'poller_hash': 'NzQ4M2MyNjhhZmEycGVlcmludGY='
                    }, {
                        'in_octets': '451154402',
                        'out_octets': '7743341853',
                        'poller_hash': 'NzQ4M2MyNjhjNTg1cGVlcmludGY='
                    }, {
                        'in_octets': '64667525251',
                        'out_octets': '82358478455',
                        'poller_hash': 'NzQ4M2MyNjhjNWE5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['08:55:31:57:7f:84', '48:f8:b3:bc:ed:cb'],
                        'in_octets':
                        '733420160517',
                        'out_octets':
                        '52589305598',
                        'poller_hash':
                        'ZmNlY2RhZTBmMjYycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['04:a1:51:90:a7:f8'],
                        'in_octets': '17750737146',
                        'out_octets': '359940158363',
                        'poller_hash': 'ZmNlY2RhZWI5NTZhcGVlcmludGY='
                    }, {
                        'in_octets': '1214411',
                        'out_octets': '217700',
                        'poller_hash': 'ZmNlY2RhZWI5YmNkcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:4d:28:54:fb:ec'],
                        'in_octets': '16340708945',
                        'out_octets': '29992066797',
                        'poller_hash': 'YjRmYmU0NzkzNDM1cGVlcmludGY='
                    }, {
                        'in_octets': '43476043526',
                        'out_octets': '376367532541',
                        'poller_hash': 'YjRmYmU0NzkzOTNmcGVlcmludGY='
                    }, {
                        'in_octets': '39380962626',
                        'out_octets': '708550786866',
                        'poller_hash': 'YjRmYmU0ZTZjNGE5cGVlcmludGY='
                    }, {
                        'in_octets': '12791422536',
                        'out_octets': '54698871226',
                        'poller_hash': 'YjRmYmU0ZTZjZjI1cGVlcmludGY='
                    }, {
                        'in_octets': '7699521486',
                        'out_octets': '125648534287',
                        'poller_hash': 'YjRmYmU0ZTZjZjU4cGVlcmludGY='
                    }, {
                        'in_octets': '37276557970',
                        'out_octets': '737747228139',
                        'poller_hash': 'YjRmYmU0ZTZlMWVkcGVlcmludGY='
                    }, {
                        'in_octets': '2606907686',
                        'out_octets': '42368105659',
                        'poller_hash': 'YjRmYmU0ZTZlMjlhcGVlcmludGY='
                    }, {
                        'in_octets': '48529894030',
                        'out_octets': '1176560583068',
                        'poller_hash': 'YjRmYmU0Zjk1MDNjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': [
                            '74:4d:28:55:19:2e', '74:4d:28:bb:a0:1a',
                            '74:4d:28:bb:b5:02', 'ec:13:b2:91:09:a2'
                        ],
                        'in_octets':
                        '112918238146',
                        'out_octets':
                        '2325325057591',
                        'poller_hash':
                        'YjRmYmU0Zjk1M2EycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:01:21:46:42:08'],
                        'in_octets': '285854656952',
                        'out_octets': '668452474612',
                        'poller_hash': 'YjRmYmU0ZjlkYjM4cGVlcmludGY='
                    }, {
                        'in_octets': '64512637049',
                        'out_octets': '328400160555',
                        'poller_hash': 'ZDAyMWY5MDYxZjY0cGVlcmludGY='
                    }, {
                        'in_octets': '8228731278',
                        'out_octets': '75952505532',
                        'poller_hash': 'ZDAyMWY5OWE4MzQ4cGVlcmludGY='
                    }, {
                        'in_octets': '5699519514',
                        'out_octets': '44974624559',
                        'poller_hash': 'ZDAyMWY5OWE4NDZjcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '98547031190303',
                    'out_ucast_pkts':
                    '86596376997',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uMmludGY=',
                    'pons': [{
                        'id':
                        '2',
                        'links': [{
                            'connected_time': '1124230',
                            'fiber_length': 2652,
                            'poller_hash': 'Nzg4YTIwNzNkMDRkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8212952',
                            'fiber_length': 2415,
                            'poller_hash': 'MThlODI5MGI5YmQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1724128',
                            'fiber_length': 3871,
                            'poller_hash': 'MThlODI5MGJiMDNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473875',
                            'fiber_length': 4321,
                            'poller_hash': 'MThlODI5MGJiMGUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875910',
                            'fiber_length': 5060,
                            'poller_hash': 'MThlODI5MGJkOWY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875910',
                            'fiber_length': 5269,
                            'poller_hash': 'MThlODI5MGJkYjI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1895250',
                            'fiber_length': 7204,
                            'poller_hash': 'MThlODI5MTk1ZWZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8212252',
                            'fiber_length': 2391,
                            'poller_hash': 'MThlODI5MTk1ZjAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4156670',
                            'fiber_length': 2595,
                            'poller_hash': 'MThlODI5MTliNDVhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875900',
                            'fiber_length': 5279,
                            'poller_hash': 'MThlODI5ZjVkNGZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1540616',
                            'fiber_length': 5493,
                            'poller_hash': 'NzBhNzQxMzM0NTVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1647767',
                            'fiber_length': 7683,
                            'poller_hash': 'NzBhNzQxMzM0NmVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1356783',
                            'fiber_length': 4336,
                            'poller_hash': 'Nzg0NTU4MDYyNzdkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 2608,
                            'poller_hash': 'Nzg0NTU4OWE1MzI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236315',
                            'fiber_length': 2889,
                            'poller_hash': 'Nzg0NTU4OWE1YjQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7690875',
                            'fiber_length': 4887,
                            'poller_hash': 'NjhkNzlhMDY2N2E5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1471145',
                            'fiber_length': 4859,
                            'poller_hash': 'NjhkNzlhMDY4MjNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4152150',
                            'fiber_length': 2597,
                            'poller_hash': 'NzRhY2I5MDY3MzFicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473875',
                            'fiber_length': 4403,
                            'poller_hash': 'ZjQ5MmJmMDY0YjU1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3807335',
                            'fiber_length': 5470,
                            'poller_hash': 'NzQ4M2MyNDNmNTg1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236325',
                            'fiber_length': 3127,
                            'poller_hash': 'NzQ4M2MyNDNmN2ZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2761781',
                            'fiber_length': 7273,
                            'poller_hash': 'NzQ4M2MyNjgyOWQ1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236345',
                            'fiber_length': 2578,
                            'poller_hash': 'NzQ4M2MyNjhhZmEycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236344',
                            'fiber_length': 3254,
                            'poller_hash': 'NzQ4M2MyNjhjNTg1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236345',
                            'fiber_length': 3115,
                            'poller_hash': 'NzQ4M2MyNjhjNWE5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1562096',
                            'fiber_length': 2399,
                            'poller_hash': 'ZmNlY2RhZTBmMjYycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236325',
                            'fiber_length': 2762,
                            'poller_hash': 'ZmNlY2RhZWI5NTZhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '873427',
                            'fiber_length': 2744,
                            'poller_hash': 'ZmNlY2RhZWI5YmNkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236344',
                            'fiber_length': 3236,
                            'poller_hash': 'YjRmYmU0NzkzNDM1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997763',
                            'fiber_length': 2625,
                            'poller_hash': 'YjRmYmU0NzkzOTNmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473845',
                            'fiber_length': 4623,
                            'poller_hash': 'YjRmYmU0ZTZjNGE5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '11737786',
                            'fiber_length': 2560,
                            'poller_hash': 'YjRmYmU0ZTZjZjI1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2761781',
                            'fiber_length': 7158,
                            'poller_hash': 'YjRmYmU0ZTZjZjU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473624',
                            'fiber_length': 4572,
                            'poller_hash': 'YjRmYmU0ZTZlMWVkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473625',
                            'fiber_length': 4502,
                            'poller_hash': 'YjRmYmU0ZTZlMjlhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5688569',
                            'fiber_length': 7211,
                            'poller_hash': 'YjRmYmU0Zjk1MDNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5334595',
                            'fiber_length': 2381,
                            'poller_hash': 'YjRmYmU0Zjk1M2EycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3644593',
                            'fiber_length': 3222,
                            'poller_hash': 'YjRmYmU0ZjlkYjM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7778616',
                            'fiber_length': 7300,
                            'poller_hash': 'ZDAyMWY5MDYxZjY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2761781',
                            'fiber_length': 7224,
                            'poller_hash': 'ZDAyMWY5OWE4MzQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951638',
                            'fiber_length': 2789,
                            'poller_hash': 'ZDAyMWY5OWE4NDZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon3',
                    'in_errors':
                    '0',
                    'in_octets':
                    '11063818800627',
                    'in_ucast_pkts':
                    '34221471711',
                    'links': [{
                        'in_octets': '26916477814',
                        'out_octets': '354539529981',
                        'poller_hash': 'Nzg4YTIwYzA0NDI0cGVlcmludGY='
                    }, {
                        'in_octets': '52470755',
                        'out_octets': '21736665',
                        'poller_hash': 'MThlODI5MGI3YjIwcGVlcmludGY='
                    }, {
                        'in_octets': '6073705015',
                        'out_octets': '47870585596',
                        'poller_hash': 'MThlODI5MGI5OTZjcGVlcmludGY='
                    }, {
                        'in_octets': '22898687137',
                        'out_octets': '539359714979',
                        'poller_hash': 'MThlODI5MGJiMGQwcGVlcmludGY='
                    }, {
                        'in_octets': '72746249726',
                        'out_octets': '868444339701',
                        'poller_hash': 'MThlODI5MTk1YTgycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['cc:9c:3e:50:b4:eb'],
                        'in_octets': '100191774',
                        'out_octets': '13161400',
                        'poller_hash': 'MThlODI5ZjVkM2NkcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['3c:ec:ef:6f:29:ce', '3c:ec:ef:6f:30:21'],
                        'in_octets':
                        '16057965159',
                        'out_octets':
                        '38862993188',
                        'poller_hash':
                        'MThlODI5ZjVkNGJlcGVlcmludGY='
                    }, {
                        'in_octets': '11633928406',
                        'out_octets': '319737295861',
                        'poller_hash': 'NzBhNzQxMzM0NDQ0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['04:d5:90:5f:5b:b5'],
                        'in_octets': '1122169150',
                        'out_octets': '20811592604',
                        'poller_hash': 'NzBhNzQxMzM0NmUwcGVlcmludGY='
                    }, {
                        'in_octets': '104802381961',
                        'out_octets': '1433260765635',
                        'poller_hash': 'Nzg0NTU4MDYyNGE3cGVlcmludGY='
                    }, {
                        'in_octets': '83127397829',
                        'out_octets': '5181478383559',
                        'poller_hash': 'Nzg0NTU4MDYyNzI2cGVlcmludGY='
                    }, {
                        'in_octets': '38191421835',
                        'out_octets': '627518198044',
                        'poller_hash': 'Nzg0NTU4MDYyOGUwcGVlcmludGY='
                    }, {
                        'in_octets': '49736658591',
                        'out_octets': '1095668450715',
                        'poller_hash': 'Nzg0NTU4MDYyOTMxcGVlcmludGY='
                    }, {
                        'in_octets': '301208890999',
                        'out_octets': '2691025485006',
                        'poller_hash': 'Nzg0NTU4OWE1OWYwcGVlcmludGY='
                    }, {
                        'in_octets': '28678459567',
                        'out_octets': '594247947654',
                        'poller_hash': 'NjhkNzlhMDY2N2JkcGVlcmludGY='
                    }, {
                        'in_octets': '270596986406',
                        'out_octets': '7288813286328',
                        'poller_hash': 'NjhkNzlhMDY4MDNkcGVlcmludGY='
                    }, {
                        'in_octets': '10354185389',
                        'out_octets': '408137292637',
                        'poller_hash': 'ZjQ5MmJmMDZlM2M1cGVlcmludGY='
                    }, {
                        'in_octets': '23257630059',
                        'out_octets': '513717530050',
                        'poller_hash': 'ZjQ5MmJmMDZmM2U0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['18:b1:69:38:8e:d1'],
                        'in_octets': '66846381393',
                        'out_octets': '81890741079',
                        'poller_hash': 'NzQ4M2MyNDNlYzhicGVlcmludGY='
                    }, {
                        'in_octets': '18948295788',
                        'out_octets': '511207640643',
                        'poller_hash': 'NzQ4M2MyNDNmNjI4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['50:c7:bf:39:2b:19'],
                        'in_octets': '11192681513',
                        'out_octets': '199122231467',
                        'poller_hash': 'NzQ4M2MyNDNmNjg1cGVlcmludGY='
                    }, {
                        'in_octets': '75465268098',
                        'out_octets': '1910936437170',
                        'poller_hash': 'NzQ4M2MyNDNmODE5cGVlcmludGY='
                    }, {
                        'in_octets': '276236753',
                        'out_octets': '3933187581',
                        'poller_hash': 'NzQ4M2MyNjgzNTYycGVlcmludGY='
                    }, {
                        'in_octets': '5490536901',
                        'out_octets': '132060310759',
                        'poller_hash': 'YjRmYmU0ZTZhY2EzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:01:21:2f:0a:e4'],
                        'in_octets': '568621885269',
                        'out_octets': '323815704936',
                        'poller_hash': 'YjRmYmU0ZjkyODlicGVlcmludGY='
                    }, {
                        'in_octets': '12203916160',
                        'out_octets': '116107972986',
                        'poller_hash': 'YjRmYmU0Zjk0ZjFhcGVlcmludGY='
                    }, {
                        'in_octets': '255745969',
                        'out_octets': '118185250',
                        'poller_hash': 'YjRmYmU0Zjk0ZmU3cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:90:7f:01:ac:16'],
                        'in_octets': '12166021346',
                        'out_octets': '64190780317',
                        'poller_hash': 'YjRmYmU0ZjlkYzE0cGVlcmludGY='
                    }, {
                        'in_octets': '7252090642',
                        'out_octets': '19746822349',
                        'poller_hash': 'ZDAyMWY5OWFhNTMwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon3',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '105536493817231',
                    'out_ucast_pkts':
                    '86413828151',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uM2ludGY=',
                    'pons': [{
                        'id':
                        '3',
                        'links': [{
                            'connected_time': '1720528',
                            'fiber_length': 3802,
                            'poller_hash': 'Nzg4YTIwYzA0NDI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236345',
                            'fiber_length': 3077,
                            'poller_hash': 'MThlODI5MGI3YjIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '403281',
                            'fiber_length': 6725,
                            'poller_hash': 'MThlODI5MGI5OTZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5249294',
                            'fiber_length': 3213,
                            'poller_hash': 'MThlODI5MGJiMGQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122296',
                            'fiber_length': 6693,
                            'poller_hash': 'MThlODI5MTk1YTgycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236325',
                            'fiber_length': 2942,
                            'poller_hash': 'MThlODI5ZjVkM2NkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1728578',
                            'fiber_length': 3934,
                            'poller_hash': 'MThlODI5ZjVkNGJlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1562996',
                            'fiber_length': 6703,
                            'poller_hash': 'NzBhNzQxMzM0NDQ0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '522143',
                            'fiber_length': 6807,
                            'poller_hash': 'NzBhNzQxMzM0NmUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122295',
                            'fiber_length': 6666,
                            'poller_hash': 'Nzg0NTU4MDYyNGE3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997733',
                            'fiber_length': 3223,
                            'poller_hash': 'Nzg0NTU4MDYyNzI2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 3244,
                            'poller_hash': 'Nzg0NTU4MDYyOGUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122296',
                            'fiber_length': 6668,
                            'poller_hash': 'Nzg0NTU4MDYyOTMxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997733',
                            'fiber_length': 3332,
                            'poller_hash': 'Nzg0NTU4OWE1OWYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1744168',
                            'fiber_length': 6565,
                            'poller_hash': 'NjhkNzlhMDY2N2JkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9117783',
                            'fiber_length': 4906,
                            'poller_hash': 'NjhkNzlhMDY4MDNkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1981181',
                            'fiber_length': 6522,
                            'poller_hash': 'ZjQ5MmJmMDZlM2M1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1894890',
                            'fiber_length': 6694,
                            'poller_hash': 'ZjQ5MmJmMDZmM2U0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 2894,
                            'poller_hash': 'NzQ4M2MyNDNlYzhicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1228172',
                            'fiber_length': 3336,
                            'poller_hash': 'NzQ4M2MyNDNmNjI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 3976,
                            'poller_hash': 'NzQ4M2MyNDNmNjg1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122286',
                            'fiber_length': 6664,
                            'poller_hash': 'NzQ4M2MyNDNmODE5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2904423',
                            'fiber_length': 3221,
                            'poller_hash': 'NzQ4M2MyNjgzNTYycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '250869',
                            'fiber_length': 3088,
                            'poller_hash': 'YjRmYmU0ZTZhY2EzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2139213',
                            'fiber_length': 2860,
                            'poller_hash': 'YjRmYmU0ZjkyODlicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122296',
                            'fiber_length': 6565,
                            'poller_hash': 'YjRmYmU0Zjk0ZjFhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1812429',
                            'fiber_length': 3799,
                            'poller_hash': 'YjRmYmU0Zjk0ZmU3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 3869,
                            'poller_hash': 'YjRmYmU0ZjlkYzE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236345',
                            'fiber_length': 3537,
                            'poller_hash': 'ZDAyMWY5OWFhNTMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon4',
                    'in_errors':
                    '0',
                    'in_octets':
                    '7630009630678',
                    'in_ucast_pkts':
                    '37050894020',
                    'links': [{
                        'in_octets': '471385699',
                        'out_octets': '18341208551',
                        'poller_hash': 'MThlODI5MGI3YWI4cGVlcmludGY='
                    }, {
                        'in_octets': '19211620876',
                        'out_octets': '638479448471',
                        'poller_hash': 'MThlODI5MGJhZTljcGVlcmludGY='
                    }, {
                        'in_octets': '130408759027',
                        'out_octets': '4937645959146',
                        'poller_hash': 'MThlODI5MGJhZjA4cGVlcmludGY='
                    }, {
                        'in_octets': '7514913398',
                        'out_octets': '413976308347',
                        'poller_hash': 'MThlODI5MGJiMDc0cGVlcmludGY='
                    }, {
                        'in_octets': '15779436535',
                        'out_octets': '194266090622',
                        'poller_hash': 'MThlODI5MTk4MTI0cGVlcmludGY='
                    }, {
                        'in_octets': '49432253518',
                        'out_octets': '571808720849',
                        'poller_hash': 'MThlODI5MTliNGVicGVlcmludGY='
                    }, {
                        'in_octets': '27824745623',
                        'out_octets': '1504030425737',
                        'poller_hash': 'Nzg0NTU4MDYyODBmcGVlcmludGY='
                    }, {
                        'in_octets': '48702228981',
                        'out_octets': '2010922396415',
                        'poller_hash': 'Nzg0NTU4OWFmZDRjcGVlcmludGY='
                    }, {
                        'in_octets': '150535737723',
                        'out_octets': '2730946906061',
                        'poller_hash': 'Nzg0NTU4OWFmZDU0cGVlcmludGY='
                    }, {
                        'in_octets': '40282052347',
                        'out_octets': '79350201183',
                        'poller_hash': 'NjhkNzlhMDY0OWM2cGVlcmludGY='
                    }, {
                        'in_octets': '3994390581',
                        'out_octets': '128382929247',
                        'poller_hash': 'NjhkNzlhMDY2N2I5cGVlcmludGY='
                    }, {
                        'in_octets': '15078811039',
                        'out_octets': '338529606302',
                        'poller_hash': 'ZjQ5MmJmMDY0YWM2cGVlcmludGY='
                    }, {
                        'in_octets': '521470',
                        'out_octets': '131600',
                        'poller_hash': 'ZjQ5MmJmMDY0YmUxcGVlcmludGY='
                    }, {
                        'in_octets': '34338396214',
                        'out_octets': '337258223569',
                        'poller_hash': 'NzQ4M2MyNDNmNTUxcGVlcmludGY='
                    }, {
                        'in_octets': '8010190102',
                        'out_octets': '552574059990',
                        'poller_hash': 'NzQ4M2MyNDNmNTY5cGVlcmludGY='
                    }, {
                        'in_octets': '50882319746',
                        'out_octets': '552536006242',
                        'poller_hash': 'NzQ4M2MyNDNmNThhcGVlcmludGY='
                    }, {
                        'in_octets': '184446338435',
                        'out_octets': '1758690674648',
                        'poller_hash': 'NzQ4M2MyNDNmNTlhcGVlcmludGY='
                    }, {
                        'in_octets': '62507626656',
                        'out_octets': '1123680988544',
                        'poller_hash': 'NzQ4M2MyNjg5OThlcGVlcmludGY='
                    }, {
                        'in_octets': '109259587467',
                        'out_octets': '2201083998449',
                        'poller_hash': 'NzQ4M2MyNjg5OWU4cGVlcmludGY='
                    }, {
                        'in_octets': '39343498779',
                        'out_octets': '397430827466',
                        'poller_hash': 'NzQ4M2MyNjhjNGZjcGVlcmludGY='
                    }, {
                        'in_octets': '28695042339',
                        'out_octets': '569738347747',
                        'poller_hash': 'NzQ4M2MyNjhjNWYycGVlcmludGY='
                    }, {
                        'in_octets': '63288639990',
                        'out_octets': '1025020077247',
                        'poller_hash': 'NzQ4M2MyNjhjNjQ4cGVlcmludGY='
                    }, {
                        'in_octets': '27287158826',
                        'out_octets': '638914526447',
                        'poller_hash': 'YjRmYmU0Nzk1ZjE0cGVlcmludGY='
                    }, {
                        'in_octets': '5737046902',
                        'out_octets': '11217440568',
                        'poller_hash': 'YjRmYmU0ZTZiNDVmcGVlcmludGY='
                    }, {
                        'in_octets': '249813544920',
                        'out_octets': '2064999901639',
                        'poller_hash': 'YjRmYmU0ZTZjNTFjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['08:55:31:6d:ed:bd'],
                        'in_octets': '15948212219',
                        'out_octets': '36290512766',
                        'poller_hash': 'YjRmYmU0ZTZjZjU3cGVlcmludGY='
                    }, {
                        'in_octets': '67090417807',
                        'out_octets': '1794180430610',
                        'poller_hash': 'YjRmYmU0ZTZlMWZicGVlcmludGY='
                    }, {
                        'in_octets': '34048230309',
                        'out_octets': '993238928716',
                        'poller_hash': 'YjRmYmU0Zjk0ZjBicGVlcmludGY='
                    }, {
                        'in_octets': '6110626044',
                        'out_octets': '224021002336',
                        'poller_hash': 'ZDAyMWY5OWE4NDQwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon4',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '148849468035998',
                    'out_ucast_pkts':
                    '113908726908',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uNGludGY=',
                    'pons': [{
                        'id':
                        '4',
                        'links': [{
                            'connected_time': '124508',
                            'fiber_length': 3509,
                            'poller_hash': 'MThlODI5MGI3YWI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1258592',
                            'fiber_length': 3355,
                            'poller_hash': 'MThlODI5MGJhZTljcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10170537',
                            'fiber_length': 3944,
                            'poller_hash': 'MThlODI5MGJhZjA4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1201011',
                            'fiber_length': 3966,
                            'poller_hash': 'MThlODI5MGJiMDc0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200991',
                            'fiber_length': 3960,
                            'poller_hash': 'MThlODI5MTk4MTI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200991',
                            'fiber_length': 4134,
                            'poller_hash': 'MThlODI5MTliNGVicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200981',
                            'fiber_length': 4139,
                            'poller_hash': 'Nzg0NTU4MDYyODBmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4676996',
                            'fiber_length': 3516,
                            'poller_hash': 'Nzg0NTU4OWFmZDRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13636289',
                            'fiber_length': 3231,
                            'poller_hash': 'Nzg0NTU4OWFmZDU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5084002',
                            'fiber_length': 4358,
                            'poller_hash': 'NjhkNzlhMDY0OWM2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '511192',
                            'fiber_length': 3877,
                            'poller_hash': 'NjhkNzlhMDY2N2I5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1357523',
                            'fiber_length': 3830,
                            'poller_hash': 'ZjQ5MmJmMDY0YWM2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997742',
                            'fiber_length': 3827,
                            'poller_hash': 'ZjQ5MmJmMDY0YmUxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3006415',
                            'fiber_length': 4249,
                            'poller_hash': 'NzQ4M2MyNDNmNTUxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200531',
                            'fiber_length': 4397,
                            'poller_hash': 'NzQ4M2MyNDNmNTY5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200981',
                            'fiber_length': 4112,
                            'poller_hash': 'NzQ4M2MyNDNmNThhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8022689',
                            'fiber_length': 3861,
                            'poller_hash': 'NzQ4M2MyNDNmNTlhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2742971',
                            'fiber_length': 3974,
                            'poller_hash': 'NzQ4M2MyNjg5OThlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '11328721',
                            'fiber_length': 3679,
                            'poller_hash': 'NzQ4M2MyNjg5OWU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1201011',
                            'fiber_length': 3828,
                            'poller_hash': 'NzQ4M2MyNjhjNGZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1201011',
                            'fiber_length': 4365,
                            'poller_hash': 'NzQ4M2MyNjhjNWYycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4570205',
                            'fiber_length': 3984,
                            'poller_hash': 'NzQ4M2MyNjhjNjQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2163114',
                            'fiber_length': 3342,
                            'poller_hash': 'YjRmYmU0Nzk1ZjE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10897926',
                            'fiber_length': 4018,
                            'poller_hash': 'YjRmYmU0ZTZiNDVmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '12887901',
                            'fiber_length': 3510,
                            'poller_hash': 'YjRmYmU0ZTZjNTFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '14836772',
                            'fiber_length': 3512,
                            'poller_hash': 'YjRmYmU0ZTZjZjU3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5281134',
                            'fiber_length': 4243,
                            'poller_hash': 'YjRmYmU0ZTZlMWZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5833551',
                            'fiber_length': 3324,
                            'poller_hash': 'YjRmYmU0Zjk0ZjBicG9ubGluaw==',
        