import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):
    def test_calix_exa_E7_20_3_4_30_40_01(self):
        obj = self.run_data("calix.exa.E7-20.3.4.30.40.01")
        exp_info = {
         'model': 'E7-20', 'sw_version': '3.4.30.40', 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': None, 'system_mac_address': None
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'Calix',
                                'model': 'E7-20',
                                'modules': [       {       'id': '1',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM2NzU=',
                                                           'serial_number': '81110003675',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '2',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM2MjE=',
                                                           'serial_number': '81110003621',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '3',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNDA3NjAxNTcz',
                                                           'serial_number': '211407601573',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '4',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDQwMDk=',
                                                           'serial_number': '81110004009',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '5',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNTA5NjAxMDIx',
                                                           'serial_number': '211509601021',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '6',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNjAzNjAxMTkw',
                                                           'serial_number': '211603601190',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '7',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03007',
                                                           'name': 'GPON-8x',
                                                           'poller_hash': 'MjExNjA1NjAxMjE1',
                                                           'serial_number': '211605601215',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '8',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03007',
                                                           'name': 'GPON-8x',
                                                           'poller_hash': 'MjExNjEyNjA2Njcy',
                                                           'serial_number': '211612606672',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '9',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03007',
                                                           'name': 'GPON-8x',
                                                           'poller_hash': 'MjExNjEyNjA2NjUw',
                                                           'serial_number': '211612606650',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '14',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03007',
                                                           'name': 'GPON-8x',
                                                           'poller_hash': 'NDcxOTA1MDEwMzUz',
                                                           'serial_number': '471905010353',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '15',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNTA1NjAwMDA5',
                                                           'serial_number': '211505600009',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '16',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNTA1NjAwMDk1',
                                                           'serial_number': '211505600095',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '17',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM5ODg=',
                                                           'serial_number': '81110003988',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '18',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM1NjQ=',
                                                           'serial_number': '81110003564',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '19',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDQwNTE=',
                                                           'serial_number': '81110004051',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': '20',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM5MzM=',
                                                           'serial_number': '81110003933',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': 'A',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02092',
                                                           'name': 'SCP-10GE',
                                                           'poller_hash': 'MjExMzAyNjAxOTEy',
                                                           'serial_number': '211302601912',
                                                           'sw_version': '3.4.30.40'},
                                                   {       'id': 'B',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02092',
                                                           'name': 'SCP-10GE',
                                                           'poller_hash': 'MjExMzAyNjAxOTU4',
                                                           'serial_number': '211302601958',
                                                           'sw_version': '3.4.30.40'}],
                                'system_mac_address': '00:02:5d:f4:8c:07'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_calix_exa_E7_2_EXA_3_4_50_99_01(self):
        obj = self.run_data("calix.exa.E7-2 (EXA).3.4.50.99.01")
        exp_info = {
         'model': 'E7-2 (EXA)', 'sw_version': '3.4.50.99', 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': None, 'system_mac_address': None
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'Calix',
                                'model': 'E7-2 (EXA)',
                                'modules': [       {       'id': '1',
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03006',
                                                           'name': 'GPON-8',
                                                           'poller_hash': 'NDcxOTA1MDEwNDE1',
                                                           'serial_number': '471905010415',
                                                           'sw_version': '3.4.50.99'}],
                                'system_mac_address': '48:77:46:05:e9:2f'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
