import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestAdtranModels(DeviceTestCase):

    def test_adtran_ta5000_TA5000_11_1_5_4_01(self):
        obj = self.run_data("adtran.ta5000.TA5000.11.1.5.4.01")
        exp_info = {
                'model': 'TA5000',
                'sta_count': 208,
                'sw_version': '11.1.5.4',
                'vendor': 'Adtran'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                'ADTN20252643': {       'dev_macs': None,
                                        'ip_address': None,
                                        'name': '2@1/3/8',
                                        'serial': 'ADTN20252643'},
                'ADTN203419c2': {       'dev_macs': ['8:b4:b1:13:5f:27'],
                                        'ip_address': None,
                                        'name': '3@1/2/3',
                                        'serial': 'ADTN203419c2'},
                'ADTN20342af1': {       'dev_macs': ['c4:41:1e:1b:62:b'],
                                        'ip_address': None,
                                        'name': '6@1/2/1',
                                        'serial': 'ADTN20342af1'},
                'ADTN20342c28': {       'dev_macs': [       '0:26:2d:fe:60:f1',
                                                            'b0:39:56:4e:e6:ae'],
                                        'ip_address': None,
                                        'name': '5@1/2/1',
                                        'serial': 'ADTN20342c28'},
                'ADTN210867a6': {       'dev_macs': [       '0:24:45:dd:73:0',
                                                            '0:24:45:dd:73:ff'],
                                        'ip_address': None,
                                        'name': '14@1/1/4',
                                        'serial': 'ADTN210867a6'},
                'ADTN210867b0': {       'dev_macs': [       '0:24:45:dd:74:95',
                                                            '0:24:45:dd:74:96'],
                                        'ip_address': None,
                                        'name': '2@1/2/1',
                                        'serial': 'ADTN210867b0'},
                'ADTN210867be': {       'dev_macs': [       '0:24:45:dd:75:67',
                                                            '0:24:45:dd:75:68'],
                                        'ip_address': None,
                                        'name': '3@1/1/7',
                                        'serial': 'ADTN210867be'},
                'ADTN210867c3': {       'dev_macs': [       '0:24:45:dd:75:b2',
                                                            '0:24:45:dd:75:b3'],
                                        'ip_address': None,
                                        'name': '1@1/1/3',
                                        'serial': 'ADTN210867c3'},
                'ADTN210867d5': {       'dev_macs': [       '0:24:45:dd:76:c0',
                                                            '0:24:45:dd:76:c1'],
                                        'ip_address': None,
                                        'name': '10@1/1/2',
                                        'serial': 'ADTN210867d5'},
                'ADTN210867db': {       'dev_macs': [       '0:24:45:dd:77:1a',
                                                            '0:24:45:dd:77:1b'],
                                        'ip_address': None,
                                        'name': '1@1/2/1',
                                        'serial': 'ADTN210867db'},
                'ADTN210867ea': {       'dev_macs': [       '0:24:45:dd:77:fb',
                                                            '0:24:45:dd:77:fc'],
                                        'ip_address': None,
                                        'name': '6@1/2/2',
                                        'serial': 'ADTN210867ea'},
                'ADTN210867ec': {       'dev_macs': [       '0:24:45:dd:78:19',
                                                            '0:24:45:dd:78:1a'],
                                        'ip_address': None,
                                        'name': '10@1/1/3',
                                        'serial': 'ADTN210867ec'},
                'ADTN210867f6': {       'dev_macs': [       '0:24:45:dd:78:af',
                                                            '0:24:45:dd:78:b0'],
                                        'ip_address': None,
                                        'name': '1@1/2/2',
                                        'serial': 'ADTN210867f6'},
                'ADTN2108680c': {       'dev_macs': [       '0:24:45:dd:79:f9',
                                                            '0:24:45:dd:79:fa'],
                                        'ip_address': None,
                                        'name': '5@1/2/3',
                                        'serial': 'ADTN2108680c'},
                'ADTN21086814': {       'dev_macs': [       '0:24:45:dd:7a:71',
                                                            '0:24:45:dd:7a:72'],
                                        'ip_address': None,
                                        'name': '7@1/3/1',
                                        'serial': 'ADTN21086814'},
                'ADTN21086825': {       'dev_macs': [       '0:24:45:dd:7b:70',
                                                            '0:24:45:dd:7b:71'],
                                        'ip_address': None,
                                        'name': '6@1/2/8',
                                        'serial': 'ADTN21086825'},
                'ADTN2108682f': {       'dev_macs': [       '0:24:45:dd:7c:6',
                                                            '0:24:45:dd:7c:7'],
                                        'ip_address': None,
                                        'name': '6@1/3/1',
                                        'serial': 'ADTN2108682f'},
                'ADTN21086830': {       'dev_macs': [       '0:24:45:dd:7c:15',
                                                            '0:24:45:dd:7c:16'],
                                        'ip_address': None,
                                        'name': '6@1/2/3',
                                        'serial': 'ADTN21086830'},
                'ADTN2108683b': {       'dev_macs': [       '0:24:45:dd:7c:ba',
                                                            '0:24:45:dd:7c:bb'],
                                        'ip_address': None,
                                        'name': '15@1/3/4',
                                        'serial': 'ADTN2108683b'},
                'ADTN2108683e': {       'dev_macs': [       '0:24:45:dd:7c:e7',
                                                            '0:24:45:dd:7c:e8'],
                                        'ip_address': None,
                                        'name': '4@1/1/6',
                                        'serial': 'ADTN2108683e'},
                'ADTN21086841': {       'dev_macs': [       '0:24:45:dd:7d:14',
                                                            '0:24:45:dd:7d:15'],
                                        'ip_address': None,
                                        'name': '5@1/2/8',
                                        'serial': 'ADTN21086841'},
                'ADTN2108684f': {       'dev_macs': [       '0:24:45:dd:7d:e6',
                                                            '0:24:45:dd:7d:e7'],
                                        'ip_address': None,
                                        'name': '7@1/2/4',
                                        'serial': 'ADTN2108684f'},
                'ADTN2108685c': {       'dev_macs': [       '0:24:45:dd:7e:a9',
                                                            '0:24:45:dd:7e:aa'],
                                        'ip_address': None,
                                        'name': '9@1/2/2',
                                        'serial': 'ADTN2108685c'},
                'ADTN2108685e': {       'dev_macs': [       '0:24:45:dd:7e:c7',
                                                            '0:24:45:dd:7e:c8'],
                                        'ip_address': None,
                                        'name': '8@1/1/4',
                                        'serial': 'ADTN2108685e'},
                'ADTN2108686e': {       'dev_macs': [       '0:24:45:dd:7f:b7',
                                                            '0:24:45:dd:7f:b8'],
                                        'ip_address': None,
                                        'name': '13@1/3/4',
                                        'serial': 'ADTN2108686e'},
                'ADTN21086874': {       'dev_macs': [       '0:24:45:dd:80:11',
                                                            '0:24:45:dd:80:12'],
                                        'ip_address': None,
                                        'name': '5@1/2/5',
                                        'serial': 'ADTN21086874'},
                'ADTN21086880': {       'dev_macs': [       '0:24:45:dd:80:c5',
                                                            '0:24:45:dd:80:c6'],
                                        'ip_address': None,
                                        'name': '8@1/1/8',
                                        'serial': 'ADTN21086880'},
                'ADTN2108688e': {       'dev_macs': [       '0:24:45:dd:81:97',
                                                            '0:24:45:dd:81:98'],
                                        'ip_address': None,
                                        'name': '10@1/2/7',
                                        'serial': 'ADTN2108688e'},
                'ADTN2108689a': {       'dev_macs': [       '0:24:45:dd:82:4b',
                                                            '0:24:45:dd:82:4c'],
                                        'ip_address': None,
                                        'name': '8@1/2/4',
                                        'serial': 'ADTN2108689a'},
                'ADTN210868a3': {       'dev_macs': [       '0:24:45:dd:82:d2',
                                                            '0:24:45:dd:82:d3'],
                                        'ip_address': None,
                                        'name': '13@1/2/7',
                                        'serial': 'ADTN210868a3'},
                'ADTN210868b9': {       'dev_macs': [       '0:24:45:dd:84:1c',
                                                            '0:24:45:dd:84:1d'],
                                        'ip_address': None,
                                        'name': '17@1/3/4',
                                        'serial': 'ADTN210868b9'},
                'ADTN210868bb': {       'dev_macs': [       '0:24:45:dd:84:3a',
                                                            '0:24:45:dd:84:3b'],
                                        'ip_address': None,
                                        'name': '5@1/1/5',
                                        'serial': 'ADTN210868bb'},
                'ADTN210868c7': {       'dev_macs': [       '0:24:45:dd:84:ee',
                                                            '0:24:45:dd:84:ef'],
                                        'ip_address': None,
                                        'name': '7@1/2/1',
                                        'serial': 'ADTN210868c7'},
                'ADTN210868d0': {       'dev_macs': [       '0:24:45:dd:85:75',
                                                            '0:24:45:dd:85:76'],
                                        'ip_address': None,
                                        'name': '11@1/2/7',
                                        'serial': 'ADTN210868d0'},
                'ADTN210868ef': {       'dev_macs': [       '0:24:45:dd:87:46',
                                                            '0:24:45:dd:87:47'],
                                        'ip_address': None,
                                        'name': '2@1/1/2',
                                        'serial': 'ADTN210868ef'},
                'ADTN210868f8': {       'dev_macs': [       '0:24:45:dd:87:cd',
                                                            '0:24:45:dd:87:ce'],
                                        'ip_address': None,
                                        'name': '8@1/2/6',
                                        'serial': 'ADTN210868f8'},
                'ADTN21086901': {       'dev_macs': [       '0:24:45:dd:88:54',
                                                            '0:24:45:dd:88:55'],
                                        'ip_address': None,
                                        'name': '8@1/1/2',
                                        'serial': 'ADTN21086901'},
                'ADTN21086912': {       'dev_macs': [       '0:24:45:dd:89:53',
                                                            '0:24:45:dd:89:54'],
                                        'ip_address': None,
                                        'name': '6@1/1/1',
                                        'serial': 'ADTN21086912'},
                'ADTN21086915': {       'dev_macs': [       '0:24:45:dd:89:80',
                                                            '0:24:45:dd:89:81'],
                                        'ip_address': None,
                                        'name': '9@1/1/2',
                                        'serial': 'ADTN21086915'},
                'ADTN2108691c': {       'dev_macs': [       '0:24:45:dd:89:e9',
                                                            '0:24:45:dd:89:ea'],
                                        'ip_address': None,
                                        'name': '6@1/1/2',
                                        'serial': 'ADTN2108691c'},
                'ADTN2109c3ef': {       'dev_macs': ['80:cc:9c:bb:b6:f5'],
                                        'ip_address': None,
                                        'name': '4@1/2/3',
                                        'serial': 'ADTN2109c3ef'},
                'ADTN2109c435': {       'dev_macs': ['18:fd:74:13:b4:31'],
                                        'ip_address': None,
                                        'name': '5@1/1/2',
                                        'serial': 'ADTN2109c435'},
                'ADTN21103d37': {       'dev_macs': [       '0:24:45:e0:7c:58',
                                                            '50:c7:bf:7f:60:bd'],
                                        'ip_address': None,
                                        'name': '4@1/2/1',
                                        'serial': 'ADTN21103d37'},
                'ADTN21103db3': {       'dev_macs': [       '0:24:45:e0:7c:d4',
                                                            '2c:c8:1b:c4:e3:73'],
                                        'ip_address': None,
                                        'name': '2@1/3/1',
                                        'serial': 'ADTN21103db3'},
                'ADTN21103db5': {       'dev_macs': ['d8:ec:5e:9c:50:fb'],
                                        'ip_address': None,
                                        'name': '5@1/1/6',
                                        'serial': 'ADTN21103db5'},
                'ADTN21103ec5': {       'dev_macs': [       '0:24:45:e0:7d:e6',
                                                            '44:8a:5b:88:4c:5f',
                                                            'fc:34:97:1b:21:a8'],
                                        'ip_address': None,
                                        'name': '3@1/2/6',
                                        'serial': 'ADTN21103ec5'},
                'ADTN21103ed2': {       'dev_macs': [       '0:24:45:e0:7d:f3',
                                                            '6c:cd:d6:51:1c:cb'],
                                        'ip_address': None,
                                        'name': '4@1/3/1',
                                        'serial': 'ADTN21103ed2'},
                'ADTN21103f90': {       'dev_macs': [       '0:24:45:e0:7e:b1',
                                                            '6c:cd:d6:1a:9a:84'],
                                        'ip_address': None,
                                        'name': '3@1/1/2',
                                        'serial': 'ADTN21103f90'},
                'ADTN21103ffb': {       'dev_macs': [       '0:24:45:e0:7f:1c',
                                                            '60:38:e0:72:b4:63'],
                                        'ip_address': None,
                                        'name': '6@1/1/3',
                                        'serial': 'ADTN21103ffb'},
                'ADTN21104045': {       'dev_macs': [       '0:24:45:e0:7f:66',
                                                            '6c:5a:b0:b4:c7:9f'],
                                        'ip_address': None,
                                        'name': '3@1/2/7',
                                        'serial': 'ADTN21104045'},
                'ADTN21104050': {       'dev_macs': None,
                                        'ip_address': None,
                                        'name': '1@1/1/4',
                                        'serial': 'ADTN21104050'},
                'ADTN2110406c': {       'dev_macs': ['60:38:e0:a1:fc:2d'],
                                        'ip_address': None,
                                        'name': '3@1/1/3',
                                        'serial': 'ADTN2110406c'},
                'ADTN2110406e': {       'dev_macs': [       '0:24:45:e0:7f:8f',
                                                            '6c:cd:d6:45:44:ed',
                                                            '7c:10:c9:eb:4e:8'],
                                        'ip_address': None,
                                        'name': '4@1/2/7',
                                        'serial': 'ADTN2110406e'},
                'ADTN2110406f': {       'dev_macs': None,
                                        'ip_address': None,
                                        'name': '7@1/1/7',
                                        'serial': 'ADTN2110406f'},
                'ADTN21104075': {       'dev_macs': ['0:24:45:e0:7f:96'],
                                        'ip_address': None,
                                        'name': '6@1/1/8',
                                        'serial': 'ADTN21104075'},
                'ADTN211040c8': {       'dev_macs': ['d8:ec:5e:1a:d5:be'],
                                        'ip_address': None,
                                        'name': '1@1/1/2',
                                        'serial': 'ADTN211040c8'},
                'ADTN211040e9': {       'dev_macs': ['80:3f:5d:d4:30:10'],
                                        'ip_address': None,
                                        'name': '3@1/2/5',
                                        'serial': 'ADTN211040e9'},
                'ADTN21104186': {       'dev_macs': [       '0:24:45:e0:80:a7',
                                                            '60:32:b1:68:ed:75'],
                                        'ip_address': None,
                                        'name': '6@1/2/5',
                                        'serial': 'ADTN21104186'},
                'ADTN2110418c': {       'dev_macs': ['dc:2c:6e:62:15:9c'],
                                        'ip_address': None,
                                        'name': '2@1/2/2',
                                        'serial': 'ADTN2110418c'},
                'ADTN2110418d': {       'dev_macs': [       '0:24:45:e0:80:ae',
                                                            '2c:fd:a1:34:de:50',
                                                            '48:22:54:56:db:ac'],
                                        'ip_address': None,
                                        'name': '2@1/1/7',
                                        'serial': 'ADTN2110418d'},
                'ADTN21126c29': {       'dev_macs': [       '0:24:45:ea:6f:e2',
                                                            '0:24:45:ea:6f:e3'],
                                        'ip_address': None,
                                        'name': '8@1/2/2',
                                        'serial': 'ADTN21126c29'},
                'ADTN21126c44': {       'dev_macs': [       '0:24:45:ea:71:77',
                                                            '0:24:45:ea:71:78'],
                                        'ip_address': None,
                                        'name': '9@1/2/7',
                                        'serial': 'ADTN21126c44'},
                'ADTN21126e48': {       'dev_macs': [       '0:24:45:ea:8f:b3',
                                                            '0:24:45:ea:8f:b4'],
                                        'ip_address': None,
                                        'name': '3@1/2/2',
                                        'serial': 'ADTN21126e48'},
                'ADTN21126e68': {       'dev_macs': [       '0:24:45:ea:91:93',
                                                            '0:24:45:ea:91:94'],
                                        'ip_address': None,
                                        'name': '11@1/1/3',
                                        'serial': 'ADTN21126e68'},
                'ADTN21126e7e': {       'dev_macs': [       '0:24:45:ea:92:dd',
                                                            '0:24:45:ea:92:de'],
                                        'ip_address': None,
                                        'name': '11@1/3/2',
                                        'serial': 'ADTN21126e7e'},
                'ADTN21126ea1': {       'dev_macs': [       '0:24:45:ea:94:ea',
                                                            '0:24:45:ea:94:eb'],
                                        'ip_address': None,
                                        'name': '7@1/2/8',
                                        'serial': 'ADTN21126ea1'},
                'ADTN21127027': {       'dev_macs': [       '0:24:45:ea:ab:c4',
                                                            '0:24:45:ea:ab:c5'],
                                        'ip_address': None,
                                        'name': '9@1/1/7',
                                        'serial': 'ADTN21127027'},
                'ADTN21127045': {       'dev_macs': [       '0:24:45:ea:ad:86',
                                                            '0:24:45:ea:ad:87'],
                                        'ip_address': None,
                                        'name': '8@1/3/1',
                                        'serial': 'ADTN21127045'},
                'ADTN21127059': {       'dev_macs': [       '0:24:45:ea:ae:b2',
                                                            '0:24:45:ea:ae:b3'],
                                        'ip_address': None,
                                        'name': '9@1/1/1',
                                        'serial': 'ADTN21127059'},
                'ADTN2112719d': {       'dev_macs': [       '0:24:45:ea:c1:ae',
                                                            '0:24:45:ea:c1:af'],
                                        'ip_address': None,
                                        'name': '1@1/2/3',
                                        'serial': 'ADTN2112719d'},
                'ADTN21127391': {       'dev_macs': [       '0:24:45:ea:de:fa',
                                                            '0:24:45:ea:de:fb'],
                                        'ip_address': None,
                                        'name': '7@1/1/2',
                                        'serial': 'ADTN21127391'},
                'ADTN211273a6': {       'dev_macs': [       '0:24:45:ea:e0:35',
                                                            '0:24:45:ea:e0:36'],
                                        'ip_address': None,
                                        'name': '14@1/3/3',
                                        'serial': 'ADTN211273a6'},
                'ADTN21127484': {       'dev_macs': [       '0:24:45:ea:ed:37',
                                                            '0:24:45:ea:ed:38'],
                                        'ip_address': None,
                                        'name': '4@1/3/3',
                                        'serial': 'ADTN21127484'},
                'ADTN21127ad5': {       'dev_macs': [       '0:24:45:eb:4b:f6',
                                                            '0:24:45:eb:4b:f7'],
                                        'ip_address': None,
                                        'name': '2@1/2/7',
                                        'serial': 'ADTN21127ad5'},
                'ADTN21127b54': {       'dev_macs': [       '0:24:45:eb:53:67',
                                                            '0:24:45:eb:53:68'],
                                        'ip_address': None,
                                        'name': '12@1/1/8',
                                        'serial': 'ADTN21127b54'},
                'ADTN21127b5f': {       'dev_macs': [       '0:24:45:eb:54:c',
                                                            '0:24:45:eb:54:d'],
                                        'ip_address': None,
                                        'name': '7@1/3/4',
                                        'serial': 'ADTN21127b5f'},
                'ADTN21127b62': {       'dev_macs': [       '0:24:45:eb:54:39',
                                                            '0:24:45:eb:54:3a'],
                                        'ip_address': None,
                                        'name': '10@1/2/6',
                                        'serial': 'ADTN21127b62'},
                'ADTN21127b67': {       'dev_macs': [       '0:24:45:eb:54:84',
                                                            '0:24:45:eb:54:85'],
                                        'ip_address': None,
                                        'name': '3@1/1/1',
                                        'serial': 'ADTN21127b67'},
                'ADTN21127d3a': {       'dev_macs': [       '0:24:45:eb:6f:e1',
                                                            '0:24:45:eb:6f:e2'],
                                        'ip_address': None,
                                        'name': '2@1/2/5',
                                        'serial': 'ADTN21127d3a'},
                'ADTN21127d43': {       'dev_macs': [       '0:24:45:eb:70:68',
                                                            '0:24:45:eb:70:69'],
                                        'ip_address': None,
                                        'name': '12@1/1/7',
                                        'serial': 'ADTN21127d43'},
                'ADTN21127d49': {       'dev_macs': [       '0:24:45:eb:70:c2',
                                                            '0:24:45:eb:70:c3'],
                                        'ip_address': None,
                                        'name': '10@1/2/2',
                                        'serial': 'ADTN21127d49'},
                'ADTN21127d4b': {       'dev_macs': [       '0:24:45:eb:70:e0',
                                                            '0:24:45:eb:70:e1'],
                                        'ip_address': None,
                                        'name': '12@1/3/1',
                                        'serial': 'ADTN21127d4b'},
                'ADTN21127d4f': {       'dev_macs': [       '0:24:45:eb:71:1c',
                                                            '0:24:45:eb:71:1d'],
                                        'ip_address': None,
                                        'name': '5@1/1/4',
                                        'serial': 'ADTN21127d4f'},
                'ADTN21127d50': {       'dev_macs': [       '0:24:45:eb:71:2b',
                                                            '0:24:45:eb:71:2c'],
                                        'ip_address': None,
                                        'name': '12@1/2/2',
                                        'serial': 'ADTN21127d50'},
                'ADTN21127e23': {       'dev_macs': [       '0:24:45:eb:7d:88',
                                                            '0:24:45:eb:7d:89'],
                                        'ip_address': None,
                                        'name': '13@1/3/3',
                                        'serial': 'ADTN21127e23'},
                'ADTN21127e24': {       'dev_macs': [       '0:24:45:eb:7d:97',
                                                            '0:24:45:eb:7d:98'],
                                        'ip_address': None,
                                        'name': '2@1/3/2',
                                        'serial': 'ADTN21127e24'},
                'ADTN21127e40': {       'dev_macs': [       '0:24:45:eb:7f:3b',
                                                            '0:24:45:eb:7f:3c'],
                                        'ip_address': None,
                                        'name': '5@1/2/6',
                                        'serial': 'ADTN21127e40'},
                'ADTN21127e54': {       'dev_macs': [       '0:24:45:eb:80:67',
                                                            '0:24:45:eb:80:68'],
                                        'ip_address': None,
                                        'name': '4@1/1/2',
                                        'serial': 'ADTN21127e54'},
                'ADTN21127e56': {       'dev_macs': [       '0:24:45:eb:80:85',
                                                            '0:24:45:eb:80:86'],
                                        'ip_address': None,
                                        'name': '11@1/3/1',
                                        'serial': 'ADTN21127e56'},
                'ADTN21127e5e': {       'dev_macs': [       '0:24:45:eb:80:fd',
                                                            '0:24:45:eb:80:fe'],
                                        'ip_address': None,
                                        'name': '6@1/3/2',
                                        'serial': 'ADTN21127e5e'},
                'ADTN21159c26': {       'dev_macs': [       '0:24:45:fd:9c:ea',
                                                            '0:24:45:fd:9c:eb'],
                                        'ip_address': None,
                                        'name': '5@1/2/7',
                                        'serial': 'ADTN21159c26'},
                'ADTN21159c42': {       'dev_macs': [       '0:24:45:fd:9e:8e',
                                                            '0:24:45:fd:9e:8f'],
                                        'ip_address': None,
                                        'name': '7@1/1/5',
                                        'serial': 'ADTN21159c42'},
                'ADTN21159c70': {       'dev_macs': [       '0:24:45:fd:a1:40',
                                                            '0:24:45:fd:a1:41'],
                                        'ip_address': None,
                                        'name': '2@1/1/8',
                                        'serial': 'ADTN21159c70'},
                'ADTN21159c74': {       'dev_macs': [       '0:24:45:fd:a1:7c',
                                                            '0:24:45:fd:a1:7d'],
                                        'ip_address': None,
                                        'name': '4@1/2/2',
                                        'serial': 'ADTN21159c74'},
                'ADTN21159c91': {       'dev_macs': [       '0:24:45:fd:a3:2f',
                                                            '0:24:45:fd:a3:30'],
                                        'ip_address': None,
                                        'name': '2@1/1/3',
                                        'serial': 'ADTN21159c91'},
                'ADTN21159c93': {       'dev_macs': [       '0:24:45:fd:a3:4d',
                                                            '0:24:45:fd:a3:4e'],
                                        'ip_address': None,
                                        'name': '13@1/1/3',
                                        'serial': 'ADTN21159c93'},
                'ADTN21159c94': {       'dev_macs': [       '0:24:45:fd:a3:5c',
                                                            '0:24:45:fd:a3:5d'],
                                        'ip_address': None,
                                        'name': '12@1/3/3',
                                        'serial': 'ADTN21159c94'},
                'ADTN21159c97': {       'dev_macs': [       '0:24:45:fd:a3:89',
                                                            '0:24:45:fd:a3:8a'],
                                        'ip_address': None,
                                        'name': '3@1/1/5',
                                        'serial': 'ADTN21159c97'},
                'ADTN21159ca5': {       'dev_macs': [       '0:24:45:fd:a4:5b',
                                                            '0:24:45:fd:a4:5c'],
                                        'ip_address': None,
                                        'name': '4@1/1/7',
                                        'serial': 'ADTN21159ca5'},
                'ADTN21159ca8': {       'dev_macs': [       '0:24:45:fd:a4:88',
                                                            '0:24:45:fd:a4:89'],
                                        'ip_address': None,
                                        'name': '4@1/1/5',
                                        'serial': 'ADTN21159ca8'},
                'ADTN21159ca9': {       'dev_macs': [       '0:24:45:fd:a4:97',
                                                            '0:24:45:fd:a4:98'],
                                        'ip_address': None,
                                        'name': '1@1/3/2',
                                        'serial': 'ADTN21159ca9'},
                'ADTN21159cae': {       'dev_macs': [       '0:24:45:fd:a4:e2',
                                                            '0:24:45:fd:a4:e3'],
                                        'ip_address': None,
                                        'name': '8@1/2/1',
                                        'serial': 'ADTN21159cae'},
                'ADTN21159caf': {       'dev_macs': [       '0:24:45:fd:a4:f1',
                                                            '0:24:45:fd:a4:f2'],
                                        'ip_address': None,
                                        'name': '4@1/1/1',
                                        'serial': 'ADTN21159caf'},
                'ADTN21159cb0': {       'dev_macs': [       '0:24:45:fd:a5:0',
                                                            '0:24:45:fd:a5:1'],
                                        'ip_address': None,
                                        'name': '6@1/1/6',
                                        'serial': 'ADTN21159cb0'},
                'ADTN21159cca': {       'dev_macs': [       '0:24:45:fd:a6:86',
                                                            '0:24:45:fd:a6:87'],
                                        'ip_address': None,
                                        'name': '3@1/2/4',
                                        'serial': 'ADTN21159cca'},
                'ADTN21159cd1': {       'dev_macs': [       '0:24:45:fd:a6:ef',
                                                            '0:24:45:fd:a6:f0'],
                                        'ip_address': None,
                                        'name': '1@1/2/5',
                                        'serial': 'ADTN21159cd1'},
                'ADTN21159cd2': {       'dev_macs': [       '0:24:45:fd:a6:fe',
                                                            '0:24:45:fd:a6:ff'],
                                        'ip_address': None,
                                        'name': '3@1/3/1',
                                        'serial': 'ADTN21159cd2'},
                'ADTN21159cdb': {       'dev_macs': [       '0:24:45:fd:a7:85',
                                                            '0:24:45:fd:a7:86'],
                                        'ip_address': None,
                                        'name': '4@1/2/4',
                                        'serial': 'ADTN21159cdb'},
                'ADTN21159cdf': {       'dev_macs': [       '0:24:45:fd:a7:c1',
                                                            '0:24:45:fd:a7:c2'],
                                        'ip_address': None,
                                        'name': '7@1/1/4',
                                        'serial': 'ADTN21159cdf'},
                'ADTN21159cec': {       'dev_macs': [       '0:24:45:fd:a8:84',
                                                            '0:24:45:fd:a8:85'],
                                        'ip_address': None,
                                        'name': '2@1/2/6',
                                        'serial': 'ADTN21159cec'},
                'ADTN21159cf2': {       'dev_macs': [       '0:24:45:fd:a8:de',
                                                            '0:24:45:fd:a8:df'],
                                        'ip_address': None,
                                        'name': '2@1/2/4',
                                        'serial': 'ADTN21159cf2'},
                'ADTN21159cf6': {       'dev_macs': [       '0:24:45:fd:a9:1a',
                                                            '0:24:45:fd:a9:1b'],
                                        'ip_address': None,
                                        'name': '5@1/3/1',
                                        'serial': 'ADTN21159cf6'},
                'ADTN21159d2f': {       'dev_macs': [       '0:24:45:fd:ac:71',
                                                            '0:24:45:fd:ac:72'],
                                        'ip_address': None,
                                        'name': '8@1/1/3',
                                        'serial': 'ADTN21159d2f'},
                'ADTN21159d44': {       'dev_macs': None,
                                        'ip_address': None,
                                        'name': '5@1/1/8',
                                        'serial': 'ADTN21159d44'},
                'ADTN21159d46': {       'dev_macs': [       '0:24:45:fd:ad:ca',
                                                            '0:24:45:fd:ad:cb'],
                                        'ip_address': None,
                                        'name': '4@1/2/6',
                                        'serial': 'ADTN21159d46'},
                'ADTN21159d77': {       'dev_macs': [       '0:24:45:fd:b0:a9',
                                                            '0:24:45:fd:b0:aa'],
                                        'ip_address': None,
                                        'name': '13@1/3/2',
                                        'serial': 'ADTN21159d77'},
                'ADTN21159d83': {       'dev_macs': [       '0:24:45:fd:b1:5d',
                                                            '0:24:45:fd:b1:5e'],
                                        'ip_address': None,
                                        'name': '2@1/1/1',
                                        'serial': 'ADTN21159d83'},
                'ADTN21159df3': {       'dev_macs': [       '0:24:45:fd:b7:ed',
                                                            '0:24:45:fd:b7:ee'],
                                        'ip_address': None,
                                        'name': '4@1/1/4',
                                        'serial': 'ADTN21159df3'},
                'ADTN21159df5': {       'dev_macs': None,
                                        'ip_address': None,
                                        'name': '5@1/1/7',
                                        'serial': 'ADTN21159df5'},
                'ADTN21159dfb': {       'dev_macs': [       '0:24:45:fd:b8:65',
                                                            '0:24:45:fd:b8:66'],
                                        'ip_address': None,
                                        'name': '2@1/2/8',
                                        'serial': 'ADTN21159dfb'},
                'ADTN21159e02': {       'dev_macs': [       '0:24:45:fd:b8:ce',
                                                            '0:24:45:fd:b8:cf'],
                                        'ip_address': None,
                                        'name': '6@1/1/4',
                                        'serial': 'ADTN21159e02'},
                'ADTN21159e03': {       'dev_macs': [       '0:24:45:fd:b8:dd',
                                                            '0:24:45:fd:b8:de'],
                                        'ip_address': None,
                                        'name': '1@1/2/6',
                                        'serial': 'ADTN21159e03'},
                'ADTN21159e06': {       'dev_macs': [       '0:24:45:fd:b9:a',
                                                            '0:24:45:fd:b9:b'],
                                        'ip_address': None,
                                        'name': '7@1/1/1',
                                        'serial': 'ADTN21159e06'},
                'ADTN21159e07': {       'dev_macs': [       '0:24:45:fd:b9:19',
                                                            '0:24:45:fd:b9:1a'],
                                        'ip_address': None,
                                        'name': '3@1/1/8',
                                        'serial': 'ADTN21159e07'},
                'ADTN21159f9b': {       'dev_macs': [       '0:24:45:fd:d0:c5',
                                                            '0:24:45:fd:d0:c6'],
                                        'ip_address': None,
                                        'name': '7@1/1/3',
                                        'serial': 'ADTN21159f9b'},
                'ADTN2115a0c7': {       'dev_macs': [       '0:24:45:fd:e2:59',
                                                            '0:24:45:fd:e2:5a'],
                                        'ip_address': None,
                                        'name': '2@1/2/3',
                                        'serial': 'ADTN2115a0c7'},
                'ADTN2115a0cf': {       'dev_macs': [       '0:24:45:fd:e2:d1',
                                                            '0:24:45:fd:e2:d2'],
                                        'ip_address': None,
                                        'name': '5@1/2/4',
                                        'serial': 'ADTN2115a0cf'},
                'ADTN2115a11a': {       'dev_macs': [       '0:24:45:fd:e7:36',
                                                            '0:24:45:fd:e7:37'],
                                        'ip_address': None,
                                        'name': '9@1/1/3',
                                        'serial': 'ADTN2115a11a'},
                'ADTN2115a11c': {       'dev_macs': [       '0:24:45:fd:e7:54',
                                                            '0:24:45:fd:e7:55'],
                                        'ip_address': None,
                                        'name': '7@1/1/8',
                                        'serial': 'ADTN2115a11c'},
                'ADTN2115a152': {       'dev_macs': [       '0:24:45:fd:ea:7e',
                                                            '0:24:45:fd:ea:7f'],
                                        'ip_address': None,
                                        'name': '13@1/3/1',
                                        'serial': 'ADTN2115a152'},
                'ADTN2115a196': {       'dev_macs': [       '0:24:45:fd:ee:7a',
                                                            '0:24:45:fd:ee:7b'],
                                        'ip_address': None,
                                        'name': '7@1/2/7',
                                        'serial': 'ADTN2115a196'},
                'ADTN2115a19f': {       'dev_macs': [       '0:24:45:fd:ef:1',
                                                            '0:24:45:fd:ef:2'],
                                        'ip_address': None,
                                        'name': '1@1/2/7',
                                        'serial': 'ADTN2115a19f'},
                'ADTN2115a1a8': {       'dev_macs': [       '0:24:45:fd:ef:88',
                                                            '0:24:45:fd:ef:89'],
                                        'ip_address': None,
                                        'name': '1@1/1/8',
                                        'serial': 'ADTN2115a1a8'},
                'ADTN2115a1d2': {       'dev_macs': [       '0:24:45:fd:f1:fe',
                                                            '0:24:45:fd:f1:ff'],
                                        'ip_address': None,
                                        'name': '1@1/3/8',
                                        'serial': 'ADTN2115a1d2'},
                'ADTN2115a1e6': {       'dev_macs': ['0:24:45:fd:f3:2b'],
                                        'ip_address': None,
                                        'name': '1@1/1/7',
                                        'serial': 'ADTN2115a1e6'},
                'ADTN2115a1f1': {       'dev_macs': [       '0:24:45:fd:f3:cf',
                                                            '0:24:45:fd:f3:d0'],
                                        'ip_address': None,
                                        'name': '5@1/1/1',
                                        'serial': 'ADTN2115a1f1'},
                'ADTN2115a1f7': {       'dev_macs': [       '0:24:45:fd:f4:29',
                                                            '0:24:45:fd:f4:2a'],
                                        'ip_address': None,
                                        'name': '6@1/2/4',
                                        'serial': 'ADTN2115a1f7'},
                'ADTN2115a1f9': {       'dev_macs': [       '0:24:45:fd:f4:47',
                                                            '0:24:45:fd:f4:48'],
                                        'ip_address': None,
                                        'name': '8@1/2/7',
                                        'serial': 'ADTN2115a1f9'},
                'ADTN2115a205': {       'dev_macs': [       '0:24:45:fd:f4:fb',
                                                            '0:24:45:fd:f4:fc'],
                                        'ip_address': None,
                                        'name': '3@1/2/8',
                                        'serial': 'ADTN2115a205'},
                'ADTN2115a20b': {       'dev_macs': [       '0:24:45:fd:f5:55',
                                                            '0:24:45:fd:f5:56'],
                                        'ip_address': None,
                                        'name': '2@1/1/4',
                                        'serial': 'ADTN2115a20b'},
                'ADTN2115a216': {       'dev_macs': [       '0:24:45:fd:f5:fa',
                                                            '0:24:45:fd:f5:fb'],
                                        'ip_address': None,
                                        'name': '3@1/1/4',
                                        'serial': 'ADTN2115a216'},
                'ADTN2115a227': {       'dev_macs': [       '0:24:45:fd:f6:f9',
                                                            '0:24:45:fd:f6:fa'],
                                        'ip_address': None,
                                        'name': '1@1/2/8',
                                        'serial': 'ADTN2115a227'},
                'ADTN2115a244': {       'dev_macs': [       '0:24:45:fd:f8:ac',
                                                            '0:24:45:fd:f8:ad'],
                                        'ip_address': None,
                                        'name': '3@1/2/1',
                                        'serial': 'ADTN2115a244'},
                'ADTN2115a257': {       'dev_macs': [       '0:24:45:fd:f9:c9',
                                                            '0:24:45:fd:f9:ca'],
                                        'ip_address': None,
                                        'name': '1@1/3/1',
                                        'serial': 'ADTN2115a257'},
                'ADTN2115a25a': {       'dev_macs': [       '0:24:45:fd:f9:f6',
                                                            '0:24:45:fd:f9:f7'],
                                        'ip_address': None,
                                        'name': '3@1/1/6',
                                        'serial': 'ADTN2115a25a'},
                'ADTN2115a275': {       'dev_macs': [       '0:24:45:fd:fb:8b',
                                                            '0:24:45:fd:fb:8c'],
                                        'ip_address': None,
                                        'name': '4@1/2/5',
                                        'serial': 'ADTN2115a275'},
                'ADTN2115a299': {       'dev_macs': [       '0:24:45:fd:fd:a7',
                                                            '0:24:45:fd:fd:a8'],
                                        'ip_address': None,
                                        'name': '6@1/1/7',
                                        'serial': 'ADTN2115a299'},
                'ADTN2115a2a2': {       'dev_macs': [       '0:24:45:fd:fe:2e',
                                                            '0:24:45:fd:fe:2f'],
                                        'ip_address': None,
                                        'name': '1@1/2/4',
                                        'serial': 'ADTN2115a2a2'},
                'ADTN2115a2b0': {       'dev_macs': [       '0:24:45:fd:ff:0',
                                                            '0:24:45:fd:ff:1'],
                                        'ip_address': None,
                                        'name': '2@1/1/6',
                                        'serial': 'ADTN2115a2b0'},
                'ADTN21160144': {       'dev_macs': [       'ac:13:9c:9:83:19',
                                                            'ac:13:9c:9:83:1a'],
                                        'ip_address': None,
                                        'name': '1@1/3/9',
                                        'serial': 'ADTN21160144'},
                'ADTN21160191': {       'dev_macs': [       'ac:13:9c:9:87:9c',
                                                            'ac:13:9c:9:87:9d'],
                                        'ip_address': None,
                                        'name': '1@1/1/16',
                                        'serial': 'ADTN21160191'},
                'ADTN211602c5': {       'dev_macs': [       'ac:13:9c:9:99:a8',
                                                            'ac:13:9c:9:99:a9'],
                                        'ip_address': None,
                                        'name': '3@1/3/12',
                                        'serial': 'ADTN211602c5'},
                'ADTN21160445': {       'dev_macs': [       'ac:13:9c:9:b0:28',
                                                            'ac:13:9c:9:b0:29'],
                                        'ip_address': None,
                                        'name': '1@1/3/12',
                                        'serial': 'ADTN21160445'},
                'ADTN21160465': {       'dev_macs': [       'ac:13:9c:9:b2:8',
                                                            'ac:13:9c:9:b2:9'],
                                        'ip_address': None,
                                        'name': '1@1/3/11',
                                        'serial': 'ADTN21160465'},
                'ADTN21160655': {       'dev_macs': [       'ac:13:9c:9:cf:18',
                                                            'ac:13:9c:9:cf:19'],
                                        'ip_address': None,
                                        'name': '1@1/1/13',
                                        'serial': 'ADTN21160655'},
                'ADTN21160923': {       'dev_macs': [       'ac:13:9c:9:f9:2a',
                                                            'ac:13:9c:9:f9:2b'],
                                        'ip_address': None,
                                        'name': '2@1/3/10',
                                        'serial': 'ADTN21160923'},
                'ADTN21160926': {       'dev_macs': [       'ac:13:9c:9:f9:57',
                                                            'ac:13:9c:9:f9:58'],
                                        'ip_address': None,
                                        'name': '1@1/3/10',
                                        'serial': 'ADTN21160926'},
                'ADTN21160928': {       'dev_macs': [       'ac:13:9c:9:f9:75',
                                                            'ac:13:9c:9:f9:76'],
                                        'ip_address': None,
                                        'name': '1@1/1/12',
                                        'serial': 'ADTN21160928'},
                'ADTN21160989': {       'dev_macs': [       'ac:13:9c:9:ff:24',
                                                            'ac:13:9c:9:ff:25'],
                                        'ip_address': None,
                                        'name': '3@1/3/11',
                                        'serial': 'ADTN21160989'},
                'ADTN21160bc0': {       'dev_macs': [       'ac:13:9c:a:20:5d',
                                                            'ac:13:9c:a:20:5e'],
                                        'ip_address': None,
                                        'name': '2@1/3/11',
                                        'serial': 'ADTN21160bc0'},
                'ADTN21539ae3': {       'dev_macs': ['24:f5:a2:9:2d:5a'],
                                        'ip_address': None,
                                        'name': '9@1/1/5',
                                        'serial': 'ADTN21539ae3'},
                'ADTN21539ae6': {       'dev_macs': ['cc:40:d0:76:32:ba'],
                                        'ip_address': None,
                                        'name': '10@1/1/4',
                                        'serial': 'ADTN21539ae6'},
                'ADTN21539aed': {       'dev_macs': ['c0:36:53:e:1:e1'],
                                        'ip_address': None,
                                        'name': '8@1/1/6',
                                        'serial': 'ADTN21539aed'},
                'ADTN21539af1': {       'dev_macs': [       '94:18:65:66:96:65',
                                                            'd4:be:d9:3:2c:dd'],
                                        'ip_address': None,
                                        'name': '15@1/3/3',
                                        'serial': 'ADTN21539af1'},
                'ADTN21539b05': {       'dev_macs': ['c0:ff:d4:a4:ce:5c'],
                                        'ip_address': None,
                                        'name': '6@1/2/6',
                                        'serial': 'ADTN21539b05'},
                'ADTN21539b22': {       'dev_macs': ['9c:c9:eb:54:cf:46'],
                                        'ip_address': None,
                                        'name': '9@1/1/4',
                                        'serial': 'ADTN21539b22'},
                'ADTN21539b8d': {       'dev_macs': [       '68:ff:7b:34:7d:b',
                                                            'a0:ce:c8:eb:6a:4b',
                                                            'd4:be:d9:16:25:74'],
                                        'ip_address': None,
                                        'name': '8@1/1/7',
                                        'serial': 'ADTN21539b8d'},
                'ADTN215424cd': {       'dev_macs': ['48:22:54:56:da:8c'],
                                        'ip_address': None,
                                        'name': '8@1/3/2',
                                        'serial': 'ADTN215424cd'},
                'ADTN215424cf': {       'dev_macs': ['68:4a:76:d5:75:1'],
                                        'ip_address': None,
                                        'name': '2@1/3/3',
                                        'serial': 'ADTN215424cf'},
                'ADTN215424ed': {       'dev_macs': ['48:22:54:7a:e9:1c'],
                                        'ip_address': None,
                                        'name': '5@1/3/4',
                                        'serial': 'ADTN215424ed'},
                'ADTN215424f6': {       'dev_macs': ['78:d2:94:f:11:7f'],
                                        'ip_address': None,
                                        'name': '14@1/3/4',
                                        'serial': 'ADTN215424f6'},
                'ADTN2154250a': {       'dev_macs': [       '24:29:fe:6a:9:b9',
                                                            '2c:4d:54:e7:c4:70',
                                                            '36:84:db:7e:ff:d8',
                                                            '3a:99:95:da:5e:34',
                                                            '74:24:9f:2:77:da',
                                                            'a6:2e:eb:a4:15:42',
                                                            'c0:33:5e:62:92:85',
                                                            'd8:c0:a6:b8:2a:7d',
                                                            'de:a5:76:12:77:7e'],
                                        'ip_address': None,
                                        'name': '3@1/3/2',
                                        'serial': 'ADTN2154250a'},
                'ADTN21542534': {       'dev_macs': ['c4:41:1e:c7:f4:1a'],
                                        'ip_address': None,
                                        'name': '4@1/3/2',
                                        'serial': 'ADTN21542534'},
                'ADTN21542537': {       'dev_macs': ['34:98:b5:6d:6d:81'],
                                        'ip_address': None,
                                        'name': '3@1/3/3',
                                        'serial': 'ADTN21542537'},
                'ADTN2154253a': {       'dev_macs': ['d8:6c:63:d2:c7:38'],
                                        'ip_address': None,
                                        'name': '3@1/3/8',
                                        'serial': 'ADTN2154253a'},
                'ADTN2154253c': {       'dev_macs': ['8:55:31:57:79:d1'],
                                        'ip_address': None,
                                        'name': '2@1/3/4',
                                        'serial': 'ADTN2154253c'},
                'ADTN21542543': {       'dev_macs': ['1c:f2:9a:b2:51:c6'],
                                        'ip_address': None,
                                        'name': '5@1/3/3',
                                        'serial': 'ADTN21542543'},
                'ADTN2154487f': {       'dev_macs': [       'e8:9f:80:a5:3f:93',
                                                            'f0:1f:af:2b:14:7a'],
                                        'ip_address': None,
                                        'name': '8@1/2/3',
                                        'serial': 'ADTN2154487f'},
                'ADTN21544892': {       'dev_macs': [       '48:4d:7e:f8:cf:ee',
                                                            '70:85:c2:78:df:96'],
                                        'ip_address': None,
                                        'name': '12@1/1/3',
                                        'serial': 'ADTN21544892'},
                'ADTN215448a5': {       'dev_macs': ['78:9a:18:3e:33:1f'],
                                        'ip_address': None,
                                        'name': '12@1/3/4',
                                        'serial': 'ADTN215448a5'},
                'ADTN215448aa': {       'dev_macs': ['8:bf:b8:50:70:d0'],
                                        'ip_address': None,
                                        'name': '8@1/3/3',
                                        'serial': 'ADTN215448aa'},
                'ADTN2154493d': {       'dev_macs': [       'd8:ec:5e:17:7:fe',
                                                            'e4:c3:2a:d4:c4:e3'],
                                        'ip_address': None,
                                        'name': '13@1/1/4',
                                        'serial': 'ADTN2154493d'},
                'ADTN21544d1f': {       'dev_macs': ['8:36:c9:ee:38:3c'],
                                        'ip_address': None,
                                        'name': '14@1/2/7',
                                        'serial': 'ADTN21544d1f'},
                'ADTN21544de7': {       'dev_macs': ['48:22:54:56:d8:b4'],
                                        'ip_address': None,
                                        'name': '10@1/1/1',
                                        'serial': 'ADTN21544de7'},
                'ADTN21544f05': {       'dev_macs': ['80:cc:9c:18:7b:4a'],
                                        'ip_address': None,
                                        'name': '11@1/1/7',
                                        'serial': 'ADTN21544f05'},
                'ADTN22072e11': {       'dev_macs': ['84:d8:1b:7b:36:29'],
                                        'ip_address': None,
                                        'name': '16@1/3/4',
                                        'serial': 'ADTN22072e11'},
                'ADTN22072e14': {       'dev_macs': ['2c:c8:1b:d7:73:3c'],
                                        'ip_address': None,
                                        'name': '2@1/1/5',
                                        'serial': 'ADTN22072e14'},
                'ADTN22072e78': {       'dev_macs': ['50:91:e3:42:fb:d4'],
                                        'ip_address': None,
                                        'name': '18@1/3/4',
                                        'serial': 'ADTN22072e78'},
                'ADTN22193b01': {       'dev_macs': ['24:f5:a2:b:30:5e'],
                                        'ip_address': None,
                                        'name': '4@1/2/8',
                                        'serial': 'ADTN22193b01'},
                'ADTN22201a1b': {       'dev_macs': ['50:c7:bf:a3:c3:a1'],
                                        'ip_address': None,
                                        'name': '9@1/2/4',
                                        'serial': 'ADTN22201a1b'},
                'ADTN22201a3a': {       'dev_macs': ['2c:c8:1b:b9:28:59'],
                                        'ip_address': None,
                                        'name': '16@1/3/3',
                                        'serial': 'ADTN22201a3a'},
                'ADTN22451d29': {       'dev_macs': ['e4:38:83:81:1a:6d'],
                                        'ip_address': None,
                                        'name': '9@1/3/4',
                                        'serial': 'ADTN22451d29'},
                'ADTN2245353f': {       'dev_macs': ['48:22:54:7a:e3:38'],
                                        'ip_address': None,
                                        'name': '7@1/3/2',
                                        'serial': 'ADTN2245353f'},
                'ADTN22453544': {       'dev_macs': ['c4:41:1e:d1:28:fc'],
                                        'ip_address': None,
                                        'name': '8@1/3/4',
                                        'serial': 'ADTN22453544'},
                'ADTN22453c52': {       'dev_macs': ['48:22:54:7d:3b:a9'],
                                        'ip_address': None,
                                        'name': '5@1/3/2',
                                        'serial': 'ADTN22453c52'},
                'ADTN22453dbb': {       'dev_macs': ['a0:4:60:35:f0:9'],
                                        'ip_address': None,
                                        'name': '12@1/2/7',
                                        'serial': 'ADTN22453dbb'},
                'ADTN2245400c': {       'dev_macs': ['5c:62:8b:ef:6e:e8'],
                                        'ip_address': None,
                                        'name': '13@1/1/7',
                                        'serial': 'ADTN2245400c'},
                'ADTN22454bfe': {       'dev_macs': ['30:23:3:67:bc:fe'],
                                        'ip_address': None,
                                        'name': '7@1/3/3',
                                        'serial': 'ADTN22454bfe'},
                'ADTN22454c00': {       'dev_macs': ['8:55:31:14:5:87'],
                                        'ip_address': None,
                                        'name': '1@1/3/3',
                                        'serial': 'ADTN22454c00'},
                'ADTN22454c20': {       'dev_macs': ['bc:a5:11:ab:4d:90'],
                                        'ip_address': None,
                                        'name': '3@1/3/4',
                                        'serial': 'ADTN22454c20'},
                'ADTN22454c28': {       'dev_macs': ['48:22:54:7c:d4:1'],
                                        'ip_address': None,
                                        'name': '10@1/3/2',
                                        'serial': 'ADTN22454c28'},
                'ADTN22454e2a': {       'dev_macs': ['5c:62:8b:ef:68:b4'],
                                        'ip_address': None,
                                        'name': '11@1/1/4',
                                        'serial': 'ADTN22454e2a'},
                'ADTN22454eb2': {       'dev_macs': ['80:69:1a:b:39:3'],
                                        'ip_address': None,
                                        'name': '4@1/3/4',
                                        'serial': 'ADTN22454eb2'},
                'ADTN224550c9': {       'dev_macs': [       'a:3c:7:65:9e:13',
                                                            '14:cb:19:da:9e:19',
                                                            '20:1f:3b:82:a5:76',
                                                            '20:1f:3b:8e:85:b7',
                                                            '20:1f:3b:94:ab:9',
                                                            '20:1f:3b:e3:dd:74',
                                                            '28:80:88:2c:5a:67',
                                                            '54:49:df:3a:79:dc',
                                                            '86:f3:af:16:6b:9c',
                                                            '9e:58:d7:60:bc:c4',
                                                            'a2:8d:45:2e:d9:57',
                                                            'ac:ae:19:d6:d2:b6',
                                                            'b6:19:8:9b:8e:b7',
                                                            'f2:c6:d2:4e:86:1b'],
                                        'ip_address': None,
                                        'name': '1@1/3/4',
                                        'serial': 'ADTN224550c9'},
                'ADTN2245510e': {       'dev_macs': ['5c:62:8b:ef:78:30'],
                                        'ip_address': None,
                                        'name': '10@1/3/3',
                                        'serial': 'ADTN2245510e'},
                'ADTN22455436': {       'dev_macs': ['48:22:54:32:f3:8d'],
                                        'ip_address': None,
                                        'name': '11@1/3/3',
                                        'serial': 'ADTN22455436'},
                'ADTN22455474': {       'dev_macs': ['64:97:14:c8:5b:a1'],
                                        'ip_address': None,
                                        'name': '9@1/3/3',
                                        'serial': 'ADTN22455474'},
                'ADTN22455487': {       'dev_macs': ['b0:95:75:14:d6:e2'],
                                        'ip_address': None,
                                        'name': '6@1/3/4',
                                        'serial': 'ADTN22455487'}
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'Adtran',
                                'model': 'TA5000',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '100001/100009',
                                                                                         'in_octets': '19800725909',
                                                                                         'in_ucast_pkts': '6856026845',
                                                                                         'links': [       {       'in_octets': '1365474021',
                                                                                                                  'in_ucast_pkts': '6080035',
                                                                                                                  'out_octets': '1779802548',
                                                                                                                  'out_ucast_pkts': '3261292',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZDgzSURpbnRm'},
                                                                                                          {       'in_octets': '3972438052',
                                                                                                                  'in_ucast_pkts': '836682911',
                                                                                                                  'out_octets': '3246810263',
                                                                                                                  'out_ucast_pkts': '375179324',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3YjY3SURpbnRm'},
                                                                                                          {       'in_octets': '2824564808',
                                                                                                                  'in_ucast_pkts': '88973409',
                                                                                                                  'out_octets': '3294917693',
                                                                                                                  'out_ucast_pkts': '38494507',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2FmSURpbnRm'},
                                                                                                          {       'in_octets': '2054237198',
                                                                                                                  'in_ucast_pkts': '110764207',
                                                                                                                  'out_octets': '1903936003',
                                                                                                                  'out_ucast_pkts': '32784751',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMWYxSURpbnRm'},
                                                                                                          {       'in_octets': '3923047497',
                                                                                                                  'in_ucast_pkts': '2705921909',
                                                                                                                  'out_octets': '3386635748',
                                                                                                                  'out_ucast_pkts': '1408055172',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OTEySURpbnRm'},
                                                                                                          {       'in_octets': '780766106',
                                                                                                                  'in_ucast_pkts': '1647971791',
                                                                                                                  'out_octets': '3356820565',
                                                                                                                  'out_ucast_pkts': '405340453',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZTA2SURpbnRm'},
                                                                                                          {       'in_octets': '2826128251',
                                                                                                                  'in_ucast_pkts': '1454744477',
                                                                                                                  'out_octets': '2229833624',
                                                                                                                  'out_ucast_pkts': '560401066',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3MDU5SURpbnRm'},
                                                                                                          {       'in_octets': '2054069976',
                                                                                                                  'in_ucast_pkts': '4888106',
                                                                                                                  'out_octets': '3131383287',
                                                                                                                  'out_ucast_pkts': '8937322',
                                                                                                                  'poller_hash': 'QURUTjIxNTQ0ZGU3SURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/1/1',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '22330139731',
                                                                                         'out_ucast_pkts': '2832453887',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE=',
                                                                                         'pons': [       {       'id': '100001',
                                                                                                                 'links': [       {       'connected_time': '105009',
                                                                                                                                          'fiber_length': 878,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZDgz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '4557848',
                                                                                                                                          'fiber_length': 1193,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3YjY3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '431208',
                                                                                                                                          'fiber_length': 1067,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Fm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '635330',
                                                                                                                                          'fiber_length': 994,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMWYx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '10366092',
                                                                                                                                          'fiber_length': 1015,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OTEy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '7607102',
                                                                                                                                          'fiber_length': 1409,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZTA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '2758560',
                                                                                                                                          'fiber_length': 1025,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3MDU5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '9076405',
                                                                                                                                          'fiber_length': 988,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQ0ZGU3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'},
                                                                                                         {       'id': '100009',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDF4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '100010/100002',
                                                                                         'in_octets': '16155500834',
                                                                                         'in_ucast_pkts': '2958873844',
                                                                                         'links': [       {       'in_octets': '256147846',
                                                                                                                  'in_ucast_pkts': '2212126',
                                                                                                                  'out_octets': '2117238148',
                                                                                                                  'out_ucast_pkts': '4584159',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MGM4SURpbnRm'},
                                                                                                          {       'in_octets': '4207496292',
                                                                                                                  'in_ucast_pkts': '1365341085',
                                                                                                                  'out_octets': '3610621334',
                                                                                                                  'out_ucast_pkts': '649104525',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OGVmSURpbnRm'},
                                                                                                          {       'in_octets': '157559742',
                                                                                                                  'in_ucast_pkts': '818974',
                                                                                                                  'out_octets': '2087609296',
                                                                                                                  'out_ucast_pkts': '1717146',
                                                                                                                  'poller_hash': 'QURUTjIxMTAzZjkwSURpbnRm'},
                                                                                                          {       'in_octets': '3939610357',
                                                                                                                  'in_ucast_pkts': '21750385',
                                                                                                                  'out_octets': '748712539',
                                                                                                                  'out_ucast_pkts': '3004137',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZTU0SURpbnRm'},
                                                                                                          {       'in_octets': '46801652',
                                                                                                                  'in_ucast_pkts': '312280',
                                                                                                                  'out_octets': '3537751456',
                                                                                                                  'out_ucast_pkts': '2449907',
                                                                                                                  'poller_hash': 'QURUTjIxMDljNDM1SURpbnRm'},
                                                                                                          {       'in_octets': '1713366898',
                                                                                                                  'in_ucast_pkts': '722799456',
                                                                                                                  'out_octets': '4223549512',
                                                                                                                  'out_ucast_pkts': '162423516',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OTFjSURpbnRm'},
                                                                                                          {       'in_octets': '3135833777',
                                                                                                                  'in_ucast_pkts': '107051190',
                                                                                                                  'out_octets': '1962905427',
                                                                                                                  'out_ucast_pkts': '35256619',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3MzkxSURpbnRm'},
                                                                                                          {       'in_octets': '291078244',
                                                                                                                  'in_ucast_pkts': '612880385',
                                                                                                                  'out_octets': '2375516922',
                                                                                                                  'out_ucast_pkts': '123746376',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OTAxSURpbnRm'},
                                                                                                          {       'in_octets': '2345744495',
                                                                                                                  'in_ucast_pkts': '125539151',
                                                                                                                  'out_octets': '2722444528',
                                                                                                                  'out_ucast_pkts': '35637476',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OTE1SURpbnRm'},
                                                                                                          {       'in_octets': '61861531',
                                                                                                                  'in_ucast_pkts': '168812',
                                                                                                                  'out_octets': '30767518',
                                                                                                                  'out_ucast_pkts': '210793',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2N2Q1SURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/1/2',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '23417116680',
                                                                                         'out_ucast_pkts': '1018134654',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM=',
                                                                                         'pons': [       {       'id': '100010',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjN4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '100002',
                                                                                                                 'links': [       {       'connected_time': '6383350',
                                                                                                                                          'fiber_length': 630,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MGM4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '2228517',
                                                                                                                                          'fiber_length': 632,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OGVm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '145884',
                                                                                                                                          'fiber_length': 691,
                                                                                                                                          'poller_hash': 'QURUTjIxMTAzZjkw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '140509',
                                                                                                                                          'fiber_length': 817,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZTU0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '1553223',
                                                                                                                                          'fiber_length': 621,
                                                                                                                                          'poller_hash': 'QURUTjIxMDljNDM1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '7762038',
                                                                                                                                          'fiber_length': 888,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OTFj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '2079401',
                                                                                                                                          'fiber_length': 900,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3Mzkx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '1638645',
                                                                                                                                          'fiber_length': 696,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OTAx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '277337',
                                                                                                                                          'fiber_length': 913,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OTE1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '1903739',
                                                                                                                                          'fiber_length': 767,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2N2Q1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '100011/100003',
                                                                                         'in_octets': '15689088979',
                                                                                         'in_ucast_pkts': '3852901574',
                                                                                         'links': [       {       'in_octets': '3166762223',
                                                                                                                  'in_ucast_pkts': '206639996',
                                                                                                                  'out_octets': '399809239',
                                                                                                                  'out_ucast_pkts': '36804635',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2N2MzSURpbnRm'},
                                                                                                          {       'in_octets': '580835182',
                                                                                                                  'in_ucast_pkts': '702733381',
                                                                                                                  'out_octets': '2890036044',
                                                                                                                  'out_ucast_pkts': '239246106',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5YzkxSURpbnRm'},
                                                                                                          {       'in_octets': '128193673',
                                                                                                                  'in_ucast_pkts': '589659',
                                                                                                                  'out_octets': '4181143875',
                                                                                                                  'out_ucast_pkts': '3201682',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MDZjSURpbnRm'},
                                                                                                          {       'in_octets': '130644645',
                                                                                                                  'in_ucast_pkts': '670048',
                                                                                                                  'out_octets': '74855113',
                                                                                                                  'out_ucast_pkts': '3332451',
                                                                                                                  'poller_hash': 'QURUTjIxMTAzZmZiSURpbnRm'},
                                                                                                          {       'in_octets': '72060641',
                                                                                                                  'in_ucast_pkts': '126056593',
                                                                                                                  'out_octets': '322456680',
                                                                                                                  'out_ucast_pkts': '34401096',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZjliSURpbnRm'},
                                                                                                          {       'in_octets': '2326691935',
                                                                                                                  'in_ucast_pkts': '130843210',
                                                                                                                  'out_octets': '2615065054',
                                                                                                                  'out_ucast_pkts': '24228302',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZDJmSURpbnRm'},
                                                                                                          {       'in_octets': '1331440933',
                                                                                                                  'in_ucast_pkts': '598353108',
                                                                                                                  'out_octets': '2118771443',
                                                                                                                  'out_ucast_pkts': '208655854',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMTFhSURpbnRm'},
                                                                                                          {       'in_octets': '4008547500',
                                                                                                                  'in_ucast_pkts': '401894837',
                                                                                                                  'out_octets': '1238718410',
                                                                                                                  'out_ucast_pkts': '179811805',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2N2VjSURpbnRm'},
                                                                                                          {       'in_octets': '3563677104',
                                                                                                                  'in_ucast_pkts': '1171094177',
                                                                                                                  'out_octets': '2968553162',
                                                                                                                  'out_ucast_pkts': '536731325',
                                                                                                                  'poller_hash': 'QURUTjIxMTI2ZTY4SURpbnRm'},
                                                                                                          {       'in_octets': '52840336',
                                                                                                                  'in_ucast_pkts': '399280',
                                                                                                                  'out_octets': '3705487754',
                                                                                                                  'out_ucast_pkts': '2642769',
                                                                                                                  'poller_hash': 'QURUTjIxNTQ0ODkySURpbnRm'},
                                                                                                          {       'in_octets': '327394807',
                                                                                                                  'in_ucast_pkts': '513627285',
                                                                                                                  'out_octets': '2486550545',
                                                                                                                  'out_ucast_pkts': '102744755',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5YzkzSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/1/3',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '23001447319',
                                                                                         'out_ucast_pkts': '1371800780',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc=',
                                                                                         'pons': [       {       'id': '100011',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDd4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '100003',
                                                                                                                 'links': [       {       'connected_time': '1469650',
                                                                                                                                          'fiber_length': 959,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2N2Mz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '2165757',
                                                                                                                                          'fiber_length': 966,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Yzkx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '554757',
                                                                                                                                          'fiber_length': 971,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MDZj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '14648421',
                                                                                                                                          'fiber_length': 804,
                                                                                                                                          'poller_hash': 'QURUTjIxMTAzZmZi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '505541',
                                                                                                                                          'fiber_length': 811,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Zjli',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '667581',
                                                                                                                                          'fiber_length': 892,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZDJm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '2340973',
                                                                                                                                          'fiber_length': 811,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMTFh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '1705449',
                                                                                                                                          'fiber_length': 616,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2N2Vj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '1584825',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI2ZTY4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '8075325',
                                                                                                                                          'fiber_length': 791,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQ0ODky',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '7596700',
                                                                                                                                          'fiber_length': 1140,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Yzkz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '100012/100004',
                                                                                         'in_octets': '23042619839',
                                                                                         'in_ucast_pkts': '3617276080',
                                                                                         'links': [       {       'in_octets': '621402296',
                                                                                                                  'in_ucast_pkts': '1565453108',
                                                                                                                  'out_octets': '545829451',
                                                                                                                  'out_ucast_pkts': '361951609',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwOTI4SURpbnRm'},
                                                                                                          {       'in_octets': '398230200',
                                                                                                                  'in_ucast_pkts': '4249778',
                                                                                                                  'out_octets': '591052864',
                                                                                                                  'out_ucast_pkts': '12257535',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MDUwSURpbnRm'},
                                                                                                          {       'in_octets': '4191762723',
                                                                                                                  'in_ucast_pkts': '414428979',
                                                                                                                  'out_octets': '2691430940',
                                                                                                                  'out_ucast_pkts': '145024782',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMjBiSURpbnRm'},
                                                                                                          {       'in_octets': '2937786152',
                                                                                                                  'in_ucast_pkts': '567833095',
                                                                                                                  'out_octets': '2241090953',
                                                                                                                  'out_ucast_pkts': '186269014',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMjE2SURpbnRm'},
                                                                                                          {       'in_octets': '1973118173',
                                                                                                                  'in_ucast_pkts': '381933082',
                                                                                                                  'out_octets': '3269906571',
                                                                                                                  'out_ucast_pkts': '106721165',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZGYzSURpbnRm'},
                                                                                                          {       'in_octets': '3774186780',
                                                                                                                  'in_ucast_pkts': '2686933',
                                                                                                                  'out_octets': '203278238',
                                                                                                                  'out_ucast_pkts': '966178',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZDRmSURpbnRm'},
                                                                                                          {       'in_octets': '3693400942',
                                                                                                                  'in_ucast_pkts': '63025355',
                                                                                                                  'out_octets': '3511548089',
                                                                                                                  'out_ucast_pkts': '32342991',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZTAySURpbnRm'},
                                                                                                          {       'in_octets': '2006536987',
                                                                                                                  'in_ucast_pkts': '345883603',
                                                                                                                  'out_octets': '3865304874',
                                                                                                                  'out_ucast_pkts': '117464207',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2RmSURpbnRm'},
                                                                                                          {       'in_octets': '1538566564',
                                                                                                                  'in_ucast_pkts': '40277733',
                                                                                                                  'out_octets': '2279570144',
                                                                                                                  'out_ucast_pkts': '20462087',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODVlSURpbnRm'},
                                                                                                          {       'in_octets': '454899627',
                                                                                                                  'in_ucast_pkts': '1873751',
                                                                                                                  'out_octets': '1309757476',
                                                                                                                  'out_ucast_pkts': '4129107',
                                                                                                                  'poller_hash': 'QURUTjIxNTM5YjIySURpbnRm'},
                                                                                                          {       'in_octets': '532982149',
                                                                                                                  'in_ucast_pkts': '905958',
                                                                                                                  'out_octets': '2752414599',
                                                                                                                  'out_ucast_pkts': '2370937',
                                                                                                                  'poller_hash': 'QURUTjIxNTM5YWU2SURpbnRm'},
                                                                                                          {       'in_octets': '722220779',
                                                                                                                  'in_ucast_pkts': '2644222',
                                                                                                                  'out_octets': '4220365314',
                                                                                                                  'out_ucast_pkts': '10294776',
                                                                                                                  'poller_hash': 'QURUTjIyNDU0ZTJhSURpbnRm'},
                                                                                                          {       'in_octets': '90068961',
                                                                                                                  'in_ucast_pkts': '624619',
                                                                                                                  'out_octets': '3206162763',
                                                                                                                  'out_ucast_pkts': '2261666',
                                                                                                                  'poller_hash': 'QURUTjIxNTQ0OTNkSURpbnRm'},
                                                                                                          {       'in_octets': '107457506',
                                                                                                                  'in_ucast_pkts': '225455864',
                                                                                                                  'out_octets': '3914015559',
                                                                                                                  'out_ucast_pkts': '39773717',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2N2E2SURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/1/4',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '34601727835',
                                                                                         'out_ucast_pkts': '1042289771',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE=',
                                                                                         'pons': [       {       'id': '100012',
                                                                                                                 'links': [       {       'connected_time': '6742303',
                                                                                                                                          'fiber_length': 451,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwOTI4',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.4,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.8}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzF4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '100004',
                                                                                                                 'links': [       {       'connected_time': '2318416',
                                                                                                                                          'fiber_length': 553,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MDUw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '2340225',
                                                                                                                                          'fiber_length': 884,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMjBi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '1695487',
                                                                                                                                          'fiber_length': 809,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMjE2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '367302',
                                                                                                                                          'fiber_length': 818,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZGYz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '18233',
                                                                                                                                          'fiber_length': 690,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZDRm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '669789',
                                                                                                                                          'fiber_length': 824,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZTAy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '702330',
                                                                                                                                          'fiber_length': 879,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Rm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '169779',
                                                                                                                                          'fiber_length': 760,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODVl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '13907947',
                                                                                                                                          'fiber_length': 582,
                                                                                                                                          'poller_hash': 'QURUTjIxNTM5YjIy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '8822604',
                                                                                                                                          'fiber_length': 716,
                                                                                                                                          'poller_hash': 'QURUTjIxNTM5YWU2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '5968090',
                                                                                                                                          'fiber_length': 660,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU0ZTJh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '2492694',
                                                                                                                                          'fiber_length': 496,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQ0OTNk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '9403885',
                                                                                                                                          'fiber_length': 881,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2N2E2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '100013/100005',
                                                                                         'in_octets': '8455782983',
                                                                                         'in_ucast_pkts': '4706844336',
                                                                                         'links': [       {       'in_octets': '2480442531',
                                                                                                                  'in_ucast_pkts': '675666211',
                                                                                                                  'out_octets': '2989714875',
                                                                                                                  'out_ucast_pkts': '315138504',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwNjU1SURpbnRm'},
                                                                                                          {       'in_octets': '6489850',
                                                                                                                  'in_ucast_pkts': '60160',
                                                                                                                  'out_octets': '131699987',
                                                                                                                  'out_ucast_pkts': '100991',
                                                                                                                  'poller_hash': 'QURUTjIyMDcyZTE0SURpbnRm'},
                                                                                                          {       'in_octets': '2885959423',
                                                                                                                  'in_ucast_pkts': '1668540518',
                                                                                                                  'out_octets': '2269858149',
                                                                                                                  'out_ucast_pkts': '423572601',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Yzk3SURpbnRm'},
                                                                                                          {       'in_octets': '1855468952',
                                                                                                                  'in_ucast_pkts': '1988475180',
                                                                                                                  'out_octets': '4254857898',
                                                                                                                  'out_ucast_pkts': '800779083',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2E4SURpbnRm'},
                                                                                                          {       'in_octets': '380342012',
                                                                                                                  'in_ucast_pkts': '137841518',
                                                                                                                  'out_octets': '1799163603',
                                                                                                                  'out_ucast_pkts': '56238547',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OGJiSURpbnRm'},
                                                                                                          {       'in_octets': '548788063',
                                                                                                                  'in_ucast_pkts': '232720259',
                                                                                                                  'out_octets': '2122614807',
                                                                                                                  'out_ucast_pkts': '95323076',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5YzQySURpbnRm'},
                                                                                                          {       'in_octets': '298292152',
                                                                                                                  'in_ucast_pkts': '3540490',
                                                                                                                  'out_octets': '1702269672',
                                                                                                                  'out_ucast_pkts': '6957050',
                                                                                                                  'poller_hash': 'QURUTjIxNTM5YWUzSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/1/5',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '15270178991',
                                                                                         'out_ucast_pkts': '1698109852',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjU=',
                                                                                         'pons': [       {       'id': '100013',
                                                                                                                 'links': [       {       'connected_time': '3869658',
                                                                                                                                          'fiber_length': 1425,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwNjU1',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -13.2,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.6}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjV4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '100005',
                                                                                                                 'links': [       {       'connected_time': '90564',
                                                                                                                                          'fiber_length': 1589,
                                                                                                                                          'poller_hash': 'QURUTjIyMDcyZTE0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '7521056',
                                                                                                                                          'fiber_length': 1103,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Yzk3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '4277922',
                                                                                                                                          'fiber_length': 1734,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2E4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '506707',
                                                                                                                                          'fiber_length': 1474,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OGJi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '485691',
                                                                                                                                          'fiber_length': 975,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5YzQy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '2302105',
                                                                                                                                          'fiber_length': 1438,
                                                                                                                                          'poller_hash': 'QURUTjIxNTM5YWUz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjVncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '100014/100006',
                                                                                         'in_octets': '9927868239',
                                                                                         'in_ucast_pkts': '3908919288',
                                                                                         'links': [       {       'in_octets': '1253987322',
                                                                                                                  'in_ucast_pkts': '214758163',
                                                                                                                  'out_octets': '3638638426',
                                                                                                                  'out_ucast_pkts': '82545855',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMmIwSURpbnRm'},
                                                                                                          {       'in_octets': '3625377716',
                                                                                                                  'in_ucast_pkts': '2061822646',
                                                                                                                  'out_octets': '4038462788',
                                                                                                                  'out_ucast_pkts': '615275911',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMjVhSURpbnRm'},
                                                                                                          {       'in_octets': '1244862535',
                                                                                                                  'in_ucast_pkts': '815976675',
                                                                                                                  'out_octets': '691658195',
                                                                                                                  'out_ucast_pkts': '283320804',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODNlSURpbnRm'},
                                                                                                          {       'in_octets': '184626102',
                                                                                                                  'in_ucast_pkts': '622972',
                                                                                                                  'out_octets': '1817183502',
                                                                                                                  'out_ucast_pkts': '1339609',
                                                                                                                  'poller_hash': 'QURUTjIxMTAzZGI1SURpbnRm'},
                                                                                                          {       'in_octets': '3090718958',
                                                                                                                  'in_ucast_pkts': '809422993',
                                                                                                                  'out_octets': '84560223',
                                                                                                                  'out_ucast_pkts': '230299426',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2IwSURpbnRm'},
                                                                                                          {       'in_octets': '528295606',
                                                                                                                  'in_ucast_pkts': '6315839',
                                                                                                                  'out_octets': '1111087302',
                                                                                                                  'out_ucast_pkts': '12465022',
                                                                                                                  'poller_hash': 'QURUTjIxNTM5YWVkSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/1/6',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '11381590436',
                                                                                         'out_ucast_pkts': '1225246627',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjQ=',
                                                                                         'pons': [       {       'id': '100014',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjR4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '100006',
                                                                                                                 'links': [       {       'connected_time': '793163',
                                                                                                                                          'fiber_length': 625,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMmIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '7056430',
                                                                                                                                          'fiber_length': 830,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMjVh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '3020530',
                                                                                                                                          'fiber_length': 452,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODNl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '2328738',
                                                                                                                                          'fiber_length': 443,
                                                                                                                                          'poller_hash': 'QURUTjIxMTAzZGI1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '4641295',
                                                                                                                                          'fiber_length': 824,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Iw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '3703590',
                                                                                                                                          'fiber_length': 660,
                                                                                                                                          'poller_hash': 'QURUTjIxNTM5YWVk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjRncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '100015/100007',
                                                                                         'in_octets': '18320309515',
                                                                                         'in_ucast_pkts': '6404539322',
                                                                                         'links': [       {       'in_octets': '1992705584',
                                                                                                                  'in_ucast_pkts': '2184956',
                                                                                                                  'out_octets': '997972146',
                                                                                                                  'out_ucast_pkts': '2088301',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMWU2SURpbnRm'},
                                                                                                          {       'in_octets': '864827861',
                                                                                                                  'in_ucast_pkts': '9948485',
                                                                                                                  'out_octets': '95967',
                                                                                                                  'out_ucast_pkts': '26308200',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MThkSURpbnRm'},
                                                                                                          {       'in_octets': '4035301135',
                                                                                                                  'in_ucast_pkts': '2014362689',
                                                                                                                  'out_octets': '105394448',
                                                                                                                  'out_ucast_pkts': '2242896856',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2N2JlSURpbnRm'},
                                                                                                          {       'in_octets': '3767711825',
                                                                                                                  'in_ucast_pkts': '73844044',
                                                                                                                  'out_octets': '2229443589',
                                                                                                                  'out_ucast_pkts': '23299923',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2E1SURpbnRm'},
                                                                                                          {       'in_octets': '3159550225',
                                                                                                                  'in_ucast_pkts': '2453987',
                                                                                                                  'out_octets': '1732191131',
                                                                                                                  'out_ucast_pkts': '1939776',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZGY1SURpbnRm'},
                                                                                                          {       'in_octets': '551895421',
                                                                                                                  'in_ucast_pkts': '2067178325',
                                                                                                                  'out_octets': '1447264497',
                                                                                                                  'out_ucast_pkts': '409139851',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMjk5SURpbnRm'},
                                                                                                          {       'in_octets': '81569127',
                                                                                                                  'in_ucast_pkts': '81408',
                                                                                                                  'out_octets': '7961119',
                                                                                                                  'out_ucast_pkts': '22997',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MDZmSURpbnRm'},
                                                                                                          {       'in_octets': '257667448',
                                                                                                                  'in_ucast_pkts': '1362405',
                                                                                                                  'out_octets': '3138016727',
                                                                                                                  'out_ucast_pkts': '5290782',
                                                                                                                  'poller_hash': 'QURUTjIxNTM5YjhkSURpbnRm'},
                                                                                                          {       'in_octets': '2450466463',
                                                                                                                  'in_ucast_pkts': '405874831',
                                                                                                                  'out_octets': '852005174',
                                                                                                                  'out_ucast_pkts': '85926476',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3MDI3SURpbnRm'},
                                                                                                          {       'in_octets': '5877024',
                                                                                                                  'in_ucast_pkts': '28347',
                                                                                                                  'out_octets': '198052390',
                                                                                                                  'out_ucast_pkts': '198241',
                                                                                                                  'poller_hash': 'QURUTjIxNTQ0ZjA1SURpbnRm'},
                                                                                                          {       'in_octets': '623316000',
                                                                                                                  'in_ucast_pkts': '1824154614',
                                                                                                                  'out_octets': '3303560598',
                                                                                                                  'out_ucast_pkts': '368384023',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZDQzSURpbnRm'},
                                                                                                          {       'in_octets': '529421402',
                                                                                                                  'in_ucast_pkts': '3065231',
                                                                                                                  'out_octets': '1862602476',
                                                                                                                  'out_ucast_pkts': '14775423',
                                                                                                                  'poller_hash': 'QURUTjIyNDU0MDBjSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/1/7',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '15874560262',
                                                                                         'out_ucast_pkts': '3180270849',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTM=',
                                                                                         'pons': [       {       'id': '100015',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTN4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '100007',
                                                                                                                 'links': [       {       'connected_time': '12228',
                                                                                                                                          'fiber_length': 244,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMWU2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '77687',
                                                                                                                                          'fiber_length': 643,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MThk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '12978210',
                                                                                                                                          'fiber_length': 720,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2N2Jl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '203979',
                                                                                                                                          'fiber_length': 711,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2E1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '518664',
                                                                                                                                          'fiber_length': 567,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZGY1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '6290095',
                                                                                                                                          'fiber_length': 643,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMjk5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '1040708',
                                                                                                                                          'fiber_length': 379,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MDZm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '5330504',
                                                                                                                                          'fiber_length': 341,
                                                                                                                                          'poller_hash': 'QURUTjIxNTM5Yjhk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '4295985',
                                                                                                                                          'fiber_length': 242,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3MDI3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '91424',
                                                                                                                                          'fiber_length': 343,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQ0ZjA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '7521085',
                                                                                                                                          'fiber_length': 306,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZDQz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '6322786',
                                                                                                                                          'fiber_length': 210,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU0MDBj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTNncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '100016/100008',
                                                                                         'in_octets': '20068391313',
                                                                                         'in_ucast_pkts': '4664059281',
                                                                                         'links': [       {       'in_octets': '1597015257',
                                                                                                                  'in_ucast_pkts': '529149582',
                                                                                                                  'out_octets': '1477217948',
                                                                                                                  'out_ucast_pkts': '209516140',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwMTkxSURpbnRm'},
                                                                                                          {       'in_octets': '2157038865',
                                                                                                                  'in_ucast_pkts': '475182617',
                                                                                                                  'out_octets': '3970395416',
                                                                                                                  'out_ucast_pkts': '109637562',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMWE4SURpbnRm'},
                                                                                                          {       'in_octets': '1139634546',
                                                                                                                  'in_ucast_pkts': '311568848',
                                                                                                                  'out_octets': '338230294',
                                                                                                                  'out_ucast_pkts': '81635873',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5YzcwSURpbnRm'},
                                                                                                          {       'in_octets': '3005281288',
                                                                                                                  'in_ucast_pkts': '48553455',
                                                                                                                  'out_octets': '3652291087',
                                                                                                                  'out_ucast_pkts': '23199092',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZTA3SURpbnRm'},
                                                                                                          {       'in_octets': '4113745558',
                                                                                                                  'in_ucast_pkts': '1831885606',
                                                                                                                  'out_octets': '3890110970',
                                                                                                                  'out_ucast_pkts': '500646489',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZDQ0SURpbnRm'},
                                                                                                          {       'in_octets': '561629700',
                                                                                                                  'in_ucast_pkts': '2030627',
                                                                                                                  'out_octets': '1826557394',
                                                                                                                  'out_ucast_pkts': '2089465',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MDc1SURpbnRm'},
                                                                                                          {       'in_octets': '3598739815',
                                                                                                                  'in_ucast_pkts': '89808333',
                                                                                                                  'out_octets': '2645455301',
                                                                                                                  'out_ucast_pkts': '19623524',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMTFjSURpbnRm'},
                                                                                                          {       'in_octets': '1202983052',
                                                                                                                  'in_ucast_pkts': '1033091896',
                                                                                                                  'out_octets': '2391676745',
                                                                                                                  'out_ucast_pkts': '317197343',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODgwSURpbnRm'},
                                                                                                          {       'in_octets': '2692323232',
                                                                                                                  'in_ucast_pkts': '342788317',
                                                                                                                  'out_octets': '1420891536',
                                                                                                                  'out_ucast_pkts': '129911356',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3YjU0SURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/1/8',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '21612826691',
                                                                                         'out_ucast_pkts': '1393456844',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxNjc=',
                                                                                         'pons': [       {       'id': '100016',
                                                                                                                 'links': [       {       'connected_time': '5588145',
                                                                                                                                          'fiber_length': 412,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwMTkx',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -8.9,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.4}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxNjd4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '100008',
                                                                                                                 'links': [       {       'connected_time': '2224925',
                                                                                                                                          'fiber_length': 592,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMWE4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '560705',
                                                                                                                                          'fiber_length': 449,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Yzcw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '190122',
                                                                                                                                          'fiber_length': 745,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZTA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '9572337',
                                                                                                                                          'fiber_length': 737,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZDQ0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '13919439',
                                                                                                                                          'fiber_length': 839,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MDc1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '253043',
                                                                                                                                          'fiber_length': 677,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMTFj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '2615822',
                                                                                                                                          'fiber_length': 466,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODgw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '2301980',
                                                                                                                                          'fiber_length': 549,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3YjU0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxNjdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 31.043625,
                                                           'model': '1187518F1',
                                                           'name': 'COMBO OLT 8P',
                                                           'poller_hash': 'TEJBRFROMjEyOUNEODUzMTE4NzUxOEYx',
                                                           'serial_number': 'LBADTN2129CD853',
                                                           'sw_version': '11.1.5.4.11',
                                                           'temperature': 34.0,
                                                           'uptime': '14648262'},
                                                   {       'id': '2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '200001/200009',
                                                                                         'in_octets': '12408426305',
                                                                                         'in_ucast_pkts': '2103654999',
                                                                                         'links': [       {       'in_octets': '439749553',
                                                                                                                  'in_ucast_pkts': '180444913',
                                                                                                                  'out_octets': '2385935893',
                                                                                                                  'out_ucast_pkts': '45503061',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2N2RiSURpbnRm'},
                                                                                                          {       'in_octets': '2708858277',
                                                                                                                  'in_ucast_pkts': '62615563',
                                                                                                                  'out_octets': '2707586279',
                                                                                                                  'out_ucast_pkts': '12780502',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2N2IwSURpbnRm'},
                                                                                                          {       'in_octets': '1540611177',
                                                                                                                  'in_ucast_pkts': '190401246',
                                                                                                                  'out_octets': '1971589587',
                                                                                                                  'out_ucast_pkts': '64001131',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMjQ0SURpbnRm'},
                                                                                                          {       'in_octets': '186992884',
                                                                                                                  'in_ucast_pkts': '1321936',
                                                                                                                  'out_octets': '3440534662',
                                                                                                                  'out_ucast_pkts': '5486087',
                                                                                                                  'poller_hash': 'QURUTjIxMTAzZDM3SURpbnRm'},
                                                                                                          {       'in_octets': '313167',
                                                                                                                  'in_ucast_pkts': '1652',
                                                                                                                  'out_octets': '2757071',
                                                                                                                  'out_ucast_pkts': '3452',
                                                                                                                  'poller_hash': 'QURUTjIwMzQyYzI4SURpbnRm'},
                                                                                                          {       'in_octets': '7170',
                                                                                                                  'in_ucast_pkts': '55',
                                                                                                                  'out_octets': '14520',
                                                                                                                  'out_ucast_pkts': '80',
                                                                                                                  'poller_hash': 'QURUTjIwMzQyYWYxSURpbnRm'},
                                                                                                          {       'in_octets': '4148730643',
                                                                                                                  'in_ucast_pkts': '162048283',
                                                                                                                  'out_octets': '1624678308',
                                                                                                                  'out_ucast_pkts': '67736005',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OGM3SURpbnRm'},
                                                                                                          {       'in_octets': '3383163434',
                                                                                                                  'in_ucast_pkts': '1506821351',
                                                                                                                  'out_octets': '1932859032',
                                                                                                                  'out_ucast_pkts': '378951767',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2FlSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/2/1',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '14065955352',
                                                                                         'out_ucast_pkts': '574462085',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjYwMDA2NTU=',
                                                                                         'pons': [       {       'id': '200001',
                                                                                                                 'links': [       {       'connected_time': '1452862',
                                                                                                                                          'fiber_length': 817,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2N2Ri',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '506595',
                                                                                                                                          'fiber_length': 522,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2N2Iw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '554375',
                                                                                                                                          'fiber_length': 525,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMjQ0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '692058',
                                                                                                                                          'fiber_length': 681,
                                                                                                                                          'poller_hash': 'QURUTjIxMTAzZDM3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '14648437',
                                                                                                                                          'fiber_length': 528,
                                                                                                                                          'poller_hash': 'QURUTjIwMzQyYzI4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '2143644',
                                                                                                                                          'fiber_length': 526,
                                                                                                                                          'poller_hash': 'QURUTjIwMzQyYWYx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '560409',
                                                                                                                                          'fiber_length': 831,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OGM3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '8739814',
                                                                                                                                          'fiber_length': 597,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Fl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjYwMDA2NTVncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'},
                                                                                                         {       'id': '200009',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjYwMDA2NTV4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '200010/200002',
                                                                                         'in_octets': '18178272932',
                                                                                         'in_ucast_pkts': '6707838495',
                                                                                         'links': [       {       'in_octets': '395361278',
                                                                                                                  'in_ucast_pkts': '987169797',
                                                                                                                  'out_octets': '3596964094',
                                                                                                                  'out_ucast_pkts': '165554882',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2N2Y2SURpbnRm'},
                                                                                                          {       'in_octets': '15212675',
                                                                                                                  'in_ucast_pkts': '63263',
                                                                                                                  'out_octets': '42263064',
                                                                                                                  'out_ucast_pkts': '71459',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MThjSURpbnRm'},
                                                                                                          {       'in_octets': '914562064',
                                                                                                                  'in_ucast_pkts': '228582002',
                                                                                                                  'out_octets': '915772625',
                                                                                                                  'out_ucast_pkts': '79070148',
                                                                                                                  'poller_hash': 'QURUTjIxMTI2ZTQ4SURpbnRm'},
                                                                                                          {       'in_octets': '2559314145',
                                                                                                                  'in_ucast_pkts': '2485308261',
                                                                                                                  'out_octets': '3562817226',
                                                                                                                  'out_ucast_pkts': '619791235',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Yzc0SURpbnRm'},
                                                                                                          {       'in_octets': '3942476454',
                                                                                                                  'in_ucast_pkts': '1713719617',
                                                                                                                  'out_octets': '2796365817',
                                                                                                                  'out_ucast_pkts': '613629280',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2N2VhSURpbnRm'},
                                                                                                          {       'in_octets': '1348299759',
                                                                                                                  'in_ucast_pkts': '485582074',
                                                                                                                  'out_octets': '1121250269',
                                                                                                                  'out_ucast_pkts': '98489478',
                                                                                                                  'poller_hash': 'QURUTjIxMTI2YzI5SURpbnRm'},
                                                                                                          {       'in_octets': '3825687311',
                                                                                                                  'in_ucast_pkts': '597730006',
                                                                                                                  'out_octets': '3409926138',
                                                                                                                  'out_ucast_pkts': '238759900',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODVjSURpbnRm'},
                                                                                                          {       'in_octets': '3347402872',
                                                                                                                  'in_ucast_pkts': '164391678',
                                                                                                                  'out_octets': '1751135916',
                                                                                                                  'out_ucast_pkts': '50560219',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZDQ5SURpbnRm'},
                                                                                                          {       'in_octets': '1829956374',
                                                                                                                  'in_ucast_pkts': '45291797',
                                                                                                                  'out_octets': '3630443682',
                                                                                                                  'out_ucast_pkts': '20119525',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZDUwSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/2/2',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '20826938831',
                                                                                         'out_ucast_pkts': '1886046126',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDEyMjc=',
                                                                                         'pons': [       {       'id': '200010',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDEyMjd4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '200002',
                                                                                                                 'links': [       {       'connected_time': '5501855',
                                                                                                                                          'fiber_length': 2056,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2N2Y2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '5954775',
                                                                                                                                          'fiber_length': 1863,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MThj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '553976',
                                                                                                                                          'fiber_length': 1662,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI2ZTQ4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '14613321',
                                                                                                                                          'fiber_length': 1609,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Yzc0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '7758672',
                                                                                                                                          'fiber_length': 1455,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2N2Vh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '2304400',
                                                                                                                                          'fiber_length': 2168,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI2YzI5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '2328379',
                                                                                                                                          'fiber_length': 2009,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODVj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '506590',
                                                                                                                                          'fiber_length': 1462,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZDQ5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '204563',
                                                                                                                                          'fiber_length': 1861,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZDUw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDEyMjdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '200011/200003',
                                                                                         'in_octets': '14592944793',
                                                                                         'in_ucast_pkts': '5851479020',
                                                                                         'links': [       {       'in_octets': '3813383149',
                                                                                                                  'in_ucast_pkts': '53134229',
                                                                                                                  'out_octets': '2599239841',
                                                                                                                  'out_ucast_pkts': '18350295',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3MTlkSURpbnRm'},
                                                                                                          {       'in_octets': '2668838095',
                                                                                                                  'in_ucast_pkts': '1596890423',
                                                                                                                  'out_octets': '3865898515',
                                                                                                                  'out_ucast_pkts': '507946417',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMGM3SURpbnRm'},
                                                                                                          {       'in_octets': '122120044',
                                                                                                                  'in_ucast_pkts': '96417',
                                                                                                                  'out_octets': '119094779',
                                                                                                                  'out_ucast_pkts': '143',
                                                                                                                  'poller_hash': 'QURUTjIwMzQxOWMySURpbnRm'},
                                                                                                          {       'in_octets': '216998991',
                                                                                                                  'in_ucast_pkts': '2742606',
                                                                                                                  'out_octets': '3027166269',
                                                                                                                  'out_ucast_pkts': '7734160',
                                                                                                                  'poller_hash': 'QURUTjIxMDljM2VmSURpbnRm'},
                                                                                                          {       'in_octets': '3600566897',
                                                                                                                  'in_ucast_pkts': '3095872658',
                                                                                                                  'out_octets': '422312933',
                                                                                                                  'out_ucast_pkts': '1175871564',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODBjSURpbnRm'},
                                                                                                          {       'in_octets': '4121853925',
                                                                                                                  'in_ucast_pkts': '1102368765',
                                                                                                                  'out_octets': '2312162144',
                                                                                                                  'out_ucast_pkts': '426793171',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODMwSURpbnRm'},
                                                                                                          {       'in_octets': '49183692',
                                                                                                                  'in_ucast_pkts': '373922',
                                                                                                                  'out_octets': '2676809444',
                                                                                                                  'out_ucast_pkts': '1846561',
                                                                                                                  'poller_hash': 'QURUTjIxNTQ0ODdmSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/2/3',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '15022683925',
                                                                                         'out_ucast_pkts': '2138542311',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDE2MTE=',
                                                                                         'pons': [       {       'id': '200011',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDE2MTF4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '200003',
                                                                                                                 'links': [       {       'connected_time': '167802',
                                                                                                                                          'fiber_length': 1585,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3MTlk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '7760554',
                                                                                                                                          'fiber_length': 1832,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMGM3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '5455551',
                                                                                                                                          'fiber_length': 1827,
                                                                                                                                          'poller_hash': 'QURUTjIwMzQxOWMy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '13903576',
                                                                                                                                          'fiber_length': 1549,
                                                                                                                                          'poller_hash': 'QURUTjIxMDljM2Vm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '10970305',
                                                                                                                                          'fiber_length': 1516,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODBj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '8518077',
                                                                                                                                          'fiber_length': 1712,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODMw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9},
                                                                                                                                  {       'connected_time': '7764397',
                                                                                                                                          'fiber_length': 1683,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQ0ODdm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.9}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDE2MTFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '200012/200004',
                                                                                         'in_octets': '17573779491',
                                                                                         'in_ucast_pkts': '4650945200',
                                                                                         'links': [       {       'in_octets': '1285923469',
                                                                                                                  'in_ucast_pkts': '253476815',
                                                                                                                  'out_octets': '103418151',
                                                                                                                  'out_ucast_pkts': '105175903',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMmEySURpbnRm'},
                                                                                                          {       'in_octets': '4051435018',
                                                                                                                  'in_ucast_pkts': '615497053',
                                                                                                                  'out_octets': '797974007',
                                                                                                                  'out_ucast_pkts': '191496408',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2YySURpbnRm'},
                                                                                                          {       'in_octets': '2906952731',
                                                                                                                  'in_ucast_pkts': '1443587083',
                                                                                                                  'out_octets': '2001730771',
                                                                                                                  'out_ucast_pkts': '498017838',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2NhSURpbnRm'},
                                                                                                          {       'in_octets': '1843933446',
                                                                                                                  'in_ucast_pkts': '984171266',
                                                                                                                  'out_octets': '2801754785',
                                                                                                                  'out_ucast_pkts': '291333974',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2RiSURpbnRm'},
                                                                                                          {       'in_octets': '1831553313',
                                                                                                                  'in_ucast_pkts': '465133871',
                                                                                                                  'out_octets': '590319159',
                                                                                                                  'out_ucast_pkts': '382021958',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMGNmSURpbnRm'},
                                                                                                          {       'in_octets': '3154104494',
                                                                                                                  'in_ucast_pkts': '352224945',
                                                                                                                  'out_octets': '1610987738',
                                                                                                                  'out_ucast_pkts': '68791392',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMWY3SURpbnRm'},
                                                                                                          {       'in_octets': '1913106451',
                                                                                                                  'in_ucast_pkts': '409149601',
                                                                                                                  'out_octets': '4198115694',
                                                                                                                  'out_ucast_pkts': '84917575',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODRmSURpbnRm'},
                                                                                                          {       'in_octets': '455067468',
                                                                                                                  'in_ucast_pkts': '127426371',
                                                                                                                  'out_octets': '729013185',
                                                                                                                  'out_ucast_pkts': '33942006',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODlhSURpbnRm'},
                                                                                                          {       'in_octets': '131703101',
                                                                                                                  'in_ucast_pkts': '278195',
                                                                                                                  'out_octets': '624568949',
                                                                                                                  'out_ucast_pkts': '585925',
                                                                                                                  'poller_hash': 'QURUTjIyMjAxYTFiSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/2/4',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '13457882439',
                                                                                         'out_ucast_pkts': '1656282979',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA1Nzc=',
                                                                                         'pons': [       {       'id': '200012',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA1Nzd4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '200004',
                                                                                                                 'links': [       {       'connected_time': '2592553',
                                                                                                                                          'fiber_length': 2516,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMmEy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '2303284',
                                                                                                                                          'fiber_length': 2168,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Yy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '7761426',
                                                                                                                                          'fiber_length': 2254,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Nh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '4582698',
                                                                                                                                          'fiber_length': 2329,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Ri',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '3163823',
                                                                                                                                          'fiber_length': 2281,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMGNm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '2301943',
                                                                                                                                          'fiber_length': 2143,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMWY3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '2340826',
                                                                                                                                          'fiber_length': 2465,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODRm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '532499',
                                                                                                                                          'fiber_length': 2387,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODlh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '2346412',
                                                                                                                                          'fiber_length': 2001,
                                                                                                                                          'poller_hash': 'QURUTjIyMjAxYTFi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -12.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA1NzdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '200013/200005',
                                                                                         'in_octets': '5959206222',
                                                                                         'in_ucast_pkts': '1264359653',
                                                                                         'links': [       {       'in_octets': '572503162',
                                                                                                                  'in_ucast_pkts': '821155969',
                                                                                                                  'out_octets': '3441822553',
                                                                                                                  'out_ucast_pkts': '250144600',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2QxSURpbnRm'},
                                                                                                          {       'in_octets': '1755397667',
                                                                                                                  'in_ucast_pkts': '69529786',
                                                                                                                  'out_octets': '2443018692',
                                                                                                                  'out_ucast_pkts': '19410373',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZDNhSURpbnRm'},
                                                                                                          {       'in_octets': '17419774',
                                                                                                                  'in_ucast_pkts': '86882',
                                                                                                                  'out_octets': '31924325',
                                                                                                                  'out_ucast_pkts': '83543',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MGU5SURpbnRm'},
                                                                                                          {       'in_octets': '2975682384',
                                                                                                                  'in_ucast_pkts': '174001628',
                                                                                                                  'out_octets': '2387966082',
                                                                                                                  'out_ucast_pkts': '44041194',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMjc1SURpbnRm'},
                                                                                                          {       'in_octets': '594118145',
                                                                                                                  'in_ucast_pkts': '199480811',
                                                                                                                  'out_octets': '4036376562',
                                                                                                                  'out_ucast_pkts': '94623807',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODc0SURpbnRm'},
                                                                                                          {       'in_octets': '44085090',
                                                                                                                  'in_ucast_pkts': '104577',
                                                                                                                  'out_octets': '428528550',
                                                                                                                  'out_ucast_pkts': '401981',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MTg2SURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/2/5',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '12769636764',
                                                                                         'out_ucast_pkts': '408705498',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDAzMjk=',
                                                                                         'pons': [       {       'id': '200013',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDAzMjl4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '200005',
                                                                                                                 'links': [       {       'connected_time': '1765217',
                                                                                                                                          'fiber_length': 1818,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Qx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '178382',
                                                                                                                                          'fiber_length': 1688,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZDNh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '14648437',
                                                                                                                                          'fiber_length': 1825,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MGU5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '1092253',
                                                                                                                                          'fiber_length': 1624,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMjc1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '680728',
                                                                                                                                          'fiber_length': 1753,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODc0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '1203991',
                                                                                                                                          'fiber_length': 1678,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MTg2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.1}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDAzMjlncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '200014/200006',
                                                                                         'in_octets': '16201821085',
                                                                                         'in_ucast_pkts': '1879359916',
                                                                                         'links': [       {       'in_octets': '2554095936',
                                                                                                                  'in_ucast_pkts': '35527538',
                                                                                                                  'out_octets': '819681898',
                                                                                                                  'out_ucast_pkts': '5032670',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZTAzSURpbnRm'},
                                                                                                          {       'in_octets': '1990115555',
                                                                                                                  'in_ucast_pkts': '133148560',
                                                                                                                  'out_octets': '2996525772',
                                                                                                                  'out_ucast_pkts': '63851407',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2VjSURpbnRm'},
                                                                                                          {       'in_octets': '4111718532',
                                                                                                                  'in_ucast_pkts': '14372455',
                                                                                                                  'out_octets': '1433171765',
                                                                                                                  'out_ucast_pkts': '90416367',
                                                                                                                  'poller_hash': 'QURUTjIxMTAzZWM1SURpbnRm'},
                                                                                                          {       'in_octets': '2370714287',
                                                                                                                  'in_ucast_pkts': '364571469',
                                                                                                                  'out_octets': '1723899005',
                                                                                                                  'out_ucast_pkts': '135072433',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZDQ2SURpbnRm'},
                                                                                                          {       'in_octets': '564682961',
                                                                                                                  'in_ucast_pkts': '21007818',
                                                                                                                  'out_octets': '874432829',
                                                                                                                  'out_ucast_pkts': '9658400',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZTQwSURpbnRm'},
                                                                                                          {       'in_octets': '5597615',
                                                                                                                  'in_ucast_pkts': '20025',
                                                                                                                  'out_octets': '17775183',
                                                                                                                  'out_ucast_pkts': '23584',
                                                                                                                  'poller_hash': 'QURUTjIxNTM5YjA1SURpbnRm'},
                                                                                                          {       'in_octets': '2749363251',
                                                                                                                  'in_ucast_pkts': '1097896502',
                                                                                                                  'out_octets': '996697835',
                                                                                                                  'out_ucast_pkts': '544035448',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OGY4SURpbnRm'},
                                                                                                          {       'in_octets': '1855532948',
                                                                                                                  'in_ucast_pkts': '212815549',
                                                                                                                  'out_octets': '4044021171',
                                                                                                                  'out_ucast_pkts': '65173836',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3YjYySURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/2/6',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '12906205458',
                                                                                         'out_ucast_pkts': '913264145',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA1NTk=',
                                                                                         'pons': [       {       'id': '200014',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA1NTl4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '200006',
                                                                                                                 'links': [       {       'connected_time': '506678',
                                                                                                                                          'fiber_length': 1471,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZTAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.5},
                                                                                                                                  {       'connected_time': '595283',
                                                                                                                                          'fiber_length': 1479,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Vj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.5},
                                                                                                                                  {       'connected_time': '204127',
                                                                                                                                          'fiber_length': 1351,
                                                                                                                                          'poller_hash': 'QURUTjIxMTAzZWM1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.5},
                                                                                                                                  {       'connected_time': '346423',
                                                                                                                                          'fiber_length': 1346,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZDQ2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.5},
                                                                                                                                  {       'connected_time': '65168',
                                                                                                                                          'fiber_length': 1590,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZTQw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.5},
                                                                                                                                  {       'connected_time': '14648437',
                                                                                                                                          'fiber_length': 1334,
                                                                                                                                          'poller_hash': 'QURUTjIxNTM5YjA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.5},
                                                                                                                                  {       'connected_time': '2340195',
                                                                                                                                          'fiber_length': 1401,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OGY4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.5},
                                                                                                                                  {       'connected_time': '2068346',
                                                                                                                                          'fiber_length': 1518,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3YjYy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.5}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA1NTlncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '200015/200007',
                                                                                         'in_octets': '21866818397',
                                                                                         'in_ucast_pkts': '2372215520',
                                                                                         'links': [       {       'in_octets': '1079656275',
                                                                                                                  'in_ucast_pkts': '232414825',
                                                                                                                  'out_octets': '3564491401',
                                                                                                                  'out_ucast_pkts': '91980058',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMTlmSURpbnRm'},
                                                                                                          {       'in_octets': '3278444880',
                                                                                                                  'in_ucast_pkts': '1173737738',
                                                                                                                  'out_octets': '1685382683',
                                                                                                                  'out_ucast_pkts': '244919865',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3YWQ1SURpbnRm'},
                                                                                                          {       'in_octets': '64647414',
                                                                                                                  'in_ucast_pkts': '300662',
                                                                                                                  'out_octets': '2096698900',
                                                                                                                  'out_ucast_pkts': '1731749',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MDQ1SURpbnRm'},
                                                                                                          {       'in_octets': '1521739289',
                                                                                                                  'in_ucast_pkts': '16757493',
                                                                                                                  'out_octets': '2501015680',
                                                                                                                  'out_ucast_pkts': '33237909',
                                                                                                                  'poller_hash': 'QURUTjIxMTA0MDZlSURpbnRm'},
                                                                                                          {       'in_octets': '3007489864',
                                                                                                                  'in_ucast_pkts': '65166833',
                                                                                                                  'out_octets': '3730603727',
                                                                                                                  'out_ucast_pkts': '16739860',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5YzI2SURpbnRm'},
                                                                                                          {       'in_octets': '1062324718',
                                                                                                                  'in_ucast_pkts': '94807877',
                                                                                                                  'out_octets': '3770433982',
                                                                                                                  'out_ucast_pkts': '28974266',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMTk2SURpbnRm'},
                                                                                                          {       'in_octets': '3408194491',
                                                                                                                  'in_ucast_pkts': '181465323',
                                                                                                                  'out_octets': '3177440656',
                                                                                                                  'out_ucast_pkts': '32081957',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMWY5SURpbnRm'},
                                                                                                          {       'in_octets': '1216915665',
                                                                                                                  'in_ucast_pkts': '59712581',
                                                                                                                  'out_octets': '2158264139',
                                                                                                                  'out_ucast_pkts': '18189889',
                                                                                                                  'poller_hash': 'QURUTjIxMTI2YzQ0SURpbnRm'},
                                                                                                          {       'in_octets': '2103676149',
                                                                                                                  'in_ucast_pkts': '1913170',
                                                                                                                  'out_octets': '221869359',
                                                                                                                  'out_ucast_pkts': '569670',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODhlSURpbnRm'},
                                                                                                          {       'in_octets': '3916505557',
                                                                                                                  'in_ucast_pkts': '22605656',
                                                                                                                  'out_octets': '1228817379',
                                                                                                                  'out_ucast_pkts': '7929178',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OGQwSURpbnRm'},
                                                                                                          {       'in_octets': '41796412',
                                                                                                                  'in_ucast_pkts': '154167',
                                                                                                                  'out_octets': '747314154',
                                                                                                                  'out_ucast_pkts': '594561',
                                                                                                                  'poller_hash': 'QURUTjIyNDUzZGJiSURpbnRm'},
                                                                                                          {       'in_octets': '741442454',
                                                                                                                  'in_ucast_pkts': '521270900',
                                                                                                                  'out_octets': '1249623045',
                                                                                                                  'out_ucast_pkts': '132664300',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OGEzSURpbnRm'},
                                                                                                          {       'in_octets': '423985229',
                                                                                                                  'in_ucast_pkts': '1908295',
                                                                                                                  'out_octets': '3277751654',
                                                                                                                  'out_ucast_pkts': '3436306',
                                                                                                                  'poller_hash': 'QURUTjIxNTQ0ZDFmSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/2/7',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '29409706759',
                                                                                         'out_ucast_pkts': '613049568',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDAxNDk=',
                                                                                         'pons': [       {       'id': '200015',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDAxNDl4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '200007',
                                                                                                                 'links': [       {       'connected_time': '554593',
                                                                                                                                          'fiber_length': 3229,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMTlm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '3435532',
                                                                                                                                          'fiber_length': 3387,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3YWQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '14648436',
                                                                                                                                          'fiber_length': 3582,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MDQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '7324567',
                                                                                                                                          'fiber_length': 3298,
                                                                                                                                          'poller_hash': 'QURUTjIxMTA0MDZl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '1800631',
                                                                                                                                          'fiber_length': 3668,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5YzI2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '203709',
                                                                                                                                          'fiber_length': 3303,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMTk2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '436175',
                                                                                                                                          'fiber_length': 3251,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMWY5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '491460',
                                                                                                                                          'fiber_length': 3530,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI2YzQ0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '164644',
                                                                                                                                          'fiber_length': 3803,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODhl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '1567579',
                                                                                                                                          'fiber_length': 3345,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OGQw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '1559467',
                                                                                                                                          'fiber_length': 3359,
                                                                                                                                          'poller_hash': 'QURUTjIyNDUzZGJi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '1368216',
                                                                                                                                          'fiber_length': 3436,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OGEz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '14648436',
                                                                                                                                          'fiber_length': 3307,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQ0ZDFm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDAxNDlncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '200016/200008',
                                                                                         'in_octets': '8547907311',
                                                                                         'in_ucast_pkts': '5423568225',
                                                                                         'links': [       {       'in_octets': '896837967',
                                                                                                                  'in_ucast_pkts': '911523059',
                                                                                                                  'out_octets': '2403602101',
                                                                                                                  'out_ucast_pkts': '206430835',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMjI3SURpbnRm'},
                                                                                                          {       'in_octets': '419127539',
                                                                                                                  'in_ucast_pkts': '540378632',
                                                                                                                  'out_octets': '2664044992',
                                                                                                                  'out_ucast_pkts': '184709982',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZGZiSURpbnRm'},
                                                                                                          {       'in_octets': '2180725220',
                                                                                                                  'in_ucast_pkts': '1172423547',
                                                                                                                  'out_octets': '4042583491',
                                                                                                                  'out_ucast_pkts': '617655094',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMjA1SURpbnRm'},
                                                                                                          {       'in_octets': '159257287',
                                                                                                                  'in_ucast_pkts': '367780',
                                                                                                                  'out_octets': '2082074495',
                                                                                                                  'out_ucast_pkts': '1553912',
                                                                                                                  'poller_hash': 'QURUTjIyMTkzYjAxSURpbnRm'},
                                                                                                          {       'in_octets': '833828162',
                                                                                                                  'in_ucast_pkts': '270225822',
                                                                                                                  'out_octets': '1629603374',
                                                                                                                  'out_ucast_pkts': '87812699',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODQxSURpbnRm'},
                                                                                                          {       'in_octets': '547639546',
                                                                                                                  'in_ucast_pkts': '171084965',
                                                                                                                  'out_octets': '3080898683',
                                                                                                                  'out_ucast_pkts': '117301785',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODI1SURpbnRm'},
                                                                                                          {       'in_octets': '3510491590',
                                                                                                                  'in_ucast_pkts': '2357564420',
                                                                                                                  'out_octets': '4017281201',
                                                                                                                  'out_ucast_pkts': '958503917',
                                                                                                                  'poller_hash': 'QURUTjIxMTI2ZWExSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/2/8',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '19920088337',
                                                                                         'out_ucast_pkts': '2173968224',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA0NzQ=',
                                                                                         'pons': [       {       'id': '200016',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA0NzR4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '200008',
                                                                                                                 'links': [       {       'connected_time': '13903574',
                                                                                                                                          'fiber_length': 3518,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMjI3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '4123900',
                                                                                                                                          'fiber_length': 3536,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZGZi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '7349380',
                                                                                                                                          'fiber_length': 3323,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMjA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '1097579',
                                                                                                                                          'fiber_length': 3350,
                                                                                                                                          'poller_hash': 'QURUTjIyMTkzYjAx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '5159839',
                                                                                                                                          'fiber_length': 3322,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODQx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '472349',
                                                                                                                                          'fiber_length': 3316,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODI1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '7763875',
                                                                                                                                          'fiber_length': 3592,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI2ZWEx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.3}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA0NzRncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 30.553818,
                                                           'model': '1187518F1',
                                                           'name': 'COMBO OLT 8P',
                                                           'poller_hash': 'TEJBRFROMjEyOUNEODY5MTE4NzUxOEYx',
                                                           'serial_number': 'LBADTN2129CD869',
                                                           'sw_version': '11.1.5.4.11',
                                                           'temperature': 34.0,
                                                           'uptime': '14648272'},
                                                   {       'id': '251',
                                                           'manufacturer': 'Adtran',
                                                           'model': '1187080G3',
                                                           'name': 'Fan Module',
                                                           'poller_hash': 'TEJBRFROMjExM0FLNjY1MTE4NzA4MEcz',
                                                           'serial_number': 'LBADTN2113AK665',
                                                           'sw_version': 'A03.00',
                                                           'uptime': '23716258'},
                                                   {       'id': '252',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '25200001',
                                                                                         'in_discards': '10255102',
                                                                                         'in_nucast_pkts': '12909110',
                                                                                         'in_octets': '1840371975384',
                                                                                         'in_ucast_pkts': '1317754214',
                                                                                         'mac_address': '00:24:45:f5:11:24',
                                                                                         'manufacturer': 'Hisense',
                                                                                         'model': 'ADTRAN '
                                                                                                  '10GBASE-LR10',
                                                                                         'mtu': 12288,
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/A/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '112162',
                                                                                         'out_octets': '99655732160',
                                                                                         'out_ucast_pkts': '419107913',
                                                                                         'poller_hash': 'TEJBRFROMjExM0FLMTcySjgzQjdEMDAzMDc=',
                                                                                         'speed': '4294967295',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25200002',
                                                                                         'mac_address': '00:24:45:f5:11:25',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/A/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjExM0FLMTcyMDAyNDQ1ZjUxMTI1',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25200003',
                                                                                         'mac_address': '00:24:45:f5:11:26',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/A/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjExM0FLMTcyMDAyNDQ1ZjUxMTI2',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25200004',
                                                                                         'mac_address': '00:24:45:f5:11:27',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/A/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjExM0FLMTcyMDAyNDQ1ZjUxMTI3',
                                                                                         'type': 6}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 9.841868,
                                                           'model': '1187041F1',
                                                           'name': 'SM 4-10G',
                                                           'poller_hash': 'TEJBRFROMjExM0FLMTcyMTE4NzA0MUYx',
                                                           'serial_number': 'LBADTN2113AK172',
                                                           'sw_version': 'L15.0336',
                                                           'temperature': 45.5,
                                                           'uptime': '23716258'},
                                                   {       'id': '253',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '25300001',
                                                                                         'in_discards': '12638421',
                                                                                         'in_nucast_pkts': '12929030',
                                                                                         'in_octets': '902331343',
                                                                                         'in_ucast_pkts': '199',
                                                                                         'mac_address': '00:24:45:f5:0f:62',
                                                                                         'manufacturer': 'Hisense',
                                                                                         'model': 'ADTRAN '
                                                                                                  '10GBASE-LR10',
                                                                                         'mtu': 12288,
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/B/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1027',
                                                                                         'out_octets': '93457',
                                                                                         'poller_hash': 'TEJBRFROMjExM0FLMTYzSjgzQjdEMDA4MTA=',
                                                                                         'speed': '4294967295',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25300002',
                                                                                         'mac_address': '00:24:45:f5:0f:63',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/B/2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjExM0FLMTYzMDAyNDQ1ZjUwZjYz',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25300003',
                                                                                         'mac_address': '00:24:45:f5:0f:64',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/B/3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjExM0FLMTYzMDAyNDQ1ZjUwZjY0',
                                                                                         'type': 6},
                                                                                 {       'admin_up': False,
                                                                                         'id': '25300004',
                                                                                         'mac_address': '00:24:45:f5:0f:65',
                                                                                         'name': 'ten-gigabit-ethernet '
                                                                                                 '1/B/4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjExM0FLMTYzMDAyNDQ1ZjUwZjY1',
                                                                                         'type': 6}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 9.822745,
                                                           'model': '1187041F1',
                                                           'name': 'SM 4-10G',
                                                           'poller_hash': 'TEJBRFROMjExM0FLMTYzMTE4NzA0MUYx',
                                                           'serial_number': 'LBADTN2113AK163',
                                                           'sw_version': 'L15.0336',
                                                           'uptime': '23716571'},
                                                   {       'id': '254',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1',
                                                                                         'mac_address': '00:24:45:e8:52:fb',
                                                                                         'mtu': 1500,
                                                                                         'name': 'eth0',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjExMUFBMDM5MDAyNDQ1ZTg1MmZi',
                                                                                         'speed': '100000000',
                                                                                         'type': 6},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3',
                                                                                         'in_discards': '29',
                                                                                         'in_unknown_protos': '5871673',
                                                                                         'mac_address': '00:24:45:e8:52:fd',
                                                                                         'mtu': 1500,
                                                                                         'name': 'eth5',
                                                                                         'oper_up': True,
                                                                                         'poller_hash': 'TEJBRFROMjExMUFBMDM5MDAyNDQ1ZTg1MmZk',
                                                                                         'speed': '100000000',
                                                                                         'type': 6}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 42.151672,
                                                           'model': '1187011F3',
                                                           'name': 'SCM',
                                                           'poller_hash': 'TEJBRFROMjExMUFBMDM5MTE4NzAxMUYz',
                                                           'serial_number': 'LBADTN2111AA039',
                                                           'sw_version': 'L15.028',
                                                           'uptime': '14648203'},
                                                   {       'id': '3',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '300001/300009',
                                                                                         'in_octets': '20485445265',
                                                                                         'in_ucast_pkts': '7094424916',
                                                                                         'links': [       {       'in_octets': '879755755',
                                                                                                                  'in_ucast_pkts': '1326316506',
                                                                                                                  'out_octets': '3949858047',
                                                                                                                  'out_ucast_pkts': '623537847',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMjU3SURpbnRm'},
                                                                                                          {       'in_octets': '274896089',
                                                                                                                  'in_ucast_pkts': '1396272',
                                                                                                                  'out_octets': '2821535861',
                                                                                                                  'out_ucast_pkts': '2268477',
                                                                                                                  'poller_hash': 'QURUTjIxMTAzZGIzSURpbnRm'},
                                                                                                          {       'in_octets': '1253434522',
                                                                                                                  'in_ucast_pkts': '15966687',
                                                                                                                  'out_octets': '616213693',
                                                                                                                  'out_ucast_pkts': '3961613',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2QySURpbnRm'},
                                                                                                          {       'in_octets': '40130590',
                                                                                                                  'in_ucast_pkts': '179891',
                                                                                                                  'out_octets': '860313335',
                                                                                                                  'out_ucast_pkts': '655397',
                                                                                                                  'poller_hash': 'QURUTjIxMTAzZWQySURpbnRm'},
                                                                                                          {       'in_octets': '2926966288',
                                                                                                                  'in_ucast_pkts': '473957275',
                                                                                                                  'out_octets': '3794185025',
                                                                                                                  'out_ucast_pkts': '128176410',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2Y2SURpbnRm'},
                                                                                                          {       'in_octets': '3386082062',
                                                                                                                  'in_ucast_pkts': '335720674',
                                                                                                                  'out_octets': '101886128',
                                                                                                                  'out_ucast_pkts': '93069091',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODJmSURpbnRm'},
                                                                                                          {       'in_octets': '2438609282',
                                                                                                                  'in_ucast_pkts': '3064968265',
                                                                                                                  'out_octets': '4085932944',
                                                                                                                  'out_ucast_pkts': '810363646',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODE0SURpbnRm'},
                                                                                                          {       'in_octets': '2355022958',
                                                                                                                  'in_ucast_pkts': '1511825834',
                                                                                                                  'out_octets': '843834484',
                                                                                                                  'out_ucast_pkts': '375175575',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3MDQ1SURpbnRm'},
                                                                                                          {       'in_octets': '196163374',
                                                                                                                  'in_ucast_pkts': '19507416',
                                                                                                                  'out_octets': '1334442055',
                                                                                                                  'out_ucast_pkts': '2921098',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZTU2SURpbnRm'},
                                                                                                          {       'in_octets': '3030885228',
                                                                                                                  'in_ucast_pkts': '253890995',
                                                                                                                  'out_octets': '3882630744',
                                                                                                                  'out_ucast_pkts': '83305311',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZDRiSURpbnRm'},
                                                                                                          {       'in_octets': '325443509',
                                                                                                                  'in_ucast_pkts': '85183299',
                                                                                                                  'out_octets': '3099322132',
                                                                                                                  'out_ucast_pkts': '19197583',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMTUySURpbnRm'},
                                                                                                          {       'in_octets': '3378055608',
                                                                                                                  'in_ucast_pkts': '5511802',
                                                                                                                  'out_octets': '159589807',
                                                                                                                  'out_ucast_pkts': '554201',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwMTQ0SURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/3/1',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '25549744255',
                                                                                         'out_ucast_pkts': '2143186249',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA0MDc=',
                                                                                         'pons': [       {       'id': '300001',
                                                                                                                 'links': [       {       'connected_time': '3795706',
                                                                                                                                          'fiber_length': 1110,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMjU3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '14648415',
                                                                                                                                          'fiber_length': 918,
                                                                                                                                          'poller_hash': 'QURUTjIxMTAzZGIz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '104509',
                                                                                                                                          'fiber_length': 969,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Qy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '2516564',
                                                                                                                                          'fiber_length': 929,
                                                                                                                                          'poller_hash': 'QURUTjIxMTAzZWQy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '839117',
                                                                                                                                          'fiber_length': 929,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2Y2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '1553792',
                                                                                                                                          'fiber_length': 867,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODJm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '7538610',
                                                                                                                                          'fiber_length': 848,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODE0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '14648415',
                                                                                                                                          'fiber_length': 931,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3MDQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '938642',
                                                                                                                                          'fiber_length': 859,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZTU2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '1555076',
                                                                                                                                          'fiber_length': 874,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZDRi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '408602',
                                                                                                                                          'fiber_length': 916,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMTUy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA0MDdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'},
                                                                                                         {       'id': '300009',
                                                                                                                 'links': [       {       'connected_time': '9178',
                                                                                                                                          'fiber_length': 837,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwMTQ0',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -11.8,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.7}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA0MDd4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '300010/300002',
                                                                                         'in_octets': '12228735154',
                                                                                         'in_ucast_pkts': '3495904296',
                                                                                         'links': [       {       'in_octets': '1302841902',
                                                                                                                  'in_ucast_pkts': '80432487',
                                                                                                                  'out_octets': '3700917546',
                                                                                                                  'out_ucast_pkts': '27329059',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwOTI2SURpbnRm'},
                                                                                                          {       'in_octets': '2018543767',
                                                                                                                  'in_ucast_pkts': '353159885',
                                                                                                                  'out_octets': '288259756',
                                                                                                                  'out_ucast_pkts': '98481757',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwOTIzSURpbnRm'},
                                                                                                          {       'in_octets': '2207596092',
                                                                                                                  'in_ucast_pkts': '405861340',
                                                                                                                  'out_octets': '1973013202',
                                                                                                                  'out_ucast_pkts': '155864700',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Y2E5SURpbnRm'},
                                                                                                          {       'in_octets': '289052074',
                                                                                                                  'in_ucast_pkts': '222671',
                                                                                                                  'out_octets': '17098258',
                                                                                                                  'out_ucast_pkts': '70494',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZTI0SURpbnRm'},
                                                                                                          {       'in_octets': '542036753',
                                                                                                                  'in_ucast_pkts': '2026095',
                                                                                                                  'out_octets': '593209471',
                                                                                                                  'out_ucast_pkts': '7821899',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNTBhSURpbnRm'},
                                                                                                          {       'in_octets': '156776974',
                                                                                                                  'in_ucast_pkts': '427719',
                                                                                                                  'out_octets': '924093500',
                                                                                                                  'out_ucast_pkts': '866918',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNTM0SURpbnRm'},
                                                                                                          {       'in_octets': '423792423',
                                                                                                                  'in_ucast_pkts': '5857268',
                                                                                                                  'out_octets': '3905540536',
                                                                                                                  'out_ucast_pkts': '11167767',
                                                                                                                  'poller_hash': 'QURUTjIyNDUzYzUySURpbnRm'},
                                                                                                          {       'in_octets': '860995096',
                                                                                                                  'in_ucast_pkts': '1083629948',
                                                                                                                  'out_octets': '3373969450',
                                                                                                                  'out_ucast_pkts': '376537182',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZTVlSURpbnRm'},
                                                                                                          {       'in_octets': '83813798',
                                                                                                                  'in_ucast_pkts': '338445',
                                                                                                                  'out_octets': '1210901853',
                                                                                                                  'out_ucast_pkts': '965183',
                                                                                                                  'poller_hash': 'QURUTjIyNDUzNTNmSURpbnRm'},
                                                                                                          {       'in_octets': '497372829',
                                                                                                                  'in_ucast_pkts': '4215429',
                                                                                                                  'out_octets': '1380018402',
                                                                                                                  'out_ucast_pkts': '15707829',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNGNkSURpbnRm'},
                                                                                                          {       'in_octets': '373480530',
                                                                                                                  'in_ucast_pkts': '4310681',
                                                                                                                  'out_octets': '27837240',
                                                                                                                  'out_ucast_pkts': '11859392',
                                                                                                                  'poller_hash': 'QURUTjIyNDU0YzI4SURpbnRm'},
                                                                                                          {       'in_octets': '2802424967',
                                                                                                                  'in_ucast_pkts': '1491740940',
                                                                                                                  'out_octets': '4030059990',
                                                                                                                  'out_ucast_pkts': '820608424',
                                                                                                                  'poller_hash': 'QURUTjIxMTI2ZTdlSURpbnRm'},
                                                                                                          {       'in_octets': '670007949',
                                                                                                                  'in_ucast_pkts': '63681388',
                                                                                                                  'out_octets': '3935821563',
                                                                                                                  'out_ucast_pkts': '34716510',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5ZDc3SURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/3/2',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '25360740767',
                                                                                         'out_ucast_pkts': '1561997114',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAwMzc=',
                                                                                         'pons': [       {       'id': '300010',
                                                                                                                 'links': [       {       'connected_time': '398644',
                                                                                                                                          'fiber_length': 4930,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwOTI2',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.1},
                                                                                                                                  {       'connected_time': '1292497',
                                                                                                                                          'fiber_length': 5827,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwOTIz',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -19.5,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.1}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAwMzd4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '300002',
                                                                                                                 'links': [       {       'connected_time': '7272378',
                                                                                                                                          'fiber_length': 3419,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Y2E5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '48',
                                                                                                                                          'fiber_length': 5716,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZTI0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -27.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '58250',
                                                                                                                                          'fiber_length': 4227,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNTBh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '4744794',
                                                                                                                                          'fiber_length': 2768,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNTM0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '7528272',
                                                                                                                                          'fiber_length': 5331,
                                                                                                                                          'poller_hash': 'QURUTjIyNDUzYzUy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '7348064',
                                                                                                                                          'fiber_length': 5130,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZTVl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '6038574',
                                                                                                                                          'fiber_length': 4036,
                                                                                                                                          'poller_hash': 'QURUTjIyNDUzNTNm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '6454120',
                                                                                                                                          'fiber_length': 3872,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNGNk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '2062812',
                                                                                                                                          'fiber_length': 3672,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU0YzI4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '2258956',
                                                                                                                                          'fiber_length': 4780,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI2ZTdl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4},
                                                                                                                                  {       'connected_time': '959308',
                                                                                                                                          'fiber_length': 2929,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5ZDc3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.4}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAwMzdncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '300011/300003',
                                                                                         'in_octets': '27119419145',
                                                                                         'in_ucast_pkts': '3861934451',
                                                                                         'links': [       {       'in_octets': '3157276695',
                                                                                                                  'in_ucast_pkts': '517864029',
                                                                                                                  'out_octets': '443810217',
                                                                                                                  'out_ucast_pkts': '234143074',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwNDY1SURpbnRm'},
                                                                                                          {       'in_octets': '3555103616',
                                                                                                                  'in_ucast_pkts': '787890838',
                                                                                                                  'out_octets': '803353973',
                                                                                                                  'out_ucast_pkts': '198143135',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwYmMwSURpbnRm'},
                                                                                                          {       'in_octets': '3794301355',
                                                                                                                  'in_ucast_pkts': '904187287',
                                                                                                                  'out_octets': '872665404',
                                                                                                                  'out_ucast_pkts': '238846943',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwOTg5SURpbnRm'},
                                                                                                          {       'in_octets': '3522578283',
                                                                                                                  'in_ucast_pkts': '8581590',
                                                                                                                  'out_octets': '1229649956',
                                                                                                                  'out_ucast_pkts': '15812279',
                                                                                                                  'poller_hash': 'QURUTjIyNDU0YzAwSURpbnRm'},
                                                                                                          {       'in_octets': '1031675508',
                                                                                                                  'in_ucast_pkts': '1796259',
                                                                                                                  'out_octets': '3670377711',
                                                                                                                  'out_ucast_pkts': '5999467',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNGNmSURpbnRm'},
                                                                                                          {       'in_octets': '173909861',
                                                                                                                  'in_ucast_pkts': '2212520',
                                                                                                                  'out_octets': '4203985145',
                                                                                                                  'out_ucast_pkts': '5765235',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNTM3SURpbnRm'},
                                                                                                          {       'in_octets': '281707939',
                                                                                                                  'in_ucast_pkts': '187356896',
                                                                                                                  'out_octets': '3272614385',
                                                                                                                  'out_ucast_pkts': '18109088',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3NDg0SURpbnRm'},
                                                                                                          {       'in_octets': '466819726',
                                                                                                                  'in_ucast_pkts': '1238229',
                                                                                                                  'out_octets': '1124675776',
                                                                                                                  'out_ucast_pkts': '6806546',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNTQzSURpbnRm'},
                                                                                                          {       'in_octets': '13334183',
                                                                                                                  'in_ucast_pkts': '78775',
                                                                                                                  'out_octets': '140595072',
                                                                                                                  'out_ucast_pkts': '153832',
                                                                                                                  'poller_hash': 'QURUTjIyNDU0YmZlSURpbnRm'},
                                                                                                          {       'in_octets': '95873770',
                                                                                                                  'in_ucast_pkts': '951120',
                                                                                                                  'out_octets': '3718072518',
                                                                                                                  'out_ucast_pkts': '8338873',
                                                                                                                  'poller_hash': 'QURUTjIxNTQ0OGFhSURpbnRm'},
                                                                                                          {       'in_octets': '2765730397',
                                                                                                                  'in_ucast_pkts': '2783634',
                                                                                                                  'out_octets': '1221370552',
                                                                                                                  'out_ucast_pkts': '1408464',
                                                                                                                  'poller_hash': 'QURUTjIyNDU1NDc0SURpbnRm'},
                                                                                                          {       'in_octets': '257299898',
                                                                                                                  'in_ucast_pkts': '2809442',
                                                                                                                  'out_octets': '2168983875',
                                                                                                                  'out_ucast_pkts': '10424974',
                                                                                                                  'poller_hash': 'QURUTjIyNDU1MTBlSURpbnRm'},
                                                                                                          {       'in_octets': '336044059',
                                                                                                                  'in_ucast_pkts': '2501250',
                                                                                                                  'out_octets': '1969591218',
                                                                                                                  'out_ucast_pkts': '7407334',
                                                                                                                  'poller_hash': 'QURUTjIyNDU1NDM2SURpbnRm'},
                                                                                                          {       'in_octets': '2271711671',
                                                                                                                  'in_ucast_pkts': '84327380',
                                                                                                                  'out_octets': '1074390133',
                                                                                                                  'out_ucast_pkts': '34535183',
                                                                                                                  'poller_hash': 'QURUTjIxMTU5Yzk0SURpbnRm'},
                                                                                                          {       'in_octets': '3864950359',
                                                                                                                  'in_ucast_pkts': '42040434',
                                                                                                                  'out_octets': '885586897',
                                                                                                                  'out_ucast_pkts': '7798182',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3ZTIzSURpbnRm'},
                                                                                                          {       'in_octets': '1287323620',
                                                                                                                  'in_ucast_pkts': '1314233294',
                                                                                                                  'out_octets': '1316704552',
                                                                                                                  'out_ucast_pkts': '308749400',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3M2E2SURpbnRm'},
                                                                                                          {       'in_octets': '105695246',
                                                                                                                  'in_ucast_pkts': '255255',
                                                                                                                  'out_octets': '645010829',
                                                                                                                  'out_ucast_pkts': '573297',
                                                                                                                  'poller_hash': 'QURUTjIxNTM5YWYxSURpbnRm'},
                                                                                                          {       'in_octets': '138082959',
                                                                                                                  'in_ucast_pkts': '826219',
                                                                                                                  'out_octets': '1947579964',
                                                                                                                  'out_ucast_pkts': '4860805',
                                                                                                                  'poller_hash': 'QURUTjIyMjAxYTNhSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/3/3',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '30709018177',
                                                                                         'out_ucast_pkts': '1107876111',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA1ODE=',
                                                                                         'pons': [       {       'id': '300011',
                                                                                                                 'links': [       {       'connected_time': '6324996',
                                                                                                                                          'fiber_length': 7678,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwNDY1',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '6403739',
                                                                                                                                          'fiber_length': 5282,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwYmMw',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.3},
                                                                                                                                  {       'connected_time': '2340634',
                                                                                                                                          'fiber_length': 7112,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwOTg5',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.3}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA1ODF4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '300003',
                                                                                                                 'links': [       {       'connected_time': '6138711',
                                                                                                                                          'fiber_length': 6863,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU0YzAw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '4041282',
                                                                                                                                          'fiber_length': 4777,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNGNm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '5449091',
                                                                                                                                          'fiber_length': 6774,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNTM3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '506698',
                                                                                                                                          'fiber_length': 5178,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3NDg0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '2315642',
                                                                                                                                          'fiber_length': 5875,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNTQz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '6125251',
                                                                                                                                          'fiber_length': 6176,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU0YmZl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '5449969',
                                                                                                                                          'fiber_length': 6983,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQ0OGFh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '5450710',
                                                                                                                                          'fiber_length': 8152,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU1NDc0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '506644',
                                                                                                                                          'fiber_length': 7748,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU1MTBl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '4904652',
                                                                                                                                          'fiber_length': 7731,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU1NDM2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '4824344',
                                                                                                                                          'fiber_length': 6721,
                                                                                                                                          'poller_hash': 'QURUTjIxMTU5Yzk0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '85583',
                                                                                                                                          'fiber_length': 7190,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3ZTIz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '4235765',
                                                                                                                                          'fiber_length': 7938,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3M2E2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '2684087',
                                                                                                                                          'fiber_length': 7390,
                                                                                                                                          'poller_hash': 'QURUTjIxNTM5YWYx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2},
                                                                                                                                  {       'connected_time': '1278383',
                                                                                                                                          'fiber_length': 7947,
                                                                                                                                          'poller_hash': 'QURUTjIyMjAxYTNh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -27.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.2}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA1ODFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '300012/300004',
                                                                                         'in_discards': '12',
                                                                                         'in_octets': '12536975933',
                                                                                         'in_ucast_pkts': '999789857',
                                                                                         'links': [       {       'in_octets': '2626956591',
                                                                                                                  'in_ucast_pkts': '5490738',
                                                                                                                  'out_octets': '243115196',
                                                                                                                  'out_ucast_pkts': '2064533',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwNDQ1SURpbnRm'},
                                                                                                          {       'in_octets': '1051587215',
                                                                                                                  'in_ucast_pkts': '38514299',
                                                                                                                  'out_octets': '2350221853',
                                                                                                                  'out_ucast_pkts': '18096697',
                                                                                                                  'poller_hash': 'QURUTjIxMTYwMmM1SURpbnRm'},
                                                                                                          {       'in_octets': '46271025',
                                                                                                                  'in_ucast_pkts': '278302',
                                                                                                                  'out_octets': '2051983686',
                                                                                                                  'out_ucast_pkts': '1548517',
                                                                                                                  'poller_hash': 'QURUTjIyNDU1MGM5SURpbnRm'},
                                                                                                          {       'in_octets': '603331261',
                                                                                                                  'in_ucast_pkts': '6024302',
                                                                                                                  'out_octets': '2897701156',
                                                                                                                  'out_ucast_pkts': '25983995',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNTNjSURpbnRm'},
                                                                                                          {       'in_octets': '270764455',
                                                                                                                  'in_ucast_pkts': '425674',
                                                                                                                  'out_octets': '662833670',
                                                                                                                  'out_ucast_pkts': '686199',
                                                                                                                  'poller_hash': 'QURUTjIyNDU0YzIwSURpbnRm'},
                                                                                                          {       'in_octets': '12390201',
                                                                                                                  'in_ucast_pkts': '133294',
                                                                                                                  'out_octets': '832176665',
                                                                                                                  'out_ucast_pkts': '624098',
                                                                                                                  'poller_hash': 'QURUTjIyNDU0ZWIySURpbnRm'},
                                                                                                          {       'in_octets': '299338592',
                                                                                                                  'in_ucast_pkts': '1100147',
                                                                                                                  'out_octets': '2266535',
                                                                                                                  'out_ucast_pkts': '3519646',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNGVkSURpbnRm'},
                                                                                                          {       'in_octets': '971265863',
                                                                                                                  'in_ucast_pkts': '7049660',
                                                                                                                  'out_octets': '2905803009',
                                                                                                                  'out_ucast_pkts': '15292088',
                                                                                                                  'poller_hash': 'QURUTjIyNDU1NDg3SURpbnRm'},
                                                                                                          {       'in_octets': '2789598257',
                                                                                                                  'in_ucast_pkts': '289505089',
                                                                                                                  'out_octets': '3541291000',
                                                                                                                  'out_ucast_pkts': '108471093',
                                                                                                                  'poller_hash': 'QURUTjIxMTI3YjVmSURpbnRm'},
                                                                                                          {       'in_octets': '308872130',
                                                                                                                  'in_ucast_pkts': '3038721',
                                                                                                                  'out_octets': '2518152756',
                                                                                                                  'out_ucast_pkts': '7933835',
                                                                                                                  'poller_hash': 'QURUTjIyNDUzNTQ0SURpbnRm'},
                                                                                                          {       'in_octets': '15432752',
                                                                                                                  'in_ucast_pkts': '122831',
                                                                                                                  'out_octets': '39377457',
                                                                                                                  'out_ucast_pkts': '116747',
                                                                                                                  'poller_hash': 'QURUTjIyNDUxZDI5SURpbnRm'},
                                                                                                          {       'in_octets': '336475872',
                                                                                                                  'in_ucast_pkts': '266991',
                                                                                                                  'out_octets': '69799369',
                                                                                                                  'out_ucast_pkts': '158399',
                                                                                                                  'poller_hash': 'QURUTjIxNTQ0OGE1SURpbnRm'},
                                                                                                          {       'in_octets': '1128593281',
                                                                                                                  'in_ucast_pkts': '16641334',
                                                                                                                  'out_octets': '969953945',
                                                                                                                  'out_ucast_pkts': '9800382',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODZlSURpbnRm'},
                                                                                                          {       'in_octets': '61913625',
                                                                                                                  'in_ucast_pkts': '257062',
                                                                                                                  'out_octets': '1597525886',
                                                                                                                  'out_ucast_pkts': '1323492',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNGY2SURpbnRm'},
                                                                                                          {       'in_octets': '195396964',
                                                                                                                  'in_ucast_pkts': '286468576',
                                                                                                                  'out_octets': '4139125515',
                                                                                                                  'out_ucast_pkts': '53352269',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2ODNiSURpbnRm'},
                                                                                                          {       'in_octets': '320944048',
                                                                                                                  'in_ucast_pkts': '523262',
                                                                                                                  'out_octets': '847740112',
                                                                                                                  'out_ucast_pkts': '752455',
                                                                                                                  'poller_hash': 'QURUTjIyMDcyZTExSURpbnRm'},
                                                                                                          {       'in_octets': '1249657293',
                                                                                                                  'in_ucast_pkts': '343451977',
                                                                                                                  'out_octets': '2515108610',
                                                                                                                  'out_ucast_pkts': '139982615',
                                                                                                                  'poller_hash': 'QURUTjIxMDg2OGI5SURpbnRm'},
                                                                                                          {       'in_discards': '12',
                                                                                                                  'in_octets': '248186508',
                                                                                                                  'in_ucast_pkts': '497598',
                                                                                                                  'out_octets': '2692519000',
                                                                                                                  'out_ucast_pkts': '1940992',
                                                                                                                  'poller_hash': 'QURUTjIyMDcyZTc4SURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/3/4',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '30876695420',
                                                                                         'out_ucast_pkts': '391648052',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDEyMzE=',
                                                                                         'pons': [       {       'id': '300012',
                                                                                                                 'links': [       {       'connected_time': '16406',
                                                                                                                                          'fiber_length': 8893,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwNDQ1',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -20.4,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.7},
                                                                                                                                  {       'connected_time': '249843',
                                                                                                                                          'fiber_length': 8866,
                                                                                                                                          'poller_hash': 'QURUTjIxMTYwMmM1',
                                                                                                                                          'rx_link_rate': '10000000000',
                                                                                                                                          'rx_power': -21.0,
                                                                                                                                          'tx_link_rate': '10000000000',
                                                                                                                                          'tx_power': 5.7}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDEyMzF4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '300004',
                                                                                                                 'links': [       {       'connected_time': '713175',
                                                                                                                                          'fiber_length': 9319,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU1MGM5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '5165499',
                                                                                                                                          'fiber_length': 9486,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNTNj',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '5165498',
                                                                                                                                          'fiber_length': 7940,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU0YzIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '227005',
                                                                                                                                          'fiber_length': 9020,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU0ZWIy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '5165499',
                                                                                                                                          'fiber_length': 8451,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNGVk',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -28.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '587888',
                                                                                                                                          'fiber_length': 9511,
                                                                                                                                          'poller_hash': 'QURUTjIyNDU1NDg3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -22.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '6144118',
                                                                                                                                          'fiber_length': 8067,
                                                                                                                                          'poller_hash': 'QURUTjIxMTI3YjVm',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '520435',
                                                                                                                                          'fiber_length': 8507,
                                                                                                                                          'poller_hash': 'QURUTjIyNDUzNTQ0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '5104217',
                                                                                                                                          'fiber_length': 8518,
                                                                                                                                          'poller_hash': 'QURUTjIyNDUxZDI5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '5087140',
                                                                                                                                          'fiber_length': 8196,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQ0OGE1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '4849990',
                                                                                                                                          'fiber_length': 8458,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODZl',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '4834418',
                                                                                                                                          'fiber_length': 8735,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNGY2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '1286339',
                                                                                                                                          'fiber_length': 8913,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2ODNi',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '1304193',
                                                                                                                                          'fiber_length': 9126,
                                                                                                                                          'poller_hash': 'QURUTjIyMDcyZTEx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '2225856',
                                                                                                                                          'fiber_length': 8730,
                                                                                                                                          'poller_hash': 'QURUTjIxMDg2OGI5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8},
                                                                                                                                  {       'connected_time': '950522',
                                                                                                                                          'fiber_length': 8331,
                                                                                                                                          'poller_hash': 'QURUTjIyMDcyZTc4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.8}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDEyMzFncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '300013/300005',
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/3/5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAxNDM=',
                                                                                         'pons': [       {       'id': '300013',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAxNDN4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '300005',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAxNDNncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '300014/300006',
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/3/6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA2NjA=',
                                                                                         'pons': [       {       'id': '300014',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA2NjB4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '300006',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA2NjBncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '300015/300007',
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/3/7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA5ODU=',
                                                                                         'pons': [       {       'id': '300015',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA5ODV4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '300007',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA5ODVncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208},
                                                                                 {       'admin_up': True,
                                                                                         'id': '300016/300008',
                                                                                         'in_octets': '93354801',
                                                                                         'in_ucast_pkts': '442582',
                                                                                         'links': [       {       'in_octets': '59896415',
                                                                                                                  'in_ucast_pkts': '349550',
                                                                                                                  'out_octets': '67647932',
                                                                                                                  'out_ucast_pkts': '214067',
                                                                                                                  'poller_hash': 'QURUTjIxMTVhMWQySURpbnRm'},
                                                                                                          {       'poller_hash': 'QURUTjIwMjUyNjQzSURpbnRm'},
                                                                                                          {       'in_octets': '33458386',
                                                                                                                  'in_ucast_pkts': '93032',
                                                                                                                  'out_octets': '141819714',
                                                                                                                  'out_ucast_pkts': '148971',
                                                                                                                  'poller_hash': 'QURUTjIxNTQyNTNhSURpbnRm'}],
                                                                                         'manufacturer': 'Adtran',
                                                                                         'model': '1442543F2',
                                                                                         'name': 'gpon '
                                                                                                 '1/3/8',
                                                                                         'oper_up': True,
                                                                                         'out_octets': '209467646',
                                                                                         'out_ucast_pkts': '363038',
                                                                                         'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAxODA=',
                                                                                         'pons': [       {       'id': '300016',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAxODB4Z3Nwb24=',
                                                                                                                 'pon_technology': 'XGS_PON',
                                                                                                                 'rx_link_rate': '10000000000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '10000000000'},
                                                                                                         {       'id': '300008',
                                                                                                                 'links': [       {       'connected_time': '1446155',
                                                                                                                                          'fiber_length': 53,
                                                                                                                                          'poller_hash': 'QURUTjIxMTVhMWQy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '7609576',
                                                                                                                                          'fiber_length': 58,
                                                                                                                                          'poller_hash': 'QURUTjIwMjUyNjQz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0},
                                                                                                                                  {       'connected_time': '2161778',
                                                                                                                                          'fiber_length': 1296,
                                                                                                                                          'poller_hash': 'QURUTjIxNTQyNTNh',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 5.0}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -7.0,
                                                                                                                 'minimum_loss': -30.0,
                                                                                                                 'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAxODBncG9u',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 128,
                                                                                                                 'tx_link_rate': '2488320000'}],
                                                                                         'type': 208}],
                                                           'manufacturer': 'Adtran',
                                                           'mem': 30.401611,
                                                           'model': '1187518F1',
                                                           'name': 'COMBO OLT 8P',
                                                           'poller_hash': 'TEJBRFROMjEyOUNFMDEyMTE4NzUxOEYx',
                                                           'serial_number': 'LBADTN2129CE012',
                                                           'sw_version': '11.1.5.4.11',
                                                           'temperature': 33.0,
                                                           'uptime': '14648254'}],
                                'poller_hash': 'TEJBRFROMjExMkFNMjAy',
                                'serial_number': 'LBADTN2112AM202',
                                'sw_version': '11.1.5.4',
                                'system_mac_address': '00:24:45:e8:52:fb'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627654144',
                                                                       'in_octets': '1779802548',
                                                                       'in_ucast_pkts': '3261292',
                                                                       'links': [       {       'in_octets': '1779802548',
                                                                                                'in_ucast_pkts': '3261292',
                                                                                                'out_octets': '1365474021',
                                                                                                'out_ucast_pkts': '6080035',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159d83, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '1365474021',
                                                                       'out_ucast_pkts': '6080035',
                                                                       'poller_hash': 'QURUTjIxMTU5ZDgzSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '105009',
                                                                                                                        'fiber_length': 878,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5ZDgz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:b1:5d',
                                                                                                        '0:24:45:fd:b1:5e'],
                                                                       'id': '1627654785',
                                                                       'in_octets': '1365474021',
                                                                       'in_ucast_pkts': '6080035',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '1779802548',
                                                                       'out_ucast_pkts': '3261292',
                                                                       'poller_hash': 'QURUTjIxMTU5ZDgzVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '2@1/1/1',
                                         'poller_hash': 'QURUTjIxMTU5ZDgzU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159d83',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '105009'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627655168',
                                                                       'in_octets': '3246810263',
                                                                       'in_ucast_pkts': '375179324',
                                                                       'links': [       {       'in_octets': '3246810263',
                                                                                                'in_ucast_pkts': '375179324',
                                                                                                'out_octets': '3972438052',
                                                                                                'out_ucast_pkts': '836682911',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21127b67, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3972438052',
                                                                       'out_ucast_pkts': '836682911',
                                                                       'poller_hash': 'QURUTjIxMTI3YjY3SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '4557848',
                                                                                                                        'fiber_length': 1193,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTI3YjY3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1627655233',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'QURUTjIxMTI3YjY3RXRoaW50Zg=='},
                                                               {       'admin_up': True,
                                                                       'id': '1627655297',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(POTS)',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTI3YjY3UE9UU2ludGY='},
                                                               {       'admin_up': True,
                                                                       'id': '1627655298',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '2 '
                                                                               '(POTS)',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'QURUTjIxMTI3YjY3UE9UU2ludGY='},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:eb:54:84',
                                                                                                        '0:24:45:eb:54:85'],
                                                                       'id': '1627655809',
                                                                       'in_octets': '3972438052',
                                                                       'in_ucast_pkts': '836682911',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3246810263',
                                                                       'out_ucast_pkts': '375179324',
                                                                       'poller_hash': 'QURUTjIxMTI3YjY3VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '3@1/1/1',
                                         'poller_hash': 'QURUTjIxMTI3YjY3U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21127b67',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.4_9f48b',
                                         'uptime': '4557848'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627656192',
                                                                       'in_octets': '3294917693',
                                                                       'in_ucast_pkts': '38494507',
                                                                       'links': [       {       'in_octets': '3294917693',
                                                                                                'in_ucast_pkts': '38494507',
                                                                                                'out_octets': '2824564808',
                                                                                                'out_ucast_pkts': '88973409',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159caf, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2824564808',
                                                                       'out_ucast_pkts': '88973409',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2FmSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '431208',
                                                                                                                        'fiber_length': 1067,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.9,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5Y2Fm',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:a4:f1',
                                                                                                        '0:24:45:fd:a4:f2'],
                                                                       'id': '1627656833',
                                                                       'in_octets': '2824564808',
                                                                       'in_ucast_pkts': '88973409',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3294917693',
                                                                       'out_ucast_pkts': '38494507',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2FmVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '4@1/1/1',
                                         'poller_hash': 'QURUTjIxMTU5Y2FmU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159caf',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '431208'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627657216',
                                                                       'in_octets': '1903936003',
                                                                       'in_ucast_pkts': '32784751',
                                                                       'links': [       {       'in_octets': '1903936003',
                                                                                                'in_ucast_pkts': '32784751',
                                                                                                'out_octets': '2054237198',
                                                                                                'out_ucast_pkts': '110764207',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2115a1f1, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2054237198',
                                                                       'out_ucast_pkts': '110764207',
                                                                       'poller_hash': 'QURUTjIxMTVhMWYxSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '635330',
                                                                                                                        'fiber_length': 994,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.8,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTVhMWYx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:f3:cf',
                                                                                                        '0:24:45:fd:f3:d0'],
                                                                       'id': '1627657857',
                                                                       'in_octets': '2054237198',
                                                                       'in_ucast_pkts': '110764207',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '1903936003',
                                                                       'out_ucast_pkts': '32784751',
                                                                       'poller_hash': 'QURUTjIxMTVhMWYxVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '5@1/1/1',
                                         'poller_hash': 'QURUTjIxMTVhMWYxU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2115a1f1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '635330'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627658240',
                                                                       'in_octets': '3386635748',
                                                                       'in_ucast_pkts': '1408055172',
                                                                       'links': [       {       'in_octets': '3386635748',
                                                                                                'in_ucast_pkts': '1408055172',
                                                                                                'out_octets': '3923047497',
                                                                                                'out_ucast_pkts': '2705921909',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21086912, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3923047497',
                                                                       'out_ucast_pkts': '2705921909',
                                                                       'poller_hash': 'QURUTjIxMDg2OTEySURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '10366092',
                                                                                                                        'fiber_length': 1015,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.1,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2OTEy',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:89:53',
                                                                                                        '0:24:45:dd:89:54'],
                                                                       'id': '1627658881',
                                                                       'in_octets': '3923047497',
                                                                       'in_ucast_pkts': '2705921909',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3386635748',
                                                                       'out_ucast_pkts': '1408055172',
                                                                       'poller_hash': 'QURUTjIxMDg2OTEyVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '6@1/1/1',
                                         'poller_hash': 'QURUTjIxMDg2OTEyU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21086912',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '10366092'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627659264',
                                                                       'in_octets': '3356820565',
                                                                       'in_ucast_pkts': '405340453',
                                                                       'links': [       {       'in_octets': '3356820565',
                                                                                                'in_ucast_pkts': '405340453',
                                                                                                'out_octets': '780766106',
                                                                                                'out_ucast_pkts': '1647971791',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159e06, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '780766106',
                                                                       'out_ucast_pkts': '1647971791',
                                                                       'poller_hash': 'QURUTjIxMTU5ZTA2SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '7607102',
                                                                                                                        'fiber_length': 1409,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.1,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5ZTA2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:b9:a',
                                                                                                        '0:24:45:fd:b9:b'],
                                                                       'id': '1627659905',
                                                                       'in_octets': '780766106',
                                                                       'in_ucast_pkts': '1647971791',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3356820565',
                                                                       'out_ucast_pkts': '405340453',
                                                                       'poller_hash': 'QURUTjIxMTU5ZTA2VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '7@1/1/1',
                                         'poller_hash': 'QURUTjIxMTU5ZTA2U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159e06',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '7607102'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627661312',
                                                                       'in_octets': '2229833624',
                                                                       'in_ucast_pkts': '560401066',
                                                                       'links': [       {       'in_octets': '2229833624',
                                                                                                'in_ucast_pkts': '560401066',
                                                                                                'out_octets': '2826128251',
                                                                                                'out_ucast_pkts': '1454744477',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21127059, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2826128251',
                                                                       'out_ucast_pkts': '1454744477',
                                                                       'poller_hash': 'QURUTjIxMTI3MDU5SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2758560',
                                                                                                                        'fiber_length': 1025,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTI3MDU5',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:ea:ae:b2',
                                                                                                        '0:24:45:ea:ae:b3'],
                                                                       'id': '1627661953',
                                                                       'in_octets': '2826128251',
                                                                       'in_ucast_pkts': '1454744477',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2229833624',
                                                                       'out_ucast_pkts': '560401066',
                                                                       'poller_hash': 'QURUTjIxMTI3MDU5VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '9@1/1/1',
                                         'poller_hash': 'QURUTjIxMTI3MDU5U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21127059',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '2758560'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627662336',
                                                                       'in_octets': '3131383287',
                                                                       'in_ucast_pkts': '8937322',
                                                                       'links': [       {       'in_octets': '3131383287',
                                                                                                'in_ucast_pkts': '8937322',
                                                                                                'out_octets': '2054069976',
                                                                                                'out_ucast_pkts': '4888106',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '10, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21544de7, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2054069976',
                                                                       'out_ucast_pkts': '4888106',
                                                                       'poller_hash': 'QURUTjIxNTQ0ZGU3SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '9076405',
                                                                                                                        'fiber_length': 988,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.8,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.2}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxNTQ0ZGU3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:22:54:56:d8:b4'],
                                                                       'id': '1627662401',
                                                                       'in_octets': '2054069976',
                                                                       'in_ucast_pkts': '4888106',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '1, '
                                                                               'ONT: '
                                                                               '10, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3131383287',
                                                                       'out_ucast_pkts': '8937322',
                                                                       'poller_hash': 'QURUTjIxNTQ0ZGU3RXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '611 2ND GEND GPON SFU ONT (NA)',
                                         'name': '10@1/1/1',
                                         'poller_hash': 'QURUTjIxNTQ0ZGU3NjExIDJORCBHRU5EIEdQT04gU0ZVIE9OVCAoTkEp',
                                         'serial_number': 'ADTN21544de7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V2.3.8',
                                         'uptime': '9076405'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627915264',
                                                                       'in_octets': '2117238148',
                                                                       'in_ucast_pkts': '4584159',
                                                                       'links': [       {       'in_octets': '2117238148',
                                                                                                'in_ucast_pkts': '4584159',
                                                                                                'out_octets': '256147846',
                                                                                                'out_ucast_pkts': '2212126',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN211040c8, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '256147846',
                                                                       'out_ucast_pkts': '2212126',
                                                                       'poller_hash': 'QURUTjIxMTA0MGM4SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '6383350',
                                                                                                                        'fiber_length': 630,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.3,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.7}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTA0MGM4',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:ec:5e:1a:d5:be'],
                                                                       'id': '1627915329',
                                                                       'in_octets': '256147846',
                                                                       'in_ucast_pkts': '2212126',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2117238148',
                                                                       'out_ucast_pkts': '4584159',
                                                                       'poller_hash': 'QURUTjIxMTA0MGM4RXRoaW50Zg==',
                                                                       'speed': '100000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '401 4th GEN INDOOR SFU 1GE',
                                         'name': '1@1/1/2',
                                         'poller_hash': 'QURUTjIxMTA0MGM4NDAxIDR0aCBHRU4gSU5ET09SIFNGVSAxR0U=',
                                         'serial_number': 'ADTN211040c8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M1',
                                         'uptime': '6383350'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627916288',
                                                                       'in_octets': '3610621334',
                                                                       'in_ucast_pkts': '649104525',
                                                                       'links': [       {       'in_octets': '3610621334',
                                                                                                'in_ucast_pkts': '649104525',
                                                                                                'out_octets': '4207496292',
                                                                                                'out_ucast_pkts': '1365341085',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN210868ef, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '4207496292',
                                                                       'out_ucast_pkts': '1365341085',
                                                                       'poller_hash': 'QURUTjIxMDg2OGVmSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2228517',
                                                                                                                        'fiber_length': 632,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2OGVm',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:87:46',
                                                                                                        '0:24:45:dd:87:47'],
                                                                       'id': '1627916929',
                                                                       'in_octets': '4207496292',
                                                                       'in_ucast_pkts': '1365341085',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3610621334',
                                                                       'out_ucast_pkts': '649104525',
                                                                       'poller_hash': 'QURUTjIxMDg2OGVmVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '2@1/1/2',
                                         'poller_hash': 'QURUTjIxMDg2OGVmU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN210868ef',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '2228517'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627917312',
                                                                       'in_octets': '2087609296',
                                                                       'in_ucast_pkts': '1717146',
                                                                       'links': [       {       'in_octets': '2087609296',
                                                                                                'in_ucast_pkts': '1717146',
                                                                                                'out_octets': '157559742',
                                                                                                'out_ucast_pkts': '818974',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21103f90, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '157559742',
                                                                       'out_ucast_pkts': '818974',
                                                                       'poller_hash': 'QURUTjIxMTAzZjkwSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '145884',
                                                                                                                        'fiber_length': 691,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.7}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTAzZjkw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:e0:7e:b1',
                                                                                                        '6c:cd:d6:1a:9a:84'],
                                                                       'id': '1627917377',
                                                                       'in_octets': '157559742',
                                                                       'in_ucast_pkts': '818974',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2087609296',
                                                                       'out_ucast_pkts': '1717146',
                                                                       'poller_hash': 'QURUTjIxMTAzZjkwRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '401 4th GEN INDOOR SFU 1GE',
                                         'name': '3@1/1/2',
                                         'poller_hash': 'QURUTjIxMTAzZjkwNDAxIDR0aCBHRU4gSU5ET09SIFNGVSAxR0U=',
                                         'serial_number': 'ADTN21103f90',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M1',
                                         'uptime': '145884'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627918336',
                                                                       'in_octets': '748712539',
                                                                       'in_ucast_pkts': '3004137',
                                                                       'links': [       {       'in_octets': '748712539',
                                                                                                'in_ucast_pkts': '3004137',
                                                                                                'out_octets': '3939610357',
                                                                                                'out_ucast_pkts': '21750385',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21127e54, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3939610357',
                                                                       'out_ucast_pkts': '21750385',
                                                                       'poller_hash': 'QURUTjIxMTI3ZTU0SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '140509',
                                                                                                                        'fiber_length': 817,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTI3ZTU0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:eb:80:67',
                                                                                                        '0:24:45:eb:80:68'],
                                                                       'id': '1627918977',
                                                                       'in_octets': '3939610357',
                                                                       'in_ucast_pkts': '21750385',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '748712539',
                                                                       'out_ucast_pkts': '3004137',
                                                                       'poller_hash': 'QURUTjIxMTI3ZTU0VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '4@1/1/2',
                                         'poller_hash': 'QURUTjIxMTI3ZTU0U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21127e54',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '140509'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627919360',
                                                                       'in_octets': '3537751456',
                                                                       'in_ucast_pkts': '2449907',
                                                                       'links': [       {       'in_octets': '3537751456',
                                                                                                'in_ucast_pkts': '2449907',
                                                                                                'out_octets': '46801652',
                                                                                                'out_ucast_pkts': '312280',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2109c435, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '46801652',
                                                                       'out_ucast_pkts': '312280',
                                                                       'poller_hash': 'QURUTjIxMDljNDM1SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '1553223',
                                                                                                                        'fiber_length': 621,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.3,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDljNDM1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '18:fd:74:13:b4:31'],
                                                                       'id': '1627919425',
                                                                       'in_octets': '46801652',
                                                                       'in_ucast_pkts': '312280',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3537751456',
                                                                       'out_ucast_pkts': '2449907',
                                                                       'poller_hash': 'QURUTjIxMDljNDM1RXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '611 2ND GEND GPON SFU ONT (NA)',
                                         'name': '5@1/1/2',
                                         'poller_hash': 'QURUTjIxMDljNDM1NjExIDJORCBHRU5EIEdQT04gU0ZVIE9OVCAoTkEp',
                                         'serial_number': 'ADTN2109c435',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V2.3.6',
                                         'uptime': '1553223'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627920384',
                                                                       'in_octets': '4223549512',
                                                                       'in_ucast_pkts': '162423516',
                                                                       'links': [       {       'in_octets': '4223549512',
                                                                                                'in_ucast_pkts': '162423516',
                                                                                                'out_octets': '1713366898',
                                                                                                'out_ucast_pkts': '722799456',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2108691c, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '1713366898',
                                                                       'out_ucast_pkts': '722799456',
                                                                       'poller_hash': 'QURUTjIxMDg2OTFjSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '7762038',
                                                                                                                        'fiber_length': 888,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2OTFj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:89:e9',
                                                                                                        '0:24:45:dd:89:ea'],
                                                                       'id': '1627921025',
                                                                       'in_octets': '1713366898',
                                                                       'in_ucast_pkts': '722799456',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '4223549512',
                                                                       'out_ucast_pkts': '162423516',
                                                                       'poller_hash': 'QURUTjIxMDg2OTFjVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '6@1/1/2',
                                         'poller_hash': 'QURUTjIxMDg2OTFjU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2108691c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '7762038'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627921408',
                                                                       'in_octets': '1962905427',
                                                                       'in_ucast_pkts': '35256619',
                                                                       'links': [       {       'in_octets': '1962905427',
                                                                                                'in_ucast_pkts': '35256619',
                                                                                                'out_octets': '3135833777',
                                                                                                'out_ucast_pkts': '107051190',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21127391, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3135833777',
                                                                       'out_ucast_pkts': '107051190',
                                                                       'poller_hash': 'QURUTjIxMTI3MzkxSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2079401',
                                                                                                                        'fiber_length': 900,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTI3Mzkx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:ea:de:fa',
                                                                                                        '0:24:45:ea:de:fb'],
                                                                       'id': '1627922049',
                                                                       'in_octets': '3135833777',
                                                                       'in_ucast_pkts': '107051190',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '1962905427',
                                                                       'out_ucast_pkts': '35256619',
                                                                       'poller_hash': 'QURUTjIxMTI3MzkxVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '7@1/1/2',
                                         'poller_hash': 'QURUTjIxMTI3MzkxU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21127391',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '2079401'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627922432',
                                                                       'in_octets': '2375516922',
                                                                       'in_ucast_pkts': '123746376',
                                                                       'links': [       {       'in_octets': '2375516922',
                                                                                                'in_ucast_pkts': '123746376',
                                                                                                'out_octets': '291078244',
                                                                                                'out_ucast_pkts': '612880385',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '8, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21086901, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '291078244',
                                                                       'out_ucast_pkts': '612880385',
                                                                       'poller_hash': 'QURUTjIxMDg2OTAxSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '1638645',
                                                                                                                        'fiber_length': 696,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.1,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2OTAx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:88:54',
                                                                                                        '0:24:45:dd:88:55'],
                                                                       'id': '1627923073',
                                                                       'in_octets': '291078244',
                                                                       'in_ucast_pkts': '612880385',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '8, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2375516922',
                                                                       'out_ucast_pkts': '123746376',
                                                                       'poller_hash': 'QURUTjIxMDg2OTAxVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '8@1/1/2',
                                         'poller_hash': 'QURUTjIxMDg2OTAxU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21086901',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '1638645'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627923456',
                                                                       'in_octets': '2722444528',
                                                                       'in_ucast_pkts': '35637476',
                                                                       'links': [       {       'in_octets': '2722444528',
                                                                                                'in_ucast_pkts': '35637476',
                                                                                                'out_octets': '2345744495',
                                                                                                'out_ucast_pkts': '125539151',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21086915, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2345744495',
                                                                       'out_ucast_pkts': '125539151',
                                                                       'poller_hash': 'QURUTjIxMDg2OTE1SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '277337',
                                                                                                                        'fiber_length': 913,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2OTE1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:89:80',
                                                                                                        '0:24:45:dd:89:81'],
                                                                       'id': '1627924097',
                                                                       'in_octets': '2345744495',
                                                                       'in_ucast_pkts': '125539151',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2722444528',
                                                                       'out_ucast_pkts': '35637476',
                                                                       'poller_hash': 'QURUTjIxMDg2OTE1VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '9@1/1/2',
                                         'poller_hash': 'QURUTjIxMDg2OTE1U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21086915',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '277337'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1627924480',
                                                                       'in_octets': '30767518',
                                                                       'in_ucast_pkts': '210793',
                                                                       'links': [       {       'in_octets': '30767518',
                                                                                                'in_ucast_pkts': '210793',
                                                                                                'out_octets': '61861531',
                                                                                                'out_ucast_pkts': '168812',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '10, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN210867d5, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '61861531',
                                                                       'out_ucast_pkts': '168812',
                                                                       'poller_hash': 'QURUTjIxMDg2N2Q1SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '1903739',
                                                                                                                        'fiber_length': 767,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.3,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2N2Q1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:76:c0',
                                                                                                        '0:24:45:dd:76:c1'],
                                                                       'id': '1627925121',
                                                                       'in_octets': '61861531',
                                                                       'in_ucast_pkts': '168812',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '2, '
                                                                               'ONT: '
                                                                               '10, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '30767518',
                                                                       'out_ucast_pkts': '210793',
                                                                       'poller_hash': 'QURUTjIxMDg2N2Q1VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '10@1/1/2',
                                         'poller_hash': 'QURUTjIxMDg2N2Q1U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN210867d5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '1903739'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628177408',
                                                                       'in_octets': '399809239',
                                                                       'in_ucast_pkts': '36804635',
                                                                       'links': [       {       'in_octets': '399809239',
                                                                                                'in_ucast_pkts': '36804635',
                                                                                                'out_octets': '3166762223',
                                                                                                'out_ucast_pkts': '206639996',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN210867c3, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3166762223',
                                                                       'out_ucast_pkts': '206639996',
                                                                       'poller_hash': 'QURUTjIxMDg2N2MzSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '1469650',
                                                                                                                        'fiber_length': 959,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2N2Mz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:75:b2',
                                                                                                        '0:24:45:dd:75:b3'],
                                                                       'id': '1628178049',
                                                                       'in_octets': '3166762223',
                                                                       'in_ucast_pkts': '206639996',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '399809239',
                                                                       'out_ucast_pkts': '36804635',
                                                                       'poller_hash': 'QURUTjIxMDg2N2MzVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '1@1/1/3',
                                         'poller_hash': 'QURUTjIxMDg2N2MzU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN210867c3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '1469650'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628178432',
                                                                       'in_octets': '2890036044',
                                                                       'in_ucast_pkts': '239246106',
                                                                       'links': [       {       'in_octets': '2890036044',
                                                                                                'in_ucast_pkts': '239246106',
                                                                                                'out_octets': '580835182',
                                                                                                'out_ucast_pkts': '702733381',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159c91, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '580835182',
                                                                       'out_ucast_pkts': '702733381',
                                                                       'poller_hash': 'QURUTjIxMTU5YzkxSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2165757',
                                                                                                                        'fiber_length': 966,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5Yzkx',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:a3:2f',
                                                                                                        '0:24:45:fd:a3:30'],
                                                                       'id': '1628179073',
                                                                       'in_octets': '580835182',
                                                                       'in_ucast_pkts': '702733381',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2890036044',
                                                                       'out_ucast_pkts': '239246106',
                                                                       'poller_hash': 'QURUTjIxMTU5YzkxVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '2@1/1/3',
                                         'poller_hash': 'QURUTjIxMTU5YzkxU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159c91',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '2165757'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628179456',
                                                                       'in_octets': '4181143875',
                                                                       'in_ucast_pkts': '3201682',
                                                                       'links': [       {       'in_octets': '4181143875',
                                                                                                'in_ucast_pkts': '3201682',
                                                                                                'out_octets': '128193673',
                                                                                                'out_ucast_pkts': '589659',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2110406c, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '128193673',
                                                                       'out_ucast_pkts': '589659',
                                                                       'poller_hash': 'QURUTjIxMTA0MDZjSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '554757',
                                                                                                                        'fiber_length': 971,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTA0MDZj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:38:e0:a1:fc:2d'],
                                                                       'id': '1628179521',
                                                                       'in_octets': '128193673',
                                                                       'in_ucast_pkts': '589659',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '4181143875',
                                                                       'out_ucast_pkts': '3201682',
                                                                       'poller_hash': 'QURUTjIxMTA0MDZjRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '401 4th GEN INDOOR SFU 1GE',
                                         'name': '3@1/1/3',
                                         'poller_hash': 'QURUTjIxMTA0MDZjNDAxIDR0aCBHRU4gSU5ET09SIFNGVSAxR0U=',
                                         'serial_number': 'ADTN2110406c',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M1',
                                         'uptime': '554757'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628182528',
                                                                       'in_octets': '74855113',
                                                                       'in_ucast_pkts': '3332451',
                                                                       'links': [       {       'in_octets': '74855113',
                                                                                                'in_ucast_pkts': '3332451',
                                                                                                'out_octets': '130644645',
                                                                                                'out_ucast_pkts': '670048',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21103ffb, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '130644645',
                                                                       'out_ucast_pkts': '670048',
                                                                       'poller_hash': 'QURUTjIxMTAzZmZiSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '14648421',
                                                                                                                        'fiber_length': 804,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTAzZmZi',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:e0:7f:1c',
                                                                                                        '60:38:e0:72:b4:63'],
                                                                       'id': '1628182593',
                                                                       'in_octets': '130644645',
                                                                       'in_ucast_pkts': '670048',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '74855113',
                                                                       'out_ucast_pkts': '3332451',
                                                                       'poller_hash': 'QURUTjIxMTAzZmZiRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '401 4th GEN INDOOR SFU 1GE',
                                         'name': '6@1/1/3',
                                         'poller_hash': 'QURUTjIxMTAzZmZiNDAxIDR0aCBHRU4gSU5ET09SIFNGVSAxR0U=',
                                         'serial_number': 'ADTN21103ffb',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M1',
                                         'uptime': '14648421'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628183552',
                                                                       'in_octets': '322456680',
                                                                       'in_ucast_pkts': '34401096',
                                                                       'links': [       {       'in_octets': '322456680',
                                                                                                'in_ucast_pkts': '34401096',
                                                                                                'out_octets': '72060641',
                                                                                                'out_ucast_pkts': '126056593',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159f9b, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '72060641',
                                                                       'out_ucast_pkts': '126056593',
                                                                       'poller_hash': 'QURUTjIxMTU5ZjliSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '505541',
                                                                                                                        'fiber_length': 811,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5Zjli',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:d0:c5',
                                                                                                        '0:24:45:fd:d0:c6'],
                                                                       'id': '1628184193',
                                                                       'in_octets': '72060641',
                                                                       'in_ucast_pkts': '126056593',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '322456680',
                                                                       'out_ucast_pkts': '34401096',
                                                                       'poller_hash': 'QURUTjIxMTU5ZjliVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '7@1/1/3',
                                         'poller_hash': 'QURUTjIxMTU5ZjliU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159f9b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '505541'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628184576',
                                                                       'in_octets': '2615065054',
                                                                       'in_ucast_pkts': '24228302',
                                                                       'links': [       {       'in_octets': '2615065054',
                                                                                                'in_ucast_pkts': '24228302',
                                                                                                'out_octets': '2326691935',
                                                                                                'out_ucast_pkts': '130843210',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '8, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159d2f, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2326691935',
                                                                       'out_ucast_pkts': '130843210',
                                                                       'poller_hash': 'QURUTjIxMTU5ZDJmSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '667581',
                                                                                                                        'fiber_length': 892,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.3,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5ZDJm',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:ac:71',
                                                                                                        '0:24:45:fd:ac:72'],
                                                                       'id': '1628185217',
                                                                       'in_octets': '2326691935',
                                                                       'in_ucast_pkts': '130843210',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '8, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2615065054',
                                                                       'out_ucast_pkts': '24228302',
                                                                       'poller_hash': 'QURUTjIxMTU5ZDJmVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '8@1/1/3',
                                         'poller_hash': 'QURUTjIxMTU5ZDJmU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159d2f',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'D210316_56a57',
                                         'uptime': '667581'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628185600',
                                                                       'in_octets': '2118771443',
                                                                       'in_ucast_pkts': '208655854',
                                                                       'links': [       {       'in_octets': '2118771443',
                                                                                                'in_ucast_pkts': '208655854',
                                                                                                'out_octets': '1331440933',
                                                                                                'out_ucast_pkts': '598353108',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2115a11a, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '1331440933',
                                                                       'out_ucast_pkts': '598353108',
                                                                       'poller_hash': 'QURUTjIxMTVhMTFhSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2340973',
                                                                                                                        'fiber_length': 811,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.8,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTVhMTFh',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:e7:36',
                                                                                                        '0:24:45:fd:e7:37'],
                                                                       'id': '1628186241',
                                                                       'in_octets': '1331440933',
                                                                       'in_ucast_pkts': '598353108',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2118771443',
                                                                       'out_ucast_pkts': '208655854',
                                                                       'poller_hash': 'QURUTjIxMTVhMTFhVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '9@1/1/3',
                                         'poller_hash': 'QURUTjIxMTVhMTFhU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2115a11a',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '2340973'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628186624',
                                                                       'in_octets': '1238718410',
                                                                       'in_ucast_pkts': '179811805',
                                                                       'links': [       {       'in_octets': '1238718410',
                                                                                                'in_ucast_pkts': '179811805',
                                                                                                'out_octets': '4008547500',
                                                                                                'out_ucast_pkts': '401894837',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '10, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN210867ec, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '4008547500',
                                                                       'out_ucast_pkts': '401894837',
                                                                       'poller_hash': 'QURUTjIxMDg2N2VjSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '1705449',
                                                                                                                        'fiber_length': 616,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.3,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2N2Vj',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:78:19',
                                                                                                        '0:24:45:dd:78:1a'],
                                                                       'id': '1628187265',
                                                                       'in_octets': '4008547500',
                                                                       'in_ucast_pkts': '401894837',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '10, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '1238718410',
                                                                       'out_ucast_pkts': '179811805',
                                                                       'poller_hash': 'QURUTjIxMDg2N2VjVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '10@1/1/3',
                                         'poller_hash': 'QURUTjIxMDg2N2VjU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN210867ec',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '1705449'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628187648',
                                                                       'in_octets': '2968553162',
                                                                       'in_ucast_pkts': '536731325',
                                                                       'links': [       {       'in_octets': '2968553162',
                                                                                                'in_ucast_pkts': '536731325',
                                                                                                'out_octets': '3563677104',
                                                                                                'out_ucast_pkts': '1171094177',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '11, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21126e68, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3563677104',
                                                                       'out_ucast_pkts': '1171094177',
                                                                       'poller_hash': 'QURUTjIxMTI2ZTY4SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '1584825',
                                                                                                                        'fiber_length': 667,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTI2ZTY4',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:ea:91:93',
                                                                                                        '0:24:45:ea:91:94'],
                                                                       'id': '1628188289',
                                                                       'in_octets': '3563677104',
                                                                       'in_ucast_pkts': '1171094177',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '11, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2968553162',
                                                                       'out_ucast_pkts': '536731325',
                                                                       'poller_hash': 'QURUTjIxMTI2ZTY4VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '11@1/1/3',
                                         'poller_hash': 'QURUTjIxMTI2ZTY4U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21126e68',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '1584825'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628188672',
                                                                       'in_octets': '3705487754',
                                                                       'in_ucast_pkts': '2642769',
                                                                       'links': [       {       'in_octets': '3705487754',
                                                                                                'in_ucast_pkts': '2642769',
                                                                                                'out_octets': '52840336',
                                                                                                'out_ucast_pkts': '399280',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '12, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21544892, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '52840336',
                                                                       'out_ucast_pkts': '399280',
                                                                       'poller_hash': 'QURUTjIxNTQ0ODkySURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '8075325',
                                                                                                                        'fiber_length': 791,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.6}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxNTQ0ODky',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '48:4d:7e:f8:cf:ee',
                                                                                                        '70:85:c2:78:df:96'],
                                                                       'id': '1628188737',
                                                                       'in_octets': '52840336',
                                                                       'in_ucast_pkts': '399280',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '12, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3705487754',
                                                                       'out_ucast_pkts': '2642769',
                                                                       'poller_hash': 'QURUTjIxNTQ0ODkyRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '611 2ND GEND GPON SFU ONT (NA)',
                                         'name': '12@1/1/3',
                                         'poller_hash': 'QURUTjIxNTQ0ODkyNjExIDJORCBHRU5EIEdQT04gU0ZVIE9OVCAoTkEp',
                                         'serial_number': 'ADTN21544892',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V2.3.8',
                                         'uptime': '8075325'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628189696',
                                                                       'in_octets': '2486550545',
                                                                       'in_ucast_pkts': '102744755',
                                                                       'links': [       {       'in_octets': '2486550545',
                                                                                                'in_ucast_pkts': '102744755',
                                                                                                'out_octets': '327394807',
                                                                                                'out_ucast_pkts': '513627285',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '13, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159c93, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '327394807',
                                                                       'out_ucast_pkts': '513627285',
                                                                       'poller_hash': 'QURUTjIxMTU5YzkzSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '7596700',
                                                                                                                        'fiber_length': 1140,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDdncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5Yzkz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:a3:4d',
                                                                                                        '0:24:45:fd:a3:4e'],
                                                                       'id': '1628190337',
                                                                       'in_octets': '327394807',
                                                                       'in_ucast_pkts': '513627285',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '3, '
                                                                               'ONT: '
                                                                               '13, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2486550545',
                                                                       'out_ucast_pkts': '102744755',
                                                                       'poller_hash': 'QURUTjIxMTU5YzkzVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '13@1/1/3',
                                         'poller_hash': 'QURUTjIxMTU5YzkzU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159c93',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '7596700'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1630536704',
                                                                       'in_octets': '545829451',
                                                                       'in_ucast_pkts': '361951609',
                                                                       'links': [       {       'in_octets': '545829451',
                                                                                                'in_ucast_pkts': '361951609',
                                                                                                'out_octets': '621402296',
                                                                                                'out_ucast_pkts': '1565453108',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '12, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21160928, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '621402296',
                                                                       'out_ucast_pkts': '1565453108',
                                                                       'poller_hash': 'QURUTjIxMTYwOTI4SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '6742303',
                                                                                                                        'fiber_length': 451,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzF4Z3Nwb24=',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTYwOTI4',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'ac:13:9c:9:f9:75',
                                                                                                        'ac:13:9c:9:f9:76'],
                                                                       'id': '1630537345',
                                                                       'in_octets': '621402296',
                                                                       'in_ucast_pkts': '1565453108',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '12, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '545829451',
                                                                       'out_ucast_pkts': '361951609',
                                                                       'poller_hash': 'QURUTjIxMTYwOTI4VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 825-V6 XGSPON HGU - NA',
                                         'name': '1@1/1/12',
                                         'poller_hash': 'QURUTjIxMTYwOTI4U1JHIDgyNS1WNiBYR1NQT04gSEdVIC0gTkE=',
                                         'serial_number': 'ADTN21160928',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.4_9f48b',
                                         'uptime': '6742303'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628439552',
                                                                       'in_octets': '591052864',
                                                                       'in_ucast_pkts': '12257535',
                                                                       'links': [       {       'in_octets': '591052864',
                                                                                                'in_ucast_pkts': '12257535',
                                                                                                'out_octets': '398230200',
                                                                                                'out_ucast_pkts': '4249778',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21104050, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '398230200',
                                                                       'out_ucast_pkts': '4249778',
                                                                       'poller_hash': 'QURUTjIxMTA0MDUwSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2318416',
                                                                                                                        'fiber_length': 553,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTA0MDUw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1628439617',
                                                                       'in_octets': '398230200',
                                                                       'in_ucast_pkts': '4249778',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '591052864',
                                                                       'out_ucast_pkts': '12257535',
                                                                       'poller_hash': 'QURUTjIxMTA0MDUwRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '401 4th GEN INDOOR SFU 1GE',
                                         'name': '1@1/1/4',
                                         'poller_hash': 'QURUTjIxMTA0MDUwNDAxIDR0aCBHRU4gSU5ET09SIFNGVSAxR0U=',
                                         'serial_number': 'ADTN21104050',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M1',
                                         'uptime': '2318416'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628440576',
                                                                       'in_octets': '2691430940',
                                                                       'in_ucast_pkts': '145024782',
                                                                       'links': [       {       'in_octets': '2691430940',
                                                                                                'in_ucast_pkts': '145024782',
                                                                                                'out_octets': '4191762723',
                                                                                                'out_ucast_pkts': '414428979',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2115a20b, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '4191762723',
                                                                       'out_ucast_pkts': '414428979',
                                                                       'poller_hash': 'QURUTjIxMTVhMjBiSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2340225',
                                                                                                                        'fiber_length': 884,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.8,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTVhMjBi',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:f5:55',
                                                                                                        '0:24:45:fd:f5:56'],
                                                                       'id': '1628441217',
                                                                       'in_octets': '4191762723',
                                                                       'in_ucast_pkts': '414428979',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2691430940',
                                                                       'out_ucast_pkts': '145024782',
                                                                       'poller_hash': 'QURUTjIxMTVhMjBiVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '2@1/1/4',
                                         'poller_hash': 'QURUTjIxMTVhMjBiU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2115a20b',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '2340225'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628441600',
                                                                       'in_octets': '2241090953',
                                                                       'in_ucast_pkts': '186269014',
                                                                       'links': [       {       'in_octets': '2241090953',
                                                                                                'in_ucast_pkts': '186269014',
                                                                                                'out_octets': '2937786152',
                                                                                                'out_ucast_pkts': '567833095',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2115a216, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2937786152',
                                                                       'out_ucast_pkts': '567833095',
                                                                       'poller_hash': 'QURUTjIxMTVhMjE2SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '1695487',
                                                                                                                        'fiber_length': 809,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.3,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTVhMjE2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:f5:fa',
                                                                                                        '0:24:45:fd:f5:fb'],
                                                                       'id': '1628442241',
                                                                       'in_octets': '2937786152',
                                                                       'in_ucast_pkts': '567833095',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2241090953',
                                                                       'out_ucast_pkts': '186269014',
                                                                       'poller_hash': 'QURUTjIxMTVhMjE2VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '3@1/1/4',
                                         'poller_hash': 'QURUTjIxMTVhMjE2U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2115a216',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '1695487'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628442624',
                                                                       'in_octets': '3269906571',
                                                                       'in_ucast_pkts': '106721165',
                                                                       'links': [       {       'in_octets': '3269906571',
                                                                                                'in_ucast_pkts': '106721165',
                                                                                                'out_octets': '1973118173',
                                                                                                'out_ucast_pkts': '381933082',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159df3, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '1973118173',
                                                                       'out_ucast_pkts': '381933082',
                                                                       'poller_hash': 'QURUTjIxMTU5ZGYzSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '367302',
                                                                                                                        'fiber_length': 818,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5ZGYz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:b7:ed',
                                                                                                        '0:24:45:fd:b7:ee'],
                                                                       'id': '1628443265',
                                                                       'in_octets': '1973118173',
                                                                       'in_ucast_pkts': '381933082',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3269906571',
                                                                       'out_ucast_pkts': '106721165',
                                                                       'poller_hash': 'QURUTjIxMTU5ZGYzVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '4@1/1/4',
                                         'poller_hash': 'QURUTjIxMTU5ZGYzU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159df3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'D210316_56a57',
                                         'uptime': '367302'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628443648',
                                                                       'in_octets': '203278238',
                                                                       'in_ucast_pkts': '966178',
                                                                       'links': [       {       'in_octets': '203278238',
                                                                                                'in_ucast_pkts': '966178',
                                                                                                'out_octets': '3774186780',
                                                                                                'out_ucast_pkts': '2686933',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21127d4f, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3774186780',
                                                                       'out_ucast_pkts': '2686933',
                                                                       'poller_hash': 'QURUTjIxMTI3ZDRmSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '18233',
                                                                                                                        'fiber_length': 690,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -16.1,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTI3ZDRm',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:eb:71:1c',
                                                                                                        '0:24:45:eb:71:1d'],
                                                                       'id': '1628444289',
                                                                       'in_octets': '3774186780',
                                                                       'in_ucast_pkts': '2686933',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '203278238',
                                                                       'out_ucast_pkts': '966178',
                                                                       'poller_hash': 'QURUTjIxMTI3ZDRmVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '5@1/1/4',
                                         'poller_hash': 'QURUTjIxMTI3ZDRmU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21127d4f',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '18233'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628444672',
                                                                       'in_octets': '3511548089',
                                                                       'in_ucast_pkts': '32342991',
                                                                       'links': [       {       'in_octets': '3511548089',
                                                                                                'in_ucast_pkts': '32342991',
                                                                                                'out_octets': '3693400942',
                                                                                                'out_ucast_pkts': '63025355',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159e02, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3693400942',
                                                                       'out_ucast_pkts': '63025355',
                                                                       'poller_hash': 'QURUTjIxMTU5ZTAySURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '669789',
                                                                                                                        'fiber_length': 824,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5ZTAy',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:b8:ce',
                                                                                                        '0:24:45:fd:b8:cf'],
                                                                       'id': '1628445313',
                                                                       'in_octets': '3693400942',
                                                                       'in_ucast_pkts': '63025355',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3511548089',
                                                                       'out_ucast_pkts': '32342991',
                                                                       'poller_hash': 'QURUTjIxMTU5ZTAyVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '6@1/1/4',
                                         'poller_hash': 'QURUTjIxMTU5ZTAyU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159e02',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'D210316_56a57',
                                         'uptime': '669789'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628445696',
                                                                       'in_octets': '3865304874',
                                                                       'in_ucast_pkts': '117464207',
                                                                       'links': [       {       'in_octets': '3865304874',
                                                                                                'in_ucast_pkts': '117464207',
                                                                                                'out_octets': '2006536987',
                                                                                                'out_ucast_pkts': '345883603',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159cdf, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2006536987',
                                                                       'out_ucast_pkts': '345883603',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2RmSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '702330',
                                                                                                                        'fiber_length': 879,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5Y2Rm',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:a7:c1',
                                                                                                        '0:24:45:fd:a7:c2'],
                                                                       'id': '1628446337',
                                                                       'in_octets': '2006536987',
                                                                       'in_ucast_pkts': '345883603',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3865304874',
                                                                       'out_ucast_pkts': '117464207',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2RmVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '7@1/1/4',
                                         'poller_hash': 'QURUTjIxMTU5Y2RmU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159cdf',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'D210316_56a57',
                                         'uptime': '702330'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628446720',
                                                                       'in_octets': '2279570144',
                                                                       'in_ucast_pkts': '20462087',
                                                                       'links': [       {       'in_octets': '2279570144',
                                                                                                'in_ucast_pkts': '20462087',
                                                                                                'out_octets': '1538566564',
                                                                                                'out_ucast_pkts': '40277733',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '8, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2108685e, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '1538566564',
                                                                       'out_ucast_pkts': '40277733',
                                                                       'poller_hash': 'QURUTjIxMDg2ODVlSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '169779',
                                                                                                                        'fiber_length': 760,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2ODVl',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:7e:c7',
                                                                                                        '0:24:45:dd:7e:c8'],
                                                                       'id': '1628447361',
                                                                       'in_octets': '1538566564',
                                                                       'in_ucast_pkts': '40277733',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '8, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2279570144',
                                                                       'out_ucast_pkts': '20462087',
                                                                       'poller_hash': 'QURUTjIxMDg2ODVlVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '8@1/1/4',
                                         'poller_hash': 'QURUTjIxMDg2ODVlU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2108685e',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '169779'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628447744',
                                                                       'in_octets': '1309757476',
                                                                       'in_ucast_pkts': '4129107',
                                                                       'links': [       {       'in_octets': '1309757476',
                                                                                                'in_ucast_pkts': '4129107',
                                                                                                'out_octets': '454899627',
                                                                                                'out_ucast_pkts': '1873751',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21539b22, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '454899627',
                                                                       'out_ucast_pkts': '1873751',
                                                                       'poller_hash': 'QURUTjIxNTM5YjIySURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '13907947',
                                                                                                                        'fiber_length': 582,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.9,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxNTM5YjIy',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '9c:c9:eb:54:cf:46'],
                                                                       'id': '1628447809',
                                                                       'in_octets': '454899627',
                                                                       'in_ucast_pkts': '1873751',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '1309757476',
                                                                       'out_ucast_pkts': '4129107',
                                                                       'poller_hash': 'QURUTjIxNTM5YjIyRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '611 2ND GEND GPON SFU ONT (NA)',
                                         'name': '9@1/1/4',
                                         'poller_hash': 'QURUTjIxNTM5YjIyNjExIDJORCBHRU5EIEdQT04gU0ZVIE9OVCAoTkEp',
                                         'serial_number': 'ADTN21539b22',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V2.3.8',
                                         'uptime': '13907947'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628448768',
                                                                       'in_octets': '2752414599',
                                                                       'in_ucast_pkts': '2370937',
                                                                       'links': [       {       'in_octets': '2752414599',
                                                                                                'in_ucast_pkts': '2370937',
                                                                                                'out_octets': '532982149',
                                                                                                'out_ucast_pkts': '905958',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '10, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21539ae6, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '532982149',
                                                                       'out_ucast_pkts': '905958',
                                                                       'poller_hash': 'QURUTjIxNTM5YWU2SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '8822604',
                                                                                                                        'fiber_length': 716,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.3,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxNTM5YWU2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'cc:40:d0:76:32:ba'],
                                                                       'id': '1628448833',
                                                                       'in_octets': '532982149',
                                                                       'in_ucast_pkts': '905958',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '10, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2752414599',
                                                                       'out_ucast_pkts': '2370937',
                                                                       'poller_hash': 'QURUTjIxNTM5YWU2RXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '611 2ND GEND GPON SFU ONT (NA)',
                                         'name': '10@1/1/4',
                                         'poller_hash': 'QURUTjIxNTM5YWU2NjExIDJORCBHRU5EIEdQT04gU0ZVIE9OVCAoTkEp',
                                         'serial_number': 'ADTN21539ae6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V2.3.8',
                                         'uptime': '8822604'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628449792',
                                                                       'in_octets': '4220365314',
                                                                       'in_ucast_pkts': '10294776',
                                                                       'links': [       {       'in_octets': '4220365314',
                                                                                                'in_ucast_pkts': '10294776',
                                                                                                'out_octets': '722220779',
                                                                                                'out_ucast_pkts': '2644222',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '11, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN22454e2a, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '722220779',
                                                                       'out_ucast_pkts': '2644222',
                                                                       'poller_hash': 'QURUTjIyNDU0ZTJhSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '5968090',
                                                                                                                        'fiber_length': 660,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIyNDU0ZTJh',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '5c:62:8b:ef:68:b4'],
                                                                       'id': '1628449857',
                                                                       'in_octets': '722220779',
                                                                       'in_ucast_pkts': '2644222',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '11, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '4220365314',
                                                                       'out_ucast_pkts': '10294776',
                                                                       'poller_hash': 'QURUTjIyNDU0ZTJhRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '611 2ND GEND GPON SFU ONT (NA)',
                                         'name': '11@1/1/4',
                                         'poller_hash': 'QURUTjIyNDU0ZTJhNjExIDJORCBHRU5EIEdQT04gU0ZVIE9OVCAoTkEp',
                                         'serial_number': 'ADTN22454e2a',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V2.3.8',
                                         'uptime': '5968090'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628451840',
                                                                       'in_octets': '3206162763',
                                                                       'in_ucast_pkts': '2261666',
                                                                       'links': [       {       'in_octets': '3206162763',
                                                                                                'in_ucast_pkts': '2261666',
                                                                                                'out_octets': '90068961',
                                                                                                'out_ucast_pkts': '624619',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '13, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2154493d, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '90068961',
                                                                       'out_ucast_pkts': '624619',
                                                                       'poller_hash': 'QURUTjIxNTQ0OTNkSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2492694',
                                                                                                                        'fiber_length': 496,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.1,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxNTQ0OTNk',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:ec:5e:17:7:fe',
                                                                                                        'e4:c3:2a:d4:c4:e3'],
                                                                       'id': '1628451905',
                                                                       'in_octets': '90068961',
                                                                       'in_ucast_pkts': '624619',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '13, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3206162763',
                                                                       'out_ucast_pkts': '2261666',
                                                                       'poller_hash': 'QURUTjIxNTQ0OTNkRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '611 2ND GEND GPON SFU ONT (NA)',
                                         'name': '13@1/1/4',
                                         'poller_hash': 'QURUTjIxNTQ0OTNkNjExIDJORCBHRU5EIEdQT04gU0ZVIE9OVCAoTkEp',
                                         'serial_number': 'ADTN2154493d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V2.3.8',
                                         'uptime': '2492694'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628452864',
                                                                       'in_octets': '3914015559',
                                                                       'in_ucast_pkts': '39773717',
                                                                       'links': [       {       'in_octets': '3914015559',
                                                                                                'in_ucast_pkts': '39773717',
                                                                                                'out_octets': '107457506',
                                                                                                'out_ucast_pkts': '225455864',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '14, '
                                                                               'ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN210867a6, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '107457506',
                                                                       'out_ucast_pkts': '225455864',
                                                                       'poller_hash': 'QURUTjIxMDg2N2E2SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '9403885',
                                                                                                                        'fiber_length': 881,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzFncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2N2E2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:73:0',
                                                                                                        '0:24:45:dd:73:ff'],
                                                                       'id': '1628453505',
                                                                       'in_octets': '107457506',
                                                                       'in_ucast_pkts': '225455864',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '4, '
                                                                               'ONT: '
                                                                               '14, '
                                                                               'ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3914015559',
                                                                       'out_ucast_pkts': '39773717',
                                                                       'poller_hash': 'QURUTjIxMDg2N2E2VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '14@1/1/4',
                                         'poller_hash': 'QURUTjIxMDg2N2E2U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN210867a6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '9403885'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1630798848',
                                                                       'in_octets': '2989714875',
                                                                       'in_ucast_pkts': '315138504',
                                                                       'links': [       {       'in_octets': '2989714875',
                                                                                                'in_ucast_pkts': '315138504',
                                                                                                'out_octets': '2480442531',
                                                                                                'out_ucast_pkts': '675666211',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjU='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '13, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21160655, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2480442531',
                                                                       'out_ucast_pkts': '675666211',
                                                                       'poller_hash': 'QURUTjIxMTYwNjU1SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '3869658',
                                                                                                                        'fiber_length': 1425,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjV4Z3Nwb24=',
                                                                                                                        'rx_link_rate': '10000000000',
                                                                                                                        'rx_power': -18.4,
                                                                                                                        'tx_link_rate': '10000000000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTYwNjU1',
                                                                                               'pon_technology': 'XGS_PON',
                                                                                               'rx_link_rate': '10000000000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '10000000000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'ac:13:9c:9:cf:18',
                                                                                                        'ac:13:9c:9:cf:19'],
                                                                       'id': '1630799489',
                                                                       'in_octets': '2480442531',
                                                                       'in_ucast_pkts': '675666211',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '13, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2989714875',
                                                                       'out_ucast_pkts': '315138504',
                                                                       'poller_hash': 'QURUTjIxMTYwNjU1VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 825-V6 XGSPON HGU - NA',
                                         'name': '1@1/1/13',
                                         'poller_hash': 'QURUTjIxMTYwNjU1U1JHIDgyNS1WNiBYR1NQT04gSEdVIC0gTkE=',
                                         'serial_number': 'ADTN21160655',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.4_9f48b',
                                         'uptime': '3869658'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628702720',
                                                                       'in_octets': '131699987',
                                                                       'in_ucast_pkts': '100991',
                                                                       'links': [       {       'in_octets': '131699987',
                                                                                                'in_ucast_pkts': '100991',
                                                                                                'out_octets': '6489850',
                                                                                                'out_ucast_pkts': '60160',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjU='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN22072e14, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '6489850',
                                                                       'out_ucast_pkts': '60160',
                                                                       'poller_hash': 'QURUTjIyMDcyZTE0SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '90564',
                                                                                                                        'fiber_length': 1589,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.7}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIyMDcyZTE0',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '2c:c8:1b:d7:73:3c'],
                                                                       'id': '1628702785',
                                                                       'in_octets': '6489850',
                                                                       'in_ucast_pkts': '60160',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '131699987',
                                                                       'out_ucast_pkts': '100991',
                                                                       'poller_hash': 'QURUTjIyMDcyZTE0RXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SDX611 GPON SFU ONT, 1GE (NA)',
                                         'name': '2@1/1/5',
                                         'poller_hash': 'QURUTjIyMDcyZTE0U0RYNjExIEdQT04gU0ZVIE9OVCwgMUdFIChOQSk=',
                                         'serial_number': 'ADTN22072e14',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V1.3.7',
                                         'uptime': '90564'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628703744',
                                                                       'in_octets': '2269858149',
                                                                       'in_ucast_pkts': '423572601',
                                                                       'links': [       {       'in_octets': '2269858149',
                                                                                                'in_ucast_pkts': '423572601',
                                                                                                'out_octets': '2885959423',
                                                                                                'out_ucast_pkts': '1668540518',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjU='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159c97, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '2885959423',
                                                                       'out_ucast_pkts': '1668540518',
                                                                       'poller_hash': 'QURUTjIxMTU5Yzk3SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '7521056',
                                                                                                                        'fiber_length': 1103,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.1,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5Yzk3',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:a3:89',
                                                                                                        '0:24:45:fd:a3:8a'],
                                                                       'id': '1628704385',
                                                                       'in_octets': '2885959423',
                                                                       'in_ucast_pkts': '1668540518',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2269858149',
                                                                       'out_ucast_pkts': '423572601',
                                                                       'poller_hash': 'QURUTjIxMTU5Yzk3VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '3@1/1/5',
                                         'poller_hash': 'QURUTjIxMTU5Yzk3U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159c97',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '7521056'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628704768',
                                                                       'in_octets': '4254857898',
                                                                       'in_ucast_pkts': '800779083',
                                                                       'links': [       {       'in_octets': '4254857898',
                                                                                                'in_ucast_pkts': '800779083',
                                                                                                'out_octets': '1855468952',
                                                                                                'out_ucast_pkts': '1988475180',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjU='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159ca8, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '1855468952',
                                                                       'out_ucast_pkts': '1988475180',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2E4SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '4277922',
                                                                                                                        'fiber_length': 1734,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5Y2E4',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:a4:88',
                                                                                                        '0:24:45:fd:a4:89'],
                                                                       'id': '1628705409',
                                                                       'in_octets': '1855468952',
                                                                       'in_ucast_pkts': '1988475180',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '4254857898',
                                                                       'out_ucast_pkts': '800779083',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2E4VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '4@1/1/5',
                                         'poller_hash': 'QURUTjIxMTU5Y2E4U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159ca8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '4277922'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628705792',
                                                                       'in_octets': '1799163603',
                                                                       'in_ucast_pkts': '56238547',
                                                                       'links': [       {       'in_octets': '1799163603',
                                                                                                'in_ucast_pkts': '56238547',
                                                                                                'out_octets': '380342012',
                                                                                                'out_ucast_pkts': '137841518',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjU='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN210868bb, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '380342012',
                                                                       'out_ucast_pkts': '137841518',
                                                                       'poller_hash': 'QURUTjIxMDg2OGJiSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '506707',
                                                                                                                        'fiber_length': 1474,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2OGJi',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:84:3a',
                                                                                                        '0:24:45:dd:84:3b'],
                                                                       'id': '1628706433',
                                                                       'in_octets': '380342012',
                                                                       'in_ucast_pkts': '137841518',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '1799163603',
                                                                       'out_ucast_pkts': '56238547',
                                                                       'poller_hash': 'QURUTjIxMDg2OGJiVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '5@1/1/5',
                                         'poller_hash': 'QURUTjIxMDg2OGJiU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN210868bb',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '506707'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628707840',
                                                                       'in_octets': '2122614807',
                                                                       'in_ucast_pkts': '95323076',
                                                                       'links': [       {       'in_octets': '2122614807',
                                                                                                'in_ucast_pkts': '95323076',
                                                                                                'out_octets': '548788063',
                                                                                                'out_ucast_pkts': '232720259',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjU='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159c42, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '548788063',
                                                                       'out_ucast_pkts': '232720259',
                                                                       'poller_hash': 'QURUTjIxMTU5YzQySURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '485691',
                                                                                                                        'fiber_length': 975,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5YzQy',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:9e:8e',
                                                                                                        '0:24:45:fd:9e:8f'],
                                                                       'id': '1628708481',
                                                                       'in_octets': '548788063',
                                                                       'in_ucast_pkts': '232720259',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '7, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2122614807',
                                                                       'out_ucast_pkts': '95323076',
                                                                       'poller_hash': 'QURUTjIxMTU5YzQyVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '7@1/1/5',
                                         'poller_hash': 'QURUTjIxMTU5YzQyU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159c42',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '485691'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628709888',
                                                                       'in_octets': '1702269672',
                                                                       'in_ucast_pkts': '6957050',
                                                                       'links': [       {       'in_octets': '1702269672',
                                                                                                'in_ucast_pkts': '6957050',
                                                                                                'out_octets': '298292152',
                                                                                                'out_ucast_pkts': '3540490',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjU='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21539ae3, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '298292152',
                                                                       'out_ucast_pkts': '3540490',
                                                                       'poller_hash': 'QURUTjIxNTM5YWUzSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2302105',
                                                                                                                        'fiber_length': 1438,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjVncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxNTM5YWUz',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '24:f5:a2:9:2d:5a'],
                                                                       'id': '1628709953',
                                                                       'in_octets': '298292152',
                                                                       'in_ucast_pkts': '3540490',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '5, '
                                                                               'ONT: '
                                                                               '9, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '1702269672',
                                                                       'out_ucast_pkts': '6957050',
                                                                       'poller_hash': 'QURUTjIxNTM5YWUzRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '611 2ND GEND GPON SFU ONT (NA)',
                                         'name': '9@1/1/5',
                                         'poller_hash': 'QURUTjIxNTM5YWUzNjExIDJORCBHRU5EIEdQT04gU0ZVIE9OVCAoTkEp',
                                         'serial_number': 'ADTN21539ae3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V2.3.8',
                                         'uptime': '2302105'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628964864',
                                                                       'in_octets': '3638638426',
                                                                       'in_ucast_pkts': '82545855',
                                                                       'links': [       {       'in_octets': '3638638426',
                                                                                                'in_ucast_pkts': '82545855',
                                                                                                'out_octets': '1253987322',
                                                                                                'out_ucast_pkts': '214758163',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjQ='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2115a2b0, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '1253987322',
                                                                       'out_ucast_pkts': '214758163',
                                                                       'poller_hash': 'QURUTjIxMTVhMmIwSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '793163',
                                                                                                                        'fiber_length': 625,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjRncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.7,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTVhMmIw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:ff:0',
                                                                                                        '0:24:45:fd:ff:1'],
                                                                       'id': '1628965505',
                                                                       'in_octets': '1253987322',
                                                                       'in_ucast_pkts': '214758163',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '3638638426',
                                                                       'out_ucast_pkts': '82545855',
                                                                       'poller_hash': 'QURUTjIxMTVhMmIwVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '2@1/1/6',
                                         'poller_hash': 'QURUTjIxMTVhMmIwU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2115a2b0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '793163'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628965888',
                                                                       'in_octets': '4038462788',
                                                                       'in_ucast_pkts': '615275911',
                                                                       'links': [       {       'in_octets': '4038462788',
                                                                                                'in_ucast_pkts': '615275911',
                                                                                                'out_octets': '3625377716',
                                                                                                'out_ucast_pkts': '2061822646',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjQ='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2115a25a, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3625377716',
                                                                       'out_ucast_pkts': '2061822646',
                                                                       'poller_hash': 'QURUTjIxMTVhMjVhSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '7056430',
                                                                                                                        'fiber_length': 830,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjRncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTVhMjVh',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:f9:f6',
                                                                                                        '0:24:45:fd:f9:f7'],
                                                                       'id': '1628966529',
                                                                       'in_octets': '3625377716',
                                                                       'in_ucast_pkts': '2061822646',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '4038462788',
                                                                       'out_ucast_pkts': '615275911',
                                                                       'poller_hash': 'QURUTjIxMTVhMjVhVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '3@1/1/6',
                                         'poller_hash': 'QURUTjIxMTVhMjVhU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2115a25a',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '7056430'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628966912',
                                                                       'in_octets': '691658195',
                                                                       'in_ucast_pkts': '283320804',
                                                                       'links': [       {       'in_octets': '691658195',
                                                                                                'in_ucast_pkts': '283320804',
                                                                                                'out_octets': '1244862535',
                                                                                                'out_ucast_pkts': '815976675',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjQ='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2108683e, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '1244862535',
                                                                       'out_ucast_pkts': '815976675',
                                                                       'poller_hash': 'QURUTjIxMDg2ODNlSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '3020530',
                                                                                                                        'fiber_length': 452,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjRncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.4,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2ODNl',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:7c:e7',
                                                                                                        '0:24:45:dd:7c:e8'],
                                                                       'id': '1628967553',
                                                                       'in_octets': '1244862535',
                                                                       'in_ucast_pkts': '815976675',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '691658195',
                                                                       'out_ucast_pkts': '283320804',
                                                                       'poller_hash': 'QURUTjIxMDg2ODNlVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '4@1/1/6',
                                         'poller_hash': 'QURUTjIxMDg2ODNlU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2108683e',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '3020530'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628967936',
                                                                       'in_octets': '1817183502',
                                                                       'in_ucast_pkts': '1339609',
                                                                       'links': [       {       'in_octets': '1817183502',
                                                                                                'in_ucast_pkts': '1339609',
                                                                                                'out_octets': '184626102',
                                                                                                'out_ucast_pkts': '622972',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjQ='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21103db5, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '184626102',
                                                                       'out_ucast_pkts': '622972',
                                                                       'poller_hash': 'QURUTjIxMTAzZGI1SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '2328738',
                                                                                                                        'fiber_length': 443,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjRncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.8}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTAzZGI1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'd8:ec:5e:9c:50:fb'],
                                                                       'id': '1628968001',
                                                                       'in_octets': '184626102',
                                                                       'in_ucast_pkts': '622972',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '5, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '1817183502',
                                                                       'out_ucast_pkts': '1339609',
                                                                       'poller_hash': 'QURUTjIxMTAzZGI1RXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '401 4th GEN INDOOR SFU 1GE',
                                         'name': '5@1/1/6',
                                         'poller_hash': 'QURUTjIxMTAzZGI1NDAxIDR0aCBHRU4gSU5ET09SIFNGVSAxR0U=',
                                         'serial_number': 'ADTN21103db5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M1',
                                         'uptime': '2328738'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628968960',
                                                                       'in_octets': '84560223',
                                                                       'in_ucast_pkts': '230299426',
                                                                       'links': [       {       'in_octets': '84560223',
                                                                                                'in_ucast_pkts': '230299426',
                                                                                                'out_octets': '3090718958',
                                                                                                'out_ucast_pkts': '809422993',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjQ='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159cb0, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3090718958',
                                                                       'out_ucast_pkts': '809422993',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2IwSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '4641295',
                                                                                                                        'fiber_length': 824,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjRncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -22.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5Y2Iw',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:a5:0',
                                                                                                        '0:24:45:fd:a5:1'],
                                                                       'id': '1628969601',
                                                                       'in_octets': '3090718958',
                                                                       'in_ucast_pkts': '809422993',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '6, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '84560223',
                                                                       'out_ucast_pkts': '230299426',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2IwVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '6@1/1/6',
                                         'poller_hash': 'QURUTjIxMTU5Y2IwU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN21159cb0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '4641295'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1628971008',
                                                                       'in_octets': '1111087302',
                                                                       'in_ucast_pkts': '12465022',
                                                                       'links': [       {       'in_octets': '1111087302',
                                                                                                'in_ucast_pkts': '12465022',
                                                                                                'out_octets': '528295606',
                                                                                                'out_ucast_pkts': '6315839',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjQ='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '8, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21539aed, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '528295606',
                                                                       'out_ucast_pkts': '6315839',
                                                                       'poller_hash': 'QURUTjIxNTM5YWVkSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '3703590',
                                                                                                                        'fiber_length': 660,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjRncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -12.5,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.1}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxNTM5YWVk',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       'c0:36:53:e:1:e1'],
                                                                       'id': '1628971073',
                                                                       'in_octets': '528295606',
                                                                       'in_ucast_pkts': '6315839',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '6, '
                                                                               'ONT: '
                                                                               '8, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '1111087302',
                                                                       'out_ucast_pkts': '12465022',
                                                                       'poller_hash': 'QURUTjIxNTM5YWVkRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '611 2ND GEND GPON SFU ONT (NA)',
                                         'name': '8@1/1/6',
                                         'poller_hash': 'QURUTjIxNTM5YWVkNjExIDJORCBHRU5EIEdQT04gU0ZVIE9OVCAoTkEp',
                                         'serial_number': 'ADTN21539aed',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V2.3.8',
                                         'uptime': '3703590'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1629225984',
                                                                       'in_octets': '997972146',
                                                                       'in_ucast_pkts': '2088301',
                                                                       'links': [       {       'in_octets': '997972146',
                                                                                                'in_ucast_pkts': '2088301',
                                                                                                'out_octets': '1992705584',
                                                                                                'out_ucast_pkts': '2184956',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '7, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2115a1e6, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '1992705584',
                                                                       'out_ucast_pkts': '2184956',
                                                                       'poller_hash': 'QURUTjIxMTVhMWU2SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '12228',
                                                                                                                        'fiber_length': 244,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTVhMWU2',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:f3:2b'],
                                                                       'id': '1629226625',
                                                                       'in_octets': '1992705584',
                                                                       'in_ucast_pkts': '2184956',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '7, '
                                                                               'ONT: '
                                                                               '1, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '997972146',
                                                                       'out_ucast_pkts': '2088301',
                                                                       'poller_hash': 'QURUTjIxMTVhMWU2VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '1@1/1/7',
                                         'poller_hash': 'QURUTjIxMTVhMWU2U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN2115a1e6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '12228'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1629227008',
                                                                       'in_octets': '95967',
                                                                       'in_ucast_pkts': '26308200',
                                                                       'links': [       {       'in_octets': '95967',
                                                                                                'in_ucast_pkts': '26308200',
                                                                                                'out_octets': '864827861',
                                                                                                'out_ucast_pkts': '9948485',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '7, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN2110418d, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '864827861',
                                                                       'out_ucast_pkts': '9948485',
                                                                       'poller_hash': 'QURUTjIxMTA0MThkSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '77687',
                                                                                                                        'fiber_length': 643,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -15.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 1.9}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTA0MThk',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:e0:80:ae',
                                                                                                        '2c:fd:a1:34:de:50',
                                                                                                        '48:22:54:56:db:ac'],
                                                                       'id': '1629227073',
                                                                       'in_octets': '864827861',
                                                                       'in_ucast_pkts': '9948485',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '7, '
                                                                               'ONT: '
                                                                               '2, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(Eth)',
                                                                       'oper_up': True,
                                                                       'out_octets': '95967',
                                                                       'out_ucast_pkts': '26308200',
                                                                       'poller_hash': 'QURUTjIxMTA0MThkRXRoaW50Zg==',
                                                                       'speed': '1000000000'}],
                                         'manufacturer': 'Adtran',
                                         'model': '401 4th GEN INDOOR SFU 1GE',
                                         'name': '2@1/1/7',
                                         'poller_hash': 'QURUTjIxMTA0MThkNDAxIDR0aCBHRU4gSU5ET09SIFNGVSAxR0U=',
                                         'serial_number': 'ADTN2110418d',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'M40.00.0013.M1',
                                         'uptime': '77687'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1629228032',
                                                                       'in_octets': '105394448',
                                                                       'in_ucast_pkts': '2242896856',
                                                                       'links': [       {       'in_octets': '105394448',
                                                                                                'in_ucast_pkts': '2242896856',
                                                                                                'out_octets': '4035301135',
                                                                                                'out_ucast_pkts': '2014362689',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '7, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN210867be, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '4035301135',
                                                                       'out_ucast_pkts': '2014362689',
                                                                       'poller_hash': 'QURUTjIxMDg2N2JlSURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '12978210',
                                                                                                                        'fiber_length': 720,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -14.2,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMDg2N2Jl',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:dd:75:67',
                                                                                                        '0:24:45:dd:75:68'],
                                                                       'id': '1629228673',
                                                                       'in_octets': '4035301135',
                                                                       'in_ucast_pkts': '2014362689',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '7, '
                                                                               'ONT: '
                                                                               '3, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '105394448',
                                                                       'out_ucast_pkts': '2242896856',
                                                                       'poller_hash': 'QURUTjIxMDg2N2JlVkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '3@1/1/7',
                                         'poller_hash': 'QURUTjIxMDg2N2JlU1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'ADTN210867be',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '2.7.0.3_2bc26',
                                         'uptime': '12978210'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1629229056',
                                                                       'in_octets': '2229443589',
                                                                       'in_ucast_pkts': '23299923',
                                                                       'links': [       {       'in_octets': '2229443589',
                                                                                                'in_ucast_pkts': '23299923',
                                                                                                'out_octets': '3767711825',
                                                                                                'out_ucast_pkts': '73844044',
                                                                                                'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTM='}],
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '7, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Serial '
                                                                               'No: '
                                                                               'ADTN21159ca5, '
                                                                               'ONT '
                                                                               'Reg '
                                                                               'ID:',
                                                                       'oper_up': True,
                                                                       'out_octets': '3767711825',
                                                                       'out_ucast_pkts': '73844044',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2E1SURpbnRm',
                                                                       'pons': [       {       'links': [       {       'connected_time': '203979',
                                                                                                                        'fiber_length': 711,
                                                                                                                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTNncG9u',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -13.6,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 4.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'QURUTjIxMTU5Y2E1',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 128,
                                                                                               'tx_link_rate': '1244160000'}]},
                                                               {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '0:24:45:fd:a4:5b',
                                                                                                        '0:24:45:fd:a4:5c'],
                                                                       'id': '1629229697',
                                                                       'in_octets': '3767711825',
                                                                       'in_ucast_pkts': '73844044',
                                                                       'name': 'Shelf: '
                                                                               '1, '
                                                                               'Slot: '
                                                                               '1, '
                                                                               'Pon: '
                                                                               '7, '
                                                                               'ONT: '
                                                                               '4, ONT '
                                                                               'Port: '
                                                                               '1 '
                                                                               '(VEIP)',
                                                                       'oper_up': True,
                                                                       'out_octets': '2229443589',
                                                                       'out_ucast_pkts': '23299923',
                                                                       'poller_hash': 'QURUTjIxMTU5Y2E1VkVJUGludGY='}],
                                         'manufacturer': 'Adtran',
                                         'model': 'SRG 814-V6 GPON HGU - NA',
                                         'name': '4@1/1/7',
                                         'poller_hash': 'QURUTjIxMTU5Y2E1U1JHIDgxNC1WNiBHUE9OIEhHVSAtIE5B',
                                         'serial_number': 'A