import os.path
import sys
from tabulate import tabulate

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase
import devices.mikrotik

class TestRadioStats(DeviceTestCase):
    def test_mikrotik_ap_01(self):
        """Test CPE polling.  Work in progress."""
        obj = self.run_data('mikrotik.mikrotik-ap.RB922UAGS-5HPacD.6.43.8.01')
        self.assertEqual(obj.vendor, 'Mikrotik')
        self.assertEqual(obj.model, 'RB922UAGS-5HPacD')
        self.assertEqual(obj.sw_version, '6.43.8')
        #print(tabulate(obj.stations, headers=obj.stations[0]._fields))

    def test_mikrotik_60g_ap(self):
        """Test the Mikrotik 60G AP variant"""
        obj = self.run_data('mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45beta62.01')
        #print(tabulate(obj.stations, headers=obj.stations[0]._fields))
