import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestBlinqModels(DeviceTestCase):
    def test_blinq_enb_Blinq_eNB_1_3_10_1_01(self):
        obj = self.run_data("blinq.enb.Blinq eNB.1.3.10_1.01")
        exp_info = {
         'model': 'RevC05', 'sta_count': 0, 'sw_version': '1.3.10_1', 'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '0c:a1:38:00:04:f9',
                                                              'name': 'WLAN Interface',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}]}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'RevC05',
                                'serial_number': '60101C5-18520010',
                                'sw_version': '1.3.10_1',
                                'system_mac_address': '0c:a1:38:00:04:f9'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_Blinq_eNB_2_0_9_1_01(self):
        obj = self.run_data("blinq.enb.Blinq eNB.2.0.9_1.01")
        exp_info = {
         'model': 'RevC05', 'sta_count': 35, 'sw_version': '2.0.9_1', 'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '001015432100145': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100145',
                                           'ip_address': '10.0.0.145',
                                           'name': 'Bruce Dresselhouse',
                                           'ul_rssi': -112.14},
                '001015432100146': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100146',
                                           'ip_address': '10.0.0.146',
                                           'name': None,
                                           'ul_rssi': -103.77},
                '001015432100147': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100147',
                                           'ip_address': '10.0.0.147',
                                           'name': 'Dave Zimmer',
                                           'ul_rssi': -96.49},
                '001015432100148': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100148',
                                           'ip_address': '10.0.0.148',
                                           'name': None,
                                           'ul_rssi': -111.52},
                '001015432100149': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100149',
                                           'ip_address': '10.0.0.149',
                                           'name': 'Barbara Haist',
                                           'ul_rssi': -96.19},
                '001015432100224': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100224',
                                           'ip_address': '10.0.0.224',
                                           'name': None,
                                           'ul_rssi': None},
                '001015432100225': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100225',
                                           'ip_address': '10.0.0.225',
                                           'name': 'Jessica Richer',
                                           'ul_rssi': -112.15},
                '001015432100226': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100226',
                                           'ip_address': '10.0.0.226',
                                           'name': 'Bryan Reynolds',
                                           'ul_rssi': -95.19},
                '001015432100227': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100227',
                                           'ip_address': '10.0.0.227',
                                           'name': 'Curt Peterfeso',
                                           'ul_rssi': -102.91},
                '999995432100107': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100107',
                                           'ip_address': '10.0.0.7',
                                           'name': 'Cindy Fischaber',
                                           'ul_rssi': None},
                '999995432100108': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100108',
                                           'ip_address': '10.0.0.8',
                                           'name': 'Darrel Bergor',
                                           'ul_rssi': -115.75},
                '999995432100109': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100109',
                                           'ip_address': '10.0.0.109',
                                           'name': 'Mark Daane',
                                           'ul_rssi': -95.89},
                '999995432100110': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100110',
                                           'ip_address': '10.0.0.10',
                                           'name': 'Jerry Richardson',
                                           'ul_rssi': -94.98},
                '999995432100111': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100111',
                                           'ip_address': '10.0.0.11',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100112': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100112',
                                           'ip_address': '10.0.0.12',
                                           'name': 'Randal Wright',
                                           'ul_rssi': -106.94},
                '999995432100113': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100113',
                                           'ip_address': '10.0.0.13',
                                           'name': 'Mike Carry',
                                           'ul_rssi': -98.13},
                '999995432100114': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100114',
                                           'ip_address': '10.0.0.14',
                                           'name': 'Judy Ligi',
                                           'ul_rssi': None},
                '999995432100115': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100115',
                                           'ip_address': '10.0.0.15',
                                           'name': 'Anthony Hicks',
                                           'ul_rssi': -100.17},
                '999995432100116': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100116',
                                           'ip_address': '10.0.0.16',
                                           'name': None,
                                           'ul_rssi': -96.95},
                '999995432100117': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100117',
                                           'ip_address': '10.0.0.17',
                                           'name': 'Thomas Steele',
                                           'ul_rssi': -96.32},
                '999995432100119': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100119',
                                           'ip_address': '10.0.0.19',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100120': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100120',
                                           'ip_address': '10.0.0.120',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100121': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100121',
                                           'ip_address': '10.0.0.121',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100122': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100122',
                                           'ip_address': '10.0.0.122',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100158': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100158',
                                           'ip_address': '10.0.0.158',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100159': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100159',
                                           'ip_address': '10.0.0.159',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100160': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100160',
                                           'ip_address': '10.0.0.160',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100161': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100161',
                                           'ip_address': '10.0.0.161',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100162': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100162',
                                           'ip_address': '10.0.0.162',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100163': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100163',
                                           'ip_address': '10.0.0.163',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100164': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100164',
                                           'ip_address': '10.0.0.164',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100165': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100165',
                                           'ip_address': '10.0.0.165',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100166': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100166',
                                           'ip_address': '10.0.0.166',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100167': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100167',
                                           'ip_address': '10.0.0.167',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100172': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100172',
                                           'ip_address': '10.0.0.172',
                                           'name': 'Eric Wheeler',
                                           'ul_rssi': -112.54}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'links': [       {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ1MQ=='},
                                                                               {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ2MQ=='},
                                                                               {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ3MQ=='},
                                                                               {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ4MQ=='},
                                                                               {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ5MQ=='},
                                                                               {       'poller_hash': 'MDAxMDE1NDMyMTAwMjI0MQ=='},
                                                                               {       'poller_hash': 'MDAxMDE1NDMyMTAwMjI1MQ=='},
                                                                               {       'poller_hash': 'MDAxMDE1NDMyMTAwMjI2MQ=='},
                                                                               {       'poller_hash': 'MDAxMDE1NDMyMTAwMjI3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTA3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTA4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTA5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTEwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTExMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTEyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTEzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTIwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTIxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTIyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTU4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTU5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTYwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTYxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTYyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTYzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTY0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTY1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTY2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTY3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwMTcyMQ=='}],
                                                              'mac_address': '0c:a1:38:00:04:f9',
                                                              'name': 'WLAN Interface',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ1MQ==',
                                                                                                                                            'rssi': -112.14,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 16},
                                                                                                                                    {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ2MQ==',
                                                                                                                                            'rssi': -103.77,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 17},
                                                                                                                                    {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ3MQ==',
                                                                                                                                            'rssi': -96.49,
                                                                                                                                            'rx_mcs': 23,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ4MQ==',
                                                                                                                                            'rssi': -111.52,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 13},
                                                                                                                                    {       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ5MQ==',
                                                                                                                                            'rssi': -96.19,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'MDAxMDE1NDMyMTAwMjI0MQ=='},
                                                                                                                                    {       'poller_hash': 'MDAxMDE1NDMyMTAwMjI1MQ==',
                                                                                                                                            'rssi': -112.15,
                                                                                                                                            'rx_mcs': 22,
                                                                                                                                            'tx_mcs': 26},
                                                                                                                                    {       'poller_hash': 'MDAxMDE1NDMyMTAwMjI2MQ==',
                                                                                                                                            'rssi': -95.19,
                                                                                                                                            'rx_mcs': 23,
                                                                                                                                            'tx_mcs': 18},
                                                                                                                                    {       'poller_hash': 'MDAxMDE1NDMyMTAwMjI3MQ==',
                                                                                                                                            'rssi': -102.91,
                                                                                                                                            'rx_mcs': 23,
                                                                                                                                            'tx_mcs': 18},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTA3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTA4MQ==',
                                                                                                                                            'rssi': -115.75,
                                                                                                                                            'rx_mcs': 19,
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTA5MQ==',
                                                                                                                                            'rssi': -95.89,
                                                                                                                                            'rx_mcs': 23,
                                                                                                                                            'tx_mcs': 18},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTEwMQ==',
                                                                                                                                            'rssi': -94.98,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 23},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTExMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTEyMQ==',
                                                                                                                                            'rssi': -106.94,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 15},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTEzMQ==',
                                                                                                                                            'rssi': -98.13,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 18},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE1MQ==',
                                                                                                                                            'rssi': -100.17,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 16},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE2MQ==',
                                                                                                                                            'rssi': -96.95,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 18},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE3MQ==',
                                                                                                                                            'rssi': -96.32,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 18},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTE5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTIwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTIxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTIyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTU4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTU5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTYwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTYxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTYyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTYzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTY0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTY1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTY2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTY3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwMTcyMQ==',
                                                                                                                                            'rssi': -112.54,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 25}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'RevC05',
                                'serial_number': '60101C5-18520010',
                                'sw_version': '2.0.9_1',
                                'system_mac_address': '0c:a1:38:00:04:f9'},
                'peers': [       {       'imsi': '001015432100145',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 16,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Bruce Dresselhouse',
                                         'poller_hash': 'MDAxMDE1NDMyMTAwMTQ1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '001015432100146',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 17,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'MDAxMDE1NDMyMTAwMTQ2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '001015432100147',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 23}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Dave Zimmer',
                                         'poller_hash': 'MDAxMDE1NDMyMTAwMTQ3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '001015432100148',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 13,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'MDAxMDE1NDMyMTAwMTQ4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '001015432100149',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'MDAxMDE1NDMyMTAwMTQ5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Barbara Haist',
                                         'poller_hash': 'MDAxMDE1NDMyMTAwMTQ5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '001015432100224',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'MDAxMDE1NDMyMTAwMjI0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'MDAxMDE1NDMyMTAwMjI0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '001015432100225',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'MDAxMDE1NDMyMTAwMjI1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 26,
                                                                                                                                                     'tx_mcs': 22}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Jessica Richer',
                                         'poller_hash': 'MDAxMDE1NDMyMTAwMjI1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '001015432100226',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'MDAxMDE1NDMyMTAwMjI2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 18,
                                                                                                                                                     'tx_mcs': 23}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Bryan Reynolds',
                                         'poller_hash': 'MDAxMDE1NDMyMTAwMjI2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '001015432100227',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'MDAxMDE1NDMyMTAwMjI3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 18,
                                                                                                                                                     'tx_mcs': 23}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Curt Peterfeso',
                                         'poller_hash': 'MDAxMDE1NDMyMTAwMjI3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100107',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTA3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Cindy Fischaber',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTA3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100108',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTA4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_mcs': 19}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Darrel Bergor',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTA4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100109',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTA5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 18,
                                                                                                                                                     'tx_mcs': 23}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Mark Daane',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTA5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100110',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTEwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 23,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Jerry Richardson',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTEw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100111',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTExMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTEx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100112',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTEyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 15,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Randal Wright',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTEy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100113',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTEzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 18,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Mike Carry',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTEz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100114',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTE0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Judy Ligi',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTE0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100115',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTE1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 16,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Anthony Hicks',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTE1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100116',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTE2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 18,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTE2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100117',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTE3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 18,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Thomas Steele',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTE3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100119',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTE5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTE5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100120',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTIwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTIw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100121',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTIxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTIx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100122',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTIyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTIy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100158',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTU4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTU4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100159',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTU5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTU5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100160',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTYwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTYw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100161',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTYxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTYx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100162',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTYyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTYy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100163',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTYzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTYz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100164',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTY0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTY0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100165',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTY1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTY1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100166',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTY2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTY2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100167',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTY3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTY3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100172',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:f9'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwMTcyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:f9',
                                                                                                                                                     'rx_mcs': 25,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Eric Wheeler',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwMTcy',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_Blinq_eNB_4_0_4_1_10_11_254_10(self):
        obj = self.run_data("blinq.enb.Blinq eNB.4.0.4_1.10_11_254_10")
        exp_info = {
                'model': 'FW-300i B48',
                'sta_count': 28,
                'sw_version': '4.0.4_1',
                'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '999995432100825': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100825',
                                           'ip_address': '10.201.12.11',
                                           'name': 'Polk, Ken - Ranch Man Cave',
                                           'ul_rssi': -112.85},
                '999995432100890': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100890',
                                           'ip_address': '10.201.12.19',
                                           'name': 'Haas Snow, Jessi',
                                           'ul_rssi': -102.51},
                '999995432100909': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100909',
                                           'ip_address': '10.201.12.10',
                                           'name': 'Haas, Jo Nell',
                                           'ul_rssi': -124.73},
                '999995432100940': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100940',
                                           'ip_address': '10.201.12.28',
                                           'name': 'Hamilton, Sarah',
                                           'ul_rssi': -113.48},
                '999995432100986': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100986',
                                           'ip_address': '10.201.12.14',
                                           'name': 'Deborah & Monty Safell',
                                           'ul_rssi': -107.05},
                '999995432101034': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101034',
                                           'ip_address': '10.201.12.23',
                                           'name': 'Harvey, Cody',
                                           'ul_rssi': -113.72},
                '999995432101038': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101038',
                                           'ip_address': '10.201.12.29',
                                           'name': 'Heins, Leoris - SuperBLiNQ',
                                           'ul_rssi': -122.41},
                '999995432101045': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101045',
                                           'ip_address': '10.201.12.18',
                                           'name': 'Wiegand, Julie',
                                           'ul_rssi': -111.36},
                '999995432101047': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101047',
                                           'ip_address': '10.201.12.24',
                                           'name': 'Smith, Ron',
                                           'ul_rssi': -111.39},
                '999995432101053': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101053',
                                           'ip_address': '10.201.12.17',
                                           'name': 'Raley, Jacob - SuperBlinq',
                                           'ul_rssi': -107.96},
                '999995432101201': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101201',
                                           'ip_address': '10.201.12.27',
                                           'name': 'Hall, Ann',
                                           'ul_rssi': -112.86},
                '999995432101224': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101224',
                                           'ip_address': '10.201.12.16',
                                           'name': 'Cooper, Alan',
                                           'ul_rssi': -112.52},
                '999995432101234': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101234',
                                           'ip_address': '10.201.12.75',
                                           'name': 'Gray, Steven',
                                           'ul_rssi': None},
                '999995432101245': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101245',
                                           'ip_address': '10.201.12.34',
                                           'name': 'Rieken, Mike',
                                           'ul_rssi': -101.49},
                '999995432102212': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102212',
                                           'ip_address': '10.201.12.30',
                                           'name': 'Smith, Larry - SuperBLiNQ',
                                           'ul_rssi': -110.78},
                '999995432102213': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102213',
                                           'ip_address': '10.201.12.36',
                                           'name': 'Soto, Miranda',
                                           'ul_rssi': None},
                '999995432102214': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102214',
                                           'ip_address': '10.201.12.33',
                                           'name': 'Tabor, Russell - SuperBLiNQ',
                                           'ul_rssi': None},
                '999995432102215': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102215',
                                           'ip_address': '10.201.12.48',
                                           'name': 'Crull, Carla',
                                           'ul_rssi': None},
                '999995432102222': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102222',
                                           'ip_address': '10.201.12.12',
                                           'name': 'Gustafson, Sandra',
                                           'ul_rssi': -107.64},
                '999995432102223': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102223',
                                           'ip_address': '10.201.12.32',
                                           'name': 'Trent, Courtney - SuperBLiNQ',
                                           'ul_rssi': None},
                '999995432102226': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102226',
                                           'ip_address': '10.201.12.52',
                                           'name': 'Stubbs, Kay',
                                           'ul_rssi': None},
                '999995432102227': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102227',
                                           'ip_address': '10.201.12.35',
                                           'name': 'Mieras, Rachel - SuperBLiNQ',
                                           'ul_rssi': -106.4},
                '999995432105000': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105000',
                                           'ip_address': '10.201.12.13',
                                           'name': 'Curry, Sean',
                                           'ul_rssi': -108.92},
                '999995432105003': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105003',
                                           'ip_address': '10.201.12.26',
                                           'name': 'Seymour, Robert',
                                           'ul_rssi': None},
                '999995432105007': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105007',
                                           'ip_address': '10.201.12.20',
                                           'name': 'Johnson, Robin',
                                           'ul_rssi': None},
                '999995432105076': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105076',
                                           'ip_address': '10.201.12.25',
                                           'name': 'Stellfox, Marcy',
                                           'ul_rssi': -113.63},
                '999995432105079': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105079',
                                           'ip_address': '10.201.12.31',
                                           'name': 'Wallace, Nick',
                                           'ul_rssi': -116.67},
                '999995432107457': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432107457',
                                           'ip_address': '10.201.12.37',
                                           'name': 'Stubbs, Kay (Replacement)',
                                           'ul_rssi': -100.28}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'links': [       {       'poller_hash': 'OTk5OTk1NDMyMTAwODI1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwODkwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwOTA5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwOTQwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwOTg2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDM0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDM4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDUzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMjAxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMjI0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMjM0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMjQ1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjEyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjEzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjE0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjE1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjIyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjIzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjI2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjI3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDAwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDAzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDA3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDc2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDc5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA3NDU3MQ=='}],
                                                              'mac_address': '0c:a1:38:00:04:98',
                                                              'name': 'WLAN Interface',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'poller_hash': 'OTk5OTk1NDMyMTAwODI1MQ==',
                                                                                                                                            'rssi': -112.85,
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_mcs': 25},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwODkwMQ==',
                                                                                                                                            'rssi': -102.51,
                                                                                                                                            'rx_mcs': 20,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwOTA5MQ==',
                                                                                                                                            'rssi': -124.73,
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_mcs': 10},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwOTQwMQ==',
                                                                                                                                            'rssi': -113.48,
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'tx_mcs': 23},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwOTg2MQ==',
                                                                                                                                            'rssi': -107.05,
                                                                                                                                            'rx_mcs': 23,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDM0MQ==',
                                                                                                                                            'rssi': -113.72,
                                                                                                                                            'rx_mcs': 14,
                                                                                                                                            'tx_mcs': 15},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDM4MQ==',
                                                                                                                                            'rssi': -122.41,
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_mcs': 15},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ1MQ==',
                                                                                                                                            'rssi': -111.36,
                                                                                                                                            'rx_mcs': 19,
                                                                                                                                            'tx_mcs': 25},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ3MQ==',
                                                                                                                                            'rssi': -111.39,
                                                                                                                                            'rx_mcs': 17,
                                                                                                                                            'tx_mcs': 17},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDUzMQ==',
                                                                                                                                            'rssi': -107.96,
                                                                                                                                            'rx_mcs': 20,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMjAxMQ==',
                                                                                                                                            'rssi': -112.86,
                                                                                                                                            'rx_mcs': 18,
                                                                                                                                            'tx_mcs': 25},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMjI0MQ==',
                                                                                                                                            'rssi': -112.52,
                                                                                                                                            'rx_mcs': 19,
                                                                                                                                            'tx_mcs': 17},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMjM0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMjQ1MQ==',
                                                                                                                                            'rssi': -101.49,
                                                                                                                                            'rx_mcs': 18,
                                                                                                                                            'tx_mcs': 20},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjEyMQ==',
                                                                                                                                            'rssi': -110.78,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 25},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjEzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjE0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjE1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjIyMQ==',
                                                                                                                                            'rssi': -107.64,
                                                                                                                                            'rx_mcs': 23,
                                                                                                                                            'tx_mcs': 20},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjIzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjI2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjI3MQ==',
                                                                                                                                            'rssi': -106.4,
                                                                                                                                            'rx_mcs': 19,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDAwMQ==',
                                                                                                                                            'rssi': -108.92,
                                                                                                                                            'rx_mcs': 18,
                                                                                                                                            'tx_mcs': 25},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDAzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDA3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDc2MQ==',
                                                                                                                                            'rssi': -113.63,
                                                                                                                                            'rx_mcs': 12,
                                                                                                                                            'tx_mcs': 18},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDc5MQ==',
                                                                                                                                            'rssi': -116.67,
                                                                                                                                            'rx_mcs': 15,
                                                                                                                                            'tx_mcs': 23},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA3NDU3MQ==',
                                                                                                                                            'rssi': -100.28,
                                                                                                                                            'rx_mcs': 17,
                                                                                                                                            'tx_mcs': 27}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'FW-300i B48',
                                'serial_number': 'A181107455',
                                'sw_version': '4.0.4_1',
                                'system_mac_address': '0c:a1:38:00:04:98'},
                'peers': [       {       'imsi': '999995432100825',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwODI1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 25,
                                                                                                                                                     'tx_mcs': 7}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Polk, Ken - Ranch Man Cave',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwODI1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100890',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwODkwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 20}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Haas Snow, Jessi',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwODkw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100909',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwOTA5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 10,
                                                                                                                                                     'tx_mcs': 3}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Haas, Jo Nell',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwOTA5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100940',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwOTQwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 23,
                                                                                                                                                     'tx_mcs': 9}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Hamilton, Sarah',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwOTQw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100986',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwOTg2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 23}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Deborah & Monty Safell',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwOTg2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101034',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDM0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 15,
                                                                                                                                                     'tx_mcs': 14}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Harvey, Cody',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDM0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101038',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDM4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 15,
                                                                                                                                                     'tx_mcs': 3}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Heins, Leoris - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDM4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101045',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 25,
                                                                                                                                                     'tx_mcs': 19}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Wiegand, Julie',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDQ1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101047',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 17,
                                                                                                                                                     'tx_mcs': 17}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Smith, Ron',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDQ3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101053',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDUzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 20}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Raley, Jacob - SuperBlinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDUz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101201',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMjAxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 25,
                                                                                                                                                     'tx_mcs': 18}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Hall, Ann',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMjAx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101224',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMjI0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 17,
                                                                                                                                                     'tx_mcs': 19}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Cooper, Alan',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMjI0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101234',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMjM0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Gray, Steven',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMjM0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101245',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMjQ1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 20,
                                                                                                                                                     'tx_mcs': 18}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Rieken, Mike',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMjQ1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102212',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjEyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 25,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Smith, Larry - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjEy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102213',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjEzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Soto, Miranda',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjEz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102214',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjE0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Tabor, Russell - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjE0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102215',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjE1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Crull, Carla',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjE1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102222',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjIyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 20,
                                                                                                                                                     'tx_mcs': 23}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Gustafson, Sandra',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjIy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102223',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjIzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Trent, Courtney - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjIz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102226',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjI2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Stubbs, Kay',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjI2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102227',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjI3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 19}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Mieras, Rachel - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjI3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105000',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDAwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 25,
                                                                                                                                                     'tx_mcs': 18}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Curry, Sean',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDAw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105003',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDAzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Seymour, Robert',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDAz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105007',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDA3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Johnson, Robin',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDA3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105076',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDc2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 18,
                                                                                                                                                     'tx_mcs': 12}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Stellfox, Marcy',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDc2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105079',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDc5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 23,
                                                                                                                                                     'tx_mcs': 15}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Wallace, Nick',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDc5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432107457',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA3NDU3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 17}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Stubbs, Kay (Replacement)',
                                         'poller_hash': 'OTk5OTk1NDMyMTA3NDU3',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_Blinq_eNB_4_1_6_1_01(self):
        obj = self.run_data("blinq.enb.Blinq eNB.4.1.6_1.01")
        exp_info = {
                'model': 'X-300i B48',
                'sta_count': 110,
                'sw_version': '4.1.6_1',
                'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '999995432108256': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108256',
                                           'ip_address': '172.28.12.2',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108257': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108257',
                                           'ip_address': '172.28.12.3',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108258': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108258',
                                           'ip_address': '172.28.12.4',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108259': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108259',
                                           'ip_address': '172.28.12.5',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108260': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108260',
                                           'ip_address': '172.28.12.6',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108261': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108261',
                                           'ip_address': '172.28.12.7',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108262': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108262',
                                           'ip_address': '172.28.12.8',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108263': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108263',
                                           'ip_address': '172.28.12.9',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108264': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108264',
                                           'ip_address': '172.28.12.10',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108266': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108266',
                                           'ip_address': '172.28.12.11',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108267': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108267',
                                           'ip_address': '172.28.12.12',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108268': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108268',
                                           'ip_address': '172.28.12.13',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108269': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108269',
                                           'ip_address': '172.28.12.14',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108270': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108270',
                                           'ip_address': '172.28.12.15',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108271': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108271',
                                           'ip_address': '172.28.12.16',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108272': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108272',
                                           'ip_address': '172.28.12.17',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108273': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108273',
                                           'ip_address': '172.28.12.18',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108274': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108274',
                                           'ip_address': '172.28.12.19',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108275': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108275',
                                           'ip_address': '172.28.12.20',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108276': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108276',
                                           'ip_address': '172.28.12.21',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108277': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108277',
                                           'ip_address': '172.28.12.22',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108278': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108278',
                                           'ip_address': '172.28.12.23',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108279': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108279',
                                           'ip_address': '172.28.12.24',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108280': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108280',
                                           'ip_address': '172.28.12.25',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108281': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108281',
                                           'ip_address': '172.28.12.26',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108282': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108282',
                                           'ip_address': '172.28.12.27',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108283': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108283',
                                           'ip_address': '172.28.12.28',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108284': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108284',
                                           'ip_address': '172.28.12.29',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108285': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108285',
                                           'ip_address': '172.28.12.30',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108286': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108286',
                                           'ip_address': '172.28.12.31',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108287': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108287',
                                           'ip_address': '172.28.12.32',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108288': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108288',
                                           'ip_address': '172.28.12.33',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108289': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108289',
                                           'ip_address': '172.28.12.34',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108290': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108290',
                                           'ip_address': '172.28.12.35',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108291': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108291',
                                           'ip_address': '172.28.12.36',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108292': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108292',
                                           'ip_address': '172.28.12.37',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108293': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108293',
                                           'ip_address': '172.28.12.38',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108294': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108294',
                                           'ip_address': '172.28.12.39',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108295': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108295',
                                           'ip_address': '172.28.12.40',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108296': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108296',
                                           'ip_address': '172.28.12.41',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108297': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108297',
                                           'ip_address': '172.28.12.42',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108298': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108298',
                                           'ip_address': '172.28.12.43',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108299': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108299',
                                           'ip_address': '172.28.12.44',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108300': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108300',
                                           'ip_address': '172.28.12.45',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108301': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108301',
                                           'ip_address': '172.28.12.46',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108302': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108302',
                                           'ip_address': '172.28.12.47',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108303': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108303',
                                           'ip_address': '172.28.12.48',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108304': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108304',
                                           'ip_address': '172.28.12.49',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108305': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108305',
                                           'ip_address': '172.28.12.50',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108306': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108306',
                                           'ip_address': '172.28.12.51',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108307': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108307',
                                           'ip_address': '172.28.12.52',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108308': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108308',
                                           'ip_address': '172.28.12.53',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108309': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108309',
                                           'ip_address': '172.28.12.54',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108310': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108310',
                                           'ip_address': '172.28.12.55',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108311': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108311',
                                           'ip_address': '172.28.12.56',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108312': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108312',
                                           'ip_address': '172.28.12.57',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108313': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108313',
                                           'ip_address': '172.28.12.58',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108314': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108314',
                                           'ip_address': '172.28.12.59',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108315': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108315',
                                           'ip_address': '172.28.12.60',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108316': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108316',
                                           'ip_address': '172.28.12.61',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108317': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108317',
                                           'ip_address': '172.28.12.62',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108318': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108318',
                                           'ip_address': '172.28.12.63',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108319': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108319',
                                           'ip_address': '172.28.12.64',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108320': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108320',
                                           'ip_address': '172.28.12.65',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108321': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108321',
                                           'ip_address': '172.28.12.66',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108322': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108322',
                                           'ip_address': '172.28.12.67',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108323': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108323',
                                           'ip_address': '172.28.12.68',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108324': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108324',
                                           'ip_address': '172.28.12.69',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108325': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108325',
                                           'ip_address': '172.28.12.70',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108326': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108326',
                                           'ip_address': '172.28.12.71',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108327': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108327',
                                           'ip_address': '172.28.12.72',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108328': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108328',
                                           'ip_address': '172.28.12.73',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108329': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108329',
                                           'ip_address': '172.28.12.74',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108330': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108330',
                                           'ip_address': '172.28.12.75',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108331': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108331',
                                           'ip_address': '172.28.12.76',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108332': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108332',
                                           'ip_address': '172.28.12.77',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108333': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108333',
                                           'ip_address': '172.28.12.78',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108334': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108334',
                                           'ip_address': '172.28.12.79',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108335': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108335',
                                           'ip_address': '172.28.12.80',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108336': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108336',
                                           'ip_address': '172.28.12.81',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108337': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108337',
                                           'ip_address': '172.28.12.82',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108338': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108338',
                                           'ip_address': '172.28.12.83',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108339': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108339',
                                           'ip_address': '172.28.12.84',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108340': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108340',
                                           'ip_address': '172.28.12.85',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108341': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108341',
                                           'ip_address': '172.28.12.86',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108342': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108342',
                                           'ip_address': '172.28.12.87',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108343': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108343',
                                           'ip_address': '172.28.12.88',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108344': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108344',
                                           'ip_address': '172.28.12.89',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108345': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108345',
                                           'ip_address': '172.28.12.90',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108346': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108346',
                                           'ip_address': '172.28.12.91',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108347': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108347',
                                           'ip_address': '172.28.12.92',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108348': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108348',
                                           'ip_address': '172.28.12.93',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108349': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108349',
                                           'ip_address': '172.28.12.94',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108350': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108350',
                                           'ip_address': '172.28.12.95',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108351': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108351',
                                           'ip_address': '172.28.12.96',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108352': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108352',
                                           'ip_address': '172.28.12.97',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108353': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108353',
                                           'ip_address': '172.28.12.98',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108354': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108354',
                                           'ip_address': '172.28.12.99',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108355': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108355',
                                           'ip_address': '172.28.12.100',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108356': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108356',
                                           'ip_address': '172.28.12.101',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108357': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108357',
                                           'ip_address': '172.28.12.102',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108358': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108358',
                                           'ip_address': '172.28.12.103',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108359': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108359',
                                           'ip_address': '172.28.12.104',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108360': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108360',
                                           'ip_address': '172.28.12.105',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108361': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108361',
                                           'ip_address': '172.28.12.106',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108362': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108362',
                                           'ip_address': '172.28.12.107',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108363': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108363',
                                           'ip_address': '172.28.12.108',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108364': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108364',
                                           'ip_address': '172.28.12.109',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108365': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108365',
                                           'ip_address': '172.28.12.110',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108400': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108400',
                                           'ip_address': '172.28.12.111',
                                           'name': None,
                                           'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'links': [       {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjczMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzExMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzY0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzY1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4NDAwMQ=='}],
                                                              'mac_address': '0c:a1:38:10:00:68',
                                                              'name': 'WLAN Interface',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjczMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzExMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzY0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzY1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4NDAwMQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'X-300i B48',
                                'serial_number': '60101D2-20481105',
                                'sw_version': '4.1.6_1',
                                'system_mac_address': '0c:a1:38:10:00:68'},
                'peers': [       {       'imsi': '999995432108256',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjU2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjU2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108257',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjU3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjU3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108258',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjU4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjU4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108259',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjU5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjU5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108260',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjYwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjYw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108261',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjYxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjYx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108262',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjYyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjYy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108263',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjYzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjYz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108264',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108266',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108267',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108268',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108269',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108270',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjcwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjcw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108271',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjcxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjcx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108272',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjcyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjcy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108273',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjczMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjcz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108274',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108275',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108276',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108277',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108278',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108279',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108280',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjgwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjgw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108281',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjgxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjgx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108282',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjgyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjgy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108283',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjgzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjgz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108284',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108285',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108286',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108287',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108288',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108289',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108290',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjkwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjkw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108291',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjkxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjkx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108292',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjkyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjky',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108293',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjkzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjkz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108294',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108295',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108296',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108297',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108298',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108299',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108300',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzAwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzAw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108301',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzAxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzAx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108302',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzAyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzAy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108303',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzAzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzAz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108304',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108305',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108306',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108307',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108308',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108309',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108310',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzEwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzEw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108311',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzExMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzEx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108312',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzEyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzEy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108313',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzEzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzEz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108314',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108315',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108316',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108317',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108318',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108319',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108320',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzIwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzIw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108321',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzIxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzIx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108322',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzIyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzIy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108323',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzIzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzIz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108324',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108325',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108326',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108327',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108328',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108329',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108330',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzMwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzMw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108331',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzMxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzMx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108332',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzMyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzMy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108333',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzMzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzMz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108334',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108335',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108336',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108337',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108338',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108339',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108340',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108341',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108342',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108343',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108344',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108345',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108346',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108347',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108348',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108349',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108350',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzUwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzUw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108351',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzUxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzUx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108352',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzUyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzUy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108353',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzUzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzUz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108354',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108355',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108356',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108357',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108358',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108359',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108360',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzYwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzYw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108361',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzYxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzYx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108362',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzYyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzYy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108363',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzYzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzYz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108364',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzY0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzY0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108365',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzY1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzY1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108400',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:10:00:68'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4NDAwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:10:00:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4NDAw',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_FW_300i_B48_3_0_6_1_10_11_254_10(self):
        obj = self.run_data("blinq.enb.FW-300i B48.3.0.6_1.10_11_254_10")
        exp_info = {
                'model': 'FW-300i B48',
                'sta_count': 29,
                'sw_version': '3.0.6_1',
                'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '999995432100825': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100825',
                                           'ip_address': '10.201.12.11',
                                           'name': 'Polk, Ken - Ranch Man Cave',
                                           'ul_rssi': -107.96},
                '999995432100890': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100890',
                                           'ip_address': '10.201.12.19',
                                           'name': 'Haas Snow, Jessi',
                                           'ul_rssi': -117.81},
                '999995432100909': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100909',
                                           'ip_address': '10.201.12.10',
                                           'name': 'Haas, Jo Nell',
                                           'ul_rssi': -100.71},
                '999995432100940': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100940',
                                           'ip_address': '10.201.12.28',
                                           'name': 'Hamilton, Sarah',
                                           'ul_rssi': -111.03},
                '999995432100986': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100986',
                                           'ip_address': '10.201.12.14',
                                           'name': 'Deborah & Monty Safell',
                                           'ul_rssi': -96.34},
                '999995432101034': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101034',
                                           'ip_address': '10.201.12.23',
                                           'name': 'Harvey, Cody',
                                           'ul_rssi': -109.16},
                '999995432101038': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101038',
                                           'ip_address': '10.201.12.29',
                                           'name': 'Heins, Leoris - SuperBLiNQ',
                                           'ul_rssi': -112.25},
                '999995432101045': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101045',
                                           'ip_address': '10.201.12.18',
                                           'name': 'Wiegand, Julie',
                                           'ul_rssi': -112.62},
                '999995432101047': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101047',
                                           'ip_address': '10.201.12.24',
                                           'name': 'Smith, Ron',
                                           'ul_rssi': -100.78},
                '999995432101053': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101053',
                                           'ip_address': '10.201.12.17',
                                           'name': 'Raley, Jacob - SuperBlinq',
                                           'ul_rssi': None},
                '999995432101201': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101201',
                                           'ip_address': '10.201.12.27',
                                           'name': 'Hall, Ann',
                                           'ul_rssi': -105.91},
                '999995432101224': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101224',
                                           'ip_address': '10.201.12.16',
                                           'name': 'Cooper, Alan',
                                           'ul_rssi': -105.84},
                '999995432101234': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101234',
                                           'ip_address': '10.201.12.75',
                                           'name': 'Gray, Steven',
                                           'ul_rssi': None},
                '999995432101245': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101245',
                                           'ip_address': '10.201.12.34',
                                           'name': 'Rieken, Mike',
                                           'ul_rssi': -113.99},
                '999995432102212': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102212',
                                           'ip_address': '10.201.12.30',
                                           'name': 'Smith, Larry - SuperBLiNQ',
                                           'ul_rssi': None},
                '999995432102213': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102213',
                                           'ip_address': '10.201.12.36',
                                           'name': 'Soto, Miranda',
                                           'ul_rssi': None},
                '999995432102214': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102214',
                                           'ip_address': '10.201.12.33',
                                           'name': 'Tabor, Russell - SuperBLiNQ',
                                           'ul_rssi': None},
                '999995432102215': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102215',
                                           'ip_address': '10.201.12.48',
                                           'name': 'Crull, Carla',
                                           'ul_rssi': None},
                '999995432102222': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102222',
                                           'ip_address': '10.201.12.12',
                                           'name': 'Gustafson, Sandra',
                                           'ul_rssi': -101.79},
                '999995432102223': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102223',
                                           'ip_address': '10.201.12.32',
                                           'name': 'Trent, Courtney - SuperBLiNQ',
                                           'ul_rssi': None},
                '999995432102226': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102226',
                                           'ip_address': '10.201.12.52',
                                           'name': 'Stubbs, Kay',
                                           'ul_rssi': None},
                '999995432102227': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102227',
                                           'ip_address': '10.201.12.35',
                                           'name': 'Mieras, Rachel - SuperBLiNQ',
                                           'ul_rssi': None},
                '999995432103388': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432103388',
                                           'ip_address': '10.201.12.53',
                                           'name': 'Smith, Larry #2 - SuperBLiNQ',
                                           'ul_rssi': -105.63},
                '999995432105000': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105000',
                                           'ip_address': '10.201.12.13',
                                           'name': 'Curry, Sean',
                                           'ul_rssi': None},
                '999995432105003': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105003',
                                           'ip_address': '10.201.12.26',
                                           'name': 'Seymour, Robert',
                                           'ul_rssi': None},
                '999995432105007': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105007',
                                           'ip_address': '10.201.12.20',
                                           'name': 'Johnson, Robin',
                                           'ul_rssi': None},
                '999995432105076': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105076',
                                           'ip_address': '10.201.12.25',
                                           'name': 'Stellfox, Marcy',
                                           'ul_rssi': -111.71},
                '999995432105079': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105079',
                                           'ip_address': '10.201.12.31',
                                           'name': 'Wallace, Nick',
                                           'ul_rssi': -113.68},
                '999995432107457': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432107457',
                                           'ip_address': '10.201.12.37',
                                           'name': 'Stubbs, Kay (Replacement)',
                                           'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'links': [       {       'poller_hash': 'OTk5OTk1NDMyMTAwODI1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwODkwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwOTA5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwOTQwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAwOTg2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDM0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDM4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMDUzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMjAxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMjI0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMjM0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAxMjQ1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjEyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjEzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjE0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjE1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjIyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjIzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjI2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAyMjI3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTAzMzg4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDAwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDAzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDA3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDc2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA1MDc5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA3NDU3MQ=='}],
                                                              'mac_address': '0c:a1:38:00:04:98',
                                                              'name': 'WLAN Interface',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'poller_hash': 'OTk5OTk1NDMyMTAwODI1MQ==',
                                                                                                                                            'rssi': -107.96,
                                                                                                                                            'rx_mcs': 21,
                                                                                                                                            'tx_mcs': 24},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwODkwMQ==',
                                                                                                                                            'rssi': -117.81,
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_mcs': 12},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwOTA5MQ==',
                                                                                                                                            'rssi': -100.71,
                                                                                                                                            'rx_mcs': 22,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwOTQwMQ==',
                                                                                                                                            'rssi': -111.03,
                                                                                                                                            'rx_mcs': 15,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAwOTg2MQ==',
                                                                                                                                            'rssi': -96.34,
                                                                                                                                            'rx_mcs': 18,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDM0MQ==',
                                                                                                                                            'rssi': -109.16,
                                                                                                                                            'rx_mcs': 18,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDM4MQ==',
                                                                                                                                            'rssi': -112.25,
                                                                                                                                            'rx_mcs': 13,
                                                                                                                                            'tx_mcs': 22},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ1MQ==',
                                                                                                                                            'rssi': -112.62,
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'tx_mcs': 26},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ3MQ==',
                                                                                                                                            'rssi': -100.78,
                                                                                                                                            'rx_mcs': 23,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMDUzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMjAxMQ==',
                                                                                                                                            'rssi': -105.91,
                                                                                                                                            'rx_mcs': 20,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMjI0MQ==',
                                                                                                                                            'rssi': -105.84,
                                                                                                                                            'rx_mcs': 21,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMjM0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAxMjQ1MQ==',
                                                                                                                                            'rssi': -113.99,
                                                                                                                                            'rx_mcs': 12,
                                                                                                                                            'tx_mcs': 18},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjEyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjEzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjE0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjE1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjIyMQ==',
                                                                                                                                            'rssi': -101.79,
                                                                                                                                            'rx_mcs': 21,
                                                                                                                                            'tx_mcs': 28},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjIzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjI2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAyMjI3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTAzMzg4MQ==',
                                                                                                                                            'rssi': -105.63,
                                                                                                                                            'rx_mcs': 21,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDAwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDAzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDA3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDc2MQ==',
                                                                                                                                            'rssi': -111.71,
                                                                                                                                            'rx_mcs': 14,
                                                                                                                                            'tx_mcs': 26},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA1MDc5MQ==',
                                                                                                                                            'rssi': -113.68,
                                                                                                                                            'rx_mcs': 19,
                                                                                                                                            'tx_mcs': 21},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA3NDU3MQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'FW-300i B48',
                                'serial_number': 'A181107455',
                                'sw_version': '3.0.6_1',
                                'system_mac_address': '0c:a1:38:00:04:98'},
                'peers': [       {       'imsi': '999995432100825',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwODI1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 24,
                                                                                                                                                     'tx_mcs': 21}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Polk, Ken - Ranch Man Cave',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwODI1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100890',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwODkwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 12,
                                                                                                                                                     'tx_mcs': 3}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Haas Snow, Jessi',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwODkw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100909',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwOTA5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 22}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Haas, Jo Nell',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwOTA5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100940',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwOTQwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 15}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Hamilton, Sarah',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwOTQw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432100986',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAwOTg2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 18}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Deborah & Monty Safell',
                                         'poller_hash': 'OTk5OTk1NDMyMTAwOTg2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101034',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDM0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 18}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Harvey, Cody',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDM0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101038',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDM4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 22,
                                                                                                                                                     'tx_mcs': 13}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Heins, Leoris - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDM4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101045',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 26,
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Wiegand, Julie',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDQ1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101047',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDQ3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 23}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Smith, Ron',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDQ3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101053',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMDUzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Raley, Jacob - SuperBlinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMDUz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101201',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMjAxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 20}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Hall, Ann',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMjAx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101224',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMjI0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 21}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Cooper, Alan',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMjI0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101234',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMjM0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Gray, Steven',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMjM0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432101245',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAxMjQ1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 18,
                                                                                                                                                     'tx_mcs': 12}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Rieken, Mike',
                                         'poller_hash': 'OTk5OTk1NDMyMTAxMjQ1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102212',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjEyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Smith, Larry - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjEy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102213',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjEzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Soto, Miranda',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjEz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102214',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjE0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Tabor, Russell - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjE0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102215',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjE1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Crull, Carla',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjE1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102222',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjIyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 28,
                                                                                                                                                     'tx_mcs': 21}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Gustafson, Sandra',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjIy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102223',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjIzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Trent, Courtney - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjIz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102226',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjI2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Stubbs, Kay',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjI2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432102227',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAyMjI3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Mieras, Rachel - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAyMjI3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432103388',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTAzMzg4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 21}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Smith, Larry #2 - SuperBLiNQ',
                                         'poller_hash': 'OTk5OTk1NDMyMTAzMzg4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105000',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDAwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Curry, Sean',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDAw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105003',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDAzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Seymour, Robert',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDAz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105007',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDA3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Johnson, Robin',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDA3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105076',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDc2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 26,
                                                                                                                                                     'tx_mcs': 14}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Stellfox, Marcy',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDc2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432105079',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA1MDc5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98',
                                                                                                                                                     'rx_mcs': 21,
                                                                                                                                                     'tx_mcs': 19}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Wallace, Nick',
                                         'poller_hash': 'OTk5OTk1NDMyMTA1MDc5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432107457',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:04:98'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA3NDU3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:04:98'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Stubbs, Kay (Replacement)',
                                         'poller_hash': 'OTk5OTk1NDMyMTA3NDU3',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_FW_300i_B48_4_0_4_1_01(self):
        obj = self.run_data("blinq.enb.FW-300i B48.4.0.4_1.01")
        exp_info = {
                'model': 'FW-300i B48',
                'sta_count': 110,
                'sw_version': '4.0.4_1',
                'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '999995432108256': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108256',
                                           'ip_address': '172.28.6.2',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108257': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108257',
                                           'ip_address': '172.28.6.3',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108258': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108258',
                                           'ip_address': '172.28.6.4',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108259': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108259',
                                           'ip_address': '172.28.6.5',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108260': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108260',
                                           'ip_address': '172.28.6.6',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108261': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108261',
                                           'ip_address': '172.28.6.7',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108262': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108262',
                                           'ip_address': '172.28.6.8',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108263': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108263',
                                           'ip_address': '172.28.6.9',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108264': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108264',
                                           'ip_address': '172.28.6.10',
                                           'name': 'Karlee_Nelkie',
                                           'ul_rssi': -105.73},
                '999995432108266': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108266',
                                           'ip_address': '172.28.6.11',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108267': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108267',
                                           'ip_address': '172.28.6.12',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108268': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108268',
                                           'ip_address': '172.28.6.13',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108269': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108269',
                                           'ip_address': '172.28.6.14',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108270': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108270',
                                           'ip_address': '172.28.6.15',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108271': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108271',
                                           'ip_address': '172.28.6.16',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108272': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108272',
                                           'ip_address': '172.28.6.17',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108273': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108273',
                                           'ip_address': '172.28.6.18',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108274': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108274',
                                           'ip_address': '172.28.6.19',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108275': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108275',
                                           'ip_address': '172.28.6.20',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108276': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108276',
                                           'ip_address': '172.28.6.21',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108277': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108277',
                                           'ip_address': '172.28.6.22',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108278': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108278',
                                           'ip_address': '172.28.6.23',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108279': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108279',
                                           'ip_address': '172.28.6.24',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108280': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108280',
                                           'ip_address': '172.28.6.25',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108281': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108281',
                                           'ip_address': '172.28.6.26',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108282': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108282',
                                           'ip_address': '172.28.6.27',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108283': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108283',
                                           'ip_address': '172.28.6.28',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108284': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108284',
                                           'ip_address': '172.28.6.29',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108285': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108285',
                                           'ip_address': '172.28.6.30',
                                           'name': 'Clement Township Hall',
                                           'ul_rssi': None},
                '999995432108286': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108286',
                                           'ip_address': '172.28.6.31',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108287': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108287',
                                           'ip_address': '172.28.6.32',
                                           'name': 'Clement_Fire_Hall',
                                           'ul_rssi': None},
                '999995432108288': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108288',
                                           'ip_address': '172.28.6.33',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108289': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108289',
                                           'ip_address': '172.28.6.34',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108290': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108290',
                                           'ip_address': '172.28.6.35',
                                           'name': 'John_Schauflee',
                                           'ul_rssi': None},
                '999995432108291': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108291',
                                           'ip_address': '172.28.6.36',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108292': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108292',
                                           'ip_address': '172.28.6.37',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108293': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108293',
                                           'ip_address': '172.28.6.38',
                                           'name': 'Jay_Rohnda_Moore',
                                           'ul_rssi': None},
                '999995432108294': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108294',
                                           'ip_address': '172.28.6.39',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108295': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108295',
                                           'ip_address': '172.28.6.40',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108296': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108296',
                                           'ip_address': '172.28.6.41',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108297': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108297',
                                           'ip_address': '172.28.6.42',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108298': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108298',
                                           'ip_address': '172.28.6.43',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108299': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108299',
                                           'ip_address': '172.28.6.44',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108300': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108300',
                                           'ip_address': '172.28.6.45',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108301': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108301',
                                           'ip_address': '172.28.6.46',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108302': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108302',
                                           'ip_address': '172.28.6.47',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108303': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108303',
                                           'ip_address': '172.28.6.48',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108304': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108304',
                                           'ip_address': '172.28.6.49',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108305': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108305',
                                           'ip_address': '172.28.6.50',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108306': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108306',
                                           'ip_address': '172.28.6.51',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108307': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108307',
                                           'ip_address': '172.28.6.52',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108308': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108308',
                                           'ip_address': '172.28.6.53',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108309': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108309',
                                           'ip_address': '172.28.6.54',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108310': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108310',
                                           'ip_address': '172.28.6.55',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108311': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108311',
                                           'ip_address': '172.28.6.56',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108312': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108312',
                                           'ip_address': '172.28.6.57',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108313': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108313',
                                           'ip_address': '172.28.6.58',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108314': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108314',
                                           'ip_address': '172.28.6.59',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108315': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108315',
                                           'ip_address': '172.28.6.60',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108316': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108316',
                                           'ip_address': '172.28.6.61',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108317': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108317',
                                           'ip_address': '172.28.6.62',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108318': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108318',
                                           'ip_address': '172.28.6.63',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108319': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108319',
                                           'ip_address': '172.28.6.64',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108320': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108320',
                                           'ip_address': '172.28.6.65',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108321': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108321',
                                           'ip_address': '172.28.6.66',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108322': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108322',
                                           'ip_address': '172.28.6.67',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108323': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108323',
                                           'ip_address': '172.28.6.68',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108324': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108324',
                                           'ip_address': '172.28.6.69',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108325': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108325',
                                           'ip_address': '172.28.6.70',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108326': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108326',
                                           'ip_address': '172.28.6.71',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108327': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108327',
                                           'ip_address': '172.28.6.72',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108328': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108328',
                                           'ip_address': '172.28.6.73',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108329': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108329',
                                           'ip_address': '172.28.6.74',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108330': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108330',
                                           'ip_address': '172.28.6.75',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108331': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108331',
                                           'ip_address': '172.28.6.76',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108332': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108332',
                                           'ip_address': '172.28.6.77',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108333': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108333',
                                           'ip_address': '172.28.6.78',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108334': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108334',
                                           'ip_address': '172.28.6.79',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108335': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108335',
                                           'ip_address': '172.28.6.80',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108336': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108336',
                                           'ip_address': '172.28.6.81',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108337': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108337',
                                           'ip_address': '172.28.6.82',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108338': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108338',
                                           'ip_address': '172.28.6.83',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108339': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108339',
                                           'ip_address': '172.28.6.84',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108340': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108340',
                                           'ip_address': '172.28.6.85',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108341': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108341',
                                           'ip_address': '172.28.6.86',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108342': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108342',
                                           'ip_address': '172.28.6.87',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108343': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108343',
                                           'ip_address': '172.28.6.88',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108344': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108344',
                                           'ip_address': '172.28.6.89',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108345': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108345',
                                           'ip_address': '172.28.6.90',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108346': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108346',
                                           'ip_address': '172.28.6.91',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108347': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108347',
                                           'ip_address': '172.28.6.92',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108348': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108348',
                                           'ip_address': '172.28.6.93',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108349': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108349',
                                           'ip_address': '172.28.6.94',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108350': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108350',
                                           'ip_address': '172.28.6.95',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108351': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108351',
                                           'ip_address': '172.28.6.96',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108352': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108352',
                                           'ip_address': '172.28.6.97',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108353': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108353',
                                           'ip_address': '172.28.6.98',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108354': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108354',
                                           'ip_address': '172.28.6.99',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108355': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108355',
                                           'ip_address': '172.28.6.100',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108356': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108356',
                                           'ip_address': '172.28.6.101',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108357': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108357',
                                           'ip_address': '172.28.6.102',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108358': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108358',
                                           'ip_address': '172.28.6.103',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108359': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108359',
                                           'ip_address': '172.28.6.104',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108360': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108360',
                                           'ip_address': '172.28.6.105',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108361': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108361',
                                           'ip_address': '172.28.6.106',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108362': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108362',
                                           'ip_address': '172.28.6.107',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108363': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108363',
                                           'ip_address': '172.28.6.108',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108364': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108364',
                                           'ip_address': '172.28.6.109',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108365': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108365',
                                           'ip_address': '172.28.6.110',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108400': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108400',
                                           'ip_address': '172.28.6.111',
                                           'name': None,
                                           'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'links': [       {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjczMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzExMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU2MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU3MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU4MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU5MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYwMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYxMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYyMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYzMQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzY0MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4MzY1MQ=='},
                                                                               {       'poller_hash': 'OTk5OTk1NDMyMTA4NDAwMQ=='}],
                                                              'mac_address': '0c:a1:38:00:08:97',
                                                              'name': 'WLAN Interface',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjU5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjYzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY0MQ==',
                                                                                                                                            'rssi': -105.73,
                                                                                                                                            'rx_mcs': 26,
                                                                                                                                            'tx_mcs': 27},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjY5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjcyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjczMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjgzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MjkzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzAzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzA5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzExMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzEzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzE5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzIzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzI5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzMzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzM5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzUzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU2MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU3MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU4MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzU5MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYwMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYxMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYyMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzYzMQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzY0MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4MzY1MQ=='},
                                                                                                                                    {       'poller_hash': 'OTk5OTk1NDMyMTA4NDAwMQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'FW-300i B48',
                                'serial_number': '60101C5-20350026',
                                'sw_version': '4.0.4_1',
                                'system_mac_address': '0c:a1:38:00:08:97'},
                'peers': [       {       'imsi': '999995432108256',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjU2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjU2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108257',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjU3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjU3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108258',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjU4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjU4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108259',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjU5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjU5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108260',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjYwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjYw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108261',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjYxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjYx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108262',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjYyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjYy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108263',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjYzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjYz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108264',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97',
                                                                                                                                                     'rx_mcs': 27,
                                                                                                                                                     'tx_mcs': 26}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Karlee_Nelkie',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108266',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108267',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108268',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108269',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjY5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MjY5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108270',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjcwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjcw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108271',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjcxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjcx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108272',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjcyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjcy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108273',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjczMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjcz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108274',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108275',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108276',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108277',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108278',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108279',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjc5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjc5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108280',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjgwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjgw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108281',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjgxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjgx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108282',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjgyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjgy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108283',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjgzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjgz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108284',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108285',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Clement Township Hall',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108286',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108287',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Clement_Fire_Hall',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108288',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108289',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjg5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjg5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108290',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjkwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'John_Schauflee',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjkw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108291',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjkxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjkx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108292',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjkyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjky',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108293',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MjkzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'name': 'Jay_Rohnda_Moore',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjkz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108294',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108295',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108296',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108297',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108298',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108299',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4Mjk5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4Mjk5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108300',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzAwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzAw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108301',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzAxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzAx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108302',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzAyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzAy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108303',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzAzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzAz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108304',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108305',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108306',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108307',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108308',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108309',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzA5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzA5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108310',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzEwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzEw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108311',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzExMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzEx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108312',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzEyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzEy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108313',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzEzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzEz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108314',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108315',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108316',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108317',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108318',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108319',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzE5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzE5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108320',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzIwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzIw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108321',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzIxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzIx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108322',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzIyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzIy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108323',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzIzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzIz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108324',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108325',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108326',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108327',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108328',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108329',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzI5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzI5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108330',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzMwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzMw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108331',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzMxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzMx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108332',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzMyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzMy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108333',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzMzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzMz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108334',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108335',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108336',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108337',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108338',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108339',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzM5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzM5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108340',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108341',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108342',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108343',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108344',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108345',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108346',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108347',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108348',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108349',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzQ5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzQ5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108350',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzUwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzUw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108351',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzUxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzUx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108352',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzUyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzUy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108353',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzUzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzUz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108354',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108355',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108356',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU2MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU2',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108357',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU3MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU3',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108358',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU4MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108359',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzU5MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzU5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108360',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzYwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzYw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108361',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzYxMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzYx',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108362',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzYyMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzYy',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108363',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzYzMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzYz',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108364',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzY0MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzY0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108365',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4MzY1MQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4MzY1',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'imsi': '999995432108400',
                                         'interfaces': [       {       'links': [       {       'mac_address': '0c:a1:38:00:08:97'}],
                                                                       'name': 'WLAN '
                                                                               'Interface',
                                                                       'poller_hash': 'OTk5OTk1NDMyMTA4NDAwMQ==',
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '0c:a1:38:00:08:97'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Blinq',
                                         'poller_hash': 'OTk5OTk1NDMyMTA4NDAw',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_RevC05_2_0_16_1_01(self):
        obj = self.run_data("blinq.enb.RevC05.2.0.16_1.01")
        exp_info = {
         'model': 'RevC05', 'sta_count': 0, 'sw_version': '2.0.16_1', 'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '0c:a1:38:00:08:f7',
                                                              'name': 'WLAN Interface',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1'}]}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'RevC05',
                                'serial_number': '60101C5-20380052',
                                'sw_version': '2.0.16_1',
                                'system_mac_address': '0c:a1:38:00:08:f7'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
