import os.path
import sys
from tabulate import tabulate

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):
    def test_trango_m900s_M900S_1p2a4H8005D04071403_01(self):
        obj = self.run_data("trango.m900s.M900S.1p2a4H8005D04071403.01")
        exp_info = {
                'model': 'M900S',
                'rf_freq': 918,
                'rf_tx_power': 26,
                'sta_count': 0,
                'sw_version': '1p2a4H8005D04071403',
                'vendor': 'Trango'
        }
        exp_stats = {
                'dl_en_bytes': 4749346,
                'dl_rf_bytes': None,
                'dl_rf_packets': 51393,
                'dl_rf_packets_dropped': None,
                'ul_en_bytes': 566932,
                'ul_rf_bytes': None,
                'ul_rf_packets': 0,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '4749346',
                                                              'name': 'Ethernet '
                                                                      'Interface',
                                                              'oper_up': True,
                                                              'out_octets': '566932',
                                                              'poller_hash': 'AB3hVegv'},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '00:01:de:15:5e:82',
                                                              'name': 'Radio Interface',
                                                              'oper_up': True,
                                                              'out_ucast_pkts': '51393',
                                                              'radios': [       {       'frequency': 918,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 26}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Trango',
                                'model': 'M900S',
                                'sw_version': '1p2a4H8005D04071403',
                                'system_mac_address': '00:01:de:15:5e:82',
                                'uptime': '40109'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_trango_m900s_M900S_2p0r3H8005D06013101_01(self):
        obj = self.run_data("trango.m900s.M900S.2p0r3H8005D06013101.01")
        exp_info = {
                'model': 'M900S',
                'rf_freq': 924,
                'rf_tx_power': 26,
                'sta_count': 2,
                'sw_version': '2p0r3H8005D06013101',
                'vendor': 'Trango'
        }
        exp_stats = {
                'dl_en_bytes': 4185746079,
                'dl_rf_bytes': 2695062413,
                'dl_rf_packets': 192544441,
                'dl_rf_packets_dropped': None,
                'ul_en_bytes': 2418392404,
                'ul_rf_bytes': 2393603038,
                'ul_rf_packets': 142160298,
                'ul_rf_packets_dropped': 582409
        }
        exp_sta_stats = {
                '00:01:de:4c:d0:2a': {       'dev_macs': None,
                                             'dl_link_rate': 3000000,
                                             'dl_rf_bytes': 1439373111,
                                             'dl_rf_packets': 4188010,
                                             'dl_rf_packets_dropped': 67882,
                                             'dl_rssi': -84.0,
                                             'ip_address': '192.168.240.26',
                                             'mac_address': '00:01:de:4c:d0:2a',
                                             'name': 'James,Jack',
                                             'ul_link_rate': 3000000,
                                             'ul_rf_bytes': 268660059,
                                             'ul_rf_packets': 2483814,
                                             'ul_rf_packets_dropped': 89272,
                                             'ul_rssi': -82.0},
                '00:01:de:4c:db:4a': {       'dev_macs': None,
                                             'dl_link_rate': 3000000,
                                             'dl_rf_bytes': 3962643147,
                                             'dl_rf_packets': 442705837,
                                             'dl_rf_packets_dropped': 127605,
                                             'dl_rssi': -76.0,
                                             'ip_address': '192.168.240.66',
                                             'mac_address': '00:01:de:4c:db:4a',
                                             'name': 'PinestoneCrossing',
                                             'ul_link_rate': 3000000,
                                             'ul_rf_bytes': 2233665158,
                                             'ul_rf_packets': 329505234,
                                             'ul_rf_packets_dropped': 10808,
                                             'ul_rssi': -75.0}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '4185746079',
                                                              'name': 'Ethernet '
                                                                      'Interface',
                                                              'oper_up': True,
                                                              'out_octets': '2418392404',
                                                              'poller_hash': 'AB3hVfe/'},
                                                      {       'admin_up': True,
                                                              'in_discards': '582409',
                                                              'in_octets': '2393603038',
                                                              'in_ucast_pkts': '142160298',
                                                              'links': [       {       'in_discards': '89272',
                                                                                       'in_octets': '268660059',
                                                                                       'in_ucast_pkts': '2483814',
                                                                                       'mac_address': '00:01:de:4c:d0:2a',
                                                                                       'out_discards': '67882',
                                                                                       'out_octets': '1439373111',
                                                                                       'out_retransmits': '384214',
                                                                                       'out_ucast_pkts': '4188010'},
                                                                               {       'in_discards': '10808',
                                                                                       'in_octets': '2233665158',
                                                                                       'in_ucast_pkts': '329505234',
                                                                                       'mac_address': '00:01:de:4c:db:4a',
                                                                                       'out_discards': '127605',
                                                                                       'out_octets': '3962643147',
                                                                                       'out_retransmits': '137101',
                                                                                       'out_ucast_pkts': '442705837'}],
                                                              'mac_address': '00:01:de:15:5f:7b',
                                                              'name': 'Radio Interface',
                                                              'oper_up': True,
                                                              'out_octets': '2695062413',
                                                              'out_ucast_pkts': '192544441',
                                                              'radios': [       {       'frequency': 924,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 643,
                                                                                                                                            'mac_address': '00:01:de:4c:d0:2a',
                                                                                                                                            'rssi': -82.0,
                                                                                                                                            'rx_link_rate': '3000000',
                                                                                                                                            'tx_link_rate': '3000000'},
                                                                                                                                    {       'distance': 2092,
                                                                                                                                            'mac_address': '00:01:de:4c:db:4a',
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '3000000',
                                                                                                                                            'tx_link_rate': '3000000'}]}],
                                                                                        'tx_power': 26}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Trango',
                                'model': 'M900S',
                                'sw_version': '2p0r3H8005D06013101',
                                'system_mac_address': '00:01:de:15:5f:7b',
                                'uptime': '2414874'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1439373111',
                                                                       'in_ucast_pkts': '4188010',
                                                                       'links': [       {       'in_octets': '1439373111',
                                                                                                'in_ucast_pkts': '4188010',
                                                                                                'mac_address': '00:01:de:15:5f:7b',
                                                                                                'out_octets': '268660059',
                                                                                                'out_ucast_pkts': '2483814'}],
                                                                       'mac_address': '00:01:de:4c:d0:2a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '268660059',
                                                                       'out_ucast_pkts': '2483814',
                                                                       'radios': [       {       'frequency': 924,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '3000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 643,
                                                                                                                                                     'mac_address': '00:01:de:15:5f:7b',
                                                                                                                                                     'rssi': -84.0,
                                                                                                                                                     'rx_link_rate': '3000000',
                                                                                                                                                     'tx_link_rate': '3000000'}]}],
                                                                                                 'tx_link_rate': '3000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.240.26',
                                         'manufacturer': 'Trango',
                                         'name': 'James,Jack',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:01:de:4c:d0:2a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '3962643147',
                                                                       'in_ucast_pkts': '442705837',
                                                                       'links': [       {       'in_octets': '3962643147',
                                                                                                'in_ucast_pkts': '442705837',
                                                                                                'mac_address': '00:01:de:15:5f:7b',
                                                                                                'out_octets': '2233665158',
                                                                                                'out_ucast_pkts': '329505234'}],
                                                                       'mac_address': '00:01:de:4c:db:4a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2233665158',
                                                                       'out_ucast_pkts': '329505234',
                                                                       'radios': [       {       'frequency': 924,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '3000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 2092,
                                                                                                                                                     'mac_address': '00:01:de:15:5f:7b',
                                                                                                                                                     'rssi': -76.0,
                                                                                                                                                     'rx_link_rate': '3000000',
                                                                                                                                                     'tx_link_rate': '3000000'}]}],
                                                                                                 'tx_link_rate': '3000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.240.66',
                                         'manufacturer': 'Trango',
                                         'name': 'PinestoneCrossing',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:01:de:4c:db:4a'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_trango_m900s_M900S_2p1r1H8005D06101801_01(self):
        obj = self.run_data("trango.m900s.M900S.2p1r1H8005D06101801.01")
        exp_info = {
                'model': 'M900S',
                'rf_freq': 924,
                'rf_tx_power': 26,
                'sta_count': 4,
                'sw_version': '2p1r1H8005D06101801',
                'vendor': 'Trango'
        }
        exp_stats = {
                'dl_en_bytes': 2690227221,
                'dl_rf_bytes': 704517519,
                'dl_rf_packets': 208783723,
                'dl_rf_packets_dropped': None,
                'ul_en_bytes': 1986156428,
                'ul_rf_bytes': 722089994,
                'ul_rf_packets': 159055534,
                'ul_rf_packets_dropped': 101151371
        }
        exp_sta_stats = {
                '00:01:de:4c:d6:7a': {       'dev_macs': None,
                                             'dl_link_rate': 3000000,
                                             'dl_rf_bytes': 3001249332,
                                             'dl_rf_packets': 5781339,
                                             'dl_rf_packets_dropped': 2654,
                                             'dl_rssi': -56.0,
                                             'ip_address': '192.168.244.51',
                                             'mac_address': '00:01:de:4c:d6:7a',
                                             'name': 'Haarala,Lawrence',
                                             'ul_link_rate': 3000000,
                                             'ul_rf_bytes': 881874078,
                                             'ul_rf_packets': 4433718,
                                             'ul_rf_packets_dropped': 900,
                                             'ul_rssi': -61.0},
                '00:01:de:4c:d9:02': {       'dev_macs': None,
                                             'dl_link_rate': 3000000,
                                             'dl_rf_bytes': 4286239965,
                                             'dl_rf_packets': 4578156,
                                             'dl_rf_packets_dropped': 33236,
                                             'dl_rssi': -81.0,
                                             'ip_address': '192.168.244.44',
                                             'mac_address': '00:01:de:4c:d9:02',
                                             'name': 'Swartz,MaryLou',
                                             'ul_link_rate': 3000000,
                                             'ul_rf_bytes': 1154341091,
                                             'ul_rf_packets': 3315191,
                                             'ul_rf_packets_dropped': 73625,
                                             'ul_rssi': -80.0},
                '00:01:de:4c:db:9c': {       'dev_macs': None,
                                             'dl_link_rate': 3000000,
                                             'dl_rf_bytes': 1256904174,
                                             'dl_rf_packets': 5343700,
                                             'dl_rf_packets_dropped': 12057,
                                             'dl_rssi': -78.0,
                                             'ip_address': '192.168.244.18',
                                             'mac_address': '00:01:de:4c:db:9c',
                                             'name': 'Gherardini,Norm',
                                             'ul_link_rate': 3000000,
                                             'ul_rf_bytes': 579000134,
                                             'ul_rf_packets': 3501538,
                                             'ul_rf_packets_dropped': 25287,
                                             'ul_rssi': -76.0},
                '00:01:de:4c:db:a4': {       'dev_macs': None,
                                             'dl_link_rate': 1000000,
                                             'dl_rf_bytes': 188416047,
                                             'dl_rf_packets': 4145632,
                                             'dl_rf_packets_dropped': 22236,
                                             'dl_rssi': -81.0,
                                             'ip_address': '192.168.244.46',
                                             'mac_address': '00:01:de:4c:db:a4',
                                             'name': 'Nyman,Becky',
                                             'ul_link_rate': 1000000,
                                             'ul_rf_bytes': 439323667,
                                             'ul_rf_packets': 3207578,
                                             'ul_rf_packets_dropped': 29275,
                                             'ul_rssi': -78.0}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_octets': '2690227221',
                                                              'name': 'Ethernet '
                                                                      'Interface',
                                                              'oper_up': True,
                                                              'out_octets': '1986156428',
                                                              'poller_hash': 'AB3hVwLv'},
                                                      {       'admin_up': True,
                                                              'in_discards': '101151371',
                                                              'in_octets': '722089994',
                                                              'in_ucast_pkts': '159055534',
                                                              'links': [       {       'in_discards': '25287',
                                                                                       'in_octets': '579000134',
                                                                                       'in_ucast_pkts': '3501538',
                                                                                       'mac_address': '00:01:de:4c:db:9c',
                                                                                       'out_discards': '12057',
                                                                                       'out_octets': '1256904174',
                                                                                       'out_retransmits': '248457',
                                                                                       'out_ucast_pkts': '5343700'},
                                                                               {       'in_discards': '73625',
                                                                                       'in_octets': '1154341091',
                                                                                       'in_ucast_pkts': '3315191',
                                                                                       'mac_address': '00:01:de:4c:d9:02',
                                                                                       'out_discards': '33236',
                                                                                       'out_octets': '4286239965',
                                                                                       'out_retransmits': '603716',
                                                                                       'out_ucast_pkts': '4578156'},
                                                                               {       'in_discards': '29275',
                                                                                       'in_octets': '439323667',
                                                                                       'in_ucast_pkts': '3207578',
                                                                                       'mac_address': '00:01:de:4c:db:a4',
                                                                                       'out_discards': '22236',
                                                                                       'out_octets': '188416047',
                                                                                       'out_retransmits': '257335',
                                                                                       'out_ucast_pkts': '4145632'},
                                                                               {       'in_discards': '900',
                                                                                       'in_octets': '881874078',
                                                                                       'in_ucast_pkts': '4433718',
                                                                                       'mac_address': '00:01:de:4c:d6:7a',
                                                                                       'out_discards': '2654',
                                                                                       'out_octets': '3001249332',
                                                                                       'out_retransmits': '13812',
                                                                                       'out_ucast_pkts': '5781339'}],
                                                              'mac_address': '00:01:de:15:70:2e',
                                                              'name': 'Radio Interface',
                                                              'oper_up': True,
                                                              'out_octets': '704517519',
                                                              'out_ucast_pkts': '208783723',
                                                              'radios': [       {       'frequency': 924,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 2414,
                                                                                                                                            'mac_address': '00:01:de:4c:db:9c',
                                                                                                                                            'rssi': -76.0,
                                                                                                                                            'rx_link_rate': '3000000',
                                                                                                                                            'tx_link_rate': '3000000'},
                                                                                                                                    {       'distance': 2092,
                                                                                                                                            'mac_address': '00:01:de:4c:d9:02',
                                                                                                                                            'rssi': -80.0,
                                                                                                                                            'rx_link_rate': '3000000',
                                                                                                                                            'tx_link_rate': '3000000'},
                                                                                                                                    {       'distance': 2574,
                                                                                                                                            'mac_address': '00:01:de:4c:db:a4',
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'rx_link_rate': '1000000',
                                                                                                                                            'tx_link_rate': '1000000'},
                                                                                                                                    {       'distance': 482,
                                                                                                                                            'mac_address': '00:01:de:4c:d6:7a',
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '3000000',
                                                                                                                                            'tx_link_rate': '3000000'}]}],
                                                                                        'tx_power': 26}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Trango',
                                'model': 'M900S',
                                'sw_version': '2p1r1H8005D06101801',
                                'system_mac_address': '00:01:de:15:70:2e',
                                'uptime': '315123'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '1256904174',
                                                                       'in_ucast_pkts': '5343700',
                                                                       'links': [       {       'in_octets': '1256904174',
                                                                                                'in_ucast_pkts': '5343700',
                                                                                                'mac_address': '00:01:de:15:70:2e',
                                                                                                'out_octets': '579000134',
                                                                                                'out_ucast_pkts': '3501538'}],
                                                                       'mac_address': '00:01:de:4c:db:9c',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '579000134',
                                                                       'out_ucast_pkts': '3501538',
                                                                       'radios': [       {       'frequency': 924,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '3000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 2414,
                                                                                                                                                     'mac_address': '00:01:de:15:70:2e',
                                                                                                                                                     'rssi': -78.0,
                                                                                                                                                     'rx_link_rate': '3000000',
                                                                                                                                                     'tx_link_rate': '3000000'}]}],
                                                                                                 'tx_link_rate': '3000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.244.18',
                                         'manufacturer': 'Trango',
                                         'name': 'Gherardini,Norm',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:01:de:4c:db:9c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '4286239965',
                                                                       'in_ucast_pkts': '4578156',
                                                                       'links': [       {       'in_octets': '4286239965',
                                                                                                'in_ucast_pkts': '4578156',
                                                                                                'mac_address': '00:01:de:15:70:2e',
                                                                                                'out_octets': '1154341091',
                                                                                                'out_ucast_pkts': '3315191'}],
                                                                       'mac_address': '00:01:de:4c:d9:02',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1154341091',
                                                                       'out_ucast_pkts': '3315191',
                                                                       'radios': [       {       'frequency': 924,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '3000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 2092,
                                                                                                                                                     'mac_address': '00:01:de:15:70:2e',
                                                                                                                                                     'rssi': -81.0,
                                                                                                                                                     'rx_link_rate': '3000000',
                                                                                                                                                     'tx_link_rate': '3000000'}]}],
                                                                                                 'tx_link_rate': '3000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.244.44',
                                         'manufacturer': 'Trango',
                                         'name': 'Swartz,MaryLou',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:01:de:4c:d9:02'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '188416047',
                                                                       'in_ucast_pkts': '4145632',
                                                                       'links': [       {       'in_octets': '188416047',
                                                                                                'in_ucast_pkts': '4145632',
                                                                                                'mac_address': '00:01:de:15:70:2e',
                                                                                                'out_octets': '439323667',
                                                                                                'out_ucast_pkts': '3207578'}],
                                                                       'mac_address': '00:01:de:4c:db:a4',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '439323667',
                                                                       'out_ucast_pkts': '3207578',
                                                                       'radios': [       {       'frequency': 924,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 2574,
                                                                                                                                                     'mac_address': '00:01:de:15:70:2e',
                                                                                                                                                     'rssi': -81.0,
                                                                                                                                                     'rx_link_rate': '1000000',
                                                                                                                                                     'tx_link_rate': '1000000'}]}],
                                                                                                 'tx_link_rate': '1000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.244.46',
                                         'manufacturer': 'Trango',
                                         'name': 'Nyman,Becky',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:01:de:4c:db:a4'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '3001249332',
                                                                       'in_ucast_pkts': '5781339',
                                                                       'links': [       {       'in_octets': '3001249332',
                                                                                                'in_ucast_pkts': '5781339',
                                                                                                'mac_address': '00:01:de:15:70:2e',
                                                                                                'out_octets': '881874078',
                                                                                                'out_ucast_pkts': '4433718'}],
                                                                       'mac_address': '00:01:de:4c:d6:7a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '881874078',
                                                                       'out_ucast_pkts': '4433718',
                                                                       'radios': [       {       'frequency': 924,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '3000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 482,
                                                                                                                                                     'mac_address': '00:01:de:15:70:2e',
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '3000000',
                                                                                                                                                     'tx_link_rate': '3000000'}]}],
                                                                                                 'tx_link_rate': '3000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.244.51',
                                         'manufacturer': 'Trango',
                                         'name': 'Haarala,Lawrence',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:01:de:4c:d6:7a'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
