import asyncio
from collections import namedtuple
import os
import sys
import unittest

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
import olt
from preseem import NetworkMetadataReference, Reference
from preseem.network_element_update import NetworkElementUpdate
from fake_context import FakeContext

class Olt(olt.Olt):
    """We subclass the Olt object to add some test synchronization helpers"""
    async def poll(self):
        FakeContext.ap_event.clear()
        await super().poll()
        FakeContext.ap_event.set()

class FakeClient:
    def __init__(self, host=None):
        self.dft = {}
        self.host = host

class FakeModule:
    def __init__(self):
        self.stations = []
        self.model = None
        self.mode = "ap"  # I'm not sure yet if this should be changed to olt.

    async def poll(self):
        self.network_element_update_msg = NetworkElementUpdate()


class TestOLT(unittest.TestCase):
    def setUp(self):
        self.ctx = FakeContext()
        self.loop = asyncio.new_event_loop() # needed to initialize asyncio
        asyncio.set_event_loop(self.loop)
        self._await(self.ctx.start())

    def tearDown(self):
        self._await(self.ctx.close())
        self.loop.close()

    def _await(self, co):
        return self.loop.run_until_complete(co)

    def test_olt_poll(self):
        """Test polling of an OLT element type."""
        olt = Olt(self.ctx, 'TestAP', 'TestAP', 'MySite', FakeClient('MyHost'), None, 'olt', None)
        olt.module = FakeModule()
        self._await(olt.load())

        # For now we're just testing some very basic functionality.
        topology1_snmp_refs = self.ctx.netmeta_model.refs.get('topology1_snmp') or {}
        neu = getattr(olt, 'network_element_update_msg', None)
        self.assertEqual(len(topology1_snmp_refs), 1)
        self.assertIsNotNone(neu)
