import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestAdtranModels(DeviceTestCase):

    def test_adtran_ta5000_TA5000_11_1_5_4_01(self):
        obj = self.run_data("adtran.ta5000.TA5000.11.1.5.4.01")
        exp_info = {'model': 'TA5000', 'sw_version': '11.1.5.4', 'vendor': 'Adtran'}
        exp_stats = {'serial_number': 'LBADTN2112AM202'}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'manufacturer':
                'Adtran',
                'model':
                'TA5000',
                'modules': [{
                    'id':
                    '1',
                    'interfaces': [{
                        'admin_up': True,
                        'id': '100001',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/1/1',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxMDE=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '100002',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/1/2',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjM=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '100003',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/1/3',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA5MDc=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '100004',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/1/4',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAyMzE=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '100005',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/1/5',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAwNjU=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '100006',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/1/6',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDA0NjQ=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '100007',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/1/7',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAzNTM=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '100008',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/1/8',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODUzVVc5QjcwMDAxNjc=',
                        'type': 208
                    }],
                    'manufacturer':
                    'Adtran',
                    'mem':
                    31.035233,
                    'model':
                    '1187518F1',
                    'name':
                    'COMBO OLT 8P',
                    'poller_hash':
                    'TEJBRFROMjEyOUNEODUzMTE4NzUxOEYx',
                    'serial_number':
                    'LBADTN2129CD853',
                    'sw_version':
                    '11.1.5.4.11',
                    'temperature':
                    34.0,
                    'uptime':
                    '10993448'
                }, {
                    'id':
                    '2',
                    'interfaces': [{
                        'admin_up': True,
                        'id': '200001',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/2/1',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjYwMDA2NTU=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '200002',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/2/2',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDEyMjc=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '200003',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/2/3',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDE2MTE=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '200004',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/2/4',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA1Nzc=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '200005',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/2/5',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDAzMjk=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '200006',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/2/6',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA1NTk=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '200007',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/2/7',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDAxNDk=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '200008',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/2/8',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNEODY5VVc5QjcwMDA0NzQ=',
                        'type': 208
                    }],
                    'manufacturer':
                    'Adtran',
                    'mem':
                    30.529404,
                    'model':
                    '1187518F1',
                    'name':
                    'COMBO OLT 8P',
                    'poller_hash':
                    'TEJBRFROMjEyOUNEODY5MTE4NzUxOEYx',
                    'serial_number':
                    'LBADTN2129CD869',
                    'sw_version':
                    '11.1.5.4.11',
                    'temperature':
                    34.6,
                    'uptime':
                    '10993458'
                }, {
                    'id': '251',
                    'manufacturer': 'Adtran',
                    'model': '1187080G3',
                    'name': 'Fan Module',
                    'poller_hash': 'TEJBRFROMjExM0FLNjY1MTE4NzA4MEcz',
                    'serial_number': 'LBADTN2113AK665',
                    'sw_version': 'A03.00',
                    'uptime': '20061534'
                }, {
                    'id':
                    '252',
                    'interfaces': [{
                        'admin_up': True,
                        'id': '25200001',
                        'in_discards': '1064026',
                        'in_nucast_pkts': '1572100',
                        'in_octets': '76540597918',
                        'in_ucast_pkts': '56177713',
                        'mac_address': '00:24:45:f5:11:24',
                        'manufacturer': 'Hisense',
                        'model': 'ADTRAN '
                        '10GBASE-LR10',
                        'mtu': 12288,
                        'name': 'ten-gigabit-ethernet '
                        '1/A/1',
                        'oper_up': True,
                        'out_nucast_pkts': '2709',
                        'out_octets': '5073841183',
                        'out_ucast_pkts': '18776525',
                        'poller_hash': 'TEJBRFROMjExM0FLMTcySjgzQjdEMDAzMDc=',
                        'speed': '4294967295',
                        'type': 6
                    }, {
                        'admin_up': False,
                        'id': '25200002',
                        'mac_address': '00:24:45:f5:11:25',
                        'name': 'ten-gigabit-ethernet '
                        '1/A/2',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjExM0FLMTcyMDAyNDQ1ZjUxMTI1',
                        'type': 6
                    }, {
                        'admin_up': False,
                        'id': '25200003',
                        'mac_address': '00:24:45:f5:11:26',
                        'name': 'ten-gigabit-ethernet '
                        '1/A/3',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjExM0FLMTcyMDAyNDQ1ZjUxMTI2',
                        'type': 6
                    }, {
                        'admin_up': False,
                        'id': '25200004',
                        'mac_address': '00:24:45:f5:11:27',
                        'name': 'ten-gigabit-ethernet '
                        '1/A/4',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjExM0FLMTcyMDAyNDQ1ZjUxMTI3',
                        'type': 6
                    }],
                    'manufacturer':
                    'Adtran',
                    'mem':
                    9.840206,
                    'model':
                    '1187041F1',
                    'name':
                    'SM 4-10G',
                    'poller_hash':
                    'TEJBRFROMjExM0FLMTcyMTE4NzA0MUYx',
                    'serial_number':
                    'LBADTN2113AK172',
                    'sw_version':
                    'L15.0336',
                    'temperature':
                    45.5,
                    'uptime':
                    '20061534'
                }, {
                    'id':
                    '253',
                    'interfaces': [{
                        'admin_up': True,
                        'id': '25300001',
                        'in_discards': '1225666',
                        'in_nucast_pkts': '1480865',
                        'in_octets': '102139673',
                        'in_ucast_pkts': '25',
                        'mac_address': '00:24:45:f5:0f:62',
                        'manufacturer': 'Hisense',
                        'model': 'ADTRAN '
                        '10GBASE-LR10',
                        'mtu': 12288,
                        'name': 'ten-gigabit-ethernet '
                        '1/B/1',
                        'oper_up': True,
                        'out_nucast_pkts': '101',
                        'out_octets': '9191',
                        'poller_hash': 'TEJBRFROMjExM0FLMTYzSjgzQjdEMDA4MTA=',
                        'speed': '4294967295',
                        'type': 6
                    }, {
                        'admin_up': False,
                        'id': '25300002',
                        'mac_address': '00:24:45:f5:0f:63',
                        'name': 'ten-gigabit-ethernet '
                        '1/B/2',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjExM0FLMTYzMDAyNDQ1ZjUwZjYz',
                        'type': 6
                    }, {
                        'admin_up': False,
                        'id': '25300003',
                        'mac_address': '00:24:45:f5:0f:64',
                        'name': 'ten-gigabit-ethernet '
                        '1/B/3',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjExM0FLMTYzMDAyNDQ1ZjUwZjY0',
                        'type': 6
                    }, {
                        'admin_up': False,
                        'id': '25300004',
                        'mac_address': '00:24:45:f5:0f:65',
                        'name': 'ten-gigabit-ethernet '
                        '1/B/4',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjExM0FLMTYzMDAyNDQ1ZjUwZjY1',
                        'type': 6
                    }],
                    'manufacturer':
                    'Adtran',
                    'mem':
                    9.821498,
                    'model':
                    '1187041F1',
                    'name':
                    'SM 4-10G',
                    'poller_hash':
                    'TEJBRFROMjExM0FLMTYzMTE4NzA0MUYx',
                    'serial_number':
                    'LBADTN2113AK163',
                    'sw_version':
                    'L15.0336',
                    'uptime':
                    '20061847'
                }, {
                    'id':
                    '254',
                    'interfaces': [{
                        'admin_up': True,
                        'id': '1',
                        'mac_address': '00:24:45:e8:52:fb',
                        'manufacturer': 'Adtran',
                        'mtu': 1500,
                        'name': 'eth0',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjExMUFBMDM5MDAyNDQ1ZTg1MmZi',
                        'speed': '100000000',
                        'type': 6
                    }, {
                        'admin_up': True,
                        'id': '3',
                        'in_discards': '29',
                        'in_unknown_protos': '3922559',
                        'mac_address': '00:24:45:e8:52:fd',
                        'manufacturer': 'Adtran',
                        'mtu': 1500,
                        'name': 'eth5',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjExMUFBMDM5MDAyNDQ1ZTg1MmZk',
                        'speed': '100000000',
                        'type': 6
                    }],
                    'manufacturer':
                    'Adtran',
                    'mem':
                    41.98529,
                    'model':
                    '1187011F3',
                    'name':
                    'SCM',
                    'poller_hash':
                    'TEJBRFROMjExMUFBMDM5MTE4NzAxMUYz',
                    'serial_number':
                    'LBADTN2111AA039',
                    'sw_version':
                    'L15.028',
                    'uptime':
                    '10993375'
                }, {
                    'id':
                    '3',
                    'interfaces': [{
                        'admin_up': True,
                        'id': '300001',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/3/1',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA0MDc=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '300002',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/3/2',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAwMzc=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '300003',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/3/3',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA1ODE=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '300004',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/3/4',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDEyMzE=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '300005',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/3/5',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAxNDM=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '300006',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/3/6',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA2NjA=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '300007',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/3/7',
                        'oper_up': False,
                        'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDA5ODU=',
                        'type': 208
                    }, {
                        'admin_up': True,
                        'id': '300008',
                        'manufacturer': 'Adtran',
                        'model': '1442543F2',
                        'name': 'gpon '
                        '1/3/8',
                        'oper_up': True,
                        'poller_hash': 'TEJBRFROMjEyOUNFMDEyVVc5QjcwMDAxODA=',
                        'type': 208
                    }],
                    'manufacturer':
                    'Adtran',
                    'mem':
                    30.221558,
                    'model':
                    '1187518F1',
                    'name':
                    'COMBO OLT 8P',
                    'poller_hash':
                    'TEJBRFROMjEyOUNFMDEyMTE4NzUxOEYx',
                    'serial_number':
                    'LBADTN2129CE012',
                    'sw_version':
                    '11.1.5.4.11',
                    'temperature':
                    33.0,
                    'uptime':
                    '10993440'
                }],
                'poller_hash':
                'TEJBRFROMjExMkFNMjAy',
                'serial_number':
                'LBADTN2112AM202',
                'sw_version':
                '11.1.5.4',
                'system_mac_address':
                '00:24:45:e8:52:fb'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
