import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):
    def setUp(self):
        super().setUp()

    def test_radwin_winlink_RW_5AB5_0658_4_9_58_01(self):
        obj = self.run_data("radwin.winlink.RW-5AB5-0658.4.9.58.01")
        exp_info = {
                'model': 'RW-5AB5-0658',
                'rf_chan_width': 20,
                'rf_freq': 5795,
                'sta_count': 2,
                'sw_version': '4.9.58_b0004_Jun 24 2018',
                'vendor': 'Radwin'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:15:67:f6:27:4a': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -60.0,
                                             'ip_address': '10.4.0.1',
                                             'mac_address': '00:15:67:f6:27:4a',
                                             'name': 'Franz Funk - 228',
                                             'ul_rssi': -63.0},
                '00:15:67:f6:2a:b0': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -64.0,
                                             'ip_address': '10.4.0.11',
                                             'mac_address': '00:15:67:f6:2a:b0',
                                             'name': 'Ben Funk - 256',
                                             'ul_rssi': -69.0}
        }
        exp_ne_msg = {
                'data': {       'elevation': 1047.0,
                                'gps_sats_tracked': 6,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '8079925',
                                                              'in_octets': '938340465',
                                                              'in_ucast_pkts': '65041072',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:15:67:e3:fd:23',
                                                              'mtu': 2047,
                                                              'name': 'Management Port '
                                                                      'on Odu',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '40',
                                                              'out_octets': '3172889896',
                                                              'out_ucast_pkts': '33423104',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'in_octets': '3172960309',
                                                              'in_ucast_pkts': '33423782',
                                                              'links': [       {       'in_octets': '998813206',
                                                                                       'in_ucast_pkts': '12449033',
                                                                                       'mac_address': '00:15:67:f6:27:4a',
                                                                                       'out_octets': '486355497',
                                                                                       'out_ucast_pkts': '33935914'},
                                                                               {       'in_octets': '1266599964',
                                                                                       'in_ucast_pkts': '13882917',
                                                                                       'mac_address': '00:15:67:f6:2a:b0',
                                                                                       'out_octets': '3499038136',
                                                                                       'out_ucast_pkts': '44658541'}],
                                                              'mac_address': '00:15:67:68:b0:5e',
                                                              'name': 'Radio Interface',
                                                              'out_octets': '938449363',
                                                              'out_ucast_pkts': '73122075',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'frame_duration': 1250,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5795,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:15:67:f6:27:4a',
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '173333333',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '00:15:67:f6:2a:b0',
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '144444444',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '115555555',
                                                                                                                                            'tx_mcs': 5}]}],
                                                                                        'tx_power': 13}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'tx-4southwest'}]}],
                                'latitude': 32.682926,
                                'longitude': -102.673756,
                                'manufacturer': 'Radwin',
                                'model': 'RW-5AB5-0658',
                                'poller_hash': 'ABVnaLBe',
                                'serial_number': 'C16280IB00J00449',
                                'sw_version': '4.9.58_b0004_Jun 24 2018',
                                'system_mac_address': '00:15:67:e3:fd:23',
                                'temperature': 44.0,
                                'uptime': '436034'},
                'peers': [       {       'interfaces': [       {       'in_octets': '486355497',
                                                                       'in_ucast_pkts': '33935914',
                                                                       'links': [       {       'in_octets': '486355497',
                                                                                                'in_ucast_pkts': '33935914',
                                                                                                'mac_address': '00:15:67:68:b0:5e',
                                                                                                'out_octets': '998813206',
                                                                                                'out_ucast_pkts': '12449033'}],
                                                                       'mac_address': '00:15:67:f6:27:4a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '998813206',
                                                                       'out_ucast_pkts': '12449033',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '173333333',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:b0:5e',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '173333333',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '130000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '130000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'tx-4southwest'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '998813206',
                                                                       'in_ucast_pkts': '12449033',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '486355497',
                                                                       'out_ucast_pkts': '33935914',
                                                                       'poller_hash': 'MDAxNTY3ZjYyNzRhTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 32.67861,
                                         'longitude': -102.68162,
                                         'management_ip': '10.4.0.1',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Franz Funk - 228',
                                         'poller_hash': 'ABVn9idK',
                                         'serial_number': 'P15000I000T00770',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3499038136',
                                                                       'in_ucast_pkts': '44658541',
                                                                       'links': [       {       'in_octets': '3499038136',
                                                                                                'in_ucast_pkts': '44658541',
                                                                                                'mac_address': '00:15:67:68:b0:5e',
                                                                                                'out_octets': '1266599964',
                                                                                                'out_ucast_pkts': '13882917'}],
                                                                       'mac_address': '00:15:67:f6:2a:b0',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1266599964',
                                                                       'out_ucast_pkts': '13882917',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '115555555',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:b0:5e',
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '115555555',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '144444444',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '144444444'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'tx-4southwest'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1266599964',
                                                                       'in_ucast_pkts': '13882917',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3499038136',
                                                                       'out_ucast_pkts': '44658541',
                                                                       'poller_hash': 'MDAxNTY3ZjYyYWIwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 32.67884,
                                         'longitude': -102.68188,
                                         'management_ip': '10.4.0.11',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Ben Funk - 256',
                                         'poller_hash': 'ABVn9iqw',
                                         'serial_number': 'P15000I000Q01260',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_radwin_winlink_RW_5AB5_0658_4_9_60_01(self):
        obj = self.run_data("radwin.winlink.RW-5AB5-0658.4.9.60.01")
        exp_info = {
                'model': 'RW-5AB5-0658',
                'rf_chan_width': 40,
                'rf_freq': 5190,
                'sta_count': 21,
                'sw_version': '4.9.60_b0051_Nov 11 2018',
                'vendor': 'Radwin'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:15:67:00:56:23': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -58.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:00:56:23',
                                             'name': 'Sabastion Chad',
                                             'ul_rssi': -68.0},
                '00:15:67:62:f6:00': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -53.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:62:f6:00',
                                             'name': 'Melody&RobertWalker',
                                             'ul_rssi': -65.0},
                '00:15:67:e2:87:73': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -55.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:e2:87:73',
                                             'name': 'MonteHazen',
                                             'ul_rssi': -64.0},
                '00:15:67:e2:b3:0c': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -47.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:e2:b3:0c',
                                             'name': 'FarmersUnion',
                                             'ul_rssi': -71.0},
                '00:15:67:e2:d3:ee': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -53.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:e2:d3:ee',
                                             'name': 'JaniceArent',
                                             'ul_rssi': -71.0},
                '00:15:67:e2:d6:2d': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -81.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:e2:d6:2d',
                                             'name': 'LouisNancy Stoeger',
                                             'ul_rssi': -91.0},
                '00:15:67:e3:ae:01': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -54.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:e3:ae:01',
                                             'name': 'ClaytonSchmitz',
                                             'ul_rssi': -66.0},
                '00:15:67:f7:99:af': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -71.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:99:af',
                                             'name': 'AGValley-MaywoodFertilizer',
                                             'ul_rssi': -75.0},
                '00:15:67:f7:99:be': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -55.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:99:be',
                                             'name': 'UspsMaywood',
                                             'ul_rssi': -64.0},
                '00:15:67:f7:99:cd': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -50.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:99:cd',
                                             'name': 'AgValley-MaywoodOfficeStation',
                                             'ul_rssi': -68.0},
                '00:15:67:f7:9a:18': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -73.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:9a:18',
                                             'name': 'BrookeTravisHatfield',
                                             'ul_rssi': -84.0},
                '00:15:67:f7:9a:24': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -52.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:9a:24',
                                             'name': 'KarenHastings',
                                             'ul_rssi': -68.0},
                '00:15:67:f7:a1:00': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -61.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:a1:00',
                                             'name': 'CHARLAWERKMEISTER',
                                             'ul_rssi': -74.0},
                '00:15:67:f7:a1:03': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -50.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:a1:03',
                                             'name': 'Lucas Mccain',
                                             'ul_rssi': -70.0},
                '00:15:67:f7:a1:06': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -73.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:a1:06',
                                             'name': 'TraciVandrimmelen',
                                             'ul_rssi': -79.0},
                '00:15:67:f7:a1:12': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -54.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:a1:12',
                                             'name': 'MaywoodUnitedMethodis',
                                             'ul_rssi': -64.0},
                '00:15:67:f7:a2:0b': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -60.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:a2:0b',
                                             'name': 'Alicia Shirley',
                                             'ul_rssi': -66.0},
                '00:15:67:f7:a3:10': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -70.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:a3:10',
                                             'name': 'EricMerritt',
                                             'ul_rssi': -71.0},
                '00:15:67:f7:a5:9a': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -61.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:a5:9a',
                                             'name': 'ScottDavis',
                                             'ul_rssi': -68.0},
                '00:15:67:f7:bc:e2': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -60.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:bc:e2',
                                             'name': 'TerraPeitz',
                                             'ul_rssi': -65.0},
                '00:15:67:f7:bd:12': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -54.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:bd:12',
                                             'name': 'HeatherGrimes',
                                             'ul_rssi': -68.0}
        }
        exp_ne_msg = {
                'data': {       'elevation': 876.0,
                                'gps_sats_tracked': 9,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '65536054',
                                                              'in_octets': '39018842',
                                                              'in_ucast_pkts': '3575847017',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:15:67:69:2b:54',
                                                              'mtu': 2047,
                                                              'name': 'Management Port '
                                                                      'on Odu',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1321744',
                                                              'out_octets': '534757722',
                                                              'out_ucast_pkts': '3308482812',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'in_octets': '535882710',
                                                              'in_ucast_pkts': '3309812094',
                                                              'links': [       {       'in_octets': '2889885596',
                                                                                       'in_ucast_pkts': '25182565',
                                                                                       'mac_address': '00:15:67:e2:b3:0c',
                                                                                       'out_octets': '2173418040',
                                                                                       'out_ucast_pkts': '44963719'},
                                                                               {       'in_octets': '3314040066',
                                                                                       'in_ucast_pkts': '98317177',
                                                                                       'mac_address': '00:15:67:f7:9a:18',
                                                                                       'out_octets': '2059194443',
                                                                                       'out_ucast_pkts': '190704643'},
                                                                               {       'in_octets': '719839330',
                                                                                       'in_ucast_pkts': '3497552',
                                                                                       'mac_address': '00:15:67:f7:99:be',
                                                                                       'out_octets': '2878302594',
                                                                                       'out_ucast_pkts': '4816759'},
                                                                               {       'in_octets': '3636254490',
                                                                                       'in_ucast_pkts': '80728713',
                                                                                       'mac_address': '00:15:67:f7:a1:00',
                                                                                       'out_octets': '264982221',
                                                                                       'out_ucast_pkts': '105973599'},
                                                                               {       'in_octets': '2021673632',
                                                                                       'in_ucast_pkts': '11882881',
                                                                                       'mac_address': '00:15:67:e3:ae:01',
                                                                                       'out_octets': '4291621744',
                                                                                       'out_ucast_pkts': '18732977'},
                                                                               {       'in_octets': '88690124',
                                                                                       'in_ucast_pkts': '843644',
                                                                                       'mac_address': '00:15:67:f7:a1:12',
                                                                                       'out_octets': '547878553',
                                                                                       'out_ucast_pkts': '2211302'},
                                                                               {       'in_octets': '791619947',
                                                                                       'in_ucast_pkts': '41042020',
                                                                                       'mac_address': '00:15:67:f7:a1:06',
                                                                                       'out_octets': '1955647152',
                                                                                       'out_ucast_pkts': '69414254'},
                                                                               {       'in_octets': '1910956447',
                                                                                       'in_ucast_pkts': '11285138',
                                                                                       'mac_address': '00:15:67:e2:d3:ee',
                                                                                       'out_octets': '385562133',
                                                                                       'out_ucast_pkts': '15360105'},
                                                                               {       'in_octets': '1691327374',
                                                                                       'in_ucast_pkts': '41267200',
                                                                                       'mac_address': '00:15:67:00:56:23',
                                                                                       'out_octets': '1136085012',
                                                                                       'out_ucast_pkts': '77764508'},
                                                                               {       'in_octets': '1097710621',
                                                                                       'in_ucast_pkts': '5809074',
                                                                                       'mac_address': '00:15:67:f7:bd:12',
                                                                                       'out_octets': '1410049552',
                                                                                       'out_ucast_pkts': '11392422'},
                                                                               {       'in_octets': '3408978095',
                                                                                       'in_ucast_pkts': '361498159',
                                                                                       'mac_address': '00:15:67:f7:99:cd',
                                                                                       'out_octets': '1546248442',
                                                                                       'out_ucast_pkts': '500681994'},
                                                                               {       'in_octets': '2841456626',
                                                                                       'in_ucast_pkts': '136588025',
                                                                                       'mac_address': '00:15:67:e2:87:73',
                                                                                       'out_octets': '3923745424',
                                                                                       'out_ucast_pkts': '262957563'},
                                                                               {       'in_octets': '1457858344',
                                                                                       'in_ucast_pkts': '363749905',
                                                                                       'mac_address': '00:15:67:f7:99:af',
                                                                                       'out_octets': '1476019370',
                                                                                       'out_ucast_pkts': '349017329'},
                                                                               {       'in_octets': '3487019087',
                                                                                       'in_ucast_pkts': '25825033',
                                                                                       'mac_address': '00:15:67:f7:a5:9a',
                                                                                       'out_octets': '4105481100',
                                                                                       'out_ucast_pkts': '46074293'},
                                                                               {       'in_octets': '1830167238',
                                                                                       'in_ucast_pkts': '32856450',
                                                                                       'mac_address': '00:15:67:f7:a2:0b',
                                                                                       'out_octets': '4043022004',
                                                                                       'out_ucast_pkts': '48918253'},
                                                                               {       'in_octets': '875933492',
                                                                                       'in_ucast_pkts': '126716979',
                                                                                       'mac_address': '00:15:67:f7:bc:e2',
                                                                                       'out_octets': '2997503507',
                                                                                       'out_ucast_pkts': '227435801'},
                                                                               {       'in_octets': '1431183310',
                                                                                       'in_ucast_pkts': '34746304',
                                                                                       'mac_address': '00:15:67:f7:a3:10',
                                                                                       'out_octets': '488624739',
                                                                                       'out_ucast_pkts': '48190677'},
                                                                               {       'in_octets': '2847226732',
                                                                                       'in_ucast_pkts': '95973547',
                                                                                       'mac_address': '00:15:67:62:f6:00',
                                                                                       'out_octets': '3764451482',
                                                                                       'out_ucast_pkts': '107912969'},
                                                                               {       'in_octets': '851508452',
                                                                                       'in_ucast_pkts': '81478355',
                                                                                       'mac_address': '00:15:67:e2:d6:2d',
                                                                                       'out_octets': '1986405168',
                                                                                       'out_ucast_pkts': '119833444'},
                                                                               {       'in_octets': '1730730511',
                                                                                       'in_ucast_pkts': '105316542',
                                                                                       'mac_address': '00:15:67:f7:a1:03',
                                                                                       'out_octets': '2407278444',
                                                                                       'out_ucast_pkts': '143542799'},
                                                                               {       'in_octets': '1009499933',
                                                                                       'in_ucast_pkts': '121914101',
                                                                                       'mac_address': '00:15:67:f7:9a:24',
                                                                                       'out_octets': '2102864645',
                                                                                       'out_ucast_pkts': '358545425'}],
                                                              'mac_address': '00:15:67:69:30:c4',
                                                              'name': 'Radio Interface',
                                                              'out_octets': '54892042',
                                                              'out_ucast_pkts': '3641400245',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 1250,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5190,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:15:67:e2:b3:0c',
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:9a:18',
                                                                                                                                            'rssi': -84.0,
                                                                                                                                            'rx_link_rate': '40500000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '135000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:f7:99:be',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '100000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a1:00',
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '75000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '225000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:e3:ae:01',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a1:12',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '100000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a1:06',
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '40500000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '121500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:e2:d3:ee',
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:00:56:23',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:bd:12',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '100000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:99:cd',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:e2:87:73',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '100000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:99:af',
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '60000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a5:9a',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a2:0b',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '81000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:bc:e2',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '100000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a3:10',
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '54000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:62:f6:00',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '100000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:e2:d6:2d',
                                                                                                                                            'rssi': -91.0,
                                                                                                                                            'rx_link_rate': '9750000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '30375000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a1:03',
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:9a:24',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 13}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ATCJMAYW5X5K02'}]}],
                                'latitude': 40.659783,
                                'longitude': -100.620745,
                                'manufacturer': 'Radwin',
                                'model': 'RW-5AB5-0658',
                                'poller_hash': 'ABVnaTDE',
                                'serial_number': 'C16280IB00J00484',
                                'sw_version': '4.9.60_b0051_Nov 11 2018',
                                'system_mac_address': '00:15:67:69:2b:54',
                                'temperature': 39.0,
                                'uptime': '8687201'},
                'peers': [       {       'interfaces': [       {       'in_octets': '2173418040',
                                                                       'in_ucast_pkts': '44963719',
                                                                       'links': [       {       'in_octets': '2173418040',
                                                                                                'in_ucast_pkts': '44963719',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '2889885596',
                                                                                                'out_ucast_pkts': '25182565'}],
                                                                       'mac_address': '00:15:67:e2:b3:0c',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2889885596',
                                                                       'out_ucast_pkts': '25182565',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -47.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2889885596',
                                                                       'in_ucast_pkts': '25182565',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2173418040',
                                                                       'out_ucast_pkts': '44963719',
                                                                       'poller_hash': 'MDAxNTY3ZTJiMzBjTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'FarmersUnion',
                                         'poller_hash': 'ABVn4rMM',
                                         'serial_number': 'P15000I000M00430',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2059194443',
                                                                       'in_ucast_pkts': '190704643',
                                                                       'links': [       {       'in_octets': '2059194443',
                                                                                                'in_ucast_pkts': '190704643',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '3314040066',
                                                                                                'out_ucast_pkts': '98317177'}],
                                                                       'mac_address': '00:15:67:f7:9a:18',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3314040066',
                                                                       'out_ucast_pkts': '98317177',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '135000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '135000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '40500000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '40500000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3314040066',
                                                                       'in_ucast_pkts': '98317177',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2059194443',
                                                                       'out_ucast_pkts': '190704643',
                                                                       'poller_hash': 'MDAxNTY3Zjc5YTE4TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'BrookeTravisHatfield',
                                         'poller_hash': 'ABVn95oY',
                                         'serial_number': 'P15000I000W01150',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2878302594',
                                                                       'in_ucast_pkts': '4816759',
                                                                       'links': [       {       'in_octets': '2878302594',
                                                                                                'in_ucast_pkts': '4816759',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '719839330',
                                                                                                'out_ucast_pkts': '3497552'}],
                                                                       'mac_address': '00:15:67:f7:99:be',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '719839330',
                                                                       'out_ucast_pkts': '3497552',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '100000000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '100000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '719839330',
                                                                       'in_ucast_pkts': '3497552',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2878302594',
                                                                       'out_ucast_pkts': '4816759',
                                                                       'poller_hash': 'MDAxNTY3Zjc5OWJlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'UspsMaywood',
                                         'poller_hash': 'ABVn95m+',
                                         'serial_number': 'P15000I000T01072',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '264982221',
                                                                       'in_ucast_pkts': '105973599',
                                                                       'links': [       {       'in_octets': '264982221',
                                                                                                'in_ucast_pkts': '105973599',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '3636254490',
                                                                                                'out_ucast_pkts': '80728713'}],
                                                                       'mac_address': '00:15:67:f7:a1:00',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3636254490',
                                                                       'out_ucast_pkts': '80728713',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '225000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '225000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '75000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '75000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3636254490',
                                                                       'in_ucast_pkts': '80728713',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '264982221',
                                                                       'out_ucast_pkts': '105973599',
                                                                       'poller_hash': 'MDAxNTY3ZjdhMTAwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'CHARLAWERKMEISTER',
                                         'poller_hash': 'ABVn96EA',
                                         'serial_number': 'P15000I000M01603',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '4291621744',
                                                                       'in_ucast_pkts': '18732977',
                                                                       'links': [       {       'in_octets': '4291621744',
                                                                                                'in_ucast_pkts': '18732977',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '2021673632',
                                                                                                'out_ucast_pkts': '11882881'}],
                                                                       'mac_address': '00:15:67:e3:ae:01',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2021673632',
                                                                       'out_ucast_pkts': '11882881',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2021673632',
                                                                       'in_ucast_pkts': '11882881',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '4291621744',
                                                                       'out_ucast_pkts': '18732977',
                                                                       'poller_hash': 'MDAxNTY3ZTNhZTAxTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'ClaytonSchmitz',
                                         'poller_hash': 'ABVn464B',
                                         'serial_number': 'P15000I000M01098',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '547878553',
                                                                       'in_ucast_pkts': '2211302',
                                                                       'links': [       {       'in_octets': '547878553',
                                                                                                'in_ucast_pkts': '2211302',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '88690124',
                                                                                                'out_ucast_pkts': '843644'}],
                                                                       'mac_address': '00:15:67:f7:a1:12',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '88690124',
                                                                       'out_ucast_pkts': '843644',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '100000000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '100000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '88690124',
                                                                       'in_ucast_pkts': '843644',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '547878553',
                                                                       'out_ucast_pkts': '2211302',
                                                                       'poller_hash': 'MDAxNTY3ZjdhMTEyTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'MaywoodUnitedMethodis',
                                         'poller_hash': 'ABVn96ES',
                                         'serial_number': 'P15000I000U01142',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1955647152',
                                                                       'in_ucast_pkts': '69414254',
                                                                       'links': [       {       'in_octets': '1955647152',
                                                                                                'in_ucast_pkts': '69414254',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '791619947',
                                                                                                'out_ucast_pkts': '41042020'}],
                                                                       'mac_address': '00:15:67:f7:a1:06',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '791619947',
                                                                       'out_ucast_pkts': '41042020',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '121500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '121500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '40500000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '40500000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '791619947',
                                                                       'in_ucast_pkts': '41042020',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1955647152',
                                                                       'out_ucast_pkts': '69414254',
                                                                       'poller_hash': 'MDAxNTY3ZjdhMTA2TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'TraciVandrimmelen',
                                         'poller_hash': 'ABVn96EG',
                                         'serial_number': 'P15000I000U01144',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '385562133',
                                                                       'in_ucast_pkts': '15360105',
                                                                       'links': [       {       'in_octets': '385562133',
                                                                                                'in_ucast_pkts': '15360105',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '1910956447',
                                                                                                'out_ucast_pkts': '11285138'}],
                                                                       'mac_address': '00:15:67:e2:d3:ee',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1910956447',
                                                                       'out_ucast_pkts': '11285138',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1910956447',
                                                                       'in_ucast_pkts': '11285138',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '385562133',
                                                                       'out_ucast_pkts': '15360105',
                                                                       'poller_hash': 'MDAxNTY3ZTJkM2VlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'JaniceArent',
                                         'poller_hash': 'ABVn4tPu',
                                         'serial_number': 'P15000I000M01072',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1136085012',
                                                                       'in_ucast_pkts': '77764508',
                                                                       'links': [       {       'in_octets': '1136085012',
                                                                                                'in_ucast_pkts': '77764508',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '1691327374',
                                                                                                'out_ucast_pkts': '41267200'}],
                                                                       'mac_address': '00:15:67:00:56:23',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1691327374',
                                                                       'out_ucast_pkts': '41267200',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1691327374',
                                                                       'in_ucast_pkts': '41267200',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1136085012',
                                                                       'out_ucast_pkts': '77764508',
                                                                       'poller_hash': 'MDAxNTY3MDA1NjIzTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Sabastion Chad',
                                         'poller_hash': 'ABVnAFYj',
                                         'serial_number': 'P15000I000Q01065',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1410049552',
                                                                       'in_ucast_pkts': '11392422',
                                                                       'links': [       {       'in_octets': '1410049552',
                                                                                                'in_ucast_pkts': '11392422',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '1097710621',
                                                                                                'out_ucast_pkts': '5809074'}],
                                                                       'mac_address': '00:15:67:f7:bd:12',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1097710621',
                                                                       'out_ucast_pkts': '5809074',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '100000000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '100000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1097710621',
                                                                       'in_ucast_pkts': '5809074',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1410049552',
                                                                       'out_ucast_pkts': '11392422',
                                                                       'poller_hash': 'MDAxNTY3ZjdiZDEyTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'HeatherGrimes',
                                         'poller_hash': 'ABVn970S',
                                         'serial_number': 'P15000I000W01201',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1546248442',
                                                                       'in_ucast_pkts': '500681994',
                                                                       'links': [       {       'in_octets': '1546248442',
                                                                                                'in_ucast_pkts': '500681994',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '3408978095',
                                                                                                'out_ucast_pkts': '361498159'}],
                                                                       'mac_address': '00:15:67:f7:99:cd',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3408978095',
                                                                       'out_ucast_pkts': '361498159',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3408978095',
                                                                       'in_ucast_pkts': '361498159',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1546248442',
                                                                       'out_ucast_pkts': '500681994',
                                                                       'poller_hash': 'MDAxNTY3Zjc5OWNkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'AgValley-MaywoodOfficeStation',
                                         'poller_hash': 'ABVn95nN',
                                         'serial_number': 'P15000I000W01155',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3923745424',
                                                                       'in_ucast_pkts': '262957563',
                                                                       'links': [       {       'in_octets': '3923745424',
                                                                                                'in_ucast_pkts': '262957563',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '2841456626',
                                                                                                'out_ucast_pkts': '136588025'}],
                                                                       'mac_address': '00:15:67:e2:87:73',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2841456626',
                                                                       'out_ucast_pkts': '136588025',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '100000000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '100000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2841456626',
                                                                       'in_ucast_pkts': '136588025',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3923745424',
                                                                       'out_ucast_pkts': '262957563',
                                                                       'poller_hash': 'MDAxNTY3ZTI4NzczTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'MonteHazen',
                                         'poller_hash': 'ABVn4odz',
                                         'serial_number': 'P15000I000R00812',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1476019370',
                                                                       'in_ucast_pkts': '349017329',
                                                                       'links': [       {       'in_octets': '1476019370',
                                                                                                'in_ucast_pkts': '349017329',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '1457858344',
                                                                                                'out_ucast_pkts': '363749905'}],
                                                                       'mac_address': '00:15:67:f7:99:af',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1457858344',
                                                                       'out_ucast_pkts': '363749905',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '60000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '60000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1457858344',
                                                                       'in_ucast_pkts': '363749905',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1476019370',
                                                                       'out_ucast_pkts': '349017329',
                                                                       'poller_hash': 'MDAxNTY3Zjc5OWFmTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'AGValley-MaywoodFertilizer',
                                         'poller_hash': 'ABVn95mv',
                                         'serial_number': 'P15000I000W01156',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '4105481100',
                                                                       'in_ucast_pkts': '46074293',
                                                                       'links': [       {       'in_octets': '4105481100',
                                                                                                'in_ucast_pkts': '46074293',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '3487019087',
                                                                                                'out_ucast_pkts': '25825033'}],
                                                                       'mac_address': '00:15:67:f7:a5:9a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3487019087',
                                                                       'out_ucast_pkts': '25825033',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3487019087',
                                                                       'in_ucast_pkts': '25825033',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '4105481100',
                                                                       'out_ucast_pkts': '46074293',
                                                                       'poller_hash': 'MDAxNTY3ZjdhNTlhTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'ScottDavis',
                                         'poller_hash': 'ABVn96Wa',
                                         'serial_number': 'P15000I000M01753',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '4043022004',
                                                                       'in_ucast_pkts': '48918253',
                                                                       'links': [       {       'in_octets': '4043022004',
                                                                                                'in_ucast_pkts': '48918253',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '1830167238',
                                                                                                'out_ucast_pkts': '32856450'}],
                                                                       'mac_address': '00:15:67:f7:a2:0b',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1830167238',
                                                                       'out_ucast_pkts': '32856450',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '81000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '81000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1830167238',
                                                                       'in_ucast_pkts': '32856450',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '4043022004',
                                                                       'out_ucast_pkts': '48918253',
                                                                       'poller_hash': 'MDAxNTY3ZjdhMjBiTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Alicia Shirley',
                                         'poller_hash': 'ABVn96IL',
                                         'serial_number': 'P15000I000W01327',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2997503507',
                                                                       'in_ucast_pkts': '227435801',
                                                                       'links': [       {       'in_octets': '2997503507',
                                                                                                'in_ucast_pkts': '227435801',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '875933492',
                                                                                                'out_ucast_pkts': '126716979'}],
                                                                       'mac_address': '00:15:67:f7:bc:e2',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '875933492',
                                                                       'out_ucast_pkts': '126716979',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '100000000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '100000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '875933492',
                                                                       'in_ucast_pkts': '126716979',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2997503507',
                                                                       'out_ucast_pkts': '227435801',
                                                                       'poller_hash': 'MDAxNTY3ZjdiY2UyTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'TerraPeitz',
                                         'poller_hash': 'ABVn97zi',
                                         'serial_number': 'P15000I000P01687',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '488624739',
                                                                       'in_ucast_pkts': '48190677',
                                                                       'links': [       {       'in_octets': '488624739',
                                                                                                'in_ucast_pkts': '48190677',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '1431183310',
                                                                                                'out_ucast_pkts': '34746304'}],
                                                                       'mac_address': '00:15:67:f7:a3:10',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1431183310',
                                                                       'out_ucast_pkts': '34746304',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -70.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '54000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '54000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1431183310',
                                                                       'in_ucast_pkts': '34746304',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '488624739',
                                                                       'out_ucast_pkts': '48190677',
                                                                       'poller_hash': 'MDAxNTY3ZjdhMzEwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'EricMerritt',
                                         'poller_hash': 'ABVn96MQ',
                                         'serial_number': 'P15000I000W01322',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3764451482',
                                                                       'in_ucast_pkts': '107912969',
                                                                       'links': [       {       'in_octets': '3764451482',
                                                                                                'in_ucast_pkts': '107912969',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '2847226732',
                                                                                                'out_ucast_pkts': '95973547'}],
                                                                       'mac_address': '00:15:67:62:f6:00',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2847226732',
                                                                       'out_ucast_pkts': '95973547',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '100000000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '100000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2847226732',
                                                                       'in_ucast_pkts': '95973547',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3764451482',
                                                                       'out_ucast_pkts': '107912969',
                                                                       'poller_hash': 'MDAxNTY3NjJmNjAwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Melody&RobertWalker',
                                         'poller_hash': 'ABVnYvYA',
                                         'serial_number': 'P15000I000P01122',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1986405168',
                                                                       'in_ucast_pkts': '119833444',
                                                                       'links': [       {       'in_octets': '1986405168',
                                                                                                'in_ucast_pkts': '119833444',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '851508452',
                                                                                                'out_ucast_pkts': '81478355'}],
                                                                       'mac_address': '00:15:67:e2:d6:2d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '851508452',
                                                                       'out_ucast_pkts': '81478355',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '30375000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -81.0,
                                                                                                                                                     'rx_link_rate': '30375000',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '9750000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '9750000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '851508452',
                                                                       'in_ucast_pkts': '81478355',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1986405168',
                                                                       'out_ucast_pkts': '119833444',
                                                                       'poller_hash': 'MDAxNTY3ZTJkNjJkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'LouisNancy Stoeger',
                                         'poller_hash': 'ABVn4tYt',
                                         'serial_number': 'P15000I000M01065',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2407278444',
                                                                       'in_ucast_pkts': '143542799',
                                                                       'links': [       {       'in_octets': '2407278444',
                                                                                                'in_ucast_pkts': '143542799',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '1730730511',
                                                                                                'out_ucast_pkts': '105316542'}],
                                                                       'mac_address': '00:15:67:f7:a1:03',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1730730511',
                                                                       'out_ucast_pkts': '105316542',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1730730511',
                                                                       'in_ucast_pkts': '105316542',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2407278444',
                                                                       'out_ucast_pkts': '143542799',
                                                                       'poller_hash': 'MDAxNTY3ZjdhMTAzTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Lucas Mccain',
                                         'poller_hash': 'ABVn96ED',
                                         'serial_number': 'P15000I000T01075',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2102864645',
                                                                       'in_ucast_pkts': '358545425',
                                                                       'links': [       {       'in_octets': '2102864645',
                                                                                                'in_ucast_pkts': '358545425',
                                                                                                'mac_address': '00:15:67:69:30:c4',
                                                                                                'out_octets': '1009499933',
                                                                                                'out_ucast_pkts': '121914101'}],
                                                                       'mac_address': '00:15:67:f7:9a:24',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1009499933',
                                                                       'out_ucast_pkts': '121914101',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:69:30:c4',
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATCJMAYW5X5K02'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1009499933',
                                                                       'in_ucast_pkts': '121914101',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2102864645',
                                                                       'out_ucast_pkts': '358545425',
                                                                       'poller_hash': 'MDAxNTY3Zjc5YTI0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'KarenHastings',
                                         'poller_hash': 'ABVn95ok',
                                         'serial_number': 'P15000I000E00168',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_radwin_winlink_RW_5AB5_0658_4_9_70_01(self):
        obj = self.run_data("radwin.winlink.RW-5AB5-0658.4.9.70.01")
        exp_info = {
                'model': 'RW-5AB5-0658',
                'rf_chan_width': 40,
                'rf_freq': 5750,
                'sta_count': 24,
                'sw_version': '4.9.70_b0015_May  2 2019',
                'vendor': 'Radwin'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:15:67:00:11:dc': {       'alt_macs': {'00:15:67:00:11:d7'},
                                             'dev_macs': {'cc:2d:e0:7d:24:ef'},
                                             'dl_rssi': -57.0,
                                             'ip_address': '10.6.1.14',
                                             'mac_address': '00:15:67:00:11:dc',
                                             'name': '10222 Daphnee Washington',
                                             'ul_rssi': -61.0},
                '00:15:67:00:12:50': {       'alt_macs': {'00:15:67:00:12:49'},
                                             'dev_macs': {'b8:69:f4:85:66:e9'},
                                             'dl_rssi': -53.0,
                                             'ip_address': '10.6.1.19',
                                             'mac_address': '00:15:67:00:12:50',
                                             'name': '10358 Amanda Rock',
                                             'ul_rssi': -52.0},
                '00:15:67:00:1b:3a': {       'alt_macs': {'00:15:67:00:1b:35'},
                                             'dev_macs': {'6c:3b:6b:48:d9:c9'},
                                             'dl_rssi': -49.0,
                                             'ip_address': '10.6.1.6',
                                             'mac_address': '00:15:67:00:1b:3a',
                                             'name': '7503 Gary Alires',
                                             'ul_rssi': -51.0},
                '00:15:67:63:a0:7c': {       'alt_macs': {'00:15:67:63:a0:68'},
                                             'dev_macs': {'6c:3b:6b:58:ee:be'},
                                             'dl_rssi': -58.0,
                                             'ip_address': '10.6.0.246',
                                             'mac_address': '00:15:67:63:a0:7c',
                                             'name': '7241 Natalie Richards',
                                             'ul_rssi': -56.0},
                '00:15:67:63:a3:6d': {       'alt_macs': {'00:15:67:63:a3:6c'},
                                             'dev_macs': {'74:4d:28:2a:9a:0b'},
                                             'dl_rssi': -47.0,
                                             'ip_address': '10.6.0.248',
                                             'mac_address': '00:15:67:63:a3:6d',
                                             'name': '9476 Shiri Howell',
                                             'ul_rssi': -55.0},
                '00:15:67:63:a5:4b': {       'alt_macs': {'00:15:67:63:a5:4a'},
                                             'dev_macs': {'64:d1:54:79:38:25'},
                                             'dl_rssi': -63.0,
                                             'ip_address': '10.6.1.4',
                                             'mac_address': '00:15:67:63:a5:4b',
                                             'name': '10217 Gogi Griffith',
                                             'ul_rssi': -61.0},
                '00:15:67:80:03:61': {       'alt_macs': {'00:15:67:80:03:5e'},
                                             'dev_macs': {'6c:3b:6b:d7:c6:57'},
                                             'dl_rssi': -51.0,
                                             'ip_address': '10.6.1.17',
                                             'mac_address': '00:15:67:80:03:61',
                                             'name': '8331 Conrad Thompson',
                                             'ul_rssi': -55.0},
                '00:15:67:e3:75:ef': {       'alt_macs': {'00:15:67:e3:75:ed'},
                                             'dev_macs': {'cc:2d:e0:87:9c:ad'},
                                             'dl_rssi': -57.0,
                                             'ip_address': '10.6.0.250',
                                             'mac_address': '00:15:67:e3:75:ef',
                                             'name': '10065 Larry Lovecchio (IKH)',
                                             'ul_rssi': -60.0},
                '00:15:67:e3:85:df': {       'alt_macs': {'00:15:67:e3:85:d5'},
                                             'dev_macs': {'6c:3b:6b:5c:26:dc'},
                                             'dl_rssi': -55.0,
                                             'ip_address': '10.6.0.223',
                                             'mac_address': '00:15:67:e3:85:df',
                                             'name': '7230 Stephanie & Olin Goodtracks',
                                             'ul_rssi': -58.0},
                '00:15:67:e3:88:ae': {       'alt_macs': {'00:15:67:e3:88:99'},
                                             'dev_macs': {'6c:3b:6b:48:d1:63'},
                                             'dl_rssi': -54.0,
                                             'ip_address': '10.6.1.21',
                                             'mac_address': '00:15:67:e3:88:ae',
                                             'name': '7063 Amos & Kathrine Ojohn',
                                             'ul_rssi': -58.0},
                '00:15:67:e3:a0:2e': {       'alt_macs': {'00:15:67:e3:a0:26'},
                                             'dev_macs': {'cc:2d:e0:2d:cc:88'},
                                             'dl_rssi': -53.0,
                                             'ip_address': '10.6.1.23',
                                             'mac_address': '00:15:67:e3:a0:2e',
                                             'name': '10452 David Storey & Mariah '
                                                     'Vigil',
                                             'ul_rssi': -52.0},
                '00:15:67:e3:c3:e9': {       'alt_macs': {'00:15:67:e3:c3:e7'},
                                             'dev_macs': {'6c:3b:6b:68:9d:95'},
                                             'dl_rssi': -68.0,
                                             'ip_address': '10.6.1.25',
                                             'mac_address': '00:15:67:e3:c3:e9',
                                             'name': '7051 Lorena Richards',
                                             'ul_rssi': -64.0},
                '00:15:67:e3:c4:9a': {       'alt_macs': {'00:15:67:e3:c4:98'},
                                             'dev_macs': {'64:d1:54:79:51:f8'},
                                             'dl_rssi': -52.0,
                                             'ip_address': '10.6.1.37',
                                             'mac_address': '00:15:67:e3:c4:9a',
                                             'name': '9406 Marilyn Olguin',
                                             'ul_rssi': -55.0},
                '00:15:67:f6:30:19': {       'alt_macs': set(),
                                             'dev_macs': {'b8:69:f4:b6:0a:40'},
                                             'dl_rssi': -58.0,
                                             'ip_address': '10.6.1.52',
                                             'mac_address': '00:15:67:f6:30:19',
                                             'name': '10833 Emmett Frost',
                                             'ul_rssi': -59.0},
                '00:15:67:f6:30:55': {       'alt_macs': {'00:15:67:f6:30:54'},
                                             'dev_macs': {'cc:2d:e0:2d:d0:ba'},
                                             'dl_rssi': -54.0,
                                             'ip_address': '10.6.1.31',
                                             'mac_address': '00:15:67:f6:30:55',
                                             'name': '6450 Arnulfo Pardo',
                                             'ul_rssi': -57.0},
                '00:15:67:f6:30:61': {       'alt_macs': {'00:15:67:f6:30:60'},
                                             'dev_macs': {'cc:2d:e0:43:2c:6e'},
                                             'dl_rssi': -67.0,
                                             'ip_address': '10.6.1.27',
                                             'mac_address': '00:15:67:f6:30:61',
                                             'name': '10505 Treva Watts',
                                             'ul_rssi': -68.0},
                '00:15:67:f6:30:79': {       'alt_macs': {'00:15:67:f6:30:78'},
                                             'dev_macs': {'64:d1:54:4c:ed:4f'},
                                             'dl_rssi': -51.0,
                                             'ip_address': '10.6.1.43',
                                             'mac_address': '00:15:67:f6:30:79',
                                             'name': '7000 Philman Lopez',
                                             'ul_rssi': -56.0},
                '00:15:67:f6:30:88': {       'alt_macs': {'00:15:67:f6:30:87'},
                                             'dev_macs': {'cc:2d:e0:43:2f:5c'},
                                             'dl_rssi': -53.0,
                                             'ip_address': '10.6.1.29',
                                             'mac_address': '00:15:67:f6:30:88',
                                             'name': '10509 Angelica Cloud',
                                             'ul_rssi': -51.0},
                '00:15:67:f7:9d:63': {       'alt_macs': {'00:15:67:f7:9d:62'},
                                             'dev_macs': {'cc:2d:e0:2d:cb:98'},
                                             'dl_rssi': -53.0,
                                             'ip_address': '10.6.1.35',
                                             'mac_address': '00:15:67:f7:9d:63',
                                             'name': '10586 Loretta Velasquez',
                                             'ul_rssi': -51.0},
                '00:15:67:f7:9d:cc': {       'alt_macs': set(),
                                             'dev_macs': {'64:d1:54:79:4f:3b'},
                                             'dl_rssi': -63.0,
                                             'ip_address': '10.6.1.50',
                                             'mac_address': '00:15:67:f7:9d:cc',
                                             'name': '9518 Ashley Valencia',
                                             'ul_rssi': -56.0},
                '00:15:67:f7:a2:6e': {       'alt_macs': set(),
                                             'dev_macs': {'64:d1:54:47:b5:c5'},
                                             'dl_rssi': -54.0,
                                             'ip_address': '10.6.1.78',
                                             'mac_address': '00:15:67:f7:a2:6e',
                                             'name': '10951 Bernandine Cuthair',
                                             'ul_rssi': -55.0},
                '00:15:67:f7:a3:70': {       'alt_macs': {'00:15:67:f7:a3:6f'},
                                             'dev_macs': {'b8:69:f4:b5:6d:f6'},
                                             'dl_rssi': -49.0,
                                             'ip_address': '10.6.1.48',
                                             'mac_address': '00:15:67:f7:a3:70',
                                             'name': '10746 Ryan Cook',
                                             'ul_rssi': -51.0},
                '00:15:67:f7:a4:67': {       'alt_macs': set(),
                                             'dev_macs': {'b8:69:f4:b5:b4:fc'},
                                             'dl_rssi': -49.0,
                                             'ip_address': '10.6.1.61',
                                             'mac_address': '00:15:67:f7:a4:67',
                                             'name': '10842 Cheyenne & Evaristo '
                                                     'McKinney',
                                             'ul_rssi': -52.0}
        }
        exp_ne_msg = {
                'data': {       'elevation': 2050.2,
                                'gps_sats_tracked': 9,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '5611463',
                                                              'in_octets': '64536754',
                                                              'in_ucast_pkts': '3834855568',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:15:67:03:5e:04',
                                                              'mtu': 2047,
                                                              'name': 'Management Port '
                                                                      'on Odu',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '3752487',
                                                              'out_octets': '3284074527',
                                                              'out_ucast_pkts': '2166367869',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'in_octets': '3284524514',
                                                              'in_ucast_pkts': '2170125160',
                                                              'links': [       {       'bridged_mac_addresses': [       'b8:69:f4:85:66:e9'],
                                                                                       'in_octets': '3248094873',
                                                                                       'in_ucast_pkts': '25717563',
                                                                                       'mac_address': '00:15:67:00:12:50',
                                                                                       'out_octets': '1953896549',
                                                                                       'out_ucast_pkts': '56913446'},
                                                                               {       'bridged_mac_addresses': [       '6c:3b:6b:48:d1:63'],
                                                                                       'in_octets': '1178788176',
                                                                                       'in_ucast_pkts': '215104754',
                                                                                       'mac_address': '00:15:67:e3:88:ae',
                                                                                       'out_octets': '3200503310',
                                                                                       'out_ucast_pkts': '323783465'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:2d:cc:88'],
                                                                                       'in_octets': '3057017079',
                                                                                       'in_ucast_pkts': '28534259',
                                                                                       'mac_address': '00:15:67:e3:a0:2e',
                                                                                       'out_octets': '735792092',
                                                                                       'out_ucast_pkts': '43980261'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:43:2c:6e'],
                                                                                       'in_octets': '3442802535',
                                                                                       'in_ucast_pkts': '2710527',
                                                                                       'mac_address': '00:15:67:f6:30:61',
                                                                                       'out_octets': '1198135864',
                                                                                       'out_ucast_pkts': '2419548'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:43:2f:5c'],
                                                                                       'in_octets': '1192366999',
                                                                                       'in_ucast_pkts': '102285283',
                                                                                       'mac_address': '00:15:67:f6:30:88',
                                                                                       'out_octets': '2695909568',
                                                                                       'out_ucast_pkts': '202897562'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:2d:d0:ba'],
                                                                                       'in_octets': '3617321680',
                                                                                       'in_ucast_pkts': '64863466',
                                                                                       'mac_address': '00:15:67:f6:30:55',
                                                                                       'out_octets': '1722596352',
                                                                                       'out_ucast_pkts': '118766160'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:2d:cb:98'],
                                                                                       'in_octets': '3684724010',
                                                                                       'in_ucast_pkts': '54545083',
                                                                                       'mac_address': '00:15:67:f7:9d:63',
                                                                                       'out_octets': '4081649370',
                                                                                       'out_ucast_pkts': '104025097'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:79:51:f8'],
                                                                                       'in_octets': '950042459',
                                                                                       'in_ucast_pkts': '6609878',
                                                                                       'mac_address': '00:15:67:e3:c4:9a',
                                                                                       'out_octets': '545507875',
                                                                                       'out_ucast_pkts': '15455735'},
                                                                               {       'bridged_mac_addresses': [       '6c:3b:6b:68:9d:95'],
                                                                                       'in_octets': '2714170554',
                                                                                       'in_ucast_pkts': '70390216',
                                                                                       'mac_address': '00:15:67:e3:c3:e9',
                                                                                       'out_octets': '3846549253',
                                                                                       'out_ucast_pkts': '131557573'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:4c:ed:4f'],
                                                                                       'in_octets': '183400306',
                                                                                       'in_ucast_pkts': '35786355',
                                                                                       'mac_address': '00:15:67:f6:30:79',
                                                                                       'out_octets': '4173883008',
                                                                                       'out_ucast_pkts': '105056039'},
                                                                               {       'bridged_mac_addresses': [       '6c:3b:6b:5c:26:dc'],
                                                                                       'in_octets': '3056882643',
                                                                                       'in_ucast_pkts': '23442990',
                                                                                       'mac_address': '00:15:67:e3:85:df',
                                                                                       'out_octets': '3695978075',
                                                                                       'out_ucast_pkts': '46517066'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:b5:6d:f6'],
                                                                                       'in_octets': '4205954179',
                                                                                       'in_ucast_pkts': '91468558',
                                                                                       'mac_address': '00:15:67:f7:a3:70',
                                                                                       'out_octets': '3896659046',
                                                                                       'out_ucast_pkts': '184936513'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:79:4f:3b'],
                                                                                       'in_octets': '2672867771',
                                                                                       'in_ucast_pkts': '158363929',
                                                                                       'mac_address': '00:15:67:f7:9d:cc',
                                                                                       'out_octets': '2615743529',
                                                                                       'out_ucast_pkts': '314635578'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:b6:0a:40'],
                                                                                       'in_octets': '1752774237',
                                                                                       'in_ucast_pkts': '7824750',
                                                                                       'mac_address': '00:15:67:f6:30:19',
                                                                                       'out_octets': '3925237765',
                                                                                       'out_ucast_pkts': '20316260'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:b5:b4:fc'],
                                                                                       'in_octets': '54149508',
                                                                                       'in_ucast_pkts': '91943208',
                                                                                       'mac_address': '00:15:67:f7:a4:67',
                                                                                       'out_octets': '1183804440',
                                                                                       'out_ucast_pkts': '275417200'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:47:b5:c5'],
                                                                                       'in_octets': '8350602',
                                                                                       'in_ucast_pkts': '73797',
                                                                                       'mac_address': '00:15:67:f7:a2:6e',
                                                                                       'out_octets': '99531611',
                                                                                       'out_ucast_pkts': '114232'},
                                                                               {       'bridged_mac_addresses': [       '6c:3b:6b:58:ee:be'],
                                                                                       'in_octets': '1131496749',
                                                                                       'in_ucast_pkts': '65027852',
                                                                                       'mac_address': '00:15:67:63:a0:7c',
                                                                                       'out_octets': '8400222',
                                                                                       'out_ucast_pkts': '132423158'},
                                                                               {       'bridged_mac_addresses': [       '74:4d:28:2a:9a:0b'],
                                                                                       'in_octets': '2616376804',
                                                                                       'in_ucast_pkts': '22464995',
                                                                                       'mac_address': '00:15:67:63:a3:6d',
                                                                                       'out_octets': '63888243',
                                                                                       'out_ucast_pkts': '38916155'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:87:9c:ad'],
                                                                                       'in_octets': '587456499',
                                                                                       'in_ucast_pkts': '2388993',
                                                                                       'mac_address': '00:15:67:e3:75:ef',
                                                                                       'out_octets': '2156734395',
                                                                                       'out_ucast_pkts': '4968291'},
                                                                               {       'bridged_mac_addresses': [       '6c:3b:6b:48:d9:c9'],
                                                                                       'in_octets': '3483135237',
                                                                                       'in_ucast_pkts': '27700961',
                                                                                       'mac_address': '00:15:67:00:1b:3a',
                                                                                       'out_octets': '1025393676',
                                                                                       'out_ucast_pkts': '26139393'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:79:38:25'],
                                                                                       'in_octets': '270627230',
                                                                                       'in_ucast_pkts': '50017322',
                                                                                       'mac_address': '00:15:67:63:a5:4b',
                                                                                       'out_octets': '1055310078',
                                                                                       'out_ucast_pkts': '85092546'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:7d:24:ef'],
                                                                                       'in_octets': '3284868581',
                                                                                       'in_ucast_pkts': '84955772',
                                                                                       'mac_address': '00:15:67:00:11:dc',
                                                                                       'out_octets': '3785122476',
                                                                                       'out_ucast_pkts': '164574768'},
                                                                               {       'bridged_mac_addresses': [       '6c:3b:6b:d7:c6:57'],
                                                                                       'in_octets': '274434391',
                                                                                       'in_ucast_pkts': '37793904',
                                                                                       'mac_address': '00:15:67:80:03:61',
                                                                                       'out_octets': '2107844612',
                                                                                       'out_ucast_pkts': '67573198'}],
                                                              'mac_address': '00:15:67:68:25:08',
                                                              'name': 'Radio Interface',
                                                              'out_octets': '87003491',
                                                              'out_ucast_pkts': '3840482059',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'frame_duration': 1250,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5750,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:15:67:00:12:50',
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:e3:88:ae',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:e3:a0:2e',
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f6:30:61',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:f6:30:88',
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f6:30:55',
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '324000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:9d:63',
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:e3:c4:9a',
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '360000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:e3:c3:e9',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '60000000',
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:f6:30:79',
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '360000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:e3:85:df',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a3:70',
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_link_rate': '360000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:9d:cc',
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '00:15:67:f6:30:19',
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a4:67',
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a2:6e',
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:63:a0:7c',
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:63:a3:6d',
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '360000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:e3:75:ef',
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:00:1b:3a',
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:63:a5:4b',
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:00:11:dc',
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '00:15:67:80:03:61',
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '1301AT013_W2'}]}],
                                'latitude': 37.101536,
                                'longitude': -107.635816,
                                'manufacturer': 'Radwin',
                                'model': 'RW-5AB5-0658',
                                'poller_hash': 'ABVnaCUI',
                                'serial_number': 'C13680IB00J00334',
                                'sw_version': '4.9.70_b0015_May  2 2019',
                                'system_mac_address': '00:15:67:03:5e:04',
                                'temperature': 40.0,
                                'uptime': '3627027'},
                'peers': [       {       'interfaces': [       {       'in_octets': '1953896549',
                                                                       'in_ucast_pkts': '56913446',
                                                                       'links': [       {       'in_octets': '1953896549',
                                                                                                'in_ucast_pkts': '56913446',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '3248094873',
                                                                                                'out_ucast_pkts': '25717563'}],
                                                                       'mac_address': '00:15:67:00:12:50',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3248094873',
                                                                       'out_ucast_pkts': '25717563',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '240000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3248094873',
                                                                       'in_ucast_pkts': '25717563',
                                                                       'mac_address': '00:15:67:00:12:49',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1953896549',
                                                                       'out_ucast_pkts': '56913446',
                                                                       'poller_hash': 'MDAxNTY3MDAxMjUwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10141,
                                         'longitude': -107.64086,
                                         'management_ip': '10.6.1.19',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10358 Amanda Rock',
                                         'poller_hash': 'ABVnABJQ',
                                         'serial_number': 'P15000I000W00432',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3200503310',
                                                                       'in_ucast_pkts': '323783465',
                                                                       'links': [       {       'in_octets': '3200503310',
                                                                                                'in_ucast_pkts': '323783465',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '1178788176',
                                                                                                'out_ucast_pkts': '215104754'}],
                                                                       'mac_address': '00:15:67:e3:88:ae',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1178788176',
                                                                       'out_ucast_pkts': '215104754',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1178788176',
                                                                       'in_ucast_pkts': '215104754',
                                                                       'mac_address': '00:15:67:e3:88:99',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3200503310',
                                                                       'out_ucast_pkts': '323783465',
                                                                       'poller_hash': 'MDAxNTY3ZTM4OGFlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10808,
                                         'longitude': -107.64387,
                                         'management_ip': '10.6.1.21',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '7063 Amos & Kathrine Ojohn',
                                         'poller_hash': 'ABVn44iu',
                                         'serial_number': 'P15000I000T00388',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '735792092',
                                                                       'in_ucast_pkts': '43980261',
                                                                       'links': [       {       'in_octets': '735792092',
                                                                                                'in_ucast_pkts': '43980261',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '3057017079',
                                                                                                'out_ucast_pkts': '28534259'}],
                                                                       'mac_address': '00:15:67:e3:a0:2e',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3057017079',
                                                                       'out_ucast_pkts': '28534259',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3057017079',
                                                                       'in_ucast_pkts': '28534259',
                                                                       'mac_address': '00:15:67:e3:a0:26',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '735792092',
                                                                       'out_ucast_pkts': '43980261',
                                                                       'poller_hash': 'MDAxNTY3ZTNhMDJlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.1002,
                                         'longitude': -107.64203,
                                         'management_ip': '10.6.1.23',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10452 David Storey & Mariah Vigil',
                                         'poller_hash': 'ABVn46Au',
                                         'serial_number': 'P15000I000W00275',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1198135864',
                                                                       'in_ucast_pkts': '2419548',
                                                                       'links': [       {       'in_octets': '1198135864',
                                                                                                'in_ucast_pkts': '2419548',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '3442802535',
                                                                                                'out_ucast_pkts': '2710527'}],
                                                                       'mac_address': '00:15:67:f6:30:61',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3442802535',
                                                                       'out_ucast_pkts': '2710527',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3442802535',
                                                                       'in_ucast_pkts': '2710527',
                                                                       'mac_address': '00:15:67:f6:30:60',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1198135864',
                                                                       'out_ucast_pkts': '2419548',
                                                                       'poller_hash': 'MDAxNTY3ZjYzMDYxTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10271,
                                         'longitude': -107.64332,
                                         'management_ip': '10.6.1.27',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10505 Treva Watts',
                                         'poller_hash': 'ABVn9jBh',
                                         'serial_number': 'P15000I000P01501',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2695909568',
                                                                       'in_ucast_pkts': '202897562',
                                                                       'links': [       {       'in_octets': '2695909568',
                                                                                                'in_ucast_pkts': '202897562',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '1192366999',
                                                                                                'out_ucast_pkts': '102285283'}],
                                                                       'mac_address': '00:15:67:f6:30:88',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1192366999',
                                                                       'out_ucast_pkts': '102285283',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1192366999',
                                                                       'in_ucast_pkts': '102285283',
                                                                       'mac_address': '00:15:67:f6:30:87',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2695909568',
                                                                       'out_ucast_pkts': '202897562',
                                                                       'poller_hash': 'MDAxNTY3ZjYzMDg4TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10025,
                                         'longitude': -107.642,
                                         'management_ip': '10.6.1.29',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10509 Angelica Cloud',
                                         'poller_hash': 'ABVn9jCI',
                                         'serial_number': 'P15000I000M01443',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1722596352',
                                                                       'in_ucast_pkts': '118766160',
                                                                       'links': [       {       'in_octets': '1722596352',
                                                                                                'in_ucast_pkts': '118766160',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '3617321680',
                                                                                                'out_ucast_pkts': '64863466'}],
                                                                       'mac_address': '00:15:67:f6:30:55',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3617321680',
                                                                       'out_ucast_pkts': '64863466',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '324000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '324000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3617321680',
                                                                       'in_ucast_pkts': '64863466',
                                                                       'mac_address': '00:15:67:f6:30:54',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1722596352',
                                                                       'out_ucast_pkts': '118766160',
                                                                       'poller_hash': 'MDAxNTY3ZjYzMDU1TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10317,
                                         'longitude': -107.64596,
                                         'management_ip': '10.6.1.31',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '6450 Arnulfo Pardo',
                                         'poller_hash': 'ABVn9jBV',
                                         'serial_number': 'P15000I000W00956',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '4081649370',
                                                                       'in_ucast_pkts': '104025097',
                                                                       'links': [       {       'in_octets': '4081649370',
                                                                                                'in_ucast_pkts': '104025097',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '3684724010',
                                                                                                'out_ucast_pkts': '54545083'}],
                                                                       'mac_address': '00:15:67:f7:9d:63',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3684724010',
                                                                       'out_ucast_pkts': '54545083',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3684724010',
                                                                       'in_ucast_pkts': '54545083',
                                                                       'mac_address': '00:15:67:f7:9d:62',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '4081649370',
                                                                       'out_ucast_pkts': '104025097',
                                                                       'poller_hash': 'MDAxNTY3Zjc5ZDYzTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.1002,
                                         'longitude': -107.64203,
                                         'management_ip': '10.6.1.35',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10586 Loretta Velasquez',
                                         'poller_hash': 'ABVn951j',
                                         'serial_number': 'P15000I000M01606',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '545507875',
                                                                       'in_ucast_pkts': '15455735',
                                                                       'links': [       {       'in_octets': '545507875',
                                                                                                'in_ucast_pkts': '15455735',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '950042459',
                                                                                                'out_ucast_pkts': '6609878'}],
                                                                       'mac_address': '00:15:67:e3:c4:9a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '950042459',
                                                                       'out_ucast_pkts': '6609878',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '360000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '360000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '950042459',
                                                                       'in_ucast_pkts': '6609878',
                                                                       'mac_address': '00:15:67:e3:c4:98',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '545507875',
                                                                       'out_ucast_pkts': '15455735',
                                                                       'poller_hash': 'MDAxNTY3ZTNjNDlhTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10251,
                                         'longitude': -107.6435,
                                         'management_ip': '10.6.1.37',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '9406 Marilyn Olguin',
                                         'poller_hash': 'ABVn48Sa',
                                         'serial_number': 'P15000I000W01194',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3846549253',
                                                                       'in_ucast_pkts': '131557573',
                                                                       'links': [       {       'in_octets': '3846549253',
                                                                                                'in_ucast_pkts': '131557573',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '2714170554',
                                                                                                'out_ucast_pkts': '70390216'}],
                                                                       'mac_address': '00:15:67:e3:c3:e9',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2714170554',
                                                                       'out_ucast_pkts': '70390216',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '60000000',
                                                                                                                                                     'tx_mcs': 1}]}],
                                                                                                 'tx_link_rate': '60000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2714170554',
                                                                       'in_ucast_pkts': '70390216',
                                                                       'mac_address': '00:15:67:e3:c3:e7',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3846549253',
                                                                       'out_ucast_pkts': '131557573',
                                                                       'poller_hash': 'MDAxNTY3ZTNjM2U5TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.09949,
                                         'longitude': -107.64868,
                                         'management_ip': '10.6.1.25',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '7051 Lorena Richards',
                                         'poller_hash': 'ABVn48Pp',
                                         'serial_number': 'P15000I000P01677',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '4173883008',
                                                                       'in_ucast_pkts': '105056039',
                                                                       'links': [       {       'in_octets': '4173883008',
                                                                                                'in_ucast_pkts': '105056039',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '183400306',
                                                                                                'out_ucast_pkts': '35786355'}],
                                                                       'mac_address': '00:15:67:f6:30:79',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '183400306',
                                                                       'out_ucast_pkts': '35786355',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '360000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '360000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '183400306',
                                                                       'in_ucast_pkts': '35786355',
                                                                       'mac_address': '00:15:67:f6:30:78',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '4173883008',
                                                                       'out_ucast_pkts': '105056039',
                                                                       'poller_hash': 'MDAxNTY3ZjYzMDc5TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10284,
                                         'longitude': -107.64399,
                                         'management_ip': '10.6.1.43',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '7000 Philman Lopez',
                                         'poller_hash': 'ABVn9jB5',
                                         'serial_number': 'P15000I000W00957',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3695978075',
                                                                       'in_ucast_pkts': '46517066',
                                                                       'links': [       {       'in_octets': '3695978075',
                                                                                                'in_ucast_pkts': '46517066',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '3056882643',
                                                                                                'out_ucast_pkts': '23442990'}],
                                                                       'mac_address': '00:15:67:e3:85:df',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3056882643',
                                                                       'out_ucast_pkts': '23442990',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '240000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3056882643',
                                                                       'in_ucast_pkts': '23442990',
                                                                       'mac_address': '00:15:67:e3:85:d5',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3695978075',
                                                                       'out_ucast_pkts': '46517066',
                                                                       'poller_hash': 'MDAxNTY3ZTM4NWRmTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.09933,
                                         'longitude': -107.64712,
                                         'management_ip': '10.6.0.223',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '7230 Stephanie & Olin Goodtracks',
                                         'poller_hash': 'ABVn44Xf',
                                         'serial_number': 'P15000I000U00141',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3896659046',
                                                                       'in_ucast_pkts': '184936513',
                                                                       'links': [       {       'in_octets': '3896659046',
                                                                                                'in_ucast_pkts': '184936513',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '4205954179',
                                                                                                'out_ucast_pkts': '91468558'}],
                                                                       'mac_address': '00:15:67:f7:a3:70',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '4205954179',
                                                                       'out_ucast_pkts': '91468558',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '360000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '360000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '4205954179',
                                                                       'in_ucast_pkts': '91468558',
                                                                       'mac_address': '00:15:67:f7:a3:6f',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3896659046',
                                                                       'out_ucast_pkts': '184936513',
                                                                       'poller_hash': 'MDAxNTY3ZjdhMzcwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10158,
                                         'longitude': -107.64109,
                                         'management_ip': '10.6.1.48',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10746 Ryan Cook',
                                         'poller_hash': 'ABVn96Nw',
                                         'serial_number': 'P15000I000M01607',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2615743529',
                                                                       'in_ucast_pkts': '314635578',
                                                                       'links': [       {       'in_octets': '2615743529',
                                                                                                'in_ucast_pkts': '314635578',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '2672867771',
                                                                                                'out_ucast_pkts': '158363929'}],
                                                                       'mac_address': '00:15:67:f7:9d:cc',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2672867771',
                                                                       'out_ucast_pkts': '158363929',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2672867771',
                                                                       'in_ucast_pkts': '158363929',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2615743529',
                                                                       'out_ucast_pkts': '314635578',
                                                                       'poller_hash': 'MDAxNTY3Zjc5ZGNjTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.09808,
                                         'longitude': -107.65175,
                                         'management_ip': '10.6.1.50',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '9518 Ashley Valencia',
                                         'poller_hash': 'ABVn953M',
                                         'serial_number': 'P15000I000W01165',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3925237765',
                                                                       'in_ucast_pkts': '20316260',
                                                                       'links': [       {       'in_octets': '3925237765',
                                                                                                'in_ucast_pkts': '20316260',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '1752774237',
                                                                                                'out_ucast_pkts': '7824750'}],
                                                                       'mac_address': '00:15:67:f6:30:19',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1752774237',
                                                                       'out_ucast_pkts': '7824750',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1752774237',
                                                                       'in_ucast_pkts': '7824750',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3925237765',
                                                                       'out_ucast_pkts': '20316260',
                                                                       'poller_hash': 'MDAxNTY3ZjYzMDE5TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.09793,
                                         'longitude': -107.6544,
                                         'management_ip': '10.6.1.52',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10833 Emmett Frost',
                                         'poller_hash': 'ABVn9jAZ',
                                         'serial_number': 'P15000I000P01506',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1183804440',
                                                                       'in_ucast_pkts': '275417200',
                                                                       'links': [       {       'in_octets': '1183804440',
                                                                                                'in_ucast_pkts': '275417200',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '54149508',
                                                                                                'out_ucast_pkts': '91943208'}],
                                                                       'mac_address': '00:15:67:f7:a4:67',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '54149508',
                                                                       'out_ucast_pkts': '91943208',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '54149508',
                                                                       'in_ucast_pkts': '91943208',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1183804440',
                                                                       'out_ucast_pkts': '275417200',
                                                                       'poller_hash': 'MDAxNTY3ZjdhNDY3TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10058,
                                         'longitude': -107.64186,
                                         'management_ip': '10.6.1.61',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10842 Cheyenne & Evaristo McKinney',
                                         'poller_hash': 'ABVn96Rn',
                                         'serial_number': 'P15000I000E00309',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '99531611',
                                                                       'in_ucast_pkts': '114232',
                                                                       'links': [       {       'in_octets': '99531611',
                                                                                                'in_ucast_pkts': '114232',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '8350602',
                                                                                                'out_ucast_pkts': '73797'}],
                                                                       'mac_address': '00:15:67:f7:a2:6e',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '8350602',
                                                                       'out_ucast_pkts': '73797',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '8350602',
                                                                       'in_ucast_pkts': '73797',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '99531611',
                                                                       'out_ucast_pkts': '114232',
                                                                       'poller_hash': 'MDAxNTY3ZjdhMjZlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10447,
                                         'longitude': -107.64525,
                                         'management_ip': '10.6.1.78',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10951 Bernandine Cuthair',
                                         'poller_hash': 'ABVn96Ju',
                                         'serial_number': 'P15000I000M01772',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '8400222',
                                                                       'in_ucast_pkts': '132423158',
                                                                       'links': [       {       'in_octets': '8400222',
                                                                                                'in_ucast_pkts': '132423158',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '1131496749',
                                                                                                'out_ucast_pkts': '65027852'}],
                                                                       'mac_address': '00:15:67:63:a0:7c',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1131496749',
                                                                       'out_ucast_pkts': '65027852',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1131496749',
                                                                       'in_ucast_pkts': '65027852',
                                                                       'mac_address': '00:15:67:63:a0:68',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '8400222',
                                                                       'out_ucast_pkts': '132423158',
                                                                       'poller_hash': 'MDAxNTY3NjNhMDdjTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10763,
                                         'longitude': -107.64379,
                                         'management_ip': '10.6.0.246',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '7241 Natalie Richards',
                                         'poller_hash': 'ABVnY6B8',
                                         'serial_number': 'P15000I000T00229',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '63888243',
                                                                       'in_ucast_pkts': '38916155',
                                                                       'links': [       {       'in_octets': '63888243',
                                                                                                'in_ucast_pkts': '38916155',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '2616376804',
                                                                                                'out_ucast_pkts': '22464995'}],
                                                                       'mac_address': '00:15:67:63:a3:6d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2616376804',
                                                                       'out_ucast_pkts': '22464995',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -47.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '360000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '360000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2616376804',
                                                                       'in_ucast_pkts': '22464995',
                                                                       'mac_address': '00:15:67:63:a3:6c',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '63888243',
                                                                       'out_ucast_pkts': '38916155',
                                                                       'poller_hash': 'MDAxNTY3NjNhMzZkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10648,
                                         'longitude': -107.64246,
                                         'management_ip': '10.6.0.248',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '9476 Shiri Howell',
                                         'poller_hash': 'ABVnY6Nt',
                                         'serial_number': 'P15000I000W00261',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2156734395',
                                                                       'in_ucast_pkts': '4968291',
                                                                       'links': [       {       'in_octets': '2156734395',
                                                                                                'in_ucast_pkts': '4968291',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '587456499',
                                                                                                'out_ucast_pkts': '2388993'}],
                                                                       'mac_address': '00:15:67:e3:75:ef',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '587456499',
                                                                       'out_ucast_pkts': '2388993',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '587456499',
                                                                       'in_ucast_pkts': '2388993',
                                                                       'mac_address': '00:15:67:e3:75:ed',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2156734395',
                                                                       'out_ucast_pkts': '4968291',
                                                                       'poller_hash': 'MDAxNTY3ZTM3NWVmTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.096,
                                         'longitude': -107.64981,
                                         'management_ip': '10.6.0.250',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10065 Larry Lovecchio (IKH)',
                                         'poller_hash': 'ABVn43Xv',
                                         'serial_number': 'P15000I000W00133',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1025393676',
                                                                       'in_ucast_pkts': '26139393',
                                                                       'links': [       {       'in_octets': '1025393676',
                                                                                                'in_ucast_pkts': '26139393',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '3483135237',
                                                                                                'out_ucast_pkts': '27700961'}],
                                                                       'mac_address': '00:15:67:00:1b:3a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3483135237',
                                                                       'out_ucast_pkts': '27700961',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3483135237',
                                                                       'in_ucast_pkts': '27700961',
                                                                       'mac_address': '00:15:67:00:1b:35',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1025393676',
                                                                       'out_ucast_pkts': '26139393',
                                                                       'poller_hash': 'MDAxNTY3MDAxYjNhTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10555,
                                         'longitude': -107.64242,
                                         'management_ip': '10.6.1.6',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '7503 Gary Alires',
                                         'poller_hash': 'ABVnABs6',
                                         'serial_number': 'P15000I000U00461',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1055310078',
                                                                       'in_ucast_pkts': '85092546',
                                                                       'links': [       {       'in_octets': '1055310078',
                                                                                                'in_ucast_pkts': '85092546',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '270627230',
                                                                                                'out_ucast_pkts': '50017322'}],
                                                                       'mac_address': '00:15:67:63:a5:4b',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '270627230',
                                                                       'out_ucast_pkts': '50017322',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '270627230',
                                                                       'in_ucast_pkts': '50017322',
                                                                       'mac_address': '00:15:67:63:a5:4a',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1055310078',
                                                                       'out_ucast_pkts': '85092546',
                                                                       'poller_hash': 'MDAxNTY3NjNhNTRiTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10094,
                                         'longitude': -107.64127,
                                         'management_ip': '10.6.1.4',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10217 Gogi Griffith',
                                         'poller_hash': 'ABVnY6VL',
                                         'serial_number': 'P15000I000U00259',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3785122476',
                                                                       'in_ucast_pkts': '164574768',
                                                                       'links': [       {       'in_octets': '3785122476',
                                                                                                'in_ucast_pkts': '164574768',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '3284868581',
                                                                                                'out_ucast_pkts': '84955772'}],
                                                                       'mac_address': '00:15:67:00:11:dc',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3284868581',
                                                                       'out_ucast_pkts': '84955772',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3284868581',
                                                                       'in_ucast_pkts': '84955772',
                                                                       'mac_address': '00:15:67:00:11:d7',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3785122476',
                                                                       'out_ucast_pkts': '164574768',
                                                                       'poller_hash': 'MDAxNTY3MDAxMWRjTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.09961,
                                         'longitude': -107.64668,
                                         'management_ip': '10.6.1.14',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '10222 Daphnee Washington',
                                         'poller_hash': 'ABVnABHc',
                                         'serial_number': 'P15000I000U00444',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2107844612',
                                                                       'in_ucast_pkts': '67573198',
                                                                       'links': [       {       'in_octets': '2107844612',
                                                                                                'in_ucast_pkts': '67573198',
                                                                                                'mac_address': '00:15:67:68:25:08',
                                                                                                'out_octets': '274434391',
                                                                                                'out_ucast_pkts': '37793904'}],
                                                                       'mac_address': '00:15:67:80:03:61',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '274434391',
                                                                       'out_ucast_pkts': '37793904',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:25:08',
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '1301AT013_W2'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '274434391',
                                                                       'in_ucast_pkts': '37793904',
                                                                       'mac_address': '00:15:67:80:03:5e',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2107844612',
                                                                       'out_ucast_pkts': '67573198',
                                                                       'poller_hash': 'MDAxNTY3ODAwMzYxTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.10488,
                                         'longitude': -107.64474,
                                         'management_ip': '10.6.1.17',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': '8331 Conrad Thompson',
                                         'poller_hash': 'ABVngANh',
                                         'serial_number': 'P15000I000W00371',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_radwin_winlink_RW_5AB5_0658_4_9_70_03(self):
        obj = self.run_data("radwin.winlink.RW-5AB5-0658.4.9.70.03")
        exp_info = {
                'model': 'RW-5AB5-0658',
                'rf_chan_width': 40,
                'rf_freq': 5190,
                'sta_count': 25,
                'sw_version': '4.9.70_b0015_May  2 2019',
                'vendor': 'Radwin'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:15:67:00:2e:4e': {       'alt_macs': set(),
                                             'dev_macs': {'00:04:56:17:89:a1'},
                                             'dl_rssi': -67.0,
                                             'ip_address': '10.3.254.91',
                                             'mac_address': '00:15:67:00:2e:4e',
                                             'name': 'J. Garza',
                                             'ul_rssi': -65.0},
                '00:15:67:00:ad:0d': {       'alt_macs': set(),
                                             'dev_macs': {'b4:fb:e4:27:6c:56'},
                                             'dl_rssi': -60.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:00:ad:0d',
                                             'name': 'HillCountryCupboard',
                                             'ul_rssi': -68.0},
                '00:15:67:62:dc:24': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -57.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:62:dc:24',
                                             'name': 'JC City Hall',
                                             'ul_rssi': -65.0},
                '00:15:67:62:ec:d8': {       'alt_macs': set(),
                                             'dev_macs': {'cc:2d:e0:08:3b:17'},
                                             'dl_rssi': -56.0,
                                             'ip_address': '10.3.254.226',
                                             'mac_address': '00:15:67:62:ec:d8',
                                             'name': '1st Christian Church',
                                             'ul_rssi': -66.0},
                '00:15:67:63:02:8b': {       'alt_macs': set(),
                                             'dev_macs': {'3c:37:86:76:14:7f'},
                                             'dl_rssi': -53.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:63:02:8b',
                                             'name': 'FarmhouseTasting',
                                             'ul_rssi': -62.0},
                '00:15:67:80:be:0f': {       'alt_macs': set(),
                                             'dev_macs': {'24:05:88:20:90:ed'},
                                             'dl_rssi': -61.0,
                                             'ip_address': '10.3.254.117',
                                             'mac_address': '00:15:67:80:be:0f',
                                             'name': 'David Benner JR',
                                             'ul_rssi': -71.0},
                '00:15:67:e2:8a:fd': {       'alt_macs': set(),
                                             'dev_macs': {'cc:2d:e0:08:3e:f0'},
                                             'dl_rssi': -57.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:e2:8a:fd',
                                             'name': 'Marissa',
                                             'ul_rssi': -65.0},
                '00:15:67:e2:ed:bd': {       'alt_macs': set(),
                                             'dev_macs': {'58:ef:68:aa:dc:b6'},
                                             'dl_rssi': -54.0,
                                             'ip_address': '10.3.254.216',
                                             'mac_address': '00:15:67:e2:ed:bd',
                                             'name': 'Anders Realty',
                                             'ul_rssi': -62.0},
                '00:15:67:e2:ee:c6': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:e1:92:d9'},
                                             'dl_rssi': -59.0,
                                             'ip_address': '10.3.254.203',
                                             'mac_address': '00:15:67:e2:ee:c6',
                                             'name': 'Crawford',
                                             'ul_rssi': -65.0},
                '00:15:67:f6:34:cf': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:0b:4e:81'},
                                             'dl_rssi': -61.0,
                                             'ip_address': '10.3.254.113',
                                             'mac_address': '00:15:67:f6:34:cf',
                                             'name': 'Lindy Harris',
                                             'ul_rssi': -65.0},
                '00:15:67:f7:a4:91': {       'alt_macs': set(),
                                             'dev_macs': {'3c:37:86:75:67:d6'},
                                             'dl_rssi': -61.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:a4:91',
                                             'name': 'Colbath',
                                             'ul_rssi': -66.0},
                '00:15:67:f7:a4:c7': {       'alt_macs': set(),
                                             'dev_macs': {'00:04:56:1e:30:e9'},
                                             'dl_rssi': -61.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:a4:c7',
                                             'name': 'FatBoys',
                                             'ul_rssi': -67.0},
                '00:15:67:f7:bc:70': {       'alt_macs': set(),
                                             'dev_macs': {'00:04:56:19:05:f1'},
                                             'dl_rssi': -64.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:bc:70',
                                             'name': 'Alvarez',
                                             'ul_rssi': -73.0},
                '00:15:67:f7:bd:7d': {       'alt_macs': set(),
                                             'dev_macs': {'00:04:56:1b:02:99'},
                                             'dl_rssi': -66.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:bd:7d',
                                             'name': 'GrahamLoren',
                                             'ul_rssi': -69.0},
                '00:15:67:f7:c5:9a': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:0d:bf:59'},
                                             'dl_rssi': -57.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f7:c5:9a',
                                             'name': 'R. Scott',
                                             'ul_rssi': -68.0},
                '00:15:67:f8:b5:e7': {       'alt_macs': set(),
                                             'dev_macs': {'00:04:56:1a:de:79'},
                                             'dl_rssi': -59.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f8:b5:e7',
                                             'name': 'Chance',
                                             'ul_rssi': -71.0},
                '00:15:67:f8:fe:74': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:02:ea:89'},
                                             'dl_rssi': -64.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:f8:fe:74',
                                             'name': 'JCPreSchool',
                                             'ul_rssi': -68.0},
                '00:15:67:fb:51:ef': {       'alt_macs': set(),
                                             'dev_macs': {'00:04:56:1d:8e:41'},
                                             'dl_rssi': -58.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:fb:51:ef',
                                             'name': 'Bergman',
                                             'ul_rssi': -65.0},
                '00:15:67:fb:e4:f2': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:0d:7e:d9'},
                                             'dl_rssi': -61.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:fb:e4:f2',
                                             'name': 'Shannan',
                                             'ul_rssi': -66.0},
                '00:15:67:fb:e7:d7': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:0a:17:59'},
                                             'dl_rssi': -63.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:fb:e7:d7',
                                             'name': 'Marrowquin',
                                             'ul_rssi': -79.0},
                '00:15:67:fc:56:cb': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:09:23:d9'},
                                             'dl_rssi': -68.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:fc:56:cb',
                                             'name': 'GrahamTravis',
                                             'ul_rssi': -75.0},
                '00:15:67:fc:56:e6': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:09:2b:e1'},
                                             'dl_rssi': -55.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:fc:56:e6',
                                             'name': 'OdellRobert',
                                             'ul_rssi': -64.0},
                '00:15:67:fc:58:2d': {       'alt_macs': set(),
                                             'dev_macs': {'00:04:56:17:6f:29'},
                                             'dl_rssi': -57.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:fc:58:2d',
                                             'name': 'HudsonBarbara',
                                             'ul_rssi': -63.0},
                '00:15:67:fd:63:2c': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:e0:ef:a9'},
                                             'dl_rssi': -62.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:fd:63:2c',
                                             'name': 'SooterEdwin',
                                             'ul_rssi': -76.0},
                '00:15:67:fd:63:cf': {       'alt_macs': set(),
                                             'dev_macs': {'bc:e6:7c:0d:63:81'},
                                             'dl_rssi': -63.0,
                                             'ip_address': '10.0.0.120',
                                             'mac_address': '00:15:67:fd:63:cf',
                                             'name': 'MasseyAbigail',
                                             'ul_rssi': -73.0}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '55010235',
                                                              'in_octets': '1774463564',
                                                              'in_ucast_pkts': '3948407296',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:15:67:69:55:71',
                                                              'mtu': 2047,
                                                              'name': 'Management Port '
                                                                      'on Odu',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '345549',
                                                              'out_octets': '1504975716',
                                                              'out_ucast_pkts': '1504584845',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '00:04:56:1e:30:e9'],
                                                                                       'in_octets': '413599374',
                                                                                       'in_ucast_pkts': '19184844',
                                                                                       'mac_address': '00:15:67:f7:a4:c7',
                                                                                       'out_octets': '4257057433',
                                                                                       'out_ucast_pkts': '34970252'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:0b:4e:81'],
                                                                                       'in_octets': '2431213327',
                                                                                       'in_ucast_pkts': '20316637',
                                                                                       'mac_address': '00:15:67:f6:34:cf',
                                                                                       'out_octets': '404239177',
                                                                                       'out_ucast_pkts': '36598781'},
                                                                               {       'bridged_mac_addresses': [       '58:ef:68:aa:dc:b6'],
                                                                                       'in_octets': '579912',
                                                                                       'in_ucast_pkts': '3448',
                                                                                       'mac_address': '00:15:67:e2:ed:bd',
                                                                                       'out_octets': '8257795',
                                                                                       'out_ucast_pkts': '81420'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:0d:63:81'],
                                                                                       'in_octets': '1358703659',
                                                                                       'in_ucast_pkts': '78116625',
                                                                                       'mac_address': '00:15:67:fd:63:cf',
                                                                                       'out_octets': '2744771366',
                                                                                       'out_ucast_pkts': '136106052'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:0a:17:59'],
                                                                                       'in_octets': '1753289683',
                                                                                       'in_ucast_pkts': '89072370',
                                                                                       'mac_address': '00:15:67:fb:e7:d7',
                                                                                       'out_octets': '22658754',
                                                                                       'out_ucast_pkts': '168979265'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1a:de:79'],
                                                                                       'in_octets': '14161973',
                                                                                       'in_ucast_pkts': '175400',
                                                                                       'mac_address': '00:15:67:f8:b5:e7',
                                                                                       'out_octets': '245647732',
                                                                                       'out_ucast_pkts': '231392'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1b:02:99'],
                                                                                       'in_octets': '74189193',
                                                                                       'in_ucast_pkts': '457884',
                                                                                       'mac_address': '00:15:67:f7:bd:7d',
                                                                                       'out_octets': '803552054',
                                                                                       'out_ucast_pkts': '661472'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:19:05:f1'],
                                                                                       'in_octets': '3354222414',
                                                                                       'in_ucast_pkts': '195066989',
                                                                                       'mac_address': '00:15:67:f7:bc:70',
                                                                                       'out_octets': '3162531123',
                                                                                       'out_ucast_pkts': '339664083'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:0d:bf:59'],
                                                                                       'in_octets': '38021272',
                                                                                       'in_ucast_pkts': '157911',
                                                                                       'mac_address': '00:15:67:f7:c5:9a',
                                                                                       'out_octets': '780828751',
                                                                                       'out_ucast_pkts': '696486'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:08:3e:f0'],
                                                                                       'in_octets': '315825698',
                                                                                       'in_ucast_pkts': '394879',
                                                                                       'mac_address': '00:15:67:e2:8a:fd',
                                                                                       'out_octets': '349900908',
                                                                                       'out_ucast_pkts': '442797'},
                                                                               {       'bridged_mac_addresses': [       '3c:37:86:76:14:7f'],
                                                                                       'in_octets': '2261935587',
                                                                                       'in_ucast_pkts': '2444816',
                                                                                       'mac_address': '00:15:67:63:02:8b',
                                                                                       'out_octets': '849424645',
                                                                                       'out_ucast_pkts': '2324205'},
                                                                               {       'bridged_mac_addresses': [       '24:05:88:20:90:ed'],
                                                                                       'in_octets': '2841736318',
                                                                                       'in_ucast_pkts': '122322249',
                                                                                       'mac_address': '00:15:67:80:be:0f',
                                                                                       'out_octets': '428534928',
                                                                                       'out_ucast_pkts': '303164087'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:e0:ef:a9'],
                                                                                       'in_octets': '7560594',
                                                                                       'in_ucast_pkts': '45557',
                                                                                       'mac_address': '00:15:67:fd:63:2c',
                                                                                       'out_octets': '68935574',
                                                                                       'out_ucast_pkts': '126880'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1d:8e:41'],
                                                                                       'in_octets': '11185677',
                                                                                       'in_ucast_pkts': '131006',
                                                                                       'mac_address': '00:15:67:fb:51:ef',
                                                                                       'out_octets': '401449358',
                                                                                       'out_ucast_pkts': '326694'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:0d:7e:d9'],
                                                                                       'in_octets': '229809523',
                                                                                       'in_ucast_pkts': '1135239',
                                                                                       'mac_address': '00:15:67:fb:e4:f2',
                                                                                       'out_octets': '2964962272',
                                                                                       'out_ucast_pkts': '2108738'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:17:89:a1'],
                                                                                       'in_octets': '59831886',
                                                                                       'in_ucast_pkts': '464501',
                                                                                       'mac_address': '00:15:67:00:2e:4e',
                                                                                       'out_octets': '1919392003',
                                                                                       'out_ucast_pkts': '1451420'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:09:2b:e1'],
                                                                                       'in_octets': '205122698',
                                                                                       'in_ucast_pkts': '2227171',
                                                                                       'mac_address': '00:15:67:fc:56:e6',
                                                                                       'out_octets': '4289416643',
                                                                                       'out_ucast_pkts': '5808361'},
                                                                               {       'bridged_mac_addresses': [       '3c:37:86:75:67:d6'],
                                                                                       'in_octets': '1282555591',
                                                                                       'in_ucast_pkts': '13440076',
                                                                                       'mac_address': '00:15:67:f7:a4:91',
                                                                                       'out_octets': '441910116',
                                                                                       'out_ucast_pkts': '41143624'},
                                                                               {       'in_octets': '3029024648',
                                                                                       'in_ucast_pkts': '244476444',
                                                                                       'mac_address': '00:15:67:62:dc:24',
                                                                                       'out_octets': '3192728529',
                                                                                       'out_ucast_pkts': '347933057'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:09:23:d9'],
                                                                                       'in_octets': '1005823664',
                                                                                       'in_ucast_pkts': '966062510',
                                                                                       'mac_address': '00:15:67:fc:56:cb',
                                                                                       'out_octets': '3910274826',
                                                                                       'out_ucast_pkts': '2037783555'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:17:6f:29'],
                                                                                       'in_octets': '7369172',
                                                                                       'in_ucast_pkts': '55960',
                                                                                       'mac_address': '00:15:67:fc:58:2d',
                                                                                       'out_octets': '76470389',
                                                                                       'out_ucast_pkts': '122010'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:02:ea:89'],
                                                                                       'in_octets': '34053213',
                                                                                       'in_ucast_pkts': '292804',
                                                                                       'mac_address': '00:15:67:f8:fe:74',
                                                                                       'out_octets': '574995739',
                                                                                       'out_ucast_pkts': '440341'},
                                                                               {       'bridged_mac_addresses': [       'bc:e6:7c:e1:92:d9'],
                                                                                       'in_octets': '2861660761',
                                                                                       'in_ucast_pkts': '59194935',
                                                                                       'mac_address': '00:15:67:e2:ee:c6',
                                                                                       'out_octets': '2734313270',
                                                                                       'out_ucast_pkts': '93902334'},
                                                                               {       'bridged_mac_addresses': [       'b4:fb:e4:27:6c:56'],
                                                                                       'in_octets': '1580484270',
                                                                                       'in_ucast_pkts': '68350830',
                                                                                       'mac_address': '00:15:67:00:ad:0d',
                                                                                       'out_octets': '629226992',
                                                                                       'out_ucast_pkts': '96321555'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:08:3b:17'],
                                                                                       'in_octets': '3981877890',
                                                                                       'in_ucast_pkts': '128691965',
                                                                                       'mac_address': '00:15:67:62:ec:d8',
                                                                                       'out_octets': '1943320492',
                                                                                       'out_ucast_pkts': '175495150'}],
                                                              'mac_address': '00:15:67:e9:60:cb',
                                                              'name': 'Radio Interface',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5190,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:15:67:f7:a4:c7',
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:f6:34:cf',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:e2:ed:bd',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '243000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '00:15:67:fd:63:cf',
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:fb:e7:d7',
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '40500000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:f8:b5:e7',
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '216000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:f7:bd:7d',
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '216000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:f7:bc:70',
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:f7:c5:9a',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '130000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '360000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '00:15:67:e2:8a:fd',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '00:15:67:63:02:8b',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:80:be:0f',
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '00:15:67:fd:63:2c',
                                                                                                                                            'rssi': -76.0,
                                                                                                                                            'rx_link_rate': '121500000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '216000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:fb:51:ef',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:fb:e4:f2',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '144444444',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '173333333',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '00:15:67:00:2e:4e',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:fc:56:e6',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '162000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:f7:a4:91',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '243000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:62:dc:24',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '243000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '324000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'mac_address': '00:15:67:fc:56:cb',
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:fc:58:2d',
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '108000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '400000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:f8:fe:74',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:e2:ee:c6',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '324000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:00:ad:0d',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '162000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:62:ec:d8',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '324000000',
                                                                                                                                            'tx_mcs': 8}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Radwin',
                                'model': 'RW-5AB5-0658',
                                'poller_hash': 'ABVn6WDL',
                                'sw_version': '4.9.70_b0015_May  2 2019',
                                'temperature': 26.0,
                                'uptime': '15392743'},
                'peers': [       {       'interfaces': [       {       'in_octets': '4257057433',
                                                                       'in_ucast_pkts': '34970252',
                                                                       'links': [       {       'in_octets': '4257057433',
                                                                                                'in_ucast_pkts': '34970252',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '413599374',
                                                                                                'out_ucast_pkts': '19184844'}],
                                                                       'mac_address': '00:15:67:f7:a4:c7',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '413599374',
                                                                       'out_ucast_pkts': '19184844',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '413599374',
                                                                       'in_ucast_pkts': '19184844',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '4257057433',
                                                                       'out_ucast_pkts': '34970252',
                                                                       'poller_hash': 'MDAxNTY3ZjdhNGM3TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'FatBoys',
                                         'poller_hash': 'ABVn96TH',
                                         'serial_number': 'P15000I000M01732',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '404239177',
                                                                       'in_ucast_pkts': '36598781',
                                                                       'links': [       {       'in_octets': '404239177',
                                                                                                'in_ucast_pkts': '36598781',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '2431213327',
                                                                                                'out_ucast_pkts': '20316637'}],
                                                                       'mac_address': '00:15:67:f6:34:cf',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2431213327',
                                                                       'out_ucast_pkts': '20316637',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2431213327',
                                                                       'in_ucast_pkts': '20316637',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '404239177',
                                                                       'out_ucast_pkts': '36598781',
                                                                       'poller_hash': 'MDAxNTY3ZjYzNGNmTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.3.254.113',
                                         'manufacturer': 'Radwin',
                                         'name': 'Lindy Harris',
                                         'poller_hash': 'ABVn9jTP',
                                         'serial_number': 'P15000I000Q01391',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '8257795',
                                                                       'in_ucast_pkts': '81420',
                                                                       'links': [       {       'in_octets': '8257795',
                                                                                                'in_ucast_pkts': '81420',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '579912',
                                                                                                'out_ucast_pkts': '3448'}],
                                                                       'mac_address': '00:15:67:e2:ed:bd',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '579912',
                                                                       'out_ucast_pkts': '3448',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '243000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '243000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '579912',
                                                                       'in_ucast_pkts': '3448',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '8257795',
                                                                       'out_ucast_pkts': '81420',
                                                                       'poller_hash': 'MDAxNTY3ZTJlZGJkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.3.254.216',
                                         'manufacturer': 'Radwin',
                                         'name': 'Anders Realty',
                                         'poller_hash': 'ABVn4u29',
                                         'serial_number': 'P15000I000P00750',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2744771366',
                                                                       'in_ucast_pkts': '136106052',
                                                                       'links': [       {       'in_octets': '2744771366',
                                                                                                'in_ucast_pkts': '136106052',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '1358703659',
                                                                                                'out_ucast_pkts': '78116625'}],
                                                                       'mac_address': '00:15:67:fd:63:cf',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1358703659',
                                                                       'out_ucast_pkts': '78116625',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1358703659',
                                                                       'in_ucast_pkts': '78116625',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2744771366',
                                                                       'out_ucast_pkts': '136106052',
                                                                       'poller_hash': 'MDAxNTY3ZmQ2M2NmTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'MasseyAbigail',
                                         'poller_hash': 'ABVn/WPP',
                                         'serial_number': 'P15000I000T03273',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '22658754',
                                                                       'in_ucast_pkts': '168979265',
                                                                       'links': [       {       'in_octets': '22658754',
                                                                                                'in_ucast_pkts': '168979265',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '1753289683',
                                                                                                'out_ucast_pkts': '89072370'}],
                                                                       'mac_address': '00:15:67:fb:e7:d7',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1753289683',
                                                                       'out_ucast_pkts': '89072370',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '40500000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '40500000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1753289683',
                                                                       'in_ucast_pkts': '89072370',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '22658754',
                                                                       'out_ucast_pkts': '168979265',
                                                                       'poller_hash': 'MDAxNTY3ZmJlN2Q3TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'Marrowquin',
                                         'poller_hash': 'ABVn++fX',
                                         'serial_number': 'P17400I000B00357',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '245647732',
                                                                       'in_ucast_pkts': '231392',
                                                                       'links': [       {       'in_octets': '245647732',
                                                                                                'in_ucast_pkts': '231392',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '14161973',
                                                                                                'out_ucast_pkts': '175400'}],
                                                                       'mac_address': '00:15:67:f8:b5:e7',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '14161973',
                                                                       'out_ucast_pkts': '175400',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '216000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '216000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '14161973',
                                                                       'in_ucast_pkts': '175400',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '245647732',
                                                                       'out_ucast_pkts': '231392',
                                                                       'poller_hash': 'MDAxNTY3ZjhiNWU3TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'Chance',
                                         'poller_hash': 'ABVn+LXn',
                                         'serial_number': 'P15000I000M01844',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '803552054',
                                                                       'in_ucast_pkts': '661472',
                                                                       'links': [       {       'in_octets': '803552054',
                                                                                                'in_ucast_pkts': '661472',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '74189193',
                                                                                                'out_ucast_pkts': '457884'}],
                                                                       'mac_address': '00:15:67:f7:bd:7d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '74189193',
                                                                       'out_ucast_pkts': '457884',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '216000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '216000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '74189193',
                                                                       'in_ucast_pkts': '457884',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '803552054',
                                                                       'out_ucast_pkts': '661472',
                                                                       'poller_hash': 'MDAxNTY3ZjdiZDdkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'GrahamLoren',
                                         'poller_hash': 'ABVn9719',
                                         'serial_number': 'P15000I000M01688',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3162531123',
                                                                       'in_ucast_pkts': '339664083',
                                                                       'links': [       {       'in_octets': '3162531123',
                                                                                                'in_ucast_pkts': '339664083',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '3354222414',
                                                                                                'out_ucast_pkts': '195066989'}],
                                                                       'mac_address': '00:15:67:f7:bc:70',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3354222414',
                                                                       'out_ucast_pkts': '195066989',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3354222414',
                                                                       'in_ucast_pkts': '195066989',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3162531123',
                                                                       'out_ucast_pkts': '339664083',
                                                                       'poller_hash': 'MDAxNTY3ZjdiYzcwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'Alvarez',
                                         'poller_hash': 'ABVn97xw',
                                         'serial_number': 'P15000I000T01181',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '780828751',
                                                                       'in_ucast_pkts': '696486',
                                                                       'links': [       {       'in_octets': '780828751',
                                                                                                'in_ucast_pkts': '696486',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '38021272',
                                                                                                'out_ucast_pkts': '157911'}],
                                                                       'mac_address': '00:15:67:f7:c5:9a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '38021272',
                                                                       'out_ucast_pkts': '157911',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '360000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '360000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '130000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '130000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '38021272',
                                                                       'in_ucast_pkts': '157911',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '780828751',
                                                                       'out_ucast_pkts': '696486',
                                                                       'poller_hash': 'MDAxNTY3ZjdjNTlhTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'R. Scott',
                                         'poller_hash': 'ABVn98Wa',
                                         'serial_number': 'P15000I000M01734',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '349900908',
                                                                       'in_ucast_pkts': '442797',
                                                                       'links': [       {       'in_octets': '349900908',
                                                                                                'in_ucast_pkts': '442797',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '315825698',
                                                                                                'out_ucast_pkts': '394879'}],
                                                                       'mac_address': '00:15:67:e2:8a:fd',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '315825698',
                                                                       'out_ucast_pkts': '394879',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '240000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '315825698',
                                                                       'in_ucast_pkts': '394879',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '349900908',
                                                                       'out_ucast_pkts': '442797',
                                                                       'poller_hash': 'MDAxNTY3ZTI4YWZkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'Marissa',
                                         'poller_hash': 'ABVn4or9',
                                         'serial_number': 'P14880I200P00117',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '849424645',
                                                                       'in_ucast_pkts': '2324205',
                                                                       'links': [       {       'in_octets': '849424645',
                                                                                                'in_ucast_pkts': '2324205',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '2261935587',
                                                                                                'out_ucast_pkts': '2444816'}],
                                                                       'mac_address': '00:15:67:63:02:8b',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2261935587',
                                                                       'out_ucast_pkts': '2444816',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2261935587',
                                                                       'in_ucast_pkts': '2444816',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '849424645',
                                                                       'out_ucast_pkts': '2324205',
                                                                       'poller_hash': 'MDAxNTY3NjMwMjhiTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'FarmhouseTasting',
                                         'poller_hash': 'ABVnYwKL',
                                         'serial_number': 'P15000I000M00897',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '428534928',
                                                                       'in_ucast_pkts': '303164087',
                                                                       'links': [       {       'in_octets': '428534928',
                                                                                                'in_ucast_pkts': '303164087',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '2841736318',
                                                                                                'out_ucast_pkts': '122322249'}],
                                                                       'mac_address': '00:15:67:80:be:0f',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2841736318',
                                                                       'out_ucast_pkts': '122322249',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2841736318',
                                                                       'in_ucast_pkts': '122322249',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '428534928',
                                                                       'out_ucast_pkts': '303164087',
                                                                       'poller_hash': 'MDAxNTY3ODBiZTBmTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.3.254.117',
                                         'manufacturer': 'Radwin',
                                         'name': 'David Benner JR',
                                         'poller_hash': 'ABVngL4P',
                                         'serial_number': 'P15000I000P01264',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '68935574',
                                                                       'in_ucast_pkts': '126880',
                                                                       'links': [       {       'in_octets': '68935574',
                                                                                                'in_ucast_pkts': '126880',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '7560594',
                                                                                                'out_ucast_pkts': '45557'}],
                                                                       'mac_address': '00:15:67:fd:63:2c',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '7560594',
                                                                       'out_ucast_pkts': '45557',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '216000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '216000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '121500000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '121500000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '7560594',
                                                                       'in_ucast_pkts': '45557',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '68935574',
                                                                       'out_ucast_pkts': '126880',
                                                                       'poller_hash': 'MDAxNTY3ZmQ2MzJjTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'SooterEdwin',
                                         'poller_hash': 'ABVn/WMs',
                                         'serial_number': 'P15000I000E02425',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '401449358',
                                                                       'in_ucast_pkts': '326694',
                                                                       'links': [       {       'in_octets': '401449358',
                                                                                                'in_ucast_pkts': '326694',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '11185677',
                                                                                                'out_ucast_pkts': '131006'}],
                                                                       'mac_address': '00:15:67:fb:51:ef',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '11185677',
                                                                       'out_ucast_pkts': '131006',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '11185677',
                                                                       'in_ucast_pkts': '131006',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '401449358',
                                                                       'out_ucast_pkts': '326694',
                                                                       'poller_hash': 'MDAxNTY3ZmI1MWVmTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'Bergman',
                                         'poller_hash': 'ABVn+1Hv',
                                         'serial_number': 'P15000I000E00707',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2964962272',
                                                                       'in_ucast_pkts': '2108738',
                                                                       'links': [       {       'in_octets': '2964962272',
                                                                                                'in_ucast_pkts': '2108738',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '229809523',
                                                                                                'out_ucast_pkts': '1135239'}],
                                                                       'mac_address': '00:15:67:fb:e4:f2',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '229809523',
                                                                       'out_ucast_pkts': '1135239',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '173333333',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '173333333',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '144444444',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '144444444'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '229809523',
                                                                       'in_ucast_pkts': '1135239',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2964962272',
                                                                       'out_ucast_pkts': '2108738',
                                                                       'poller_hash': 'MDAxNTY3ZmJlNGYyTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'Shannan',
                                         'poller_hash': 'ABVn++Ty',
                                         'serial_number': 'P15000I000U02376',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1919392003',
                                                                       'in_ucast_pkts': '1451420',
                                                                       'links': [       {       'in_octets': '1919392003',
                                                                                                'in_ucast_pkts': '1451420',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '59831886',
                                                                                                'out_ucast_pkts': '464501'}],
                                                                       'mac_address': '00:15:67:00:2e:4e',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '59831886',
                                                                       'out_ucast_pkts': '464501',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '59831886',
                                                                       'in_ucast_pkts': '464501',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1919392003',
                                                                       'out_ucast_pkts': '1451420',
                                                                       'poller_hash': 'MDAxNTY3MDAyZTRlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.3.254.91',
                                         'manufacturer': 'Radwin',
                                         'name': 'J. Garza',
                                         'poller_hash': 'ABVnAC5O',
                                         'serial_number': 'P15000I000U00532',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '4289416643',
                                                                       'in_ucast_pkts': '5808361',
                                                                       'links': [       {       'in_octets': '4289416643',
                                                                                                'in_ucast_pkts': '5808361',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '205122698',
                                                                                                'out_ucast_pkts': '2227171'}],
                                                                       'mac_address': '00:15:67:fc:56:e6',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '205122698',
                                                                       'out_ucast_pkts': '2227171',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '162000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '162000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '205122698',
                                                                       'in_ucast_pkts': '2227171',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '4289416643',
                                                                       'out_ucast_pkts': '5808361',
                                                                       'poller_hash': 'MDAxNTY3ZmM1NmU2TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'OdellRobert',
                                         'poller_hash': 'ABVn/Fbm',
                                         'serial_number': 'P15000I000E01014',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '441910116',
                                                                       'in_ucast_pkts': '41143624',
                                                                       'links': [       {       'in_octets': '441910116',
                                                                                                'in_ucast_pkts': '41143624',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '1282555591',
                                                                                                'out_ucast_pkts': '13440076'}],
                                                                       'mac_address': '00:15:67:f7:a4:91',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1282555591',
                                                                       'out_ucast_pkts': '13440076',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '243000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '243000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1282555591',
                                                                       'in_ucast_pkts': '13440076',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '441910116',
                                                                       'out_ucast_pkts': '41143624',
                                                                       'poller_hash': 'MDAxNTY3ZjdhNDkxTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'Colbath',
                                         'poller_hash': 'ABVn96SR',
                                         'serial_number': 'P15000I000W01313',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3192728529',
                                                                       'in_ucast_pkts': '347933057',
                                                                       'links': [       {       'in_octets': '3192728529',
                                                                                                'in_ucast_pkts': '347933057',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '3029024648',
                                                                                                'out_ucast_pkts': '244476444'}],
                                                                       'mac_address': '00:15:67:62:dc:24',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3029024648',
                                                                       'out_ucast_pkts': '244476444',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '324000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '324000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '243000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '243000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3029024648',
                                                                       'in_ucast_pkts': '244476444',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3192728529',
                                                                       'out_ucast_pkts': '347933057',
                                                                       'poller_hash': 'MDAxNTY3NjJkYzI0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'JC City Hall',
                                         'poller_hash': 'ABVnYtwk',
                                         'serial_number': 'P15000I000M00603',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3910274826',
                                                                       'in_ucast_pkts': '2037783555',
                                                                       'links': [       {       'in_octets': '3910274826',
                                                                                                'in_ucast_pkts': '2037783555',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '1005823664',
                                                                                                'out_ucast_pkts': '966062510'}],
                                                                       'mac_address': '00:15:67:fc:56:cb',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1005823664',
                                                                       'out_ucast_pkts': '966062510',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1005823664',
                                                                       'in_ucast_pkts': '966062510',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3910274826',
                                                                       'out_ucast_pkts': '2037783555',
                                                                       'poller_hash': 'MDAxNTY3ZmM1NmNiTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'GrahamTravis',
                                         'poller_hash': 'ABVn/FbL',
                                         'serial_number': 'P15000I000T01802',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '76470389',
                                                                       'in_ucast_pkts': '122010',
                                                                       'links': [       {       'in_octets': '76470389',
                                                                                                'in_ucast_pkts': '122010',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '7369172',
                                                                                                'out_ucast_pkts': '55960'}],
                                                                       'mac_address': '00:15:67:fc:58:2d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '7369172',
                                                                       'out_ucast_pkts': '55960',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '400000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '400000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '108000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '108000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '7369172',
                                                                       'in_ucast_pkts': '55960',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '76470389',
                                                                       'out_ucast_pkts': '122010',
                                                                       'poller_hash': 'MDAxNTY3ZmM1ODJkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'HudsonBarbara',
                                         'poller_hash': 'ABVn/Fgt',
                                         'serial_number': 'P15000I000W02504',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '574995739',
                                                                       'in_ucast_pkts': '440341',
                                                                       'links': [       {       'in_octets': '574995739',
                                                                                                'in_ucast_pkts': '440341',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '34053213',
                                                                                                'out_ucast_pkts': '292804'}],
                                                                       'mac_address': '00:15:67:f8:fe:74',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '34053213',
                                                                       'out_ucast_pkts': '292804',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '34053213',
                                                                       'in_ucast_pkts': '292804',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '574995739',
                                                                       'out_ucast_pkts': '440341',
                                                                       'poller_hash': 'MDAxNTY3ZjhmZTc0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'JCPreSchool',
                                         'poller_hash': 'ABVn+P50',
                                         'serial_number': 'P15000I000B00171',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2734313270',
                                                                       'in_ucast_pkts': '93902334',
                                                                       'links': [       {       'in_octets': '2734313270',
                                                                                                'in_ucast_pkts': '93902334',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '2861660761',
                                                                                                'out_ucast_pkts': '59194935'}],
                                                                       'mac_address': '00:15:67:e2:ee:c6',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2861660761',
                                                                       'out_ucast_pkts': '59194935',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '324000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '324000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2861660761',
                                                                       'in_ucast_pkts': '59194935',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2734313270',
                                                                       'out_ucast_pkts': '93902334',
                                                                       'poller_hash': 'MDAxNTY3ZTJlZWM2TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.3.254.203',
                                         'manufacturer': 'Radwin',
                                         'name': 'Crawford',
                                         'poller_hash': 'ABVn4u7G',
                                         'serial_number': 'P15000I000M00733',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '629226992',
                                                                       'in_ucast_pkts': '96321555',
                                                                       'links': [       {       'in_octets': '629226992',
                                                                                                'in_ucast_pkts': '96321555',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '1580484270',
                                                                                                'out_ucast_pkts': '68350830'}],
                                                                       'mac_address': '00:15:67:00:ad:0d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1580484270',
                                                                       'out_ucast_pkts': '68350830',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '162000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '162000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1580484270',
                                                                       'in_ucast_pkts': '68350830',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '629226992',
                                                                       'out_ucast_pkts': '96321555',
                                                                       'poller_hash': 'MDAxNTY3MDBhZDBkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.0.0.120',
                                         'manufacturer': 'Radwin',
                                         'name': 'HillCountryCupboard',
                                         'poller_hash': 'ABVnAK0N',
                                         'serial_number': 'P15000I000P01240',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1943320492',
                                                                       'in_ucast_pkts': '175495150',
                                                                       'links': [       {       'in_octets': '1943320492',
                                                                                                'in_ucast_pkts': '175495150',
                                                                                                'mac_address': '00:15:67:e9:60:cb',
                                                                                                'out_octets': '3981877890',
                                                                                                'out_ucast_pkts': '128691965'}],
                                                                       'mac_address': '00:15:67:62:ec:d8',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3981877890',
                                                                       'out_ucast_pkts': '128691965',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '324000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:e9:60:cb',
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '324000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3981877890',
                                                                       'in_ucast_pkts': '128691965',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1943320492',
                                                                       'out_ucast_pkts': '175495150',
                                                                       'poller_hash': 'MDAxNTY3NjJlY2Q4TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.3.254.226',
                                         'manufacturer': 'Radwin',
                                         'name': '1st Christian Church',
                                         'poller_hash': 'ABVnYuzY',
                                         'serial_number': 'P15000I000Q00568',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_radwin_winlink_RW_5AG5_0L50_5_1_10_b0020_May_21_2021_01(self):
        obj = self.run_data("radwin.winlink.RW-5AG5-0L50.5.1.10_b0020_May 21 2021.01")
        exp_info = {
                'model': 'RW-5AG5-0L50',
                'rf_chan_width': 20,
                'rf_freq': 5225,
                'sta_count': 17,
                'sw_version': '5.1.10_b0020_May 21 2021',
                'vendor': 'Radwin'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:15:67:f0:74:55': {       'alt_macs': {'00:15:67:f0:74:54'},
                                             'dev_macs': {'90:9a:4a:34:44:a9'},
                                             'dl_rssi': -65.0,
                                             'ip_address': '10.222.1.109',
                                             'mac_address': '00:15:67:f0:74:55',
                                             'name': 'Tracy',
                                             'ul_rssi': -59.0},
                '00:15:67:f0:74:67': {       'alt_macs': {'00:15:67:f0:74:66'},
                                             'dev_macs': {'74:83:c2:ef:ed:4e'},
                                             'dl_rssi': -66.0,
                                             'ip_address': '10.222.1.106',
                                             'mac_address': '00:15:67:f0:74:67',
                                             'name': 'Jeff Davis',
                                             'ul_rssi': -74.0},
                '00:15:67:f0:75:62': {       'alt_macs': {'00:15:67:f0:75:61'},
                                             'dev_macs': {'dc:2c:6e:b2:e6:3e'},
                                             'dl_rssi': -55.0,
                                             'ip_address': '10.222.1.117',
                                             'mac_address': '00:15:67:f0:75:62',
                                             'name': 'David Lucas',
                                             'ul_rssi': -50.0},
                '00:15:67:f0:75:72': {       'alt_macs': {'00:15:67:f0:75:71'},
                                             'dev_macs': {'2c:c8:1b:88:f4:2c'},
                                             'dl_rssi': -62.0,
                                             'ip_address': '10.222.1.110',
                                             'mac_address': '00:15:67:f0:75:72',
                                             'name': 'Pam Suppon',
                                             'ul_rssi': -58.0},
                '00:15:67:fd:ec:70': {       'alt_macs': {'00:15:67:fd:ec:6f'},
                                             'dev_macs': {'18:e8:29:25:d9:8d'},
                                             'dl_rssi': -66.0,
                                             'ip_address': '10.222.1.111',
                                             'mac_address': '00:15:67:fd:ec:70',
                                             'name': 'Perry Thompson',
                                             'ul_rssi': -77.0},
                '00:15:67:fd:ee:dd': {       'alt_macs': {'00:15:67:fd:ee:dc'},
                                             'dev_macs': {'b4:fb:e4:53:4e:80'},
                                             'dl_rssi': -69.0,
                                             'ip_address': '10.222.1.101',
                                             'mac_address': '00:15:67:fd:ee:dd',
                                             'name': 'Kelli Orender',
                                             'ul_rssi': -67.0},
                '00:15:67:fd:f0:79': {       'alt_macs': {'00:15:67:fd:f0:78'},
                                             'dev_macs': {'2c:c8:1b:88:f3:cc'},
                                             'dl_rssi': -58.0,
                                             'ip_address': '10.222.1.113',
                                             'mac_address': '00:15:67:fd:f0:79',
                                             'name': 'Osage green house',
                                             'ul_rssi': -56.0},
                '00:15:67:fe:8f:a9': {       'alt_macs': {'00:15:67:fe:8f:a8'},
                                             'dev_macs': {'08:55:31:9e:09:d9'},
                                             'dl_rssi': -55.0,
                                             'ip_address': '10.222.1.115',
                                             'mac_address': '00:15:67:fe:8f:a9',
                                             'name': 'KAB Tire',
                                             'ul_rssi': -58.0},
                '00:15:67:fe:8f:d3': {       'alt_macs': {'00:15:67:fe:8f:d2'},
                                             'dev_macs': {'2c:c8:1b:88:f4:81'},
                                             'dl_rssi': -70.0,
                                             'ip_address': '10.222.1.108',
                                             'mac_address': '00:15:67:fe:8f:d3',
                                             'name': 'Russell Baker',
                                             'ul_rssi': -65.0},
                '00:15:67:fe:90:a8': {       'alt_macs': {'00:15:67:fe:90:a7'},
                                             'dev_macs': {'08:02:8e:d2:ab:40'},
                                             'dl_rssi': -53.0,
                                             'ip_address': '10.222.1.102',
                                             'mac_address': '00:15:67:fe:90:a8',
                                             'name': 'Spencer Stromgren',
                                             'ul_rssi': -52.0},
                '00:15:67:fe:90:cc': {       'alt_macs': {'00:15:67:fe:90:cb'},
                                             'dev_macs': {'18:fd:74:18:84:80'},
                                             'dl_rssi': -49.0,
                                             'ip_address': '10.222.1.119',
                                             'mac_address': '00:15:67:fe:90:cc',
                                             'name': 'Ashlee Keim',
                                             'ul_rssi': -64.0},
                '00:15:67:fe:93:1d': {       'alt_macs': {'00:15:67:fe:93:1c'},
                                             'dev_macs': {'2c:c8:1b:88:f3:a6'},
                                             'dl_rssi': -65.0,
                                             'ip_address': '10.222.1.107',
                                             'mac_address': '00:15:67:fe:93:1d',
                                             'name': 'Gibbons',
                                             'ul_rssi': -63.0},
                '00:15:67:fe:95:92': {       'alt_macs': {'00:15:67:fe:95:91'},
                                             'dev_macs': {       '00:19:3b:0e:8b:1a',
                                                                 '00:19:3b:13:27:4a',
                                                                 '00:19:3b:13:27:4b',
                                                                 'dc:2c:6e:2f:29:c8',
                                                                 'dc:2c:6e:b2:e4:e7'},
                                             'dl_rssi': -51.0,
                                             'ip_address': '10.222.1.116',
                                             'mac_address': '00:15:67:fe:95:92',
                                             'name': 'Lazy J Custom Meats',
                                             'ul_rssi': -57.0},
                '00:15:67:fe:97:37': {       'alt_macs': {'00:15:67:fe:97:36'},
                                             'dev_macs': {'dc:2c:6e:2f:29:5c'},
                                             'dl_rssi': -57.0,
                                             'ip_address': '10.222.1.118',
                                             'mac_address': '00:15:67:fe:97:37',
                                             'name': 'Griffith',
                                             'ul_rssi': -73.0},
                '00:15:67:fe:97:49': {       'alt_macs': {'00:15:67:fe:97:48'},
                                             'dev_macs': {'2c:c8:1b:88:f3:91'},
                                             'dl_rssi': -73.0,
                                             'ip_address': '10.222.1.112',
                                             'mac_address': '00:15:67:fe:97:49',
                                             'name': 'Jason Gilliland',
                                             'ul_rssi': -68.0},
                '00:15:67:fe:99:04': {       'alt_macs': {'00:15:67:fe:99:03'},
                                             'dev_macs': {'2c:c8:1b:88:f2:f1'},
                                             'dl_rssi': -62.0,
                                             'ip_address': '10.222.1.104',
                                             'mac_address': '00:15:67:fe:99:04',
                                             'name': 'Joe Ryan',
                                             'ul_rssi': -76.0},
                '00:15:67:fe:99:75': {       'alt_macs': {'00:15:67:fe:99:74'},
                                             'dev_macs': {       '68:72:51:36:77:0b',
                                                                 '68:72:51:7a:50:bf',
                                                                 '6a:72:51:7b:50:bf',
                                                                 '74:ac:b9:79:5e:13',
                                                                 '80:2a:a8:df:c9:e8'},
                                             'dl_rssi': -60.0,
                                             'ip_address': '10.222.1.103',
                                             'mac_address': '00:15:67:fe:99:75',
                                             'name': 'Bowin Shop',
                                             'ul_rssi': -76.0}
        }
        exp_ne_msg = {
                'data': {       'elevation': 360.4,
                                'gps_sats_tracked': 13,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '24455218',
                                                              'in_octets': '1645534312',
                                                              'in_ucast_pkts': '2961012439',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:15:67:ed:28:d4',
                                                              'mtu': 9216,
                                                              'name': 'Management Port '
                                                                      'on Odu',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '3558206',
                                                              'out_octets': '546700912',
                                                              'out_ucast_pkts': '3905992852',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'in_octets': '553916650',
                                                              'in_ucast_pkts': '3909566670',
                                                              'links': [       {       'bridged_mac_addresses': [       'dc:2c:6e:b2:e6:3e'],
                                                                                       'in_octets': '3272709783',
                                                                                       'in_ucast_pkts': '120456393',
                                                                                       'mac_address': '00:15:67:f0:75:62',
                                                                                       'out_octets': '7160442',
                                                                                       'out_ucast_pkts': '184672059'},
                                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:88:f3:cc'],
                                                                                       'in_octets': '741085668',
                                                                                       'in_ucast_pkts': '5756496',
                                                                                       'mac_address': '00:15:67:fd:f0:79',
                                                                                       'out_octets': '1952644',
                                                                                       'out_ucast_pkts': '13542809'},
                                                                               {       'bridged_mac_addresses': [       'dc:2c:6e:2f:29:5c'],
                                                                                       'in_octets': '1345231550',
                                                                                       'in_ucast_pkts': '26558054',
                                                                                       'mac_address': '00:15:67:fe:97:37',
                                                                                       'out_octets': '462280825',
                                                                                       'out_ucast_pkts': '63042105'},
                                                                               {       'bridged_mac_addresses': [       '08:02:8e:d2:ab:40'],
                                                                                       'in_octets': '68357772',
                                                                                       'in_ucast_pkts': '348811',
                                                                                       'mac_address': '00:15:67:fe:90:a8',
                                                                                       'out_octets': '470401173',
                                                                                       'out_ucast_pkts': '1002637'},
                                                                               {       'bridged_mac_addresses': [       '68:72:51:36:77:0b',
                                                                                                                        '68:72:51:7a:50:bf',
                                                                                                                        '6a:72:51:7b:50:bf',
                                                                                                                        '74:ac:b9:79:5e:13',
                                                                                                                        '80:2a:a8:df:c9:e8'],
                                                                                       'in_octets': '2258059783',
                                                                                       'in_ucast_pkts': '23197912',
                                                                                       'mac_address': '00:15:67:fe:99:75',
                                                                                       'out_octets': '2379505408',
                                                                                       'out_ucast_pkts': '43364194'},
                                                                               {       'bridged_mac_addresses': [       'b4:fb:e4:53:4e:80'],
                                                                                       'in_octets': '2830985159',
                                                                                       'in_ucast_pkts': '20353570',
                                                                                       'mac_address': '00:15:67:fd:ee:dd',
                                                                                       'out_octets': '1762236864',
                                                                                       'out_ucast_pkts': '43939448'},
                                                                               {       'bridged_mac_addresses': [       '08:55:31:9e:09:d9'],
                                                                                       'in_octets': '1964788560',
                                                                                       'in_ucast_pkts': '87428300',
                                                                                       'mac_address': '00:15:67:fe:8f:a9',
                                                                                       'out_octets': '3472018466',
                                                                                       'out_ucast_pkts': '176872632'},
                                                                               {       'bridged_mac_addresses': [       '00:19:3b:0e:8b:1a',
                                                                                                                        '00:19:3b:13:27:4a',
                                                                                                                        '00:19:3b:13:27:4b',
                                                                                                                        'dc:2c:6e:2f:29:c8',
                                                                                                                        'dc:2c:6e:b2:e4:e7'],
                                                                                       'in_octets': '2677890900',
                                                                                       'in_ucast_pkts': '8012386',
                                                                                       'mac_address': '00:15:67:fe:95:92',
                                                                                       'out_octets': '2811325099',
                                                                                       'out_ucast_pkts': '19349965'},
                                                                               {       'bridged_mac_addresses': [       '18:fd:74:18:84:80'],
                                                                                       'in_octets': '2651298925',
                                                                                       'in_ucast_pkts': '62345151',
                                                                                       'mac_address': '00:15:67:fe:90:cc',
                                                                                       'out_octets': '3760717386',
                                                                                       'out_ucast_pkts': '132910101'},
                                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:88:f4:81'],
                                                                                       'in_octets': '1561981850',
                                                                                       'in_ucast_pkts': '8721228',
                                                                                       'mac_address': '00:15:67:fe:8f:d3',
                                                                                       'out_octets': '395722288',
                                                                                       'out_ucast_pkts': '20439890'},
                                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:88:f3:a6'],
                                                                                       'in_octets': '273211527',
                                                                                       'in_ucast_pkts': '12311052',
                                                                                       'mac_address': '00:15:67:fe:93:1d',
                                                                                       'out_octets': '3430565183',
                                                                                       'out_ucast_pkts': '21995585'},
                                                                               {       'bridged_mac_addresses': [       '74:83:c2:ef:ed:4e'],
                                                                                       'in_octets': '2476358287',
                                                                                       'in_ucast_pkts': '127018839',
                                                                                       'mac_address': '00:15:67:f0:74:67',
                                                                                       'out_octets': '2068039072',
                                                                                       'out_ucast_pkts': '194343917'},
                                                                               {       'bridged_mac_addresses': [       '90:9a:4a:34:44:a9'],
                                                                                       'in_octets': '1893078917',
                                                                                       'in_ucast_pkts': '55219975',
                                                                                       'mac_address': '00:15:67:f0:74:55',
                                                                                       'out_octets': '1655939836',
                                                                                       'out_ucast_pkts': '130629053'},
                                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:88:f4:2c'],
                                                                                       'in_octets': '1259674475',
                                                                                       'in_ucast_pkts': '493244061',
                                                                                       'mac_address': '00:15:67:f0:75:72',
                                                                                       'out_octets': '348523209',
                                                                                       'out_ucast_pkts': '961113546'},
                                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:88:f2:f1'],
                                                                                       'in_octets': '680952592',
                                                                                       'in_ucast_pkts': '320256340',
                                                                                       'mac_address': '00:15:67:fe:99:04',
                                                                                       'out_octets': '2823213805',
                                                                                       'out_ucast_pkts': '675756760'},
                                                                               {       'bridged_mac_addresses': [       '18:e8:29:25:d9:8d'],
                                                                                       'in_octets': '711321886',
                                                                                       'in_ucast_pkts': '550396176',
                                                                                       'mac_address': '00:15:67:fd:ec:70',
                                                                                       'out_octets': '3436678312',
                                                                                       'out_ucast_pkts': '851052444'},
                                                                               {       'bridged_mac_addresses': [       '2c:c8:1b:88:f3:91'],
                                                                                       'in_octets': '1224499388',
                                                                                       'in_ucast_pkts': '4419724',
                                                                                       'mac_address': '00:15:67:fe:97:49',
                                                                                       'out_octets': '2241242353',
                                                                                       'out_ucast_pkts': '12772603'}],
                                                              'mac_address': '00:15:67:ed:06:ad',
                                                              'name': 'Radio Interface',
                                                              'out_octets': '1723968894',
                                                              'out_ucast_pkts': '2985523125',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 70,
                                                                                        'frame_duration': 1250,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5225,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 150,
                                                                                                                                            'mac_address': '00:15:67:f0:75:62',
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '108000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '168000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:fd:f0:79',
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '108000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '280000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:fe:97:37',
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '17333333',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '121333333',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1050,
                                                                                                                                            'mac_address': '00:15:67:fe:90:a8',
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '252000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1650,
                                                                                                                                            'mac_address': '00:15:67:fe:99:75',
                                                                                                                                            'rssi': -76.0,
                                                                                                                                            'rx_link_rate': '17333333',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '121333333',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 1650,
                                                                                                                                            'mac_address': '00:15:67:fd:ee:dd',
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '27000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '63000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:fe:8f:a9',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '108000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '280000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'distance': 1200,
                                                                                                                                            'mac_address': '00:15:67:fe:95:92',
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '108000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'tx_link_rate': '140000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'mac_address': '00:15:67:fe:90:cc',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '34666666',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '121333333',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 750,
                                                                                                                                            'mac_address': '00:15:67:fe:8f:d3',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '54000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '126000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'distance': 600,
                                                                                                                                            'mac_address': '00:15:67:fe:93:1d',
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '54000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '126000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'distance': 150,
                                                                                                                                            'mac_address': '00:15:67:f0:74:67',
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '15600000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '60666666',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'distance': 150,
                                                                                                                                            'mac_address': '00:15:67:f0:74:55',
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '126000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'distance': 150,
                                                                                                                                            'mac_address': '00:15:67:f0:75:72',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '168000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'distance': 150,
                                                                                                                                            'mac_address': '00:15:67:fe:99:04',
                                                                                                                                            'rssi': -76.0,
                                                                                                                                            'rx_link_rate': '23400000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '121333333',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'distance': 3600,
                                                                                                                                            'mac_address': '00:15:67:fd:ec:70',
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '15600000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '80888888',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'distance': 9000,
                                                                                                                                            'mac_address': '00:15:67:fe:97:49',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '32400000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '84000000',
                                                                                                                                            'tx_mcs': 3}]}],
                                                                                        'tx_power': 17}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'AG01AGChoice '
                                                                                                 'E'}]}],
                                'latitude': 38.638593,
                                'longitude': -95.830248,
                                'manufacturer': 'Radwin',
                                'model': 'RW-5AG5-0L50',
                                'poller_hash': 'ABVn7Qat',
                                'serial_number': 'P20660IG00000149',
                                'sw_version': '5.1.10_b0020_May 21 2021',
                                'system_mac_address': '00:15:67:ed:28:d4',
                                'temperature': 41.0,
                                'uptime': '12022478'},
                'peers': [       {       'interfaces': [       {       'in_octets': '7160442',
                                                                       'in_ucast_pkts': '184672059',
                                                                       'links': [       {       'in_octets': '7160442',
                                                                                                'in_ucast_pkts': '184672059',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '3272709783',
                                                                                                'out_ucast_pkts': '120456393'}],
                                                                       'mac_address': '00:15:67:f0:75:62',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3272709783',
                                                                       'out_ucast_pkts': '120456393',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '168000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 150,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '168000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '108000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '108000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '3272709783',
                                                                       'in_ucast_pkts': '120456393',
                                                                       'mac_address': '00:15:67:f0:75:61',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '7160442',
                                                                       'out_ucast_pkts': '184672059',
                                                                       'poller_hash': 'MDAxNTY3ZjA3NTYyTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.222.1.117',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'David Lucas',
                                         'poller_hash': 'ABVn8HVi',
                                         'serial_number': 'P15000I000E04415',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.9.75_b0061_Mar 24 2020'},
                                 {       'interfaces': [       {       'in_octets': '1952644',
                                                                       'in_ucast_pkts': '13542809',
                                                                       'links': [       {       'in_octets': '1952644',
                                                                                                'in_ucast_pkts': '13542809',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '741085668',
                                                                                                'out_ucast_pkts': '5756496'}],
                                                                       'mac_address': '00:15:67:fd:f0:79',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '741085668',
                                                                       'out_ucast_pkts': '5756496',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '280000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '280000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '108000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '108000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '741085668',
                                                                       'in_ucast_pkts': '5756496',
                                                                       'mac_address': '00:15:67:fd:f0:78',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1952644',
                                                                       'out_ucast_pkts': '13542809',
                                                                       'poller_hash': 'MDAxNTY3ZmRmMDc5TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.222.1.113',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Osage green house',
                                         'poller_hash': 'ABVn/fB5',
                                         'serial_number': 'P17400I000X01977',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '462280825',
                                                                       'in_ucast_pkts': '63042105',
                                                                       'links': [       {       'in_octets': '462280825',
                                                                                                'in_ucast_pkts': '63042105',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '1345231550',
                                                                                                'out_ucast_pkts': '26558054'}],
                                                                       'mac_address': '00:15:67:fe:97:37',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1345231550',
                                                                       'out_ucast_pkts': '26558054',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '121333333',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '121333333',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '17333333',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '17333333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1345231550',
                                                                       'in_ucast_pkts': '26558054',
                                                                       'mac_address': '00:15:67:fe:97:36',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '462280825',
                                                                       'out_ucast_pkts': '63042105',
                                                                       'poller_hash': 'MDAxNTY3ZmU5NzM3TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.222.1.118',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Griffith',
                                         'poller_hash': 'ABVn/pc3',
                                         'serial_number': 'P17400I000B00555',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '470401173',
                                                                       'in_ucast_pkts': '1002637',
                                                                       'links': [       {       'in_octets': '470401173',
                                                                                                'in_ucast_pkts': '1002637',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '68357772',
                                                                                                'out_ucast_pkts': '348811'}],
                                                                       'mac_address': '00:15:67:fe:90:a8',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '68357772',
                                                                       'out_ucast_pkts': '348811',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '252000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1050,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '252000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '68357772',
                                                                       'in_ucast_pkts': '348811',
                                                                       'mac_address': '00:15:67:fe:90:a7',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '470401173',
                                                                       'out_ucast_pkts': '1002637',
                                                                       'poller_hash': 'MDAxNTY3ZmU5MGE4TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.222.1.102',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Spencer Stromgren',
                                         'poller_hash': 'ABVn/pCo',
                                         'serial_number': 'P17400I000200544',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.1.10_b0020_May 21 2021'},
                                 {       'interfaces': [       {       'in_octets': '2379505408',
                                                                       'in_ucast_pkts': '43364194',
                                                                       'links': [       {       'in_octets': '2379505408',
                                                                                                'in_ucast_pkts': '43364194',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '2258059783',
                                                                                                'out_ucast_pkts': '23197912'}],
                                                                       'mac_address': '00:15:67:fe:99:75',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2258059783',
                                                                       'out_ucast_pkts': '23197912',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '121333333',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1650,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '121333333',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '17333333',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '17333333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2258059783',
                                                                       'in_ucast_pkts': '23197912',
                                                                       'mac_address': '00:15:67:fe:99:74',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '2379505408',
                                                                       'out_ucast_pkts': '43364194',
                                                                       'poller_hash': 'MDAxNTY3ZmU5OTc1TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.222.1.103',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Bowin Shop',
                                         'poller_hash': 'ABVn/pl1',
                                         'serial_number': 'P17400I000200531',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.1.10_b0020_May 21 2021'},
                                 {       'interfaces': [       {       'in_octets': '1762236864',
                                                                       'in_ucast_pkts': '43939448',
                                                                       'links': [       {       'in_octets': '1762236864',
                                                                                                'in_ucast_pkts': '43939448',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '2830985159',
                                                                                                'out_ucast_pkts': '20353570'}],
                                                                       'mac_address': '00:15:67:fd:ee:dd',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2830985159',
                                                                       'out_ucast_pkts': '20353570',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '63000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1650,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '63000000',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '27000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '27000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2830985159',
                                                                       'in_ucast_pkts': '20353570',
                                                                       'mac_address': '00:15:67:fd:ee:dc',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '1762236864',
                                                                       'out_ucast_pkts': '43939448',
                                                                       'poller_hash': 'MDAxNTY3ZmRlZWRkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.222.1.101',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Kelli Orender',
                                         'poller_hash': 'ABVn/e7d',
                                         'serial_number': 'P17400I000V00124',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.1.10_b0020_May 21 2021'},
                                 {       'interfaces': [       {       'in_octets': '3472018466',
                                                                       'in_ucast_pkts': '176872632',
                                                                       'links': [       {       'in_octets': '3472018466',
                                                                                                'in_ucast_pkts': '176872632',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '1964788560',
                                                                                                'out_ucast_pkts': '87428300'}],
                                                                       'mac_address': '00:15:67:fe:8f:a9',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1964788560',
                                                                       'out_ucast_pkts': '87428300',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '280000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '280000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '108000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '108000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1964788560',
                                                                       'in_ucast_pkts': '87428300',
                                                                       'mac_address': '00:15:67:fe:8f:a8',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3472018466',
                                                                       'out_ucast_pkts': '176872632',
                                                                       'poller_hash': 'MDAxNTY3ZmU4ZmE5TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.222.1.115',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'KAB Tire',
                                         'poller_hash': 'ABVn/o+p',
                                         'serial_number': 'P17400I000V00122',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2811325099',
                                                                       'in_ucast_pkts': '19349965',
                                                                       'links': [       {       'in_octets': '2811325099',
                                                                                                'in_ucast_pkts': '19349965',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '2677890900',
                                                                                                'out_ucast_pkts': '8012386'}],
                                                                       'mac_address': '00:15:67:fe:95:92',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2677890900',
                                                                       'out_ucast_pkts': '8012386',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '140000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1200,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '140000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'tx_link_rate': '108000000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '108000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2677890900',
                                                                       'in_ucast_pkts': '8012386',
                                                                       'mac_address': '00:15:67:fe:95:91',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '2811325099',
                                                                       'out_ucast_pkts': '19349965',
                                                                       'poller_hash': 'MDAxNTY3ZmU5NTkyTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.222.1.116',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Lazy J Custom Meats',
                                         'poller_hash': 'ABVn/pWS',
                                         'serial_number': 'P17400I000Y01619',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.9.75_b0061_Mar 24 2020'},
                                 {       'interfaces': [       {       'in_octets': '3760717386',
                                                                       'in_ucast_pkts': '132910101',
                                                                       'links': [       {       'in_octets': '3760717386',
                                                                                                'in_ucast_pkts': '132910101',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '2651298925',
                                                                                                'out_ucast_pkts': '62345151'}],
                                                                       'mac_address': '00:15:67:fe:90:cc',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2651298925',
                                                                       'out_ucast_pkts': '62345151',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '121333333',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '121333333',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '34666666',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '34666666'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2651298925',
                                                                       'in_ucast_pkts': '62345151',
                                                                       'mac_address': '00:15:67:fe:90:cb',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3760717386',
                                                                       'out_ucast_pkts': '132910101',
                                                                       'poller_hash': 'MDAxNTY3ZmU5MGNjTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.222.1.119',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Ashlee Keim',
                                         'poller_hash': 'ABVn/pDM',
                                         'serial_number': 'P17400I000R01925',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '395722288',
                                                                       'in_ucast_pkts': '20439890',
                                                                       'links': [       {       'in_octets': '395722288',
                                                                                                'in_ucast_pkts': '20439890',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '1561981850',
                                                                                                'out_ucast_pkts': '8721228'}],
                                                                       'mac_address': '00:15:67:fe:8f:d3',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1561981850',
                                                                       'out_ucast_pkts': '8721228',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '126000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 750,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -70.0,
                                                                                                                                                     'rx_link_rate': '126000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '54000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '54000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1561981850',
                                                                       'in_ucast_pkts': '8721228',
                                                                       'mac_address': '00:15:67:fe:8f:d2',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '395722288',
                                                                       'out_ucast_pkts': '20439890',
                                                                       'poller_hash': 'MDAxNTY3ZmU4ZmQzTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.222.1.108',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Russell Baker',
                                         'poller_hash': 'ABVn/o/T',
                                         'serial_number': 'P17400I000X01974',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.9.75_b0061_Mar 24 2020'},
                                 {       'interfaces': [       {       'in_octets': '3430565183',
                                                                       'in_ucast_pkts': '21995585',
                                                                       'links': [       {       'in_octets': '3430565183',
                                                                                                'in_ucast_pkts': '21995585',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '273211527',
                                                                                                'out_ucast_pkts': '12311052'}],
                                                                       'mac_address': '00:15:67:fe:93:1d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '273211527',
                                                                       'out_ucast_pkts': '12311052',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '126000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 600,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '126000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '54000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '54000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '273211527',
                                                                       'in_ucast_pkts': '12311052',
                                                                       'mac_address': '00:15:67:fe:93:1c',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '3430565183',
                                                                       'out_ucast_pkts': '21995585',
                                                                       'poller_hash': 'MDAxNTY3ZmU5MzFkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.222.1.107',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Gibbons',
                                         'poller_hash': 'ABVn/pMd',
                                         'serial_number': 'P17400I000R01910',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.9.75_b0061_Mar 24 2020'},
                                 {       'interfaces': [       {       'in_octets': '2068039072',
                                                                       'in_ucast_pkts': '194343917',
                                                                       'links': [       {       'in_octets': '2068039072',
                                                                                                'in_ucast_pkts': '194343917',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '2476358287',
                                                                                                'out_ucast_pkts': '127018839'}],
                                                                       'mac_address': '00:15:67:f0:74:67',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2476358287',
                                                                       'out_ucast_pkts': '127018839',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '60666666',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 150,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '60666666',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '15600000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '15600000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2476358287',
                                                                       'in_ucast_pkts': '127018839',
                                                                       'mac_address': '00:15:67:f0:74:66',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '2068039072',
                                                                       'out_ucast_pkts': '194343917',
                                                                       'poller_hash': 'MDAxNTY3ZjA3NDY3TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.222.1.106',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Jeff Davis',
                                         'poller_hash': 'ABVn8HRn',
                                         'serial_number': 'P15000I000E04421',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.1.10_b0020_May 21 2021'},
                                 {       'interfaces': [       {       'in_octets': '1655939836',
                                                                       'in_ucast_pkts': '130629053',
                                                                       'links': [       {       'in_octets': '1655939836',
                                                                                                'in_ucast_pkts': '130629053',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '1893078917',
                                                                                                'out_ucast_pkts': '55219975'}],
                                                                       'mac_address': '00:15:67:f0:74:55',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1893078917',
                                                                       'out_ucast_pkts': '55219975',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '126000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 150,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '126000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1893078917',
                                                                       'in_ucast_pkts': '55219975',
                                                                       'mac_address': '00:15:67:f0:74:54',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '1655939836',
                                                                       'out_ucast_pkts': '130629053',
                                                                       'poller_hash': 'MDAxNTY3ZjA3NDU1TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.222.1.109',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Tracy',
                                         'poller_hash': 'ABVn8HRV',
                                         'serial_number': 'P15000I000W06018',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.9.75_b0061_Mar 24 2020'},
                                 {       'interfaces': [       {       'in_octets': '348523209',
                                                                       'in_ucast_pkts': '961113546',
                                                                       'links': [       {       'in_octets': '348523209',
                                                                                                'in_ucast_pkts': '961113546',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '1259674475',
                                                                                                'out_ucast_pkts': '493244061'}],
                                                                       'mac_address': '00:15:67:f0:75:72',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1259674475',
                                                                       'out_ucast_pkts': '493244061',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '168000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 150,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '168000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1259674475',
                                                                       'in_ucast_pkts': '493244061',
                                                                       'mac_address': '00:15:67:f0:75:71',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '348523209',
                                                                       'out_ucast_pkts': '961113546',
                                                                       'poller_hash': 'MDAxNTY3ZjA3NTcyTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '100000000'}],
                                         'management_ip': '10.222.1.110',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Pam Suppon',
                                         'poller_hash': 'ABVn8HVy',
                                         'serial_number': 'P15000I000W06009',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '4.9.75_b0061_Mar 24 2020'},
                                 {       'interfaces': [       {       'in_octets': '2823213805',
                                                                       'in_ucast_pkts': '675756760',
                                                                       'links': [       {       'in_octets': '2823213805',
                                                                                                'in_ucast_pkts': '675756760',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '680952592',
                                                                                                'out_ucast_pkts': '320256340'}],
                                                                       'mac_address': '00:15:67:fe:99:04',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '680952592',
                                                                       'out_ucast_pkts': '320256340',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '121333333',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 150,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '121333333',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'tx_link_rate': '23400000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '23400000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '680952592',
                                                                       'in_ucast_pkts': '320256340',
                                                                       'mac_address': '00:15:67:fe:99:03',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '2823213805',
                                                                       'out_ucast_pkts': '675756760',
                                                                       'poller_hash': 'MDAxNTY3ZmU5OTA0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.222.1.104',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Joe Ryan',
                                         'poller_hash': 'ABVn/pkE',
                                         'serial_number': 'P17400I000900160',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.1.10_b0020_May 21 2021'},
                                 {       'interfaces': [       {       'in_octets': '3436678312',
                                                                       'in_ucast_pkts': '851052444',
                                                                       'links': [       {       'in_octets': '3436678312',
                                                                                                'in_ucast_pkts': '851052444',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '711321886',
                                                                                                'out_ucast_pkts': '550396176'}],
                                                                       'mac_address': '00:15:67:fd:ec:70',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '711321886',
                                                                       'out_ucast_pkts': '550396176',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '80888888',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 3600,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '80888888',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '15600000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '15600000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '711321886',
                                                                       'in_ucast_pkts': '550396176',
                                                                       'mac_address': '00:15:67:fd:ec:6f',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '3436678312',
                                                                       'out_ucast_pkts': '851052444',
                                                                       'poller_hash': 'MDAxNTY3ZmRlYzcwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.222.1.111',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Perry Thompson',
                                         'poller_hash': 'ABVn/exw',
                                         'serial_number': 'P17400I000900165',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.1.10_b0020_May 21 2021'},
                                 {       'interfaces': [       {       'in_octets': '2241242353',
                                                                       'in_ucast_pkts': '12772603',
                                                                       'links': [       {       'in_octets': '2241242353',
                                                                                                'in_ucast_pkts': '12772603',
                                                                                                'mac_address': '00:15:67:ed:06:ad',
                                                                                                'out_octets': '1224499388',
                                                                                                'out_ucast_pkts': '4419724'}],
                                                                       'mac_address': '00:15:67:fe:97:49',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1224499388',
                                                                       'out_ucast_pkts': '4419724',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 70,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5225,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '84000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 9000,
                                                                                                                                                     'mac_address': '00:15:67:ed:06:ad',
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '84000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '32400000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '32400000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AG01AGChoice '
                                                                                                          'E'}]},
                                                               {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1224499388',
                                                                       'in_ucast_pkts': '4419724',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'oper_up': True,
                                                                       'out_octets': '2241242353',
                                                                       'out_ucast_pkts': '12772603',
                                                                       'poller_hash': 'MDAxNTY3ZmU5NzQ5TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ==',
                                                                       'speed': '1000000000'}],
                                         'management_ip': '10.222.1.112',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5H00-0A58',
                                         'name': 'Jason Gilliland',
                                         'poller_hash': 'ABVn/pdJ',
                                         'serial_number': 'P17400I000900142',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '5.1.10_b0020_May 21 2021'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_radwin_winlink_RW_5B00_0630_00_4_9_76_b0019_Oct_22_2020_01(self):
        obj = self.run_data("radwin.winlink.RW-5B00-0630-00.4.9.76_b0019_Oct 22 2020.01")
        exp_info = {
                'model': 'RW-5B00-0630-00',
                'rf_chan_width': 20,
                'rf_freq': 3320,
                'sta_count': 1,
                'sw_version': '4.9.76_b0019_Oct 22 2020',
                'vendor': 'Radwin'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:15:67:5e:9f:63': {       'alt_macs': {'00:15:67:e4:db:4d'},
                                             'dev_macs': {'ac:9e:17:67:76:bc'},
                                             'dl_rssi': -85.0,
                                             'ip_address': '192.168.40.28',
                                             'mac_address': '00:15:67:5e:9f:63',
                                             'name': 'William Baranick - 0221-6653',
                                             'ul_rssi': -85.0}
        }
        exp_ne_msg = {
                'data': {       'elevation': 215.7,
                                'gps_sats_tracked': 3,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2691812610',
                                                              'in_octets': '3598882950',
                                                              'in_ucast_pkts': '1784094195',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:15:67:65:52:e4',
                                                              'mtu': 2047,
                                                              'name': 'Management Port '
                                                                      'on Odu',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '9582619',
                                                              'out_octets': '140928175',
                                                              'out_ucast_pkts': '804867094',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'in_octets': '142180554',
                                                              'in_ucast_pkts': '814459415',
                                                              'links': [       {       'bridged_mac_addresses': [       'ac:9e:17:67:76:bc'],
                                                                                       'in_octets': '209727344',
                                                                                       'in_ucast_pkts': '1811170',
                                                                                       'mac_address': '00:15:67:5e:9f:63',
                                                                                       'out_octets': '56145543',
                                                                                       'out_ucast_pkts': '3938067'}],
                                                              'mac_address': '00:15:67:df:2f:38',
                                                              'name': 'Radio Interface',
                                                              'out_octets': '3603325239',
                                                              'out_ucast_pkts': '180989905',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 65,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:15:67:5e:9f:63',
                                                                                                                                            'rssi': -85.0,
                                                                                                                                            'rx_link_rate': '13650000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '14083332',
                                                                                                                                            'tx_mcs': 2}]}],
                                                                                        'tx_power': 23}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'site403_pmp201'}]}],
                                'latitude': 43.153131,
                                'longitude': -79.428183,
                                'manufacturer': 'Radwin',
                                'model': 'RW-5B00-0630-00',
                                'poller_hash': 'ABVn3y84',
                                'serial_number': 'C12240I000D00216',
                                'sw_version': '4.9.76_b0019_Oct 22 2020',
                                'system_mac_address': '00:15:67:65:52:e4',
                                'temperature': 20.0,
                                'uptime': '35443623'},
                'peers': [       {       'interfaces': [       {       'in_octets': '56145543',
                                                                       'in_ucast_pkts': '3938067',
                                                                       'links': [       {       'in_octets': '56145543',
                                                                                                'in_ucast_pkts': '3938067',
                                                                                                'mac_address': '00:15:67:df:2f:38',
                                                                                                'out_octets': '209727344',
                                                                                                'out_ucast_pkts': '1811170'}],
                                                                       'mac_address': '00:15:67:5e:9f:63',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '209727344',
                                                                       'out_ucast_pkts': '1811170',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 65,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3320,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '14083332',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:df:2f:38',
                                                                                                                                                     'rssi': -85.0,
                                                                                                                                                     'rx_link_rate': '14083332',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '13650000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '13650000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'site403_pmp201'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '209727344',
                                                                       'in_ucast_pkts': '1811170',
                                                                       'mac_address': '00:15:67:e4:db:4d',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '56145543',
                                                                       'out_ucast_pkts': '3938067',
                                                                       'poller_hash': 'MDAxNTY3NWU5ZjYzTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 44.15013,
                                         'longitude': -79.34974,
                                         'management_ip': '192.168.40.28',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0130',
                                         'name': 'William Baranick - 0221-6653',
                                         'poller_hash': 'ABVnXp9j',
                                         'serial_number': 'P08570I100A00394',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_radwin_winlink_RW_5BG5_0649_4_9_70_01(self):
        obj = self.run_data("radwin.winlink.RW-5BG5-0649.4.9.70.01")
        exp_info = {
                'model': 'RW-5BG5-0649',
                'rf_chan_width': 40,
                'rf_freq': 5780,
                'sta_count': 47,
                'sw_version': '4.9.70_b0015_May  2 2019',
                'vendor': 'Radwin'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:15:67:00:18:d0': {       'alt_macs': set(),
                                             'dev_macs': {'44:65:7f:42:1b:c6'},
                                             'dl_rssi': -77.0,
                                             'ip_address': '10.101.4.21',
                                             'mac_address': '00:15:67:00:18:d0',
                                             'name': 'Dillon Suto',
                                             'ul_rssi': -80.0},
                '00:15:67:00:42:ea': {       'alt_macs': set(),
                                             'dev_macs': {'6c:b0:ce:a0:09:f6'},
                                             'dl_rssi': -72.0,
                                             'ip_address': '10.101.4.52',
                                             'mac_address': '00:15:67:00:42:ea',
                                             'name': 'Rich Goodrich',
                                             'ul_rssi': -79.0},
                '00:15:67:00:ad:37': {       'alt_macs': set(),
                                             'dev_macs': {'4c:60:de:e6:40:21'},
                                             'dl_rssi': -78.0,
                                             'ip_address': '10.101.4.24',
                                             'mac_address': '00:15:67:00:ad:37',
                                             'name': 'Dennis Frazee',
                                             'ul_rssi': -81.0},
                '00:15:67:62:99:99': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -71.0,
                                             'ip_address': '10.101.4.57',
                                             'mac_address': '00:15:67:62:99:99',
                                             'name': 'John Guess',
                                             'ul_rssi': -79.0},
                '00:15:67:62:c0:ae': {       'alt_macs': set(),
                                             'dev_macs': {'c0:56:27:29:57:e4'},
                                             'dl_rssi': -76.0,
                                             'ip_address': '10.101.4.17',
                                             'mac_address': '00:15:67:62:c0:ae',
                                             'name': 'Walter Flye',
                                             'ul_rssi': -81.0},
                '00:15:67:62:c1:27': {       'alt_macs': set(),
                                             'dev_macs': {'00:1c:10:15:bd:f7'},
                                             'dl_rssi': -78.0,
                                             'ip_address': '10.101.4.34',
                                             'mac_address': '00:15:67:62:c1:27',
                                             'name': 'Bill Seamans',
                                             'ul_rssi': -81.0},
                '00:15:67:62:c1:c4': {       'alt_macs': set(),
                                             'dev_macs': {'b0:7f:b9:91:49:e7'},
                                             'dl_rssi': -73.0,
                                             'ip_address': '10.101.4.2',
                                             'mac_address': '00:15:67:62:c1:c4',
                                             'name': 'Linda Tomky',
                                             'ul_rssi': -78.0},
                '00:15:67:62:ec:4c': {       'alt_macs': set(),
                                             'dev_macs': {'b4:75:0e:b7:17:d3'},
                                             'dl_rssi': -69.0,
                                             'ip_address': '10.101.4.11',
                                             'mac_address': '00:15:67:62:ec:4c',
                                             'name': 'Natalie Ridgwell',
                                             'ul_rssi': -75.0},
                '00:15:67:63:27:2d': {       'alt_macs': set(),
                                             'dev_macs': {'c0:56:27:26:ae:83'},
                                             'dl_rssi': -74.0,
                                             'ip_address': '10.101.4.30',
                                             'mac_address': '00:15:67:63:27:2d',
                                             'name': 'Shelby Jackson',
                                             'ul_rssi': -80.0},
                '00:15:67:63:27:c0': {       'alt_macs': set(),
                                             'dev_macs': {'44:65:7f:b2:1c:a0'},
                                             'dl_rssi': -60.0,
                                             'ip_address': '10.101.4.60',
                                             'mac_address': '00:15:67:63:27:c0',
                                             'name': 'Amanda Mueller',
                                             'ul_rssi': -66.0},
                '00:15:67:63:81:56': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -71.0,
                                             'ip_address': '10.101.4.6',
                                             'mac_address': '00:15:67:63:81:56',
                                             'name': 'South Swink Water',
                                             'ul_rssi': -77.0},
                '00:15:67:67:7f:8e': {       'alt_macs': set(),
                                             'dev_macs': {'94:10:3e:e0:c9:01'},
                                             'dl_rssi': -76.0,
                                             'ip_address': '10.101.4.8',
                                             'mac_address': '00:15:67:67:7f:8e',
                                             'name': 'Jessica Duran',
                                             'ul_rssi': -77.0},
                '00:15:67:67:a2:ba': {       'alt_macs': set(),
                                             'dev_macs': {'b0:7f:b9:4b:f1:2d'},
                                             'dl_rssi': -69.0,
                                             'ip_address': '10.101.4.19',
                                             'mac_address': '00:15:67:67:a2:ba',
                                             'name': 'Charles Nafziger',
                                             'ul_rssi': -72.0},
                '00:15:67:67:a3:53': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -74.0,
                                             'ip_address': '10.101.4.3',
                                             'mac_address': '00:15:67:67:a3:53',
                                             'name': 'Don Hunter',
                                             'ul_rssi': -79.0},
                '00:15:67:67:a3:5f': {       'alt_macs': set(),
                                             'dev_macs': {'c4:04:15:0e:ee:08'},
                                             'dl_rssi': -52.0,
                                             'ip_address': '10.101.4.43',
                                             'mac_address': '00:15:67:67:a3:5f',
                                             'name': 'Jerry Henderson',
                                             'ul_rssi': -63.0},
                '00:15:67:67:a3:77': {       'alt_macs': set(),
                                             'dev_macs': {'9c:3d:cf:e4:6b:e7'},
                                             'dl_rssi': -74.0,
                                             'ip_address': '10.101.4.29',
                                             'mac_address': '00:15:67:67:a3:77',
                                             'name': 'Junior Miller',
                                             'ul_rssi': -77.0},
                '00:15:67:67:a8:44': {       'alt_macs': set(),
                                             'dev_macs': {'94:10:3e:96:91:c4'},
                                             'dl_rssi': -66.0,
                                             'ip_address': '10.101.4.47',
                                             'mac_address': '00:15:67:67:a8:44',
                                             'name': 'Donna Wren',
                                             'ul_rssi': -77.0},
                '00:15:67:67:a8:d5': {       'alt_macs': set(),
                                             'dev_macs': {'6c:b0:ce:e9:04:db'},
                                             'dl_rssi': -65.0,
                                             'ip_address': '10.101.4.15',
                                             'mac_address': '00:15:67:67:a8:d5',
                                             'name': 'Edward Mayhoffer',
                                             'ul_rssi': -68.0},
                '00:15:67:67:ab:17': {       'alt_macs': set(),
                                             'dev_macs': {'24:a4:3c:4b:83:d7'},
                                             'dl_rssi': -74.0,
                                             'ip_address': '10.101.4.44',
                                             'mac_address': '00:15:67:67:ab:17',
                                             'name': 'Michael Mayhoffer',
                                             'ul_rssi': -75.0},
                '00:15:67:67:fd:30': {       'alt_macs': set(),
                                             'dev_macs': {       '00:59:dc:ba:f5:24',
                                                                 '58:6d:8f:bb:29:2c'},
                                             'dl_rssi': -65.0,
                                             'ip_address': '10.101.4.4',
                                             'mac_address': '00:15:67:67:fd:30',
                                             'name': 'Telly Stanger',
                                             'ul_rssi': -67.0},
                '00:15:67:67:fd:35': {       'alt_macs': set(),
                                             'dev_macs': {'98:de:d0:31:31:97'},
                                             'dl_rssi': -71.0,
                                             'ip_address': '10.101.4.9',
                                             'mac_address': '00:15:67:67:fd:35',
                                             'name': 'Chelsey Grover',
                                             'ul_rssi': -72.0},
                '00:15:67:67:fd:9c': {       'alt_macs': set(),
                                             'dev_macs': {'14:91:82:11:94:fd'},
                                             'dl_rssi': -81.0,
                                             'ip_address': '10.101.4.20',
                                             'mac_address': '00:15:67:67:fd:9c',
                                             'name': 'Glori Hubler-Hand',
                                             'ul_rssi': -84.0},
                '00:15:67:67:ff:0e': {       'alt_macs': set(),
                                             'dev_macs': {'9c:3d:cf:c2:c0:69'},
                                             'dl_rssi': -71.0,
                                             'ip_address': '10.101.4.27',
                                             'mac_address': '00:15:67:67:ff:0e',
                                             'name': 'Tesslynn Jackson',
                                             'ul_rssi': -77.0},
                '00:15:67:67:ff:6e': {       'alt_macs': set(),
                                             'dev_macs': {'ec:4f:82:29:69:5f'},
                                             'dl_rssi': -69.0,
                                             'ip_address': '10.101.4.39',
                                             'mac_address': '00:15:67:67:ff:6e',
                                             'name': 'DJ & Michelle Jones',
                                             'ul_rssi': -72.0},
                '00:15:67:80:3e:40': {       'alt_macs': set(),
                                             'dev_macs': {'a0:63:91:e4:e4:4f'},
                                             'dl_rssi': -59.0,
                                             'ip_address': '10.101.4.51',
                                             'mac_address': '00:15:67:80:3e:40',
                                             'name': 'Chris Votruba',
                                             'ul_rssi': -66.0},
                '00:15:67:80:bb:8f': {       'alt_macs': set(),
                                             'dev_macs': {'44:65:7f:42:1a:3a'},
                                             'dl_rssi': -72.0,
                                             'ip_address': '10.101.4.62',
                                             'mac_address': '00:15:67:80:bb:8f',
                                             'name': 'Frederick Johnson',
                                             'ul_rssi': -79.0},
                '00:15:67:e2:d7:54': {       'alt_macs': set(),
                                             'dev_macs': {'2c:30:33:ed:5b:08'},
                                             'dl_rssi': -63.0,
                                             'ip_address': '10.101.4.10',
                                             'mac_address': '00:15:67:e2:d7:54',
                                             'name': 'Jerry Martinez',
                                             'ul_rssi': -68.0},
                '00:15:67:e3:ae:85': {       'alt_macs': set(),
                                             'dev_macs': {'8c:3b:ad:d6:bf:2d'},
                                             'dl_rssi': -72.0,
                                             'ip_address': '10.101.4.102',
                                             'mac_address': '00:15:67:e3:ae:85',
                                             'name': 'Vicki Meis',
                                             'ul_rssi': -78.0},
                '00:15:67:e7:77:84': {       'alt_macs': set(),
                                             'dev_macs': {'24:f5:a2:14:8d:c5'},
                                             'dl_rssi': -77.0,
                                             'ip_address': '10.101.4.45',
                                             'mac_address': '00:15:67:e7:77:84',
                                             'name': 'Randy Jones',
                                             'ul_rssi': -79.0},
                '00:15:67:e7:c0:f0': {       'alt_macs': set(),
                                             'dev_macs': {'0c:9d:92:55:b3:b8'},
                                             'dl_rssi': -80.0,
                                             'ip_address': '10.101.4.25',
                                             'mac_address': '00:15:67:e7:c0:f0',
                                             'name': 'Ty Herman',
                                             'ul_rssi': -84.0},
                '00:15:67:e7:c3:c9': {       'alt_macs': set(),
                                             'dev_macs': {'c0:25:e9:ff:10:0f'},
                                             'dl_rssi': -81.0,
                                             'ip_address': '10.101.4.53',
                                             'mac_address': '00:15:67:e7:c3:c9',
                                             'name': 'GARY PEARSON',
                                             'ul_rssi': -81.0},
                '00:15:67:e7:c4:3b': {       'alt_macs': set(),
                                             'dev_macs': {'0c:80:63:4c:a3:55'},
                                             'dl_rssi': -65.0,
                                             'ip_address': '10.101.4.14',
                                             'mac_address': '00:15:67:e7:c4:3b',
                                             'name': 'Timothy Alvarez',
                                             'ul_rssi': -73.0},
                '00:15:67:e7:c7:0c': {       'alt_macs': set(),
                                             'dev_macs': {'24:a4:3c:4b:83:11'},
                                             'dl_rssi': -58.0,
                                             'ip_address': '10.101.4.48',
                                             'mac_address': '00:15:67:e7:c7:0c',
                                             'name': 'Mayhoffer Farms Shop',
                                             'ul_rssi': -65.0},
                '00:15:67:e7:d4:1a': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -75.0,
                                             'ip_address': '10.101.4.13',
                                             'mac_address': '00:15:67:e7:d4:1a',
                                             'name': 'Keo Honey',
                                             'ul_rssi': -79.0},
                '00:15:67:e7:d5:62': {       'alt_macs': set(),
                                             'dev_macs': {'94:10:3e:00:27:69'},
                                             'dl_rssi': -53.0,
                                             'ip_address': '10.101.4.42',
                                             'mac_address': '00:15:67:e7:d5:62',
                                             'name': 'Terry Mills',
                                             'ul_rssi': -60.0},
                '00:15:67:e7:d6:36': {       'alt_macs': set(),
                                             'dev_macs': {'18:d6:c7:44:9d:1d'},
                                             'dl_rssi': -74.0,
                                             'ip_address': '10.101.4.32',
                                             'mac_address': '00:15:67:e7:d6:36',
                                             'name': 'Mayhoffer Farms Office',
                                             'ul_rssi': -75.0},
                '00:15:67:e7:d6:52': {       'alt_macs': set(),
                                             'dev_macs': {'84:c9:b2:68:7a:a7'},
                                             'dl_rssi': -65.0,
                                             'ip_address': '10.101.4.26',
                                             'mac_address': '00:15:67:e7:d6:52',
                                             'name': 'Carolyn Thomas',
                                             'ul_rssi': -70.0},
                '00:15:67:e7:d7:04': {       'alt_macs': set(),
                                             'dev_macs': {'94:10:3e:f9:76:61'},
                                             'dl_rssi': -73.0,
                                             'ip_address': '10.101.4.41',
                                             'mac_address': '00:15:67:e7:d7:04',
                                             'name': 'Dave Kaess',
                                             'ul_rssi': -79.0},
                '00:15:67:e7:f8:74': {       'alt_macs': set(),
                                             'dev_macs': {'c4:e9:84:6d:07:5d'},
                                             'dl_rssi': -77.0,
                                             'ip_address': '10.101.4.36',
                                             'mac_address': '00:15:67:e7:f8:74',
                                             'name': 'Josh Proctor',
                                             'ul_rssi': -80.0},
                '00:15:67:f6:2b:01': {       'alt_macs': set(),
                                             'dev_macs': None,
                                             'dl_rssi': -75.0,
                                             'ip_address': '10.101.4.22',
                                             'mac_address': '00:15:67:f6:2b:01',
                                             'name': 'Harold Vance',
                                             'ul_rssi': -80.0},
                '00:15:67:f6:b0:b1': {       'alt_macs': set(),
                                             'dev_macs': {'08:86:3b:9c:2e:f5'},
                                             'dl_rssi': -75.0,
                                             'ip_address': '10.101.4.16',
                                             'mac_address': '00:15:67:f6:b0:b1',
                                             'name': 'John and Valerie Campbell',
                                             'ul_rssi': -81.0},
                '00:15:67:f6:bb:96': {       'alt_macs': set(),
                                             'dev_macs': {'00:21:9b:2c:a5:f3'},
                                             'dl_rssi': -78.0,
                                             'ip_address': '10.101.4.61',
                                             'mac_address': '00:15:67:f6:bb:96',
                                             'name': 'Mayrene Pennington',
                                             'ul_rssi': -82.0},
                '00:15:67:f7:99:c4': {       'alt_macs': set(),
                                             'dev_macs': {'94:10:3e:f8:e6:76'},
                                             'dl_rssi': -79.0,
                                             'ip_address': '10.101.4.63',
                                             'mac_address': '00:15:67:f7:99:c4',
                                             'name': 'Dennis Carroll',
                                             'ul_rssi': -80.0},
                '00:15:67:f7:bf:b1': {       'alt_macs': set(),
                                             'dev_macs': {'44:65:7f:73:1a:48'},
                                             'dl_rssi': -72.0,
                                             'ip_address': '10.101.4.31',
                                             'mac_address': '00:15:67:f7:bf:b1',
                                             'name': 'Diamond A Farms',
                                             'ul_rssi': -78.0},
                '00:15:67:f7:bf:ba': {       'alt_macs': set(),
                                             'dev_macs': {'98:fc:11:4b:bb:a5'},
                                             'dl_rssi': -73.0,
                                             'ip_address': '10.101.4.28',
                                             'mac_address': '00:15:67:f7:bf:ba',
                                             'name': 'Derek Carroll',
                                             'ul_rssi': -83.0},
                '00:15:67:f7:bf:de': {       'alt_macs': set(),
                                             'dev_macs': {'44:65:7f:88:81:ca'},
                                             'dl_rssi': -66.0,
                                             'ip_address': '10.101.4.54',
                                             'mac_address': '00:15:67:f7:bf:de',
                                             'name': 'TLM Constructors',
                                             'ul_rssi': -69.0},
                '00:15:67:f7:bf:f6': {       'alt_macs': set(),
                                             'dev_macs': {'48:f8:b3:4a:fd:cc'},
                                             'dl_rssi': -69.0,
                                             'ip_address': '10.101.4.38',
                                             'mac_address': '00:15:67:f7:bf:f6',
                                             'name': 'Karney Kattle Kompany',
                                             'ul_rssi': -74.0}
        }
        exp_ne_msg = {
                'data': {       'elevation': 1344.9,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '108751',
                                                              'in_octets': '3116367717',
                                                              'in_ucast_pkts': '669359046',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:15:67:e0:51:bf',
                                                              'mtu': 2047,
                                                              'name': 'Management Port '
                                                                      'on Odu',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '408068',
                                                              'out_octets': '3318738266',
                                                              'out_ucast_pkts': '351463971',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'in_octets': '3319488434',
                                                              'in_ucast_pkts': '351874692',
                                                              'links': [       {       'bridged_mac_addresses': [       '24:f5:a2:14:8d:c5'],
                                                                                       'in_octets': '276666244',
                                                                                       'in_ucast_pkts': '2238302',
                                                                                       'mac_address': '00:15:67:e7:77:84',
                                                                                       'out_octets': '815025407',
                                                                                       'out_ucast_pkts': '4623067'},
                                                                               {       'bridged_mac_addresses': [       '6c:b0:ce:e9:04:db'],
                                                                                       'in_octets': '733553453',
                                                                                       'in_ucast_pkts': '10398628',
                                                                                       'mac_address': '00:15:67:67:a8:d5',
                                                                                       'out_octets': '478913698',
                                                                                       'out_ucast_pkts': '18075238'},
                                                                               {       'bridged_mac_addresses': [       '94:10:3e:e0:c9:01'],
                                                                                       'in_octets': '2344939905',
                                                                                       'in_ucast_pkts': '26671562',
                                                                                       'mac_address': '00:15:67:67:7f:8e',
                                                                                       'out_octets': '375174425',
                                                                                       'out_ucast_pkts': '41158032'},
                                                                               {       'bridged_mac_addresses': [       '94:10:3e:96:91:c4'],
                                                                                       'in_octets': '1691143887',
                                                                                       'in_ucast_pkts': '16185789',
                                                                                       'mac_address': '00:15:67:67:a8:44',
                                                                                       'out_octets': '2474872777',
                                                                                       'out_ucast_pkts': '23861752'},
                                                                               {       'in_octets': '0',
                                                                                       'in_ucast_pkts': '0',
                                                                                       'mac_address': '00:15:67:67:a3:53',
                                                                                       'out_octets': '0',
                                                                                       'out_ucast_pkts': '0'},
                                                                               {       'bridged_mac_addresses': [       'b0:7f:b9:4b:f1:2d'],
                                                                                       'in_octets': '405116948',
                                                                                       'in_ucast_pkts': '1692891',
                                                                                       'mac_address': '00:15:67:67:a2:ba',
                                                                                       'out_octets': '3909103124',
                                                                                       'out_ucast_pkts': '3444096'},
                                                                               {       'bridged_mac_addresses': [       'b4:75:0e:b7:17:d3'],
                                                                                       'in_octets': '1727714231',
                                                                                       'in_ucast_pkts': '19640053',
                                                                                       'mac_address': '00:15:67:62:ec:4c',
                                                                                       'out_octets': '3835787424',
                                                                                       'out_ucast_pkts': '43495212'},
                                                                               {       'in_octets': '50168651',
                                                                                       'in_ucast_pkts': '282874',
                                                                                       'mac_address': '00:15:67:f6:2b:01',
                                                                                       'out_octets': '550650828',
                                                                                       'out_ucast_pkts': '1236411'},
                                                                               {       'bridged_mac_addresses': [       '0c:80:63:4c:a3:55'],
                                                                                       'in_octets': '3343725371',
                                                                                       'in_ucast_pkts': '19919264',
                                                                                       'mac_address': '00:15:67:e7:c4:3b',
                                                                                       'out_octets': '300117543',
                                                                                       'out_ucast_pkts': '40773375'},
                                                                               {       'bridged_mac_addresses': [       'a0:63:91:e4:e4:4f'],
                                                                                       'in_octets': '1472369170',
                                                                                       'in_ucast_pkts': '15807517',
                                                                                       'mac_address': '00:15:67:80:3e:40',
                                                                                       'out_octets': '1612274052',
                                                                                       'out_ucast_pkts': '31733403'},
                                                                               {       'bridged_mac_addresses': [       'c4:e9:84:6d:07:5d'],
                                                                                       'in_octets': '1097563589',
                                                                                       'in_ucast_pkts': '4975897',
                                                                                       'mac_address': '00:15:67:e7:f8:74',
                                                                                       'out_octets': '2444060243',
                                                                                       'out_ucast_pkts': '8492731'},
                                                                               {       'in_octets': '117108516',
                                                                                       'in_ucast_pkts': '373705',
                                                                                       'mac_address': '00:15:67:63:81:56',
                                                                                       'out_octets': '621546391',
                                                                                       'out_ucast_pkts': '1624950'},
                                                                               {       'bridged_mac_addresses': [       '8c:3b:ad:d6:bf:2d'],
                                                                                       'in_octets': '1368530660',
                                                                                       'in_ucast_pkts': '41180167',
                                                                                       'mac_address': '00:15:67:e3:ae:85',
                                                                                       'out_octets': '1800127301',
                                                                                       'out_ucast_pkts': '85363465'},
                                                                               {       'bridged_mac_addresses': [       '9c:3d:cf:c2:c0:69'],
                                                                                       'in_octets': '650740056',
                                                                                       'in_ucast_pkts': '5204995',
                                                                                       'mac_address': '00:15:67:67:ff:0e',
                                                                                       'out_octets': '546046418',
                                                                                       'out_ucast_pkts': '16550061'},
                                                                               {       'bridged_mac_addresses': [       '14:91:82:11:94:fd'],
                                                                                       'in_octets': '4221199821',
                                                                                       'in_ucast_pkts': '43927484',
                                                                                       'mac_address': '00:15:67:67:fd:9c',
                                                                                       'out_octets': '710883954',
                                                                                       'out_ucast_pkts': '76193328'},
                                                                               {       'bridged_mac_addresses': [       '00:59:dc:ba:f5:24',
                                                                                                                        '58:6d:8f:bb:29:2c'],
                                                                                       'in_octets': '1181382298',
                                                                                       'in_ucast_pkts': '9667279',
                                                                                       'mac_address': '00:15:67:67:fd:30',
                                                                                       'out_octets': '3015157931',
                                                                                       'out_ucast_pkts': '26164151'},
                                                                               {       'bridged_mac_addresses': [       'ec:4f:82:29:69:5f'],
                                                                                       'in_octets': '4057777885',
                                                                                       'in_ucast_pkts': '31765430',
                                                                                       'mac_address': '00:15:67:67:ff:6e',
                                                                                       'out_octets': '3554951599',
                                                                                       'out_ucast_pkts': '61818991'},
                                                                               {       'bridged_mac_addresses': [       '98:de:d0:31:31:97'],
                                                                                       'in_octets': '2549541446',
                                                                                       'in_ucast_pkts': '22275390',
                                                                                       'mac_address': '00:15:67:67:fd:35',
                                                                                       'out_octets': '752093769',
                                                                                       'out_ucast_pkts': '52577085'},
                                                                               {       'bridged_mac_addresses': [       '98:fc:11:4b:bb:a5'],
                                                                                       'in_octets': '369429191',
                                                                                       'in_ucast_pkts': '20787608',
                                                                                       'mac_address': '00:15:67:f7:bf:ba',
                                                                                       'out_octets': '1823659507',
                                                                                       'out_ucast_pkts': '34011961'},
                                                                               {       'bridged_mac_addresses': [       '94:10:3e:00:27:69'],
                                                                                       'in_octets': '377047662',
                                                                                       'in_ucast_pkts': '1741101',
                                                                                       'mac_address': '00:15:67:e7:d5:62',
                                                                                       'out_octets': '2951287162',
                                                                                       'out_ucast_pkts': '5819007'},
                                                                               {       'bridged_mac_addresses': [       '44:65:7f:42:1a:3a'],
                                                                                       'in_octets': '1819142124',
                                                                                       'in_ucast_pkts': '6525849',
                                                                                       'mac_address': '00:15:67:80:bb:8f',
                                                                                       'out_octets': '3146173699',
                                                                                       'out_ucast_pkts': '12573857'},
                                                                               {       'bridged_mac_addresses': [       '24:a4:3c:4b:83:11'],
                                                                                       'in_octets': '92814333',
                                                                                       'in_ucast_pkts': '673699',
                                                                                       'mac_address': '00:15:67:e7:c7:0c',
                                                                                       'out_octets': '1839272701',
                                                                                       'out_ucast_pkts': '2463032'},
                                                                               {       'bridged_mac_addresses': [       '00:21:9b:2c:a5:f3'],
                                                                                       'in_octets': '606928454',
                                                                                       'in_ucast_pkts': '2780560',
                                                                                       'mac_address': '00:15:67:f6:bb:96',
                                                                                       'out_octets': '3355837768',
                                                                                       'out_ucast_pkts': '3129235'},
                                                                               {       'bridged_mac_addresses': [       '08:86:3b:9c:2e:f5'],
                                                                                       'in_octets': '819443579',
                                                                                       'in_ucast_pkts': '5376167',
                                                                                       'mac_address': '00:15:67:f6:b0:b1',
                                                                                       'out_octets': '193980673',
                                                                                       'out_ucast_pkts': '8135186'},
                                                                               {       'bridged_mac_addresses': [       '18:d6:c7:44:9d:1d'],
                                                                                       'in_octets': '686609650',
                                                                                       'in_ucast_pkts': '7664070',
                                                                                       'mac_address': '00:15:67:e7:d6:36',
                                                                                       'out_octets': '981410270',
                                                                                       'out_ucast_pkts': '18969893'},
                                                                               {       'in_octets': '60222',
                                                                                       'in_ucast_pkts': '415',
                                                                                       'mac_address': '00:15:67:e7:d4:1a',
                                                                                       'out_octets': '452654',
                                                                                       'out_ucast_pkts': '1992'},
                                                                               {       'bridged_mac_addresses': [       '94:10:3e:f8:e6:76'],
                                                                                       'in_octets': '830286289',
                                                                                       'in_ucast_pkts': '2518551',
                                                                                       'mac_address': '00:15:67:f7:99:c4',
                                                                                       'out_octets': '3353875485',
                                                                                       'out_ucast_pkts': '3832320'},
                                                                               {       'bridged_mac_addresses': [       '44:65:7f:42:1b:c6'],
                                                                                       'in_octets': '899405604',
                                                                                       'in_ucast_pkts': '10515682',
                                                                                       'mac_address': '00:15:67:00:18:d0',
                                                                                       'out_octets': '3381266572',
                                                                                       'out_ucast_pkts': '26089173'},
                                                                               {       'bridged_mac_addresses': [       '84:c9:b2:68:7a:a7'],
                                                                                       'in_octets': '159871184',
                                                                                       'in_ucast_pkts': '954662',
                                                                                       'mac_address': '00:15:67:e7:d6:52',
                                                                                       'out_octets': '1498437451',
                                                                                       'out_ucast_pkts': '1320582'},
                                                                               {       'bridged_mac_addresses': [       '94:10:3e:f9:76:61'],
                                                                                       'in_octets': '1015661587',
                                                                                       'in_ucast_pkts': '6436125',
                                                                                       'mac_address': '00:15:67:e7:d7:04',
                                                                                       'out_octets': '426196936',
                                                                                       'out_ucast_pkts': '10261303'},
                                                                               {       'in_octets': '35390337',
                                                                                       'in_ucast_pkts': '225601',
                                                                                       'mac_address': '00:15:67:62:99:99',
                                                                                       'out_octets': '431363399',
                                                                                       'out_ucast_pkts': '1257824'},
                                                                               {       'bridged_mac_addresses': [       'c4:04:15:0e:ee:08'],
                                                                                       'in_octets': '744287550',
                                                                                       'in_ucast_pkts': '7159884',
                                                                                       'mac_address': '00:15:67:67:a3:5f',
                                                                                       'out_octets': '3580260254',
                                                                                       'out_ucast_pkts': '11547056'},
                                                                               {       'bridged_mac_addresses': [       '6c:b0:ce:a0:09:f6'],
                                                                                       'in_octets': '1491689155',
                                                                                       'in_ucast_pkts': '5844747',
                                                                                       'mac_address': '00:15:67:00:42:ea',
                                                                                       'out_octets': '1324651977',
                                                                                       'out_ucast_pkts': '11667620'},
                                                                               {       'bridged_mac_addresses': [       '00:1c:10:15:bd:f7'],
                                                                                       'in_octets': '462401737',
                                                                                       'in_ucast_pkts': '814618',
                                                                                       'mac_address': '00:15:67:62:c1:27',
                                                                                       'out_octets': '70560329',
                                                                                       'out_ucast_pkts': '482225'},
                                                                               {       'bridged_mac_addresses': [       'c0:56:27:29:57:e4'],
                                                                                       'in_octets': '2535268115',
                                                                                       'in_ucast_pkts': '5548345',
                                                                                       'mac_address': '00:15:67:62:c0:ae',
                                                                                       'out_octets': '3167027734',
                                                                                       'out_ucast_pkts': '7843850'},
                                                                               {       'bridged_mac_addresses': [       '0c:9d:92:55:b3:b8'],
                                                                                       'in_octets': '2384774904',
                                                                                       'in_ucast_pkts': '22463002',
                                                                                       'mac_address': '00:15:67:e7:c0:f0',
                                                                                       'out_octets': '416508636',
                                                                                       'out_ucast_pkts': '63634980'},
                                                                               {       'bridged_mac_addresses': [       'b0:7f:b9:91:49:e7'],
                                                                                       'in_octets': '1447198753',
                                                                                       'in_ucast_pkts': '2064532',
                                                                                       'mac_address': '00:15:67:62:c1:c4',
                                                                                       'out_octets': '1499904501',
                                                                                       'out_ucast_pkts': '2760753'},
                                                                               {       'bridged_mac_addresses': [       '44:65:7f:73:1a:48'],
                                                                                       'in_octets': '3345870285',
                                                                                       'in_ucast_pkts': '29535205',
                                                                                       'mac_address': '00:15:67:f7:bf:b1',
                                                                                       'out_octets': '1704488616',
                                                                                       'out_ucast_pkts': '20875062'},
                                                                               {       'bridged_mac_addresses': [       '48:f8:b3:4a:fd:cc'],
                                                                                       'in_octets': '2716986148',
                                                                                       'in_ucast_pkts': '19667106',
                                                                                       'mac_address': '00:15:67:f7:bf:f6',
                                                                                       'out_octets': '206463267',
                                                                                       'out_ucast_pkts': '36557169'},
                                                                               {       'bridged_mac_addresses': [       'c0:56:27:26:ae:83'],
                                                                                       'in_octets': '552837055',
                                                                                       'in_ucast_pkts': '5674830',
                                                                                       'mac_address': '00:15:67:63:27:2d',
                                                                                       'out_octets': '3335681922',
                                                                                       'out_ucast_pkts': '9233414'},
                                                                               {       'bridged_mac_addresses': [       '4c:60:de:e6:40:21'],
                                                                                       'in_octets': '1178692477',
                                                                                       'in_ucast_pkts': '5126822',
                                                                                       'mac_address': '00:15:67:00:ad:37',
                                                                                       'out_octets': '2687202300',
                                                                                       'out_ucast_pkts': '9744647'},
                                                                               {       'bridged_mac_addresses': [       '24:a4:3c:4b:83:d7'],
                                                                                       'in_octets': '1104419069',
                                                                                       'in_ucast_pkts': '11725553',
                                                                                       'mac_address': '00:15:67:67:ab:17',
                                                                                       'out_octets': '1144576793',
                                                                                       'out_ucast_pkts': '36244686'},
                                                                               {       'bridged_mac_addresses': [       'c0:25:e9:ff:10:0f'],
                                                                                       'in_octets': '588448959',
                                                                                       'in_ucast_pkts': '3347863',
                                                                                       'mac_address': '00:15:67:e7:c3:c9',
                                                                                       'out_octets': '970043570',
                                                                                       'out_ucast_pkts': '4992033'},
                                                                               {       'bridged_mac_addresses': [       '44:65:7f:b2:1c:a0'],
                                                                                       'in_octets': '1250474664',
                                                                                       'in_ucast_pkts': '5010202',
                                                                                       'mac_address': '00:15:67:63:27:c0',
                                                                                       'out_octets': '2649517760',
                                                                                       'out_ucast_pkts': '11097348'},
                                                                               {       'bridged_mac_addresses': [       '44:65:7f:88:81:ca'],
                                                                                       'in_octets': '1336568181',
                                                                                       'in_ucast_pkts': '5351800',
                                                                                       'mac_address': '00:15:67:f7:bf:de',
                                                                                       'out_octets': '1784363003',
                                                                                       'out_ucast_pkts': '7033022'},
                                                                               {       'bridged_mac_addresses': [       '9c:3d:cf:e4:6b:e7'],
                                                                                       'in_octets': '3840098428',
                                                                                       'in_ucast_pkts': '30805361',
                                                                                       'mac_address': '00:15:67:67:a3:77',
                                                                                       'out_octets': '3052129610',
                                                                                       'out_ucast_pkts': '93574729'},
                                                                               {       'bridged_mac_addresses': [       '2c:30:33:ed:5b:08'],
                                                                                       'in_octets': '426457985',
                                                                                       'in_ucast_pkts': '3150064',
                                                                                       'mac_address': '00:15:67:e2:d7:54',
                                                                                       'out_octets': '3674038741',
                                                                                       'out_ucast_pkts': '5850069'}],
                                                              'mac_address': '00:15:67:68:12:43',
                                                              'name': 'Radio Interface',
                                                              'out_octets': '3126767225',
                                                              'out_ucast_pkts': '669475805',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'frame_duration': 1250,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5780,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:15:67:e7:77:84',
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '108000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:67:a8:d5',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:67:7f:8e',
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '90000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:67:a8:44',
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '00:15:67:67:a3:53',
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:67:a2:ba',
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '00:15:67:62:ec:4c',
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:f6:2b:01',
                                                                                                                                            'rssi': -80.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:e7:c4:3b',
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '00:15:67:80:3e:40',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:e7:f8:74',
                                                                                                                                            'rssi': -80.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '90000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:63:81:56',
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '162000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:e3:ae:85',
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'rx_link_rate': '162000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:67:ff:0e',
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:67:fd:9c',
                                                                                                                                            'rssi': -84.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:67:fd:30',
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '240000000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '00:15:67:67:ff:6e',
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:67:fd:35',
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '216000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:f7:bf:ba',
                                                                                                                                            'rssi': -83.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '108000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:e7:d5:62',
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:80:bb:8f',
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:e7:c7:0c',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'mac_address': '00:15:67:f6:bb:96',
                                                                                                                                            'rssi': -82.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '90000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:f6:b0:b1',
                                                                                                                                            'rssi': -81.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '108000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:e7:d6:36',
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '108000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:e7:d4:1a',
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:f7:99:c4',
                                                                                                                                            'rssi': -80.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '90000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:00:18:d0',
                                                                                                                                            'rssi': -80.0,
                                                                                                                                            'rx_link_rate': '81000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '54000000',
                                                                                                                                            'tx_mcs': 1},
                                                                                                                                    {       'mac_address': '00:15:67:e7:d6:52',
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:e7:d7:04',
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:62:99:99',
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '162000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:67:a3:5f',
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:00:42:ea',
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'rx_link_rate': '162000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '180000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:62:c1:27',
                                                                                                                                            'rssi': -81.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '90000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:62:c0:ae',
                                                                                                                                            'rssi': -81.0,
                                                                                                                                            'rx_link_rate': '81000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '108000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:e7:c0:f0',
                                                                                                                                            'rssi': -84.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '90000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:62:c1:c4',
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'rx_link_rate': '90000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:f7:bf:b1',
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:f7:bf:f6',
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '240000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'mac_address': '00:15:67:63:27:2d',
                                                                                                                                            'rssi': -80.0,
                                                                                                                                            'rx_link_rate': '120000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'mac_address': '00:15:67:00:ad:37',
                                                                                                                                            'rssi': -81.0,
                                                                                                                                            'rx_link_rate': '81000000',
                                                                                                                                            'rx_mcs': 2,
                                                                                                                                            'tx_link_rate': '81000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:67:ab:17',
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:e7:c3:c9',
                                                                                                                                            'rssi': -81.0,
                                                                                                                                            'rx_link_rate': '52000000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'tx_link_rate': '90000000',
                                                                                                                                            'tx_mcs': 2},
                                                                                                                                    {       'mac_address': '00:15:67:63:27:c0',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '300000000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:f7:bf:de',
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'mac_address': '00:15:67:67:a3:77',
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_link_rate': '180000000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'tx_link_rate': '120000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'mac_address': '00:15:67:e2:d7:54',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'tx_link_rate': '300000000',
                                                                                                                                            'tx_mcs': 7}]}],
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '4444LJAHND-R58W'}]}],
                                'latitude': 37.978393,
                                'longitude': -103.580893,
                                'manufacturer': 'Radwin',
                                'model': 'RW-5BG5-0649',
                                'poller_hash': 'ABVnaBJD',
                                'serial_number': 'C13460IG00J00204',
                                'sw_version': '4.9.70_b0015_May  2 2019',
                                'system_mac_address': '00:15:67:e0:51:bf',
                                'temperature': 38.0,
                                'uptime': '263984'},
                'peers': [       {       'interfaces': [       {       'in_octets': '815025407',
                                                                       'in_ucast_pkts': '4623067',
                                                                       'links': [       {       'in_octets': '815025407',
                                                                                                'in_ucast_pkts': '4623067',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '276666244',
                                                                                                'out_ucast_pkts': '2238302'}],
                                                                       'mac_address': '00:15:67:e7:77:84',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '276666244',
                                                                       'out_ucast_pkts': '2238302',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '108000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -77.0,
                                                                                                                                                     'rx_link_rate': '108000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '276666244',
                                                                       'in_ucast_pkts': '2238302',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '815025407',
                                                                       'out_ucast_pkts': '4623067',
                                                                       'poller_hash': 'MDAxNTY3ZTc3Nzg0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.90222,
                                         'longitude': -103.19824,
                                         'management_ip': '10.101.4.45',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Randy Jones',
                                         'poller_hash': 'ABVn53eE',
                                         'serial_number': 'P10680I100A00C54',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '478913698',
                                                                       'in_ucast_pkts': '18075238',
                                                                       'links': [       {       'in_octets': '478913698',
                                                                                                'in_ucast_pkts': '18075238',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '733553453',
                                                                                                'out_ucast_pkts': '10398628'}],
                                                                       'mac_address': '00:15:67:67:a8:d5',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '733553453',
                                                                       'out_ucast_pkts': '10398628',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '733553453',
                                                                       'in_ucast_pkts': '10398628',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '478913698',
                                                                       'out_ucast_pkts': '18075238',
                                                                       'poller_hash': 'MDAxNTY3NjdhOGQ1TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.87522,
                                         'longitude': -103.13864,
                                         'management_ip': '10.101.4.15',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Edward Mayhoffer',
                                         'poller_hash': 'ABVnZ6jV',
                                         'serial_number': 'P10680I100A0102A',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '375174425',
                                                                       'in_ucast_pkts': '41158032',
                                                                       'links': [       {       'in_octets': '375174425',
                                                                                                'in_ucast_pkts': '41158032',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '2344939905',
                                                                                                'out_ucast_pkts': '26671562'}],
                                                                       'mac_address': '00:15:67:67:7f:8e',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2344939905',
                                                                       'out_ucast_pkts': '26671562',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '90000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -76.0,
                                                                                                                                                     'rx_link_rate': '90000000',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2344939905',
                                                                       'in_ucast_pkts': '26671562',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '375174425',
                                                                       'out_ucast_pkts': '41158032',
                                                                       'poller_hash': 'MDAxNTY3Njc3ZjhlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.82931,
                                         'longitude': -104.56971,
                                         'management_ip': '10.101.4.8',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Jessica Duran',
                                         'poller_hash': 'ABVnZ3+O',
                                         'serial_number': 'P10680I100A00DED',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2474872777',
                                                                       'in_ucast_pkts': '23861752',
                                                                       'links': [       {       'in_octets': '2474872777',
                                                                                                'in_ucast_pkts': '23861752',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1691143887',
                                                                                                'out_ucast_pkts': '16185789'}],
                                                                       'mac_address': '00:15:67:67:a8:44',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1691143887',
                                                                       'out_ucast_pkts': '16185789',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '240000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1691143887',
                                                                       'in_ucast_pkts': '16185789',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2474872777',
                                                                       'out_ucast_pkts': '23861752',
                                                                       'poller_hash': 'MDAxNTY3NjdhODQ0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.96979,
                                         'longitude': -103.4504,
                                         'management_ip': '10.101.4.47',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Donna Wren',
                                         'poller_hash': 'ABVnZ6hE',
                                         'serial_number': 'P10680I100A01032',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'links': [       {       'in_octets': '0',
                                                                                                'in_ucast_pkts': '0',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '0',
                                                                                                'out_ucast_pkts': '0'}],
                                                                       'mac_address': '00:15:67:67:a3:53',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'MDAxNTY3NjdhMzUzTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.58711,
                                         'longitude': -102.78757,
                                         'management_ip': '10.101.4.3',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Don Hunter',
                                         'poller_hash': 'ABVnZ6NT',
                                         'serial_number': 'P10680I100A00FA4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3909103124',
                                                                       'in_ucast_pkts': '3444096',
                                                                       'links': [       {       'in_octets': '3909103124',
                                                                                                'in_ucast_pkts': '3444096',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '405116948',
                                                                                                'out_ucast_pkts': '1692891'}],
                                                                       'mac_address': '00:15:67:67:a2:ba',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '405116948',
                                                                       'out_ucast_pkts': '1692891',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '405116948',
                                                                       'in_ucast_pkts': '1692891',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3909103124',
                                                                       'out_ucast_pkts': '3444096',
                                                                       'poller_hash': 'MDAxNTY3NjdhMmJhTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.17344,
                                         'longitude': -102.60014,
                                         'management_ip': '10.101.4.19',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Charles Nafziger',
                                         'poller_hash': 'ABVnZ6K6',
                                         'serial_number': 'P10680I100A00FEC',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3835787424',
                                                                       'in_ucast_pkts': '43495212',
                                                                       'links': [       {       'in_octets': '3835787424',
                                                                                                'in_ucast_pkts': '43495212',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1727714231',
                                                                                                'out_ucast_pkts': '19640053'}],
                                                                       'mac_address': '00:15:67:62:ec:4c',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1727714231',
                                                                       'out_ucast_pkts': '19640053',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1727714231',
                                                                       'in_ucast_pkts': '19640053',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3835787424',
                                                                       'out_ucast_pkts': '43495212',
                                                                       'poller_hash': 'MDAxNTY3NjJlYzRjTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.11',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Natalie Ridgwell',
                                         'poller_hash': 'ABVnYuxM',
                                         'serial_number': 'P15000I000M00622',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '550650828',
                                                                       'in_ucast_pkts': '1236411',
                                                                       'links': [       {       'in_octets': '550650828',
                                                                                                'in_ucast_pkts': '1236411',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '50168651',
                                                                                                'out_ucast_pkts': '282874'}],
                                                                       'mac_address': '00:15:67:f6:2b:01',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '50168651',
                                                                       'out_ucast_pkts': '282874',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -75.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '50168651',
                                                                       'in_ucast_pkts': '282874',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '550650828',
                                                                       'out_ucast_pkts': '1236411',
                                                                       'poller_hash': 'MDAxNTY3ZjYyYjAxTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.22',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Harold Vance',
                                         'poller_hash': 'ABVn9isB',
                                         'serial_number': 'P15000I000Q01261',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '300117543',
                                                                       'in_ucast_pkts': '40773375',
                                                                       'links': [       {       'in_octets': '300117543',
                                                                                                'in_ucast_pkts': '40773375',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '3343725371',
                                                                                                'out_ucast_pkts': '19919264'}],
                                                                       'mac_address': '00:15:67:e7:c4:3b',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3343725371',
                                                                       'out_ucast_pkts': '19919264',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '240000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3343725371',
                                                                       'in_ucast_pkts': '19919264',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '300117543',
                                                                       'out_ucast_pkts': '40773375',
                                                                       'poller_hash': 'MDAxNTY3ZTdjNDNiTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.14',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Timothy Alvarez',
                                         'poller_hash': 'ABVn58Q7',
                                         'serial_number': 'P10680I100A0136B',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1612274052',
                                                                       'in_ucast_pkts': '31733403',
                                                                       'links': [       {       'in_octets': '1612274052',
                                                                                                'in_ucast_pkts': '31733403',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1472369170',
                                                                                                'out_ucast_pkts': '15807517'}],
                                                                       'mac_address': '00:15:67:80:3e:40',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1472369170',
                                                                       'out_ucast_pkts': '15807517',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1472369170',
                                                                       'in_ucast_pkts': '15807517',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1612274052',
                                                                       'out_ucast_pkts': '31733403',
                                                                       'poller_hash': 'MDAxNTY3ODAzZTQwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.86638,
                                         'longitude': -104.5746,
                                         'management_ip': '10.101.4.51',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Chris Votruba',
                                         'poller_hash': 'ABVngD5A',
                                         'serial_number': 'P15000I000U00612',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2444060243',
                                                                       'in_ucast_pkts': '8492731',
                                                                       'links': [       {       'in_octets': '2444060243',
                                                                                                'in_ucast_pkts': '8492731',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1097563589',
                                                                                                'out_ucast_pkts': '4975897'}],
                                                                       'mac_address': '00:15:67:e7:f8:74',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1097563589',
                                                                       'out_ucast_pkts': '4975897',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '90000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -77.0,
                                                                                                                                                     'rx_link_rate': '90000000',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1097563589',
                                                                       'in_ucast_pkts': '4975897',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2444060243',
                                                                       'out_ucast_pkts': '8492731',
                                                                       'poller_hash': 'MDAxNTY3ZTdmODc0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.10887,
                                         'longitude': -102.58948,
                                         'management_ip': '10.101.4.36',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Josh Proctor',
                                         'poller_hash': 'ABVn5/h0',
                                         'serial_number': 'P10680I100A01671',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '621546391',
                                                                       'in_ucast_pkts': '1624950',
                                                                       'links': [       {       'in_octets': '621546391',
                                                                                                'in_ucast_pkts': '1624950',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '117108516',
                                                                                                'out_ucast_pkts': '373705'}],
                                                                       'mac_address': '00:15:67:63:81:56',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '117108516',
                                                                       'out_ucast_pkts': '373705',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '162000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '162000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '117108516',
                                                                       'in_ucast_pkts': '373705',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '621546391',
                                                                       'out_ucast_pkts': '1624950',
                                                                       'poller_hash': 'MDAxNTY3NjM4MTU2TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.6',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'South Swink Water',
                                         'poller_hash': 'ABVnY4FW',
                                         'serial_number': 'P15000I000T00253',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1800127301',
                                                                       'in_ucast_pkts': '85363465',
                                                                       'links': [       {       'in_octets': '1800127301',
                                                                                                'in_ucast_pkts': '85363465',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1368530660',
                                                                                                'out_ucast_pkts': '41180167'}],
                                                                       'mac_address': '00:15:67:e3:ae:85',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1368530660',
                                                                       'out_ucast_pkts': '41180167',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '162000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '162000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1368530660',
                                                                       'in_ucast_pkts': '41180167',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1800127301',
                                                                       'out_ucast_pkts': '85363465',
                                                                       'poller_hash': 'MDAxNTY3ZTNhZTg1TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.102',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Vicki Meis',
                                         'poller_hash': 'ABVn466F',
                                         'serial_number': 'P15000I000R01093',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '546046418',
                                                                       'in_ucast_pkts': '16550061',
                                                                       'links': [       {       'in_octets': '546046418',
                                                                                                'in_ucast_pkts': '16550061',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '650740056',
                                                                                                'out_ucast_pkts': '5204995'}],
                                                                       'mac_address': '00:15:67:67:ff:0e',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '650740056',
                                                                       'out_ucast_pkts': '5204995',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '650740056',
                                                                       'in_ucast_pkts': '5204995',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '546046418',
                                                                       'out_ucast_pkts': '16550061',
                                                                       'poller_hash': 'MDAxNTY3NjdmZjBlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.91425,
                                         'longitude': -103.22867,
                                         'management_ip': '10.101.4.27',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Tesslynn Jackson',
                                         'poller_hash': 'ABVnZ/8O',
                                         'serial_number': 'P10680I100A01661',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '710883954',
                                                                       'in_ucast_pkts': '76193328',
                                                                       'links': [       {       'in_octets': '710883954',
                                                                                                'in_ucast_pkts': '76193328',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '4221199821',
                                                                                                'out_ucast_pkts': '43927484'}],
                                                                       'mac_address': '00:15:67:67:fd:9c',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '4221199821',
                                                                       'out_ucast_pkts': '43927484',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -81.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '4221199821',
                                                                       'in_ucast_pkts': '43927484',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '710883954',
                                                                       'out_ucast_pkts': '76193328',
                                                                       'poller_hash': 'MDAxNTY3NjdmZDljTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.79119,
                                         'longitude': -102.99845,
                                         'management_ip': '10.101.4.20',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Glori Hubler-Hand',
                                         'poller_hash': 'ABVnZ/2c',
                                         'serial_number': 'P10680I100A01723',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3015157931',
                                                                       'in_ucast_pkts': '26164151',
                                                                       'links': [       {       'in_octets': '3015157931',
                                                                                                'in_ucast_pkts': '26164151',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1181382298',
                                                                                                'out_ucast_pkts': '9667279'}],
                                                                       'mac_address': '00:15:67:67:fd:30',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1181382298',
                                                                       'out_ucast_pkts': '9667279',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '240000000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '240000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1181382298',
                                                                       'in_ucast_pkts': '9667279',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3015157931',
                                                                       'out_ucast_pkts': '26164151',
                                                                       'poller_hash': 'MDAxNTY3NjdmZDMwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.88921,
                                         'longitude': -103.16822,
                                         'management_ip': '10.101.4.4',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Telly Stanger',
                                         'poller_hash': 'ABVnZ/0w',
                                         'serial_number': 'P10680I100A016A5',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3554951599',
                                                                       'in_ucast_pkts': '61818991',
                                                                       'links': [       {       'in_octets': '3554951599',
                                                                                                'in_ucast_pkts': '61818991',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '4057777885',
                                                                                                'out_ucast_pkts': '31765430'}],
                                                                       'mac_address': '00:15:67:67:ff:6e',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '4057777885',
                                                                       'out_ucast_pkts': '31765430',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '4057777885',
                                                                       'in_ucast_pkts': '31765430',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3554951599',
                                                                       'out_ucast_pkts': '61818991',
                                                                       'poller_hash': 'MDAxNTY3NjdmZjZlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.86027,
                                         'longitude': -103.10953,
                                         'management_ip': '10.101.4.39',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'DJ & Michelle Jones',
                                         'poller_hash': 'ABVnZ/9u',
                                         'serial_number': 'P10680I100A016A4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '752093769',
                                                                       'in_ucast_pkts': '52577085',
                                                                       'links': [       {       'in_octets': '752093769',
                                                                                                'in_ucast_pkts': '52577085',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '2549541446',
                                                                                                'out_ucast_pkts': '22275390'}],
                                                                       'mac_address': '00:15:67:67:fd:35',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2549541446',
                                                                       'out_ucast_pkts': '22275390',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '216000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '216000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2549541446',
                                                                       'in_ucast_pkts': '22275390',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '752093769',
                                                                       'out_ucast_pkts': '52577085',
                                                                       'poller_hash': 'MDAxNTY3NjdmZDM1TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.82755,
                                         'longitude': -103.05286,
                                         'management_ip': '10.101.4.9',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Chelsey Grover',
                                         'poller_hash': 'ABVnZ/01',
                                         'serial_number': 'P10680I100A0168F',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1823659507',
                                                                       'in_ucast_pkts': '34011961',
                                                                       'links': [       {       'in_octets': '1823659507',
                                                                                                'in_ucast_pkts': '34011961',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '369429191',
                                                                                                'out_ucast_pkts': '20787608'}],
                                                                       'mac_address': '00:15:67:f7:bf:ba',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '369429191',
                                                                       'out_ucast_pkts': '20787608',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '108000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '108000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '369429191',
                                                                       'in_ucast_pkts': '20787608',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1823659507',
                                                                       'out_ucast_pkts': '34011961',
                                                                       'poller_hash': 'MDAxNTY3ZjdiZmJhTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.28',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Derek Carroll',
                                         'poller_hash': 'ABVn97+6',
                                         'serial_number': 'P15000I000W01223',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2951287162',
                                                                       'in_ucast_pkts': '5819007',
                                                                       'links': [       {       'in_octets': '2951287162',
                                                                                                'in_ucast_pkts': '5819007',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '377047662',
                                                                                                'out_ucast_pkts': '1741101'}],
                                                                       'mac_address': '00:15:67:e7:d5:62',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '377047662',
                                                                       'out_ucast_pkts': '1741101',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '377047662',
                                                                       'in_ucast_pkts': '1741101',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2951287162',
                                                                       'out_ucast_pkts': '5819007',
                                                                       'poller_hash': 'MDAxNTY3ZTdkNTYyTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.73018,
                                         'longitude': -102.92158,
                                         'management_ip': '10.101.4.42',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Terry Mills',
                                         'poller_hash': 'ABVn59Vi',
                                         'serial_number': 'P10680I100A017D6',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3146173699',
                                                                       'in_ucast_pkts': '12573857',
                                                                       'links': [       {       'in_octets': '3146173699',
                                                                                                'in_ucast_pkts': '12573857',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1819142124',
                                                                                                'out_ucast_pkts': '6525849'}],
                                                                       'mac_address': '00:15:67:80:bb:8f',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1819142124',
                                                                       'out_ucast_pkts': '6525849',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1819142124',
                                                                       'in_ucast_pkts': '6525849',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3146173699',
                                                                       'out_ucast_pkts': '12573857',
                                                                       'poller_hash': 'MDAxNTY3ODBiYjhmTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.62',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Frederick Johnson',
                                         'poller_hash': 'ABVngLuP',
                                         'serial_number': 'P15000I000Q01206',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1839272701',
                                                                       'in_ucast_pkts': '2463032',
                                                                       'links': [       {       'in_octets': '1839272701',
                                                                                                'in_ucast_pkts': '2463032',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '92814333',
                                                                                                'out_ucast_pkts': '673699'}],
                                                                       'mac_address': '00:15:67:e7:c7:0c',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '92814333',
                                                                       'out_ucast_pkts': '673699',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'tx_link_rate': '270000000',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '270000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '92814333',
                                                                       'in_ucast_pkts': '673699',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1839272701',
                                                                       'out_ucast_pkts': '2463032',
                                                                       'poller_hash': 'MDAxNTY3ZTdjNzBjTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.48',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Mayhoffer Farms Shop',
                                         'poller_hash': 'ABVn58cM',
                                         'serial_number': 'P10680I100A01849',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3355837768',
                                                                       'in_ucast_pkts': '3129235',
                                                                       'links': [       {       'in_octets': '3355837768',
                                                                                                'in_ucast_pkts': '3129235',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '606928454',
                                                                                                'out_ucast_pkts': '2780560'}],
                                                                       'mac_address': '00:15:67:f6:bb:96',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '606928454',
                                                                       'out_ucast_pkts': '2780560',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '90000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -78.0,
                                                                                                                                                     'rx_link_rate': '90000000',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '606928454',
                                                                       'in_ucast_pkts': '2780560',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3355837768',
                                                                       'out_ucast_pkts': '3129235',
                                                                       'poller_hash': 'MDAxNTY3ZjZiYjk2TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.61',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5650-0P58',
                                         'name': 'Mayrene Pennington',
                                         'poller_hash': 'ABVn9ruW',
                                         'serial_number': 'P14970I500T01095',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '193980673',
                                                                       'in_ucast_pkts': '8135186',
                                                                       'links': [       {       'in_octets': '193980673',
                                                                                                'in_ucast_pkts': '8135186',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '819443579',
                                                                                                'out_ucast_pkts': '5376167'}],
                                                                       'mac_address': '00:15:67:f6:b0:b1',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '819443579',
                                                                       'out_ucast_pkts': '5376167',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '108000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -75.0,
                                                                                                                                                     'rx_link_rate': '108000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '819443579',
                                                                       'in_ucast_pkts': '5376167',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '193980673',
                                                                       'out_ucast_pkts': '8135186',
                                                                       'poller_hash': 'MDAxNTY3ZjZiMGIxTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.16',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5650-0P58',
                                         'name': 'John and Valerie Campbell',
                                         'poller_hash': 'ABVn9rCx',
                                         'serial_number': 'P14970I500T01094',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '981410270',
                                                                       'in_ucast_pkts': '18969893',
                                                                       'links': [       {       'in_octets': '981410270',
                                                                                                'in_ucast_pkts': '18969893',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '686609650',
                                                                                                'out_ucast_pkts': '7664070'}],
                                                                       'mac_address': '00:15:67:e7:d6:36',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '686609650',
                                                                       'out_ucast_pkts': '7664070',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '108000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '108000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '686609650',
                                                                       'in_ucast_pkts': '7664070',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '981410270',
                                                                       'out_ucast_pkts': '18969893',
                                                                       'poller_hash': 'MDAxNTY3ZTdkNjM2TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.86639,
                                         'longitude': -104.5746,
                                         'management_ip': '10.101.4.32',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Mayhoffer Farms Office',
                                         'poller_hash': 'ABVn59Y2',
                                         'serial_number': 'P10680I100A01846',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '452654',
                                                                       'in_ucast_pkts': '1992',
                                                                       'links': [       {       'in_octets': '452654',
                                                                                                'in_ucast_pkts': '1992',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '60222',
                                                                                                'out_ucast_pkts': '415'}],
                                                                       'mac_address': '00:15:67:e7:d4:1a',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '60222',
                                                                       'out_ucast_pkts': '415',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -75.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '60222',
                                                                       'in_ucast_pkts': '415',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '452654',
                                                                       'out_ucast_pkts': '1992',
                                                                       'poller_hash': 'MDAxNTY3ZTdkNDFhTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.3306,
                                         'longitude': -102.64502,
                                         'management_ip': '10.101.4.13',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Keo Honey',
                                         'poller_hash': 'ABVn59Qa',
                                         'serial_number': 'P10680I100A01785',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3353875485',
                                                                       'in_ucast_pkts': '3832320',
                                                                       'links': [       {       'in_octets': '3353875485',
                                                                                                'in_ucast_pkts': '3832320',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '830286289',
                                                                                                'out_ucast_pkts': '2518551'}],
                                                                       'mac_address': '00:15:67:f7:99:c4',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '830286289',
                                                                       'out_ucast_pkts': '2518551',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '90000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -79.0,
                                                                                                                                                     'rx_link_rate': '90000000',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '830286289',
                                                                       'in_ucast_pkts': '2518551',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3353875485',
                                                                       'out_ucast_pkts': '3832320',
                                                                       'poller_hash': 'MDAxNTY3Zjc5OWM0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.63',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Dennis Carroll',
                                         'poller_hash': 'ABVn95nE',
                                         'serial_number': 'P15000I000M01599',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3381266572',
                                                                       'in_ucast_pkts': '26089173',
                                                                       'links': [       {       'in_octets': '3381266572',
                                                                                                'in_ucast_pkts': '26089173',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '899405604',
                                                                                                'out_ucast_pkts': '10515682'}],
                                                                       'mac_address': '00:15:67:00:18:d0',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '899405604',
                                                                       'out_ucast_pkts': '10515682',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '54000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -77.0,
                                                                                                                                                     'rx_link_rate': '54000000',
                                                                                                                                                     'rx_mcs': 1,
                                                                                                                                                     'tx_link_rate': '81000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '81000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '899405604',
                                                                       'in_ucast_pkts': '10515682',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3381266572',
                                                                       'out_ucast_pkts': '26089173',
                                                                       'poller_hash': 'MDAxNTY3MDAxOGQwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.21',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Dillon Suto',
                                         'poller_hash': 'ABVnABjQ',
                                         'serial_number': 'P15000I000U00466',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1498437451',
                                                                       'in_ucast_pkts': '1320582',
                                                                       'links': [       {       'in_octets': '1498437451',
                                                                                                'in_ucast_pkts': '1320582',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '159871184',
                                                                                                'out_ucast_pkts': '954662'}],
                                                                       'mac_address': '00:15:67:e7:d6:52',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '159871184',
                                                                       'out_ucast_pkts': '954662',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '159871184',
                                                                       'in_ucast_pkts': '954662',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1498437451',
                                                                       'out_ucast_pkts': '1320582',
                                                                       'poller_hash': 'MDAxNTY3ZTdkNjUyTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.04375,
                                         'longitude': -102.58306,
                                         'management_ip': '10.101.4.26',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5550-0H50',
                                         'name': 'Carolyn Thomas',
                                         'poller_hash': 'ABVn59ZS',
                                         'serial_number': 'P10700I500A01AE4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '426196936',
                                                                       'in_ucast_pkts': '10261303',
                                                                       'links': [       {       'in_octets': '426196936',
                                                                                                'in_ucast_pkts': '10261303',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1015661587',
                                                                                                'out_ucast_pkts': '6436125'}],
                                                                       'mac_address': '00:15:67:e7:d7:04',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1015661587',
                                                                       'out_ucast_pkts': '6436125',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1015661587',
                                                                       'in_ucast_pkts': '6436125',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '426196936',
                                                                       'out_ucast_pkts': '10261303',
                                                                       'poller_hash': 'MDAxNTY3ZTdkNzA0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.42063,
                                         'longitude': -102.68405,
                                         'management_ip': '10.101.4.41',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5550-0H50',
                                         'name': 'Dave Kaess',
                                         'poller_hash': 'ABVn59cE',
                                         'serial_number': 'P10700I500A01AE7',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '431363399',
                                                                       'in_ucast_pkts': '1257824',
                                                                       'links': [       {       'in_octets': '431363399',
                                                                                                'in_ucast_pkts': '1257824',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '35390337',
                                                                                                'out_ucast_pkts': '225601'}],
                                                                       'mac_address': '00:15:67:62:99:99',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '35390337',
                                                                       'out_ucast_pkts': '225601',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '162000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '162000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '35390337',
                                                                       'in_ucast_pkts': '225601',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '431363399',
                                                                       'out_ucast_pkts': '1257824',
                                                                       'poller_hash': 'MDAxNTY3NjI5OTk5TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.68359,
                                         'longitude': -104.53646,
                                         'management_ip': '10.101.4.57',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'John Guess',
                                         'poller_hash': 'ABVnYpmZ',
                                         'serial_number': 'P15000I000P00327',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3580260254',
                                                                       'in_ucast_pkts': '11547056',
                                                                       'links': [       {       'in_octets': '3580260254',
                                                                                                'in_ucast_pkts': '11547056',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '744287550',
                                                                                                'out_ucast_pkts': '7159884'}],
                                                                       'mac_address': '00:15:67:67:a3:5f',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '744287550',
                                                                       'out_ucast_pkts': '7159884',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '300000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '300000000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'tx_link_rate': '300000000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '300000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '744287550',
                                                                       'in_ucast_pkts': '7159884',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3580260254',
                                                                       'out_ucast_pkts': '11547056',
                                                                       'poller_hash': 'MDAxNTY3NjdhMzVmTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.36103,
                                         'longitude': -102.65705,
                                         'management_ip': '10.101.4.43',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Jerry Henderson',
                                         'poller_hash': 'ABVnZ6Nf',
                                         'serial_number': 'P10680I100A00FAD',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1324651977',
                                                                       'in_ucast_pkts': '11667620',
                                                                       'links': [       {       'in_octets': '1324651977',
                                                                                                'in_ucast_pkts': '11667620',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1491689155',
                                                                                                'out_ucast_pkts': '5844747'}],
                                                                       'mac_address': '00:15:67:00:42:ea',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1491689155',
                                                                       'out_ucast_pkts': '5844747',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '180000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '180000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '162000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '162000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1491689155',
                                                                       'in_ucast_pkts': '5844747',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1324651977',
                                                                       'out_ucast_pkts': '11667620',
                                                                       'poller_hash': 'MDAxNTY3MDA0MmVhTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 37.75583,
                                         'longitude': -104.55581,
                                         'management_ip': '10.101.4.52',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Rich Goodrich',
                                         'poller_hash': 'ABVnAELq',
                                         'serial_number': 'P15000I000U00621',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '70560329',
                                                                       'in_ucast_pkts': '482225',
                                                                       'links': [       {       'in_octets': '70560329',
                                                                                                'in_ucast_pkts': '482225',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '462401737',
                                                                                                'out_ucast_pkts': '814618'}],
                                                                       'mac_address': '00:15:67:62:c1:27',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '462401737',
                                                                       'out_ucast_pkts': '814618',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '90000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -78.0,
                                                                                                                                                     'rx_link_rate': '90000000',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '462401737',
                                                                       'in_ucast_pkts': '814618',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '70560329',
                                                                       'out_ucast_pkts': '482225',
                                                                       'poller_hash': 'MDAxNTY3NjJjMTI3TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.7717,
                                         'longitude': -102.97216,
                                         'management_ip': '10.101.4.34',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5650-0P58',
                                         'name': 'Bill Seamans',
                                         'poller_hash': 'ABVnYsEn',
                                         'serial_number': 'P14970I500P00181',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3167027734',
                                                                       'in_ucast_pkts': '7843850',
                                                                       'links': [       {       'in_octets': '3167027734',
                                                                                                'in_ucast_pkts': '7843850',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '2535268115',
                                                                                                'out_ucast_pkts': '5548345'}],
                                                                       'mac_address': '00:15:67:62:c0:ae',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2535268115',
                                                                       'out_ucast_pkts': '5548345',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '108000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -76.0,
                                                                                                                                                     'rx_link_rate': '108000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '81000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '81000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2535268115',
                                                                       'in_ucast_pkts': '5548345',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3167027734',
                                                                       'out_ucast_pkts': '7843850',
                                                                       'poller_hash': 'MDAxNTY3NjJjMGFlTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.47834,
                                         'longitude': -102.7149,
                                         'management_ip': '10.101.4.17',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5650-0P58',
                                         'name': 'Walter Flye',
                                         'poller_hash': 'ABVnYsCu',
                                         'serial_number': 'P14970I500R00184',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '416508636',
                                                                       'in_ucast_pkts': '63634980',
                                                                       'links': [       {       'in_octets': '416508636',
                                                                                                'in_ucast_pkts': '63634980',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '2384774904',
                                                                                                'out_ucast_pkts': '22463002'}],
                                                                       'mac_address': '00:15:67:e7:c0:f0',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2384774904',
                                                                       'out_ucast_pkts': '22463002',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '90000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -80.0,
                                                                                                                                                     'rx_link_rate': '90000000',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2384774904',
                                                                       'in_ucast_pkts': '22463002',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '416508636',
                                                                       'out_ucast_pkts': '63634980',
                                                                       'poller_hash': 'MDAxNTY3ZTdjMGYwTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.25',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Ty Herman',
                                         'poller_hash': 'ABVn58Dw',
                                         'serial_number': 'P10680I100A011A8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1499904501',
                                                                       'in_ucast_pkts': '2760753',
                                                                       'links': [       {       'in_octets': '1499904501',
                                                                                                'in_ucast_pkts': '2760753',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1447198753',
                                                                                                'out_ucast_pkts': '2064532'}],
                                                                       'mac_address': '00:15:67:62:c1:c4',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1447198753',
                                                                       'out_ucast_pkts': '2064532',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '90000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '90000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1447198753',
                                                                       'in_ucast_pkts': '2064532',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1499904501',
                                                                       'out_ucast_pkts': '2760753',
                                                                       'poller_hash': 'MDAxNTY3NjJjMWM0TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.20542,
                                         'longitude': -102.60705,
                                         'management_ip': '10.101.4.2',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5650-0P58',
                                         'name': 'Linda Tomky',
                                         'poller_hash': 'ABVnYsHE',
                                         'serial_number': 'P14970I500Q00189',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1704488616',
                                                                       'in_ucast_pkts': '20875062',
                                                                       'links': [       {       'in_octets': '1704488616',
                                                                                                'in_ucast_pkts': '20875062',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '3345870285',
                                                                                                'out_ucast_pkts': '29535205'}],
                                                                       'mac_address': '00:15:67:f7:bf:b1',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '3345870285',
                                                                       'out_ucast_pkts': '29535205',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3345870285',
                                                                       'in_ucast_pkts': '29535205',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1704488616',
                                                                       'out_ucast_pkts': '20875062',
                                                                       'poller_hash': 'MDAxNTY3ZjdiZmIxTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.31',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Diamond A Farms',
                                         'poller_hash': 'ABVn97+x',
                                         'serial_number': 'P15000I000U01203',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '206463267',
                                                                       'in_ucast_pkts': '36557169',
                                                                       'links': [       {       'in_octets': '206463267',
                                                                                                'in_ucast_pkts': '36557169',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '2716986148',
                                                                                                'out_ucast_pkts': '19667106'}],
                                                                       'mac_address': '00:15:67:f7:bf:f6',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '2716986148',
                                                                       'out_ucast_pkts': '19667106',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '240000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '240000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2716986148',
                                                                       'in_ucast_pkts': '19667106',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '206463267',
                                                                       'out_ucast_pkts': '36557169',
                                                                       'poller_hash': 'MDAxNTY3ZjdiZmY2TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.38',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Karney Kattle Kompany',
                                         'poller_hash': 'ABVn97/2',
                                         'serial_number': 'P15000I000W01243',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '3335681922',
                                                                       'in_ucast_pkts': '9233414',
                                                                       'links': [       {       'in_octets': '3335681922',
                                                                                                'in_ucast_pkts': '9233414',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '552837055',
                                                                                                'out_ucast_pkts': '5674830'}],
                                                                       'mac_address': '00:15:67:63:27:2d',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '552837055',
                                                                       'out_ucast_pkts': '5674830',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'tx_link_rate': '120000000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '120000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '552837055',
                                                                       'in_ucast_pkts': '5674830',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '3335681922',
                                                                       'out_ucast_pkts': '9233414',
                                                                       'poller_hash': 'MDAxNTY3NjMyNzJkTWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.26863,
                                         'longitude': -102.62398,
                                         'management_ip': '10.101.4.30',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5650-0P58',
                                         'name': 'Shelby Jackson',
                                         'poller_hash': 'ABVnYyct',
                                         'serial_number': 'P14970I500M00257',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '2687202300',
                                                                       'in_ucast_pkts': '9744647',
                                                                       'links': [       {       'in_octets': '2687202300',
                                                                                                'in_ucast_pkts': '9744647',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1178692477',
                                                                                                'out_ucast_pkts': '5126822'}],
                                                                       'mac_address': '00:15:67:00:ad:37',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1178692477',
                                                                       'out_ucast_pkts': '5126822',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '81000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -78.0,
                                                                                                                                                     'rx_link_rate': '81000000',
                                                                                                                                                     'rx_mcs': 2,
                                                                                                                                                     'tx_link_rate': '81000000',
                                                                                                                                                     'tx_mcs': 2}]}],
                                                                                                 'tx_link_rate': '81000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1178692477',
                                                                       'in_ucast_pkts': '5126822',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '2687202300',
                                                                       'out_ucast_pkts': '9744647',
                                                                       'poller_hash': 'MDAxNTY3MDBhZDM3TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'management_ip': '10.101.4.24',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5600-0A58',
                                         'name': 'Dennis Frazee',
                                         'poller_hash': 'ABVnAK03',
                                         'serial_number': 'P15000I000Q01191',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '1144576793',
                                                                       'in_ucast_pkts': '36244686',
                                                                       'links': [       {       'in_octets': '1144576793',
                                                                                                'in_ucast_pkts': '36244686',
                                                                                                'mac_address': '00:15:67:68:12:43',
                                                                                                'out_octets': '1104419069',
                                                                                                'out_ucast_pkts': '11725553'}],
                                                                       'mac_address': '00:15:67:67:ab:17',
                                                                       'name': 'Radio '
                                                                               'Interface',
                                                                       'out_octets': '1104419069',
                                                                       'out_ucast_pkts': '11725553',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'frame_duration': 1250,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5780,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '120000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:15:67:68:12:43',
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '120000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'tx_link_rate': '180000000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '180000000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '4444LJAHND-R58W'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1104419069',
                                                                       'in_ucast_pkts': '11725553',
                                                                       'name': 'Management '
                                                                               'Port '
                                                                               'on Odu',
                                                                       'out_octets': '1144576793',
                                                                       'out_ucast_pkts': '36244686',
                                                                       'poller_hash': 'MDAxNTY3NjdhYjE3TWFuYWdlbWVudCBQb3J0IG9uIE9kdQ=='}],
                                         'latitude': 38.68545,
                                         'longitude': -102.87382,
                                         'management_ip': '10.101.4.44',
                                         'manufacturer': 'Radwin',
                                         'model': 'RW-5510-0H50',
                                         'name': 'Michael Mayhoffer',
                                         'poller_hash': 'ABVnZ6sX',
                                         'serial_number': 'P10680I100A01062',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'in_octets': '970043570',
                                                                       'in_ucast_pkts': '4992033',
 