import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestTarana(DeviceTestCase):
    def test_tarana_tarana_30_0134_001_0_977_016_00_10_135_132_131(self):
        obj = self.run_data("tarana.tarana.30-0134-001.0.977.016.00.10_135_132_131")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 14,
                'sw_version': '0.977.016.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F1211300003',
                'system_mac_address': None,
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                'S128F1211400031': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 111545078110,
                                           'dl_rf_packets': 81291434,
                                           'ip_address': None,
                                           'name': 'Kieyah_Fyffe',
                                           'serial': 'S128F1211400031',
                                           'serial_number': 'S128F1211400031',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7359657609,
                                           'ul_rf_packets': 42327105},
                'S128F1211400132': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 10051144497,
                                           'dl_rf_packets': 8820136,
                                           'ip_address': None,
                                           'name': 'Angie_Kroeger',
                                           'serial': 'S128F1211400132',
                                           'serial_number': 'S128F1211400132',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2733726156,
                                           'ul_rf_packets': 6875524},
                'S128F1211400171': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 702092934,
                                           'dl_rf_packets': 642830,
                                           'ip_address': None,
                                           'name': 'Jennifer_Ray_49051',
                                           'serial': 'S128F1211400171',
                                           'serial_number': 'S128F1211400171',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 78492505,
                                           'ul_rf_packets': 492909},
                'S128F1211500013': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 113867872218,
                                           'dl_rf_packets': 90367207,
                                           'ip_address': None,
                                           'name': 'Savannah_Szymanski',
                                           'serial': 'S128F1211500013',
                                           'serial_number': 'S128F1211500013',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 25475107589,
                                           'ul_rf_packets': 50702193},
                'S128F1211500072': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 82589886935,
                                           'dl_rf_packets': 56608704,
                                           'ip_address': None,
                                           'name': 'Carla_Childers',
                                           'serial': 'S128F1211500072',
                                           'serial_number': 'S128F1211500072',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2038966760,
                                           'ul_rf_packets': 16098680},
                'S128F1212500234': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 666373607312,
                                           'dl_rf_packets': 472455749,
                                           'ip_address': None,
                                           'name': 'Clayton_Corbett_50530',
                                           'serial': 'S128F1212500234',
                                           'serial_number': 'S128F1212500234',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 25695928166,
                                           'ul_rf_packets': 232755799},
                'S128F1212500548': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 53809661651,
                                           'dl_rf_packets': 43130994,
                                           'ip_address': None,
                                           'name': 'Heather_Sullivan',
                                           'serial': 'S128F1212500548',
                                           'serial_number': 'S128F1212500548',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 3517554304,
                                           'ul_rf_packets': 21470664},
                'S128F1212700257': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 407114452703,
                                           'dl_rf_packets': 280482511,
                                           'ip_address': None,
                                           'name': 'Renee_Dove',
                                           'serial': 'S128F1212700257',
                                           'serial_number': 'S128F1212700257',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 11245769456,
                                           'ul_rf_packets': 126478788},
                'S128F1212800054': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 409924967218,
                                           'dl_rf_packets': 311815755,
                                           'ip_address': None,
                                           'name': 'Danita_Bittle',
                                           'serial': 'S128F1212800054',
                                           'serial_number': 'S128F1212800054',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 17431373891,
                                           'ul_rf_packets': 76981758},
                'S128F1212800154': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 773910937027,
                                           'dl_rf_packets': 696398826,
                                           'ip_address': None,
                                           'name': 'Steve_Brockman_46913',
                                           'serial': 'S128F1212800154',
                                           'serial_number': 'S128F1212800154',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 131531096939,
                                           'ul_rf_packets': 497346328},
                'S128F1212800181': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 242352872853,
                                           'dl_rf_packets': 176246456,
                                           'ip_address': None,
                                           'name': 'Rose_Martin_49117',
                                           'serial': 'S128F1212800181',
                                           'serial_number': 'S128F1212800181',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 12424890198,
                                           'ul_rf_packets': 59148886},
                'S150F2224125595': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 471906591144,
                                           'dl_rf_packets': 318549251,
                                           'ip_address': None,
                                           'name': 'Dustin_Draper_47015',
                                           'serial': 'S150F2224125595',
                                           'serial_number': 'S150F2224125595',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 13864498472,
                                           'ul_rf_packets': 152388342},
                'S150F2224125599': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 48388445836,
                                           'dl_rf_packets': 38263708,
                                           'ip_address': None,
                                           'name': 'Wesley_White_49956',
                                           'serial': 'S150F2224125599',
                                           'serial_number': 'S150F2224125599',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 5264949395,
                                           'ul_rf_packets': 25847714},
                'S150F2224125601': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 90793124384,
                                           'dl_rf_packets': 72503965,
                                           'ip_address': None,
                                           'name': 'Larry_Soles_49451',
                                           'serial': 'S150F2224125601',
                                           'serial_number': 'S150F2224125601',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 15247110856,
                                           'ul_rf_packets': 57147321}
        }
        exp_ne_msg = {
                'data': {       'cpu': 33.412533,
                                'elevation': 336.58,
                                'gps_sats_tracked': 17,
                                'height': 562.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '422427',
                                                                                       'in_octets': '7359657609',
                                                                                       'in_ucast_pkts': '42327105',
                                                                                       'out_errors': '1804747',
                                                                                       'out_octets': '111545078110',
                                                                                       'out_ucast_pkts': '81291434',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ=='},
                                                                               {       'in_errors': '1912251',
                                                                                       'in_octets': '11245769456',
                                                                                       'in_ucast_pkts': '126478788',
                                                                                       'out_errors': '9338056',
                                                                                       'out_octets': '407114452703',
                                                                                       'out_ucast_pkts': '280482511',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ=='},
                                                                               {       'in_errors': '1927202',
                                                                                       'in_octets': '25475107589',
                                                                                       'in_ucast_pkts': '50702193',
                                                                                       'out_errors': '5806455',
                                                                                       'out_octets': '113867872218',
                                                                                       'out_ucast_pkts': '90367207',
                                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ=='},
                                                                               {       'in_errors': '6120175',
                                                                                       'in_octets': '131531096939',
                                                                                       'in_ucast_pkts': '497346328',
                                                                                       'out_errors': '29433563',
                                                                                       'out_octets': '773910937027',
                                                                                       'out_ucast_pkts': '696398826',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ=='},
                                                                               {       'in_errors': '397930',
                                                                                       'in_octets': '3517554304',
                                                                                       'in_ucast_pkts': '21470664',
                                                                                       'out_errors': '1921034',
                                                                                       'out_octets': '53809661651',
                                                                                       'out_ucast_pkts': '43130994',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ=='},
                                                                               {       'in_errors': '13742',
                                                                                       'in_octets': '78492505',
                                                                                       'in_ucast_pkts': '492909',
                                                                                       'out_errors': '45064',
                                                                                       'out_octets': '702092934',
                                                                                       'out_ucast_pkts': '642830',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ=='},
                                                                               {       'in_errors': '2919236',
                                                                                       'in_octets': '25695928166',
                                                                                       'in_ucast_pkts': '232755799',
                                                                                       'out_errors': '13889372',
                                                                                       'out_octets': '666373607312',
                                                                                       'out_ucast_pkts': '472455749',
                                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ=='},
                                                                               {       'in_errors': '2119119',
                                                                                       'in_octets': '17431373891',
                                                                                       'in_ucast_pkts': '76981758',
                                                                                       'out_errors': '11193598',
                                                                                       'out_octets': '409924967218',
                                                                                       'out_ucast_pkts': '311815755',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ=='},
                                                                               {       'in_errors': '568332',
                                                                                       'in_octets': '12424890198',
                                                                                       'in_ucast_pkts': '59148886',
                                                                                       'out_errors': '4049822',
                                                                                       'out_octets': '242352872853',
                                                                                       'out_ucast_pkts': '176246456',
                                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ=='},
                                                                               {       'in_errors': '90557',
                                                                                       'in_octets': '2733726156',
                                                                                       'in_ucast_pkts': '6875524',
                                                                                       'out_errors': '330964',
                                                                                       'out_octets': '10051144497',
                                                                                       'out_ucast_pkts': '8820136',
                                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ=='},
                                                                               {       'in_errors': '1308940',
                                                                                       'in_octets': '13864498472',
                                                                                       'in_ucast_pkts': '152388342',
                                                                                       'out_errors': '5992835',
                                                                                       'out_octets': '471906591144',
                                                                                       'out_ucast_pkts': '318549251',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ=='},
                                                                               {       'in_errors': '637110',
                                                                                       'in_octets': '15247110856',
                                                                                       'in_ucast_pkts': '57147321',
                                                                                       'out_errors': '3065344',
                                                                                       'out_octets': '90793124384',
                                                                                       'out_ucast_pkts': '72503965',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ=='},
                                                                               {       'in_errors': '414063',
                                                                                       'in_octets': '2038966760',
                                                                                       'in_ucast_pkts': '16098680',
                                                                                       'out_errors': '1229025',
                                                                                       'out_octets': '82589886935',
                                                                                       'out_ucast_pkts': '56608704',
                                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ=='},
                                                                               {       'in_errors': '361262',
                                                                                       'in_octets': '5264949395',
                                                                                       'in_ucast_pkts': '25847714',
                                                                                       'out_errors': '1792137',
                                                                                       'out_octets': '48388445836',
                                                                                       'out_ucast_pkts': '38263708',
                                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '615729',
                                                                                                                                            'distance': 2465,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ=='},
                                                                                                                                    {       'connected_time': '660559',
                                                                                                                                            'distance': 12837,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ=='},
                                                                                                                                    {       'connected_time': '499379',
                                                                                                                                            'distance': 7148,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ=='},
                                                                                                                                    {       'connected_time': '13211649',
                                                                                                                                            'distance': 10874,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ=='},
                                                                                                                                    {       'connected_time': '561019',
                                                                                                                                            'distance': 10190,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ=='},
                                                                                                                                    {       'connected_time': '26889',
                                                                                                                                            'distance': 14043,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ=='},
                                                                                                                                    {       'connected_time': '6128339',
                                                                                                                                            'distance': 6994,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ=='},
                                                                                                                                    {       'connected_time': '2796999',
                                                                                                                                            'distance': 6499,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ=='},
                                                                                                                                    {       'connected_time': '670589',
                                                                                                                                            'distance': 9359,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ=='},
                                                                                                                                    {       'connected_time': '589919',
                                                                                                                                            'distance': 2144,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ=='},
                                                                                                                                    {       'connected_time': '517679',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ=='},
                                                                                                                                    {       'connected_time': '692229',
                                                                                                                                            'distance': 9272,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ=='},
                                                                                                                                    {       'connected_time': '569469',
                                                                                                                                            'distance': 6492,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ=='},
                                                                                                                                    {       'connected_time': '662599',
                                                                                                                                            'distance': 3711,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '564',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '25080442',
                                                              'in_octets': '38698663489263',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '2358353',
                                                              'out_octets': '3320911369647',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '152',
                                                              'out_octets': '11386',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzZXgy'},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '17434',
                                                              'out_octets': '1228160',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDAzZ2kx'}],
                                'latitude': 38.7607536315918,
                                'longitude': -93.46488952636719,
                                'manufacturer': 'Tarana',
                                'mem': 2.9162247,
                                'model': '30-0134-001',
                                'poller_hash': 'UzEzNEYxMjExMzAwMDAz',
                                'serial_number': 'S134F1211300003',
                                'sw_version': '0.977.016.00',
                                'temperature': 29.125,
                                'uptime': '17481742'},
                'peers': [       {       'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '111545078110',
                                                                       'in_ucast_pkts': '81291434',
                                                                       'links': [       {       'in_octets': '111545078110',
                                                                                                'in_ucast_pkts': '81291434',
                                                                                                'out_octets': '7359657609',
                                                                                                'out_ucast_pkts': '42327105',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7359657609',
                                                                       'out_ucast_pkts': '42327105',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDMxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '615729',
                                                                                                                                                     'distance': 2465,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5632',
                                                                       'in_octets': '7359766082',
                                                                       'in_ucast_pkts': '42321173',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '111222722782',
                                                                       'out_ucast_pkts': '81291685',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMDMxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.73887252807617,
                                         'longitude': -93.4662857055664,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Kieyah_Fyffe',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMDMx',
                                         'serial_number': 'S128F1211400031',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.958,
                                         'uptime': '616070'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '407114452703',
                                                                       'in_ucast_pkts': '280482511',
                                                                       'links': [       {       'in_octets': '407114452703',
                                                                                                'in_ucast_pkts': '280482511',
                                                                                                'out_octets': '11245769456',
                                                                                                'out_ucast_pkts': '126478788',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '11245769456',
                                                                       'out_ucast_pkts': '126478788',
                                                                       'poller_hash': 'UzEyOEYxMjEyNzAwMjU3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '660559',
                                                                                                                                                     'distance': 12837,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '763',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6131',
                                                                       'in_octets': '11246419217',
                                                                       'in_ucast_pkts': '126472618',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '405980799892',
                                                                       'out_ucast_pkts': '280475681',
                                                                       'poller_hash': 'UzEyOEYxMjEyNzAwMjU3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.646331787109375,
                                         'longitude': -93.47783660888672,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Renee_Dove',
                                         'poller_hash': 'UzEyOEYxMjEyNzAwMjU3',
                                         'serial_number': 'S128F1212700257',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.9,
                                         'uptime': '660768'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '113867872218',
                                                                       'in_ucast_pkts': '90367207',
                                                                       'links': [       {       'in_octets': '113867872218',
                                                                                                'in_ucast_pkts': '90367207',
                                                                                                'out_octets': '25475107589',
                                                                                                'out_ucast_pkts': '50702193',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '25475107589',
                                                                       'out_ucast_pkts': '50702193',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDEzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '499379',
                                                                                                                                                     'distance': 7148,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '13',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4554',
                                                                       'in_octets': '25485803220',
                                                                       'in_ucast_pkts': '50707390',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '113495461528',
                                                                       'out_ucast_pkts': '90360161',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDEzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.71567916870117,
                                         'longitude': -93.40946960449219,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Savannah_Szymanski',
                                         'poller_hash': 'UzEyOEYxMjExNTAwMDEz',
                                         'serial_number': 'S128F1211500013',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.088,
                                         'uptime': '499613'},
                                 {       'elevation': 295.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '773910937027',
                                                                       'in_ucast_pkts': '696398826',
                                                                       'links': [       {       'in_octets': '773910937027',
                                                                                                'in_ucast_pkts': '696398826',
                                                                                                'out_octets': '131531096939',
                                                                                                'out_ucast_pkts': '497346328',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '131531096939',
                                                                       'out_ucast_pkts': '497346328',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTU0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '13211649',
                                                                                                                                                     'distance': 10874,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '32',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '116448',
                                                                       'in_octets': '131534569065',
                                                                       'in_ucast_pkts': '497231985',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '771260519282',
                                                                       'out_ucast_pkts': '696430566',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.66176223754883,
                                         'longitude': -93.46878051757812,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0128-001',
                                         'name': 'Steve_Brockman_46913',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMTU0',
                                         'serial_number': 'S128F1212800154',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 12.333,
                                         'uptime': '13211868'},
                                 {       'elevation': 12.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '53809661651',
                                                                       'in_ucast_pkts': '43130994',
                                                                       'links': [       {       'in_octets': '53809661651',
                                                                                                'in_ucast_pkts': '43130994',
                                                                                                'out_octets': '3517554304',
                                                                                                'out_ucast_pkts': '21470664',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3517554304',
                                                                       'out_ucast_pkts': '21470664',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '561019',
                                                                                                                                                     'distance': 10190,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5082',
                                                                       'in_octets': '3517646983',
                                                                       'in_ucast_pkts': '21465404',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '53634599610',
                                                                       'out_ucast_pkts': '43128758',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.669837951660156,
                                         'longitude': -93.45140838623047,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Heather_Sullivan',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwNTQ4',
                                         'serial_number': 'S128F1212500548',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 12.913,
                                         'uptime': '561235'},
                                 {       'elevation': 7.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '702092934',
                                                                       'in_ucast_pkts': '642830',
                                                                       'links': [       {       'in_octets': '702092934',
                                                                                                'in_ucast_pkts': '642830',
                                                                                                'out_octets': '78492505',
                                                                                                'out_ucast_pkts': '492909',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '78492505',
                                                                       'out_ucast_pkts': '492909',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTcxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '26889',
                                                                                                                                                     'distance': 14043,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '18',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '128542',
                                                                       'in_octets': '84380312351',
                                                                       'in_ucast_pkts': '539823167',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1338557309709',
                                                                       'out_ucast_pkts': '1029140427',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTcxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.634849548339844,
                                         'longitude': -93.4756088256836,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0128-001',
                                         'name': 'Jennifer_Ray_49051',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMTcx',
                                         'serial_number': 'S128F1211400171',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 12.913,
                                         'uptime': '12954419'},
                                 {       'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '666373607312',
                                                                       'in_ucast_pkts': '472455749',
                                                                       'links': [       {       'in_octets': '666373607312',
                                                                                                'in_ucast_pkts': '472455749',
                                                                                                'out_octets': '25695928166',
                                                                                                'out_ucast_pkts': '232755799',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '25695928166',
                                                                       'out_ucast_pkts': '232755799',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjM0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6128339',
                                                                                                                                                     'distance': 6994,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '17',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '53730',
                                                                       'in_octets': '25696902263',
                                                                       'in_ucast_pkts': '232699943',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '664481589399',
                                                                       'out_ucast_pkts': '472467201',
                                                                       'poller_hash': 'UzEyOEYxMjEyNTAwMjM0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.69669723510742,
                                         'longitude': -93.4757308959961,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Clayton_Corbett_50530',
                                         'poller_hash': 'UzEyOEYxMjEyNTAwMjM0',
                                         'serial_number': 'S128F1212500234',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.816,
                                         'uptime': '6128560'},
                                 {       'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '409924967218',
                                                                       'in_ucast_pkts': '311815755',
                                                                       'links': [       {       'in_octets': '409924967218',
                                                                                                'in_ucast_pkts': '311815755',
                                                                                                'out_octets': '17431373891',
                                                                                                'out_ucast_pkts': '76981758',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '17431373891',
                                                                       'out_ucast_pkts': '76981758',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMDU0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2796999',
                                                                                                                                                     'distance': 6499,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '25',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '25378',
                                                                       'in_octets': '17432430978',
                                                                       'in_ucast_pkts': '76955912',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '408655748081',
                                                                       'out_ucast_pkts': '311802886',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMDU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.70980453491211,
                                         'longitude': -93.42867279052734,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0128-001',
                                         'name': 'Danita_Bittle',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMDU0',
                                         'serial_number': 'S128F1212800054',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 16.629,
                                         'uptime': '2797346'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '242352872853',
                                                                       'in_ucast_pkts': '176246456',
                                                                       'links': [       {       'in_octets': '242352872853',
                                                                                                'in_ucast_pkts': '176246456',
                                                                                                'out_octets': '12424890198',
                                                                                                'out_ucast_pkts': '59148886',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '12424890198',
                                                                       'out_ucast_pkts': '59148886',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTgxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '670589',
                                                                                                                                                     'distance': 9359,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '13',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11255',
                                                                       'in_octets': '12425028667',
                                                                       'in_ucast_pkts': '59137467',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '241649723785',
                                                                       'out_ucast_pkts': '176245541',
                                                                       'poller_hash': 'UzEyOEYxMjEyODAwMTgxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.67723083496094,
                                         'longitude': -93.45409393310547,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0128-001',
                                         'name': 'Rose_Martin_49117',
                                         'poller_hash': 'UzEyOEYxMjEyODAwMTgx',
                                         'serial_number': 'S128F1212800181',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.526,
                                         'uptime': '670938'},
                                 {       'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '10051144497',
                                                                       'in_ucast_pkts': '8820136',
                                                                       'links': [       {       'in_octets': '10051144497',
                                                                                                'in_ucast_pkts': '8820136',
                                                                                                'out_octets': '2733726156',
                                                                                                'out_ucast_pkts': '6875524',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2733726156',
                                                                       'out_ucast_pkts': '6875524',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTMyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '589919',
                                                                                                                                                     'distance': 2144,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5321',
                                                                       'in_octets': '2733846174',
                                                                       'in_ucast_pkts': '6870038',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '10016733287',
                                                                       'out_ucast_pkts': '8820741',
                                                                       'poller_hash': 'UzEyOEYxMjExNDAwMTMyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.742218017578125,
                                         'longitude': -93.47102355957031,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0128-001',
                                         'name': 'Angie_Kroeger',
                                         'poller_hash': 'UzEyOEYxMjExNDAwMTMy',
                                         'serial_number': 'S128F1211400132',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 10.243,
                                         'uptime': '590142'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '471906591144',
                                                                       'in_ucast_pkts': '318549251',
                                                                       'links': [       {       'in_octets': '471906591144',
                                                                                                'in_ucast_pkts': '318549251',
                                                                                                'out_octets': '13864498472',
                                                                                                'out_ucast_pkts': '152388342',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '13864498472',
                                                                       'out_ucast_pkts': '152388342',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '517679',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '382',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14623',
                                                                       'in_octets': '13865693161',
                                                                       'in_ucast_pkts': '152374767',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '470629734193',
                                                                       'out_ucast_pkts': '318548562',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.733699798583984,
                                         'longitude': -93.48733520507812,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0150-001',
                                         'name': 'Dustin_Draper_47015',
                                         'poller_hash': 'UzE1MEYyMjI0MTI1NTk1',
                                         'serial_number': 'S150F2224125595',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.352,
                                         'uptime': '517916'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '90793124384',
                                                                       'in_ucast_pkts': '72503965',
                                                                       'links': [       {       'in_octets': '90793124384',
                                                                                                'in_ucast_pkts': '72503965',
                                                                                                'out_octets': '15247110856',
                                                                                                'out_ucast_pkts': '57147321',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '15247110856',
                                                                       'out_ucast_pkts': '57147321',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NjAxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '692229',
                                                                                                                                                     'distance': 9272,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '55675',
                                                                       'in_errors': '50038',
                                                                       'in_nucast_pkts': '6276',
                                                                       'in_octets': '15317417462',
                                                                       'in_ucast_pkts': '57211466',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '90501473019',
                                                                       'out_ucast_pkts': '72503428',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NjAxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.6778564453125,
                                         'longitude': -93.47520446777344,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0150-001',
                                         'name': 'Larry_Soles_49451',
                                         'poller_hash': 'UzE1MEYyMjI0MTI1NjAx',
                                         'serial_number': 'S150F2224125601',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.088,
                                         'uptime': '692493'},
                                 {       'elevation': 25.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '82589886935',
                                                                       'in_ucast_pkts': '56608704',
                                                                       'links': [       {       'in_octets': '82589886935',
                                                                                                'in_ucast_pkts': '56608704',
                                                                                                'out_octets': '2038966760',
                                                                                                'out_ucast_pkts': '16098680',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2038966760',
                                                                       'out_ucast_pkts': '16098680',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDcyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '569469',
                                                                                                                                                     'distance': 6492,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5255',
                                                                       'in_octets': '2039116077',
                                                                       'in_ucast_pkts': '16093389',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '82363060257',
                                                                       'out_ucast_pkts': '56608690',
                                                                       'poller_hash': 'UzEyOEYxMjExNTAwMDcyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.71841812133789,
                                         'longitude': -93.4135971069336,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0128-001',
                                         'name': 'Carla_Childers',
                                         'poller_hash': 'UzEyOEYxMjExNTAwMDcy',
                                         'serial_number': 'S128F1211500072',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 15.004,
                                         'uptime': '569981'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '48388445836',
                                                                       'in_ucast_pkts': '38263708',
                                                                       'links': [       {       'in_octets': '48388445836',
                                                                                                'in_ucast_pkts': '38263708',
                                                                                                'out_octets': '5264949395',
                                                                                                'out_ucast_pkts': '25847714',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5264949395',
                                                                       'out_ucast_pkts': '25847714',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk5MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '662599',
                                                                                                                                                     'distance': 3711,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDAzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '31',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5955',
                                                                       'in_octets': '5260006478',
                                                                       'in_ucast_pkts': '25836805',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '48233678231',
                                                                       'out_ucast_pkts': '38263311',
                                                                       'poller_hash': 'UzE1MEYyMjI0MTI1NTk5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.728084564208984,
                                         'longitude': -93.47294616699219,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0150-001',
                                         'name': 'Wesley_White_49956',
                                         'poller_hash': 'UzE1MEYyMjI0MTI1NTk5',
                                         'serial_number': 'S150F2224125599',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 13.784,
                                         'uptime': '662804'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0134_001_0_988_004_00_10_100_8_14(self):
        obj = self.run_data("tarana.tarana.30-0134-001.0.988.004.00.10_100_8_14")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 3,
                'sw_version': '0.988.004.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F1211300017',
                'system_mac_address': '04:f1:7d:00:25:eb',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:00:23:b0': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 2556,
                                             'dl_rf_packets': 14,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:23:b0',
                                             'name': '03-WALTON_COUNTY_COURT_HOUSE-FREE-R',
                                             'serial_number': 'S128F1211800086',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3084441,
                                             'ul_rf_packets': 35078},
                '04:f1:7d:00:28:bd': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 23066481102,
                                             'dl_rf_packets': 25536783,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:28:bd',
                                             'name': '1074-GUARDIAN_AD_LITEM-FREE-R',
                                             'serial_number': 'S128F1211600018',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 2040239347,
                                             'ul_rf_packets': 15781673},
                '04:f1:7d:00:29:1a': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 15173457732,
                                             'dl_rf_packets': 10824924,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:29:1a',
                                             'name': '810-BETH_MOONEY-RES25-R',
                                             'serial_number': 'S128F1211600118',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 762375140,
                                             'ul_rf_packets': 7370516}
        }
        exp_ne_msg = {
                'data': {       'cpu': 30.954504,
                                'elevation': 123.159,
                                'gps_sats_tracked': 14,
                                'height': 45.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '599',
                                                                                       'in_octets': '3084441',
                                                                                       'in_ucast_pkts': '35078',
                                                                                       'out_errors': '2695',
                                                                                       'out_octets': '2556',
                                                                                       'out_ucast_pkts': '14',
                                                                                       'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ=='},
                                                                               {       'in_errors': '300',
                                                                                       'in_octets': '2040239347',
                                                                                       'in_ucast_pkts': '15781673',
                                                                                       'out_errors': '117511',
                                                                                       'out_octets': '23066481102',
                                                                                       'out_ucast_pkts': '25536783',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ=='},
                                                                               {       'in_errors': '73024',
                                                                                       'in_octets': '762375140',
                                                                                       'in_ucast_pkts': '7370516',
                                                                                       'out_errors': '543609',
                                                                                       'out_octets': '15173457732',
                                                                                       'out_ucast_pkts': '10824924',
                                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5755,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '140076',
                                                                                                                                            'distance': 716,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ=='},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 636,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ=='},
                                                                                                                                    {       'connected_time': '140066',
                                                                                                                                            'distance': 1092,
                                                                                                                                            'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '54',
                                                              'out_octets': '4148',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3Z2kx'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '9',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '414291',
                                                              'in_octets': '38381328754',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '63264',
                                                              'out_octets': '4626724732',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3ZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYxMjExMzAwMDE3ZXgy'}],
                                'latitude': 30.71991539001465,
                                'longitude': -86.11815643310547,
                                'manufacturer': 'Tarana',
                                'mem': 2.1208909,
                                'model': '30-0134-001',
                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3',
                                'serial_number': 'S134F1211300017',
                                'sw_version': '0.988.004.00',
                                'system_mac_address': '04:f1:7d:00:25:eb',
                                'temperature': 51.25,
                                'uptime': '140409'},
                'peers': [       {       'elevation': 15.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2556',
                                                                       'in_ucast_pkts': '14',
                                                                       'links': [       {       'in_octets': '2556',
                                                                                                'in_ucast_pkts': '14',
                                                                                                'out_octets': '3084441',
                                                                                                'out_ucast_pkts': '35078',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3084441',
                                                                       'out_ucast_pkts': '35078',
                                                                       'poller_hash': 'UzEyOEYxMjExODAwMDg2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140076',
                                                                                                                                                     'distance': 716,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '35153',
                                                                       'in_octets': '3116843',
                                                                       'in_ucast_pkts': '10',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '34120',
                                                                       'out_ucast_pkts': '399',
                                                                       'poller_hash': 'UzEyOEYxMjExODAwMDg2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.721792221069336,
                                         'longitude': -86.11119842529297,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0128-001',
                                         'name': '03-WALTON_COUNTY_COURT_HOUSE-FREE-R',
                                         'poller_hash': 'UzEyOEYxMjExODAwMDg2',
                                         'serial_number': 'S128F1211800086',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:23:b0',
                                         'temperature': 24.293,
                                         'uptime': '140430'},
                                 {       'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '23066481102',
                                                                       'in_ucast_pkts': '25536783',
                                                                       'links': [       {       'in_octets': '23066481102',
                                                                                                'in_ucast_pkts': '25536783',
                                                                                                'out_octets': '2040239347',
                                                                                                'out_ucast_pkts': '15781673',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2040239347',
                                                                       'out_ucast_pkts': '15781673',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDE4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 636,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2159583',
                                                                       'in_octets': '63082667566',
                                                                       'in_ucast_pkts': '362354881',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '578988164771',
                                                                       'out_ucast_pkts': '614897955',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMDE4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.720535278320312,
                                         'longitude': -86.11167907714844,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.816118,
                                         'model': '30-0128-001',
                                         'name': '1074-GUARDIAN_AD_LITEM-FREE-R',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMDE4',
                                         'serial_number': 'S128F1211600018',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:28:bd',
                                         'temperature': 23.887,
                                         'uptime': '8632580'},
                                 {       'elevation': 2.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15173457732',
                                                                       'in_ucast_pkts': '10824924',
                                                                       'links': [       {       'in_octets': '15173457732',
                                                                                                'in_ucast_pkts': '10824924',
                                                                                                'out_octets': '762375140',
                                                                                                'out_ucast_pkts': '7370516',
                                                                                                'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '762375140',
                                                                       'out_ucast_pkts': '7370516',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTE4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '140066',
                                                                                                                                                     'distance': 1092,
                                                                                                                                                     'poller_hash': 'UzEzNEYxMjExMzAwMDE3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14197',
                                                                       'in_octets': '1600579939',
                                                                       'in_ucast_pkts': '14522302',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '29794304713',
                                                                       'out_ucast_pkts': '21375281',
                                                                       'poller_hash': 'UzEyOEYxMjExNjAwMTE4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.716629028320312,
                                         'longitude': -86.10767364501953,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0128-001',
                                         'name': '810-BETH_MOONEY-RES25-R',
                                         'poller_hash': 'UzEyOEYxMjExNjAwMTE4',
                                         'serial_number': 'S128F1211600118',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:29:1a',
                                         'temperature': 26.616,
                                         'uptime': '275381'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0134_001_0_997_028_00_10_11_240_91(self):
        obj = self.run_data("tarana.tarana.30-0134-001.0.997.028.00.10_11_240_91")
        exp_info = {
                'model': '30-0134-001',
                'sta_count': 3,
                'sw_version': '0.997.028.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S134F2224809083',
                'system_mac_address': '04:f1:7d:01:4e:3a',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:01:20:4a': {       'dev_macs': None,
                                             'dl_link_rate': 113514167,
                                             'dl_rf_bytes': 51844262121,
                                             'dl_rf_packets': 40922953,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:20:4a',
                                             'name': '11232-RMX6',
                                             'serial_number': 'S150F2224402665',
                                             'system_mac_address': None,
                                             'ul_link_rate': 65950133,
                                             'ul_rf_bytes': 3394798411,
                                             'ul_rf_packets': 17435256},
                '04:f1:7d:01:88:39': {       'dev_macs': None,
                                             'dl_link_rate': 567568187,
                                             'dl_rf_bytes': 22357725769,
                                             'dl_rf_packets': 18157047,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:88:39',
                                             'name': '7904-CED5',
                                             'serial_number': 'S150F2230121277',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142340679,
                                             'ul_rf_bytes': 2624678709,
                                             'ul_rf_packets': 10539180},
                '04:f1:7d:03:59:04': {       'dev_macs': None,
                                             'dl_link_rate': 251897999,
                                             'dl_rf_bytes': 15499814885,
                                             'dl_rf_packets': 15062937,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:03:59:04',
                                             'name': '12833-RMX33',
                                             'serial_number': 'S150F2232417671',
                                             'system_mac_address': None,
                                             'ul_link_rate': 86245054,
                                             'ul_rf_bytes': 8202864435,
                                             'ul_rf_packets': 10067820}
        }
        exp_ne_msg = {
                'data': {       'cpu': 18.495779,
                                'elevation': 1910.963,
                                'gps_sats_tracked': 21,
                                'height': 0.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '253329',
                                                                                       'in_octets': '8202864435',
                                                                                       'in_ucast_pkts': '10067820',
                                                                                       'out_errors': '877516',
                                                                                       'out_octets': '15499814885',
                                                                                       'out_ucast_pkts': '15062937',
                                                                                       'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ=='},
                                                                               {       'in_errors': '78439',
                                                                                       'in_octets': '2624678709',
                                                                                       'in_ucast_pkts': '10539180',
                                                                                       'out_errors': '282618',
                                                                                       'out_octets': '22357725769',
                                                                                       'out_ucast_pkts': '18157047',
                                                                                       'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ=='},
                                                                               {       'in_errors': '331847',
                                                                                       'in_octets': '3394798411',
                                                                                       'in_ucast_pkts': '17435256',
                                                                                       'out_errors': '1193471',
                                                                                       'out_octets': '51844262121',
                                                                                       'out_ucast_pkts': '40922953',
                                                                                       'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 80,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5795,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1087824',
                                                                                                                                            'distance': 2566,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ==',
                                                                                                                                            'rx_link_rate': '86245054',
                                                                                                                                            'tx_link_rate': '251897999'},
                                                                                                                                    {       'connected_time': '334255',
                                                                                                                                            'distance': 221,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ==',
                                                                                                                                            'rx_link_rate': '142340679',
                                                                                                                                            'tx_link_rate': '567568187'},
                                                                                                                                    {       'connected_time': '172444',
                                                                                                                                            'distance': 1400,
                                                                                                                                            'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ==',
                                                                                                                                            'rx_link_rate': '65950133',
                                                                                                                                            'tx_link_rate': '113514167'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzZ2kx'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzZXgy'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '142',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '194187132',
                                                              'in_octets': '2782358419665',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '637560',
                                                              'out_octets': '381883912609',
                                                              'poller_hash': 'UzEzNEYyMjI0ODA5MDgzZXgx',
                                                              'speed': '10000000000'}],
                                'latitude': 40.512184143066406,
                                'longitude': -107.54761505126953,
                                'manufacturer': 'Tarana',
                                'mem': 1.7497349,
                                'model': '30-0134-001',
                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgz',
                                'serial_number': 'S134F2224809083',
                                'sw_version': '0.997.028.00',
                                'system_mac_address': '04:f1:7d:01:4e:3a',
                                'temperature': 50.641,
                                'uptime': '6760237'},
                'peers': [       {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15499814885',
                                                                       'in_ucast_pkts': '15062937',
                                                                       'links': [       {       'in_octets': '15499814885',
                                                                                                'in_ucast_pkts': '15062937',
                                                                                                'out_octets': '8202864435',
                                                                                                'out_ucast_pkts': '10067820',
                                                                                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8202864435',
                                                                       'out_ucast_pkts': '10067820',
                                                                       'poller_hash': 'UzE1MEYyMjMyNDE3NjcxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 80,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '251897999',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1087824',
                                                                                                                                                     'distance': 2566,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rx_link_rate': '251897999',
                                                                                                                                                     'tx_link_rate': '86245054'}]}],
                                                                                                 'tx_link_rate': '86245054'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '225',
                                                                       'in_octets': '8202921099',
                                                                       'in_ucast_pkts': '10067273',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '15868314258',
                                                                       'out_ucast_pkts': '15316198',
                                                                       'poller_hash': 'UzE1MEYyMjMyNDE3NjcxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 40.5145378112793,
                                         'longitude': -107.57792663574219,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.3620886,
                                         'model': '30-0150-001',
                                         'name': '12833-RMX33',
                                         'poller_hash': 'UzE1MEYyMjMyNDE3Njcx',
                                         'serial_number': 'S150F2232417671',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.997.028.00',
                                         'system_mac_address': '04:f1:7d:03:59:04',
                                         'temperature': 28.416,
                                         'uptime': '1088178'},
                                 {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '22357725769',
                                                                       'in_ucast_pkts': '18157047',
                                                                       'links': [       {       'in_octets': '22357725769',
                                                                                                'in_ucast_pkts': '18157047',
                                                                                                'out_octets': '2624678709',
                                                                                                'out_ucast_pkts': '10539180',
                                                                                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2624678709',
                                                                       'out_ucast_pkts': '10539180',
                                                                       'poller_hash': 'UzE1MEYyMjMwMTIxMjc3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 80,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '567568187',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '334255',
                                                                                                                                                     'distance': 221,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rx_link_rate': '567568187',
                                                                                                                                                     'tx_link_rate': '142340679'}]}],
                                                                                                 'tx_link_rate': '142340679'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1009',
                                                                       'in_octets': '2625096890',
                                                                       'in_ucast_pkts': '10539296',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '22470841269',
                                                                       'out_ucast_pkts': '18234590',
                                                                       'poller_hash': 'UzE1MEYyMjMwMTIxMjc3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 40.51382827758789,
                                         'longitude': -107.54873657226562,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.3620886,
                                         'model': '30-0150-001',
                                         'name': '7904-CED5',
                                         'poller_hash': 'UzE1MEYyMjMwMTIxMjc3',
                                         'serial_number': 'S150F2230121277',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.997.028.00',
                                         'system_mac_address': '04:f1:7d:01:88:39',
                                         'temperature': 26.964,
                                         'uptime': '335424'},
                                 {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '51844262121',
                                                                       'in_ucast_pkts': '40922953',
                                                                       'links': [       {       'in_octets': '51844262121',
                                                                                                'in_ucast_pkts': '40922953',
                                                                                                'out_octets': '3394798411',
                                                                                                'out_ucast_pkts': '17435256',
                                                                                                'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3394798411',
                                                                       'out_ucast_pkts': '17435256',
                                                                       'poller_hash': 'UzE1MEYyMjI0NDAyNjY1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 80,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5795,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '113514167',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '172444',
                                                                                                                                                     'distance': 1400,
                                                                                                                                                     'poller_hash': 'UzEzNEYyMjI0ODA5MDgzd2wx',
                                                                                                                                                     'rx_link_rate': '113514167',
                                                                                                                                                     'tx_link_rate': '65950133'}]}],
                                                                                                 'tx_link_rate': '65950133'}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '9321',
                                                                       'in_octets': '3394940888',
                                                                       'in_ucast_pkts': '17426670',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '51901315378',
                                                                       'out_ucast_pkts': '40962312',
                                                                       'poller_hash': 'UzE1MEYyMjI0NDAyNjY1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 40.521949768066406,
                                         'longitude': -107.55876159667969,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.3620886,
                                         'model': '30-0150-001',
                                         'name': '11232-RMX6',
                                         'poller_hash': 'UzE1MEYyMjI0NDAyNjY1',
                                         'serial_number': 'S150F2224402665',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.997.028.00',
                                         'system_mac_address': '04:f1:7d:01:20:4a',
                                         'temperature': 28.822,
                                         'uptime': '172760'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_977_016_00_10_135_112_131(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.977.016.00.10_135_112_131")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 25,
                'sw_version': '0.977.016.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2221600607',
                'system_mac_address': None,
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                'S142F1214600005': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 10541395,
                                           'dl_rf_packets': 20044,
                                           'ip_address': None,
                                           'name': 'Raubach_Randy_7106',
                                           'serial': 'S142F1214600005',
                                           'serial_number': 'S142F1214600005',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 3206124,
                                           'ul_rf_packets': 19571},
                'S142F1214700097': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 64307864850,
                                           'dl_rf_packets': 50335423,
                                           'ip_address': None,
                                           'name': 'Matthew_wolfe_20005',
                                           'serial': 'S142F1214700097',
                                           'serial_number': 'S142F1214700097',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6755180685,
                                           'ul_rf_packets': 27317079},
                'S142F2221006740': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 15656880292,
                                           'dl_rf_packets': 13193016,
                                           'ip_address': None,
                                           'name': 'Admas_Williams',
                                           'serial': 'S142F2221006740',
                                           'serial_number': 'S142F2221006740',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2526462376,
                                           'ul_rf_packets': 10922741},
                'S142F2221202151': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 49622064821,
                                           'dl_rf_packets': 38667699,
                                           'ip_address': None,
                                           'name': 'Sharon_Pulliam',
                                           'serial': 'S142F2221202151',
                                           'serial_number': 'S142F2221202151',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2388727454,
                                           'ul_rf_packets': 15395613},
                'S142F2221202454': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 3165611194,
                                           'dl_rf_packets': 2983445,
                                           'ip_address': None,
                                           'name': 'Vernon_Dotson',
                                           'serial': 'S142F2221202454',
                                           'serial_number': 'S142F2221202454',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 443224473,
                                           'ul_rf_packets': 2226695},
                'S142F2221205997': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 217187438084,
                                           'dl_rf_packets': 146838753,
                                           'ip_address': None,
                                           'name': 'Janet_Ronchetto',
                                           'serial': 'S142F2221205997',
                                           'serial_number': 'S142F2221205997',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7297249822,
                                           'ul_rf_packets': 83954413},
                'S142F2221301987': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 142236663613,
                                           'dl_rf_packets': 101956515,
                                           'ip_address': None,
                                           'name': 'Stephanie_Bennett_13698',
                                           'serial': 'S142F2221301987',
                                           'serial_number': 'S142F2221301987',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6096513066,
                                           'ul_rf_packets': 55390254},
                'S142F2221400006': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 178741237195,
                                           'dl_rf_packets': 133683367,
                                           'ip_address': None,
                                           'name': 'Carla_Pulliam_7166HQ',
                                           'serial': 'S142F2221400006',
                                           'serial_number': 'S142F2221400006',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 26870197927,
                                           'ul_rf_packets': 65794059},
                'S142F2221400012': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 761039,
                                           'dl_rf_packets': 1731,
                                           'ip_address': None,
                                           'name': 'Richard_Cremer',
                                           'serial': 'S142F2221400012',
                                           'serial_number': 'S142F2221400012',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 546742,
                                           'ul_rf_packets': 1744},
                'S142F2221805235': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 53858265770,
                                           'dl_rf_packets': 40520225,
                                           'ip_address': None,
                                           'name': 'Bryan_Salina',
                                           'serial': 'S142F2221805235',
                                           'serial_number': 'S142F2221805235',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 3739258867,
                                           'ul_rf_packets': 18054637},
                'S142F2221805255': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 1426540191,
                                           'dl_rf_packets': 1308455,
                                           'ip_address': None,
                                           'name': 'Casey_Melissa_17432',
                                           'serial': 'S142F2221805255',
                                           'serial_number': 'S142F2221805255',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 147704358,
                                           'ul_rf_packets': 563327},
                'S142F2221805302': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 70337594941,
                                           'dl_rf_packets': 51919282,
                                           'ip_address': None,
                                           'name': 'Harkins_Jerry_7202',
                                           'serial': 'S142F2221805302',
                                           'serial_number': 'S142F2221805302',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6716455094,
                                           'ul_rf_packets': 30844468},
                'S142F2221805317': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 43577557139,
                                           'dl_rf_packets': 30695429,
                                           'ip_address': None,
                                           'name': 'marie_craig_9508',
                                           'serial': 'S142F2221805317',
                                           'serial_number': 'S142F2221805317',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2412734823,
                                           'ul_rf_packets': 23550751},
                'S142F2221805326': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 81050819557,
                                           'dl_rf_packets': 61498541,
                                           'ip_address': None,
                                           'name': 'Ryan_Eaton',
                                           'serial': 'S142F2221805326',
                                           'serial_number': 'S142F2221805326',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6136387794,
                                           'ul_rf_packets': 30179221},
                'S142F2221805333': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 236310526669,
                                           'dl_rf_packets': 159734063,
                                           'ip_address': None,
                                           'name': 'Jacy_Page',
                                           'serial': 'S142F2221805333',
                                           'serial_number': 'S142F2221805333',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 10266717522,
                                           'ul_rf_packets': 106710238},
                'S142F2221805353': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 42309368327,
                                           'dl_rf_packets': 32414335,
                                           'ip_address': None,
                                           'name': 'Becky_Clay',
                                           'serial': 'S142F2221805353',
                                           'serial_number': 'S142F2221805353',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2899415558,
                                           'ul_rf_packets': 21577750},
                'S142F2222203668': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 66000619011,
                                           'dl_rf_packets': 51158308,
                                           'ip_address': None,
                                           'name': 'John.Odle',
                                           'serial': 'S142F2222203668',
                                           'serial_number': 'S142F2222203668',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7113663389,
                                           'ul_rf_packets': 30132741},
                'S142F2222205276': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 85678777250,
                                           'dl_rf_packets': 61728674,
                                           'ip_address': None,
                                           'name': 'Kearney_Ashley',
                                           'serial': 'S142F2222205276',
                                           'serial_number': 'S142F2222205276',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 4382786706,
                                           'ul_rf_packets': 20278567},
                'S142F2222205577': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 59906290788,
                                           'dl_rf_packets': 42209178,
                                           'ip_address': None,
                                           'name': 'Kim_Cabaness',
                                           'serial': 'S142F2222205577',
                                           'serial_number': 'S142F2222205577',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1968421908,
                                           'ul_rf_packets': 16765697},
                'S142F2222807390': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 53691680803,
                                           'dl_rf_packets': 46120274,
                                           'ip_address': None,
                                           'name': 'jason_adams',
                                           'serial': 'S142F2222807390',
                                           'serial_number': 'S142F2222807390',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 8165532458,
                                           'ul_rf_packets': 29840895},
                'S142F2223100340': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 54200145085,
                                           'dl_rf_packets': 39677626,
                                           'ip_address': None,
                                           'name': 'Kenneth_Martinsen_13662HQ',
                                           'serial': 'S142F2223100340',
                                           'serial_number': 'S142F2223100340',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2675496251,
                                           'ul_rf_packets': 20933604},
                'S142F2223305916': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 87075149115,
                                           'dl_rf_packets': 64018083,
                                           'ip_address': None,
                                           'name': 'Elijah_Murphey',
                                           'serial': 'S142F2223305916',
                                           'serial_number': 'S142F2223305916',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 4637538241,
                                           'ul_rf_packets': 46564740},
                'S142F2223500125': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 4036644188,
                                           'dl_rf_packets': 3039365,
                                           'ip_address': None,
                                           'name': 'Lauren_Taylor',
                                           'serial': 'S142F2223500125',
                                           'serial_number': 'S142F2223500125',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 282078049,
                                           'ul_rf_packets': 1977449},
                'S142F2223501032': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 52721218288,
                                           'dl_rf_packets': 44128037,
                                           'ip_address': None,
                                           'name': 'Jerry_Suspinac',
                                           'serial': 'S142F2223501032',
                                           'serial_number': 'S142F2223501032',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7449750477,
                                           'ul_rf_packets': 28830272},
                'S142F2223800692': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 9378763869,
                                           'dl_rf_packets': 7637159,
                                           'ip_address': None,
                                           'name': 'MUTCHEK.JOHN',
                                           'serial': 'S142F2223800692',
                                           'serial_number': 'S142F2223800692',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 849338425,
                                           'ul_rf_packets': 4147433}
        }
        exp_ne_msg = {
                'data': {       'cpu': 53.554134,
                                'elevation': 220.677,
                                'gps_sats_tracked': 18,
                                'height': 290.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '1184660',
                                                                                       'in_octets': '2412734823',
                                                                                       'in_ucast_pkts': '23550751',
                                                                                       'out_errors': '738703',
                                                                                       'out_octets': '43577557139',
                                                                                       'out_ucast_pkts': '30695429',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzE3MQ=='},
                                                                               {       'in_errors': '182864',
                                                                                       'in_octets': '1968421908',
                                                                                       'in_ucast_pkts': '16765697',
                                                                                       'out_errors': '651047',
                                                                                       'out_octets': '59906290788',
                                                                                       'out_ucast_pkts': '42209178',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTc3MQ=='},
                                                                               {       'in_errors': '520469',
                                                                                       'in_octets': '4637538241',
                                                                                       'in_ucast_pkts': '46564740',
                                                                                       'out_errors': '2567673',
                                                                                       'out_octets': '87075149115',
                                                                                       'out_ucast_pkts': '64018083',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMzA1OTE2MQ=='},
                                                                               {       'in_errors': '469806',
                                                                                       'in_octets': '7113663389',
                                                                                       'in_ucast_pkts': '30132741',
                                                                                       'out_errors': '2346140',
                                                                                       'out_octets': '66000619011',
                                                                                       'out_ucast_pkts': '51158308',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNjY4MQ=='},
                                                                               {       'in_errors': '742592',
                                                                                       'in_octets': '4382786706',
                                                                                       'in_ucast_pkts': '20278567',
                                                                                       'out_errors': '3728832',
                                                                                       'out_octets': '85678777250',
                                                                                       'out_ucast_pkts': '61728674',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2MQ=='},
                                                                               {       'in_errors': '556906',
                                                                                       'in_octets': '6136387794',
                                                                                       'in_ucast_pkts': '30179221',
                                                                                       'out_errors': '2571804',
                                                                                       'out_octets': '81050819557',
                                                                                       'out_ucast_pkts': '61498541',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzI2MQ=='},
                                                                               {       'in_errors': '543432',
                                                                                       'in_octets': '3739258867',
                                                                                       'in_ucast_pkts': '18054637',
                                                                                       'out_errors': '2697299',
                                                                                       'out_octets': '53858265770',
                                                                                       'out_ucast_pkts': '40520225',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjM1MQ=='},
                                                                               {       'in_errors': '312397',
                                                                                       'in_octets': '8165532458',
                                                                                       'in_ucast_pkts': '29840895',
                                                                                       'out_errors': '561561',
                                                                                       'out_octets': '53691680803',
                                                                                       'out_ucast_pkts': '46120274',
                                                                                       'poller_hash': 'UzE0MkYyMjIyODA3MzkwMQ=='},
                                                                               {       'in_errors': '24064',
                                                                                       'in_octets': '282078049',
                                                                                       'in_ucast_pkts': '1977449',
                                                                                       'out_errors': '122309',
                                                                                       'out_octets': '4036644188',
                                                                                       'out_ucast_pkts': '3039365',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTI1MQ=='},
                                                                               {       'in_errors': '807',
                                                                                       'in_octets': '546742',
                                                                                       'in_ucast_pkts': '1744',
                                                                                       'out_errors': '1863',
                                                                                       'out_octets': '761039',
                                                                                       'out_ucast_pkts': '1731',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDEyMQ=='},
                                                                               {       'in_errors': '1317787',
                                                                                       'in_octets': '6716455094',
                                                                                       'in_ucast_pkts': '30844468',
                                                                                       'out_errors': '1349514',
                                                                                       'out_octets': '70337594941',
                                                                                       'out_ucast_pkts': '51919282',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzAyMQ=='},
                                                                               {       'in_errors': '57899',
                                                                                       'in_octets': '849338425',
                                                                                       'in_ucast_pkts': '4147433',
                                                                                       'out_errors': '292426',
                                                                                       'out_octets': '9378763869',
                                                                                       'out_ucast_pkts': '7637159',
                                                                                       'poller_hash': 'UzE0MkYyMjIzODAwNjkyMQ=='},
                                                                               {       'in_errors': '248411',
                                                                                       'in_octets': '7449750477',
                                                                                       'in_ucast_pkts': '28830272',
                                                                                       'out_errors': '25172',
                                                                                       'out_octets': '52721218288',
                                                                                       'out_ucast_pkts': '44128037',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNTAxMDMyMQ=='},
                                                                               {       'in_errors': '162484',
                                                                                       'in_octets': '2526462376',
                                                                                       'in_ucast_pkts': '10922741',
                                                                                       'out_errors': '772221',
                                                                                       'out_octets': '15656880292',
                                                                                       'out_ucast_pkts': '13193016',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMDA2NzQwMQ=='},
                                                                               {       'in_errors': '1244854',
                                                                                       'in_octets': '6096513066',
                                                                                       'in_ucast_pkts': '55390254',
                                                                                       'out_errors': '5652260',
                                                                                       'out_octets': '142236663613',
                                                                                       'out_ucast_pkts': '101956515',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMzAxOTg3MQ=='},
                                                                               {       'in_errors': '203715',
                                                                                       'in_octets': '2899415558',
                                                                                       'in_ucast_pkts': '21577750',
                                                                                       'out_errors': '567864',
                                                                                       'out_octets': '42309368327',
                                                                                       'out_ucast_pkts': '32414335',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzUzMQ=='},
                                                                               {       'in_errors': '399283',
                                                                                       'in_octets': '6755180685',
                                                                                       'in_ucast_pkts': '27317079',
                                                                                       'out_errors': '1718427',
                                                                                       'out_octets': '64307864850',
                                                                                       'out_ucast_pkts': '50335423',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDk3MQ=='},
                                                                               {       'in_errors': '1841907',
                                                                                       'in_octets': '26870197927',
                                                                                       'in_ucast_pkts': '65794059',
                                                                                       'out_errors': '8016163',
                                                                                       'out_octets': '178741237195',
                                                                                       'out_ucast_pkts': '133683367',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDA2MQ=='},
                                                                               {       'in_errors': '1195738',
                                                                                       'in_octets': '7297249822',
                                                                                       'in_ucast_pkts': '83954413',
                                                                                       'out_errors': '5641653',
                                                                                       'out_octets': '217187438084',
                                                                                       'out_ucast_pkts': '146838753',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMjA1OTk3MQ=='},
                                                                               {       'in_errors': '796699',
                                                                                       'in_octets': '10266717522',
                                                                                       'in_ucast_pkts': '106710238',
                                                                                       'out_errors': '3784752',
                                                                                       'out_octets': '236310526669',
                                                                                       'out_ucast_pkts': '159734063',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzMzMQ=='},
                                                                               {       'in_errors': '369132',
                                                                                       'in_octets': '2388727454',
                                                                                       'in_ucast_pkts': '15395613',
                                                                                       'out_errors': '1840888',
                                                                                       'out_octets': '49622064821',
                                                                                       'out_ucast_pkts': '38667699',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyMTUxMQ=='},
                                                                               {       'in_errors': '2243',
                                                                                       'in_octets': '3206124',
                                                                                       'in_ucast_pkts': '19571',
                                                                                       'out_errors': '5508',
                                                                                       'out_octets': '10541395',
                                                                                       'out_ucast_pkts': '20044',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDA1MQ=='},
                                                                               {       'in_errors': '26674',
                                                                                       'in_octets': '147704358',
                                                                                       'in_ucast_pkts': '563327',
                                                                                       'out_errors': '86317',
                                                                                       'out_octets': '1426540191',
                                                                                       'out_ucast_pkts': '1308455',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU1MQ=='},
                                                                               {       'in_errors': '100714',
                                                                                       'in_octets': '443224473',
                                                                                       'in_ucast_pkts': '2226695',
                                                                                       'out_errors': '339977',
                                                                                       'out_octets': '3165611194',
                                                                                       'out_ucast_pkts': '2983445',
                                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyNDU0MQ=='},
                                                                               {       'in_errors': '326596',
                                                                                       'in_octets': '2675496251',
                                                                                       'in_ucast_pkts': '20933604',
                                                                                       'out_errors': '1411445',
                                                                                       'out_octets': '54200145085',
                                                                                       'out_ucast_pkts': '39677626',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwMzQwMQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3570,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '447298',
                                                                                                                                            'distance': 11034,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzE3MQ=='},
                                                                                                                                    {       'connected_time': '447248',
                                                                                                                                            'distance': 7296,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NTc3MQ=='},
                                                                                                                                    {       'connected_time': '447198',
                                                                                                                                            'distance': 6251,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMzA1OTE2MQ=='},
                                                                                                                                    {       'connected_time': '447248',
                                                                                                                                            'distance': 7303,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAzNjY4MQ=='},
                                                                                                                                    {       'connected_time': '447148',
                                                                                                                                            'distance': 1922,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2MQ=='},
                                                                                                                                    {       'connected_time': '447148',
                                                                                                                                            'distance': 2505,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzI2MQ=='},
                                                                                                                                    {       'connected_time': '447148',
                                                                                                                                            'distance': 2398,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjM1MQ=='},
                                                                                                                                    {       'connected_time': '447198',
                                                                                                                                            'distance': 7148,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyODA3MzkwMQ=='},
                                                                                                                                    {       'connected_time': '165898',
                                                                                                                                            'distance': 11852,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAwMTI1MQ=='},
                                                                                                                                    {       'connected_time': '1756',
                                                                                                                                            'distance': 7584,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNDAwMDEyMQ=='},
                                                                                                                                    {       'connected_time': '409048',
                                                                                                                                            'distance': 11061,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzAyMQ=='},
                                                                                                                                    {       'connected_time': '390756',
                                                                                                                                            'distance': 7584,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzODAwNjkyMQ=='},
                                                                                                                                    {       'connected_time': '390756',
                                                                                                                                            'distance': 4093,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAxMDMyMQ=='},
                                                                                                                                    {       'connected_time': '390758',
                                                                                                                                            'distance': 2968,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMDA2NzQwMQ=='},
                                                                                                                                    {       'connected_time': '390756',
                                                                                                                                            'distance': 6371,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMzAxOTg3MQ=='},
                                                                                                                                    {       'connected_time': '390759',
                                                                                                                                            'distance': 3356,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzUzMQ=='},
                                                                                                                                    {       'connected_time': '390057',
                                                                                                                                            'distance': 3343,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NzAwMDk3MQ=='},
                                                                                                                                    {       'connected_time': '389943',
                                                                                                                                            'distance': 5266,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNDAwMDA2MQ=='},
                                                                                                                                    {       'connected_time': '389804',
                                                                                                                                            'distance': 2961,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMjA1OTk3MQ=='},
                                                                                                                                    {       'connected_time': '389791',
                                                                                                                                            'distance': 3015,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MzMzMQ=='},
                                                                                                                                    {       'connected_time': '389777',
                                                                                                                                            'distance': 5628,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMjAyMTUxMQ=='},
                                                                                                                                    {       'connected_time': '19791',
                                                                                                                                            'distance': 10565,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NjAwMDA1MQ=='},
                                                                                                                                    {       'connected_time': '18472',
                                                                                                                                            'distance': 3551,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjU1MQ=='},
                                                                                                                                    {       'connected_time': '205648',
                                                                                                                                            'distance': 7664,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxMjAyNDU0MQ=='},
                                                                                                                                    {       'connected_time': '205348',
                                                                                                                                            'distance': 7403,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMTAwMzQwMQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '695',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '24513276',
                                                              'in_octets': '1882286607446',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '136204',
                                                              'out_octets': '163120212470',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNjA3ZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNjA3ZXgy'},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNjA3Z2kx'}],
                                'latitude': 37.987972259521484,
                                'longitude': -88.8926773071289,
                                'manufacturer': 'Tarana',
                                'mem': 2.2269354,
                                'model': '30-0141-001',
                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3',
                                'serial_number': 'S141F2221600607',
                                'sw_version': '0.977.016.00',
                                'temperature': 53.375,
                                'uptime': '447780'},
                'peers': [       {       'elevation': 15.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '43577557139',
                                                                       'in_ucast_pkts': '30695429',
                                                                       'links': [       {       'in_octets': '43577557139',
                                                                                                'in_ucast_pkts': '30695429',
                                                                                                'out_octets': '2412734823',
                                                                                                'out_ucast_pkts': '23550751',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2412734823',
                                                                       'out_ucast_pkts': '23550751',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzE3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447298',
                                                                                                                                                     'distance': 11034,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '43250',
                                                                       'in_octets': '22388090950',
                                                                       'in_ucast_pkts': '195943138',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '370244929903',
                                                                       'out_ucast_pkts': '268452273',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzE3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.89215087890625,
                                         'longitude': -88.85618591308594,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'marie_craig_9508',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzE3',
                                         'serial_number': 'S142F2221805317',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.899,
                                         'uptime': '4727579'},
                                 {       'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '59906290788',
                                                                       'in_ucast_pkts': '42209178',
                                                                       'links': [       {       'in_octets': '59906290788',
                                                                                                'in_ucast_pkts': '42209178',
                                                                                                'out_octets': '1968421908',
                                                                                                'out_ucast_pkts': '16765697',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1968421908',
                                                                       'out_ucast_pkts': '16765697',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTc3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447248',
                                                                                                                                                     'distance': 7296,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '15',
                                                                       'in_errors': '4',
                                                                       'in_nucast_pkts': '70456',
                                                                       'in_octets': '11317103172',
                                                                       'in_ucast_pkts': '99256403',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '385404963266',
                                                                       'out_ucast_pkts': '265006012',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTc3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.92168426513672,
                                         'longitude': -88.89781951904297,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Kim_Cabaness',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1NTc3',
                                         'serial_number': 'S142F2222205577',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.899,
                                         'uptime': '4397957'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '87075149115',
                                                                       'in_ucast_pkts': '64018083',
                                                                       'links': [       {       'in_octets': '87075149115',
                                                                                                'in_ucast_pkts': '64018083',
                                                                                                'out_octets': '4637538241',
                                                                                                'out_ucast_pkts': '46564740',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '4637538241',
                                                                       'out_ucast_pkts': '46564740',
                                                                       'poller_hash': 'UzE0MkYyMjIzMzA1OTE2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447198',
                                                                                                                                                     'distance': 6251,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '25',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '85676',
                                                                       'in_octets': '65086419905',
                                                                       'in_ucast_pkts': '643079224',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1269509601065',
                                                                       'out_ucast_pkts': '920494418',
                                                                       'poller_hash': 'UzE0MkYyMjIzMzA1OTE2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.93168640136719,
                                         'longitude': -88.89076232910156,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Elijah_Murphey',
                                         'poller_hash': 'UzE0MkYyMjIzMzA1OTE2',
                                         'serial_number': 'S142F2223305916',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.086,
                                         'uptime': '7248940'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '66000619011',
                                                                       'in_ucast_pkts': '51158308',
                                                                       'links': [       {       'in_octets': '66000619011',
                                                                                                'in_ucast_pkts': '51158308',
                                                                                                'out_octets': '7113663389',
                                                                                                'out_ucast_pkts': '30132741',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7113663389',
                                                                       'out_ucast_pkts': '30132741',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNjY4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447248',
                                                                                                                                                     'distance': 7303,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '700',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '91484',
                                                                       'in_octets': '155874877711',
                                                                       'in_ucast_pkts': '730032823',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1842164616886',
                                                                       'out_ucast_pkts': '1378501777',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNjY4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.92151641845703,
                                         'longitude': -88.8956069946289,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7603635,
                                         'model': '30-0142-001',
                                         'name': 'John.Odle',
                                         'poller_hash': 'UzE0MkYyMjIyMjAzNjY4',
                                         'serial_number': 'S142F2222203668',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.538,
                                         'uptime': '8179474'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '85678777250',
                                                                       'in_ucast_pkts': '61728674',
                                                                       'links': [       {       'in_octets': '85678777250',
                                                                                                'in_ucast_pkts': '61728674',
                                                                                                'out_octets': '4382786706',
                                                                                                'out_ucast_pkts': '20278567',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '4382786706',
                                                                       'out_ucast_pkts': '20278567',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447148',
                                                                                                                                                     'distance': 1922,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '9',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13638',
                                                                       'in_octets': '14981017731',
                                                                       'in_ucast_pkts': '80953372',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '378148955575',
                                                                       'out_ucast_pkts': '271606912',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.9760627746582,
                                         'longitude': -88.90961456298828,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Kearney_Ashley',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1Mjc2',
                                         'serial_number': 'S142F2222205276',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.157,
                                         'uptime': '1457055'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '81050819557',
                                                                       'in_ucast_pkts': '61498541',
                                                                       'links': [       {       'in_octets': '81050819557',
                                                                                                'in_ucast_pkts': '61498541',
                                                                                                'out_octets': '6136387794',
                                                                                                'out_ucast_pkts': '30179221',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6136387794',
                                                                       'out_ucast_pkts': '30179221',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzI2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447148',
                                                                                                                                                     'distance': 2505,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '51',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13709',
                                                                       'in_octets': '29759103662',
                                                                       'in_ucast_pkts': '151804368',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '374221517025',
                                                                       'out_ucast_pkts': '293706634',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzI2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.969635009765625,
                                         'longitude': -88.91056823730469,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Ryan_Eaton',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzI2',
                                         'serial_number': 'S142F2221805326',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.783,
                                         'uptime': '1457060'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '53858265770',
                                                                       'in_ucast_pkts': '40520225',
                                                                       'links': [       {       'in_octets': '53858265770',
                                                                                                'in_ucast_pkts': '40520225',
                                                                                                'out_octets': '3739258867',
                                                                                                'out_ucast_pkts': '18054637',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3739258867',
                                                                       'out_ucast_pkts': '18054637',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjM1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447148',
                                                                                                                                                     'distance': 2398,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '29',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13752',
                                                                       'in_octets': '12612268012',
                                                                       'in_ucast_pkts': '66099201',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '196970797281',
                                                                       'out_ucast_pkts': '149518144',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjM1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.97060775756836,
                                         'longitude': -88.91015625,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Bryan_Salina',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MjM1',
                                         'serial_number': 'S142F2221805235',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 37.821,
                                         'uptime': '1457058'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '53691680803',
                                                                       'in_ucast_pkts': '46120274',
                                                                       'links': [       {       'in_octets': '53691680803',
                                                                                                'in_ucast_pkts': '46120274',
                                                                                                'out_octets': '8165532458',
                                                                                                'out_ucast_pkts': '29840895',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8165532458',
                                                                       'out_ucast_pkts': '29840895',
                                                                       'poller_hash': 'UzE0MkYyMjIyODA3MzkwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '447198',
                                                                                                                                                     'distance': 7148,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '298',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '36380',
                                                                       'in_octets': '87032157985',
                                                                       'in_ucast_pkts': '322075541',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '872661109114',
                                                                       'out_ucast_pkts': '670127857',
                                                                       'poller_hash': 'UzE0MkYyMjIyODA3MzkwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.922977447509766,
                                         'longitude': -88.89509582519531,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'jason_adams',
                                         'poller_hash': 'UzE0MkYyMjIyODA3Mzkw',
                                         'serial_number': 'S142F2222807390',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.738,
                                         'uptime': '4017769'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '4036644188',
                                                                       'in_ucast_pkts': '3039365',
                                                                       'links': [       {       'in_octets': '4036644188',
                                                                                                'in_ucast_pkts': '3039365',
                                                                                                'out_octets': '282078049',
                                                                                                'out_ucast_pkts': '1977449',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '282078049',
                                                                       'out_ucast_pkts': '1977449',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTI1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '165898',
                                                                                                                                                     'distance': 11852,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '23210',
                                                                       'in_octets': '6320704023',
                                                                       'in_ucast_pkts': '43849962',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '111514196278',
                                                                       'out_ucast_pkts': '80342587',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTI1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.88165283203125,
                                         'longitude': -88.87371826171875,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Lauren_Taylor',
                                         'poller_hash': 'UzE0MkYyMjIzNTAwMTI1',
                                         'serial_number': 'S142F2223500125',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.506,
                                         'uptime': '1549047'},
                                 {       'elevation': 9.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '761039',
                                                                       'in_ucast_pkts': '1731',
                                                                       'links': [       {       'in_octets': '761039',
                                                                                                'in_ucast_pkts': '1731',
                                                                                                'out_octets': '546742',
                                                                                                'out_ucast_pkts': '1744',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '546742',
                                                                       'out_ucast_pkts': '1744',
                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDEyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1756',
                                                                                                                                                     'distance': 7584,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11464',
                                                                       'in_octets': '321588377',
                                                                       'in_ucast_pkts': '2060780',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3014050691',
                                                                       'out_ucast_pkts': '2628846',
                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDEyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.91940689086914,
                                         'longitude': -88.88265228271484,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Richard_Cremer',
                                         'poller_hash': 'UzE0MkYyMjIxNDAwMDEy',
                                         'serial_number': 'S142F2221400012',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.073,
                                         'uptime': '205965'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '70337594941',
                                                                       'in_ucast_pkts': '51919282',
                                                                       'links': [       {       'in_octets': '70337594941',
                                                                                                'in_ucast_pkts': '51919282',
                                                                                                'out_octets': '6716455094',
                                                                                                'out_ucast_pkts': '30844468',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6716455094',
                                                                       'out_ucast_pkts': '30844468',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzAyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '409048',
                                                                                                                                                     'distance': 11061,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3704',
                                                                       'in_octets': '6742504101',
                                                                       'in_ucast_pkts': '30875175',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '70120135105',
                                                                       'out_ucast_pkts': '51914672',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzAyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.89228820800781,
                                         'longitude': -88.85506439208984,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Harkins_Jerry_7202',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzAy',
                                         'serial_number': 'S142F2221805302',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.073,
                                         'uptime': '409443'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '9378763869',
                                                                       'in_ucast_pkts': '7637159',
                                                                       'links': [       {       'in_octets': '9378763869',
                                                                                                'in_ucast_pkts': '7637159',
                                                                                                'out_octets': '849338425',
                                                                                                'out_ucast_pkts': '4147433',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '849338425',
                                                                       'out_ucast_pkts': '4147433',
                                                                       'poller_hash': 'UzE0MkYyMjIzODAwNjkyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390756',
                                                                                                                                                     'distance': 7584,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3684',
                                                                       'in_octets': '849480531',
                                                                       'in_ucast_pkts': '4143716',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '9348356567',
                                                                       'out_ucast_pkts': '7638815',
                                                                       'poller_hash': 'UzE0MkYyMjIzODAwNjkyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.93523025512695,
                                         'longitude': -88.94892120361328,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'MUTCHEK.JOHN',
                                         'poller_hash': 'UzE0MkYyMjIzODAwNjky',
                                         'serial_number': 'S142F2223800692',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.377,
                                         'uptime': '391263'},
                                 {       'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '52721218288',
                                                                       'in_ucast_pkts': '44128037',
                                                                       'links': [       {       'in_octets': '52721218288',
                                                                                                'in_ucast_pkts': '44128037',
                                                                                                'out_octets': '7449750477',
                                                                                                'out_ucast_pkts': '28830272',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7449750477',
                                                                       'out_ucast_pkts': '28830272',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAxMDMyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390756',
                                                                                                                                                     'distance': 4093,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3614',
                                                                       'in_octets': '7450417599',
                                                                       'in_ucast_pkts': '28827176',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '52548504947',
                                                                       'out_ucast_pkts': '44129892',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAxMDMyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.95406723022461,
                                         'longitude': -88.91439819335938,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Jerry_Suspinac',
                                         'poller_hash': 'UzE0MkYyMjIzNTAxMDMy',
                                         'serial_number': 'S142F2223501032',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.783,
                                         'uptime': '391278'},
                                 {       'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15656880292',
                                                                       'in_ucast_pkts': '13193016',
                                                                       'links': [       {       'in_octets': '15656880292',
                                                                                                'in_ucast_pkts': '13193016',
                                                                                                'out_octets': '2526462376',
                                                                                                'out_ucast_pkts': '10922741',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2526462376',
                                                                       'out_ucast_pkts': '10922741',
                                                                       'poller_hash': 'UzE0MkYyMjIxMDA2NzQwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390758',
                                                                                                                                                     'distance': 2968,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3601',
                                                                       'in_octets': '2527500534',
                                                                       'in_ucast_pkts': '10920253',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '15597854002',
                                                                       'out_ucast_pkts': '13189677',
                                                                       'poller_hash': 'UzE0MkYyMjIxMDA2NzQwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.96778869628906,
                                         'longitude': -88.915771484375,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Admas_Williams',
                                         'poller_hash': 'UzE0MkYyMjIxMDA2NzQw',
                                         'serial_number': 'S142F2221006740',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.086,
                                         'uptime': '391253'},
                                 {       'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '142236663613',
                                                                       'in_ucast_pkts': '101956515',
                                                                       'links': [       {       'in_octets': '142236663613',
                                                                                                'in_ucast_pkts': '101956515',
                                                                                                'out_octets': '6096513066',
                                                                                                'out_ucast_pkts': '55390254',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6096513066',
                                                                       'out_ucast_pkts': '55390254',
                                                                       'poller_hash': 'UzE0MkYyMjIxMzAxOTg3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390756',
                                                                                                                                                     'distance': 6371,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '85',
                                                                       'in_errors': '46',
                                                                       'in_nucast_pkts': '3583',
                                                                       'in_octets': '6100170936',
                                                                       'in_ucast_pkts': '55391550',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '141814132983',
                                                                       'out_ucast_pkts': '101945503',
                                                                       'poller_hash': 'UzE0MkYyMjIxMzAxOTg3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.94938278198242,
                                         'longitude': -88.94747924804688,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Stephanie_Bennett_13698',
                                         'poller_hash': 'UzE0MkYyMjIxMzAxOTg3',
                                         'serial_number': 'S142F2221301987',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.912,
                                         'uptime': '391256'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '42309368327',
                                                                       'in_ucast_pkts': '32414335',
                                                                       'links': [       {       'in_octets': '42309368327',
                                                                                                'in_ucast_pkts': '32414335',
                                                                                                'out_octets': '2899415558',
                                                                                                'out_ucast_pkts': '21577750',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2899415558',
                                                                       'out_ucast_pkts': '21577750',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzUzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390759',
                                                                                                                                                     'distance': 3356,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3676',
                                                                       'in_octets': '2902062498',
                                                                       'in_ucast_pkts': '21579115',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '42179185102',
                                                                       'out_ucast_pkts': '32415508',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzUzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.96281433105469,
                                         'longitude': -88.91524505615234,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Becky_Clay',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzUz',
                                         'serial_number': 'S142F2221805353',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.886,
                                         'uptime': '391272'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '64307864850',
                                                                       'in_ucast_pkts': '50335423',
                                                                       'links': [       {       'in_octets': '64307864850',
                                                                                                'in_ucast_pkts': '50335423',
                                                                                                'out_octets': '6755180685',
                                                                                                'out_ucast_pkts': '27317079',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6755180685',
                                                                       'out_ucast_pkts': '27317079',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDk3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '390057',
                                                                                                                                                     'distance': 3343,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '5',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3860',
                                                                       'in_octets': '6755792322',
                                                                       'in_ucast_pkts': '27313830',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '64111357100',
                                                                       'out_ucast_pkts': '50336490',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDk3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.97086715698242,
                                         'longitude': -88.9247055053711,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Matthew_wolfe_20005',
                                         'poller_hash': 'UzE0MkYxMjE0NzAwMDk3',
                                         'serial_number': 'S142F1214700097',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.248,
                                         'uptime': '391282'},
                                 {       'elevation': 7.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '178741237195',
                                                                       'in_ucast_pkts': '133683367',
                                                                       'links': [       {       'in_octets': '178741237195',
                                                                                                'in_ucast_pkts': '133683367',
                                                                                                'out_octets': '26870197927',
                                                                                                'out_ucast_pkts': '65794059',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '26870197927',
                                                                       'out_ucast_pkts': '65794059',
                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDA2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389943',
                                                                                                                                                     'distance': 5266,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '6',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '174',
                                                                       'in_octets': '26872960301',
                                                                       'in_ucast_pkts': '65795547',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '178195949499',
                                                                       'out_ucast_pkts': '133672782',
                                                                       'poller_hash': 'UzE0MkYyMjIxNDAwMDA2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.94259262084961,
                                         'longitude': -88.91342163085938,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Carla_Pulliam_7166HQ',
                                         'poller_hash': 'UzE0MkYyMjIxNDAwMDA2',
                                         'serial_number': 'S142F2221400006',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.377,
                                         'uptime': '391275'},
                                 {       'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '217187438084',
                                                                       'in_ucast_pkts': '146838753',
                                                                       'links': [       {       'in_octets': '217187438084',
                                                                                                'in_ucast_pkts': '146838753',
                                                                                                'out_octets': '7297249822',
                                                                                                'out_ucast_pkts': '83954413',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7297249822',
                                                                       'out_ucast_pkts': '83954413',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjA1OTk3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389804',
                                                                                                                                                     'distance': 2961,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3888',
                                                                       'in_octets': '7298579879',
                                                                       'in_ucast_pkts': '83953255',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '216569323264',
                                                                       'out_ucast_pkts': '146819179',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjA1OTk3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.96733093261719,
                                         'longitude': -88.9152603149414,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Janet_Ronchetto',
                                         'poller_hash': 'UzE0MkYyMjIxMjA1OTk3',
                                         'serial_number': 'S142F2221205997',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.899,
                                         'uptime': '391263'},
                                 {       'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '236310526669',
                                                                       'in_ucast_pkts': '159734063',
                                                                       'links': [       {       'in_octets': '236310526669',
                                                                                                'in_ucast_pkts': '159734063',
                                                                                                'out_octets': '10266717522',
                                                                                                'out_ucast_pkts': '106710238',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '10266717522',
                                                                       'out_ucast_pkts': '106710238',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzMzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389791',
                                                                                                                                                     'distance': 3015,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '187',
                                                                       'in_octets': '10269375775',
                                                                       'in_ucast_pkts': '106711000',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '235648080772',
                                                                       'out_ucast_pkts': '159719038',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MzMzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.966514587402344,
                                         'longitude': -88.91500854492188,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Jacy_Page',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MzMz',
                                         'serial_number': 'S142F2221805333',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.028,
                                         'uptime': '391273'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '49622064821',
                                                                       'in_ucast_pkts': '38667699',
                                                                       'links': [       {       'in_octets': '49622064821',
                                                                                                'in_ucast_pkts': '38667699',
                                                                                                'out_octets': '2388727454',
                                                                                                'out_ucast_pkts': '15395613',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2388727454',
                                                                       'out_ucast_pkts': '15395613',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyMTUxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '389777',
                                                                                                                                                     'distance': 5628,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3923',
                                                                       'in_octets': '2389533629',
                                                                       'in_ucast_pkts': '15392425',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '49465044458',
                                                                       'out_ucast_pkts': '38667298',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyMTUxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.93960952758789,
                                         'longitude': -88.91454315185547,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Sharon_Pulliam',
                                         'poller_hash': 'UzE0MkYyMjIxMjAyMTUx',
                                         'serial_number': 'S142F2221202151',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 34.686,
                                         'uptime': '391264'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '10541395',
                                                                       'in_ucast_pkts': '20044',
                                                                       'links': [       {       'in_octets': '10541395',
                                                                                                'in_ucast_pkts': '20044',
                                                                                                'out_octets': '3206124',
                                                                                                'out_ucast_pkts': '19571',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3206124',
                                                                       'out_ucast_pkts': '19571',
                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDA1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '19791',
                                                                                                                                                     'distance': 10565,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3560',
                                                                       'in_octets': '75034169',
                                                                       'in_ucast_pkts': '422037',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '387772120',
                                                                       'out_ucast_pkts': '551522',
                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDA1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.89767837524414,
                                         'longitude': -88.9328384399414,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Raubach_Randy_7106',
                                         'poller_hash': 'UzE0MkYxMjE0NjAwMDA1',
                                         'serial_number': 'S142F1214600005',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.319,
                                         'uptime': '329550'},
                                 {       'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1426540191',
                                                                       'in_ucast_pkts': '1308455',
                                                                       'links': [       {       'in_octets': '1426540191',
                                                                                                'in_ucast_pkts': '1308455',
                                                                                                'out_octets': '147704358',
                                                                                                'out_ucast_pkts': '563327',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '147704358',
                                                                       'out_ucast_pkts': '563327',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '18472',
                                                                                                                                                     'distance': 3551,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1522',
                                                                       'in_octets': '407150499',
                                                                       'in_ucast_pkts': '1805690',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4671154904',
                                                                       'out_ucast_pkts': '4173634',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.97806930541992,
                                         'longitude': -88.93434143066406,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Casey_Melissa_17432',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MjU1',
                                         'serial_number': 'S142F2221805255',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.854,
                                         'uptime': '90255'},
                                 {       'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '3165611194',
                                                                       'in_ucast_pkts': '2983445',
                                                                       'links': [       {       'in_octets': '3165611194',
                                                                                                'in_ucast_pkts': '2983445',
                                                                                                'out_octets': '443224473',
                                                                                                'out_ucast_pkts': '2226695',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '443224473',
                                                                       'out_ucast_pkts': '2226695',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyNDU0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '205648',
                                                                                                                                                     'distance': 7664,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2022',
                                                                       'in_octets': '444963352',
                                                                       'in_ucast_pkts': '2226262',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3152790096',
                                                                       'out_ucast_pkts': '2982814',
                                                                       'poller_hash': 'UzE0MkYyMjIxMjAyNDU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.91835021972656,
                                         'longitude': -88.8901138305664,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Vernon_Dotson',
                                         'poller_hash': 'UzE0MkYyMjIxMjAyNDU0',
                                         'serial_number': 'S142F2221202454',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.796,
                                         'uptime': '205981'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '54200145085',
                                                                       'in_ucast_pkts': '39677626',
                                                                       'links': [       {       'in_octets': '54200145085',
                                                                                                'in_ucast_pkts': '39677626',
                                                                                                'out_octets': '2675496251',
                                                                                                'out_ucast_pkts': '20933604',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2675496251',
                                                                       'out_ucast_pkts': '20933604',
                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwMzQwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '205348',
                                                                                                                                                     'distance': 7403,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNjA3d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1972',
                                                                       'in_octets': '2677154555',
                                                                       'in_ucast_pkts': '20933097',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '54039697898',
                                                                       'out_ucast_pkts': '39677228',
                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwMzQwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.921043395996094,
                                         'longitude': -88.88288116455078,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Kenneth_Martinsen_13662HQ',
                                         'poller_hash': 'UzE0MkYyMjIzMTAwMzQw',
                                         'serial_number': 'S142F2223100340',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.189,
                                         'uptime': '205988'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_977_016_00_10_135_112_132(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.977.016.00.10_135_112_132")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 32,
                'sw_version': '0.977.016.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2221600576',
                'system_mac_address': None,
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                'S142F1215000075': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 18954704836,
                                           'dl_rf_packets': 14679626,
                                           'ip_address': None,
                                           'name': 'S142F1215000075',
                                           'serial': 'S142F1215000075',
                                           'serial_number': 'S142F1215000075',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1031629440,
                                           'ul_rf_packets': 8580737},
                'S142F1215000099': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 550566016064,
                                           'dl_rf_packets': 368393006,
                                           'ip_address': None,
                                           'name': 'Charles_Bushue_19078',
                                           'serial': 'S142F1215000099',
                                           'serial_number': 'S142F1215000099',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 20126393499,
                                           'ul_rf_packets': 242436242},
                'S142F2221706261': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 580103542,
                                           'dl_rf_packets': 550207,
                                           'ip_address': None,
                                           'name': 'ronald_rose',
                                           'serial': 'S142F2221706261',
                                           'serial_number': 'S142F2221706261',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 59274912,
                                           'ul_rf_packets': 475424},
                'S142F2221706350': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 1833151799,
                                           'dl_rf_packets': 3478405,
                                           'ip_address': None,
                                           'name': 'Susan_Quindry',
                                           'serial': 'S142F2221706350',
                                           'serial_number': 'S142F2221706350',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 560306977,
                                           'ul_rf_packets': 3020991},
                'S142F2221706351': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 387769331125,
                                           'dl_rf_packets': 270754772,
                                           'ip_address': None,
                                           'name': 'Lane_Gibbens',
                                           'serial': 'S142F2221706351',
                                           'serial_number': 'S142F2221706351',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 21337189844,
                                           'ul_rf_packets': 227087730},
                'S142F2221706352': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 280092069781,
                                           'dl_rf_packets': 211108010,
                                           'ip_address': None,
                                           'name': 'Amanda_Hartline',
                                           'serial': 'S142F2221706352',
                                           'serial_number': 'S142F2221706352',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 18503805725,
                                           'ul_rf_packets': 96187954},
                'S142F2221706374': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 22270246612,
                                           'dl_rf_packets': 15828062,
                                           'ip_address': None,
                                           'name': 'Matt_Garrett',
                                           'serial': 'S142F2221706374',
                                           'serial_number': 'S142F2221706374',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1037550466,
                                           'ul_rf_packets': 8704176},
                'S142F2221706376': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 16927660191,
                                           'dl_rf_packets': 14661232,
                                           'ip_address': None,
                                           'name': 'Marsha_Wyant',
                                           'serial': 'S142F2221706376',
                                           'serial_number': 'S142F2221706376',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1262509508,
                                           'ul_rf_packets': 7229877},
                'S142F2221805250': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 155636605970,
                                           'dl_rf_packets': 114556323,
                                           'ip_address': None,
                                           'name': 'lisa_keener_7769',
                                           'serial': 'S142F2221805250',
                                           'serial_number': 'S142F2221805250',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 9980309010,
                                           'ul_rf_packets': 69529293},
                'S142F2221805254': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 1457374909,
                                           'dl_rf_packets': 1788002,
                                           'ip_address': None,
                                           'name': 'Sherry_drysdale',
                                           'serial': 'S142F2221805254',
                                           'serial_number': 'S142F2221805254',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 345442010,
                                           'ul_rf_packets': 1308129},
                'S142F2221902685': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 69773423798,
                                           'dl_rf_packets': 56700032,
                                           'ip_address': None,
                                           'name': 'Sanders_Leon_15612',
                                           'serial': 'S142F2221902685',
                                           'serial_number': 'S142F2221902685',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 6604497835,
                                           'ul_rf_packets': 43759625},
                'S142F2222000079': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 378606716,
                                           'dl_rf_packets': 530178,
                                           'ip_address': None,
                                           'name': 'merrill_rose_8486',
                                           'serial': 'S142F2222000079',
                                           'serial_number': 'S142F2222000079',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 52129655,
                                           'ul_rf_packets': 466077},
                'S142F2222000261': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 382757607427,
                                           'dl_rf_packets': 304117214,
                                           'ip_address': None,
                                           'name': 'Poole_Dennis_17811',
                                           'serial': 'S142F2222000261',
                                           'serial_number': 'S142F2222000261',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 25988630317,
                                           'ul_rf_packets': 158514494},
                'S142F2222002095': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 21690877062,
                                           'dl_rf_packets': 16057690,
                                           'ip_address': None,
                                           'name': 'John_Grutzius',
                                           'serial': 'S142F2222002095',
                                           'serial_number': 'S142F2222002095',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1279354917,
                                           'ul_rf_packets': 8414644},
                'S142F2222002333': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 2576243597,
                                           'dl_rf_packets': 1895776,
                                           'ip_address': None,
                                           'name': 'Forsythe_Sandy_20054',
                                           'serial': 'S142F2222002333',
                                           'serial_number': 'S142F2222002333',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 105755144,
                                           'ul_rf_packets': 955277},
                'S142F2222203400': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 1142548329069,
                                           'dl_rf_packets': 801367868,
                                           'ip_address': None,
                                           'name': 'Ronald_Lancaster_55858HQ',
                                           'serial': 'S142F2222203400',
                                           'serial_number': 'S142F2222203400',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 35372390901,
                                           'ul_rf_packets': 375899736},
                'S142F2222203594': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 184101143312,
                                           'dl_rf_packets': 125280866,
                                           'ip_address': None,
                                           'name': 'Dawn_Sullivan_8311HQ',
                                           'serial': 'S142F2222203594',
                                           'serial_number': 'S142F2222203594',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 7743503178,
                                           'ul_rf_packets': 85439536},
                'S142F2222205447': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 15504858207,
                                           'dl_rf_packets': 10892170,
                                           'ip_address': None,
                                           'name': 'David_Moss',
                                           'serial': 'S142F2222205447',
                                           'serial_number': 'S142F2222205447',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 692907235,
                                           'ul_rf_packets': 5088086},
                'S142F2222205503': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 140398968101,
                                           'dl_rf_packets': 97085680,
                                           'ip_address': None,
                                           'name': 'Kelsey_Stroud',
                                           'serial': 'S142F2222205503',
                                           'serial_number': 'S142F2222205503',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 5174840865,
                                           'ul_rf_packets': 44486433},
                'S142F2222205631': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 252508155788,
                                           'dl_rf_packets': 181631369,
                                           'ip_address': None,
                                           'name': 'Ferrell_Winemiller',
                                           'serial': 'S142F2222205631',
                                           'serial_number': 'S142F2222205631',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 13871078358,
                                           'ul_rf_packets': 97025735},
                'S142F2222601578': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 94303264102,
                                           'dl_rf_packets': 78323898,
                                           'ip_address': None,
                                           'name': 'Jonathan_Edwards',
                                           'serial': 'S142F2222601578',
                                           'serial_number': 'S142F2222601578',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 8134259991,
                                           'ul_rf_packets': 47169508},
                'S142F2222601624': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 128922670071,
                                           'dl_rf_packets': 87797648,
                                           'ip_address': None,
                                           'name': 'Shelton_7260',
                                           'serial': 'S142F2222601624',
                                           'serial_number': 'S142F2222601624',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 5958544442,
                                           'ul_rf_packets': 60644078},
                'S142F2222807396': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 84155474302,
                                           'dl_rf_packets': 61825004,
                                           'ip_address': None,
                                           'name': 'Elaine_Rich',
                                           'serial': 'S142F2222807396',
                                           'serial_number': 'S142F2222807396',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 5535733148,
                                           'ul_rf_packets': 46773258},
                'S142F2223000123': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 329395571688,
                                           'dl_rf_packets': 269049813,
                                           'ip_address': None,
                                           'name': 'Linda_Swan',
                                           'serial': 'S142F2223000123',
                                           'serial_number': 'S142F2223000123',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 66556973474,
                                           'ul_rf_packets': 196693126},
                'S142F2223000361': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 2245801028,
                                           'dl_rf_packets': 2068306,
                                           'ip_address': None,
                                           'name': 'Ben_Clements',
                                           'serial': 'S142F2223000361',
                                           'serial_number': 'S142F2223000361',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 241212630,
                                           'ul_rf_packets': 1554229},
                'S142F2223000368': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 582337180223,
                                           'dl_rf_packets': 400114756,
                                           'ip_address': None,
                                           'name': 'Ben_Clements',
                                           'serial': 'S142F2223000368',
                                           'serial_number': 'S142F2223000368',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 29458572364,
                                           'ul_rf_packets': 272980031},
                'S142F2223100853': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 40216527668,
                                           'dl_rf_packets': 31067876,
                                           'ip_address': None,
                                           'name': 'Wilcox.Richard',
                                           'serial': 'S142F2223100853',
                                           'serial_number': 'S142F2223100853',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 3194813044,
                                           'ul_rf_packets': 25276597},
                'S142F2223400754': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 33247475528,
                                           'dl_rf_packets': 27175994,
                                           'ip_address': None,
                                           'name': 'JonesArview_22099',
                                           'serial': 'S142F2223400754',
                                           'serial_number': 'S142F2223400754',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 2649795479,
                                           'ul_rf_packets': 15291496},
                'S142F2223400782': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 283955492874,
                                           'dl_rf_packets': 200080213,
                                           'ip_address': None,
                                           'name': 'Lewis_RobertAndRebecca_15948HQ',
                                           'serial': 'S142F2223400782',
                                           'serial_number': 'S142F2223400782',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 17734281013,
                                           'ul_rf_packets': 165220138},
                'S142F2223500139': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 179038668841,
                                           'dl_rf_packets': 160763414,
                                           'ip_address': None,
                                           'name': 'Ricky_Robinson',
                                           'serial': 'S142F2223500139',
                                           'serial_number': 'S142F2223500139',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 22033348629,
                                           'ul_rf_packets': 96797455},
                'S142F2223500202': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 24051396484,
                                           'dl_rf_packets': 19322858,
                                           'ip_address': None,
                                           'name': 'William_Armstrong',
                                           'serial': 'S142F2223500202',
                                           'serial_number': 'S142F2223500202',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1257486737,
                                           'ul_rf_packets': 9251466},
                'S142F2223803537': {       'dev_macs': None,
                                           'dl_link_rate': None,
                                           'dl_rf_bytes': 8424206679,
                                           'dl_rf_packets': 7895845,
                                           'ip_address': None,
                                           'name': 'Stowers_Derek_19338HQ',
                                           'serial': 'S142F2223803537',
                                           'serial_number': 'S142F2223803537',
                                           'system_mac_address': None,
                                           'ul_link_rate': None,
                                           'ul_rf_bytes': 1094492842,
                                           'ul_rf_packets': 6887613}
        }
        exp_ne_msg = {
                'data': {       'cpu': 44.87144,
                                'elevation': 225.173,
                                'gps_sats_tracked': 15,
                                'height': 228.728,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '1632200',
                                                                                       'in_octets': '29458572364',
                                                                                       'in_ucast_pkts': '272980031',
                                                                                       'out_errors': '8125311',
                                                                                       'out_octets': '582337180223',
                                                                                       'out_ucast_pkts': '400114756',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzY4MQ=='},
                                                                               {       'in_errors': '820071',
                                                                                       'in_octets': '17734281013',
                                                                                       'in_ucast_pkts': '165220138',
                                                                                       'out_errors': '378114',
                                                                                       'out_octets': '283955492874',
                                                                                       'out_ucast_pkts': '200080213',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzgyMQ=='},
                                                                               {       'in_errors': '2447006',
                                                                                       'in_octets': '18503805725',
                                                                                       'in_ucast_pkts': '96187954',
                                                                                       'out_errors': '10303882',
                                                                                       'out_octets': '280092069781',
                                                                                       'out_ucast_pkts': '211108010',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUyMQ=='},
                                                                               {       'in_errors': '709337',
                                                                                       'in_octets': '9980309010',
                                                                                       'in_ucast_pkts': '69529293',
                                                                                       'out_errors': '3009605',
                                                                                       'out_octets': '155636605970',
                                                                                       'out_ucast_pkts': '114556323',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjUwMQ=='},
                                                                               {       'in_errors': '1840825',
                                                                                       'in_octets': '66556973474',
                                                                                       'in_ucast_pkts': '196693126',
                                                                                       'out_errors': '5654547',
                                                                                       'out_octets': '329395571688',
                                                                                       'out_ucast_pkts': '269049813',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMTIzMQ=='},
                                                                               {       'in_errors': '5067810',
                                                                                       'in_octets': '35372390901',
                                                                                       'in_ucast_pkts': '375899736',
                                                                                       'out_errors': '23935848',
                                                                                       'out_octets': '1142548329069',
                                                                                       'out_ucast_pkts': '801367868',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNDAwMQ=='},
                                                                               {       'in_errors': '38260',
                                                                                       'in_octets': '241212630',
                                                                                       'in_ucast_pkts': '1554229',
                                                                                       'out_errors': '185913',
                                                                                       'out_octets': '2245801028',
                                                                                       'out_ucast_pkts': '2068306',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzYxMQ=='},
                                                                               {       'in_errors': '1470055',
                                                                                       'in_octets': '20126393499',
                                                                                       'in_ucast_pkts': '242436242',
                                                                                       'out_errors': '7074353',
                                                                                       'out_octets': '550566016064',
                                                                                       'out_ucast_pkts': '368393006',
                                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDk5MQ=='},
                                                                               {       'in_errors': '253767',
                                                                                       'in_octets': '560306977',
                                                                                       'in_ucast_pkts': '3020991',
                                                                                       'out_errors': '1247115',
                                                                                       'out_octets': '1833151799',
                                                                                       'out_ucast_pkts': '3478405',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUwMQ=='},
                                                                               {       'in_errors': '97300',
                                                                                       'in_octets': '1031629440',
                                                                                       'in_ucast_pkts': '8580737',
                                                                                       'out_errors': '468522',
                                                                                       'out_octets': '18954704836',
                                                                                       'out_ucast_pkts': '14679626',
                                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDc1MQ=='},
                                                                               {       'in_errors': '181071',
                                                                                       'in_octets': '3194813044',
                                                                                       'in_ucast_pkts': '25276597',
                                                                                       'out_errors': '939942',
                                                                                       'out_octets': '40216527668',
                                                                                       'out_ucast_pkts': '31067876',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwODUzMQ=='},
                                                                               {       'in_errors': '1064977',
                                                                                       'in_octets': '21337189844',
                                                                                       'in_ucast_pkts': '227087730',
                                                                                       'out_errors': '5013118',
                                                                                       'out_octets': '387769331125',
                                                                                       'out_ucast_pkts': '270754772',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUxMQ=='},
                                                                               {       'in_errors': '1028123',
                                                                                       'in_octets': '8134259991',
                                                                                       'in_ucast_pkts': '47169508',
                                                                                       'out_errors': '4791036',
                                                                                       'out_octets': '94303264102',
                                                                                       'out_ucast_pkts': '78323898',
                                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNTc4MQ=='},
                                                                               {       'in_errors': '34174',
                                                                                       'in_octets': '345442010',
                                                                                       'in_ucast_pkts': '1308129',
                                                                                       'out_errors': '6886',
                                                                                       'out_octets': '1457374909',
                                                                                       'out_ucast_pkts': '1788002',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU0MQ=='},
                                                                               {       'in_errors': '382844',
                                                                                       'in_octets': '6604497835',
                                                                                       'in_ucast_pkts': '43759625',
                                                                                       'out_errors': '1661814',
                                                                                       'out_octets': '69773423798',
                                                                                       'out_ucast_pkts': '56700032',
                                                                                       'poller_hash': 'UzE0MkYyMjIxOTAyNjg1MQ=='},
                                                                               {       'in_errors': '1262839',
                                                                                       'in_octets': '5535733148',
                                                                                       'in_ucast_pkts': '46773258',
                                                                                       'out_errors': '3488282',
                                                                                       'out_octets': '84155474302',
                                                                                       'out_ucast_pkts': '61825004',
                                                                                       'poller_hash': 'UzE0MkYyMjIyODA3Mzk2MQ=='},
                                                                               {       'in_errors': '197023',
                                                                                       'in_octets': '1279354917',
                                                                                       'in_ucast_pkts': '8414644',
                                                                                       'out_errors': '846409',
                                                                                       'out_octets': '21690877062',
                                                                                       'out_ucast_pkts': '16057690',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMDk1MQ=='},
                                                                               {       'in_errors': '122895',
                                                                                       'in_octets': '692907235',
                                                                                       'in_ucast_pkts': '5088086',
                                                                                       'out_errors': '586461',
                                                                                       'out_octets': '15504858207',
                                                                                       'out_ucast_pkts': '10892170',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3MQ=='},
                                                                               {       'in_errors': '336642',
                                                                                       'in_octets': '5958544442',
                                                                                       'in_ucast_pkts': '60644078',
                                                                                       'out_errors': '1713469',
                                                                                       'out_octets': '128922670071',
                                                                                       'out_ucast_pkts': '87797648',
                                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNjI0MQ=='},
                                                                               {       'in_errors': '141221',
                                                                                       'in_octets': '1037550466',
                                                                                       'in_ucast_pkts': '8704176',
                                                                                       'out_errors': '670263',
                                                                                       'out_octets': '22270246612',
                                                                                       'out_ucast_pkts': '15828062',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0MQ=='},
                                                                               {       'in_errors': '1517769',
                                                                                       'in_octets': '13871078358',
                                                                                       'in_ucast_pkts': '97025735',
                                                                                       'out_errors': '7377276',
                                                                                       'out_octets': '252508155788',
                                                                                       'out_ucast_pkts': '181631369',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NjMxMQ=='},
                                                                               {       'in_errors': '18298',
                                                                                       'in_octets': '59274912',
                                                                                       'in_ucast_pkts': '475424',
                                                                                       'out_errors': '86830',
                                                                                       'out_octets': '580103542',
                                                                                       'out_ucast_pkts': '550207',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MjYxMQ=='},
                                                                               {       'in_errors': '129314',
                                                                                       'in_octets': '1257486737',
                                                                                       'in_ucast_pkts': '9251466',
                                                                                       'out_errors': '634742',
                                                                                       'out_octets': '24051396484',
                                                                                       'out_ucast_pkts': '19322858',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMjAyMQ=='},
                                                                               {       'in_errors': '843551',
                                                                                       'in_octets': '5174840865',
                                                                                       'in_ucast_pkts': '44486433',
                                                                                       'out_errors': '4351836',
                                                                                       'out_octets': '140398968101',
                                                                                       'out_ucast_pkts': '97085680',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTAzMQ=='},
                                                                               {       'in_errors': '229936',
                                                                                       'in_octets': '1262509508',
                                                                                       'in_ucast_pkts': '7229877',
                                                                                       'out_errors': '985749',
                                                                                       'out_octets': '16927660191',
                                                                                       'out_ucast_pkts': '14661232',
                                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2MQ=='},
                                                                               {       'in_errors': '407049',
                                                                                       'in_octets': '7743503178',
                                                                                       'in_ucast_pkts': '85439536',
                                                                                       'out_errors': '1979207',
                                                                                       'out_octets': '184101143312',
                                                                                       'out_ucast_pkts': '125280866',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNTk0MQ=='},
                                                                               {       'in_errors': '219619',
                                                                                       'in_octets': '2649795479',
                                                                                       'in_ucast_pkts': '15291496',
                                                                                       'out_errors': '1281115',
                                                                                       'out_octets': '33247475528',
                                                                                       'out_ucast_pkts': '27175994',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzU0MQ=='},
                                                                               {       'in_errors': '66362',
                                                                                       'in_octets': '1094492842',
                                                                                       'in_ucast_pkts': '6887613',
                                                                                       'out_errors': '228190',
                                                                                       'out_octets': '8424206679',
                                                                                       'out_ucast_pkts': '7895845',
                                                                                       'poller_hash': 'UzE0MkYyMjIzODAzNTM3MQ=='},
                                                                               {       'in_errors': '6513',
                                                                                       'in_octets': '52129655',
                                                                                       'in_ucast_pkts': '466077',
                                                                                       'out_errors': '26488',
                                                                                       'out_octets': '378606716',
                                                                                       'out_ucast_pkts': '530178',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMDc5MQ=='},
                                                                               {       'in_errors': '26593',
                                                                                       'in_octets': '105755144',
                                                                                       'in_ucast_pkts': '955277',
                                                                                       'out_errors': '125279',
                                                                                       'out_octets': '2576243597',
                                                                                       'out_ucast_pkts': '1895776',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMzMzMQ=='},
                                                                               {       'in_errors': '1061444',
                                                                                       'in_octets': '22033348629',
                                                                                       'in_ucast_pkts': '96797455',
                                                                                       'out_errors': '488954',
                                                                                       'out_octets': '179038668841',
                                                                                       'out_ucast_pkts': '160763414',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTM5MQ=='},
                                                                               {       'in_errors': '2267823',
                                                                                       'in_octets': '25988630317',
                                                                                       'in_ucast_pkts': '158514494',
                                                                                       'out_errors': '10277924',
                                                                                       'out_octets': '382757607427',
                                                                                       'out_ucast_pkts': '304117214',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMjYxMQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3570,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2333083',
                                                                                                                                            'distance': 9112,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMzY4MQ=='},
                                                                                                                                    {       'connected_time': '2328187',
                                                                                                                                            'distance': 2358,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNDAwNzgyMQ=='},
                                                                                                                                    {       'connected_time': '4218113',
                                                                                                                                            'distance': 2445,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MzUyMQ=='},
                                                                                                                                    {       'connected_time': '2328637',
                                                                                                                                            'distance': 4884,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjUwMQ=='},
                                                                                                                                    {       'connected_time': '2327636',
                                                                                                                                            'distance': 1400,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMTIzMQ=='},
                                                                                                                                    {       'connected_time': '1367054',
                                                                                                                                            'distance': 2780,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAzNDAwMQ=='},
                                                                                                                                    {       'connected_time': '1186089',
                                                                                                                                            'distance': 9065,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMzYxMQ=='},
                                                                                                                                    {       'connected_time': '1127235',
                                                                                                                                            'distance': 1045,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE1MDAwMDk5MQ=='},
                                                                                                                                    {       'connected_time': '4174443',
                                                                                                                                            'distance': 1835,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MzUwMQ=='},
                                                                                                                                    {       'connected_time': '1066538',
                                                                                                                                            'distance': 3041,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE1MDAwMDc1MQ=='},
                                                                                                                                    {       'connected_time': '985749',
                                                                                                                                            'distance': 6720,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMTAwODUzMQ=='},
                                                                                                                                    {       'connected_time': '985749',
                                                                                                                                            'distance': 1889,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MzUxMQ=='},
                                                                                                                                    {       'connected_time': '955819',
                                                                                                                                            'distance': 4388,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyNjAxNTc4MQ=='},
                                                                                                                                    {       'connected_time': '955004',
                                                                                                                                            'distance': 562,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1MjU0MQ=='},
                                                                                                                                    {       'connected_time': '933604',
                                                                                                                                            'distance': 6344,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxOTAyNjg1MQ=='},
                                                                                                                                    {       'connected_time': '869297',
                                                                                                                                            'distance': 7048,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyODA3Mzk2MQ=='},
                                                                                                                                    {       'connected_time': '867698',
                                                                                                                                            'distance': 1949,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAyMDk1MQ=='},
                                                                                                                                    {       'connected_time': '813966',
                                                                                                                                            'distance': 917,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3MQ=='},
                                                                                                                                    {       'connected_time': '798538',
                                                                                                                                            'distance': 1152,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyNjAxNjI0MQ=='},
                                                                                                                                    {       'connected_time': '703758',
                                                                                                                                            'distance': 2284,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0MQ=='},
                                                                                                                                    {       'connected_time': '641454',
                                                                                                                                            'distance': 3745,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NjMxMQ=='},
                                                                                                                                    {       'connected_time': '508268',
                                                                                                                                            'distance': 5025,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2MjYxMQ=='},
                                                                                                                                    {       'connected_time': '497000',
                                                                                                                                            'distance': 3356,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAwMjAyMQ=='},
                                                                                                                                    {       'connected_time': '488676',
                                                                                                                                            'distance': 9487,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA1NTAzMQ=='},
                                                                                                                                    {       'connected_time': '410319',
                                                                                                                                            'distance': 2539,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2MQ=='},
                                                                                                                                    {       'connected_time': '368250',
                                                                                                                                            'distance': 87,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAzNTk0MQ=='},
                                                                                                                                    {       'connected_time': '335400',
                                                                                                                                            'distance': 8622,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNDAwNzU0MQ=='},
                                                                                                                                    {       'connected_time': '174600',
                                                                                                                                            'distance': 6170,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzODAzNTM3MQ=='},
                                                                                                                                    {       'connected_time': '79750',
                                                                                                                                            'distance': 4991,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAwMDc5MQ=='},
                                                                                                                                    {       'connected_time': '74117',
                                                                                                                                            'distance': 4602,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAyMzMzMQ=='},
                                                                                                                                    {       'connected_time': '3994265',
                                                                                                                                            'distance': 6231,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTAwMTM5MQ=='},
                                                                                                                                    {       'connected_time': '3045811',
                                                                                                                                            'distance': 5071,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAwMjYxMQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '250',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '268131000',
                                                              'in_octets': '18621757671587',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1284453',
                                                              'out_octets': '1251393274346',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNTc2ZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNTc2ZXgy'},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIxNjAwNTc2Z2kx'}],
                                'latitude': 37.988006591796875,
                                'longitude': -88.89268493652344,
                                'manufacturer': 'Tarana',
                                'mem': 2.8632026,
                                'model': '30-0141-001',
                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2',
                                'serial_number': 'S141F2221600576',
                                'sw_version': '0.977.016.00',
                                'temperature': 45.375,
                                'uptime': '4272139'},
                'peers': [       {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '582337180223',
                                                                       'in_ucast_pkts': '400114756',
                                                                       'links': [       {       'in_octets': '582337180223',
                                                                                                'in_ucast_pkts': '400114756',
                                                                                                'out_octets': '29458572364',
                                                                                                'out_ucast_pkts': '272980031',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '29458572364',
                                                                       'out_ucast_pkts': '272980031',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzY4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2333083',
                                                                                                                                                     'distance': 9112,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '6',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20730',
                                                                       'in_octets': '29460697995',
                                                                       'in_ucast_pkts': '272960163',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '580707484000',
                                                                       'out_ucast_pkts': '400099102',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzY4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.050235748291016,
                                         'longitude': -88.8232421875,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Ben_Clements',
                                         'poller_hash': 'UzE0MkYyMjIzMDAwMzY4',
                                         'serial_number': 'S142F2223000368',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.551,
                                         'uptime': '2333414'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '283955492874',
                                                                       'in_ucast_pkts': '200080213',
                                                                       'links': [       {       'in_octets': '283955492874',
                                                                                                'in_ucast_pkts': '200080213',
                                                                                                'out_octets': '17734281013',
                                                                                                'out_ucast_pkts': '165220138',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '17734281013',
                                                                       'out_ucast_pkts': '165220138',
                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzgyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2328187',
                                                                                                                                                     'distance': 2358,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '10',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20764',
                                                                       'in_octets': '17734518984',
                                                                       'in_ucast_pkts': '165198679',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '283162571076',
                                                                       'out_ucast_pkts': '200087205',
                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzgyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.00625228881836,
                                         'longitude': -88.87940216064453,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Lewis_RobertAndRebecca_15948HQ',
                                         'poller_hash': 'UzE0MkYyMjIzNDAwNzgy',
                                         'serial_number': 'S142F2223400782',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 29.577,
                                         'uptime': '2328565'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '280092069781',
                                                                       'in_ucast_pkts': '211108010',
                                                                       'links': [       {       'in_octets': '280092069781',
                                                                                                'in_ucast_pkts': '211108010',
                                                                                                'out_octets': '18503805725',
                                                                                                'out_ucast_pkts': '96187954',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '18503805725',
                                                                       'out_ucast_pkts': '96187954',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4218113',
                                                                                                                                                     'distance': 2445,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '8',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '40809',
                                                                       'in_octets': '18576750813',
                                                                       'in_ucast_pkts': '96669278',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '279944731293',
                                                                       'out_ucast_pkts': '211669034',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.00816345214844,
                                         'longitude': -88.90579986572266,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Amanda_Hartline',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2MzUy',
                                         'serial_number': 'S142F2221706352',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.667,
                                         'uptime': '4233630'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '155636605970',
                                                                       'in_ucast_pkts': '114556323',
                                                                       'links': [       {       'in_octets': '155636605970',
                                                                                                'in_ucast_pkts': '114556323',
                                                                                                'out_octets': '9980309010',
                                                                                                'out_ucast_pkts': '69529293',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '9980309010',
                                                                       'out_ucast_pkts': '69529293',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjUwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2328637',
                                                                                                                                                     'distance': 4884,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20674',
                                                                       'in_octets': '9982457759',
                                                                       'in_ucast_pkts': '69514984',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '155176889089',
                                                                       'out_ucast_pkts': '114560685',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjUwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.01287841796875,
                                         'longitude': -88.84589385986328,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'lisa_keener_7769',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MjUw',
                                         'serial_number': 'S142F2221805250',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.125,
                                         'uptime': '2328941'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '329395571688',
                                                                       'in_ucast_pkts': '269049813',
                                                                       'links': [       {       'in_octets': '329395571688',
                                                                                                'in_ucast_pkts': '269049813',
                                                                                                'out_octets': '66556973474',
                                                                                                'out_ucast_pkts': '196693126',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '66556973474',
                                                                       'out_ucast_pkts': '196693126',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMTIzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2327636',
                                                                                                                                                     'distance': 1400,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '40',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '21028',
                                                                       'in_octets': '66580188216',
                                                                       'in_ucast_pkts': '196699050',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '328325290761',
                                                                       'out_ucast_pkts': '269050745',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMTIzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.00062942504883,
                                         'longitude': -88.88574981689453,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Linda_Swan',
                                         'poller_hash': 'UzE0MkYyMjIzMDAwMTIz',
                                         'serial_number': 'S142F2223000123',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.551,
                                         'uptime': '2328940'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1142548329069',
                                                                       'in_ucast_pkts': '801367868',
                                                                       'links': [       {       'in_octets': '1142548329069',
                                                                                                'in_ucast_pkts': '801367868',
                                                                                                'out_octets': '35372390901',
                                                                                                'out_ucast_pkts': '375899736',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '35372390901',
                                                                       'out_ucast_pkts': '375899736',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNDAwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1367054',
                                                                                                                                                     'distance': 2780,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '165',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12250',
                                                                       'in_octets': '35377008137',
                                                                       'in_ucast_pkts': '375889573',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1139300563030',
                                                                       'out_ucast_pkts': '801336036',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNDAwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.00863265991211,
                                         'longitude': -88.91160583496094,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Ronald_Lancaster_55858HQ',
                                         'poller_hash': 'UzE0MkYyMjIyMjAzNDAw',
                                         'serial_number': 'S142F2222203400',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 34.222,
                                         'uptime': '1367401'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2245801028',
                                                                       'in_ucast_pkts': '2068306',
                                                                       'links': [       {       'in_octets': '2245801028',
                                                                                                'in_ucast_pkts': '2068306',
                                                                                                'out_octets': '241212630',
                                                                                                'out_ucast_pkts': '1554229',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '241212630',
                                                                       'out_ucast_pkts': '1554229',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzYxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1186089',
                                                                                                                                                     'distance': 9065,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '21325',
                                                                       'in_octets': '447125034',
                                                                       'in_ucast_pkts': '2934971',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4580955494',
                                                                       'out_ucast_pkts': '4166755',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMzYxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.050235748291016,
                                         'longitude': -88.8232421875,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Ben_Clements',
                                         'poller_hash': 'UzE0MkYyMjIzMDAwMzYx',
                                         'serial_number': 'S142F2223000361',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 27.719,
                                         'uptime': '2330872'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '550566016064',
                                                                       'in_ucast_pkts': '368393006',
                                                                       'links': [       {       'in_octets': '550566016064',
                                                                                                'in_ucast_pkts': '368393006',
                                                                                                'out_octets': '20126393499',
                                                                                                'out_ucast_pkts': '242436242',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '20126393499',
                                                                       'out_ucast_pkts': '242436242',
                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDk5MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1127235',
                                                                                                                                                     'distance': 1045,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '29',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20702',
                                                                       'in_octets': '44450492364',
                                                                       'in_ucast_pkts': '525543532',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1175440773740',
                                                                       'out_ucast_pkts': '789883811',
                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDk5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.998291015625,
                                         'longitude': -88.88893127441406,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Charles_Bushue_19078',
                                         'poller_hash': 'UzE0MkYxMjE1MDAwMDk5',
                                         'serial_number': 'S142F1215000099',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.828,
                                         'uptime': '2328240'},
                                 {       'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1833151799',
                                                                       'in_ucast_pkts': '3478405',
                                                                       'links': [       {       'in_octets': '1833151799',
                                                                                                'in_ucast_pkts': '3478405',
                                                                                                'out_octets': '560306977',
                                                                                                'out_ucast_pkts': '3020991',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '560306977',
                                                                       'out_ucast_pkts': '3020991',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4174443',
                                                                                                                                                     'distance': 1835,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '42362',
                                                                       'in_octets': '564772135',
                                                                       'in_ucast_pkts': '3032049',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1839157029',
                                                                       'out_ucast_pkts': '3543966',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.92168426513672,
                                         'longitude': -88.89781951904297,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Susan_Quindry',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2MzUw',
                                         'serial_number': 'S142F2221706350',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.886,
                                         'uptime': '4233611'},
                                 {       'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '18954704836',
                                                                       'in_ucast_pkts': '14679626',
                                                                       'links': [       {       'in_octets': '18954704836',
                                                                                                'in_ucast_pkts': '14679626',
                                                                                                'out_octets': '1031629440',
                                                                                                'out_ucast_pkts': '8580737',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1031629440',
                                                                       'out_ucast_pkts': '8580737',
                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDc1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1066538',
                                                                                                                                                     'distance': 3041,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '37849',
                                                                       'in_octets': '10695870587',
                                                                       'in_ucast_pkts': '103260168',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '264731501163',
                                                                       'out_ucast_pkts': '194622385',
                                                                       'poller_hash': 'UzE0MkYxMjE1MDAwMDc1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.52296829223633,
                                         'longitude': -89.1353988647461,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'S142F1215000075',
                                         'poller_hash': 'UzE0MkYxMjE1MDAwMDc1',
                                         'serial_number': 'S142F1215000075',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.273,
                                         'uptime': '4177714'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '40216527668',
                                                                       'in_ucast_pkts': '31067876',
                                                                       'links': [       {       'in_octets': '40216527668',
                                                                                                'in_ucast_pkts': '31067876',
                                                                                                'out_octets': '3194813044',
                                                                                                'out_ucast_pkts': '25276597',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3194813044',
                                                                       'out_ucast_pkts': '25276597',
                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwODUzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '985749',
                                                                                                                                                     'distance': 6720,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '34608',
                                                                       'in_octets': '14085299737',
                                                                       'in_ucast_pkts': '120803415',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '189943933302',
                                                                       'out_ucast_pkts': '143814966',
                                                                       'poller_hash': 'UzE0MkYyMjIzMTAwODUzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.03328323364258,
                                         'longitude': -88.84077453613281,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Wilcox.Richard',
                                         'poller_hash': 'UzE0MkYyMjIzMTAwODUz',
                                         'serial_number': 'S142F2223100853',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.332,
                                         'uptime': '3816897'},
                                 {       'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '387769331125',
                                                                       'in_ucast_pkts': '270754772',
                                                                       'links': [       {       'in_octets': '387769331125',
                                                                                                'in_ucast_pkts': '270754772',
                                                                                                'out_octets': '21337189844',
                                                                                                'out_ucast_pkts': '227087730',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '21337189844',
                                                                       'out_ucast_pkts': '227087730',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '985749',
                                                                                                                                                     'distance': 1889,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '26',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '42482',
                                                                       'in_octets': '93513994880',
                                                                       'in_ucast_pkts': '1003775368',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1716351132639',
                                                                       'out_ucast_pkts': '1191913756',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MzUxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.001434326171875,
                                         'longitude': -88.90713500976562,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Lane_Gibbens',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2MzUx',
                                         'serial_number': 'S142F2221706351',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 33.467,
                                         'uptime': '4233656'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '94303264102',
                                                                       'in_ucast_pkts': '78323898',
                                                                       'links': [       {       'in_octets': '94303264102',
                                                                                                'in_ucast_pkts': '78323898',
                                                                                                'out_octets': '8134259991',
                                                                                                'out_ucast_pkts': '47169508',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8134259991',
                                                                       'out_ucast_pkts': '47169508',
                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNTc4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '955819',
                                                                                                                                                     'distance': 4388,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '12',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '35792',
                                                                       'in_octets': '31691256616',
                                                                       'in_ucast_pkts': '181325348',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '404900665320',
                                                                       'out_ucast_pkts': '331096808',
                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNTc4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.02140426635742,
                                         'longitude': -88.86434173583984,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Jonathan_Edwards',
                                         'poller_hash': 'UzE0MkYyMjIyNjAxNTc4',
                                         'serial_number': 'S142F2222601578',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.493,
                                         'uptime': '3711170'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '1457374909',
                                                                       'in_ucast_pkts': '1788002',
                                                                       'links': [       {       'in_octets': '1457374909',
                                                                                                'in_ucast_pkts': '1788002',
                                                                                                'out_octets': '345442010',
                                                                                                'out_ucast_pkts': '1308129',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '345442010',
                                                                       'out_ucast_pkts': '1308129',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '955004',
                                                                                                                                                     'distance': 562,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8524',
                                                                       'in_octets': '345469834',
                                                                       'in_ucast_pkts': '1299205',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1450970146',
                                                                       'out_ucast_pkts': '1790893',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1MjU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.992591857910156,
                                         'longitude': -88.89274597167969,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Sherry_drysdale',
                                         'poller_hash': 'UzE0MkYyMjIxODA1MjU0',
                                         'serial_number': 'S142F2221805254',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.273,
                                         'uptime': '955364'},
                                 {       'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '69773423798',
                                                                       'in_ucast_pkts': '56700032',
                                                                       'links': [       {       'in_octets': '69773423798',
                                                                                                'in_ucast_pkts': '56700032',
                                                                                                'out_octets': '6604497835',
                                                                                                'out_ucast_pkts': '43759625',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6604497835',
                                                                       'out_ucast_pkts': '43759625',
                                                                       'poller_hash': 'UzE0MkYyMjIxOTAyNjg1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '933604',
                                                                                                                                                     'distance': 6344,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8361',
                                                                       'in_octets': '6604751972',
                                                                       'in_ucast_pkts': '43751102',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '69548337004',
                                                                       'out_ucast_pkts': '56700667',
                                                                       'poller_hash': 'UzE0MkYyMjIxOTAyNjg1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.04445266723633,
                                         'longitude': -88.87718200683594,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Sanders_Leon_15612',
                                         'poller_hash': 'UzE0MkYyMjIxOTAyNjg1',
                                         'serial_number': 'S142F2221902685',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.622,
                                         'uptime': '934059'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '84155474302',
                                                                       'in_ucast_pkts': '61825004',
                                                                       'links': [       {       'in_octets': '84155474302',
                                                                                                'in_ucast_pkts': '61825004',
                                                                                                'out_octets': '5535733148',
                                                                                                'out_ucast_pkts': '46773258',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5535733148',
                                                                       'out_ucast_pkts': '46773258',
                                                                       'poller_hash': 'UzE0MkYyMjIyODA3Mzk2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '869297',
                                                                                                                                                     'distance': 7048,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20735',
                                                                       'in_octets': '16000129359',
                                                                       'in_ucast_pkts': '143112525',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '250068350547',
                                                                       'out_ucast_pkts': '181752669',
                                                                       'poller_hash': 'UzE0MkYyMjIyODA3Mzk2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.03420639038086,
                                         'longitude': -88.83478546142578,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Elaine_Rich',
                                         'poller_hash': 'UzE0MkYyMjIyODA3Mzk2',
                                         'serial_number': 'S142F2222807396',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.448,
                                         'uptime': '2328932'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '21690877062',
                                                                       'in_ucast_pkts': '16057690',
                                                                       'links': [       {       'in_octets': '21690877062',
                                                                                                'in_ucast_pkts': '16057690',
                                                                                                'out_octets': '1279354917',
                                                                                                'out_ucast_pkts': '8414644',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1279354917',
                                                                       'out_ucast_pkts': '8414644',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMDk1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '867698',
                                                                                                                                                     'distance': 1949,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '32102',
                                                                       'in_octets': '6319262784',
                                                                       'in_ucast_pkts': '43363931',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '114088647008',
                                                                       'out_ucast_pkts': '83153812',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMDk1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.001102447509766,
                                         'longitude': -88.90853881835938,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'John_Grutzius',
                                         'poller_hash': 'UzE0MkYyMjIyMDAyMDk1',
                                         'serial_number': 'S142F2222002095',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 34.047,
                                         'uptime': '3550167'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '15504858207',
                                                                       'in_ucast_pkts': '10892170',
                                                                       'links': [       {       'in_octets': '15504858207',
                                                                                                'in_ucast_pkts': '10892170',
                                                                                                'out_octets': '692907235',
                                                                                                'out_ucast_pkts': '5088086',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '692907235',
                                                                       'out_ucast_pkts': '5088086',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '813966',
                                                                                                                                                     'distance': 917,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '14',
                                                                       'in_errors': '2',
                                                                       'in_nucast_pkts': '39552',
                                                                       'in_octets': '2598996124',
                                                                       'in_ucast_pkts': '25579758',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '67011146968',
                                                                       'out_ucast_pkts': '46378996',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.99394989013672,
                                         'longitude': -88.90081024169922,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'David_Moss',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1NDQ3',
                                         'serial_number': 'S142F2222205447',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.957,
                                         'uptime': '4233649'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '128922670071',
                                                                       'in_ucast_pkts': '87797648',
                                                                       'links': [       {       'in_octets': '128922670071',
                                                                                                'in_ucast_pkts': '87797648',
                                                                                                'out_octets': '5958544442',
                                                                                                'out_ucast_pkts': '60644078',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5958544442',
                                                                       'out_ucast_pkts': '60644078',
                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNjI0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '798538',
                                                                                                                                                     'distance': 1152,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '1',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '7877',
                                                                       'in_octets': '5960687490',
                                                                       'in_ucast_pkts': '60654671',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '128580226998',
                                                                       'out_ucast_pkts': '87824883',
                                                                       'poller_hash': 'UzE0MkYyMjIyNjAxNjI0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.995784759521484,
                                         'longitude': -88.88191223144531,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Shelton_7260',
                                         'poller_hash': 'UzE0MkYyMjIyNjAxNjI0',
                                         'serial_number': 'S142F2222601624',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.215,
                                         'uptime': '799296'},
                                 {       'elevation': 7.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '22270246612',
                                                                       'in_ucast_pkts': '15828062',
                                                                       'links': [       {       'in_octets': '22270246612',
                                                                                                'in_ucast_pkts': '15828062',
                                                                                                'out_octets': '1037550466',
                                                                                                'out_ucast_pkts': '8704176',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1037550466',
                                                                       'out_ucast_pkts': '8704176',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '703758',
                                                                                                                                                     'distance': 2284,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '8',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '41425',
                                                                       'in_octets': '12247415710',
                                                                       'in_ucast_pkts': '113616126',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '275929503245',
                                                                       'out_ucast_pkts': '192773892',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.005714416503906,
                                         'longitude': -88.90699005126953,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Matt_Garrett',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2Mzc0',
                                         'serial_number': 'S142F2221706374',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 31.086,
                                         'uptime': '4233628'},
                                 {       'elevation': 10.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '252508155788',
                                                                       'in_ucast_pkts': '181631369',
                                                                       'links': [       {       'in_octets': '252508155788',
                                                                                                'in_ucast_pkts': '181631369',
                                                                                                'out_octets': '13871078358',
                                                                                                'out_ucast_pkts': '97025735',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '13871078358',
                                                                       'out_ucast_pkts': '97025735',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NjMxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '641454',
                                                                                                                                                     'distance': 3745,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '5',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '36291',
                                                                       'in_octets': '14912984117',
                                                                       'in_ucast_pkts': '105032308',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '266485437369',
                                                                       'out_ucast_pkts': '194363883',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NjMxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.01695251464844,
                                         'longitude': -88.8694839477539,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'Ferrell_Winemiller',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1NjMx',
                                         'serial_number': 'S142F2222205631',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 33.873,
                                         'uptime': '2328960'},
                                 {       'elevation': 20.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '580103542',
                                                                       'in_ucast_pkts': '550207',
                                                                       'links': [       {       'in_octets': '580103542',
                                                                                                'in_ucast_pkts': '550207',
                                                                                                'out_octets': '59274912',
                                                                                                'out_ucast_pkts': '475424',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '59274912',
                                                                       'out_ucast_pkts': '475424',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MjYxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '508268',
                                                                                                                                                     'distance': 5025,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '114984',
                                                                       'in_octets': '683461667',
                                                                       'in_ucast_pkts': '5559169',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '9480686856',
                                                                       'out_ucast_pkts': '8246498',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2MjYxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.023128509521484,
                                         'longitude': -88.85501861572266,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.6467916,
                                         'model': '30-0142-001',
                                         'name': 'ronald_rose',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2MjYx',
                                         'serial_number': 'S142F2221706261',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.796,
                                         'uptime': '3889598'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '24051396484',
                                                                       'in_ucast_pkts': '19322858',
                                                                       'links': [       {       'in_octets': '24051396484',
                                                                                                'in_ucast_pkts': '19322858',
                                                                                                'out_octets': '1257486737',
                                                                                                'out_ucast_pkts': '9251466',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1257486737',
                                                                       'out_ucast_pkts': '9251466',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMjAyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '497000',
                                                                                                                                                     'distance': 3356,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4565',
                                                                       'in_octets': '1257572370',
                                                                       'in_ucast_pkts': '9246443',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '23973207484',
                                                                       'out_ucast_pkts': '19323235',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMjAyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.01100540161133,
                                         'longitude': -88.91854095458984,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'William_Armstrong',
                                         'poller_hash': 'UzE0MkYyMjIzNTAwMjAy',
                                         'serial_number': 'S142F2223500202',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 29.751,
                                         'uptime': '497316'},
                                 {       'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '140398968101',
                                                                       'in_ucast_pkts': '97085680',
                                                                       'links': [       {       'in_octets': '140398968101',
                                                                                                'in_ucast_pkts': '97085680',
                                                                                                'out_octets': '5174840865',
                                                                                                'out_ucast_pkts': '44486433',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5174840865',
                                                                       'out_ucast_pkts': '44486433',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTAzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '488676',
                                                                                                                                                     'distance': 9487,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '21',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '28122',
                                                                       'in_octets': '23131267296',
                                                                       'in_ucast_pkts': '220427275',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '698677196047',
                                                                       'out_ucast_pkts': '481444584',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA1NTAzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.04951095581055,
                                         'longitude': -88.8168716430664,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Kelsey_Stroud',
                                         'poller_hash': 'UzE0MkYyMjIyMjA1NTAz',
                                         'serial_number': 'S142F2222205503',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.996,
                                         'uptime': '2261784'},
                                 {       'elevation': 6.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '16927660191',
                                                                       'in_ucast_pkts': '14661232',
                                                                       'links': [       {       'in_octets': '16927660191',
                                                                                                'in_ucast_pkts': '14661232',
                                                                                                'out_octets': '1262509508',
                                                                                                'out_ucast_pkts': '7229877',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1262509508',
                                                                       'out_ucast_pkts': '7229877',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '410319',
                                                                                                                                                     'distance': 2539,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '45871',
                                                                       'in_octets': '12059435024',
                                                                       'in_ucast_pkts': '53891611',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '123364818270',
                                                                       'out_ucast_pkts': '113545243',
                                                                       'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.008548736572266,
                                         'longitude': -88.90560913085938,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7035775,
                                         'model': '30-0142-001',
                                         'name': 'Marsha_Wyant',
                                         'poller_hash': 'UzE0MkYyMjIxNzA2Mzc2',
                                         'serial_number': 'S142F2221706376',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 32.77,
                                         'uptime': '4233666'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '184101143312',
                                                                       'in_ucast_pkts': '125280866',
                                                                       'links': [       {       'in_octets': '184101143312',
                                                                                                'in_ucast_pkts': '125280866',
                                                                                                'out_octets': '7743503178',
                                                                                                'out_ucast_pkts': '85439536',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '7743503178',
                                                                       'out_ucast_pkts': '85439536',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNTk0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '368250',
                                                                                                                                                     'distance': 87,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3504',
                                                                       'in_octets': '7743173067',
                                                                       'in_ucast_pkts': '85430448',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '183581126420',
                                                                       'out_ucast_pkts': '125269074',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAzNTk0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 37.98866653442383,
                                         'longitude': -88.89169311523438,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Dawn_Sullivan_8311HQ',
                                         'poller_hash': 'UzE0MkYyMjIyMjAzNTk0',
                                         'serial_number': 'S142F2222203594',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.357,
                                         'uptime': '369094'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '33247475528',
                                                                       'in_ucast_pkts': '27175994',
                                                                       'links': [       {       'in_octets': '33247475528',
                                                                                                'in_ucast_pkts': '27175994',
                                                                                                'out_octets': '2649795479',
                                                                                                'out_ucast_pkts': '15291496',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '2649795479',
                                                                       'out_ucast_pkts': '15291496',
                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzU0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '335400',
                                                                                                                                                     'distance': 8622,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '3',
                                                                       'in_errors': '2',
                                                                       'in_nucast_pkts': '3146',
                                                                       'in_octets': '2651067949',
                                                                       'in_ucast_pkts': '15290204',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '33131363466',
                                                                       'out_ucast_pkts': '27170621',
                                                                       'poller_hash': 'UzE0MkYyMjIzNDAwNzU0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.03839874267578,
                                         'longitude': -88.81697082519531,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'JonesArview_22099',
                                         'poller_hash': 'UzE0MkYyMjIzNDAwNzU0',
                                         'serial_number': 'S142F2223400754',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 29.751,
                                         'uptime': '335792'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '8424206679',
                                                                       'in_ucast_pkts': '7895845',
                                                                       'links': [       {       'in_octets': '8424206679',
                                                                                                'in_ucast_pkts': '7895845',
                                                                                                'out_octets': '1094492842',
                                                                                                'out_ucast_pkts': '6887613',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1094492842',
                                                                       'out_ucast_pkts': '6887613',
                                                                       'poller_hash': 'UzE0MkYyMjIzODAzNTM3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174600',
                                                                                                                                                     'distance': 6170,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1687',
                                                                       'in_octets': '1094898429',
                                                                       'in_ucast_pkts': '6886392',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '8392731846',
                                                                       'out_ucast_pkts': '7896277',
                                                                       'poller_hash': 'UzE0MkYyMjIzODAzNTM3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.042510986328125,
                                         'longitude': -88.9098129272461,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Stowers_Derek_19338HQ',
                                         'poller_hash': 'UzE0MkYyMjIzODAzNTM3',
                                         'serial_number': 'S142F2223803537',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 30.738,
                                         'uptime': '175142'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '378606716',
                                                                       'in_ucast_pkts': '530178',
                                                                       'links': [       {       'in_octets': '378606716',
                                                                                                'in_ucast_pkts': '530178',
                                                                                                'out_octets': '52129655',
                                                                                                'out_ucast_pkts': '466077',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '52129655',
                                                                       'out_ucast_pkts': '466077',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMDc5MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '79750',
                                                                                                                                                     'distance': 4991,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '864',
                                                                       'in_octets': '52167573',
                                                                       'in_ucast_pkts': '465125',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '376415348',
                                                                       'out_ucast_pkts': '529968',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMDc5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.023128509521484,
                                         'longitude': -88.85501861572266,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'merrill_rose_8486',
                                         'poller_hash': 'UzE0MkYyMjIyMDAwMDc5',
                                         'serial_number': 'S142F2222000079',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.416,
                                         'uptime': '80297'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2576243597',
                                                                       'in_ucast_pkts': '1895776',
                                                                       'links': [       {       'in_octets': '2576243597',
                                                                                                'in_ucast_pkts': '1895776',
                                                                                                'out_octets': '105755144',
                                                                                                'out_ucast_pkts': '955277',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '105755144',
                                                                       'out_ucast_pkts': '955277',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMzMzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '74117',
                                                                                                                                                     'distance': 4602,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6359',
                                                                       'in_octets': '985946153',
                                                                       'in_ucast_pkts': '7968892',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '22850546779',
                                                                       'out_ucast_pkts': '17453875',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAyMzMzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.02571105957031,
                                         'longitude': -88.86808013916016,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5332198,
                                         'model': '30-0142-001',
                                         'name': 'Forsythe_Sandy_20054',
                                         'poller_hash': 'UzE0MkYyMjIyMDAyMzMz',
                                         'serial_number': 'S142F2222002333',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.532,
                                         'uptime': '661675'},
                                 {       'elevation': 562.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '179038668841',
                                                                       'in_ucast_pkts': '160763414',
                                                                       'links': [       {       'in_octets': '179038668841',
                                                                                                'in_ucast_pkts': '160763414',
                                                                                                'out_octets': '22033348629',
                                                                                                'out_ucast_pkts': '96797455',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '22033348629',
                                                                       'out_ucast_pkts': '96797455',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTM5MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3994265',
                                                                                                                                                     'distance': 6231,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '2',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '359',
                                                                       'in_octets': '22041711824',
                                                                       'in_ucast_pkts': '96812672',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '178401912680',
                                                                       'out_ucast_pkts': '160800775',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTAwMTM5Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.0434684753418,
                                         'longitude': -88.90764617919922,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Ricky_Robinson',
                                         'poller_hash': 'UzE0MkYyMjIzNTAwMTM5',
                                         'serial_number': 'S142F2223500139',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 28.416,
                                         'uptime': '3994762'},
                                 {       'elevation': 10.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '382757607427',
                                                                       'in_ucast_pkts': '304117214',
                                                                       'links': [       {       'in_octets': '382757607427',
                                                                                                'in_ucast_pkts': '304117214',
                                                                                                'out_octets': '25988630317',
                                                                                                'out_ucast_pkts': '158514494',
                                                                                                'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '25988630317',
                                                                       'out_ucast_pkts': '158514494',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMjYxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3570,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3045811',
                                                                                                                                                     'distance': 5071,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIxNjAwNTc2d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '4',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '27263',
                                                                       'in_octets': '25995742125',
                                                                       'in_ucast_pkts': '158498786',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '381545853417',
                                                                       'out_ucast_pkts': '304125775',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMjYxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 38.03155517578125,
                                         'longitude': -88.87805938720703,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5900056,
                                         'model': '30-0142-001',
                                         'name': 'Poole_Dennis_17811',
                                         'poller_hash': 'UzE0MkYyMjIyMDAwMjYx',
                                         'serial_number': 'S142F2222000261',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.977.016.00',
                                         'temperature': 27.719,
                                         'uptime': '3046131'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_988_004_00_10_100_0_10(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.988.004.00.10_100_0_10")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 4,
                'sw_version': '0.988.004.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2222312193',
                'system_mac_address': '04:f1:7d:00:89:64',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:00:2a:60': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 744027980,
                                             'dl_rf_packets': 630686,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2a:60',
                                             'name': '1277-PAXTON_HANGAR-FREE-R',
                                             'serial_number': 'S154F1212600026',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 87655892,
                                             'ul_rf_packets': 240998},
                '04:f1:7d:00:2b:67': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 449024948,
                                             'dl_rf_packets': 402242,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2b:67',
                                             'name': '1279-PAXTON_TOWN_HALL-FREE-R',
                                             'serial_number': 'S154F1212900008',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 52878472,
                                             'ul_rf_packets': 333004},
                '04:f1:7d:00:3c:e1': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 699707366688,
                                             'dl_rf_packets': 527943854,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3c:e1',
                                             'name': '492-SCOTT_ANDERSON-RES100-R',
                                             'serial_number': 'S142F1214900123',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 149350617247,
                                             'ul_rf_packets': 430040870},
                '04:f1:7d:00:ef:7d': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 63168865530,
                                             'dl_rf_packets': 50067436,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:ef:7d',
                                             'name': '2382-SHELLEY_SMITH-RES100-R',
                                             'serial_number': 'S142F2224001956',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 4207592885,
                                             'ul_rf_packets': 21011515}
        }
        exp_ne_msg = {
                'data': {       'cpu': 33.175354,
                                'elevation': 167.032,
                                'gps_sats_tracked': 16,
                                'height': 0.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '11219299',
                                                                                       'in_octets': '149350617247',
                                                                                       'in_ucast_pkts': '430040870',
                                                                                       'out_errors': '38693684',
                                                                                       'out_octets': '699707366688',
                                                                                       'out_ucast_pkts': '527943854',
                                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMTIzMQ=='},
                                                                               {       'in_errors': '131054',
                                                                                       'in_octets': '4207592885',
                                                                                       'in_ucast_pkts': '21011515',
                                                                                       'out_errors': '1299750',
                                                                                       'out_octets': '63168865530',
                                                                                       'out_ucast_pkts': '50067436',
                                                                                       'poller_hash': 'UzE0MkYyMjI0MDAxOTU2MQ=='},
                                                                               {       'in_errors': '7012',
                                                                                       'in_octets': '52878472',
                                                                                       'in_ucast_pkts': '333004',
                                                                                       'out_errors': '263',
                                                                                       'out_octets': '449024948',
                                                                                       'out_ucast_pkts': '402242',
                                                                                       'poller_hash': 'UzE1NEYxMjEyOTAwMDA4MQ=='},
                                                                               {       'in_errors': '3817',
                                                                                       'in_octets': '87655892',
                                                                                       'in_ucast_pkts': '240998',
                                                                                       'out_errors': '14563',
                                                                                       'out_octets': '744027980',
                                                                                       'out_ucast_pkts': '630686',
                                                                                       'poller_hash': 'UzE1NEYxMjEyNjAwMDI2MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3600,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1757526',
                                                                                                                                            'distance': 2144,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0OTAwMTIzMQ=='},
                                                                                                                                    {       'connected_time': '710026',
                                                                                                                                            'distance': 314,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjI0MDAxOTU2MQ=='},
                                                                                                                                    {       'connected_time': '458583',
                                                                                                                                            'distance': 710,
                                                                                                                                            'poller_hash': 'UzE1NEYxMjEyOTAwMDA4MQ=='},
                                                                                                                                    {       'connected_time': '155326',
                                                                                                                                            'distance': 247,
                                                                                                                                            'poller_hash': 'UzE1NEYxMjEyNjAwMDI2MQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': True,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '492',
                                                              'out_octets': '36490',
                                                              'poller_hash': 'UzE0MUYyMjIyMzEyMTkzZ2kx'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '4',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2175250',
                                                              'in_octets': '965834268472',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1201191',
                                                              'out_octets': '194569597528',
                                                              'poller_hash': 'UzE0MUYyMjIyMzEyMTkzZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': True,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '147',
                                                              'out_octets': '11010',
                                                              'poller_hash': 'UzE0MUYyMjIyMzEyMTkzZXgy'}],
                                'latitude': 30.96637725830078,
                                'longitude': -86.30143737792969,
                                'manufacturer': 'Tarana',
                                'mem': 2.2269354,
                                'model': '30-0141-001',
                                'poller_hash': 'UzE0MUYyMjIyMzEyMTkz',
                                'serial_number': 'S141F2222312193',
                                'sw_version': '0.988.004.00',
                                'system_mac_address': '04:f1:7d:00:89:64',
                                'temperature': 47.625,
                                'uptime': '1758163'},
                'peers': [       {       'elevation': 10.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '699707366688',
                                                                       'in_ucast_pkts': '527943854',
                                                                       'links': [       {       'in_octets': '699707366688',
                                                                                                'in_ucast_pkts': '527943854',
                                                                                                'out_octets': '149350617247',
                                                                                                'out_ucast_pkts': '430040870',
                                                                                                'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '149350617247',
                                                                       'out_ucast_pkts': '430040870',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMTIzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3600,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1757526',
                                                                                                                                                     'distance': 2144,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '106230',
                                                                       'in_octets': '157647907724',
                                                                       'in_ucast_pkts': '485839168',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '833441793758',
                                                                       'out_ucast_pkts': '625196860',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMTIzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.98595428466797,
                                         'longitude': -86.30738830566406,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.645857,
                                         'model': '30-0142-001',
                                         'name': '492-SCOTT_ANDERSON-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0OTAwMTIz',
                                         'serial_number': 'S142F1214900123',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3c:e1',
                                         'temperature': 26.906,
                                         'uptime': '2113810'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '63168865530',
                                                                       'in_ucast_pkts': '50067436',
                                                                       'links': [       {       'in_octets': '63168865530',
                                                                                                'in_ucast_pkts': '50067436',
                                                                                                'out_octets': '4207592885',
                                                                                                'out_ucast_pkts': '21011515',
                                                                                                'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '4207592885',
                                                                       'out_ucast_pkts': '21011515',
                                                                       'poller_hash': 'UzE0MkYyMjI0MDAxOTU2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3600,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '710026',
                                                                                                                                                     'distance': 314,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '189318',
                                                                       'in_octets': '4207577329',
                                                                       'in_ucast_pkts': '20821575',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '62965902615',
                                                                       'out_ucast_pkts': '50066246',
                                                                       'poller_hash': 'UzE0MkYyMjI0MDAxOTU2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.96765899658203,
                                         'longitude': -86.29730987548828,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '2382-SHELLEY_SMITH-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjI0MDAxOTU2',
                                         'serial_number': 'S142F2224001956',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:ef:7d',
                                         'temperature': 27.138,
                                         'uptime': '710202'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '449024948',
                                                                       'in_ucast_pkts': '402242',
                                                                       'links': [       {       'in_octets': '449024948',
                                                                                                'in_ucast_pkts': '402242',
                                                                                                'out_octets': '52878472',
                                                                                                'out_ucast_pkts': '333004',
                                                                                                'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '52878472',
                                                                       'out_ucast_pkts': '333004',
                                                                       'poller_hash': 'UzE1NEYxMjEyOTAwMDA4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3600,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '458583',
                                                                                                                                                     'distance': 710,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2197550',
                                                                       'in_octets': '1180589733',
                                                                       'in_ucast_pkts': '3407134',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '6219157012',
                                                                       'out_ucast_pkts': '6131870',
                                                                       'poller_hash': 'UzE1NEYxMjEyOTAwMDA4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.973705291748047,
                                         'longitude': -86.30252075195312,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7593644,
                                         'model': '30-0154-001',
                                         'name': '1279-PAXTON_TOWN_HALL-FREE-R',
                                         'poller_hash': 'UzE1NEYxMjEyOTAwMDA4',
                                         'serial_number': 'S154F1212900008',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:2b:67',
                                         'temperature': 24.7,
                                         'uptime': '8413055'},
                                 {       'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '744027980',
                                                                       'in_ucast_pkts': '630686',
                                                                       'links': [       {       'in_octets': '744027980',
                                                                                                'in_ucast_pkts': '630686',
                                                                                                'out_octets': '87655892',
                                                                                                'out_ucast_pkts': '240998',
                                                                                                'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '87655892',
                                                                       'out_ucast_pkts': '240998',
                                                                       'poller_hash': 'UzE1NEYxMjEyNjAwMDI2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3600,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '155326',
                                                                                                                                                     'distance': 247,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIyMzEyMTkzd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '38862',
                                                                       'in_octets': '87669562',
                                                                       'in_ucast_pkts': '202112',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '741539322',
                                                                       'out_ucast_pkts': '631062',
                                                                       'poller_hash': 'UzE1NEYxMjEyNjAwMDI2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.969141006469727,
                                         'longitude': -86.30290222167969,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0154-001',
                                         'name': '1277-PAXTON_HANGAR-FREE-R',
                                         'poller_hash': 'UzE1NEYxMjEyNjAwMDI2',
                                         'serial_number': 'S154F1212600026',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:2a:60',
                                         'temperature': 26.325,
                                         'uptime': '155526'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_988_004_00_10_100_48_13(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.988.004.00.10_100_48_13")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 8,
                'sw_version': '0.988.004.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2220901414',
                'system_mac_address': '04:f1:7d:00:5f:66',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:00:15:f7': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 205147713230,
                                             'dl_rf_packets': 172452661,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:15:f7',
                                             'name': '2451-YESEINA_BAEZ-RES100-R',
                                             'serial_number': 'S142T1222000197',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 35512396951,
                                             'ul_rf_packets': 86319564},
                '04:f1:7d:00:3d:c8': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 221661144390,
                                             'dl_rf_packets': 153996954,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3d:c8',
                                             'name': '1599-MALLORY_WALKER-RES100-R',
                                             'serial_number': 'S142T1221800184',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 10252302492,
                                             'ul_rf_packets': 102314595},
                '04:f1:7d:00:7b:2f': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 63707524421,
                                             'dl_rf_packets': 47670224,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:7b:2f',
                                             'name': '2438-JENNIFER_PORTER-RES100-R',
                                             'serial_number': 'S142F2222000004',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 6924681685,
                                             'ul_rf_packets': 31089444},
                '04:f1:7d:00:8b:f7': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 763395400920,
                                             'dl_rf_packets': 585682239,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:8b:f7',
                                             'name': '495-DONALD_ILLICH-RES100-R',
                                             'serial_number': 'S142F2222311550',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 64756243482,
                                             'ul_rf_packets': 401152170},
                '04:f1:7d:00:8f:18': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 57916192266,
                                             'dl_rf_packets': 53573565,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:8f:18',
                                             'name': '2540-CORINNE_PORTER-RES100-R',
                                             'serial_number': 'S142F2222312036',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 11992222481,
                                             'ul_rf_packets': 40332401},
                '04:f1:7d:00:a1:a1': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 113566396005,
                                             'dl_rf_packets': 79125564,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:a1:a1',
                                             'name': '40-AL_SILVANI-RES100-R',
                                             'serial_number': 'S142F2223000106',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 6524781118,
                                             'ul_rf_packets': 43441557},
                '04:f1:7d:00:b5:5d': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 195638759619,
                                             'dl_rf_packets': 147117966,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:b5:5d',
                                             'name': '1647-WAYNE_GRANDSTAFF-RES100-R',
                                             'serial_number': 'S142F2223001498',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 11154179181,
                                             'ul_rf_packets': 78445210},
                '04:f1:7d:01:14:f7': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 701496177336,
                                             'dl_rf_packets': 494643130,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:14:f7',
                                             'name': '2421-TANYA_RATHBURN-RES100-R',
                                             'serial_number': 'S142F2224307075',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 28523807994,
                                             'ul_rf_packets': 231065309}
        }
        exp_ne_msg = {
                'data': {       'cpu': 50.556404,
                                'elevation': 130.886,
                                'gps_sats_tracked': 13,
                                'height': 0.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '7831674',
                                                                                       'in_octets': '64756243482',
                                                                                       'in_ucast_pkts': '401152170',
                                                                                       'out_errors': '28832640',
                                                                                       'out_octets': '763395400920',
                                                                                       'out_ucast_pkts': '585682239',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMzExNTUwMQ=='},
                                                                               {       'in_errors': '222548',
                                                                                       'in_octets': '11992222481',
                                                                                       'in_ucast_pkts': '40332401',
                                                                                       'out_errors': '2781123',
                                                                                       'out_octets': '57916192266',
                                                                                       'out_ucast_pkts': '53573565',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMzEyMDM2MQ=='},
                                                                               {       'in_errors': '652817',
                                                                                       'in_octets': '11154179181',
                                                                                       'in_ucast_pkts': '78445210',
                                                                                       'out_errors': '4570860',
                                                                                       'out_octets': '195638759619',
                                                                                       'out_ucast_pkts': '147117966',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMDAxNDk4MQ=='},
                                                                               {       'in_errors': '668023',
                                                                                       'in_octets': '6924681685',
                                                                                       'in_ucast_pkts': '31089444',
                                                                                       'out_errors': '3183173',
                                                                                       'out_octets': '63707524421',
                                                                                       'out_ucast_pkts': '47670224',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMDA0MQ=='},
                                                                               {       'in_errors': '847321',
                                                                                       'in_octets': '6524781118',
                                                                                       'in_ucast_pkts': '43441557',
                                                                                       'out_errors': '3789449',
                                                                                       'out_octets': '113566396005',
                                                                                       'out_ucast_pkts': '79125564',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMTA2MQ=='},
                                                                               {       'in_errors': '2830574',
                                                                                       'in_octets': '28523807994',
                                                                                       'in_ucast_pkts': '231065309',
                                                                                       'out_errors': '16744585',
                                                                                       'out_octets': '701496177336',
                                                                                       'out_ucast_pkts': '494643130',
                                                                                       'poller_hash': 'UzE0MkYyMjI0MzA3MDc1MQ=='},
                                                                               {       'in_errors': '1052405',
                                                                                       'in_octets': '10252302492',
                                                                                       'in_ucast_pkts': '102314595',
                                                                                       'out_errors': '4140480',
                                                                                       'out_octets': '221661144390',
                                                                                       'out_ucast_pkts': '153996954',
                                                                                       'poller_hash': 'UzE0MlQxMjIxODAwMTg0MQ=='},
                                                                               {       'in_errors': '1986186',
                                                                                       'in_octets': '35512396951',
                                                                                       'in_ucast_pkts': '86319564',
                                                                                       'out_errors': '7930994',
                                                                                       'out_octets': '205147713230',
                                                                                       'out_ucast_pkts': '172452661',
                                                                                       'poller_hash': 'UzE0MlQxMjIyMDAwMTk3MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3580,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '3799055',
                                                                                                                                            'distance': 2659,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMzExNTUwMQ=='},
                                                                                                                                    {       'connected_time': '1655515',
                                                                                                                                            'distance': 1815,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMzEyMDM2MQ=='},
                                                                                                                                    {       'connected_time': '941945',
                                                                                                                                            'distance': 2318,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAxNDk4MQ=='},
                                                                                                                                    {       'connected_time': '768395',
                                                                                                                                            'distance': 1487,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMDAwMDA0MQ=='},
                                                                                                                                    {       'connected_time': '768385',
                                                                                                                                            'distance': 2988,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwMTA2MQ=='},
                                                                                                                                    {       'connected_time': '768185',
                                                                                                                                            'distance': 2927,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjI0MzA3MDc1MQ=='},
                                                                                                                                    {       'connected_time': '768105',
                                                                                                                                            'distance': 2291,
                                                                                                                                            'poller_hash': 'UzE0MlQxMjIxODAwMTg0MQ=='},
                                                                                                                                    {       'connected_time': '768005',
                                                                                                                                            'distance': 2311,
                                                                                                                                            'poller_hash': 'UzE0MlQxMjIyMDAwMTk3MQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIwOTAxNDE0Z2kx'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '17',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '3537697',
                                                              'in_octets': '7456751926822',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '7828449',
                                                              'out_octets': '825819992593',
                                                              'poller_hash': 'UzE0MUYyMjIwOTAxNDE0ZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIwOTAxNDE0ZXgy'}],
                                'latitude': 30.77254867553711,
                                'longitude': -86.35140228271484,
                                'manufacturer': 'Tarana',
                                'mem': 2.7041357,
                                'model': '30-0141-001',
                                'poller_hash': 'UzE0MUYyMjIwOTAxNDE0',
                                'serial_number': 'S141F2220901414',
                                'sw_version': '0.988.004.00',
                                'system_mac_address': '04:f1:7d:00:5f:66',
                                'temperature': 48.637,
                                'uptime': '4425272'},
                'peers': [       {       'elevation': 10.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '763395400920',
                                                                       'in_ucast_pkts': '585682239',
                                                                       'links': [       {       'in_octets': '763395400920',
                                                                                                'in_ucast_pkts': '585682239',
                                                                                                'out_octets': '64756243482',
                                                                                                'out_ucast_pkts': '401152170',
                                                                                                'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '64756243482',
                                                                       'out_ucast_pkts': '401152170',
                                                                       'poller_hash': 'UzE0MkYyMjIyMzExNTUwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3580,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3799055',
                                                                                                                                                     'distance': 2659,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '949141',
                                                                       'in_octets': '64765921153',
                                                                       'in_ucast_pkts': '400213518',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '761044429864',
                                                                       'out_ucast_pkts': '585673457',
                                                                       'poller_hash': 'UzE0MkYyMjIyMzExNTUwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.77817153930664,
                                         'longitude': -86.37969970703125,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.645857,
                                         'model': '30-0142-001',
                                         'name': '495-DONALD_ILLICH-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIyMzExNTUw',
                                         'serial_number': 'S142F2222311550',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:8b:f7',
                                         'temperature': 36.312,
                                         'uptime': '3799384'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '57916192266',
                                                                       'in_ucast_pkts': '53573565',
                                                                       'links': [       {       'in_octets': '57916192266',
                                                                                                'in_ucast_pkts': '53573565',
                                                                                                'out_octets': '11992222481',
                                                                                                'out_ucast_pkts': '40332401',
                                                                                                'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '11992222481',
                                                                       'out_ucast_pkts': '40332401',
                                                                       'poller_hash': 'UzE0MkYyMjIyMzEyMDM2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3580,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1655515',
                                                                                                                                                     'distance': 1815,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '386030',
                                                                       'in_octets': '11992455731',
                                                                       'in_ucast_pkts': '39945910',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '57706709515',
                                                                       'out_ucast_pkts': '53577208',
                                                                       'poller_hash': 'UzE0MkYyMjIyMzEyMDM2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.781164169311523,
                                         'longitude': -86.36888122558594,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '2540-CORINNE_PORTER-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIyMzEyMDM2',
                                         'serial_number': 'S142F2222312036',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:8f:18',
                                         'temperature': 30.157,
                                         'uptime': '1655715'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '195638759619',
                                                                       'in_ucast_pkts': '147117966',
                                                                       'links': [       {       'in_octets': '195638759619',
                                                                                                'in_ucast_pkts': '147117966',
                                                                                                'out_octets': '11154179181',
                                                                                                'out_ucast_pkts': '78445210',
                                                                                                'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '11154179181',
                                                                       'out_ucast_pkts': '78445210',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAxNDk4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3580,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '941945',
                                                                                                                                                     'distance': 2318,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '2',
                                                                       'in_nucast_pkts': '1178820',
                                                                       'in_octets': '52080270972',
                                                                       'in_ucast_pkts': '391824492',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1006423478935',
                                                                       'out_ucast_pkts': '770887832',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAxNDk4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.78265953063965,
                                         'longitude': -86.37393951416016,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7026106,
                                         'model': '30-0142-001',
                                         'name': '1647-WAYNE_GRANDSTAFF-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIzMDAxNDk4',
                                         'serial_number': 'S142F2223001498',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:b5:5d',
                                         'temperature': 35.209,
                                         'uptime': '4423376'},
                                 {       'elevation': 3.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '63707524421',
                                                                       'in_ucast_pkts': '47670224',
                                                                       'links': [       {       'in_octets': '63707524421',
                                                                                                'in_ucast_pkts': '47670224',
                                                                                                'out_octets': '6924681685',
                                                                                                'out_ucast_pkts': '31089444',
                                                                                                'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6924681685',
                                                                       'out_ucast_pkts': '31089444',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMDA0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3580,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '768395',
                                                                                                                                                     'distance': 1487,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '344353',
                                                                       'in_octets': '12031492767',
                                                                       'in_ucast_pkts': '52404179',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '106755299162',
                                                                       'out_ucast_pkts': '81733783',
                                                                       'poller_hash': 'UzE0MkYyMjIyMDAwMDA0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.77894401550293,
                                         'longitude': -86.36637878417969,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '2438-JENNIFER_PORTER-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIyMDAwMDA0',
                                         'serial_number': 'S142F2222000004',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:7b:2f',
                                         'temperature': 36.312,
                                         'uptime': '1377554'},
                                 {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '113566396005',
                                                                       'in_ucast_pkts': '79125564',
                                                                       'links': [       {       'in_octets': '113566396005',
                                                                                                'in_ucast_pkts': '79125564',
                                                                                                'out_octets': '6524781118',
                                                                                                'out_ucast_pkts': '43441557',
                                                                                                'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6524781118',
                                                                       'out_ucast_pkts': '43441557',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMTA2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3580,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '768385',
                                                                                                                                                     'distance': 2988,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1031499',
                                                                       'in_octets': '44126231059',
                                                                       'in_ucast_pkts': '208566636',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '577668210595',
                                                                       'out_ucast_pkts': '418202260',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwMTA2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.769250869750977,
                                         'longitude': -86.38348388671875,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7026106,
                                         'model': '30-0142-001',
                                         'name': '40-AL_SILVANI-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIzMDAwMTA2',
                                         'serial_number': 'S142F2223000106',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:a1:a1',
                                         'temperature': 33.989,
                                         'uptime': '4423360'},
                                 {       'elevation': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '701496177336',
                                                                       'in_ucast_pkts': '494643130',
                                                                       'links': [       {       'in_octets': '701496177336',
                                                                                                'in_ucast_pkts': '494643130',
                                                                                                'out_octets': '28523807994',
                                                                                                'out_ucast_pkts': '231065309',
                                                                                                'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '28523807994',
                                                                       'out_ucast_pkts': '231065309',
                                                                       'poller_hash': 'UzE0MkYyMjI0MzA3MDc1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3580,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '768185',
                                                                                                                                                     'distance': 2927,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '596655',
                                                                       'in_octets': '52245210894',
                                                                       'in_ucast_pkts': '371817326',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1152314788856',
                                                                       'out_ucast_pkts': '815517300',
                                                                       'poller_hash': 'UzE0MkYyMjI0MzA3MDc1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.7723445892334,
                                         'longitude': -86.3830795288086,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '2421-TANYA_RATHBURN-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjI0MzA3MDc1',
                                         'serial_number': 'S142F2224307075',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:01:14:f7',
                                         'temperature': 32.015,
                                         'uptime': '2238188'},
                                 {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '221661144390',
                                                                       'in_ucast_pkts': '153996954',
                                                                       'links': [       {       'in_octets': '221661144390',
                                                                                                'in_ucast_pkts': '153996954',
                                                                                                'out_octets': '10252302492',
                                                                                                'out_ucast_pkts': '102314595',
                                                                                                'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '10252302492',
                                                                       'out_ucast_pkts': '102314595',
                                                                       'poller_hash': 'UzE0MlQxMjIxODAwMTg0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3580,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '768105',
                                                                                                                                                     'distance': 2291,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '192023',
                                                                       'in_octets': '10253165878',
                                                                       'in_ucast_pkts': '102123555',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '221044859717',
                                                                       'out_ucast_pkts': '153997870',
                                                                       'poller_hash': 'UzE0MlQxMjIxODAwMTg0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.781827926635742,
                                         'longitude': -86.3740463256836,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '1599-MALLORY_WALKER-RES100-R',
                                         'poller_hash': 'UzE0MlQxMjIxODAwMTg0',
                                         'serial_number': 'S142T1221800184',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3d:c8',
                                         'temperature': 29.577,
                                         'uptime': '768281'},
                                 {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '205147713230',
                                                                       'in_ucast_pkts': '172452661',
                                                                       'links': [       {       'in_octets': '205147713230',
                                                                                                'in_ucast_pkts': '172452661',
                                                                                                'out_octets': '35512396951',
                                                                                                'out_ucast_pkts': '86319564',
                                                                                                'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '35512396951',
                                                                       'out_ucast_pkts': '86319564',
                                                                       'poller_hash': 'UzE0MlQxMjIyMDAwMTk3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3580,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '768005',
                                                                                                                                                     'distance': 2311,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjIwOTAxNDE0d2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '948686',
                                                                       'in_octets': '210356491942',
                                                                       'in_ucast_pkts': '446399695',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '971050462310',
                                                                       'out_ucast_pkts': '831231751',
                                                                       'poller_hash': 'UzE0MlQxMjIyMDAwMTk3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.76886558532715,
                                         'longitude': -86.37632751464844,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.645857,
                                         'model': '30-0142-001',
                                         'name': '2451-YESEINA_BAEZ-RES100-R',
                                         'poller_hash': 'UzE0MlQxMjIyMDAwMTk3',
                                         'serial_number': 'S142T1222000197',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:15:f7',
                                         'temperature': 36.66,
                                         'uptime': '3796244'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_989_011_00_10_100_20_10(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.989.011.00.10_100_20_10")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 28,
                'sw_version': '0.989.011.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2224305100',
                'system_mac_address': '04:f1:7d:01:19:3e',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:00:1d:0d': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 470552064362,
                                             'dl_rf_packets': 386163377,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:1d:0d',
                                             'name': '1007-RICHARD_EDGE-RES100-R',
                                             'serial_number': 'S142F1213600031',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 23173880857,
                                             'ul_rf_packets': 219295881},
                '04:f1:7d:00:2a:d8': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 221585351918,
                                             'dl_rf_packets': 160647001,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:2a:d8',
                                             'name': '927-RICK_APPLEBY-RES100-R',
                                             'serial_number': 'S142F1213800016',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 5309974046,
                                             'ul_rf_packets': 39853741},
                '04:f1:7d:00:38:b7': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 9454084869,
                                             'dl_rf_packets': 8218013,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:38:b7',
                                             'name': '1031-DANA_DICE-RES100-R',
                                             'serial_number': 'S142F1214700025',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 6508551191,
                                             'ul_rf_packets': 10970772},
                '04:f1:7d:00:38:ce': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 64151447429,
                                             'dl_rf_packets': 49497494,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:38:ce',
                                             'name': '166-NICOLE_ECHELE-RES100-R',
                                             'serial_number': 'S142F1214700050',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 4447992792,
                                             'ul_rf_packets': 31827247},
                '04:f1:7d:00:39:2e': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 129699049176,
                                             'dl_rf_packets': 104259047,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:39:2e',
                                             'name': '08-JOSH_SENN-RES100-R',
                                             'serial_number': 'S142T1220500046',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 8495934825,
                                             'ul_rf_packets': 59240103},
                '04:f1:7d:00:39:38': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 70788186062,
                                             'dl_rf_packets': 54472567,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:39:38',
                                             'name': '109-ROBIN_SIMMONS-RES100-R',
                                             'serial_number': 'S142T1220600052',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3780123690,
                                             'ul_rf_packets': 34706384},
                '04:f1:7d:00:39:db': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 90564916152,
                                             'dl_rf_packets': 68469850,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:39:db',
                                             'name': '1251-TIFFANY_PARSON-RES100-R',
                                             'serial_number': 'S142F1214900072',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 6303082666,
                                             'ul_rf_packets': 37042971},
                '04:f1:7d:00:3a:5b': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 143585805266,
                                             'dl_rf_packets': 117714694,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3a:5b',
                                             'name': '1028-CAYLEE_GRIFFITH-RES100-R',
                                             'serial_number': 'S142F1214600016',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 12169583630,
                                             'ul_rf_packets': 78377115},
                '04:f1:7d:00:3a:6e': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 131649941899,
                                             'dl_rf_packets': 101727746,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3a:6e',
                                             'name': '295-ALYSSA_DUPREE_MOORE-RES100-R',
                                             'serial_number': 'S142F1214600008',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 5624046848,
                                             'ul_rf_packets': 64420124},
                '04:f1:7d:00:3a:75': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 58929175077,
                                             'dl_rf_packets': 51820362,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3a:75',
                                             'name': '512-MIRANDA_WARD-RES100-R',
                                             'serial_number': 'S142F1214700002',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 4698373029,
                                             'ul_rf_packets': 36668135},
                '04:f1:7d:00:3b:53': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 319248024709,
                                             'dl_rf_packets': 233520743,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3b:53',
                                             'name': '832-KATRINA_MOORE-RES100-R',
                                             'serial_number': 'S142F1214700033',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 17809065506,
                                             'ul_rf_packets': 148838538},
                '04:f1:7d:00:3b:ba': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 55946773351,
                                             'dl_rf_packets': 45748075,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3b:ba',
                                             'name': '967-JEAN_NELSON-RES100-R',
                                             'serial_number': 'S142F1214700020',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3459355355,
                                             'ul_rf_packets': 22254943},
                '04:f1:7d:00:3c:af': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 99260210877,
                                             'dl_rf_packets': 77747869,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3c:af',
                                             'name': '169-BARBARA_THOMAS-RES100-R',
                                             'serial_number': 'S142F1214900074',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 5956018515,
                                             'ul_rf_packets': 56223619},
                '04:f1:7d:00:3c:b4': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 17564321720,
                                             'dl_rf_packets': 13824082,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3c:b4',
                                             'name': '1525-KAYE_HUTCHINSON-RES100-R',
                                             'serial_number': 'S142F1214900090',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 1287509347,
                                             'ul_rf_packets': 9797794},
                '04:f1:7d:00:3c:b6': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 211493387796,
                                             'dl_rf_packets': 175746881,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3c:b6',
                                             'name': '297-WOODIE_DUPREE-RES100-R',
                                             'serial_number': 'S142F1214900096',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 31997856586,
                                             'ul_rf_packets': 96026375},
                '04:f1:7d:00:3c:ba': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 4522867468,
                                             'dl_rf_packets': 10423549,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3c:ba',
                                             'name': '1036-JOHN_SANDERSON-RES100-R',
                                             'serial_number': 'S142F1214900095',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 9384652904,
                                             'ul_rf_packets': 13444833},
                '04:f1:7d:00:3d:c5': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 242014249197,
                                             'dl_rf_packets': 189753971,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3d:c5',
                                             'name': '1492-LOUIS_SZYMANSKI-RES100-R',
                                             'serial_number': 'S142T1220500040',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 15650842566,
                                             'ul_rf_packets': 164471313},
                '04:f1:7d:00:3e:5a': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 86813600227,
                                             'dl_rf_packets': 80308052,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:3e:5a',
                                             'name': '1766-KISHA_POWELL-RES100-R',
                                             'serial_number': 'S142T1220700057',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 5526257756,
                                             'ul_rf_packets': 48364350},
                '04:f1:7d:00:75:67': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 49381940919,
                                             'dl_rf_packets': 37725508,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:75:67',
                                             'name': '1764-MELISSA_MURPHY-RES100-R',
                                             'serial_number': 'S142F2221805641',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 9969410413,
                                             'ul_rf_packets': 32823523},
                '04:f1:7d:00:85:5d': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 18938672501,
                                             'dl_rf_packets': 21935199,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:85:5d',
                                             'name': '340-JEFFERY_TRUETT-RES100-R',
                                             'serial_number': 'S142F2222201198',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 60515578524,
                                             'ul_rf_packets': 68782296},
                '04:f1:7d:00:8b:b1': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 14125946728,
                                             'dl_rf_packets': 11077954,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:8b:b1',
                                             'name': '1577-ANGELA_NOLIN-RES100-R',
                                             'serial_number': 'S142F2222206582',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 712785601,
                                             'ul_rf_packets': 5179938},
                '04:f1:7d:00:8f:53': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 35521880735,
                                             'dl_rf_packets': 30070044,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:8f:53',
                                             'name': '199-LIDA_PERT-RES100-R',
                                             'serial_number': 'S142F2222312303',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3570765769,
                                             'ul_rf_packets': 22176060},
                '04:f1:7d:00:8f:93': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 274636265908,
                                             'dl_rf_packets': 238155584,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:8f:93',
                                             'name': '1686-CHRISTI_MITCHEM-RES100-R',
                                             'serial_number': 'S142F2222312308',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 17132637471,
                                             'ul_rf_packets': 184282978},
                '04:f1:7d:00:b1:87': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 239702434395,
                                             'dl_rf_packets': 179580434,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:b1:87',
                                             'name': '2267-LUCY_KNOTH-RES100-R',
                                             'serial_number': 'S142F2223000763',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 15307536320,
                                             'ul_rf_packets': 126837603},
                '04:f1:7d:00:c0:3d': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 112151273454,
                                             'dl_rf_packets': 85647725,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:c0:3d',
                                             'name': '1308-TROY_DUPREE-RES100-R',
                                             'serial_number': 'S142F2223507617',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 4802200131,
                                             'ul_rf_packets': 50142807},
                '04:f1:7d:00:cd:9e': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 219357507032,
                                             'dl_rf_packets': 164130914,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:cd:9e',
                                             'name': '2648-CLAYTON_SIMPLER-RES100-R',
                                             'serial_number': 'S142F2223603213',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 6979360879,
                                             'ul_rf_packets': 68351558},
                '04:f1:7d:00:f2:ae': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 2360141615,
                                             'dl_rf_packets': 2468298,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:f2:ae',
                                             'name': '2559-MARYLEE_WARD-RES25-R',
                                             'serial_number': 'S142F2224002000',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 560115588,
                                             'ul_rf_packets': 2560076},
                '04:f1:7d:00:f6:3a': {       'dev_macs': None,
                                             'dl_link_rate': None,
                                             'dl_rf_bytes': 55375136258,
                                             'dl_rf_packets': 46921141,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:f6:3a',
                                             'name': '1512-PETER_HANSON-RES100-R',
                                             'serial_number': 'S142F2224002001',
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_rf_bytes': 3301267310,
                                             'ul_rf_packets': 31612523}
        }
        exp_ne_msg = {
                'data': {       'cpu': 32.234776,
                                'elevation': 109.477,
                                'gps_sats_tracked': 15,
                                'height': 0.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '23918',
                                                                                       'in_octets': '17809065506',
                                                                                       'in_ucast_pkts': '148838538',
                                                                                       'out_errors': '421953',
                                                                                       'out_octets': '319248024709',
                                                                                       'out_ucast_pkts': '233520743',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDMzMQ=='},
                                                                               {       'in_errors': '7048',
                                                                                       'in_octets': '5956018515',
                                                                                       'in_ucast_pkts': '56223619',
                                                                                       'out_errors': '185901',
                                                                                       'out_octets': '99260210877',
                                                                                       'out_ucast_pkts': '77747869',
                                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDc0MQ=='},
                                                                               {       'in_errors': '3802',
                                                                                       'in_octets': '12169583630',
                                                                                       'in_ucast_pkts': '78377115',
                                                                                       'out_errors': '9180',
                                                                                       'out_octets': '143585805266',
                                                                                       'out_ucast_pkts': '117714694',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDE2MQ=='},
                                                                               {       'in_errors': '1301',
                                                                                       'in_octets': '4698373029',
                                                                                       'in_ucast_pkts': '36668135',
                                                                                       'out_errors': '20303',
                                                                                       'out_octets': '58929175077',
                                                                                       'out_ucast_pkts': '51820362',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDAyMQ=='},
                                                                               {       'in_errors': '1033239',
                                                                                       'in_octets': '5526257756',
                                                                                       'in_ucast_pkts': '48364350',
                                                                                       'out_errors': '5751134',
                                                                                       'out_octets': '86813600227',
                                                                                       'out_ucast_pkts': '80308052',
                                                                                       'poller_hash': 'UzE0MlQxMjIwNzAwMDU3MQ=='},
                                                                               {       'in_errors': '11926',
                                                                                       'in_octets': '60515578524',
                                                                                       'in_ucast_pkts': '68782296',
                                                                                       'out_errors': '517951',
                                                                                       'out_octets': '18938672501',
                                                                                       'out_ucast_pkts': '21935199',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjAxMTk4MQ=='},
                                                                               {       'in_errors': '24481',
                                                                                       'in_octets': '3780123690',
                                                                                       'in_ucast_pkts': '34706384',
                                                                                       'out_errors': '57778',
                                                                                       'out_octets': '70788186062',
                                                                                       'out_ucast_pkts': '54472567',
                                                                                       'poller_hash': 'UzE0MlQxMjIwNjAwMDUyMQ=='},
                                                                               {       'in_errors': '639462',
                                                                                       'in_octets': '15650842566',
                                                                                       'in_ucast_pkts': '164471313',
                                                                                       'out_errors': '5826975',
                                                                                       'out_octets': '242014249197',
                                                                                       'out_ucast_pkts': '189753971',
                                                                                       'poller_hash': 'UzE0MlQxMjIwNTAwMDQwMQ=='},
                                                                               {       'in_errors': '133947',
                                                                                       'in_octets': '1287509347',
                                                                                       'in_ucast_pkts': '9797794',
                                                                                       'out_errors': '1243323',
                                                                                       'out_octets': '17564321720',
                                                                                       'out_ucast_pkts': '13824082',
                                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDkwMQ=='},
                                                                               {       'in_errors': '10275',
                                                                                       'in_octets': '6303082666',
                                                                                       'in_ucast_pkts': '37042971',
                                                                                       'out_errors': '117797',
                                                                                       'out_octets': '90564916152',
                                                                                       'out_ucast_pkts': '68469850',
                                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDcyMQ=='},
                                                                               {       'in_errors': '487233',
                                                                                       'in_octets': '17132637471',
                                                                                       'in_ucast_pkts': '184282978',
                                                                                       'out_errors': '6485014',
                                                                                       'out_octets': '274636265908',
                                                                                       'out_ucast_pkts': '238155584',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMzEyMzA4MQ=='},
                                                                               {       'in_errors': '31001',
                                                                                       'in_octets': '5309974046',
                                                                                       'in_ucast_pkts': '39853741',
                                                                                       'out_errors': '304406',
                                                                                       'out_octets': '221585351918',
                                                                                       'out_ucast_pkts': '160647001',
                                                                                       'poller_hash': 'UzE0MkYxMjEzODAwMDE2MQ=='},
                                                                               {       'in_errors': '930458',
                                                                                       'in_octets': '31997856586',
                                                                                       'in_ucast_pkts': '96026375',
                                                                                       'out_errors': '5943623',
                                                                                       'out_octets': '211493387796',
                                                                                       'out_ucast_pkts': '175746881',
                                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDk2MQ=='},
                                                                               {       'in_errors': '4906',
                                                                                       'in_octets': '4447992792',
                                                                                       'in_ucast_pkts': '31827247',
                                                                                       'out_errors': '64329',
                                                                                       'out_octets': '64151447429',
                                                                                       'out_ucast_pkts': '49497494',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDUwMQ=='},
                                                                               {       'in_errors': '9817',
                                                                                       'in_octets': '712785601',
                                                                                       'in_ucast_pkts': '5179938',
                                                                                       'out_errors': '250758',
                                                                                       'out_octets': '14125946728',
                                                                                       'out_ucast_pkts': '11077954',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMjA2NTgyMQ=='},
                                                                               {       'in_errors': '15738',
                                                                                       'in_octets': '5624046848',
                                                                                       'in_ucast_pkts': '64420124',
                                                                                       'out_errors': '180808',
                                                                                       'out_octets': '131649941899',
                                                                                       'out_ucast_pkts': '101727746',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDA4MQ=='},
                                                                               {       'in_errors': '1938183',
                                                                                       'in_octets': '6979360879',
                                                                                       'in_ucast_pkts': '68351558',
                                                                                       'out_errors': '11933374',
                                                                                       'out_octets': '219357507032',
                                                                                       'out_ucast_pkts': '164130914',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNjAzMjEzMQ=='},
                                                                               {       'in_errors': '131907',
                                                                                       'in_octets': '3570765769',
                                                                                       'in_ucast_pkts': '22176060',
                                                                                       'out_errors': '1567785',
                                                                                       'out_octets': '35521880735',
                                                                                       'out_ucast_pkts': '30070044',
                                                                                       'poller_hash': 'UzE0MkYyMjIyMzEyMzAzMQ=='},
                                                                               {       'in_errors': '58060',
                                                                                       'in_octets': '15307536320',
                                                                                       'in_ucast_pkts': '126837603',
                                                                                       'out_errors': '229392',
                                                                                       'out_octets': '239702434395',
                                                                                       'out_ucast_pkts': '179580434',
                                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwNzYzMQ=='},
                                                                               {       'in_errors': '1191',
                                                                                       'in_octets': '560115588',
                                                                                       'in_ucast_pkts': '2560076',
                                                                                       'out_errors': '32702',
                                                                                       'out_octets': '2360141615',
                                                                                       'out_ucast_pkts': '2468298',
                                                                                       'poller_hash': 'UzE0MkYyMjI0MDAyMDAwMQ=='},
                                                                               {       'in_errors': '394370',
                                                                                       'in_octets': '9384652904',
                                                                                       'in_ucast_pkts': '13444833',
                                                                                       'out_errors': '3638098',
                                                                                       'out_octets': '4522867468',
                                                                                       'out_ucast_pkts': '10423549',
                                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDk1MQ=='},
                                                                               {       'in_errors': '21396',
                                                                                       'in_octets': '8495934825',
                                                                                       'in_ucast_pkts': '59240103',
                                                                                       'out_errors': '1414127',
                                                                                       'out_octets': '129699049176',
                                                                                       'out_ucast_pkts': '104259047',
                                                                                       'poller_hash': 'UzE0MlQxMjIwNTAwMDQ2MQ=='},
                                                                               {       'in_errors': '25133',
                                                                                       'in_octets': '3459355355',
                                                                                       'in_ucast_pkts': '22254943',
                                                                                       'out_errors': '1535251',
                                                                                       'out_octets': '55946773351',
                                                                                       'out_ucast_pkts': '45748075',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDIwMQ=='},
                                                                               {       'in_errors': '968118',
                                                                                       'in_octets': '4802200131',
                                                                                       'in_ucast_pkts': '50142807',
                                                                                       'out_errors': '6840147',
                                                                                       'out_octets': '112151273454',
                                                                                       'out_ucast_pkts': '85647725',
                                                                                       'poller_hash': 'UzE0MkYyMjIzNTA3NjE3MQ=='},
                                                                               {       'in_errors': '147397',
                                                                                       'in_octets': '23173880857',
                                                                                       'in_ucast_pkts': '219295881',
                                                                                       'out_errors': '1093949',
                                                                                       'out_octets': '470552064362',
                                                                                       'out_ucast_pkts': '386163377',
                                                                                       'poller_hash': 'UzE0MkYxMjEzNjAwMDMxMQ=='},
                                                                               {       'in_errors': '485714',
                                                                                       'in_octets': '3301267310',
                                                                                       'in_ucast_pkts': '31612523',
                                                                                       'out_errors': '2315147',
                                                                                       'out_octets': '55375136258',
                                                                                       'out_ucast_pkts': '46921141',
                                                                                       'poller_hash': 'UzE0MkYyMjI0MDAyMDAxMQ=='},
                                                                               {       'in_errors': '660332',
                                                                                       'in_octets': '9969410413',
                                                                                       'in_ucast_pkts': '32823523',
                                                                                       'out_errors': '3354359',
                                                                                       'out_octets': '49381940919',
                                                                                       'out_ucast_pkts': '37725508',
                                                                                       'poller_hash': 'UzE0MkYyMjIxODA1NjQxMQ=='},
                                                                               {       'in_errors': '209934',
                                                                                       'in_octets': '6508551191',
                                                                                       'in_ucast_pkts': '10970772',
                                                                                       'out_errors': '1833357',
                                                                                       'out_octets': '9454084869',
                                                                                       'out_ucast_pkts': '8218013',
                                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDI1MQ=='}],
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3640,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '726371',
                                                                                                                                            'distance': 100,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NzAwMDMzMQ=='},
                                                                                                                                    {       'connected_time': '726370',
                                                                                                                                            'distance': 2814,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0OTAwMDc0MQ=='},
                                                                                                                                    {       'connected_time': '726371',
                                                                                                                                            'distance': 154,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NjAwMDE2MQ=='},
                                                                                                                                    {       'connected_time': '726371',
                                                                                                                                            'distance': 73,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NzAwMDAyMQ=='},
                                                                                                                                    {       'connected_time': '726370',
                                                                                                                                            'distance': 2492,
                                                                                                                                            'poller_hash': 'UzE0MlQxMjIwNzAwMDU3MQ=='},
                                                                                                                                    {       'connected_time': '726370',
                                                                                                                                            'distance': 2720,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjAxMTk4MQ=='},
                                                                                                                                    {       'connected_time': '726370',
                                                                                                                                            'distance': 381,
                                                                                                                                            'poller_hash': 'UzE0MlQxMjIwNjAwMDUyMQ=='},
                                                                                                                                    {       'connected_time': '726370',
                                                                                                                                            'distance': 830,
                                                                                                                                            'poller_hash': 'UzE0MlQxMjIwNTAwMDQwMQ=='},
                                                                                                                                    {       'connected_time': '726370',
                                                                                                                                            'distance': 676,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0OTAwMDkwMQ=='},
                                                                                                                                    {       'connected_time': '726371',
                                                                                                                                            'distance': 113,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0OTAwMDcyMQ=='},
                                                                                                                                    {       'connected_time': '726370',
                                                                                                                                            'distance': 2512,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMzEyMzA4MQ=='},
                                                                                                                                    {       'connected_time': '726371',
                                                                                                                                            'distance': 1273,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjEzODAwMDE2MQ=='},
                                                                                                                                    {       'connected_time': '726370',
                                                                                                                                            'distance': 2177,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0OTAwMDk2MQ=='},
                                                                                                                                    {       'connected_time': '726360',
                                                                                                                                            'distance': 964,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NzAwMDUwMQ=='},
                                                                                                                                    {       'connected_time': '726361',
                                                                                                                                            'distance': 308,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMjA2NTgyMQ=='},
                                                                                                                                    {       'connected_time': '726360',
                                                                                                                                            'distance': 1675,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NjAwMDA4MQ=='},
                                                                                                                                    {       'connected_time': '726361',
                                                                                                                                            'distance': 2720,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNjAzMjEzMQ=='},
                                                                                                                                    {       'connected_time': '726360',
                                                                                                                                            'distance': 2056,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIyMzEyMzAzMQ=='},
                                                                                                                                    {       'connected_time': '726361',
                                                                                                                                            'distance': 214,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzMDAwNzYzMQ=='},
                                                                                                                                    {       'connected_time': '726360',
                                                                                                                                            'distance': 53,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjI0MDAyMDAwMQ=='},
                                                                                                                                    {       'connected_time': '726351',
                                                                                                                                            'distance': 3236,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0OTAwMDk1MQ=='},
                                                                                                                                    {       'connected_time': '726351',
                                                                                                                                            'distance': 2767,
                                                                                                                                            'poller_hash': 'UzE0MlQxMjIwNTAwMDQ2MQ=='},
                                                                                                                                    {       'connected_time': '726341',
                                                                                                                                            'distance': 556,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NzAwMDIwMQ=='},
                                                                                                                                    {       'connected_time': '726271',
                                                                                                                                            'distance': 2418,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIzNTA3NjE3MQ=='},
                                                                                                                                    {       'connected_time': '726241',
                                                                                                                                            'distance': 160,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjEzNjAwMDMxMQ=='},
                                                                                                                                    {       'connected_time': '160921',
                                                                                                                                            'distance': 4368,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjI0MDAyMDAxMQ=='},
                                                                                                                                    {       'connected_time': '160901',
                                                                                                                                            'distance': 4234,
                                                                                                                                            'poller_hash': 'UzE0MkYyMjIxODA1NjQxMQ=='},
                                                                                                                                    {       'connected_time': '152581',
                                                                                                                                            'distance': 2211,
                                                                                                                                            'poller_hash': 'UzE0MkYxMjE0NzAwMDI1MQ=='}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjI0MzA1MTAwZ2kx'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '75',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '7916114',
                                                              'in_octets': '30582026032829',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '30830072',
                                                              'out_octets': '3093815539878',
                                                              'poller_hash': 'UzE0MUYyMjI0MzA1MTAwZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjI0MzA1MTAwZXgy'}],
                                'latitude': 30.944076538085938,
                                'longitude': -86.05999755859375,
                                'manufacturer': 'Tarana',
                                'mem': 2.6511135,
                                'model': '30-0141-001',
                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAw',
                                'serial_number': 'S141F2224305100',
                                'sw_version': '0.989.011.00',
                                'system_mac_address': '04:f1:7d:01:19:3e',
                                'temperature': 57.625,
                                'uptime': '4957491'},
                'peers': [       {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '319248024709',
                                                                       'in_ucast_pkts': '233520743',
                                                                       'links': [       {       'in_octets': '319248024709',
                                                                                                'in_ucast_pkts': '233520743',
                                                                                                'out_octets': '17809065506',
                                                                                                'out_ucast_pkts': '148838538',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '17809065506',
                                                                       'out_ucast_pkts': '148838538',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDMzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726371',
                                                                                                                                                     'distance': 100,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181540',
                                                                       'in_octets': '17807703489',
                                                                       'in_ucast_pkts': '148641424',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '318296010674',
                                                                       'out_ucast_pkts': '233504649',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDMzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.945905685424805,
                                         'longitude': -86.05974578857422,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '832-KATRINA_MOORE-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0NzAwMDMz',
                                         'serial_number': 'S142F1214700033',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3b:53',
                                         'temperature': 39.041,
                                         'uptime': '726578'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '99260210877',
                                                                       'in_ucast_pkts': '77747869',
                                                                       'links': [       {       'in_octets': '99260210877',
                                                                                                'in_ucast_pkts': '77747869',
                                                                                                'out_octets': '5956018515',
                                                                                                'out_ucast_pkts': '56223619',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5956018515',
                                                                       'out_ucast_pkts': '56223619',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDc0MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726370',
                                                                                                                                                     'distance': 2814,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181534',
                                                                       'in_octets': '5956000972',
                                                                       'in_ucast_pkts': '56041732',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '98949792150',
                                                                       'out_ucast_pkts': '77750296',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDc0Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.959829330444336,
                                         'longitude': -86.03547668457031,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '169-BARBARA_THOMAS-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0OTAwMDc0',
                                         'serial_number': 'S142F1214900074',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3c:af',
                                         'temperature': 36.486,
                                         'uptime': '726580'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '143585805266',
                                                                       'in_ucast_pkts': '117714694',
                                                                       'links': [       {       'in_octets': '143585805266',
                                                                                                'in_ucast_pkts': '117714694',
                                                                                                'out_octets': '12169583630',
                                                                                                'out_ucast_pkts': '78377115',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '12169583630',
                                                                       'out_ucast_pkts': '78377115',
                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDE2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726371',
                                                                                                                                                     'distance': 154,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181535',
                                                                       'in_octets': '12169569751',
                                                                       'in_ucast_pkts': '78195239',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '143116012916',
                                                                       'out_ucast_pkts': '117717213',
                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDE2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.946338653564453,
                                         'longitude': -86.05913543701172,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '1028-CAYLEE_GRIFFITH-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0NjAwMDE2',
                                         'serial_number': 'S142F1214600016',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3a:5b',
                                         'temperature': 40.782,
                                         'uptime': '726583'},
                                 {       'elevation': 3.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '58929175077',
                                                                       'in_ucast_pkts': '51820362',
                                                                       'links': [       {       'in_octets': '58929175077',
                                                                                                'in_ucast_pkts': '51820362',
                                                                                                'out_octets': '4698373029',
                                                                                                'out_ucast_pkts': '36668135',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '4698373029',
                                                                       'out_ucast_pkts': '36668135',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDAyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726371',
                                                                                                                                                     'distance': 73,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181531',
                                                                       'in_octets': '4698363595',
                                                                       'in_ucast_pkts': '36486281',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '58722682633',
                                                                       'out_ucast_pkts': '51822896',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDAyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.945446014404297,
                                         'longitude': -86.05900573730469,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '512-MIRANDA_WARD-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0NzAwMDAy',
                                         'serial_number': 'S142F1214700002',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3a:75',
                                         'temperature': 40.724,
                                         'uptime': '726581'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '86813600227',
                                                                       'in_ucast_pkts': '80308052',
                                                                       'links': [       {       'in_octets': '86813600227',
                                                                                                'in_ucast_pkts': '80308052',
                                                                                                'out_octets': '5526257756',
                                                                                                'out_ucast_pkts': '48364350',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5526257756',
                                                                       'out_ucast_pkts': '48364350',
                                                                       'poller_hash': 'UzE0MlQxMjIwNzAwMDU3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726370',
                                                                                                                                                     'distance': 2492,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '183356',
                                                                       'in_octets': '5527836247',
                                                                       'in_ucast_pkts': '48183349',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '86329476640',
                                                                       'out_ucast_pkts': '80170742',
                                                                       'poller_hash': 'UzE0MlQxMjIwNzAwMDU3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.956756591796875,
                                         'longitude': -86.03727722167969,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '1766-KISHA_POWELL-RES100-R',
                                         'poller_hash': 'UzE0MlQxMjIwNzAwMDU3',
                                         'serial_number': 'S142T1220700057',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3e:5a',
                                         'temperature': 36.544,
                                         'uptime': '726579'},
                                 {       'elevation': 9.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '18938672501',
                                                                       'in_ucast_pkts': '21935199',
                                                                       'links': [       {       'in_octets': '18938672501',
                                                                                                'in_ucast_pkts': '21935199',
                                                                                                'out_octets': '60515578524',
                                                                                                'out_ucast_pkts': '68782296',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '60515578524',
                                                                       'out_ucast_pkts': '68782296',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAxMTk4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726370',
                                                                                                                                                     'distance': 2720,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181540',
                                                                       'in_octets': '60516051993',
                                                                       'in_ucast_pkts': '68600894',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '18851656320',
                                                                       'out_ucast_pkts': '21937660',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjAxMTk4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.961545944213867,
                                         'longitude': -86.03840637207031,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '340-JEFFERY_TRUETT-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIyMjAxMTk4',
                                         'serial_number': 'S142F2222201198',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:85:5d',
                                         'temperature': 37.705,
                                         'uptime': '726585'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '70788186062',
                                                                       'in_ucast_pkts': '54472567',
                                                                       'links': [       {       'in_octets': '70788186062',
                                                                                                'in_ucast_pkts': '54472567',
                                                                                                'out_octets': '3780123690',
                                                                                                'out_ucast_pkts': '34706384',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3780123690',
                                                                       'out_ucast_pkts': '34706384',
                                                                       'poller_hash': 'UzE0MlQxMjIwNjAwMDUyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726370',
                                                                                                                                                     'distance': 381,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '169442',
                                                                       'in_octets': '3780127060',
                                                                       'in_ucast_pkts': '34536658',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '70570752270',
                                                                       'out_ucast_pkts': '54475341',
                                                                       'poller_hash': 'UzE0MlQxMjIwNjAwMDUyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.9483585357666,
                                         'longitude': -86.05829620361328,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '109-ROBIN_SIMMONS-RES100-R',
                                         'poller_hash': 'UzE0MlQxMjIwNjAwMDUy',
                                         'serial_number': 'S142T1220600052',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:39:38',
                                         'temperature': 38.344,
                                         'uptime': '726578'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '242014249197',
                                                                       'in_ucast_pkts': '189753971',
                                                                       'links': [       {       'in_octets': '242014249197',
                                                                                                'in_ucast_pkts': '189753971',
                                                                                                'out_octets': '15650842566',
                                                                                                'out_ucast_pkts': '164471313',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '15650842566',
                                                                       'out_ucast_pkts': '164471313',
                                                                       'poller_hash': 'UzE0MlQxMjIwNTAwMDQwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726370',
                                                                                                                                                     'distance': 830,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '169470',
                                                                       'in_octets': '15650566804',
                                                                       'in_ucast_pkts': '164296452',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '241242490755',
                                                                       'out_ucast_pkts': '189747354',
                                                                       'poller_hash': 'UzE0MlQxMjIwNTAwMDQwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.952360153198242,
                                         'longitude': -86.05665588378906,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '1492-LOUIS_SZYMANSKI-RES100-R',
                                         'poller_hash': 'UzE0MlQxMjIwNTAwMDQw',
                                         'serial_number': 'S142T1220500040',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3d:c5',
                                         'temperature': 40.899,
                                         'uptime': '726582'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '17564321720',
                                                                       'in_ucast_pkts': '13824082',
                                                                       'links': [       {       'in_octets': '17564321720',
                                                                                                'in_ucast_pkts': '13824082',
                                                                                                'out_octets': '1287509347',
                                                                                                'out_ucast_pkts': '9797794',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '1287509347',
                                                                       'out_ucast_pkts': '9797794',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDkwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726370',
                                                                                                                                                     'distance': 676,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '169448',
                                                                       'in_octets': '1287535565',
                                                                       'in_ucast_pkts': '9628111',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '17507773713',
                                                                       'out_ucast_pkts': '13825318',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDkwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.947113037109375,
                                         'longitude': -86.0527114868164,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '1525-KAYE_HUTCHINSON-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0OTAwMDkw',
                                         'serial_number': 'S142F1214900090',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3c:b4',
                                         'temperature': 44.15,
                                         'uptime': '726582'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '90564916152',
                                                                       'in_ucast_pkts': '68469850',
                                                                       'links': [       {       'in_octets': '90564916152',
                                                                                                'in_ucast_pkts': '68469850',
                                                                                                'out_octets': '6303082666',
                                                                                                'out_ucast_pkts': '37042971',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6303082666',
                                                                       'out_ucast_pkts': '37042971',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDcyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726371',
                                                                                                                                                     'distance': 113,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181534',
                                                                       'in_octets': '6302870997',
                                                                       'in_ucast_pkts': '36858439',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '90281141585',
                                                                       'out_ucast_pkts': '68464944',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDcyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.94542694091797,
                                         'longitude': -86.05806732177734,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '1251-TIFFANY_PARSON-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0OTAwMDcy',
                                         'serial_number': 'S142F1214900072',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:39:db',
                                         'temperature': 40.202,
                                         'uptime': '726586'},
                                 {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '274636265908',
                                                                       'in_ucast_pkts': '238155584',
                                                                       'links': [       {       'in_octets': '274636265908',
                                                                                                'in_ucast_pkts': '238155584',
                                                                                                'out_octets': '17132637471',
                                                                                                'out_ucast_pkts': '184282978',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '17132637471',
                                                                       'out_ucast_pkts': '184282978',
                                                                       'poller_hash': 'UzE0MkYyMjIyMzEyMzA4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726370',
                                                                                                                                                     'distance': 2512,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181529',
                                                                       'in_octets': '17132791981',
                                                                       'in_ucast_pkts': '184101639',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '273677627519',
                                                                       'out_ucast_pkts': '238152658',
                                                                       'poller_hash': 'UzE0MkYyMjIyMzEyMzA4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.95587158203125,
                                         'longitude': -86.03631591796875,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '1686-CHRISTI_MITCHEM-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIyMzEyMzA4',
                                         'serial_number': 'S142F2222312308',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:8f:93',
                                         'temperature': 40.434,
                                         'uptime': '726585'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '221585351918',
                                                                       'in_ucast_pkts': '160647001',
                                                                       'links': [       {       'in_octets': '221585351918',
                                                                                                'in_ucast_pkts': '160647001',
                                                                                                'out_octets': '5309974046',
                                                                                                'out_ucast_pkts': '39853741',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5309974046',
                                                                       'out_ucast_pkts': '39853741',
                                                                       'poller_hash': 'UzE0MkYxMjEzODAwMDE2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726371',
                                                                                                                                                     'distance': 1273,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '169436',
                                                                       'in_octets': '5309974464',
                                                                       'in_ucast_pkts': '39684023',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '220945404685',
                                                                       'out_ucast_pkts': '160649367',
                                                                       'poller_hash': 'UzE0MkYxMjEzODAwMDE2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.948698043823242,
                                         'longitude': -86.04647827148438,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '927-RICK_APPLEBY-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjEzODAwMDE2',
                                         'serial_number': 'S142F1213800016',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:2a:d8',
                                         'temperature': 38.75,
                                         'uptime': '726584'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '211493387796',
                                                                       'in_ucast_pkts': '175746881',
                                                                       'links': [       {       'in_octets': '211493387796',
                                                                                                'in_ucast_pkts': '175746881',
                                                                                                'out_octets': '31997856586',
                                                                                                'out_ucast_pkts': '96026375',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '31997856586',
                                                                       'out_ucast_pkts': '96026375',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDk2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726370',
                                                                                                                                                     'distance': 2177,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '169416',
                                                                       'in_octets': '32000509601',
                                                                       'in_ucast_pkts': '95859492',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '210786458725',
                                                                       'out_ucast_pkts': '175745262',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDk2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.959489822387695,
                                         'longitude': -86.0439682006836,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '297-WOODIE_DUPREE-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0OTAwMDk2',
                                         'serial_number': 'S142F1214900096',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3c:b6',
                                         'temperature': 41.828,
                                         'uptime': '726579'},
                                 {       'elevation': 3.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '64151447429',
                                                                       'in_ucast_pkts': '49497494',
                                                                       'links': [       {       'in_octets': '64151447429',
                                                                                                'in_ucast_pkts': '49497494',
                                                                                                'out_octets': '4447992792',
                                                                                                'out_ucast_pkts': '31827247',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '4447992792',
                                                                       'out_ucast_pkts': '31827247',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDUwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726360',
                                                                                                                                                     'distance': 964,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181624',
                                                                       'in_octets': '4447997037',
                                                                       'in_ucast_pkts': '31645363',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '63955850743',
                                                                       'out_ucast_pkts': '49499967',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDUwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.952428817749023,
                                         'longitude': -86.0542221069336,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '166-NICOLE_ECHELE-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0NzAwMDUw',
                                         'serial_number': 'S142F1214700050',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:38:ce',
                                         'temperature': 39.215,
                                         'uptime': '726594'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '14125946728',
                                                                       'in_ucast_pkts': '11077954',
                                                                       'links': [       {       'in_octets': '14125946728',
                                                                                                'in_ucast_pkts': '11077954',
                                                                                                'out_octets': '712785601',
                                                                                                'out_ucast_pkts': '5179938',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '712785601',
                                                                       'out_ucast_pkts': '5179938',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA2NTgyMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726361',
                                                                                                                                                     'distance': 308,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '193668',
                                                                       'in_octets': '712790139',
                                                                       'in_ucast_pkts': '4986000',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '14081804194',
                                                                       'out_ucast_pkts': '11080373',
                                                                       'poller_hash': 'UzE0MkYyMjIyMjA2NTgyZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.94776725769043,
                                         'longitude': -86.05903625488281,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '1577-ANGELA_NOLIN-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIyMjA2NTgy',
                                         'serial_number': 'S142F2222206582',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:8b:b1',
                                         'temperature': 41.944,
                                         'uptime': '726602'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '131649941899',
                                                                       'in_ucast_pkts': '101727746',
                                                                       'links': [       {       'in_octets': '131649941899',
                                                                                                'in_ucast_pkts': '101727746',
                                                                                                'out_octets': '5624046848',
                                                                                                'out_ucast_pkts': '64420124',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '5624046848',
                                                                       'out_ucast_pkts': '64420124',
                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDA4MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726360',
                                                                                                                                                     'distance': 1675,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181553',
                                                                       'in_octets': '5624046586',
                                                                       'in_ucast_pkts': '64238298',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '131243491328',
                                                                       'out_ucast_pkts': '101729691',
                                                                       'poller_hash': 'UzE0MkYxMjE0NjAwMDA4Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.952150344848633,
                                         'longitude': -86.04364776611328,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '295-ALYSSA_DUPREE_MOORE-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0NjAwMDA4',
                                         'serial_number': 'S142F1214600008',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3a:6e',
                                         'temperature': 42.234,
                                         'uptime': '726594'},
                                 {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '219357507032',
                                                                       'in_ucast_pkts': '164130914',
                                                                       'links': [       {       'in_octets': '219357507032',
                                                                                                'in_ucast_pkts': '164130914',
                                                                                                'out_octets': '6979360879',
                                                                                                'out_ucast_pkts': '68351558',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6979360879',
                                                                       'out_ucast_pkts': '68351558',
                                                                       'poller_hash': 'UzE0MkYyMjIzNjAzMjEzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726361',
                                                                                                                                                     'distance': 2720,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '193649',
                                                                       'in_octets': '6979728884',
                                                                       'in_ucast_pkts': '68158577',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '218682759440',
                                                                       'out_ucast_pkts': '164119252',
                                                                       'poller_hash': 'UzE0MkYyMjIzNjAzMjEzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.958328247070312,
                                         'longitude': -86.03545379638672,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '2648-CLAYTON_SIMPLER-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIzNjAzMjEz',
                                         'serial_number': 'S142F2223603213',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:cd:9e',
                                         'temperature': 41.189,
                                         'uptime': '726596'},
                                 {       'elevation': 3.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '35521880735',
                                                                       'in_ucast_pkts': '30070044',
                                                                       'links': [       {       'in_octets': '35521880735',
                                                                                                'in_ucast_pkts': '30070044',
                                                                                                'out_octets': '3570765769',
                                                                                                'out_ucast_pkts': '22176060',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3570765769',
                                                                       'out_ucast_pkts': '22176060',
                                                                       'poller_hash': 'UzE0MkYyMjIyMzEyMzAzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726360',
                                                                                                                                                     'distance': 2056,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '169431',
                                                                       'in_octets': '3570814377',
                                                                       'in_ucast_pkts': '22006446',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '35400094469',
                                                                       'out_ucast_pkts': '30071068',
                                                                       'poller_hash': 'UzE0MkYyMjIyMzEyMzAzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.958145141601562,
                                         'longitude': -86.0442886352539,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '199-LIDA_PERT-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIyMzEyMzAz',
                                         'serial_number': 'S142F2222312303',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:8f:53',
                                         'temperature': 37.183,
                                         'uptime': '726592'},
                                 {       'elevation': 2.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '239702434395',
                                                                       'in_ucast_pkts': '179580434',
                                                                       'links': [       {       'in_octets': '239702434395',
                                                                                                'in_ucast_pkts': '179580434',
                                                                                                'out_octets': '15307536320',
                                                                                                'out_ucast_pkts': '126837603',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '15307536320',
                                                                       'out_ucast_pkts': '126837603',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwNzYzMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726361',
                                                                                                                                                     'distance': 214,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '169428',
                                                                       'in_octets': '15307571187',
                                                                       'in_ucast_pkts': '126667939',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '238985541817',
                                                                       'out_ucast_pkts': '179582438',
                                                                       'poller_hash': 'UzE0MkYyMjIzMDAwNzYzZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.944421768188477,
                                         'longitude': -86.05667877197266,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '2267-LUCY_KNOTH-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIzMDAwNzYz',
                                         'serial_number': 'S142F2223000763',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:b1:87',
                                         'temperature': 44.498,
                                         'uptime': '726596'},
                                 {       'elevation': 2.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '2360141615',
                                                                       'in_ucast_pkts': '2468298',
                                                                       'links': [       {       'in_octets': '2360141615',
                                                                                                'in_ucast_pkts': '2468298',
                                                                                                'out_octets': '560115588',
                                                                                                'out_ucast_pkts': '2560076',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '560115588',
                                                                       'out_ucast_pkts': '2560076',
                                                                       'poller_hash': 'UzE0MkYyMjI0MDAyMDAwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726360',
                                                                                                                                                     'distance': 53,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '169474',
                                                                       'in_octets': '560118729',
                                                                       'in_ucast_pkts': '2390324',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2350550156',
                                                                       'out_ucast_pkts': '2470811',
                                                                       'poller_hash': 'UzE0MkYyMjI0MDAyMDAwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.94461441040039,
                                         'longitude': -86.05848693847656,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '2559-MARYLEE_WARD-RES25-R',
                                         'poller_hash': 'UzE0MkYyMjI0MDAyMDAw',
                                         'serial_number': 'S142F2224002000',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:f2:ae',
                                         'temperature': 40.55,
                                         'uptime': '726593'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '4522867468',
                                                                       'in_ucast_pkts': '10423549',
                                                                       'links': [       {       'in_octets': '4522867468',
                                                                                                'in_ucast_pkts': '10423549',
                                                                                                'out_octets': '9384652904',
                                                                                                'out_ucast_pkts': '13444833',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '9384652904',
                                                                       'out_ucast_pkts': '13444833',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDk1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726351',
                                                                                                                                                     'distance': 3236,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181538',
                                                                       'in_octets': '9386803512',
                                                                       'in_ucast_pkts': '13264352',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '4480944498',
                                                                       'out_ucast_pkts': '10425099',
                                                                       'poller_hash': 'UzE0MkYxMjE0OTAwMDk1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.97089958190918,
                                         'longitude': -86.0439682006836,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '1036-JOHN_SANDERSON-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0OTAwMDk1',
                                         'serial_number': 'S142F1214900095',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3c:ba',
                                         'temperature': 36.428,
                                         'uptime': '726580'},
                                 {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '129699049176',
                                                                       'in_ucast_pkts': '104259047',
                                                                       'links': [       {       'in_octets': '129699049176',
                                                                                                'in_ucast_pkts': '104259047',
                                                                                                'out_octets': '8495934825',
                                                                                                'out_ucast_pkts': '59240103',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '8495934825',
                                                                       'out_ucast_pkts': '59240103',
                                                                       'poller_hash': 'UzE0MlQxMjIwNTAwMDQ2MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726351',
                                                                                                                                                     'distance': 2767,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181603',
                                                                       'in_octets': '8495821011',
                                                                       'in_ucast_pkts': '59057973',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '129283074491',
                                                                       'out_ucast_pkts': '104260317',
                                                                       'poller_hash': 'UzE0MlQxMjIwNTAwMDQ2Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.28846549987793,
                                         'longitude': -86.04563903808594,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '08-JOSH_SENN-RES100-R',
                                         'poller_hash': 'UzE0MlQxMjIwNTAwMDQ2',
                                         'serial_number': 'S142T1220500046',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:39:2e',
                                         'temperature': 35.673,
                                         'uptime': '726580'},
                                 {       'elevation': 5.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '55946773351',
                                                                       'in_ucast_pkts': '45748075',
                                                                       'links': [       {       'in_octets': '55946773351',
                                                                                                'in_ucast_pkts': '45748075',
                                                                                                'out_octets': '3459355355',
                                                                                                'out_ucast_pkts': '22254943',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3459355355',
                                                                       'out_ucast_pkts': '22254943',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDIwMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726341',
                                                                                                                                                     'distance': 556,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '169453',
                                                                       'in_octets': '3459365203',
                                                                       'in_ucast_pkts': '22085236',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '55762043256',
                                                                       'out_ucast_pkts': '45748748',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDIwZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.9498348236084,
                                         'longitude': -86.05821990966797,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '967-JEAN_NELSON-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0NzAwMDIw',
                                         'serial_number': 'S142F1214700020',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:3b:ba',
                                         'temperature': 36.428,
                                         'uptime': '726579'},
                                 {       'elevation': 4.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '112151273454',
                                                                       'in_ucast_pkts': '85647725',
                                                                       'links': [       {       'in_octets': '112151273454',
                                                                                                'in_ucast_pkts': '85647725',
                                                                                                'out_octets': '4802200131',
                                                                                                'out_ucast_pkts': '50142807',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '4802200131',
                                                                       'out_ucast_pkts': '50142807',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTA3NjE3MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726271',
                                                                                                                                                     'distance': 2418,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '181559',
                                                                       'in_octets': '4802392457',
                                                                       'in_ucast_pkts': '49961323',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '112045205078',
                                                                       'out_ucast_pkts': '85813913',
                                                                       'poller_hash': 'UzE0MkYyMjIzNTA3NjE3Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.962438583374023,
                                         'longitude': -86.0444107055664,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '1308-TROY_DUPREE-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIzNTA3NjE3',
                                         'serial_number': 'S142F2223507617',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.989.011.00',
                                         'system_mac_address': '04:f1:7d:00:c0:3d',
                                         'temperature': 40.202,
                                         'uptime': '726591'},
                                 {       'elevation': 2.5,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '470552064362',
                                                                       'in_ucast_pkts': '386163377',
                                                                       'links': [       {       'in_octets': '470552064362',
                                                                                                'in_ucast_pkts': '386163377',
                                                                                                'out_octets': '23173880857',
                                                                                                'out_ucast_pkts': '219295881',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '23173880857',
                                                                       'out_ucast_pkts': '219295881',
                                                                       'poller_hash': 'UzE0MkYxMjEzNjAwMDMxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '726241',
                                                                                                                                                     'distance': 160,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '173974',
                                                                       'in_octets': '23173894933',
                                                                       'in_ucast_pkts': '219121555',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '469003791594',
                                                                       'out_ucast_pkts': '386161983',
                                                                       'poller_hash': 'UzE0MkYxMjEzNjAwMDMxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.94624900817871,
                                         'longitude': -86.05966186523438,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5891033,
                                         'model': '30-0142-001',
                                         'name': '1007-RICHARD_EDGE-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjEzNjAwMDMx',
                                         'serial_number': 'S142F1213600031',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:1d:0d',
                                         'temperature': 39.389,
                                         'uptime': '726592'},
                                 {       'elevation': 0.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '55375136258',
                                                                       'in_ucast_pkts': '46921141',
                                                                       'links': [       {       'in_octets': '55375136258',
                                                                                                'in_ucast_pkts': '46921141',
                                                                                                'out_octets': '3301267310',
                                                                                                'out_ucast_pkts': '31612523',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '3301267310',
                                                                       'out_ucast_pkts': '31612523',
                                                                       'poller_hash': 'UzE0MkYyMjI0MDAyMDAxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '160921',
                                                                                                                                                     'distance': 4368,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '43030',
                                                                       'in_octets': '3301190086',
                                                                       'in_ucast_pkts': '31565236',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '55151083662',
                                                                       'out_ucast_pkts': '46891301',
                                                                       'poller_hash': 'UzE0MkYyMjI0MDAyMDAxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.983837127685547,
                                         'longitude': -86.05194091796875,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '1512-PETER_HANSON-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjI0MDAyMDAx',
                                         'serial_number': 'S142F2224002001',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.989.011.00',
                                         'system_mac_address': '04:f1:7d:00:f6:3a',
                                         'temperature': 37.531,
                                         'uptime': '161149'},
                                 {       'elevation': 1.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '49381940919',
                                                                       'in_ucast_pkts': '37725508',
                                                                       'links': [       {       'in_octets': '49381940919',
                                                                                                'in_ucast_pkts': '37725508',
                                                                                                'out_octets': '9969410413',
                                                                                                'out_ucast_pkts': '32823523',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '9969410413',
                                                                       'out_ucast_pkts': '32823523',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1NjQxMQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '160901',
                                                                                                                                                     'distance': 4234,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '37607',
                                                                       'in_octets': '9969508844',
                                                                       'in_ucast_pkts': '32783267',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '49221864174',
                                                                       'out_ucast_pkts': '37718950',
                                                                       'poller_hash': 'UzE0MkYyMjIxODA1NjQxZ2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.98019790649414,
                                         'longitude': -86.04246520996094,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.5323496,
                                         'model': '30-0142-001',
                                         'name': '1764-MELISSA_MURPHY-RES100-R',
                                         'poller_hash': 'UzE0MkYyMjIxODA1NjQx',
                                         'serial_number': 'S142F2221805641',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:75:67',
                                         'temperature': 40.782,
                                         'uptime': '161141'},
                                 {       'elevation': 8.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wl1',
                                                                       'in_octets': '9454084869',
                                                                       'in_ucast_pkts': '8218013',
                                                                       'links': [       {       'in_octets': '9454084869',
                                                                                                'in_ucast_pkts': '8218013',
                                                                                                'out_octets': '6508551191',
                                                                                                'out_ucast_pkts': '10970772',
                                                                                                'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}],
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'oper_up': True,
                                                                       'out_octets': '6508551191',
                                                                       'out_ucast_pkts': '10970772',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDI1MQ==',
                                                                       'radios': [       {       'chan_width': 80,
                                                                                                 'dl_percent': 82,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 3640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '152581',
                                                                                                                                                     'distance': 2211,
                                                                                                                                                     'poller_hash': 'UzE0MUYyMjI0MzA1MTAwd2wx'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]},
                                                               {       'admin_up': True,
                                                                       'id': 'gi1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '107',
                                                                       'in_nucast_pkts': '420350',
                                                                       'in_octets': '67551962752',
                                                                       'in_ucast_pkts': '182884394',
                                                                       'name': 'Subscriber '
                                                                               '- 1G '
                                                                               'POE',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '334192845088',
                                                                       'out_ucast_pkts': '278388742',
                                                                       'poller_hash': 'UzE0MkYxMjE0NzAwMDI1Z2kx',
                                                                       'speed': '1000000000'}],
                                         'latitude': 30.955228805541992,
                                         'longitude': -86.03858184814453,
                                         'manufacturer': 'Tarana',
                                         'mem': 1.7026106,
                                         'model': '30-0142-001',
                                         'name': '1031-DANA_DICE-RES100-R',
                                         'poller_hash': 'UzE0MkYxMjE0NzAwMDI1',
                                         'serial_number': 'S142F1214700025',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '0.988.004.00',
                                         'system_mac_address': '04:f1:7d:00:38:b7',
                                         'temperature': 35.209,
                                         'uptime': '1627610'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_989_037_00_01(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.989.037.00.01")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 0,
                'sw_version': '0.989.037.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2223909041',
                'system_mac_address': '04:f1:7d:00:f7:49',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 24.61156,
                                'elevation': 86.26,
                                'gps_sats_tracked': 17,
                                'height': 0.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'name': 'WLAN interface',
                                                              'poller_hash': 'UzE0MUYyMjIzOTA5MDQxd2wx',
                                                              'radios': [       {       'chan_width': 80,
                                                                                        'dl_percent': 82,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 3600,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}]}],
                                                              'sectors': [       {       'mode': 'AP'}]},
                                                      {       'admin_up': False,
                                                              'id': 'gi1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data3 - 1G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIzOTA5MDQxZ2kx'},
                                                      {       'admin_up': True,
                                                              'id': 'ex1',
                                                              'in_discards': '15',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '647367',
                                                              'in_octets': '157039889',
                                                              'name': 'Data1 - 10G',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '117',
                                                              'out_octets': '1154857368',
                                                              'poller_hash': 'UzE0MUYyMjIzOTA5MDQxZXgx',
                                                              'speed': '10000000000'},
                                                      {       'admin_up': False,
                                                              'id': 'ex2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'name': 'Data2 - 10G',
                                                              'oper_up': False,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'poller_hash': 'UzE0MUYyMjIzOTA5MDQxZXgy'}],
                                'latitude': 30.612342834472656,
                                'longitude': -85.69384765625,
                                'manufacturer': 'Tarana',
                                'mem': 2.0678685,
                                'model': '30-0141-001',
                                'poller_hash': 'UzE0MUYyMjIzOTA5MDQx',
                                'serial_number': 'S141F2223909041',
                                'sw_version': '0.989.037.00',
                                'system_mac_address': '04:f1:7d:00:f7:49',
                                'temperature': 52.645,
                                'uptime': '369730'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_tarana_tarana_30_0141_001_0_997_028_00_10_11_230_80(self):
        obj = self.run_data("tarana.tarana.30-0141-001.0.997.028.00.10_11_230_80")
        exp_info = {
                'model': '30-0141-001',
                'sta_count': 17,
                'sw_version': '0.997.028.00',
                'vendor': 'Tarana'
        }
        exp_stats = {
                'cpu': None,
                'dl_rf_bytes': None,
                'dl_rf_packets': None,
                'mem': None,
                'serial_number': 'S141F2224609648',
                'system_mac_address': '04:f1:7d:01:40:c3',
                'ul_rf_bytes': None,
                'ul_rf_packets': None
        }
        exp_sta_stats = {
                '04:f1:7d:00:d7:40': {       'dev_macs': None,
                                             'dl_link_rate': 337118749,
                                             'dl_rf_bytes': 354880763758,
                                             'dl_rf_packets': 254008821,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:d7:40',
                                             'name': '12344-HDN6',
                                             'serial_number': 'S142F2223804424',
                                             'system_mac_address': None,
                                             'ul_link_rate': 68321491,
                                             'ul_rf_bytes': 23499133075,
                                             'ul_rf_packets': 88514290},
                '04:f1:7d:00:d8:b1': {       'dev_macs': None,
                                             'dl_link_rate': 589048031,
                                             'dl_rf_bytes': 69128296843,
                                             'dl_rf_packets': 51064010,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:00:d8:b1',
                                             'name': '1170-HDN8',
                                             'serial_number': 'S142F2223804387',
                                             'system_mac_address': None,
                                             'ul_link_rate': 132176296,
                                             'ul_rf_bytes': 8067521731,
                                             'ul_rf_packets': 23302773},
                '04:f1:7d:01:64:ad': {       'dev_macs': None,
                                             'dl_link_rate': 640555874,
                                             'dl_rf_bytes': 30897021516,
                                             'dl_rf_packets': 25388577,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:64:ad',
                                             'name': '4069-HDN128',
                                             'serial_number': 'S142F2225107066',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142476656,
                                             'ul_rf_bytes': 1962892132,
                                             'ul_rf_packets': 10475571},
                '04:f1:7d:01:68:98': {       'dev_macs': None,
                                             'dl_link_rate': 641433624,
                                             'dl_rf_bytes': 44348263216,
                                             'dl_rf_packets': 38818009,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:68:98',
                                             'name': '12489-HDN17',
                                             'serial_number': 'S142F2225211193',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142540906,
                                             'ul_rf_bytes': 3925226059,
                                             'ul_rf_packets': 17031923},
                '04:f1:7d:01:71:0c': {       'dev_macs': None,
                                             'dl_link_rate': 328955139,
                                             'dl_rf_bytes': 18873438215,
                                             'dl_rf_packets': 12786911,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:71:0c',
                                             'name': '12803-HDN99',
                                             'serial_number': 'S142F2225107112',
                                             'system_mac_address': None,
                                             'ul_link_rate': 76367548,
                                             'ul_rf_bytes': 273297910,
                                             'ul_rf_packets': 2476957},
                '04:f1:7d:01:7b:4a': {       'dev_macs': None,
                                             'dl_link_rate': 409102781,
                                             'dl_rf_bytes': 134136455385,
                                             'dl_rf_packets': 98509088,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7b:4a',
                                             'name': '12426-HDN10',
                                             'serial_number': 'S142F2225211222',
                                             'system_mac_address': None,
                                             'ul_link_rate': 80771632,
                                             'ul_rf_bytes': 4856650514,
                                             'ul_rf_packets': 28013396},
                '04:f1:7d:01:7b:51': {       'dev_macs': None,
                                             'dl_link_rate': 641433624,
                                             'dl_rf_bytes': 182839009416,
                                             'dl_rf_packets': 130426021,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7b:51',
                                             'name': 'S142F2225211223',
                                             'serial_number': 'S142F2225211223',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142540906,
                                             'ul_rf_bytes': 7530660805,
                                             'ul_rf_packets': 61549552},
                '04:f1:7d:01:7c:10': {       'dev_macs': None,
                                             'dl_link_rate': 639874999,
                                             'dl_rf_bytes': 297175966427,
                                             'dl_rf_packets': 214419934,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7c:10',
                                             'name': '8439-HDN13',
                                             'serial_number': 'S142F2225211271',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142311218,
                                             'ul_rf_bytes': 17734606423,
                                             'ul_rf_packets': 87806139},
                '04:f1:7d:01:7c:17': {       'dev_macs': None,
                                             'dl_link_rate': 634032124,
                                             'dl_rf_bytes': 36122135378,
                                             'dl_rf_packets': 31903073,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7c:17',
                                             'name': '12488-HDN117',
                                             'serial_number': 'S142F2225211249',
                                             'system_mac_address': None,
                                             'ul_link_rate': 131350777,
                                             'ul_rf_bytes': 7088701098,
                                             'ul_rf_packets': 14491905},
                '04:f1:7d:01:7c:35': {       'dev_macs': None,
                                             'dl_link_rate': 641433624,
                                             'dl_rf_bytes': 15126091557,
                                             'dl_rf_packets': 12962982,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7c:35',
                                             'name': '11025-HDN16',
                                             'serial_number': 'S142F2225211207',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142540906,
                                             'ul_rf_bytes': 1401627835,
                                             'ul_rf_packets': 5735560},
                '04:f1:7d:01:7c:9e': {       'dev_macs': None,
                                             'dl_link_rate': 641433624,
                                             'dl_rf_bytes': 119103361171,
                                             'dl_rf_packets': 102770280,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7c:9e',
                                             'name': '3215-HDN12',
                                             'serial_number': 'S142F2225211272',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142540906,
                                             'ul_rf_bytes': 12705557914,
                                             'ul_rf_packets': 48458598},
                '04:f1:7d:01:7c:bc': {       'dev_macs': None,
                                             'dl_link_rate': 548066093,
                                             'dl_rf_bytes': 242603847360,
                                             'dl_rf_packets': 181183732,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7c:bc',
                                             'name': 'S142F2225211269',
                                             'serial_number': 'S142F2225211269',
                                             'system_mac_address': None,
                                             'ul_link_rate': 111905776,
                                             'ul_rf_bytes': 21835321776,
                                             'ul_rf_packets': 45964780},
                '04:f1:7d:01:7c:d9': {       'dev_macs': None,
                                             'dl_link_rate': 641433624,
                                             'dl_rf_bytes': 8706612837,
                                             'dl_rf_packets': 9901040,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7c:d9',
                                             'name': '12462-HDN18',
                                             'serial_number': 'S142F2225211248',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142540906,
                                             'ul_rf_bytes': 2692175416,
                                             'ul_rf_packets': 7440211},
                '04:f1:7d:01:7d:38': {       'dev_macs': None,
                                             'dl_link_rate': 641433624,
                                             'dl_rf_bytes': 1233748633021,
                                             'dl_rf_packets': 915161306,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7d:38',
                                             'name': '6418-HDN11',
                                             'serial_number': 'S142F2225211241',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142540906,
                                             'ul_rf_bytes': 55501626795,
                                             'ul_rf_packets': 352326128},
                '04:f1:7d:01:7d:59': {       'dev_macs': None,
                                             'dl_link_rate': 641433624,
                                             'dl_rf_bytes': 166332957689,
                                             'dl_rf_packets': 123602132,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7d:59',
                                             'name': '4782-HDN9',
                                             'serial_number': 'S142F2225211293',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142540906,
                                             'ul_rf_bytes': 12260260338,
                                             'ul_rf_packets': 48942055},
                '04:f1:7d:01:7d:86': {       'dev_macs': None,
                                             'dl_link_rate': 641433624,
                                             'dl_rf_bytes': 24104103011,
                                             'dl_rf_packets': 18392511,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7d:86',
                                             'name': '1503-HDN15',
                                             'serial_number': 'S142F2225211208',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142540906,
                                             'ul_rf_bytes': 2344998634,
                                             'ul_rf_packets': 7622337},
                '04:f1:7d:01:7d:bf': {       'dev_macs': None,
                                             'dl_link_rate': 641433624,
                                             'dl_rf_bytes': 125500116721,
                                             'dl_rf_packets': 91683288,
                                             'ip_address': None,
                                             'mac_address': '04:f1:7d:01:7d:bf',
                                             'name': '10739-HDN21',
                                             'serial_number': 'S142F2225211295',
                                             'system_mac_address': None,
                                             'ul_link_rate': 142540906,
                                             'ul_rf_bytes': 3641478382,
                                             'ul_rf_packets': 26890711}
        }
        exp_ne_msg = {
                'data': {       'cpu': 33.66416,
                                'elevation': 2235.023,
                                'gps_sats_tracked': 21,
                                'height': 0.0,
                                'interfaces': [       {       'id': 'wl1',
                                                              'links': [       {       'in_errors': '13052',
                                                                                       'in_octets': '55501626795',
                                                                                       'in_ucast_pkts': '352326128',
                                                                                       'out_errors': '183920',
                                                                                       'out_octets': '1233748633021',
                                                                                       'out_ucast_pkts': '915161306',
                                                                                       'poller_hash': 'UzE0MkYyMjI1MjExMjQxMQ=='},
                                                                               {       'in_errors': '1201094',
                                                                                       'in_octets': '23499133075',
                                                                                       'in_ucast_pkts': '88514290',
                                                                                       'out_errors': '5110722',
                                                                                       'out_octets': '354880763758',
                                                                                       'out_ucast_pkts': '254008821',
                                                                                       'poller_hash': 'UzE0MkYyMjIzODA0NDI0MQ=='},
                                                                               {       'in_errors': '14571',
                                                                                       'in_octets': '3641478382',
                                                                                       'in_ucast_pkts': '26890711',
                                                                                       'out_errors': '72895',
                                                                                       'out_octets': '125500116721',
                                                                                       'out_ucast_pkts': '91683288',
                                                                                       'poller_hash': 'UzE0MkYyMjI1MjExMjk1MQ=='},
                                                                               {       'in_errors': '1979',
                                                                                       'in_octets': '12705557914',
                                                                                       'in_ucast_pkts': '48458598',
                                                                                       'out_errors': '306',
                                                                                       'out_octets': '119103361171',
                                                                                       'out_ucast_pkts': '102770280',
                                                                                       'poller_hash': 'UzE0MkYyMjI1MjExMjcyMQ=='},
                                                                               {       'in_errors': '24572',
                                                                                       'in_octets': '17734606423',
                                                                                       'in_ucast_pkts': '87806139',
                                                                                       'out_errors': '211397',
                                                                                       'out_octets': '297175966427',
                                                                                       'out_ucast_pkts': '214419934',
                                                                                       'poller_hash': 'UzE0MkYyMjI1MjExMjcxMQ=='},
                                                                               {       'in_errors': '785922',
                                                                                       'in_octets': '21835321776',
                                                                                       'in_ucast_pkts': '45964780',
                                                                                       'out_errors': '3553963',
                                                                                       'out_octets': '242603847360',
                                                                                       'out_ucast_pkts': '181183732',
                                                                                       'poller_hash': 'UzE0MkYyMjI1MjExMjY5MQ=='},
                                                                               {       'in_errors': '17121',
                                                                                       'in_octets': '273297910',
                                                                                       'in_ucast_pkts': '2476957',
                                                                                       'out_errors': '254810',
                                                                                       'out_octets': '18873438215',
                                                                                       'out_ucast_pkts': '12786911',
                                                                                       'poller_hash': 'UzE0MkYyMjI1MTA3MTEyMQ=='},
                                                                               {       'in_errors': '473860',
                                                                                       'in_octets': '4856650514',
                                                                                       'in_ucast_pkts': '28013396',
                                                                                       'out_errors': '2076264',
                                                                                       'out_octets': '134136455385',
                                                                                       'out_ucast_pkts': '98509088',
                                                                                       'poller_hash': 'UzE0MkYyMjI1MjExMjIyMQ=='},
                                                                               {       'in_errors': '667',
                                                                                       'in_octets': '1962892132',
                                                                                       'in_ucast_pkts': '10475571',
                                                                                       'out_errors': '254214',
                                                                                       'out_octets': '30897021516',
                                                