import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestAdtranModels(DeviceTestCase):

    def test_adtran_ta5000_TA5000_11_1_5_4_01(self):
        obj = self.run_data("adtran.ta5000.TA5000.11.1.5.4.01")
        exp_info = {'model': 'TA5000', 'sw_version': '11.1.5.4', 'vendor': 'Adtran'}
        exp_stats = {'serial_number': 'LBADTN2112AM202'}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'manufacturer':
                'Adtran',
                'model':
                'TA5000',
                'modules': [{
                    'id': '1',
                    'manufacturer': 'Adtran',
                    'mem': 31.035233,
                    'model': '1187518F1',
                    'name': 'COMBO OLT 8P',
                    'poller_hash': 'TEJBRFROMjEyOUNEODUzMTE4NzUxOEYx',
                    'serial_number': 'LBADTN2129CD853',
                    'sw_version': '11.1.5.4.11',
                    'temperature': 34.0,
                    'uptime': '10993448'
                }, {
                    'id': '2',
                    'manufacturer': 'Adtran',
                    'mem': 30.529404,
                    'model': '1187518F1',
                    'name': 'COMBO OLT 8P',
                    'poller_hash': 'TEJBRFROMjEyOUNEODY5MTE4NzUxOEYx',
                    'serial_number': 'LBADTN2129CD869',
                    'sw_version': '11.1.5.4.11',
                    'temperature': 34.6,
                    'uptime': '10993458'
                }, {
                    'id': '251',
                    'manufacturer': 'Adtran',
                    'model': '1187080G3',
                    'name': 'Fan Module',
                    'poller_hash': 'TEJBRFROMjExM0FLNjY1MTE4NzA4MEcz',
                    'serial_number': 'LBADTN2113AK665',
                    'sw_version': 'A03.00',
                    'uptime': '20061534'
                }, {
                    'id': '252',
                    'manufacturer': 'Adtran',
                    'mem': 9.840206,
                    'model': '1187041F1',
                    'name': 'SM 4-10G',
                    'poller_hash': 'TEJBRFROMjExM0FLMTcyMTE4NzA0MUYx',
                    'serial_number': 'LBADTN2113AK172',
                    'sw_version': 'L15.0336',
                    'temperature': 45.5,
                    'uptime': '20061534'
                }, {
                    'id': '253',
                    'manufacturer': 'Adtran',
                    'mem': 9.821498,
                    'model': '1187041F1',
                    'name': 'SM 4-10G',
                    'poller_hash': 'TEJBRFROMjExM0FLMTYzMTE4NzA0MUYx',
                    'serial_number': 'LBADTN2113AK163',
                    'sw_version': 'L15.0336',
                    'uptime': '20061847'
                }, {
                    'id': '254',
                    'manufacturer': 'Adtran',
                    'mem': 41.98529,
                    'model': '1187011F3',
                    'name': 'SCM',
                    'poller_hash': 'TEJBRFROMjExMUFBMDM5MTE4NzAxMUYz',
                    'serial_number': 'LBADTN2111AA039',
                    'sw_version': 'L15.028',
                    'uptime': '10993375'
                }, {
                    'id': '3',
                    'manufacturer': 'Adtran',
                    'mem': 30.221558,
                    'model': '1187518F1',
                    'name': 'COMBO OLT 8P',
                    'poller_hash': 'TEJBRFROMjEyOUNFMDEyMTE4NzUxOEYx',
                    'serial_number': 'LBADTN2129CE012',
                    'sw_version': '11.1.5.4.11',
                    'temperature': 33.0,
                    'uptime': '10993440'
                }],
                'poller_hash':
                'TEJBRFROMjExMkFNMjAy',
                'serial_number':
                'LBADTN2112AM202',
                'sw_version':
                '11.1.5.4'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
