import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):
    def test_ubnt_airmax_ac_Bullet_AC_v8_5_12_01(self):
        obj = self.run_data("ubnt.airmax-ac.Bullet AC.v8.5.12.01")
        exp_info = {
                'gps_sync': False,
                'model': 'Bullet AC',
                'rf_chan_width': 20,
                'rf_freq': 5540,
                'rf_tx_power': 21,
                'sta_count': 14,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.12',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 15.7,
                'cpu': 7.0,
                'dl_en_bytes': 11944913,
                'dl_en_packets': 2479640792,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1919529646,
                'dl_rf_packets': 2493831965,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 2294105056,
                'ul_en_packets': 1479147100,
                'ul_noise_floor': -92,
                'ul_rf_bytes': 4282804861,
                'ul_rf_packets': 1492765621
        }
        exp_sta_stats = {
                '00:27:22:88:e2:97': {       'alt_macs': ['00:27:22:89:e2:97'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 68789650135,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.18.207.96',
                                             'mac_address': '00:27:22:88:e2:97',
                                             'name': 'Welborne Mark (The Roundhouse)',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 5000476722,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 34.0},
                '00:27:22:bc:2d:be': {       'alt_macs': ['00:27:22:bd:2d:be'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 316408900463,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.18.207.97',
                                             'mac_address': '00:27:22:bc:2d:be',
                                             'name': '',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 22340271988,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 33.0},
                '00:27:22:bc:36:24': {       'alt_macs': ['00:27:22:bd:36:24'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 162812149131,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.18.207.89',
                                             'mac_address': '00:27:22:bc:36:24',
                                             'name': 'GordonR2',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 5978852912,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 33.0},
                '04:18:d6:fa:3c:23': {       'alt_macs': ['04:18:d6:fb:3c:23'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 24666965127,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.18.207.94',
                                             'mac_address': '04:18:d6:fa:3c:23',
                                             'name': 'SouthwoodN (FarmCottage)',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 39103854347,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 34.0},
                '24:a4:3c:32:6a:17': {       'alt_macs': ['24:a4:3c:33:6a:17'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 310372040605,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.18.207.88',
                                             'mac_address': '24:a4:3c:32:6a:17',
                                             'name': 'AbellM',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 19357802816,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.0,
                                             'ul_snr': 23.0},
                '24:a4:3c:8c:73:2a': {       'alt_macs': ['24:a4:3c:8d:73:2a'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 139088042644,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:a4:3c:8c:73:2a',
                                             'name': 'PorteousM',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 70718321178,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 34.0},
                '24:a4:3c:90:2b:03': {       'alt_macs': ['24:a4:3c:91:2b:03'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 166578405287,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.18.207.100',
                                             'mac_address': '24:a4:3c:90:2b:03',
                                             'name': 'Wilson Kevin',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 16599709927,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -66.0,
                                             'ul_snr': 26.0},
                '24:a4:3c:9e:ca:e0': {       'alt_macs': ['24:a4:3c:9f:ca:e0'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 38819050359,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.18.207.90',
                                             'mac_address': '24:a4:3c:9e:ca:e0',
                                             'name': 'HartleyI',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 3971651019,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 33.0},
                '44:d9:e7:52:0b:76': {       'alt_macs': ['44:d9:e7:53:0b:76'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 34107627659,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.28.47.253',
                                             'mac_address': '44:d9:e7:52:0b:76',
                                             'name': 'Prince Rupert House',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 7039421624,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 31.0},
                '78:8a:20:e6:42:ef': {       'alt_macs': ['78:8a:20:e7:42:ef'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 543171842564,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.18.207.93',
                                             'mac_address': '78:8a:20:e6:42:ef',
                                             'name': 'Peter Ramsbotham YO26',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 34736911801,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 33.0},
                '80:2a:a8:34:7a:d1': {       'alt_macs': ['80:2a:a8:35:7a:d1'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 153208191394,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.18.207.95',
                                             'mac_address': '80:2a:a8:34:7a:d1',
                                             'name': 'TheakstoneEngineering',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 20017531552,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 32.0},
                'b4:fb:e4:58:b4:30': {       'alt_macs': ['b4:fb:e4:59:b4:30'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 36955449024,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.28.47.246',
                                             'mac_address': 'b4:fb:e4:58:b4:30',
                                             'name': 'Naylor Natasha ',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 1646508770,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 28.0},
                'fc:ec:da:2c:74:a6': {       'alt_macs': ['fc:ec:da:2d:74:a6'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 101226282563,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:2c:74:a6',
                                             'name': 'Wilson Keith (Old Orchard)',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 9293029924,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 34.0},
                'fc:ec:da:60:6e:2f': {       'alt_macs': ['fc:ec:da:61:6e:2f'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 12343645426,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': 'fc:ec:da:60:6e:2f',
                                             'name': 'Wilson G (Keith) (Holy Tree '
                                                     'Farm)',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 934377214,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 29.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 7.0,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '6491455',
                                                              'in_octets': '11944913',
                                                              'in_ucast_pkts': '2473149337',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'b4:fb:e4:bf:7c:6c',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '2',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2294105056',
                                                              'out_ucast_pkts': '1479147100',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '4282804861',
                                                              'in_ucast_pkts': '1492765621',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '5000476722',
                                                                                       'mac_address': '00:27:22:88:e2:97',
                                                                                       'out_octets': '68789650135'},
                                                                               {       'in_octets': '22340271988',
                                                                                       'mac_address': '00:27:22:bc:2d:be',
                                                                                       'out_octets': '316408900463'},
                                                                               {       'in_octets': '5978852912',
                                                                                       'mac_address': '00:27:22:bc:36:24',
                                                                                       'out_octets': '162812149131'},
                                                                               {       'in_octets': '34736911801',
                                                                                       'mac_address': '78:8a:20:e6:42:ef',
                                                                                       'out_octets': '543171842564'},
                                                                               {       'in_octets': '20017531552',
                                                                                       'mac_address': '80:2a:a8:34:7a:d1',
                                                                                       'out_octets': '153208191394'},
                                                                               {       'in_octets': '1646508770',
                                                                                       'mac_address': 'b4:fb:e4:58:b4:30',
                                                                                       'out_octets': '36955449024'},
                                                                               {       'in_octets': '9293029924',
                                                                                       'mac_address': 'fc:ec:da:2c:74:a6',
                                                                                       'out_octets': '101226282563'},
                                                                               {       'in_octets': '934377214',
                                                                                       'mac_address': 'fc:ec:da:60:6e:2f',
                                                                                       'out_octets': '12343645426'},
                                                                               {       'in_octets': '70718321178',
                                                                                       'mac_address': '24:a4:3c:8c:73:2a',
                                                                                       'out_octets': '139088042644'},
                                                                               {       'in_octets': '16599709927',
                                                                                       'mac_address': '24:a4:3c:90:2b:03',
                                                                                       'out_octets': '166578405287'},
                                                                               {       'in_octets': '3971651019',
                                                                                       'mac_address': '24:a4:3c:9e:ca:e0',
                                                                                       'out_octets': '38819050359'},
                                                                               {       'in_octets': '19357802816',
                                                                                       'mac_address': '24:a4:3c:32:6a:17',
                                                                                       'out_octets': '310372040605'},
                                                                               {       'in_octets': '39103854347',
                                                                                       'mac_address': '04:18:d6:fa:3c:23',
                                                                                       'out_octets': '24666965127'},
                                                                               {       'in_octets': '7039421624',
                                                                                       'mac_address': '44:d9:e7:52:0b:76',
                                                                                       'out_octets': '34107627659'}],
                                                              'mac_address': 'b4:fb:e4:be:7c:6c',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '449',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1919529646',
                                                              'out_ucast_pkts': '2493831965',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5540,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1548492',
                                                                                                                                            'distance': 1050,
                                                                                                                                            'mac_address': '00:27:22:88:e2:97',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'snr': 34.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '3480943',
                                                                                                                                            'distance': 0,
                                                                                                                                            'mac_address': '00:27:22:bc:2d:be',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 33.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2358734',
                                                                                                                                            'distance': 150,
                                                                                                                                            'mac_address': '00:27:22:bc:36:24',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 33.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '3480943',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': '78:8a:20:e6:42:ef',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 33.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '3480947',
                                                                                                                                            'distance': 1350,
                                                                                                                                            'mac_address': '80:2a:a8:34:7a:d1',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'snr': 32.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '187905',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': 'b4:fb:e4:58:b4:30',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'snr': 28.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '3480948',
                                                                                                                                            'distance': 1200,
                                                                                                                                            'mac_address': 'fc:ec:da:2c:74:a6',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'snr': 34.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1157426',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': 'fc:ec:da:60:6e:2f',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'snr': 29.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2675936',
                                                                                                                                            'distance': 150,
                                                                                                                                            'mac_address': '24:a4:3c:8c:73:2a',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'snr': 34.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2867118',
                                                                                                                                            'distance': 3600,
                                                                                                                                            'mac_address': '24:a4:3c:90:2b:03',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'snr': 26.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '3480945',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': '24:a4:3c:9e:ca:e0',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 33.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '3480944',
                                                                                                                                            'distance': 1500,
                                                                                                                                            'mac_address': '24:a4:3c:32:6a:17',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'snr': 23.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '338293',
                                                                                                                                            'distance': 1050,
                                                                                                                                            'mac_address': '04:18:d6:fa:3c:23',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'snr': 34.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1678601',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': '44:d9:e7:52:0b:76',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'snr': 31.0}],
                                                                                                                   'noise_floor': -92.0}],
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Redhouse'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'Bullet AC',
                                'sw_version': 'v8.5.12',
                                'system_mac_address': 'b4:fb:e4:be:7c:6c',
                                'temperature': 0.0,
                                'uptime': '3481039'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '68789650135',
                                                                       'links': [       {       'in_octets': '68789650135',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '5000476722'}],
                                                                       'mac_address': '00:27:22:88:e2:97',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5000476722',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1548492',
                                                                                                                                                     'distance': 1050,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '5000476722',
                                                                       'mac_address': '00:27:22:89:e2:97',
                                                                       'name': 'eth0',
                                                                       'out_octets': '68789650135'}],
                                         'management_ip': '172.18.207.96',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Welborne Mark (The Roundhouse)',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:27:22:88:e2:97'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '316408900463',
                                                                       'links': [       {       'in_octets': '316408900463',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '22340271988'}],
                                                                       'mac_address': '00:27:22:bc:2d:be',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '22340271988',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3480943',
                                                                                                                                                     'distance': 0,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '22340271988',
                                                                       'mac_address': '00:27:22:bd:2d:be',
                                                                       'name': 'eth0',
                                                                       'out_octets': '316408900463'}],
                                         'management_ip': '172.18.207.97',
                                         'manufacturer': 'Ubiquiti',
                                         'name': '',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:27:22:bc:2d:be'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '162812149131',
                                                                       'links': [       {       'in_octets': '162812149131',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '5978852912'}],
                                                                       'mac_address': '00:27:22:bc:36:24',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5978852912',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2358734',
                                                                                                                                                     'distance': 150,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '5978852912',
                                                                       'mac_address': '00:27:22:bd:36:24',
                                                                       'name': 'eth0',
                                                                       'out_octets': '162812149131'}],
                                         'management_ip': '172.18.207.89',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'GordonR2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:27:22:bc:36:24'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '543171842564',
                                                                       'links': [       {       'in_octets': '543171842564',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '34736911801'}],
                                                                       'mac_address': '78:8a:20:e6:42:ef',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '34736911801',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3480943',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '34736911801',
                                                                       'mac_address': '78:8a:20:e7:42:ef',
                                                                       'name': 'eth0',
                                                                       'out_octets': '543171842564'}],
                                         'management_ip': '172.18.207.93',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Peter Ramsbotham YO26',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:e6:42:ef'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '153208191394',
                                                                       'links': [       {       'in_octets': '153208191394',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '20017531552'}],
                                                                       'mac_address': '80:2a:a8:34:7a:d1',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '20017531552',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3480947',
                                                                                                                                                     'distance': 1350,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '20017531552',
                                                                       'mac_address': '80:2a:a8:35:7a:d1',
                                                                       'name': 'eth0',
                                                                       'out_octets': '153208191394'}],
                                         'management_ip': '172.18.207.95',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'TheakstoneEngineering',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '80:2a:a8:34:7a:d1'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '36955449024',
                                                                       'links': [       {       'in_octets': '36955449024',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '1646508770'}],
                                                                       'mac_address': 'b4:fb:e4:58:b4:30',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1646508770',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '187905',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1646508770',
                                                                       'mac_address': 'b4:fb:e4:59:b4:30',
                                                                       'name': 'eth0',
                                                                       'out_octets': '36955449024'}],
                                         'management_ip': '172.28.47.246',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Naylor Natasha ',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:58:b4:30'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '101226282563',
                                                                       'links': [       {       'in_octets': '101226282563',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '9293029924'}],
                                                                       'mac_address': 'fc:ec:da:2c:74:a6',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '9293029924',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3480948',
                                                                                                                                                     'distance': 1200,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '9293029924',
                                                                       'mac_address': 'fc:ec:da:2d:74:a6',
                                                                       'name': 'eth0',
                                                                       'out_octets': '101226282563'}],
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Wilson Keith (Old Orchard)',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:2c:74:a6'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '12343645426',
                                                                       'links': [       {       'in_octets': '12343645426',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '934377214'}],
                                                                       'mac_address': 'fc:ec:da:60:6e:2f',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '934377214',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1157426',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '934377214',
                                                                       'mac_address': 'fc:ec:da:61:6e:2f',
                                                                       'name': 'eth0',
                                                                       'out_octets': '12343645426'}],
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Wilson G (Keith) (Holy Tree Farm)',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:60:6e:2f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '139088042644',
                                                                       'links': [       {       'in_octets': '139088042644',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '70718321178'}],
                                                                       'mac_address': '24:a4:3c:8c:73:2a',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '70718321178',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2675936',
                                                                                                                                                     'distance': 150,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '70718321178',
                                                                       'mac_address': '24:a4:3c:8d:73:2a',
                                                                       'name': 'eth0',
                                                                       'out_octets': '139088042644'}],
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'PorteousM',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:a4:3c:8c:73:2a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '166578405287',
                                                                       'links': [       {       'in_octets': '166578405287',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '16599709927'}],
                                                                       'mac_address': '24:a4:3c:90:2b:03',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '16599709927',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2867118',
                                                                                                                                                     'distance': 3600,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '16599709927',
                                                                       'mac_address': '24:a4:3c:91:2b:03',
                                                                       'name': 'eth0',
                                                                       'out_octets': '166578405287'}],
                                         'management_ip': '172.18.207.100',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Wilson Kevin',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:a4:3c:90:2b:03'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '38819050359',
                                                                       'links': [       {       'in_octets': '38819050359',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '3971651019'}],
                                                                       'mac_address': '24:a4:3c:9e:ca:e0',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3971651019',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3480945',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3971651019',
                                                                       'mac_address': '24:a4:3c:9f:ca:e0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '38819050359'}],
                                         'management_ip': '172.18.207.90',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'HartleyI',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:a4:3c:9e:ca:e0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '310372040605',
                                                                       'links': [       {       'in_octets': '310372040605',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '19357802816'}],
                                                                       'mac_address': '24:a4:3c:32:6a:17',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '19357802816',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3480944',
                                                                                                                                                     'distance': 1500,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '19357802816',
                                                                       'mac_address': '24:a4:3c:33:6a:17',
                                                                       'name': 'eth0',
                                                                       'out_octets': '310372040605'}],
                                         'management_ip': '172.18.207.88',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'AbellM',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:a4:3c:32:6a:17'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '24666965127',
                                                                       'links': [       {       'in_octets': '24666965127',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '39103854347'}],
                                                                       'mac_address': '04:18:d6:fa:3c:23',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '39103854347',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '338293',
                                                                                                                                                     'distance': 1050,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '39103854347',
                                                                       'mac_address': '04:18:d6:fb:3c:23',
                                                                       'name': 'eth0',
                                                                       'out_octets': '24666965127'}],
                                         'management_ip': '172.18.207.94',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'SouthwoodN (FarmCottage)',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:fa:3c:23'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '34107627659',
                                                                       'links': [       {       'in_octets': '34107627659',
                                                                                                'mac_address': 'b4:fb:e4:be:7c:6c',
                                                                                                'out_octets': '7039421624'}],
                                                                       'mac_address': '44:d9:e7:52:0b:76',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7039421624',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5540,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1678601',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': 'b4:fb:e4:be:7c:6c'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Redhouse'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '7039421624',
                                                                       'mac_address': '44:d9:e7:53:0b:76',
                                                                       'name': 'eth0',
                                                                       'out_octets': '34107627659'}],
                                         'management_ip': '172.28.47.253',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Prince Rupert House',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '44:d9:e7:52:0b:76'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_GigaBeam_LR_v0_11_0_cs_01(self):
        obj = self.run_data("ubnt.airmax-ac.GigaBeam LR.v0.11.0-cs.01")
        exp_info = {
                'gps_sync': None,
                'model': 'GigaBeam LR',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'rf_tx_power': 25,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v0.11.0-cs',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 0.249377,
                'dl_en_bytes': 1523462272,
                'dl_en_packets': 1615143,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3313372805,
                'dl_rf_packets': 184018517,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'temperature': None,
                'ul_en_bytes': 267885087,
                'ul_en_packets': 2413070,
                'ul_noise_floor': -90,
                'ul_rf_bytes': 619956447,
                'ul_rf_packets': 184079733
        }
        exp_sta_stats = {
                'f4:92:bf:ec:53:3c': {       'alt_macs': ['f4:92:bf:ed:53:3c'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 80351500,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': 20493167022,
                                             'dl_rf_packets': 184018313,
                                             'dl_rssi': -59.0,
                                             'dl_snr': None,
                                             'ip_address': '169.254.83.60',
                                             'mac_address': 'f4:92:bf:ec:53:3c',
                                             'name': 'GB BISON B',
                                             'temperature': None,
                                             'ul_link_rate': 86399500,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 17799809390,
                                             'ul_rf_packets': 184079538,
                                             'ul_rssi': -61,
                                             'ul_snr': 35}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.249377,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1523462272',
                                                              'in_ucast_pkts': '1615143',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'f4:92:bf:ed:53:69',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '267885087',
                                                              'out_ucast_pkts': '2413070',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '1480',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '619956447',
                                                              'in_ucast_pkts': '184079733',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '17799809390',
                                                                                       'in_ucast_pkts': '184079538',
                                                                                       'mac_address': 'f4:92:bf:ec:53:3c',
                                                                                       'out_octets': '20493167022',
                                                                                       'out_ucast_pkts': '184018313'}],
                                                              'mac_address': 'f4:92:bf:ec:53:69',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3313372805',
                                                              'out_ucast_pkts': '184018517',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '86399500',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1970917',
                                                                                                                                            'distance': 37599,
                                                                                                                                            'mac_address': 'f4:92:bf:ec:53:3c',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '86399500',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '80351500',
                                                                                                                                            'tx_mcs': 4}],
                                                                                                                   'noise_floor': -90.0}],
                                                                                        'tx_link_rate': '80351500',
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'BISON60'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 49.4265,
                                'model': 'GigaBeam LR',
                                'sw_version': 'v0.11.0-cs',
                                'system_mac_address': 'f4:92:bf:ec:53:69',
                                'uptime': '1971736'},
                'peers': [       {       'cpu': 0.7444,
                                         'errors': [{'http_connect': {}}],
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '20493167022',
                                                                       'in_ucast_pkts': '184018313',
                                                                       'links': [       {       'in_octets': '20493167022',
                                                                                                'in_ucast_pkts': '184018313',
                                                                                                'mac_address': 'f4:92:bf:ec:53:69',
                                                                                                'out_octets': '17799809390',
                                                                                                'out_ucast_pkts': '184079538'}],
                                                                       'mac_address': 'f4:92:bf:ec:53:3c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '17799809390',
                                                                       'out_ucast_pkts': '184079538',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'dl_percent': 50,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '80351500',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1970917',
                                                                                                                                                     'distance': 37599,
                                                                                                                                                     'mac_address': 'f4:92:bf:ec:53:69',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '80351500',
                                                                                                                                                     'tx_link_rate': '86399500'}],
                                                                                                                            'noise_floor': -89.0}],
                                                                                                 'tx_link_rate': '86399500',
                                                                                                 'tx_power': 0}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BISON60'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '17799809390',
                                                                       'in_ucast_pkts': '184079538',
                                                                       'mac_address': 'f4:92:bf:ed:53:3c',
                                                                       'name': 'eth0',
                                                                       'out_octets': '20493167022',
                                                                       'out_ucast_pkts': '184018313'}],
                                         'management_ip': '169.254.83.60',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.97176,
                                         'model': 'GigaBeam LR',
                                         'name': 'GB BISON B',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': 'v0.11.0-cs',
                                         'system_mac_address': 'f4:92:bf:ec:53:3c',
                                         'uptime': '1970920'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_GigaBeam_LR_v1_3_0_01(self):
        obj = self.run_data("ubnt.airmax-ac.GigaBeam LR.v1.3.0.01")
        exp_info = {
                'gps_sync': None,
                'model': 'GigaBeam LR',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'rf_tx_power': 16,
                'sta_count': 1,
                'sta_mode_cpe': True,
                'sw_version': 'v1.3.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 1.736973,
                'dl_en_bytes': 4135466,
                'dl_en_packets': 68719,
                'dl_noise_floor': None,
                'dl_rf_bytes': 238511223,
                'dl_rf_packets': 3245413,
                'en_if_speed': 100000000,
                'gps_sats_tracked': 0,
                'temperature': None,
                'ul_en_bytes': 525591346,
                'ul_en_packets': 2041224,
                'ul_noise_floor': -92,
                'ul_rf_bytes': 556282011,
                'ul_rf_packets': 2111607
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.736973,
                                'elevation': 0.0,
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '4135466',
                                                              'in_ucast_pkts': '68719',
                                                              'mac_address': '74:ac:b9:73:4f:46',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '525591346',
                                                              'out_ucast_pkts': '2041224',
                                                              'speed': '100000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '543079563',
                                                              'in_ucast_pkts': '2098430',
                                                              'mac_address': '74:ac:b9:72:4f:46',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '12',
                                                              'out_octets': '224729401',
                                                              'out_ucast_pkts': '3231206',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '131000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'noise_floor': -92.0}],
                                                                                        'tx_link_rate': '152000',
                                                                                        'tx_power': 16}],
                                                              'sectors': [       {       'mode': 'STA',
                                                                                         'ssid': 'eastlandcountycourthouse'}],
                                                              'speed': '0'}],
                                'latitude': 32.401143,
                                'longitude': -98.817897,
                                'manufacturer': 'Ubiquiti',
                                'mem': 40.121326,
                                'model': 'GigaBeam LR',
                                'sw_version': 'v1.3.0',
                                'system_mac_address': '74:ac:b9:72:4f:46',
                                'uptime': '34386'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_GigaBeam_LR_v1_4_0_01(self):
        obj = self.run_data("ubnt.airmax-ac.GigaBeam LR.v1.4.0.01")
        exp_info = {
                'gps_sync': None,
                'model': 'GigaBeam LR',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'rf_tx_power': 19,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.4.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 0.25,
                'dl_en_bytes': 443211733180,
                'dl_en_packets': 1044738971,
                'dl_noise_floor': None,
                'dl_rf_bytes': 961241594738,
                'dl_rf_packets': 114609622,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'temperature': None,
                'ul_en_bytes': 98425657673,
                'ul_en_packets': 293445565,
                'ul_noise_floor': -93,
                'ul_rf_bytes': 608562193675,
                'ul_rf_packets': 29439064
        }
        exp_sta_stats = {
                '74:ac:b9:0c:99:b8': {       'alt_macs': ['74:ac:b9:0d:99:b8'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -72.0,
                                             'dl_rf_bytes': 46413560842,
                                             'dl_rf_packets': 114609621,
                                             'dl_rssi': -53.0,
                                             'dl_snr': 19.0,
                                             'ip_address': '10.0.82.27',
                                             'mac_address': '74:ac:b9:0c:99:b8',
                                             'name': 'Lorenz-Bolivar STA',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -72.0,
                                             'ul_rf_bytes': 7266772376,
                                             'ul_rf_packets': 29439064,
                                             'ul_rssi': -51,
                                             'ul_snr': 21}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.25,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '51',
                                                              'in_errors': '0',
                                                              'in_octets': '443211733180',
                                                              'in_ucast_pkts': '1044738971',
                                                              'mac_address': '74:ac:b9:0d:98:e8',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '98425657673',
                                                              'out_ucast_pkts': '293445565',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '608562193675',
                                                              'in_ucast_pkts': '29439064',
                                                              'links': [       {       'in_octets': '7266772376',
                                                                                       'in_ucast_pkts': '29439064',
                                                                                       'mac_address': '74:ac:b9:0c:99:b8',
                                                                                       'out_octets': '46413560842',
                                                                                       'out_ucast_pkts': '114609621'}],
                                                              'mac_address': '74:ac:b9:0c:98:e8',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '22',
                                                              'out_octets': '961241594738',
                                                              'out_ucast_pkts': '114609622',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '704567',
                                                                                                                                            'distance': 563,
                                                                                                                                            'mac_address': '74:ac:b9:0c:99:b8',
                                                                                                                                            'noise_floor': -72.0,
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_mcs': 7}],
                                                                                                                   'noise_floor': -93.0}],
                                                                                        'tx_link_rate': '168000',
                                                                                        'tx_power': 19}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '83.128'}],
                                                              'speed': '0'}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 44.627777,
                                'model': 'GigaBeam LR',
                                'sw_version': 'v1.4.0',
                                'system_mac_address': '74:ac:b9:0c:98:e8',
                                'uptime': '7666607'},
                'peers': [       {       'cpu': 0.4975,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '46413560842',
                                                                       'in_ucast_pkts': '114609621',
                                                                       'links': [       {       'in_octets': '46413560842',
                                                                                                'in_ucast_pkts': '114609621',
                                                                                                'mac_address': '74:ac:b9:0c:98:e8',
                                                                                                'out_octets': '7266772376',
                                                                                                'out_ucast_pkts': '29439064'}],
                                                                       'mac_address': '74:ac:b9:0c:99:b8',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7266772376',
                                                                       'out_ucast_pkts': '29439064',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '704567',
                                                                                                                                                     'distance': 563,
                                                                                                                                                     'mac_address': '74:ac:b9:0c:98:e8',
                                                                                                                                                     'noise_floor': -72.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'snr': 19.0}],
                                                                                                                            'noise_floor': -72.0}],
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '83.128'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '7266772376',
                                                                       'in_ucast_pkts': '29439064',
                                                                       'mac_address': '74:ac:b9:0d:99:b8',
                                                                       'name': 'eth0',
                                                                       'out_octets': '46413560842',
                                                                       'out_ucast_pkts': '114609621'}],
                                         'management_ip': '10.0.82.27',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 34.03966,
                                         'model': 'GigaBeam LR',
                                         'name': 'Lorenz-Bolivar STA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.4.0',
                                         'system_mac_address': '74:ac:b9:0c:99:b8',
                                         'uptime': '704598'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_GigaBeam_LR_v1_4_0_02(self):
        obj = self.run_data("ubnt.airmax-ac.GigaBeam LR.v1.4.0.02")
        exp_info = {
                'gps_sync': None,
                'model': 'GigaBeam LR',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'rf_tx_power': 25,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.4.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 1.246883,
                'dl_en_bytes': 859610345,
                'dl_en_packets': 10561835,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1385164005,
                'dl_rf_packets': 17982433,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'temperature': None,
                'ul_en_bytes': 799402764,
                'ul_en_packets': 1108306,
                'ul_noise_floor': -92,
                'ul_rf_bytes': 261251891,
                'ul_rf_packets': 724484
        }
        exp_sta_stats = {
                'f4:92:bf:de:95:94': {       'alt_macs': ['f4:92:bf:df:95:94'],
                                             'dev_macs': {       'c4:ad:34:35:5e:17',
                                                                 'c4:ad:34:35:5e:1b',
                                                                 'e8:da:00:0b:de:6d'},
                                             'dl_link_rate': 323000,
                                             'dl_noise_floor': -72.0,
                                             'dl_rf_bytes': 1324302199,
                                             'dl_rf_packets': 17919575,
                                             'dl_rssi': -53.0,
                                             'dl_snr': 19.0,
                                             'ip_address': '10.0.2.127',
                                             'mac_address': 'f4:92:bf:de:95:94',
                                             'name': '614 N. National BH STA',
                                             'temperature': None,
                                             'ul_link_rate': 352000,
                                             'ul_noise_floor': -92,
                                             'ul_rf_bytes': 203140793,
                                             'ul_rf_packets': 665549,
                                             'ul_rssi': -42,
                                             'ul_snr': 54}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.246883,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '859610345',
                                                              'in_ucast_pkts': '10561835',
                                                              'mac_address': 'f4:92:bf:df:96:00',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '799402764',
                                                              'out_ucast_pkts': '1108306',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '203140793',
                                                              'in_ucast_pkts': '665549',
                                                              'links': [       {       'in_octets': '203140793',
                                                                                       'in_ucast_pkts': '665549',
                                                                                       'mac_address': 'f4:92:bf:de:95:94',
                                                                                       'out_octets': '1324302199',
                                                                                       'out_ucast_pkts': '17919575'}],
                                                              'mac_address': 'f4:92:bf:de:96:00',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '1324302199',
                                                              'out_ucast_pkts': '17919575',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '352000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '153095',
                                                                                                                                            'distance': 119,
                                                                                                                                            'mac_address': 'f4:92:bf:de:95:94',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -42.0,
                                                                                                                                            'rx_link_rate': '352000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 54.0,
                                                                                                                                            'tx_link_rate': '323000',
                                                                                                                                            'tx_mcs': 8}],
                                                                                                                   'noise_floor': -92.0}],
                                                                                        'tx_link_rate': '323000',
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '2.79'}],
                                                              'speed': '0'}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 35.460247,
                                'model': 'GigaBeam LR',
                                'sw_version': 'v1.4.0',
                                'system_mac_address': 'f4:92:bf:de:96:00',
                                'uptime': '153128'},
                'peers': [       {       'cpu': 0.7481,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '1324302199',
                                                                       'in_ucast_pkts': '17919575',
                                                                       'links': [       {       'in_octets': '1324302199',
                                                                                                'in_ucast_pkts': '17919575',
                                                                                                'mac_address': 'f4:92:bf:de:96:00',
                                                                                                'out_octets': '203140793',
                                                                                                'out_ucast_pkts': '665549'}],
                                                                       'mac_address': 'f4:92:bf:de:95:94',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '203140793',
                                                                       'out_ucast_pkts': '665549',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '323000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '153095',
                                                                                                                                                     'distance': 119,
                                                                                                                                                     'mac_address': 'f4:92:bf:de:96:00',
                                                                                                                                                     'noise_floor': -72.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '323000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '352000'}],
                                                                                                                            'noise_floor': -72.0}],
                                                                                                 'tx_link_rate': '352000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '2.79'}]},
                                                               {       'bridged_mac_addresses': [       'c4:ad:34:35:5e:17',
                                                                                                        'c4:ad:34:35:5e:1b',
                                                                                                        'e8:da:00:0b:de:6d'],
                                                                       'id': 'eth0',
                                                                       'in_octets': '203140793',
                                                                       'in_ucast_pkts': '665549',
                                                                       'mac_address': 'f4:92:bf:df:95:94',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1324302199',
                                                                       'out_ucast_pkts': '17919575'}],
                                         'management_ip': '10.0.2.127',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 43.85121,
                                         'model': 'GigaBeam LR',
                                         'name': '614 N. National BH STA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.4.0',
                                         'system_mac_address': 'f4:92:bf:de:95:94',
                                         'uptime': '1444988'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_GigaBeam_LR_v1_4_1_devel_01(self):
        obj = self.run_data("ubnt.airmax-ac.GigaBeam LR.v1.4.1-devel.01")
        exp_info = {
                'gps_sync': False,
                'model': 'GigaBeam LR',
                'rf_chan_width': 0,
                'rf_freq': 0,
                'rf_tx_power': 0,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': 'v1.4.1-devel',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 2.99,
                'dl_en_bytes': 2628258177,
                'dl_en_packets': 2557261770,
                'dl_noise_floor': None,
                'dl_rf_bytes': 4041695376,
                'dl_rf_packets': 52835261,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 3418490622,
                'ul_en_packets': 3160736959,
                'ul_noise_floor': 0,
                'ul_rf_bytes': 1720116864,
                'ul_rf_packets': 32262794
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 2.99,
                                'errors': [{'http_auth': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '95',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2628258177',
                                                              'in_ucast_pkts': '2557261770',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:ac:b9:fd:f9:c8',
                                                              'mtu': 1600,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3418490622',
                                                              'out_ucast_pkts': '3160736959',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1720116864',
                                                              'in_ucast_pkts': '32262794',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:ac:b9:fc:f9:c8',
                                                              'mtu': 1600,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4041695376',
                                                              'out_ucast_pkts': '52835261',
                                                              'radios': [       {       'framing': 'FLEXIBLE',
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'GW-PUB-BILL-60'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'latitude': -38.18296,
                                'longitude': 145.952624,
                                'manufacturer': 'Ubiquiti',
                                'model': 'GigaBeam LR',
                                'sw_version': 'v1.4.1-devel',
                                'system_mac_address': '74:ac:b9:fc:f9:c8',
                                'temperature': 0.0,
                                'uptime': '5230585'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_GigaBeam_Plus_v1_3_0_01(self):
        obj = self.run_data("ubnt.airmax-ac.GigaBeam Plus.v1.3.0.01")
        exp_info = {
                'gps_sync': None,
                'model': 'GigaBeam Plus',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'rf_tx_power': None,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': 'v1.3.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 0.497512,
                'dl_en_bytes': 8640132707,
                'dl_en_packets': 32745699,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'temperature': None,
                'ul_en_bytes': 278780682,
                'ul_en_packets': 793016,
                'ul_noise_floor': None,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.497512,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '8640132707',
                                                              'in_ucast_pkts': '32745699',
                                                              'mac_address': 'f4:92:bf:d9:6d:93',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '278780682',
                                                              'out_ucast_pkts': '793016',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': 'f4:92:bf:d8:6d:93',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MonicaMendolla_PTP'}],
                                                              'speed': '0'}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 29.42106,
                                'model': 'GigaBeam Plus',
                                'sw_version': 'v1.3.0',
                                'system_mac_address': 'f4:92:bf:d8:6d:93',
                                'uptime': '826892'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_GigaBeam_Plus_v1_4_0_01(self):
        obj = self.run_data("ubnt.airmax-ac.GigaBeam Plus.v1.4.0.01")
        exp_info = {
                'gps_sync': None,
                'model': 'GigaBeam Plus',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'rf_tx_power': None,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.4.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 0.249377,
                'dl_en_bytes': 209319447055,
                'dl_en_packets': 188941200,
                'dl_noise_floor': None,
                'dl_rf_bytes': 213163840437,
                'dl_rf_packets': 232705717,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'temperature': None,
                'ul_en_bytes': 8141655803,
                'ul_en_packets': 46806942,
                'ul_noise_floor': None,
                'ul_rf_bytes': 8285362540,
                'ul_rf_packets': 46040405
        }
        exp_sta_stats = {
                '24:5a:4c:da:81:00': {       'alt_macs': ['24:5a:4c:db:81:00'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': -72.0,
                                             'dl_rf_bytes': 213163840486,
                                             'dl_rf_packets': 232705717,
                                             'dl_rssi': -61.0,
                                             'dl_snr': 11.0,
                                             'ip_address': '10.0.13.81',
                                             'mac_address': '24:5a:4c:da:81:00',
                                             'name': 'RobertAyres_PTP',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -72.0,
                                             'ul_rf_bytes': 8285362541,
                                             'ul_rf_packets': 46040405,
                                             'ul_rssi': -64,
                                             'ul_snr': 8}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.249377,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_octets': '209319447055',
                                                              'in_ucast_pkts': '188941200',
                                                              'mac_address': 'f4:92:bf:d9:6b:43',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '8141655803',
                                                              'out_ucast_pkts': '46806942',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '8285362540',
                                                              'in_ucast_pkts': '46040405',
                                                              'links': [       {       'in_octets': '8285362541',
                                                                                       'in_ucast_pkts': '46040405',
                                                                                       'mac_address': '24:5a:4c:da:81:00',
                                                                                       'out_octets': '213163840486',
                                                                                       'out_ucast_pkts': '232705717'}],
                                                              'mac_address': 'f4:92:bf:d8:6b:43',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '213163840437',
                                                              'out_ucast_pkts': '232705717',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1174081',
                                                                                                                                            'distance': 116,
                                                                                                                                            'mac_address': '24:5a:4c:da:81:00',
                                                                                                                                            'noise_floor': -72.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 8.0,
                                                                                                                                            'tx_mcs': 7}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RobertAyres_STA'}],
                                                              'speed': '0'}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 29.735424,
                                'model': 'GigaBeam Plus',
                                'sw_version': 'v1.4.0',
                                'system_mac_address': 'f4:92:bf:d8:6b:43',
                                'uptime': '1174134'},
                'peers': [       {       'cpu': 0.4962,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '213163840486',
                                                                       'in_ucast_pkts': '232705717',
                                                                       'links': [       {       'in_octets': '213163840486',
                                                                                                'in_ucast_pkts': '232705717',
                                                                                                'mac_address': 'f4:92:bf:d8:6b:43',
                                                                                                'out_octets': '8285362541',
                                                                                                'out_ucast_pkts': '46040405'}],
                                                                       'mac_address': '24:5a:4c:da:81:00',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8285362541',
                                                                       'out_ucast_pkts': '46040405',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1174081',
                                                                                                                                                     'distance': 116,
                                                                                                                                                     'mac_address': 'f4:92:bf:d8:6b:43',
                                                                                                                                                     'noise_floor': -72.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'snr': 11.0}],
                                                                                                                            'noise_floor': -72.0}],
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RobertAyres_STA'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '8285362541',
                                                                       'in_ucast_pkts': '46040405',
                                                                       'mac_address': '24:5a:4c:db:81:00',
                                                                       'name': 'eth0',
                                                                       'out_octets': '213163840486',
                                                                       'out_ucast_pkts': '232705717'}],
                                         'latitude': 33.686482,
                                         'longitude': -101.380414,
                                         'management_ip': '10.0.13.81',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 28.447382,
                                         'model': 'GigaBeam Plus',
                                         'name': 'RobertAyres_PTP',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.4.0',
                                         'system_mac_address': '24:5a:4c:da:81:00',
                                         'uptime': '1174108'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_GigaBeam_v1_2_0_01(self):
        obj = self.run_data("ubnt.airmax-ac.GigaBeam.v1.2.0.01")
        exp_info = {
                'gps_sync': False,
                'model': 'GigaBeam',
                'rf_chan_width': 20,
                'rf_freq': 5160,
                'rf_tx_power': 1,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.2.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 2.73,
                'dl_en_bytes': 4265494629,
                'dl_en_packets': 840293773,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3164840664,
                'dl_rf_packets': 883930652,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 3780311189,
                'ul_en_packets': 340347118,
                'ul_noise_floor': -90,
                'ul_rf_bytes': 3717623986,
                'ul_rf_packets': 338088843
        }
        exp_sta_stats = {
                '74:ac:b9:82:ef:ae': {       'alt_macs': ['74:ac:b9:83:ef:ae'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 682935248,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.100.25',
                                             'mac_address': '74:ac:b9:82:ef:ae',
                                             'name': 'GigaBeam Slave',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 655473070,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 29.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 2.73,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '4265494629',
                                                              'in_ucast_pkts': '840293773',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '74:ac:b9:83:f0:99',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3780311189',
                                                              'out_ucast_pkts': '340347118',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3717623986',
                                                              'in_ucast_pkts': '338088843',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '655473070',
                                                                                       'mac_address': '74:ac:b9:82:ef:ae',
                                                                                       'out_octets': '682935248'}],
                                                              'mac_address': '74:ac:b9:82:f0:99',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '135',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3164840664',
                                                              'out_ucast_pkts': '883930652',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5160,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1880727',
                                                                                                                                            'distance': 7941,
                                                                                                                                            'mac_address': '74:ac:b9:82:ef:ae',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_airtime': 0.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_airtime': 0.0}],
                                                                                                                   'noise_floor': -90.0}],
                                                                                        'tx_power': 1}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Kuhl '
                                                                                                 'gigabeam'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'GigaBeam',
                                'sw_version': 'v1.2.0',
                                'system_mac_address': '74:ac:b9:82:f0:99',
                                'temperature': 0.0,
                                'uptime': '1880793'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '682935248',
                                                                       'links': [       {       'in_octets': '682935248',
                                                                                                'mac_address': '74:ac:b9:82:f0:99',
                                                                                                'out_octets': '655473070'}],
                                                                       'mac_address': '74:ac:b9:82:ef:ae',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '655473070',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5160,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1880727',
                                                                                                                                                     'distance': 7941,
                                                                                                                                                     'mac_address': '74:ac:b9:82:f0:99'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Kuhl '
                                                                                                          'gigabeam'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '655473070',
                                                                       'mac_address': '74:ac:b9:83:ef:ae',
                                                                       'name': 'eth0',
                                                                       'out_octets': '682935248'}],
                                         'management_ip': '10.10.100.25',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'GigaBeam Slave',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '74:ac:b9:82:ef:ae'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_GigaBeam_v1_4_0_01(self):
        obj = self.run_data("ubnt.airmax-ac.GigaBeam.v1.4.0.01")
        exp_info = {
                'gps_sync': None,
                'model': 'GigaBeam',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'rf_tx_power': 1,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v1.4.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 1.985112,
                'dl_en_bytes': 76569524153,
                'dl_en_packets': 156875459,
                'dl_noise_floor': None,
                'dl_rf_bytes': 97203537478,
                'dl_rf_packets': 333597433,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'temperature': None,
                'ul_en_bytes': 9903992136,
                'ul_en_packets': 37068580,
                'ul_noise_floor': -91,
                'ul_rf_bytes': 27013528162,
                'ul_rf_packets': 33423774
        }
        exp_sta_stats = {
                '24:5a:4c:44:cd:4f': {       'alt_macs': ['24:5a:4c:45:cd:4f'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 172000000,
                                             'dl_noise_floor': -72.0,
                                             'dl_rf_bytes': 82959620375,
                                             'dl_rf_packets': 332185376,
                                             'dl_rssi': -52.0,
                                             'dl_snr': 20.0,
                                             'ip_address': '10.0.11.167',
                                             'mac_address': '24:5a:4c:44:cd:4f',
                                             'name': 'PatDonathan_60G_STA',
                                             'temperature': None,
                                             'ul_link_rate': 172000000,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 8479734235,
                                             'ul_rf_packets': 32093818,
                                             'ul_rssi': -55,
                                             'ul_snr': 41}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.985112,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '76569524153',
                                                              'in_ucast_pkts': '156875459',
                                                              'mac_address': '24:5a:4c:45:ca:47',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '9903992136',
                                                              'out_ucast_pkts': '37068580',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '25659600500',
                                                              'in_ucast_pkts': '32093818',
                                                              'links': [       {       'in_octets': '8479734235',
                                                                                       'in_ucast_pkts': '32093818',
                                                                                       'mac_address': '24:5a:4c:44:cd:4f',
                                                                                       'out_octets': '82959620375',
                                                                                       'out_ucast_pkts': '332185376'}],
                                                              'mac_address': '24:5a:4c:44:ca:47',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '755',
                                                              'out_octets': '95844507228',
                                                              'out_ucast_pkts': '332185376',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '172000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2871475',
                                                                                                                                            'distance': 40,
                                                                                                                                            'mac_address': '24:5a:4c:44:cd:4f',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '172000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_link_rate': '172000000',
                                                                                                                                            'tx_mcs': 8}],
                                                                                                                   'noise_floor': -91.0}],
                                                                                        'tx_link_rate': '172000',
                                                                                        'tx_power': 1}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'PatDonathan_60G'}],
                                                              'speed': '0'}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 35.348095,
                                'model': 'GigaBeam',
                                'sw_version': 'v1.4.0',
                                'system_mac_address': '24:5a:4c:44:ca:47',
                                'uptime': '3456015'},
                'peers': [       {       'cpu': 0.5,
                                         'elevation': 0.0,
                                         'gps_sats_tracked': 0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '82959620375',
                                                                       'in_ucast_pkts': '332185376',
                                                                       'links': [       {       'in_octets': '82959620375',
                                                                                                'in_ucast_pkts': '332185376',
                                                                                                'mac_address': '24:5a:4c:44:ca:47',
                                                                                                'out_octets': '8479734235',
                                                                                                'out_ucast_pkts': '32093818'}],
                                                                       'mac_address': '24:5a:4c:44:cd:4f',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8479734235',
                                                                       'out_ucast_pkts': '32093818',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '172000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2871475',
                                                                                                                                                     'distance': 40,
                                                                                                                                                     'mac_address': '24:5a:4c:44:ca:47',
                                                                                                                                                     'noise_floor': -72.0,
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '172000000',
                                                                                                                                                     'snr': 20.0,
                                                                                                                                                     'tx_link_rate': '172000000'}],
                                                                                                                            'noise_floor': -72.0}],
                                                                                                 'tx_link_rate': '172000000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PatDonathan_60G'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '8479734235',
                                                                       'in_ucast_pkts': '32093818',
                                                                       'mac_address': '24:5a:4c:45:cd:4f',
                                                                       'name': 'eth0',
                                                                       'out_octets': '82959620375',
                                                                       'out_ucast_pkts': '332185376'}],
                                         'latitude': 33.68363,
                                         'longitude': -101.378531,
                                         'management_ip': '10.0.11.167',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 40.67019,
                                         'model': 'GigaBeam',
                                         'name': 'PatDonathan_60G_STA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v1.4.0',
                                         'system_mac_address': '24:5a:4c:44:cd:4f',
                                         'uptime': '2871692'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_5_0_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.5.0.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 20,
                'rf_freq': 5170,
                'rf_tx_power': 25,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 7.6,
                'cpu': 14.0,
                'dl_en_bytes': 2459149090,
                'dl_en_packets': 482614944,
                'dl_noise_floor': None,
                'dl_rf_bytes': 545059931,
                'dl_rf_packets': 480389847,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 3192314627,
                'ul_en_packets': 242043316,
                'ul_noise_floor': -89,
                'ul_rf_bytes': 1661943756,
                'ul_rf_packets': 239864357
        }
        exp_sta_stats = {
                'f0:9f:c2:88:0f:77': {       'alt_macs': ['f0:9f:c2:89:0f:77'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 434194953675,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.27.3',
                                             'mac_address': 'f0:9f:c2:88:0f:77',
                                             'name': 'Griggs Tower BH',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 24229726418,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -71.0,
                                             'ul_snr': 18.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 14.0,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '343',
                                                              'in_nucast_pkts': '6857342',
                                                              'in_octets': '2459149090',
                                                              'in_ucast_pkts': '475757602',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'f0:9f:c2:89:0f:8f',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3192314627',
                                                              'out_ucast_pkts': '242043316',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1661943756',
                                                              'in_ucast_pkts': '239864357',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '24229726418',
                                                                                       'mac_address': 'f0:9f:c2:88:0f:77',
                                                                                       'out_octets': '434194953675'}],
                                                              'mac_address': 'f0:9f:c2:88:0f:8f',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '9',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '545059931',
                                                              'out_ucast_pkts': '480389847',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5170,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 0.5,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1057180',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': 'f0:9f:c2:88:0f:77',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_airtime': 0.5,
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_airtime': 7.1}],
                                                                                                                   'noise_floor': -89.0}],
                                                                                        'tx_airtime': 7.1,
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TekWav-ST-GT'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.5.0',
                                'system_mac_address': 'f0:9f:c2:88:0f:8f',
                                'temperature': 0.0,
                                'uptime': '1663863'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '434194953675',
                                                                       'links': [       {       'in_octets': '434194953675',
                                                                                                'mac_address': 'f0:9f:c2:88:0f:8f',
                                                                                                'out_octets': '24229726418'}],
                                                                       'mac_address': 'f0:9f:c2:88:0f:77',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '24229726418',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1057180',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:88:0f:8f'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-ST-GT'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '24229726418',
                                                                       'mac_address': 'f0:9f:c2:89:0f:77',
                                                                       'name': 'eth0',
                                                                       'out_octets': '434194953675'}],
                                         'management_ip': '10.150.27.3',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Griggs Tower BH',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:88:0f:77'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_5_11_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.5.11.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5750,
                'rf_tx_power': 13,
                'sta_count': 3,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.11',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 15.2,
                'cpu': 39.39,
                'dl_en_bytes': 942724729,
                'dl_en_packets': 2166181690,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1676886937,
                'dl_rf_packets': 41821712,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 969102016,
                'ul_en_packets': 2901724833,
                'ul_noise_floor': -90,
                'ul_rf_bytes': 495056359,
                'ul_rf_packets': 19133456
        }
        exp_sta_stats = {
                '78:8a:20:62:16:de': {       'alt_macs': ['78:8a:20:63:16:de'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 13034199197,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.90.80',
                                             'mac_address': '78:8a:20:62:16:de',
                                             'name': 'NanoBeam 5AC Gen2',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 894530249,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 23.0},
                '78:8a:20:62:31:f9': {       'alt_macs': ['78:8a:20:63:31:f9'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 40670888528,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.90.118',
                                             'mac_address': '78:8a:20:62:31:f9',
                                             'name': 'NanoBeam 5AC Gen2',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 3456320814,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 31.0},
                'f0:9f:c2:5a:c5:a6': {       'alt_macs': ['f0:9f:c2:5b:c5:a6'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1713480838,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.90.91',
                                             'mac_address': 'f0:9f:c2:5a:c5:a6',
                                             'name': 'PowerBeam 5AC 300 ISO',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 439596090,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 31.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 39.39,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '5',
                                                              'in_nucast_pkts': '564351',
                                                              'in_octets': '942724729',
                                                              'in_ucast_pkts': '2165617339',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:15:18:62',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '969102016',
                                                              'out_ucast_pkts': '2901724833',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '495056359',
                                                              'in_ucast_pkts': '19133456',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '894530249',
                                                                                       'mac_address': '78:8a:20:62:16:de',
                                                                                       'out_octets': '13034199197'},
                                                                               {       'in_octets': '3456320814',
                                                                                       'mac_address': '78:8a:20:62:31:f9',
                                                                                       'out_octets': '40670888528'},
                                                                               {       'in_octets': '439596090',
                                                                                       'mac_address': 'f0:9f:c2:5a:c5:a6',
                                                                                       'out_octets': '1713480838'}],
                                                              'mac_address': '78:8a:20:14:18:62',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1676886937',
                                                              'out_ucast_pkts': '41821712',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5750,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 1.8,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '88426',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': '78:8a:20:62:16:de',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_airtime': 0.9,
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_airtime': 2.2},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '88426',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': '78:8a:20:62:31:f9',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_airtime': 0.5,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_airtime': 4.5},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '88426',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': 'f0:9f:c2:5a:c5:a6',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_airtime': 0.4,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_airtime': 0.1}],
                                                                                                                   'noise_floor': -90.0}],
                                                                                        'tx_airtime': 6.8,
                                                                                        'tx_power': 13}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Maycrest1'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.5.11',
                                'system_mac_address': '78:8a:20:14:18:62',
                                'temperature': 0.0,
                                'uptime': '15293543'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '13034199197',
                                                                       'links': [       {       'in_octets': '13034199197',
                                                                                                'mac_address': '78:8a:20:14:18:62',
                                                                                                'out_octets': '894530249'}],
                                                                       'mac_address': '78:8a:20:62:16:de',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '894530249',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '88426',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': '78:8a:20:14:18:62'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Maycrest1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '894530249',
                                                                       'mac_address': '78:8a:20:63:16:de',
                                                                       'name': 'eth0',
                                                                       'out_octets': '13034199197'}],
                                         'management_ip': '192.168.90.80',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'NanoBeam 5AC Gen2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:62:16:de'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '40670888528',
                                                                       'links': [       {       'in_octets': '40670888528',
                                                                                                'mac_address': '78:8a:20:14:18:62',
                                                                                                'out_octets': '3456320814'}],
                                                                       'mac_address': '78:8a:20:62:31:f9',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3456320814',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '88426',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': '78:8a:20:14:18:62'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Maycrest1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3456320814',
                                                                       'mac_address': '78:8a:20:63:31:f9',
                                                                       'name': 'eth0',
                                                                       'out_octets': '40670888528'}],
                                         'management_ip': '192.168.90.118',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'NanoBeam 5AC Gen2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:62:31:f9'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1713480838',
                                                                       'links': [       {       'in_octets': '1713480838',
                                                                                                'mac_address': '78:8a:20:14:18:62',
                                                                                                'out_octets': '439596090'}],
                                                                       'mac_address': 'f0:9f:c2:5a:c5:a6',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '439596090',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5750,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '88426',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': '78:8a:20:14:18:62'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Maycrest1'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '439596090',
                                                                       'mac_address': 'f0:9f:c2:5b:c5:a6',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1713480838'}],
                                         'management_ip': '192.168.90.91',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'PowerBeam 5AC 300 ISO',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:5a:c5:a6'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_5_11_cs_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.5.11-cs.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5180,
                'rf_tx_power': 25,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.11-cs',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 0.5,
                'cpu': 6.86,
                'dl_en_bytes': 1228285377,
                'dl_en_packets': 16667391,
                'dl_noise_floor': None,
                'dl_rf_bytes': 532273839,
                'dl_rf_packets': 4814693,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 1263173680,
                'ul_en_packets': 12278064,
                'ul_noise_floor': 0,
                'ul_rf_bytes': 834561,
                'ul_rf_packets': 3231
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 6.86,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '1',
                                                              'in_nucast_pkts': '4468533',
                                                              'in_octets': '1228285377',
                                                              'in_ucast_pkts': '12198858',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'f0:9f:c2:e7:3a:27',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1263173680',
                                                              'out_ucast_pkts': '12278064',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '834561',
                                                              'in_ucast_pkts': '3231',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'f0:9f:c2:e6:3a:27',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '532273839',
                                                              'out_ucast_pkts': '4814693',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5180,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FR.AlbionFire.North'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'latitude': 39.223529,
                                'longitude': -123.769258,
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.5.11-cs',
                                'system_mac_address': 'f0:9f:c2:e6:3a:27',
                                'temperature': 0.0,
                                'uptime': '19347966'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_5_12_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.5.12.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 20,
                'rf_freq': 5270,
                'rf_tx_power': 25,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.12',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 0.9,
                'cpu': 10.78,
                'dl_en_bytes': 649320277,
                'dl_en_packets': 78182095,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1436031986,
                'dl_rf_packets': 1982593,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 1986684335,
                'ul_en_packets': 46813946,
                'ul_noise_floor': -89,
                'ul_rf_bytes': 214019834,
                'ul_rf_packets': 1263899
        }
        exp_sta_stats = {
                'f0:9f:c2:42:fd:45': {       'alt_macs': ['f0:9f:c2:43:fd:45'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1436033662,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.5.240',
                                             'mac_address': 'f0:9f:c2:42:fd:45',
                                             'name': 'DBM-MPOP-D4NB',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 214137459,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 30.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 10.78,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '100545',
                                                              'in_octets': '649320277',
                                                              'in_ucast_pkts': '78081550',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:15:4e:e7',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1986684335',
                                                              'out_ucast_pkts': '46813946',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '214019834',
                                                              'in_ucast_pkts': '1263899',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '214137459',
                                                                                       'mac_address': 'f0:9f:c2:42:fd:45',
                                                                                       'out_octets': '1436033662'}],
                                                              'mac_address': '78:8a:20:14:4e:e7',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1436031986',
                                                              'out_ucast_pkts': '1982593',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5270,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 0.1,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '45547',
                                                                                                                                            'distance': 6900,
                                                                                                                                            'mac_address': 'f0:9f:c2:42:fd:45',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_airtime': 0.3}],
                                                                                                                   'noise_floor': -89.0}],
                                                                                        'tx_airtime': 0.3,
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'DBM-MPOP-D4N'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.5.12',
                                'system_mac_address': '78:8a:20:14:4e:e7',
                                'temperature': 0.0,
                                'uptime': '1390528'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1436033662',
                                                                       'links': [       {       'in_octets': '1436033662',
                                                                                                'mac_address': '78:8a:20:14:4e:e7',
                                                                                                'out_octets': '214137459'}],
                                                                       'mac_address': 'f0:9f:c2:42:fd:45',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '214137459',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5270,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '45547',
                                                                                                                                                     'distance': 6900,
                                                                                                                                                     'mac_address': '78:8a:20:14:4e:e7'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'DBM-MPOP-D4N'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '214137459',
                                                                       'mac_address': 'f0:9f:c2:43:fd:45',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1436033662'}],
                                         'management_ip': '10.1.5.240',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'DBM-MPOP-D4NB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:42:fd:45'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_5_12_cs_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.5.12-cs.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5170,
                'rf_tx_power': 25,
                'sta_count': 20,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.12-cs',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 2.0,
                'cpu': 10.0,
                'dl_en_bytes': 2445691030,
                'dl_en_packets': 3666117407,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3516276031,
                'dl_rf_packets': 3683916159,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 3088888735,
                'ul_en_packets': 2064410151,
                'ul_noise_floor': -88,
                'ul_rf_bytes': 301147376,
                'ul_rf_packets': 2081288113
        }
        exp_sta_stats = {
                '04:18:d6:32:7a:2e': {       'alt_macs': ['04:18:d6:33:7a:2e'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 95208805844,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.237',
                                             'mac_address': '04:18:d6:32:7a:2e',
                                             'name': 'Diane Albert (Pomo Lake Drive '
                                                     'House) NB-19',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 7938250245,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 26.0},
                '04:18:d6:32:7c:b1': {       'alt_macs': ['04:18:d6:33:7c:b1'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 821013557702,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.21',
                                             'mac_address': '04:18:d6:32:7c:b1',
                                             'name': 'Frame - Uplink NB19',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 52950603408,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 31.0},
                '04:18:d6:48:14:83': {       'alt_macs': ['04:18:d6:49:14:83'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1818213430,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.235',
                                             'mac_address': '04:18:d6:48:14:83',
                                             'name': 'Stephanie Graham Rivas NB-16',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 971529219,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.0,
                                             'ul_snr': 19.0},
                '04:18:d6:48:14:ea': {       'alt_macs': ['04:18:d6:49:14:ea'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 9977336172,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.236',
                                             'mac_address': '04:18:d6:48:14:ea',
                                             'name': 'McCarthy Kevin NB-16 ',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 1228044918,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -70.0,
                                             'ul_snr': 18.0},
                '04:18:d6:52:c2:5f': {       'alt_macs': ['04:18:d6:53:c2:5f'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 26686986373,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.229',
                                             'mac_address': '04:18:d6:52:c2:5f',
                                             'name': 'Dan Moore NB-19',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 2561532666,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68.0,
                                             'ul_snr': 20.0},
                '04:18:d6:5c:74:24': {       'alt_macs': ['04:18:d6:5d:74:24'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 42947907507,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.233',
                                             'mac_address': '04:18:d6:5c:74:24',
                                             'name': 'Patrick Robards NB-19',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 7483896589,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 26.0},
                '04:18:d6:5c:74:5d': {       'alt_macs': ['04:18:d6:5d:74:5d'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 25188405850,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.234',
                                             'mac_address': '04:18:d6:5c:74:5d',
                                             'name': 'Vierra NB-16',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 3364660933,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.0,
                                             'ul_snr': 19.0},
                '04:18:d6:5e:31:73': {       'alt_macs': ['04:18:d6:5f:31:73'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 14334740708,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.239',
                                             'mac_address': '04:18:d6:5e:31:73',
                                             'name': 'Dean & Patty Wolfe NBM5 19',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 10656260035,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 30.0},
                '04:18:d6:5e:32:36': {       'alt_macs': ['04:18:d6:5f:32:36'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 29378259867,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.226',
                                             'mac_address': '04:18:d6:5e:32:36',
                                             'name': 'Julie Trout NB-16 ',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 2529409979,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 24.0},
                '04:18:d6:a6:a5:cd': {       'alt_macs': ['04:18:d6:a7:a5:cd'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 5351671991,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.231',
                                             'mac_address': '04:18:d6:a6:a5:cd',
                                             'name': 'IB Water&Fire NB-400',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 1059849069,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -73.0,
                                             'ul_snr': 15.0},
                '24:a4:3c:d6:17:df': {       'alt_macs': ['24:a4:3c:d7:17:df'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 13259443362,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.240',
                                             'mac_address': '24:a4:3c:d6:17:df',
                                             'name': 'NIk Epanchin NB-400 ',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 2239963200,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -75.0,
                                             'ul_snr': 13.0},
                '44:d9:e7:b4:9f:67': {       'alt_macs': ['44:d9:e7:b5:9f:67'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 277084795950,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.166',
                                             'mac_address': '44:d9:e7:b4:9f:67',
                                             'name': 'Marian Hemmingway -LB23',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 15656527115,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 24.0},
                '44:d9:e7:b6:d6:98': {       'alt_macs': ['44:d9:e7:b7:d6:98'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 771714849,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.177',
                                             'mac_address': '44:d9:e7:b6:d6:98',
                                             'name': 'Beth-GurneyLBM5',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 14476545,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -70.0,
                                             'ul_snr': 18.0},
                '44:d9:e7:b6:da:82': {       'alt_macs': ['44:d9:e7:b7:da:82'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 38900887645,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.171',
                                             'mac_address': '44:d9:e7:b6:da:82',
                                             'name': 'Dean Freedlun LB5',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 3832441206,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 28.0},
                '78:8a:20:32:2a:09': {       'alt_macs': ['78:8a:20:33:2a:09'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 49139770229,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.136',
                                             'mac_address': '78:8a:20:32:2a:09',
                                             'name': 'Debi Walker L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 4814795288,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 30.0},
                '80:2a:a8:74:a1:02': {       'alt_macs': ['80:2a:a8:75:a1:02'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 103327025277,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.165',
                                             'mac_address': '80:2a:a8:74:a1:02',
                                             'name': 'WaveLength Farm (Patrick '
                                                     'Cordrey) P5B',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 14444579873,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.0,
                                             'ul_snr': 19.0},
                'b4:fb:e4:a4:89:bb': {       'alt_macs': ['b4:fb:e4:a5:89:bb'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 6698195656,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.115',
                                             'mac_address': 'b4:fb:e4:a4:89:bb',
                                             'name': 'Melissa Scheaffer L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 1058366984,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 27.0},
                'f0:9f:c2:b8:61:b2': {       'alt_macs': ['f0:9f:c2:b9:61:b2'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 140368589823,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.164',
                                             'mac_address': 'f0:9f:c2:b8:61:b2',
                                             'name': 'Travis Haury L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 10447683365,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.0,
                                             'ul_snr': 19.0},
                'f0:9f:c2:ec:25:bc': {       'alt_macs': ['f0:9f:c2:ed:25:bc'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2299605900225,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.11',
                                             'mac_address': 'f0:9f:c2:ec:25:bc',
                                             'name': 'Pacific View PBAC-400',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 134766623870,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -66.0,
                                             'ul_snr': 22.0},
                'fc:ec:da:5c:27:92': {       'alt_macs': ['fc:ec:da:5d:27:92'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 360983650622,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.143',
                                             'mac_address': 'fc:ec:da:5c:27:92',
                                             'name': 'Law Office of Susan Israel '
                                                     '(Susan Israel) L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -88,
                                             'ul_rf_bytes': 61865365062,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -53.0,
                                             'ul_snr': 35.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 10.0,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '1',
                                                              'in_nucast_pkts': '8782560',
                                                              'in_octets': '2445691030',
                                                              'in_ucast_pkts': '3657334847',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'f0:9f:c2:e3:d9:32',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '2',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3088888735',
                                                              'out_ucast_pkts': '2064410151',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '301147376',
                                                              'in_ucast_pkts': '2081288113',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '4814795288',
                                                                                       'mac_address': '78:8a:20:32:2a:09',
                                                                                       'out_octets': '49139770229'},
                                                                               {       'in_octets': '14444579873',
                                                                                       'mac_address': '80:2a:a8:74:a1:02',
                                                                                       'out_octets': '103327025277'},
                                                                               {       'in_octets': '1058366984',
                                                                                       'mac_address': 'b4:fb:e4:a4:89:bb',
                                                                                       'out_octets': '6698195656'},
                                                                               {       'in_octets': '10447683365',
                                                                                       'mac_address': 'f0:9f:c2:b8:61:b2',
                                                                                       'out_octets': '140368589823'},
                                                                               {       'in_octets': '134766623870',
                                                                                       'mac_address': 'f0:9f:c2:ec:25:bc',
                                                                                       'out_octets': '2299605900225'},
                                                                               {       'in_octets': '61865365062',
                                                                                       'mac_address': 'fc:ec:da:5c:27:92',
                                                                                       'out_octets': '360983650622'},
                                                                               {       'in_octets': '2239963200',
                                                                                       'mac_address': '24:a4:3c:d6:17:df',
                                                                                       'out_octets': '13259443362'},
                                                                               {       'in_octets': '1059849069',
                                                                                       'mac_address': '04:18:d6:a6:a5:cd',
                                                                                       'out_octets': '5351671991'},
                                                                               {       'in_octets': '7938250245',
                                                                                       'mac_address': '04:18:d6:32:7a:2e',
                                                                                       'out_octets': '95208805844'},
                                                                               {       'in_octets': '52950603408',
                                                                                       'mac_address': '04:18:d6:32:7c:b1',
                                                                                       'out_octets': '821013557702'},
                                                                               {       'in_octets': '971529219',
                                                                                       'mac_address': '04:18:d6:48:14:83',
                                                                                       'out_octets': '1818213430'},
                                                                               {       'in_octets': '1228044918',
                                                                                       'mac_address': '04:18:d6:48:14:ea',
                                                                                       'out_octets': '9977336172'},
                                                                               {       'in_octets': '2561532666',
                                                                                       'mac_address': '04:18:d6:52:c2:5f',
                                                                                       'out_octets': '26686986373'},
                                                                               {       'in_octets': '7483896589',
                                                                                       'mac_address': '04:18:d6:5c:74:24',
                                                                                       'out_octets': '42947907507'},
                                                                               {       'in_octets': '3364660933',
                                                                                       'mac_address': '04:18:d6:5c:74:5d',
                                                                                       'out_octets': '25188405850'},
                                                                               {       'in_octets': '10656260035',
                                                                                       'mac_address': '04:18:d6:5e:31:73',
                                                                                       'out_octets': '14334740708'},
                                                                               {       'in_octets': '2529409979',
                                                                                       'mac_address': '04:18:d6:5e:32:36',
                                                                                       'out_octets': '29378259867'},
                                                                               {       'in_octets': '15656527115',
                                                                                       'mac_address': '44:d9:e7:b4:9f:67',
                                                                                       'out_octets': '277084795950'},
                                                                               {       'in_octets': '14476545',
                                                                                       'mac_address': '44:d9:e7:b6:d6:98',
                                                                                       'out_octets': '771714849'},
                                                                               {       'in_octets': '3832441206',
                                                                                       'mac_address': '44:d9:e7:b6:da:82',
                                                                                       'out_octets': '38900887645'}],
                                                              'mac_address': 'f0:9f:c2:e2:d9:32',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '1',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3516276031',
                                                              'out_ucast_pkts': '3683916159',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5170,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 2.4,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210936',
                                                                                                                                            'distance': 1050,
                                                                                                                                            'mac_address': '78:8a:20:32:2a:09',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210943',
                                                                                                                                            'distance': 3900,
                                                                                                                                            'mac_address': '80:2a:a8:74:a1:02',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_airtime': 0.3,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_airtime': 0.3},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '373617',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': 'b4:fb:e4:a4:89:bb',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210939',
                                                                                                                                            'distance': 1050,
                                                                                                                                            'mac_address': 'f0:9f:c2:b8:61:b2',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2674404',
                                                                                                                                            'distance': 4200,
                                                                                                                                            'mac_address': 'f0:9f:c2:ec:25:bc',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 22.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210944',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': 'fc:ec:da:5c:27:92',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210876',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': '24:a4:3c:d6:17:df',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 13.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2131711',
                                                                                                                                            'distance': 1350,
                                                                                                                                            'mac_address': '04:18:d6:a6:a5:cd',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -73.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 15.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210954',
                                                                                                                                            'distance': 900,
                                                                                                                                            'mac_address': '04:18:d6:32:7a:2e',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_airtime': 0.3,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210938',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': '04:18:d6:32:7c:b1',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210954',
                                                                                                                                            'distance': 1200,
                                                                                                                                            'mac_address': '04:18:d6:48:14:83',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210954',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': '04:18:d6:48:14:ea',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210954',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': '04:18:d6:52:c2:5f',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210954',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': '04:18:d6:5c:74:24',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210954',
                                                                                                                                            'distance': 150,
                                                                                                                                            'mac_address': '04:18:d6:5c:74:5d',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '547227',
                                                                                                                                            'distance': 0,
                                                                                                                                            'mac_address': '04:18:d6:5e:31:73',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210955',
                                                                                                                                            'distance': 1050,
                                                                                                                                            'mac_address': '04:18:d6:5e:32:36',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210890',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': '44:d9:e7:b4:9f:67',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '63453',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': '44:d9:e7:b6:d6:98',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2210941',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': '44:d9:e7:b6:da:82',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_airtime': 0.1}],
                                                                                                                   'noise_floor': -88.0}],
                                                                                        'tx_airtime': 2.2,
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FurtherReach-RJ-E'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'latitude': 39.029435,
                                'longitude': -123.682718,
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.5.12-cs',
                                'system_mac_address': 'f0:9f:c2:e2:d9:32',
                                'temperature': 0.0,
                                'uptime': '2674486'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '49139770229',
                                                                       'links': [       {       'in_octets': '49139770229',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '4814795288'}],
                                                                       'mac_address': '78:8a:20:32:2a:09',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4814795288',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210936',
                                                                                                                                                     'distance': 1050,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '4814795288',
                                                                       'mac_address': '78:8a:20:33:2a:09',
                                                                       'name': 'eth0',
                                                                       'out_octets': '49139770229'}],
                                         'management_ip': '10.1.1.136',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Debi Walker L5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:32:2a:09'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '103327025277',
                                                                       'links': [       {       'in_octets': '103327025277',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '14444579873'}],
                                                                       'mac_address': '80:2a:a8:74:a1:02',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '14444579873',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210943',
                                                                                                                                                     'distance': 3900,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '14444579873',
                                                                       'mac_address': '80:2a:a8:75:a1:02',
                                                                       'name': 'eth0',
                                                                       'out_octets': '103327025277'}],
                                         'management_ip': '10.1.1.165',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'WaveLength Farm (Patrick Cordrey) '
                                                 'P5B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '80:2a:a8:74:a1:02'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '6698195656',
                                                                       'links': [       {       'in_octets': '6698195656',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '1058366984'}],
                                                                       'mac_address': 'b4:fb:e4:a4:89:bb',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1058366984',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '373617',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1058366984',
                                                                       'mac_address': 'b4:fb:e4:a5:89:bb',
                                                                       'name': 'eth0',
                                                                       'out_octets': '6698195656'}],
                                         'management_ip': '10.1.1.115',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Melissa Scheaffer L5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:a4:89:bb'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '140368589823',
                                                                       'links': [       {       'in_octets': '140368589823',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '10447683365'}],
                                                                       'mac_address': 'f0:9f:c2:b8:61:b2',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10447683365',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210939',
                                                                                                                                                     'distance': 1050,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10447683365',
                                                                       'mac_address': 'f0:9f:c2:b9:61:b2',
                                                                       'name': 'eth0',
                                                                       'out_octets': '140368589823'}],
                                         'management_ip': '10.1.1.164',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Travis Haury L5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:b8:61:b2'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '2299605900225',
                                                                       'links': [       {       'in_octets': '2299605900225',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '134766623870'}],
                                                                       'mac_address': 'f0:9f:c2:ec:25:bc',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '134766623870',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2674404',
                                                                                                                                                     'distance': 4200,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '134766623870',
                                                                       'mac_address': 'f0:9f:c2:ed:25:bc',
                                                                       'name': 'eth0',
                                                                       'out_octets': '2299605900225'}],
                                         'management_ip': '10.1.1.11',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Pacific View PBAC-400',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:ec:25:bc'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '360983650622',
                                                                       'links': [       {       'in_octets': '360983650622',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '61865365062'}],
                                                                       'mac_address': 'fc:ec:da:5c:27:92',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '61865365062',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210944',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '61865365062',
                                                                       'mac_address': 'fc:ec:da:5d:27:92',
                                                                       'name': 'eth0',
                                                                       'out_octets': '360983650622'}],
                                         'management_ip': '10.1.1.143',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Law Office of Susan Israel (Susan '
                                                 'Israel) L5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:5c:27:92'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '13259443362',
                                                                       'links': [       {       'in_octets': '13259443362',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '2239963200'}],
                                                                       'mac_address': '24:a4:3c:d6:17:df',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2239963200',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210876',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2239963200',
                                                                       'mac_address': '24:a4:3c:d7:17:df',
                                                                       'name': 'eth0',
                                                                       'out_octets': '13259443362'}],
                                         'management_ip': '10.1.1.240',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'NIk Epanchin NB-400 ',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:a4:3c:d6:17:df'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '5351671991',
                                                                       'links': [       {       'in_octets': '5351671991',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '1059849069'}],
                                                                       'mac_address': '04:18:d6:a6:a5:cd',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1059849069',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2131711',
                                                                                                                                                     'distance': 1350,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1059849069',
                                                                       'mac_address': '04:18:d6:a7:a5:cd',
                                                                       'name': 'eth0',
                                                                       'out_octets': '5351671991'}],
                                         'management_ip': '10.1.1.231',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'IB Water&Fire NB-400',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:a6:a5:cd'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '95208805844',
                                                                       'links': [       {       'in_octets': '95208805844',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '7938250245'}],
                                                                       'mac_address': '04:18:d6:32:7a:2e',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7938250245',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210954',
                                                                                                                                                     'distance': 900,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '7938250245',
                                                                       'mac_address': '04:18:d6:33:7a:2e',
                                                                       'name': 'eth0',
                                                                       'out_octets': '95208805844'}],
                                         'management_ip': '10.1.1.237',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Diane Albert (Pomo Lake Drive House) '
                                                 'NB-19',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:32:7a:2e'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '821013557702',
                                                                       'links': [       {       'in_octets': '821013557702',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '52950603408'}],
                                                                       'mac_address': '04:18:d6:32:7c:b1',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '52950603408',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210938',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '52950603408',
                                                                       'mac_address': '04:18:d6:33:7c:b1',
                                                                       'name': 'eth0',
                                                                       'out_octets': '821013557702'}],
                                         'management_ip': '10.1.1.21',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Frame - Uplink NB19',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:32:7c:b1'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1818213430',
                                                                       'links': [       {       'in_octets': '1818213430',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '971529219'}],
                                                                       'mac_address': '04:18:d6:48:14:83',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '971529219',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210954',
                                                                                                                                                     'distance': 1200,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '971529219',
                                                                       'mac_address': '04:18:d6:49:14:83',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1818213430'}],
                                         'management_ip': '10.1.1.235',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Stephanie Graham Rivas NB-16',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:48:14:83'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '9977336172',
                                                                       'links': [       {       'in_octets': '9977336172',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '1228044918'}],
                                                                       'mac_address': '04:18:d6:48:14:ea',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1228044918',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210954',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1228044918',
                                                                       'mac_address': '04:18:d6:49:14:ea',
                                                                       'name': 'eth0',
                                                                       'out_octets': '9977336172'}],
                                         'management_ip': '10.1.1.236',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'McCarthy Kevin NB-16 ',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:48:14:ea'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '26686986373',
                                                                       'links': [       {       'in_octets': '26686986373',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '2561532666'}],
                                                                       'mac_address': '04:18:d6:52:c2:5f',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2561532666',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210954',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2561532666',
                                                                       'mac_address': '04:18:d6:53:c2:5f',
                                                                       'name': 'eth0',
                                                                       'out_octets': '26686986373'}],
                                         'management_ip': '10.1.1.229',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Dan Moore NB-19',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:52:c2:5f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '42947907507',
                                                                       'links': [       {       'in_octets': '42947907507',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '7483896589'}],
                                                                       'mac_address': '04:18:d6:5c:74:24',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7483896589',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210954',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '7483896589',
                                                                       'mac_address': '04:18:d6:5d:74:24',
                                                                       'name': 'eth0',
                                                                       'out_octets': '42947907507'}],
                                         'management_ip': '10.1.1.233',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Patrick Robards NB-19',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:5c:74:24'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '25188405850',
                                                                       'links': [       {       'in_octets': '25188405850',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '3364660933'}],
                                                                       'mac_address': '04:18:d6:5c:74:5d',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3364660933',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210954',
                                                                                                                                                     'distance': 150,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3364660933',
                                                                       'mac_address': '04:18:d6:5d:74:5d',
                                                                       'name': 'eth0',
                                                                       'out_octets': '25188405850'}],
                                         'management_ip': '10.1.1.234',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Vierra NB-16',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:5c:74:5d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '14334740708',
                                                                       'links': [       {       'in_octets': '14334740708',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '10656260035'}],
                                                                       'mac_address': '04:18:d6:5e:31:73',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10656260035',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '547227',
                                                                                                                                                     'distance': 0,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10656260035',
                                                                       'mac_address': '04:18:d6:5f:31:73',
                                                                       'name': 'eth0',
                                                                       'out_octets': '14334740708'}],
                                         'management_ip': '10.1.1.239',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Dean & Patty Wolfe NBM5 19',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:5e:31:73'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '29378259867',
                                                                       'links': [       {       'in_octets': '29378259867',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '2529409979'}],
                                                                       'mac_address': '04:18:d6:5e:32:36',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2529409979',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210955',
                                                                                                                                                     'distance': 1050,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2529409979',
                                                                       'mac_address': '04:18:d6:5f:32:36',
                                                                       'name': 'eth0',
                                                                       'out_octets': '29378259867'}],
                                         'management_ip': '10.1.1.226',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Julie Trout NB-16 ',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '04:18:d6:5e:32:36'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '277084795950',
                                                                       'links': [       {       'in_octets': '277084795950',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '15656527115'}],
                                                                       'mac_address': '44:d9:e7:b4:9f:67',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '15656527115',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210890',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '15656527115',
                                                                       'mac_address': '44:d9:e7:b5:9f:67',
                                                                       'name': 'eth0',
                                                                       'out_octets': '277084795950'}],
                                         'management_ip': '10.1.1.166',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Marian Hemmingway -LB23',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '44:d9:e7:b4:9f:67'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '771714849',
                                                                       'links': [       {       'in_octets': '771714849',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '14476545'}],
                                                                       'mac_address': '44:d9:e7:b6:d6:98',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '14476545',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '63453',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '14476545',
                                                                       'mac_address': '44:d9:e7:b7:d6:98',
                                                                       'name': 'eth0',
                                                                       'out_octets': '771714849'}],
                                         'management_ip': '10.1.1.177',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Beth-GurneyLBM5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '44:d9:e7:b6:d6:98'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '38900887645',
                                                                       'links': [       {       'in_octets': '38900887645',
                                                                                                'mac_address': 'f0:9f:c2:e2:d9:32',
                                                                                                'out_octets': '3832441206'}],
                                                                       'mac_address': '44:d9:e7:b6:da:82',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3832441206',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5170,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2210941',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e2:d9:32'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FurtherReach-RJ-E'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3832441206',
                                                                       'mac_address': '44:d9:e7:b7:da:82',
                                                                       'name': 'eth0',
                                                                       'out_octets': '38900887645'}],
                                         'management_ip': '10.1.1.171',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Dean Freedlun LB5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '44:d9:e7:b6:da:82'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_5_7_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.5.7.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 20,
                'rf_freq': 5800,
                'rf_tx_power': 25,
                'sta_count': 3,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.7',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 1.3,
                'cpu': 20.79,
                'dl_en_bytes': 96826608,
                'dl_en_packets': 172045614,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3687438659,
                'dl_rf_packets': 172823485,
                'en_if_speed': 100000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 1702783523,
                'ul_en_packets': 80147466,
                'ul_noise_floor': -95,
                'ul_rf_bytes': 4094883838,
                'ul_rf_packets': 80857814
        }
        exp_sta_stats = {
                '18:e8:29:34:b5:1b': {       'alt_macs': ['18:e8:29:35:b5:1b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 66831819081,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.3.42',
                                             'mac_address': '18:e8:29:34:b5:1b',
                                             'name': 'Peggy Davis',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 3598907064,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -42.0,
                                             'ul_snr': 53.0},
                'b4:fb:e4:38:0f:d9': {       'alt_macs': ['b4:fb:e4:39:0f:d9'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 87584225417,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.4.209',
                                             'mac_address': 'b4:fb:e4:38:0f:d9',
                                             'name': 'Billy Anderson',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 10413209250,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -80.0,
                                             'ul_snr': 15.0},
                'b4:fb:e4:6a:49:a0': {       'alt_macs': ['b4:fb:e4:6b:49:a0'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 49926473368,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.3.47',
                                             'mac_address': 'b4:fb:e4:6a:49:a0',
                                             'name': 'Rhonda Dockery',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 2967671921,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 46.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 20.79,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '6052523',
                                                              'in_octets': '96826608',
                                                              'in_ucast_pkts': '165993091',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:15:5a:65',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1702783523',
                                                              'out_ucast_pkts': '80147466',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '4094883838',
                                                              'in_ucast_pkts': '80857814',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2967671921',
                                                                                       'mac_address': 'b4:fb:e4:6a:49:a0',
                                                                                       'out_octets': '49926473368'},
                                                                               {       'in_octets': '10413209250',
                                                                                       'mac_address': 'b4:fb:e4:38:0f:d9',
                                                                                       'out_octets': '87584225417'},
                                                                               {       'in_octets': '3598907064',
                                                                                       'mac_address': '18:e8:29:34:b5:1b',
                                                                                       'out_octets': '66831819081'}],
                                                              'mac_address': '78:8a:20:14:5a:65',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3687438659',
                                                              'out_ucast_pkts': '172823485',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5800,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 0.3,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1013337',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': 'b4:fb:e4:6a:49:a0',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 46.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1013278',
                                                                                                                                            'distance': 900,
                                                                                                                                            'mac_address': 'b4:fb:e4:38:0f:d9',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -80.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 15.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1013340',
                                                                                                                                            'distance': 150,
                                                                                                                                            'mac_address': '18:e8:29:34:b5:1b',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -42.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 53.0,
                                                                                                                                            'tx_airtime': 0.1}],
                                                                                                                   'noise_floor': -95.0}],
                                                                                        'tx_airtime': 0.3,
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'www.BreezeAir.net-KT'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.5.7',
                                'system_mac_address': '78:8a:20:14:5a:65',
                                'temperature': 0.0,
                                'uptime': '1013373'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '49926473368',
                                                                       'links': [       {       'in_octets': '49926473368',
                                                                                                'mac_address': '78:8a:20:14:5a:65',
                                                                                                'out_octets': '2967671921'}],
                                                                       'mac_address': 'b4:fb:e4:6a:49:a0',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2967671921',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1013337',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': '78:8a:20:14:5a:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'www.BreezeAir.net-KT'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2967671921',
                                                                       'mac_address': 'b4:fb:e4:6b:49:a0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '49926473368'}],
                                         'management_ip': '192.168.3.47',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Rhonda Dockery',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:6a:49:a0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '87584225417',
                                                                       'links': [       {       'in_octets': '87584225417',
                                                                                                'mac_address': '78:8a:20:14:5a:65',
                                                                                                'out_octets': '10413209250'}],
                                                                       'mac_address': 'b4:fb:e4:38:0f:d9',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10413209250',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1013278',
                                                                                                                                                     'distance': 900,
                                                                                                                                                     'mac_address': '78:8a:20:14:5a:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'www.BreezeAir.net-KT'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10413209250',
                                                                       'mac_address': 'b4:fb:e4:39:0f:d9',
                                                                       'name': 'eth0',
                                                                       'out_octets': '87584225417'}],
                                         'management_ip': '192.168.4.209',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Billy Anderson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:38:0f:d9'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '66831819081',
                                                                       'links': [       {       'in_octets': '66831819081',
                                                                                                'mac_address': '78:8a:20:14:5a:65',
                                                                                                'out_octets': '3598907064'}],
                                                                       'mac_address': '18:e8:29:34:b5:1b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3598907064',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1013340',
                                                                                                                                                     'distance': 150,
                                                                                                                                                     'mac_address': '78:8a:20:14:5a:65'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'www.BreezeAir.net-KT'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3598907064',
                                                                       'mac_address': '18:e8:29:35:b5:1b',
                                                                       'name': 'eth0',
                                                                       'out_octets': '66831819081'}],
                                         'management_ip': '192.168.3.42',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Peggy Davis',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '18:e8:29:34:b5:1b'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_5_7_cs_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.5.7-cs.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 20,
                'rf_freq': 5220,
                'rf_tx_power': 25,
                'sta_count': 10,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.7-cs',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 11.7,
                'cpu': 36.27,
                'dl_en_bytes': 3780490977,
                'dl_en_packets': 989302167,
                'dl_noise_floor': None,
                'dl_rf_bytes': 573535434,
                'dl_rf_packets': 991563644,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 1459508312,
                'ul_en_packets': 531233092,
                'ul_noise_floor': -89,
                'ul_rf_bytes': 2762423158,
                'ul_rf_packets': 532889350
        }
        exp_sta_stats = {
                '00:27:22:74:6c:41': {       'alt_macs': ['00:27:22:75:6c:41'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 66350714163,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.35',
                                             'mac_address': '00:27:22:74:6c:41',
                                             'name': 'Jeff Wideman CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 10561724649,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -52.0,
                                             'ul_snr': 37.0},
                '78:8a:20:62:ee:47': {       'alt_macs': ['78:8a:20:63:ee:47'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 72521166358,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.43',
                                             'mac_address': '78:8a:20:62:ee:47',
                                             'name': 'Connie Legg CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 5101064501,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -71.0,
                                             'ul_snr': 18.0},
                '78:8a:20:9e:8f:96': {       'alt_macs': ['78:8a:20:9f:8f:96'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 24709541766,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.39',
                                             'mac_address': '78:8a:20:9e:8f:96',
                                             'name': 'Roger Watkins CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 2007983411,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -52.0,
                                             'ul_snr': 37.0},
                'b4:fb:e4:30:46:7f': {       'alt_macs': ['b4:fb:e4:31:46:7f'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 296757725832,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.49',
                                             'mac_address': 'b4:fb:e4:30:46:7f',
                                             'name': 'Grant Miller CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 12982585721,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 22.0},
                'f0:9f:c2:50:55:fa': {       'alt_macs': ['f0:9f:c2:51:55:fa'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 210697355339,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.45',
                                             'mac_address': 'f0:9f:c2:50:55:fa',
                                             'name': 'David Murphy CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 16669940858,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 40.0},
                'f0:9f:c2:54:73:5b': {       'alt_macs': ['f0:9f:c2:55:73:5b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 6638738391,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.41',
                                             'mac_address': 'f0:9f:c2:54:73:5b',
                                             'name': 'Mike Dastous CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 290983066,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -42.0,
                                             'ul_snr': 47.0},
                'f0:9f:c2:5a:80:99': {       'alt_macs': ['f0:9f:c2:5b:80:99'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 19474484554,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.47',
                                             'mac_address': 'f0:9f:c2:5a:80:99',
                                             'name': 'Rick Dean CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 1298968151,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 28.0},
                'fc:ec:da:dc:37:6c': {       'alt_macs': ['fc:ec:da:dd:37:6c'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 288758103678,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.30',
                                             'mac_address': 'fc:ec:da:dc:37:6c',
                                             'name': 'Jim Tarpley House CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 18014829021,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -47.0,
                                             'ul_snr': 42.0},
                'fc:ec:da:dc:3f:41': {       'alt_macs': ['fc:ec:da:dd:3f:41'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 10597014657,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.37',
                                             'mac_address': 'fc:ec:da:dc:3f:41',
                                             'name': 'Jennifer Burgess CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 295156749,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -48.0,
                                             'ul_snr': 41.0},
                'fc:ec:da:de:4c:8a': {       'alt_macs': ['fc:ec:da:df:4c:8a'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 21154832701,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.150.28.57',
                                             'mac_address': 'fc:ec:da:de:4c:8a',
                                             'name': 'Lance Jones CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -89,
                                             'ul_rf_bytes': 7018309730,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 29.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 36.27,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '550',
                                                              'in_nucast_pkts': '6888167',
                                                              'in_octets': '3780490977',
                                                              'in_ucast_pkts': '982414000',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:19:5f:e2',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1459508312',
                                                              'out_ucast_pkts': '531233092',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2762423158',
                                                              'in_ucast_pkts': '532889350',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '10561724649',
                                                                                       'mac_address': '00:27:22:74:6c:41',
                                                                                       'out_octets': '66350714163'},
                                                                               {       'in_octets': '2007983411',
                                                                                       'mac_address': '78:8a:20:9e:8f:96',
                                                                                       'out_octets': '24709541766'},
                                                                               {       'in_octets': '5101064501',
                                                                                       'mac_address': '78:8a:20:62:ee:47',
                                                                                       'out_octets': '72521166358'},
                                                                               {       'in_octets': '12982585721',
                                                                                       'mac_address': 'b4:fb:e4:30:46:7f',
                                                                                       'out_octets': '296757725832'},
                                                                               {       'in_octets': '16669940858',
                                                                                       'mac_address': 'f0:9f:c2:50:55:fa',
                                                                                       'out_octets': '210697355339'},
                                                                               {       'in_octets': '290983066',
                                                                                       'mac_address': 'f0:9f:c2:54:73:5b',
                                                                                       'out_octets': '6638738391'},
                                                                               {       'in_octets': '1298968151',
                                                                                       'mac_address': 'f0:9f:c2:5a:80:99',
                                                                                       'out_octets': '19474484554'},
                                                                               {       'in_octets': '18014829021',
                                                                                       'mac_address': 'fc:ec:da:dc:37:6c',
                                                                                       'out_octets': '288758103678'},
                                                                               {       'in_octets': '295156749',
                                                                                       'mac_address': 'fc:ec:da:dc:3f:41',
                                                                                       'out_octets': '10597014657'},
                                                                               {       'in_octets': '7018309730',
                                                                                       'mac_address': 'fc:ec:da:de:4c:8a',
                                                                                       'out_octets': '21154832701'}],
                                                              'mac_address': '78:8a:20:18:5f:e2',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '1',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '573535434',
                                                              'out_ucast_pkts': '991563644',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5220,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 1.7,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1104145',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': '00:27:22:74:6c:41',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_airtime': 0.2,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '271082',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': '78:8a:20:9e:8f:96',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_airtime': 0.2,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '884764',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': '78:8a:20:62:ee:47',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1077326',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': 'b4:fb:e4:30:46:7f',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 22.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1104130',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': 'f0:9f:c2:50:55:fa',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_airtime': 0.5,
                                                                                                                                            'snr': 40.0,
                                                                                                                                            'tx_airtime': 2.9},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '64677',
                                                                                                                                            'distance': 150,
                                                                                                                                            'mac_address': 'f0:9f:c2:54:73:5b',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -42.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 47.0,
                                                                                                                                            'tx_airtime': 3.7},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1104130',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': 'f0:9f:c2:5a:80:99',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1104161',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': 'fc:ec:da:dc:37:6c',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -47.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 42.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '34289',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': 'fc:ec:da:dc:3f:41',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -48.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1104130',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': 'fc:ec:da:de:4c:8a',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_airtime': 0.2,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_airtime': 0.1}],
                                                                                                                   'noise_floor': -89.0}],
                                                                                        'tx_airtime': 7.4,
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TekWav-TT-SSE'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.5.7-cs',
                                'system_mac_address': '78:8a:20:18:5f:e2',
                                'temperature': 0.0,
                                'uptime': '1104200'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '66350714163',
                                                                       'links': [       {       'in_octets': '66350714163',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '10561724649'}],
                                                                       'mac_address': '00:27:22:74:6c:41',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10561724649',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1104145',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10561724649',
                                                                       'mac_address': '00:27:22:75:6c:41',
                                                                       'name': 'eth0',
                                                                       'out_octets': '66350714163'}],
                                         'management_ip': '10.150.28.35',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Jeff Wideman CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:27:22:74:6c:41'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '24709541766',
                                                                       'links': [       {       'in_octets': '24709541766',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '2007983411'}],
                                                                       'mac_address': '78:8a:20:9e:8f:96',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2007983411',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '271082',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2007983411',
                                                                       'mac_address': '78:8a:20:9f:8f:96',
                                                                       'name': 'eth0',
                                                                       'out_octets': '24709541766'}],
                                         'management_ip': '10.150.28.39',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Roger Watkins CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:9e:8f:96'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '72521166358',
                                                                       'links': [       {       'in_octets': '72521166358',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '5101064501'}],
                                                                       'mac_address': '78:8a:20:62:ee:47',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5101064501',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '884764',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '5101064501',
                                                                       'mac_address': '78:8a:20:63:ee:47',
                                                                       'name': 'eth0',
                                                                       'out_octets': '72521166358'}],
                                         'management_ip': '10.150.28.43',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Connie Legg CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:62:ee:47'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '296757725832',
                                                                       'links': [       {       'in_octets': '296757725832',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '12982585721'}],
                                                                       'mac_address': 'b4:fb:e4:30:46:7f',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '12982585721',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1077326',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '12982585721',
                                                                       'mac_address': 'b4:fb:e4:31:46:7f',
                                                                       'name': 'eth0',
                                                                       'out_octets': '296757725832'}],
                                         'management_ip': '10.150.28.49',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Grant Miller CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:30:46:7f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '210697355339',
                                                                       'links': [       {       'in_octets': '210697355339',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '16669940858'}],
                                                                       'mac_address': 'f0:9f:c2:50:55:fa',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '16669940858',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1104130',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '16669940858',
                                                                       'mac_address': 'f0:9f:c2:51:55:fa',
                                                                       'name': 'eth0',
                                                                       'out_octets': '210697355339'}],
                                         'management_ip': '10.150.28.45',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'David Murphy CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:50:55:fa'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '6638738391',
                                                                       'links': [       {       'in_octets': '6638738391',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '290983066'}],
                                                                       'mac_address': 'f0:9f:c2:54:73:5b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '290983066',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '64677',
                                                                                                                                                     'distance': 150,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '290983066',
                                                                       'mac_address': 'f0:9f:c2:55:73:5b',
                                                                       'name': 'eth0',
                                                                       'out_octets': '6638738391'}],
                                         'management_ip': '10.150.28.41',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Mike Dastous CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:54:73:5b'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '19474484554',
                                                                       'links': [       {       'in_octets': '19474484554',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '1298968151'}],
                                                                       'mac_address': 'f0:9f:c2:5a:80:99',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1298968151',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1104130',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1298968151',
                                                                       'mac_address': 'f0:9f:c2:5b:80:99',
                                                                       'name': 'eth0',
                                                                       'out_octets': '19474484554'}],
                                         'management_ip': '10.150.28.47',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Rick Dean CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:5a:80:99'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '288758103678',
                                                                       'links': [       {       'in_octets': '288758103678',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '18014829021'}],
                                                                       'mac_address': 'fc:ec:da:dc:37:6c',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '18014829021',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1104161',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '18014829021',
                                                                       'mac_address': 'fc:ec:da:dd:37:6c',
                                                                       'name': 'eth0',
                                                                       'out_octets': '288758103678'}],
                                         'management_ip': '10.150.28.30',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Jim Tarpley House CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:dc:37:6c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '10597014657',
                                                                       'links': [       {       'in_octets': '10597014657',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '295156749'}],
                                                                       'mac_address': 'fc:ec:da:dc:3f:41',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '295156749',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '34289',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '295156749',
                                                                       'mac_address': 'fc:ec:da:dd:3f:41',
                                                                       'name': 'eth0',
                                                                       'out_octets': '10597014657'}],
                                         'management_ip': '10.150.28.37',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Jennifer Burgess CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:dc:3f:41'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '21154832701',
                                                                       'links': [       {       'in_octets': '21154832701',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '7018309730'}],
                                                                       'mac_address': 'fc:ec:da:de:4c:8a',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7018309730',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5220,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1104130',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '7018309730',
                                                                       'mac_address': 'fc:ec:da:df:4c:8a',
                                                                       'name': 'eth0',
                                                                       'out_octets': '21154832701'}],
                                         'management_ip': '10.150.28.57',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Lance Jones CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:de:4c:8a'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_5_8_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.5.8.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 20,
                'rf_freq': 5260,
                'rf_tx_power': 25,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.8',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 0.0,
                'cpu': 19.8,
                'dl_en_bytes': 3660610884,
                'dl_en_packets': 80319771,
                'dl_noise_floor': None,
                'dl_rf_bytes': 26523860,
                'dl_rf_packets': 203176,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 4003535785,
                'ul_en_packets': 13780728,
                'ul_noise_floor': 0,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 19.8,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '128154',
                                                              'in_octets': '3660610884',
                                                              'in_ucast_pkts': '80191617',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:15:1a:00',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4003535785',
                                                              'out_ucast_pkts': '13780728',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:14:1a:00',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '26523860',
                                                              'out_ucast_pkts': '203176',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5260,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'DBM-WST-TSE'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.5.8',
                                'system_mac_address': '78:8a:20:14:1a:00',
                                'temperature': 0.0,
                                'uptime': '21194381'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_6_1_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.6.1.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5790,
                'rf_tx_power': 25,
                'sta_count': 13,
                'sta_mode_cpe': False,
                'sw_version': 'v8.6.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 5.3,
                'cpu': 21.0,
                'dl_en_bytes': 425075051,
                'dl_en_packets': 1650248127,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3884565416,
                'dl_rf_packets': 1633461444,
                'en_if_speed': 100000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 1372533807,
                'ul_en_packets': 1182696534,
                'ul_noise_floor': -91,
                'ul_rf_bytes': 2851647158,
                'ul_rf_packets': 1181915395
        }
        exp_sta_stats = {
                '18:e8:29:32:97:1a': {       'alt_macs': ['18:e8:29:33:97:1a'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 250223067,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.17',
                                             'mac_address': '18:e8:29:32:97:1a',
                                             'name': 'Stephen O Reilly ',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 15348792,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68.0,
                                             'ul_snr': 23.0},
                '78:8a:20:1c:42:cd': {       'alt_macs': ['78:8a:20:1d:42:cd'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 170965701870,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.4',
                                             'mac_address': '78:8a:20:1c:42:cd',
                                             'name': 'Laura Myles',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 15153718266,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -70.0,
                                             'ul_snr': 21.0},
                'b4:fb:e4:34:c7:64': {       'alt_macs': ['b4:fb:e4:35:c7:64'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 140934499124,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.9',
                                             'mac_address': 'b4:fb:e4:34:c7:64',
                                             'name': 'Dolores Lawlor',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 15952893445,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.0,
                                             'ul_snr': 22.0},
                'b4:fb:e4:34:c8:56': {       'alt_macs': ['b4:fb:e4:35:c8:56'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 53855131711,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.11',
                                             'mac_address': 'b4:fb:e4:34:c8:56',
                                             'name': 'William Tyrrell & Mary Hunt '
                                                     'Tyrrell',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 9360869652,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 24.0},
                'b4:fb:e4:34:c9:00': {       'alt_macs': ['b4:fb:e4:35:c9:00'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 261835769,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.7',
                                             'mac_address': 'b4:fb:e4:34:c9:00',
                                             'name': 'Yan Zhao',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 113219991,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -77.0,
                                             'ul_snr': 14.0},
                'b4:fb:e4:34:cb:95': {       'alt_macs': ['b4:fb:e4:35:cb:95'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 27974789580,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.8',
                                             'mac_address': 'b4:fb:e4:34:cb:95',
                                             'name': 'Denise Smith',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 2029397243,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 27.0},
                'b4:fb:e4:68:66:79': {       'alt_macs': ['b4:fb:e4:69:66:79'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 224883446048,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.12',
                                             'mac_address': 'b4:fb:e4:68:66:79',
                                             'name': 'Nora Murphy',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 16717717086,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 31.0},
                'b4:fb:e4:68:69:49': {       'alt_macs': ['b4:fb:e4:69:69:49'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1787566257,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.15',
                                             'mac_address': 'b4:fb:e4:68:69:49',
                                             'name': 'Alan English',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 202971854,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 24.0},
                'b4:fb:e4:68:6a:16': {       'alt_macs': ['b4:fb:e4:69:6a:16'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 102145247200,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.6',
                                             'mac_address': 'b4:fb:e4:68:6a:16',
                                             'name': 'Pamela McHugh',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 10771646514,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -70.0,
                                             'ul_snr': 21.0},
                'b4:fb:e4:68:6f:4c': {       'alt_macs': ['b4:fb:e4:69:6f:4c'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 77296778230,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.14',
                                             'mac_address': 'b4:fb:e4:68:6f:4c',
                                             'name': 'Fabian Wolf',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 3996052755,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68.0,
                                             'ul_snr': 23.0},
                'b4:fb:e4:b8:6d:58': {       'alt_macs': ['b4:fb:e4:b9:6d:58'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 26996030917,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.5',
                                             'mac_address': 'b4:fb:e4:b8:6d:58',
                                             'name': 'Susan Albarracin',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 2020594305,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68.0,
                                             'ul_snr': 23.0},
                'f0:9f:c2:be:fc:76': {       'alt_macs': ['f0:9f:c2:bf:fc:76'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 77724604184,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.3',
                                             'mac_address': 'f0:9f:c2:be:fc:76',
                                             'name': 'Matt Barrett',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 25313951987,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 28.0},
                'fc:ec:da:9e:6a:7e': {       'alt_macs': ['fc:ec:da:9f:6a:7e'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 174493243006,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.1.10.10',
                                             'mac_address': 'fc:ec:da:9e:6a:7e',
                                             'name': 'Frank Burke',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 19826419019,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 28.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 21.0,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '14928961',
                                                              'in_octets': '425075051',
                                                              'in_ucast_pkts': '1635319166',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'f0:9f:c2:e7:ff:bf',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1372533807',
                                                              'out_ucast_pkts': '1182696534',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2851647158',
                                                              'in_ucast_pkts': '1181915395',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '15153718266',
                                                                                       'mac_address': '78:8a:20:1c:42:cd',
                                                                                       'out_octets': '170965701870'},
                                                                               {       'in_octets': '16717717086',
                                                                                       'mac_address': 'b4:fb:e4:68:66:79',
                                                                                       'out_octets': '224883446048'},
                                                                               {       'in_octets': '202971854',
                                                                                       'mac_address': 'b4:fb:e4:68:69:49',
                                                                                       'out_octets': '1787566257'},
                                                                               {       'in_octets': '10771646514',
                                                                                       'mac_address': 'b4:fb:e4:68:6a:16',
                                                                                       'out_octets': '102145247200'},
                                                                               {       'in_octets': '3996052755',
                                                                                       'mac_address': 'b4:fb:e4:68:6f:4c',
                                                                                       'out_octets': '77296778230'},
                                                                               {       'in_octets': '2020594305',
                                                                                       'mac_address': 'b4:fb:e4:b8:6d:58',
                                                                                       'out_octets': '26996030917'},
                                                                               {       'in_octets': '15952893445',
                                                                                       'mac_address': 'b4:fb:e4:34:c7:64',
                                                                                       'out_octets': '140934499124'},
                                                                               {       'in_octets': '9360869652',
                                                                                       'mac_address': 'b4:fb:e4:34:c8:56',
                                                                                       'out_octets': '53855131711'},
                                                                               {       'in_octets': '113219991',
                                                                                       'mac_address': 'b4:fb:e4:34:c9:00',
                                                                                       'out_octets': '261835769'},
                                                                               {       'in_octets': '2029397243',
                                                                                       'mac_address': 'b4:fb:e4:34:cb:95',
                                                                                       'out_octets': '27974789580'},
                                                                               {       'in_octets': '15348792',
                                                                                       'mac_address': '18:e8:29:32:97:1a',
                                                                                       'out_octets': '250223067'},
                                                                               {       'in_octets': '25313951987',
                                                                                       'mac_address': 'f0:9f:c2:be:fc:76',
                                                                                       'out_octets': '77724604184'},
                                                                               {       'in_octets': '19826419019',
                                                                                       'mac_address': 'fc:ec:da:9e:6a:7e',
                                                                                       'out_octets': '174493243006'}],
                                                              'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3884565416',
                                                              'out_ucast_pkts': '1633461444',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5790,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 2.7,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1720623',
                                                                                                                                            'distance': 5550,
                                                                                                                                            'mac_address': '78:8a:20:1c:42:cd',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1720624',
                                                                                                                                            'distance': 3300,
                                                                                                                                            'mac_address': 'b4:fb:e4:68:66:79',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_airtime': 1.7},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '72580',
                                                                                                                                            'distance': 3300,
                                                                                                                                            'mac_address': 'b4:fb:e4:68:69:49',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_airtime': 0.2,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '790931',
                                                                                                                                            'distance': 5400,
                                                                                                                                            'mac_address': 'b4:fb:e4:68:6a:16',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '788658',
                                                                                                                                            'distance': 3450,
                                                                                                                                            'mac_address': 'b4:fb:e4:68:6f:4c',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '198611',
                                                                                                                                            'distance': 8700,
                                                                                                                                            'mac_address': 'b4:fb:e4:b8:6d:58',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_airtime': 0.8,
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_airtime': 0.5},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1720623',
                                                                                                                                            'distance': 4200,
                                                                                                                                            'mac_address': 'b4:fb:e4:34:c7:64',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 22.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1706654',
                                                                                                                                            'distance': 1650,
                                                                                                                                            'mac_address': 'b4:fb:e4:34:c8:56',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '198644',
                                                                                                                                            'distance': 8850,
                                                                                                                                            'mac_address': 'b4:fb:e4:34:c9:00',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -77.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 14.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '526259',
                                                                                                                                            'distance': 5400,
                                                                                                                                            'mac_address': 'b4:fb:e4:34:cb:95',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_airtime': 0.6,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_airtime': 0.5},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '8947',
                                                                                                                                            'distance': 4800,
                                                                                                                                            'mac_address': '18:e8:29:32:97:1a',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1720618',
                                                                                                                                            'distance': 5400,
                                                                                                                                            'mac_address': 'f0:9f:c2:be:fc:76',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_airtime': 0.2,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1720623',
                                                                                                                                            'distance': 3450,
                                                                                                                                            'mac_address': 'fc:ec:da:9e:6a:7e',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_airtime': 0.1}],
                                                                                                                   'noise_floor': -91.0}],
                                                                                        'tx_airtime': 3.7,
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'AP58HILLTOP002'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.6.1',
                                'system_mac_address': 'f0:9f:c2:e6:ff:bf',
                                'temperature': 0.0,
                                'uptime': '1720802'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '170965701870',
                                                                       'links': [       {       'in_octets': '170965701870',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '15153718266'}],
                                                                       'mac_address': '78:8a:20:1c:42:cd',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '15153718266',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1720623',
                                                                                                                                                     'distance': 5550,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '15153718266',
                                                                       'mac_address': '78:8a:20:1d:42:cd',
                                                                       'name': 'eth0',
                                                                       'out_octets': '170965701870'}],
                                         'management_ip': '10.1.10.4',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Laura Myles',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:1c:42:cd'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '224883446048',
                                                                       'links': [       {       'in_octets': '224883446048',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '16717717086'}],
                                                                       'mac_address': 'b4:fb:e4:68:66:79',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '16717717086',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1720624',
                                                                                                                                                     'distance': 3300,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '16717717086',
                                                                       'mac_address': 'b4:fb:e4:69:66:79',
                                                                       'name': 'eth0',
                                                                       'out_octets': '224883446048'}],
                                         'management_ip': '10.1.10.12',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Nora Murphy',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:68:66:79'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1787566257',
                                                                       'links': [       {       'in_octets': '1787566257',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '202971854'}],
                                                                       'mac_address': 'b4:fb:e4:68:69:49',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '202971854',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '72580',
                                                                                                                                                     'distance': 3300,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '202971854',
                                                                       'mac_address': 'b4:fb:e4:69:69:49',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1787566257'}],
                                         'management_ip': '10.1.10.15',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Alan English',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:68:69:49'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '102145247200',
                                                                       'links': [       {       'in_octets': '102145247200',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '10771646514'}],
                                                                       'mac_address': 'b4:fb:e4:68:6a:16',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10771646514',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '790931',
                                                                                                                                                     'distance': 5400,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '10771646514',
                                                                       'mac_address': 'b4:fb:e4:69:6a:16',
                                                                       'name': 'eth0',
                                                                       'out_octets': '102145247200'}],
                                         'management_ip': '10.1.10.6',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Pamela McHugh',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:68:6a:16'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '77296778230',
                                                                       'links': [       {       'in_octets': '77296778230',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '3996052755'}],
                                                                       'mac_address': 'b4:fb:e4:68:6f:4c',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3996052755',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '788658',
                                                                                                                                                     'distance': 3450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3996052755',
                                                                       'mac_address': 'b4:fb:e4:69:6f:4c',
                                                                       'name': 'eth0',
                                                                       'out_octets': '77296778230'}],
                                         'management_ip': '10.1.10.14',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Fabian Wolf',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:68:6f:4c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '26996030917',
                                                                       'links': [       {       'in_octets': '26996030917',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '2020594305'}],
                                                                       'mac_address': 'b4:fb:e4:b8:6d:58',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2020594305',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '198611',
                                                                                                                                                     'distance': 8700,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2020594305',
                                                                       'mac_address': 'b4:fb:e4:b9:6d:58',
                                                                       'name': 'eth0',
                                                                       'out_octets': '26996030917'}],
                                         'management_ip': '10.1.10.5',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Susan Albarracin',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:b8:6d:58'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '140934499124',
                                                                       'links': [       {       'in_octets': '140934499124',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '15952893445'}],
                                                                       'mac_address': 'b4:fb:e4:34:c7:64',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '15952893445',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1720623',
                                                                                                                                                     'distance': 4200,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '15952893445',
                                                                       'mac_address': 'b4:fb:e4:35:c7:64',
                                                                       'name': 'eth0',
                                                                       'out_octets': '140934499124'}],
                                         'management_ip': '10.1.10.9',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Dolores Lawlor',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:34:c7:64'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '53855131711',
                                                                       'links': [       {       'in_octets': '53855131711',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '9360869652'}],
                                                                       'mac_address': 'b4:fb:e4:34:c8:56',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '9360869652',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1706654',
                                                                                                                                                     'distance': 1650,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '9360869652',
                                                                       'mac_address': 'b4:fb:e4:35:c8:56',
                                                                       'name': 'eth0',
                                                                       'out_octets': '53855131711'}],
                                         'management_ip': '10.1.10.11',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'William Tyrrell & Mary Hunt Tyrrell',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:34:c8:56'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '261835769',
                                                                       'links': [       {       'in_octets': '261835769',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '113219991'}],
                                                                       'mac_address': 'b4:fb:e4:34:c9:00',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '113219991',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '198644',
                                                                                                                                                     'distance': 8850,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '113219991',
                                                                       'mac_address': 'b4:fb:e4:35:c9:00',
                                                                       'name': 'eth0',
                                                                       'out_octets': '261835769'}],
                                         'management_ip': '10.1.10.7',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Yan Zhao',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:34:c9:00'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '27974789580',
                                                                       'links': [       {       'in_octets': '27974789580',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '2029397243'}],
                                                                       'mac_address': 'b4:fb:e4:34:cb:95',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2029397243',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '526259',
                                                                                                                                                     'distance': 5400,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2029397243',
                                                                       'mac_address': 'b4:fb:e4:35:cb:95',
                                                                       'name': 'eth0',
                                                                       'out_octets': '27974789580'}],
                                         'management_ip': '10.1.10.8',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Denise Smith',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:34:cb:95'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '250223067',
                                                                       'links': [       {       'in_octets': '250223067',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '15348792'}],
                                                                       'mac_address': '18:e8:29:32:97:1a',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '15348792',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '8947',
                                                                                                                                                     'distance': 4800,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '15348792',
                                                                       'mac_address': '18:e8:29:33:97:1a',
                                                                       'name': 'eth0',
                                                                       'out_octets': '250223067'}],
                                         'management_ip': '10.1.10.17',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Stephen O Reilly ',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '18:e8:29:32:97:1a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '77724604184',
                                                                       'links': [       {       'in_octets': '77724604184',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '25313951987'}],
                                                                       'mac_address': 'f0:9f:c2:be:fc:76',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '25313951987',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1720618',
                                                                                                                                                     'distance': 5400,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '25313951987',
                                                                       'mac_address': 'f0:9f:c2:bf:fc:76',
                                                                       'name': 'eth0',
                                                                       'out_octets': '77724604184'}],
                                         'management_ip': '10.1.10.3',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Matt Barrett',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:be:fc:76'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '174493243006',
                                                                       'links': [       {       'in_octets': '174493243006',
                                                                                                'mac_address': 'f0:9f:c2:e6:ff:bf',
                                                                                                'out_octets': '19826419019'}],
                                                                       'mac_address': 'fc:ec:da:9e:6a:7e',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '19826419019',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1720623',
                                                                                                                                                     'distance': 3450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:ff:bf'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AP58HILLTOP002'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '19826419019',
                                                                       'mac_address': 'fc:ec:da:9f:6a:7e',
                                                                       'name': 'eth0',
                                                                       'out_octets': '174493243006'}],
                                         'management_ip': '10.1.10.10',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Frank Burke',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:9e:6a:7e'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_6_1_cs_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.6.1-cs.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5745,
                'rf_tx_power': 25,
                'sta_count': 8,
                'sta_mode_cpe': False,
                'sw_version': 'v8.6.1-cs',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 14.4,
                'cpu': 35.0,
                'dl_en_bytes': 502767803,
                'dl_en_packets': 1990862368,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1884582964,
                'dl_rf_packets': 1994480822,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 3425709259,
                'ul_en_packets': 701497563,
                'ul_noise_floor': -91,
                'ul_rf_bytes': 2411006339,
                'ul_rf_packets': 705371450
        }
        exp_sta_stats = {
                '18:e8:29:3a:58:44': {       'alt_macs': ['18:e8:29:3b:58:44'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 103751440426,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.26.51',
                                             'mac_address': '18:e8:29:3a:58:44',
                                             'name': 'Thayer Walker P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 7109168332,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 29.0},
                '18:e8:29:3a:58:c2': {       'alt_macs': ['18:e8:29:3b:58:c2'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 245146446447,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.26.53',
                                             'mac_address': '18:e8:29:3a:58:c2',
                                             'name': 'Diana Nicholas P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 6333280691,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -71.0,
                                             'ul_snr': 20.0},
                '78:8a:20:6c:ed:bb': {       'alt_macs': ['78:8a:20:6d:ed:bb'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 16495365853,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.26.58',
                                             'mac_address': '78:8a:20:6c:ed:bb',
                                             'name': 'The Appraisal Office (Patricia '
                                                     'Rangel) P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 3172819858,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -52.0,
                                             'ul_snr': 39.0},
                '78:8a:20:6c:ed:cf': {       'alt_macs': ['78:8a:20:6d:ed:cf'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 53445159349,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.26.55',
                                             'mac_address': '78:8a:20:6c:ed:cf',
                                             'name': 'Anita Green P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 5241579495,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -74.0,
                                             'ul_snr': 17.0},
                '78:8a:20:e4:5f:05': {       'alt_macs': ['78:8a:20:e5:5f:05'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2264955148755,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.26.54',
                                             'mac_address': '78:8a:20:e4:5f:05',
                                             'name': 'Karen Thompson P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 51295084857,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 41.0},
                '78:8a:20:e4:6e:ae': {       'alt_macs': ['78:8a:20:e5:6e:ae'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 36736906922,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.26.60',
                                             'mac_address': '78:8a:20:e4:6e:ae',
                                             'name': 'Mark Bollock P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 2953038573,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -75.0,
                                             'ul_snr': 16.0},
                'f0:9f:c2:b8:64:55': {       'alt_macs': ['f0:9f:c2:b9:64:55'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 6684112105,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.26.64',
                                             'mac_address': 'f0:9f:c2:b8:64:55',
                                             'name': 'Nita Hiltz L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 1252542469,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 33.0},
                'fc:ec:da:5c:28:d2': {       'alt_macs': ['fc:ec:da:5d:28:d2'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 144213418743,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.26.67',
                                             'mac_address': 'fc:ec:da:5c:28:d2',
                                             'name': 'Emilia Sherman L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -91,
                                             'ul_rf_bytes': 26295455420,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 29.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 35.0,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '795843',
                                                              'in_octets': '502767803',
                                                              'in_ucast_pkts': '1990066525',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'f0:9f:c2:e7:39:68',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3425709259',
                                                              'out_ucast_pkts': '701497563',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2411006339',
                                                              'in_ucast_pkts': '705371450',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '3172819858',
                                                                                       'mac_address': '78:8a:20:6c:ed:bb',
                                                                                       'out_octets': '16495365853'},
                                                                               {       'in_octets': '5241579495',
                                                                                       'mac_address': '78:8a:20:6c:ed:cf',
                                                                                       'out_octets': '53445159349'},
                                                                               {       'in_octets': '2953038573',
                                                                                       'mac_address': '78:8a:20:e4:6e:ae',
                                                                                       'out_octets': '36736906922'},
                                                                               {       'in_octets': '51295084857',
                                                                                       'mac_address': '78:8a:20:e4:5f:05',
                                                                                       'out_octets': '2264955148755'},
                                                                               {       'in_octets': '6333280691',
                                                                                       'mac_address': '18:e8:29:3a:58:c2',
                                                                                       'out_octets': '245146446447'},
                                                                               {       'in_octets': '7109168332',
                                                                                       'mac_address': '18:e8:29:3a:58:44',
                                                                                       'out_octets': '103751440426'},
                                                                               {       'in_octets': '1252542469',
                                                                                       'mac_address': 'f0:9f:c2:b8:64:55',
                                                                                       'out_octets': '6684112105'},
                                                                               {       'in_octets': '26295455420',
                                                                                       'mac_address': 'fc:ec:da:5c:28:d2',
                                                                                       'out_octets': '144213418743'}],
                                                              'mac_address': 'f0:9f:c2:e6:39:68',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '1',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1884582964',
                                                              'out_ucast_pkts': '1994480822',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5745,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 5.9,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '405200',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': '78:8a:20:6c:ed:bb',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_airtime': 1.8,
                                                                                                                                            'snr': 39.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1900740',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': '78:8a:20:6c:ed:cf',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_airtime': 0.6,
                                                                                                                                            'snr': 17.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1900735',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': '78:8a:20:e4:6e:ae',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 16.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1900740',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': '78:8a:20:e4:5f:05',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_airtime': 1.6,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_airtime': 5.4},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1900735',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': '18:e8:29:3a:58:c2',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_airtime': 0.2,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1900739',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': '18:e8:29:3a:58:44',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_airtime': 0.5,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1900737',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': 'f0:9f:c2:b8:64:55',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_airtime': 0.9,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1900740',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': 'fc:ec:da:5c:28:d2',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_airtime': 0.2,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_airtime': 0.1}],
                                                                                                                   'noise_floor': -91.0}],
                                                                                        'tx_airtime': 6.1,
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FR-Butch-AC120-NE'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'latitude': 38.798138,
                                'longitude': -123.536835,
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.6.1-cs',
                                'system_mac_address': 'f0:9f:c2:e6:39:68',
                                'temperature': 0.0,
                                'uptime': '1900781'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '16495365853',
                                                                       'links': [       {       'in_octets': '16495365853',
                                                                                                'mac_address': 'f0:9f:c2:e6:39:68',
                                                                                                'out_octets': '3172819858'}],
                                                                       'mac_address': '78:8a:20:6c:ed:bb',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3172819858',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5745,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '405200',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:39:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR-Butch-AC120-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3172819858',
                                                                       'mac_address': '78:8a:20:6d:ed:bb',
                                                                       'name': 'eth0',
                                                                       'out_octets': '16495365853'}],
                                         'management_ip': '10.10.26.58',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'The Appraisal Office (Patricia '
                                                 'Rangel) P5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:6c:ed:bb'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '53445159349',
                                                                       'links': [       {       'in_octets': '53445159349',
                                                                                                'mac_address': 'f0:9f:c2:e6:39:68',
                                                                                                'out_octets': '5241579495'}],
                                                                       'mac_address': '78:8a:20:6c:ed:cf',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5241579495',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5745,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1900740',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:39:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR-Butch-AC120-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '5241579495',
                                                                       'mac_address': '78:8a:20:6d:ed:cf',
                                                                       'name': 'eth0',
                                                                       'out_octets': '53445159349'}],
                                         'management_ip': '10.10.26.55',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Anita Green P5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:6c:ed:cf'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '36736906922',
                                                                       'links': [       {       'in_octets': '36736906922',
                                                                                                'mac_address': 'f0:9f:c2:e6:39:68',
                                                                                                'out_octets': '2953038573'}],
                                                                       'mac_address': '78:8a:20:e4:6e:ae',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2953038573',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5745,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1900735',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:39:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR-Butch-AC120-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2953038573',
                                                                       'mac_address': '78:8a:20:e5:6e:ae',
                                                                       'name': 'eth0',
                                                                       'out_octets': '36736906922'}],
                                         'management_ip': '10.10.26.60',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Mark Bollock P5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:e4:6e:ae'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '2264955148755',
                                                                       'links': [       {       'in_octets': '2264955148755',
                                                                                                'mac_address': 'f0:9f:c2:e6:39:68',
                                                                                                'out_octets': '51295084857'}],
                                                                       'mac_address': '78:8a:20:e4:5f:05',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '51295084857',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5745,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1900740',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:39:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR-Butch-AC120-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '51295084857',
                                                                       'mac_address': '78:8a:20:e5:5f:05',
                                                                       'name': 'eth0',
                                                                       'out_octets': '2264955148755'}],
                                         'management_ip': '10.10.26.54',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Karen Thompson P5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:e4:5f:05'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '245146446447',
                                                                       'links': [       {       'in_octets': '245146446447',
                                                                                                'mac_address': 'f0:9f:c2:e6:39:68',
                                                                                                'out_octets': '6333280691'}],
                                                                       'mac_address': '18:e8:29:3a:58:c2',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6333280691',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5745,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1900735',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:39:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR-Butch-AC120-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '6333280691',
                                                                       'mac_address': '18:e8:29:3b:58:c2',
                                                                       'name': 'eth0',
                                                                       'out_octets': '245146446447'}],
                                         'management_ip': '10.10.26.53',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Diana Nicholas P5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '18:e8:29:3a:58:c2'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '103751440426',
                                                                       'links': [       {       'in_octets': '103751440426',
                                                                                                'mac_address': 'f0:9f:c2:e6:39:68',
                                                                                                'out_octets': '7109168332'}],
                                                                       'mac_address': '18:e8:29:3a:58:44',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7109168332',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5745,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1900739',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:39:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR-Butch-AC120-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '7109168332',
                                                                       'mac_address': '18:e8:29:3b:58:44',
                                                                       'name': 'eth0',
                                                                       'out_octets': '103751440426'}],
                                         'management_ip': '10.10.26.51',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Thayer Walker P5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '18:e8:29:3a:58:44'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '6684112105',
                                                                       'links': [       {       'in_octets': '6684112105',
                                                                                                'mac_address': 'f0:9f:c2:e6:39:68',
                                                                                                'out_octets': '1252542469'}],
                                                                       'mac_address': 'f0:9f:c2:b8:64:55',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1252542469',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5745,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1900737',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:39:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR-Butch-AC120-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1252542469',
                                                                       'mac_address': 'f0:9f:c2:b9:64:55',
                                                                       'name': 'eth0',
                                                                       'out_octets': '6684112105'}],
                                         'management_ip': '10.10.26.64',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Nita Hiltz L5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f0:9f:c2:b8:64:55'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '144213418743',
                                                                       'links': [       {       'in_octets': '144213418743',
                                                                                                'mac_address': 'f0:9f:c2:e6:39:68',
                                                                                                'out_octets': '26295455420'}],
                                                                       'mac_address': 'fc:ec:da:5c:28:d2',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '26295455420',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5745,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1900740',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:39:68'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR-Butch-AC120-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '26295455420',
                                                                       'mac_address': 'fc:ec:da:5d:28:d2',
                                                                       'name': 'eth0',
                                                                       'out_octets': '144213418743'}],
                                         'management_ip': '10.10.26.67',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Emilia Sherman L5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:5c:28:d2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_6_2_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.6.2.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 60,
                'rf_freq': 5805,
                'rf_tx_power': 25,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v8.6.2',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 0.4,
                'cpu': 5.94,
                'dl_en_bytes': 3445757076,
                'dl_en_packets': 38078458,
                'dl_noise_floor': None,
                'dl_rf_bytes': 918195055,
                'dl_rf_packets': 37482783,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 2119922365,
                'ul_en_packets': 32054254,
                'ul_noise_floor': -90,
                'ul_rf_bytes': 2491774189,
                'ul_rf_packets': 31473732
        }
        exp_sta_stats = {
                '78:8a:20:1c:47:aa': {       'alt_macs': ['78:8a:20:1d:47:aa'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 48162835311,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '94.102.197.19',
                                             'mac_address': '78:8a:20:1c:47:aa',
                                             'name': 'Ballymoney link to Ballymoney '
                                                     'Fibre',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 6786741485,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 5.94,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '421900',
                                                              'in_octets': '3445757076',
                                                              'in_ucast_pkts': '37656558',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'f0:9f:c2:e7:7a:50',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2119922365',
                                                              'out_ucast_pkts': '32054254',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2491774189',
                                                              'in_ucast_pkts': '31473732',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '6786741485',
                                                                                       'mac_address': '78:8a:20:1c:47:aa',
                                                                                       'out_octets': '48162835311'}],
                                                              'mac_address': 'f0:9f:c2:e6:7a:50',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '918195055',
                                                              'out_ucast_pkts': '37482783',
                                                              'radios': [       {       'chan_width': 60,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5805,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 0.2,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '148737',
                                                                                                                                            'distance': 3150,
                                                                                                                                            'mac_address': '78:8a:20:1c:47:aa',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_airtime': 0.2,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_airtime': 0.2}],
                                                                                                                   'noise_floor': -90.0}],
                                                                                        'tx_airtime': 0.2,
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'BHBALMONFBR'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.6.2',
                                'system_mac_address': 'f0:9f:c2:e6:7a:50',
                                'temperature': 0.0,
                                'uptime': '149337'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '48162835311',
                                                                       'links': [       {       'in_octets': '48162835311',
                                                                                                'mac_address': 'f0:9f:c2:e6:7a:50',
                                                                                                'out_octets': '6786741485'}],
                                                                       'mac_address': '78:8a:20:1c:47:aa',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6786741485',
                                                                       'radios': [       {       'chan_width': 60,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5805,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '148737',
                                                                                                                                                     'distance': 3150,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:7a:50'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'BHBALMONFBR'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '6786741485',
                                                                       'mac_address': '78:8a:20:1d:47:aa',
                                                                       'name': 'eth0',
                                                                       'out_octets': '48162835311'}],
                                         'management_ip': '94.102.197.19',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Ballymoney link to Ballymoney Fibre',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:1c:47:aa'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_6_2_cs_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.6.2-cs.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5790,
                'rf_tx_power': 25,
                'sta_count': 5,
                'sta_mode_cpe': False,
                'sw_version': 'v8.6.2-cs',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 1.6,
                'cpu': 6.06,
                'dl_en_bytes': 1117233129,
                'dl_en_packets': 137303357,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3121355464,
                'dl_rf_packets': 137195151,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 667655332,
                'ul_en_packets': 74573690,
                'ul_noise_floor': -90,
                'ul_rf_bytes': 2860769588,
                'ul_rf_packets': 74445890
        }
        exp_sta_stats = {
                '18:e8:29:8c:bf:1b': {       'alt_macs': ['18:e8:29:8d:bf:1b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 34031742919,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.134.62',
                                             'mac_address': '18:e8:29:8c:bf:1b',
                                             'name': 'Laurie Linscheid L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 2741949416,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 32.0},
                '78:8a:20:34:7e:b9': {       'alt_macs': ['78:8a:20:35:7e:b9'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 754239868,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.134.50',
                                             'mac_address': '78:8a:20:34:7e:b9',
                                             'name': 'Frank Jackson LB5',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 327274984,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 32.0},
                'b4:fb:e4:a8:04:a0': {       'alt_macs': ['b4:fb:e4:a9:04:a0'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 39938431902,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.134.52',
                                             'mac_address': 'b4:fb:e4:a8:04:a0',
                                             'name': 'Tweedie-Uplink P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 5634484353,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69.0,
                                             'ul_snr': 21.0},
                'b4:fb:e4:a8:06:e0': {       'alt_macs': ['b4:fb:e4:a9:06:e0'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 62611552032,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.134.58',
                                             'mac_address': 'b4:fb:e4:a8:06:e0',
                                             'name': 'Ron Bolander P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 3159244915,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -66.0,
                                             'ul_snr': 24.0},
                'b4:fb:e4:a8:10:9e': {       'alt_macs': ['b4:fb:e4:a9:10:9e'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 46153649848,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.134.53',
                                             'mac_address': 'b4:fb:e4:a8:10:9e',
                                             'name': 'Paul Boothe P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -90,
                                             'ul_rf_bytes': 3855290538,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 28.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 6.06,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '542707',
                                                              'in_octets': '1117233129',
                                                              'in_ucast_pkts': '136760650',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'f0:9f:c2:e7:6c:9a',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '667655332',
                                                              'out_ucast_pkts': '74573690',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2860769588',
                                                              'in_ucast_pkts': '74445890',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '327274984',
                                                                                       'mac_address': '78:8a:20:34:7e:b9',
                                                                                       'out_octets': '754239868'},
                                                                               {       'in_octets': '3855290538',
                                                                                       'mac_address': 'b4:fb:e4:a8:10:9e',
                                                                                       'out_octets': '46153649848'},
                                                                               {       'in_octets': '5634484353',
                                                                                       'mac_address': 'b4:fb:e4:a8:04:a0',
                                                                                       'out_octets': '39938431902'},
                                                                               {       'in_octets': '3159244915',
                                                                                       'mac_address': 'b4:fb:e4:a8:06:e0',
                                                                                       'out_octets': '62611552032'},
                                                                               {       'in_octets': '2741949416',
                                                                                       'mac_address': '18:e8:29:8c:bf:1b',
                                                                                       'out_octets': '34031742919'}],
                                                              'mac_address': 'f0:9f:c2:e6:6c:9a',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3121355464',
                                                              'out_ucast_pkts': '137195151',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5790,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 4.4,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '524247',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': '78:8a:20:34:7e:b9',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_airtime': 0.9,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '524251',
                                                                                                                                            'distance': 6600,
                                                                                                                                            'mac_address': 'b4:fb:e4:a8:10:9e',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '524256',
                                                                                                                                            'distance': 6450,
                                                                                                                                            'mac_address': 'b4:fb:e4:a8:04:a0',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_airtime': 1.8,
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '524251',
                                                                                                                                            'distance': 4050,
                                                                                                                                            'mac_address': 'b4:fb:e4:a8:06:e0',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_airtime': 1.5,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_airtime': 0.1},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '482044',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': '18:e8:29:8c:bf:1b',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_airtime': 0.1}],
                                                                                                                   'noise_floor': -90.0}],
                                                                                        'tx_airtime': 0.5,
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FR.Beam-N.NS5'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'latitude': 38.803279,
                                'longitude': -123.589389,
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.6.2-cs',
                                'system_mac_address': 'f0:9f:c2:e6:6c:9a',
                                'temperature': 0.0,
                                'uptime': '524290'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '754239868',
                                                                       'links': [       {       'in_octets': '754239868',
                                                                                                'mac_address': 'f0:9f:c2:e6:6c:9a',
                                                                                                'out_octets': '327274984'}],
                                                                       'mac_address': '78:8a:20:34:7e:b9',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '327274984',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '524247',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:6c:9a'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR.Beam-N.NS5'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '327274984',
                                                                       'mac_address': '78:8a:20:35:7e:b9',
                                                                       'name': 'eth0',
                                                                       'out_octets': '754239868'}],
                                         'management_ip': '10.6.134.50',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Frank Jackson LB5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:34:7e:b9'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '46153649848',
                                                                       'links': [       {       'in_octets': '46153649848',
                                                                                                'mac_address': 'f0:9f:c2:e6:6c:9a',
                                                                                                'out_octets': '3855290538'}],
                                                                       'mac_address': 'b4:fb:e4:a8:10:9e',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3855290538',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '524251',
                                                                                                                                                     'distance': 6600,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:6c:9a'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR.Beam-N.NS5'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3855290538',
                                                                       'mac_address': 'b4:fb:e4:a9:10:9e',
                                                                       'name': 'eth0',
                                                                       'out_octets': '46153649848'}],
                                         'management_ip': '10.6.134.53',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Paul Boothe P5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:a8:10:9e'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '39938431902',
                                                                       'links': [       {       'in_octets': '39938431902',
                                                                                                'mac_address': 'f0:9f:c2:e6:6c:9a',
                                                                                                'out_octets': '5634484353'}],
                                                                       'mac_address': 'b4:fb:e4:a8:04:a0',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5634484353',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '524256',
                                                                                                                                                     'distance': 6450,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:6c:9a'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR.Beam-N.NS5'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '5634484353',
                                                                       'mac_address': 'b4:fb:e4:a9:04:a0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '39938431902'}],
                                         'management_ip': '10.6.134.52',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Tweedie-Uplink P5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:a8:04:a0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '62611552032',
                                                                       'links': [       {       'in_octets': '62611552032',
                                                                                                'mac_address': 'f0:9f:c2:e6:6c:9a',
                                                                                                'out_octets': '3159244915'}],
                                                                       'mac_address': 'b4:fb:e4:a8:06:e0',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3159244915',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '524251',
                                                                                                                                                     'distance': 4050,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:6c:9a'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR.Beam-N.NS5'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3159244915',
                                                                       'mac_address': 'b4:fb:e4:a9:06:e0',
                                                                       'name': 'eth0',
                                                                       'out_octets': '62611552032'}],
                                         'management_ip': '10.6.134.58',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Ron Bolander P5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:a8:06:e0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '34031742919',
                                                                       'links': [       {       'in_octets': '34031742919',
                                                                                                'mac_address': 'f0:9f:c2:e6:6c:9a',
                                                                                                'out_octets': '2741949416'}],
                                                                       'mac_address': '18:e8:29:8c:bf:1b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2741949416',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5790,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '482044',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': 'f0:9f:c2:e6:6c:9a'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FR.Beam-N.NS5'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2741949416',
                                                                       'mac_address': '18:e8:29:8d:bf:1b',
                                                                       'name': 'eth0',
                                                                       'out_octets': '34031742919'}],
                                         'management_ip': '10.6.134.62',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Laurie Linscheid L5C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '18:e8:29:8c:bf:1b'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_7_1_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.7.1.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5825,
                'rf_tx_power': 6,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v8.7.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 5.5,
                'cpu': 13.0,
                'dl_en_bytes': 1474497187,
                'dl_en_packets': 3917628276,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1596171913,
                'dl_rf_packets': 3891525412,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 1628632775,
                'ul_en_packets': 375404484,
                'ul_noise_floor': -94,
                'ul_rf_bytes': 3735724208,
                'ul_rf_packets': 349139221
        }
        exp_sta_stats = {
                '78:8a:20:18:62:d1': {       'alt_macs': ['78:8a:20:19:62:d1'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 6876759778595,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '66.255.227.124',
                                             'mac_address': '78:8a:20:18:62:d1',
                                             'name': 'port - 1108 O   st',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94,
                                             'ul_rf_bytes': 1846366400669,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -46.0,
                                             'ul_snr': 48.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 13.0,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '28362003',
                                                              'in_octets': '1474497187',
                                                              'in_ucast_pkts': '3889266273',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:15:14:e5',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '147',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1628632775',
                                                              'out_ucast_pkts': '375404484',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3735724208',
                                                              'in_ucast_pkts': '349139221',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '1846366400669',
                                                                                       'mac_address': '78:8a:20:18:62:d1',
                                                                                       'out_octets': '6876759778595'}],
                                                              'mac_address': '78:8a:20:14:14:e5',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '288',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1596171913',
                                                              'out_ucast_pkts': '3891525412',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5825,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 2.6,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '2393134',
                                                                                                                                            'distance': 0,
                                                                                                                                            'mac_address': '78:8a:20:18:62:d1',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -46.0,
                                                                                                                                            'rx_airtime': 2.6,
                                                                                                                                            'snr': 48.0,
                                                                                                                                            'tx_airtime': 2.9}],
                                                                                                                   'noise_floor': -94.0}],
                                                                                        'tx_airtime': 2.9,
                                                                                        'tx_power': 6}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'DOT2_1108OStreet'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'latitude': 38.573459,
                                'longitude': -121.493258,
                                'manufacturer': 'Ubiquiti',
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.7.1',
                                'system_mac_address': '78:8a:20:14:14:e5',
                                'temperature': 0.0,
                                'uptime': '14616104'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '6876759778595',
                                                                       'links': [       {       'in_octets': '6876759778595',
                                                                                                'mac_address': '78:8a:20:14:14:e5',
                                                                                                'out_octets': '1846366400669'}],
                                                                       'mac_address': '78:8a:20:18:62:d1',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1846366400669',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5825,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2393134',
                                                                                                                                                     'distance': 0,
                                                                                                                                                     'mac_address': '78:8a:20:14:14:e5'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'DOT2_1108OStreet'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1846366400669',
                                                                       'mac_address': '78:8a:20:19:62:d1',
                                                                       'name': 'eth0',
                                                                       'out_octets': '6876759778595'}],
                                         'management_ip': '66.255.227.124',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'port - 1108 O   st',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:18:62:d1'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_7_1_02(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.7.1.02")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5690,
                'rf_tx_power': 25,
                'sta_count': 5,
                'sta_mode_cpe': False,
                'sw_version': 'v8.7.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 7.1,
                'cpu': 67.326736,
                'dl_en_bytes': 3092458545,
                'dl_en_packets': 256734960,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1240032406,
                'dl_rf_packets': 255301369,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'temperature': None,
                'ul_en_bytes': 1437922426,
                'ul_en_packets': 135076427,
                'ul_noise_floor': -90,
                'ul_rf_bytes': 559288260,
                'ul_rf_packets': 134572101
        }
        exp_sta_stats = {
                '74:83:c2:64:35:92': {       'alt_macs': ['74:83:c2:65:35:92'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 153765000,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 7216359732,
                                             'dl_rf_packets': 14977028,
                                             'dl_rssi': -57.0,
                                             'dl_snr': 39.0,
                                             'ip_address': '10.100.4.173',
                                             'mac_address': '74:83:c2:64:35:92',
                                             'name': 'Skeeter Callahan CPE',
                                             'temperature': None,
                                             'ul_link_rate': 59875200,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 318513133,
                                             'ul_rf_packets': 2527267,
                                             'ul_rssi': -55,
                                             'ul_snr': 41},
                'b4:fb:e4:30:46:7f': {       'alt_macs': ['b4:fb:e4:31:46:7f'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 159192000,
                                             'dl_noise_floor': -91.0,
                                             'dl_rf_bytes': 105695446684,
                                             'dl_rf_packets': 90807941,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 41.0,
                                             'ip_address': '10.150.28.49',
                                             'mac_address': 'b4:fb:e4:30:46:7f',
                                             'name': 'Grant Miller CPE',
                                             'temperature': None,
                                             'ul_link_rate': 64152000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 14061123670,
                                             'ul_rf_packets': 46040803,
                                             'ul_rssi': -55,
                                             'ul_snr': 41},
                'e0:63:da:f4:84:5c': {       'alt_macs': ['e0:63:da:f5:84:5c'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 112338900,
                                             'dl_noise_floor': -94.0,
                                             'dl_rf_bytes': 83004843072,
                                             'dl_rf_packets': 70667323,
                                             'dl_rssi': -60.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.150.28.33',
                                             'mac_address': 'e0:63:da:f4:84:5c',
                                             'name': 'Antonio Lopez-Canino CPE',
                                             'temperature': None,
                                             'ul_link_rate': 75735000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 6213751144,
                                             'ul_rf_packets': 25715090,
                                             'ul_rssi': -57,
                                             'ul_snr': 39},
                'f4:92:bf:48:94:36': {       'alt_macs': ['f4:92:bf:49:94:36'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 67294800,
                                             'dl_noise_floor': -93.0,
                                             'dl_rf_bytes': 14155620460,
                                             'dl_rf_packets': 22143768,
                                             'dl_rssi': -61.0,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.150.28.58',
                                             'mac_address': 'f4:92:bf:48:94:36',
                                             'name': 'Carol Boyd CPE',
                                             'temperature': None,
                                             'ul_link_rate': 62013600,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 1731679949,
                                             'ul_rf_packets': 7790301,
                                             'ul_rssi': -59,
                                             'ul_snr': 37},
                'fc:ec:da:6c:e4:73': {       'alt_macs': ['fc:ec:da:6d:e4:73'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 79234200,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 25227423149,
                                             'dl_rf_packets': 38955474,
                                             'dl_rssi': -66.0,
                                             'dl_snr': 30.0,
                                             'ip_address': '10.150.28.51',
                                             'mac_address': 'fc:ec:da:6c:e4:73',
                                             'name': 'Robert Zischkale CPE',
                                             'temperature': None,
                                             'ul_link_rate': 49183200,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 17115759777,
                                             'ul_rf_packets': 23772647,
                                             'ul_rssi': -63,
                                             'ul_snr': 33}
        }
        exp_ne_msg = {
                'data': {       'cpu': 67.32674,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '2',
                                                              'in_nucast_pkts': '6299265',
                                                              'in_octets': '3092458545',
                                                              'in_ucast_pkts': '250435695',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:19:72:de',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1437922426',
                                                              'out_ucast_pkts': '135076427',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '559288260',
                                                              'in_ucast_pkts': '134572101',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '6213751144',
                                                                                       'in_ucast_pkts': '25715090',
                                                                                       'mac_address': 'e0:63:da:f4:84:5c',
                                                                                       'out_octets': '83004843072',
                                                                                       'out_ucast_pkts': '70667323'},
                                                                               {       'in_octets': '1731679949',
                                                                                       'in_ucast_pkts': '7790301',
                                                                                       'mac_address': 'f4:92:bf:48:94:36',
                                                                                       'out_octets': '14155620460',
                                                                                       'out_ucast_pkts': '22143768'},
                                                                               {       'in_octets': '17115759777',
                                                                                       'in_ucast_pkts': '23772647',
                                                                                       'mac_address': 'fc:ec:da:6c:e4:73',
                                                                                       'out_octets': '25227423149',
                                                                                       'out_ucast_pkts': '38955474'},
                                                                               {       'in_octets': '318513133',
                                                                                       'in_ucast_pkts': '2527267',
                                                                                       'mac_address': '74:83:c2:64:35:92',
                                                                                       'out_octets': '7216359732',
                                                                                       'out_ucast_pkts': '14977028'},
                                                                               {       'in_octets': '14061123670',
                                                                                       'in_ucast_pkts': '46040803',
                                                                                       'mac_address': 'b4:fb:e4:30:46:7f',
                                                                                       'out_octets': '105695446684',
                                                                                       'out_ucast_pkts': '90807941'}],
                                                              'mac_address': '78:8a:20:18:72:de',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '1444',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1240032406',
                                                              'out_ucast_pkts': '255301369',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 67,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5690,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 0.9,
                                                                                        'rx_link_rate': '50109840',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '365664',
                                                                                                                                            'distance': 900,
                                                                                                                                            'mac_address': 'e0:63:da:f4:84:5c',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_airtime': 1.2121212,
                                                                                                                                            'rx_link_rate': '75735000',
                                                                                                                                            'snr': 39.0,
                                                                                                                                            'tx_airtime': 3.1343284,
                                                                                                                                            'tx_link_rate': '112338900'},
                                                                                                                                    {       'connected_time': '365664',
                                                                                                                                            'distance': 1200,
                                                                                                                                            'mac_address': 'f4:92:bf:48:94:36',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_airtime': 0.3030303,
                                                                                                                                            'rx_link_rate': '62013600',
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_airtime': 0.14925373,
                                                                                                                                            'tx_link_rate': '67294800'},
                                                                                                                                    {       'connected_time': '365663',
                                                                                                                                            'distance': 900,
                                                                                                                                            'mac_address': 'fc:ec:da:6c:e4:73',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_airtime': 1.5151515,
                                                                                                                                            'rx_link_rate': '49183200',
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_airtime': 0.14925373,
                                                                                                                                            'tx_link_rate': '79234200'},
                                                                                                                                    {       'connected_time': '13833',
                                                                                                                                            'distance': 1050,
                                                                                                                                            'mac_address': '74:83:c2:64:35:92',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_airtime': 3.030303,
                                                                                                                                            'rx_link_rate': '59875200',
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_airtime': 5.8208957,
                                                                                                                                            'tx_link_rate': '153765000'},
                                                                                                                                    {       'connected_time': '365662',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': 'b4:fb:e4:30:46:7f',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_airtime': 2.121212,
                                                                                                                                            'rx_link_rate': '64152000',
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_airtime': 4.776119,
                                                                                                                                            'tx_link_rate': '159192000'}],
                                                                                                                   'noise_floor': -90.0}],
                                                                                        'tx_airtime': 6.2,
                                                                                        'tx_link_rate': '108286740',
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TekWav-TT-NE'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'latitude': 33.72656,
                                'longitude': -96.62332,
                                'manufacturer': 'Ubiquiti',
                                'mem': 69.83215,
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.7.1',
                                'system_mac_address': '78:8a:20:18:72:de',
                                'uptime': '365791'},
                'peers': [       {       'cpu': 24.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '83004843072',
                                                                       'in_ucast_pkts': '70667323',
                                                                       'links': [       {       'in_octets': '83004843072',
                                                                                                'in_ucast_pkts': '70667323',
                                                                                                'mac_address': '78:8a:20:18:72:de',
                                                                                                'out_octets': '6213751144',
                                                                                                'out_ucast_pkts': '25715090'}],
                                                                       'mac_address': 'e0:63:da:f4:84:5c',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6213751144',
                                                                       'out_ucast_pkts': '25715090',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5690,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '112338900',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '365664',
                                                                                                                                                     'distance': 900,
                                                                                                                                                     'mac_address': '78:8a:20:18:72:de',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '112338900',
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '75735000'}],
                                                                                                                            'noise_floor': -94.0}],
                                                                                                 'tx_link_rate': '75735000',
                                                                                                 'tx_power': 24}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '6213751144',
                                                                       'in_ucast_pkts': '25715090',
                                                                       'mac_address': 'e0:63:da:f5:84:5c',
                                                                       'name': 'eth0',
                                                                       'out_octets': '83004843072',
                                                                       'out_ucast_pkts': '70667323'}],
                                         'latitude': 33.730386,
                                         'longitude': -96.617897,
                                         'management_ip': '10.150.28.33',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 68.17301,
                                         'model': 'PowerBeam 5AC Gen2',
                                         'name': 'Antonio Lopez-Canino CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': 'e0:63:da:f4:84:5c',
                                         'uptime': '6559782'},
                                 {       'cpu': 2.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '14155620460',
                                                                       'in_ucast_pkts': '22143768',
                                                                       'links': [       {       'in_octets': '14155620460',
                                                                                                'in_ucast_pkts': '22143768',
                                                                                                'mac_address': '78:8a:20:18:72:de',
                                                                                                'out_octets': '1731679949',
                                                                                                'out_ucast_pkts': '7790301'}],
                                                                       'mac_address': 'f4:92:bf:48:94:36',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1731679949',
                                                                       'out_ucast_pkts': '7790301',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5690,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '67294800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '365664',
                                                                                                                                                     'distance': 1200,
                                                                                                                                                     'mac_address': '78:8a:20:18:72:de',
                                                                                                                                                     'noise_floor': -93.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '67294800',
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '62013600'}],
                                                                                                                            'noise_floor': -93.0}],
                                                                                                 'tx_link_rate': '62013600',
                                                                                                 'tx_power': 24}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1731679949',
                                                                       'in_ucast_pkts': '7790301',
                                                                       'mac_address': 'f4:92:bf:49:94:36',
                                                                       'name': 'eth0',
                                                                       'out_octets': '14155620460',
                                                                       'out_ucast_pkts': '22143768'}],
                                         'latitude': 33.73164,
                                         'longitude': -96.61503,
                                         'management_ip': '10.150.28.58',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 68.831505,
                                         'model': 'PowerBeam 5AC Gen2',
                                         'name': 'Carol Boyd CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': 'f4:92:bf:48:94:36',
                                         'uptime': '5728683'},
                                 {       'cpu': 1.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '25227423149',
                                                                       'in_ucast_pkts': '38955474',
                                                                       'links': [       {       'in_octets': '25227423149',
                                                                                                'in_ucast_pkts': '38955474',
                                                                                                'mac_address': '78:8a:20:18:72:de',
                                                                                                'out_octets': '17115759777',
                                                                                                'out_ucast_pkts': '23772647'}],
                                                                       'mac_address': 'fc:ec:da:6c:e4:73',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '17115759777',
                                                                       'out_ucast_pkts': '23772647',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5690,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '79234200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '365663',
                                                                                                                                                     'distance': 900,
                                                                                                                                                     'mac_address': '78:8a:20:18:72:de',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '79234200',
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '49183200'}],
                                                                                                                            'noise_floor': -92.0}],
                                                                                                 'tx_link_rate': '49183200',
                                                                                                 'tx_power': 24}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '17115759777',
                                                                       'in_ucast_pkts': '23772647',
                                                                       'mac_address': 'fc:ec:da:6d:e4:73',
                                                                       'name': 'eth0',
                                                                       'out_octets': '25227423149',
                                                                       'out_ucast_pkts': '38955474'}],
                                         'latitude': 33.7292,
                                         'longitude': -96.61709,
                                         'management_ip': '10.150.28.51',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 68.005165,
                                         'model': 'PowerBeam 5AC Gen2',
                                         'name': 'Robert Zischkale CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': 'fc:ec:da:6c:e4:73',
                                         'uptime': '882334'},
                                 {       'cpu': 34.6534,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '7216359732',
                                                                       'in_ucast_pkts': '14977028',
                                                                       'links': [       {       'in_octets': '7216359732',
                                                                                                'in_ucast_pkts': '14977028',
                                                                                                'mac_address': '78:8a:20:18:72:de',
                                                                                                'out_octets': '318513133',
                                                                                                'out_ucast_pkts': '2527267'}],
                                                                       'mac_address': '74:83:c2:64:35:92',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '318513133',
                                                                       'out_ucast_pkts': '2527267',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5690,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '153765000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '13833',
                                                                                                                                                     'distance': 1050,
                                                                                                                                                     'mac_address': '78:8a:20:18:72:de',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '153765000',
                                                                                                                                                     'snr': 39.0,
                                                                                                                                                     'tx_link_rate': '59875200'}],
                                                                                                                            'noise_floor': -92.0}],
                                                                                                 'tx_link_rate': '59875200',
                                                                                                 'tx_power': 24}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '318513133',
                                                                       'in_ucast_pkts': '2527267',
                                                                       'mac_address': '74:83:c2:65:35:92',
                                                                       'name': 'eth0',
                                                                       'out_octets': '7216359732',
                                                                       'out_ucast_pkts': '14977028'}],
                                         'latitude': 33.733144,
                                         'longitude': -96.618178,
                                         'management_ip': '10.100.4.173',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 67.38541,
                                         'model': 'PowerBeam 5AC Gen2',
                                         'name': 'Skeeter Callahan CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': '74:83:c2:64:35:92',
                                         'uptime': '13871'},
                                 {       'cpu': 5.9405,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '105695446684',
                                                                       'in_ucast_pkts': '90807941',
                                                                       'links': [       {       'in_octets': '105695446684',
                                                                                                'in_ucast_pkts': '90807941',
                                                                                                'mac_address': '78:8a:20:18:72:de',
                                                                                                'out_octets': '14061123670',
                                                                                                'out_ucast_pkts': '46040803'}],
                                                                       'mac_address': 'b4:fb:e4:30:46:7f',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '14061123670',
                                                                       'out_ucast_pkts': '46040803',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 67,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5690,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '159192000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '365662',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': '78:8a:20:18:72:de',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '159192000',
                                                                                                                                                     'snr': 41.0,
                                                                                                                                                     'tx_link_rate': '64152000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '64152000',
                                                                                                 'tx_power': 24}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-NE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '14061123670',
                                                                       'in_ucast_pkts': '46040803',
                                                                       'mac_address': 'b4:fb:e4:31:46:7f',
                                                                       'name': 'eth0',
                                                                       'out_octets': '105695446684',
                                                                       'out_ucast_pkts': '90807941'}],
                                         'latitude': 33.72935,
                                         'longitude': -96.61896,
                                         'management_ip': '10.150.28.49',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 68.90897,
                                         'model': 'PowerBeam 5AC Gen2',
                                         'name': 'Grant Miller CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': 'b4:fb:e4:30:46:7f',
                                         'uptime': '5394081'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_7_1_cs_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.7.1-cs.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5165,
                'rf_tx_power': 25,
                'sta_count': 9,
                'sta_mode_cpe': False,
                'sw_version': 'v8.7.1-cs',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 15.7,
                'cpu': 36.274509,
                'dl_en_bytes': 2112755090,
                'dl_en_packets': 403084695,
                'dl_noise_floor': None,
                'dl_rf_bytes': 4207463237,
                'dl_rf_packets': 403267488,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'temperature': None,
                'ul_en_bytes': 1076782165,
                'ul_en_packets': 218987488,
                'ul_noise_floor': -89,
                'ul_rf_bytes': 2580294016,
                'ul_rf_packets': 218972015
        }
        exp_sta_stats = {
                '00:27:22:74:6c:41': {       'alt_macs': ['00:27:22:75:6c:41'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 138510000,
                                             'dl_noise_floor': -93.0,
                                             'dl_rf_bytes': 47198525447,
                                             'dl_rf_packets': 51324190,
                                             'dl_rssi': -65.0,
                                             'dl_snr': 31.0,
                                             'ip_address': '10.150.28.35',
                                             'mac_address': '00:27:22:74:6c:41',
                                             'name': 'Jeff Wideman CPE',
                                             'temperature': None,
                                             'ul_link_rate': 228285000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 11921532507,
                                             'ul_rf_packets': 26133952,
                                             'ul_rssi': -63,
                                             'ul_snr': 33},
                '18:e8:29:38:d0:32': {       'alt_macs': ['18:e8:29:39:d0:32'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 131220000,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': 9322712275,
                                             'dl_rf_packets': 17217613,
                                             'dl_rssi': -67.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '10.150.28.43',
                                             'mac_address': '18:e8:29:38:d0:32',
                                             'name': 'Connie Legg CPE',
                                             'temperature': None,
                                             'ul_link_rate': 192240000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 303865968,
                                             'ul_rf_packets': 2361227,
                                             'ul_rssi': -64,
                                             'ul_snr': 32},
                '78:8a:20:9e:8f:96': {       'alt_macs': ['78:8a:20:9f:8f:96'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 226800000,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': 41922478376,
                                             'dl_rf_packets': 44147116,
                                             'dl_rssi': -58.0,
                                             'dl_snr': 38.0,
                                             'ip_address': '10.150.28.39',
                                             'mac_address': '78:8a:20:9e:8f:96',
                                             'name': 'Roger Watkins CPE',
                                             'temperature': None,
                                             'ul_link_rate': 267000000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 5056361732,
                                             'ul_rf_packets': 19358183,
                                             'ul_rssi': -66,
                                             'ul_snr': 30},
                'f0:9f:c2:50:55:fa': {       'alt_macs': ['f0:9f:c2:51:55:fa'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 186300000,
                                             'dl_noise_floor': -102.0,
                                             'dl_rf_bytes': 1602147767,
                                             'dl_rf_packets': 11848640,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 41.0,
                                             'ip_address': '10.150.28.45',
                                             'mac_address': 'f0:9f:c2:50:55:fa',
                                             'name': 'David Murphy CPE',
                                             'temperature': None,
                                             'ul_link_rate': 162000000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 21360937,
                                             'ul_rf_packets': 31403,
                                             'ul_rssi': -56,
                                             'ul_snr': 40},
                'f0:9f:c2:54:73:5b': {       'alt_macs': ['f0:9f:c2:55:73:5b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 251100000,
                                             'dl_noise_floor': -101.0,
                                             'dl_rf_bytes': 56203065385,
                                             'dl_rf_packets': 52027177,
                                             'dl_rssi': -49.0,
                                             'dl_snr': 47.0,
                                             'ip_address': '10.150.28.41',
                                             'mac_address': 'f0:9f:c2:54:73:5b',
                                             'name': 'Mike Dastous CPE',
                                             'temperature': None,
                                             'ul_link_rate': 267000000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 3279345857,
                                             'ul_rf_packets': 19984570,
                                             'ul_rssi': -52,
                                             'ul_snr': 44},
                'f0:9f:c2:5a:80:99': {       'alt_macs': ['f0:9f:c2:5b:80:99'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 259200000,
                                             'dl_noise_floor': -98.0,
                                             'dl_rf_bytes': 2249323277,
                                             'dl_rf_packets': 12308033,
                                             'dl_rssi': -60.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.150.28.47',
                                             'mac_address': 'f0:9f:c2:5a:80:99',
                                             'name': 'Rick Dean CPE',
                                             'temperature': None,
                                             'ul_link_rate': 137700000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 49253669,
                                             'ul_rf_packets': 331938,
                                             'ul_rssi': -74,
                                             'ul_snr': 22},
                'fc:ec:da:dc:37:6c': {       'alt_macs': ['fc:ec:da:dd:37:6c'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 334800000,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': 56628659457,
                                             'dl_rf_packets': 66754493,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 41.0,
                                             'ip_address': '10.150.28.30',
                                             'mac_address': 'fc:ec:da:dc:37:6c',
                                             'name': 'Jim Tarpley House CPE',
                                             'temperature': None,
                                             'ul_link_rate': 248400000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 11092993255,
                                             'ul_rf_packets': 38620496,
                                             'ul_rssi': -55,
                                             'ul_snr': 41},
                'fc:ec:da:dc:3f:41': {       'alt_macs': ['fc:ec:da:dd:3f:41'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 334800000,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': 143231942904,
                                             'dl_rf_packets': 112945873,
                                             'dl_rssi': -46.0,
                                             'dl_snr': 50.0,
                                             'ip_address': '10.150.28.37',
                                             'mac_address': 'fc:ec:da:dc:3f:41',
                                             'name': 'Jennifer Burgess CPE',
                                             'temperature': None,
                                             'ul_link_rate': 270000000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 7752290355,
                                             'ul_rf_packets': 48777584,
                                             'ul_rssi': -62,
                                             'ul_snr': 34},
                'fc:ec:da:de:4c:8a': {       'alt_macs': ['fc:ec:da:df:4c:8a'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 150660000,
                                             'dl_noise_floor': -91.0,
                                             'dl_rf_bytes': 26547532193,
                                             'dl_rf_packets': 30923204,
                                             'dl_rssi': -66.0,
                                             'dl_snr': 30.0,
                                             'ip_address': '10.150.28.57',
                                             'mac_address': 'fc:ec:da:de:4c:8a',
                                             'name': 'Lance Jones CPE',
                                             'temperature': None,
                                             'ul_link_rate': 240300000,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 1965376375,
                                             'ul_rf_packets': 7991614,
                                             'ul_rssi': -66,
                                             'ul_snr': 30}
        }
        exp_ne_msg = {
                'data': {       'cpu': 36.27451,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '6233636',
                                                              'in_octets': '2112755090',
                                                              'in_ucast_pkts': '396851059',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:19:5f:e2',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '1',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1076782165',
                                                              'out_ucast_pkts': '218987488',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2580294016',
                                                              'in_ucast_pkts': '218972015',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '11921532507',
                                                                                       'in_ucast_pkts': '26133952',
                                                                                       'mac_address': '00:27:22:74:6c:41',
                                                                                       'out_octets': '47198525447',
                                                                                       'out_ucast_pkts': '51324190'},
                                                                               {       'in_octets': '303865968',
                                                                                       'in_ucast_pkts': '2361227',
                                                                                       'mac_address': '18:e8:29:38:d0:32',
                                                                                       'out_octets': '9322712275',
                                                                                       'out_ucast_pkts': '17217613'},
                                                                               {       'in_octets': '21360937',
                                                                                       'in_ucast_pkts': '31403',
                                                                                       'mac_address': 'f0:9f:c2:50:55:fa',
                                                                                       'out_octets': '1602147767',
                                                                                       'out_ucast_pkts': '11848640'},
                                                                               {       'in_octets': '49253669',
                                                                                       'in_ucast_pkts': '331938',
                                                                                       'mac_address': 'f0:9f:c2:5a:80:99',
                                                                                       'out_octets': '2249323277',
                                                                                       'out_ucast_pkts': '12308033'},
                                                                               {       'in_octets': '1965376375',
                                                                                       'in_ucast_pkts': '7991614',
                                                                                       'mac_address': 'fc:ec:da:de:4c:8a',
                                                                                       'out_octets': '26547532193',
                                                                                       'out_ucast_pkts': '30923204'},
                                                                               {       'in_octets': '11092993255',
                                                                                       'in_ucast_pkts': '38620496',
                                                                                       'mac_address': 'fc:ec:da:dc:37:6c',
                                                                                       'out_octets': '56628659457',
                                                                                       'out_ucast_pkts': '66754493'},
                                                                               {       'in_octets': '7752290355',
                                                                                       'in_ucast_pkts': '48777584',
                                                                                       'mac_address': 'fc:ec:da:dc:3f:41',
                                                                                       'out_octets': '143231942904',
                                                                                       'out_ucast_pkts': '112945873'},
                                                                               {       'in_octets': '5056361732',
                                                                                       'in_ucast_pkts': '19358183',
                                                                                       'mac_address': '78:8a:20:9e:8f:96',
                                                                                       'out_octets': '41922478376',
                                                                                       'out_ucast_pkts': '44147116'},
                                                                               {       'in_octets': '3279345857',
                                                                                       'in_ucast_pkts': '19984570',
                                                                                       'mac_address': 'f0:9f:c2:54:73:5b',
                                                                                       'out_octets': '56203065385',
                                                                                       'out_ucast_pkts': '52027177'}],
                                                              'mac_address': '78:8a:20:18:5f:e2',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4207463237',
                                                              'out_ucast_pkts': '403267488',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5165,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_airtime': 4.6,
                                                                                        'rx_link_rate': '227732000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '362502',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': '00:27:22:74:6c:41',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_airtime': 0.3,
                                                                                                                                            'rx_link_rate': '228285000',
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_airtime': 0.3,
                                                                                                                                            'tx_link_rate': '138510000'},
                                                                                                                                    {       'connected_time': '10605',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': '18:e8:29:38:d0:32',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'rx_link_rate': '192240000',
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_airtime': 3.0,
                                                                                                                                            'tx_link_rate': '131220000'},
                                                                                                                                    {       'connected_time': '122',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': 'f0:9f:c2:50:55:fa',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_airtime': 1.1,
                                                                                                                                            'rx_link_rate': '162000000',
                                                                                                                                            'snr': 40.0,
                                                                                                                                            'tx_airtime': 2.4,
                                                                                                                                            'tx_link_rate': '186300000'},
                                                                                                                                    {       'connected_time': '9389',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': 'f0:9f:c2:5a:80:99',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_airtime': 2.5,
                                                                                                                                            'rx_link_rate': '137700000',
                                                                                                                                            'snr': 22.0,
                                                                                                                                            'tx_airtime': 0.6,
                                                                                                                                            'tx_link_rate': '259200000'},
                                                                                                                                    {       'connected_time': '362484',
                                                                                                                                            'distance': 600,
                                                                                                                                            'mac_address': 'fc:ec:da:de:4c:8a',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'rx_link_rate': '240300000',
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_airtime': 0.1,
                                                                                                                                            'tx_link_rate': '150660000'},
                                                                                                                                    {       'connected_time': '362484',
                                                                                                                                            'distance': 150,
                                                                                                                                            'mac_address': 'fc:ec:da:dc:37:6c',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_airtime': 0.2,
                                                                                                                                            'rx_link_rate': '248400000',
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_airtime': 1.3,
                                                                                                                                            'tx_link_rate': '334800000'},
                                                                                                                                    {       'connected_time': '362484',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': 'fc:ec:da:dc:3f:41',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_airtime': 0.3,
                                                                                                                                            'rx_link_rate': '270000000',
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_airtime': 2.3,
                                                                                                                                            'tx_link_rate': '334800000'},
                                                                                                                                    {       'connected_time': '362452',
                                                                                                                                            'distance': 150,
                                                                                                                                            'mac_address': '78:8a:20:9e:8f:96',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_airtime': 0.1,
                                                                                                                                            'rx_link_rate': '267000000',
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_airtime': 0.1,
                                                                                                                                            'tx_link_rate': '226800000'},
                                                                                                                                    {       'connected_time': '362449',
                                                                                                                                            'distance': 300,
                                                                                                                                            'mac_address': 'f0:9f:c2:54:73:5b',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_airtime': 0.4,
                                                                                                                                            'rx_link_rate': '267000000',
                                                                                                                                            'snr': 44.0,
                                                                                                                                            'tx_airtime': 1.1,
                                                                                                                                            'tx_link_rate': '251100000'}],
                                                                                                                   'noise_floor': -89.0}],
                                                                                        'tx_airtime': 11.1,
                                                                                        'tx_link_rate': '219620000',
                                                                                        'tx_power': 25}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TekWav-TT-SSE'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 69.37379,
                                'model': 'ISO Station 5AC',
                                'sw_version': 'v8.7.1-cs',
                                'system_mac_address': '78:8a:20:18:5f:e2',
                                'uptime': '362560'},
                'peers': [       {       'cpu': 7.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '47198525447',
                                                                       'in_ucast_pkts': '51324190',
                                                                       'links': [       {       'in_octets': '47198525447',
                                                                                                'in_ucast_pkts': '51324190',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '11921532507',
                                                                                                'out_ucast_pkts': '26133952'}],
                                                                       'mac_address': '00:27:22:74:6c:41',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '11921532507',
                                                                       'out_ucast_pkts': '26133952',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5165,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '138510000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '362502',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2',
                                                                                                                                                     'noise_floor': -93.0,
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '138510000',
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '228285000'}],
                                                                                                                            'noise_floor': -93.0}],
                                                                                                 'tx_link_rate': '228285000',
                                                                                                 'tx_power': 22}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '11921532507',
                                                                       'in_ucast_pkts': '26133952',
                                                                       'mac_address': '00:27:22:75:6c:41',
                                                                       'name': 'eth0',
                                                                       'out_octets': '47198525447',
                                                                       'out_ucast_pkts': '51324190'}],
                                         'management_ip': '10.150.28.35',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 75.71158,
                                         'model': 'NanoStation loco M5',
                                         'name': 'Jeff Wideman CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v6.3.2',
                                         'system_mac_address': '00:27:22:74:6c:41',
                                         'uptime': '6556633'},
                                 {       'cpu': 6.8627,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '9322712275',
                                                                       'in_ucast_pkts': '17217613',
                                                                       'links': [       {       'in_octets': '9322712275',
                                                                                                'in_ucast_pkts': '17217613',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '303865968',
                                                                                                'out_ucast_pkts': '2361227'}],
                                                                       'mac_address': '18:e8:29:38:d0:32',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '303865968',
                                                                       'out_ucast_pkts': '2361227',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '131220000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '10605',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '131220000',
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '192240000'}],
                                                                                                                            'noise_floor': -90.0}],
                                                                                                 'tx_link_rate': '192240000',
                                                                                                 'tx_power': 24}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '303865968',
                                                                       'in_ucast_pkts': '2361227',
                                                                       'mac_address': '18:e8:29:39:d0:32',
                                                                       'name': 'eth0',
                                                                       'out_octets': '9322712275',
                                                                       'out_ucast_pkts': '17217613'}],
                                         'latitude': 33.72437,
                                         'longitude': -96.62315,
                                         'management_ip': '10.150.28.43',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 67.50807,
                                         'model': 'PowerBeam 5AC Gen2',
                                         'name': 'Connie Legg CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': '18:e8:29:38:d0:32',
                                         'uptime': '10645'},
                                 {       'cpu': 5.0505,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1602147767',
                                                                       'in_ucast_pkts': '11848640',
                                                                       'links': [       {       'in_octets': '1602147767',
                                                                                                'in_ucast_pkts': '11848640',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '21360937',
                                                                                                'out_ucast_pkts': '31403'}],
                                                                       'mac_address': 'f0:9f:c2:50:55:fa',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21360937',
                                                                       'out_ucast_pkts': '31403',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '186300000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '122',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2',
                                                                                                                                                     'noise_floor': -102.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '186300000',
                                                                                                                                                     'snr': 41.0,
                                                                                                                                                     'tx_link_rate': '162000000'}],
                                                                                                                            'noise_floor': -102.0}],
                                                                                                 'tx_link_rate': '162000000',
                                                                                                 'tx_power': 24}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '21360937',
                                                                       'in_ucast_pkts': '31403',
                                                                       'mac_address': 'f0:9f:c2:51:55:fa',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1602147767',
                                                                       'out_ucast_pkts': '11848640'}],
                                         'latitude': 33.72439,
                                         'longitude': -96.62084,
                                         'management_ip': '10.150.28.45',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 65.58425,
                                         'model': 'PowerBeam 5AC 400',
                                         'name': 'David Murphy CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1-cs',
                                         'system_mac_address': 'f0:9f:c2:50:55:fa',
                                         'uptime': '259993'},
                                 {       'cpu': 7.8431,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '2249323277',
                                                                       'in_ucast_pkts': '12308033',
                                                                       'links': [       {       'in_octets': '2249323277',
                                                                                                'in_ucast_pkts': '12308033',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '49253669',
                                                                                                'out_ucast_pkts': '331938'}],
                                                                       'mac_address': 'f0:9f:c2:5a:80:99',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '49253669',
                                                                       'out_ucast_pkts': '331938',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '259200000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '9389',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2',
                                                                                                                                                     'noise_floor': -98.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '259200000',
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '137700000'}],
                                                                                                                            'noise_floor': -98.0}],
                                                                                                 'tx_link_rate': '137700000',
                                                                                                 'tx_power': 3}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '49253669',
                                                                       'in_ucast_pkts': '331938',
                                                                       'mac_address': 'f0:9f:c2:5b:80:99',
                                                                       'name': 'eth0',
                                                                       'out_octets': '2249323277',
                                                                       'out_ucast_pkts': '12308033'}],
                                         'latitude': 33.72407,
                                         'longitude': -96.62054,
                                         'management_ip': '10.150.28.47',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 65.71982,
                                         'model': 'PowerBeam 5AC 400',
                                         'name': 'Rick Dean CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': 'f0:9f:c2:5a:80:99',
                                         'uptime': '6556648'},
                                 {       'cpu': 5.8823,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '26547532193',
                                                                       'in_ucast_pkts': '30923204',
                                                                       'links': [       {       'in_octets': '26547532193',
                                                                                                'in_ucast_pkts': '30923204',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '1965376375',
                                                                                                'out_ucast_pkts': '7991614'}],
                                                                       'mac_address': 'fc:ec:da:de:4c:8a',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1965376375',
                                                                       'out_ucast_pkts': '7991614',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '150660000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '362484',
                                                                                                                                                     'distance': 600,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '150660000',
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '240300000'}],
                                                                                                                            'noise_floor': -91.0}],
                                                                                                 'tx_link_rate': '240300000',
                                                                                                 'tx_power': 24}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1965376375',
                                                                       'in_ucast_pkts': '7991614',
                                                                       'mac_address': 'fc:ec:da:df:4c:8a',
                                                                       'name': 'eth0',
                                                                       'out_octets': '26547532193',
                                                                       'out_ucast_pkts': '30923204'}],
                                         'latitude': 33.72559,
                                         'longitude': -96.62725,
                                         'management_ip': '10.150.28.57',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 69.580376,
                                         'model': 'PowerBeam 5AC Gen2',
                                         'name': 'Lance Jones CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': 'fc:ec:da:de:4c:8a',
                                         'uptime': '6556639'},
                                 {       'cpu': 6.8627,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '56628659457',
                                                                       'in_ucast_pkts': '66754493',
                                                                       'links': [       {       'in_octets': '56628659457',
                                                                                                'in_ucast_pkts': '66754493',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '11092993255',
                                                                                                'out_ucast_pkts': '38620496'}],
                                                                       'mac_address': 'fc:ec:da:dc:37:6c',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '11092993255',
                                                                       'out_ucast_pkts': '38620496',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '334800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '362484',
                                                                                                                                                     'distance': 150,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '334800000',
                                                                                                                                                     'snr': 41.0,
                                                                                                                                                     'tx_link_rate': '248400000'}],
                                                                                                                            'noise_floor': -90.0}],
                                                                                                 'tx_link_rate': '248400000',
                                                                                                 'tx_power': 25}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '11092993255',
                                                                       'in_ucast_pkts': '38620496',
                                                                       'mac_address': 'fc:ec:da:dd:37:6c',
                                                                       'name': 'eth0',
                                                                       'out_octets': '56628659457',
                                                                       'out_ucast_pkts': '66754493'}],
                                         'latitude': 33.72656,
                                         'longitude': -96.62337,
                                         'management_ip': '10.150.28.30',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 65.71336,
                                         'model': 'NanoBeam 5AC Gen2',
                                         'name': 'Jim Tarpley House CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': 'fc:ec:da:dc:37:6c',
                                         'uptime': '6556617'},
                                 {       'cpu': 16.0,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '143231942904',
                                                                       'in_ucast_pkts': '112945873',
                                                                       'links': [       {       'in_octets': '143231942904',
                                                                                                'in_ucast_pkts': '112945873',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '7752290355',
                                                                                                'out_ucast_pkts': '48777584'}],
                                                                       'mac_address': 'fc:ec:da:dc:3f:41',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7752290355',
                                                                       'out_ucast_pkts': '48777584',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5165,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '334800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '362484',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -46.0,
                                                                                                                                                     'rx_link_rate': '334800000',
                                                                                                                                                     'snr': 50.0,
                                                                                                                                                     'tx_link_rate': '270000000'}],
                                                                                                                            'noise_floor': -90.0}],
                                                                                                 'tx_link_rate': '270000000',
                                                                                                 'tx_power': -4}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '7752290355',
                                                                       'in_ucast_pkts': '48777584',
                                                                       'mac_address': 'fc:ec:da:dd:3f:41',
                                                                       'name': 'eth0',
                                                                       'out_octets': '143231942904',
                                                                       'out_ucast_pkts': '112945873'}],
                                         'latitude': 33.72683,
                                         'longitude': -96.62244,
                                         'management_ip': '10.150.28.37',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 67.44997,
                                         'model': 'NanoBeam 5AC Gen2',
                                         'name': 'Jennifer Burgess CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v8.7.1',
                                         'system_mac_address': 'fc:ec:da:dc:3f:41',
                                         'uptime': '6556643'},
                                 {       'cpu': 13.9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '41922478376',
                                                                       'in_ucast_pkts': '44147116',
                                                                       'links': [       {       'in_octets': '41922478376',
                                                                                                'in_ucast_pkts': '44147116',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '5056361732',
                                                                                                'out_ucast_pkts': '19358183'}],
                                                                       'mac_address': '78:8a:20:9e:8f:96',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5056361732',
                                                                       'out_ucast_pkts': '19358183',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5165,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '226800000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '362452',
                                                                                                                                                     'distance': 150,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '226800000',
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '267000000'}],
                                                                                                                            'noise_floor': -97.0}],
                                                                                                 'tx_link_rate': '267000000',
                                                                                                 'tx_power': 18}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '5056361732',
                                                                       'in_ucast_pkts': '19358183',
                                                                       'mac_address': '78:8a:20:9f:8f:96',
                                                                       'name': 'eth0',
                                                                       'out_octets': '41922478376',
                                                                       'out_ucast_pkts': '44147116'}],
                                         'management_ip': '10.150.28.39',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 36.803143,
                                         'model': 'NanoStation M5',
                                         'name': 'Roger Watkins CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v6.3.2',
                                         'system_mac_address': '78:8a:20:9e:8f:96',
                                         'uptime': '6560464'},
                                 {       'cpu': 21.6,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '56203065385',
                                                                       'in_ucast_pkts': '52027177',
                                                                       'links': [       {       'in_octets': '56203065385',
                                                                                                'in_ucast_pkts': '52027177',
                                                                                                'mac_address': '78:8a:20:18:5f:e2',
                                                                                                'out_octets': '3279345857',
                                                                                                'out_ucast_pkts': '19984570'}],
                                                                       'mac_address': 'f0:9f:c2:54:73:5b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3279345857',
                                                                       'out_ucast_pkts': '19984570',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 5165,
                                                                                                 'gps_sync': False,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '251100000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '362449',
                                                                                                                                                     'distance': 300,
                                                                                                                                                     'mac_address': '78:8a:20:18:5f:e2',
                                                                                                                                                     'noise_floor': -101.0,
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '251100000',
                                                                                                                                                     'snr': 47.0,
                                                                                                                                                     'tx_link_rate': '267000000'}],
                                                                                                                            'noise_floor': -101.0}],
                                                                                                 'tx_link_rate': '267000000',
                                                                                                 'tx_power': 26}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TekWav-TT-SSE'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '3279345857',
                                                                       'in_ucast_pkts': '19984570',
                                                                       'mac_address': 'f0:9f:c2:55:73:5b',
                                                                       'name': 'eth0',
                                                                       'out_octets': '56203065385',
                                                                       'out_ucast_pkts': '52027177'}],
                                         'management_ip': '10.150.28.41',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 41.393074,
                                         'model': 'PowerBeam M5 400',
                                         'name': 'Mike Dastous CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v6.3.2',
                                         'system_mac_address': 'f0:9f:c2:54:73:5b',
                                         'uptime': '6256495'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_ISO_Station_5AC_v8_7_4_01(self):
        obj = self.run_data("ubnt.airmax-ac.ISO Station 5AC.v8.7.4.01")
        exp_info = {
                'gps_sync': False,
                'model': 'ISO Station 5AC',
                'rf_chan_width': 40,
                'rf_freq': 5630,
                'rf_tx_power': 23,
                'sta_count': 1,
                'sta_mode_cpe': True,
                'sw_version': 'v8.7.4',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': None,
                'cpu': 33.0,
                'dl_en_bytes': 0,
                'dl_en_packets': 0,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': None,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 0,
                'ul_en_packets': 0,
                'ul_noise_floor': -89,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_LiteAP_AC_v8_5_11_01(self):
        obj = self.run_data("ubnt.airmax-ac.LiteAP AC.v8.5.11.01")
        exp_info = {
                'gps_sync': False,
                'model': 'LiteAP AC',
                'rf_chan_width': 20,
                'rf_freq': 5800,
                'rf_tx_power': 22,
                'sta_count': 8,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.11',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 17.5,
                'cpu': 7.07,
                'dl_en_bytes': 1746239459,
                'dl_en_packets': 3309296787,
                'dl_noise_floor': None,
                'dl_rf_bytes': 2269448054,
                'dl_rf_packets': 2913246131,
                'en_if_speed': 100000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 996256338,
                'ul_en_packets': 1121134146,
                'ul_noise_floor': -94,
                'ul_rf_bytes': 1201165374,
                'ul_rf_packets': 813059576
        }
        exp_sta_stats = {
                'b4:fb:e4:34:00:80': {       'alt_macs': ['b4:fb:e4:35:00:80'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 20765701803,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '100.101.19.50',
                                             'mac_address': 'b4:fb:e4:34:00:80',
                                             'name': 'Kyerra Higbee 397 CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94,
                                             'ul_rf_bytes': 1801791811,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 45.0},
                'b4:fb:e4:34:02:bf': {       'alt_macs': ['b4:fb:e4:35:02:bf'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 205790050962,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '100.101.19.52',
                                             'mac_address': 'b4:fb:e4:34:02:bf',
                                             'name': 'Leisha Brower 399 CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94,
                                             'ul_rf_bytes': 30697291590,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -54.0,
                                             'ul_snr': 40.0},
                'b4:fb:e4:aa:cb:d9': {       'alt_macs': ['b4:fb:e4:ab:cb:d9'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 260876214207,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '100.101.19.199',
                                             'mac_address': 'b4:fb:e4:aa:cb:d9',
                                             'name': ' Noel CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94,
                                             'ul_rf_bytes': 12294216006,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -53.0,
                                             'ul_snr': 41.0},
                'b4:fb:e4:b8:e3:46': {       'alt_macs': ['b4:fb:e4:b9:e3:46'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 44732011248,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '100.101.19.186',
                                             'mac_address': 'b4:fb:e4:b8:e3:46',
                                             'name': ' insert name CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94,
                                             'ul_rf_bytes': 5285988621,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -51.0,
                                             'ul_snr': 43.0},
                'fc:ec:da:64:4e:3b': {       'alt_macs': ['fc:ec:da:65:4e:3b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 849573956562,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '100.101.19.46',
                                             'mac_address': 'fc:ec:da:64:4e:3b',
                                             'name': 'Kolay Johnson CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94,
                                             'ul_rf_bytes': 59541488179,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68.0,
                                             'ul_snr': 26.0},
                'fc:ec:da:64:50:76': {       'alt_macs': ['fc:ec:da:65:50:76'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 152500723200,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '100.101.19.54',
                                             'mac_address': 'fc:ec:da:64:50:76',
                                             'name': 'Dean Hazen CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94,
                                             'ul_rf_bytes': 20628182954,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -71.0,
                                             'ul_snr': 23.0},
                'fc:ec:da:6c:e3:85': {       'alt_macs': ['fc:ec:da:6d:e3:85'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2866245431629,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '100.101.19.51',
                                             'mac_address': 'fc:ec:da:6c:e3:85',
                                             'name': 'George Chandler #401 CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94,
                                             'ul_rf_bytes': 168137521205,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -66.0,
                                             'ul_snr': 28.0},
                'fc:ec:da:6c:e7:74': {       'alt_macs': ['fc:ec:da:6d:e7:74'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1426738774974,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '100.101.19.45',
                                             'mac_address': 'fc:ec:da:6c:e7:74',
                                             'name': 'Anderson #375 CPE',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -94,
                                             'ul_rf_bytes': 119967446914,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 35.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 7.07,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '5616378',
                                                              'in_octets': '1746239459',
                                                              'in_ucast_pkts': '3303680409',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '44:d9:e7:af:71:f4',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '996256338',
                                                              'out_ucast_pkts': '1121134146',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1201165374',
                                                              'in_ucast_pkts': '813059576',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '12294216006',
                                                                                       'mac_address': 'b4:fb:e4:aa:cb:d9',
                                                                                       'out_octets': '260876214207'},
                                                                               {       'in_octets': '5285988621',
                                                                                       'mac_address': 'b4:fb:e4:b8:e3:46',
                                                                                       'out_octets': '44732011248'},
                                                                               {       'in_octets': '1801791811',
                                                                                       'mac_address': 'b4:fb:e4:34:00:80',
                                                                                       'out_octets': '20765701803'},
                                                                               {       'in_octets': '30697291590',
                                                                                       'mac_address': 'b4:fb:e4:34:02:bf',
                                                                                       'out_octets': '205790050962'},
                                                                               {       'in_octets': '59541488179',
                                                                                       'mac_address': 'fc:ec:da:64:4e:3b',
                                                                                       'out_octets': '849573956562'},
                                                                               {       'in_octets': '20628182954',
                                                                                       'mac_address': 'fc:ec:da:64:50:76',
                                                                                       'out_octets': '152500723200'},
                                                                               {       'in_octets': '168137521205',
                                                                                       'mac_address': 'fc:ec:da:6c:e3:85',
                                                                                       'out_octets': '2866245431629'},
                                                                               {       'in_octets': '119967446914',
                                                                                       'mac_address': 'fc:ec:da:6c:e7:74',
                                                                                       'out_octets': '1426738774974'}],
                                                              'mac_address': '44:d9:e7:ae:71:f4',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2269448054',
                                                              'out_ucast_pkts': '2913246131',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5800,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1245955',
                                                                                                                                            'distance': 450,
                                                                                                                                            'mac_address': 'b4:fb:e4:aa:cb:d9',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'snr': 41.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1864203',
                                                                                                                                            'distance': 900,
                                                                                                                                            'mac_address': 'b4:fb:e4:b8:e3:46',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'snr': 43.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '358623',
                                                                                                                                            'distance': 1200,
                                                                                                                                            'mac_address': 'b4:fb:e4:34:00:80',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'snr': 45.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '4164830',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': 'b4:fb:e4:34:02:bf',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'snr': 40.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '4164842',
                                                                                                                                            'distance': 900,
                                                                                                                                            'mac_address': 'fc:ec:da:64:4e:3b',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'snr': 26.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '4164814',
                                                                                                                                            'distance': 3000,
                                                                                                                                            'mac_address': 'fc:ec:da:64:50:76',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'snr': 23.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '4164831',
                                                                                                                                            'distance': 1950,
                                                                                                                                            'mac_address': 'fc:ec:da:6c:e3:85',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'snr': 28.0},
                                                                                                                                    {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '1701421',
                                                                                                                                            'distance': 1200,
                                                                                                                                            'mac_address': 'fc:ec:da:6c:e7:74',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'snr': 35.0}],
                                                                                                                   'noise_floor': -94.0}],
                                                                                        'tx_power': 22}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ATS-Rapid '
                                                                                                 'Creek'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'LiteAP AC',
                                'sw_version': 'v8.5.11',
                                'system_mac_address': '44:d9:e7:ae:71:f4',
                                'temperature': 0.0,
                                'uptime': '15260643'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '260876214207',
                                                                       'links': [       {       'in_octets': '260876214207',
                                                                                                'mac_address': '44:d9:e7:ae:71:f4',
                                                                                                'out_octets': '12294216006'}],
                                                                       'mac_address': 'b4:fb:e4:aa:cb:d9',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '12294216006',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1245955',
                                                                                                                                                     'distance': 450,
                                                                                                                                                     'mac_address': '44:d9:e7:ae:71:f4'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATS-Rapid '
                                                                                                          'Creek'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '12294216006',
                                                                       'mac_address': 'b4:fb:e4:ab:cb:d9',
                                                                       'name': 'eth0',
                                                                       'out_octets': '260876214207'}],
                                         'management_ip': '100.101.19.199',
                                         'manufacturer': 'Ubiquiti',
                                         'name': ' Noel CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:aa:cb:d9'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '44732011248',
                                                                       'links': [       {       'in_octets': '44732011248',
                                                                                                'mac_address': '44:d9:e7:ae:71:f4',
                                                                                                'out_octets': '5285988621'}],
                                                                       'mac_address': 'b4:fb:e4:b8:e3:46',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '5285988621',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1864203',
                                                                                                                                                     'distance': 900,
                                                                                                                                                     'mac_address': '44:d9:e7:ae:71:f4'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATS-Rapid '
                                                                                                          'Creek'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '5285988621',
                                                                       'mac_address': 'b4:fb:e4:b9:e3:46',
                                                                       'name': 'eth0',
                                                                       'out_octets': '44732011248'}],
                                         'management_ip': '100.101.19.186',
                                         'manufacturer': 'Ubiquiti',
                                         'name': ' insert name CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:b8:e3:46'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '20765701803',
                                                                       'links': [       {       'in_octets': '20765701803',
                                                                                                'mac_address': '44:d9:e7:ae:71:f4',
                                                                                                'out_octets': '1801791811'}],
                                                                       'mac_address': 'b4:fb:e4:34:00:80',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1801791811',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '358623',
                                                                                                                                                     'distance': 1200,
                                                                                                                                                     'mac_address': '44:d9:e7:ae:71:f4'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATS-Rapid '
                                                                                                          'Creek'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '1801791811',
                                                                       'mac_address': 'b4:fb:e4:35:00:80',
                                                                       'name': 'eth0',
                                                                       'out_octets': '20765701803'}],
                                         'management_ip': '100.101.19.50',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Kyerra Higbee 397 CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:34:00:80'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '205790050962',
                                                                       'links': [       {       'in_octets': '205790050962',
                                                                                                'mac_address': '44:d9:e7:ae:71:f4',
                                                                                                'out_octets': '30697291590'}],
                                                                       'mac_address': 'b4:fb:e4:34:02:bf',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '30697291590',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4164830',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': '44:d9:e7:ae:71:f4'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATS-Rapid '
                                                                                                          'Creek'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '30697291590',
                                                                       'mac_address': 'b4:fb:e4:35:02:bf',
                                                                       'name': 'eth0',
                                                                       'out_octets': '205790050962'}],
                                         'management_ip': '100.101.19.52',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Leisha Brower 399 CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b4:fb:e4:34:02:bf'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '849573956562',
                                                                       'links': [       {       'in_octets': '849573956562',
                                                                                                'mac_address': '44:d9:e7:ae:71:f4',
                                                                                                'out_octets': '59541488179'}],
                                                                       'mac_address': 'fc:ec:da:64:4e:3b',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '59541488179',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4164842',
                                                                                                                                                     'distance': 900,
                                                                                                                                                     'mac_address': '44:d9:e7:ae:71:f4'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATS-Rapid '
                                                                                                          'Creek'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '59541488179',
                                                                       'mac_address': 'fc:ec:da:65:4e:3b',
                                                                       'name': 'eth0',
                                                                       'out_octets': '849573956562'}],
                                         'management_ip': '100.101.19.46',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Kolay Johnson CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:64:4e:3b'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '152500723200',
                                                                       'links': [       {       'in_octets': '152500723200',
                                                                                                'mac_address': '44:d9:e7:ae:71:f4',
                                                                                                'out_octets': '20628182954'}],
                                                                       'mac_address': 'fc:ec:da:64:50:76',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '20628182954',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4164814',
                                                                                                                                                     'distance': 3000,
                                                                                                                                                     'mac_address': '44:d9:e7:ae:71:f4'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATS-Rapid '
                                                                                                          'Creek'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '20628182954',
                                                                       'mac_address': 'fc:ec:da:65:50:76',
                                                                       'name': 'eth0',
                                                                       'out_octets': '152500723200'}],
                                         'management_ip': '100.101.19.54',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Dean Hazen CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:64:50:76'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '2866245431629',
                                                                       'links': [       {       'in_octets': '2866245431629',
                                                                                                'mac_address': '44:d9:e7:ae:71:f4',
                                                                                                'out_octets': '168137521205'}],
                                                                       'mac_address': 'fc:ec:da:6c:e3:85',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '168137521205',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4164831',
                                                                                                                                                     'distance': 1950,
                                                                                                                                                     'mac_address': '44:d9:e7:ae:71:f4'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATS-Rapid '
                                                                                                          'Creek'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '168137521205',
                                                                       'mac_address': 'fc:ec:da:6d:e3:85',
                                                                       'name': 'eth0',
                                                                       'out_octets': '2866245431629'}],
                                         'management_ip': '100.101.19.51',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'George Chandler #401 CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:6c:e3:85'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '1426738774974',
                                                                       'links': [       {       'in_octets': '1426738774974',
                                                                                                'mac_address': '44:d9:e7:ae:71:f4',
                                                                                                'out_octets': '119967446914'}],
                                                                       'mac_address': 'fc:ec:da:6c:e7:74',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '119967446914',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1701421',
                                                                                                                                                     'distance': 1200,
                                                                                                                                                     'mac_address': '44:d9:e7:ae:71:f4'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ATS-Rapid '
                                                                                                          'Creek'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '119967446914',
                                                                       'mac_address': 'fc:ec:da:6d:e7:74',
                                                                       'name': 'eth0',
                                                                       'out_octets': '1426738774974'}],
                                         'management_ip': '100.101.19.45',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Anderson #375 CPE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'fc:ec:da:6c:e7:74'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_LiteAP_AC_v8_5_12_01(self):
        obj = self.run_data("ubnt.airmax-ac.LiteAP AC.v8.5.12.01")
        exp_info = {
                'gps_sync': False,
                'model': 'LiteAP AC',
                'rf_chan_width': 20,
                'rf_freq': 5280,
                'rf_tx_power': 24,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.12',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 0.7,
                'cpu': 32.67,
                'dl_en_bytes': 3318988520,
                'dl_en_packets': 969328236,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3399846410,
                'dl_rf_packets': 967678134,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 2905000889,
                'ul_en_packets': 324271637,
                'ul_noise_floor': -93,
                'ul_rf_bytes': 2176823631,
                'ul_rf_packets': 320873711
        }
        exp_sta_stats = {
                '78:8a:20:aa:d4:ee': {       'alt_macs': ['78:8a:20:ab:d4:ee'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 91648162043,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '172.16.4.206',
                                             'mac_address': '78:8a:20:aa:d4:ee',
                                             'name': 'Myers, Kenzie PowerBeam M5 300',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -93,
                                             'ul_rf_bytes': 2249372303,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -38.0,
                                             'ul_snr': 55.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 32.67,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '54',
                                                              'in_nucast_pkts': '7334801',
                                                              'in_octets': '3318988520',
                                                              'in_ucast_pkts': '961993435',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '78:8a:20:6d:20:40',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2905000889',
                                                              'out_ucast_pkts': '324271637',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '2176823631',
                                                              'in_ucast_pkts': '320873711',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '2249372303',
                                                                                       'mac_address': '78:8a:20:aa:d4:ee',
                                                                                       'out_octets': '91648162043'}],
                                                              'mac_address': '78:8a:20:6c:20:40',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '130',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3399846410',
                                                              'out_ucast_pkts': '967678134',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5280,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'amc': 0.0,
                                                                                                                                            'amq': 0.0,
                                                                                                                                            'connected_time': '443500',
                                                                                                                                            'distance': 750,
                                                                                                                                            'mac_address': '78:8a:20:aa:d4:ee',
                                                                                                                                            'noise_floor': -93.0,
                                                                                                                                            'rssi': -38.0,
                                                                                                                                            'snr': 55.0}],
                                                                                                                   'noise_floor': -93.0}],
                                                                                        'tx_power': 24}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'DBM-CPOP-S120S'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'model': 'LiteAP AC',
                                'sw_version': 'v8.5.12',
                                'system_mac_address': '78:8a:20:6c:20:40',
                                'temperature': 0.0,
                                'uptime': '4677382'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'ath0',
                                                                       'in_octets': '91648162043',
                                                                       'links': [       {       'in_octets': '91648162043',
                                                                                                'mac_address': '78:8a:20:6c:20:40',
                                                                                                'out_octets': '2249372303'}],
                                                                       'mac_address': '78:8a:20:aa:d4:ee',
                                                                       'name': 'ath0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2249372303',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5280,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '443500',
                                                                                                                                                     'distance': 750,
                                                                                                                                                     'mac_address': '78:8a:20:6c:20:40'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'DBM-CPOP-S120S'}]},
                                                               {       'id': 'eth0',
                                                                       'in_octets': '2249372303',
                                                                       'mac_address': '78:8a:20:ab:d4:ee',
                                                                       'name': 'eth0',
                                                                       'out_octets': '91648162043'}],
                                         'management_ip': '172.16.4.206',
                                         'manufacturer': 'Ubiquiti',
                                         'name': 'Myers, Kenzie PowerBeam M5 300',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '78:8a:20:aa:d4:ee'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_LiteAP_AC_v8_5_12_02(self):
        obj = self.run_data("ubnt.airmax-ac.LiteAP AC.v8.5.12.02")
        exp_info = {
                'gps_sync': False,
                'model': 'LiteAP AC',
                'rf_chan_width': 40,
                'rf_freq': 5740,
                'rf_tx_power': 24,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.12',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 1.1,
                'cpu': 1.010101,
                'dl_en_bytes': 656978015,
                'dl_en_packets': 1168911886,
                'dl_noise_floor': None,
                'dl_rf_bytes': 751117046,
                'dl_rf_packets': 1167532295,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'temperature': None,
                'ul_en_bytes': 3829516179,
                'ul_en_packets': 710616095,
                'ul_noise_floor': None,
                'ul_rf_bytes': 819008788,
                'ul_rf_packets': 709370922
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.010101,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '4',
                                                              'in_nucast_pkts': '9015895',
                                                              'in_octets': '656978015',
                                                              'in_ucast_pkts': '1159895991',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'b4:fb:e4:5b:52:8a',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3829516179',
                                                              'out_ucast_pkts': '710616095',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '819008788',
                                                              'in_ucast_pkts': '709370922',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'b4:fb:e4:5a:52:8a',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': True,
                                                              'out_discards': '36',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '751117046',
                                                              'out_ucast_pkts': '1167532295',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 5740,
                                                                                        'gps_sync': False,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '240300000',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_link_rate': '53460000',
                                                                                        'tx_power': 24}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TekWav-Baer-0'}],
                                                              'speed': '0',
                                                              'type': 6}],
                                'manufacturer': 'Ubiquiti',
                                'mem': 71.423035,
                                'model': 'LiteAP AC',
                                'sw_version': 'v8.5.12',
                                'system_mac_address': 'b4:fb:e4:5a:52:8a',
                                'uptime': '1164013'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_airmax_ac_LiteAP_AC_v8_5_12_cs_01(self):
        obj = self.run_data("ubnt.airmax-ac.LiteAP AC.v8.5.12-cs.01")
        exp_info = {
                'gps_sync': False,
                'model': 'LiteAP AC',
                'rf_chan_width': 40,
                'rf_freq': 5815,
                'rf_tx_power': 24,
                'sta_count': 25,
                'sta_mode_cpe': False,
                'sw_version': 'v8.5.12-cs',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'airtime': 2.5,
                'cpu': 17.82,
                'dl_en_bytes': 3966380717,
                'dl_en_packets': 69530532,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1318097555,
                'dl_rf_packets': 141359529,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 0,
                'temperature': 0.0,
                'ul_en_bytes': 2330967597,
                'ul_en_packets': 2184685095,
                'ul_noise_floor': -95,
                'ul_rf_bytes': 735165423,
                'ul_rf_packets': 2251240508
        }
        exp_sta_stats = {
                '04:18:d6:34:9c:99': {       'alt_macs': ['04:18:d6:35:9c:99'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 477603105,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.214',
                                             'mac_address': '04:18:d6:34:9c:99',
                                             'name': 'Linda Heisler NB-19',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 128117461,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -47.0,
                                             'ul_snr': 48.0},
                '04:18:d6:52:c0:c7': {       'alt_macs': ['04:18:d6:53:c0:c7'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 105271549007,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.236',
                                             'mac_address': '04:18:d6:52:c0:c7',
                                             'name': 'Donald Jassowski NB-19',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 8268128078,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -76.0,
                                             'ul_snr': 19.0},
                '04:18:d6:52:c0:ce': {       'alt_macs': ['04:18:d6:53:c0:ce'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 31993628409,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.223',
                                             'mac_address': '04:18:d6:52:c0:ce',
                                             'name': 'Donna Dell NB-19',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 5319874217,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -51.0,
                                             'ul_snr': 44.0},
                '04:18:d6:5c:74:1b': {       'alt_macs': ['04:18:d6:5d:74:1b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 28718714705,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.234',
                                             'mac_address': '04:18:d6:5c:74:1b',
                                             'name': 'NB-16 E. Bledsoe',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 7815651435,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -51.0,
                                             'ul_snr': 44.0},
                '04:18:d6:5c:74:2b': {       'alt_macs': ['04:18:d6:5d:74:2b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 24526099813,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.230',
                                             'mac_address': '04:18:d6:5c:74:2b',
                                             'name': 'NB-16 J. Bledsoe',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 7024383315,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -48.0,
                                             'ul_snr': 47.0},
                '04:18:d6:5e:34:52': {       'alt_macs': ['04:18:d6:5f:34:52'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 133904716105,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.231',
                                             'mac_address': '04:18:d6:5e:34:52',
                                             'name': 'NB-16 Simmons',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 108378376493,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -54.0,
                                             'ul_snr': 41.0},
                '04:18:d6:5e:34:90': {       'alt_macs': ['04:18:d6:5f:34:90'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 25530956108,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.225',
                                             'mac_address': '04:18:d6:5e:34:90',
                                             'name': 'Dolan NB-16',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 10822628784,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -47.0,
                                             'ul_snr': 48.0},
                '04:18:d6:5e:34:ec': {       'alt_macs': ['04:18:d6:5f:34:ec'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 19844030071,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.226',
                                             'mac_address': '04:18:d6:5e:34:ec',
                                             'name': 'ken-turnquist NB16',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 2479347437,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -48.0,
                                             'ul_snr': 47.0},
                '04:18:d6:5e:35:d2': {       'alt_macs': ['04:18:d6:5f:35:d2'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 31292757030,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.224',
                                             'mac_address': '04:18:d6:5e:35:d2',
                                             'name': 'Conlon NB-16',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 3867235047,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -43.0,
                                             'ul_snr': 52.0},
                '04:18:d6:66:a5:ed': {       'alt_macs': ['04:18:d6:67:a5:ed'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 75531458371,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.229',
                                             'mac_address': '04:18:d6:66:a5:ed',
                                             'name': 'Seghesio-15020 Navarro Way',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 24185962078,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -74.0,
                                             'ul_snr': 21.0},
                '18:e8:29:3a:57:31': {       'alt_macs': ['18:e8:29:3b:57:31'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 30866948945,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.194',
                                             'mac_address': '18:e8:29:3a:57:31',
                                             'name': 'Karl Waidhofer P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 3519482841,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 33.0},
                '18:e8:29:3a:e4:37': {       'alt_macs': ['18:e8:29:3b:e4:37'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 175168192280,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.193',
                                             'mac_address': '18:e8:29:3a:e4:37',
                                             'name': 'Gary Klein L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 6099080576,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 38.0},
                '24:a4:3c:d6:28:1b': {       'alt_macs': ['24:a4:3c:d7:28:1b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 115186266168,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.233',
                                             'mac_address': '24:a4:3c:d6:28:1b',
                                             'name': 'Yeunsoon Jeung NB-19',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 9001453105,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -74.0,
                                             'ul_snr': 21.0},
                '44:d9:e7:7e:29:40': {       'alt_macs': ['44:d9:e7:7f:29:40'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 43201766733,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.227',
                                             'mac_address': '44:d9:e7:7e:29:40',
                                             'name': 'NB-16 Winters',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 3226340766,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -51.0,
                                             'ul_snr': 44.0},
                '44:d9:e7:b6:d4:ac': {       'alt_macs': ['44:d9:e7:b7:d4:ac'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 77836187977,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.219',
                                             'mac_address': '44:d9:e7:b6:d4:ac',
                                             'name': 'Miles Gordon LB5',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 21529258839,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 34.0},
                '44:d9:e7:b6:d6:24': {       'alt_macs': ['44:d9:e7:b7:d6:24'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 258530071313,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.218',
                                             'mac_address': '44:d9:e7:b6:d6:24',
                                             'name': 'Steven & Margaret Truter N5B',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 11266308131,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 33.0},
                '78:8a:20:62:23:cf': {       'alt_macs': ['78:8a:20:63:23:cf'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 413258803259,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.238',
                                             'mac_address': '78:8a:20:62:23:cf',
                                             'name': 'Omar Abdallah P5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 17839997941,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 34.0},
                '78:8a:20:62:6c:17': {       'alt_macs': ['78:8a:20:63:6c:17'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 35848980714,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.198',
                                             'mac_address': '78:8a:20:62:6c:17',
                                             'name': 'Jennifer Boehm N5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 6985437572,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -44.0,
                                             'ul_snr': 51.0},
                '80:2a:a8:bc:4b:c0': {       'alt_macs': ['80:2a:a8:bd:4b:c0'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 9062267761,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.215',
                                             'mac_address': '80:2a:a8:bc:4b:c0',
                                             'name': 'Robert Yazell LB5',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 78371470681,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -54.0,
                                             'ul_snr': 41.0},
                '80:2a:a8:ee:c0:ee': {       'alt_macs': ['80:2a:a8:ef:c0:ee'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 40509485480,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.217',
                                             'mac_address': '80:2a:a8:ee:c0:ee',
                                             'name': 'Tracy Sclar LB5',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 6959297794,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -74.0,
                                             'ul_snr': 21.0},
                'b4:fb:e4:32:f3:19': {       'alt_macs': ['b4:fb:e4:33:f3:19'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 104915762853,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.199',
                                             'mac_address': 'b4:fb:e4:32:f3:19',
                                             'name': 'Jonathan Funk L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 12307905815,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -45.0,
                                             'ul_snr': 50.0},
                'b4:fb:e4:32:f4:e6': {       'alt_macs': ['b4:fb:e4:33:f4:e6'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 223823009987,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.195',
                                             'mac_address': 'b4:fb:e4:32:f4:e6',
                                             'name': 'Sandra Moores L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 16568632060,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -35.0,
                                             'ul_snr': 60.0},
                'f0:9f:c2:4e:09:7c': {       'alt_macs': ['f0:9f:c2:4f:09:7c'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 22534464183,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.201',
                                             'mac_address': 'f0:9f:c2:4e:09:7c',
                                             'name': 'Michelle Strand L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 2844630646,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -43.0,
                                             'ul_snr': 52.0},
                'fc:ec:da:5c:27:dd': {       'alt_macs': ['fc:ec:da:5d:27:dd'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 98628865244,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.200',
                                             'mac_address': 'fc:ec:da:5c:27:dd',
                                             'name': 'Thomas Merline L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 28789422467,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -41.0,
                                             'ul_snr': 54.0},
                'fc:ec:da:ce:25:c7': {       'alt_macs': ['fc:ec:da:cf:25:c7'],
                                             'dev_macs': set(),
                                             'dl_link_rate': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 133143677189,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.6.93.196',
                                             'mac_address': 'fc:ec:da:ce:25:c7',
                                             'name': 'Diane Heinzer L5C',
                                             'temperature': None,
                                             'ul_link_rate': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 27686110940,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -44.0,
                                             'ul_snr': 51.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 17.82,
                                'errors': [{'http_connect': {}}],
                                'gps_sats_tracked': 0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '1',
                                                              'in_nucast_pkts': '12762597',
                                                              'in_octets': '3966380717',
                                                              'in_ucast_pkts': '56767935',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '44:d9:e7:cf:b5:46',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '19',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2330967597',
                                                              'out_ucast_pkts': '2184685095',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '735165423',
                                                              'in_ucast_pkts': '2251240508',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '6985437572',
                                                                                       'mac_address': '78:8a:20:62:6c:17',
                                                                                       'out_octets': '35848980714'},
                                                                               {       'in_octets': '17839997941',
                                                                                       'mac_address': '78:8a:20:62:23:cf',
                                                                                       'out_octets': '413258803259'},
                                                                               {       'in_octets': '78371470681',
                                                                                       'mac_address': '80:2a:a8:bc:4b:c0',
                                                                                       'out_octets': '9062267761'},
                                                                               {       'in_octets': '6959297794',
                                                                                       'mac_address': '80:2a:a8:ee:c0:ee',
                                                                                       'out_octets': '40509485480'},
                                                                               {       'in_octets': '12307905815',
                                                                                       'mac_address': 'b4:fb:e4:32:f3:19',
                                                                                       'out_octets': '104915762853'},
                                                                               {       'in_octets': '16568632060',
                                                                                       'mac_address': 'b4:fb:e4:32:f4:e6',
                                                                                       'out_octets': '223823009987'},
                                                                               {       'in_octets': '6099080576',
                                                                                       'mac_address': '18:e8:29:3a:e4:37',
                                                                                       'out_octets': '175168192280'},
                                                                               {       'in_octets': '3519482841',
                                                                                       'mac_address': '18:e8:29:3a:57:31',
                                                                                       'out_octets': '30866948945'},
                                                                               {       'in_octets': '2844630646',
                                                                                       'mac_address': 'f0:9f:c2:4e:09:7c',
                                                                                       'out_octets': '22534464183'},
                                                                               {       'in_octets': '27686110940',
                                                                                       'mac_address': 'fc:ec:da:ce:25:c7',
                                                                                       'out_octets': '133143677189'},
                                                                               {       'in_octets': '28789422467',
                                                                                       'mac_address': 'fc:ec:da:5c:27:dd',
                                                                                       'out_octets': '98628865244'},
                                                                               {       'in_octets': '9001453105',
                                                                                       'mac_address': '24:a4:3c:d6:28:1b',
                                                                                       'out_octets': '115186266168'},
                                                                               {       'in_octets': '24185962078',
                                                                                       'mac_address': '04:18:d6:66:a5:ed',
                                                                                       'out_octets': '75531458371'},
                                                                               {       'in_octets': '128117461',
                                                                                       'mac_address': '04:18:d6:34:9c:99',
                                                                                       'out_octets': '477603105'},
                                                                               {       'in_octets': '8268128078',
                                                                                       'mac_address': '04:18:d6:52:c0:c7',
                                                                                       'out_octets': '105271549007'},
                                                                               {       'in_octets': '5319874217',
                                                                                       'mac_address': '04:18:d6:52:c0:ce',
                                                                                       'out_octets': '31993628409'},
                                                                               {       'in_octets': '7815651435',
                                                                                       'mac_address': '04:18:d6:5c:74:1b',
                                                                                       'out_octets': '28718714705'},
                                                                               {       'in_octets': '7024383315',
                                                                                       'mac_address': '04:18:d6:5c:74:2b',
                                                                                       'out_octets': '24526099813'},
                                                                               {       'in_octets': '10822628784',
                                                                                       'mac_address': '04:18:d6:5e:34:90',
                                                                                       'out_octets': '25530956108'},
                                                                               {       'in_octets': '2479347437',
                                                                                       'mac_address': '04:18:d6:5e:34:ec',
                                                                                       'out_octets': '19844030071'},
                                                                               {       'in_octets': '108378376493',
                                                                                       'mac_address': '04:18:d6:5e:34:52',
                                                                                       'out_octets': '133904716105'},
                                                                               {       'in_octets': '3867235047',
                                                                                       'mac_address': '04:18:d6:5e:35:d2',
                                                                                       'out_octets': '31292757030'},
                                                                               {       'in_octets': '3226340766',
                                                                                       'mac_address': '44:d9:e7:7e:29:40',
                                                                                       'out_octets': '43201766733'},
                                                                               {       'in_octets': '21529258839',
                                                                                       'mac_address': '44:d9:e7:b6:d4:ac',
                                                                                       'out_octets': '77836187977'},
                                                                               {       'in_octets': '11266308131',
                                                                                       'mac_address': '44:d9:e7:b6:d6:24',
                                                                                       'out_octets': '258530071313'}],
                                                              'mac_address': '44:d9:e7:ce:b5:46',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'oper_up': T