import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):
    def test_axxcelera_ap_AP_3_8_11_2_01(self):
        obj = self.run_data("axxcelera.ap.AP.3.8.11.2.01")
        exp_info = {
         'model': 'AP', 'sta_count': 8, 'sw_version': '3.8.11.2', 'vendor': 'Axxcelera'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:10:6d:1c:b6:48': {       'dev_macs': {'a0:63:91:83:10:e9'},
                                             'ip_address': '192.168.14.75',
                                             'mac_address': '00:10:6d:1c:b6:48',
                                             'name': None},
                '00:10:6d:1d:5d:64': {       'dev_macs': {'c8:d7:19:4e:cb:34'},
                                             'ip_address': '192.168.14.80',
                                             'mac_address': '00:10:6d:1d:5d:64',
                                             'name': None},
                '00:10:6d:1d:80:a4': {       'dev_macs': {'8c:3b:ad:dd:91:c9'},
                                             'ip_address': '192.168.15.226',
                                             'mac_address': '00:10:6d:1d:80:a4',
                                             'name': None},
                '00:10:6d:1d:97:e0': {       'dev_macs': {'b4:fb:e4:27:5c:d8'},
                                             'ip_address': '192.168.14.28',
                                             'mac_address': '00:10:6d:1d:97:e0',
                                             'name': None},
                '00:10:6d:1d:98:f4': {       'dev_macs': {'e0:46:9a:39:18:a9'},
                                             'ip_address': '192.168.14.55',
                                             'mac_address': '00:10:6d:1d:98:f4',
                                             'name': None},
                '00:10:6d:1d:c6:74': {       'dev_macs': {'00:0e:08:42:94:7c'},
                                             'ip_address': '192.168.15.206',
                                             'mac_address': '00:10:6d:1d:c6:74',
                                             'name': None},
                '00:10:6d:1d:d1:28': {       'dev_macs': {'dc:ef:09:0b:e9:c1'},
                                             'ip_address': '192.168.14.82',
                                             'mac_address': '00:10:6d:1d:d1:28',
                                             'name': None},
                '00:10:6d:1d:e2:24': {       'dev_macs': {'f0:4d:a2:f1:08:94'},
                                             'ip_address': '192.168.15.94',
                                             'mac_address': '00:10:6d:1d:e2:24',
                                             'name': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '583454902',
                                                              'in_octets': '3296913161',
                                                              'in_ucast_pkts': '4091573577',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'brg0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '231212',
                                                              'out_octets': '3795020960',
                                                              'out_ucast_pkts': '2339051321',
                                                              'poller_hash': 'AQbRqHyB',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '265',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '231208',
                                                              'in_octets': '2918598117',
                                                              'in_ucast_pkts': '2335487719',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       'a0:63:91:83:10:e9'],
                                                                                       'mac_address': '00:10:6d:1c:b6:48'},
                                                                               {       'bridged_mac_addresses': [       '8c:3b:ad:dd:91:c9'],
                                                                                       'mac_address': '00:10:6d:1d:80:a4'},
                                                                               {       'bridged_mac_addresses': [       'b4:fb:e4:27:5c:d8'],
                                                                                       'mac_address': '00:10:6d:1d:97:e0'},
                                                                               {       'bridged_mac_addresses': [       'e0:46:9a:39:18:a9'],
                                                                                       'mac_address': '00:10:6d:1d:98:f4'},
                                                                               {       'bridged_mac_addresses': [       '00:0e:08:42:94:7c'],
                                                                                       'mac_address': '00:10:6d:1d:c6:74'},
                                                                               {       'bridged_mac_addresses': [       'dc:ef:09:0b:e9:c1'],
                                                                                       'mac_address': '00:10:6d:1d:d1:28'},
                                                                               {       'bridged_mac_addresses': [       'f0:4d:a2:f1:08:94'],
                                                                                       'mac_address': '00:10:6d:1d:e2:24'},
                                                                               {       'bridged_mac_addresses': [       'c8:d7:19:4e:cb:34'],
                                                                                       'mac_address': '00:10:6d:1d:5d:64'}],
                                                              'mac_address': '00:10:6d:1a:87:c8',
                                                              'mtu': 1500,
                                                              'name': 'brg1',
                                                              'oper_up': True,
                                                              'out_discards': '2009169',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '576990542',
                                                              'out_octets': '1069247160',
                                                              'out_ucast_pkts': '4086937126',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:10:6d:1c:b6:48'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:80:a4'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:97:e0'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:98:f4'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:c6:74'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:d1:28'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:e2:24'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:5d:64'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '100000000',
                                                              'type': 184}],
                                'manufacturer': 'Axxcelera',
                                'model': 'AP',
                                'poller_hash': 'ABBtGofI',
                                'sw_version': '3.8.11.2',
                                'system_mac_address': '00:10:6d:1a:87:c8',
                                'uptime': '7927656'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}],
                                                                       'mac_address': '00:10:6d:1c:b6:48',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.14.75',
                                         'poller_hash': 'ABBtHLZI',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}],
                                                                       'mac_address': '00:10:6d:1d:80:a4',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.15.226',
                                         'poller_hash': 'ABBtHYCk',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}],
                                                                       'mac_address': '00:10:6d:1d:97:e0',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.14.28',
                                         'poller_hash': 'ABBtHZfg',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}],
                                                                       'mac_address': '00:10:6d:1d:98:f4',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.14.55',
                                         'poller_hash': 'ABBtHZj0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}],
                                                                       'mac_address': '00:10:6d:1d:c6:74',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.15.206',
                                         'poller_hash': 'ABBtHcZ0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}],
                                                                       'mac_address': '00:10:6d:1d:d1:28',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.14.82',
                                         'poller_hash': 'ABBtHdEo',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}],
                                                                       'mac_address': '00:10:6d:1d:e2:24',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.15.94',
                                         'poller_hash': 'ABBtHeIk',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}],
                                                                       'mac_address': '00:10:6d:1d:5d:64',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:87:c8'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.14.80',
                                         'poller_hash': 'ABBtHV1k',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else 'imsi')
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_axxcelera_ap_AP_3_8_12_3_01(self):
        obj = self.run_data("axxcelera.ap.AP.3.8.12.3.01")
        exp_info = {
                'model': 'AP',
                'sta_count': 30,
                'sw_version': '3.8.12.3',
                'vendor': 'Axxcelera'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:10:6d:1d:2b:e8': {       'dev_macs': {'10:da:43:ab:0b:b9'},
                                             'ip_address': '192.168.12.246',
                                             'mac_address': '00:10:6d:1d:2b:e8',
                                             'name': None},
                '00:10:6d:1d:40:54': {       'dev_macs': set(),
                                             'ip_address': '192.168.13.16',
                                             'mac_address': '00:10:6d:1d:40:54',
                                             'name': None},
                '00:10:6d:1d:41:38': {       'dev_macs': {'f0:79:59:36:6d:68'},
                                             'ip_address': '192.168.13.49',
                                             'mac_address': '00:10:6d:1d:41:38',
                                             'name': None},
                '00:10:6d:1d:41:bc': {       'dev_macs': {'00:0e:08:40:2b:ba'},
                                             'ip_address': '192.168.12.30',
                                             'mac_address': '00:10:6d:1d:41:bc',
                                             'name': None},
                '00:10:6d:1d:4f:1c': {       'dev_macs': {'00:0e:08:2b:c0:0f'},
                                             'ip_address': '192.168.12.103',
                                             'mac_address': '00:10:6d:1d:4f:1c',
                                             'name': None},
                '00:10:6d:1d:52:58': {       'dev_macs': {'94:10:3e:fb:38:16'},
                                             'ip_address': '192.168.12.127',
                                             'mac_address': '00:10:6d:1d:52:58',
                                             'name': None},
                '00:10:6d:1d:53:50': {       'dev_macs': {'4c:60:de:44:c5:57'},
                                             'ip_address': '192.168.13.59',
                                             'mac_address': '00:10:6d:1d:53:50',
                                             'name': None},
                '00:10:6d:1d:57:dc': {       'dev_macs': {'dc:ef:09:e4:06:31'},
                                             'ip_address': '192.168.12.87',
                                             'mac_address': '00:10:6d:1d:57:dc',
                                             'name': None},
                '00:10:6d:1d:5a:b4': {       'dev_macs': {'20:4e:7f:40:84:bd'},
                                             'ip_address': '192.168.12.66',
                                             'mac_address': '00:10:6d:1d:5a:b4',
                                             'name': None},
                '00:10:6d:1d:5d:04': {       'dev_macs': set(),
                                             'ip_address': '192.168.12.76',
                                             'mac_address': '00:10:6d:1d:5d:04',
                                             'name': None},
                '00:10:6d:1d:79:c8': {       'dev_macs': {'44:94:fc:54:fa:f5'},
                                             'ip_address': '192.168.13.11',
                                             'mac_address': '00:10:6d:1d:79:c8',
                                             'name': None},
                '00:10:6d:1d:90:84': {       'dev_macs': {'00:0e:08:18:fe:49'},
                                             'ip_address': '192.168.12.160',
                                             'mac_address': '00:10:6d:1d:90:84',
                                             'name': None},
                '00:10:6d:1d:97:e8': {       'dev_macs': {'80:37:73:d8:33:a8'},
                                             'ip_address': '192.168.12.134',
                                             'mac_address': '00:10:6d:1d:97:e8',
                                             'name': None},
                '00:10:6d:1d:98:18': {       'dev_macs': {'a0:04:60:18:0c:8b'},
                                             'ip_address': '192.168.12.178',
                                             'mac_address': '00:10:6d:1d:98:18',
                                             'name': None},
                '00:10:6d:1d:98:78': {       'dev_macs': {'48:f8:b3:e2:8e:df'},
                                             'ip_address': '192.168.12.125',
                                             'mac_address': '00:10:6d:1d:98:78',
                                             'name': None},
                '00:10:6d:1d:98:ec': {       'dev_macs': {'c0:3f:0e:03:35:bb'},
                                             'ip_address': '192.168.12.123',
                                             'mac_address': '00:10:6d:1d:98:ec',
                                             'name': None},
                '00:10:6d:1d:98:f0': {       'dev_macs': set(),
                                             'ip_address': '192.168.12.107',
                                             'mac_address': '00:10:6d:1d:98:f0',
                                             'name': None},
                '00:10:6d:1d:99:c0': {       'dev_macs': {'20:4e:7f:a4:e1:63'},
                                             'ip_address': '192.168.12.45',
                                             'mac_address': '00:10:6d:1d:99:c0',
                                             'name': None},
                '00:10:6d:1d:9a:54': {       'dev_macs': {'14:91:82:29:4e:1b'},
                                             'ip_address': '192.168.12.29',
                                             'mac_address': '00:10:6d:1d:9a:54',
                                             'name': None},
                '00:10:6d:1d:ad:c4': {       'dev_macs': {'20:0c:c8:23:6f:e0'},
                                             'ip_address': '192.168.13.32',
                                             'mac_address': '00:10:6d:1d:ad:c4',
                                             'name': None},
                '00:10:6d:1d:c4:58': {       'dev_macs': {'00:0e:08:4e:cf:f8'},
                                             'ip_address': '192.168.12.22',
                                             'mac_address': '00:10:6d:1d:c4:58',
                                             'name': None},
                '00:10:6d:1d:c6:f0': {       'dev_macs': {'84:c9:b2:68:08:7f'},
                                             'ip_address': '192.168.12.170',
                                             'mac_address': '00:10:6d:1d:c6:f0',
                                             'name': None},
                '00:10:6d:1d:c7:98': {       'dev_macs': {'dc:ef:09:b4:67:8c'},
                                             'ip_address': '192.168.13.58',
                                             'mac_address': '00:10:6d:1d:c7:98',
                                             'name': None},
                '00:10:6d:1d:d1:34': {       'dev_macs': {'1c:7e:e5:30:dc:35'},
                                             'ip_address': '192.168.13.44',
                                             'mac_address': '00:10:6d:1d:d1:34',
                                             'name': None},
                '00:10:6d:1d:d4:6c': {       'dev_macs': {'00:0e:08:2d:b4:4f'},
                                             'ip_address': '192.168.12.94',
                                             'mac_address': '00:10:6d:1d:d4:6c',
                                             'name': None},
                '00:10:6d:1d:d5:98': {       'dev_macs': {'08:02:8e:d2:be:48'},
                                             'ip_address': '192.168.12.144',
                                             'mac_address': '00:10:6d:1d:d5:98',
                                             'name': None},
                '00:10:6d:1d:d6:14': {       'dev_macs': {       '54:2b:57:17:4b:7c',
                                                                 '54:2b:57:25:2d:0e',
                                                                 '54:2b:57:25:36:68',
                                                                 '54:2b:57:25:65:a8',
                                                                 '54:2b:57:25:66:90',
                                                                 '54:2b:57:25:8e:be',
                                                                 '54:2b:57:25:8e:d1',
                                                                 '54:2b:57:25:d0:1e'},
                                             'ip_address': '192.168.13.60',
                                             'mac_address': '00:10:6d:1d:d6:14',
                                             'name': None},
                '00:10:6d:1d:d8:cc': {       'dev_macs': {'00:23:69:14:98:75'},
                                             'ip_address': '192.168.12.101',
                                             'mac_address': '00:10:6d:1d:d8:cc',
                                             'name': None},
                '00:10:6d:1d:db:ec': {       'dev_macs': {'cc:40:d0:ad:84:20'},
                                             'ip_address': '192.168.12.113',
                                             'mac_address': '00:10:6d:1d:db:ec',
                                             'name': None},
                '00:10:6d:1d:e3:54': {       'dev_macs': {'4c:bb:58:92:5e:e9'},
                                             'ip_address': '192.168.12.207',
                                             'mac_address': '00:10:6d:1d:e3:54',
                                             'name': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '514037239',
                                                              'in_octets': '3596709061',
                                                              'in_ucast_pkts': '1586199169',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'brg0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '39388744',
                                                              'out_octets': '2936509739',
                                                              'out_ucast_pkts': '3030350852',
                                                              'poller_hash': 'AQbRdM/B',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '39388735',
                                                              'in_octets': '3605002660',
                                                              'in_ucast_pkts': '3015442530',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '44:94:fc:54:fa:f5'],
                                                                                       'mac_address': '00:10:6d:1d:79:c8'},
                                                                               {       'bridged_mac_addresses': [       '00:0e:08:18:fe:49'],
                                                                                       'mac_address': '00:10:6d:1d:90:84'},
                                                                               {       'bridged_mac_addresses': [       '80:37:73:d8:33:a8'],
                                                                                       'mac_address': '00:10:6d:1d:97:e8'},
                                                                               {       'bridged_mac_addresses': [       '48:f8:b3:e2:8e:df'],
                                                                                       'mac_address': '00:10:6d:1d:98:78'},
                                                                               {       'bridged_mac_addresses': [       'c0:3f:0e:03:35:bb'],
                                                                                       'mac_address': '00:10:6d:1d:98:ec'},
                                                                               {       'bridged_mac_addresses': [       'a0:04:60:18:0c:8b'],
                                                                                       'mac_address': '00:10:6d:1d:98:18'},
                                                                               {       'mac_address': '00:10:6d:1d:98:f0'},
                                                                               {       'bridged_mac_addresses': [       '20:4e:7f:a4:e1:63'],
                                                                                       'mac_address': '00:10:6d:1d:99:c0'},
                                                                               {       'bridged_mac_addresses': [       '14:91:82:29:4e:1b'],
                                                                                       'mac_address': '00:10:6d:1d:9a:54'},
                                                                               {       'bridged_mac_addresses': [       '20:0c:c8:23:6f:e0'],
                                                                                       'mac_address': '00:10:6d:1d:ad:c4'},
                                                                               {       'bridged_mac_addresses': [       '00:0e:08:4e:cf:f8'],
                                                                                       'mac_address': '00:10:6d:1d:c4:58'},
                                                                               {       'bridged_mac_addresses': [       '84:c9:b2:68:08:7f'],
                                                                                       'mac_address': '00:10:6d:1d:c6:f0'},
                                                                               {       'bridged_mac_addresses': [       'dc:ef:09:b4:67:8c'],
                                                                                       'mac_address': '00:10:6d:1d:c7:98'},
                                                                               {       'bridged_mac_addresses': [       '1c:7e:e5:30:dc:35'],
                                                                                       'mac_address': '00:10:6d:1d:d1:34'},
                                                                               {       'bridged_mac_addresses': [       '00:0e:08:2d:b4:4f'],
                                                                                       'mac_address': '00:10:6d:1d:d4:6c'},
                                                                               {       'bridged_mac_addresses': [       '08:02:8e:d2:be:48'],
                                                                                       'mac_address': '00:10:6d:1d:d5:98'},
                                                                               {       'bridged_mac_addresses': [       '54:2b:57:17:4b:7c',
                                                                                                                        '54:2b:57:25:2d:0e',
                                                                                                                        '54:2b:57:25:36:68',
                                                                                                                        '54:2b:57:25:65:a8',
                                                                                                                        '54:2b:57:25:66:90',
                                                                                                                        '54:2b:57:25:8e:be',
                                                                                                                        '54:2b:57:25:8e:d1',
                                                                                                                        '54:2b:57:25:d0:1e'],
                                                                                       'mac_address': '00:10:6d:1d:d6:14'},
                                                                               {       'bridged_mac_addresses': [       '00:23:69:14:98:75'],
                                                                                       'mac_address': '00:10:6d:1d:d8:cc'},
                                                                               {       'bridged_mac_addresses': [       'cc:40:d0:ad:84:20'],
                                                                                       'mac_address': '00:10:6d:1d:db:ec'},
                                                                               {       'bridged_mac_addresses': [       '4c:bb:58:92:5e:e9'],
                                                                                       'mac_address': '00:10:6d:1d:e3:54'},
                                                                               {       'bridged_mac_addresses': [       '10:da:43:ab:0b:b9'],
                                                                                       'mac_address': '00:10:6d:1d:2b:e8'},
                                                                               {       'mac_address': '00:10:6d:1d:40:54'},
                                                                               {       'bridged_mac_addresses': [       '00:0e:08:40:2b:ba'],
                                                                                       'mac_address': '00:10:6d:1d:41:bc'},
                                                                               {       'bridged_mac_addresses': [       'f0:79:59:36:6d:68'],
                                                                                       'mac_address': '00:10:6d:1d:41:38'},
                                                                               {       'bridged_mac_addresses': [       '00:0e:08:2b:c0:0f'],
                                                                                       'mac_address': '00:10:6d:1d:4f:1c'},
                                                                               {       'bridged_mac_addresses': [       '94:10:3e:fb:38:16'],
                                                                                       'mac_address': '00:10:6d:1d:52:58'},
                                                                               {       'bridged_mac_addresses': [       '4c:60:de:44:c5:57'],
                                                                                       'mac_address': '00:10:6d:1d:53:50'},
                                                                               {       'bridged_mac_addresses': [       'dc:ef:09:e4:06:31'],
                                                                                       'mac_address': '00:10:6d:1d:57:dc'},
                                                                               {       'bridged_mac_addresses': [       '20:4e:7f:40:84:bd'],
                                                                                       'mac_address': '00:10:6d:1d:5a:b4'},
                                                                               {       'mac_address': '00:10:6d:1d:5d:04'}],
                                                              'mac_address': '00:10:6d:17:4c:fc',
                                                              'mtu': 1500,
                                                              'name': 'brg1',
                                                              'oper_up': True,
                                                              'out_discards': '9166261',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '482986683',
                                                              'out_octets': '3396873919',
                                                              'out_ucast_pkts': '1569014183',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:10:6d:1d:79:c8'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:90:84'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:97:e8'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:98:78'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:98:ec'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:98:18'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:98:f0'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:99:c0'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:9a:54'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:ad:c4'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:c4:58'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:c6:f0'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:c7:98'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:d1:34'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:d4:6c'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:d5:98'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:d6:14'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:d8:cc'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:db:ec'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:e3:54'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:2b:e8'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:40:54'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:41:bc'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:41:38'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:4f:1c'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:52:58'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:53:50'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:57:dc'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:5a:b4'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:5d:04'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '100000000',
                                                              'type': 184}],
                                'manufacturer': 'Axxcelera',
                                'model': 'AP',
                                'poller_hash': 'ABBtF0z8',
                                'sw_version': '3.8.12.3',
                                'system_mac_address': '00:10:6d:17:4c:fc',
                                'uptime': '38938820'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:79:c8',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.13.11',
                                         'poller_hash': 'ABBtHXnI',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:90:84',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.160',
                                         'poller_hash': 'ABBtHZCE',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:97:e8',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.134',
                                         'poller_hash': 'ABBtHZfo',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:98:78',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.125',
                                         'poller_hash': 'ABBtHZh4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:98:ec',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.123',
                                         'poller_hash': 'ABBtHZjs',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:98:18',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.178',
                                         'poller_hash': 'ABBtHZgY',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:98:f0',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.107',
                                         'poller_hash': 'ABBtHZjw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:99:c0',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.45',
                                         'poller_hash': 'ABBtHZnA',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:9a:54',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.29',
                                         'poller_hash': 'ABBtHZpU',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:ad:c4',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.13.32',
                                         'poller_hash': 'ABBtHa3E',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:c4:58',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.22',
                                         'poller_hash': 'ABBtHcRY',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:c6:f0',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.170',
                                         'poller_hash': 'ABBtHcbw',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:c7:98',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.13.58',
                                         'poller_hash': 'ABBtHceY',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:d1:34',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.13.44',
                                         'poller_hash': 'ABBtHdE0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:d4:6c',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.94',
                                         'poller_hash': 'ABBtHdRs',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:d5:98',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.144',
                                         'poller_hash': 'ABBtHdWY',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:d6:14',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.13.60',
                                         'poller_hash': 'ABBtHdYU',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:d8:cc',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.101',
                                         'poller_hash': 'ABBtHdjM',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:db:ec',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.113',
                                         'poller_hash': 'ABBtHdvs',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:e3:54',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.207',
                                         'poller_hash': 'ABBtHeNU',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:2b:e8',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.246',
                                         'poller_hash': 'ABBtHSvo',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:40:54',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.13.16',
                                         'poller_hash': 'ABBtHUBU',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:41:bc',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.30',
                                         'poller_hash': 'ABBtHUG8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:41:38',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.13.49',
                                         'poller_hash': 'ABBtHUE4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:4f:1c',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.103',
                                         'poller_hash': 'ABBtHU8c',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:52:58',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.127',
                                         'poller_hash': 'ABBtHVJY',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:53:50',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.13.59',
                                         'poller_hash': 'ABBtHVNQ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:57:dc',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.87',
                                         'poller_hash': 'ABBtHVfc',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:5a:b4',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.66',
                                         'poller_hash': 'ABBtHVq0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}],
                                                                       'mac_address': '00:10:6d:1d:5d:04',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:17:4c:fc'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.12.76',
                                         'poller_hash': 'ABBtHV0E',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else 'imsi')
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_axxcelera_ap_AP_3_8_13_1_01(self):
        obj = self.run_data("axxcelera.ap.AP.3.8.13.1.01")
        exp_info = {
                'model': 'AP',
                'sta_count': 22,
                'sw_version': '3.8.13.1',
                'vendor': 'Axxcelera'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '00:10:6d:1c:b0:64': {       'dev_macs': {'00:0e:08:40:2b:b7'},
                                             'ip_address': '192.168.26.27',
                                             'mac_address': '00:10:6d:1c:b0:64',
                                             'name': None},
                '00:10:6d:1c:b4:ec': {       'dev_macs': {'00:21:91:d3:4f:32'},
                                             'ip_address': '192.168.26.88',
                                             'mac_address': '00:10:6d:1c:b4:ec',
                                             'name': None},
                '00:10:6d:1d:31:c4': {       'dev_macs': {'98:da:c4:03:45:7d'},
                                             'ip_address': '192.168.26.98',
                                             'mac_address': '00:10:6d:1d:31:c4',
                                             'name': None},
                '00:10:6d:1d:34:c4': {       'dev_macs': {'00:18:e7:da:b3:78'},
                                             'ip_address': '192.168.26.117',
                                             'mac_address': '00:10:6d:1d:34:c4',
                                             'name': None},
                '00:10:6d:1d:42:e0': {       'dev_macs': {'30:23:03:6c:f2:42'},
                                             'ip_address': '192.168.26.63',
                                             'mac_address': '00:10:6d:1d:42:e0',
                                             'name': None},
                '00:10:6d:1d:48:b8': {       'dev_macs': {'a0:63:91:9b:6b:11'},
                                             'ip_address': '192.168.26.34',
                                             'mac_address': '00:10:6d:1d:48:b8',
                                             'name': None},
                '00:10:6d:1d:4b:f8': {       'dev_macs': {'b4:75:0e:67:61:c7'},
                                             'ip_address': '192.168.26.60',
                                             'mac_address': '00:10:6d:1d:4b:f8',
                                             'name': None},
                '00:10:6d:1d:53:0c': {       'dev_macs': {'00:0e:08:2e:a8:85'},
                                             'ip_address': '192.168.26.48',
                                             'mac_address': '00:10:6d:1d:53:0c',
                                             'name': None},
                '00:10:6d:1d:88:40': {       'dev_macs': {'00:0e:08:4e:cf:fd'},
                                             'ip_address': '192.168.26.80',
                                             'mac_address': '00:10:6d:1d:88:40',
                                             'name': None},
                '00:10:6d:1d:8d:54': {       'dev_macs': {'c4:6e:1f:4b:49:97'},
                                             'ip_address': '192.168.26.55',
                                             'mac_address': '00:10:6d:1d:8d:54',
                                             'name': None},
                '00:10:6d:1d:90:90': {       'dev_macs': {'04:a1:51:d6:1e:96'},
                                             'ip_address': '192.168.26.32',
                                             'mac_address': '00:10:6d:1d:90:90',
                                             'name': None},
                '00:10:6d:1d:92:ac': {       'dev_macs': {'04:a1:51:24:a1:04'},
                                             'ip_address': '192.168.26.82',
                                             'mac_address': '00:10:6d:1d:92:ac',
                                             'name': None},
                '00:10:6d:1d:9e:10': {       'dev_macs': {'14:91:82:f3:82:3f'},
                                             'ip_address': '192.168.26.66',
                                             'mac_address': '00:10:6d:1d:9e:10',
                                             'name': None},
                '00:10:6d:1d:c4:48': {       'dev_macs': {'d0:67:e5:3c:46:ab'},
                                             'ip_address': '192.168.26.123',
                                             'mac_address': '00:10:6d:1d:c4:48',
                                             'name': None},
                '00:10:6d:1d:c9:00': {       'dev_macs': {'c8:b3:73:26:cb:ef'},
                                             'ip_address': '192.168.26.21',
                                             'mac_address': '00:10:6d:1d:c9:00',
                                             'name': None},
                '00:10:6d:1d:cb:58': {       'dev_macs': {'14:91:82:5f:c4:d3'},
                                             'ip_address': '192.168.26.149',
                                             'mac_address': '00:10:6d:1d:cb:58',
                                             'name': None},
                '00:10:6d:1d:cb:ec': {       'dev_macs': {'04:a1:51:94:17:cd'},
                                             'ip_address': '192.168.26.53',
                                             'mac_address': '00:10:6d:1d:cb:ec',
                                             'name': None},
                '00:10:6d:1d:cf:fc': {       'dev_macs': {'20:e5:2a:64:5f:73'},
                                             'ip_address': '192.168.26.28',
                                             'mac_address': '00:10:6d:1d:cf:fc',
                                             'name': None},
                '00:10:6d:1d:d6:34': {       'dev_macs': {'00:16:41:6c:3d:b8'},
                                             'ip_address': '192.168.26.72',
                                             'mac_address': '00:10:6d:1d:d6:34',
                                             'name': None},
                '00:10:6d:1d:dc:04': {       'dev_macs': {'dc:ef:09:97:6f:04'},
                                             'ip_address': '192.168.26.84',
                                             'mac_address': '00:10:6d:1d:dc:04',
                                             'name': None},
                '00:10:6d:1d:dc:bc': {       'dev_macs': {'00:1e:e5:b6:df:fd'},
                                             'ip_address': '192.168.26.91',
                                             'mac_address': '00:10:6d:1d:dc:bc',
                                             'name': None},
                '00:10:6d:1d:dc:d4': {       'dev_macs': {'c8:d7:19:a5:7b:61'},
                                             'ip_address': '192.168.26.44',
                                             'mac_address': '00:10:6d:1d:dc:d4',
                                             'name': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '342887605',
                                                              'in_octets': '2312001935',
                                                              'in_ucast_pkts': '2000503451',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'brg0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '9251820',
                                                              'out_octets': '2323578978',
                                                              'out_ucast_pkts': '2278215243',
                                                              'poller_hash': 'AQbRqKGB',
                                                              'speed': '100000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '192',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '9251816',
                                                              'in_octets': '2462694868',
                                                              'in_ucast_pkts': '2259538622',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '00:0e:08:40:2b:b7'],
                                                                                       'mac_address': '00:10:6d:1c:b0:64'},
                                                                               {       'bridged_mac_addresses': [       '00:21:91:d3:4f:32'],
                                                                                       'mac_address': '00:10:6d:1c:b4:ec'},
                                                                               {       'bridged_mac_addresses': [       '00:0e:08:4e:cf:fd'],
                                                                                       'mac_address': '00:10:6d:1d:88:40'},
                                                                               {       'bridged_mac_addresses': [       'c4:6e:1f:4b:49:97'],
                                                                                       'mac_address': '00:10:6d:1d:8d:54'},
                                                                               {       'bridged_mac_addresses': [       '04:a1:51:d6:1e:96'],
                                                                                       'mac_address': '00:10:6d:1d:90:90'},
                                                                               {       'bridged_mac_addresses': [       '04:a1:51:24:a1:04'],
                                                                                       'mac_address': '00:10:6d:1d:92:ac'},
                                                                               {       'bridged_mac_addresses': [       '14:91:82:f3:82:3f'],
                                                                                       'mac_address': '00:10:6d:1d:9e:10'},
                                                                               {       'bridged_mac_addresses': [       'd0:67:e5:3c:46:ab'],
                                                                                       'mac_address': '00:10:6d:1d:c4:48'},
                                                                               {       'bridged_mac_addresses': [       'c8:b3:73:26:cb:ef'],
                                                                                       'mac_address': '00:10:6d:1d:c9:00'},
                                                                               {       'bridged_mac_addresses': [       '04:a1:51:94:17:cd'],
                                                                                       'mac_address': '00:10:6d:1d:cb:ec'},
                                                                               {       'bridged_mac_addresses': [       '14:91:82:5f:c4:d3'],
                                                                                       'mac_address': '00:10:6d:1d:cb:58'},
                                                                               {       'bridged_mac_addresses': [       '20:e5:2a:64:5f:73'],
                                                                                       'mac_address': '00:10:6d:1d:cf:fc'},
                                                                               {       'bridged_mac_addresses': [       '00:16:41:6c:3d:b8'],
                                                                                       'mac_address': '00:10:6d:1d:d6:34'},
                                                                               {       'bridged_mac_addresses': [       '00:1e:e5:b6:df:fd'],
                                                                                       'mac_address': '00:10:6d:1d:dc:bc'},
                                                                               {       'bridged_mac_addresses': [       'c8:d7:19:a5:7b:61'],
                                                                                       'mac_address': '00:10:6d:1d:dc:d4'},
                                                                               {       'bridged_mac_addresses': [       'dc:ef:09:97:6f:04'],
                                                                                       'mac_address': '00:10:6d:1d:dc:04'},
                                                                               {       'bridged_mac_addresses': [       '98:da:c4:03:45:7d'],
                                                                                       'mac_address': '00:10:6d:1d:31:c4'},
                                                                               {       'bridged_mac_addresses': [       '00:18:e7:da:b3:78'],
                                                                                       'mac_address': '00:10:6d:1d:34:c4'},
                                                                               {       'bridged_mac_addresses': [       '30:23:03:6c:f2:42'],
                                                                                       'mac_address': '00:10:6d:1d:42:e0'},
                                                                               {       'bridged_mac_addresses': [       'a0:63:91:9b:6b:11'],
                                                                                       'mac_address': '00:10:6d:1d:48:b8'},
                                                                               {       'bridged_mac_addresses': [       'b4:75:0e:67:61:c7'],
                                                                                       'mac_address': '00:10:6d:1d:4b:f8'},
                                                                               {       'bridged_mac_addresses': [       '00:0e:08:2e:a8:85'],
                                                                                       'mac_address': '00:10:6d:1d:53:0c'}],
                                                              'mac_address': '00:10:6d:1a:8a:18',
                                                              'mtu': 1500,
                                                              'name': 'brg1',
                                                              'oper_up': True,
                                                              'out_discards': '11804510',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '302396247',
                                                              'out_octets': '3839259407',
                                                              'out_ucast_pkts': '1980959517',
                                                              'radios': [       {       'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:10:6d:1c:b0:64'},
                                                                                                                                    {       'mac_address': '00:10:6d:1c:b4:ec'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:88:40'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:8d:54'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:90:90'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:92:ac'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:9e:10'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:c4:48'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:c9:00'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:cb:ec'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:cb:58'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:cf:fc'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:d6:34'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:dc:bc'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:dc:d4'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:dc:04'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:31:c4'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:34:c4'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:42:e0'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:48:b8'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:4b:f8'},
                                                                                                                                    {       'mac_address': '00:10:6d:1d:53:0c'}]}]}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'speed': '100000000',
                                                              'type': 184}],
                                'manufacturer': 'Axxcelera',
                                'model': 'AP',
                                'poller_hash': 'ABBtGooY',
                                'sw_version': '3.8.13.1',
                                'system_mac_address': '00:10:6d:1a:8a:18',
                                'uptime': '8093931'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1c:b0:64',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.27',
                                         'poller_hash': 'ABBtHLBk',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1c:b4:ec',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.88',
                                         'poller_hash': 'ABBtHLTs',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:88:40',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.80',
                                         'poller_hash': 'ABBtHYhA',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:8d:54',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.55',
                                         'poller_hash': 'ABBtHY1U',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:90:90',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.32',
                                         'poller_hash': 'ABBtHZCQ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:92:ac',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.82',
                                         'poller_hash': 'ABBtHZKs',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:9e:10',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.66',
                                         'poller_hash': 'ABBtHZ4Q',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:c4:48',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.123',
                                         'poller_hash': 'ABBtHcRI',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:c9:00',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.21',
                                         'poller_hash': 'ABBtHckA',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:cb:ec',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.53',
                                         'poller_hash': 'ABBtHcvs',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:cb:58',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.149',
                                         'poller_hash': 'ABBtHctY',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:cf:fc',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.28',
                                         'poller_hash': 'ABBtHc/8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:d6:34',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.72',
                                         'poller_hash': 'ABBtHdY0',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:dc:bc',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.91',
                                         'poller_hash': 'ABBtHdy8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:dc:d4',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.44',
                                         'poller_hash': 'ABBtHdzU',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:dc:04',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.84',
                                         'poller_hash': 'ABBtHdwE',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:31:c4',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.98',
                                         'poller_hash': 'ABBtHTHE',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:34:c4',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.117',
                                         'poller_hash': 'ABBtHTTE',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:42:e0',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.63',
                                         'poller_hash': 'ABBtHULg',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:48:b8',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.34',
                                         'poller_hash': 'ABBtHUi4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:4b:f8',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.60',
                                         'poller_hash': 'ABBtHUv4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}],
                                                                       'mac_address': '00:10:6d:1d:53:0c',
                                                                       'name': 'Radio '
                                                                               'port',
                                                                       'oper_up': True,
                                                                       'radios': [       {       'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:10:6d:1a:8a:18'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '192.168.26.48',
                                         'poller_hash': 'ABBtHVMM',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else 'imsi')
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
