import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestRadioStats(DeviceTestCase):

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_0_3_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.0.3.01")
        exp_info = {
            'model': 'UFiber OLT4',
            'rf_tx_power': None,
            'sta_count': 2,
            'sw_version': '4.0.3',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_auth': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT4',
                'sw_version': '4.0.3'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.0.5.01")
        exp_info = {
            'model': 'UFiber OLT4',
            'rf_tx_power': None,
            'sta_count': 12,
            'sw_version': '4.0.5',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_auth': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT4',
                'sw_version': '4.0.5'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_1_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.1.0.01")
        exp_info = {
            'model': 'UFiber OLT4',
            'rf_tx_power': None,
            'sta_count': 42,
            'sw_version': '4.1.0',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_auth': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT4',
                'sw_version': '4.1.0'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.0.5.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 105,
            'sw_version': '4.0.5',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_auth': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT',
                'sw_version': '4.0.5'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_1_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.1.0.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 63,
            'sw_version': '4.1.0',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': None}
        exp_sta_stats = {}
        exp_ne_msg = {
            'data': {
                'errors': [{
                    'http_auth': {}
                }],
                'manufacturer': 'Ubiquiti',
                'model': 'UFiber OLT',
                'sw_version': '4.1.0'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_4_8_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.4.8.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 243,
            'sw_version': '4.4.8',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 30}
        exp_sta_stats = {
            '18:e8:29:0b:7a:b8': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:7a:b8',
                'name': 'Diana Escarcega - 94943'
            },
            '18:e8:29:0b:7b:20': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:7b:20',
                'name': 'VMartinez-83158'
            },
            '18:e8:29:0b:96:5c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:96:5c',
                'name': 'GWilcox-96157'
            },
            '18:e8:29:0b:97:64': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:97:64',
                'name': 'PRiley-94133'
            },
            '18:e8:29:0b:97:90': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:97:90',
                'name': 'Levi Lunsford (Barn) - 92832'
            },
            '18:e8:29:0b:99:6c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:99:6c',
                'name': 'TexasPanhandleLogistics-94290'
            },
            '18:e8:29:0b:9b:d8': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:9b:d8',
                'name': "Mario's Heating and Air "
                'Conditioning - 85808'
            },
            '18:e8:29:0b:ad:cc': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:ad:cc',
                'name': '605DaqShack-96050'
            },
            '18:e8:29:0b:ae:04': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:ae:04',
                'name': 'PMedina-95333'
            },
            '18:e8:29:0b:ae:0c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:ae:0c',
                'name': 'JPerez-95045'
            },
            '18:e8:29:0b:ae:68': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:ae:68',
                'name': 'Armando Prieto - 94883'
            },
            '18:e8:29:0b:ae:9c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:ae:9c',
                'name': 'KRamirez - 94442'
            },
            '18:e8:29:0b:af:08': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:af:08',
                'name': 'JCastillo-95065'
            },
            '18:e8:29:0b:b0:3c': {
                'dev_macs': ['c0:ea:e4:8b:e8:41'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:3c',
                'name': 'WBEquipment-76404'
            },
            '18:e8:29:0b:b0:50': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:50',
                'name': 'PBradley-94852'
            },
            '18:e8:29:0b:b0:74': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:74',
                'name': 'JAguero-95502'
            },
            '18:e8:29:0b:b0:78': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:78',
                'name': 'BScottJr -94888'
            },
            '18:e8:29:0b:b0:a4': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:a4',
                'name': 'OQuintana-94823'
            },
            '18:e8:29:0b:b0:c4': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:c4',
                'name': 'DPrieto-94861'
            },
            '18:e8:29:0b:b0:d0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:d0',
                'name': 'ESaenz-95379'
            },
            '18:e8:29:0b:b0:d8': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:d8',
                'name': 'IDeLaCruz-95739'
            },
            '18:e8:29:0b:b0:e0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b0:e0',
                'name': 'BGriswold-96935'
            },
            '18:e8:29:0b:d9:f8': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:d9:f8',
                'name': 'DGoldsmith-95707'
            },
            '18:e8:29:0b:db:28': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:db:28',
                'name': 'AMartinez - 94229'
            },
            '18:e8:29:0b:db:e0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:db:e0',
                'name': 'ADaniel-96546'
            },
            '18:e8:29:0b:dc:68': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:dc:68',
                'name': 'VLopez-96059'
            },
            '18:e8:29:0b:e0:b0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:e0:b0',
                'name': 'GVasquez-90370'
            },
            '18:e8:29:0b:e1:60': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:0b:e1:60',
                'name': 'HBonilla - 96429'
            },
            '18:e8:29:19:5a:82': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:5a:82',
                'name': 'CGregory-83114'
            },
            '18:e8:29:19:5a:c3': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:5a:c3',
                'name': 'RMartinezSr-83350'
            },
            '18:e8:29:19:5a:c8': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:5a:c8',
                'name': 'AMalapady-83057'
            },
            '18:e8:29:19:5e:d8': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:5e:d8',
                'name': 'DangFineTrucking-82660'
            },
            '18:e8:29:19:5e:f6': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:5e:f6',
                'name': 'RGwinn - 83131'
            },
            '18:e8:29:19:5e:fb': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:5e:fb',
                'name': 'ZPrice-83277'
            },
            '18:e8:29:19:5f:00': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:5f:00',
                'name': 'SchafferCommunityCenter-83330'
            },
            '18:e8:29:19:81:24': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:81:24',
                'name': 'SKinser-81531'
            },
            '18:e8:29:19:81:29': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:81:29',
                'name': 'ONavarro-76397'
            },
            '18:e8:29:19:ae:24': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:ae:24',
                'name': 'JFlynt-81277'
            },
            '18:e8:29:19:b4:5a': {
                'dev_macs': ['18:b1:69:b1:59:d1'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b4:5a',
                'name': 'HigginbothamBrothers-80554'
            },
            '18:e8:29:19:b4:a0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:b4:a0',
                'name': 'KAljoe-81385'
            },
            '18:e8:29:19:b4:a5': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:b4:a5',
                'name': 'COkamoto-81278'
            },
            '18:e8:29:19:b4:af': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:b4:af',
                'name': 'CRivera-76079'
            },
            '18:e8:29:19:b4:e6': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:b4:e6',
                'name': 'MFlores-81129'
            },
            '18:e8:29:19:b4:eb': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:19:b4:eb',
                'name': 'ANino_85173'
            },
            '18:e8:29:f5:d3:cd': {
                'dev_macs': ['cc:9c:3e:50:b4:eb'],
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d3:cd',
                'name': 'Happy State Bank-88420'
            },
            '18:e8:29:f5:d3:d4': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d3:d4',
                'name': 'LAlvarez-90544'
            },
            '18:e8:29:f5:d4:0f': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d4:0f',
                'name': 'JMcLean-88569'
            },
            '18:e8:29:f5:d4:77': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d4:77',
                'name': 'NSantellano-87956'
            },
            '18:e8:29:f5:d4:be': {
                'dev_macs': ['3c:ec:ef:6f:29:ce', '3c:ec:ef:6f:30:21'],
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d4:be',
                'name': 'FirstUnitedBankDimmitt-76416'
            },
            '18:e8:29:f5:d4:f6': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d4:f6',
                'name': 'RMcDaniel-88515'
            },
            '18:e8:29:f5:d4:fb': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d4:fb',
                'name': 'DBall-88672'
            },
            '18:e8:29:f5:d4:fc': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d4:fc',
                'name': 'JHunkins-88542'
            },
            '18:e8:29:f5:d4:fe': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '18:e8:29:f5:d4:fe',
                'name': 'SOltivero-88505'
            },
            '68:d7:9a:06:49:c6': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '68:d7:9a:06:49:c6',
                'name': 'JLeal-90888'
            },
            '68:d7:9a:06:67:a9': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '68:d7:9a:06:67:a9',
                'name': 'DProffitt-96297'
            },
            '68:d7:9a:06:67:b9': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '68:d7:9a:06:67:b9',
                'name': 'EHernandez-90300'
            },
            '68:d7:9a:06:67:bd': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '68:d7:9a:06:67:bd',
                'name': 'BHernandez-90268'
            },
            '68:d7:9a:06:80:3d': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '68:d7:9a:06:80:3d',
                'name': 'KProffitt-96064'
            },
            '68:d7:9a:06:80:c0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '68:d7:9a:06:80:c0',
                'name': 'CornerPlace-91104'
            },
            '68:d7:9a:06:82:3e': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '68:d7:9a:06:82:3e',
                'name': 'ATrevino-94079'
            },
            '68:d7:9a:06:8d:7d': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '68:d7:9a:06:8d:7d',
                'name': 'LQuiroz-91118'
            },
            '70:a7:41:33:44:44': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '70:a7:41:33:44:44',
                'name': 'IVela-94386'
            },
            '70:a7:41:33:45:5c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '70:a7:41:33:45:5c',
                'name': 'JRedman-96785'
            },
            '70:a7:41:33:46:14': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '70:a7:41:33:46:14',
                'name': 'MThacker-96834'
            },
            '70:a7:41:33:46:e0': {
                'dev_macs': ['04:d5:90:5f:5b:b5'],
                'ip_address': None,
                'mac_address': '70:a7:41:33:46:e0',
                'name': 'Castro County Nursing & '
                'Rehabilitation-80864'
            },
            '70:a7:41:33:46:ec': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '70:a7:41:33:46:ec',
                'name': 'RHunter-96872'
            },
            '70:a7:41:33:47:04': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '70:a7:41:33:47:04',
                'name': 'FMendoza-96851'
            },
            '70:a7:41:33:47:38': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '70:a7:41:33:47:38',
                'name': 'BlueSkyFarms-96500'
            },
            '74:83:c2:43:ec:24': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:ec:24',
                'name': 'JBaker-84690'
            },
            '74:83:c2:43:ec:2e': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:ec:2e',
                'name': 'KGauna-84769'
            },
            '74:83:c2:43:ec:64': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:ec:64',
                'name': 'GReyes-84703'
            },
            '74:83:c2:43:ec:8b': {
                'dev_macs': ['18:b1:69:38:8e:d1'],
                'ip_address': None,
                'mac_address': '74:83:c2:43:ec:8b',
                'name': 'DPharmacy-84631'
            },
            '74:83:c2:43:ed:ae': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:ed:ae',
                'name': 'AJones-87307'
            },
            '74:83:c2:43:f5:32': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f5:32',
                'name': 'MPena-86308'
            },
            '74:83:c2:43:f5:51': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f5:51',
                'name': 'CVasquez-88941'
            },
            '74:83:c2:43:f5:69': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f5:69',
                'name': 'VSteffens - 91882'
            },
            '74:83:c2:43:f5:85': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f5:85',
                'name': 'DUnderwood-83151'
            },
            '74:83:c2:43:f5:8a': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f5:8a',
                'name': 'RSilva-86688'
            },
            '74:83:c2:43:f5:9a': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f5:9a',
                'name': 'EGonzalez-88846'
            },
            '74:83:c2:43:f6:28': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f6:28',
                'name': 'SSkinner-86381'
            },
            '74:83:c2:43:f6:50': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f6:50',
                'name': 'JonRiddle-78067'
            },
            '74:83:c2:43:f6:5d': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f6:5d',
                'name': 'RBonilla-87432'
            },
            '74:83:c2:43:f6:85': {
                'dev_macs': ['50:c7:bf:39:2b:19'],
                'ip_address': None,
                'mac_address': '74:83:c2:43:f6:85',
                'name': 'Bi-Wize-75953'
            },
            '74:83:c2:43:f6:c0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f6:c0',
                'name': 'AOrtega-94516'
            },
            '74:83:c2:43:f7:f9': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f7:f9',
                'name': 'MRios-79846'
            },
            '74:83:c2:43:f7:fb': {
                'dev_macs':
                ['00:d8:61:6c:ea:87', '10:62:e5:1a:6c:1c', 'ac:1f:6b:49:69:77'],
                'ip_address': None,
                'mac_address': '74:83:c2:43:f7:fb',
                'name': 'Lowes10-86941'
            },
            '74:83:c2:43:f8:19': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f8:19',
                'name': 'AMontelongo-85907'
            },
            '74:83:c2:43:f9:ce': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f9:ce',
                'name': 'JRamos-86516'
            },
            '74:83:c2:43:f9:f1': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:43:f9:f1',
                'name': 'CLuna-87700'
            },
            '74:83:c2:68:29:d5': {
                'dev_macs': ['6c:cd:d6:0f:d2:0b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:29:d5',
                'name': 'KRushing-90930'
            },
            '74:83:c2:68:35:41': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:35:41',
                'name': 'JSullivan-85036'
            },
            '74:83:c2:68:35:62': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:35:62',
                'name': 'DJackson-85588'
            },
            '74:83:c2:68:36:4c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:36:4c',
                'name': 'MRodriguez-85077'
            },
            '74:83:c2:68:99:8e': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:99:8e',
                'name': 'ORivera-89002'
            },
            '74:83:c2:68:99:e8': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:99:e8',
                'name': 'JBell-95810'
            },
            '74:83:c2:68:99:ec': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:99:ec',
                'name': 'ASanchez-89093'
            },
            '74:83:c2:68:9a:06': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:9a:06',
                'name': 'RGonzalez-88892'
            },
            '74:83:c2:68:af:a2': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:af:a2',
                'name': 'CastroCountyNews - 34313'
            },
            '74:83:c2:68:af:b6': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:af:b6',
                'name': 'SAguero-91330'
            },
            '74:83:c2:68:b1:7c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:b1:7c',
                'name': 'MGardo-91431'
            },
            '74:83:c2:68:b1:8f': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:b1:8f',
                'name': 'DReinart-96211'
            },
            '74:83:c2:68:b2:04': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:b2:04',
                'name': 'CFinck-95040'
            },
            '74:83:c2:68:c4:fc': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:c4:fc',
                'name': 'MEnriquez-89562 '
            },
            '74:83:c2:68:c5:85': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:c5:85',
                'name': 'DimmittFirstAssemblyOfGod-89678'
            },
            '74:83:c2:68:c5:90': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:c5:90',
                'name': 'JGarcia-89164'
            },
            '74:83:c2:68:c5:a9': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:c5:a9',
                'name': 'BovineDiagnostics-89256'
            },
            '74:83:c2:68:c5:f2': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:c5:f2',
                'name': 'AVidal-89682'
            },
            '74:83:c2:68:c6:48': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:c6:48',
                'name': 'MFavela-89741'
            },
            '74:83:c2:68:c6:54': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:68:c6:54',
                'name': 'JSaenz_89769'
            },
            '74:83:c2:f0:c9:48': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:83:c2:f0:c9:48',
                'name': 'MFlores - 95127'
            },
            '74:ac:b9:06:73:1b': {
                'dev_macs': [],
                'ip_address': None,
                'mac_address': '74:ac:b9:06:73:1b',
                'name': 'Velocity/HigginbothamBrothers-96609'
            },
            '74:ac:b9:06:7a:96': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:ac:b9:06:7a:96',
                'name': 'SOrtiz-89888'
            },
            '74:ac:b9:06:7a:9a': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:ac:b9:06:7a:9a',
                'name': 'CAlag-90013'
            },
            '74:ac:b9:06:7a:a1': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:ac:b9:06:7a:a1',
                'name': 'KBlack-90729'
            },
            '74:ac:b9:06:7a:a2': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:ac:b9:06:7a:a2',
                'name': 'SCorona-95911'
            },
            '74:ac:b9:06:7a:a4': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:ac:b9:06:7a:a4',
                'name': 'SEOntiveros-91061'
            },
            '74:ac:b9:06:a0:c4': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:ac:b9:06:a0:c4',
                'name': 'AAcevedo-88266'
            },
            '74:ac:b9:06:a2:d1': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '74:ac:b9:06:a2:d1',
                'name': 'ZMcCasland-90591'
            },
            '78:45:58:06:24:a7': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:24:a7',
                'name': 'L&A.Silva-78575 '
            },
            '78:45:58:06:27:26': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:27:26',
                'name': 'DNelson -92671'
            },
            '78:45:58:06:27:7d': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:27:7d',
                'name': 'MRichardson-92770'
            },
            '78:45:58:06:27:89': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:27:89',
                'name': 'DOntiveros-92624'
            },
            '78:45:58:06:27:8f': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:27:8f',
                'name': 'AVilllareal-91955'
            },
            '78:45:58:06:27:ad': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:27:ad',
                'name': 'Evolve Nutrition - 92144'
            },
            '78:45:58:06:27:b5': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:27:b5',
                'name': 'AMartinez-91301'
            },
            '78:45:58:06:27:b7': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:27:b7',
                'name': 'BConyers-92189'
            },
            '78:45:58:06:28:0f': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:28:0f',
                'name': 'REnriquez-91457'
            },
            '78:45:58:06:28:74': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:28:74',
                'name': 'LCleveland-82159'
            },
            '78:45:58:06:28:78': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:28:78',
                'name': 'SCarpio-96066'
            },
            '78:45:58:06:28:e0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:28:e0',
                'name': 'Dimmitt Motel-92675'
            },
            '78:45:58:06:29:31': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:06:29:31',
                'name': 'RCadena-92934'
            },
            '78:45:58:9a:53:28': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:9a:53:28',
                'name': 'Salina’s Salon-96068'
            },
            '78:45:58:9a:59:f0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:9a:59:f0',
                'name': 'BlueSkyFarmsDBA-93136'
            },
            '78:45:58:9a:5b:40': {
                'dev_macs': ['18:fd:74:18:2e:22'],
                'ip_address': None,
                'mac_address': '78:45:58:9a:5b:40',
                'name': 'City of Dimmitt Police Annex '
                '-93658'
            },
            '78:45:58:9a:fd:4c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:9a:fd:4c',
                'name': 'VLeal-96351'
            },
            '78:45:58:9a:fd:54': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:45:58:9a:fd:54',
                'name': 'FMartinez - 95735'
            },
            '78:8a:20:73:d0:4d': {
                'dev_macs': ['00:04:56:13:8d:81'],
                'ip_address': None,
                'mac_address': '78:8a:20:73:d0:4d',
                'name': 'SealesByWalkingG-96794'
            },
            '78:8a:20:c0:41:36': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:8a:20:c0:41:36',
                'name': 'VCaballero-79486'
            },
            '78:8a:20:c0:44:24': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': '78:8a:20:c0:44:24',
                'name': 'LLunsford-77627'
            },
            '78:8a:20:c0:57:ed': {
                'dev_macs': ['b8:69:f4:57:75:bf'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:57:ed',
                'name': 'NutrienOffice-76414'
            },
            'b4:fb:e4:79:34:35': {
                'dev_macs': ['74:4d:28:54:fb:ec'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:34:35',
                'name': 'PebsworthInsurance-79365'
            },
            'b4:fb:e4:79:34:49': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:34:49',
                'name': 'CPriest-96257'
            },
            'b4:fb:e4:79:34:76': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:34:76',
                'name': 'KSherman-81988'
            },
            'b4:fb:e4:79:35:07': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:35:07',
                'name': 'FUMCParsonage1-81672(temp '
                'inactive)'
            },
            'b4:fb:e4:79:35:3e': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:35:3e',
                'name': 'SusieBradford-81855'
            },
            'b4:fb:e4:79:35:43': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:35:43',
                'name': 'LGarcia-76691'
            },
            'b4:fb:e4:79:38:13': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:38:13',
                'name': 'SNavarro-82075'
            },
            'b4:fb:e4:79:38:90': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:38:90',
                'name': 'JMedrano-81783'
            },
            'b4:fb:e4:79:39:3f': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:39:3f',
                'name': 'Stampede-92676'
            },
            'b4:fb:e4:79:39:8a': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:39:8a',
                'name': 'PHerrera-92802'
            },
            'b4:fb:e4:79:3b:b5': {
                'dev_macs': ['c4:ad:34:cf:b9:4e'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:3b:b5',
                'name': 'CityofDimmittUtilityWarehouse-87769'
            },
            'b4:fb:e4:79:5f:14': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:79:5f:14',
                'name': 'BKinser-78424'
            },
            'b4:fb:e4:e6:83:0e': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:83:0e',
                'name': 'SSanchez-80453'
            },
            'b4:fb:e4:e6:ac:a3': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:ac:a3',
                'name': 'ESilva-76504'
            },
            'b4:fb:e4:e6:b4:5f': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:b4:5f',
                'name': 'GSnitker-76623'
            },
            'b4:fb:e4:e6:c4:a9': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:c4:a9',
                'name': 'MOviedo-84381'
            },
            'b4:fb:e4:e6:c5:1c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:c5:1c',
                'name': 'MNavarro-83232'
            },
            'b4:fb:e4:e6:c5:62': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:c5:62',
                'name': 'EChavez-84336'
            },
            'b4:fb:e4:e6:cf:25': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:cf:25',
                'name': 'BBQ2Go-95462'
            },
            'b4:fb:e4:e6:cf:36': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:cf:36',
                'name': 'BConyers-82662'
            },
            'b4:fb:e4:e6:cf:3f': {
                'dev_macs':
                ['00:90:7f:dd:9b:47', '00:a0:c8:85:cb:4b', 'c0:06:c3:c9:8e:96'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:cf:3f',
                'name': 'CastroCountyJail-83479'
            },
            'b4:fb:e4:e6:cf:57': {
                'dev_macs': ['08:55:31:6d:ed:bd'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:cf:57',
                'name': 'CityOfDimmittFireDept-89380'
            },
            'b4:fb:e4:e6:cf:58': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:cf:58',
                'name': 'FBruegel-78174'
            },
            'b4:fb:e4:e6:d7:38': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:d7:38',
                'name': 'SBuckley-82199'
            },
            'b4:fb:e4:e6:d7:3c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:d7:3c',
                'name': 'JPena-82158'
            },
            'b4:fb:e4:e6:df:2b': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:df:2b',
                'name': 'LCase-94834'
            },
            'b4:fb:e4:e6:df:42': {
                'dev_macs': ['74:4d:28:9d:46:d0'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:df:42',
                'name': 'RSchaffer-76804'
            },
            'b4:fb:e4:e6:e1:ed': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e1:ed',
                'name': 'BAcker-82354'
            },
            'b4:fb:e4:e6:e1:fb': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e1:fb',
                'name': 'MLaura-79980'
            },
            'b4:fb:e4:e6:e2:12': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e2:12',
                'name': 'EPresas-77993'
            },
            'b4:fb:e4:e6:e2:9a': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e2:9a',
                'name': 'KPaxton-76553'
            },
            'b4:fb:e4:f9:28:9b': {
                'dev_macs': ['00:01:21:2f:0a:e4'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:28:9b',
                'name': 'FrontierCapitol-76456'
            },
            'b4:fb:e4:f9:4d:03': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:4d:03',
                'name': 'ATorres-87599'
            },
            'b4:fb:e4:f9:4d:7b': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:4d:7b',
                'name': 'DSwingburn-86309'
            },
            'b4:fb:e4:f9:4f:0b': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:4f:0b',
                'name': 'LMonreal-80925'
            },
            'b4:fb:e4:f9:4f:1a': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:4f:1a',
                'name': 'L&CBradley-76457'
            },
            'b4:fb:e4:f9:4f:24': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:4f:24',
                'name': 'DBuckley-86490'
            },
            'b4:fb:e4:f9:4f:51': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:4f:51',
                'name': 'POrtiz-79058'
            },
            'b4:fb:e4:f9:4f:e7': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:4f:e7',
                'name': 'ModernCarpet-78079'
            },
            'b4:fb:e4:f9:50:3c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:50:3c',
                'name': 'CGilbreath-76809'
            },
            'b4:fb:e4:f9:53:25': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:53:25',
                'name': 'CVandiver-80251'
            },
            'b4:fb:e4:f9:53:5c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:53:5c',
                'name': 'MLytle-77547'
            },
            'b4:fb:e4:f9:53:61': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:53:61',
                'name': 'ScottSheffy-76556'
            },
            'b4:fb:e4:f9:53:8e': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:53:8e',
                'name': 'CNeinast-80149'
            },
            'b4:fb:e4:f9:53:9d': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:53:9d',
                'name': 'DEspinosa-78795'
            },
            'b4:fb:e4:f9:53:a2': {
                'dev_macs': [
                    '74:4d:28:55:19:2e', '74:4d:28:bb:a0:1a', '74:4d:28:bb:b5:02',
                    'ec:13:b2:91:09:a2'
                ],
                'ip_address':
                None,
                'mac_address':
                'b4:fb:e4:f9:53:a2',
                'name':
                'TheMavrickontheSquare-92535'
            },
            'b4:fb:e4:f9:54:f6': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:54:f6',
                'name': 'HJeter-79483'
            },
            'b4:fb:e4:f9:55:32': {
                'dev_macs': ['b8:69:f4:57:79:07'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:55:32',
                'name': 'NutrienWeighStation-79513 '
            },
            'b4:fb:e4:f9:55:a0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:55:a0',
                'name': 'AGallegos-91213'
            },
            'b4:fb:e4:f9:57:94': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:57:94',
                'name': 'HighwayAutoGlass-77130'
            },
            'b4:fb:e4:f9:db:38': {
                'dev_macs': ['00:01:21:46:42:08'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:db:38',
                'name': 'CastroCountyCourtHouse-83475'
            },
            'b4:fb:e4:f9:dc:14': {
                'dev_macs': ['00:90:7f:01:ac:16'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:dc:14',
                'name': 'CastroCountyExtensionOffice - '
                '83481'
            },
            'b4:fb:e4:f9:dc:c8': {
                'dev_macs': ['00:01:21:28:bf:ac'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:dc:c8',
                'name': "Gary'sEngine&Machine-83276"
            },
            'b4:fb:e4:f9:dd:04': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'b4:fb:e4:f9:dd:04',
                'name': 'LDennis-86492'
            },
            'd0:21:f9:06:17:f4': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'd0:21:f9:06:17:f4',
                'name': 'JRodriguez-86428'
            },
            'd0:21:f9:06:1f:64': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'd0:21:f9:06:1f:64',
                'name': 'LJurado-93847'
            },
            'd0:21:f9:9a:83:48': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:83:48',
                'name': 'DProffitt PC-96299'
            },
            'd0:21:f9:9a:84:40': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:84:40',
                'name': 'Nick Lara - 82090'
            },
            'd0:21:f9:9a:84:6c': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:84:6c',
                'name': 'ExtremeDetailing-82089'
            },
            'd0:21:f9:9a:85:34': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:85:34',
                'name': 'TLeinen-96516'
            },
            'd0:21:f9:9a:85:a0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:85:a0',
                'name': 'JEmerson-77700'
            },
            'd0:21:f9:9a:a5:30': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:a5:30',
                'name': 'Sonic-90402'
            },
            'd0:21:f9:9a:a5:c0': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:a5:c0',
                'name': 'FTaylor-96291'
            },
            'f4:92:bf:06:26:db': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:26:db',
                'name': 'DimmitFeed-76493'
            },
            'f4:92:bf:06:40:11': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:40:11',
                'name': 'CAnes-91096'
            },
            'f4:92:bf:06:42:47': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:42:47',
                'name': 'BudHillFeedlots-92644'
            },
            'f4:92:bf:06:4a:c6': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:4a:c6',
                'name': 'MPuente-91050'
            },
            'f4:92:bf:06:4b:55': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:4b:55',
                'name': 'EGonzalez-92231'
            },
            'f4:92:bf:06:4b:59': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:4b:59',
                'name': 'JEnriquez-91069'
            },
            'f4:92:bf:06:4b:e1': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:4b:e1',
                'name': 'ANavarro-91082'
            },
            'f4:92:bf:06:e3:c5': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e3:c5',
                'name': 'LGrand-92803'
            },
            'f4:92:bf:06:e4:d2': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e4:d2',
                'name': 'JCastillo - 93331'
            },
            'f4:92:bf:06:ec:71': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:ec:71',
                'name': 'DFisher-94176'
            },
            'f4:92:bf:06:ec:90': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:ec:90',
                'name': 'RGauna - 93421'
            },
            'f4:92:bf:06:f2:8f': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f2:8f',
                'name': 'RMartinez - 94393'
            },
            'f4:92:bf:06:f3:e4': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f3:e4',
                'name': 'SSheffy-93345'
            },
            'f4:92:bf:06:f4:26': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f4:26',
                'name': 'JVillarreal-93379'
            },
            'f4:92:bf:06:fe:f8': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:fe:f8',
                'name': 'ColonialFuneralHome-82084'
            },
            'fc:ec:da:e0:f2:62': {
                'dev_macs': ['08:55:31:57:7f:84', '48:f8:b3:bc:ed:cb'],
                'ip_address': None,
                'mac_address': 'fc:ec:da:e0:f2:62',
                'name': 'CCAbstractTitle-85531'
            },
            'fc:ec:da:eb:95:10': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'fc:ec:da:eb:95:10',
                'name': 'BDrennan-83726'
            },
            'fc:ec:da:eb:95:33': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'fc:ec:da:eb:95:33',
                'name': 'MaryALane-84333'
            },
            'fc:ec:da:eb:95:6a': {
                'dev_macs': ['04:a1:51:90:a7:f8'],
                'ip_address': None,
                'mac_address': 'fc:ec:da:eb:95:6a',
                'name': 'CastroCountyLibrary-83485'
            },
            'fc:ec:da:eb:9b:cd': {
                'dev_macs': [],
                'ip_address': None,
                'mac_address': 'fc:ec:da:eb:9b:cd',
                'name': 'CastroCountyRoss-83484'
            },
            'fc:ec:da:eb:f1:72': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'fc:ec:da:eb:f1:72',
                'name': 'TWidick-85679'
            },
            'fc:ec:da:eb:f9:fb': {
                'dev_macs': None,
                'ip_address': None,
                'mac_address': 'fc:ec:da:eb:f9:fb',
                'name': 'JHinjosa-85795'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                30.0,
                'interfaces': [{
                    'admin_up': True,
                    'id': 'eth0',
                    'name': 'MGMT',
                    'oper_up': True,
                    'poller_hash': 'Nzg4YTIwMGQ3NTdlZXRoMGludGY=',
                    'speed': '1000000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon1',
                    'in_errors':
                    '0',
                    'in_octets':
                    '6502605190861',
                    'in_ucast_pkts':
                    '24999574741',
                    'links': [{
                        'bridged_mac_addresses': ['b8:69:f4:57:75:bf'],
                        'in_octets': '179849551975',
                        'out_octets': '638956727639',
                        'poller_hash': 'Nzg4YTIwYzA1N2VkcGVlcmludGY='
                    }, {
                        'in_octets': '14085184931',
                        'out_octets': '108035893022',
                        'poller_hash': 'MThlODI5MGJhZGNjcGVlcmludGY='
                    }, {
                        'in_octets': '27114768126',
                        'out_octets': '420422245790',
                        'poller_hash': 'MThlODI5MGJhZTBjcGVlcmludGY='
                    }, {
                        'in_octets': '724992',
                        'out_octets': '889910',
                        'poller_hash': 'MThlODI5MTk1ZWQ4cGVlcmludGY='
                    }, {
                        'in_octets': '3618395657',
                        'out_octets': '226224681865',
                        'poller_hash': 'NzBhNzQxMzM0NjE0cGVlcmludGY='
                    }, {
                        'in_octets': '19453255895',
                        'out_octets': '643741211987',
                        'poller_hash': 'NzBhNzQxMzM0NzA0cGVlcmludGY='
                    }, {
                        'in_octets': '3779497855',
                        'out_octets': '43749674446',
                        'poller_hash': 'Nzg0NTU4MDYyN2FkcGVlcmludGY='
                    }, {
                        'in_octets': '9426014032',
                        'out_octets': '86070300007',
                        'poller_hash': 'NjhkNzlhMDY4MGMwcGVlcmludGY='
                    }, {
                        'in_octets': '8050419182',
                        'out_octets': '208093027582',
                        'poller_hash': 'NzRhY2I5MDY3YWEycGVlcmludGY='
                    }, {
                        'in_octets': '87290701862',
                        'out_octets': '59257439890',
                        'poller_hash': 'ZjQ5MmJmMDYyNmRicGVlcmludGY='
                    }, {
                        'in_octets': '15461302098',
                        'out_octets': '542132930745',
                        'poller_hash': 'ZjQ5MmJmMDZlYzkwcGVlcmludGY='
                    }, {
                        'in_octets': '41377528576',
                        'out_octets': '1206183795600',
                        'poller_hash': 'ZjQ5MmJmMDZmNDI2cGVlcmludGY='
                    }, {
                        'in_octets': '40910398644',
                        'out_octets': '1868780133360',
                        'poller_hash': 'ZmNlY2RhZWJmOWZicGVlcmludGY='
                    }, {
                        'in_octets': '44679978425',
                        'out_octets': '2145749122952',
                        'poller_hash': 'YjRmYmU0NzkzNDQ5cGVlcmludGY='
                    }, {
                        'in_octets': '125842620753',
                        'out_octets': '953788902578',
                        'poller_hash': 'YjRmYmU0NzkzODEzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c4:ad:34:cf:b9:4e'],
                        'in_octets': '8245931261',
                        'out_octets': '58090936365',
                        'poller_hash': 'YjRmYmU0NzkzYmI1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['00:90:7f:dd:9b:47', '00:a0:c8:85:cb:4b', 'c0:06:c3:c9:8e:96'],
                        'in_octets':
                        '1251800419593',
                        'out_octets':
                        '9141049979702',
                        'poller_hash':
                        'YjRmYmU0ZTZjZjNmcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['b8:69:f4:57:79:07'],
                        'in_octets': '55763109025',
                        'out_octets': '252653365066',
                        'poller_hash': 'YjRmYmU0Zjk1NTMycGVlcmludGY='
                    }, {
                        'in_octets': '1804895322',
                        'out_octets': '38407107231',
                        'poller_hash': 'YjRmYmU0Zjk1Nzk0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:01:21:28:bf:ac'],
                        'in_octets': '1717409162210',
                        'out_octets': '963132757240',
                        'poller_hash': 'YjRmYmU0ZjlkY2M4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon1',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '63517437709816',
                    'out_ucast_pkts':
                    '55584956540',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uMWludGY=',
                    'pons': [{
                        'id':
                        '1',
                        'links': [{
                            'connected_time': '8211832',
                            'fiber_length': 1320,
                            'poller_hash': 'Nzg4YTIwYzA1N2VkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10285398',
                            'fiber_length': 1516,
                            'poller_hash': 'MThlODI5MGJhZGNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1894960',
                            'fiber_length': 7048,
                            'poller_hash': 'MThlODI5MGJhZTBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '154778',
                            'fiber_length': 2309,
                            'poller_hash': 'MThlODI5MTk1ZWQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1561946',
                            'fiber_length': 7053,
                            'poller_hash': 'NzBhNzQxMzM0NjE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2330376',
                            'fiber_length': 2055,
                            'poller_hash': 'NzBhNzQxMzM0NzA0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10631592',
                            'fiber_length': 2043,
                            'poller_hash': 'Nzg0NTU4MDYyN2FkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5090281',
                            'fiber_length': 2046,
                            'poller_hash': 'NjhkNzlhMDY4MGMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '697625',
                            'fiber_length': 7053,
                            'poller_hash': 'NzRhY2I5MDY3YWEycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7604674',
                            'fiber_length': 2427,
                            'poller_hash': 'ZjQ5MmJmMDYyNmRicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1112060',
                            'fiber_length': 2338,
                            'poller_hash': 'ZjQ5MmJmMDZlYzkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1357543',
                            'fiber_length': 2424,
                            'poller_hash': 'ZjQ5MmJmMDZmNDI2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2770091',
                            'fiber_length': 1812,
                            'poller_hash': 'ZmNlY2RhZWJmOWZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7671675',
                            'fiber_length': 7047,
                            'poller_hash': 'YjRmYmU0NzkzNDQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2770092',
                            'fiber_length': 1838,
                            'poller_hash': 'YjRmYmU0NzkzODEzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2837852',
                            'fiber_length': 1417,
                            'poller_hash': 'YjRmYmU0NzkzYmI1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '18445256',
                            'fiber_length': 1849,
                            'poller_hash': 'YjRmYmU0ZTZjZjNmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122006',
                            'fiber_length': 1489,
                            'poller_hash': 'YjRmYmU0Zjk1NTMycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5254723',
                            'fiber_length': 1698,
                            'poller_hash': 'YjRmYmU0Zjk1Nzk0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997733',
                            'fiber_length': 2269,
                            'poller_hash': 'YjRmYmU0ZjlkY2M4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon2',
                    'in_errors':
                    '0',
                    'in_octets':
                    '21078219630991',
                    'in_ucast_pkts':
                    '43553202210',
                    'links': [{
                        'bridged_mac_addresses': ['00:04:56:13:8d:81'],
                        'in_octets': '6638375779',
                        'out_octets': '9051885600',
                        'poller_hash': 'Nzg4YTIwNzNkMDRkcGVlcmludGY='
                    }, {
                        'in_octets': '48203031319',
                        'out_octets': '196986725734',
                        'poller_hash': 'MThlODI5MGI5YmQ4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['c0:ea:e4:8b:e8:41'],
                        'in_octets': '62469214802',
                        'out_octets': '114628485556',
                        'poller_hash': 'MThlODI5MGJiMDNjcGVlcmludGY='
                    }, {
                        'in_octets': '18271868481',
                        'out_octets': '1197908503688',
                        'poller_hash': 'MThlODI5MGJiMGUwcGVlcmludGY='
                    }, {
                        'in_octets': '34745283466',
                        'out_octets': '831964002475',
                        'poller_hash': 'MThlODI5MGJkOWY4cGVlcmludGY='
                    }, {
                        'in_octets': '72343703573',
                        'out_octets': '982932634011',
                        'poller_hash': 'MThlODI5MGJkYjI4cGVlcmludGY='
                    }, {
                        'in_octets': '24745638195',
                        'out_octets': '1116519254825',
                        'poller_hash': 'MThlODI5MTk1ZWZicGVlcmludGY='
                    }, {
                        'in_octets': '136693130145',
                        'out_octets': '605235713138',
                        'poller_hash': 'MThlODI5MTk1ZjAwcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['18:b1:69:b1:59:d1'],
                        'in_octets': '117387156998',
                        'out_octets': '231627713235',
                        'poller_hash': 'MThlODI5MTliNDVhcGVlcmludGY='
                    }, {
                        'in_octets': '18448983292',
                        'out_octets': '170550531593',
                        'poller_hash': 'MThlODI5ZjVkNGZicGVlcmludGY='
                    }, {
                        'in_octets': '15335038841',
                        'out_octets': '268140789420',
                        'poller_hash': 'NzBhNzQxMzM0NTVjcGVlcmludGY='
                    }, {
                        'in_octets': '3837806666',
                        'out_octets': '68994168461',
                        'poller_hash': 'NzBhNzQxMzM0NmVjcGVlcmludGY='
                    }, {
                        'in_octets': '13194846514',
                        'out_octets': '406060361177',
                        'poller_hash': 'Nzg0NTU4MDYyNzdkcGVlcmludGY='
                    }, {
                        'in_octets': '3115670170',
                        'out_octets': '37687610599',
                        'poller_hash': 'Nzg0NTU4OWE1MzI4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['18:fd:74:18:2e:22'],
                        'in_octets': '296983902667',
                        'out_octets': '266949474443',
                        'poller_hash': 'Nzg0NTU4OWE1YjQwcGVlcmludGY='
                    }, {
                        'in_octets': '6220961177',
                        'out_octets': '76290298954',
                        'poller_hash': 'NjhkNzlhMDY2N2E5cGVlcmludGY='
                    }, {
                        'in_octets': '10910353252',
                        'out_octets': '290485823710',
                        'poller_hash': 'NjhkNzlhMDY4MjNlcGVlcmludGY='
                    }, {
                        'in_octets': '94',
                        'out_octets': '0',
                        'poller_hash': 'NzRhY2I5MDY3MzFicGVlcmludGY='
                    }, {
                        'in_octets': '27678239346',
                        'out_octets': '654488670780',
                        'poller_hash': 'ZjQ5MmJmMDY0YjU1cGVlcmludGY='
                    }, {
                        'in_octets': '16690572524',
                        'out_octets': '363453761035',
                        'poller_hash': 'NzQ4M2MyNDNmNTg1cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['00:d8:61:6c:ea:87', '10:62:e5:1a:6c:1c', 'ac:1f:6b:49:69:77'],
                        'in_octets':
                        '51559726570',
                        'out_octets':
                        '47229884893',
                        'poller_hash':
                        'NzQ4M2MyNDNmN2ZicGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['6c:cd:d6:0f:d2:0b'],
                        'in_octets': '12647139104',
                        'out_octets': '193153843467',
                        'poller_hash': 'NzQ4M2MyNjgyOWQ1cGVlcmludGY='
                    }, {
                        'in_octets': '15301645109',
                        'out_octets': '34167819865',
                        'poller_hash': 'NzQ4M2MyNjhhZmEycGVlcmludGY='
                    }, {
                        'in_octets': '451154402',
                        'out_octets': '7743341853',
                        'poller_hash': 'NzQ4M2MyNjhjNTg1cGVlcmludGY='
                    }, {
                        'in_octets': '64667525251',
                        'out_octets': '82358478455',
                        'poller_hash': 'NzQ4M2MyNjhjNWE5cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['08:55:31:57:7f:84', '48:f8:b3:bc:ed:cb'],
                        'in_octets':
                        '733420160517',
                        'out_octets':
                        '52589305598',
                        'poller_hash':
                        'ZmNlY2RhZTBmMjYycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['04:a1:51:90:a7:f8'],
                        'in_octets': '17750737146',
                        'out_octets': '359940158363',
                        'poller_hash': 'ZmNlY2RhZWI5NTZhcGVlcmludGY='
                    }, {
                        'in_octets': '1214411',
                        'out_octets': '217700',
                        'poller_hash': 'ZmNlY2RhZWI5YmNkcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:4d:28:54:fb:ec'],
                        'in_octets': '16340708945',
                        'out_octets': '29992066797',
                        'poller_hash': 'YjRmYmU0NzkzNDM1cGVlcmludGY='
                    }, {
                        'in_octets': '43476043526',
                        'out_octets': '376367532541',
                        'poller_hash': 'YjRmYmU0NzkzOTNmcGVlcmludGY='
                    }, {
                        'in_octets': '39380962626',
                        'out_octets': '708550786866',
                        'poller_hash': 'YjRmYmU0ZTZjNGE5cGVlcmludGY='
                    }, {
                        'in_octets': '12791422536',
                        'out_octets': '54698871226',
                        'poller_hash': 'YjRmYmU0ZTZjZjI1cGVlcmludGY='
                    }, {
                        'in_octets': '7699521486',
                        'out_octets': '125648534287',
                        'poller_hash': 'YjRmYmU0ZTZjZjU4cGVlcmludGY='
                    }, {
                        'in_octets': '37276557970',
                        'out_octets': '737747228139',
                        'poller_hash': 'YjRmYmU0ZTZlMWVkcGVlcmludGY='
                    }, {
                        'in_octets': '2606907686',
                        'out_octets': '42368105659',
                        'poller_hash': 'YjRmYmU0ZTZlMjlhcGVlcmludGY='
                    }, {
                        'in_octets': '48529894030',
                        'out_octets': '1176560583068',
                        'poller_hash': 'YjRmYmU0Zjk1MDNjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': [
                            '74:4d:28:55:19:2e', '74:4d:28:bb:a0:1a',
                            '74:4d:28:bb:b5:02', 'ec:13:b2:91:09:a2'
                        ],
                        'in_octets':
                        '112918238146',
                        'out_octets':
                        '2325325057591',
                        'poller_hash':
                        'YjRmYmU0Zjk1M2EycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:01:21:46:42:08'],
                        'in_octets': '285854656952',
                        'out_octets': '668452474612',
                        'poller_hash': 'YjRmYmU0ZjlkYjM4cGVlcmludGY='
                    }, {
                        'in_octets': '64512637049',
                        'out_octets': '328400160555',
                        'poller_hash': 'ZDAyMWY5MDYxZjY0cGVlcmludGY='
                    }, {
                        'in_octets': '8228731278',
                        'out_octets': '75952505532',
                        'poller_hash': 'ZDAyMWY5OWE4MzQ4cGVlcmludGY='
                    }, {
                        'in_octets': '5699519514',
                        'out_octets': '44974624559',
                        'poller_hash': 'ZDAyMWY5OWE4NDZjcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '98547031190303',
                    'out_ucast_pkts':
                    '86596376997',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uMmludGY=',
                    'pons': [{
                        'id':
                        '2',
                        'links': [{
                            'connected_time': '1124230',
                            'fiber_length': 2652,
                            'poller_hash': 'Nzg4YTIwNzNkMDRkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8212952',
                            'fiber_length': 2415,
                            'poller_hash': 'MThlODI5MGI5YmQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1724128',
                            'fiber_length': 3871,
                            'poller_hash': 'MThlODI5MGJiMDNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473875',
                            'fiber_length': 4321,
                            'poller_hash': 'MThlODI5MGJiMGUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875910',
                            'fiber_length': 5060,
                            'poller_hash': 'MThlODI5MGJkOWY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875910',
                            'fiber_length': 5269,
                            'poller_hash': 'MThlODI5MGJkYjI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1895250',
                            'fiber_length': 7204,
                            'poller_hash': 'MThlODI5MTk1ZWZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8212252',
                            'fiber_length': 2391,
                            'poller_hash': 'MThlODI5MTk1ZjAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4156670',
                            'fiber_length': 2595,
                            'poller_hash': 'MThlODI5MTliNDVhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875900',
                            'fiber_length': 5279,
                            'poller_hash': 'MThlODI5ZjVkNGZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1540616',
                            'fiber_length': 5493,
                            'poller_hash': 'NzBhNzQxMzM0NTVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1647767',
                            'fiber_length': 7683,
                            'poller_hash': 'NzBhNzQxMzM0NmVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1356783',
                            'fiber_length': 4336,
                            'poller_hash': 'Nzg0NTU4MDYyNzdkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 2608,
                            'poller_hash': 'Nzg0NTU4OWE1MzI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236315',
                            'fiber_length': 2889,
                            'poller_hash': 'Nzg0NTU4OWE1YjQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7690875',
                            'fiber_length': 4887,
                            'poller_hash': 'NjhkNzlhMDY2N2E5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1471145',
                            'fiber_length': 4859,
                            'poller_hash': 'NjhkNzlhMDY4MjNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4152150',
                            'fiber_length': 2597,
                            'poller_hash': 'NzRhY2I5MDY3MzFicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473875',
                            'fiber_length': 4403,
                            'poller_hash': 'ZjQ5MmJmMDY0YjU1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3807335',
                            'fiber_length': 5470,
                            'poller_hash': 'NzQ4M2MyNDNmNTg1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236325',
                            'fiber_length': 3127,
                            'poller_hash': 'NzQ4M2MyNDNmN2ZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2761781',
                            'fiber_length': 7273,
                            'poller_hash': 'NzQ4M2MyNjgyOWQ1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236345',
                            'fiber_length': 2578,
                            'poller_hash': 'NzQ4M2MyNjhhZmEycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236344',
                            'fiber_length': 3254,
                            'poller_hash': 'NzQ4M2MyNjhjNTg1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236345',
                            'fiber_length': 3115,
                            'poller_hash': 'NzQ4M2MyNjhjNWE5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1562096',
                            'fiber_length': 2399,
                            'poller_hash': 'ZmNlY2RhZTBmMjYycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236325',
                            'fiber_length': 2762,
                            'poller_hash': 'ZmNlY2RhZWI5NTZhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '873427',
                            'fiber_length': 2744,
                            'poller_hash': 'ZmNlY2RhZWI5YmNkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236344',
                            'fiber_length': 3236,
                            'poller_hash': 'YjRmYmU0NzkzNDM1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997763',
                            'fiber_length': 2625,
                            'poller_hash': 'YjRmYmU0NzkzOTNmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473845',
                            'fiber_length': 4623,
                            'poller_hash': 'YjRmYmU0ZTZjNGE5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '11737786',
                            'fiber_length': 2560,
                            'poller_hash': 'YjRmYmU0ZTZjZjI1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2761781',
                            'fiber_length': 7158,
                            'poller_hash': 'YjRmYmU0ZTZjZjU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473624',
                            'fiber_length': 4572,
                            'poller_hash': 'YjRmYmU0ZTZlMWVkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1473625',
                            'fiber_length': 4502,
                            'poller_hash': 'YjRmYmU0ZTZlMjlhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5688569',
                            'fiber_length': 7211,
                            'poller_hash': 'YjRmYmU0Zjk1MDNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5334595',
                            'fiber_length': 2381,
                            'poller_hash': 'YjRmYmU0Zjk1M2EycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3644593',
                            'fiber_length': 3222,
                            'poller_hash': 'YjRmYmU0ZjlkYjM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7778616',
                            'fiber_length': 7300,
                            'poller_hash': 'ZDAyMWY5MDYxZjY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2761781',
                            'fiber_length': 7224,
                            'poller_hash': 'ZDAyMWY5OWE4MzQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951638',
                            'fiber_length': 2789,
                            'poller_hash': 'ZDAyMWY5OWE4NDZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon3',
                    'in_errors':
                    '0',
                    'in_octets':
                    '11063818800627',
                    'in_ucast_pkts':
                    '34221471711',
                    'links': [{
                        'in_octets': '26916477814',
                        'out_octets': '354539529981',
                        'poller_hash': 'Nzg4YTIwYzA0NDI0cGVlcmludGY='
                    }, {
                        'in_octets': '52470755',
                        'out_octets': '21736665',
                        'poller_hash': 'MThlODI5MGI3YjIwcGVlcmludGY='
                    }, {
                        'in_octets': '6073705015',
                        'out_octets': '47870585596',
                        'poller_hash': 'MThlODI5MGI5OTZjcGVlcmludGY='
                    }, {
                        'in_octets': '22898687137',
                        'out_octets': '539359714979',
                        'poller_hash': 'MThlODI5MGJiMGQwcGVlcmludGY='
                    }, {
                        'in_octets': '72746249726',
                        'out_octets': '868444339701',
                        'poller_hash': 'MThlODI5MTk1YTgycGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['cc:9c:3e:50:b4:eb'],
                        'in_octets': '100191774',
                        'out_octets': '13161400',
                        'poller_hash': 'MThlODI5ZjVkM2NkcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses':
                        ['3c:ec:ef:6f:29:ce', '3c:ec:ef:6f:30:21'],
                        'in_octets':
                        '16057965159',
                        'out_octets':
                        '38862993188',
                        'poller_hash':
                        'MThlODI5ZjVkNGJlcGVlcmludGY='
                    }, {
                        'in_octets': '11633928406',
                        'out_octets': '319737295861',
                        'poller_hash': 'NzBhNzQxMzM0NDQ0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['04:d5:90:5f:5b:b5'],
                        'in_octets': '1122169150',
                        'out_octets': '20811592604',
                        'poller_hash': 'NzBhNzQxMzM0NmUwcGVlcmludGY='
                    }, {
                        'in_octets': '104802381961',
                        'out_octets': '1433260765635',
                        'poller_hash': 'Nzg0NTU4MDYyNGE3cGVlcmludGY='
                    }, {
                        'in_octets': '83127397829',
                        'out_octets': '5181478383559',
                        'poller_hash': 'Nzg0NTU4MDYyNzI2cGVlcmludGY='
                    }, {
                        'in_octets': '38191421835',
                        'out_octets': '627518198044',
                        'poller_hash': 'Nzg0NTU4MDYyOGUwcGVlcmludGY='
                    }, {
                        'in_octets': '49736658591',
                        'out_octets': '1095668450715',
                        'poller_hash': 'Nzg0NTU4MDYyOTMxcGVlcmludGY='
                    }, {
                        'in_octets': '301208890999',
                        'out_octets': '2691025485006',
                        'poller_hash': 'Nzg0NTU4OWE1OWYwcGVlcmludGY='
                    }, {
                        'in_octets': '28678459567',
                        'out_octets': '594247947654',
                        'poller_hash': 'NjhkNzlhMDY2N2JkcGVlcmludGY='
                    }, {
                        'in_octets': '270596986406',
                        'out_octets': '7288813286328',
                        'poller_hash': 'NjhkNzlhMDY4MDNkcGVlcmludGY='
                    }, {
                        'in_octets': '10354185389',
                        'out_octets': '408137292637',
                        'poller_hash': 'ZjQ5MmJmMDZlM2M1cGVlcmludGY='
                    }, {
                        'in_octets': '23257630059',
                        'out_octets': '513717530050',
                        'poller_hash': 'ZjQ5MmJmMDZmM2U0cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['18:b1:69:38:8e:d1'],
                        'in_octets': '66846381393',
                        'out_octets': '81890741079',
                        'poller_hash': 'NzQ4M2MyNDNlYzhicGVlcmludGY='
                    }, {
                        'in_octets': '18948295788',
                        'out_octets': '511207640643',
                        'poller_hash': 'NzQ4M2MyNDNmNjI4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['50:c7:bf:39:2b:19'],
                        'in_octets': '11192681513',
                        'out_octets': '199122231467',
                        'poller_hash': 'NzQ4M2MyNDNmNjg1cGVlcmludGY='
                    }, {
                        'in_octets': '75465268098',
                        'out_octets': '1910936437170',
                        'poller_hash': 'NzQ4M2MyNDNmODE5cGVlcmludGY='
                    }, {
                        'in_octets': '276236753',
                        'out_octets': '3933187581',
                        'poller_hash': 'NzQ4M2MyNjgzNTYycGVlcmludGY='
                    }, {
                        'in_octets': '5490536901',
                        'out_octets': '132060310759',
                        'poller_hash': 'YjRmYmU0ZTZhY2EzcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:01:21:2f:0a:e4'],
                        'in_octets': '568621885269',
                        'out_octets': '323815704936',
                        'poller_hash': 'YjRmYmU0ZjkyODlicGVlcmludGY='
                    }, {
                        'in_octets': '12203916160',
                        'out_octets': '116107972986',
                        'poller_hash': 'YjRmYmU0Zjk0ZjFhcGVlcmludGY='
                    }, {
                        'in_octets': '255745969',
                        'out_octets': '118185250',
                        'poller_hash': 'YjRmYmU0Zjk0ZmU3cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['00:90:7f:01:ac:16'],
                        'in_octets': '12166021346',
                        'out_octets': '64190780317',
                        'poller_hash': 'YjRmYmU0ZjlkYzE0cGVlcmludGY='
                    }, {
                        'in_octets': '7252090642',
                        'out_octets': '19746822349',
                        'poller_hash': 'ZDAyMWY5OWFhNTMwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon3',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '105536493817231',
                    'out_ucast_pkts':
                    '86413828151',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uM2ludGY=',
                    'pons': [{
                        'id':
                        '3',
                        'links': [{
                            'connected_time': '1720528',
                            'fiber_length': 3802,
                            'poller_hash': 'Nzg4YTIwYzA0NDI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236345',
                            'fiber_length': 3077,
                            'poller_hash': 'MThlODI5MGI3YjIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '403281',
                            'fiber_length': 6725,
                            'poller_hash': 'MThlODI5MGI5OTZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5249294',
                            'fiber_length': 3213,
                            'poller_hash': 'MThlODI5MGJiMGQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122296',
                            'fiber_length': 6693,
                            'poller_hash': 'MThlODI5MTk1YTgycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236325',
                            'fiber_length': 2942,
                            'poller_hash': 'MThlODI5ZjVkM2NkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1728578',
                            'fiber_length': 3934,
                            'poller_hash': 'MThlODI5ZjVkNGJlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1562996',
                            'fiber_length': 6703,
                            'poller_hash': 'NzBhNzQxMzM0NDQ0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '522143',
                            'fiber_length': 6807,
                            'poller_hash': 'NzBhNzQxMzM0NmUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122295',
                            'fiber_length': 6666,
                            'poller_hash': 'Nzg0NTU4MDYyNGE3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997733',
                            'fiber_length': 3223,
                            'poller_hash': 'Nzg0NTU4MDYyNzI2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 3244,
                            'poller_hash': 'Nzg0NTU4MDYyOGUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122296',
                            'fiber_length': 6668,
                            'poller_hash': 'Nzg0NTU4MDYyOTMxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997733',
                            'fiber_length': 3332,
                            'poller_hash': 'Nzg0NTU4OWE1OWYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1744168',
                            'fiber_length': 6565,
                            'poller_hash': 'NjhkNzlhMDY2N2JkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9117783',
                            'fiber_length': 4906,
                            'poller_hash': 'NjhkNzlhMDY4MDNkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1981181',
                            'fiber_length': 6522,
                            'poller_hash': 'ZjQ5MmJmMDZlM2M1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1894890',
                            'fiber_length': 6694,
                            'poller_hash': 'ZjQ5MmJmMDZmM2U0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 2894,
                            'poller_hash': 'NzQ4M2MyNDNlYzhicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1228172',
                            'fiber_length': 3336,
                            'poller_hash': 'NzQ4M2MyNDNmNjI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 3976,
                            'poller_hash': 'NzQ4M2MyNDNmNjg1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122286',
                            'fiber_length': 6664,
                            'poller_hash': 'NzQ4M2MyNDNmODE5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2904423',
                            'fiber_length': 3221,
                            'poller_hash': 'NzQ4M2MyNjgzNTYycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '250869',
                            'fiber_length': 3088,
                            'poller_hash': 'YjRmYmU0ZTZhY2EzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2139213',
                            'fiber_length': 2860,
                            'poller_hash': 'YjRmYmU0ZjkyODlicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3122296',
                            'fiber_length': 6565,
                            'poller_hash': 'YjRmYmU0Zjk0ZjFhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1812429',
                            'fiber_length': 3799,
                            'poller_hash': 'YjRmYmU0Zjk0ZmU3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 3869,
                            'poller_hash': 'YjRmYmU0ZjlkYzE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236345',
                            'fiber_length': 3537,
                            'poller_hash': 'ZDAyMWY5OWFhNTMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon4',
                    'in_errors':
                    '0',
                    'in_octets':
                    '7630009630678',
                    'in_ucast_pkts':
                    '37050894020',
                    'links': [{
                        'in_octets': '471385699',
                        'out_octets': '18341208551',
                        'poller_hash': 'MThlODI5MGI3YWI4cGVlcmludGY='
                    }, {
                        'in_octets': '19211620876',
                        'out_octets': '638479448471',
                        'poller_hash': 'MThlODI5MGJhZTljcGVlcmludGY='
                    }, {
                        'in_octets': '130408759027',
                        'out_octets': '4937645959146',
                        'poller_hash': 'MThlODI5MGJhZjA4cGVlcmludGY='
                    }, {
                        'in_octets': '7514913398',
                        'out_octets': '413976308347',
                        'poller_hash': 'MThlODI5MGJiMDc0cGVlcmludGY='
                    }, {
                        'in_octets': '15779436535',
                        'out_octets': '194266090622',
                        'poller_hash': 'MThlODI5MTk4MTI0cGVlcmludGY='
                    }, {
                        'in_octets': '49432253518',
                        'out_octets': '571808720849',
                        'poller_hash': 'MThlODI5MTliNGVicGVlcmludGY='
                    }, {
                        'in_octets': '27824745623',
                        'out_octets': '1504030425737',
                        'poller_hash': 'Nzg0NTU4MDYyODBmcGVlcmludGY='
                    }, {
                        'in_octets': '48702228981',
                        'out_octets': '2010922396415',
                        'poller_hash': 'Nzg0NTU4OWFmZDRjcGVlcmludGY='
                    }, {
                        'in_octets': '150535737723',
                        'out_octets': '2730946906061',
                        'poller_hash': 'Nzg0NTU4OWFmZDU0cGVlcmludGY='
                    }, {
                        'in_octets': '40282052347',
                        'out_octets': '79350201183',
                        'poller_hash': 'NjhkNzlhMDY0OWM2cGVlcmludGY='
                    }, {
                        'in_octets': '3994390581',
                        'out_octets': '128382929247',
                        'poller_hash': 'NjhkNzlhMDY2N2I5cGVlcmludGY='
                    }, {
                        'in_octets': '15078811039',
                        'out_octets': '338529606302',
                        'poller_hash': 'ZjQ5MmJmMDY0YWM2cGVlcmludGY='
                    }, {
                        'in_octets': '521470',
                        'out_octets': '131600',
                        'poller_hash': 'ZjQ5MmJmMDY0YmUxcGVlcmludGY='
                    }, {
                        'in_octets': '34338396214',
                        'out_octets': '337258223569',
                        'poller_hash': 'NzQ4M2MyNDNmNTUxcGVlcmludGY='
                    }, {
                        'in_octets': '8010190102',
                        'out_octets': '552574059990',
                        'poller_hash': 'NzQ4M2MyNDNmNTY5cGVlcmludGY='
                    }, {
                        'in_octets': '50882319746',
                        'out_octets': '552536006242',
                        'poller_hash': 'NzQ4M2MyNDNmNThhcGVlcmludGY='
                    }, {
                        'in_octets': '184446338435',
                        'out_octets': '1758690674648',
                        'poller_hash': 'NzQ4M2MyNDNmNTlhcGVlcmludGY='
                    }, {
                        'in_octets': '62507626656',
                        'out_octets': '1123680988544',
                        'poller_hash': 'NzQ4M2MyNjg5OThlcGVlcmludGY='
                    }, {
                        'in_octets': '109259587467',
                        'out_octets': '2201083998449',
                        'poller_hash': 'NzQ4M2MyNjg5OWU4cGVlcmludGY='
                    }, {
                        'in_octets': '39343498779',
                        'out_octets': '397430827466',
                        'poller_hash': 'NzQ4M2MyNjhjNGZjcGVlcmludGY='
                    }, {
                        'in_octets': '28695042339',
                        'out_octets': '569738347747',
                        'poller_hash': 'NzQ4M2MyNjhjNWYycGVlcmludGY='
                    }, {
                        'in_octets': '63288639990',
                        'out_octets': '1025020077247',
                        'poller_hash': 'NzQ4M2MyNjhjNjQ4cGVlcmludGY='
                    }, {
                        'in_octets': '27287158826',
                        'out_octets': '638914526447',
                        'poller_hash': 'YjRmYmU0Nzk1ZjE0cGVlcmludGY='
                    }, {
                        'in_octets': '5737046902',
                        'out_octets': '11217440568',
                        'poller_hash': 'YjRmYmU0ZTZiNDVmcGVlcmludGY='
                    }, {
                        'in_octets': '249813544920',
                        'out_octets': '2064999901639',
                        'poller_hash': 'YjRmYmU0ZTZjNTFjcGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['08:55:31:6d:ed:bd'],
                        'in_octets': '15948212219',
                        'out_octets': '36290512766',
                        'poller_hash': 'YjRmYmU0ZTZjZjU3cGVlcmludGY='
                    }, {
                        'in_octets': '67090417807',
                        'out_octets': '1794180430610',
                        'poller_hash': 'YjRmYmU0ZTZlMWZicGVlcmludGY='
                    }, {
                        'in_octets': '34048230309',
                        'out_octets': '993238928716',
                        'poller_hash': 'YjRmYmU0Zjk0ZjBicGVlcmludGY='
                    }, {
                        'in_octets': '6110626044',
                        'out_octets': '224021002336',
                        'poller_hash': 'ZDAyMWY5OWE4NDQwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon4',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '148849468035998',
                    'out_ucast_pkts':
                    '113908726908',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uNGludGY=',
                    'pons': [{
                        'id':
                        '4',
                        'links': [{
                            'connected_time': '124508',
                            'fiber_length': 3509,
                            'poller_hash': 'MThlODI5MGI3YWI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1258592',
                            'fiber_length': 3355,
                            'poller_hash': 'MThlODI5MGJhZTljcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10170537',
                            'fiber_length': 3944,
                            'poller_hash': 'MThlODI5MGJhZjA4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1201011',
                            'fiber_length': 3966,
                            'poller_hash': 'MThlODI5MGJiMDc0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200991',
                            'fiber_length': 3960,
                            'poller_hash': 'MThlODI5MTk4MTI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200991',
                            'fiber_length': 4134,
                            'poller_hash': 'MThlODI5MTliNGVicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200981',
                            'fiber_length': 4139,
                            'poller_hash': 'Nzg0NTU4MDYyODBmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4676996',
                            'fiber_length': 3516,
                            'poller_hash': 'Nzg0NTU4OWFmZDRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13636289',
                            'fiber_length': 3231,
                            'poller_hash': 'Nzg0NTU4OWFmZDU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5084002',
                            'fiber_length': 4358,
                            'poller_hash': 'NjhkNzlhMDY0OWM2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '511192',
                            'fiber_length': 3877,
                            'poller_hash': 'NjhkNzlhMDY2N2I5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1357523',
                            'fiber_length': 3830,
                            'poller_hash': 'ZjQ5MmJmMDY0YWM2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997742',
                            'fiber_length': 3827,
                            'poller_hash': 'ZjQ5MmJmMDY0YmUxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3006415',
                            'fiber_length': 4249,
                            'poller_hash': 'NzQ4M2MyNDNmNTUxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200531',
                            'fiber_length': 4397,
                            'poller_hash': 'NzQ4M2MyNDNmNTY5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200981',
                            'fiber_length': 4112,
                            'poller_hash': 'NzQ4M2MyNDNmNThhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8022689',
                            'fiber_length': 3861,
                            'poller_hash': 'NzQ4M2MyNDNmNTlhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2742971',
                            'fiber_length': 3974,
                            'poller_hash': 'NzQ4M2MyNjg5OThlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '11328721',
                            'fiber_length': 3679,
                            'poller_hash': 'NzQ4M2MyNjg5OWU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1201011',
                            'fiber_length': 3828,
                            'poller_hash': 'NzQ4M2MyNjhjNGZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1201011',
                            'fiber_length': 4365,
                            'poller_hash': 'NzQ4M2MyNjhjNWYycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4570205',
                            'fiber_length': 3984,
                            'poller_hash': 'NzQ4M2MyNjhjNjQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2163114',
                            'fiber_length': 3342,
                            'poller_hash': 'YjRmYmU0Nzk1ZjE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10897926',
                            'fiber_length': 4018,
                            'poller_hash': 'YjRmYmU0ZTZiNDVmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '12887901',
                            'fiber_length': 3510,
                            'poller_hash': 'YjRmYmU0ZTZjNTFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '14836772',
                            'fiber_length': 3512,
                            'poller_hash': 'YjRmYmU0ZTZjZjU3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5281134',
                            'fiber_length': 4243,
                            'poller_hash': 'YjRmYmU0ZTZlMWZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5833551',
                            'fiber_length': 3324,
                            'poller_hash': 'YjRmYmU0Zjk0ZjBicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '744235',
                            'fiber_length': 4085,
                            'poller_hash': 'ZDAyMWY5OWE4NDQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon5',
                    'in_errors':
                    '0',
                    'in_octets':
                    '3720069202940',
                    'in_ucast_pkts':
                    '19376312986',
                    'links': [{
                        'in_octets': '1329250559',
                        'out_octets': '197617922',
                        'poller_hash': 'MThlODI5MGJiMGM0cGVlcmludGY='
                    }, {
                        'in_octets': '71779536815',
                        'out_octets': '1993287629147',
                        'poller_hash': 'MThlODI5MGJiMGQ4cGVlcmludGY='
                    }, {
                        'in_octets': '1812015826',
                        'out_octets': '4906654418',
                        'poller_hash': 'MThlODI5MTk1YWM4cGVlcmludGY='
                    }, {
                        'in_octets': '1928592642',
                        'out_octets': '56307744559',
                        'poller_hash': 'MThlODI5ZjVkM2Q0cGVlcmludGY='
                    }, {
                        'in_octets': '12134588914',
                        'out_octets': '432166540162',
                        'poller_hash': 'Nzg0NTU4MDYyNzg5cGVlcmludGY='
                    }, {
                        'in_octets': '15701436881',
                        'out_octets': '484986346095',
                        'poller_hash': 'NzQ4M2MyNDNmNmMwcGVlcmludGY='
                    }, {
                        'in_octets': '14509449166',
                        'out_octets': '532242081283',
                        'poller_hash': 'NzQ4M2MyNDNmN2Y5cGVlcmludGY='
                    }, {
                        'in_octets': '45697058001',
                        'out_octets': '1443354564733',
                        'poller_hash': 'NzQ4M2MyNDNmOWYxcGVlcmludGY='
                    }, {
                        'in_octets': '11716720273',
                        'out_octets': '137770601046',
                        'poller_hash': 'NzQ4M2MyNjg5OWVjcGVlcmludGY='
                    }, {
                        'in_octets': '26502903475',
                        'out_octets': '467013827812',
                        'poller_hash': 'NzQ4M2MyNjhjNTkwcGVlcmludGY='
                    }, {
                        'in_octets': '6013486972',
                        'out_octets': '331763020150',
                        'poller_hash': 'YjRmYmU0NzkzNTQzcGVlcmludGY='
                    }, {
                        'in_octets': '32935044121',
                        'out_octets': '116575324098',
                        'poller_hash': 'YjRmYmU0ZTZkNzNjcGVlcmludGY='
                    }, {
                        'in_octets': '124430602209',
                        'out_octets': '1491635343887',
                        'poller_hash': 'YjRmYmU0Zjk0ZDAzcGVlcmludGY='
                    }, {
                        'in_octets': '14959842176',
                        'out_octets': '478130425849',
                        'poller_hash': 'ZDAyMWY5OWE4NTM0cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon5',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '72534526088062',
                    'out_ucast_pkts':
                    '59070703109',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uNWludGY=',
                    'pons': [{
                        'id':
                        '5',
                        'links': [{
                            'connected_time': '1453095',
                            'fiber_length': 4433,
                            'poller_hash': 'MThlODI5MGJiMGM0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10005354',
                            'fiber_length': 4741,
                            'poller_hash': 'MThlODI5MGJiMGQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '97887',
                            'fiber_length': 4294,
                            'poller_hash': 'MThlODI5MTk1YWM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '90197',
                            'fiber_length': 4573,
                            'poller_hash': 'MThlODI5ZjVkM2Q0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1273202',
                            'fiber_length': 4259,
                            'poller_hash': 'Nzg0NTU4MDYyNzg5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1309603',
                            'fiber_length': 5508,
                            'poller_hash': 'NzQ4M2MyNDNmNmMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200991',
                            'fiber_length': 4592,
                            'poller_hash': 'NzQ4M2MyNDNmN2Y5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10243097',
                            'fiber_length': 4186,
                            'poller_hash': 'NzQ4M2MyNDNmOWYxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1026629',
                            'fiber_length': 5471,
                            'poller_hash': 'NzQ4M2MyNjg5OWVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1893990',
                            'fiber_length': 4282,
                            'poller_hash': 'NzQ4M2MyNjhjNTkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1200991',
                            'fiber_length': 4590,
                            'poller_hash': 'YjRmYmU0NzkzNTQzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '879487',
                            'fiber_length': 4729,
                            'poller_hash': 'YjRmYmU0ZTZkNzNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5682579',
                            'fiber_length': 5588,
                            'poller_hash': 'YjRmYmU0Zjk0ZDAzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1201011',
                            'fiber_length': 4324,
                            'poller_hash': 'ZDAyMWY5OWE4NTM0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon6',
                    'in_errors':
                    '0',
                    'in_octets':
                    '11880738578227',
                    'in_ucast_pkts':
                    '56190836020',
                    'links': [{
                        'in_octets': '24311508521',
                        'out_octets': '320714753186',
                        'poller_hash': 'MThlODI5MGI5NjVjcGVlcmludGY='
                    }, {
                        'in_octets': '55361853012',
                        'out_octets': '333590495370',
                        'poller_hash': 'MThlODI5MGI5NzkwcGVlcmludGY='
                    }, {
                        'in_octets': '31235907268',
                        'out_octets': '841385835781',
                        'poller_hash': 'MThlODI5MGJhZTA0cGVlcmludGY='
                    }, {
                        'in_octets': '27685306049',
                        'out_octets': '81947189012',
                        'poller_hash': 'MThlODI5MGJiMDUwcGVlcmludGY='
                    }, {
                        'in_octets': '121467929012',
                        'out_octets': '1906562229700',
                        'poller_hash': 'MThlODI5MGJiMDc4cGVlcmludGY='
                    }, {
                        'in_octets': '42334637027',
                        'out_octets': '1497782409427',
                        'poller_hash': 'MThlODI5MGJiMGE0cGVlcmludGY='
                    }, {
                        'in_octets': '15091483886',
                        'out_octets': '42493798605',
                        'poller_hash': 'MThlODI5MGJlMGIwcGVlcmludGY='
                    }, {
                        'in_octets': '24953858142',
                        'out_octets': '831917276154',
                        'poller_hash': 'MThlODI5MTk1YWMzcGVlcmludGY='
                    }, {
                        'in_octets': '7371520985',
                        'out_octets': '228352125021',
                        'poller_hash': 'MThlODI5MTk1ZWY2cGVlcmludGY='
                    }, {
                        'in_octets': '114401447187',
                        'out_octets': '3458254745999',
                        'poller_hash': 'MThlODI5MTliNGFmcGVlcmludGY='
                    }, {
                        'in_octets': '252011240049',
                        'out_octets': '1866463416679',
                        'poller_hash': 'MThlODI5ZjVkNDc3cGVlcmludGY='
                    }, {
                        'in_octets': '210280614850',
                        'out_octets': '1575010373101',
                        'poller_hash': 'MThlODI5ZjVkNGZjcGVlcmludGY='
                    }, {
                        'in_octets': '12978057375',
                        'out_octets': '138942247791',
                        'poller_hash': 'NzBhNzQxMzM0NzM4cGVlcmludGY='
                    }, {
                        'in_octets': '1922931848',
                        'out_octets': '67122072562',
                        'poller_hash': 'Nzg0NTU4MDYyNzhmcGVlcmludGY='
                    }, {
                        'in_octets': '22473517154',
                        'out_octets': '756475218787',
                        'poller_hash': 'Nzg0NTU4MDYyN2I1cGVlcmludGY='
                    }, {
                        'in_octets': '11039292030',
                        'out_octets': '400936520750',
                        'poller_hash': 'Nzg0NTU4MDYyN2I3cGVlcmludGY='
                    }, {
                        'in_octets': '14432952283',
                        'out_octets': '403772541765',
                        'poller_hash': 'NzRhY2I5MDY3YWE0cGVlcmludGY='
                    }, {
                        'in_octets': '38199583011',
                        'out_octets': '585376026327',
                        'poller_hash': 'NzRhY2I5MDZhMGM0cGVlcmludGY='
                    }, {
                        'in_octets': '40906467147',
                        'out_octets': '1065503786325',
                        'poller_hash': 'ZjQ5MmJmMDY0MjQ3cGVlcmludGY='
                    }, {
                        'in_octets': '11878260275',
                        'out_octets': '301823475817',
                        'poller_hash': 'ZjQ5MmJmMDZmMjhmcGVlcmludGY='
                    }, {
                        'in_octets': '30931068804',
                        'out_octets': '306414958210',
                        'poller_hash': 'NzQ4M2MyNDNmNjUwcGVlcmludGY='
                    }, {
                        'in_octets': '137286259372',
                        'out_octets': '3056239298887',
                        'poller_hash': 'NzQ4M2MyNjg5YTA2cGVlcmludGY='
                    }, {
                        'in_octets': '388646230770',
                        'out_octets': '2493077108129',
                        'poller_hash': 'NzQ4M2MyNjhhZmI2cGVlcmludGY='
                    }, {
                        'in_octets': '50222128505',
                        'out_octets': '292503590947',
                        'poller_hash': 'NzQ4M2MyNjhiMThmcGVlcmludGY='
                    }, {
                        'in_octets': '17605697430',
                        'out_octets': '690942419316',
                        'poller_hash': 'NzQ4M2MyZjBjOTQ4cGVlcmludGY='
                    }, {
                        'in_octets': '14180443040',
                        'out_octets': '140347805327',
                        'poller_hash': 'ZmNlY2RhZWJmMTcycGVlcmludGY='
                    }, {
                        'in_octets': '991293677536',
                        'out_octets': '11168575942626',
                        'poller_hash': 'YjRmYmU0NzkzNDc2cGVlcmludGY='
                    }, {
                        'in_octets': '172156812366',
                        'out_octets': '4274742806913',
                        'poller_hash': 'YjRmYmU0NzkzNTNlcGVlcmludGY='
                    }, {
                        'in_octets': '2452120',
                        'out_octets': '4647017',
                        'poller_hash': 'YjRmYmU0NzkzOThhcGVlcmludGY='
                    }, {
                        'in_octets': '33867028498',
                        'out_octets': '846233534584',
                        'poller_hash': 'YjRmYmU0ZTY4MzBlcGVlcmludGY='
                    }, {
                        'in_octets': '23516856561',
                        'out_octets': '969800435588',
                        'poller_hash': 'YjRmYmU0ZTZjZjM2cGVlcmludGY='
                    }, {
                        'in_octets': '124770107983',
                        'out_octets': '967085065286',
                        'poller_hash': 'YjRmYmU0ZTZkNzM4cGVlcmludGY='
                    }, {
                        'bridged_mac_addresses': ['74:4d:28:9d:46:d0'],
                        'in_octets': '2299018173',
                        'out_octets': '46458715419',
                        'poller_hash': 'YjRmYmU0ZTZkZjQycGVlcmludGY='
                    }, {
                        'in_octets': '11259485256',
                        'out_octets': '466762290773',
                        'poller_hash': 'YjRmYmU0ZTZlMjEycGVlcmludGY='
                    }, {
                        'in_octets': '50945124068',
                        'out_octets': '543089917895',
                        'poller_hash': 'YjRmYmU0Zjk0ZDdicGVlcmludGY='
                    }, {
                        'in_octets': '39777759260',
                        'out_octets': '551092453935',
                        'poller_hash': 'YjRmYmU0Zjk0ZjI0cGVlcmludGY='
                    }, {
                        'in_octets': '6682706304',
                        'out_octets': '46505050381',
                        'poller_hash': 'YjRmYmU0ZjlkZDA0cGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon6',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '201389253875582',
                    'out_ucast_pkts':
                    '152303069245',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uNmludGY=',
                    'pons': [{
                        'id':
                        '6',
                        'links': [{
                            'connected_time': '6059724',
                            'fiber_length': 6918,
                            'poller_hash': 'MThlODI5MGI5NjVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3603092',
                            'fiber_length': 5100,
                            'poller_hash': 'MThlODI5MGI5NzkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3365669',
                            'fiber_length': 4850,
                            'poller_hash': 'MThlODI5MGJhZTA0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1818489',
                            'fiber_length': 7151,
                            'poller_hash': 'MThlODI5MGJiMDUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875910',
                            'fiber_length': 7136,
                            'poller_hash': 'MThlODI5MGJiMDc4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2924804',
                            'fiber_length': 5118,
                            'poller_hash': 'MThlODI5MGJiMGE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '680284',
                            'fiber_length': 5626,
                            'poller_hash': 'MThlODI5MGJlMGIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2558789',
                            'fiber_length': 4963,
                            'poller_hash': 'MThlODI5MTk1YWMzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '658044',
                            'fiber_length': 4842,
                            'poller_hash': 'MThlODI5MTk1ZWY2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3364729',
                            'fiber_length': 4854,
                            'poller_hash': 'MThlODI5MTliNGFmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5653779',
                            'fiber_length': 7059,
                            'poller_hash': 'MThlODI5ZjVkNDc3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875890',
                            'fiber_length': 6897,
                            'poller_hash': 'MThlODI5ZjVkNGZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5195243',
                            'fiber_length': 4056,
                            'poller_hash': 'NzBhNzQxMzM0NzM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '445942',
                            'fiber_length': 5041,
                            'poller_hash': 'Nzg0NTU4MDYyNzhmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1386313',
                            'fiber_length': 5016,
                            'poller_hash': 'Nzg0NTU4MDYyN2I1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1356623',
                            'fiber_length': 6903,
                            'poller_hash': 'Nzg0NTU4MDYyN2I3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1391624',
                            'fiber_length': 5000,
                            'poller_hash': 'NzRhY2I5MDY3YWE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3289848',
                            'fiber_length': 5116,
                            'poller_hash': 'NzRhY2I5MDZhMGM0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875900',
                            'fiber_length': 6967,
                            'poller_hash': 'ZjQ5MmJmMDY0MjQ3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236325',
                            'fiber_length': 4167,
                            'poller_hash': 'ZjQ5MmJmMDZmMjhmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3603082',
                            'fiber_length': 6456,
                            'poller_hash': 'NzQ4M2MyNDNmNjUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875890',
                            'fiber_length': 7181,
                            'poller_hash': 'NzQ4M2MyNjg5YTA2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7923238',
                            'fiber_length': 5416,
                            'poller_hash': 'NzQ4M2MyNjhhZmI2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8298523',
                            'fiber_length': 7005,
                            'poller_hash': 'NzQ4M2MyNjhiMThmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236345',
                            'fiber_length': 3709,
                            'poller_hash': 'NzQ4M2MyZjBjOTQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5268274',
                            'fiber_length': 7122,
                            'poller_hash': 'ZmNlY2RhZWJmMTcycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7905718',
                            'fiber_length': 4044,
                            'poller_hash': 'YjRmYmU0NzkzNDc2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875920',
                            'fiber_length': 7013,
                            'poller_hash': 'YjRmYmU0NzkzNTNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4296',
                            'fiber_length': 4875,
                            'poller_hash': 'YjRmYmU0NzkzOThhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2236324',
                            'fiber_length': 3624,
                            'poller_hash': 'YjRmYmU0ZTY4MzBlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875890',
                            'fiber_length': 7081,
                            'poller_hash': 'YjRmYmU0ZTZjZjM2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8624707',
                            'fiber_length': 7059,
                            'poller_hash': 'YjRmYmU0ZTZkNzM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '331710',
                            'fiber_length': 5680,
                            'poller_hash': 'YjRmYmU0ZTZkZjQycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1391624',
                            'fiber_length': 5037,
                            'poller_hash': 'YjRmYmU0ZTZlMjEycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875900',
                            'fiber_length': 7032,
                            'poller_hash': 'YjRmYmU0Zjk0ZDdicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3603072',
                            'fiber_length': 5960,
                            'poller_hash': 'YjRmYmU0Zjk0ZjI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3603072',
                            'fiber_length': 6159,
                            'poller_hash': 'YjRmYmU0ZjlkZDA0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon7',
                    'in_errors':
                    '0',
                    'in_octets':
                    '9335554218360',
                    'in_ucast_pkts':
                    '40965164128',
                    'links': [{
                        'in_octets': '235305901206',
                        'out_octets': '2983069267237',
                        'poller_hash': 'Nzg4YTIwYzA0MTM2cGVlcmludGY='
                    }, {
                        'in_octets': '19400555022',
                        'out_octets': '710899371601',
                        'poller_hash': 'MThlODI5MGJkYzY4cGVlcmludGY='
                    }, {
                        'in_octets': '56295465865',
                        'out_octets': '1843511847484',
                        'poller_hash': 'MThlODI5MGJlMTYwcGVlcmludGY='
                    }, {
                        'in_octets': '147316268689',
                        'out_octets': '3871421607321',
                        'poller_hash': 'MThlODI5MTk4MTI5cGVlcmludGY='
                    }, {
                        'in_octets': '1464158807',
                        'out_octets': '42662503108',
                        'poller_hash': 'MThlODI5MTliNGEwcGVlcmludGY='
                    }, {
                        'in_octets': '22412688659',
                        'out_octets': '463849171359',
                        'poller_hash': 'MThlODI5MTliNGE1cGVlcmludGY='
                    }, {
                        'in_octets': '801745801',
                        'out_octets': '27829325359',
                        'poller_hash': 'MThlODI5MTliNGU2cGVlcmludGY='
                    }, {
                        'in_octets': '581658608',
                        'out_octets': '12498471768',
                        'poller_hash': 'MThlODI5ZjVkNGY2cGVlcmludGY='
                    }, {
                        'in_octets': '130896041879',
                        'out_octets': '4000781578713',
                        'poller_hash': 'Nzg0NTU4MDYyODc4cGVlcmludGY='
                    }, {
                        'in_octets': '71157861539',
                        'out_octets': '1035974838147',
                        'poller_hash': 'NzRhY2I5MDY3YTlhcGVlcmludGY='
                    }, {
                        'in_octets': '2318273195',
                        'out_octets': '58489307323',
                        'poller_hash': 'NzRhY2I5MDZhMmQxcGVlcmludGY='
                    }, {
                        'in_octets': '22943668861',
                        'out_octets': '456787180269',
                        'poller_hash': 'NzQ4M2MyNDNlYzI0cGVlcmludGY='
                    }, {
                        'in_octets': '18505512829',
                        'out_octets': '435615447750',
                        'poller_hash': 'NzQ4M2MyNDNlYzJlcGVlcmludGY='
                    }, {
                        'in_octets': '68067119643',
                        'out_octets': '1460816390799',
                        'poller_hash': 'NzQ4M2MyNDNlYzY0cGVlcmludGY='
                    }, {
                        'in_octets': '33582343756',
                        'out_octets': '534203345960',
                        'poller_hash': 'NzQ4M2MyNDNlZGFlcGVlcmludGY='
                    }, {
                        'in_octets': '87147657044',
                        'out_octets': '1815426469104',
                        'poller_hash': 'NzQ4M2MyNDNmNTMycGVlcmludGY='
                    }, {
                        'in_octets': '24767664316',
                        'out_octets': '266931301220',
                        'poller_hash': 'NzQ4M2MyNjgzNjRjcGVlcmludGY='
                    }, {
                        'in_octets': '4234802587',
                        'out_octets': '154489852640',
                        'poller_hash': 'NzQ4M2MyNjhjNjU0cGVlcmludGY='
                    }, {
                        'in_octets': '472138378',
                        'out_octets': '4321206432',
                        'poller_hash': 'ZmNlY2RhZWI5NTMzcGVlcmludGY='
                    }, {
                        'in_octets': '171376248013',
                        'out_octets': '2304453327600',
                        'poller_hash': 'YjRmYmU0NzkzNTA3cGVlcmludGY='
                    }, {
                        'in_octets': '224080460647',
                        'out_octets': '4253045053892',
                        'poller_hash': 'YjRmYmU0NzkzODkwcGVlcmludGY='
                    }, {
                        'in_octets': '4814326888',
                        'out_octets': '56750503034',
                        'poller_hash': 'YjRmYmU0Zjk1MzI1cGVlcmludGY='
                    }, {
                        'in_octets': '2397415516',
                        'out_octets': '55315559895',
                        'poller_hash': 'YjRmYmU0Zjk1MzYxcGVlcmludGY='
                    }, {
                        'in_octets': '2495620117',
                        'out_octets': '47790346452',
                        'poller_hash': 'YjRmYmU0Zjk1MzhlcGVlcmludGY='
                    }, {
                        'in_octets': '5567527266',
                        'out_octets': '87608301203',
                        'poller_hash': 'YjRmYmU0Zjk1MzlkcGVlcmludGY='
                    }, {
                        'in_octets': '318358605919',
                        'out_octets': '1370828170246',
                        'poller_hash': 'YjRmYmU0Zjk1NGY2cGVlcmludGY='
                    }, {
                        'in_octets': '28878540612',
                        'out_octets': '1205998367684',
                        'poller_hash': 'YjRmYmU0Zjk1NWEwcGVlcmludGY='
                    }, {
                        'in_octets': '1087759929785',
                        'out_octets': '6087336398467',
                        'poller_hash': 'ZDAyMWY5MDYxN2Y0cGVlcmludGY='
                    }, {
                        'in_octets': '24975444572',
                        'out_octets': '652878335304',
                        'poller_hash': 'ZDAyMWY5OWE4NWEwcGVlcmludGY='
                    }, {
                        'in_octets': '40171739322',
                        'out_octets': '458407159940',
                        'poller_hash': 'ZDAyMWY5OWFhNWMwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon7',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '145922480254925',
                    'out_ucast_pkts':
                    '113265860391',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uN2ludGY=',
                    'pons': [{
                        'id':
                        '7',
                        'links': [{
                            'connected_time': '12271343',
                            'fiber_length': 4399,
                            'poller_hash': 'Nzg4YTIwYzA0MTM2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1552736',
                            'fiber_length': 4701,
                            'poller_hash': 'MThlODI5MGJkYzY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6231806',
                            'fiber_length': 4462,
                            'poller_hash': 'MThlODI5MGJlMTYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9044622',
                            'fiber_length': 4405,
                            'poller_hash': 'MThlODI5MTk4MTI5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '258319',
                            'fiber_length': 4532,
                            'poller_hash': 'MThlODI5MTliNGEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875900',
                            'fiber_length': 5100,
                            'poller_hash': 'MThlODI5MTliNGE1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '258319',
                            'fiber_length': 4680,
                            'poller_hash': 'MThlODI5MTliNGU2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '258319',
                            'fiber_length': 4900,
                            'poller_hash': 'MThlODI5ZjVkNGY2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7869727',
                            'fiber_length': 4845,
                            'poller_hash': 'Nzg0NTU4MDYyODc4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10606172',
                            'fiber_length': 4862,
                            'poller_hash': 'NzRhY2I5MDY3YTlhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '258318',
                            'fiber_length': 4764,
                            'poller_hash': 'NzRhY2I5MDZhMmQxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10606902',
                            'fiber_length': 4495,
                            'poller_hash': 'NzQ4M2MyNDNlYzI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1281922',
                            'fiber_length': 4174,
                            'poller_hash': 'NzQ4M2MyNDNlYzJlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1551976',
                            'fiber_length': 5529,
                            'poller_hash': 'NzQ4M2MyNDNlYzY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2030922',
                            'fiber_length': 4668,
                            'poller_hash': 'NzQ4M2MyNDNlZGFlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6467229',
                            'fiber_length': 4875,
                            'poller_hash': 'NzQ4M2MyNDNmNTMycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4370472',
                            'fiber_length': 4225,
                            'poller_hash': 'NzQ4M2MyNjgzNjRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '258319',
                            'fiber_length': 4511,
                            'poller_hash': 'NzQ4M2MyNjhjNjU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '69737',
                            'fiber_length': 4480,
                            'poller_hash': 'ZmNlY2RhZWI5NTMzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8108281',
                            'fiber_length': 4700,
                            'poller_hash': 'YjRmYmU0NzkzNTA3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875910',
                            'fiber_length': 5145,
                            'poller_hash': 'YjRmYmU0NzkzODkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4043058',
                            'fiber_length': 4495,
                            'poller_hash': 'YjRmYmU0Zjk1MzI1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '258319',
                            'fiber_length': 4790,
                            'poller_hash': 'YjRmYmU0Zjk1MzYxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '258318',
                            'fiber_length': 4508,
                            'poller_hash': 'YjRmYmU0Zjk1MzhlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '258319',
                            'fiber_length': 4757,
                            'poller_hash': 'YjRmYmU0Zjk1MzlkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8212592',
                            'fiber_length': 4908,
                            'poller_hash': 'YjRmYmU0Zjk1NGY2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '13997742',
                            'fiber_length': 4487,
                            'poller_hash': 'YjRmYmU0Zjk1NWEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10946486',
                            'fiber_length': 4253,
                            'poller_hash': 'ZDAyMWY5MDYxN2Y0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1533016',
                            'fiber_length': 5525,
                            'poller_hash': 'ZDAyMWY5OWE4NWEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6400229',
                            'fiber_length': 4446,
                            'poller_hash': 'ZDAyMWY5OWFhNWMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon8',
                    'in_errors':
                    '0',
                    'in_octets':
                    '6737239656464',
                    'in_ucast_pkts':
                    '32726191160',
                    'links': [{
                        'in_octets': '1400990970',
                        'out_octets': '45006651096',
                        'poller_hash': 'MThlODI5MGI5NzY0cGVlcmludGY='
                    }, {
                        'in_octets': '10143187620',
                        'out_octets': '182340782047',
                        'poller_hash': 'MThlODI5MGJhZTY4cGVlcmludGY='
                    }, {
                        'in_octets': '145608047087',
                        'out_octets': '2154979290922',
                        'poller_hash': 'MThlODI5MGJkYmUwcGVlcmludGY='
                    }, {
                        'in_octets': '11259083628',
                        'out_octets': '283082342300',
                        'poller_hash': 'MThlODI5MTlhZTI0cGVlcmludGY='
                    }, {
                        'in_octets': '114759952567',
                        'out_octets': '3152745259419',
                        'poller_hash': 'MThlODI5ZjVkNDBmcGVlcmludGY='
                    }, {
                        'in_octets': '45267639156',
                        'out_octets': '1037467946612',
                        'poller_hash': 'MThlODI5ZjVkNGZlcGVlcmludGY='
                    }, {
                        'in_octets': '29545387833',
                        'out_octets': '1598354885334',
                        'poller_hash': 'Nzg0NTU4MDYyODc0cGVlcmludGY='
                    }, {
                        'in_octets': '3271692447',
                        'out_octets': '99727316536',
                        'poller_hash': 'NjhkNzlhMDY4ZDdkcGVlcmludGY='
                    }, {
                        'in_octets': '14201918403',
                        'out_octets': '160255367058',
                        'poller_hash': 'NzRhY2I5MDY3YTk2cGVlcmludGY='
                    }, {
                        'in_octets': '7015955001',
                        'out_octets': '240809337228',
                        'poller_hash': 'NzRhY2I5MDY3YWExcGVlcmludGY='
                    }, {
                        'in_octets': '6209297373',
                        'out_octets': '243959944123',
                        'poller_hash': 'ZjQ5MmJmMDY0MDExcGVlcmludGY='
                    }, {
                        'in_octets': '91775156756',
                        'out_octets': '1918832839941',
                        'poller_hash': 'ZjQ5MmJmMDY0YjU5cGVlcmludGY='
                    }, {
                        'in_octets': '16026785871',
                        'out_octets': '353244671616',
                        'poller_hash': 'ZjQ5MmJmMDZlNGQycGVlcmludGY='
                    }, {
                        'in_octets': '32937811937',
                        'out_octets': '983577417876',
                        'poller_hash': 'ZjQ5MmJmMDZlYzcxcGVlcmludGY='
                    }, {
                        'in_octets': '1172612681',
                        'out_octets': '5380764017',
                        'poller_hash': 'ZjQ5MmJmMDZmZWY4cGVlcmludGY='
                    }, {
                        'in_octets': '10163035123',
                        'out_octets': '346821063899',
                        'poller_hash': 'NzQ4M2MyNDNmNjVkcGVlcmludGY='
                    }, {
                        'in_octets': '140580169493',
                        'out_octets': '4445890193784',
                        'poller_hash': 'NzQ4M2MyNDNmOWNlcGVlcmludGY='
                    }, {
                        'in_octets': '17455000120',
                        'out_octets': '466352394676',
                        'poller_hash': 'NzQ4M2MyNjgzNTQxcGVlcmludGY='
                    }, {
                        'in_octets': '270759008586',
                        'out_octets': '2736147416377',
                        'poller_hash': 'NzQ4M2MyNjhiMTdjcGVlcmludGY='
                    }, {
                        'in_octets': '4775225144',
                        'out_octets': '151353552645',
                        'poller_hash': 'NzQ4M2MyNjhiMjA0cGVlcmludGY='
                    }, {
                        'in_octets': '9981271420',
                        'out_octets': '232157396114',
                        'poller_hash': 'ZmNlY2RhZWI5NTEwcGVlcmludGY='
                    }, {
                        'in_octets': '39211601708',
                        'out_octets': '1373772696207',
                        'poller_hash': 'YjRmYmU0ZTZjNTYycGVlcmludGY='
                    }, {
                        'in_octets': '27771790989',
                        'out_octets': '562147073262',
                        'poller_hash': 'YjRmYmU0ZTZkZjJicGVlcmludGY='
                    }, {
                        'in_octets': '2360114624',
                        'out_octets': '38485612988',
                        'poller_hash': 'YjRmYmU0Zjk0ZjUxcGVlcmludGY='
                    }, {
                        'in_octets': '8377562090',
                        'out_octets': '232491614152',
                        'poller_hash': 'YjRmYmU0Zjk1MzVjcGVlcmludGY='
                    }],
                    'manufacturer':
                    'UBNT',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon8',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '118955441630590',
                    'out_ucast_pkts':
                    '91820461913',
                    'poller_hash':
                    'Nzg4YTIwMGQ3NTdlcG9uOGludGY=',
                    'pons': [{
                        'id':
                        '8',
                        'links': [{
                            'connected_time': '951378',
                            'fiber_length': 5639,
                            'poller_hash': 'MThlODI5MGI5NzY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951908',
                            'fiber_length': 4628,
                            'poller_hash': 'MThlODI5MGJhZTY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8211872',
                            'fiber_length': 4848,
                            'poller_hash': 'MThlODI5MGJkYmUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3478391',
                            'fiber_length': 5085,
                            'poller_hash': 'MThlODI5MTlhZTI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875900',
                            'fiber_length': 4842,
                            'poller_hash': 'MThlODI5ZjVkNDBmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1952481',
                            'fiber_length': 4673,
                            'poller_hash': 'MThlODI5ZjVkNGZlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6293697',
                            'fiber_length': 4875,
                            'poller_hash': 'Nzg0NTU4MDYyODc0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1445644',
                            'fiber_length': 4839,
                            'poller_hash': 'NjhkNzlhMDY4ZDdkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '944748',
                            'fiber_length': 5350,
                            'poller_hash': 'NzRhY2I5MDY3YTk2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951388',
                            'fiber_length': 5461,
                            'poller_hash': 'NzRhY2I5MDY3YWExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1893320',
                            'fiber_length': 4687,
                            'poller_hash': 'ZjQ5MmJmMDY0MDExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875889',
                            'fiber_length': 4645,
                            'poller_hash': 'ZjQ5MmJmMDY0YjU5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '944748',
                            'fiber_length': 5297,
                            'poller_hash': 'ZjQ5MmJmMDZlNGQycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8875889',
                            'fiber_length': 5093,
                            'poller_hash': 'ZjQ5MmJmMDZlYzcxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951388',
                            'fiber_length': 5421,
                            'poller_hash': 'ZjQ5MmJmMDZmZWY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951388',
                            'fiber_length': 5203,
                            'poller_hash': 'NzQ4M2MyNDNmNjVkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8211732',
                            'fiber_length': 4811,
                            'poller_hash': 'NzQ4M2MyNDNmOWNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951388',
                            'fiber_length': 5701,
                            'poller_hash': 'NzQ4M2MyNjgzNTQxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8719758',
                            'fiber_length': 4670,
                            'poller_hash': 'NzQ4M2MyNjhiMTdjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951388',
                            'fiber_length': 5272,
                            'poller_hash': 'NzQ4M2MyNjhiMjA0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951388',
                            'fiber_length': 5607,
                            'poller_hash': 'ZmNlY2RhZWI5NTEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4236961',
                            'fiber_length': 5087,
                            'poller_hash': 'YjRmYmU0ZTZjNTYycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '944748',
                            'fiber_length': 5281,
                            'poller_hash': 'YjRmYmU0ZTZkZjJicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '695024',
                            'fiber_length': 4839,
                            'poller_hash': 'YjRmYmU0Zjk0ZjUxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '951378',
                            'fiber_length': 5233,
                            'poller_hash': 'YjRmYmU0Zjk1MzVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'poller_hash':
                        'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp1',
                    'in_octets': '92720176232376',
                    'in_ucast_pkts': '704683940205',
                    'manufacturer': 'FS',
                    'model': 'SFPP-AO01',
                    'name': 'SFP+ 1',
                    'oper_up': True,
                    'out_octets': '77929865681715',
                    'out_ucast_pkts': '289004505344',
                    'poller_hash': 'Nzg4YTIwMGQ3NTdlc2ZwMWludGY=',
                    'speed': '10000000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp2',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'SFP+ 2',
                    'oper_up': False,
                    'out_octets': '0',
                    'out_ucast_pkts': '0',
                    'poller_hash': 'Nzg4YTIwMGQ3NTdlc2ZwMmludGY='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                73.0,
                'model':
                'UFiber OLT',
                'serial_number':
                'UBNT200d757e',
                'sw_version':
                '4.4.8',
                'system_mac_address':
                '78:8a:20:0d:75:7e',
                'temperature':
                46.5,
                'uptime':
                '18446439'
            },
            'peers': [{
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '638956727639',
                    'links': [{
                        'in_octets': '638956727639',
                        'out_octets': '179849551975',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '179849551975',
                    'poller_hash':
                    'Nzg4YTIwYzA1N2VkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8211832',
                            'fiber_length': 1320,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.548,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.27
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg4YTIwYzA1N2VkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '179849551975',
                    'mac_address': '78:8a:20:c1:57:ed',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '638956727639',
                    'poller_hash': 'Nzg4YTIwYzA1N2VkZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'NutrienOffice-76414',
                'serial_number':
                'UBNT20c057ed',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:8a:20:c0:57:ed',
                'temperature':
                56.0,
                'uptime':
                '8211896'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '108035893022',
                    'links': [{
                        'in_octets': '108035893022',
                        'out_octets': '14085184931',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14085184931',
                    'poller_hash':
                    'MThlODI5MGJhZGNjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '10285398',
                            'fiber_length': 1516,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.456,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.22
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJhZGNjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '14085184931',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '108035893022',
                    'poller_hash': 'MThlODI5MGJhZGNjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '605DaqShack-96050',
                'serial_number':
                'UBNT290badcc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:ad:cc',
                'temperature':
                68.0,
                'uptime':
                '10285443'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '420422245790',
                    'links': [{
                        'in_octets': '420422245790',
                        'out_octets': '27114768126',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27114768126',
                    'poller_hash':
                    'MThlODI5MGJhZTBjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1894960',
                            'fiber_length': 7048,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.766,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.91
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJhZTBjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '27114768126',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '420422245790',
                    'poller_hash': 'MThlODI5MGJhZTBjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'JPerez-95045',
                'serial_number':
                'UBNT290bae0c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:ae:0c',
                'temperature':
                52.0,
                'uptime':
                '1895005'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '889910',
                    'links': [{
                        'in_octets': '889910',
                        'out_octets': '724992',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '724992',
                    'poller_hash':
                    'MThlODI5MTk1ZWQ4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '154778',
                            'fiber_length': 2309,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.506,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.616
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTk1ZWQ4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '724992',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '889910',
                    'poller_hash': 'MThlODI5MTk1ZWQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'DangFineTrucking-82660',
                'serial_number':
                'UBNT29195ed8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:5e:d8',
                'temperature':
                61.0,
                'uptime':
                '711901'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '226224681865',
                    'links': [{
                        'in_octets': '226224681865',
                        'out_octets': '3618395657',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3618395657',
                    'poller_hash':
                    'NzBhNzQxMzM0NjE0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1561946',
                            'fiber_length': 7053,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.718
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzM0NjE0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '3618395657',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '226224681865',
                    'poller_hash': 'NzBhNzQxMzM0NjE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'MThacker-96834',
                'serial_number':
                'UBNT41334614',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '70:a7:41:33:46:14',
                'temperature':
                50.0,
                'uptime':
                '2405929'
            }, {
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '643741211987',
                    'links': [{
                        'in_octets': '643741211987',
                        'out_octets': '19453255895',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '19453255895',
                    'poller_hash':
                    'NzBhNzQxMzM0NzA0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2330376',
                            'fiber_length': 2055,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.362,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.268
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzM0NzA0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '19453255895',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '643741211987',
                    'poller_hash': 'NzBhNzQxMzM0NzA0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'FMendoza-96851',
                'serial_number':
                'UBNT41334704',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '70:a7:41:33:47:04',
                'temperature':
                53.0,
                'uptime':
                '2330438'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '43749674446',
                    'links': [{
                        'in_octets': '43749674446',
                        'out_octets': '3779497855',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3779497855',
                    'poller_hash':
                    'Nzg0NTU4MDYyN2FkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '10631592',
                            'fiber_length': 2043,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.28,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.442
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyN2FkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '3779497855',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '43749674446',
                    'poller_hash': 'Nzg0NTU4MDYyN2FkZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'Evolve Nutrition - 92144',
                'serial_number':
                'UBNT580627ad',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:27:ad',
                'temperature':
                50.0,
                'uptime':
                '10631658'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '86070300007',
                    'links': [{
                        'in_octets': '86070300007',
                        'out_octets': '9426014032',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9426014032',
                    'poller_hash':
                    'NjhkNzlhMDY4MGMwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5090281',
                            'fiber_length': 2046,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.12,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.512
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY4MGMwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '9426014032',
                    'name': 'eth0',
                    'oper_up': False,
                    'out_octets': '86070300007',
                    'poller_hash': 'NjhkNzlhMDY4MGMwZXRoMQ=='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'CornerPlace-91104',
                'serial_number':
                'UBNT9a0680c0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '68:d7:9a:06:80:c0',
                'temperature':
                65.0,
                'uptime':
                '5090345'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '208093027582',
                    'links': [{
                        'in_octets': '208093027582',
                        'out_octets': '8050419182',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8050419182',
                    'poller_hash':
                    'NzRhY2I5MDY3YWEycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '697625',
                            'fiber_length': 7053,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.466,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.918
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5MDY3YWEycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '8050419182',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '208093027582',
                    'poller_hash': 'NzRhY2I5MDY3YWEyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'SCorona-95911',
                'serial_number':
                'UBNTb9067aa2',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:ac:b9:06:7a:a2',
                'temperature':
                46.0,
                'uptime':
                '697689'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '59257439890',
                    'links': [{
                        'in_octets': '59257439890',
                        'out_octets': '87290701862',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '87290701862',
                    'poller_hash':
                    'ZjQ5MmJmMDYyNmRicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '7604674',
                            'fiber_length': 2427,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.746,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.2
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDYyNmRicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '87290701862',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '59257439890',
                    'poller_hash': 'ZjQ5MmJmMDYyNmRiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'DimmitFeed-76493',
                'serial_number':
                'UBNTbf0626db',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '3.1.4',
                'system_mac_address':
                'f4:92:bf:06:26:db',
                'temperature':
                75.0,
                'uptime':
                '7604737'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '542132930745',
                    'links': [{
                        'in_octets': '542132930745',
                        'out_octets': '15461302098',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15461302098',
                    'poller_hash':
                    'ZjQ5MmJmMDZlYzkwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1112060',
                            'fiber_length': 2338,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.554,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.476
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlYzkwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '15461302098',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '542132930745',
                    'poller_hash': 'ZjQ5MmJmMDZlYzkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'RGauna - 93421',
                'serial_number':
                'UBNTbf06ec90',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:ec:90',
                'temperature':
                66.0,
                'uptime':
                '1112128'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1206183795600',
                    'links': [{
                        'in_octets': '1206183795600',
                        'out_octets': '41377528576',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '41377528576',
                    'poller_hash':
                    'ZjQ5MmJmMDZmNDI2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1357543',
                            'fiber_length': 2424,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.134,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.13
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmNDI2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '41377528576',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1206183795600',
                    'poller_hash': 'ZjQ5MmJmMDZmNDI2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'JVillarreal-93379',
                'serial_number':
                'UBNTbf06f426',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:f4:26',
                'temperature':
                63.0,
                'uptime':
                '1357614'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1868780133360',
                    'links': [{
                        'in_octets': '1868780133360',
                        'out_octets': '40910398644',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '40910398644',
                    'poller_hash':
                    'ZmNlY2RhZWJmOWZicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2770091',
                            'fiber_length': 1812,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.408,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.196
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZmNlY2RhZWJmOWZicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '40910398644',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1868780133360',
                    'poller_hash': 'ZmNlY2RhZWJmOWZiZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'JHinjosa-85795',
                'serial_number':
                'UBNTdaebf9fb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'fc:ec:da:eb:f9:fb',
                'temperature':
                60.0,
                'uptime':
                '2770141'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2145749122952',
                    'links': [{
                        'in_octets': '2145749122952',
                        'out_octets': '44679978425',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '44679978425',
                    'poller_hash':
                    'YjRmYmU0NzkzNDQ5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '7671675',
                            'fiber_length': 7047,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.766,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.94
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzNDQ5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '44679978425',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2145749122952',
                    'poller_hash': 'YjRmYmU0NzkzNDQ5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'CPriest-96257',
                'serial_number':
                'UBNTe4793449',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:34:49',
                'temperature':
                53.0,
                'uptime':
                '7671727'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '953788902578',
                    'links': [{
                        'in_octets': '953788902578',
                        'out_octets': '125842620753',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '125842620753',
                    'poller_hash':
                    'YjRmYmU0NzkzODEzcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2770092',
                            'fiber_length': 1838,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.426,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.146
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzODEzcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '125842620753',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '953788902578',
                    'poller_hash': 'YjRmYmU0NzkzODEzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'SNavarro-82075',
                'serial_number':
                'UBNTe4793813',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:38:13',
                'temperature':
                66.0,
                'uptime':
                '2770140'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '58090936365',
                    'links': [{
                        'in_octets': '58090936365',
                        'out_octets': '8245931261',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8245931261',
                    'poller_hash':
                    'YjRmYmU0NzkzYmI1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2837852',
                            'fiber_length': 1417,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.0,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.638
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzYmI1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '8245931261',
                    'mac_address': 'b4:fb:e4:7a:3b:b5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '58090936365',
                    'poller_hash': 'YjRmYmU0NzkzYmI1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'NanoG',
                'name':
                'CityofDimmittUtilityWarehouse-87769',
                'serial_number':
                'UBNTe4793bb5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:3b:b5',
                'temperature':
                80.0,
                'uptime':
                '2837903'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '9141049979702',
                    'links': [{
                        'in_octets': '9141049979702',
                        'out_octets': '1251800419593',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1251800419593',
                    'poller_hash':
                    'YjRmYmU0ZTZjZjNmcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '18445256',
                            'fiber_length': 1849,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.878,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.054
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZjZjNmcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1251800419593',
                    'mac_address': 'b4:fb:e4:e7:cf:3f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '9141049979702',
                    'poller_hash': 'YjRmYmU0ZTZjZjNmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'CastroCountyJail-83479',
                'serial_number':
                'UBNTe4e6cf3f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:cf:3f',
                'temperature':
                59.0,
                'uptime':
                '18445321'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '252653365066',
                    'links': [{
                        'in_octets': '252653365066',
                        'out_octets': '55763109025',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '55763109025',
                    'poller_hash':
                    'YjRmYmU0Zjk1NTMycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3122006',
                            'fiber_length': 1489,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.482,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.566
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1NTMycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '55763109025',
                    'mac_address': 'b4:fb:e4:fa:55:32',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '252653365066',
                    'poller_hash': 'YjRmYmU0Zjk1NTMyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'NutrienWeighStation-79513 ',
                'serial_number':
                'UBNTe4f95532',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:55:32',
                'temperature':
                48.0,
                'uptime':
                '3122074'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '38407107231',
                    'links': [{
                        'in_octets': '38407107231',
                        'out_octets': '1804895322',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1804895322',
                    'poller_hash':
                    'YjRmYmU0Zjk1Nzk0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5254723',
                            'fiber_length': 1698,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.996,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.46
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1Nzk0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1804895322',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '38407107231',
                    'poller_hash': 'YjRmYmU0Zjk1Nzk0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'HighwayAutoGlass-77130',
                'serial_number':
                'UBNTe4f95794',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:57:94',
                'temperature':
                56.0,
                'uptime':
                '5254786'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '963132757240',
                    'links': [{
                        'in_octets': '963132757240',
                        'out_octets': '1717409162210',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1717409162210',
                    'poller_hash':
                    'YjRmYmU0ZjlkY2M4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '13997733',
                            'fiber_length': 2269,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.614,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.428
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZjlkY2M4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1717409162210',
                    'mac_address': 'b4:fb:e4:fa:dc:c8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '963132757240',
                    'poller_hash': 'YjRmYmU0ZjlkY2M4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                "Gary'sEngine&Machine-83276",
                'serial_number':
                'UBNTe4f9dcc8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:dc:c8',
                'temperature':
                58.0,
                'uptime':
                '13997807'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '9051885600',
                    'links': [{
                        'in_octets': '9051885600',
                        'out_octets': '6638375779',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6638375779',
                    'poller_hash':
                    'Nzg4YTIwNzNkMDRkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1124230',
                            'fiber_length': 2652,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.676,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.15
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg4YTIwNzNkMDRkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '6638375779',
                    'mac_address': '78:8a:20:74:d0:4d',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '9051885600',
                    'poller_hash': 'Nzg4YTIwNzNkMDRkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                'SealesByWalkingG-96794',
                'serial_number':
                'UBNT2073d04d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:8a:20:73:d0:4d',
                'temperature':
                66.0,
                'uptime':
                '1124280'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '196986725734',
                    'links': [{
                        'in_octets': '196986725734',
                        'out_octets': '48203031319',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48203031319',
                    'poller_hash':
                    'MThlODI5MGI5YmQ4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8212952',
                            'fiber_length': 2415,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.022
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI5YmQ4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '48203031319',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '196986725734',
                    'poller_hash': 'MThlODI5MGI5YmQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                "Mario's Heating and Air Conditioning "
                '- 85808',
                'serial_number':
                'UBNT290b9bd8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:9b:d8',
                'temperature':
                60.0,
                'uptime':
                '8212997'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '114628485556',
                    'links': [{
                        'in_octets': '114628485556',
                        'out_octets': '62469214802',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '62469214802',
                    'poller_hash':
                    'MThlODI5MGJiMDNjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1724128',
                            'fiber_length': 3871,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.24
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJiMDNjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '62469214802',
                    'mac_address': '18:e8:29:0c:b0:3c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '114628485556',
                    'poller_hash': 'MThlODI5MGJiMDNjZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                'WBEquipment-76404',
                'serial_number':
                'UBNT290bb03c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:b0:3c',
                'temperature':
                70.0,
                'uptime':
                '1724181'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1197908503688',
                    'links': [{
                        'in_octets': '1197908503688',
                        'out_octets': '18271868481',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18271868481',
                    'poller_hash':
                    'MThlODI5MGJiMGUwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1473875',
                            'fiber_length': 4321,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.864
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJiMGUwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '18271868481',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1197908503688',
                    'poller_hash': 'MThlODI5MGJiMGUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'BGriswold-96935',
                'serial_number':
                'UBNT290bb0e0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:b0:e0',
                'temperature':
                56.0,
                'uptime':
                '1473921'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '831964002475',
                    'links': [{
                        'in_octets': '831964002475',
                        'out_octets': '34745283466',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '34745283466',
                    'poller_hash':
                    'MThlODI5MGJkOWY4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875910',
                            'fiber_length': 5060,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.086,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.606
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJkOWY4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '34745283466',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '831964002475',
                    'poller_hash': 'MThlODI5MGJkOWY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'DGoldsmith-95707',
                'serial_number':
                'UBNT290bd9f8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:d9:f8',
                'temperature':
                60.0,
                'uptime':
                '8875964'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '982932634011',
                    'links': [{
                        'in_octets': '982932634011',
                        'out_octets': '72343703573',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '72343703573',
                    'poller_hash':
                    'MThlODI5MGJkYjI4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875910',
                            'fiber_length': 5269,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.756,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.354
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJkYjI4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '72343703573',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '982932634011',
                    'poller_hash': 'MThlODI5MGJkYjI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                'AMartinez - 94229',
                'serial_number':
                'UBNT290bdb28',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:db:28',
                'temperature':
                51.0,
                'uptime':
                '8875964'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1116519254825',
                    'links': [{
                        'in_octets': '1116519254825',
                        'out_octets': '24745638195',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24745638195',
                    'poller_hash':
                    'MThlODI5MTk1ZWZicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1895250',
                            'fiber_length': 7204,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.87,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.84
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTk1ZWZicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '24745638195',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1116519254825',
                    'poller_hash': 'MThlODI5MTk1ZWZiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'ZPrice-83277',
                'serial_number':
                'UBNT29195efb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:5e:fb',
                'temperature':
                53.0,
                'uptime':
                '1895314'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '605235713138',
                    'links': [{
                        'in_octets': '605235713138',
                        'out_octets': '136693130145',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '136693130145',
                    'poller_hash':
                    'MThlODI5MTk1ZjAwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8212252',
                            'fiber_length': 2391,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.766,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.252
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTk1ZjAwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '136693130145',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '605235713138',
                    'poller_hash': 'MThlODI5MTk1ZjAwZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'SchafferCommunityCenter-83330',
                'serial_number':
                'UBNT29195f00',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:5f:00',
                'temperature':
                52.0,
                'uptime':
                '8212315'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '231627713235',
                    'links': [{
                        'in_octets': '231627713235',
                        'out_octets': '117387156998',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '117387156998',
                    'poller_hash':
                    'MThlODI5MTliNDVhcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '4156670',
                            'fiber_length': 2595,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.372,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.196
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTliNDVhcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '117387156998',
                    'mac_address': '18:e8:29:1a:b4:5a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '231627713235',
                    'poller_hash': 'MThlODI5MTliNDVhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'HigginbothamBrothers-80554',
                'serial_number':
                'UBNT2919b45a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:b4:5a',
                'temperature':
                58.0,
                'uptime':
                '4156737'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '170550531593',
                    'links': [{
                        'in_octets': '170550531593',
                        'out_octets': '18448983292',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18448983292',
                    'poller_hash':
                    'MThlODI5ZjVkNGZicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875900',
                            'fiber_length': 5279,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.076,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.366
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5ZjVkNGZicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '18448983292',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '170550531593',
                    'poller_hash': 'MThlODI5ZjVkNGZiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'DBall-88672',
                'serial_number':
                'UBNT29f5d4fb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:f5:d4:fb',
                'temperature':
                65.0,
                'uptime':
                '8875963'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '268140789420',
                    'links': [{
                        'in_octets': '268140789420',
                        'out_octets': '15335038841',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15335038841',
                    'poller_hash':
                    'NzBhNzQxMzM0NTVjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1540616',
                            'fiber_length': 5493,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.01,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.128
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzM0NTVjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '15335038841',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '268140789420',
                    'poller_hash': 'NzBhNzQxMzM0NTVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'JRedman-96785',
                'serial_number':
                'UBNT4133455c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '70:a7:41:33:45:5c',
                'temperature':
                51.0,
                'uptime':
                '1540684'
            }, {
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '68994168461',
                    'links': [{
                        'in_octets': '68994168461',
                        'out_octets': '3837806666',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3837806666',
                    'poller_hash':
                    'NzBhNzQxMzM0NmVjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1647767',
                            'fiber_length': 7683,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.216
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzM0NmVjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '3837806666',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '68994168461',
                    'poller_hash': 'NzBhNzQxMzM0NmVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'RHunter-96872',
                'serial_number':
                'UBNT413346ec',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '70:a7:41:33:46:ec',
                'temperature':
                60.0,
                'uptime':
                '1647836'
            }, {
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '406060361177',
                    'links': [{
                        'in_octets': '406060361177',
                        'out_octets': '13194846514',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13194846514',
                    'poller_hash':
                    'Nzg0NTU4MDYyNzdkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1356783',
                            'fiber_length': 4336,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.792
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyNzdkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '13194846514',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '406060361177',
                    'poller_hash': 'Nzg0NTU4MDYyNzdkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'MRichardson-92770',
                'serial_number':
                'UBNT5806277d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:27:7d',
                'temperature':
                47.0,
                'uptime':
                '1356857'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '37687610599',
                    'links': [{
                        'in_octets': '37687610599',
                        'out_octets': '3115670170',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3115670170',
                    'poller_hash':
                    'Nzg0NTU4OWE1MzI4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236324',
                            'fiber_length': 2608,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.746,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.774
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OWE1MzI4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '3115670170',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '37687610599',
                    'poller_hash': 'Nzg0NTU4OWE1MzI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Salina’s Salon-96068',
                'serial_number':
                'UBNT589a5328',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:9a:53:28',
                'temperature':
                55.0,
                'uptime':
                '2236390'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '266949474443',
                    'links': [{
                        'in_octets': '266949474443',
                        'out_octets': '296983902667',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '296983902667',
                    'poller_hash':
                    'Nzg0NTU4OWE1YjQwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236315',
                            'fiber_length': 2889,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.564,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.784
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OWE1YjQwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '296983902667',
                    'mac_address': '78:45:58:9b:5b:40',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '266949474443',
                    'poller_hash': 'Nzg0NTU4OWE1YjQwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'City of Dimmitt Police Annex -93658',
                'serial_number':
                'UBNT589a5b40',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:9a:5b:40',
                'temperature':
                62.0,
                'uptime':
                '2236390'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '76290298954',
                    'links': [{
                        'in_octets': '76290298954',
                        'out_octets': '6220961177',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6220961177',
                    'poller_hash':
                    'NjhkNzlhMDY2N2E5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '7690875',
                            'fiber_length': 4887,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.924,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.67
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY2N2E5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '6220961177',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '76290298954',
                    'poller_hash': 'NjhkNzlhMDY2N2E5ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'DProffitt-96297',
                'serial_number':
                'UBNT9a0667a9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '68:d7:9a:06:67:a9',
                'temperature':
                50.0,
                'uptime':
                '7690945'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '290485823710',
                    'links': [{
                        'in_octets': '290485823710',
                        'out_octets': '10910353252',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10910353252',
                    'poller_hash':
                    'NjhkNzlhMDY4MjNlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1471145',
                            'fiber_length': 4859,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.022,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.034
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY4MjNlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '10910353252',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '290485823710',
                    'poller_hash': 'NjhkNzlhMDY4MjNlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'ATrevino-94079',
                'serial_number':
                'UBNT9a06823e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '68:d7:9a:06:82:3e',
                'temperature':
                54.0,
                'uptime':
                '1471210'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '0',
                    'links': [{
                        'in_octets': '0',
                        'out_octets': '94',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '94',
                    'poller_hash':
                    'NzRhY2I5MDY3MzFicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '4152150',
                            'fiber_length': 2597,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.088,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.098
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5MDY3MzFicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '94',
                    'mac_address': '74:ac:b9:07:73:1b',
                    'name': 'eth0',
                    'oper_up': False,
                    'out_octets': '0',
                    'poller_hash': 'NzRhY2I5MDY3MzFiZXRoMQ=='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'Velocity/HigginbothamBrothers-96609',
                'serial_number':
                'UBNTb906731b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:ac:b9:06:73:1b',
                'temperature':
                48.0,
                'uptime':
                '4152212'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '654488670780',
                    'links': [{
                        'in_octets': '654488670780',
                        'out_octets': '27678239346',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27678239346',
                    'poller_hash':
                    'ZjQ5MmJmMDY0YjU1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1473875',
                            'fiber_length': 4403,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.676,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.49
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDY0YjU1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '27678239346',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '654488670780',
                    'poller_hash': 'ZjQ5MmJmMDY0YjU1ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'EGonzalez-92231',
                'serial_number':
                'UBNTbf064b55',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:4b:55',
                'temperature':
                51.0,
                'uptime':
                '1473946'
            }, {
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '363453761035',
                    'links': [{
                        'in_octets': '363453761035',
                        'out_octets': '16690572524',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '16690572524',
                    'poller_hash':
                    'NzQ4M2MyNDNmNTg1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3807335',
                            'fiber_length': 5470,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.948,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.178
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNTg1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '16690572524',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '363453761035',
                    'poller_hash': 'NzQ4M2MyNDNmNTg1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'DUnderwood-83151',
                'serial_number':
                'UBNTc243f585',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f5:85',
                'temperature':
                51.0,
                'uptime':
                '3807406'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '47229884893',
                    'links': [{
                        'in_octets': '47229884893',
                        'out_octets': '51559726570',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '51559726570',
                    'poller_hash':
                    'NzQ4M2MyNDNmN2ZicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236325',
                            'fiber_length': 3127,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.766,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.486
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmN2ZicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '51559726570',
                    'mac_address': '74:83:c2:44:f7:fb',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '47229884893',
                    'poller_hash': 'NzQ4M2MyNDNmN2ZiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'Lowes10-86941',
                'serial_number':
                'UBNTc243f7fb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f7:fb',
                'temperature':
                71.0,
                'uptime':
                '2236390'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '193153843467',
                    'links': [{
                        'in_octets': '193153843467',
                        'out_octets': '12647139104',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12647139104',
                    'poller_hash':
                    'NzQ4M2MyNjgyOWQ1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2761781',
                            'fiber_length': 7273,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.596,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.226
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjgyOWQ1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '12647139104',
                    'mac_address': '74:83:c2:69:29:d5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '193153843467',
                    'poller_hash': 'NzQ4M2MyNjgyOWQ1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'KRushing-90930',
                'serial_number':
                'UBNTc26829d5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:29:d5',
                'temperature':
                50.0,
                'uptime':
                '4583488'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '34167819865',
                    'links': [{
                        'in_octets': '34167819865',
                        'out_octets': '15301645109',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15301645109',
                    'poller_hash':
                    'NzQ4M2MyNjhhZmEycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236345',
                            'fiber_length': 2578,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.042,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.726
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhhZmEycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '15301645109',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '34167819865',
                    'poller_hash': 'NzQ4M2MyNjhhZmEyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'NanoG',
                'name':
                'CastroCountyNews - 34313',
                'serial_number':
                'UBNTc268afa2',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:af:a2',
                'temperature':
                63.0,
                'uptime':
                '2236391'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '7743341853',
                    'links': [{
                        'in_octets': '7743341853',
                        'out_octets': '451154402',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '451154402',
                    'poller_hash':
                    'NzQ4M2MyNjhjNTg1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236344',
                            'fiber_length': 3254,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.44,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.806
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhjNTg1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '451154402',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '7743341853',
                    'poller_hash': 'NzQ4M2MyNjhjNTg1ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'DimmittFirstAssemblyOfGod-89678',
                'serial_number':
                'UBNTc268c585',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:c5:85',
                'temperature':
                55.0,
                'uptime':
                '2236392'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '82358478455',
                    'links': [{
                        'in_octets': '82358478455',
                        'out_octets': '64667525251',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '64667525251',
                    'poller_hash':
                    'NzQ4M2MyNjhjNWE5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236345',
                            'fiber_length': 3115,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.924,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.722
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhjNWE5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '64667525251',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '82358478455',
                    'poller_hash': 'NzQ4M2MyNjhjNWE5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                'BovineDiagnostics-89256',
                'serial_number':
                'UBNTc268c5a9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:c5:a9',
                'temperature':
                61.0,
                'uptime':
                '2236392'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '52589305598',
                    'links': [{
                        'in_octets': '52589305598',
                        'out_octets': '733420160517',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '733420160517',
                    'poller_hash':
                    'ZmNlY2RhZTBmMjYycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1562096',
                            'fiber_length': 2399,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.676,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.148
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZmNlY2RhZTBmMjYycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '733420160517',
                    'mac_address': 'fc:ec:da:e1:f2:62',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '52589305598',
                    'poller_hash': 'ZmNlY2RhZTBmMjYyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'NanoG',
                'name':
                'CCAbstractTitle-85531',
                'serial_number':
                'UBNTdae0f262',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'fc:ec:da:e0:f2:62',
                'temperature':
                62.0,
                'uptime':
                '1562145'
            }, {
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '359940158363',
                    'links': [{
                        'in_octets': '359940158363',
                        'out_octets': '17750737146',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17750737146',
                    'poller_hash':
                    'ZmNlY2RhZWI5NTZhcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236325',
                            'fiber_length': 2762,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.684,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.434
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZmNlY2RhZWI5NTZhcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '17750737146',
                    'mac_address': 'fc:ec:da:ec:95:6a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '359940158363',
                    'poller_hash': 'ZmNlY2RhZWI5NTZhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'CastroCountyLibrary-83485',
                'serial_number':
                'UBNTdaeb956a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'fc:ec:da:eb:95:6a',
                'temperature':
                58.0,
                'uptime':
                '2236389'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '217700',
                    'links': [{
                        'in_octets': '217700',
                        'out_octets': '1214411',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1214411',
                    'poller_hash':
                    'ZmNlY2RhZWI5YmNkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '873427',
                            'fiber_length': 2744,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.558,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.898
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZmNlY2RhZWI5YmNkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1214411',
                    'mac_address': 'fc:ec:da:ec:9b:cd',
                    'name': 'eth0',
                    'oper_up': False,
                    'out_octets': '217700',
                    'poller_hash': 'ZmNlY2RhZWI5YmNkZXRoMQ=='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'CastroCountyRoss-83484',
                'serial_number':
                'UBNTdaeb9bcd',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'fc:ec:da:eb:9b:cd',
                'temperature':
                51.0,
                'uptime':
                '873490'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '29992066797',
                    'links': [{
                        'in_octets': '29992066797',
                        'out_octets': '16340708945',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '16340708945',
                    'poller_hash':
                    'YjRmYmU0NzkzNDM1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236344',
                            'fiber_length': 3236,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.558,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.782
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzNDM1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '16340708945',
                    'mac_address': 'b4:fb:e4:7a:34:35',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '29992066797',
                    'poller_hash': 'YjRmYmU0NzkzNDM1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                'PebsworthInsurance-79365',
                'serial_number':
                'UBNTe4793435',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:34:35',
                'temperature':
                72.0,
                'uptime':
                '2236392'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '376367532541',
                    'links': [{
                        'in_octets': '376367532541',
                        'out_octets': '43476043526',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '43476043526',
                    'poller_hash':
                    'YjRmYmU0NzkzOTNmcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '13997763',
                            'fiber_length': 2625,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.006,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.036
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzOTNmcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '43476043526',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '376367532541',
                    'poller_hash': 'YjRmYmU0NzkzOTNmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'NanoG',
                'name':
                'Stampede-92676',
                'serial_number':
                'UBNTe479393f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:39:3f',
                'temperature':
                62.0,
                'uptime':
                '13997810'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '708550786866',
                    'links': [{
                        'in_octets': '708550786866',
                        'out_octets': '39380962626',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '39380962626',
                    'poller_hash':
                    'YjRmYmU0ZTZjNGE5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1473845',
                            'fiber_length': 4623,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.978,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.796
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZjNGE5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '39380962626',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '708550786866',
                    'poller_hash': 'YjRmYmU0ZTZjNGE5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'MOviedo-84381',
                'serial_number':
                'UBNTe4e6c4a9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:c4:a9',
                'temperature':
                71.0,
                'uptime':
                '1473916'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '54698871226',
                    'links': [{
                        'in_octets': '54698871226',
                        'out_octets': '12791422536',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12791422536',
                    'poller_hash':
                    'YjRmYmU0ZTZjZjI1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '11737786',
                            'fiber_length': 2560,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.87,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.236
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZjZjI1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '12791422536',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '54698871226',
                    'poller_hash': 'YjRmYmU0ZTZjZjI1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'BBQ2Go-95462',
                'serial_number':
                'UBNTe4e6cf25',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:cf:25',
                'temperature':
                59.0,
                'uptime':
                '11737852'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '125648534287',
                    'links': [{
                        'in_octets': '125648534287',
                        'out_octets': '7699521486',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7699521486',
                    'poller_hash':
                    'YjRmYmU0ZTZjZjU4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2761781',
                            'fiber_length': 7158,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.408,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.836
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZjZjU4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '7699521486',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '125648534287',
                    'poller_hash': 'YjRmYmU0ZTZjZjU4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'FBruegel-78174',
                'serial_number':
                'UBNTe4e6cf58',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:cf:58',
                'temperature':
                64.0,
                'uptime':
                '4295514'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '737747228139',
                    'links': [{
                        'in_octets': '737747228139',
                        'out_octets': '37276557970',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '37276557970',
                    'poller_hash':
                    'YjRmYmU0ZTZlMWVkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1473624',
                            'fiber_length': 4572,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.088,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.256
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlMWVkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '37276557970',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '737747228139',
                    'poller_hash': 'YjRmYmU0ZTZlMWVkZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'BAcker-82354',
                'serial_number':
                'UBNTe4e6e1ed',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:e1:ed',
                'temperature':
                56.0,
                'uptime':
                '1473687'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '42368105659',
                    'links': [{
                        'in_octets': '42368105659',
                        'out_octets': '2606907686',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2606907686',
                    'poller_hash':
                    'YjRmYmU0ZTZlMjlhcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1473625',
                            'fiber_length': 4502,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.858
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlMjlhcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '2606907686',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '42368105659',
                    'poller_hash': 'YjRmYmU0ZTZlMjlhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'KPaxton-76553',
                'serial_number':
                'UBNTe4e6e29a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:e2:9a',
                'temperature':
                55.0,
                'uptime':
                '1473686'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1176560583068',
                    'links': [{
                        'in_octets': '1176560583068',
                        'out_octets': '48529894030',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48529894030',
                    'poller_hash':
                    'YjRmYmU0Zjk1MDNjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5688569',
                            'fiber_length': 7211,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.428
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1MDNjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '48529894030',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1176560583068',
                    'poller_hash': 'YjRmYmU0Zjk1MDNjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'CGilbreath-76809',
                'serial_number':
                'UBNTe4f9503c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:50:3c',
                'temperature':
                63.0,
                'uptime':
                '5688638'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2325325057591',
                    'links': [{
                        'in_octets': '2325325057591',
                        'out_octets': '112918238146',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '112918238146',
                    'poller_hash':
                    'YjRmYmU0Zjk1M2EycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5334595',
                            'fiber_length': 2381,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.086,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.738
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1M2EycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '112918238146',
                    'mac_address': 'b4:fb:e4:fa:53:a2',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2325325057591',
                    'poller_hash': 'YjRmYmU0Zjk1M2EyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'Loco',
                'name':
                'TheMavrickontheSquare-92535',
                'serial_number':
                'UBNTe4f953a2',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:53:a2',
                'temperature':
                61.0,
                'uptime':
                '5412215'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '668452474612',
                    'links': [{
                        'in_octets': '668452474612',
                        'out_octets': '285854656952',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '285854656952',
                    'poller_hash':
                    'YjRmYmU0ZjlkYjM4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3644593',
                            'fiber_length': 3222,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.664,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.58
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZjlkYjM4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '285854656952',
                    'mac_address': 'b4:fb:e4:fa:db:38',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '668452474612',
                    'poller_hash': 'YjRmYmU0ZjlkYjM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'CastroCountyCourtHouse-83475',
                'serial_number':
                'UBNTe4f9db38',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:db:38',
                'temperature':
                50.0,
                'uptime':
                '3644661'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '328400160555',
                    'links': [{
                        'in_octets': '328400160555',
                        'out_octets': '64512637049',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '64512637049',
                    'poller_hash':
                    'ZDAyMWY5MDYxZjY0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '7778616',
                            'fiber_length': 7300,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.788,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.866
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5MDYxZjY0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '64512637049',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '328400160555',
                    'poller_hash': 'ZDAyMWY5MDYxZjY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'LJurado-93847',
                'serial_number':
                'UBNTf9061f64',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'd0:21:f9:06:1f:64',
                'temperature':
                73.0,
                'uptime':
                '8876413'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '75952505532',
                    'links': [{
                        'in_octets': '75952505532',
                        'out_octets': '8228731278',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8228731278',
                    'poller_hash':
                    'ZDAyMWY5OWE4MzQ4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2761781',
                            'fiber_length': 7224,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.076,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.67
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE4MzQ4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '8228731278',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '75952505532',
                    'poller_hash': 'ZDAyMWY5OWE4MzQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'DProffitt PC-96299',
                'serial_number':
                'UBNTf99a8348',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'd0:21:f9:9a:83:48',
                'temperature':
                62.0,
                'uptime':
                '3297881'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '44974624559',
                    'links': [{
                        'in_octets': '44974624559',
                        'out_octets': '5699519514',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5699519514',
                    'poller_hash':
                    'ZDAyMWY5OWE4NDZjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951638',
                            'fiber_length': 2789,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.466,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.4
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE4NDZjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '5699519514',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '44974624559',
                    'poller_hash': 'ZDAyMWY5OWE4NDZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'ExtremeDetailing-82089',
                'serial_number':
                'UBNTf99a846c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'd0:21:f9:9a:84:6c',
                'temperature':
                60.0,
                'uptime':
                '951689'
            }, {
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '354539529981',
                    'links': [{
                        'in_octets': '354539529981',
                        'out_octets': '26916477814',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '26916477814',
                    'poller_hash':
                    'Nzg4YTIwYzA0NDI0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1720528',
                            'fiber_length': 3802,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.186,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.218
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg4YTIwYzA0NDI0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '26916477814',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '354539529981',
                    'poller_hash': 'Nzg4YTIwYzA0NDI0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'LLunsford-77627',
                'serial_number':
                'UBNT20c04424',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:8a:20:c0:44:24',
                'temperature':
                53.0,
                'uptime':
                '2236590'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '21736665',
                    'links': [{
                        'in_octets': '21736665',
                        'out_octets': '52470755',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '52470755',
                    'poller_hash':
                    'MThlODI5MGI3YjIwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236345',
                            'fiber_length': 3077,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.808,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.852
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI3YjIwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '52470755',
                    'name': 'eth0',
                    'oper_up': False,
                    'out_octets': '21736665',
                    'poller_hash': 'MThlODI5MGI3YjIwZXRoMQ=='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'VMartinez-83158',
                'serial_number':
                'UBNT290b7b20',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:7b:20',
                'temperature':
                70.0,
                'uptime':
                '2236392'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '47870585596',
                    'links': [{
                        'in_octets': '47870585596',
                        'out_octets': '6073705015',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6073705015',
                    'poller_hash':
                    'MThlODI5MGI5OTZjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '403281',
                            'fiber_length': 6725,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.19,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.216
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI5OTZjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '6073705015',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '47870585596',
                    'poller_hash': 'MThlODI5MGI5OTZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'NanoG',
                'name':
                'TexasPanhandleLogistics-94290',
                'serial_number':
                'UBNT290b996c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:99:6c',
                'temperature':
                56.0,
                'uptime':
                '403330'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '539359714979',
                    'links': [{
                        'in_octets': '539359714979',
                        'out_octets': '22898687137',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '22898687137',
                    'poller_hash':
                    'MThlODI5MGJiMGQwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5249294',
                            'fiber_length': 3213,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.586,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.418
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJiMGQwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '22898687137',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '539359714979',
                    'poller_hash': 'MThlODI5MGJiMGQwZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'ESaenz-95379',
                'serial_number':
                'UBNT290bb0d0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:b0:d0',
                'temperature':
                58.0,
                'uptime':
                '8963061'
            }, {
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '868444339701',
                    'links': [{
                        'in_octets': '868444339701',
                        'out_octets': '72746249726',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '72746249726',
                    'poller_hash':
                    'MThlODI5MTk1YTgycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3122296',
                            'fiber_length': 6693,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.412
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTk1YTgycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '72746249726',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '868444339701',
                    'poller_hash': 'MThlODI5MTk1YTgyZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'CGregory-83114',
                'serial_number':
                'UBNT29195a82',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:5a:82',
                'temperature':
                58.0,
                'uptime':
                '4583587'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '13161400',
                    'links': [{
                        'in_octets': '13161400',
                        'out_octets': '100191774',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '100191774',
                    'poller_hash':
                    'MThlODI5ZjVkM2NkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236325',
                            'fiber_length': 2942,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.042,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.742
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5ZjVkM2NkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '100191774',
                    'mac_address': '18:e8:29:f6:d3:cd',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '13161400',
                    'poller_hash': 'MThlODI5ZjVkM2NkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'Happy State Bank-88420',
                'serial_number':
                'UBNT29f5d3cd',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:f5:d3:cd',
                'temperature':
                47.0,
                'uptime':
                '2236390'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '38862993188',
                    'links': [{
                        'in_octets': '38862993188',
                        'out_octets': '16057965159',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '16057965159',
                    'poller_hash':
                    'MThlODI5ZjVkNGJlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1728578',
                            'fiber_length': 3934,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.924,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.632
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5ZjVkNGJlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '16057965159',
                    'mac_address': '18:e8:29:f6:d4:be',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '38862993188',
                    'poller_hash': 'MThlODI5ZjVkNGJlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'FirstUnitedBankDimmitt-76416',
                'serial_number':
                'UBNT29f5d4be',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:f5:d4:be',
                'temperature':
                50.0,
                'uptime':
                '2236625'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '319737295861',
                    'links': [{
                        'in_octets': '319737295861',
                        'out_octets': '11633928406',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11633928406',
                    'poller_hash':
                    'NzBhNzQxMzM0NDQ0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1562996',
                            'fiber_length': 6703,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.804,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.438
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzM0NDQ0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '11633928406',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '319737295861',
                    'poller_hash': 'NzBhNzQxMzM0NDQ0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'IVela-94386',
                'serial_number':
                'UBNT41334444',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '70:a7:41:33:44:44',
                'temperature':
                53.0,
                'uptime':
                '1563061'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '20811592604',
                    'links': [{
                        'in_octets': '20811592604',
                        'out_octets': '1122169150',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1122169150',
                    'poller_hash':
                    'NzBhNzQxMzM0NmUwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '522143',
                            'fiber_length': 6807,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.762
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzM0NmUwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1122169150',
                    'mac_address': '70:a7:41:34:46:e0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '20811592604',
                    'poller_hash': 'NzBhNzQxMzM0NmUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'Castro County Nursing & '
                'Rehabilitation-80864',
                'serial_number':
                'UBNT413346e0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '70:a7:41:33:46:e0',
                'temperature':
                54.0,
                'uptime':
                '522212'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1433260765635',
                    'links': [{
                        'in_octets': '1433260765635',
                        'out_octets': '104802381961',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '104802381961',
                    'poller_hash':
                    'Nzg0NTU4MDYyNGE3cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3122295',
                            'fiber_length': 6666,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.19,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.282
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyNGE3cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '104802381961',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1433260765635',
                    'poller_hash': 'Nzg0NTU4MDYyNGE3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'L&A.Silva-78575 ',
                'serial_number':
                'UBNT580624a7',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:24:a7',
                'temperature':
                55.0,
                'uptime':
                '4583356'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '5181478383559',
                    'links': [{
                        'in_octets': '5181478383559',
                        'out_octets': '83127397829',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '83127397829',
                    'poller_hash':
                    'Nzg0NTU4MDYyNzI2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '13997733',
                            'fiber_length': 3223,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.684,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.956
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyNzI2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '83127397829',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '5181478383559',
                    'poller_hash': 'Nzg0NTU4MDYyNzI2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'DNelson -92671',
                'serial_number':
                'UBNT58062726',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:27:26',
                'temperature':
                55.0,
                'uptime':
                '13997805'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '627518198044',
                    'links': [{
                        'in_octets': '627518198044',
                        'out_octets': '38191421835',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '38191421835',
                    'poller_hash':
                    'Nzg0NTU4MDYyOGUwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236324',
                            'fiber_length': 3244,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.684,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.958
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyOGUwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '38191421835',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '627518198044',
                    'poller_hash': 'Nzg0NTU4MDYyOGUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'Dimmitt Motel-92675',
                'serial_number':
                'UBNT580628e0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:28:e0',
                'temperature':
                55.0,
                'uptime':
                '2236391'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1095668450715',
                    'links': [{
                        'in_octets': '1095668450715',
                        'out_octets': '49736658591',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '49736658591',
                    'poller_hash':
                    'Nzg0NTU4MDYyOTMxcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3122296',
                            'fiber_length': 6668,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.218,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.29
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyOTMxcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '49736658591',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1095668450715',
                    'poller_hash': 'Nzg0NTU4MDYyOTMxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'RCadena-92934',
                'serial_number':
                'UBNT58062931',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:29:31',
                'temperature':
                45.0,
                'uptime':
                '4583327'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2691025485006',
                    'links': [{
                        'in_octets': '2691025485006',
                        'out_octets': '301208890999',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '301208890999',
                    'poller_hash':
                    'Nzg0NTU4OWE1OWYwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '13997733',
                            'fiber_length': 3332,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.486,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.46
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OWE1OWYwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '301208890999',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2691025485006',
                    'poller_hash': 'Nzg0NTU4OWE1OWYwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'BlueSkyFarmsDBA-93136',
                'serial_number':
                'UBNT589a59f0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:9a:59:f0',
                'temperature':
                54.0,
                'uptime':
                '13997807'
            }, {
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '594247947654',
                    'links': [{
                        'in_octets': '594247947654',
                        'out_octets': '28678459567',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28678459567',
                    'poller_hash':
                    'NjhkNzlhMDY2N2JkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1744168',
                            'fiber_length': 6565,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.548,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.464
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY2N2JkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '28678459567',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '594247947654',
                    'poller_hash': 'NjhkNzlhMDY2N2JkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'BHernandez-90268',
                'serial_number':
                'UBNT9a0667bd',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '68:d7:9a:06:67:bd',
                'temperature':
                59.0,
                'uptime':
                '1744236'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '7288813286328',
                    'links': [{
                        'in_octets': '7288813286328',
                        'out_octets': '270596986406',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '270596986406',
                    'poller_hash':
                    'NjhkNzlhMDY4MDNkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '9117783',
                            'fiber_length': 4906,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.926,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.446
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY4MDNkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '270596986406',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '7288813286328',
                    'poller_hash': 'NjhkNzlhMDY4MDNkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'KProffitt-96064',
                'serial_number':
                'UBNT9a06803d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '68:d7:9a:06:80:3d',
                'temperature':
                55.0,
                'uptime':
                '9117849'
            }, {
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '408137292637',
                    'links': [{
                        'in_octets': '408137292637',
                        'out_octets': '10354185389',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10354185389',
                    'poller_hash':
                    'ZjQ5MmJmMDZlM2M1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1981181',
                            'fiber_length': 6522,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.516
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlM2M1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '10354185389',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '408137292637',
                    'poller_hash': 'ZjQ5MmJmMDZlM2M1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'LGrand-92803',
                'serial_number':
                'UBNTbf06e3c5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:e3:c5',
                'temperature':
                65.0,
                'uptime':
                '1981245'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '513717530050',
                    'links': [{
                        'in_octets': '513717530050',
                        'out_octets': '23257630059',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '23257630059',
                    'poller_hash':
                    'ZjQ5MmJmMDZmM2U0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1894890',
                            'fiber_length': 6694,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.808,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.308
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmM2U0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '23257630059',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '513717530050',
                    'poller_hash': 'ZjQ5MmJmMDZmM2U0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'SSheffy-93345',
                'serial_number':
                'UBNTbf06f3e4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:f3:e4',
                'temperature':
                62.0,
                'uptime':
                '1894957'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '81890741079',
                    'links': [{
                        'in_octets': '81890741079',
                        'out_octets': '66846381393',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '66846381393',
                    'poller_hash':
                    'NzQ4M2MyNDNlYzhicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236324',
                            'fiber_length': 2894,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.44,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.604
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNlYzhicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '66846381393',
                    'mac_address': '74:83:c2:44:ec:8b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '81890741079',
                    'poller_hash': 'NzQ4M2MyNDNlYzhiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'DPharmacy-84631',
                'serial_number':
                'UBNTc243ec8b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:ec:8b',
                'temperature':
                55.0,
                'uptime':
                '2236391'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '511207640643',
                    'links': [{
                        'in_octets': '511207640643',
                        'out_octets': '18948295788',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18948295788',
                    'poller_hash':
                    'NzQ4M2MyNDNmNjI4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1228172',
                            'fiber_length': 3336,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.804,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.264
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNjI4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '18948295788',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '511207640643',
                    'poller_hash': 'NzQ4M2MyNDNmNjI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'SSkinner-86381',
                'serial_number':
                'UBNTc243f628',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f6:28',
                'temperature':
                51.0,
                'uptime':
                '1228235'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '199122231467',
                    'links': [{
                        'in_octets': '199122231467',
                        'out_octets': '11192681513',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11192681513',
                    'poller_hash':
                    'NzQ4M2MyNDNmNjg1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236324',
                            'fiber_length': 3976,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.248,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.226
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNjg1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '11192681513',
                    'mac_address': '74:83:c2:44:f6:85',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '199122231467',
                    'poller_hash': 'NzQ4M2MyNDNmNjg1ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'Bi-Wize-75953',
                'serial_number':
                'UBNTc243f685',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f6:85',
                'temperature':
                50.0,
                'uptime':
                '2236390'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1910936437170',
                    'links': [{
                        'in_octets': '1910936437170',
                        'out_octets': '75465268098',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '75465268098',
                    'poller_hash':
                    'NzQ4M2MyNDNmODE5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3122286',
                            'fiber_length': 6664,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.076,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.472
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmODE5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '75465268098',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1910936437170',
                    'poller_hash': 'NzQ4M2MyNDNmODE5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'AMontelongo-85907',
                'serial_number':
                'UBNTc243f819',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f8:19',
                'temperature':
                65.0,
                'uptime':
                '4583374'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3933187581',
                    'links': [{
                        'in_octets': '3933187581',
                        'out_octets': '276236753',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '276236753',
                    'poller_hash':
                    'NzQ4M2MyNjgzNTYycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2904423',
                            'fiber_length': 3221,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.314,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.408
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjgzNTYycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '276236753',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3933187581',
                    'poller_hash': 'NzQ4M2MyNjgzNTYyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'DJackson-85588',
                'serial_number':
                'UBNTc2683562',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:35:62',
                'temperature':
                57.0,
                'uptime':
                '2904488'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '132060310759',
                    'links': [{
                        'in_octets': '132060310759',
                        'out_octets': '5490536901',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5490536901',
                    'poller_hash':
                    'YjRmYmU0ZTZhY2EzcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '250869',
                            'fiber_length': 3088,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.316,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.802
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZhY2EzcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '5490536901',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '132060310759',
                    'poller_hash': 'YjRmYmU0ZTZhY2EzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'ESilva-76504',
                'serial_number':
                'UBNTe4e6aca3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:ac:a3',
                'temperature':
                67.0,
                'uptime':
                '250940'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '323815704936',
                    'links': [{
                        'in_octets': '323815704936',
                        'out_octets': '568621885269',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '568621885269',
                    'poller_hash':
                    'YjRmYmU0ZjkyODlicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2139213',
                            'fiber_length': 2860,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.466,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.59
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZjkyODlicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '568621885269',
                    'mac_address': 'b4:fb:e4:fa:28:9b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '323815704936',
                    'poller_hash': 'YjRmYmU0ZjkyODliZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'FrontierCapitol-76456',
                'serial_number':
                'UBNTe4f9289b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:28:9b',
                'temperature':
                58.0,
                'uptime':
                '3915770'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '116107972986',
                    'links': [{
                        'in_octets': '116107972986',
                        'out_octets': '12203916160',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12203916160',
                    'poller_hash':
                    'YjRmYmU0Zjk0ZjFhcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3122296',
                            'fiber_length': 6565,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.904
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk0ZjFhcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '12203916160',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '116107972986',
                    'poller_hash': 'YjRmYmU0Zjk0ZjFhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'L&CBradley-76457',
                'serial_number':
                'UBNTe4f94f1a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:4f:1a',
                'temperature':
                54.0,
                'uptime':
                '4583526'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '118185250',
                    'links': [{
                        'in_octets': '118185250',
                        'out_octets': '255745969',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '255745969',
                    'poller_hash':
                    'YjRmYmU0Zjk0ZmU3cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1812429',
                            'fiber_length': 3799,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.436,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.628
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk0ZmU3cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '255745969',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '118185250',
                    'poller_hash': 'YjRmYmU0Zjk0ZmU3ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'ModernCarpet-78079',
                'serial_number':
                'UBNTe4f94fe7',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:4f:e7',
                'temperature':
                66.0,
                'uptime':
                '1812520'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '64190780317',
                    'links': [{
                        'in_octets': '64190780317',
                        'out_octets': '12166021346',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12166021346',
                    'poller_hash':
                    'YjRmYmU0ZjlkYzE0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236324',
                            'fiber_length': 3869,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.436,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.902
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZjlkYzE0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '12166021346',
                    'mac_address': 'b4:fb:e4:fa:dc:14',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '64190780317',
                    'poller_hash': 'YjRmYmU0ZjlkYzE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'CastroCountyExtensionOffice - 83481',
                'serial_number':
                'UBNTe4f9dc14',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:dc:14',
                'temperature':
                57.0,
                'uptime':
                '2236390'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '19746822349',
                    'links': [{
                        'in_octets': '19746822349',
                        'out_octets': '7252090642',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7252090642',
                    'poller_hash':
                    'ZDAyMWY5OWFhNTMwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236345',
                            'fiber_length': 3537,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQysz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.086,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.614
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWFhNTMwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '7252090642',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '19746822349',
                    'poller_hash': 'ZDAyMWY5OWFhNTMwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'Sonic-90402',
                'serial_number':
                'UBNTf99aa530',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'd0:21:f9:9a:a5:30',
                'temperature':
                61.0,
                'uptime':
                '2236392'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '18341208551',
                    'links': [{
                        'in_octets': '18341208551',
                        'out_octets': '471385699',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '471385699',
                    'poller_hash':
                    'MThlODI5MGI3YWI4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '124508',
                            'fiber_length': 3509,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.926,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.358
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI3YWI4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '471385699',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '18341208551',
                    'poller_hash': 'MThlODI5MGI3YWI4ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'Diana Escarcega - 94943',
                'serial_number':
                'UBNT290b7ab8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:7a:b8',
                'temperature':
                55.0,
                'uptime':
                '124561'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '638479448471',
                    'links': [{
                        'in_octets': '638479448471',
                        'out_octets': '19211620876',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '19211620876',
                    'poller_hash':
                    'MThlODI5MGJhZTljcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1258592',
                            'fiber_length': 3355,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.326,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.23
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJhZTljcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '19211620876',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '638479448471',
                    'poller_hash': 'MThlODI5MGJhZTljZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'NanoG',
                'name':
                'KRamirez - 94442',
                'serial_number':
                'UBNT290bae9c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:ae:9c',
                'temperature':
                59.0,
                'uptime':
                '1258644'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4937645959146',
                    'links': [{
                        'in_octets': '4937645959146',
                        'out_octets': '130408759027',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '130408759027',
                    'poller_hash':
                    'MThlODI5MGJhZjA4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '10170537',
                            'fiber_length': 3944,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.03,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.394
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJhZjA4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '130408759027',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4937645959146',
                    'poller_hash': 'MThlODI5MGJhZjA4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'JCastillo-95065',
                'serial_number':
                'UBNT290baf08',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:af:08',
                'temperature':
                52.0,
                'uptime':
                '10170581'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '413976308347',
                    'links': [{
                        'in_octets': '413976308347',
                        'out_octets': '7514913398',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7514913398',
                    'poller_hash':
                    'MThlODI5MGJiMDc0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1201011',
                            'fiber_length': 3966,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.04,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.644
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJiMDc0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '7514913398',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '413976308347',
                    'poller_hash': 'MThlODI5MGJiMDc0ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'JAguero-95502',
                'serial_number':
                'UBNT290bb074',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:b0:74',
                'temperature':
                38.0,
                'uptime':
                '1201056'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '194266090622',
                    'links': [{
                        'in_octets': '194266090622',
                        'out_octets': '15779436535',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15779436535',
                    'poller_hash':
                    'MThlODI5MTk4MTI0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1200991',
                            'fiber_length': 3960,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.756
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTk4MTI0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '15779436535',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '194266090622',
                    'poller_hash': 'MThlODI5MTk4MTI0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'SKinser-81531',
                'serial_number':
                'UBNT29198124',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:81:24',
                'temperature':
                62.0,
                'uptime':
                '1201054'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '571808720849',
                    'links': [{
                        'in_octets': '571808720849',
                        'out_octets': '49432253518',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '49432253518',
                    'poller_hash':
                    'MThlODI5MTliNGVicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1200991',
                            'fiber_length': 4134,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.364,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.542
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTliNGVicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '49432253518',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '571808720849',
                    'poller_hash': 'MThlODI5MTliNGViZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'ANino_85173',
                'serial_number':
                'UBNT2919b4eb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:b4:eb',
                'temperature':
                51.0,
                'uptime':
                '1201055'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1504030425737',
                    'links': [{
                        'in_octets': '1504030425737',
                        'out_octets': '27824745623',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27824745623',
                    'poller_hash':
                    'Nzg0NTU4MDYyODBmcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1200981',
                            'fiber_length': 4139,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.676,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.466
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyODBmcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '27824745623',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1504030425737',
                    'poller_hash': 'Nzg0NTU4MDYyODBmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'REnriquez-91457',
                'serial_number':
                'UBNT5806280f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:28:0f',
                'temperature':
                57.0,
                'uptime':
                '1201055'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2010922396415',
                    'links': [{
                        'in_octets': '2010922396415',
                        'out_octets': '48702228981',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48702228981',
                    'poller_hash':
                    'Nzg0NTU4OWFmZDRjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '4676996',
                            'fiber_length': 3516,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.696,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.79
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OWFmZDRjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '48702228981',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2010922396415',
                    'poller_hash': 'Nzg0NTU4OWFmZDRjZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'VLeal-96351',
                'serial_number':
                'UBNT589afd4c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:9a:fd:4c',
                'temperature':
                48.0,
                'uptime':
                '4677062'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2730946906061',
                    'links': [{
                        'in_octets': '2730946906061',
                        'out_octets': '150535737723',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '150535737723',
                    'poller_hash':
                    'Nzg0NTU4OWFmZDU0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '13636289',
                            'fiber_length': 3231,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.022,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.15
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4OWFmZDU0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '150535737723',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2730946906061',
                    'poller_hash': 'Nzg0NTU4OWFmZDU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'FMartinez - 95735',
                'serial_number':
                'UBNT589afd54',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:9a:fd:54',
                'temperature':
                62.0,
                'uptime':
                '13636351'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '79350201183',
                    'links': [{
                        'in_octets': '79350201183',
                        'out_octets': '40282052347',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '40282052347',
                    'poller_hash':
                    'NjhkNzlhMDY0OWM2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5084002',
                            'fiber_length': 4358,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.516,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.866
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY0OWM2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '40282052347',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '79350201183',
                    'poller_hash': 'NjhkNzlhMDY0OWM2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'JLeal-90888',
                'serial_number':
                'UBNT9a0649c6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '68:d7:9a:06:49:c6',
                'temperature':
                53.0,
                'uptime':
                '5084069'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '128382929247',
                    'links': [{
                        'in_octets': '128382929247',
                        'out_octets': '3994390581',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3994390581',
                    'poller_hash':
                    'NjhkNzlhMDY2N2I5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '511192',
                            'fiber_length': 3877,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.824,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.31
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY2N2I5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '3994390581',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '128382929247',
                    'poller_hash': 'NjhkNzlhMDY2N2I5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'EHernandez-90300',
                'serial_number':
                'UBNT9a0667b9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '68:d7:9a:06:67:b9',
                'temperature':
                75.0,
                'uptime':
                '511264'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '338529606302',
                    'links': [{
                        'in_octets': '338529606302',
                        'out_octets': '15078811039',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15078811039',
                    'poller_hash':
                    'ZjQ5MmJmMDY0YWM2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1357523',
                            'fiber_length': 3830,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.35,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.978
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDY0YWM2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '15078811039',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '338529606302',
                    'poller_hash': 'ZjQ5MmJmMDY0YWM2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'MPuente-91050',
                'serial_number':
                'UBNTbf064ac6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:4a:c6',
                'temperature':
                56.0,
                'uptime':
                '1357591'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '131600',
                    'links': [{
                        'in_octets': '131600',
                        'out_octets': '521470',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '521470',
                    'poller_hash':
                    'ZjQ5MmJmMDY0YmUxcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '13997742',
                            'fiber_length': 3827,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.054,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.368
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDY0YmUxcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '521470',
                    'name': 'eth0',
                    'oper_up': False,
                    'out_octets': '131600',
                    'poller_hash': 'ZjQ5MmJmMDY0YmUxZXRoMQ=='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'ANavarro-91082',
                'serial_number':
                'UBNTbf064be1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:4b:e1',
                'temperature':
                48.0,
                'uptime':
                '13997807'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '337258223569',
                    'links': [{
                        'in_octets': '337258223569',
                        'out_octets': '34338396214',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '34338396214',
                    'poller_hash':
                    'NzQ4M2MyNDNmNTUxcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3006415',
                            'fiber_length': 4249,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.938,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.38
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNTUxcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '34338396214',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '337258223569',
                    'poller_hash': 'NzQ4M2MyNDNmNTUxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'CVasquez-88941',
                'serial_number':
                'UBNTc243f551',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f5:51',
                'temperature':
                57.0,
                'uptime':
                '3006484'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '552574059990',
                    'links': [{
                        'in_octets': '552574059990',
                        'out_octets': '8010190102',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8010190102',
                    'poller_hash':
                    'NzQ4M2MyNDNmNTY5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1200531',
                            'fiber_length': 4397,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.318,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.008
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNTY5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '8010190102',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '552574059990',
                    'poller_hash': 'NzQ4M2MyNDNmNTY5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'VSteffens - 91882',
                'serial_number':
                'UBNTc243f569',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f5:69',
                'temperature':
                64.0,
                'uptime':
                '1200601'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '552536006242',
                    'links': [{
                        'in_octets': '552536006242',
                        'out_octets': '50882319746',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '50882319746',
                    'poller_hash':
                    'NzQ4M2MyNDNmNThhcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1200981',
                            'fiber_length': 4112,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.43,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.064
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNThhcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '50882319746',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '552536006242',
                    'poller_hash': 'NzQ4M2MyNDNmNThhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'RSilva-86688',
                'serial_number':
                'UBNTc243f58a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f5:8a',
                'temperature':
                55.0,
                'uptime':
                '1201055'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1758690674648',
                    'links': [{
                        'in_octets': '1758690674648',
                        'out_octets': '184446338435',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '184446338435',
                    'poller_hash':
                    'NzQ4M2MyNDNmNTlhcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8022689',
                            'fiber_length': 3861,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.782,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.884
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNTlhcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '184446338435',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1758690674648',
                    'poller_hash': 'NzQ4M2MyNDNmNTlhZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'EGonzalez-88846',
                'serial_number':
                'UBNTc243f59a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f5:9a',
                'temperature':
                52.0,
                'uptime':
                '8022754'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1123680988544',
                    'links': [{
                        'in_octets': '1123680988544',
                        'out_octets': '62507626656',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '62507626656',
                    'poller_hash':
                    'NzQ4M2MyNjg5OThlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2742971',
                            'fiber_length': 3974,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.136,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.428
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjg5OThlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '62507626656',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1123680988544',
                    'poller_hash': 'NzQ4M2MyNjg5OThlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'ORivera-89002',
                'serial_number':
                'UBNTc268998e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:99:8e',
                'temperature':
                60.0,
                'uptime':
                '2743042'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2201083998449',
                    'links': [{
                        'in_octets': '2201083998449',
                        'out_octets': '109259587467',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '109259587467',
                    'poller_hash':
                    'NzQ4M2MyNjg5OWU4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '11328721',
                            'fiber_length': 3679,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.82
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjg5OWU4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '109259587467',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2201083998449',
                    'poller_hash': 'NzQ4M2MyNjg5OWU4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'JBell-95810',
                'serial_number':
                'UBNTc26899e8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:99:e8',
                'temperature':
                60.0,
                'uptime':
                '11328787'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '397430827466',
                    'links': [{
                        'in_octets': '397430827466',
                        'out_octets': '39343498779',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '39343498779',
                    'poller_hash':
                    'NzQ4M2MyNjhjNGZjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1201011',
                            'fiber_length': 3828,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.624
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhjNGZjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '39343498779',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '397430827466',
                    'poller_hash': 'NzQ4M2MyNjhjNGZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                'MEnriquez-89562 ',
                'serial_number':
                'UBNTc268c4fc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:c4:fc',
                'temperature':
                66.0,
                'uptime':
                '1201056'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '569738347747',
                    'links': [{
                        'in_octets': '569738347747',
                        'out_octets': '28695042339',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28695042339',
                    'poller_hash':
                    'NzQ4M2MyNjhjNWYycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1201011',
                            'fiber_length': 4365,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.804
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhjNWYycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '28695042339',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '569738347747',
                    'poller_hash': 'NzQ4M2MyNjhjNWYyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'AVidal-89682',
                'serial_number':
                'UBNTc268c5f2',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:c5:f2',
                'temperature':
                60.0,
                'uptime':
                '1201057'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1025020077247',
                    'links': [{
                        'in_octets': '1025020077247',
                        'out_octets': '63288639990',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '63288639990',
                    'poller_hash':
                    'NzQ4M2MyNjhjNjQ4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '4570205',
                            'fiber_length': 3984,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.664,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.44
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhjNjQ4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '63288639990',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1025020077247',
                    'poller_hash': 'NzQ4M2MyNjhjNjQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'NanoG',
                'name':
                'MFavela-89741',
                'serial_number':
                'UBNTc268c648',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:c6:48',
                'temperature':
                73.0,
                'uptime':
                '4570251'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '638914526447',
                    'links': [{
                        'in_octets': '638914526447',
                        'out_octets': '27287158826',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27287158826',
                    'poller_hash':
                    'YjRmYmU0Nzk1ZjE0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2163114',
                            'fiber_length': 3342,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.87,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.518
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Nzk1ZjE0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '27287158826',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '638914526447',
                    'poller_hash': 'YjRmYmU0Nzk1ZjE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'BKinser-78424',
                'serial_number':
                'UBNTe4795f14',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:5f:14',
                'temperature':
                60.0,
                'uptime':
                '3504772'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '11217440568',
                    'links': [{
                        'in_octets': '11217440568',
                        'out_octets': '5737046902',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5737046902',
                    'poller_hash':
                    'YjRmYmU0ZTZiNDVmcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '10897926',
                            'fiber_length': 4018,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.788,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.57
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZiNDVmcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '5737046902',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '11217440568',
                    'poller_hash': 'YjRmYmU0ZTZiNDVmZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'GSnitker-76623',
                'serial_number':
                'UBNTe4e6b45f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:b4:5f',
                'temperature':
                56.0,
                'uptime':
                '10897993'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2064999901639',
                    'links': [{
                        'in_octets': '2064999901639',
                        'out_octets': '249813544920',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '249813544920',
                    'poller_hash':
                    'YjRmYmU0ZTZjNTFjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '12887901',
                            'fiber_length': 3510,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.362,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.548
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZjNTFjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '249813544920',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2064999901639',
                    'poller_hash': 'YjRmYmU0ZTZjNTFjZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'MNavarro-83232',
                'serial_number':
                'UBNTe4e6c51c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:c5:1c',
                'temperature':
                64.0,
                'uptime':
                '12887973'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '36290512766',
                    'links': [{
                        'in_octets': '36290512766',
                        'out_octets': '15948212219',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15948212219',
                    'poller_hash':
                    'YjRmYmU0ZTZjZjU3cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '14836772',
                            'fiber_length': 3512,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.808,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.71
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZjZjU3cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '15948212219',
                    'mac_address': 'b4:fb:e4:e7:cf:57',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '36290512766',
                    'poller_hash': 'YjRmYmU0ZTZjZjU3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'CityOfDimmittFireDept-89380',
                'serial_number':
                'UBNTe4e6cf57',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:cf:57',
                'temperature':
                73.0,
                'uptime':
                '14836837'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1794180430610',
                    'links': [{
                        'in_octets': '1794180430610',
                        'out_octets': '67090417807',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '67090417807',
                    'poller_hash':
                    'YjRmYmU0ZTZlMWZicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5281134',
                            'fiber_length': 4243,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.978,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.002
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlMWZicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '67090417807',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1794180430610',
                    'poller_hash': 'YjRmYmU0ZTZlMWZiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'MLaura-79980',
                'serial_number':
                'UBNTe4e6e1fb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:e1:fb',
                'temperature':
                73.0,
                'uptime':
                '5281197'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '993238928716',
                    'links': [{
                        'in_octets': '993238928716',
                        'out_octets': '34048230309',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '34048230309',
                    'poller_hash':
                    'YjRmYmU0Zjk0ZjBicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5833551',
                            'fiber_length': 3324,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.364,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.694
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk0ZjBicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '34048230309',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '993238928716',
                    'poller_hash': 'YjRmYmU0Zjk0ZjBiZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'LMonreal-80925',
                'serial_number':
                'UBNTe4f94f0b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:4f:0b',
                'temperature':
                54.0,
                'uptime':
                '9706442'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '224021002336',
                    'links': [{
                        'in_octets': '224021002336',
                        'out_octets': '6110626044',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6110626044',
                    'poller_hash':
                    'ZDAyMWY5OWE4NDQwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '744235',
                            'fiber_length': 4085,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.064,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.534
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE4NDQwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '6110626044',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '224021002336',
                    'poller_hash': 'ZDAyMWY5OWE4NDQwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'Nick Lara - 82090',
                'serial_number':
                'UBNTf99a8440',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'd0:21:f9:9a:84:40',
                'temperature':
                64.0,
                'uptime':
                '744287'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '197617922',
                    'links': [{
                        'in_octets': '197617922',
                        'out_octets': '1329250559',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1329250559',
                    'poller_hash':
                    'MThlODI5MGJiMGM0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1453095',
                            'fiber_length': 4433,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.022,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.338
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJiMGM0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1329250559',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '197617922',
                    'poller_hash': 'MThlODI5MGJiMGM0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'DPrieto-94861',
                'serial_number':
                'UBNT290bb0c4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:b0:c4',
                'temperature':
                56.0,
                'uptime':
                '1453144'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1993287629147',
                    'links': [{
                        'in_octets': '1993287629147',
                        'out_octets': '71779536815',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '71779536815',
                    'poller_hash':
                    'MThlODI5MGJiMGQ4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '10005354',
                            'fiber_length': 4741,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.01,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.044
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJiMGQ4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '71779536815',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1993287629147',
                    'poller_hash': 'MThlODI5MGJiMGQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'IDeLaCruz-95739',
                'serial_number':
                'UBNT290bb0d8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:b0:d8',
                'temperature':
                53.0,
                'uptime':
                '10005406'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4906654418',
                    'links': [{
                        'in_octets': '4906654418',
                        'out_octets': '1812015826',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1812015826',
                    'poller_hash':
                    'MThlODI5MTk1YWM4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '97887',
                            'fiber_length': 4294,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.29,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.502
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTk1YWM4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1812015826',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4906654418',
                    'poller_hash': 'MThlODI5MTk1YWM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'AMalapady-83057',
                'serial_number':
                'UBNT29195ac8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:5a:c8',
                'temperature':
                63.0,
                'uptime':
                '97957'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '56307744559',
                    'links': [{
                        'in_octets': '56307744559',
                        'out_octets': '1928592642',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1928592642',
                    'poller_hash':
                    'MThlODI5ZjVkM2Q0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '90197',
                            'fiber_length': 4573,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.314,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.634
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5ZjVkM2Q0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1928592642',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '56307744559',
                    'poller_hash': 'MThlODI5ZjVkM2Q0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'LAlvarez-90544',
                'serial_number':
                'UBNT29f5d3d4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:f5:d3:d4',
                'temperature':
                61.0,
                'uptime':
                '90262'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '432166540162',
                    'links': [{
                        'in_octets': '432166540162',
                        'out_octets': '12134588914',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12134588914',
                    'poller_hash':
                    'Nzg0NTU4MDYyNzg5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1273202',
                            'fiber_length': 4259,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.604,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.478
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyNzg5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '12134588914',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '432166540162',
                    'poller_hash': 'Nzg0NTU4MDYyNzg5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'DOntiveros-92624',
                'serial_number':
                'UBNT58062789',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:27:89',
                'temperature':
                55.0,
                'uptime':
                '1273272'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '484986346095',
                    'links': [{
                        'in_octets': '484986346095',
                        'out_octets': '15701436881',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15701436881',
                    'poller_hash':
                    'NzQ4M2MyNDNmNmMwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1309603',
                            'fiber_length': 5508,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.186,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.646
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNmMwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '15701436881',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '484986346095',
                    'poller_hash': 'NzQ4M2MyNDNmNmMwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'AOrtega-94516',
                'serial_number':
                'UBNTc243f6c0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f6:c0',
                'temperature':
                66.0,
                'uptime':
                '1309669'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '532242081283',
                    'links': [{
                        'in_octets': '532242081283',
                        'out_octets': '14509449166',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14509449166',
                    'poller_hash':
                    'NzQ4M2MyNDNmN2Y5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1200991',
                            'fiber_length': 4592,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.47
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmN2Y5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '14509449166',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '532242081283',
                    'poller_hash': 'NzQ4M2MyNDNmN2Y5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'MRios-79846',
                'serial_number':
                'UBNTc243f7f9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f7:f9',
                'temperature':
                55.0,
                'uptime':
                '1201055'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1443354564733',
                    'links': [{
                        'in_octets': '1443354564733',
                        'out_octets': '45697058001',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '45697058001',
                    'poller_hash':
                    'NzQ4M2MyNDNmOWYxcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '10243097',
                            'fiber_length': 4186,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.01,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.066
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmOWYxcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '45697058001',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1443354564733',
                    'poller_hash': 'NzQ4M2MyNDNmOWYxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'CLuna-87700',
                'serial_number':
                'UBNTc243f9f1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f9:f1',
                'temperature':
                58.0,
                'uptime':
                '10243161'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '137770601046',
                    'links': [{
                        'in_octets': '137770601046',
                        'out_octets': '11716720273',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11716720273',
                    'poller_hash':
                    'NzQ4M2MyNjg5OWVjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1026629',
                            'fiber_length': 5471,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.076,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.902
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjg5OWVjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '11716720273',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '137770601046',
                    'poller_hash': 'NzQ4M2MyNjg5OWVjZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'ASanchez-89093',
                'serial_number':
                'UBNTc26899ec',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:99:ec',
                'temperature':
                66.0,
                'uptime':
                '1026694'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '467013827812',
                    'links': [{
                        'in_octets': '467013827812',
                        'out_octets': '26502903475',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '26502903475',
                    'poller_hash':
                    'NzQ4M2MyNjhjNTkwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1893990',
                            'fiber_length': 4282,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.756,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.008
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhjNTkwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '26502903475',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '467013827812',
                    'poller_hash': 'NzQ4M2MyNjhjNTkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'JGarcia-89164',
                'serial_number':
                'UBNTc268c590',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:c5:90',
                'temperature':
                57.0,
                'uptime':
                '1894043'
            }, {
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '331763020150',
                    'links': [{
                        'in_octets': '331763020150',
                        'out_octets': '6013486972',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6013486972',
                    'poller_hash':
                    'YjRmYmU0NzkzNTQzcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1200991',
                            'fiber_length': 4590,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.482
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzNTQzcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '6013486972',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '331763020150',
                    'poller_hash': 'YjRmYmU0NzkzNTQzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'LGarcia-76691',
                'serial_number':
                'UBNTe4793543',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:35:43',
                'temperature':
                63.0,
                'uptime':
                '1201056'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '116575324098',
                    'links': [{
                        'in_octets': '116575324098',
                        'out_octets': '32935044121',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '32935044121',
                    'poller_hash':
                    'YjRmYmU0ZTZkNzNjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '879487',
                            'fiber_length': 4729,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.166
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZkNzNjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '32935044121',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '116575324098',
                    'poller_hash': 'YjRmYmU0ZTZkNzNjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'JPena-82158',
                'serial_number':
                'UBNTe4e6d73c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:d7:3c',
                'temperature':
                70.0,
                'uptime':
                '879557'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1491635343887',
                    'links': [{
                        'in_octets': '1491635343887',
                        'out_octets': '124430602209',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '124430602209',
                    'poller_hash':
                    'YjRmYmU0Zjk0ZDAzcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5682579',
                            'fiber_length': 5588,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.348
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk0ZDAzcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '124430602209',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1491635343887',
                    'poller_hash': 'YjRmYmU0Zjk0ZDAzZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'ATorres-87599',
                'serial_number':
                'UBNTe4f94d03',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:4d:03',
                'temperature':
                55.0,
                'uptime':
                '5682647'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '478130425849',
                    'links': [{
                        'in_octets': '478130425849',
                        'out_octets': '14959842176',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14959842176',
                    'poller_hash':
                    'ZDAyMWY5OWE4NTM0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1201011',
                            'fiber_length': 4324,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.316
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE4NTM0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '14959842176',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '478130425849',
                    'poller_hash': 'ZDAyMWY5OWE4NTM0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'TLeinen-96516',
                'serial_number':
                'UBNTf99a8534',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'd0:21:f9:9a:85:34',
                'temperature':
                55.0,
                'uptime':
                '1201056'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '320714753186',
                    'links': [{
                        'in_octets': '320714753186',
                        'out_octets': '24311508521',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24311508521',
                    'poller_hash':
                    'MThlODI5MGI5NjVjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '6059724',
                            'fiber_length': 6918,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.44,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.762
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI5NjVjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '24311508521',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '320714753186',
                    'poller_hash': 'MThlODI5MGI5NjVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'GWilcox-96157',
                'serial_number':
                'UBNT290b965c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:96:5c',
                'temperature':
                54.0,
                'uptime':
                '6059771'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '333590495370',
                    'links': [{
                        'in_octets': '333590495370',
                        'out_octets': '55361853012',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '55361853012',
                    'poller_hash':
                    'MThlODI5MGI5NzkwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3603092',
                            'fiber_length': 5100,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.924,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.272
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI5NzkwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '55361853012',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '333590495370',
                    'poller_hash': 'MThlODI5MGI5NzkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                'Levi Lunsford (Barn) - 92832',
                'serial_number':
                'UBNT290b9790',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:97:90',
                'temperature':
                57.0,
                'uptime':
                '3603146'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '841385835781',
                    'links': [{
                        'in_octets': '841385835781',
                        'out_octets': '31235907268',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '31235907268',
                    'poller_hash':
                    'MThlODI5MGJhZTA0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3365669',
                            'fiber_length': 4850,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.548,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.326
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJhZTA0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '31235907268',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '841385835781',
                    'poller_hash': 'MThlODI5MGJhZTA0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'PMedina-95333',
                'serial_number':
                'UBNT290bae04',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:ae:04',
                'temperature':
                56.0,
                'uptime':
                '3365717'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '81947189012',
                    'links': [{
                        'in_octets': '81947189012',
                        'out_octets': '27685306049',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27685306049',
                    'poller_hash':
                    'MThlODI5MGJiMDUwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1818489',
                            'fiber_length': 7151,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.886
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJiMDUwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '27685306049',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '81947189012',
                    'poller_hash': 'MThlODI5MGJiMDUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'PBradley-94852',
                'serial_number':
                'UBNT290bb050',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:b0:50',
                'temperature':
                59.0,
                'uptime':
                '1818536'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1906562229700',
                    'links': [{
                        'in_octets': '1906562229700',
                        'out_octets': '121467929012',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '121467929012',
                    'poller_hash':
                    'MThlODI5MGJiMDc4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875910',
                            'fiber_length': 7136,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.808,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.38
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJiMDc4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '121467929012',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1906562229700',
                    'poller_hash': 'MThlODI5MGJiMDc4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'BScottJr -94888',
                'serial_number':
                'UBNT290bb078',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:b0:78',
                'temperature':
                64.0,
                'uptime':
                '8875964'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1497782409427',
                    'links': [{
                        'in_octets': '1497782409427',
                        'out_octets': '42334637027',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '42334637027',
                    'poller_hash':
                    'MThlODI5MGJiMGE0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2924804',
                            'fiber_length': 5118,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.172
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJiMGE0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '42334637027',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1497782409427',
                    'poller_hash': 'MThlODI5MGJiMGE0ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'OQuintana-94823',
                'serial_number':
                'UBNT290bb0a4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:b0:a4',
                'temperature':
                55.0,
                'uptime':
                '2924853'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '42493798605',
                    'links': [{
                        'in_octets': '42493798605',
                        'out_octets': '15091483886',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15091483886',
                    'poller_hash':
                    'MThlODI5MGJlMGIwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '680284',
                            'fiber_length': 5626,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.248,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.862
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJlMGIwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '15091483886',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '42493798605',
                    'poller_hash': 'MThlODI5MGJlMGIwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'GVasquez-90370',
                'serial_number':
                'UBNT290be0b0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:e0:b0',
                'temperature':
                54.0,
                'uptime':
                '680337'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '831917276154',
                    'links': [{
                        'in_octets': '831917276154',
                        'out_octets': '24953858142',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24953858142',
                    'poller_hash':
                    'MThlODI5MTk1YWMzcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2558789',
                            'fiber_length': 4963,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.828
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTk1YWMzcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '24953858142',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '831917276154',
                    'poller_hash': 'MThlODI5MTk1YWMzZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'RMartinezSr-83350',
                'serial_number':
                'UBNT29195ac3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:5a:c3',
                'temperature':
                57.0,
                'uptime':
                '2558857'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '228352125021',
                    'links': [{
                        'in_octets': '228352125021',
                        'out_octets': '7371520985',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7371520985',
                    'poller_hash':
                    'MThlODI5MTk1ZWY2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '658044',
                            'fiber_length': 4842,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.704,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.906
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTk1ZWY2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '7371520985',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '228352125021',
                    'poller_hash': 'MThlODI5MTk1ZWY2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'RGwinn - 83131',
                'serial_number':
                'UBNT29195ef6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:5e:f6',
                'temperature':
                56.0,
                'uptime':
                '658114'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3458254745999',
                    'links': [{
                        'in_octets': '3458254745999',
                        'out_octets': '114401447187',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '114401447187',
                    'poller_hash':
                    'MThlODI5MTliNGFmcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3364729',
                            'fiber_length': 4854,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.076,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.566
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTliNGFmcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '114401447187',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3458254745999',
                    'poller_hash': 'MThlODI5MTliNGFmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'CRivera-76079',
                'serial_number':
                'UBNT2919b4af',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:b4:af',
                'temperature':
                53.0,
                'uptime':
                '3364795'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1866463416679',
                    'links': [{
                        'in_octets': '1866463416679',
                        'out_octets': '252011240049',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '252011240049',
                    'poller_hash':
                    'MThlODI5ZjVkNDc3cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5653779',
                            'fiber_length': 7059,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.324
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5ZjVkNDc3cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '252011240049',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1866463416679',
                    'poller_hash': 'MThlODI5ZjVkNDc3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'NSantellano-87956',
                'serial_number':
                'UBNT29f5d477',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:f5:d4:77',
                'temperature':
                54.0,
                'uptime':
                '5653844'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1575010373101',
                    'links': [{
                        'in_octets': '1575010373101',
                        'out_octets': '210280614850',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '210280614850',
                    'poller_hash':
                    'MThlODI5ZjVkNGZjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875890',
                            'fiber_length': 6897,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.676,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.632
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5ZjVkNGZjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '210280614850',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1575010373101',
                    'poller_hash': 'MThlODI5ZjVkNGZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'JHunkins-88542',
                'serial_number':
                'UBNT29f5d4fc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:f5:d4:fc',
                'temperature':
                59.0,
                'uptime':
                '8875962'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '138942247791',
                    'links': [{
                        'in_octets': '138942247791',
                        'out_octets': '12978057375',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12978057375',
                    'poller_hash':
                    'NzBhNzQxMzM0NzM4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5195243',
                            'fiber_length': 4056,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.068,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.41
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzBhNzQxMzM0NzM4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '12978057375',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '138942247791',
                    'poller_hash': 'NzBhNzQxMzM0NzM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'BlueSkyFarms-96500',
                'serial_number':
                'UBNT41334738',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '70:a7:41:33:47:38',
                'temperature':
                52.0,
                'uptime':
                '5195312'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '67122072562',
                    'links': [{
                        'in_octets': '67122072562',
                        'out_octets': '1922931848',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1922931848',
                    'poller_hash':
                    'Nzg0NTU4MDYyNzhmcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '445942',
                            'fiber_length': 5041,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.924,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.152
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyNzhmcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1922931848',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '67122072562',
                    'poller_hash': 'Nzg0NTU4MDYyNzhmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'AVilllareal-91955',
                'serial_number':
                'UBNT5806278f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:27:8f',
                'temperature':
                58.0,
                'uptime':
                '446008'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '756475218787',
                    'links': [{
                        'in_octets': '756475218787',
                        'out_octets': '22473517154',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '22473517154',
                    'poller_hash':
                    'Nzg0NTU4MDYyN2I1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1386313',
                            'fiber_length': 5016,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.978,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.36
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyN2I1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '22473517154',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '756475218787',
                    'poller_hash': 'Nzg0NTU4MDYyN2I1ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'AMartinez-91301',
                'serial_number':
                'UBNT580627b5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:27:b5',
                'temperature':
                51.0,
                'uptime':
                '1386386'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '400936520750',
                    'links': [{
                        'in_octets': '400936520750',
                        'out_octets': '11039292030',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11039292030',
                    'poller_hash':
                    'Nzg0NTU4MDYyN2I3cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1356623',
                            'fiber_length': 6903,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.218,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.816
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyN2I3cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '11039292030',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '400936520750',
                    'poller_hash': 'Nzg0NTU4MDYyN2I3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'BConyers-92189',
                'serial_number':
                'UBNT580627b7',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:27:b7',
                'temperature':
                53.0,
                'uptime':
                '1356693'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '403772541765',
                    'links': [{
                        'in_octets': '403772541765',
                        'out_octets': '14432952283',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14432952283',
                    'poller_hash':
                    'NzRhY2I5MDY3YWE0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1391624',
                            'fiber_length': 5000,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.426,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.288
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5MDY3YWE0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '14432952283',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '403772541765',
                    'poller_hash': 'NzRhY2I5MDY3YWE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'SEOntiveros-91061',
                'serial_number':
                'UBNTb9067aa4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:ac:b9:06:7a:a4',
                'temperature':
                54.0,
                'uptime':
                '1391696'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '585376026327',
                    'links': [{
                        'in_octets': '585376026327',
                        'out_octets': '38199583011',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '38199583011',
                    'poller_hash':
                    'NzRhY2I5MDZhMGM0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3289848',
                            'fiber_length': 5116,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.804,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.818
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5MDZhMGM0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '38199583011',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '585376026327',
                    'poller_hash': 'NzRhY2I5MDZhMGM0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'AAcevedo-88266',
                'serial_number':
                'UBNTb906a0c4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:ac:b9:06:a0:c4',
                'temperature':
                60.0,
                'uptime':
                '3289912'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1065503786325',
                    'links': [{
                        'in_octets': '1065503786325',
                        'out_octets': '40906467147',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '40906467147',
                    'poller_hash':
                    'ZjQ5MmJmMDY0MjQ3cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875900',
                            'fiber_length': 6967,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.268,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.0
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDY0MjQ3cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '40906467147',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1065503786325',
                    'poller_hash': 'ZjQ5MmJmMDY0MjQ3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'BudHillFeedlots-92644',
                'serial_number':
                'UBNTbf064247',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:42:47',
                'temperature':
                57.0,
                'uptime':
                '8875963'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '301823475817',
                    'links': [{
                        'in_octets': '301823475817',
                        'out_octets': '11878260275',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11878260275',
                    'poller_hash':
                    'ZjQ5MmJmMDZmMjhmcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236325',
                            'fiber_length': 4167,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.468
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmMjhmcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '11878260275',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '301823475817',
                    'poller_hash': 'ZjQ5MmJmMDZmMjhmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'RMartinez - 94393',
                'serial_number':
                'UBNTbf06f28f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:f2:8f',
                'temperature':
                65.0,
                'uptime':
                '2236390'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '306414958210',
                    'links': [{
                        'in_octets': '306414958210',
                        'out_octets': '30931068804',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '30931068804',
                    'poller_hash':
                    'NzQ4M2MyNDNmNjUwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3603082',
                            'fiber_length': 6456,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.278,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.736
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNjUwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '30931068804',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '306414958210',
                    'poller_hash': 'NzQ4M2MyNDNmNjUwZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'JonRiddle-78067',
                'serial_number':
                'UBNTc243f650',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f6:50',
                'temperature':
                60.0,
                'uptime':
                '3603144'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3056239298887',
                    'links': [{
                        'in_octets': '3056239298887',
                        'out_octets': '137286259372',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '137286259372',
                    'poller_hash':
                    'NzQ4M2MyNjg5YTA2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875890',
                            'fiber_length': 7181,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.676,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.286
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjg5YTA2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '137286259372',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3056239298887',
                    'poller_hash': 'NzQ4M2MyNjg5YTA2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'RGonzalez-88892',
                'serial_number':
                'UBNTc2689a06',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:9a:06',
                'temperature':
                68.0,
                'uptime':
                '8875963'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2493077108129',
                    'links': [{
                        'in_octets': '2493077108129',
                        'out_octets': '388646230770',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '388646230770',
                    'poller_hash':
                    'NzQ4M2MyNjhhZmI2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '7923238',
                            'fiber_length': 5416,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.914,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.544
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhhZmI2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '388646230770',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2493077108129',
                    'poller_hash': 'NzQ4M2MyNjhhZmI2ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'NanoG',
                'name':
                'SAguero-91330',
                'serial_number':
                'UBNTc268afb6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:af:b6',
                'temperature':
                51.0,
                'uptime':
                '7923291'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '292503590947',
                    'links': [{
                        'in_octets': '292503590947',
                        'out_octets': '50222128505',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '50222128505',
                    'poller_hash':
                    'NzQ4M2MyNjhiMThmcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8298523',
                            'fiber_length': 7005,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.804,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.744
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhiMThmcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '50222128505',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '292503590947',
                    'poller_hash': 'NzQ4M2MyNjhiMThmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'DReinart-96211',
                'serial_number':
                'UBNTc268b18f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:b1:8f',
                'temperature':
                57.0,
                'uptime':
                '8298570'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '690942419316',
                    'links': [{
                        'in_octets': '690942419316',
                        'out_octets': '17605697430',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17605697430',
                    'poller_hash':
                    'NzQ4M2MyZjBjOTQ4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236345',
                            'fiber_length': 3709,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.456,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.138
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyZjBjOTQ4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '17605697430',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '690942419316',
                    'poller_hash': 'NzQ4M2MyZjBjOTQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'MFlores - 95127',
                'serial_number':
                'UBNTc2f0c948',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:f0:c9:48',
                'temperature':
                62.0,
                'uptime':
                '2236392'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '140347805327',
                    'links': [{
                        'in_octets': '140347805327',
                        'out_octets': '14180443040',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14180443040',
                    'poller_hash':
                    'ZmNlY2RhZWJmMTcycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '5268274',
                            'fiber_length': 7122,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.01,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.262
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZmNlY2RhZWJmMTcycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '14180443040',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '140347805327',
                    'poller_hash': 'ZmNlY2RhZWJmMTcyZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'TWidick-85679',
                'serial_number':
                'UBNTdaebf172',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'fc:ec:da:eb:f1:72',
                'temperature':
                59.0,
                'uptime':
                '5268323'
            }, {
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '11168575942626',
                    'links': [{
                        'in_octets': '11168575942626',
                        'out_octets': '991293677536',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '991293677536',
                    'poller_hash':
                    'YjRmYmU0NzkzNDc2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '7905718',
                            'fiber_length': 4044,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.326,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.97
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzNDc2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '991293677536',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '11168575942626',
                    'poller_hash': 'YjRmYmU0NzkzNDc2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'KSherman-81988',
                'serial_number':
                'UBNTe4793476',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:34:76',
                'temperature':
                72.0,
                'uptime':
                '7905765'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4274742806913',
                    'links': [{
                        'in_octets': '4274742806913',
                        'out_octets': '172156812366',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '172156812366',
                    'poller_hash':
                    'YjRmYmU0NzkzNTNlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875920',
                            'fiber_length': 7013,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.738,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.454
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzNTNlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '172156812366',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4274742806913',
                    'poller_hash': 'YjRmYmU0NzkzNTNlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'SusieBradford-81855',
                'serial_number':
                'UBNTe479353e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:35:3e',
                'temperature':
                57.0,
                'uptime':
                '8875963'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4647017',
                    'links': [{
                        'in_octets': '4647017',
                        'out_octets': '2452120',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2452120',
                    'poller_hash':
                    'YjRmYmU0NzkzOThhcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '4296',
                            'fiber_length': 4875,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.766,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.488
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzOThhcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '2452120',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4647017',
                    'poller_hash': 'YjRmYmU0NzkzOThhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'PHerrera-92802',
                'serial_number':
                'UBNTe479398a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:39:8a',
                'temperature':
                77.0,
                'uptime':
                '4342'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '846233534584',
                    'links': [{
                        'in_octets': '846233534584',
                        'out_octets': '33867028498',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '33867028498',
                    'poller_hash':
                    'YjRmYmU0ZTY4MzBlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2236324',
                            'fiber_length': 3624,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.87,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.718
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTY4MzBlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '33867028498',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '846233534584',
                    'poller_hash': 'YjRmYmU0ZTY4MzBlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'SSanchez-80453',
                'serial_number':
                'UBNTe4e6830e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:83:0e',
                'temperature':
                77.0,
                'uptime':
                '2236391'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '969800435588',
                    'links': [{
                        'in_octets': '969800435588',
                        'out_octets': '23516856561',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '23516856561',
                    'poller_hash':
                    'YjRmYmU0ZTZjZjM2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875890',
                            'fiber_length': 7081,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.186,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.514
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZjZjM2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '23516856561',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '969800435588',
                    'poller_hash': 'YjRmYmU0ZTZjZjM2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'BConyers-82662',
                'serial_number':
                'UBNTe4e6cf36',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:cf:36',
                'temperature':
                57.0,
                'uptime':
                '8875962'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '967085065286',
                    'links': [{
                        'in_octets': '967085065286',
                        'out_octets': '124770107983',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '124770107983',
                    'poller_hash':
                    'YjRmYmU0ZTZkNzM4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8624707',
                            'fiber_length': 7059,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.596,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.98
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZkNzM4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '124770107983',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '967085065286',
                    'poller_hash': 'YjRmYmU0ZTZkNzM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'SBuckley-82199',
                'serial_number':
                'UBNTe4e6d738',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:d7:38',
                'temperature':
                62.0,
                'uptime':
                '8876073'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '46458715419',
                    'links': [{
                        'in_octets': '46458715419',
                        'out_octets': '2299018173',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2299018173',
                    'poller_hash':
                    'YjRmYmU0ZTZkZjQycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '331710',
                            'fiber_length': 5680,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.426,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.362
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZkZjQycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '2299018173',
                    'mac_address': 'b4:fb:e4:e7:df:42',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '46458715419',
                    'poller_hash': 'YjRmYmU0ZTZkZjQyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'RSchaffer-76804',
                'serial_number':
                'UBNTe4e6df42',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:df:42',
                'temperature':
                71.0,
                'uptime':
                '331779'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '466762290773',
                    'links': [{
                        'in_octets': '466762290773',
                        'out_octets': '11259485256',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11259485256',
                    'poller_hash':
                    'YjRmYmU0ZTZlMjEycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1391624',
                            'fiber_length': 5037,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.512
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZlMjEycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '11259485256',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '466762290773',
                    'poller_hash': 'YjRmYmU0ZTZlMjEyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'EPresas-77993',
                'serial_number':
                'UBNTe4e6e212',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:e2:12',
                'temperature':
                53.0,
                'uptime':
                '1391694'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '543089917895',
                    'links': [{
                        'in_octets': '543089917895',
                        'out_octets': '50945124068',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '50945124068',
                    'poller_hash':
                    'YjRmYmU0Zjk0ZDdicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875900',
                            'fiber_length': 7032,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.088,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.328
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk0ZDdicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '50945124068',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '543089917895',
                    'poller_hash': 'YjRmYmU0Zjk0ZDdiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'DSwingburn-86309',
                'serial_number':
                'UBNTe4f94d7b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:4d:7b',
                'temperature':
                59.0,
                'uptime':
                '8875963'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '551092453935',
                    'links': [{
                        'in_octets': '551092453935',
                        'out_octets': '39777759260',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '39777759260',
                    'poller_hash':
                    'YjRmYmU0Zjk0ZjI0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3603072',
                            'fiber_length': 5960,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.476
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk0ZjI0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '39777759260',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '551092453935',
                    'poller_hash': 'YjRmYmU0Zjk0ZjI0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'DBuckley-86490',
                'serial_number':
                'UBNTe4f94f24',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:4f:24',
                'temperature':
                60.0,
                'uptime':
                '3603143'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '46505050381',
                    'links': [{
                        'in_octets': '46505050381',
                        'out_octets': '6682706304',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6682706304',
                    'poller_hash':
                    'YjRmYmU0ZjlkZDA0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3603072',
                            'fiber_length': 6159,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.486,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.508
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZjlkZDA0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '6682706304',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '46505050381',
                    'poller_hash': 'YjRmYmU0ZjlkZDA0ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'LDennis-86492',
                'serial_number':
                'UBNTe4f9dd04',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:dd:04',
                'temperature':
                48.0,
                'uptime':
                '3603145'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2983069267237',
                    'links': [{
                        'in_octets': '2983069267237',
                        'out_octets': '235305901206',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '235305901206',
                    'poller_hash':
                    'Nzg4YTIwYzA0MTM2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '12271343',
                            'fiber_length': 4399,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.686,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.998
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg4YTIwYzA0MTM2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '235305901206',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2983069267237',
                    'poller_hash': 'Nzg4YTIwYzA0MTM2ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'VCaballero-79486',
                'serial_number':
                'UBNT20c04136',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:8a:20:c0:41:36',
                'temperature':
                71.0,
                'uptime':
                '12271407'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '710899371601',
                    'links': [{
                        'in_octets': '710899371601',
                        'out_octets': '19400555022',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '19400555022',
                    'poller_hash':
                    'MThlODI5MGJkYzY4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1552736',
                            'fiber_length': 4701,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.366,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.006
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJkYzY4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '19400555022',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '710899371601',
                    'poller_hash': 'MThlODI5MGJkYzY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'VLopez-96059',
                'serial_number':
                'UBNT290bdc68',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:dc:68',
                'temperature':
                55.0,
                'uptime':
                '5374330'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1843511847484',
                    'links': [{
                        'in_octets': '1843511847484',
                        'out_octets': '56295465865',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '56295465865',
                    'poller_hash':
                    'MThlODI5MGJlMTYwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '6231806',
                            'fiber_length': 4462,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.158
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJlMTYwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '56295465865',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1843511847484',
                    'poller_hash': 'MThlODI5MGJlMTYwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'HBonilla - 96429',
                'serial_number':
                'UBNT290be160',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:e1:60',
                'temperature':
                52.0,
                'uptime':
                '6231858'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3871421607321',
                    'links': [{
                        'in_octets': '3871421607321',
                        'out_octets': '147316268689',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '147316268689',
                    'poller_hash':
                    'MThlODI5MTk4MTI5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '9044622',
                            'fiber_length': 4405,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.894,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.582
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTk4MTI5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '147316268689',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3871421607321',
                    'poller_hash': 'MThlODI5MTk4MTI5ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'ONavarro-76397',
                'serial_number':
                'UBNT29198129',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:81:29',
                'temperature':
                61.0,
                'uptime':
                '9044687'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '42662503108',
                    'links': [{
                        'in_octets': '42662503108',
                        'out_octets': '1464158807',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1464158807',
                    'poller_hash':
                    'MThlODI5MTliNGEwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '258319',
                            'fiber_length': 4532,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.674,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.596
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTliNGEwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1464158807',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '42662503108',
                    'poller_hash': 'MThlODI5MTliNGEwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'KAljoe-81385',
                'serial_number':
                'UBNT2919b4a0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:b4:a0',
                'temperature':
                56.0,
                'uptime':
                '1119021'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '463849171359',
                    'links': [{
                        'in_octets': '463849171359',
                        'out_octets': '22412688659',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '22412688659',
                    'poller_hash':
                    'MThlODI5MTliNGE1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875900',
                            'fiber_length': 5100,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.376,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.264
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTliNGE1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '22412688659',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '463849171359',
                    'poller_hash': 'MThlODI5MTliNGE1ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'COkamoto-81278',
                'serial_number':
                'UBNT2919b4a5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:b4:a5',
                'temperature':
                64.0,
                'uptime':
                '8875962'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '27829325359',
                    'links': [{
                        'in_octets': '27829325359',
                        'out_octets': '801745801',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '801745801',
                    'poller_hash':
                    'MThlODI5MTliNGU2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '258319',
                            'fiber_length': 4680,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.596,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.222
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTliNGU2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '801745801',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '27829325359',
                    'poller_hash': 'MThlODI5MTliNGU2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'MFlores-81129',
                'serial_number':
                'UBNT2919b4e6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:b4:e6',
                'temperature':
                74.0,
                'uptime':
                '4160482'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '12498471768',
                    'links': [{
                        'in_octets': '12498471768',
                        'out_octets': '581658608',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '581658608',
                    'poller_hash':
                    'MThlODI5ZjVkNGY2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '258319',
                            'fiber_length': 4900,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.924,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.612
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5ZjVkNGY2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '581658608',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '12498471768',
                    'poller_hash': 'MThlODI5ZjVkNGY2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'RMcDaniel-88515',
                'serial_number':
                'UBNT29f5d4f6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:f5:d4:f6',
                'temperature':
                56.0,
                'uptime':
                '1399349'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4000781578713',
                    'links': [{
                        'in_octets': '4000781578713',
                        'out_octets': '130896041879',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '130896041879',
                    'poller_hash':
                    'Nzg0NTU4MDYyODc4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '7869727',
                            'fiber_length': 4845,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.366,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.906
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyODc4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '130896041879',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4000781578713',
                    'poller_hash': 'Nzg0NTU4MDYyODc4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'SCarpio-96066',
                'serial_number':
                'UBNT58062878',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:28:78',
                'temperature':
                72.0,
                'uptime':
                '7869793'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1035974838147',
                    'links': [{
                        'in_octets': '1035974838147',
                        'out_octets': '71157861539',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '71157861539',
                    'poller_hash':
                    'NzRhY2I5MDY3YTlhcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '10606172',
                            'fiber_length': 4862,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.596,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.738
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5MDY3YTlhcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '71157861539',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1035974838147',
                    'poller_hash': 'NzRhY2I5MDY3YTlhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'CAlag-90013',
                'serial_number':
                'UBNTb9067a9a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:ac:b9:06:7a:9a',
                'temperature':
                58.0,
                'uptime':
                '13999180'
            }, {
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '58489307323',
                    'links': [{
                        'in_octets': '58489307323',
                        'out_octets': '2318273195',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2318273195',
                    'poller_hash':
                    'NzRhY2I5MDZhMmQxcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '258318',
                            'fiber_length': 4764,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.366,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.438
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5MDZhMmQxcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '2318273195',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '58489307323',
                    'poller_hash': 'NzRhY2I5MDZhMmQxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'ZMcCasland-90591',
                'serial_number':
                'UBNTb906a2d1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:ac:b9:06:a2:d1',
                'temperature':
                52.0,
                'uptime':
                '3657323'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '456787180269',
                    'links': [{
                        'in_octets': '456787180269',
                        'out_octets': '22943668861',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '22943668861',
                    'poller_hash':
                    'NzQ4M2MyNDNlYzI0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '10606902',
                            'fiber_length': 4495,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.366,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.186
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNlYzI0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '22943668861',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '456787180269',
                    'poller_hash': 'NzQ4M2MyNDNlYzI0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'Loco',
                'name':
                'JBaker-84690',
                'serial_number':
                'UBNTc243ec24',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:ec:24',
                'temperature':
                55.0,
                'uptime':
                '13999165'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '435615447750',
                    'links': [{
                        'in_octets': '435615447750',
                        'out_octets': '18505512829',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18505512829',
                    'poller_hash':
                    'NzQ4M2MyNDNlYzJlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1281922',
                            'fiber_length': 4174,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.472
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNlYzJlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '18505512829',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '435615447750',
                    'poller_hash': 'NzQ4M2MyNDNlYzJlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'KGauna-84769',
                'serial_number':
                'UBNTc243ec2e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:ec:2e',
                'temperature':
                60.0,
                'uptime':
                '1281995'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1460816390799',
                    'links': [{
                        'in_octets': '1460816390799',
                        'out_octets': '68067119643',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '68067119643',
                    'poller_hash':
                    'NzQ4M2MyNDNlYzY0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1551976',
                            'fiber_length': 5529,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.438
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNlYzY0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '68067119643',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1460816390799',
                    'poller_hash': 'NzQ4M2MyNDNlYzY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'GReyes-84703',
                'serial_number':
                'UBNTc243ec64',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:ec:64',
                'temperature':
                68.0,
                'uptime':
                '1552045'
            }, {
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '534203345960',
                    'links': [{
                        'in_octets': '534203345960',
                        'out_octets': '33582343756',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '33582343756',
                    'poller_hash':
                    'NzQ4M2MyNDNlZGFlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '2030922',
                            'fiber_length': 4668,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.548,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.57
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNlZGFlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '33582343756',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '534203345960',
                    'poller_hash': 'NzQ4M2MyNDNlZGFlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'AJones-87307',
                'serial_number':
                'UBNTc243edae',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:ed:ae',
                'temperature':
                63.0,
                'uptime':
                '2030990'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1815426469104',
                    'links': [{
                        'in_octets': '1815426469104',
                        'out_octets': '87147657044',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '87147657044',
                    'poller_hash':
                    'NzQ4M2MyNDNmNTMycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '6467229',
                            'fiber_length': 4875,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.564,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.282
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNTMycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '87147657044',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1815426469104',
                    'poller_hash': 'NzQ4M2MyNDNmNTMyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'MPena-86308',
                'serial_number':
                'UBNTc243f532',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f5:32',
                'temperature':
                54.0,
                'uptime':
                '6467298'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '266931301220',
                    'links': [{
                        'in_octets': '266931301220',
                        'out_octets': '24767664316',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24767664316',
                    'poller_hash':
                    'NzQ4M2MyNjgzNjRjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '4370472',
                            'fiber_length': 4225,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.392,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.08
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjgzNjRjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '24767664316',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '266931301220',
                    'poller_hash': 'NzQ4M2MyNjgzNjRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'MRodriguez-85077',
                'serial_number':
                'UBNTc268364c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:36:4c',
                'temperature':
                55.0,
                'uptime':
                '4370542'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '154489852640',
                    'links': [{
                        'in_octets': '154489852640',
                        'out_octets': '4234802587',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '4234802587',
                    'poller_hash':
                    'NzQ4M2MyNjhjNjU0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '258319',
                            'fiber_length': 4511,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.382
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhjNjU0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '4234802587',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '154489852640',
                    'poller_hash': 'NzQ4M2MyNjhjNjU0ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'JSaenz_89769',
                'serial_number':
                'UBNTc268c654',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:c6:54',
                'temperature':
                71.0,
                'uptime':
                '1895015'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4321206432',
                    'links': [{
                        'in_octets': '4321206432',
                        'out_octets': '472138378',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '472138378',
                    'poller_hash':
                    'ZmNlY2RhZWI5NTMzcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '69737',
                            'fiber_length': 4480,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.558,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.548
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZmNlY2RhZWI5NTMzcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '472138378',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4321206432',
                    'poller_hash': 'ZmNlY2RhZWI5NTMzZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'MaryALane-84333',
                'serial_number':
                'UBNTdaeb9533',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'fc:ec:da:eb:95:33',
                'temperature':
                51.0,
                'uptime':
                '69800'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2304453327600',
                    'links': [{
                        'in_octets': '2304453327600',
                        'out_octets': '171376248013',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '171376248013',
                    'poller_hash':
                    'YjRmYmU0NzkzNTA3cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8108281',
                            'fiber_length': 4700,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.524
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzNTA3cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '171376248013',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2304453327600',
                    'poller_hash': 'YjRmYmU0NzkzNTA3ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'FUMCParsonage1-81672(temp inactive)',
                'serial_number':
                'UBNTe4793507',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:35:07',
                'temperature':
                62.0,
                'uptime':
                '8108324'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4253045053892',
                    'links': [{
                        'in_octets': '4253045053892',
                        'out_octets': '224080460647',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '224080460647',
                    'poller_hash':
                    'YjRmYmU0NzkzODkwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875910',
                            'fiber_length': 5145,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.316,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.11
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0NzkzODkwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '224080460647',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4253045053892',
                    'poller_hash': 'YjRmYmU0NzkzODkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'JMedrano-81783',
                'serial_number':
                'UBNTe4793890',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:79:38:90',
                'temperature':
                59.0,
                'uptime':
                '8875963'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '56750503034',
                    'links': [{
                        'in_octets': '56750503034',
                        'out_octets': '4814326888',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '4814326888',
                    'poller_hash':
                    'YjRmYmU0Zjk1MzI1cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '4043058',
                            'fiber_length': 4495,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.466,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.554
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1MzI1cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '4814326888',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '56750503034',
                    'poller_hash': 'YjRmYmU0Zjk1MzI1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'CVandiver-80251',
                'serial_number':
                'UBNTe4f95325',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:53:25',
                'temperature':
                71.0,
                'uptime':
                '4043127'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '55315559895',
                    'links': [{
                        'in_octets': '55315559895',
                        'out_octets': '2397415516',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2397415516',
                    'poller_hash':
                    'YjRmYmU0Zjk1MzYxcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '258319',
                            'fiber_length': 4790,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 4.13
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1MzYxcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '2397415516',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '55315559895',
                    'poller_hash': 'YjRmYmU0Zjk1MzYxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'ScottSheffy-76556',
                'serial_number':
                'UBNTe4f95361',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:53:61',
                'temperature':
                67.0,
                'uptime':
                '3342216'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '47790346452',
                    'links': [{
                        'in_octets': '47790346452',
                        'out_octets': '2495620117',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2495620117',
                    'poller_hash':
                    'YjRmYmU0Zjk1MzhlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '258318',
                            'fiber_length': 4508,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.552
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1MzhlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '2495620117',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '47790346452',
                    'poller_hash': 'YjRmYmU0Zjk1MzhlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'CNeinast-80149',
                'serial_number':
                'UBNTe4f9538e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:53:8e',
                'temperature':
                56.0,
                'uptime':
                '1118877'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '87608301203',
                    'links': [{
                        'in_octets': '87608301203',
                        'out_octets': '5567527266',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5567527266',
                    'poller_hash':
                    'YjRmYmU0Zjk1MzlkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '258319',
                            'fiber_length': 4757,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.596,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.618
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1MzlkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '5567527266',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '87608301203',
                    'poller_hash': 'YjRmYmU0Zjk1MzlkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'DEspinosa-78795',
                'serial_number':
                'UBNTe4f9539d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:53:9d',
                'temperature':
                56.0,
                'uptime':
                '1092552'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1370828170246',
                    'links': [{
                        'in_octets': '1370828170246',
                        'out_octets': '318358605919',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '318358605919',
                    'poller_hash':
                    'YjRmYmU0Zjk1NGY2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8212592',
                            'fiber_length': 4908,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.596,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.26
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1NGY2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '318358605919',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1370828170246',
                    'poller_hash': 'YjRmYmU0Zjk1NGY2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'HJeter-79483',
                'serial_number':
                'UBNTe4f954f6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:54:f6',
                'temperature':
                59.0,
                'uptime':
                '8212656'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1205998367684',
                    'links': [{
                        'in_octets': '1205998367684',
                        'out_octets': '28878540612',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28878540612',
                    'poller_hash':
                    'YjRmYmU0Zjk1NWEwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '13997742',
                            'fiber_length': 4487,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.596,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.528
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1NWEwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '28878540612',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1205998367684',
                    'poller_hash': 'YjRmYmU0Zjk1NWEwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'AGallegos-91213',
                'serial_number':
                'UBNTe4f955a0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:55:a0',
                'temperature':
                65.0,
                'uptime':
                '13997807'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '6087336398467',
                    'links': [{
                        'in_octets': '6087336398467',
                        'out_octets': '1087759929785',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1087759929785',
                    'poller_hash':
                    'ZDAyMWY5MDYxN2Y0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '10946486',
                            'fiber_length': 4253,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.072
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5MDYxN2Y0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1087759929785',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '6087336398467',
                    'poller_hash': 'ZDAyMWY5MDYxN2Y0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'JRodriguez-86428',
                'serial_number':
                'UBNTf90617f4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'd0:21:f9:06:17:f4',
                'temperature':
                57.0,
                'uptime':
                '10946552'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '652878335304',
                    'links': [{
                        'in_octets': '652878335304',
                        'out_octets': '24975444572',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24975444572',
                    'poller_hash':
                    'ZDAyMWY5OWE4NWEwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1533016',
                            'fiber_length': 5525,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.794
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWE4NWEwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '24975444572',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '652878335304',
                    'poller_hash': 'ZDAyMWY5OWE4NWEwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'JEmerson-77700',
                'serial_number':
                'UBNTf99a85a0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'd0:21:f9:9a:85:a0',
                'temperature':
                69.0,
                'uptime':
                '1533064'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '458407159940',
                    'links': [{
                        'in_octets': '458407159940',
                        'out_octets': '40171739322',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uN2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '40171739322',
                    'poller_hash':
                    'ZDAyMWY5OWFhNWMwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '6400229',
                            'fiber_length': 4446,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys3',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.808,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.856
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZDAyMWY5OWFhNWMwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '40171739322',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '458407159940',
                    'poller_hash': 'ZDAyMWY5OWFhNWMwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'FTaylor-96291',
                'serial_number':
                'UBNTf99aa5c0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'd0:21:f9:9a:a5:c0',
                'temperature':
                70.0,
                'uptime':
                '7600822'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '45006651096',
                    'links': [{
                        'in_octets': '45006651096',
                        'out_octets': '1400990970',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1400990970',
                    'poller_hash':
                    'MThlODI5MGI5NzY0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951378',
                            'fiber_length': 5639,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.518,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.062
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGI5NzY0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1400990970',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '45006651096',
                    'poller_hash': 'MThlODI5MGI5NzY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'NanoG',
                'name':
                'PRiley-94133',
                'serial_number':
                'UBNT290b9764',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:97:64',
                'temperature':
                63.0,
                'uptime':
                '4672861'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '182340782047',
                    'links': [{
                        'in_octets': '182340782047',
                        'out_octets': '10143187620',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10143187620',
                    'poller_hash':
                    'MThlODI5MGJhZTY4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951908',
                            'fiber_length': 4628,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.306,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.394
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJhZTY4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '10143187620',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '182340782047',
                    'poller_hash': 'MThlODI5MGJhZTY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'Armando Prieto - 94883',
                'serial_number':
                'UBNT290bae68',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:ae:68',
                'temperature':
                67.0,
                'uptime':
                '4584863'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2154979290922',
                    'links': [{
                        'in_octets': '2154979290922',
                        'out_octets': '145608047087',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '145608047087',
                    'poller_hash':
                    'MThlODI5MGJkYmUwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8211872',
                            'fiber_length': 4848,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.978,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.59
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MGJkYmUwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '145608047087',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2154979290922',
                    'poller_hash': 'MThlODI5MGJkYmUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                'ADaniel-96546',
                'serial_number':
                'UBNT290bdbe0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:0b:db:e0',
                'temperature':
                70.0,
                'uptime':
                '8211921'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '283082342300',
                    'links': [{
                        'in_octets': '283082342300',
                        'out_octets': '11259083628',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11259083628',
                    'poller_hash':
                    'MThlODI5MTlhZTI0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '3478391',
                            'fiber_length': 5085,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.766,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.206
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5MTlhZTI0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '11259083628',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '283082342300',
                    'poller_hash': 'MThlODI5MTlhZTI0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'JFlynt-81277',
                'serial_number':
                'UBNT2919ae24',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:19:ae:24',
                'temperature':
                59.0,
                'uptime':
                '3478456'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3152745259419',
                    'links': [{
                        'in_octets': '3152745259419',
                        'out_octets': '114759952567',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '114759952567',
                    'poller_hash':
                    'MThlODI5ZjVkNDBmcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875900',
                            'fiber_length': 4842,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.372,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.302
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5ZjVkNDBmcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '114759952567',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3152745259419',
                    'poller_hash': 'MThlODI5ZjVkNDBmZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'JMcLean-88569',
                'serial_number':
                'UBNT29f5d40f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:f5:d4:0f',
                'temperature':
                51.0,
                'uptime':
                '8875962'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1037467946612',
                    'links': [{
                        'in_octets': '1037467946612',
                        'out_octets': '45267639156',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '45267639156',
                    'poller_hash':
                    'MThlODI5ZjVkNGZlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1952481',
                            'fiber_length': 4673,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.466,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.924
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'MThlODI5ZjVkNGZlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '45267639156',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1037467946612',
                    'poller_hash': 'MThlODI5ZjVkNGZlZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'SOltivero-88505',
                'serial_number':
                'UBNT29f5d4fe',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '18:e8:29:f5:d4:fe',
                'temperature':
                68.0,
                'uptime':
                '1952543'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1598354885334',
                    'links': [{
                        'in_octets': '1598354885334',
                        'out_octets': '29545387833',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '29545387833',
                    'poller_hash':
                    'Nzg0NTU4MDYyODc0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '6293697',
                            'fiber_length': 4875,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.376,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.01
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'Nzg0NTU4MDYyODc0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '29545387833',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1598354885334',
                    'poller_hash': 'Nzg0NTU4MDYyODc0ZXRoMQ==',
                    'speed': '10000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'LCleveland-82159',
                'serial_number':
                'UBNT58062874',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '78:45:58:06:28:74',
                'temperature':
                49.0,
                'uptime':
                '6293762'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '99727316536',
                    'links': [{
                        'in_octets': '99727316536',
                        'out_octets': '3271692447',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3271692447',
                    'poller_hash':
                    'NjhkNzlhMDY4ZDdkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1445644',
                            'fiber_length': 4839,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.436,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.178
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NjhkNzlhMDY4ZDdkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '3271692447',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '99727316536',
                    'poller_hash': 'NjhkNzlhMDY4ZDdkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'LQuiroz-91118',
                'serial_number':
                'UBNT9a068d7d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '68:d7:9a:06:8d:7d',
                'temperature':
                55.0,
                'uptime':
                '1445709'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '160255367058',
                    'links': [{
                        'in_octets': '160255367058',
                        'out_octets': '14201918403',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14201918403',
                    'poller_hash':
                    'NzRhY2I5MDY3YTk2cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '944748',
                            'fiber_length': 5350,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.552
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5MDY3YTk2cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '14201918403',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '160255367058',
                    'poller_hash': 'NzRhY2I5MDY3YTk2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'SOrtiz-89888',
                'serial_number':
                'UBNTb9067a96',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:ac:b9:06:7a:96',
                'temperature':
                70.0,
                'uptime':
                '944817'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '240809337228',
                    'links': [{
                        'in_octets': '240809337228',
                        'out_octets': '7015955001',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7015955001',
                    'poller_hash':
                    'NzRhY2I5MDY3YWExcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951388',
                            'fiber_length': 5461,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.548,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.138
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzRhY2I5MDY3YWExcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '7015955001',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '240809337228',
                    'poller_hash': 'NzRhY2I5MDY3YWExZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'KBlack-90729',
                'serial_number':
                'UBNTb9067aa1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:ac:b9:06:7a:a1',
                'temperature':
                56.0,
                'uptime':
                '1895344'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '243959944123',
                    'links': [{
                        'in_octets': '243959944123',
                        'out_octets': '6209297373',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6209297373',
                    'poller_hash':
                    'ZjQ5MmJmMDY0MDExcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '1893320',
                            'fiber_length': 4687,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.372,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.258
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDY0MDExcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '6209297373',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '243959944123',
                    'poller_hash': 'ZjQ5MmJmMDY0MDExZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'CAnes-91096',
                'serial_number':
                'UBNTbf064011',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:40:11',
                'temperature':
                64.0,
                'uptime':
                '1893390'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1918832839941',
                    'links': [{
                        'in_octets': '1918832839941',
                        'out_octets': '91775156756',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '91775156756',
                    'poller_hash':
                    'ZjQ5MmJmMDY0YjU5cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875889',
                            'fiber_length': 4645,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.01,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.224
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDY0YjU5cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '91775156756',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1918832839941',
                    'poller_hash': 'ZjQ5MmJmMDY0YjU5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'JEnriquez-91069',
                'serial_number':
                'UBNTbf064b59',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:4b:59',
                'temperature':
                46.0,
                'uptime':
                '8875962'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '353244671616',
                    'links': [{
                        'in_octets': '353244671616',
                        'out_octets': '16026785871',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '16026785871',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNGQycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '944748',
                            'fiber_length': 5297,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.756,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.098
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlNGQycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '16026785871',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '353244671616',
                    'poller_hash': 'ZjQ5MmJmMDZlNGQyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'JCastillo - 93331',
                'serial_number':
                'UBNTbf06e4d2',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:e4:d2',
                'temperature':
                54.0,
                'uptime':
                '944817'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '983577417876',
                    'links': [{
                        'in_octets': '983577417876',
                        'out_octets': '32937811937',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '32937811937',
                    'poller_hash':
                    'ZjQ5MmJmMDZlYzcxcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8875889',
                            'fiber_length': 5093,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.436,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.438
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZlYzcxcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '32937811937',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '983577417876',
                    'poller_hash': 'ZjQ5MmJmMDZlYzcxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'DFisher-94176',
                'serial_number':
                'UBNTbf06ec71',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:ec:71',
                'temperature':
                55.0,
                'uptime':
                '8875963'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '5380764017',
                    'links': [{
                        'in_octets': '5380764017',
                        'out_octets': '1172612681',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1172612681',
                    'poller_hash':
                    'ZjQ5MmJmMDZmZWY4cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951388',
                            'fiber_length': 5421,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.006,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.004
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZjQ5MmJmMDZmZWY4cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '1172612681',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '5380764017',
                    'poller_hash': 'ZjQ5MmJmMDZmZWY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'ColonialFuneralHome-82084',
                'serial_number':
                'UBNTbf06fef8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'f4:92:bf:06:fe:f8',
                'temperature':
                53.0,
                'uptime':
                '4584308'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '346821063899',
                    'links': [{
                        'in_octets': '346821063899',
                        'out_octets': '10163035123',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10163035123',
                    'poller_hash':
                    'NzQ4M2MyNDNmNjVkcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951388',
                            'fiber_length': 5203,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.364,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.192
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmNjVkcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '10163035123',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '346821063899',
                    'poller_hash': 'NzQ4M2MyNDNmNjVkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'RBonilla-87432',
                'serial_number':
                'UBNTc243f65d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f6:5d',
                'temperature':
                50.0,
                'uptime':
                '4584328'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4445890193784',
                    'links': [{
                        'in_octets': '4445890193784',
                        'out_octets': '140580169493',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '140580169493',
                    'poller_hash':
                    'NzQ4M2MyNDNmOWNlcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8211732',
                            'fiber_length': 4811,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.31
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNDNmOWNlcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '140580169493',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4445890193784',
                    'poller_hash': 'NzQ4M2MyNDNmOWNlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'JRamos-86516',
                'serial_number':
                'UBNTc243f9ce',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:43:f9:ce',
                'temperature':
                55.0,
                'uptime':
                '8211801'
            }, {
                'cpu':
                5.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '466352394676',
                    'links': [{
                        'in_octets': '466352394676',
                        'out_octets': '17455000120',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17455000120',
                    'poller_hash':
                    'NzQ4M2MyNjgzNTQxcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951388',
                            'fiber_length': 5701,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.364,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.972
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjgzNTQxcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '17455000120',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '466352394676',
                    'poller_hash': 'NzQ4M2MyNjgzNTQxZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'JSullivan-85036',
                'serial_number':
                'UBNTc2683541',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:35:41',
                'temperature':
                47.0,
                'uptime':
                '1399987'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2736147416377',
                    'links': [{
                        'in_octets': '2736147416377',
                        'out_octets': '270759008586',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '270759008586',
                    'poller_hash':
                    'NzQ4M2MyNjhiMTdjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '8719758',
                            'fiber_length': 4670,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.218,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.832
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhiMTdjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '270759008586',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2736147416377',
                    'poller_hash': 'NzQ4M2MyNjhiMTdjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'MGardo-91431',
                'serial_number':
                'UBNTc268b17c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:b1:7c',
                'temperature':
                67.0,
                'uptime':
                '8719803'
            }, {
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '151353552645',
                    'links': [{
                        'in_octets': '151353552645',
                        'out_octets': '4775225144',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '4775225144',
                    'poller_hash':
                    'NzQ4M2MyNjhiMjA0cGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951388',
                            'fiber_length': 5272,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.938,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.732
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'NzQ4M2MyNjhiMjA0cG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '4775225144',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '151353552645',
                    'poller_hash': 'NzQ4M2MyNjhiMjA0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'CFinck-95040',
                'serial_number':
                'UBNTc268b204',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                '74:83:c2:68:b2:04',
                'temperature':
                73.0,
                'uptime':
                '2591953'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '232157396114',
                    'links': [{
                        'in_octets': '232157396114',
                        'out_octets': '9981271420',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9981271420',
                    'poller_hash':
                    'ZmNlY2RhZWI5NTEwcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951388',
                            'fiber_length': 5607,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.228,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.92
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'ZmNlY2RhZWI5NTEwcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '9981271420',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '232157396114',
                    'poller_hash': 'ZmNlY2RhZWI5NTEwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'BDrennan-83726',
                'serial_number':
                'UBNTdaeb9510',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'fc:ec:da:eb:95:10',
                'temperature':
                65.0,
                'uptime':
                '4584484'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1373772696207',
                    'links': [{
                        'in_octets': '1373772696207',
                        'out_octets': '39211601708',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '39211601708',
                    'poller_hash':
                    'YjRmYmU0ZTZjNTYycGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '4236961',
                            'fiber_length': 5087,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.228,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.642
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZjNTYycG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '39211601708',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1373772696207',
                    'poller_hash': 'YjRmYmU0ZTZjNTYyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'EChavez-84336',
                'serial_number':
                'UBNTe4e6c562',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:c5:62',
                'temperature':
                55.0,
                'uptime':
                '4237029'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '562147073262',
                    'links': [{
                        'in_octets': '562147073262',
                        'out_octets': '27771790989',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27771790989',
                    'poller_hash':
                    'YjRmYmU0ZTZkZjJicGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '944748',
                            'fiber_length': 5281,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.278,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.33
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0ZTZkZjJicG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '27771790989',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '562147073262',
                    'poller_hash': 'YjRmYmU0ZTZkZjJiZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'LCase-94834',
                'serial_number':
                'UBNTe4e6df2b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:e6:df:2b',
                'temperature':
                62.0,
                'uptime':
                '944817'
            }, {
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '38485612988',
                    'links': [{
                        'in_octets': '38485612988',
                        'out_octets': '2360114624',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2360114624',
                    'poller_hash':
                    'YjRmYmU0Zjk0ZjUxcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '695024',
                            'fiber_length': 4839,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.088,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.72
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk0ZjUxcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '2360114624',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '38485612988',
                    'poller_hash': 'YjRmYmU0Zjk0ZjUxZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'POrtiz-79058',
                'serial_number':
                'UBNTe4f94f51',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:4f:51',
                'temperature':
                61.0,
                'uptime':
                '2429158'
            }, {
                'cpu':
                4.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '232491614152',
                    'links': [{
                        'in_octets': '232491614152',
                        'out_octets': '8377562090',
                        'poller_hash': 'Nzg4YTIwMGQ3NTdlcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8377562090',
                    'poller_hash':
                    'YjRmYmU0Zjk1MzVjcGVlcmludGY=',
                    'pons': [{
                        'links': [{
                            'connected_time': '951378',
                            'fiber_length': 5233,
                            'poller_hash': 'Nzg4YTIwMGQ3NTdlVUYtR1AtQys4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.202,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.562
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'poller_hash':
                        'YjRmYmU0Zjk1MzVjcG9ubGluaw==',
                        'split_ratio':
                        128
                    }]
                }, {
                    'id': '1',
                    'in_octets': '8377562090',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '232491614152',
                    'poller_hash': 'YjRmYmU0Zjk1MzVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'MLytle-77547',
                'serial_number':
                'UBNTe4f9535c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.6',
                'system_mac_address':
                'b4:fb:e4:f9:53:5c',
                'temperature':
                73.0,
                'uptime':
                '3311138'
            }]
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_4_9_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.4.9.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 8,
            'sw_version': '4.4.9',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 8}
        exp_sta_stats = {
            '18:e8:29:0b:9a:d8': {
                'dev_macs': ['74:4d:28:5b:15:46'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:9a:d8',
                'name': '18:e8:29:0b:9a:d8'
            },
            '18:e8:29:f5:80:54': {
                'dev_macs': ['18:b1:69:7a:34:51'],
                'ip_address': None,
                'mac_address': '18:e8:29:f5:80:54',
                'name': '22049-Darren Patterson Christian '
                'Academy'
            },
            '18:e8:29:f5:b0:72': {
                'dev_macs': ['68:d7:9a:67:b9:2d'],
                'ip_address': None,
                'mac_address': '18:e8:29:f5:b0:72',
                'name': '10340-carlin-walsh-ufiberwifi'
            },
            '74:83:c2:f0:1e:90': {
                'dev_macs': ['48:a9:8a:5f:bc:94'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:1e:90',
                'name': '756289-evan-bartlett-nanog'
            },
            '74:83:c2:f0:b1:a4': {
                'dev_macs': ['18:fd:74:1c:bf:7a'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:b1:a4',
                'name': '756084-anna-toll'
            },
            'b4:fb:e4:eb:4d:58': {
                'dev_macs': ['48:8f:5a:49:bf:9b'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:eb:4d:58',
                'name': '10523-jay-leaver-nanog'
            },
            'b4:fb:e4:eb:4d:62': {
                'dev_macs': ['34:98:b5:c4:4e:11'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:eb:4d:62',
                'name': '24017-grace-garret-nanog'
            },
            'b4:fb:e4:eb:50:73': {
                'dev_macs': ['48:8f:5a:82:a9:f7'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:eb:50:73',
                'name': '20157-ellen-kelly-nanog'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                8.0,
                'errors': [{
                    'http_connect': {}
                }],
                'interfaces': [{
                    'id': 'eth0',
                    'name': 'MGMT',
                    'poller_hash': 'YjRmYmU0MWIyODc1ZXRoMGludGY='
                }, {
                    'id': 'pon1',
                    'in_errors': '0',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'pon1',
                    'out_errors': '0',
                    'out_octets': '400029918',
                    'out_ucast_pkts': '2797173',
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uMWludGY='
                }, {
                    'id': 'pon2',
                    'in_errors': '0',
                    'in_octets': '2024631609766',
                    'in_ucast_pkts': '4007766242',
                    'name': 'pon2',
                    'out_errors': '0',
                    'out_octets': '9346603003067',
                    'out_ucast_pkts': '8079833261',
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                }, {
                    'id': 'pon3',
                    'in_errors': '0',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'pon3',
                    'out_errors': '0',
                    'out_octets': '400029918',
                    'out_ucast_pkts': '2797173',
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uM2ludGY='
                }, {
                    'id': 'pon4',
                    'in_errors': '0',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'pon4',
                    'out_errors': '0',
                    'out_octets': '400029918',
                    'out_ucast_pkts': '2797173',
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='
                }, {
                    'id': 'pon5',
                    'in_errors': '0',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'pon5',
                    'out_errors': '0',
                    'out_octets': '400029918',
                    'out_ucast_pkts': '2797173',
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uNWludGY='
                }, {
                    'id': 'pon6',
                    'in_errors': '0',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'pon6',
                    'out_errors': '0',
                    'out_octets': '400029918',
                    'out_ucast_pkts': '2797173',
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uNmludGY='
                }, {
                    'id': 'pon7',
                    'in_errors': '0',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'pon7',
                    'out_errors': '0',
                    'out_octets': '400029918',
                    'out_ucast_pkts': '2797173',
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uN2ludGY='
                }, {
                    'id': 'pon8',
                    'in_errors': '0',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'pon8',
                    'out_errors': '0',
                    'out_octets': '400029918',
                    'out_ucast_pkts': '2797173',
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uOGludGY='
                }, {
                    'id': 'sfp1',
                    'in_octets': '9314888572469',
                    'in_ucast_pkts': '8087506249',
                    'name': 'SFP+ 1',
                    'out_octets': '2008696627547',
                    'out_ucast_pkts': '4007851956',
                    'poller_hash': 'YjRmYmU0MWIyODc1c2ZwMWludGY='
                }, {
                    'id': 'sfp2',
                    'in_octets': '0',
                    'in_ucast_pkts': '0',
                    'name': 'SFP+ 2',
                    'out_octets': '0',
                    'out_ucast_pkts': '0',
                    'poller_hash': 'YjRmYmU0MWIyODc1c2ZwMmludGY='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                14.0,
                'model':
                'UFiber OLT',
                'serial_number':
                'UBNTe41b2875',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                'b4:fb:e4:1b:28:75',
                'temperature':
                33.75,
                'uptime':
                '12273875'
            }
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
