import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):
    def test_ubnt_wave_ap_Wave_AP_Micro_v3_1_1_01(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP Micro.v3.1.1.01")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP Micro',
                'rf_chan_width': 1080,
                'rf_freq': 61560,
                'rf_tx_power': 21,
                'sta_count': 4,
                'sta_mode_cpe': False,
                'sw_version': 'v3.1.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 1953645050463,
                'dl_en_packets': 2819658252,
                'dl_noise_floor': None,
                'dl_rf_bytes': 2237953956468,
                'dl_rf_packets': 5572000307,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 136268441246,
                'ul_en_packets': 603072793,
                'ul_noise_floor': None,
                'ul_rf_bytes': 152992776489,
                'ul_rf_packets': 623523542
        }
        exp_sta_stats = {
                '60:22:32:6f:a4:6f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 616652607678,
                                             'dl_rf_packets': 1416468508,
                                             'dl_rssi': -59.0,
                                             'dl_snr': None,
                                             'ip_address': '10.100.14.133',
                                             'mac_address': '60:22:32:6f:a4:6f',
                                             'name': 'JUtter-691905',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 34717314689,
                                             'ul_rf_packets': 213339117,
                                             'ul_rssi': -55.0,
                                             'ul_snr': None},
                'ac:8b:a9:65:1e:bd': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 431827528725,
                                             'dl_rf_packets': 1096765273,
                                             'dl_rssi': -68.0,
                                             'dl_snr': None,
                                             'ip_address': '10.100.15.17',
                                             'mac_address': 'ac:8b:a9:65:1e:bd',
                                             'name': 'JSummers-691988',
                                             'ul_link_rate': 673750000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 36076343427,
                                             'ul_rf_packets': 107598858,
                                             'ul_rssi': -66.0,
                                             'ul_snr': None},
                'ac:8b:a9:65:1e:c1': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 643964070073,
                                             'dl_rf_packets': 1402599383,
                                             'dl_rssi': -60.0,
                                             'dl_snr': None,
                                             'ip_address': '10.100.15.16',
                                             'mac_address': 'ac:8b:a9:65:1e:c1',
                                             'name': 'MSeigerman-691993',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 36149574109,
                                             'ul_rf_packets': 143775162,
                                             'ul_rssi': -59.0,
                                             'ul_snr': None},
                'ac:8b:a9:65:21:5d': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 133968386903,
                                             'dl_rf_packets': 749088498,
                                             'dl_rssi': -57.0,
                                             'dl_snr': None,
                                             'ip_address': '10.100.15.32',
                                             'mac_address': 'ac:8b:a9:65:21:5d',
                                             'name': 'MHarsin-691979',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 18006911347,
                                             'ul_rf_packets': 41073145,
                                             'ul_rssi': -57.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 16.0,
                                'elevation': 806.9,
                                'gps_sats_tracked': 9,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '1953645050463',
                                                              'in_ucast_pkts': '2819658252',
                                                              'mac_address': '04:18:d6:a3:56:40',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '136268441246',
                                                              'out_ucast_pkts': '603072793',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '5',
                                                              'in_octets': '157',
                                                              'in_ucast_pkts': '9',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '24276197950',
                                                              'out_ucast_pkts': '379926932',
                                                              'poller_hash': 'MDQxOGQ2YTM1NjNmYXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '152992776332',
                                                              'in_ucast_pkts': '623523533',
                                                              'links': [       {       'in_octets': '34717314689',
                                                                                       'in_ucast_pkts': '213339117',
                                                                                       'mac_address': '60:22:32:6f:a4:6f',
                                                                                       'out_octets': '616652607678',
                                                                                       'out_ucast_pkts': '1416468508'},
                                                                               {       'in_octets': '18006911347',
                                                                                       'in_ucast_pkts': '41073145',
                                                                                       'mac_address': 'ac:8b:a9:65:21:5d',
                                                                                       'out_octets': '133968386903',
                                                                                       'out_ucast_pkts': '749088498'},
                                                                               {       'in_octets': '36076343427',
                                                                                       'in_ucast_pkts': '107598858',
                                                                                       'mac_address': 'ac:8b:a9:65:1e:bd',
                                                                                       'out_octets': '431827528725',
                                                                                       'out_ucast_pkts': '1096765273'},
                                                                               {       'in_octets': '36149574109',
                                                                                       'in_ucast_pkts': '143775162',
                                                                                       'mac_address': 'ac:8b:a9:65:1e:c1',
                                                                                       'out_octets': '643964070073',
                                                                                       'out_ucast_pkts': '1402599383'}],
                                                              'mac_address': '04:18:d6:a3:56:3f',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '2213677758518',
                                                              'out_ucast_pkts': '5192073375',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 61560,
                                                                                        'rx_link_rate': '1000000000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2669246',
                                                                                                                                            'distance': 625,
                                                                                                                                            'mac_address': '60:22:32:6f:a4:6f',
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '875875000'},
                                                                                                                                    {       'connected_time': '1691018',
                                                                                                                                            'distance': 520,
                                                                                                                                            'mac_address': 'ac:8b:a9:65:21:5d',
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '875875000'},
                                                                                                                                    {       'connected_time': '273342',
                                                                                                                                            'distance': 630,
                                                                                                                                            'mac_address': 'ac:8b:a9:65:1e:bd',
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '673750000',
                                                                                                                                            'tx_link_rate': '875875000'},
                                                                                                                                    {       'connected_time': '2397519',
                                                                                                                                            'distance': 662,
                                                                                                                                            'mac_address': 'ac:8b:a9:65:1e:c1',
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '875875000'}]}],
                                                                                        'tx_link_rate': '1000000000',
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MLWR200U6_W_2'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 47.587198,
                                'longitude': -117.667027,
                                'manufacturer': 'Ubiquiti',
                                'mem': 42.0,
                                'model': 'Wave AP Micro',
                                'sw_version': 'v3.1.1',
                                'system_mac_address': '04:18:d6:a3:56:3f',
                                'temperature': 39.0,
                                'uptime': '3612126'},
                'peers': [       {       'cpu': 16.0,
                                         'elevation': 755.4,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '29713400711',
                                                                       'in_ucast_pkts': '211182787',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '611375333823',
                                                                       'out_ucast_pkts': '1409872477',
                                                                       'poller_hash': 'NjAyMjMyNmZhNDZmZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmZhNDZmYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '616652607678',
                                                                       'in_ucast_pkts': '1416468508',
                                                                       'links': [       {       'in_octets': '616652607678',
                                                                                                'in_ucast_pkts': '1416468508',
                                                                                                'mac_address': '04:18:d6:a3:56:3f',
                                                                                                'out_octets': '34717314689',
                                                                                                'out_ucast_pkts': '213339117'}],
                                                                       'mac_address': '60:22:32:6f:a4:6f',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '34717314689',
                                                                       'out_ucast_pkts': '213339117',
                                                                       'poller_hash': 'NjAyMjMyNmZhNDZmd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 61560,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2669246',
                                                                                                                                                     'distance': 625,
                                                                                                                                                     'mac_address': '04:18:d6:a3:56:3f',
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MLWR200U6_W_2'}],
                                                                       'type': 71}],
                                         'latitude': 47.582962,
                                         'longitude': -117.672321,
                                         'management_ip': '10.100.14.133',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'JUtter-691905',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:a4:6f',
                                         'uptime': '2669454'},
                                 {       'cpu': 16.0,
                                         'elevation': 750.6,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '16093762261',
                                                                       'in_ucast_pkts': '39721077',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '130503947842',
                                                                       'out_ucast_pkts': '744970623',
                                                                       'poller_hash': 'YWM4YmE5NjUyMTVkZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'YWM4YmE5NjUyMTVkYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '133968386903',
                                                                       'in_ucast_pkts': '749088498',
                                                                       'links': [       {       'in_octets': '133968386903',
                                                                                                'in_ucast_pkts': '749088498',
                                                                                                'mac_address': '04:18:d6:a3:56:3f',
                                                                                                'out_octets': '18006911347',
                                                                                                'out_ucast_pkts': '41073145'}],
                                                                       'mac_address': 'ac:8b:a9:65:21:5d',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '18006911347',
                                                                       'out_ucast_pkts': '41073145',
                                                                       'poller_hash': 'YWM4YmE5NjUyMTVkd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 61560,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1691018',
                                                                                                                                                     'distance': 520,
                                                                                                                                                     'mac_address': '04:18:d6:a3:56:3f',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MLWR200U6_W_2'}],
                                                                       'type': 71}],
                                         'latitude': 47.58428,
                                         'longitude': -117.672375,
                                         'management_ip': '10.100.15.32',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'MHarsin-691979',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:65:21:5d',
                                         'uptime': '1691161'},
                                 {       'cpu': 17.0,
                                         'elevation': 752.7,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '32346501153',
                                                                       'in_ucast_pkts': '105951132',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '427608053487',
                                                                       'out_ucast_pkts': '1091756924',
                                                                       'poller_hash': 'YWM4YmE5NjUxZWJkZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'YWM4YmE5NjUxZWJkYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '431827528725',
                                                                       'in_ucast_pkts': '1096765273',
                                                                       'links': [       {       'in_octets': '431827528725',
                                                                                                'in_ucast_pkts': '1096765273',
                                                                                                'mac_address': '04:18:d6:a3:56:3f',
                                                                                                'out_octets': '36076343427',
                                                                                                'out_ucast_pkts': '107598858'}],
                                                                       'mac_address': 'ac:8b:a9:65:1e:bd',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '36076343427',
                                                                       'out_ucast_pkts': '107598858',
                                                                       'poller_hash': 'YWM4YmE5NjUxZWJkd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 61560,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '273342',
                                                                                                                                                     'distance': 630,
                                                                                                                                                     'mac_address': '04:18:d6:a3:56:3f',
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'tx_link_rate': '673750000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MLWR200U6_W_2'}],
                                                                       'type': 71}],
                                         'latitude': 47.583661,
                                         'longitude': -117.673579,
                                         'management_ip': '10.100.15.17',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'JSummers-691988',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:65:1e:bd',
                                         'uptime': '2056016'},
                                 {       'cpu': 18.0,
                                         'elevation': 748.7,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '31662125100',
                                                                       'in_ucast_pkts': '141868177',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '639019812417',
                                                                       'out_ucast_pkts': '1396276277',
                                                                       'poller_hash': 'YWM4YmE5NjUxZWMxZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'YWM4YmE5NjUxZWMxYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '643964070073',
                                                                       'in_ucast_pkts': '1402599383',
                                                                       'links': [       {       'in_octets': '643964070073',
                                                                                                'in_ucast_pkts': '1402599383',
                                                                                                'mac_address': '04:18:d6:a3:56:3f',
                                                                                                'out_octets': '36149574109',
                                                                                                'out_ucast_pkts': '143775162'}],
                                                                       'mac_address': 'ac:8b:a9:65:1e:c1',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '36149574109',
                                                                       'out_ucast_pkts': '143775162',
                                                                       'poller_hash': 'YWM4YmE5NjUxZWMxd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 61560,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2397519',
                                                                                                                                                     'distance': 662,
                                                                                                                                                     'mac_address': '04:18:d6:a3:56:3f',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MLWR200U6_W_2'}],
                                                                       'type': 71}],
                                         'latitude': 47.583337,
                                         'longitude': -117.673609,
                                         'management_ip': '10.100.15.16',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'MSeigerman-691993',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:65:1e:c1',
                                         'uptime': '2397710'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_WaveAP_snmp_v3_0_2_beta2_02(self):
        obj = self.run_data("ubnt.wave-ap.WaveAP.snmp.v3.0.2-beta2.02")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 69120,
                'rf_tx_power': None,
                'sta_count': 5,
                'sta_mode_cpe': False,
                'sw_version': 'v3.0.2-beta2',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 8,
                'dl_en_bytes': 832781808,
                'dl_en_packets': 96062389,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1661746864,
                'dl_rf_packets': 968624965,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 9,
                'ul_en_bytes': 1169365668,
                'ul_en_packets': 1455194478,
                'ul_noise_floor': None,
                'ul_rf_bytes': 142249283,
                'ul_rf_packets': 363200759
        }
        exp_sta_stats = {
                '24:5a:4c:3e:df:99': {       'alt_macs': ['24:5a:4c:3f:df:99'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1078000000,
                                             'dl_noise_floor': -68.0,
                                             'dl_rf_bytes': 5594504180,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -48,
                                             'dl_snr': 20,
                                             'ip_address': '10.2.7.160',
                                             'mac_address': '24:5a:4c:3e:df:99',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 1078000000,
                                             'ul_noise_floor': -67.0,
                                             'ul_rf_bytes': 951402097,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -47.0,
                                             'ul_snr': 20.0},
                '24:5a:4c:3e:e0:d3': {       'alt_macs': ['24:5a:4c:3f:e0:d3'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1078000000,
                                             'dl_noise_floor': -64.0,
                                             'dl_rf_bytes': 53560377418,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -45,
                                             'dl_snr': 19,
                                             'ip_address': '10.2.7.107',
                                             'mac_address': '24:5a:4c:3e:e0:d3',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 1078000000,
                                             'ul_noise_floor': -62.0,
                                             'ul_rf_bytes': 3541203018,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -42.0,
                                             'ul_snr': 20.0},
                '24:5a:4c:3e:e8:30': {       'alt_macs': ['24:5a:4c:3f:e8:30'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1078000000,
                                             'dl_noise_floor': -63.0,
                                             'dl_rf_bytes': 281209173907,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -44,
                                             'dl_snr': 19,
                                             'ip_address': '10.2.7.170',
                                             'mac_address': '24:5a:4c:3e:e8:30',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 1078000000,
                                             'ul_noise_floor': -61.0,
                                             'ul_rf_bytes': 9612162982,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -42.0,
                                             'ul_snr': 19.0},
                '24:5a:4c:3e:e8:b8': {       'alt_macs': ['24:5a:4c:3f:e8:b8'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1078000000,
                                             'dl_noise_floor': -65.0,
                                             'dl_rf_bytes': 260196994771,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -46,
                                             'dl_snr': 19,
                                             'ip_address': '10.2.7.144',
                                             'mac_address': '24:5a:4c:3e:e8:b8',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 1078000000,
                                             'ul_noise_floor': -66.0,
                                             'ul_rf_bytes': 10330615722,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -46.0,
                                             'ul_snr': 20.0},
                '74:ac:b9:fe:a0:4b': {       'alt_macs': ['74:ac:b9:ff:a0:4b'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1078000000,
                                             'dl_noise_floor': -75.0,
                                             'dl_rf_bytes': 49763499316,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -56,
                                             'dl_snr': 19,
                                             'ip_address': '10.2.7.145',
                                             'mac_address': '74:ac:b9:fe:a0:4b',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': -74.0,
                                             'ul_rf_bytes': 1816076767,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55.0,
                                             'ul_snr': 19.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 8.0,
                                'elevation': 364.4,
                                'errors': [{'http_auth': {}}],
                                'gps_sats_tracked': 9,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '4',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1457888',
                                                              'in_octets': '142249283',
                                                              'in_ucast_pkts': '361742871',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_nucast_pkts': '21278',
                                                                                       'in_octets': '1816076767',
                                                                                       'in_ucast_pkts': '17167870',
                                                                                       'mac_address': '74:ac:b9:fe:a0:4b',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '49763499316',
                                                                                       'out_ucast_pkts': '35461367'},
                                                                               {       'in_nucast_pkts': '4397',
                                                                                       'in_octets': '951402097',
                                                                                       'in_ucast_pkts': '2427051',
                                                                                       'mac_address': '24:5a:4c:3e:df:99',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '5594504180',
                                                                                       'out_ucast_pkts': '4905173'},
                                                                               {       'in_nucast_pkts': '146433',
                                                                                       'in_octets': '3541203018',
                                                                                       'in_ucast_pkts': '12196630',
                                                                                       'mac_address': '24:5a:4c:3e:e0:d3',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '53560377418',
                                                                                       'out_ucast_pkts': '47304081'},
                                                                               {       'in_nucast_pkts': '114789',
                                                                                       'in_octets': '10330615722',
                                                                                       'in_ucast_pkts': '65170329',
                                                                                       'mac_address': '24:5a:4c:3e:e8:b8',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '260196994771',
                                                                                       'out_ucast_pkts': '196514520'},
                                                                               {       'in_nucast_pkts': '69666',
                                                                                       'in_octets': '9612162982',
                                                                                       'in_ucast_pkts': '55621025',
                                                                                       'mac_address': '24:5a:4c:3e:e8:30',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '281209173907',
                                                                                       'out_ucast_pkts': '201042241'}],
                                                              'mac_address': '68:d7:9a:1f:6a:95',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '18',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1661746864',
                                                              'out_ucast_pkts': '968624965',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'frequency': 69120,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '75874',
                                                                                                                                            'distance': 1237,
                                                                                                                                            'mac_address': '74:ac:b9:fe:a0:4b',
                                                                                                                                            'noise_floor': -74.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '1078000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '12532',
                                                                                                                                            'distance': 800,
                                                                                                                                            'mac_address': '24:5a:4c:3e:df:99',
                                                                                                                                            'noise_floor': -67.0,
                                                                                                                                            'rssi': -47.0,
                                                                                                                                            'rx_link_rate': '1078000000',
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '1078000000',
                                                                                                                                            'tx_mcs': 10},
                                                                                                                                    {       'connected_time': '434519',
                                                                                                                                            'distance': 697,
                                                                                                                                            'mac_address': '24:5a:4c:3e:e0:d3',
                                                                                                                                            'noise_floor': -62.0,
                                                                                                                                            'rssi': -42.0,
                                                                                                                                            'rx_link_rate': '1078000000',
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '1078000000',
                                                                                                                                            'tx_mcs': 10},
                                                                                                                                    {       'connected_time': '434887',
                                                                                                                                            'distance': 636,
                                                                                                                                            'mac_address': '24:5a:4c:3e:e8:b8',
                                                                                                                                            'noise_floor': -66.0,
                                                                                                                                            'rssi': -46.0,
                                                                                                                                            'rx_link_rate': '1078000000',
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '1078000000',
                                                                                                                                            'tx_mcs': 10},
                                                                                                                                    {       'connected_time': '373899',
                                                                                                                                            'distance': 506,
                                                                                                                                            'mac_address': '24:5a:4c:3e:e8:30',
                                                                                                                                            'noise_floor': -61.0,
                                                                                                                                            'rssi': -42.0,
                                                                                                                                            'rx_link_rate': '1078000000',
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '1078000000',
                                                                                                                                            'tx_mcs': 10}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Wave'}],
                                                              'speed': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '6',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '832781808',
                                                              'in_ucast_pkts': '96062389',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '68:d7:9a:1f:6a:96',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1169365668',
                                                              'out_ucast_pkts': '1455194478',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 33.81197,
                                'longitude': -98.683739,
                                'manufacturer': 'Ubiquiti',
                                'model': 'Wave AP',
                                'sw_version': 'v3.0.2-beta2',
                                'system_mac_address': '68:d7:9a:1f:6a:95',
                                'uptime': '2915621'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '49763499316',
                                                                       'in_ucast_pkts': '35461367',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '49763499316',
                                                                                                'in_ucast_pkts': '35461367',
                                                                                                'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                'out_nucast_pkts': '21278',
                                                                                                'out_octets': '1816076767',
                                                                                                'out_ucast_pkts': '17167870'}],
                                                                       'mac_address': '74:ac:b9:fe:a0:4b',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '21278',
                                                                       'out_octets': '1816076767',
                                                                       'out_ucast_pkts': '17167870',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '75874',
                                                                                                                                                     'distance': 1237,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                                                                     'noise_floor': -75.0,
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '1078000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '875875000',
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wave'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '74:ac:b9:ff:a0:4b',
                                                                       'name': 'eth0'}],
                                         'management_ip': '10.2.7.145',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '74:ac:b9:fe:a0:4b'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '5594504180',
                                                                       'in_ucast_pkts': '4905173',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '5594504180',
                                                                                                'in_ucast_pkts': '4905173',
                                                                                                'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                'out_nucast_pkts': '4397',
                                                                                                'out_octets': '951402097',
                                                                                                'out_ucast_pkts': '2427051'}],
                                                                       'mac_address': '24:5a:4c:3e:df:99',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '4397',
                                                                       'out_octets': '951402097',
                                                                       'out_ucast_pkts': '2427051',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '12532',
                                                                                                                                                     'distance': 800,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                                                                     'noise_floor': -68.0,
                                                                                                                                                     'rssi': -48.0,
                                                                                                                                                     'rx_link_rate': '1078000000',
                                                                                                                                                     'rx_mcs': 10,
                                                                                                                                                     'snr': 20.0,
                                                                                                                                                     'tx_link_rate': '1078000000',
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wave'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:3f:df:99',
                                                                       'name': 'eth0'}],
                                         'management_ip': '10.2.7.160',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:5a:4c:3e:df:99'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '53560377418',
                                                                       'in_ucast_pkts': '47304081',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '53560377418',
                                                                                                'in_ucast_pkts': '47304081',
                                                                                                'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                'out_nucast_pkts': '146433',
                                                                                                'out_octets': '3541203018',
                                                                                                'out_ucast_pkts': '12196630'}],
                                                                       'mac_address': '24:5a:4c:3e:e0:d3',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '146433',
                                                                       'out_octets': '3541203018',
                                                                       'out_ucast_pkts': '12196630',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '434519',
                                                                                                                                                     'distance': 697,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                                                                     'noise_floor': -64.0,
                                                                                                                                                     'rssi': -45.0,
                                                                                                                                                     'rx_link_rate': '1078000000',
                                                                                                                                                     'rx_mcs': 10,
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '1078000000',
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wave'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:3f:e0:d3',
                                                                       'name': 'eth0'}],
                                         'management_ip': '10.2.7.107',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:5a:4c:3e:e0:d3'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '260196994771',
                                                                       'in_ucast_pkts': '196514520',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '260196994771',
                                                                                                'in_ucast_pkts': '196514520',
                                                                                                'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                'out_nucast_pkts': '114789',
                                                                                                'out_octets': '10330615722',
                                                                                                'out_ucast_pkts': '65170329'}],
                                                                       'mac_address': '24:5a:4c:3e:e8:b8',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '114789',
                                                                       'out_octets': '10330615722',
                                                                       'out_ucast_pkts': '65170329',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '434887',
                                                                                                                                                     'distance': 636,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                                                                     'noise_floor': -65.0,
                                                                                                                                                     'rssi': -46.0,
                                                                                                                                                     'rx_link_rate': '1078000000',
                                                                                                                                                     'rx_mcs': 10,
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '1078000000',
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wave'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:3f:e8:b8',
                                                                       'name': 'eth0'}],
                                         'management_ip': '10.2.7.144',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:5a:4c:3e:e8:b8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '281209173907',
                                                                       'in_ucast_pkts': '201042241',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '281209173907',
                                                                                                'in_ucast_pkts': '201042241',
                                                                                                'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                'out_nucast_pkts': '69666',
                                                                                                'out_octets': '9612162982',
                                                                                                'out_ucast_pkts': '55621025'}],
                                                                       'mac_address': '24:5a:4c:3e:e8:30',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '69666',
                                                                       'out_octets': '9612162982',
                                                                       'out_ucast_pkts': '55621025',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '373899',
                                                                                                                                                     'distance': 506,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6a:95',
                                                                                                                                                     'noise_floor': -63.0,
                                                                                                                                                     'rssi': -44.0,
                                                                                                                                                     'rx_link_rate': '1078000000',
                                                                                                                                                     'rx_mcs': 10,
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '1078000000',
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Wave'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:3f:e8:30',
                                                                       'name': 'eth0'}],
                                         'management_ip': '10.2.7.170',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:5a:4c:3e:e8:30'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_WaveAP_v3_0_2_beta2_01(self):
        obj = self.run_data("ubnt.wave-ap.WaveAP.v3.0.2-beta2.01")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 69120,
                'rf_tx_power': None,
                'sta_count': 4,
                'sta_mode_cpe': False,
                'sw_version': 'v3.0.2-beta2',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 1157409566,
                'dl_en_packets': 2542700147,
                'dl_noise_floor': None,
                'dl_rf_bytes': 2743261877,
                'dl_rf_packets': 2640383867,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 2471415785,
                'ul_en_packets': 1100108857,
                'ul_noise_floor': None,
                'ul_rf_bytes': 2538392028,
                'ul_rf_packets': 1103661780
        }
        exp_sta_stats = {
                '24:5a:4c:3e:e1:0f': {       'alt_macs': ['24:5a:4c:3f:e1:0f'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': -79.0,
                                             'dl_rf_bytes': 55734989702,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -60,
                                             'dl_snr': 19,
                                             'ip_address': '192.168.16.33',
                                             'mac_address': '24:5a:4c:3e:e1:0f',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': -78.0,
                                             'ul_rf_bytes': 4310902779,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 18.0},
                '24:5a:4c:3e:ec:17': {       'alt_macs': ['24:5a:4c:3f:ec:17'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': -75.0,
                                             'dl_rf_bytes': 637520368022,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -58,
                                             'dl_snr': 17,
                                             'ip_address': '192.168.16.27',
                                             'mac_address': '24:5a:4c:3e:ec:17',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': -75.0,
                                             'ul_rf_bytes': 48148706040,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 17.0},
                'f4:92:bf:32:b4:07': {       'alt_macs': ['f4:92:bf:33:b4:07'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1078000000,
                                             'dl_noise_floor': -78.0,
                                             'dl_rf_bytes': 364515607941,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -59,
                                             'dl_snr': 19,
                                             'ip_address': '192.168.16.22',
                                             'mac_address': 'f4:92:bf:32:b4:07',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 1078000000,
                                             'ul_noise_floor': -75.0,
                                             'ul_rf_bytes': 47263257188,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 19.0},
                'f4:92:bf:de:fe:81': {       'alt_macs': ['f4:92:bf:df:fe:81'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1078000000,
                                             'dl_noise_floor': -69.0,
                                             'dl_rf_bytes': 362285387,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -51,
                                             'dl_snr': 18,
                                             'ip_address': '192.168.16.25',
                                             'mac_address': 'f4:92:bf:de:fe:81',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 1078000000,
                                             'ul_noise_floor': -69.0,
                                             'ul_rf_bytes': 359082156,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 19.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'elevation': 2401.9,
                                'errors': [{'http_auth': {}}],
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '517434',
                                                              'in_octets': '2538392028',
                                                              'in_ucast_pkts': '1103144346',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_nucast_pkts': '8573',
                                                                                       'in_octets': '359082156',
                                                                                       'in_ucast_pkts': '948114',
                                                                                       'mac_address': 'f4:92:bf:de:fe:81',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '362285387',
                                                                                       'out_ucast_pkts': '3221640'},
                                                                               {       'in_nucast_pkts': '12387',
                                                                                       'in_octets': '47263257188',
                                                                                       'in_ucast_pkts': '106288828',
                                                                                       'mac_address': 'f4:92:bf:32:b4:07',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '364515607941',
                                                                                       'out_ucast_pkts': '299671932'},
                                                                               {       'in_nucast_pkts': '15941',
                                                                                       'in_octets': '4310902779',
                                                                                       'in_ucast_pkts': '15544449',
                                                                                       'mac_address': '24:5a:4c:3e:e1:0f',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '55734989702',
                                                                                       'out_ucast_pkts': '48305225'},
                                                                               {       'in_nucast_pkts': '97950',
                                                                                       'in_octets': '48148706040',
                                                                                       'in_ucast_pkts': '252183369',
                                                                                       'mac_address': '24:5a:4c:3e:ec:17',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '637520368022',
                                                                                       'out_ucast_pkts': '512300407'}],
                                                              'mac_address': '68:d7:9a:1f:4c:27',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '1457',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2743261877',
                                                              'out_ucast_pkts': '2640383867',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'frequency': 69120,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '422621',
                                                                                                                                            'distance': 1330,
                                                                                                                                            'mac_address': 'f4:92:bf:de:fe:81',
                                                                                                                                            'noise_floor': -69.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '1078000000',
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '1078000000',
                                                                                                                                            'tx_mcs': 10},
                                                                                                                                    {       'connected_time': '3092821',
                                                                                                                                            'distance': 1602,
                                                                                                                                            'mac_address': 'f4:92:bf:32:b4:07',
                                                                                                                                            'noise_floor': -75.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '1078000000',
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '1078000000',
                                                                                                                                            'tx_mcs': 10},
                                                                                                                                    {       'connected_time': '1169711',
                                                                                                                                            'distance': 843,
                                                                                                                                            'mac_address': '24:5a:4c:3e:e1:0f',
                                                                                                                                            'noise_floor': -78.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 18.0,
                                                                                                                                            'tx_link_rate': '875875000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '2507425',
                                                                                                                                            'distance': 894,
                                                                                                                                            'mac_address': '24:5a:4c:3e:ec:17',
                                                                                                                                            'noise_floor': -75.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 17.0,
                                                                                                                                            'tx_link_rate': '875875000',
                                                                                                                                            'tx_mcs': 9}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'xb7-pflum-wave-1'}],
                                                              'speed': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1157409566',
                                                              'in_ucast_pkts': '2542700147',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '68:d7:9a:1f:4c:28',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '2471415785',
                                                              'out_ucast_pkts': '1100108857',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 40.260311,
                                'longitude': -105.416527,
                                'manufacturer': 'Ubiquiti',
                                'model': 'Wave AP',
                                'sw_version': 'v3.0.2-beta2',
                                'system_mac_address': '68:d7:9a:1f:4c:27',
                                'uptime': '7501889'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '362285387',
                                                                       'in_ucast_pkts': '3221640',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '362285387',
                                                                                                'in_ucast_pkts': '3221640',
                                                                                                'mac_address': '68:d7:9a:1f:4c:27',
                                                                                                'out_nucast_pkts': '8573',
                                                                                                'out_octets': '359082156',
                                                                                                'out_ucast_pkts': '948114'}],
                                                                       'mac_address': 'f4:92:bf:de:fe:81',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '8573',
                                                                       'out_octets': '359082156',
                                                                       'out_ucast_pkts': '948114',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '422621',
                                                                                                                                                     'distance': 1330,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4c:27',
                                                                                                                                                     'noise_floor': -69.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '1078000000',
                                                                                                                                                     'rx_mcs': 10,
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '1078000000',
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'xb7-pflum-wave-1'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': 'f4:92:bf:df:fe:81',
                                                                       'name': 'eth0'}],
                                         'management_ip': '192.168.16.25',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f4:92:bf:de:fe:81'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '364515607941',
                                                                       'in_ucast_pkts': '299671932',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '364515607941',
                                                                                                'in_ucast_pkts': '299671932',
                                                                                                'mac_address': '68:d7:9a:1f:4c:27',
                                                                                                'out_nucast_pkts': '12387',
                                                                                                'out_octets': '47263257188',
                                                                                                'out_ucast_pkts': '106288828'}],
                                                                       'mac_address': 'f4:92:bf:32:b4:07',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '12387',
                                                                       'out_octets': '47263257188',
                                                                       'out_ucast_pkts': '106288828',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3092821',
                                                                                                                                                     'distance': 1602,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4c:27',
                                                                                                                                                     'noise_floor': -78.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '1078000000',
                                                                                                                                                     'rx_mcs': 10,
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '1078000000',
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'xb7-pflum-wave-1'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': 'f4:92:bf:33:b4:07',
                                                                       'name': 'eth0'}],
                                         'management_ip': '192.168.16.22',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f4:92:bf:32:b4:07'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '55734989702',
                                                                       'in_ucast_pkts': '48305225',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '55734989702',
                                                                                                'in_ucast_pkts': '48305225',
                                                                                                'mac_address': '68:d7:9a:1f:4c:27',
                                                                                                'out_nucast_pkts': '15941',
                                                                                                'out_octets': '4310902779',
                                                                                                'out_ucast_pkts': '15544449'}],
                                                                       'mac_address': '24:5a:4c:3e:e1:0f',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '15941',
                                                                       'out_octets': '4310902779',
                                                                       'out_ucast_pkts': '15544449',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1169711',
                                                                                                                                                     'distance': 843,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4c:27',
                                                                                                                                                     'noise_floor': -79.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '875875000',
                                                                                                                                                     'tx_mcs': 9}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'xb7-pflum-wave-1'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:3f:e1:0f',
                                                                       'name': 'eth0'}],
                                         'management_ip': '192.168.16.33',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:5a:4c:3e:e1:0f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '637520368022',
                                                                       'in_ucast_pkts': '512300407',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '637520368022',
                                                                                                'in_ucast_pkts': '512300407',
                                                                                                'mac_address': '68:d7:9a:1f:4c:27',
                                                                                                'out_nucast_pkts': '97950',
                                                                                                'out_octets': '48148706040',
                                                                                                'out_ucast_pkts': '252183369'}],
                                                                       'mac_address': '24:5a:4c:3e:ec:17',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '97950',
                                                                       'out_octets': '48148706040',
                                                                       'out_ucast_pkts': '252183369',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 69120,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2507425',
                                                                                                                                                     'distance': 894,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4c:27',
                                                                                                                                                     'noise_floor': -75.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 17.0,
                                                                                                                                                     'tx_link_rate': '875875000',
                                                                                                                                                     'tx_mcs': 9}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'xb7-pflum-wave-1'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:3f:ec:17',
                                                                       'name': 'eth0'}],
                                         'management_ip': '192.168.16.27',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:5a:4c:3e:ec:17'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_WaveAP_v3_0_2_beta2_02(self):
        obj = self.run_data("ubnt.wave-ap.WaveAP.v3.0.2-beta2.02")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 2160,
                'rf_freq': 68040,
                'rf_tx_power': 0,
                'sta_count': 3,
                'sta_mode_cpe': False,
                'sw_version': 'v3.0.2-beta2',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 1.995013,
                'dl_en_bytes': 1590422589259,
                'dl_en_packets': 2456254371,
                'dl_noise_floor': None,
                'dl_rf_bytes': 2078263735016,
                'dl_rf_packets': 14156931,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 273575410951,
                'ul_en_packets': 969585936,
                'ul_noise_floor': None,
                'ul_rf_bytes': 675117493039,
                'ul_rf_packets': 4973855
        }
        exp_sta_stats = {
                '24:5a:4c:ce:62:6d': {       'alt_macs': ['24:5a:4c:cf:62:6d'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1751750000,
                                             'dl_noise_floor': -59.0,
                                             'dl_rf_bytes': 117252125,
                                             'dl_rf_packets': 1657590,
                                             'dl_rssi': -40.0,
                                             'dl_snr': 19.0,
                                             'ip_address': '10.1.0.251',
                                             'mac_address': '24:5a:4c:ce:62:6d',
                                             'name': 'CVI - 2165',
                                             'ul_link_rate': 1751750000,
                                             'ul_noise_floor': -57.0,
                                             'ul_rf_bytes': 15381911,
                                             'ul_rf_packets': 36940,
                                             'ul_rssi': -37,
                                             'ul_snr': 20},
                '24:5a:4c:de:c5:92': {       'alt_macs': ['24:5a:4c:df:c5:92'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1751750000,
                                             'dl_noise_floor': -58.0,
                                             'dl_rf_bytes': 388134071,
                                             'dl_rf_packets': 2639174,
                                             'dl_rssi': -39.0,
                                             'dl_snr': 19.0,
                                             'ip_address': '10.1.1.21',
                                             'mac_address': '24:5a:4c:de:c5:92',
                                             'name': 'Helena Agri Enterprises - 2078',
                                             'ul_link_rate': 1751750000,
                                             'ul_noise_floor': -59.0,
                                             'ul_rf_bytes': 356008162,
                                             'ul_rf_packets': 1145087,
                                             'ul_rssi': -39,
                                             'ul_snr': 20},
                '24:5a:4c:de:c6:20': {       'alt_macs': ['24:5a:4c:df:c6:20'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1751750000,
                                             'dl_noise_floor': -62.0,
                                             'dl_rf_bytes': 11851633337,
                                             'dl_rf_packets': 9832260,
                                             'dl_rssi': -42.0,
                                             'dl_snr': 20.0,
                                             'ip_address': '10.1.0.225',
                                             'mac_address': '24:5a:4c:de:c6:20',
                                             'name': 'Webber LLC - 2402',
                                             'ul_link_rate': 1751750000,
                                             'ul_noise_floor': -64.0,
                                             'ul_rf_bytes': 436234605,
                                             'ul_rf_packets': 3791813,
                                             'ul_rssi': -44,
                                             'ul_snr': 20}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.995013,
                                'elevation': 1021.8,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '1590422589259',
                                                              'in_ucast_pkts': '2456254371',
                                                              'mac_address': '68:d7:9a:1f:4c:2b',
                                                              'mtu': 1560,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '273575410951',
                                                              'out_ucast_pkts': '969585936',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '675117493039',
                                                              'in_ucast_pkts': '4973855',
                                                              'links': [       {       'in_octets': '436234605',
                                                                                       'in_ucast_pkts': '3791813',
                                                                                       'mac_address': '24:5a:4c:de:c6:20',
                                                                                       'out_octets': '11851633337',
                                                                                       'out_ucast_pkts': '9832260'},
                                                                               {       'in_octets': '15381911',
                                                                                       'in_ucast_pkts': '36940',
                                                                                       'mac_address': '24:5a:4c:ce:62:6d',
                                                                                       'out_octets': '117252125',
                                                                                       'out_ucast_pkts': '1657590'},
                                                                               {       'in_octets': '356008162',
                                                                                       'in_ucast_pkts': '1145087',
                                                                                       'mac_address': '24:5a:4c:de:c5:92',
                                                                                       'out_octets': '388134071',
                                                                                       'out_ucast_pkts': '2639174'}],
                                                              'mac_address': '68:d7:9a:1f:4c:2a',
                                                              'mtu': 1560,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '1',
                                                              'out_errors': '0',
                                                              'out_octets': '2078263735016',
                                                              'out_ucast_pkts': '14156931',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '1751750000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '24385',
                                                                                                                                            'distance': 463,
                                                                                                                                            'mac_address': '24:5a:4c:de:c6:20',
                                                                                                                                            'noise_floor': -64.0,
                                                                                                                                            'rssi': -44.0,
                                                                                                                                            'rx_link_rate': '1751750000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '1751750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '24385',
                                                                                                                                            'distance': 485,
                                                                                                                                            'mac_address': '24:5a:4c:ce:62:6d',
                                                                                                                                            'noise_floor': -57.0,
                                                                                                                                            'rssi': -37.0,
                                                                                                                                            'rx_link_rate': '1751750000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '1751750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '24385',
                                                                                                                                            'distance': 379,
                                                                                                                                            'mac_address': '24:5a:4c:de:c5:92',
                                                                                                                                            'noise_floor': -59.0,
                                                                                                                                            'rssi': -39.0,
                                                                                                                                            'rx_link_rate': '1751750000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '1751750000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_link_rate': '1751750000',
                                                                                        'tx_power': 0}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Lonestar.60NNE'}],
                                                              'speed': '0'}],
                                'latitude': 32.734408,
                                'longitude': -102.642659,
                                'manufacturer': 'Ubiquiti',
                                'mem': 39.40824,
                                'model': 'Wave AP',
                                'sw_version': 'v3.0.2-beta2',
                                'system_mac_address': '68:d7:9a:1f:4c:2a',
                                'temperature': 31.0,
                                'uptime': '11307072'},
                'peers': [       {       'cpu': 1.5,
                                         'elevation': 1014.1,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '11851633337',
                                                                       'in_ucast_pkts': '9832260',
                                                                       'links': [       {       'in_octets': '11851633337',
                                                                                                'in_ucast_pkts': '9832260',
                                                                                                'mac_address': '68:d7:9a:1f:4c:2a',
                                                                                                'out_octets': '436234605',
                                                                                                'out_ucast_pkts': '3791813'}],
                                                                       'mac_address': '24:5a:4c:de:c6:20',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '436234605',
                                                                       'out_ucast_pkts': '3791813',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 68040,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1751750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '24385',
                                                                                                                                                     'distance': 463,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4c:2a',
                                                                                                                                                     'noise_floor': -62.0,
                                                                                                                                                     'rssi': -42.0,
                                                                                                                                                     'rx_link_rate': '1751750000',
                                                                                                                                                     'snr': 20.0,
                                                                                                                                                     'tx_link_rate': '1751750000'}],
                                                                                                                            'noise_floor': -62.0}],
                                                                                                 'tx_link_rate': '1751750000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Lonestar.60NNE'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:df:c6:20',
                                                                       'name': 'eth0'}],
                                         'latitude': 32.737716,
                                         'longitude': -102.639581,
                                         'management_ip': '10.1.0.225',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 35.2771,
                                         'model': 'airFiber 60 LR',
                                         'name': 'Webber LLC - 2402',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v3.0.2-beta2',
                                         'system_mac_address': '24:5a:4c:de:c6:20',
                                         'temperature': 36.0,
                                         'uptime': '10298515'},
                                 {       'cpu': 0.4975,
                                         'elevation': 1017.4,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '117252125',
                                                                       'in_ucast_pkts': '1657590',
                                                                       'links': [       {       'in_octets': '117252125',
                                                                                                'in_ucast_pkts': '1657590',
                                                                                                'mac_address': '68:d7:9a:1f:4c:2a',
                                                                                                'out_octets': '15381911',
                                                                                                'out_ucast_pkts': '36940'}],
                                                                       'mac_address': '24:5a:4c:ce:62:6d',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '15381911',
                                                                       'out_ucast_pkts': '36940',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 68040,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1751750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '24385',
                                                                                                                                                     'distance': 485,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4c:2a',
                                                                                                                                                     'noise_floor': -59.0,
                                                                                                                                                     'rssi': -40.0,
                                                                                                                                                     'rx_link_rate': '1751750000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '1751750000'}],
                                                                                                                            'noise_floor': -59.0}],
                                                                                                 'tx_link_rate': '1751750000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Lonestar.60NNE'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:cf:62:6d',
                                                                       'name': 'eth0'}],
                                         'latitude': 32.738596,
                                         'longitude': -102.641247,
                                         'management_ip': '10.1.0.251',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 35.312626,
                                         'model': 'airFiber 60 LR',
                                         'name': 'CVI - 2165',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v3.0.2-beta2',
                                         'system_mac_address': '24:5a:4c:ce:62:6d',
                                         'temperature': 26.0,
                                         'uptime': '11340699'},
                                 {       'cpu': 0.0,
                                         'elevation': 1016.2,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '388134071',
                                                                       'in_ucast_pkts': '2639174',
                                                                       'links': [       {       'in_octets': '388134071',
                                                                                                'in_ucast_pkts': '2639174',
                                                                                                'mac_address': '68:d7:9a:1f:4c:2a',
                                                                                                'out_octets': '356008162',
                                                                                                'out_ucast_pkts': '1145087'}],
                                                                       'mac_address': '24:5a:4c:de:c5:92',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '356008162',
                                                                       'out_ucast_pkts': '1145087',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 68040,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1751750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '24385',
                                                                                                                                                     'distance': 379,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4c:2a',
                                                                                                                                                     'noise_floor': -58.0,
                                                                                                                                                     'rssi': -39.0,
                                                                                                                                                     'rx_link_rate': '1751750000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '1751750000'}],
                                                                                                                            'noise_floor': -58.0}],
                                                                                                 'tx_link_rate': '1751750000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Lonestar.60NNE'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:df:c5:92',
                                                                       'name': 'eth0'}],
                                         'latitude': 32.737673,
                                         'longitude': -102.641542,
                                         'management_ip': '10.1.1.21',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.785896,
                                         'model': 'airFiber 60 LR',
                                         'name': 'Helena Agri Enterprises - 2078',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v3.0.2-beta2',
                                         'system_mac_address': '24:5a:4c:de:c5:92',
                                         'temperature': 31.0,
                                         'uptime': '12800814'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_WaveAP_v3_0_2_beta5_01(self):
        obj = self.run_data("ubnt.wave-ap.WaveAP.v3.0.2-beta5.01")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 68040,
                'rf_tx_power': None,
                'sta_count': 2,
                'sta_mode_cpe': False,
                'sw_version': 'v3.0.2-beta5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 3705248327,
                'dl_en_packets': 2878013694,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3649616446,
                'dl_rf_packets': 2957731342,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 3325502488,
                'ul_en_packets': 1547448968,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1351703895,
                'ul_rf_packets': 1546311314
        }
        exp_sta_stats = {
                '24:5a:4c:44:7f:e5': {       'alt_macs': ['24:5a:4c:45:7f:e5'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': -69.0,
                                             'dl_rf_bytes': 28675040329,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -51,
                                             'dl_snr': 18,
                                             'ip_address': '192.168.3.44',
                                             'mac_address': '24:5a:4c:44:7f:e5',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': -68.0,
                                             'ul_rf_bytes': 4033526651,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 19.0},
                'f4:92:bf:ee:95:7c': {       'alt_macs': ['f4:92:bf:ef:95:7c'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': -80.0,
                                             'dl_rf_bytes': 29500875020,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -64,
                                             'dl_snr': 16,
                                             'ip_address': '192.168.3.42',
                                             'mac_address': 'f4:92:bf:ee:95:7c',
                                             'name': 'airFiber 60 LR',
                                             'ul_link_rate': 808500000,
                                             'ul_noise_floor': -77.0,
                                             'ul_rf_bytes': 2247113468,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 17.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'elevation': 1992.3,
                                'errors': [{'http_auth': {}}],
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '288370',
                                                              'in_octets': '1351703895',
                                                              'in_ucast_pkts': '1546022944',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_nucast_pkts': '653',
                                                                                       'in_octets': '2247113468',
                                                                                       'in_ucast_pkts': '10535794',
                                                                                       'mac_address': 'f4:92:bf:ee:95:7c',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '29500875020',
                                                                                       'out_ucast_pkts': '24610975'},
                                                                               {       'in_nucast_pkts': '5705',
                                                                                       'in_octets': '4033526651',
                                                                                       'in_ucast_pkts': '15774545',
                                                                                       'mac_address': '24:5a:4c:44:7f:e5',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '28675040329',
                                                                                       'out_ucast_pkts': '26001298'}],
                                                              'mac_address': '68:d7:9a:1f:4c:b1',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '2081',
                                                              'out_errors': '1209',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3649616446',
                                                              'out_ucast_pkts': '2957731342',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'frequency': 68040,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '178210',
                                                                                                                                            'distance': 1490,
                                                                                                                                            'mac_address': 'f4:92:bf:ee:95:7c',
                                                                                                                                            'noise_floor': -77.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '808500000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 17.0,
                                                                                                                                            'tx_link_rate': '875875000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '154193',
                                                                                                                                            'distance': 1614,
                                                                                                                                            'mac_address': '24:5a:4c:44:7f:e5',
                                                                                                                                            'noise_floor': -68.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'rx_mcs': 10,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '1000000000',
                                                                                                                                            'tx_mcs': 10}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'xb7-kiowa-w-south'}],
                                                              'speed': '0',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '1',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3705248327',
                                                              'in_ucast_pkts': '2878013694',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '68:d7:9a:1f:4c:b2',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3325502488',
                                                              'out_ucast_pkts': '1547448968',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 40.290686,
                                'longitude': -105.343762,
                                'manufacturer': 'Ubiquiti',
                                'model': 'Wave AP',
                                'sw_version': 'v3.0.2-beta5',
                                'system_mac_address': '68:d7:9a:1f:4c:b1',
                                'uptime': '12942391'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '29500875020',
                                                                       'in_ucast_pkts': '24610975',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '29500875020',
                                                                                                'in_ucast_pkts': '24610975',
                                                                                                'mac_address': '68:d7:9a:1f:4c:b1',
                                                                                                'out_nucast_pkts': '653',
                                                                                                'out_octets': '2247113468',
                                                                                                'out_ucast_pkts': '10535794'}],
                                                                       'mac_address': 'f4:92:bf:ee:95:7c',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '653',
                                                                       'out_octets': '2247113468',
                                                                       'out_ucast_pkts': '10535794',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 68040,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '178210',
                                                                                                                                                     'distance': 1490,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4c:b1',
                                                                                                                                                     'noise_floor': -80.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 16.0,
                                                                                                                                                     'tx_link_rate': '808500000',
                                                                                                                                                     'tx_mcs': 9}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'xb7-kiowa-w-south'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': 'f4:92:bf:ef:95:7c',
                                                                       'name': 'eth0'}],
                                         'management_ip': '192.168.3.42',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'f4:92:bf:ee:95:7c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '28675040329',
                                                                       'in_ucast_pkts': '26001298',
                                                                       'links': [       {       'in_nucast_pkts': '0',
                                                                                                'in_octets': '28675040329',
                                                                                                'in_ucast_pkts': '26001298',
                                                                                                'mac_address': '68:d7:9a:1f:4c:b1',
                                                                                                'out_nucast_pkts': '5705',
                                                                                                'out_octets': '4033526651',
                                                                                                'out_ucast_pkts': '15774545'}],
                                                                       'mac_address': '24:5a:4c:44:7f:e5',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_nucast_pkts': '5705',
                                                                       'out_octets': '4033526651',
                                                                       'out_ucast_pkts': '15774545',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 68040,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '154193',
                                                                                                                                                     'distance': 1614,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4c:b1',
                                                                                                                                                     'noise_floor': -69.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'rx_mcs': 10,
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '1000000000',
                                                                                                                                                     'tx_mcs': 10}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'xb7-kiowa-w-south'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:45:7f:e5',
                                                                       'name': 'eth0'}],
                                         'management_ip': '192.168.3.44',
                                         'manufacturer': 'Ubiquiti',
                                         'model': 'AF60-LR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '24:5a:4c:44:7f:e5'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_WaveAP_v3_0_2_beta5_02(self):
        obj = self.run_data("ubnt.wave-ap.WaveAP.v3.0.2-beta5.02")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 2160,
                'rf_freq': 68040,
                'rf_tx_power': 0,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v3.0.2-beta5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': 1.243781,
                'dl_en_bytes': 1741345723749,
                'dl_en_packets': 3052914524,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1745581100666,
                'dl_rf_packets': 843729754,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': 12,
                'ul_en_bytes': 1296636305888,
                'ul_en_packets': 1676121286,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1301627518028,
                'ul_rf_packets': 508122640
        }
        exp_sta_stats = {
                '24:5a:4c:3e:e1:8a': {       'alt_macs': ['24:5a:4c:3f:e1:8a'],
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': -70.0,
                                             'dl_rf_bytes': 571654674271,
                                             'dl_rf_packets': 842305804,
                                             'dl_rssi': -51.0,
                                             'dl_snr': 19.0,
                                             'ip_address': '10.22.0.28',
                                             'mac_address': '24:5a:4c:3e:e1:8a',
                                             'name': 'C and C Irrigation',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': -68.0,
                                             'ul_rf_bytes': 369619615099,
                                             'ul_rf_packets': 508122640,
                                             'ul_rssi': -49,
                                             'ul_snr': 19}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.243781,
                                'elevation': 1038.1,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '1951616',
                                                              'in_errors': '0',
                                                              'in_octets': '1741345723749',
                                                              'in_ucast_pkts': '3052914524',
                                                              'mac_address': '68:d7:9a:1f:4e:26',
                                                              'mtu': 1560,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '1296636305888',
                                                              'out_ucast_pkts': '1676121286',
                                                              'speed': '1000000000'},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '1301627518028',
                                                              'in_ucast_pkts': '508122640',
                                                              'links': [       {       'in_octets': '369619615099',
                                                                                       'in_ucast_pkts': '508122640',
                                                                                       'mac_address': '24:5a:4c:3e:e1:8a',
                                                                                       'out_octets': '571654674271',
                                                                                       'out_ucast_pkts': '842305804'}],
                                                              'mac_address': '68:d7:9a:1f:4e:25',
                                                              'mtu': 1560,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '1745581100666',
                                                              'out_ucast_pkts': '843729754',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'id': '1',
                                                                                        'rx_link_rate': '1000000000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '3661796',
                                                                                                                                            'distance': 1055,
                                                                                                                                            'mac_address': '24:5a:4c:3e:e1:8a',
                                                                                                                                            'noise_floor': -68.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 19.0,
                                                                                                                                            'tx_link_rate': '1000000000',
                                                                                                                                            'tx_mcs': 9}]}],
                                                                                        'tx_link_rate': '1000000000',
                                                                                        'tx_power': 0}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Tx22.60NE'}],
                                                              'speed': '0'}],
                                'latitude': 32.719082,
                                'longitude': -102.717187,
                                'manufacturer': 'Ubiquiti',
                                'mem': 39.24753,
                                'model': 'Wave AP',
                                'sw_version': 'v3.0.2-beta5',
                                'system_mac_address': '68:d7:9a:1f:4e:25',
                                'temperature': 27.0,
                                'uptime': '14636617'},
                'peers': [       {       'cpu': 0.2481,
                                         'elevation': 1028.0,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': 'wlan0',
                                                                       'in_octets': '571654674271',
                                                                       'in_ucast_pkts': '842305804',
                                                                       'links': [       {       'in_octets': '571654674271',
                                                                                                'in_ucast_pkts': '842305804',
                                                                                                'mac_address': '68:d7:9a:1f:4e:25',
                                                                                                'out_octets': '369619615099',
                                                                                                'out_ucast_pkts': '508122640'}],
                                                                       'mac_address': '24:5a:4c:3e:e1:8a',
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '369619615099',
                                                                       'out_ucast_pkts': '508122640',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 68040,
                                                                                                 'gps_sync': True,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '1000000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3661796',
                                                                                                                                                     'distance': 1055,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:4e:25',
                                                                                                                                                     'noise_floor': -70.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'snr': 19.0,
                                                                                                                                                     'tx_link_rate': '1000000000'}],
                                                                                                                            'noise_floor': -70.0}],
                                                                                                 'tx_link_rate': '1000000000',
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx22.60NE'}]},
                                                               {       'id': 'eth0',
                                                                       'mac_address': '24:5a:4c:3f:e1:8a',
                                                                       'name': 'eth0'}],
                                         'latitude': 32.726079,
                                         'longitude': -102.709698,
                                         'management_ip': '10.22.0.28',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 35.57484,
                                         'model': 'airFiber 60 LR',
                                         'name': 'C and C Irrigation',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'v3.0.2-beta2',
                                         'system_mac_address': '24:5a:4c:3e:e1:8a',
                                         'temperature': 27.0,
                                         'uptime': '11303324'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_1_1_01(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.1.1.01")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 2160,
                'rf_freq': 68040,
                'rf_tx_power': 21,
                'sta_count': 4,
                'sta_mode_cpe': False,
                'sw_version': 'v3.1.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 4263296599058,
                'dl_en_packets': 3107002387,
                'dl_noise_floor': None,
                'dl_rf_bytes': 4354336461752,
                'dl_rf_packets': 3303503797,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 210684441420,
                'ul_en_packets': 1183981338,
                'ul_noise_floor': None,
                'ul_rf_bytes': 217579350748,
                'ul_rf_packets': 1198740700
        }
        exp_sta_stats = {
                '60:22:32:6f:9a:f5': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1532830419774,
                                             'dl_rf_packets': 1155724994,
                                             'dl_rssi': -50.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.182',
                                             'mac_address': '60:22:32:6f:9a:f5',
                                             'name': 'T3-W1-E.Hererra',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 86022596292,
                                             'ul_rf_packets': 569768422,
                                             'ul_rssi': -50.0,
                                             'ul_snr': None},
                '60:22:32:6f:9e:15': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 332697745957,
                                             'dl_rf_packets': 255414523,
                                             'dl_rssi': -62.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.143',
                                             'mac_address': '60:22:32:6f:9e:15',
                                             'name': 'T3-W1-M.Calderon',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 25441036202,
                                             'ul_rf_packets': 103519147,
                                             'ul_rssi': -61.0,
                                             'ul_snr': None},
                '60:22:32:6f:ac:d1': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1590793637332,
                                             'dl_rf_packets': 1144353640,
                                             'dl_rssi': -60.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.60',
                                             'mac_address': '60:22:32:6f:ac:d1',
                                             'name': 'T3-W1-S.Meyers2.0',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 29812533168,
                                             'ul_rf_packets': 231657274,
                                             'ul_rssi': -58.0,
                                             'ul_snr': None},
                '60:22:32:6f:ad:c5': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 827197793068,
                                             'dl_rf_packets': 672851278,
                                             'dl_rssi': -56.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.61',
                                             'mac_address': '60:22:32:6f:ad:c5',
                                             'name': 'T3-W1-K.Lalli',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 89388422685,
                                             'ul_rf_packets': 274642235,
                                             'ul_rssi': -54.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 16.0,
                                'elevation': 1034.5,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NzBhNzQxY2RkYWFmZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '4263296599058',
                                                              'in_ucast_pkts': '3107002387',
                                                              'mac_address': '70:a7:41:cd:da:af',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '210684441420',
                                                              'out_ucast_pkts': '1183981338',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_octets': '8448',
                                                              'in_ucast_pkts': '239',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '9330786725',
                                                              'out_ucast_pkts': '89198736',
                                                              'poller_hash': 'NzBhNzQxY2RkYWFlYXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '217579342300',
                                                              'in_ucast_pkts': '1198740461',
                                                              'links': [       {       'in_octets': '29812533168',
                                                                                       'in_ucast_pkts': '231657274',
                                                                                       'mac_address': '60:22:32:6f:ac:d1',
                                                                                       'out_octets': '1590793637332',
                                                                                       'out_ucast_pkts': '1144353640'},
                                                                               {       'in_octets': '25441036202',
                                                                                       'in_ucast_pkts': '103519147',
                                                                                       'mac_address': '60:22:32:6f:9e:15',
                                                                                       'out_octets': '332697745957',
                                                                                       'out_ucast_pkts': '255414523'},
                                                                               {       'in_octets': '86022596292',
                                                                                       'in_ucast_pkts': '569768422',
                                                                                       'mac_address': '60:22:32:6f:9a:f5',
                                                                                       'out_octets': '1532830419774',
                                                                                       'out_ucast_pkts': '1155724994'},
                                                                               {       'in_octets': '89388422685',
                                                                                       'in_ucast_pkts': '274642235',
                                                                                       'mac_address': '60:22:32:6f:ad:c5',
                                                                                       'out_octets': '827197793068',
                                                                                       'out_ucast_pkts': '672851278'}],
                                                              'mac_address': '70:a7:41:cd:da:ae',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '4345005675027',
                                                              'out_ucast_pkts': '3214305061',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'rx_link_rate': '2700000000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '2432492',
                                                                                                                                            'distance': 2782,
                                                                                                                                            'mac_address': '60:22:32:6f:ac:d1',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '1132083',
                                                                                                                                            'distance': 3008,
                                                                                                                                            'mac_address': '60:22:32:6f:9e:15',
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '2424721',
                                                                                                                                            'distance': 1110,
                                                                                                                                            'mac_address': '60:22:32:6f:9a:f5',
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '2432487',
                                                                                                                                            'distance': 2788,
                                                                                                                                            'mac_address': '60:22:32:6f:ad:c5',
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '2700000000',
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RW-T3-W1'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.054608,
                                'longitude': -110.678332,
                                'manufacturer': 'Ubiquiti',
                                'mem': 40.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.1.1',
                                'system_mac_address': '70:a7:41:cd:da:ae',
                                'temperature': 41.0,
                                'uptime': '2432705'},
                'peers': [       {       'cpu': 17.0,
                                         'elevation': 1003.1,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '23629020267',
                                                                       'in_ucast_pkts': '229876481',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1585634692645',
                                                                       'out_ucast_pkts': '1138246825',
                                                                       'poller_hash': 'NjAyMjMyNmZhY2QxZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '3626095342',
                                                                       'in_ucast_pkts': '34714873',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '12692',
                                                                       'out_ucast_pkts': '103',
                                                                       'poller_hash': 'NjAyMjMyNmZhY2QxYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '1590793637332',
                                                                       'in_ucast_pkts': '1144353640',
                                                                       'links': [       {       'in_octets': '1590793637332',
                                                                                                'in_ucast_pkts': '1144353640',
                                                                                                'mac_address': '70:a7:41:cd:da:ae',
                                                                                                'out_octets': '29812533168',
                                                                                                'out_ucast_pkts': '231657274'}],
                                                                       'mac_address': '60:22:32:6f:ac:d1',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '29812533168',
                                                                       'out_ucast_pkts': '231657274',
                                                                       'poller_hash': 'NjAyMjMyNmZhY2Qxd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2432492',
                                                                                                                                                     'distance': 2782,
                                                                                                                                                     'mac_address': '70:a7:41:cd:da:ae',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW-T3-W1'}],
                                                                       'type': 71}],
                                         'latitude': 32.038468,
                                         'longitude': -110.700979,
                                         'management_ip': '10.3.12.60',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-LR',
                                         'name': 'T3-W1-S.Meyers2.0',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:ac:d1',
                                         'uptime': '2432743'},
                                 {       'cpu': 17.0,
                                         'elevation': 1003.7,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '23219583881',
                                                                       'in_ucast_pkts': '102637092',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '323673215335',
                                                                       'out_ucast_pkts': '248247989',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTE1ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '736406996',
                                                                       'in_ucast_pkts': '7413215',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '6126',
                                                                       'out_ucast_pkts': '49',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTE1YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '332697745957',
                                                                       'in_ucast_pkts': '255414523',
                                                                       'links': [       {       'in_octets': '332697745957',
                                                                                                'in_ucast_pkts': '255414523',
                                                                                                'mac_address': '70:a7:41:cd:da:ae',
                                                                                                'out_octets': '25441036202',
                                                                                                'out_ucast_pkts': '103519147'}],
                                                                       'mac_address': '60:22:32:6f:9e:15',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '25441036202',
                                                                       'out_ucast_pkts': '103519147',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTE1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1132083',
                                                                                                                                                     'distance': 3008,
                                                                                                                                                     'mac_address': '70:a7:41:cd:da:ae',
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW-T3-W1'}],
                                                                       'type': 71}],
                                         'latitude': 32.036046,
                                         'longitude': -110.701578,
                                         'management_ip': '10.3.12.143',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'T3-W1-M.Calderon',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:9e:15',
                                         'uptime': '1132188'},
                                 {       'cpu': 17.0,
                                         'elevation': 1012.2,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '70598560816',
                                                                       'in_ucast_pkts': '567855453',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1527663991011',
                                                                       'out_ucast_pkts': '1149592507',
                                                                       'poller_hash': 'NjAyMjMyNmY5YWY1ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '4620620674',
                                                                       'in_ucast_pkts': '44156714',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '4640',
                                                                       'out_ucast_pkts': '31',
                                                                       'poller_hash': 'NjAyMjMyNmY5YWY1YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '1532830419774',
                                                                       'in_ucast_pkts': '1155724994',
                                                                       'links': [       {       'in_octets': '1532830419774',
                                                                                                'in_ucast_pkts': '1155724994',
                                                                                                'mac_address': '70:a7:41:cd:da:ae',
                                                                                                'out_octets': '86022596292',
                                                                                                'out_ucast_pkts': '569768422'}],
                                                                       'mac_address': '60:22:32:6f:9a:f5',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '86022596292',
                                                                       'out_ucast_pkts': '569768422',
                                                                       'poller_hash': 'NjAyMjMyNmY5YWY1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2424721',
                                                                                                                                                     'distance': 1110,
                                                                                                                                                     'mac_address': '70:a7:41:cd:da:ae',
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW-T3-W1'}],
                                                                       'type': 71}],
                                         'latitude': 32.048673,
                                         'longitude': -110.687823,
                                         'management_ip': '10.3.12.182',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'T3-W1-E.Hererra',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:9a:f5',
                                         'uptime': '2424911'},
                                 {       'cpu': 20.0,
                                         'elevation': 996.2,
                                         'errors': [{'http_connect': {}}],
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '81814663794',
                                                                       'in_ucast_pkts': '272786665',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '822035979195',
                                                                       'out_ucast_pkts': '666695453',
                                                                       'poller_hash': 'NjAyMjMyNmZhZGM1ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '4635409868',
                                                                       'in_ucast_pkts': '44329340',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '4640',
                                                                       'out_ucast_pkts': '31',
                                                                       'poller_hash': 'NjAyMjMyNmZhZGM1YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '827197793068',
                                                                       'in_ucast_pkts': '672851278',
                                                                       'links': [       {       'in_octets': '827197793068',
                                                                                                'in_ucast_pkts': '672851278',
                                                                                                'mac_address': '70:a7:41:cd:da:ae',
                                                                                                'out_octets': '89388422685',
                                                                                                'out_ucast_pkts': '274642235'}],
                                                                       'mac_address': '60:22:32:6f:ad:c5',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '89388422685',
                                                                       'out_ucast_pkts': '274642235',
                                                                       'poller_hash': 'NjAyMjMyNmZhZGM1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2432487',
                                                                                                                                                     'distance': 2788,
                                                                                                                                                     'mac_address': '70:a7:41:cd:da:ae',
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW-T3-W1'}],
                                                                       'type': 71}],
                                         'latitude': 32.042245,
                                         'longitude': -110.704053,
                                         'management_ip': '10.3.12.61',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-LR',
                                         'name': 'T3-W1-K.Lalli',
                                         'status': 'ELEMENT_STATUS_ERROR',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:ad:c5',
                                         'uptime': '2432742'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_1_1_02(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.1.1.02")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 2160,
                'rf_freq': 68040,
                'rf_tx_power': 21,
                'sta_count': 6,
                'sta_mode_cpe': False,
                'sw_version': 'v3.1.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 1032086045499,
                'dl_en_packets': 789357069,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1048297802843,
                'dl_rf_packets': 819308394,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 192539667992,
                'ul_en_packets': 349535682,
                'ul_noise_floor': None,
                'ul_rf_bytes': 199461305369,
                'ul_rf_packets': 359442947
        }
        exp_sta_stats = {
                '70:a7:41:b5:aa:31': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 389330730930,
                                             'dl_rf_packets': 464082871,
                                             'dl_rssi': -65.0,
                                             'dl_snr': None,
                                             'ip_address': '10.12.12.60',
                                             'mac_address': '70:a7:41:b5:aa:31',
                                             'name': 'T12-AP3W-C.Seed',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 851143629292,
                                             'ul_rf_packets': 831690526,
                                             'ul_rssi': -61.0,
                                             'ul_snr': None},
                'ac:8b:a9:3b:93:b5': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 33970568822,
                                             'dl_rf_packets': 25340053,
                                             'dl_rssi': -62.0,
                                             'dl_snr': None,
                                             'ip_address': '10.12.12.115',
                                             'mac_address': 'ac:8b:a9:3b:93:b5',
                                             'name': 'T12-N.Poppleton',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 1240677713,
                                             'ul_rf_packets': 9906834,
                                             'ul_rssi': -59.0,
                                             'ul_snr': None},
                'ac:8b:a9:43:50:ef': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 513437689149,
                                             'dl_rf_packets': 371424339,
                                             'dl_rssi': -67.0,
                                             'dl_snr': None,
                                             'ip_address': '10.12.12.72',
                                             'mac_address': 'ac:8b:a9:43:50:ef',
                                             'name': 'T12-W1-M.Lopez',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 17309576062,
                                             'ul_rf_packets': 70077131,
                                             'ul_rssi': -64.0,
                                             'ul_snr': None},
                'ac:8b:a9:43:54:7d': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 191944700041,
                                             'dl_rf_packets': 158021914,
                                             'dl_rssi': -63.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.126',
                                             'mac_address': 'ac:8b:a9:43:54:7d',
                                             'name': 'T12-W1-A.Greene',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 21089650785,
                                             'ul_rf_packets': 49106051,
                                             'ul_rssi': -59.0,
                                             'ul_snr': None},
                'ac:8b:a9:43:57:15': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 574981373240,
                                             'dl_rf_packets': 424057170,
                                             'dl_rssi': -64.0,
                                             'dl_snr': None,
                                             'ip_address': '10.12.12.66',
                                             'mac_address': 'ac:8b:a9:43:57:15',
                                             'name': 'M.Williams',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 33682675747,
                                             'ul_rf_packets': 159160711,
                                             'ul_rssi': -61.0,
                                             'ul_snr': None},
                'ac:8b:a9:43:5b:09': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 199258509047,
                                             'dl_rf_packets': 151995045,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.12.12.81',
                                             'mac_address': 'ac:8b:a9:43:5b:09',
                                             'name': 'T12-L.Cates',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 11004788848,
                                             'ul_rf_packets': 27840510,
                                             'ul_rssi': -58.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 23.0,
                                'elevation': 1047.4,
                                'gps_sats_tracked': 10,
                                'interfaces': [       {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NjAyMjMyMzU2MDk3ZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '1032086045499',
                                                              'in_ucast_pkts': '789357069',
                                                              'mac_address': '60:22:32:35:60:97',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '192539667992',
                                                              'out_ucast_pkts': '349535682',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_octets': '279696828',
                                                              'in_ucast_pkts': '540747',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '2493721554',
                                                              'out_ucast_pkts': '11013564',
                                                              'poller_hash': 'NjAyMjMyMzU2MDk2YXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '199181608541',
                                                              'in_ucast_pkts': '358902200',
                                                              'links': [       {       'in_octets': '21089650785',
                                                                                       'in_ucast_pkts': '49106051',
                                                                                       'mac_address': 'ac:8b:a9:43:54:7d',
                                                                                       'out_octets': '191944700041',
                                                                                       'out_ucast_pkts': '158021914'},
                                                                               {       'in_octets': '33682675747',
                                                                                       'in_ucast_pkts': '159160711',
                                                                                       'mac_address': 'ac:8b:a9:43:57:15',
                                                                                       'out_octets': '574981373240',
                                                                                       'out_ucast_pkts': '424057170'},
                                                                               {       'in_octets': '17309576062',
                                                                                       'in_ucast_pkts': '70077131',
                                                                                       'mac_address': 'ac:8b:a9:43:50:ef',
                                                                                       'out_octets': '513437689149',
                                                                                       'out_ucast_pkts': '371424339'},
                                                                               {       'in_octets': '1240677713',
                                                                                       'in_ucast_pkts': '9906834',
                                                                                       'mac_address': 'ac:8b:a9:3b:93:b5',
                                                                                       'out_octets': '33970568822',
                                                                                       'out_ucast_pkts': '25340053'},
                                                                               {       'in_octets': '11004788848',
                                                                                       'in_ucast_pkts': '27840510',
                                                                                       'mac_address': 'ac:8b:a9:43:5b:09',
                                                                                       'out_octets': '199258509047',
                                                                                       'out_ucast_pkts': '151995045'},
                                                                               {       'in_octets': '851143629292',
                                                                                       'in_ucast_pkts': '831690526',
                                                                                       'mac_address': '70:a7:41:b5:aa:31',
                                                                                       'out_octets': '389330730930',
                                                                                       'out_ucast_pkts': '464082871'}],
                                                              'mac_address': '60:22:32:35:60:96',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '1045804081289',
                                                              'out_ucast_pkts': '808294830',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'rx_link_rate': '2202200000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '174317',
                                                                                                                                            'distance': 4842,
                                                                                                                                            'mac_address': 'ac:8b:a9:43:54:7d',
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '174047',
                                                                                                                                            'distance': 4928,
                                                                                                                                            'mac_address': 'ac:8b:a9:43:57:15',
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '174068',
                                                                                                                                            'distance': 5612,
                                                                                                                                            'mac_address': 'ac:8b:a9:43:50:ef',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '174553',
                                                                                                                                            'distance': 3507,
                                                                                                                                            'mac_address': 'ac:8b:a9:3b:93:b5',
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '174557',
                                                                                                                                            'distance': 3463,
                                                                                                                                            'mac_address': 'ac:8b:a9:43:5b:09',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '174401',
                                                                                                                                            'distance': 3653,
                                                                                                                                            'mac_address': '70:a7:41:b5:aa:31',
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '2202200000',
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RW_T12_AP3_W1'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.014761,
                                'longitude': -110.698008,
                                'manufacturer': 'Ubiquiti',
                                'mem': 40.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.1.1',
                                'system_mac_address': '60:22:32:35:60:96',
                                'temperature': 31.0,
                                'uptime': '1048875'},
                'peers': [       {       'cpu': 18.0,
                                         'elevation': 1082.5,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '19596321998',
                                                                       'in_ucast_pkts': '48814342',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '190826880029',
                                                                       'out_ucast_pkts': '156970564',
                                                                       'poller_hash': 'YWM4YmE5NDM1NDdkZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '606951525',
                                                                       'in_ucast_pkts': '2912761',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '50300746',
                                                                       'out_ucast_pkts': '165119',
                                                                       'poller_hash': 'YWM4YmE5NDM1NDdkYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '191944700041',
                                                                       'in_ucast_pkts': '158021914',
                                                                       'links': [       {       'in_octets': '191944700041',
                                                                                                'in_ucast_pkts': '158021914',
                                                                                                'mac_address': '60:22:32:35:60:96',
                                                                                                'out_octets': '21089650785',
                                                                                                'out_ucast_pkts': '49106051'}],
                                                                       'mac_address': 'ac:8b:a9:43:54:7d',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21089650785',
                                                                       'out_ucast_pkts': '49106051',
                                                                       'poller_hash': 'YWM4YmE5NDM1NDdkd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174317',
                                                                                                                                                     'distance': 4842,
                                                                                                                                                     'mac_address': '60:22:32:35:60:96',
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP3_W1'}],
                                                                       'type': 71}],
                                         'latitude': 31.973028,
                                         'longitude': -110.712902,
                                         'management_ip': '10.3.12.126',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-LR',
                                         'name': 'T12-W1-A.Greene',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:43:54:7d',
                                         'uptime': '574998'},
                                 {       'cpu': 17.0,
                                         'elevation': 1067.5,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '29910160473',
                                                                       'in_ucast_pkts': '157689188',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '570118359486',
                                                                       'out_ucast_pkts': '418741012',
                                                                       'poller_hash': 'YWM4YmE5NDM1NzE1ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '1168260148',
                                                                       'in_ucast_pkts': '9617224',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '77859089',
                                                                       'out_ucast_pkts': '171482',
                                                                       'poller_hash': 'YWM4YmE5NDM1NzE1YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '574981373240',
                                                                       'in_ucast_pkts': '424057170',
                                                                       'links': [       {       'in_octets': '574981373240',
                                                                                                'in_ucast_pkts': '424057170',
                                                                                                'mac_address': '60:22:32:35:60:96',
                                                                                                'out_octets': '33682675747',
                                                                                                'out_ucast_pkts': '159160711'}],
                                                                       'mac_address': 'ac:8b:a9:43:57:15',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '33682675747',
                                                                       'out_ucast_pkts': '159160711',
                                                                       'poller_hash': 'YWM4YmE5NDM1NzE1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174047',
                                                                                                                                                     'distance': 4928,
                                                                                                                                                     'mac_address': '60:22:32:35:60:96',
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP3_W1'}],
                                                                       'type': 71}],
                                         'latitude': 31.974224,
                                         'longitude': -110.719221,
                                         'management_ip': '10.12.12.66',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-LR',
                                         'name': 'M.Williams',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:43:57:15',
                                         'uptime': '2145217'},
                                 {       'cpu': 18.0,
                                         'elevation': 1098.5,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '55081195454',
                                                                       'in_ucast_pkts': '242949898',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1582096385905',
                                                                       'out_ucast_pkts': '1169987187',
                                                                       'poller_hash': 'YWM4YmE5NDM1MGVmZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '5953683558',
                                                                       'in_ucast_pkts': '22767811',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '599818426',
                                                                       'out_ucast_pkts': '846272',
                                                                       'poller_hash': 'YWM4YmE5NDM1MGVmYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '513437689149',
                                                                       'in_ucast_pkts': '371424339',
                                                                       'links': [       {       'in_octets': '513437689149',
                                                                                                'in_ucast_pkts': '371424339',
                                                                                                'mac_address': '60:22:32:35:60:96',
                                                                                                'out_octets': '17309576062',
                                                                                                'out_ucast_pkts': '70077131'}],
                                                                       'mac_address': 'ac:8b:a9:43:50:ef',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '17309576062',
                                                                       'out_ucast_pkts': '70077131',
                                                                       'poller_hash': 'YWM4YmE5NDM1MGVmd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174068',
                                                                                                                                                     'distance': 5612,
                                                                                                                                                     'mac_address': '60:22:32:35:60:96',
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP3_W1'}],
                                                                       'type': 71}],
                                         'latitude': 31.965704,
                                         'longitude': -110.712516,
                                         'management_ip': '10.12.12.72',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-LR',
                                         'name': 'T12-W1-M.Lopez',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:43:50:ef',
                                         'uptime': '4652862'},
                                 {       'cpu': 18.0,
                                         'elevation': 1058.4,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '929761830',
                                                                       'in_ucast_pkts': '9679306',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '33178625389',
                                                                       'out_ucast_pkts': '24427623',
                                                                       'poller_hash': 'YWM4YmE5M2I5M2I1ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '121141672',
                                                                       'in_ucast_pkts': '1476001',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '936760',
                                                                       'out_ucast_pkts': '2108',
                                                                       'poller_hash': 'YWM4YmE5M2I5M2I1YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '33970568822',
                                                                       'in_ucast_pkts': '25340053',
                                                                       'links': [       {       'in_octets': '33970568822',
                                                                                                'in_ucast_pkts': '25340053',
                                                                                                'mac_address': '60:22:32:35:60:96',
                                                                                                'out_octets': '1240677713',
                                                                                                'out_ucast_pkts': '9906834'}],
                                                                       'mac_address': 'ac:8b:a9:3b:93:b5',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1240677713',
                                                                       'out_ucast_pkts': '9906834',
                                                                       'poller_hash': 'YWM4YmE5M2I5M2I1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174553',
                                                                                                                                                     'distance': 3507,
                                                                                                                                                     'mac_address': '60:22:32:35:60:96',
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP3_W1'}],
                                                                       'type': 71}],
                                         'latitude': 31.985438,
                                         'longitude': -110.711591,
                                         'management_ip': '10.12.12.115',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-LR',
                                         'name': 'T12-N.Poppleton',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:3b:93:b5',
                                         'uptime': '296858'},
                                 {       'cpu': 18.0,
                                         'elevation': 1058.9,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '9448924701',
                                                                       'in_ucast_pkts': '26417106',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '194622541764',
                                                                       'out_ucast_pkts': '147007074',
                                                                       'poller_hash': 'YWM4YmE5NDM1YjA5ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '749273577',
                                                                       'in_ucast_pkts': '8209606',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '8129717',
                                                                       'out_ucast_pkts': '16770',
                                                                       'poller_hash': 'YWM4YmE5NDM1YjA5YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '199258509047',
                                                                       'in_ucast_pkts': '151995045',
                                                                       'links': [       {       'in_octets': '199258509047',
                                                                                                'in_ucast_pkts': '151995045',
                                                                                                'mac_address': '60:22:32:35:60:96',
                                                                                                'out_octets': '11004788848',
                                                                                                'out_ucast_pkts': '27840510'}],
                                                                       'mac_address': 'ac:8b:a9:43:5b:09',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '11004788848',
                                                                       'out_ucast_pkts': '27840510',
                                                                       'poller_hash': 'YWM4YmE5NDM1YjA5d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174557',
                                                                                                                                                     'distance': 3463,
                                                                                                                                                     'mac_address': '60:22:32:35:60:96',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP3_W1'}],
                                                                       'type': 71}],
                                         'latitude': 31.986013,
                                         'longitude': -110.712274,
                                         'management_ip': '10.12.12.81',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-LR',
                                         'name': 'T12-L.Cates',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:43:5b:09',
                                         'uptime': '1886971'},
                                 {       'cpu': 18.0,
                                         'elevation': 1069.8,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '826181134150',
                                                                       'in_ucast_pkts': '826640515',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '377252469938',
                                                                       'out_ucast_pkts': '450979988',
                                                                       'poller_hash': 'NzBhNzQxYjVhYTMxZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '2265284282',
                                                                       'in_ucast_pkts': '22541019',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '308100914',
                                                                       'out_ucast_pkts': '379241',
                                                                       'poller_hash': 'NzBhNzQxYjVhYTMxYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '389330730930',
                                                                       'in_ucast_pkts': '464082871',
                                                                       'links': [       {       'in_octets': '389330730930',
                                                                                                'in_ucast_pkts': '464082871',
                                                                                                'mac_address': '60:22:32:35:60:96',
                                                                                                'out_octets': '851143629292',
                                                                                                'out_ucast_pkts': '831690526'}],
                                                                       'mac_address': '70:a7:41:b5:aa:31',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '851143629292',
                                                                       'out_ucast_pkts': '831690526',
                                                                       'poller_hash': 'NzBhNzQxYjVhYTMxd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174401',
                                                                                                                                                     'distance': 3653,
                                                                                                                                                     'mac_address': '60:22:32:35:60:96',
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP3_W1'}],
                                                                       'type': 71}],
                                         'latitude': 31.982738,
                                         'longitude': -110.70693,
                                         'management_ip': '10.12.12.60',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-LR',
                                         'name': 'T12-AP3W-C.Seed',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '70:a7:41:b5:aa:31',
                                         'uptime': '5428549'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_1_1_03(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.1.1.03")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 68040,
                'rf_tx_power': 21,
                'sta_count': 4,
                'sta_mode_cpe': False,
                'sw_version': 'v3.1.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 3279927883546,
                'dl_en_packets': 2405553745,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3326054876595,
                'dl_rf_packets': 2432889830,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 252632981811,
                'ul_en_packets': 844497651,
                'ul_noise_floor': None,
                'ul_rf_bytes': 255032240215,
                'ul_rf_packets': 852016802
        }
        exp_sta_stats = {
                '60:22:32:6f:9f:bd': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3852727790359,
                                             'dl_rf_packets': 2713360820,
                                             'dl_rssi': -66.0,
                                             'dl_snr': None,
                                             'ip_address': '10.12.12.63',
                                             'mac_address': '60:22:32:6f:9f:bd',
                                             'name': 'T12-AP4-J.Curtis',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 107262139504,
                                             'ul_rf_packets': 806830750,
                                             'ul_rssi': -62.0,
                                             'ul_snr': None},
                'ac:8b:a9:30:ba:ab': {       'alt_macs': {'ac:8b:a9:31:ba:ab'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 446925069528,
                                             'dl_rf_packets': 357435471,
                                             'dl_rssi': -68.0,
                                             'dl_snr': None,
                                             'ip_address': '10.12.12.153',
                                             'mac_address': 'ac:8b:a9:30:ba:ab',
                                             'name': 'T12-W2-A.Galmarini',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 39276990600,
                                             'ul_rf_packets': 144556835,
                                             'ul_rssi': -64.0,
                                             'ul_snr': None},
                'ac:8b:a9:3b:94:65': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 450916377668,
                                             'dl_rf_packets': 373963437,
                                             'dl_rssi': -57.0,
                                             'dl_snr': None,
                                             'ip_address': '10.12.12.69',
                                             'mac_address': 'ac:8b:a9:3b:94:65',
                                             'name': 'T12-M.Buck',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 104371724976,
                                             'ul_rf_packets': 168653462,
                                             'ul_rssi': -56.0,
                                             'ul_snr': None},
                'ac:8b:a9:43:4c:a1': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 808500000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 973994601581,
                                             'dl_rf_packets': 722245733,
                                             'dl_rssi': -68.0,
                                             'dl_snr': None,
                                             'ip_address': '10.12.12.112',
                                             'mac_address': 'ac:8b:a9:43:4c:a1',
                                             'name': 'T12-W2-M.Prober',
                                             'ul_link_rate': 539000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 70718594209,
                                             'ul_rf_packets': 282356912,
                                             'ul_rssi': -67.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 16.0,
                                'elevation': 1045.2,
                                'gps_sats_tracked': 10,
                                'interfaces': [       {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NjAyMjMyMzVkZmNmZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '3279927883546',
                                                              'in_ucast_pkts': '2405553745',
                                                              'mac_address': '60:22:32:35:df:cf',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '252632981811',
                                                              'out_ucast_pkts': '844497651',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_octets': '539073719',
                                                              'in_ucast_pkts': '2584876',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '13652643812',
                                                              'out_ucast_pkts': '19679504',
                                                              'poller_hash': 'NjAyMjMyMzVkZmNlYXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '254493166496',
                                                              'in_ucast_pkts': '849431926',
                                                              'links': [       {       'in_octets': '104371724976',
                                                                                       'in_ucast_pkts': '168653462',
                                                                                       'mac_address': 'ac:8b:a9:3b:94:65',
                                                                                       'out_octets': '450916377668',
                                                                                       'out_ucast_pkts': '373963437'},
                                                                               {       'in_octets': '39276990600',
                                                                                       'in_ucast_pkts': '144556835',
                                                                                       'mac_address': 'ac:8b:a9:30:ba:ab',
                                                                                       'out_octets': '446925069528',
                                                                                       'out_ucast_pkts': '357435471'},
                                                                               {       'in_octets': '70718594209',
                                                                                       'in_ucast_pkts': '282356912',
                                                                                       'mac_address': 'ac:8b:a9:43:4c:a1',
                                                                                       'out_octets': '973994601581',
                                                                                       'out_ucast_pkts': '722245733'},
                                                                               {       'in_octets': '107262139504',
                                                                                       'in_ucast_pkts': '806830750',
                                                                                       'mac_address': '60:22:32:6f:9f:bd',
                                                                                       'out_octets': '3852727790359',
                                                                                       'out_ucast_pkts': '2713360820'}],
                                                              'mac_address': '60:22:32:35:df:ce',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '3312402232783',
                                                              'out_ucast_pkts': '2413210326',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'rx_link_rate': '1101100000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '174534',
                                                                                                                                            'distance': 3040,
                                                                                                                                            'mac_address': 'ac:8b:a9:3b:94:65',
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '174001',
                                                                                                                                            'distance': 5309,
                                                                                                                                            'mac_address': 'ac:8b:a9:30:ba:ab',
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '875875000'},
                                                                                                                                    {       'connected_time': '174471',
                                                                                                                                            'distance': 3029,
                                                                                                                                            'mac_address': 'ac:8b:a9:43:4c:a1',
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '539000000',
                                                                                                                                            'tx_link_rate': '808500000'},
                                                                                                                                    {       'connected_time': '506496',
                                                                                                                                            'distance': 1684,
                                                                                                                                            'mac_address': '60:22:32:6f:9f:bd',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '1355200000',
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RW_T12_AP4_W2'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.014836,
                                'longitude': -110.698074,
                                'manufacturer': 'Ubiquiti',
                                'mem': 40.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.1.1',
                                'system_mac_address': '60:22:32:35:df:ce',
                                'temperature': 33.0,
                                'uptime': '1049014'},
                'peers': [       {       'cpu': 17.0,
                                         'elevation': 1068.5,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '99542266338',
                                                                       'in_ucast_pkts': '168117968',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '449144455036',
                                                                       'out_ucast_pkts': '372182395',
                                                                       'poller_hash': 'YWM4YmE5M2I5NDY1ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '321751165',
                                                                       'in_ucast_pkts': '3454254',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '89193229',
                                                                       'out_ucast_pkts': '90319',
                                                                       'poller_hash': 'YWM4YmE5M2I5NDY1YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '450916377668',
                                                                       'in_ucast_pkts': '373963437',
                                                                       'links': [       {       'in_octets': '450916377668',
                                                                                                'in_ucast_pkts': '373963437',
                                                                                                'mac_address': '60:22:32:35:df:ce',
                                                                                                'out_octets': '104371724976',
                                                                                                'out_ucast_pkts': '168653462'}],
                                                                       'mac_address': 'ac:8b:a9:3b:94:65',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '104371724976',
                                                                       'out_ucast_pkts': '168653462',
                                                                       'poller_hash': 'YWM4YmE5M2I5NDY1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174534',
                                                                                                                                                     'distance': 3040,
                                                                                                                                                     'mac_address': '60:22:32:35:df:ce',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP4_W2'}],
                                                                       'type': 71}],
                                         'latitude': 31.987603,
                                         'longitude': -110.693652,
                                         'management_ip': '10.12.12.69',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-LR',
                                         'name': 'T12-M.Buck',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:3b:94:65',
                                         'uptime': '744848'},
                                 {       'cpu': 21.0,
                                         'elevation': 1115.3,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '35590628217',
                                                                       'in_ucast_pkts': '145037318',
                                                                       'mac_address': 'ac:8b:a9:31:ba:ab',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '449305375191',
                                                                       'out_ucast_pkts': '358044740',
                                                                       'poller_hash': 'YWM4YmE5MzBiYWFiZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '7012543311',
                                                                       'in_ucast_pkts': '12141757',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '333668732',
                                                                       'out_ucast_pkts': '1239219',
                                                                       'poller_hash': 'YWM4YmE5MzBiYWFiYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '446925069528',
                                                                       'in_ucast_pkts': '357435471',
                                                                       'links': [       {       'in_octets': '446925069528',
                                                                                                'in_ucast_pkts': '357435471',
                                                                                                'mac_address': '60:22:32:35:df:ce',
                                                                                                'out_octets': '39276990600',
                                                                                                'out_ucast_pkts': '144556835'}],
                                                                       'mac_address': 'ac:8b:a9:30:ba:ab',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '39276990600',
                                                                       'out_ucast_pkts': '144556835',
                                                                       'poller_hash': 'YWM4YmE5MzBiYWFid2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174001',
                                                                                                                                                     'distance': 5309,
                                                                                                                                                     'mac_address': '60:22:32:35:df:ce',
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP4_W2'}],
                                                                       'type': 71}],
                                         'latitude': 31.967364,
                                         'longitude': -110.690613,
                                         'management_ip': '10.12.12.153',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 39.0,
                                         'model': 'Wave-LR',
                                         'name': 'T12-W2-A.Galmarini',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:30:ba:ab',
                                         'uptime': '1702153'},
                                 {       'cpu': 18.0,
                                         'elevation': 1066.0,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '63858928095',
                                                                       'in_ucast_pkts': '282627303',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '974095377128',
                                                                       'out_ucast_pkts': '721522166',
                                                                       'poller_hash': 'YWM4YmE5NDM0Y2ExZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '4362444647',
                                                                       'in_ucast_pkts': '8677013',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '287860016',
                                                                       'out_ucast_pkts': '1802457',
                                                                       'poller_hash': 'YWM4YmE5NDM0Y2ExYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '973994601581',
                                                                       'in_ucast_pkts': '722245733',
                                                                       'links': [       {       'in_octets': '973994601581',
                                                                                                'in_ucast_pkts': '722245733',
                                                                                                'mac_address': '60:22:32:35:df:ce',
                                                                                                'out_octets': '70718594209',
                                                                                                'out_ucast_pkts': '282356912'}],
                                                                       'mac_address': 'ac:8b:a9:43:4c:a1',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '70718594209',
                                                                       'out_ucast_pkts': '282356912',
                                                                       'poller_hash': 'YWM4YmE5NDM0Y2Exd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '174471',
                                                                                                                                                     'distance': 3029,
                                                                                                                                                     'mac_address': '60:22:32:35:df:ce',
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '808500000',
                                                                                                                                                     'tx_link_rate': '539000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP4_W2'}],
                                                                       'type': 71}],
                                         'latitude': 31.987661,
                                         'longitude': -110.694056,
                                         'management_ip': '10.12.12.112',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 39.0,
                                         'model': 'Wave-LR',
                                         'name': 'T12-W2-M.Prober',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:43:4c:a1',
                                         'uptime': '1301631'},
                                 {       'cpu': 17.0,
                                         'elevation': 1051.3,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '92595147012',
                                                                       'in_ucast_pkts': '804582889',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3844624381274',
                                                                       'out_ucast_pkts': '2703942099',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZmJkZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '1287080872',
                                                                       'in_ucast_pkts': '13995578',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '1728228',
                                                                       'out_ucast_pkts': '10421',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZmJkYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '3852727790359',
                                                                       'in_ucast_pkts': '2713360820',
                                                                       'links': [       {       'in_octets': '3852727790359',
                                                                                                'in_ucast_pkts': '2713360820',
                                                                                                'mac_address': '60:22:32:35:df:ce',
                                                                                                'out_octets': '107262139504',
                                                                                                'out_ucast_pkts': '806830750'}],
                                                                       'mac_address': '60:22:32:6f:9f:bd',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '107262139504',
                                                                       'out_ucast_pkts': '806830750',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZmJkd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '506496',
                                                                                                                                                     'distance': 1684,
                                                                                                                                                     'mac_address': '60:22:32:35:df:ce',
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW_T12_AP4_W2'}],
                                                                       'type': 71}],
                                         'latitude': 31.999577,
                                         'longitude': -110.697096,
                                         'management_ip': '10.12.12.63',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-Nano',
                                         'name': 'T12-AP4-J.Curtis',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:9f:bd',
                                         'uptime': '4027823'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_1_1_04(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.1.1.04")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 2160,
                'rf_freq': 68040,
                'rf_tx_power': 21,
                'sta_count': 5,
                'sta_mode_cpe': False,
                'sw_version': 'v3.1.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 1032053643140,
                'dl_en_packets': 779154562,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1031345834365,
                'dl_rf_packets': 850177312,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 54916375733,
                'ul_en_packets': 254770303,
                'ul_noise_floor': None,
                'ul_rf_bytes': 55557380502,
                'ul_rf_packets': 258417230
        }
        exp_sta_stats = {
                '60:22:32:6f:9a:f5': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 319444334010,
                                             'dl_rf_packets': 257592059,
                                             'dl_rssi': -50.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.182',
                                             'mac_address': '60:22:32:6f:9a:f5',
                                             'name': 'T3-W1-E.Hererra',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 17703365786,
                                             'ul_rf_packets': 96418894,
                                             'ul_rssi': -50.0,
                                             'ul_snr': None},
                '60:22:32:6f:9b:39': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 14421346462,
                                             'dl_rf_packets': 14589326,
                                             'dl_rssi': -42.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.124',
                                             'mac_address': '60:22:32:6f:9b:39',
                                             'name': 'T3-W1-D.Davis',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 1224043619,
                                             'ul_rf_packets': 4405750,
                                             'ul_rssi': -44.0,
                                             'ul_snr': None},
                '60:22:32:6f:9e:15': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 62529579736,
                                             'dl_rf_packets': 81459059,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.143',
                                             'mac_address': '60:22:32:6f:9e:15',
                                             'name': 'T3-W1-M.Calderon',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 16691404901,
                                             'ul_rf_packets': 27423421,
                                             'ul_rssi': -61.0,
                                             'ul_snr': None},
                '60:22:32:6f:ac:d1': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 356190937465,
                                             'dl_rf_packets': 259068717,
                                             'dl_rssi': -60.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.60',
                                             'mac_address': '60:22:32:6f:ac:d1',
                                             'name': 'T3-W1-S.Meyers2.0',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 6837301512,
                                             'ul_rf_packets': 54126308,
                                             'ul_rssi': -57.0,
                                             'ul_snr': None},
                '60:22:32:6f:ad:c5': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 191005672591,
                                             'dl_rf_packets': 160569621,
                                             'dl_rssi': -54.0,
                                             'dl_snr': None,
                                             'ip_address': '10.3.12.61',
                                             'mac_address': '60:22:32:6f:ad:c5',
                                             'name': 'T3-W1-K.Lalli',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 16246688831,
                                             'ul_rf_packets': 63725483,
                                             'ul_rssi': -53.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 17.0,
                                'elevation': 1035.4,
                                'gps_sats_tracked': 10,
                                'interfaces': [       {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NzBhNzQxY2RkYWFmZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '1032053643140',
                                                              'in_ucast_pkts': '779154562',
                                                              'mac_address': '70:a7:41:cd:da:af',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '54916375733',
                                                              'out_ucast_pkts': '254770303',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_octets': '10774354',
                                                              'in_ucast_pkts': '88563',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '4346688243',
                                                              'out_ucast_pkts': '30587628',
                                                              'poller_hash': 'NzBhNzQxY2RkYWFlYXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '29',
                                                              'in_octets': '55546606148',
                                                              'in_ucast_pkts': '258328667',
                                                              'links': [       {       'in_octets': '16691404901',
                                                                                       'in_ucast_pkts': '27423421',
                                                                                       'mac_address': '60:22:32:6f:9e:15',
                                                                                       'out_octets': '62529579736',
                                                                                       'out_ucast_pkts': '81459059'},
                                                                               {       'in_octets': '17703365786',
                                                                                       'in_ucast_pkts': '96418894',
                                                                                       'mac_address': '60:22:32:6f:9a:f5',
                                                                                       'out_octets': '319444334010',
                                                                                       'out_ucast_pkts': '257592059'},
                                                                               {       'in_octets': '16246688831',
                                                                                       'in_ucast_pkts': '63725483',
                                                                                       'mac_address': '60:22:32:6f:ad:c5',
                                                                                       'out_octets': '191005672591',
                                                                                       'out_ucast_pkts': '160569621'},
                                                                               {       'in_octets': '6837301512',
                                                                                       'in_ucast_pkts': '54126308',
                                                                                       'mac_address': '60:22:32:6f:ac:d1',
                                                                                       'out_octets': '356190937465',
                                                                                       'out_ucast_pkts': '259068717'},
                                                                               {       'in_octets': '1224043619',
                                                                                       'in_ucast_pkts': '4405750',
                                                                                       'mac_address': '60:22:32:6f:9b:39',
                                                                                       'out_octets': '14421346462',
                                                                                       'out_ucast_pkts': '14589326'}],
                                                              'mac_address': '70:a7:41:cd:da:ae',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '1026999146122',
                                                              'out_ucast_pkts': '819589684',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'rx_link_rate': '2202200000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '175968',
                                                                                                                                            'distance': 3007,
                                                                                                                                            'mac_address': '60:22:32:6f:9e:15',
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '507287',
                                                                                                                                            'distance': 1109,
                                                                                                                                            'mac_address': '60:22:32:6f:9a:f5',
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '506753',
                                                                                                                                            'distance': 2790,
                                                                                                                                            'mac_address': '60:22:32:6f:ad:c5',
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '506651',
                                                                                                                                            'distance': 2781,
                                                                                                                                            'mac_address': '60:22:32:6f:ac:d1',
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '151420',
                                                                                                                                            'distance': 738,
                                                                                                                                            'mac_address': '60:22:32:6f:9b:39',
                                                                                                                                            'rssi': -44.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '2700000000',
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RW-T3-W1'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.054567,
                                'longitude': -110.678312,
                                'manufacturer': 'Ubiquiti',
                                'mem': 40.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.1.1',
                                'system_mac_address': '70:a7:41:cd:da:ae',
                                'temperature': 36.0,
                                'uptime': '530575'},
                'peers': [       {       'cpu': 17.0,
                                         'elevation': 1004.0,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '15845223446',
                                                                       'in_ucast_pkts': '27016000',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '61252436654',
                                                                       'out_ucast_pkts': '80132560',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTE1ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '648413645',
                                                                       'in_ucast_pkts': '5389187',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '2097306',
                                                                       'out_ucast_pkts': '3611',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTE1YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '62529579736',
                                                                       'in_ucast_pkts': '81459059',
                                                                       'links': [       {       'in_octets': '62529579736',
                                                                                                'in_ucast_pkts': '81459059',
                                                                                                'mac_address': '70:a7:41:cd:da:ae',
                                                                                                'out_octets': '16691404901',
                                                                                                'out_ucast_pkts': '27423421'}],
                                                                       'mac_address': '60:22:32:6f:9e:15',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '16691404901',
                                                                       'out_ucast_pkts': '27423421',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTE1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '175968',
                                                                                                                                                     'distance': 3007,
                                                                                                                                                     'mac_address': '70:a7:41:cd:da:ae',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW-T3-W1'}],
                                                                       'type': 71}],
                                         'latitude': 32.03606,
                                         'longitude': -110.701571,
                                         'management_ip': '10.3.12.143',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'T3-W1-M.Calderon',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:9e:15',
                                         'uptime': '530613'},
                                 {       'cpu': 17.0,
                                         'elevation': 1010.9,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '14611379811',
                                                                       'in_ucast_pkts': '96015084',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '318269767247',
                                                                       'out_ucast_pkts': '256321347',
                                                                       'poller_hash': 'NjAyMjMyNmY5YWY1ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '1916938292',
                                                                       'in_ucast_pkts': '15008215',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '3629950',
                                                                       'out_ucast_pkts': '38387',
                                                                       'poller_hash': 'NjAyMjMyNmY5YWY1YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '319444334010',
                                                                       'in_ucast_pkts': '257592059',
                                                                       'links': [       {       'in_octets': '319444334010',
                                                                                                'in_ucast_pkts': '257592059',
                                                                                                'mac_address': '70:a7:41:cd:da:ae',
                                                                                                'out_octets': '17703365786',
                                                                                                'out_ucast_pkts': '96418894'}],
                                                                       'mac_address': '60:22:32:6f:9a:f5',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '17703365786',
                                                                       'out_ucast_pkts': '96418894',
                                                                       'poller_hash': 'NjAyMjMyNmY5YWY1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '507287',
                                                                                                                                                     'distance': 1109,
                                                                                                                                                     'mac_address': '70:a7:41:cd:da:ae',
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW-T3-W1'}],
                                                                       'type': 71}],
                                         'latitude': 32.048662,
                                         'longitude': -110.687824,
                                         'management_ip': '10.3.12.182',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-Nano',
                                         'name': 'T3-W1-E.Hererra',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:9a:f5',
                                         'uptime': '530612'},
                                 {       'cpu': 18.0,
                                         'elevation': 1003.1,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '14488638902',
                                                                       'in_ucast_pkts': '63325759',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '189735084316',
                                                                       'out_ucast_pkts': '159228801',
                                                                       'poller_hash': 'NjAyMjMyNmZhZGM1ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '1813430576',
                                                                       'in_ucast_pkts': '14916390',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '2748973',
                                                                       'out_ucast_pkts': '10601',
                                                                       'poller_hash': 'NjAyMjMyNmZhZGM1YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '191005672591',
                                                                       'in_ucast_pkts': '160569621',
                                                                       'links': [       {       'in_octets': '191005672591',
                                                                                                'in_ucast_pkts': '160569621',
                                                                                                'mac_address': '70:a7:41:cd:da:ae',
                                                                                                'out_octets': '16246688831',
                                                                                                'out_ucast_pkts': '63725483'}],
                                                                       'mac_address': '60:22:32:6f:ad:c5',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '16246688831',
                                                                       'out_ucast_pkts': '63725483',
                                                                       'poller_hash': 'NjAyMjMyNmZhZGM1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '506753',
                                                                                                                                                     'distance': 2790,
                                                                                                                                                     'mac_address': '70:a7:41:cd:da:ae',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW-T3-W1'}],
                                                                       'type': 71}],
                                         'latitude': 32.042229,
                                         'longitude': -110.704015,
                                         'management_ip': '10.3.12.61',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-LR',
                                         'name': 'T3-W1-K.Lalli',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:ad:c5',
                                         'uptime': '530613'},
                                 {       'cpu': 16.0,
                                         'elevation': 1011.4,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '5334542515',
                                                                       'in_ucast_pkts': '53765831',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '355129132220',
                                                                       'out_ucast_pkts': '257876305',
                                                                       'poller_hash': 'NjAyMjMyNmZhY2QxZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '1695967087',
                                                                       'in_ucast_pkts': '12356443',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '4810556',
                                                                       'out_ucast_pkts': '36888',
                                                                       'poller_hash': 'NjAyMjMyNmZhY2QxYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '356190937465',
                                                                       'in_ucast_pkts': '259068717',
                                                                       'links': [       {       'in_octets': '356190937465',
                                                                                                'in_ucast_pkts': '259068717',
                                                                                                'mac_address': '70:a7:41:cd:da:ae',
                                                                                                'out_octets': '6837301512',
                                                                                                'out_ucast_pkts': '54126308'}],
                                                                       'mac_address': '60:22:32:6f:ac:d1',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6837301512',
                                                                       'out_ucast_pkts': '54126308',
                                                                       'poller_hash': 'NjAyMjMyNmZhY2Qxd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '506651',
                                                                                                                                                     'distance': 2781,
                                                                                                                                                     'mac_address': '70:a7:41:cd:da:ae',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW-T3-W1'}],
                                                                       'type': 71}],
                                         'latitude': 32.038481,
                                         'longitude': -110.700971,
                                         'management_ip': '10.3.12.60',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-LR',
                                         'name': 'T3-W1-S.Meyers2.0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:ac:d1',
                                         'uptime': '530613'},
                                 {       'cpu': 17.0,
                                         'elevation': 1014.3,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1067384084',
                                                                       'in_ucast_pkts': '4287526',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '14054194767',
                                                                       'out_ucast_pkts': '14199465',
                                                                       'poller_hash': 'NjAyMjMyNmY5YjM5ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '522534919',
                                                                       'in_ucast_pkts': '4284580',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '662',
                                                                       'out_ucast_pkts': '5',
                                                                       'poller_hash': 'NjAyMjMyNmY5YjM5YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '14421346462',
                                                                       'in_ucast_pkts': '14589326',
                                                                       'links': [       {       'in_octets': '14421346462',
                                                                                                'in_ucast_pkts': '14589326',
                                                                                                'mac_address': '70:a7:41:cd:da:ae',
                                                                                                'out_octets': '1224043619',
                                                                                                'out_ucast_pkts': '4405750'}],
                                                                       'mac_address': '60:22:32:6f:9b:39',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1224043619',
                                                                       'out_ucast_pkts': '4405750',
                                                                       'poller_hash': 'NjAyMjMyNmY5YjM5d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '151420',
                                                                                                                                                     'distance': 738,
                                                                                                                                                     'mac_address': '70:a7:41:cd:da:ae',
                                                                                                                                                     'rssi': -42.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RW-T3-W1'}],
                                                                       'type': 71}],
                                         'latitude': 32.050019,
                                         'longitude': -110.684083,
                                         'management_ip': '10.3.12.124',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'T3-W1-D.Davis',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:9b:39',
                                         'uptime': '151461'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_1_1_05(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.1.1.05")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 2160,
                'rf_freq': 66960,
                'rf_tx_power': 21,
                'sta_count': 2,
                'sta_mode_cpe': False,
                'sw_version': 'v3.1.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 1714753991380,
                'dl_en_packets': 1715319621,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1764814202604,
                'dl_rf_packets': 1999814817,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 82080849610,
                'ul_en_packets': 356342247,
                'ul_noise_floor': None,
                'ul_rf_bytes': 83632919548,
                'ul_rf_packets': 358496334
        }
        exp_sta_stats = {
                'ac:8b:a9:34:2a:11': {       'alt_macs': {'ac:8b:a9:35:2a:11'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1257090172728,
                                             'dl_rf_packets': 1245958257,
                                             'dl_rssi': -63.0,
                                             'dl_snr': None,
                                             'ip_address': '10.100.14.161',
                                             'mac_address': 'ac:8b:a9:34:2a:11',
                                             'name': 'JBranch-691802',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 50389152557,
                                             'ul_rf_packets': 239217427,
                                             'ul_rssi': -59.0,
                                             'ul_snr': None},
                'ac:8b:a9:53:91:c7': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 56555786478,
                                             'dl_rf_packets': 109405544,
                                             'dl_rssi': -59.0,
                                             'dl_snr': None,
                                             'ip_address': '10.100.14.239',
                                             'mac_address': 'ac:8b:a9:53:91:c7',
                                             'name': 'JCharette-691830',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 6278094603,
                                             'ul_rf_packets': 20141911,
                                             'ul_rssi': -58.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 12.0,
                                'elevation': 803.5,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '1714753991380',
                                                              'in_ucast_pkts': '1715319621',
                                                              'mac_address': '70:a7:41:de:fc:9e',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '82080849610',
                                                              'out_ucast_pkts': '356342247',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '5',
                                                              'in_octets': '3094259',
                                                              'in_ucast_pkts': '8190',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '12851826061',
                                                              'out_ucast_pkts': '201562489',
                                                              'poller_hash': 'NzBhNzQxZGVmYzlkYXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NzBhNzQxZGVmYzllZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '83629825289',
                                                              'in_ucast_pkts': '358488144',
                                                              'links': [       {       'in_octets': '50389152557',
                                                                                       'in_ucast_pkts': '239217427',
                                                                                       'mac_address': 'ac:8b:a9:34:2a:11',
                                                                                       'out_octets': '1257090172728',
                                                                                       'out_ucast_pkts': '1245958257'},
                                                                               {       'in_octets': '6278094603',
                                                                                       'in_ucast_pkts': '20141911',
                                                                                       'mac_address': 'ac:8b:a9:53:91:c7',
                                                                                       'out_octets': '56555786478',
                                                                                       'out_ucast_pkts': '109405544'}],
                                                              'mac_address': '70:a7:41:de:fc:9d',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '1751962376543',
                                                              'out_ucast_pkts': '1798252328',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 66960,
                                                                                        'rx_link_rate': '2000000000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1111841',
                                                                                                                                            'distance': 589,
                                                                                                                                            'mac_address': 'ac:8b:a9:34:2a:11',
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '200206',
                                                                                                                                            'distance': 602,
                                                                                                                                            'mac_address': 'ac:8b:a9:53:91:c7',
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '2000000000',
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MLWR200U6_W_1'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 47.58725,
                                'longitude': -117.666964,
                                'manufacturer': 'Ubiquiti',
                                'mem': 44.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.1.1',
                                'system_mac_address': '70:a7:41:de:fc:9d',
                                'temperature': 26.0,
                                'uptime': '1460026'},
                'peers': [       {       'cpu': 19.0,
                                         'elevation': 758.8,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '43601146404',
                                                                       'in_ucast_pkts': '236852266',
                                                                       'mac_address': 'ac:8b:a9:35:2a:11',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1252365631168',
                                                                       'out_ucast_pkts': '1240696942',
                                                                       'poller_hash': 'YWM4YmE5MzQyYTExZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'YWM4YmE5MzQyYTExYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '1257090172728',
                                                                       'in_ucast_pkts': '1245958257',
                                                                       'links': [       {       'in_octets': '1257090172728',
                                                                                                'in_ucast_pkts': '1245958257',
                                                                                                'mac_address': '70:a7:41:de:fc:9d',
                                                                                                'out_octets': '50389152557',
                                                                                                'out_ucast_pkts': '239217427'}],
                                                                       'mac_address': 'ac:8b:a9:34:2a:11',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '50389152557',
                                                                       'out_ucast_pkts': '239217427',
                                                                       'poller_hash': 'YWM4YmE5MzQyYTExd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 66960,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1111841',
                                                                                                                                                     'distance': 589,
                                                                                                                                                     'mac_address': '70:a7:41:de:fc:9d',
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MLWR200U6_W_1'}],
                                                                       'type': 71}],
                                         'latitude': 47.582242,
                                         'longitude': -117.66971,
                                         'management_ip': '10.100.14.161',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'JBranch-691802',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:34:2a:11',
                                         'uptime': '1111944'},
                                 {       'cpu': 18.0,
                                         'elevation': 762.4,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '7636870019',
                                                                       'in_ucast_pkts': '29190073',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '80927045567',
                                                                       'out_ucast_pkts': '163975781',
                                                                       'poller_hash': 'YWM4YmE5NTM5MWM3ZXRoMA==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'YWM4YmE5NTM5MWM3YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '56555786478',
                                                                       'in_ucast_pkts': '109405544',
                                                                       'links': [       {       'in_octets': '56555786478',
                                                                                                'in_ucast_pkts': '109405544',
                                                                                                'mac_address': '70:a7:41:de:fc:9d',
                                                                                                'out_octets': '6278094603',
                                                                                                'out_ucast_pkts': '20141911'}],
                                                                       'mac_address': 'ac:8b:a9:53:91:c7',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6278094603',
                                                                       'out_ucast_pkts': '20141911',
                                                                       'poller_hash': 'YWM4YmE5NTM5MWM3d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 66960,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '200206',
                                                                                                                                                     'distance': 602,
                                                                                                                                                     'mac_address': '70:a7:41:de:fc:9d',
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MLWR200U6_W_1'}],
                                                                       'type': 71}],
                                         'latitude': 47.582301,
                                         'longitude': -117.670447,
                                         'management_ip': '10.100.14.239',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'JCharette-691830',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'ac:8b:a9:53:91:c7',
                                         'uptime': '315556'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_1_1_06(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.1.1.06")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 2160,
                'rf_freq': 68040,
                'rf_tx_power': 21,
                'sta_count': 5,
                'sta_mode_cpe': False,
                'sw_version': 'v3.1.1',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 3286615365,
                'dl_en_packets': 3232332161,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3616334111583,
                'dl_rf_packets': 3164409513,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 2806714946,
                'ul_en_packets': 1083797725,
                'ul_noise_floor': None,
                'ul_rf_bytes': 253487025331,
                'ul_rf_packets': 976670197
        }
        exp_sta_stats = {
                '24:5a:4c:3e:e8:c5': {       'alt_macs': {'24:5a:4c:3f:e8:c5'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 343455032751,
                                             'dl_rf_packets': 290628101,
                                             'dl_rssi': -61.0,
                                             'dl_snr': None,
                                             'ip_address': '10.1.0.3',
                                             'mac_address': '24:5a:4c:3e:e8:c5',
                                             'name': 'John Harms - 4',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 24499049994,
                                             'ul_rf_packets': 109610449,
                                             'ul_rssi': -62.0,
                                             'ul_snr': None},
                '60:22:32:6f:a2:b1': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 7092592076,
                                             'dl_rf_packets': 10536098,
                                             'dl_rssi': -59.0,
                                             'dl_snr': None,
                                             'ip_address': '10.1.0.169',
                                             'mac_address': '60:22:32:6f:a2:b1',
                                             'name': 'Lance Celander - 2781',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 325553141,
                                             'ul_rf_packets': 1702730,
                                             'ul_rssi': -62.0,
                                             'ul_snr': None},
                '60:22:32:6f:aa:63': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 69247076947,
                                             'dl_rf_packets': 114918064,
                                             'dl_rssi': -53.0,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.89',
                                             'mac_address': '60:22:32:6f:aa:63',
                                             'name': 'Johnny Powers - 2757',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 8143188833,
                                             'ul_rf_packets': 23118986,
                                             'ul_rssi': -54.0,
                                             'ul_snr': None},
                'ac:8b:a9:2f:19:eb': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1426591910185,
                                             'dl_rf_packets': 1030905969,
                                             'dl_rssi': -51.0,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.101',
                                             'mac_address': 'ac:8b:a9:2f:19:eb',
                                             'name': 'Julia Searcy - 600',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 44362825662,
                                             'ul_rf_packets': 369210606,
                                             'ul_rssi': -53.0,
                                             'ul_snr': None},
                'd0:21:f9:d8:90:21': {       'alt_macs': {'d0:21:f9:d9:90:21'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 258099315010,
                                             'dl_rf_packets': 215101089,
                                             'dl_rssi': -60.0,
                                             'dl_snr': None,
                                             'ip_address': '10.1.1.39',
                                             'mac_address': 'd0:21:f9:d8:90:21',
                                             'name': 'Blake Shelton - 587',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 21276636517,
                                             'ul_rf_packets': 52487113,
                                             'ul_rssi': -60.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 26.0,
                                'elevation': 1030.3,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '11',
                                                              'in_octets': '253487025331',
                                                              'in_ucast_pkts': '976670197',
                                                              'links': [       {       'in_octets': '325553141',
                                                                                       'in_ucast_pkts': '1702730',
                                                                                       'mac_address': '60:22:32:6f:a2:b1',
                                                                                       'out_octets': '7092592076',
                                                                                       'out_ucast_pkts': '10536098'},
                                                                               {       'in_octets': '8143188833',
                                                                                       'in_ucast_pkts': '23118986',
                                                                                       'mac_address': '60:22:32:6f:aa:63',
                                                                                       'out_octets': '69247076947',
                                                                                       'out_ucast_pkts': '114918064'},
                                                                               {       'in_octets': '21276636517',
                                                                                       'in_ucast_pkts': '52487113',
                                                                                       'mac_address': 'd0:21:f9:d8:90:21',
                                                                                       'out_octets': '258099315010',
                                                                                       'out_ucast_pkts': '215101089'},
                                                                               {       'in_octets': '44362825662',
                                                                                       'in_ucast_pkts': '369210606',
                                                                                       'mac_address': 'ac:8b:a9:2f:19:eb',
                                                                                       'out_octets': '1426591910185',
                                                                                       'out_ucast_pkts': '1030905969'},
                                                                               {       'in_octets': '24499049994',
                                                                                       'in_ucast_pkts': '109610449',
                                                                                       'mac_address': '24:5a:4c:3e:e8:c5',
                                                                                       'out_octets': '343455032751',
                                                                                       'out_ucast_pkts': '290628101'}],
                                                              'mac_address': '68:d7:9a:1f:6f:78',
                                                              'mtu': 1700,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '3616334111583',
                                                              'out_ucast_pkts': '3164409513',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'rx_link_rate': '1000000000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '251029',
                                                                                                                                            'distance': 1142,
                                                                                                                                            'mac_address': '60:22:32:6f:a2:b1',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '2586218',
                                                                                                                                            'distance': 1337,
                                                                                                                                            'mac_address': '60:22:32:6f:aa:63',
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '1129145',
                                                                                                                                            'distance': 832,
                                                                                                                                            'mac_address': 'd0:21:f9:d8:90:21',
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '2485240',
                                                                                                                                            'distance': 949,
                                                                                                                                            'mac_address': 'ac:8b:a9:2f:19:eb',
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '1823392',
                                                                                                                                            'distance': 1173,
                                                                                                                                            'mac_address': '24:5a:4c:3e:e8:c5',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '1000000000',
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Tx1.60WSW'}],
                                                              'speed': '1000000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '3286615365',
                                                              'in_ucast_pkts': '3232332161',
                                                              'mac_address': '68:d7:9a:1f:6f:79',
                                                              'mtu': 1700,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '2806714946',
                                                              'out_ucast_pkts': '1083797725',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'latitude': 32.722223,
                                'longitude': -102.65889,
                                'manufacturer': 'Ubiquiti',
                                'mem': 31.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.1.1',
                                'system_mac_address': '68:d7:9a:1f:6f:78',
                                'temperature': 31.0,
                                'uptime': '8576420'},
                'peers': [       {       'cpu': 16.0,
                                         'elevation': 1021.2,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '254082937',
                                                                       'in_ucast_pkts': '1393898',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '6608524290',
                                                                       'out_ucast_pkts': '9755639',
                                                                       'poller_hash': 'NjAyMjMyNmZhMmIxZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1700,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmZhMmIxYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '7092592076',
                                                                       'in_ucast_pkts': '10536098',
                                                                       'links': [       {       'in_octets': '7092592076',
                                                                                                'in_ucast_pkts': '10536098',
                                                                                                'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                'out_octets': '325553141',
                                                                                                'out_ucast_pkts': '1702730'}],
                                                                       'mac_address': '60:22:32:6f:a2:b1',
                                                                       'mtu': 1700,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '325553141',
                                                                       'out_ucast_pkts': '1702730',
                                                                       'poller_hash': 'NjAyMjMyNmZhMmIxd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '251029',
                                                                                                                                                     'distance': 1142,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx1.60WSW'}],
                                                                       'type': 71}],
                                         'latitude': 32.721078,
                                         'longitude': -102.670919,
                                         'management_ip': '10.1.0.169',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 36.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Lance Celander - 2781',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:a2:b1',
                                         'uptime': '251075'},
                                 {       'cpu': 15.0,
                                         'elevation': 1023.9,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '24274929683',
                                                                       'in_ucast_pkts': '69204499',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '215220150740',
                                                                       'out_ucast_pkts': '416582113',
                                                                       'poller_hash': 'NjAyMjMyNmZhYTYzZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1700,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmZhYTYzYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '69247076947',
                                                                       'in_ucast_pkts': '114918064',
                                                                       'links': [       {       'in_octets': '69247076947',
                                                                                                'in_ucast_pkts': '114918064',
                                                                                                'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                'out_octets': '8143188833',
                                                                                                'out_ucast_pkts': '23118986'}],
                                                                       'mac_address': '60:22:32:6f:aa:63',
                                                                       'mtu': 1700,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '8143188833',
                                                                       'out_ucast_pkts': '23118986',
                                                                       'poller_hash': 'NjAyMjMyNmZhYTYzd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2586218',
                                                                                                                                                     'distance': 1337,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx1.60WSW'}],
                                                                       'type': 71}],
                                         'latitude': 32.718054,
                                         'longitude': -102.672157,
                                         'management_ip': '10.1.1.89',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-LR',
                                         'name': 'Johnny Powers - 2757',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': '60:22:32:6f:aa:63',
                                         'uptime': '8473994'},
                                 {       'cpu': 19.0,
                                         'elevation': 1017.3,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '19844977387',
                                                                       'in_ucast_pkts': '50985672',
                                                                       'mac_address': 'd0:21:f9:d9:90:21',
                                                                       'mtu': 1700,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '255902368477',
                                                                       'out_ucast_pkts': '211470069',
                                                                       'poller_hash': 'ZDAyMWY5ZDg5MDIxZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1700,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ZDAyMWY5ZDg5MDIxYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '258099315010',
                                                                       'in_ucast_pkts': '215101089',
                                                                       'links': [       {       'in_octets': '258099315010',
                                                                                                'in_ucast_pkts': '215101089',
                                                                                                'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                'out_octets': '21276636517',
                                                                                                'out_ucast_pkts': '52487113'}],
                                                                       'mac_address': 'd0:21:f9:d8:90:21',
                                                                       'mtu': 1700,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '21276636517',
                                                                       'out_ucast_pkts': '52487113',
                                                                       'poller_hash': 'ZDAyMWY5ZDg5MDIxd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1129145',
                                                                                                                                                     'distance': 832,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 21}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx1.60WSW'}],
                                                                       'type': 71}],
                                         'latitude': 32.720716,
                                         'longitude': -102.667543,
                                         'management_ip': '10.1.1.39',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 36.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Blake Shelton - 587',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.1.1',
                                         'system_mac_address': 'd0:21:f9:d8:90:21',
                                         'uptime': '1129245'},
                                 {       'cpu': 12.0,
                                         'elevation': 1019.6,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '35810186057',
                                                                       'in_ucast_pkts': '365757129',
                                                                       'mtu': 1560,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1414640016216',
                                                                       'out_ucast_pkts': '984197426',
                                                                       'poller_hash': 'YWM4YmE5MmYxOWViZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1560,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'YWM4YmE5MmYxOWViYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '1426591910185',
                                                                       'in_ucast_pkts': '1030905969',
                                                                       'links': [       {       'in_octets': '1426591910185',
                                                                                                'in_ucast_pkts': '1030905969',
                                                                                                'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                'out_octets': '44362825662',
                                                                                                'out_ucast_pkts': '369210606'}],
                                                                       'mac_address': 'ac:8b:a9:2f:19:eb',
                                                                       'mtu': 1560,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '44362825662',
                                                                       'out_ucast_pkts': '369210606',
                                                                       'poller_hash': 'YWM4YmE5MmYxOWVid2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2485240',
                                                                                                                                                     'distance': 949,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx1.60WSW'}],
                                                                       'type': 71}],
                                         'latitude': 32.720152,
                                         'longitude': -102.668586,
                                         'management_ip': '10.1.1.101',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Julia Searcy - 600',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta2',
                                         'system_mac_address': 'ac:8b:a9:2f:19:eb',
                                         'uptime': '2485425'},
                                 {       'cpu': 12.0,
                                         'elevation': 1024.2,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '343455032751',
                                                                       'in_ucast_pkts': '290628101',
                                                                       'links': [       {       'in_octets': '343455032751',
                                                                                                'in_ucast_pkts': '290628101',
                                                                                                'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                'out_octets': '24499049994',
                                                                                                'out_ucast_pkts': '109610449'}],
                                                                       'mac_address': '24:5a:4c:3e:e8:c5',
                                                                       'mtu': 1530,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '24499049994',
                                                                       'out_ucast_pkts': '109610449',
                                                                       'poller_hash': 'MjQ1YTRjM2VlOGM1d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1823392',
                                                                                                                                                     'distance': 1173,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:6f:78',
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx1.60WSW'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '261921712',
                                                                       'in_ucast_pkts': '109068662',
                                                                       'mac_address': '24:5a:4c:3f:e8:c5',
                                                                       'mtu': 1530,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '773643859',
                                                                       'out_ucast_pkts': '286687158',
                                                                       'poller_hash': 'MjQ1YTRjM2VlOGM1ZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.721079,
                                         'longitude': -102.671289,
                                         'management_ip': '10.1.0.3',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 30.0,
                                         'model': 'AF60-LR',
                                         'name': 'John Harms - 4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta3',
                                         'system_mac_address': '24:5a:4c:3e:e8:c5',
                                         'uptime': '1823608'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_2_0_beta_01(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.2.0-beta.01")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 68040,
                'rf_tx_power': 20,
                'sta_count': 2,
                'sta_mode_cpe': False,
                'sw_version': 'v3.2.0-beta',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 1921240277071,
                'dl_en_packets': 1434647216,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1945479746576,
                'dl_rf_packets': 1444224824,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 267643911663,
                'ul_en_packets': 1032802453,
                'ul_noise_floor': None,
                'ul_rf_bytes': 266121107367,
                'ul_rf_packets': 1035942233
        }
        exp_sta_stats = {
                '60:22:32:6f:9b:1f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 61542069315,
                                             'dl_rf_packets': 48095736,
                                             'dl_rssi': -52.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.8.19',
                                             'mac_address': '60:22:32:6f:9b:1f',
                                             'name': 'Wave-Larremore_Tom',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 3169058306,
                                             'ul_rf_packets': 24350443,
                                             'ul_rssi': -50.0,
                                             'ul_snr': None},
                '60:22:32:6f:a1:a3': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 805382227303,
                                             'dl_rf_packets': 613646332,
                                             'dl_rssi': -48.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.8.5',
                                             'mac_address': '60:22:32:6f:a1:a3',
                                             'name': 'Wave-ShadowRidge',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 144773491640,
                                             'ul_rf_packets': 461073315,
                                             'ul_rssi': -48.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 9.0,
                                'elevation': 758.9,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '1921240277071',
                                                              'in_ucast_pkts': '1434647216',
                                                              'mac_address': '60:22:32:39:4d:33',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '267643911663',
                                                              'out_ucast_pkts': '1032802453',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NjAyMjMyMzk0ZDMzZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_octets': '920099424',
                                                              'in_ucast_pkts': '6591991',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '18083947786',
                                                              'out_ucast_pkts': '19358848',
                                                              'poller_hash': 'NjAyMjMyMzk0ZDMyYXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '12',
                                                              'in_octets': '265201007943',
                                                              'in_ucast_pkts': '1029350242',
                                                              'links': [       {       'in_octets': '3169058306',
                                                                                       'in_ucast_pkts': '24350443',
                                                                                       'mac_address': '60:22:32:6f:9b:1f',
                                                                                       'out_octets': '61542069315',
                                                                                       'out_ucast_pkts': '48095736'},
                                                                               {       'in_octets': '144773491640',
                                                                                       'in_ucast_pkts': '461073315',
                                                                                       'mac_address': '60:22:32:6f:a1:a3',
                                                                                       'out_octets': '805382227303',
                                                                                       'out_ucast_pkts': '613646332'}],
                                                              'mac_address': '60:22:32:39:4d:32',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '1927395798790',
                                                              'out_ucast_pkts': '1424865976',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'rx_link_rate': '1617000000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '507289',
                                                                                                                                            'distance': 1345,
                                                                                                                                            'mac_address': '60:22:32:6f:9b:1f',
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '507302',
                                                                                                                                            'distance': 1195,
                                                                                                                                            'mac_address': '60:22:32:6f:a1:a3',
                                                                                                                                            'rssi': -48.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '1617000000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FRI-008'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.365467,
                                'longitude': -112.878817,
                                'manufacturer': 'Ubiquiti',
                                'mem': 39.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.2.0-beta',
                                'system_mac_address': '60:22:32:39:4d:32',
                                'temperature': 37.0,
                                'uptime': '1162267'},
                'peers': [       {       'cpu': 12.0,
                                         'elevation': 561.1,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '61542069315',
                                                                       'in_ucast_pkts': '48095736',
                                                                       'links': [       {       'in_octets': '61542069315',
                                                                                                'in_ucast_pkts': '48095736',
                                                                                                'mac_address': '60:22:32:39:4d:32',
                                                                                                'out_octets': '3169058306',
                                                                                                'out_ucast_pkts': '24350443'}],
                                                                       'mac_address': '60:22:32:6f:9b:1f',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '3169058306',
                                                                       'out_ucast_pkts': '24350443',
                                                                       'poller_hash': 'NjAyMjMyNmY5YjFmd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '507289',
                                                                                                                                                     'distance': 1345,
                                                                                                                                                     'mac_address': '60:22:32:39:4d:32',
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-008'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '910122520',
                                                                       'in_ucast_pkts': '2449460',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmY5YjFmYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '2486461168',
                                                                       'in_ucast_pkts': '24118417',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '61332878625',
                                                                       'out_ucast_pkts': '47397393',
                                                                       'poller_hash': 'NjAyMjMyNmY5YjFmZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.376776,
                                         'longitude': -112.874148,
                                         'management_ip': '100.70.8.19',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-Larremore_Tom',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:9b:1f',
                                         'uptime': '514768'},
                                 {       'cpu': 14.0,
                                         'elevation': 560.5,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '805382227303',
                                                                       'in_ucast_pkts': '613646332',
                                                                       'links': [       {       'in_octets': '805382227303',
                                                                                                'in_ucast_pkts': '613646332',
                                                                                                'mac_address': '60:22:32:39:4d:32',
                                                                                                'out_octets': '144773491640',
                                                                                                'out_ucast_pkts': '461073315'}],
                                                                       'mac_address': '60:22:32:6f:a1:a3',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '144773491640',
                                                                       'out_ucast_pkts': '461073315',
                                                                       'poller_hash': 'NjAyMjMyNmZhMWEzd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '507302',
                                                                                                                                                     'distance': 1195,
                                                                                                                                                     'mac_address': '60:22:32:39:4d:32',
                                                                                                                                                     'rssi': -48.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-008'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '4748428922',
                                                                       'in_ucast_pkts': '5197268',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmZhMWEzYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '136258654460',
                                                                       'in_ucast_pkts': '462061432',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '808972322746',
                                                                       'out_ucast_pkts': '615688285',
                                                                       'poller_hash': 'NjAyMjMyNmZhMWEzZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.375375,
                                         'longitude': -112.87434,
                                         'management_ip': '100.70.8.5',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 39.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-ShadowRidge',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:a1:a3',
                                         'uptime': '513426'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_2_0_beta_02(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.2.0-beta.02")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 63720,
                'rf_tx_power': 20,
                'sta_count': 2,
                'sta_mode_cpe': False,
                'sw_version': 'v3.2.0-beta',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 1479715084268,
                'dl_en_packets': 1138555003,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1499909009912,
                'dl_rf_packets': 1147745908,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 159490587820,
                'ul_en_packets': 930268448,
                'ul_noise_floor': None,
                'ul_rf_bytes': 160390244352,
                'ul_rf_packets': 936182461
        }
        exp_sta_stats = {
                '60:22:32:6f:9a:2f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 126733104095,
                                             'dl_rf_packets': 94061380,
                                             'dl_rssi': -69.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.37.19',
                                             'mac_address': '60:22:32:6f:9a:2f',
                                             'name': 'Wave-Garcia_Pablo',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 10079268240,
                                             'ul_rf_packets': 65936639,
                                             'ul_rssi': -65.0,
                                             'ul_snr': None},
                '60:22:32:6f:9e:93': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 808500000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2769327506243,
                                             'dl_rf_packets': 2282567527,
                                             'dl_rssi': -72.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.37.4',
                                             'mac_address': '60:22:32:6f:9e:93',
                                             'name': 'Wave-Frias, Leo',
                                             'ul_link_rate': 808500000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 365095398855,
                                             'ul_rf_packets': 1758345574,
                                             'ul_rssi': -67.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 9.0,
                                'elevation': 756.7,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '1479715084268',
                                                              'in_ucast_pkts': '1138555003',
                                                              'mac_address': '60:22:32:35:e0:47',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '159490587820',
                                                              'out_ucast_pkts': '930268448',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NjAyMjMyMzVlMDQ3ZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_octets': '1220296169',
                                                              'in_ucast_pkts': '9434399',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '16452265361',
                                                              'out_ucast_pkts': '16345012',
                                                              'poller_hash': 'NjAyMjMyMzVlMDQ2YXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '159169948183',
                                                              'in_ucast_pkts': '926748062',
                                                              'links': [       {       'in_octets': '10079268240',
                                                                                       'in_ucast_pkts': '65936639',
                                                                                       'mac_address': '60:22:32:6f:9a:2f',
                                                                                       'out_octets': '126733104095',
                                                                                       'out_ucast_pkts': '94061380'},
                                                                               {       'in_octets': '365095398855',
                                                                                       'in_ucast_pkts': '1758345574',
                                                                                       'mac_address': '60:22:32:6f:9e:93',
                                                                                       'out_octets': '2769327506243',
                                                                                       'out_ucast_pkts': '2282567527'}],
                                                              'mac_address': '60:22:32:35:e0:46',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '1483456744551',
                                                              'out_ucast_pkts': '1131400896',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 63720,
                                                                                        'rx_link_rate': '875875000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '196434',
                                                                                                                                            'distance': 1699,
                                                                                                                                            'mac_address': '60:22:32:6f:9a:2f',
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '875875000'},
                                                                                                                                    {       'connected_time': '196382',
                                                                                                                                            'distance': 1673,
                                                                                                                                            'mac_address': '60:22:32:6f:9e:93',
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '808500000',
                                                                                                                                            'tx_link_rate': '808500000'}]}],
                                                                                        'tx_link_rate': '875875000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FRI-037'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.365448,
                                'longitude': -112.878826,
                                'manufacturer': 'Ubiquiti',
                                'mem': 39.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.2.0-beta',
                                'system_mac_address': '60:22:32:35:e0:46',
                                'temperature': 39.0,
                                'uptime': '1162273'},
                'peers': [       {       'cpu': 11.0,
                                         'elevation': 550.1,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '126733104095',
                                                                       'in_ucast_pkts': '94061380',
                                                                       'links': [       {       'in_octets': '126733104095',
                                                                                                'in_ucast_pkts': '94061380',
                                                                                                'mac_address': '60:22:32:35:e0:46',
                                                                                                'out_octets': '10079268240',
                                                                                                'out_ucast_pkts': '65936639'}],
                                                                       'mac_address': '60:22:32:6f:9a:2f',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '10079268240',
                                                                       'out_ucast_pkts': '65936639',
                                                                       'poller_hash': 'NjAyMjMyNmY5YTJmd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 63720,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '196434',
                                                                                                                                                     'distance': 1699,
                                                                                                                                                     'mac_address': '60:22:32:35:e0:46',
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-037'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '730245018',
                                                                       'in_ucast_pkts': '2040431',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmY5YTJmYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '8748465528',
                                                                       'in_ucast_pkts': '65973924',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '126176641876',
                                                                       'out_ucast_pkts': '93285199',
                                                                       'poller_hash': 'NjAyMjMyNmY5YTJmZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.378641,
                                         'longitude': -112.869823,
                                         'management_ip': '100.70.37.19',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-Garcia_Pablo',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:9a:2f',
                                         'uptime': '513481'},
                                 {       'cpu': 14.0,
                                         'elevation': 545.7,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2769327506243',
                                                                       'in_ucast_pkts': '2282567527',
                                                                       'links': [       {       'in_octets': '2769327506243',
                                                                                                'in_ucast_pkts': '2282567527',
                                                                                                'mac_address': '60:22:32:35:e0:46',
                                                                                                'out_octets': '365095398855',
                                                                                                'out_ucast_pkts': '1758345574'}],
                                                                       'mac_address': '60:22:32:6f:9e:93',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '365095398855',
                                                                       'out_ucast_pkts': '1758345574',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTkzd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 63720,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '196382',
                                                                                                                                                     'distance': 1673,
                                                                                                                                                     'mac_address': '60:22:32:35:e0:46',
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '808500000',
                                                                                                                                                     'tx_link_rate': '808500000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-037'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '9248489577',
                                                                       'in_ucast_pkts': '22819575',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTkzYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '328153385717',
                                                                       'in_ucast_pkts': '1759440891',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2766455251129',
                                                                       'out_ucast_pkts': '2276751029',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTkzZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.376864,
                                         'longitude': -112.86743,
                                         'management_ip': '100.70.37.4',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-Frias, Leo',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:9e:93',
                                         'uptime': '5036544'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_2_0_beta_03(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.2.0-beta.03")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 69120,
                'rf_tx_power': 20,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v3.2.0-beta',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 3016010038965,
                'dl_en_packets': 2194146817,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3050120883925,
                'dl_rf_packets': 2213795498,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 189246570895,
                'ul_en_packets': 1465901123,
                'ul_noise_floor': None,
                'ul_rf_bytes': 187188705151,
                'ul_rf_packets': 1472377776
        }
        exp_sta_stats = {
                '60:22:32:6f:9e:8d': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 9590501171338,
                                             'dl_rf_packets': 7268823583,
                                             'dl_rssi': -53.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.66.47',
                                             'mac_address': '60:22:32:6f:9e:8d',
                                             'name': 'Wave-Morondeast',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 918117853986,
                                             'ul_rf_packets': 5020877802,
                                             'ul_rssi': -52.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 8.0,
                                'elevation': 753.3,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '3016010038965',
                                                              'in_ucast_pkts': '2194146817',
                                                              'mac_address': '60:22:32:35:df:b9',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '189246570895',
                                                              'out_ucast_pkts': '1465901123',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NjAyMjMyMzVkZmI5ZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_octets': '4253118171',
                                                              'in_ucast_pkts': '21205168',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '47837569072',
                                                              'out_ucast_pkts': '42507148',
                                                              'poller_hash': 'NjAyMjMyMzVkZmI4YXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '182935586980',
                                                              'in_ucast_pkts': '1451172608',
                                                              'links': [       {       'in_octets': '918117853986',
                                                                                       'in_ucast_pkts': '5020877802',
                                                                                       'mac_address': '60:22:32:6f:9e:8d',
                                                                                       'out_octets': '9590501171338',
                                                                                       'out_ucast_pkts': '7268823583'}],
                                                              'mac_address': '60:22:32:35:df:b8',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '3002283314853',
                                                              'out_ucast_pkts': '2171288350',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 69120,
                                                                                        'rx_link_rate': '1000000000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '507320',
                                                                                                                                            'distance': 1730,
                                                                                                                                            'mac_address': '60:22:32:6f:9e:8d',
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '875875000'}]}],
                                                                                        'tx_link_rate': '875875000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FRI-066'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.365385,
                                'longitude': -112.878837,
                                'manufacturer': 'Ubiquiti',
                                'mem': 40.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.2.0-beta',
                                'system_mac_address': '60:22:32:35:df:b8',
                                'temperature': 42.0,
                                'uptime': '595198'},
                'peers': [       {       'cpu': 13.0,
                                         'elevation': 546.6,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '9590501171338',
                                                                       'in_ucast_pkts': '7268823583',
                                                                       'links': [       {       'in_octets': '9590501171338',
                                                                                                'in_ucast_pkts': '7268823583',
                                                                                                'mac_address': '60:22:32:35:df:b8',
                                                                                                'out_octets': '918117853986',
                                                                                                'out_ucast_pkts': '5020877802'}],
                                                                       'mac_address': '60:22:32:6f:9e:8d',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '918117853986',
                                                                       'out_ucast_pkts': '5020877802',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZThkd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 69120,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '507320',
                                                                                                                                                     'distance': 1730,
                                                                                                                                                     'mac_address': '60:22:32:35:df:b8',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-066'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '22884582812',
                                                                       'in_ucast_pkts': '58602994',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZThkYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '820611225424',
                                                                       'in_ucast_pkts': '5021954931',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '9594613283126',
                                                                       'out_ucast_pkts': '7268717403',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZThkZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.373517,
                                         'longitude': -112.863157,
                                         'management_ip': '100.70.66.47',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 39.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-Morondeast',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:9e:8d',
                                         'uptime': '5035178'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_2_0_beta_04(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.2.0-beta.04")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 69120,
                'rf_tx_power': 20,
                'sta_count': 4,
                'sta_mode_cpe': False,
                'sw_version': 'v3.2.0-beta',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 2263739592,
                'dl_en_packets': 268732834,
                'dl_noise_floor': None,
                'dl_rf_bytes': 347826774643,
                'dl_rf_packets': 273740332,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 2949773259,
                'ul_en_packets': 192841576,
                'ul_noise_floor': None,
                'ul_rf_bytes': 35941493588,
                'ul_rf_packets': 196948035
        }
        exp_sta_stats = {
                '60:22:32:6f:9a:b9': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 99469376082,
                                             'dl_rf_packets': 80487731,
                                             'dl_rssi': -46.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.98.3',
                                             'mac_address': '60:22:32:6f:9a:b9',
                                             'name': 'Wave-McDonough_Connemara',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 13350088153,
                                             'ul_rf_packets': 63375359,
                                             'ul_rssi': -46.0,
                                             'ul_snr': None},
                '60:22:32:6f:9e:63': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 64313838841,
                                             'dl_rf_packets': 49820135,
                                             'dl_rssi': -49.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.98.10',
                                             'mac_address': '60:22:32:6f:9e:63',
                                             'name': 'Wave-Bressler_Katrisha',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 4684836551,
                                             'ul_rf_packets': 32114099,
                                             'ul_rssi': -50.0,
                                             'ul_snr': None},
                '60:22:32:6f:9e:fb': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 149018624663,
                                             'dl_rf_packets': 117657553,
                                             'dl_rssi': -50.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.98.9',
                                             'mac_address': '60:22:32:6f:9e:fb',
                                             'name': 'Wave-Jacobs_Nadele',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 13105839638,
                                             'ul_rf_packets': 75754961,
                                             'ul_rssi': -49.0,
                                             'ul_snr': None},
                '60:22:32:6f:9f:0f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1002098236,
                                             'dl_rf_packets': 2899700,
                                             'dl_rssi': -51.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.98.6',
                                             'mac_address': '60:22:32:6f:9f:0f',
                                             'name': 'Wave-Basile_Andrew',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 179392582,
                                             'ul_rf_packets': 378535,
                                             'ul_rssi': -51.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 17.0,
                                'elevation': 754.4,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '2263739592',
                                                              'in_ucast_pkts': '268732834',
                                                              'mac_address': '68:d7:9a:1f:34:ea',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '2949773259',
                                                              'out_ucast_pkts': '192841576',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_octets': '35941493588',
                                                              'in_ucast_pkts': '196948035',
                                                              'links': [       {       'in_octets': '13350088153',
                                                                                       'in_ucast_pkts': '63375359',
                                                                                       'mac_address': '60:22:32:6f:9a:b9',
                                                                                       'out_octets': '99469376082',
                                                                                       'out_ucast_pkts': '80487731'},
                                                                               {       'in_octets': '179392582',
                                                                                       'in_ucast_pkts': '378535',
                                                                                       'mac_address': '60:22:32:6f:9f:0f',
                                                                                       'out_octets': '1002098236',
                                                                                       'out_ucast_pkts': '2899700'},
                                                                               {       'in_octets': '13105839638',
                                                                                       'in_ucast_pkts': '75754961',
                                                                                       'mac_address': '60:22:32:6f:9e:fb',
                                                                                       'out_octets': '149018624663',
                                                                                       'out_ucast_pkts': '117657553'},
                                                                               {       'in_octets': '4684836551',
                                                                                       'in_ucast_pkts': '32114099',
                                                                                       'mac_address': '60:22:32:6f:9e:63',
                                                                                       'out_octets': '64313838841',
                                                                                       'out_ucast_pkts': '49820135'}],
                                                              'mac_address': '68:d7:9a:1f:34:e9',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '347826774643',
                                                              'out_ucast_pkts': '273740332',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 69120,
                                                                                        'rx_link_rate': '1000000000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '507314',
                                                                                                                                            'distance': 792,
                                                                                                                                            'mac_address': '60:22:32:6f:9a:b9',
                                                                                                                                            'rssi': -46.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '507310',
                                                                                                                                            'distance': 744,
                                                                                                                                            'mac_address': '60:22:32:6f:9f:0f',
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '875875000'},
                                                                                                                                    {       'connected_time': '507188',
                                                                                                                                            'distance': 754,
                                                                                                                                            'mac_address': '60:22:32:6f:9e:fb',
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '507195',
                                                                                                                                            'distance': 690,
                                                                                                                                            'mac_address': '60:22:32:6f:9e:63',
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '1000000000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FRI-358'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.365435,
                                'longitude': -112.878838,
                                'manufacturer': 'Ubiquiti',
                                'mem': 31.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.2.0-beta',
                                'system_mac_address': '68:d7:9a:1f:34:e9',
                                'temperature': 18.0,
                                'uptime': '595191'},
                'peers': [       {       'cpu': 9.0,
                                         'elevation': 587.0,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '99469376082',
                                                                       'in_ucast_pkts': '80487731',
                                                                       'links': [       {       'in_octets': '99469376082',
                                                                                                'in_ucast_pkts': '80487731',
                                                                                                'mac_address': '68:d7:9a:1f:34:e9',
                                                                                                'out_octets': '13350088153',
                                                                                                'out_ucast_pkts': '63375359'}],
                                                                       'mac_address': '60:22:32:6f:9a:b9',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '13350088153',
                                                                       'out_ucast_pkts': '63375359',
                                                                       'poller_hash': 'NjAyMjMyNmY5YWI5d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 69120,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '507314',
                                                                                                                                                     'distance': 792,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:34:e9',
                                                                                                                                                     'rssi': -46.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-358'}],
                                                                       'type': 71},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmY5YWI5YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '11889840748',
                                                                       'in_ucast_pkts': '63107040',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '98588739336',
                                                                       'out_ucast_pkts': '79207920',
                                                                       'poller_hash': 'NjAyMjMyNmY5YWI5ZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.372266,
                                         'longitude': -112.880787,
                                         'management_ip': '100.70.98.3',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-McDonough_Connemara',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:9a:b9',
                                         'uptime': '520525'},
                                 {       'cpu': 10.0,
                                         'elevation': 589.1,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1002098236',
                                                                       'in_ucast_pkts': '2899700',
                                                                       'links': [       {       'in_octets': '1002098236',
                                                                                                'in_ucast_pkts': '2899700',
                                                                                                'mac_address': '68:d7:9a:1f:34:e9',
                                                                                                'out_octets': '179392582',
                                                                                                'out_ucast_pkts': '378535'}],
                                                                       'mac_address': '60:22:32:6f:9f:0f',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '179392582',
                                                                       'out_ucast_pkts': '378535',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZjBmd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 69120,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '507310',
                                                                                                                                                     'distance': 744,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:34:e9',
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-358'}],
                                                                       'type': 71},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZjBmYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '7558686',
                                                                       'in_ucast_pkts': '109339',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '127144962',
                                                                       'out_ucast_pkts': '1619028',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZjBmZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.371783,
                                         'longitude': -112.88088,
                                         'management_ip': '100.70.98.6',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 36.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-Basile_Andrew',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:9f:0f',
                                         'uptime': '513477'},
                                 {       'cpu': 11.0,
                                         'elevation': 584.7,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '149018624663',
                                                                       'in_ucast_pkts': '117657553',
                                                                       'links': [       {       'in_octets': '149018624663',
                                                                                                'in_ucast_pkts': '117657553',
                                                                                                'mac_address': '68:d7:9a:1f:34:e9',
                                                                                                'out_octets': '13105839638',
                                                                                                'out_ucast_pkts': '75754961'}],
                                                                       'mac_address': '60:22:32:6f:9e:fb',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '13105839638',
                                                                       'out_ucast_pkts': '75754961',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZWZid2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 69120,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '507188',
                                                                                                                                                     'distance': 754,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:34:e9',
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-358'}],
                                                                       'type': 71},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZWZiYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '11382568021',
                                                                       'in_ucast_pkts': '75484687',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '148128944750',
                                                                       'out_ucast_pkts': '116377350',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZWZiZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.371983,
                                         'longitude': -112.880132,
                                         'management_ip': '100.70.98.9',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-Jacobs_Nadele',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:9e:fb',
                                         'uptime': '513479'},
                                 {       'cpu': 10.0,
                                         'elevation': 589.6,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '64313838841',
                                                                       'in_ucast_pkts': '49820135',
                                                                       'links': [       {       'in_octets': '64313838841',
                                                                                                'in_ucast_pkts': '49820135',
                                                                                                'mac_address': '68:d7:9a:1f:34:e9',
                                                                                                'out_octets': '4684836551',
                                                                                                'out_ucast_pkts': '32114099'}],
                                                                       'mac_address': '60:22:32:6f:9e:63',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4684836551',
                                                                       'out_ucast_pkts': '32114099',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTYzd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 69120,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '507195',
                                                                                                                                                     'distance': 690,
                                                                                                                                                     'mac_address': '68:d7:9a:1f:34:e9',
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-358'}],
                                                                       'type': 71},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTYzYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '3753803632',
                                                                       'in_ucast_pkts': '31844234',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '63438554422',
                                                                       'out_ucast_pkts': '48539890',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZTYzZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.371283,
                                         'longitude': -112.880732,
                                         'management_ip': '100.70.98.10',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 36.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-Bressler_Katrisha',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:9e:63',
                                         'uptime': '513479'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_2_0_beta_05(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.2.0-beta.05")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 2160,
                'rf_freq': 66960,
                'rf_tx_power': 20,
                'sta_count': 3,
                'sta_mode_cpe': False,
                'sw_version': 'v3.2.0-beta',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 9979192796781,
                'dl_en_packets': 7264119959,
                'dl_noise_floor': None,
                'dl_rf_bytes': 10115808871283,
                'dl_rf_packets': 7334058375,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 693662423159,
                'ul_en_packets': 5478874230,
                'ul_noise_floor': None,
                'ul_rf_bytes': 685387609364,
                'ul_rf_packets': 5500451224
        }
        exp_sta_stats = {
                '60:22:32:6f:9e:8d': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 7579758360830,
                                             'dl_rf_packets': 5531614846,
                                             'dl_rssi': -57.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.8.116',
                                             'mac_address': '60:22:32:6f:9e:8d',
                                             'name': 'Wave-Morondeast',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 585534010758,
                                             'ul_rf_packets': 4048105171,
                                             'ul_rssi': -57.0,
                                             'ul_snr': None},
                '60:22:32:6f:a3:51': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1545247591523,
                                             'dl_rf_packets': 1133597048,
                                             'dl_rssi': -62.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.8.114',
                                             'mac_address': '60:22:32:6f:a3:51',
                                             'name': 'Wave-Martinez_Adriana',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 110524980183,
                                             'ul_rf_packets': 881774357,
                                             'ul_rssi': -62.0,
                                             'ul_snr': None},
                '60:22:32:6f:ab:9f': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 848022062363,
                                             'dl_rf_packets': 664985179,
                                             'dl_rssi': -54.0,
                                             'dl_snr': None,
                                             'ip_address': '100.70.8.117',
                                             'mac_address': '60:22:32:6f:ab:9f',
                                             'name': 'Wave-Thompson_Tina',
                                             'ul_link_rate': 1000000000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 75143294442,
                                             'ul_rf_packets': 549909182,
                                             'ul_rssi': -53.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 19.0,
                                'elevation': 756.3,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '9979192796781',
                                                              'in_ucast_pkts': '7264119959',
                                                              'mac_address': '60:22:32:39:4d:33',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '693662423159',
                                                              'out_ucast_pkts': '5478874230',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NjAyMjMyMzk0ZDMzZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_octets': '1353',
                                                              'in_ucast_pkts': '147',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '1589656917',
                                                              'out_ucast_pkts': '24528294',
                                                              'poller_hash': 'NjAyMjMyMzk0ZDMyYXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '685387608011',
                                                              'in_ucast_pkts': '5500451077',
                                                              'links': [       {       'in_octets': '75143294442',
                                                                                       'in_ucast_pkts': '549909182',
                                                                                       'mac_address': '60:22:32:6f:ab:9f',
                                                                                       'out_octets': '848022062363',
                                                                                       'out_ucast_pkts': '664985179'},
                                                                               {       'in_octets': '585534010758',
                                                                                       'in_ucast_pkts': '4048105171',
                                                                                       'mac_address': '60:22:32:6f:9e:8d',
                                                                                       'out_octets': '7579758360830',
                                                                                       'out_ucast_pkts': '5531614846'},
                                                                               {       'in_octets': '110524980183',
                                                                                       'in_ucast_pkts': '881774357',
                                                                                       'mac_address': '60:22:32:6f:a3:51',
                                                                                       'out_octets': '1545247591523',
                                                                                       'out_ucast_pkts': '1133597048'}],
                                                              'mac_address': '60:22:32:39:4d:32',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '10114219214366',
                                                              'out_ucast_pkts': '7309530081',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 66960,
                                                                                        'rx_link_rate': '2700000000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '3452460',
                                                                                                                                            'distance': 2074,
                                                                                                                                            'mac_address': '60:22:32:6f:ab:9f',
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '3452614',
                                                                                                                                            'distance': 1732,
                                                                                                                                            'mac_address': '60:22:32:6f:9e:8d',
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'},
                                                                                                                                    {       'connected_time': '3454196',
                                                                                                                                            'distance': 1636,
                                                                                                                                            'mac_address': '60:22:32:6f:a3:51',
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '1000000000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '2156000000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FRI-060-5.5'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.36545,
                                'longitude': -112.878834,
                                'manufacturer': 'Ubiquiti',
                                'mem': 41.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.2.0-beta',
                                'system_mac_address': '60:22:32:39:4d:32',
                                'temperature': 54.0,
                                'uptime': '3454695'},
                'peers': [       {       'cpu': 14.0,
                                         'elevation': 521.0,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '848022062363',
                                                                       'in_ucast_pkts': '664985179',
                                                                       'links': [       {       'in_octets': '848022062363',
                                                                                                'in_ucast_pkts': '664985179',
                                                                                                'mac_address': '60:22:32:39:4d:32',
                                                                                                'out_octets': '75143294442',
                                                                                                'out_ucast_pkts': '549909182'}],
                                                                       'mac_address': '60:22:32:6f:ab:9f',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '75143294442',
                                                                       'out_ucast_pkts': '549909182',
                                                                       'poller_hash': 'NjAyMjMyNmZhYjlmd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 66960,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3452460',
                                                                                                                                                     'distance': 2074,
                                                                                                                                                     'mac_address': '60:22:32:39:4d:32',
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-060-5.5'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '1584563160',
                                                                       'in_ucast_pkts': '24450609',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '7027',
                                                                       'out_ucast_pkts': '50',
                                                                       'poller_hash': 'NjAyMjMyNmZhYjlmYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '65187501022',
                                                                       'in_ucast_pkts': '565203218',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '866245197355',
                                                                       'out_ucast_pkts': '676380581',
                                                                       'poller_hash': 'NjAyMjMyNmZhYjlmZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.377277,
                                         'longitude': -112.861913,
                                         'management_ip': '100.70.8.117',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-LR',
                                         'name': 'Wave-Thompson_Tina',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta2',
                                         'system_mac_address': '60:22:32:6f:ab:9f',
                                         'uptime': '3537117'},
                                 {       'cpu': 12.0,
                                         'elevation': 540.5,
                                         'gps_sats_tracked': 9,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '7579758360830',
                                                                       'in_ucast_pkts': '5531614846',
                                                                       'links': [       {       'in_octets': '7579758360830',
                                                                                                'in_ucast_pkts': '5531614846',
                                                                                                'mac_address': '60:22:32:39:4d:32',
                                                                                                'out_octets': '585534010758',
                                                                                                'out_ucast_pkts': '4048105171'}],
                                                                       'mac_address': '60:22:32:6f:9e:8d',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '585534010758',
                                                                       'out_ucast_pkts': '4048105171',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZThkd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 66960,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3452614',
                                                                                                                                                     'distance': 1732,
                                                                                                                                                     'mac_address': '60:22:32:39:4d:32',
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-060-5.5'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '1581423518',
                                                                       'in_ucast_pkts': '24402361',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '6499',
                                                                       'out_ucast_pkts': '44',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZThkYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '519270884640',
                                                                       'in_ucast_pkts': '4126247622',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '7741018963891',
                                                                       'out_ucast_pkts': '5644814700',
                                                                       'poller_hash': 'NjAyMjMyNmY5ZThkZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.373539,
                                         'longitude': -112.863202,
                                         'management_ip': '100.70.8.116',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-Morondeast',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta2',
                                         'system_mac_address': '60:22:32:6f:9e:8d',
                                         'uptime': '3537114'},
                                 {       'cpu': 12.0,
                                         'elevation': 539.2,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '1545247591523',
                                                                       'in_ucast_pkts': '1133597048',
                                                                       'links': [       {       'in_octets': '1545247591523',
                                                                                                'in_ucast_pkts': '1133597048',
                                                                                                'mac_address': '60:22:32:39:4d:32',
                                                                                                'out_octets': '110524980183',
                                                                                                'out_ucast_pkts': '881774357'}],
                                                                       'mac_address': '60:22:32:6f:a3:51',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '110524980183',
                                                                       'out_ucast_pkts': '881774357',
                                                                       'poller_hash': 'NjAyMjMyNmZhMzUxd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'frequency': 66960,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3454196',
                                                                                                                                                     'distance': 1636,
                                                                                                                                                     'mac_address': '60:22:32:39:4d:32',
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '1000000000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FRI-060-5.5'}],
                                                                       'type': 71},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '1576728973',
                                                                       'in_ucast_pkts': '24328584',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyNmZhMzUxYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '106877276260',
                                                                       'in_ucast_pkts': '1006413236',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1749076807194',
                                                                       'out_ucast_pkts': '1279884272',
                                                                       'poller_hash': 'NjAyMjMyNmZhMzUxZXRoMA==',
                                                                       'speed': '1000000000'}],
                                         'latitude': 32.375572,
                                         'longitude': -112.866382,
                                         'management_ip': '100.70.8.114',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Wave-Martinez_Adriana',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': '60:22:32:6f:a3:51',
                                         'uptime': '4042913'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_2_0_beta2_01(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.2.0-beta2.01")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 68040,
                'rf_tx_power': 20,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': 'v3.2.0-beta2',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 1117821933,
                'dl_en_packets': 12474113,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 101099118,
                'ul_en_packets': 864101,
                'ul_noise_floor': None,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 2.0,
                                'elevation': 1039.4,
                                'gps_sats_tracked': 11,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '1117821933',
                                                              'in_ucast_pkts': '12474113',
                                                              'mac_address': '70:a7:41:cd:d9:89',
                                                              'mtu': 1560,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '101099118',
                                                              'out_ucast_pkts': '864101',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '5',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1560,
                                                              'name': 'ath0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NzBhNzQxY2RkOTg4YXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '8',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1560,
                                                              'name': 'eth1',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NzBhNzQxY2RkOTg5ZXRoMQ==',
                                                              'speed': '1110490560',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '2',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mac_address': '70:a7:41:cd:d9:88',
                                                              'mtu': 1560,
                                                              'name': 'wlan0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Tx4.60ENE'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 32.68306,
                                'longitude': -102.673852,
                                'manufacturer': 'Ubiquiti',
                                'mem': 41.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.2.0-beta2',
                                'system_mac_address': '70:a7:41:cd:d9:88',
                                'temperature': 53.0,
                                'uptime': '217209'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_AP_v3_2_0_beta5_01(self):
        obj = self.run_data("ubnt.wave-ap.Wave AP.v3.2.0-beta5.01")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave AP',
                'rf_chan_width': 1080,
                'rf_freq': 69120,
                'rf_tx_power': 20,
                'sta_count': 2,
                'sta_mode_cpe': False,
                'sw_version': 'v3.2.0-beta5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 1102964181524,
                'dl_en_packets': 877326424,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1129291023388,
                'dl_rf_packets': 1007153353,
                'en_if_speed': 10000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 91783422617,
                'ul_en_packets': 272536768,
                'ul_noise_floor': None,
                'ul_rf_bytes': 92518434470,
                'ul_rf_packets': 274586381
        }
        exp_sta_stats = {
                'd0:21:f9:d8:8f:5d': {       'alt_macs': {'d0:21:f9:d9:8f:5d'},
                                             'dev_macs': ['60:22:32:93:b2:f1'],
                                             'dl_link_rate': 808500000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 617714004916,
                                             'dl_rf_packets': 514671948,
                                             'dl_rssi': -69.0,
                                             'dl_snr': None,
                                             'ip_address': '10.60.105.193',
                                             'mac_address': 'd0:21:f9:d8:8f:5d',
                                             'name': 'Michael Luttkus',
                                             'ul_link_rate': 808500000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 53319245312,
                                             'ul_rf_packets': 151048219,
                                             'ul_rssi': -63.0,
                                             'ul_snr': None},
                'e4:38:83:58:37:c3': {       'alt_macs': {'e4:38:83:59:37:c3'},
                                             'dev_macs': ['00:31:92:f6:a0:c4'],
                                             'dl_link_rate': 1000000000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 51374682731,
                                             'dl_rf_packets': 108118976,
                                             'dl_rssi': -53.0,
                                             'dl_snr': None,
                                             'ip_address': '10.60.104.237',
                                             'mac_address': 'e4:38:83:58:37:c3',
                                             'name': 'Terry Johnson',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 11936955250,
                                             'ul_rf_packets': 19678457,
                                             'ul_rssi': -52.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 11.0,
                                'elevation': 312.3,
                                'gps_sats_tracked': 3,
                                'interfaces': [       {       'admin_up': False,
                                                              'id': '7',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': False,
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NzBhNzQxY2RkOWE5ZXRoMA==',
                                                              'speed': '10000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '5',
                                                              'in_octets': '561754',
                                                              'in_ucast_pkts': '1770',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '5050629437',
                                                              'out_ucast_pkts': '65364558',
                                                              'poller_hash': 'NzBhNzQxY2RkOWE4YXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_octets': '1102964181524',
                                                              'in_ucast_pkts': '877326424',
                                                              'mac_address': '70:a7:41:cd:d9:a9',
                                                              'mtu': 1500,
                                                              'name': 'eth1',
                                                              'oper_up': True,
                                                              'out_octets': '91783422617',
                                                              'out_ucast_pkts': '272536768',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_octets': '92517872716',
                                                              'in_ucast_pkts': '274584611',
                                                              'links': [       {       'bridged_mac_addresses': [       '60:22:32:93:b2:f1'],
                                                                                       'in_octets': '53319245312',
                                                                                       'in_ucast_pkts': '151048219',
                                                                                       'mac_address': 'd0:21:f9:d8:8f:5d',
                                                                                       'out_octets': '617714004916',
                                                                                       'out_ucast_pkts': '514671948'},
                                                                               {       'bridged_mac_addresses': [       '00:31:92:f6:a0:c4'],
                                                                                       'in_octets': '11936955250',
                                                                                       'in_ucast_pkts': '19678457',
                                                                                       'mac_address': 'e4:38:83:58:37:c3',
                                                                                       'out_octets': '51374682731',
                                                                                       'out_ucast_pkts': '108118976'}],
                                                              'mac_address': '70:a7:41:cd:d9:a8',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '1124240393951',
                                                              'out_ucast_pkts': '941788795',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 69120,
                                                                                        'rx_link_rate': '875875000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '334399',
                                                                                                                                            'distance': 284,
                                                                                                                                            'mac_address': 'd0:21:f9:d8:8f:5d',
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '808500000',
                                                                                                                                            'tx_link_rate': '808500000'},
                                                                                                                                    {       'connected_time': '911229',
                                                                                                                                            'distance': 686,
                                                                                                                                            'mac_address': 'e4:38:83:58:37:c3',
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '1000000000'}]}],
                                                                                        'tx_link_rate': '1617000000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '55'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 33.842918,
                                'longitude': -98.587981,
                                'manufacturer': 'Ubiquiti',
                                'mem': 42.0,
                                'model': 'Wave AP',
                                'sw_version': 'v3.2.0-beta5',
                                'system_mac_address': '70:a7:41:cd:d9:a8',
                                'temperature': 56.0,
                                'uptime': '913779'},
                'peers': [       {       'cpu': 14.0,
                                         'elevation': 303.3,
                                         'gps_sats_tracked': 11,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '60:22:32:93:b2:f1'],
                                                                       'id': '1',
                                                                       'in_octets': '49654497955',
                                                                       'in_ucast_pkts': '149503369',
                                                                       'mac_address': 'd0:21:f9:d9:8f:5d',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '615960048188',
                                                                       'out_ucast_pkts': '512240983',
                                                                       'poller_hash': 'ZDAyMWY5ZDg4ZjVkZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '3092129069',
                                                                       'in_ucast_pkts': '48558684',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '621756',
                                                                       'out_ucast_pkts': '1748',
                                                                       'poller_hash': 'ZDAyMWY5ZDg4ZjVkYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '617714004916',
                                                                       'in_ucast_pkts': '514671948',
                                                                       'links': [       {       'in_octets': '617714004916',
                                                                                                'in_ucast_pkts': '514671948',
                                                                                                'mac_address': '70:a7:41:cd:d9:a8',
                                                                                                'out_octets': '53319245312',
                                                                                                'out_ucast_pkts': '151048219'}],
                                                                       'mac_address': 'd0:21:f9:d8:8f:5d',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '53319245312',
                                                                       'out_ucast_pkts': '151048219',
                                                                       'poller_hash': 'ZDAyMWY5ZDg4ZjVkd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 69120,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '334399',
                                                                                                                                                     'distance': 284,
                                                                                                                                                     'mac_address': '70:a7:41:cd:d9:a8',
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '808500000',
                                                                                                                                                     'tx_link_rate': '808500000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '55'}],
                                                                       'type': 71}],
                                         'latitude': 33.844178,
                                         'longitude': -98.585379,
                                         'management_ip': '10.60.105.193',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Michael Luttkus',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta5',
                                         'system_mac_address': 'd0:21:f9:d8:8f:5d',
                                         'uptime': '779408'},
                                 {       'cpu': 13.0,
                                         'elevation': 309.0,
                                         'gps_sats_tracked': 8,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'bridged_mac_addresses': [       '00:31:92:f6:a0:c4'],
                                                                       'id': '1',
                                                                       'in_octets': '10816090661',
                                                                       'in_ucast_pkts': '18046718',
                                                                       'mac_address': 'e4:38:83:59:37:c3',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '49397879648',
                                                                       'out_ucast_pkts': '105229490',
                                                                       'poller_hash': 'ZTQzODgzNTgzN2MzZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '4123999488',
                                                                       'in_ucast_pkts': '65010150',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '1886',
                                                                       'out_ucast_pkts': '13',
                                                                       'poller_hash': 'ZTQzODgzNTgzN2MzYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '51374682731',
                                                                       'in_ucast_pkts': '108118976',
                                                                       'links': [       {       'in_octets': '51374682731',
                                                                                                'in_ucast_pkts': '108118976',
                                                                                                'mac_address': '70:a7:41:cd:d9:a8',
                                                                                                'out_octets': '11936955250',
                                                                                                'out_ucast_pkts': '19678457'}],
                                                                       'mac_address': 'e4:38:83:58:37:c3',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '11936955250',
                                                                       'out_ucast_pkts': '19678457',
                                                                       'poller_hash': 'ZTQzODgzNTgzN2Mzd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 69120,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '911229',
                                                                                                                                                     'distance': 686,
                                                                                                                                                     'mac_address': '70:a7:41:cd:d9:a8',
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '1000000000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '55'}],
                                                                       'type': 71}],
                                         'latitude': 33.847356,
                                         'longitude': -98.582806,
                                         'management_ip': '10.60.104.237',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 37.0,
                                         'model': 'Wave-Nano',
                                         'name': 'Terry Johnson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta5',
                                         'system_mac_address': 'e4:38:83:58:37:c3',
                                         'uptime': '911364'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_Long_Range_v3_2_0_beta5_01(self):
        obj = self.run_data("ubnt.wave-ap.Wave Long-Range.v3.2.0-beta5.01")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave Long-Range',
                'rf_chan_width': 1080,
                'rf_freq': 68040,
                'rf_tx_power': 20,
                'sta_count': 1,
                'sta_mode_cpe': True,
                'sw_version': 'v3.2.0-beta5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 9373477,
                'dl_en_packets': 55161,
                'dl_noise_floor': None,
                'dl_rf_bytes': 242103853,
                'dl_rf_packets': 412679,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 161341928,
                'ul_en_packets': 1436858,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1003235782,
                'ul_rf_packets': 3907798
        }
        exp_sta_stats = {
                '60:22:32:35:e0:e8': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 808500000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 8037525364,
                                             'dl_rf_packets': 9791291,
                                             'dl_rssi': -64.0,
                                             'dl_snr': None,
                                             'ip_address': '10.10.60.26',
                                             'mac_address': '60:22:32:35:e0:e8',
                                             'name': 'EHQ - Wave SE AP',
                                             'ul_link_rate': 404250000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 2383506741,
                                             'ul_rf_packets': 15031129,
                                             'ul_rssi': -68.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 25.0,
                                'elevation': 270.7,
                                'gps_sats_tracked': 9,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '3',
                                                              'in_octets': '9373477',
                                                              'in_ucast_pkts': '55161',
                                                              'mac_address': '60:22:32:6f:b2:0e',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '161341928',
                                                              'out_ucast_pkts': '1436858',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '7',
                                                              'in_octets': '152045391',
                                                              'in_ucast_pkts': '1385491',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '158497',
                                                              'out_ucast_pkts': '235',
                                                              'poller_hash': 'NjAyMjMyNmZiMjBkYXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '4',
                                                              'in_octets': '851190391',
                                                              'in_ucast_pkts': '2522307',
                                                              'links': [       {       'in_octets': '2383506741',
                                                                                       'in_ucast_pkts': '15031129',
                                                                                       'mac_address': '60:22:32:35:e0:e8',
                                                                                       'out_octets': '8037525364',
                                                                                       'out_ucast_pkts': '9791291'}],
                                                              'mac_address': '60:22:32:6f:b2:0d',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '241945356',
                                                              'out_ucast_pkts': '412444',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 68040,
                                                                                        'rx_link_rate': '404250000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '255239',
                                                                                                                                            'distance': 2255,
                                                                                                                                            'mac_address': '60:22:32:35:e0:e8',
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '404250000',
                                                                                                                                            'tx_link_rate': '808500000'}]}],
                                                                                        'tx_link_rate': '808500000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'ehq-wave-ap-se'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 43.220252,
                                'longitude': -88.121285,
                                'manufacturer': 'Ubiquiti',
                                'mem': 37.0,
                                'model': 'Wave Long-Range',
                                'sw_version': 'v3.2.0-beta5',
                                'system_mac_address': '60:22:32:6f:b2:0d',
                                'temperature': 48.0,
                                'uptime': '366214'},
                'peers': [       {       'cpu': 9.0,
                                         'elevation': 336.3,
                                         'gps_sats_tracked': 10,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '2608821253',
                                                                       'in_ucast_pkts': '17655201',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '4392385692',
                                                                       'out_ucast_pkts': '6074189',
                                                                       'poller_hash': 'NjAyMjMyMzVlMGU4ZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': False,
                                                                       'id': '2',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mtu': 1500,
                                                                       'name': 'eth1',
                                                                       'oper_up': False,
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'NjAyMjMyMzVlMGU4ZXRoMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '9210291',
                                                                       'in_ucast_pkts': '9434',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '1178509955',
                                                                       'out_ucast_pkts': '10644684',
                                                                       'poller_hash': 'NjAyMjMyMzVlMGU4YXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '4',
                                                                       'in_octets': '8037525364',
                                                                       'in_ucast_pkts': '9791291',
                                                                       'links': [       {       'in_octets': '8037525364',
                                                                                                'in_ucast_pkts': '9791291',
                                                                                                'mac_address': '60:22:32:6f:b2:0d',
                                                                                                'out_octets': '2383506741',
                                                                                                'out_ucast_pkts': '15031129'}],
                                                                       'mac_address': '60:22:32:35:e0:e8',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2383506741',
                                                                       'out_ucast_pkts': '15031129',
                                                                       'poller_hash': 'NjAyMjMyMzVlMGU4d2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 68040,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '255239',
                                                                                                                                                     'distance': 2255,
                                                                                                                                                     'mac_address': '60:22:32:6f:b2:0d',
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '808500000',
                                                                                                                                                     'tx_link_rate': '404250000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'ehq-wave-ap-se'}],
                                                                       'type': 71}],
                                         'latitude': 43.228078,
                                         'longitude': -88.146842,
                                         'management_ip': '10.10.60.26',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 41.0,
                                         'model': 'Wave-AP',
                                         'name': 'EHQ - Wave SE AP',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta5',
                                         'system_mac_address': '60:22:32:35:e0:e8',
                                         'uptime': '2571218'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_wave_ap_Wave_Nano_v3_2_0_beta_01(self):
        obj = self.run_data("ubnt.wave-ap.Wave Nano.v3.2.0-beta.01")
        exp_info = {
                'gps_sync': None,
                'model': 'Wave Nano',
                'rf_chan_width': 1080,
                'rf_freq': 58320,
                'rf_tx_power': 20,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': 'v3.2.0-beta',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
                'cpu': None,
                'dl_en_bytes': 1932864539388,
                'dl_en_packets': 3654129487,
                'dl_noise_floor': None,
                'dl_rf_bytes': 2036709089727,
                'dl_rf_packets': 3639838178,
                'en_if_speed': 1000000000,
                'gps_sats_tracked': None,
                'ul_en_bytes': 108849068288,
                'ul_en_packets': 460032965,
                'ul_noise_floor': None,
                'ul_rf_bytes': 116063065608,
                'ul_rf_packets': 464362241
        }
        exp_sta_stats = {
                'ac:8b:a9:53:91:d1': {       'alt_macs': set(),
                                             'dev_macs': set(),
                                             'dl_link_rate': 875875000,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 809636635313,
                                             'dl_rf_packets': 2045673202,
                                             'dl_rssi': -46.0,
                                             'dl_snr': None,
                                             'ip_address': '10.100.14.153',
                                             'mac_address': 'ac:8b:a9:53:91:d1',
                                             'name': 'SFisher-679812',
                                             'ul_link_rate': 875875000,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': 61008872795,
                                             'ul_rf_packets': 206344119,
                                             'ul_rssi': -49.0,
                                             'ul_snr': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 13.0,
                                'elevation': 799.8,
                                'gps_sats_tracked': 12,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '3',
                                                              'in_octets': '1932864539388',
                                                              'in_ucast_pkts': '3654129487',
                                                              'mac_address': '60:22:32:6f:a1:d2',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_octets': '108849068288',
                                                              'out_ucast_pkts': '460032965',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '26',
                                                              'in_octets': '3217731',
                                                              'in_ucast_pkts': '23052',
                                                              'mtu': 1500,
                                                              'name': 'ath0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'poller_hash': 'NjAyMjMyNmZhMWQxYXRoMA==',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '23',
                                                              'in_octets': '116059847877',
                                                              'in_ucast_pkts': '464339189',
                                                              'links': [       {       'in_octets': '61008872795',
                                                                                       'in_ucast_pkts': '206344119',
                                                                                       'mac_address': 'ac:8b:a9:53:91:d1',
                                                                                       'out_octets': '809636635313',
                                                                                       'out_ucast_pkts': '2045673202'}],
                                                              'mac_address': '60:22:32:6f:a1:d1',
                                                              'mtu': 1500,
                                                              'name': 'wlan0',
                                                              'oper_up': True,
                                                              'out_octets': '2036709089727',
                                                              'out_ucast_pkts': '3639838178',
                                                              'radios': [       {       'chan_width': 1080,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'rx_link_rate': '875875000',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '3950258',
                                                                                                                                            'distance': 54,
                                                                                                                                            'mac_address': 'ac:8b:a9:53:91:d1',
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '875875000',
                                                                                                                                            'tx_link_rate': '875875000'}]}],
                                                                                        'tx_link_rate': '875875000',
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MLWR2SFISHER'}],
                                                              'speed': '1000000000',
                                                              'type': 71}],
                                'latitude': 47.587262,
                                'longitude': -117.667054,
                                'manufacturer': 'Ubiquiti',
                                'mem': 38.0,
                                'model': 'Wave Nano',
                                'sw_version': 'v3.2.0-beta',
                                'system_mac_address': '60:22:32:6f:a1:d1',
                                'temperature': 49.0,
                                'uptime': '6303686'},
                'peers': [       {       'cpu': 14.0,
                                         'elevation': 796.3,
                                         'gps_sats_tracked': 12,
                                         'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_octets': '100100059282',
                                                                       'in_ucast_pkts': '437946532',
                                                                       'mtu': 1500,
                                                                       'name': 'eth0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1904955468132',
                                                                       'out_ucast_pkts': '3561567309',
                                                                       'poller_hash': 'YWM4YmE5NTM5MWQxZXRoMA==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '2',
                                                                       'in_octets': '99172016',
                                                                       'in_ucast_pkts': '117829',
                                                                       'mtu': 1500,
                                                                       'name': 'ath0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'YWM4YmE5NTM5MWQxYXRoMA=='},
                                                               {       'admin_up': True,
                                                                       'id': '3',
                                                                       'in_octets': '809636635313',
                                                                       'in_ucast_pkts': '2045673202',
                                                                       'links': [       {       'in_octets': '809636635313',
                                                                                                'in_ucast_pkts': '2045673202',
                                                                                                'mac_address': '60:22:32:6f:a1:d1',
                                                                                                'out_octets': '61008872795',
                                                                                                'out_ucast_pkts': '206344119'}],
                                                                       'mac_address': 'ac:8b:a9:53:91:d1',
                                                                       'mtu': 1500,
                                                                       'name': 'wlan0',
                                                                       'oper_up': True,
                                                                       'out_octets': '61008872795',
                                                                       'out_ucast_pkts': '206344119',
                                                                       'poller_hash': 'YWM4YmE5NTM5MWQxd2xhbjA=',
                                                                       'radios': [       {       'chan_width': 1080,
                                                                                                 'frequency': 58320,
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3950258',
                                                                                                                                                     'distance': 54,
                                                                                                                                                     'mac_address': '60:22:32:6f:a1:d1',
                                                                                                                                                     'rssi': -46.0,
                                                                                                                                                     'rx_link_rate': '875875000',
                                                                                                                                                     'tx_link_rate': '875875000'}]}],
                                                                                                 'tx_power': 20}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MLWR2SFISHER'}],
                                                                       'type': 71}],
                                         'latitude': 47.587157,
                                         'longitude': -117.667858,
                                         'management_ip': '10.100.14.153',
                                         'manufacturer': 'Ubiquiti',
                                         'mem': 38.0,
                                         'model': 'Wave-Nano',
                                         'name': 'SFisher-679812',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '3.2.0-beta',
                                         'system_mac_address': 'ac:8b:a9:53:91:d1',
                                         'uptime': '6132843'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
