import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCanopyModels(DeviceTestCase):

    def test_cambium_canopy_450m_PMP_450m_15_1_2_01(self):
        obj = self.run_data("cambium-canopy.450m.PMP 450m.15.1.2.01")
        exp_info = {
                'model': 'PMP 450m',
                'rf_chan_width': 20,
                'rf_dl_percent': 75,
                'rf_freq': 5755,
                'rf_tx_power': 20,
                'sta_count': 26,
                'sw_version': 'CANOPY 15.1.2 AP-DES',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'dl_en_bytes': 3416530726372,
                'dl_en_packets': 2545345020,
                'dl_frutl': 39.0,
                'dl_multiplexing_gain': 0.99,
                'dl_noise_floor': None,
                'dl_rf_bytes': 206902390739,
                'dl_rf_packets': 1420518512,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 206902390739,
                'ul_en_packets': 1420518512,
                'ul_frutl': 28.0,
                'ul_multiplexing_gain': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 3416530726372,
                'ul_rf_packets': 2545345020,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
                '0a:00:3e:29:1a:c1': {       'alt_macs': {       '1a:00:3e:29:1a:c1',
                                                                 '2a:00:3e:29:1a:c1',
                                                                 '3a:00:3e:29:1a:c1',
                                                                 '4a:00:3e:29:1a:c1'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 0,
                                             'dl_link_rate': 22937600,
                                             'dl_mcs': 2,
                                             'dl_modulation_rate': 0,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2148962426,
                                             'dl_rf_packets': 4480248,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.21.12',
                                             'mac_address': '0a:00:3e:29:1a:c1',
                                             'name': 'Sarai Trevino - 2324',
                                             'ul_exp_modulation_rate': 0,
                                             'ul_link_rate': None,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 0,
                                             'ul_noise_floor': -100.0,
                                             'ul_rf_bytes': 291391811,
                                             'ul_rf_packets': 3067560,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -80.0,
                                             'ul_snr': 20.0},
                '0a:00:3e:29:20:db': {       'alt_macs': {       '1a:00:3e:29:20:db',
                                                                 '2a:00:3e:29:20:db',
                                                                 '3a:00:3e:29:20:db',
                                                                 '4a:00:3e:29:20:db'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 0,
                                             'dl_link_rate': 22937600,
                                             'dl_mcs': 2,
                                             'dl_modulation_rate': 0,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 10648239,
                                             'dl_rf_packets': 13239,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.20.82',
                                             'mac_address': '0a:00:3e:29:20:db',
                                             'name': 'Patricia Hinojos - 2283',
                                             'ul_exp_modulation_rate': 0,
                                             'ul_link_rate': None,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 0,
                                             'ul_noise_floor': -102.85,
                                             'ul_rf_bytes': 4369430,
                                             'ul_rf_packets': 30486,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -75.85,
                                             'ul_snr': 27.0},
                '0a:00:3e:a1:69:12': {       'alt_macs': {       '1a:00:3e:a1:69:12',
                                                                 '2a:00:3e:a1:69:12',
                                                                 '3a:00:3e:a1:69:12',
                                                                 '4a:00:3e:a1:69:12'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 45875200,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3806858652,
                                             'dl_rf_packets': 93130774,
                                             'dl_rf_packets_dropped': 3939,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.15.24',
                                             'mac_address': '0a:00:3e:a1:69:12',
                                             'name': 'Mary Trevino - 1558',
                                             'ul_exp_modulation_rate': 600,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -101.9,
                                             'ul_rf_bytes': 684725383,
                                             'ul_rf_packets': 49804491,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -74.4,
                                             'ul_snr': 27.5},
                '0a:00:3e:a2:66:d0': {       'alt_macs': {       '1a:00:3e:a2:66:d0',
                                                                 '2a:00:3e:a2:66:d0',
                                                                 '3a:00:3e:a2:66:d0',
                                                                 '4a:00:3e:a2:66:d0'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 0,
                                             'dl_link_rate': 22937600,
                                             'dl_mcs': 2,
                                             'dl_modulation_rate': 0,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 969800559,
                                             'dl_rf_packets': 836594,
                                             'dl_rf_packets_dropped': 92,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.21.64',
                                             'mac_address': '0a:00:3e:a2:66:d0',
                                             'name': 'Ruben Gutierrez - 2351',
                                             'ul_exp_modulation_rate': 0,
                                             'ul_link_rate': None,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 0,
                                             'ul_noise_floor': -96.7,
                                             'ul_rf_bytes': 201897945,
                                             'ul_rf_packets': 1125789,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -78.2,
                                             'ul_snr': 18.5},
                '0a:00:3e:a2:a5:d2': {       'alt_macs': {       '1a:00:3e:a2:a5:d2',
                                                                 '2a:00:3e:a2:a5:d2',
                                                                 '3a:00:3e:a2:a5:d2',
                                                                 '4a:00:3e:a2:a5:d2'},
                                             'dev_macs': {'00:04:56:12:3b:41'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 34997618,
                                             'dl_rf_packets': 204123,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.11.10',
                                             'mac_address': '0a:00:3e:a2:a5:d2',
                                             'name': 'James Newton - 1122',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19456000,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 550,
                                             'ul_noise_floor': -97.55000000000001,
                                             'ul_rf_bytes': 137526401,
                                             'ul_rf_packets': 931052,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -68.55000000000001,
                                             'ul_snr': 29.0},
                '0a:00:3e:a2:b3:f9': {       'alt_macs': {       '1a:00:3e:a2:b3:f9',
                                                                 '2a:00:3e:a2:b3:f9',
                                                                 '3a:00:3e:a2:b3:f9',
                                                                 '4a:00:3e:a2:b3:f9'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 45875200,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 537865602,
                                             'dl_rf_packets': 47236428,
                                             'dl_rf_packets_dropped': 28775,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.9.83',
                                             'mac_address': '0a:00:3e:a2:b3:f9',
                                             'name': 'Henry Harms - 985',
                                             'ul_exp_modulation_rate': 600,
                                             'ul_link_rate': 7782400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 200,
                                             'ul_noise_floor': -87.65,
                                             'ul_rf_bytes': 1322491548,
                                             'ul_rf_packets': 30205997,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -73.65,
                                             'ul_snr': 14.0},
                '0a:00:3e:a2:b4:ea': {       'alt_macs': {       '1a:00:3e:a2:b4:ea',
                                                                 '2a:00:3e:a2:b4:ea',
                                                                 '3a:00:3e:a2:b4:ea',
                                                                 '4a:00:3e:a2:b4:ea'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 34406400,
                                             'dl_mcs': 3,
                                             'dl_modulation_rate': 300,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 29211238,
                                             'dl_rf_packets': 38013,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.18.6',
                                             'mac_address': '0a:00:3e:a2:b4:ea',
                                             'name': 'Danny Mcllwain - 1872',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 15564800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 400,
                                             'ul_noise_floor': -90.6,
                                             'ul_rf_bytes': 25844620,
                                             'ul_rf_packets': 103799,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -70.6,
                                             'ul_snr': 20.0},
                '0a:00:3e:b2:87:22': {       'alt_macs': {       '1a:00:3e:b2:87:22',
                                                                 '2a:00:3e:b2:87:22',
                                                                 '3a:00:3e:b2:87:22',
                                                                 '4a:00:3e:b2:87:22'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 909893639,
                                             'dl_rf_packets': 53567822,
                                             'dl_rf_packets_dropped': 6078,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.21.84',
                                             'mac_address': '0a:00:3e:b2:87:22',
                                             'name': 'Farmboys Truck and Auto Service '
                                                     '- 2444',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 31129600,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -96.9,
                                             'ul_rf_bytes': 3945467782,
                                             'ul_rf_packets': 29600632,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -62.4,
                                             'ul_snr': 34.5},
                '0a:00:3e:b2:87:41': {       'alt_macs': {       '1a:00:3e:b2:87:41',
                                                                 '2a:00:3e:b2:87:41',
                                                                 '3a:00:3e:b2:87:41',
                                                                 '4a:00:3e:b2:87:41'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 550,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2630279513,
                                             'dl_rf_packets': 29605705,
                                             'dl_rf_packets_dropped': 687,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.9.52',
                                             'mac_address': '0a:00:3e:b2:87:41',
                                             'name': 'Jacob Berg - 954',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -98.75,
                                             'ul_rf_bytes': 1596389344,
                                             'ul_rf_packets': 15433971,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -72.25,
                                             'ul_snr': 26.5},
                '0a:00:3e:b2:d2:dc': {       'alt_macs': {       '1a:00:3e:b2:d2:dc',
                                                                 '2a:00:3e:b2:d2:dc',
                                                                 '3a:00:3e:b2:d2:dc',
                                                                 '4a:00:3e:b2:d2:dc'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 45875200,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 539111849,
                                             'dl_rf_packets': 16752534,
                                             'dl_rf_packets_dropped': 89,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.51.0.54',
                                             'mac_address': '0a:00:3e:b2:d2:dc',
                                             'name': 'Pete & Lena Peters - 103',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 15564800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 420,
                                             'ul_noise_floor': -88.2,
                                             'ul_rf_bytes': 1543711768,
                                             'ul_rf_packets': 10762999,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -68.2,
                                             'ul_snr': 20.0},
                '0a:00:3e:b2:d2:dd': {       'alt_macs': {       '1a:00:3e:b2:d2:dd',
                                                                 '2a:00:3e:b2:d2:dd',
                                                                 '3a:00:3e:b2:d2:dd',
                                                                 '4a:00:3e:b2:d2:dd'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 45875200,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1825692,
                                             'dl_rf_packets': 3323,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.9.42',
                                             'mac_address': '0a:00:3e:b2:d2:dd',
                                             'name': 'Christy Arzate - 938',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -102.9,
                                             'ul_rf_bytes': 1713454,
                                             'ul_rf_packets': 11512,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -70.4,
                                             'ul_snr': 32.5},
                '0a:00:3e:b2:db:f7': {       'alt_macs': {       '1a:00:3e:b2:db:f7',
                                                                 '2a:00:3e:b2:db:f7',
                                                                 '3a:00:3e:b2:db:f7',
                                                                 '4a:00:3e:b2:db:f7'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2448788346,
                                             'dl_rf_packets': 76860696,
                                             'dl_rf_packets_dropped': 23094,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.10.36',
                                             'mac_address': '0a:00:3e:b2:db:f7',
                                             'name': 'Bernhard Loewen - 1040',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.25,
                                             'ul_rf_bytes': 122810929,
                                             'ul_rf_packets': 49517945,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.75,
                                             'ul_snr': 29.5},
                '0a:00:3e:b2:dd:aa': {       'alt_macs': {       '1a:00:3e:b2:dd:aa',
                                                                 '2a:00:3e:b2:dd:aa',
                                                                 '3a:00:3e:b2:dd:aa',
                                                                 '4a:00:3e:b2:dd:aa'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 177166383,
                                             'dl_rf_packets': 268152807,
                                             'dl_rf_packets_dropped': 183867,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.7.53',
                                             'mac_address': '0a:00:3e:b2:dd:aa',
                                             'name': 'Lucia Salazar - 733',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 27238400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 750,
                                             'ul_noise_floor': -99.1,
                                             'ul_rf_bytes': 4265838211,
                                             'ul_rf_packets': 148987716,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -68.1,
                                             'ul_snr': 31.0},
                '0a:00:3e:b3:a4:3a': {       'alt_macs': {       '1a:00:3e:b3:a4:3a',
                                                                 '2a:00:3e:b3:a4:3a',
                                                                 '3a:00:3e:b3:a4:3a',
                                                                 '4a:00:3e:b3:a4:3a'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 554964475,
                                             'dl_rf_packets': 37517732,
                                             'dl_rf_packets_dropped': 153,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.7.98',
                                             'mac_address': '0a:00:3e:b3:a4:3a',
                                             'name': 'Gail McCloud - 789',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 31129600,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -100.6,
                                             'ul_rf_bytes': 3060381759,
                                             'ul_rf_packets': 23509160,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.1,
                                             'ul_snr': 36.5},
                '0a:00:3e:b3:f4:23': {       'alt_macs': {       '1a:00:3e:b3:f4:23',
                                                                 '2a:00:3e:b3:f4:23',
                                                                 '3a:00:3e:b3:f4:23',
                                                                 '4a:00:3e:b3:f4:23'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 45875200,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3174032594,
                                             'dl_rf_packets': 5625751,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.12.59',
                                             'mac_address': '0a:00:3e:b3:f4:23',
                                             'name': 'Jacob Penner - 1277',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -100.2,
                                             'ul_rf_bytes': 340247166,
                                             'ul_rf_packets': 2656336,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -70.7,
                                             'ul_snr': 29.5},
                '0a:00:3e:b4:41:ef': {       'alt_macs': {       '1a:00:3e:b4:41:ef',
                                                                 '2a:00:3e:b4:41:ef',
                                                                 '3a:00:3e:b4:41:ef',
                                                                 '4a:00:3e:b4:41:ef'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 45875200,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 250542341,
                                             'dl_rf_packets': 29275983,
                                             'dl_rf_packets_dropped': 28436,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.8.77',
                                             'mac_address': '0a:00:3e:b4:41:ef',
                                             'name': 'Leland Haning - 871',
                                             'ul_exp_modulation_rate': 600,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -101.2,
                                             'ul_rf_bytes': 3592361528,
                                             'ul_rf_packets': 24773163,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -73.7,
                                             'ul_snr': 27.5},
                '0a:00:3e:b4:a6:b7': {       'alt_macs': {       '1a:00:3e:b4:a6:b7',
                                                                 '2a:00:3e:b4:a6:b7',
                                                                 '3a:00:3e:b4:a6:b7',
                                                                 '4a:00:3e:b4:a6:b7'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 45875200,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 159045,
                                             'dl_rf_packets': 419,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.11.44',
                                             'mac_address': '0a:00:3e:b4:a6:b7',
                                             'name': 'Mary Froese - 1176',
                                             'ul_exp_modulation_rate': 600,
                                             'ul_link_rate': 7782400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 210,
                                             'ul_noise_floor': -96.35,
                                             'ul_rf_bytes': 204511,
                                             'ul_rf_packets': 1203,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -76.35,
                                             'ul_snr': 20.0},
                '0a:00:3e:b4:a9:0e': {       'alt_macs': {       '1a:00:3e:b4:a9:0e',
                                                                 '2a:00:3e:b4:a9:0e',
                                                                 '3a:00:3e:b4:a9:0e',
                                                                 '4a:00:3e:b4:a9:0e'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1969265780,
                                             'dl_rf_packets': 1532022,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.9.18',
                                             'mac_address': '0a:00:3e:b4:a9:0e',
                                             'name': 'Maria Whitaker - 911',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -99.95,
                                             'ul_rf_bytes': 359487612,
                                             'ul_rf_packets': 3152569,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -71.45,
                                             'ul_snr': 28.5},
                '0a:00:3e:b5:0e:57': {       'alt_macs': {       '1a:00:3e:b5:0e:57',
                                                                 '2a:00:3e:b5:0e:57',
                                                                 '3a:00:3e:b5:0e:57',
                                                                 '4a:00:3e:b5:0e:57'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 45875200,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 511046742,
                                             'dl_rf_packets': 60708021,
                                             'dl_rf_packets_dropped': 35419,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.8.46',
                                             'mac_address': '0a:00:3e:b5:0e:57',
                                             'name': 'Tammy & Doyce Harris - 835',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -102.05,
                                             'ul_rf_bytes': 3933917096,
                                             'ul_rf_packets': 34826023,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -72.55,
                                             'ul_snr': 29.5},
                '0a:00:3e:b5:a5:e5': {       'alt_macs': {       '1a:00:3e:b5:a5:e5',
                                                                 '2a:00:3e:b5:a5:e5',
                                                                 '3a:00:3e:b5:a5:e5',
                                                                 '4a:00:3e:b5:a5:e5'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 540,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3248195030,
                                             'dl_rf_packets': 148823464,
                                             'dl_rf_packets_dropped': 18091,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.9.75',
                                             'mac_address': '0a:00:3e:b5:a5:e5',
                                             'name': 'Elizabeth Amaton - 982',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 31129600,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -99.55,
                                             'ul_rf_bytes': 1100058145,
                                             'ul_rf_packets': 98806717,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.55,
                                             'ul_snr': 35.0},
                '0a:00:3e:b5:a6:2e': {       'alt_macs': {       '1a:00:3e:b5:a6:2e',
                                                                 '2a:00:3e:b5:a6:2e',
                                                                 '3a:00:3e:b5:a6:2e',
                                                                 '4a:00:3e:b5:a6:2e'},
                                             'dev_macs': {'6c:b0:ce:3e:73:d6'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 45875200,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3698134799,
                                             'dl_rf_packets': 56536783,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.3.89',
                                             'mac_address': '0a:00:3e:b5:a6:2e',
                                             'name': 'Trina Loewen - 322',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -99.75,
                                             'ul_rf_bytes': 3296477184,
                                             'ul_rf_packets': 34094274,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -70.75,
                                             'ul_snr': 29.0},
                '0a:00:3e:b5:ad:8d': {       'alt_macs': {       '1a:00:3e:b5:ad:8d',
                                                                 '2a:00:3e:b5:ad:8d',
                                                                 '3a:00:3e:b5:ad:8d',
                                                                 '4a:00:3e:b5:ad:8d'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3206897061,
                                             'dl_rf_packets': 291369408,
                                             'dl_rf_packets_dropped': 13421,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.8.54',
                                             'mac_address': '0a:00:3e:b5:ad:8d',
                                             'name': 'Morgan Lira - 849',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.75,
                                             'ul_rf_bytes': 3349039110,
                                             'ul_rf_packets': 177394053,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.75,
                                             'ul_snr': 29.0},
                '0a:00:3e:b6:22:87': {       'alt_macs': {       '1a:00:3e:b6:22:87',
                                                                 '2a:00:3e:b6:22:87',
                                                                 '3a:00:3e:b6:22:87',
                                                                 '4a:00:3e:b6:22:87'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 540,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 262386549,
                                             'dl_rf_packets': 7428624,
                                             'dl_rf_packets_dropped': 42,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.8.29',
                                             'mac_address': '0a:00:3e:b6:22:87',
                                             'name': 'Peter and Sara Reimer - 820',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 31129600,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -105.4,
                                             'ul_rf_bytes': 1460079310,
                                             'ul_rf_packets': 6749676,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -68.4,
                                             'ul_snr': 37.0},
                '0a:00:3e:b6:29:93': {       'alt_macs': {       '1a:00:3e:b6:29:93',
                                                                 '2a:00:3e:b6:29:93',
                                                                 '3a:00:3e:b6:29:93',
                                                                 '4a:00:3e:b6:29:93'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1388611468,
                                             'dl_rf_packets': 5111700,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.18.21',
                                             'mac_address': '0a:00:3e:b6:29:93',
                                             'name': 'Doug Castleberry - 1894',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 31129600,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -103.65,
                                             'ul_rf_bytes': 2690419946,
                                             'ul_rf_packets': 4401542,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -69.15,
                                             'ul_snr': 34.5},
                '0a:00:3e:b6:3d:1a': {       'alt_macs': {       '1a:00:3e:b6:3d:1a',
                                                                 '2a:00:3e:b6:3d:1a',
                                                                 '3a:00:3e:b6:3d:1a',
                                                                 '4a:00:3e:b6:3d:1a'},
                                             'dev_macs': set(),
                                             'dl_exp_modulation_rate': 200,
                                             'dl_link_rate': 34406400,
                                             'dl_mcs': 3,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1221054169,
                                             'dl_rf_packets': 44022336,
                                             'dl_rf_packets_dropped': 425,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.51.0.11',
                                             'mac_address': '0a:00:3e:b6:3d:1a',
                                             'name': 'Frank Hildebrand - 2310',
                                             'ul_exp_modulation_rate': 600,
                                             'ul_link_rate': 3891200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 100,
                                             'ul_noise_floor': -94.85,
                                             'ul_rf_bytes': 2269622955,
                                             'ul_rf_packets': 26106565,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -78.35,
                                             'ul_snr': 16.5},
                '0a:00:3e:bb:3b:d2': {       'alt_macs': {       '1a:00:3e:bb:3b:d2',
                                                                 '2a:00:3e:bb:3b:d2',
                                                                 '3a:00:3e:bb:3b:d2',
                                                                 '4a:00:3e:bb:3b:d2'},
                                             'dev_macs': {'d4:ca:6d:58:ff:21'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 68812800,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 470,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 490982664,
                                             'dl_rf_packets': 376332,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.21.19.2',
                                             'mac_address': '0a:00:3e:bb:3b:d2',
                                             'name': 'Teepee RV - 1971',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 23347200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -92.85,
                                             'ul_rf_bytes': 21507872,
                                             'ul_rf_packets': 174836,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -62.349999999999994,
                                             'ul_snr': 30.5}
        }
        exp_ne_msg = {
                'data': {       'elevation': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '85435947',
                                                              'in_octets': '3416530726372',
                                                              'in_ucast_pkts': '2459909073',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '0a:00:3e:60:32:18',
                                                              'mtu': 1514,
                                                              'name': 'Ethernet',
                                                              'oper_up': True,
                                                              'out_discards': '1010',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '134773',
                                                              'out_octets': '206902390739',
                                                              'out_ucast_pkts': '1420383739',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '85435947',
                                                              'in_octets': '3416530726372',
                                                              'in_ucast_pkts': '2459909073',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '4265838211',
                                                                                       'in_ucast_pkts': '148987716',
                                                                                       'mac_address': '0a:00:3e:b2:dd:aa',
                                                                                       'out_discards': '183867',
                                                                                       'out_octets': '177166383',
                                                                                       'out_ucast_pkts': '268152807'},
                                                                               {       'in_octets': '1713454',
                                                                                       'in_ucast_pkts': '11512',
                                                                                       'mac_address': '0a:00:3e:b2:d2:dd',
                                                                                       'out_octets': '1825692',
                                                                                       'out_ucast_pkts': '3323'},
                                                                               {       'in_octets': '1322491548',
                                                                                       'in_ucast_pkts': '30205997',
                                                                                       'mac_address': '0a:00:3e:a2:b3:f9',
                                                                                       'out_discards': '28775',
                                                                                       'out_octets': '537865602',
                                                                                       'out_ucast_pkts': '47236428'},
                                                                               {       'in_octets': '3933917096',
                                                                                       'in_ucast_pkts': '34826023',
                                                                                       'mac_address': '0a:00:3e:b5:0e:57',
                                                                                       'out_discards': '35419',
                                                                                       'out_octets': '511046742',
                                                                                       'out_ucast_pkts': '60708021'},
                                                                               {       'in_octets': '1460079310',
                                                                                       'in_ucast_pkts': '6749676',
                                                                                       'mac_address': '0a:00:3e:b6:22:87',
                                                                                       'out_discards': '42',
                                                                                       'out_octets': '262386549',
                                                                                       'out_ucast_pkts': '7428624'},
                                                                               {       'in_octets': '4369430',
                                                                                       'in_ucast_pkts': '30486',
                                                                                       'mac_address': '0a:00:3e:29:20:db',
                                                                                       'out_octets': '10648239',
                                                                                       'out_ucast_pkts': '13239'},
                                                                               {       'in_octets': '25844620',
                                                                                       'in_ucast_pkts': '103799',
                                                                                       'mac_address': '0a:00:3e:a2:b4:ea',
                                                                                       'out_octets': '29211238',
                                                                                       'out_ucast_pkts': '38013'},
                                                                               {       'in_octets': '340247166',
                                                                                       'in_ucast_pkts': '2656336',
                                                                                       'mac_address': '0a:00:3e:b3:f4:23',
                                                                                       'out_octets': '3174032594',
                                                                                       'out_ucast_pkts': '5625751'},
                                                                               {       'in_octets': '3592361528',
                                                                                       'in_ucast_pkts': '24773163',
                                                                                       'mac_address': '0a:00:3e:b4:41:ef',
                                                                                       'out_discards': '28436',
                                                                                       'out_octets': '250542341',
                                                                                       'out_ucast_pkts': '29275983'},
                                                                               {       'bridged_mac_addresses': [       'd4:ca:6d:58:ff:21'],
                                                                                       'in_octets': '21507872',
                                                                                       'in_ucast_pkts': '174836',
                                                                                       'mac_address': '0a:00:3e:bb:3b:d2',
                                                                                       'out_octets': '490982664',
                                                                                       'out_ucast_pkts': '376332'},
                                                                               {       'in_octets': '3349039110',
                                                                                       'in_ucast_pkts': '177394053',
                                                                                       'mac_address': '0a:00:3e:b5:ad:8d',
                                                                                       'out_discards': '13421',
                                                                                       'out_octets': '3206897061',
                                                                                       'out_ucast_pkts': '291369408'},
                                                                               {       'in_octets': '2690419946',
                                                                                       'in_ucast_pkts': '4401542',
                                                                                       'mac_address': '0a:00:3e:b6:29:93',
                                                                                       'out_octets': '1388611468',
                                                                                       'out_ucast_pkts': '5111700'},
                                                                               {       'bridged_mac_addresses': [       '6c:b0:ce:3e:73:d6'],
                                                                                       'in_octets': '3296477184',
                                                                                       'in_ucast_pkts': '34094274',
                                                                                       'mac_address': '0a:00:3e:b5:a6:2e',
                                                                                       'out_octets': '3698134799',
                                                                                       'out_ucast_pkts': '56536783'},
                                                                               {       'in_octets': '3945467782',
                                                                                       'in_ucast_pkts': '29600632',
                                                                                       'mac_address': '0a:00:3e:b2:87:22',
                                                                                       'out_discards': '6078',
                                                                                       'out_octets': '909893639',
                                                                                       'out_ucast_pkts': '53567822'},
                                                                               {       'in_octets': '201897945',
                                                                                       'in_ucast_pkts': '1125789',
                                                                                       'mac_address': '0a:00:3e:a2:66:d0',
                                                                                       'out_discards': '92',
                                                                                       'out_octets': '969800559',
                                                                                       'out_ucast_pkts': '836594'},
                                                                               {       'in_octets': '1100058145',
                                                                                       'in_ucast_pkts': '98806717',
                                                                                       'mac_address': '0a:00:3e:b5:a5:e5',
                                                                                       'out_discards': '18091',
                                                                                       'out_octets': '3248195030',
                                                                                       'out_ucast_pkts': '148823464'},
                                                                               {       'in_octets': '359487612',
                                                                                       'in_ucast_pkts': '3152569',
                                                                                       'mac_address': '0a:00:3e:b4:a9:0e',
                                                                                       'out_octets': '1969265780',
                                                                                       'out_ucast_pkts': '1532022'},
                                                                               {       'in_octets': '2269622955',
                                                                                       'in_ucast_pkts': '26106565',
                                                                                       'mac_address': '0a:00:3e:b6:3d:1a',
                                                                                       'out_discards': '425',
                                                                                       'out_octets': '1221054169',
                                                                                       'out_ucast_pkts': '44022336'},
                                                                               {       'in_octets': '1596389344',
                                                                                       'in_ucast_pkts': '15433971',
                                                                                       'mac_address': '0a:00:3e:b2:87:41',
                                                                                       'out_discards': '687',
                                                                                       'out_octets': '2630279513',
                                                                                       'out_ucast_pkts': '29605705'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:12:3b:41'],
                                                                                       'in_octets': '137526401',
                                                                                       'in_ucast_pkts': '931052',
                                                                                       'mac_address': '0a:00:3e:a2:a5:d2',
                                                                                       'out_octets': '34997618',
                                                                                       'out_ucast_pkts': '204123'},
                                                                               {       'in_octets': '122810929',
                                                                                       'in_ucast_pkts': '49517945',
                                                                                       'mac_address': '0a:00:3e:b2:db:f7',
                                                                                       'out_discards': '23094',
                                                                                       'out_octets': '2448788346',
                                                                                       'out_ucast_pkts': '76860696'},
                                                                               {       'in_octets': '204511',
                                                                                       'in_ucast_pkts': '1203',
                                                                                       'mac_address': '0a:00:3e:b4:a6:b7',
                                                                                       'out_octets': '159045',
                                                                                       'out_ucast_pkts': '419'},
                                                                               {       'in_octets': '684725383',
                                                                                       'in_ucast_pkts': '49804491',
                                                                                       'mac_address': '0a:00:3e:a1:69:12',
                                                                                       'out_discards': '3939',
                                                                                       'out_octets': '3806858652',
                                                                                       'out_ucast_pkts': '93130774'},
                                                                               {       'in_octets': '291391811',
                                                                                       'in_ucast_pkts': '3067560',
                                                                                       'mac_address': '0a:00:3e:29:1a:c1',
                                                                                       'out_octets': '2148962426',
                                                                                       'out_ucast_pkts': '4480248'},
                                                                               {       'in_octets': '1543711768',
                                                                                       'in_ucast_pkts': '10762999',
                                                                                       'mac_address': '0a:00:3e:b2:d2:dc',
                                                                                       'out_discards': '89',
                                                                                       'out_octets': '539111849',
                                                                                       'out_ucast_pkts': '16752534'},
                                                                               {       'in_octets': '3060381759',
                                                                                       'in_ucast_pkts': '23509160',
                                                                                       'mac_address': '0a:00:3e:b3:a4:3a',
                                                                                       'out_discards': '153',
                                                                                       'out_octets': '554964475',
                                                                                       'out_ucast_pkts': '37517732'}],
                                                              'mac_address': '1a:00:3e:60:32:18',
                                                              'mtu': 1500,
                                                              'name': 'Canopy '
                                                                      'MultiPoint',
                                                              'oper_up': True,
                                                              'out_discards': '734237',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '134773',
                                                              'out_octets': '206902390739',
                                                              'out_ucast_pkts': '1420383739',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 2500,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5755,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_frutl': 28.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '1385550',
                                                                                                                                            'mac_address': '0a:00:3e:b2:dd:aa',
                                                                                                                                            'noise_floor': -99.4,
                                                                                                                                            'rssi': -67.4,
                                                                                                                                            'rx_link_rate': '27238400',
                                                                                                                                            'rx_modulation_rate': 750.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '5641',
                                                                                                                                            'mac_address': '0a:00:3e:b2:d2:dd',
                                                                                                                                            'noise_floor': -108.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 38.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '460758',
                                                                                                                                            'mac_address': '0a:00:3e:a2:b3:f9',
                                                                                                                                            'noise_floor': -86.3,
                                                                                                                                            'rssi': -72.3,
                                                                                                                                            'rx_link_rate': '7782400',
                                                                                                                                            'rx_modulation_rate': 200.0,
                                                                                                                                            'snr': 14.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385546',
                                                                                                                                            'mac_address': '0a:00:3e:b5:0e:57',
                                                                                                                                            'noise_floor': -100.3,
                                                                                                                                            'rssi': -71.3,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385545',
                                                                                                                                            'mac_address': '0a:00:3e:b6:22:87',
                                                                                                                                            'noise_floor': -103.4,
                                                                                                                                            'rssi': -66.4,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 540.0},
                                                                                                                                    {       'connected_time': '13228',
                                                                                                                                            'mac_address': '0a:00:3e:29:20:db',
                                                                                                                                            'noise_floor': -101.4,
                                                                                                                                            'rssi': -75.4,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '22937600',
                                                                                                                                            'tx_modulation_rate': 200.0},
                                                                                                                                    {       'connected_time': '38763',
                                                                                                                                            'mac_address': '0a:00:3e:a2:b4:ea',
                                                                                                                                            'noise_floor': -89.3,
                                                                                                                                            'rssi': -69.3,
                                                                                                                                            'rx_link_rate': '15564800',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '34406400',
                                                                                                                                            'tx_modulation_rate': 300.0},
                                                                                                                                    {       'connected_time': '515235',
                                                                                                                                            'mac_address': '0a:00:3e:b3:f4:23',
                                                                                                                                            'noise_floor': -97.2,
                                                                                                                                            'rssi': -69.2,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385554',
                                                                                                                                            'mac_address': '0a:00:3e:b4:41:ef',
                                                                                                                                            'noise_floor': -101.4,
                                                                                                                                            'rssi': -73.4,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '10343',
                                                                                                                                            'mac_address': '0a:00:3e:bb:3b:d2',
                                                                                                                                            'noise_floor': -93.8,
                                                                                                                                            'rssi': -62.8,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 470.0},
                                                                                                                                    {       'connected_time': '1385534',
                                                                                                                                            'mac_address': '0a:00:3e:b5:ad:8d',
                                                                                                                                            'noise_floor': -94.5,
                                                                                                                                            'rssi': -65.5,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '39207',
                                                                                                                                            'mac_address': '0a:00:3e:b6:29:93',
                                                                                                                                            'noise_floor': -103.8,
                                                                                                                                            'rssi': -68.8,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '356857',
                                                                                                                                            'mac_address': '0a:00:3e:b5:a6:2e',
                                                                                                                                            'noise_floor': -97.7,
                                                                                                                                            'rssi': -69.7,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385153',
                                                                                                                                            'mac_address': '0a:00:3e:b2:87:22',
                                                                                                                                            'noise_floor': -96.9,
                                                                                                                                            'rssi': -62.9,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '360840',
                                                                                                                                            'mac_address': '0a:00:3e:a2:66:d0',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -78.0,
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '22937600',
                                                                                                                                            'tx_modulation_rate': 200.0},
                                                                                                                                    {       'connected_time': '1008243',
                                                                                                                                            'mac_address': '0a:00:3e:b5:a5:e5',
                                                                                                                                            'noise_floor': -98.9,
                                                                                                                                            'rssi': -63.9,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 540.0},
                                                                                                                                    {       'connected_time': '1366008',
                                                                                                                                            'mac_address': '0a:00:3e:b4:a9:0e',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1385552',
                                                                                                                                            'mac_address': '0a:00:3e:b6:3d:1a',
                                                                                                                                            'noise_floor': -99.8,
                                                                                                                                            'rssi': -79.8,
                                                                                                                                            'rx_link_rate': '3891200',
                                                                                                                                            'rx_modulation_rate': 100.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '34406400',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '453901',
                                                                                                                                            'mac_address': '0a:00:3e:b2:87:41',
                                                                                                                                            'noise_floor': -99.5,
                                                                                                                                            'rssi': -72.5,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 550.0},
                                                                                                                                    {       'connected_time': '454555',
                                                                                                                                            'mac_address': '0a:00:3e:a2:a5:d2',
                                                                                                                                            'noise_floor': -96.7,
                                                                                                                                            'rssi': -66.7,
                                                                                                                                            'rx_link_rate': '19456000',
                                                                                                                                            'rx_modulation_rate': 550.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '419457',
                                                                                                                                            'mac_address': '0a:00:3e:b2:db:f7',
                                                                                                                                            'noise_floor': -92.5,
                                                                                                                                            'rssi': -62.5,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '584',
                                                                                                                                            'mac_address': '0a:00:3e:b4:a6:b7',
                                                                                                                                            'noise_floor': -94.3,
                                                                                                                                            'rssi': -74.3,
                                                                                                                                            'rx_link_rate': '7782400',
                                                                                                                                            'rx_modulation_rate': 210.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385551',
                                                                                                                                            'mac_address': '0a:00:3e:a1:69:12',
                                                                                                                                            'noise_floor': -99.5,
                                                                                                                                            'rssi': -72.5,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '56390',
                                                                                                                                            'mac_address': '0a:00:3e:29:1a:c1',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -79.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '22937600',
                                                                                                                                            'tx_modulation_rate': 200.0},
                                                                                                                                    {       'connected_time': '460802',
                                                                                                                                            'mac_address': '0a:00:3e:b2:d2:dc',
                                                                                                                                            'noise_floor': -87.5,
                                                                                                                                            'rssi': -67.5,
                                                                                                                                            'rx_link_rate': '15564800',
                                                                                                                                            'rx_modulation_rate': 420.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385550',
                                                                                                                                            'mac_address': '0a:00:3e:b3:a4:3a',
                                                                                                                                            'noise_floor': -98.4,
                                                                                                                                            'rssi': -62.4,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0}],
                                                                                                                   'noise_floor': -86.3,
                                                                                                                   'polarization': 'VERTICAL'},
                                                                                                           {       'id': '2',
                                                                                                                   'links': [       {       'connected_time': '1385550',
                                                                                                                                            'mac_address': '0a:00:3e:b2:dd:aa',
                                                                                                                                            'noise_floor': -98.8,
                                                                                                                                            'rssi': -68.8,
                                                                                                                                            'rx_link_rate': '27238400',
                                                                                                                                            'rx_modulation_rate': 750.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '5641',
                                                                                                                                            'mac_address': '0a:00:3e:b2:d2:dd',
                                                                                                                                            'noise_floor': -97.8,
                                                                                                                                            'rssi': -70.8,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '460758',
                                                                                                                                            'mac_address': '0a:00:3e:a2:b3:f9',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -75.0,
                                                                                                                                            'rx_link_rate': '7782400',
                                                                                                                                            'rx_modulation_rate': 200.0,
                                                                                                                                            'snr': 14.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385546',
                                                                                                                                            'mac_address': '0a:00:3e:b5:0e:57',
                                                                                                                                            'noise_floor': -103.8,
                                                                                                                                            'rssi': -73.8,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385545',
                                                                                                                                            'mac_address': '0a:00:3e:b6:22:87',
                                                                                                                                            'noise_floor': -107.4,
                                                                                                                                            'rssi': -70.4,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 540.0},
                                                                                                                                    {       'connected_time': '13228',
                                                                                                                                            'mac_address': '0a:00:3e:29:20:db',
                                                                                                                                            'noise_floor': -104.3,
                                                                                                                                            'rssi': -76.3,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '22937600',
                                                                                                                                            'tx_modulation_rate': 200.0},
                                                                                                                                    {       'connected_time': '38763',
                                                                                                                                            'mac_address': '0a:00:3e:a2:b4:ea',
                                                                                                                                            'noise_floor': -91.9,
                                                                                                                                            'rssi': -71.9,
                                                                                                                                            'rx_link_rate': '15564800',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '34406400',
                                                                                                                                            'tx_modulation_rate': 300.0},
                                                                                                                                    {       'connected_time': '515235',
                                                                                                                                            'mac_address': '0a:00:3e:b3:f4:23',
                                                                                                                                            'noise_floor': -103.2,
                                                                                                                                            'rssi': -72.2,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385554',
                                                                                                                                            'mac_address': '0a:00:3e:b4:41:ef',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '10343',
                                                                                                                                            'mac_address': '0a:00:3e:bb:3b:d2',
                                                                                                                                            'noise_floor': -91.9,
                                                                                                                                            'rssi': -61.9,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 470.0},
                                                                                                                                    {       'connected_time': '1385534',
                                                                                                                                            'mac_address': '0a:00:3e:b5:ad:8d',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '39207',
                                                                                                                                            'mac_address': '0a:00:3e:b6:29:93',
                                                                                                                                            'noise_floor': -103.5,
                                                                                                                                            'rssi': -69.5,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '356857',
                                                                                                                                            'mac_address': '0a:00:3e:b5:a6:2e',
                                                                                                                                            'noise_floor': -101.8,
                                                                                                                                            'rssi': -71.8,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385153',
                                                                                                                                            'mac_address': '0a:00:3e:b2:87:22',
                                                                                                                                            'noise_floor': -96.9,
                                                                                                                                            'rssi': -61.9,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '360840',
                                                                                                                                            'mac_address': '0a:00:3e:a2:66:d0',
                                                                                                                                            'noise_floor': -92.4,
                                                                                                                                            'rssi': -78.4,
                                                                                                                                            'snr': 14.0,
                                                                                                                                            'tx_link_rate': '22937600',
                                                                                                                                            'tx_modulation_rate': 200.0},
                                                                                                                                    {       'connected_time': '1008243',
                                                                                                                                            'mac_address': '0a:00:3e:b5:a5:e5',
                                                                                                                                            'noise_floor': -100.2,
                                                                                                                                            'rssi': -65.2,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 540.0},
                                                                                                                                    {       'connected_time': '1366008',
                                                                                                                                            'mac_address': '0a:00:3e:b4:a9:0e',
                                                                                                                                            'noise_floor': -102.9,
                                                                                                                                            'rssi': -73.9,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1385552',
                                                                                                                                            'mac_address': '0a:00:3e:b6:3d:1a',
                                                                                                                                            'noise_floor': -89.9,
                                                                                                                                            'rssi': -76.9,
                                                                                                                                            'rx_link_rate': '3891200',
                                                                                                                                            'rx_modulation_rate': 100.0,
                                                                                                                                            'snr': 13.0,
                                                                                                                                            'tx_link_rate': '34406400',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '453901',
                                                                                                                                            'mac_address': '0a:00:3e:b2:87:41',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -72.0,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 550.0},
                                                                                                                                    {       'connected_time': '454555',
                                                                                                                                            'mac_address': '0a:00:3e:a2:a5:d2',
                                                                                                                                            'noise_floor': -98.4,
                                                                                                                                            'rssi': -70.4,
                                                                                                                                            'rx_link_rate': '19456000',
                                                                                                                                            'rx_modulation_rate': 550.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '419457',
                                                                                                                                            'mac_address': '0a:00:3e:b2:db:f7',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '584',
                                                                                                                                            'mac_address': '0a:00:3e:b4:a6:b7',
                                                                                                                                            'noise_floor': -98.4,
                                                                                                                                            'rssi': -78.4,
                                                                                                                                            'rx_link_rate': '7782400',
                                                                                                                                            'rx_modulation_rate': 210.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385551',
                                                                                                                                            'mac_address': '0a:00:3e:a1:69:12',
                                                                                                                                            'noise_floor': -104.3,
                                                                                                                                            'rssi': -76.3,
                                                                                                                                            'rx_link_rate': '23347200',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '56390',
                                                                                                                                            'mac_address': '0a:00:3e:29:1a:c1',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -81.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '22937600',
                                                                                                                                            'tx_modulation_rate': 200.0},
                                                                                                                                    {       'connected_time': '460802',
                                                                                                                                            'mac_address': '0a:00:3e:b2:d2:dc',
                                                                                                                                            'noise_floor': -88.9,
                                                                                                                                            'rssi': -68.9,
                                                                                                                                            'rx_link_rate': '15564800',
                                                                                                                                            'rx_modulation_rate': 420.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '45875200',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1385550',
                                                                                                                                            'mac_address': '0a:00:3e:b3:a4:3a',
                                                                                                                                            'noise_floor': -102.8,
                                                                                                                                            'rssi': -65.8,
                                                                                                                                            'rx_link_rate': '31129600',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_link_rate': '68812800',
                                                                                                                                            'tx_modulation_rate': 600.0}],
                                                                                                                   'noise_floor': -88.9,
                                                                                                                   'polarization': 'HORIZONTAL'}],
                                                                                        'tx_average_group_size': 2.3,
                                                                                        'tx_frutl': 39.0,
                                                                                        'tx_multiplexing_gain': 0.99,
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'latitude': 0.0,
                                'longitude': 0.0,
                                'manufacturer': 'Cambium',
                                'model': 'PMP 450m',
                                'serial_number': 'M9SH00308S66',
                                'sw_version': 'CANOPY 15.1.2 AP-DES',
                                'system_mac_address': '0a:00:3e:60:32:18',
                                'temperature': 20.0,
                                'uptime': '1385613'},
                'peers': [       {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '183867',
                                                                       'in_octets': '177166383',
                                                                       'in_ucast_pkts': '268152807',
                                                                       'links': [       {       'in_octets': '4265838211',
                                                                                                'in_ucast_pkts': '148987716',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '177166383',
                                                                                                'out_ucast_pkts': '268152807'}],
                                                                       'mac_address': '0a:00:3e:b2:dd:aa',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '4265838211',
                                                                       'out_ucast_pkts': '148987716',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1385550',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '27238400',
                                                                                                                                                     'tx_modulation_rate': 750.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1385550',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '27238400',
                                                                                                                                                     'tx_modulation_rate': 750.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '27238400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.7.53',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Lucia Salazar - 733',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b2:dd:aa'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '1825692',
                                                                       'in_ucast_pkts': '3323',
                                                                       'links': [       {       'in_octets': '1713454',
                                                                                                'in_ucast_pkts': '11512',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '1825692',
                                                                                                'out_ucast_pkts': '3323'}],
                                                                       'mac_address': '0a:00:3e:b2:d2:dd',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1713454',
                                                                       'out_ucast_pkts': '11512',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45875200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '5641',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '5641',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.9.42',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Christy Arzate - 938',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b2:d2:dd'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '28775',
                                                                       'in_octets': '537865602',
                                                                       'in_ucast_pkts': '47236428',
                                                                       'links': [       {       'in_octets': '1322491548',
                                                                                                'in_ucast_pkts': '30205997',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '537865602',
                                                                                                'out_ucast_pkts': '47236428'}],
                                                                       'mac_address': '0a:00:3e:a2:b3:f9',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1322491548',
                                                                       'out_ucast_pkts': '30205997',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45875200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '460758',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '7782400',
                                                                                                                                                     'tx_modulation_rate': 200.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '460758',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '7782400',
                                                                                                                                                     'tx_modulation_rate': 200.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '7782400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.9.83',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Henry Harms - 985',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:a2:b3:f9'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '35419',
                                                                       'in_octets': '511046742',
                                                                       'in_ucast_pkts': '60708021',
                                                                       'links': [       {       'in_octets': '3933917096',
                                                                                                'in_ucast_pkts': '34826023',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '511046742',
                                                                                                'out_ucast_pkts': '60708021'}],
                                                                       'mac_address': '0a:00:3e:b5:0e:57',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3933917096',
                                                                       'out_ucast_pkts': '34826023',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45875200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1385546',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1385546',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.8.46',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Tammy & Doyce Harris - 835',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b5:0e:57'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '42',
                                                                       'in_octets': '262386549',
                                                                       'in_ucast_pkts': '7428624',
                                                                       'links': [       {       'in_octets': '1460079310',
                                                                                                'in_ucast_pkts': '6749676',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '262386549',
                                                                                                'out_ucast_pkts': '7428624'}],
                                                                       'mac_address': '0a:00:3e:b6:22:87',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1460079310',
                                                                       'out_ucast_pkts': '6749676',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1385545',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 540.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1385545',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 540.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '31129600'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.8.29',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Peter and Sara Reimer - 820',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b6:22:87'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '10648239',
                                                                       'in_ucast_pkts': '13239',
                                                                       'links': [       {       'in_octets': '4369430',
                                                                                                'in_ucast_pkts': '30486',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '10648239',
                                                                                                'out_ucast_pkts': '13239'}],
                                                                       'mac_address': '0a:00:3e:29:20:db',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '4369430',
                                                                       'out_ucast_pkts': '30486',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '22937600',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '13228',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '22937600',
                                                                                                                                                     'rx_modulation_rate': 200.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '13228',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '22937600',
                                                                                                                                                     'rx_modulation_rate': 200.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.20.82',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Patricia Hinojos - 2283',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1',
                                         'system_mac_address': '0a:00:3e:29:20:db'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '29211238',
                                                                       'in_ucast_pkts': '38013',
                                                                       'links': [       {       'in_octets': '25844620',
                                                                                                'in_ucast_pkts': '103799',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '29211238',
                                                                                                'out_ucast_pkts': '38013'}],
                                                                       'mac_address': '0a:00:3e:a2:b4:ea',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '25844620',
                                                                       'out_ucast_pkts': '103799',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '34406400',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '38763',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '34406400',
                                                                                                                                                     'rx_modulation_rate': 300.0,
                                                                                                                                                     'tx_link_rate': '15564800',
                                                                                                                                                     'tx_modulation_rate': 400.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '38763',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '34406400',
                                                                                                                                                     'rx_modulation_rate': 300.0,
                                                                                                                                                     'tx_link_rate': '15564800',
                                                                                                                                                     'tx_modulation_rate': 400.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '15564800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.18.6',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Danny Mcllwain - 1872',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:a2:b4:ea'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '3174032594',
                                                                       'in_ucast_pkts': '5625751',
                                                                       'links': [       {       'in_octets': '340247166',
                                                                                                'in_ucast_pkts': '2656336',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '3174032594',
                                                                                                'out_ucast_pkts': '5625751'}],
                                                                       'mac_address': '0a:00:3e:b3:f4:23',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '340247166',
                                                                       'out_ucast_pkts': '2656336',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45875200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '515235',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '515235',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.12.59',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Jacob Penner - 1277',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b3:f4:23'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '28436',
                                                                       'in_octets': '250542341',
                                                                       'in_ucast_pkts': '29275983',
                                                                       'links': [       {       'in_octets': '3592361528',
                                                                                                'in_ucast_pkts': '24773163',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '250542341',
                                                                                                'out_ucast_pkts': '29275983'}],
                                                                       'mac_address': '0a:00:3e:b4:41:ef',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3592361528',
                                                                       'out_ucast_pkts': '24773163',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45875200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1385554',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1385554',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.8.77',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Leland Haning - 871',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b4:41:ef'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '490982664',
                                                                       'in_ucast_pkts': '376332',
                                                                       'links': [       {       'in_octets': '21507872',
                                                                                                'in_ucast_pkts': '174836',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '490982664',
                                                                                                'out_ucast_pkts': '376332'}],
                                                                       'mac_address': '0a:00:3e:bb:3b:d2',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '21507872',
                                                                       'out_ucast_pkts': '174836',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '10343',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 470.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '10343',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 470.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.19.2',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450i',
                                         'name': 'Teepee RV - 1971',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:bb:3b:d2'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '13421',
                                                                       'in_octets': '3206897061',
                                                                       'in_ucast_pkts': '291369408',
                                                                       'links': [       {       'in_octets': '3349039110',
                                                                                                'in_ucast_pkts': '177394053',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '3206897061',
                                                                                                'out_ucast_pkts': '291369408'}],
                                                                       'mac_address': '0a:00:3e:b5:ad:8d',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3349039110',
                                                                       'out_ucast_pkts': '177394053',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1385534',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1385534',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.8.54',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Morgan Lira - 849',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b5:ad:8d'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '1388611468',
                                                                       'in_ucast_pkts': '5111700',
                                                                       'links': [       {       'in_octets': '2690419946',
                                                                                                'in_ucast_pkts': '4401542',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '1388611468',
                                                                                                'out_ucast_pkts': '5111700'}],
                                                                       'mac_address': '0a:00:3e:b6:29:93',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '2690419946',
                                                                       'out_ucast_pkts': '4401542',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '39207',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '39207',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '31129600'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.18.21',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Doug Castleberry - 1894',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b6:29:93'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '3698134799',
                                                                       'in_ucast_pkts': '56536783',
                                                                       'links': [       {       'in_octets': '3296477184',
                                                                                                'in_ucast_pkts': '34094274',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '3698134799',
                                                                                                'out_ucast_pkts': '56536783'}],
                                                                       'mac_address': '0a:00:3e:b5:a6:2e',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3296477184',
                                                                       'out_ucast_pkts': '34094274',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45875200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '356857',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '356857',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.3.89',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Trina Loewen - 322',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.1',
                                         'system_mac_address': '0a:00:3e:b5:a6:2e'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '6078',
                                                                       'in_octets': '909893639',
                                                                       'in_ucast_pkts': '53567822',
                                                                       'links': [       {       'in_octets': '3945467782',
                                                                                                'in_ucast_pkts': '29600632',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '909893639',
                                                                                                'out_ucast_pkts': '53567822'}],
                                                                       'mac_address': '0a:00:3e:b2:87:22',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3945467782',
                                                                       'out_ucast_pkts': '29600632',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1385153',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1385153',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '31129600'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.21.84',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Farmboys Truck and Auto Service - '
                                                 '2444',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b2:87:22'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '92',
                                                                       'in_octets': '969800559',
                                                                       'in_ucast_pkts': '836594',
                                                                       'links': [       {       'in_octets': '201897945',
                                                                                                'in_ucast_pkts': '1125789',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '969800559',
                                                                                                'out_ucast_pkts': '836594'}],
                                                                       'mac_address': '0a:00:3e:a2:66:d0',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '201897945',
                                                                       'out_ucast_pkts': '1125789',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '22937600',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '360840',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '22937600',
                                                                                                                                                     'rx_modulation_rate': 200.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '360840',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '22937600',
                                                                                                                                                     'rx_modulation_rate': 200.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.21.64',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Ruben Gutierrez - 2351',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1',
                                         'system_mac_address': '0a:00:3e:a2:66:d0'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '18091',
                                                                       'in_octets': '3248195030',
                                                                       'in_ucast_pkts': '148823464',
                                                                       'links': [       {       'in_octets': '1100058145',
                                                                                                'in_ucast_pkts': '98806717',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '3248195030',
                                                                                                'out_ucast_pkts': '148823464'}],
                                                                       'mac_address': '0a:00:3e:b5:a5:e5',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1100058145',
                                                                       'out_ucast_pkts': '98806717',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1008243',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 540.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1008243',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 540.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '31129600'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.9.75',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Elizabeth Amaton - 982',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.1',
                                         'system_mac_address': '0a:00:3e:b5:a5:e5'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '1969265780',
                                                                       'in_ucast_pkts': '1532022',
                                                                       'links': [       {       'in_octets': '359487612',
                                                                                                'in_ucast_pkts': '3152569',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '1969265780',
                                                                                                'out_ucast_pkts': '1532022'}],
                                                                       'mac_address': '0a:00:3e:b4:a9:0e',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '359487612',
                                                                       'out_ucast_pkts': '3152569',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1366008',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1366008',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.9.18',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Maria Whitaker - 911',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.1',
                                         'system_mac_address': '0a:00:3e:b4:a9:0e'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '425',
                                                                       'in_octets': '1221054169',
                                                                       'in_ucast_pkts': '44022336',
                                                                       'links': [       {       'in_octets': '2269622955',
                                                                                                'in_ucast_pkts': '26106565',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '1221054169',
                                                                                                'out_ucast_pkts': '44022336'}],
                                                                       'mac_address': '0a:00:3e:b6:3d:1a',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '2269622955',
                                                                       'out_ucast_pkts': '26106565',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '34406400',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1385552',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '34406400',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '3891200',
                                                                                                                                                     'tx_modulation_rate': 100.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1385552',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '34406400',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '3891200',
                                                                                                                                                     'tx_modulation_rate': 100.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '3891200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.51.0.11',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Frank Hildebrand - 2310',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b6:3d:1a'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '687',
                                                                       'in_octets': '2630279513',
                                                                       'in_ucast_pkts': '29605705',
                                                                       'links': [       {       'in_octets': '1596389344',
                                                                                                'in_ucast_pkts': '15433971',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '2630279513',
                                                                                                'out_ucast_pkts': '29605705'}],
                                                                       'mac_address': '0a:00:3e:b2:87:41',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1596389344',
                                                                       'out_ucast_pkts': '15433971',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '453901',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 550.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '453901',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 550.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.9.52',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Jacob Berg - 954',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b2:87:41'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '34997618',
                                                                       'in_ucast_pkts': '204123',
                                                                       'links': [       {       'in_octets': '137526401',
                                                                                                'in_ucast_pkts': '931052',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '34997618',
                                                                                                'out_ucast_pkts': '204123'}],
                                                                       'mac_address': '0a:00:3e:a2:a5:d2',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '137526401',
                                                                       'out_ucast_pkts': '931052',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '454555',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19456000',
                                                                                                                                                     'tx_modulation_rate': 550.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '454555',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19456000',
                                                                                                                                                     'tx_modulation_rate': 550.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19456000'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.11.10',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'James Newton - 1122',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.1',
                                         'system_mac_address': '0a:00:3e:a2:a5:d2'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '23094',
                                                                       'in_octets': '2448788346',
                                                                       'in_ucast_pkts': '76860696',
                                                                       'links': [       {       'in_octets': '122810929',
                                                                                                'in_ucast_pkts': '49517945',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '2448788346',
                                                                                                'out_ucast_pkts': '76860696'}],
                                                                       'mac_address': '0a:00:3e:b2:db:f7',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '122810929',
                                                                       'out_ucast_pkts': '49517945',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '419457',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '419457',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.10.36',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Bernhard Loewen - 1040',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.1',
                                         'system_mac_address': '0a:00:3e:b2:db:f7'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '159045',
                                                                       'in_ucast_pkts': '419',
                                                                       'links': [       {       'in_octets': '204511',
                                                                                                'in_ucast_pkts': '1203',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '159045',
                                                                                                'out_ucast_pkts': '419'}],
                                                                       'mac_address': '0a:00:3e:b4:a6:b7',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '204511',
                                                                       'out_ucast_pkts': '1203',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45875200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '584',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '7782400',
                                                                                                                                                     'tx_modulation_rate': 210.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '584',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '7782400',
                                                                                                                                                     'tx_modulation_rate': 210.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '7782400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.11.44',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Mary Froese - 1176',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b4:a6:b7'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '3939',
                                                                       'in_octets': '3806858652',
                                                                       'in_ucast_pkts': '93130774',
                                                                       'links': [       {       'in_octets': '684725383',
                                                                                                'in_ucast_pkts': '49804491',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '3806858652',
                                                                                                'out_ucast_pkts': '93130774'}],
                                                                       'mac_address': '0a:00:3e:a1:69:12',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '684725383',
                                                                       'out_ucast_pkts': '49804491',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45875200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1385551',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1385551',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '23347200',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '23347200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.15.24',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Mary Trevino - 1558',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:a1:69:12'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '2148962426',
                                                                       'in_ucast_pkts': '4480248',
                                                                       'links': [       {       'in_octets': '291391811',
                                                                                                'in_ucast_pkts': '3067560',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '2148962426',
                                                                                                'out_ucast_pkts': '4480248'}],
                                                                       'mac_address': '0a:00:3e:29:1a:c1',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '291391811',
                                                                       'out_ucast_pkts': '3067560',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '22937600',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '56390',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '22937600',
                                                                                                                                                     'rx_modulation_rate': 200.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '56390',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '22937600',
                                                                                                                                                     'rx_modulation_rate': 200.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.21.12',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Sarai Trevino - 2324',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1',
                                         'system_mac_address': '0a:00:3e:29:1a:c1'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '89',
                                                                       'in_octets': '539111849',
                                                                       'in_ucast_pkts': '16752534',
                                                                       'links': [       {       'in_octets': '1543711768',
                                                                                                'in_ucast_pkts': '10762999',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '539111849',
                                                                                                'out_ucast_pkts': '16752534'}],
                                                                       'mac_address': '0a:00:3e:b2:d2:dc',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1543711768',
                                                                       'out_ucast_pkts': '10762999',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '45875200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '460802',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '15564800',
                                                                                                                                                     'tx_modulation_rate': 420.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '460802',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '45875200',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '15564800',
                                                                                                                                                     'tx_modulation_rate': 420.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '15564800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.51.0.54',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Pete & Lena Peters - 103',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b2:d2:dc'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '153',
                                                                       'in_octets': '554964475',
                                                                       'in_ucast_pkts': '37517732',
                                                                       'links': [       {       'in_octets': '3060381759',
                                                                                                'in_ucast_pkts': '23509160',
                                                                                                'mac_address': '1a:00:3e:60:32:18',
                                                                                                'out_octets': '554964475',
                                                                                                'out_ucast_pkts': '37517732'}],
                                                                       'mac_address': '0a:00:3e:b3:a4:3a',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3060381759',
                                                                       'out_ucast_pkts': '23509160',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5755,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '68812800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1385550',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1385550',
                                                                                                                                                     'mac_address': '1a:00:3e:60:32:18',
                                                                                                                                                     'rx_link_rate': '68812800',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '31129600',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '31129600'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.21.7.98',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'Gail McCloud - 789',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.2',
                                         'system_mac_address': '0a:00:3e:b3:a4:3a'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_canopy_450m_PMP_450m_15_1_3_01(self):
        obj = self.run_data("cambium-canopy.450m.PMP 450m.15.1.3.01")
        exp_info = {
                'model': 'PMP 450m',
                'rf_chan_width': 20,
                'rf_dl_percent': 75,
                'rf_freq': 5735,
                'rf_tx_power': 10,
                'sta_count': 5,
                'sw_version': 'CANOPY 15.1.3 AP-None',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'dl_en_bytes': 9605708473598,
                'dl_en_packets': 8154336300,
                'dl_frutl': 22.0,
                'dl_multiplexing_gain': 1.0,
                'dl_noise_floor': None,
                'dl_rf_bytes': 331564532952,
                'dl_rf_packets': 2849354984,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 331564532952,
                'ul_en_packets': 2849354984,
                'ul_frutl': 3.0,
                'ul_multiplexing_gain': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 9605708473598,
                'ul_rf_packets': 8154336300,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
                '0a:00:3e:70:8c:95': {       'alt_macs': {       '1a:00:3e:70:8c:95',
                                                                 '2a:00:3e:70:8c:95',
                                                                 '3a:00:3e:70:8c:95',
                                                                 '4a:00:3e:70:8c:95'},
                                             'dev_macs': {'ec:1a:59:43:ec:d0'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 82944000,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1983084618,
                                             'dl_rf_packets': 300439975,
                                             'dl_rf_packets_dropped': 411253,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.51.66.58',
                                             'mac_address': '0a:00:3e:70:8c:95',
                                             'name': 'Emmet Wingert',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 37683200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -102.9,
                                             'ul_rf_bytes': 82830196,
                                             'ul_rf_packets': 75611258,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -60.4,
                                             'ul_snr': 42.5},
                '0a:00:3e:70:8c:ba': {       'alt_macs': {       '1a:00:3e:70:8c:ba',
                                                                 '2a:00:3e:70:8c:ba',
                                                                 '3a:00:3e:70:8c:ba',
                                                                 '4a:00:3e:70:8c:ba'},
                                             'dev_macs': {'8c:3b:ad:3b:e3:99'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 55296000,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3415757113,
                                             'dl_rf_packets': 977747939,
                                             'dl_rf_packets_dropped': 153000,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.51.66.49',
                                             'mac_address': '0a:00:3e:70:8c:ba',
                                             'name': 'Tasha Gadzinski',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 28262400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -98.5,
                                             'ul_rf_bytes': 413386982,
                                             'ul_rf_packets': 347432109,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 35.5},
                '0a:00:3e:70:8d:b6': {       'alt_macs': {       '1a:00:3e:70:8d:b6',
                                                                 '2a:00:3e:70:8d:b6',
                                                                 '3a:00:3e:70:8d:b6',
                                                                 '4a:00:3e:70:8d:b6'},
                                             'dev_macs': {'78:d2:94:84:3d:16'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 41472000,
                                             'dl_mcs': 3,
                                             'dl_modulation_rate': 300,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 659687130,
                                             'dl_rf_packets': 25390254,
                                             'dl_rf_packets_dropped': 2037,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.51.66.48',
                                             'mac_address': '0a:00:3e:70:8d:b6',
                                             'name': 'Darlene Lewis',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 37683200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -100.15,
                                             'ul_rf_bytes': 1621674727,
                                             'ul_rf_packets': 11380873,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -62.15,
                                             'ul_snr': 38.0},
                '0a:00:3e:70:8d:d1': {       'alt_macs': {       '1a:00:3e:70:8d:d1',
                                                                 '2a:00:3e:70:8d:d1',
                                                                 '3a:00:3e:70:8d:d1',
                                                                 '4a:00:3e:70:8d:d1'},
                                             'dev_macs': {'cc:40:d0:01:09:a8'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 82944000,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2274016619,
                                             'dl_rf_packets': 869295527,
                                             'dl_rf_packets_dropped': 518529,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.51.66.45',
                                             'mac_address': '0a:00:3e:70:8d:d1',
                                             'name': 'Jensen Hund',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 37683200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -104.6,
                                             'ul_rf_bytes': 3775783815,
                                             'ul_rf_packets': 244457102,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -60.6,
                                             'ul_snr': 44.0},
                '0a:00:3e:70:8e:95': {       'alt_macs': {       '1a:00:3e:70:8e:95',
                                                                 '2a:00:3e:70:8e:95',
                                                                 '3a:00:3e:70:8e:95',
                                                                 '4a:00:3e:70:8e:95'},
                                             'dev_macs': {'c0:56:27:dc:56:c2'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 110592000,
                                             'dl_mcs': 8,
                                             'dl_modulation_rate': 800,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4035774099,
                                             'dl_rf_packets': 22988180,
                                             'dl_rf_packets_dropped': 81504,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.51.66.43',
                                             'mac_address': '0a:00:3e:70:8e:95',
                                             'name': 'Matthew McClelland',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 37683200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -98.0,
                                             'ul_rf_bytes': 1273436075,
                                             'ul_rf_packets': 17009887,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 39.0}
        }
        exp_ne_msg = {
                'data': {       'elevation': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1507486666',
                                                              'in_octets': '9605708473598',
                                                              'in_ucast_pkts': '6646849634',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '0a:00:3e:60:46:91',
                                                              'mtu': 1514,
                                                              'name': 'Ethernet',
                                                              'oper_up': True,
                                                              'out_discards': '12',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1704812',
                                                              'out_octets': '331564532952',
                                                              'out_ucast_pkts': '2847650172',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1507486666',
                                                              'in_octets': '9605708473598',
                                                              'in_ucast_pkts': '6646849634',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '78:d2:94:84:3d:16'],
                                                                                       'in_octets': '1621674727',
                                                                                       'in_ucast_pkts': '11380873',
                                                                                       'mac_address': '0a:00:3e:70:8d:b6',
                                                                                       'out_discards': '2037',
                                                                                       'out_octets': '659687130',
                                                                                       'out_ucast_pkts': '25390254'},
                                                                               {       'bridged_mac_addresses': [       '8c:3b:ad:3b:e3:99'],
                                                                                       'in_octets': '413386982',
                                                                                       'in_ucast_pkts': '347432109',
                                                                                       'mac_address': '0a:00:3e:70:8c:ba',
                                                                                       'out_discards': '153000',
                                                                                       'out_octets': '3415757113',
                                                                                       'out_ucast_pkts': '977747939'},
                                                                               {       'bridged_mac_addresses': [       'ec:1a:59:43:ec:d0'],
                                                                                       'in_octets': '82830196',
                                                                                       'in_ucast_pkts': '75611258',
                                                                                       'mac_address': '0a:00:3e:70:8c:95',
                                                                                       'out_discards': '411253',
                                                                                       'out_octets': '1983084618',
                                                                                       'out_ucast_pkts': '300439975'},
                                                                               {       'bridged_mac_addresses': [       'cc:40:d0:01:09:a8'],
                                                                                       'in_octets': '3775783815',
                                                                                       'in_ucast_pkts': '244457102',
                                                                                       'mac_address': '0a:00:3e:70:8d:d1',
                                                                                       'out_discards': '518529',
                                                                                       'out_octets': '2274016619',
                                                                                       'out_ucast_pkts': '869295527'},
                                                                               {       'bridged_mac_addresses': [       'c0:56:27:dc:56:c2'],
                                                                                       'in_octets': '1273436075',
                                                                                       'in_ucast_pkts': '17009887',
                                                                                       'mac_address': '0a:00:3e:70:8e:95',
                                                                                       'out_discards': '81504',
                                                                                       'out_octets': '4035774099',
                                                                                       'out_ucast_pkts': '22988180'}],
                                                              'mac_address': '1a:00:3e:60:46:91',
                                                              'mtu': 1500,
                                                              'name': 'Canopy '
                                                                      'MultiPoint',
                                                              'oper_up': True,
                                                              'out_discards': '9833726',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1704812',
                                                              'out_octets': '331564532952',
                                                              'out_ucast_pkts': '2847650172',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5735,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_frutl': 3.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '587969',
                                                                                                                                            'mac_address': '0a:00:3e:70:8d:b6',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '37683200',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 39.0,
                                                                                                                                            'tx_link_rate': '41472000',
                                                                                                                                            'tx_modulation_rate': 300.0},
                                                                                                                                    {       'connected_time': '5725182',
                                                                                                                                            'mac_address': '0a:00:3e:70:8c:ba',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '28262400',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '55296000',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '2863938',
                                                                                                                                            'mac_address': '0a:00:3e:70:8c:95',
                                                                                                                                            'noise_floor': -105.9,
                                                                                                                                            'rssi': -61.9,
                                                                                                                                            'rx_link_rate': '37683200',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 44.0,
                                                                                                                                            'tx_link_rate': '82944000',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '6443305',
                                                                                                                                            'mac_address': '0a:00:3e:70:8d:d1',
                                                                                                                                            'noise_floor': -106.2,
                                                                                                                                            'rssi': -62.2,
                                                                                                                                            'rx_link_rate': '37683200',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 44.0,
                                                                                                                                            'tx_link_rate': '82944000',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '59151',
                                                                                                                                            'mac_address': '0a:00:3e:70:8e:95',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '37683200',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 40.0,
                                                                                                                                            'tx_link_rate': '110592000',
                                                                                                                                            'tx_modulation_rate': 800.0}],
                                                                                                                   'noise_floor': -94.0,
                                                                                                                   'polarization': 'VERTICAL'},
                                                                                                           {       'id': '2',
                                                                                                                   'links': [       {       'connected_time': '587969',
                                                                                                                                            'mac_address': '0a:00:3e:70:8d:b6',
                                                                                                                                            'noise_floor': -101.3,
                                                                                                                                            'rssi': -64.3,
                                                                                                                                            'rx_link_rate': '37683200',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_link_rate': '41472000',
                                                                                                                                            'tx_modulation_rate': 300.0},
                                                                                                                                    {       'connected_time': '5725182',
                                                                                                                                            'mac_address': '0a:00:3e:70:8c:ba',
                                                                                                                                            'noise_floor': -103.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '28262400',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '55296000',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '2863938',
                                                                                                                                            'mac_address': '0a:00:3e:70:8c:95',
                                                                                                                                            'noise_floor': -99.9,
                                                                                                                                            'rssi': -58.9,
                                                                                                                                            'rx_link_rate': '37683200',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_link_rate': '82944000',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '6443305',
                                                                                                                                            'mac_address': '0a:00:3e:70:8d:d1',
                                                                                                                                            'noise_floor': -103.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '37683200',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 44.0,
                                                                                                                                            'tx_link_rate': '82944000',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '59151',
                                                                                                                                            'mac_address': '0a:00:3e:70:8e:95',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '37683200',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 38.0,
                                                                                                                                            'tx_link_rate': '110592000',
                                                                                                                                            'tx_modulation_rate': 800.0}],
                                                                                                                   'noise_floor': -99.0,
                                                                                                                   'polarization': 'HORIZONTAL'}],
                                                                                        'tx_frutl': 22.0,
                                                                                        'tx_multiplexing_gain': 1.0,
                                                                                        'tx_power': 10}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'latitude': 0.0,
                                'longitude': 0.0,
                                'manufacturer': 'Cambium',
                                'model': 'PMP 450m',
                                'serial_number': 'M9UC0PZ41CKN',
                                'sw_version': 'CANOPY 15.1.3 AP-None',
                                'system_mac_address': '0a:00:3e:60:46:91',
                                'temperature': 16.0,
                                'uptime': '11234138'},
                'peers': [       {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '2037',
                                                                       'in_octets': '659687130',
                                                                       'in_ucast_pkts': '25390254',
                                                                       'links': [       {       'in_octets': '1621674727',
                                                                                                'in_ucast_pkts': '11380873',
                                                                                                'mac_address': '1a:00:3e:60:46:91',
                                                                                                'out_octets': '659687130',
                                                                                                'out_ucast_pkts': '25390254'}],
                                                                       'mac_address': '0a:00:3e:70:8d:b6',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1621674727',
                                                                       'out_ucast_pkts': '11380873',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5735,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '41472000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '587969',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '41472000',
                                                                                                                                                     'rx_modulation_rate': 300.0,
                                                                                                                                                     'tx_link_rate': '37683200',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '587969',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '41472000',
                                                                                                                                                     'rx_modulation_rate': 300.0,
                                                                                                                                                     'tx_link_rate': '37683200',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '37683200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.51.66.48',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'Darlene Lewis',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.3',
                                         'system_mac_address': '0a:00:3e:70:8d:b6'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '153000',
                                                                       'in_octets': '3415757113',
                                                                       'in_ucast_pkts': '977747939',
                                                                       'links': [       {       'in_octets': '413386982',
                                                                                                'in_ucast_pkts': '347432109',
                                                                                                'mac_address': '1a:00:3e:60:46:91',
                                                                                                'out_octets': '3415757113',
                                                                                                'out_ucast_pkts': '977747939'}],
                                                                       'mac_address': '0a:00:3e:70:8c:ba',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '413386982',
                                                                       'out_ucast_pkts': '347432109',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5735,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '55296000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '5725182',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '55296000',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '28262400',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '5725182',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '55296000',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '28262400',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '28262400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.51.66.49',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'Tasha Gadzinski',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:70:8c:ba'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '411253',
                                                                       'in_octets': '1983084618',
                                                                       'in_ucast_pkts': '300439975',
                                                                       'links': [       {       'in_octets': '82830196',
                                                                                                'in_ucast_pkts': '75611258',
                                                                                                'mac_address': '1a:00:3e:60:46:91',
                                                                                                'out_octets': '1983084618',
                                                                                                'out_ucast_pkts': '300439975'}],
                                                                       'mac_address': '0a:00:3e:70:8c:95',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '82830196',
                                                                       'out_ucast_pkts': '75611258',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5735,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '82944000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2863938',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '82944000',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '37683200',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '2863938',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '82944000',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '37683200',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '37683200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.51.66.58',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'Emmet Wingert',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.3',
                                         'system_mac_address': '0a:00:3e:70:8c:95'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '518529',
                                                                       'in_octets': '2274016619',
                                                                       'in_ucast_pkts': '869295527',
                                                                       'links': [       {       'in_octets': '3775783815',
                                                                                                'in_ucast_pkts': '244457102',
                                                                                                'mac_address': '1a:00:3e:60:46:91',
                                                                                                'out_octets': '2274016619',
                                                                                                'out_ucast_pkts': '869295527'}],
                                                                       'mac_address': '0a:00:3e:70:8d:d1',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3775783815',
                                                                       'out_ucast_pkts': '244457102',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5735,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '82944000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '6443305',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '82944000',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '37683200',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '6443305',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '82944000',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '37683200',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '37683200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.51.66.45',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'Jensen Hund',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:70:8d:d1'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '81504',
                                                                       'in_octets': '4035774099',
                                                                       'in_ucast_pkts': '22988180',
                                                                       'links': [       {       'in_octets': '1273436075',
                                                                                                'in_ucast_pkts': '17009887',
                                                                                                'mac_address': '1a:00:3e:60:46:91',
                                                                                                'out_octets': '4035774099',
                                                                                                'out_ucast_pkts': '22988180'}],
                                                                       'mac_address': '0a:00:3e:70:8e:95',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1273436075',
                                                                       'out_ucast_pkts': '17009887',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5735,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '110592000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '59151',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '110592000',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '37683200',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '59151',
                                                                                                                                                     'mac_address': '1a:00:3e:60:46:91',
                                                                                                                                                     'rx_link_rate': '110592000',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '37683200',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '37683200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.51.66.43',
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'Matthew McClelland',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.3',
                                         'system_mac_address': '0a:00:3e:70:8e:95'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_canopy_450m_PMP_450m_15_1_5_01(self):
        obj = self.run_data("cambium-canopy.450m.PMP 450m.15.1.5.01")
        exp_info = {
                'model': 'PMP 450m',
                'rf_chan_width': 20,
                'rf_dl_percent': 80,
                'rf_freq': 5840,
                'rf_tx_power': 20,
                'sta_count': 67,
                'sw_version': 'CANOPY 15.1.5 AP-DES',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'dl_en_bytes': 174657164505446,
                'dl_en_packets': 125694389142,
                'dl_frutl': 99.0,
                'dl_multiplexing_gain': 2.36,
                'dl_noise_floor': None,
                'dl_rf_bytes': 11729020165727,
                'dl_rf_packets': 64008896234,
                'dl_rf_packets_dropped': 0,
                'en_if_speed': 1000000000,
                'ul_en_bytes': 11729020165727,
                'ul_en_packets': 64008896234,
                'ul_frutl': 97.0,
                'ul_multiplexing_gain': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 174657164638628,
                'ul_rf_packets': 125694389142,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
                '0a:00:3e:75:73:58': {       'alt_macs': {       '1a:00:3e:75:73:58',
                                                                 '2a:00:3e:75:73:58',
                                                                 '3a:00:3e:75:73:58',
                                                                 '4a:00:3e:75:73:58'},
                                             'dev_macs': {'00:04:56:15:6c:e9'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1333574172,
                                             'dl_rf_packets': 173106885,
                                             'dl_rf_packets_dropped': 80,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:73:58',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -96.75,
                                             'ul_rf_bytes': 1359838632,
                                             'ul_rf_packets': 104187357,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.75,
                                             'ul_snr': 31.0},
                '0a:00:3e:75:86:11': {       'alt_macs': {       '1a:00:3e:75:86:11',
                                                                 '2a:00:3e:75:86:11',
                                                                 '3a:00:3e:75:86:11',
                                                                 '4a:00:3e:75:86:11'},
                                             'dev_macs': {'00:04:56:15:93:69'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2715089097,
                                             'dl_rf_packets': 50364526,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:86:11',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.05,
                                             'ul_rf_bytes': 189826403,
                                             'ul_rf_packets': 21022279,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -67.55,
                                             'ul_snr': 26.5},
                '0a:00:3e:75:88:e9': {       'alt_macs': {       '1a:00:3e:75:88:e9',
                                                                 '2a:00:3e:75:88:e9',
                                                                 '3a:00:3e:75:88:e9',
                                                                 '4a:00:3e:75:88:e9'},
                                             'dev_macs': {'00:04:56:14:f1:d9'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2215506619,
                                             'dl_rf_packets': 634571631,
                                             'dl_rf_packets_dropped': 45393,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:88:e9',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -92.7,
                                             'ul_rf_bytes': 2493235775,
                                             'ul_rf_packets': 364540493,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.2,
                                             'ul_snr': 27.5},
                '0a:00:3e:75:89:27': {       'alt_macs': {       '1a:00:3e:75:89:27',
                                                                 '2a:00:3e:75:89:27',
                                                                 '3a:00:3e:75:89:27',
                                                                 '4a:00:3e:75:89:27'},
                                             'dev_macs': {'00:04:56:15:03:19'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 86690369,
                                             'dl_rf_packets': 593277077,
                                             'dl_rf_packets_dropped': 76376,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:89:27',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -100.0,
                                             'ul_rf_bytes': 2490623504,
                                             'ul_rf_packets': 323183365,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -70.5,
                                             'ul_snr': 29.5},
                '0a:00:3e:75:89:43': {       'alt_macs': {       '1a:00:3e:75:89:43',
                                                                 '2a:00:3e:75:89:43',
                                                                 '3a:00:3e:75:89:43',
                                                                 '4a:00:3e:75:89:43'},
                                             'dev_macs': {'00:04:56:15:0b:d1'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 82045743,
                                             'dl_rf_packets': 211446513,
                                             'dl_rf_packets_dropped': 3511,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:89:43',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 13107200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 400,
                                             'ul_noise_floor': -87.65,
                                             'ul_rf_bytes': 3009801092,
                                             'ul_rf_packets': 109272436,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.65,
                                             'ul_snr': 24.0},
                '0a:00:3e:75:89:61': {       'alt_macs': {       '1a:00:3e:75:89:61',
                                                                 '2a:00:3e:75:89:61',
                                                                 '3a:00:3e:75:89:61',
                                                                 '4a:00:3e:75:89:61'},
                                             'dev_macs': {'00:04:56:17:65:21'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2709914301,
                                             'dl_rf_packets': 227322988,
                                             'dl_rf_packets_dropped': 1202,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:89:61',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -96.0,
                                             'ul_rf_bytes': 1802137093,
                                             'ul_rf_packets': 170886585,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.5,
                                             'ul_snr': 30.5},
                '0a:00:3e:75:89:77': {       'alt_macs': {       '1a:00:3e:75:89:77',
                                                                 '2a:00:3e:75:89:77',
                                                                 '3a:00:3e:75:89:77',
                                                                 '4a:00:3e:75:89:77'},
                                             'dev_macs': {'00:04:56:17:86:21'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 332715305,
                                             'dl_rf_packets': 78488333,
                                             'dl_rf_packets_dropped': 4338,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:89:77',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 26214400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -100.5,
                                             'ul_rf_bytes': 3804384279,
                                             'ul_rf_packets': 43367703,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.5,
                                             'ul_snr': 35.0},
                '0a:00:3e:75:89:c2': {       'alt_macs': {       '1a:00:3e:75:89:c2',
                                                                 '2a:00:3e:75:89:c2',
                                                                 '3a:00:3e:75:89:c2',
                                                                 '4a:00:3e:75:89:c2'},
                                             'dev_macs': {'00:04:56:14:f2:11'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1678233896,
                                             'dl_rf_packets': 66862575,
                                             'dl_rf_packets_dropped': 22,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:89:c2',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -97.4,
                                             'ul_rf_bytes': 363872546,
                                             'ul_rf_packets': 36395406,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -69.9,
                                             'ul_snr': 27.5},
                '0a:00:3e:75:89:c7': {       'alt_macs': {       '1a:00:3e:75:89:c7',
                                                                 '2a:00:3e:75:89:c7',
                                                                 '3a:00:3e:75:89:c7',
                                                                 '4a:00:3e:75:89:c7'},
                                             'dev_macs': {'00:04:56:15:9f:e1'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3280671092,
                                             'dl_rf_packets': 181168426,
                                             'dl_rf_packets_dropped': 3269,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:89:c7',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -93.95,
                                             'ul_rf_bytes': 3734965170,
                                             'ul_rf_packets': 71094029,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -67.95,
                                             'ul_snr': 26.0},
                '0a:00:3e:75:89:e3': {       'alt_macs': {       '1a:00:3e:75:89:e3',
                                                                 '2a:00:3e:75:89:e3',
                                                                 '3a:00:3e:75:89:e3',
                                                                 '4a:00:3e:75:89:e3'},
                                             'dev_macs': {'00:04:56:11:23:71'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3676738331,
                                             'dl_rf_packets': 492811489,
                                             'dl_rf_packets_dropped': 413031,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:89:e3',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -97.9,
                                             'ul_rf_bytes': 2019353252,
                                             'ul_rf_packets': 223865145,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -67.9,
                                             'ul_snr': 30.0},
                '0a:00:3e:75:89:f0': {       'alt_macs': {       '1a:00:3e:75:89:f0',
                                                                 '2a:00:3e:75:89:f0',
                                                                 '3a:00:3e:75:89:f0',
                                                                 '4a:00:3e:75:89:f0'},
                                             'dev_macs': {'00:04:56:19:f6:59'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 410,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2332892602,
                                             'dl_rf_packets': 159749468,
                                             'dl_rf_packets_dropped': 2824,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:89:f0',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -101.95,
                                             'ul_rf_bytes': 2949638348,
                                             'ul_rf_packets': 113648633,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -68.45,
                                             'ul_snr': 33.5},
                '0a:00:3e:75:89:fd': {       'alt_macs': {       '1a:00:3e:75:89:fd',
                                                                 '2a:00:3e:75:89:fd',
                                                                 '3a:00:3e:75:89:fd',
                                                                 '4a:00:3e:75:89:fd'},
                                             'dev_macs': {'00:04:56:15:c8:a1'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2609846349,
                                             'dl_rf_packets': 103629207,
                                             'dl_rf_packets_dropped': 1428,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:89:fd',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 13107200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 400,
                                             'ul_noise_floor': -87.95,
                                             'ul_rf_bytes': 4199162746,
                                             'ul_rf_packets': 44587839,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -67.95,
                                             'ul_snr': 20.0},
                '0a:00:3e:75:8a:53': {       'alt_macs': {       '1a:00:3e:75:8a:53',
                                                                 '2a:00:3e:75:8a:53',
                                                                 '3a:00:3e:75:8a:53',
                                                                 '4a:00:3e:75:8a:53'},
                                             'dev_macs': {'00:04:56:14:f1:b1'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4208960405,
                                             'dl_rf_packets': 351900815,
                                             'dl_rf_packets_dropped': 37402,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:8a:53',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -92.85,
                                             'ul_rf_bytes': 2973449671,
                                             'ul_rf_packets': 205558777,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.35,
                                             'ul_snr': 29.5},
                '0a:00:3e:75:8a:76': {       'alt_macs': {       '1a:00:3e:75:8a:76',
                                                                 '2a:00:3e:75:8a:76',
                                                                 '3a:00:3e:75:8a:76',
                                                                 '4a:00:3e:75:8a:76'},
                                             'dev_macs': {'00:04:56:14:f4:11'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1747474813,
                                             'dl_rf_packets': 25910015,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:8a:76',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -96.6,
                                             'ul_rf_bytes': 2026032296,
                                             'ul_rf_packets': 17436762,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -67.1,
                                             'ul_snr': 29.5},
                '0a:00:3e:75:8a:7c': {       'alt_macs': {       '1a:00:3e:75:8a:7c',
                                                                 '2a:00:3e:75:8a:7c',
                                                                 '3a:00:3e:75:8a:7c',
                                                                 '4a:00:3e:75:8a:7c'},
                                             'dev_macs': {'00:04:56:11:23:11'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3774132477,
                                             'dl_rf_packets': 539347354,
                                             'dl_rf_packets_dropped': 1482,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:8a:7c',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -96.5,
                                             'ul_rf_bytes': 189291744,
                                             'ul_rf_packets': 300731824,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 32.5},
                '0a:00:3e:75:8a:85': {       'alt_macs': {       '1a:00:3e:75:8a:85',
                                                                 '2a:00:3e:75:8a:85',
                                                                 '3a:00:3e:75:8a:85',
                                                                 '4a:00:3e:75:8a:85'},
                                             'dev_macs': {'00:04:56:18:da:d1'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4034967465,
                                             'dl_rf_packets': 99537332,
                                             'dl_rf_packets_dropped': 680,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:8a:85',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 26214400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -100.2,
                                             'ul_rf_bytes': 3272384891,
                                             'ul_rf_packets': 67956059,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.2,
                                             'ul_snr': 35.0},
                '0a:00:3e:75:8a:dc': {       'alt_macs': {       '1a:00:3e:75:8a:dc',
                                                                 '2a:00:3e:75:8a:dc',
                                                                 '3a:00:3e:75:8a:dc',
                                                                 '4a:00:3e:75:8a:dc'},
                                             'dev_macs': {'00:04:56:17:85:b1'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 296600505,
                                             'dl_rf_packets': 151615394,
                                             'dl_rf_packets_dropped': 2140,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:8a:dc',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -92.75,
                                             'ul_rf_bytes': 3923933277,
                                             'ul_rf_packets': 96115825,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -67.75,
                                             'ul_snr': 25.0},
                '0a:00:3e:75:9d:bc': {       'alt_macs': {       '1a:00:3e:75:9d:bc',
                                                                 '2a:00:3e:75:9d:bc',
                                                                 '3a:00:3e:75:9d:bc',
                                                                 '4a:00:3e:75:9d:bc'},
                                             'dev_macs': {'00:04:56:1a:10:b1'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2525367039,
                                             'dl_rf_packets': 162272328,
                                             'dl_rf_packets_dropped': 33927,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:9d:bc',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -96.1,
                                             'ul_rf_bytes': 1591335164,
                                             'ul_rf_packets': 85747851,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.1,
                                             'ul_snr': 31.0},
                '0a:00:3e:75:9e:04': {       'alt_macs': {       '1a:00:3e:75:9e:04',
                                                                 '2a:00:3e:75:9e:04',
                                                                 '3a:00:3e:75:9e:04',
                                                                 '4a:00:3e:75:9e:04'},
                                             'dev_macs': {'00:04:56:1b:3f:79'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2015105589,
                                             'dl_rf_packets': 120266064,
                                             'dl_rf_packets_dropped': 239,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:9e:04',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 26214400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -101.4,
                                             'ul_rf_bytes': 1745523899,
                                             'ul_rf_packets': 79324033,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.4,
                                             'ul_snr': 36.0},
                '0a:00:3e:75:9e:69': {       'alt_macs': {       '1a:00:3e:75:9e:69',
                                                                 '2a:00:3e:75:9e:69',
                                                                 '3a:00:3e:75:9e:69',
                                                                 '4a:00:3e:75:9e:69'},
                                             'dev_macs': {'00:04:56:17:6c:c1'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1337737701,
                                             'dl_rf_packets': 436226609,
                                             'dl_rf_packets_dropped': 71936,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:9e:69',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -98.1,
                                             'ul_rf_bytes': 1294116850,
                                             'ul_rf_packets': 236057307,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -70.1,
                                             'ul_snr': 28.0},
                '0a:00:3e:75:9f:23': {       'alt_macs': {       '1a:00:3e:75:9f:23',
                                                                 '2a:00:3e:75:9f:23',
                                                                 '3a:00:3e:75:9f:23',
                                                                 '4a:00:3e:75:9f:23'},
                                             'dev_macs': {'00:04:56:18:8c:b9'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3441555227,
                                             'dl_rf_packets': 222189158,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:9f:23',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 26214400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -102.1,
                                             'ul_rf_bytes': 3701339757,
                                             'ul_rf_packets': 118758458,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.6,
                                             'ul_snr': 37.5},
                '0a:00:3e:75:a0:86': {       'alt_macs': {       '1a:00:3e:75:a0:86',
                                                                 '2a:00:3e:75:a0:86',
                                                                 '3a:00:3e:75:a0:86',
                                                                 '4a:00:3e:75:a0:86'},
                                             'dev_macs': {'00:04:56:1b:35:61'},
                                             'dl_exp_modulation_rate': 800,
                                             'dl_link_rate': 104857600,
                                             'dl_mcs': 8,
                                             'dl_modulation_rate': 800,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 347164330,
                                             'dl_rf_packets': 135996576,
                                             'dl_rf_packets_dropped': 1142,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:a0:86',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -91.9,
                                             'ul_rf_bytes': 3363942760,
                                             'ul_rf_packets': 85497932,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.9,
                                             'ul_snr': 28.0},
                '0a:00:3e:75:a1:9d': {       'alt_macs': {       '1a:00:3e:75:a1:9d',
                                                                 '2a:00:3e:75:a1:9d',
                                                                 '3a:00:3e:75:a1:9d',
                                                                 '4a:00:3e:75:a1:9d'},
                                             'dev_macs': {'00:04:56:12:92:59'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2307486457,
                                             'dl_rf_packets': 523037757,
                                             'dl_rf_packets_dropped': 391416,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:a1:9d',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -96.15,
                                             'ul_rf_bytes': 602818337,
                                             'ul_rf_packets': 302040743,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.65,
                                             'ul_snr': 30.5},
                '0a:00:3e:75:a3:18': {       'alt_macs': {       '1a:00:3e:75:a3:18',
                                                                 '2a:00:3e:75:a3:18',
                                                                 '3a:00:3e:75:a3:18',
                                                                 '4a:00:3e:75:a3:18'},
                                             'dev_macs': {'00:04:56:1a:21:21'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1058990868,
                                             'dl_rf_packets': 474467113,
                                             'dl_rf_packets_dropped': 15532,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:a3:18',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.0,
                                             'ul_rf_bytes': 2890504927,
                                             'ul_rf_packets': 172200331,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 27.0},
                '0a:00:3e:75:a5:b4': {       'alt_macs': {       '1a:00:3e:75:a5:b4',
                                                                 '2a:00:3e:75:a5:b4',
                                                                 '3a:00:3e:75:a5:b4',
                                                                 '4a:00:3e:75:a5:b4'},
                                             'dev_macs': {'00:04:56:1b:58:c9'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4152376510,
                                             'dl_rf_packets': 1089651218,
                                             'dl_rf_packets_dropped': 1113785,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:a5:b4',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 13107200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 400,
                                             'ul_noise_floor': -87.2,
                                             'ul_rf_bytes': 1987524331,
                                             'ul_rf_packets': 611509221,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.7,
                                             'ul_snr': 23.5},
                '0a:00:3e:75:a6:c1': {       'alt_macs': {       '1a:00:3e:75:a6:c1',
                                                                 '2a:00:3e:75:a6:c1',
                                                                 '3a:00:3e:75:a6:c1',
                                                                 '4a:00:3e:75:a6:c1'},
                                             'dev_macs': {'00:04:56:1b:23:49'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3306280272,
                                             'dl_rf_packets': 39135757,
                                             'dl_rf_packets_dropped': 10949,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:a6:c1',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -100.4,
                                             'ul_rf_bytes': 129518392,
                                             'ul_rf_packets': 32739637,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.9,
                                             'ul_snr': 34.5},
                '0a:00:3e:75:b0:a2': {       'alt_macs': {       '1a:00:3e:75:b0:a2',
                                                                 '2a:00:3e:75:b0:a2',
                                                                 '3a:00:3e:75:b0:a2',
                                                                 '4a:00:3e:75:b0:a2'},
                                             'dev_macs': {'00:04:56:1a:22:59'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 26214400,
                                             'dl_mcs': 2,
                                             'dl_modulation_rate': 170,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 172083958,
                                             'dl_rf_packets': 5732008,
                                             'dl_rf_packets_dropped': 1315,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:b0:a2',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -101.1,
                                             'ul_rf_bytes': 851243131,
                                             'ul_rf_packets': 6739648,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -70.6,
                                             'ul_snr': 30.5},
                '0a:00:3e:75:b1:aa': {       'alt_macs': {       '1a:00:3e:75:b1:aa',
                                                                 '2a:00:3e:75:b1:aa',
                                                                 '3a:00:3e:75:b1:aa',
                                                                 '4a:00:3e:75:b1:aa'},
                                             'dev_macs': {'00:04:56:1a:13:61'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1679597808,
                                             'dl_rf_packets': 7492884,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:b1:aa',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -93.25,
                                             'ul_rf_bytes': 434012680,
                                             'ul_rf_packets': 3752658,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.75,
                                             'ul_snr': 29.5},
                '0a:00:3e:75:db:d1': {       'alt_macs': {       '1a:00:3e:75:db:d1',
                                                                 '2a:00:3e:75:db:d1',
                                                                 '3a:00:3e:75:db:d1',
                                                                 '4a:00:3e:75:db:d1'},
                                             'dev_macs': {'00:04:56:1b:3c:99'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2584743787,
                                             'dl_rf_packets': 629845115,
                                             'dl_rf_packets_dropped': 745815,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:75:db:d1',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -96.65,
                                             'ul_rf_bytes': 4200902272,
                                             'ul_rf_packets': 376295767,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.65,
                                             'ul_snr': 31.0},
                '0a:00:3e:76:15:21': {       'alt_macs': {       '1a:00:3e:76:15:21',
                                                                 '2a:00:3e:76:15:21',
                                                                 '3a:00:3e:76:15:21',
                                                                 '4a:00:3e:76:15:21'},
                                             'dev_macs': {'00:04:56:15:3f:f1'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3257194216,
                                             'dl_rf_packets': 330306084,
                                             'dl_rf_packets_dropped': 53777,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:15:21',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 26214400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -97.5,
                                             'ul_rf_bytes': 2745458251,
                                             'ul_rf_packets': 199242806,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.5,
                                             'ul_snr': 34.0},
                '0a:00:3e:76:1f:70': {       'alt_macs': {       '1a:00:3e:76:1f:70',
                                                                 '2a:00:3e:76:1f:70',
                                                                 '3a:00:3e:76:1f:70',
                                                                 '4a:00:3e:76:1f:70'},
                                             'dev_macs': {'00:04:56:1b:14:99'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3813064303,
                                             'dl_rf_packets': 45164347,
                                             'dl_rf_packets_dropped': 3002,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:1f:70',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 13107200,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 400,
                                             'ul_noise_floor': -85.5,
                                             'ul_rf_bytes': 4104091616,
                                             'ul_rf_packets': 29035487,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.5,
                                             'ul_snr': 20.0},
                '0a:00:3e:76:23:e7': {       'alt_macs': {       '1a:00:3e:76:23:e7',
                                                                 '2a:00:3e:76:23:e7',
                                                                 '3a:00:3e:76:23:e7',
                                                                 '4a:00:3e:76:23:e7'},
                                             'dev_macs': {'00:04:56:1d:48:91'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2908890094,
                                             'dl_rf_packets': 443856517,
                                             'dl_rf_packets_dropped': 186523,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:23:e7',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.1,
                                             'ul_rf_bytes': 3737856497,
                                             'ul_rf_packets': 229750707,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.6,
                                             'ul_snr': 29.5},
                '0a:00:3e:76:2e:bc': {       'alt_macs': {       '1a:00:3e:76:2e:bc',
                                                                 '2a:00:3e:76:2e:bc',
                                                                 '3a:00:3e:76:2e:bc',
                                                                 '4a:00:3e:76:2e:bc'},
                                             'dev_macs': {'00:04:56:12:92:39'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3060144877,
                                             'dl_rf_packets': 190000537,
                                             'dl_rf_packets_dropped': 1756,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:2e:bc',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 26214400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -98.95,
                                             'ul_rf_bytes': 4080666512,
                                             'ul_rf_packets': 88898516,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.95,
                                             'ul_snr': 35.0},
                '0a:00:3e:76:35:4e': {       'alt_macs': {       '1a:00:3e:76:35:4e',
                                                                 '2a:00:3e:76:35:4e',
                                                                 '3a:00:3e:76:35:4e',
                                                                 '4a:00:3e:76:35:4e'},
                                             'dev_macs': {'00:04:56:1a:22:51'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 511935515,
                                             'dl_rf_packets': 20466066,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:35:4e',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -98.0,
                                             'ul_rf_bytes': 961297369,
                                             'ul_rf_packets': 12421472,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.0,
                                             'ul_snr': 33.0},
                '0a:00:3e:76:3c:fc': {       'alt_macs': {       '1a:00:3e:76:3c:fc',
                                                                 '2a:00:3e:76:3c:fc',
                                                                 '3a:00:3e:76:3c:fc',
                                                                 '4a:00:3e:76:3c:fc'},
                                             'dev_macs': {'00:04:56:06:85:99'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2600898505,
                                             'dl_rf_packets': 71728068,
                                             'dl_rf_packets_dropped': 12177,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:3c:fc',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -98.95,
                                             'ul_rf_bytes': 587397911,
                                             'ul_rf_packets': 42081132,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -62.95,
                                             'ul_snr': 36.0},
                '0a:00:3e:76:40:f0': {       'alt_macs': {       '1a:00:3e:76:40:f0',
                                                                 '2a:00:3e:76:40:f0',
                                                                 '3a:00:3e:76:40:f0',
                                                                 '4a:00:3e:76:40:f0'},
                                             'dev_macs': {'00:04:56:18:9c:c9'},
                                             'dl_exp_modulation_rate': 800,
                                             'dl_link_rate': 104857600,
                                             'dl_mcs': 8,
                                             'dl_modulation_rate': 800,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 319875706,
                                             'dl_rf_packets': 844518613,
                                             'dl_rf_packets_dropped': 62289,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:40:f0',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -93.0,
                                             'ul_rf_bytes': 3257662461,
                                             'ul_rf_packets': 476333659,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.5,
                                             'ul_snr': 29.5},
                '0a:00:3e:76:43:67': {       'alt_macs': {       '1a:00:3e:76:43:67',
                                                                 '2a:00:3e:76:43:67',
                                                                 '3a:00:3e:76:43:67',
                                                                 '4a:00:3e:76:43:67'},
                                             'dev_macs': {'00:04:56:1b:67:01'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 104857600,
                                             'dl_mcs': 8,
                                             'dl_modulation_rate': 800,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1646886159,
                                             'dl_rf_packets': 824069598,
                                             'dl_rf_packets_dropped': 310297,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:43:67',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 26214400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -99.45,
                                             'ul_rf_bytes': 1780955673,
                                             'ul_rf_packets': 478021388,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.45,
                                             'ul_snr': 36.0},
                '0a:00:3e:76:48:9c': {       'alt_macs': {       '1a:00:3e:76:48:9c',
                                                                 '2a:00:3e:76:48:9c',
                                                                 '3a:00:3e:76:48:9c',
                                                                 '4a:00:3e:76:48:9c'},
                                             'dev_macs': {'00:04:56:1e:3e:31'},
                                             'dl_exp_modulation_rate': 800,
                                             'dl_link_rate': 104857600,
                                             'dl_mcs': 8,
                                             'dl_modulation_rate': 800,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 222585468,
                                             'dl_rf_packets': 6264367,
                                             'dl_rf_packets_dropped': 96,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:48:9c',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -91.85,
                                             'ul_rf_bytes': 308012612,
                                             'ul_rf_packets': 3395728,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.35,
                                             'ul_snr': 28.5},
                '0a:00:3e:76:77:25': {       'alt_macs': {       '1a:00:3e:76:77:25',
                                                                 '2a:00:3e:76:77:25',
                                                                 '3a:00:3e:76:77:25',
                                                                 '4a:00:3e:76:77:25'},
                                             'dev_macs': {'00:04:56:1d:10:09'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 453147360,
                                             'dl_rf_packets': 44418700,
                                             'dl_rf_packets_dropped': 28131,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:77:25',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -97.0,
                                             'ul_rf_bytes': 3889575485,
                                             'ul_rf_packets': 27342661,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.0,
                                             'ul_snr': 32.0},
                '0a:00:3e:76:7e:5b': {       'alt_macs': {       '1a:00:3e:76:7e:5b',
                                                                 '2a:00:3e:76:7e:5b',
                                                                 '3a:00:3e:76:7e:5b',
                                                                 '4a:00:3e:76:7e:5b'},
                                             'dev_macs': {'00:04:56:1b:54:11'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4086595371,
                                             'dl_rf_packets': 92315856,
                                             'dl_rf_packets_dropped': 904,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:7e:5b',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 660,
                                             'ul_noise_floor': -93.45,
                                             'ul_rf_bytes': 3389410539,
                                             'ul_rf_packets': 32408319,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.45,
                                             'ul_snr': 30.0},
                '0a:00:3e:76:7e:e4': {       'alt_macs': {       '1a:00:3e:76:7e:e4',
                                                                 '2a:00:3e:76:7e:e4',
                                                                 '3a:00:3e:76:7e:e4',
                                                                 '4a:00:3e:76:7e:e4'},
                                             'dev_macs': {'00:04:56:19:f1:d9'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 26214400,
                                             'dl_mcs': 2,
                                             'dl_modulation_rate': 200,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 915620192,
                                             'dl_rf_packets': 111097629,
                                             'dl_rf_packets_dropped': 9912,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:7e:e4',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -95.5,
                                             'ul_rf_bytes': 1911300665,
                                             'ul_rf_packets': 58602544,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -68.0,
                                             'ul_snr': 27.5},
                '0a:00:3e:76:7f:91': {       'alt_macs': {       '1a:00:3e:76:7f:91',
                                                                 '2a:00:3e:76:7f:91',
                                                                 '3a:00:3e:76:7f:91',
                                                                 '4a:00:3e:76:7f:91'},
                                             'dev_macs': {'00:04:56:1a:22:99'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2972078691,
                                             'dl_rf_packets': 99038965,
                                             'dl_rf_packets_dropped': 1665,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:76:7f:91',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -95.7,
                                             'ul_rf_bytes': 2402346683,
                                             'ul_rf_packets': 61020257,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.7,
                                             'ul_snr': 32.0},
                '0a:00:3e:b4:4f:00': {       'alt_macs': {       '1a:00:3e:b4:4f:00',
                                                                 '2a:00:3e:b4:4f:00',
                                                                 '3a:00:3e:b4:4f:00',
                                                                 '4a:00:3e:b4:4f:00'},
                                             'dev_macs': {'00:04:56:1b:64:39'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3621438270,
                                             'dl_rf_packets': 55046844,
                                             'dl_rf_packets_dropped': 16184,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:b4:4f:00',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -97.1,
                                             'ul_rf_bytes': 1575409785,
                                             'ul_rf_packets': 37251400,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.599999999999994,
                                             'ul_snr': 33.5},
                '0a:00:3e:b4:52:46': {       'alt_macs': {       '1a:00:3e:b4:52:46',
                                                                 '2a:00:3e:b4:52:46',
                                                                 '3a:00:3e:b4:52:46',
                                                                 '4a:00:3e:b4:52:46'},
                                             'dev_macs': {'00:04:56:0a:81:79'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 816522858,
                                             'dl_rf_packets': 383431075,
                                             'dl_rf_packets_dropped': 92668,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:b4:52:46',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -95.0,
                                             'ul_rf_bytes': 3655871347,
                                             'ul_rf_packets': 158564650,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.5,
                                             'ul_snr': 31.5},
                '0a:00:3e:b4:52:a1': {       'alt_macs': {       '1a:00:3e:b4:52:a1',
                                                                 '2a:00:3e:b4:52:a1',
                                                                 '3a:00:3e:b4:52:a1',
                                                                 '4a:00:3e:b4:52:a1'},
                                             'dev_macs': {'00:04:56:15:a0:21'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1040459534,
                                             'dl_rf_packets': 89747055,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:b4:52:a1',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -95.7,
                                             'ul_rf_bytes': 2560795753,
                                             'ul_rf_packets': 67335213,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -66.2,
                                             'ul_snr': 29.5},
                '0a:00:3e:b4:73:dd': {       'alt_macs': {       '1a:00:3e:b4:73:dd',
                                                                 '2a:00:3e:b4:73:dd',
                                                                 '3a:00:3e:b4:73:dd',
                                                                 '4a:00:3e:b4:73:dd'},
                                             'dev_macs': {'00:04:56:06:83:79'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 104857600,
                                             'dl_mcs': 8,
                                             'dl_modulation_rate': 800,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3397810074,
                                             'dl_rf_packets': 430616059,
                                             'dl_rf_packets_dropped': 259213,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:b4:73:dd',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -97.0,
                                             'ul_rf_bytes': 3721539142,
                                             'ul_rf_packets': 233037318,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 33.0},
                '0a:00:3e:b4:75:9d': {       'alt_macs': {       '1a:00:3e:b4:75:9d',
                                                                 '2a:00:3e:b4:75:9d',
                                                                 '3a:00:3e:b4:75:9d',
                                                                 '4a:00:3e:b4:75:9d'},
                                             'dev_macs': {'00:04:56:15:87:01'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1922055214,
                                             'dl_rf_packets': 227359955,
                                             'dl_rf_packets_dropped': 177,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:b4:75:9d',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -91.75,
                                             'ul_rf_bytes': 3428037747,
                                             'ul_rf_packets': 165079855,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.25,
                                             'ul_snr': 27.5},
                '0a:00:3e:b4:94:3f': {       'alt_macs': {       '1a:00:3e:b4:94:3f',
                                                                 '2a:00:3e:b4:94:3f',
                                                                 '3a:00:3e:b4:94:3f',
                                                                 '4a:00:3e:b4:94:3f'},
                                             'dev_macs': {'00:04:56:15:57:d9'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 247827588,
                                             'dl_rf_packets': 250520329,
                                             'dl_rf_packets_dropped': 20973,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:b4:94:3f',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -98.0,
                                             'ul_rf_bytes': 1086442537,
                                             'ul_rf_packets': 90364733,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.5,
                                             'ul_snr': 34.5},
                '0a:00:3e:b4:9e:5e': {       'alt_macs': {       '1a:00:3e:b4:9e:5e',
                                                                 '2a:00:3e:b4:9e:5e',
                                                                 '3a:00:3e:b4:9e:5e',
                                                                 '4a:00:3e:b4:9e:5e'},
                                             'dev_macs': {'00:04:56:0a:8b:29'},
                                             'dl_exp_modulation_rate': 800,
                                             'dl_link_rate': 104857600,
                                             'dl_mcs': 8,
                                             'dl_modulation_rate': 800,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3333235078,
                                             'dl_rf_packets': 356486004,
                                             'dl_rf_packets_dropped': 126195,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:b4:9e:5e',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.0,
                                             'ul_rf_bytes': 202527714,
                                             'ul_rf_packets': 196140893,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.5,
                                             'ul_snr': 30.5},
                '0a:00:3e:b4:a0:c7': {       'alt_macs': {       '1a:00:3e:b4:a0:c7',
                                                                 '2a:00:3e:b4:a0:c7',
                                                                 '3a:00:3e:b4:a0:c7',
                                                                 '4a:00:3e:b4:a0:c7'},
                                             'dev_macs': {'00:04:56:15:0f:c9'},
                                             'dl_exp_modulation_rate': 400,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3386493003,
                                             'dl_rf_packets': 147479849,
                                             'dl_rf_packets_dropped': 367000,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:b4:a0:c7',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -96.85,
                                             'ul_rf_bytes': 4124930670,
                                             'ul_rf_packets': 66145776,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -68.85,
                                             'ul_snr': 28.0},
                '0a:00:3e:ba:aa:bf': {       'alt_macs': {       '1a:00:3e:ba:aa:bf',
                                                                 '2a:00:3e:ba:aa:bf',
                                                                 '3a:00:3e:ba:aa:bf',
                                                                 '4a:00:3e:ba:aa:bf'},
                                             'dev_macs': {'00:04:56:15:36:81'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3087143142,
                                             'dl_rf_packets': 159255912,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:aa:bf',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 26214400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -99.45,
                                             'ul_rf_bytes': 1840895442,
                                             'ul_rf_packets': 112911725,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.45,
                                             'ul_snr': 35.0},
                '0a:00:3e:ba:ad:3d': {       'alt_macs': {       '1a:00:3e:ba:ad:3d',
                                                                 '2a:00:3e:ba:ad:3d',
                                                                 '3a:00:3e:ba:ad:3d',
                                                                 '4a:00:3e:ba:ad:3d'},
                                             'dev_macs': {'00:04:56:06:86:89'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 336317066,
                                             'dl_rf_packets': 41324582,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:ad:3d',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -93.9,
                                             'ul_rf_bytes': 3341066605,
                                             'ul_rf_packets': 29000403,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.9,
                                             'ul_snr': 29.0},
                '0a:00:3e:ba:af:b2': {       'alt_macs': {       '1a:00:3e:ba:af:b2',
                                                                 '2a:00:3e:ba:af:b2',
                                                                 '3a:00:3e:ba:af:b2',
                                                                 '4a:00:3e:ba:af:b2'},
                                             'dev_macs': {'00:04:56:15:49:11'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 298268821,
                                             'dl_rf_packets': 472113402,
                                             'dl_rf_packets_dropped': 251514,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:af:b2',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -100.0,
                                             'ul_rf_bytes': 3023599474,
                                             'ul_rf_packets': 270584675,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 36.0},
                '0a:00:3e:ba:bf:47': {       'alt_macs': {       '1a:00:3e:ba:bf:47',
                                                                 '2a:00:3e:ba:bf:47',
                                                                 '3a:00:3e:ba:bf:47',
                                                                 '4a:00:3e:ba:bf:47'},
                                             'dev_macs': {'00:04:56:0b:70:f1'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2848373924,
                                             'dl_rf_packets': 272183262,
                                             'dl_rf_packets_dropped': 24911,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:bf:47',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.5,
                                             'ul_rf_bytes': 20167873,
                                             'ul_rf_packets': 235347319,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.5,
                                             'ul_snr': 31.0},
                '0a:00:3e:ba:e4:f7': {       'alt_macs': {       '1a:00:3e:ba:e4:f7',
                                                                 '2a:00:3e:ba:e4:f7',
                                                                 '3a:00:3e:ba:e4:f7',
                                                                 '4a:00:3e:ba:e4:f7'},
                                             'dev_macs': {'00:04:56:15:e3:b9'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3780950787,
                                             'dl_rf_packets': 572133598,
                                             'dl_rf_packets_dropped': 25784,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:e4:f7',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -95.2,
                                             'ul_rf_bytes': 820401692,
                                             'ul_rf_packets': 369584809,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.2,
                                             'ul_snr': 31.0},
                '0a:00:3e:ba:e5:15': {       'alt_macs': {       '1a:00:3e:ba:e5:15',
                                                                 '2a:00:3e:ba:e5:15',
                                                                 '3a:00:3e:ba:e5:15',
                                                                 '4a:00:3e:ba:e5:15'},
                                             'dev_macs': {'00:04:56:15:63:71'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 52428800,
                                             'dl_mcs': 4,
                                             'dl_modulation_rate': 400,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3666208577,
                                             'dl_rf_packets': 10245235,
                                             'dl_rf_packets_dropped': 1702,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:e5:15',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.55000000000001,
                                             'ul_rf_bytes': 2279585034,
                                             'ul_rf_packets': 4515170,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -67.05000000000001,
                                             'ul_snr': 27.5},
                '0a:00:3e:ba:e7:92': {       'alt_macs': {       '1a:00:3e:ba:e7:92',
                                                                 '2a:00:3e:ba:e7:92',
                                                                 '3a:00:3e:ba:e7:92',
                                                                 '4a:00:3e:ba:e7:92'},
                                             'dev_macs': {'00:04:56:0f:97:f9'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3260493090,
                                             'dl_rf_packets': 104378078,
                                             'dl_rf_packets_dropped': 7454,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:e7:92',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 989811996,
                                             'ul_rf_packets': 50187623,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.5,
                                             'ul_snr': 28.5},
                '0a:00:3e:ba:e8:c7': {       'alt_macs': {       '1a:00:3e:ba:e8:c7',
                                                                 '2a:00:3e:ba:e8:c7',
                                                                 '3a:00:3e:ba:e8:c7',
                                                                 '4a:00:3e:ba:e8:c7'},
                                             'dev_macs': {'00:04:56:14:f2:29'},
                                             'dl_exp_modulation_rate': 0,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 0,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2143559610,
                                             'dl_rf_packets': 107361886,
                                             'dl_rf_packets_dropped': 5681,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:e8:c7',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 0,
                                             'ul_link_rate': None,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 0,
                                             'ul_noise_floor': -97.5,
                                             'ul_rf_bytes': 2299481456,
                                             'ul_rf_packets': 68976464,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 33.5},
                '0a:00:3e:ba:e9:23': {       'alt_macs': {       '1a:00:3e:ba:e9:23',
                                                                 '2a:00:3e:ba:e9:23',
                                                                 '3a:00:3e:ba:e9:23',
                                                                 '4a:00:3e:ba:e9:23'},
                                             'dev_macs': {'00:04:56:15:48:89'},
                                             'dl_exp_modulation_rate': 0,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 0,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1024356488,
                                             'dl_rf_packets': 29522377,
                                             'dl_rf_packets_dropped': 868,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:e9:23',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 0,
                                             'ul_link_rate': None,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 0,
                                             'ul_noise_floor': -96.25,
                                             'ul_rf_bytes': 1685836329,
                                             'ul_rf_packets': 29902591,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -66.25,
                                             'ul_snr': 30.0},
                '0a:00:3e:ba:e9:31': {       'alt_macs': {       '1a:00:3e:ba:e9:31',
                                                                 '2a:00:3e:ba:e9:31',
                                                                 '3a:00:3e:ba:e9:31',
                                                                 '4a:00:3e:ba:e9:31'},
                                             'dev_macs': {'00:04:56:0f:99:e1'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4259567971,
                                             'dl_rf_packets': 181296509,
                                             'dl_rf_packets_dropped': 9174,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:e9:31',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 26214400,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 800,
                                             'ul_noise_floor': -102.0,
                                             'ul_rf_bytes': 721790815,
                                             'ul_rf_packets': 101806955,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.5,
                                             'ul_snr': 38.5},
                '0a:00:3e:ba:ea:5b': {       'alt_macs': {       '1a:00:3e:ba:ea:5b',
                                                                 '2a:00:3e:ba:ea:5b',
                                                                 '3a:00:3e:ba:ea:5b',
                                                                 '4a:00:3e:ba:ea:5b'},
                                             'dev_macs': {'00:04:56:1a:1d:e9'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 69967567,
                                             'dl_rf_packets': 617261,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:ea:5b',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.95,
                                             'ul_rf_bytes': 156851789,
                                             'ul_rf_packets': 1173678,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -66.45,
                                             'ul_snr': 28.5},
                '0a:00:3e:ba:ea:60': {       'alt_macs': {       '1a:00:3e:ba:ea:60',
                                                                 '2a:00:3e:ba:ea:60',
                                                                 '3a:00:3e:ba:ea:60',
                                                                 '4a:00:3e:ba:ea:60'},
                                             'dev_macs': {'00:04:56:11:20:49'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2182703219,
                                             'dl_rf_packets': 68984503,
                                             'dl_rf_packets_dropped': 8687,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:ea:60',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -95.0,
                                             'ul_rf_bytes': 3841311594,
                                             'ul_rf_packets': 35227330,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 31.0},
                '0a:00:3e:ba:ea:65': {       'alt_macs': {       '1a:00:3e:ba:ea:65',
                                                                 '2a:00:3e:ba:ea:65',
                                                                 '3a:00:3e:ba:ea:65',
                                                                 '4a:00:3e:ba:ea:65'},
                                             'dev_macs': {'00:04:56:04:d4:89'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4095663621,
                                             'dl_rf_packets': 1097528054,
                                             'dl_rf_packets_dropped': 263166,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:ea:65',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -92.95,
                                             'ul_rf_bytes': 3420161297,
                                             'ul_rf_packets': 712041225,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.95,
                                             'ul_snr': 27.0},
                '0a:00:3e:ba:ea:66': {       'alt_macs': {       '1a:00:3e:ba:ea:66',
                                                                 '2a:00:3e:ba:ea:66',
                                                                 '3a:00:3e:ba:ea:66',
                                                                 '4a:00:3e:ba:ea:66'},
                                             'dev_macs': {'00:04:56:15:49:b1'},
                                             'dl_exp_modulation_rate': 0,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 0,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 1327578492,
                                             'dl_rf_packets': 207633703,
                                             'dl_rf_packets_dropped': 90285,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:ea:66',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 0,
                                             'ul_link_rate': None,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 0,
                                             'ul_noise_floor': -96.5,
                                             'ul_rf_bytes': 1882912694,
                                             'ul_rf_packets': 111649998,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -66.5,
                                             'ul_snr': 30.0},
                '0a:00:3e:ba:ea:78': {       'alt_macs': {       '1a:00:3e:ba:ea:78',
                                                                 '2a:00:3e:ba:ea:78',
                                                                 '3a:00:3e:ba:ea:78',
                                                                 '4a:00:3e:ba:ea:78'},
                                             'dev_macs': {'00:04:56:15:57:a1'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2971549872,
                                             'dl_rf_packets': 1939534645,
                                             'dl_rf_packets_dropped': 265355,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:ea:78',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -95.2,
                                             'ul_rf_bytes': 2151013857,
                                             'ul_rf_packets': 946066768,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -65.2,
                                             'ul_snr': 30.0},
                '0a:00:3e:ba:ea:7a': {       'alt_macs': {       '1a:00:3e:ba:ea:7a',
                                                                 '2a:00:3e:ba:ea:7a',
                                                                 '3a:00:3e:ba:ea:7a',
                                                                 '4a:00:3e:ba:ea:7a'},
                                             'dev_macs': {'00:04:56:0f:99:d1'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 691704403,
                                             'dl_rf_packets': 13560450,
                                             'dl_rf_packets_dropped': 1641,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:ea:7a',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -97.0,
                                             'ul_rf_bytes': 1629413038,
                                             'ul_rf_packets': 9113484,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -66.0,
                                             'ul_snr': 31.0},
                '0a:00:3e:ba:ea:d8': {       'alt_macs': {       '1a:00:3e:ba:ea:d8',
                                                                 '2a:00:3e:ba:ea:d8',
                                                                 '3a:00:3e:ba:ea:d8',
                                                                 '4a:00:3e:ba:ea:d8'},
                                             'dev_macs': {'00:04:56:11:21:41'},
                                             'dl_exp_modulation_rate': 600,
                                             'dl_link_rate': 78643200,
                                             'dl_mcs': 6,
                                             'dl_modulation_rate': 600,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 4122203591,
                                             'dl_rf_packets': 511879284,
                                             'dl_rf_packets_dropped': 13570,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '0a:00:3e:ba:ea:d8',
                                             'name': 'No Site Name',
                                             'ul_exp_modulation_rate': 800,
                                             'ul_link_rate': 19660800,
                                             'ul_mcs': None,
                                             'ul_modulation_rate': 600,
                                             'ul_noise_floor': -94.45,
                                             'ul_rf_bytes': 1080899193,
                                             'ul_rf_packets': 306478852,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -63.45,
                                             'ul_snr': 31.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 100.0,
                                'elevation': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '1973',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '29205361',
                                                              'in_octets': '174657164505446',
                                                              'in_ucast_pkts': '125665183781',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '0a:00:3e:60:3f:60',
                                                              'mtu': 1514,
                                                              'name': 'Ethernet',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '3190777',
                                                              'out_octets': '11729020165727',
                                                              'out_ucast_pkts': '64005705457',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '1572',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '29205361',
                                                              'in_octets': '174657164638628',
                                                              'in_ucast_pkts': '125665183781',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '00:04:56:1b:3c:99'],
                                                                                       'in_octets': '4200902272',
                                                                                       'in_ucast_pkts': '376295767',
                                                                                       'mac_address': '0a:00:3e:75:db:d1',
                                                                                       'out_discards': '745815',
                                                                                       'out_octets': '2584743787',
                                                                                       'out_ucast_pkts': '629845115'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:17:65:21'],
                                                                                       'in_octets': '1802137093',
                                                                                       'in_ucast_pkts': '170886585',
                                                                                       'mac_address': '0a:00:3e:75:89:61',
                                                                                       'out_discards': '1202',
                                                                                       'out_octets': '2709914301',
                                                                                       'out_ucast_pkts': '227322988'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1b:3f:79'],
                                                                                       'in_octets': '1745523899',
                                                                                       'in_ucast_pkts': '79324033',
                                                                                       'mac_address': '0a:00:3e:75:9e:04',
                                                                                       'out_discards': '239',
                                                                                       'out_octets': '2015105589',
                                                                                       'out_ucast_pkts': '120266064'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:6c:e9'],
                                                                                       'in_octets': '1359838632',
                                                                                       'in_ucast_pkts': '104187357',
                                                                                       'mac_address': '0a:00:3e:75:73:58',
                                                                                       'out_discards': '80',
                                                                                       'out_octets': '1333574172',
                                                                                       'out_ucast_pkts': '173106885'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:3f:f1'],
                                                                                       'in_octets': '2745458251',
                                                                                       'in_ucast_pkts': '199242806',
                                                                                       'mac_address': '0a:00:3e:76:15:21',
                                                                                       'out_discards': '53777',
                                                                                       'out_octets': '3257194216',
                                                                                       'out_ucast_pkts': '330306084'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1b:54:11'],
                                                                                       'in_octets': '3389410539',
                                                                                       'in_ucast_pkts': '32408319',
                                                                                       'mac_address': '0a:00:3e:76:7e:5b',
                                                                                       'out_discards': '904',
                                                                                       'out_octets': '4086595371',
                                                                                       'out_ucast_pkts': '92315856'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:14:f2:11'],
                                                                                       'in_octets': '363872546',
                                                                                       'in_ucast_pkts': '36395406',
                                                                                       'mac_address': '0a:00:3e:75:89:c2',
                                                                                       'out_discards': '22',
                                                                                       'out_octets': '1678233896',
                                                                                       'out_ucast_pkts': '66862575'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1d:10:09'],
                                                                                       'in_octets': '3889575485',
                                                                                       'in_ucast_pkts': '27342661',
                                                                                       'mac_address': '0a:00:3e:76:77:25',
                                                                                       'out_discards': '28131',
                                                                                       'out_octets': '453147360',
                                                                                       'out_ucast_pkts': '44418700'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:19:f1:d9'],
                                                                                       'in_octets': '1911300665',
                                                                                       'in_ucast_pkts': '58602544',
                                                                                       'mac_address': '0a:00:3e:76:7e:e4',
                                                                                       'out_discards': '9912',
                                                                                       'out_octets': '915620192',
                                                                                       'out_ucast_pkts': '111097629'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:9f:e1'],
                                                                                       'in_octets': '3734965170',
                                                                                       'in_ucast_pkts': '71094029',
                                                                                       'mac_address': '0a:00:3e:75:89:c7',
                                                                                       'out_discards': '3269',
                                                                                       'out_octets': '3280671092',
                                                                                       'out_ucast_pkts': '181168426'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:93:69'],
                                                                                       'in_octets': '189826403',
                                                                                       'in_ucast_pkts': '21022279',
                                                                                       'mac_address': '0a:00:3e:75:86:11',
                                                                                       'out_octets': '2715089097',
                                                                                       'out_ucast_pkts': '50364526'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:c8:a1'],
                                                                                       'in_octets': '4199162746',
                                                                                       'in_ucast_pkts': '44587839',
                                                                                       'mac_address': '0a:00:3e:75:89:fd',
                                                                                       'out_discards': '1428',
                                                                                       'out_octets': '2609846349',
                                                                                       'out_ucast_pkts': '103629207'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:18:8c:b9'],
                                                                                       'in_octets': '3701339757',
                                                                                       'in_ucast_pkts': '118758458',
                                                                                       'mac_address': '0a:00:3e:75:9f:23',
                                                                                       'out_octets': '3441555227',
                                                                                       'out_ucast_pkts': '222189158'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1b:35:61'],
                                                                                       'in_octets': '3363942760',
                                                                                       'in_ucast_pkts': '85497932',
                                                                                       'mac_address': '0a:00:3e:75:a0:86',
                                                                                       'out_discards': '1142',
                                                                                       'out_octets': '347164330',
                                                                                       'out_ucast_pkts': '135996576'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1a:21:21'],
                                                                                       'in_octets': '2890504927',
                                                                                       'in_ucast_pkts': '172200331',
                                                                                       'mac_address': '0a:00:3e:75:a3:18',
                                                                                       'out_discards': '15532',
                                                                                       'out_octets': '1058990868',
                                                                                       'out_ucast_pkts': '474467113'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1b:58:c9'],
                                                                                       'in_octets': '1987524331',
                                                                                       'in_ucast_pkts': '611509221',
                                                                                       'mac_address': '0a:00:3e:75:a5:b4',
                                                                                       'out_discards': '1113785',
                                                                                       'out_octets': '4152376510',
                                                                                       'out_ucast_pkts': '1089651218'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:0b:d1'],
                                                                                       'in_octets': '3009801092',
                                                                                       'in_ucast_pkts': '109272436',
                                                                                       'mac_address': '0a:00:3e:75:89:43',
                                                                                       'out_discards': '3511',
                                                                                       'out_octets': '82045743',
                                                                                       'out_ucast_pkts': '211446513'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1d:48:91'],
                                                                                       'in_octets': '3737856497',
                                                                                       'in_ucast_pkts': '229750707',
                                                                                       'mac_address': '0a:00:3e:76:23:e7',
                                                                                       'out_discards': '186523',
                                                                                       'out_octets': '2908890094',
                                                                                       'out_ucast_pkts': '443856517'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:11:23:11'],
                                                                                       'in_octets': '189291744',
                                                                                       'in_ucast_pkts': '300731824',
                                                                                       'mac_address': '0a:00:3e:75:8a:7c',
                                                                                       'out_discards': '1482',
                                                                                       'out_octets': '3774132477',
                                                                                       'out_ucast_pkts': '539347354'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:11:23:71'],
                                                                                       'in_octets': '2019353252',
                                                                                       'in_ucast_pkts': '223865145',
                                                                                       'mac_address': '0a:00:3e:75:89:e3',
                                                                                       'out_discards': '413031',
                                                                                       'out_octets': '3676738331',
                                                                                       'out_ucast_pkts': '492811489'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:12:92:59'],
                                                                                       'in_octets': '602818337',
                                                                                       'in_ucast_pkts': '302040743',
                                                                                       'mac_address': '0a:00:3e:75:a1:9d',
                                                                                       'out_discards': '391416',
                                                                                       'out_octets': '2307486457',
                                                                                       'out_ucast_pkts': '523037757'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1a:10:b1'],
                                                                                       'in_octets': '1591335164',
                                                                                       'in_ucast_pkts': '85747851',
                                                                                       'mac_address': '0a:00:3e:75:9d:bc',
                                                                                       'out_discards': '33927',
                                                                                       'out_octets': '2525367039',
                                                                                       'out_ucast_pkts': '162272328'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:17:86:21'],
                                                                                       'in_octets': '3804384279',
                                                                                       'in_ucast_pkts': '43367703',
                                                                                       'mac_address': '0a:00:3e:75:89:77',
                                                                                       'out_discards': '4338',
                                                                                       'out_octets': '332715305',
                                                                                       'out_ucast_pkts': '78488333'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1a:13:61'],
                                                                                       'in_octets': '434012680',
                                                                                       'in_ucast_pkts': '3752658',
                                                                                       'mac_address': '0a:00:3e:75:b1:aa',
                                                                                       'out_octets': '1679597808',
                                                                                       'out_ucast_pkts': '7492884'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:17:85:b1'],
                                                                                       'in_octets': '3923933277',
                                                                                       'in_ucast_pkts': '96115825',
                                                                                       'mac_address': '0a:00:3e:75:8a:dc',
                                                                                       'out_discards': '2140',
                                                                                       'out_octets': '296600505',
                                                                                       'out_ucast_pkts': '151615394'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:14:f1:b1'],
                                                                                       'in_octets': '2973449671',
                                                                                       'in_ucast_pkts': '205558777',
                                                                                       'mac_address': '0a:00:3e:75:8a:53',
                                                                                       'out_discards': '37402',
                                                                                       'out_octets': '4208960405',
                                                                                       'out_ucast_pkts': '351900815'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:18:9c:c9'],
                                                                                       'in_octets': '3257662461',
                                                                                       'in_ucast_pkts': '476333659',
                                                                                       'mac_address': '0a:00:3e:76:40:f0',
                                                                                       'out_discards': '62289',
                                                                                       'out_octets': '319875706',
                                                                                       'out_ucast_pkts': '844518613'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:06:85:99'],
                                                                                       'in_octets': '587397911',
                                                                                       'in_ucast_pkts': '42081132',
                                                                                       'mac_address': '0a:00:3e:76:3c:fc',
                                                                                       'out_discards': '12177',
                                                                                       'out_octets': '2600898505',
                                                                                       'out_ucast_pkts': '71728068'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1b:67:01'],
                                                                                       'in_octets': '1780955673',
                                                                                       'in_ucast_pkts': '478021388',
                                                                                       'mac_address': '0a:00:3e:76:43:67',
                                                                                       'out_discards': '310297',
                                                                                       'out_octets': '1646886159',
                                                                                       'out_ucast_pkts': '824069598'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:03:19'],
                                                                                       'in_octets': '2490623504',
                                                                                       'in_ucast_pkts': '323183365',
                                                                                       'mac_address': '0a:00:3e:75:89:27',
                                                                                       'out_discards': '76376',
                                                                                       'out_octets': '86690369',
                                                                                       'out_ucast_pkts': '593277077'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:0a:8b:29'],
                                                                                       'in_octets': '202527714',
                                                                                       'in_ucast_pkts': '196140893',
                                                                                       'mac_address': '0a:00:3e:b4:9e:5e',
                                                                                       'out_discards': '126195',
                                                                                       'out_octets': '3333235078',
                                                                                       'out_ucast_pkts': '356486004'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:0b:70:f1'],
                                                                                       'in_octets': '20167873',
                                                                                       'in_ucast_pkts': '235347319',
                                                                                       'mac_address': '0a:00:3e:ba:bf:47',
                                                                                       'out_discards': '24911',
                                                                                       'out_octets': '2848373924',
                                                                                       'out_ucast_pkts': '272183262'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:11:21:41'],
                                                                                       'in_octets': '1080899193',
                                                                                       'in_ucast_pkts': '306478852',
                                                                                       'mac_address': '0a:00:3e:ba:ea:d8',
                                                                                       'out_discards': '13570',
                                                                                       'out_octets': '4122203591',
                                                                                       'out_ucast_pkts': '511879284'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:63:71'],
                                                                                       'in_octets': '2279585034',
                                                                                       'in_ucast_pkts': '4515170',
                                                                                       'mac_address': '0a:00:3e:ba:e5:15',
                                                                                       'out_discards': '1702',
                                                                                       'out_octets': '3666208577',
                                                                                       'out_ucast_pkts': '10245235'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:0f:c9'],
                                                                                       'in_octets': '4124930670',
                                                                                       'in_ucast_pkts': '66145776',
                                                                                       'mac_address': '0a:00:3e:b4:a0:c7',
                                                                                       'out_discards': '367000',
                                                                                       'out_octets': '3386493003',
                                                                                       'out_ucast_pkts': '147479849'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:0f:99:e1'],
                                                                                       'in_octets': '721790815',
                                                                                       'in_ucast_pkts': '101806955',
                                                                                       'mac_address': '0a:00:3e:ba:e9:31',
                                                                                       'out_discards': '9174',
                                                                                       'out_octets': '4259567971',
                                                                                       'out_ucast_pkts': '181296509'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:0a:81:79'],
                                                                                       'in_octets': '3655871347',
                                                                                       'in_ucast_pkts': '158564650',
                                                                                       'mac_address': '0a:00:3e:b4:52:46',
                                                                                       'out_discards': '92668',
                                                                                       'out_octets': '816522858',
                                                                                       'out_ucast_pkts': '383431075'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:14:f4:11'],
                                                                                       'in_octets': '2026032296',
                                                                                       'in_ucast_pkts': '17436762',
                                                                                       'mac_address': '0a:00:3e:75:8a:76',
                                                                                       'out_octets': '1747474813',
                                                                                       'out_ucast_pkts': '25910015'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:e3:b9'],
                                                                                       'in_octets': '820401692',
                                                                                       'in_ucast_pkts': '369584809',
                                                                                       'mac_address': '0a:00:3e:ba:e4:f7',
                                                                                       'out_discards': '25784',
                                                                                       'out_octets': '3780950787',
                                                                                       'out_ucast_pkts': '572133598'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:0f:97:f9'],
                                                                                       'in_octets': '989811996',
                                                                                       'in_ucast_pkts': '50187623',
                                                                                       'mac_address': '0a:00:3e:ba:e7:92',
                                                                                       'out_discards': '7454',
                                                                                       'out_octets': '3260493090',
                                                                                       'out_ucast_pkts': '104378078'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:49:11'],
                                                                                       'in_octets': '3023599474',
                                                                                       'in_ucast_pkts': '270584675',
                                                                                       'mac_address': '0a:00:3e:ba:af:b2',
                                                                                       'out_discards': '251514',
                                                                                       'out_octets': '298268821',
                                                                                       'out_ucast_pkts': '472113402'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:57:a1'],
                                                                                       'in_octets': '2151013857',
                                                                                       'in_ucast_pkts': '946066768',
                                                                                       'mac_address': '0a:00:3e:ba:ea:78',
                                                                                       'out_discards': '265355',
                                                                                       'out_octets': '2971549872',
                                                                                       'out_ucast_pkts': '1939534645'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:04:d4:89'],
                                                                                       'in_octets': '3420161297',
                                                                                       'in_ucast_pkts': '712041225',
                                                                                       'mac_address': '0a:00:3e:ba:ea:65',
                                                                                       'out_discards': '263166',
                                                                                       'out_octets': '4095663621',
                                                                                       'out_ucast_pkts': '1097528054'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:0f:99:d1'],
                                                                                       'in_octets': '1629413038',
                                                                                       'in_ucast_pkts': '9113484',
                                                                                       'mac_address': '0a:00:3e:ba:ea:7a',
                                                                                       'out_discards': '1641',
                                                                                       'out_octets': '691704403',
                                                                                       'out_ucast_pkts': '13560450'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:57:d9'],
                                                                                       'in_octets': '1086442537',
                                                                                       'in_ucast_pkts': '90364733',
                                                                                       'mac_address': '0a:00:3e:b4:94:3f',
                                                                                       'out_discards': '20973',
                                                                                       'out_octets': '247827588',
                                                                                       'out_ucast_pkts': '250520329'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:11:20:49'],
                                                                                       'in_octets': '3841311594',
                                                                                       'in_ucast_pkts': '35227330',
                                                                                       'mac_address': '0a:00:3e:ba:ea:60',
                                                                                       'out_discards': '8687',
                                                                                       'out_octets': '2182703219',
                                                                                       'out_ucast_pkts': '68984503'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:87:01'],
                                                                                       'in_octets': '3428037747',
                                                                                       'in_ucast_pkts': '165079855',
                                                                                       'mac_address': '0a:00:3e:b4:75:9d',
                                                                                       'out_discards': '177',
                                                                                       'out_octets': '1922055214',
                                                                                       'out_ucast_pkts': '227359955'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:14:f1:d9'],
                                                                                       'in_octets': '2493235775',
                                                                                       'in_ucast_pkts': '364540493',
                                                                                       'mac_address': '0a:00:3e:75:88:e9',
                                                                                       'out_discards': '45393',
                                                                                       'out_octets': '2215506619',
                                                                                       'out_ucast_pkts': '634571631'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:06:86:89'],
                                                                                       'in_octets': '3341066605',
                                                                                       'in_ucast_pkts': '29000403',
                                                                                       'mac_address': '0a:00:3e:ba:ad:3d',
                                                                                       'out_octets': '336317066',
                                                                                       'out_ucast_pkts': '41324582'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:a0:21'],
                                                                                       'in_octets': '2560795753',
                                                                                       'in_ucast_pkts': '67335213',
                                                                                       'mac_address': '0a:00:3e:b4:52:a1',
                                                                                       'out_octets': '1040459534',
                                                                                       'out_ucast_pkts': '89747055'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:06:83:79'],
                                                                                       'in_octets': '3721539142',
                                                                                       'in_ucast_pkts': '233037318',
                                                                                       'mac_address': '0a:00:3e:b4:73:dd',
                                                                                       'out_discards': '259213',
                                                                                       'out_octets': '3397810074',
                                                                                       'out_ucast_pkts': '430616059'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:36:81'],
                                                                                       'in_octets': '1840895442',
                                                                                       'in_ucast_pkts': '112911725',
                                                                                       'mac_address': '0a:00:3e:ba:aa:bf',
                                                                                       'out_octets': '3087143142',
                                                                                       'out_ucast_pkts': '159255912'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1b:14:99'],
                                                                                       'in_octets': '4104091616',
                                                                                       'in_ucast_pkts': '29035487',
                                                                                       'mac_address': '0a:00:3e:76:1f:70',
                                                                                       'out_discards': '3002',
                                                                                       'out_octets': '3813064303',
                                                                                       'out_ucast_pkts': '45164347'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:49:b1'],
                                                                                       'in_octets': '1882912694',
                                                                                       'in_ucast_pkts': '111649998',
                                                                                       'mac_address': '0a:00:3e:ba:ea:66',
                                                                                       'out_discards': '90285',
                                                                                       'out_octets': '1327578492',
                                                                                       'out_ucast_pkts': '207633703'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:15:48:89'],
                                                                                       'in_octets': '1685836329',
                                                                                       'in_ucast_pkts': '29902591',
                                                                                       'mac_address': '0a:00:3e:ba:e9:23',
                                                                                       'out_discards': '868',
                                                                                       'out_octets': '1024356488',
                                                                                       'out_ucast_pkts': '29522377'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1a:1d:e9'],
                                                                                       'in_octets': '156851789',
                                                                                       'in_ucast_pkts': '1173678',
                                                                                       'mac_address': '0a:00:3e:ba:ea:5b',
                                                                                       'out_octets': '69967567',
                                                                                       'out_ucast_pkts': '617261'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:17:6c:c1'],
                                                                                       'in_octets': '1294116850',
                                                                                       'in_ucast_pkts': '236057307',
                                                                                       'mac_address': '0a:00:3e:75:9e:69',
                                                                                       'out_discards': '71936',
                                                                                       'out_octets': '1337737701',
                                                                                       'out_ucast_pkts': '436226609'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:14:f2:29'],
                                                                                       'in_octets': '2299481456',
                                                                                       'in_ucast_pkts': '68976464',
                                                                                       'mac_address': '0a:00:3e:ba:e8:c7',
                                                                                       'out_discards': '5681',
                                                                                       'out_octets': '2143559610',
                                                                                       'out_ucast_pkts': '107361886'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:12:92:39'],
                                                                                       'in_octets': '4080666512',
                                                                                       'in_ucast_pkts': '88898516',
                                                                                       'mac_address': '0a:00:3e:76:2e:bc',
                                                                                       'out_discards': '1756',
                                                                                       'out_octets': '3060144877',
                                                                                       'out_ucast_pkts': '190000537'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1a:22:59'],
                                                                                       'in_octets': '851243131',
                                                                                       'in_ucast_pkts': '6739648',
                                                                                       'mac_address': '0a:00:3e:75:b0:a2',
                                                                                       'out_discards': '1315',
                                                                                       'out_octets': '172083958',
                                                                                       'out_ucast_pkts': '5732008'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1a:22:99'],
                                                                                       'in_octets': '2402346683',
                                                                                       'in_ucast_pkts': '61020257',
                                                                                       'mac_address': '0a:00:3e:76:7f:91',
                                                                                       'out_discards': '1665',
                                                                                       'out_octets': '2972078691',
                                                                                       'out_ucast_pkts': '99038965'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1a:22:51'],
                                                                                       'in_octets': '961297369',
                                                                                       'in_ucast_pkts': '12421472',
                                                                                       'mac_address': '0a:00:3e:76:35:4e',
                                                                                       'out_octets': '511935515',
                                                                                       'out_ucast_pkts': '20466066'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:18:da:d1'],
                                                                                       'in_octets': '3272384891',
                                                                                       'in_ucast_pkts': '67956059',
                                                                                       'mac_address': '0a:00:3e:75:8a:85',
                                                                                       'out_discards': '680',
                                                                                       'out_octets': '4034967465',
                                                                                       'out_ucast_pkts': '99537332'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:19:f6:59'],
                                                                                       'in_octets': '2949638348',
                                                                                       'in_ucast_pkts': '113648633',
                                                                                       'mac_address': '0a:00:3e:75:89:f0',
                                                                                       'out_discards': '2824',
                                                                                       'out_octets': '2332892602',
                                                                                       'out_ucast_pkts': '159749468'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1b:64:39'],
                                                                                       'in_octets': '1575409785',
                                                                                       'in_ucast_pkts': '37251400',
                                                                                       'mac_address': '0a:00:3e:b4:4f:00',
                                                                                       'out_discards': '16184',
                                                                                       'out_octets': '3621438270',
                                                                                       'out_ucast_pkts': '55046844'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1b:23:49'],
                                                                                       'in_octets': '129518392',
                                                                                       'in_ucast_pkts': '32739637',
                                                                                       'mac_address': '0a:00:3e:75:a6:c1',
                                                                                       'out_discards': '10949',
                                                                                       'out_octets': '3306280272',
                                                                                       'out_ucast_pkts': '39135757'},
                                                                               {       'bridged_mac_addresses': [       '00:04:56:1e:3e:31'],
                                                                                       'in_octets': '308012612',
                                                                                       'in_ucast_pkts': '3395728',
                                                                                       'mac_address': '0a:00:3e:76:48:9c',
                                                                                       'out_discards': '96',
                                                                                       'out_octets': '222585468',
                                                                                       'out_ucast_pkts': '6264367'}],
                                                              'mac_address': '1a:00:3e:60:3f:60',
                                                              'mtu': 1500,
                                                              'name': 'Canopy '
                                                                      'MultiPoint',
                                                              'oper_up': True,
                                                              'out_discards': '48116544',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '3190777',
                                                              'out_octets': '11729020165727',
                                                              'out_ucast_pkts': '64005705457',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 80,
                                                                                        'frame_duration': 2500,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5840,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'rx_frutl': 97.0,
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '4446567',
                                                                                                                                            'mac_address': '0a:00:3e:75:db:d1',
                                                                                                                                            'noise_floor': -97.5,
                                                                                                                                            'rssi': -65.5,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446563',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:61',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '809889',
                                                                                                                                            'mac_address': '0a:00:3e:75:9e:04',
                                                                                                                                            'noise_floor': -101.8,
                                                                                                                                            'rssi': -64.8,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446563',
                                                                                                                                            'mac_address': '0a:00:3e:75:73:58',
                                                                                                                                            'noise_floor': -100.5,
                                                                                                                                            'rssi': -66.5,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '997913',
                                                                                                                                            'mac_address': '0a:00:3e:76:15:21',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1409251',
                                                                                                                                            'mac_address': '0a:00:3e:76:7e:5b',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 660.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2198867',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:c2',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '546452',
                                                                                                                                            'mac_address': '0a:00:3e:76:77:25',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1475863',
                                                                                                                                            'mac_address': '0a:00:3e:76:7e:e4',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '26214400',
                                                                                                                                            'tx_modulation_rate': 200.0},
                                                                                                                                    {       'connected_time': '2127294',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:c7',
                                                                                                                                            'noise_floor': -93.9,
                                                                                                                                            'rssi': -67.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '419229',
                                                                                                                                            'mac_address': '0a:00:3e:75:86:11',
                                                                                                                                            'noise_floor': -94.3,
                                                                                                                                            'rssi': -67.3,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '925287',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:fd',
                                                                                                                                            'noise_floor': -88.9,
                                                                                                                                            'rssi': -68.9,
                                                                                                                                            'rx_link_rate': '13107200',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1341404',
                                                                                                                                            'mac_address': '0a:00:3e:75:9f:23',
                                                                                                                                            'noise_floor': -101.2,
                                                                                                                                            'rssi': -63.2,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 38.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '954477',
                                                                                                                                            'mac_address': '0a:00:3e:75:a0:86',
                                                                                                                                            'noise_floor': -91.9,
                                                                                                                                            'rssi': -63.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '3199987',
                                                                                                                                            'mac_address': '0a:00:3e:75:a3:18',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '3661568',
                                                                                                                                            'mac_address': '0a:00:3e:75:a5:b4',
                                                                                                                                            'noise_floor': -90.4,
                                                                                                                                            'rssi': -63.4,
                                                                                                                                            'rx_link_rate': '13107200',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1237208',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:43',
                                                                                                                                            'noise_floor': -92.3,
                                                                                                                                            'rssi': -64.3,
                                                                                                                                            'rx_link_rate': '13107200',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '3624520',
                                                                                                                                            'mac_address': '0a:00:3e:76:23:e7',
                                                                                                                                            'noise_floor': -95.5,
                                                                                                                                            'rssi': -64.5,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '4446545',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:7c',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '4446555',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:e3',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1383777',
                                                                                                                                            'mac_address': '0a:00:3e:75:a1:9d',
                                                                                                                                            'noise_floor': -96.3,
                                                                                                                                            'rssi': -65.3,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1159775',
                                                                                                                                            'mac_address': '0a:00:3e:75:9d:bc',
                                                                                                                                            'noise_floor': -97.2,
                                                                                                                                            'rssi': -65.2,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1655118',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:77',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '234280',
                                                                                                                                            'mac_address': '0a:00:3e:75:b1:aa',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '633013',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:dc',
                                                                                                                                            'noise_floor': -92.5,
                                                                                                                                            'rssi': -67.5,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446565',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:53',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446564',
                                                                                                                                            'mac_address': '0a:00:3e:76:40:f0',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '803595',
                                                                                                                                            'mac_address': '0a:00:3e:76:3c:fc',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446565',
                                                                                                                                            'mac_address': '0a:00:3e:76:43:67',
                                                                                                                                            'noise_floor': -98.9,
                                                                                                                                            'rssi': -62.9,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '4446558',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:27',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -71.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '4446525',
                                                                                                                                            'mac_address': '0a:00:3e:b4:9e:5e',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '2454351',
                                                                                                                                            'mac_address': '0a:00:3e:ba:bf:47',
                                                                                                                                            'noise_floor': -93.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446405',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:d8',
                                                                                                                                            'noise_floor': -93.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '289083',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e5:15',
                                                                                                                                            'noise_floor': -93.2,
                                                                                                                                            'rssi': -66.2,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '2366620',
                                                                                                                                            'mac_address': '0a:00:3e:b4:a0:c7',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1433868',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e9:31',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1368610',
                                                                                                                                            'mac_address': '0a:00:3e:b4:52:46',
                                                                                                                                            'noise_floor': -93.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1414534',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:76',
                                                                                                                                            'noise_floor': -95.3,
                                                                                                                                            'rssi': -65.3,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446527',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e4:f7',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2103699',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e7:92',
                                                                                                                                            'noise_floor': -90.5,
                                                                                                                                            'rssi': -63.5,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1890510',
                                                                                                                                            'mac_address': '0a:00:3e:ba:af:b2',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446519',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:78',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446522',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:65',
                                                                                                                                            'noise_floor': -92.2,
                                                                                                                                            'rssi': -65.2,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1391452',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:7a',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446516',
                                                                                                                                            'mac_address': '0a:00:3e:b4:94:3f',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '267861',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:60',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446523',
                                                                                                                                            'mac_address': '0a:00:3e:b4:75:9d',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446541',
                                                                                                                                            'mac_address': '0a:00:3e:75:88:e9',
                                                                                                                                            'noise_floor': -91.4,
                                                                                                                                            'rssi': -64.4,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '984809',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ad:3d',
                                                                                                                                            'noise_floor': -95.9,
                                                                                                                                            'rssi': -64.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2144316',
                                                                                                                                            'mac_address': '0a:00:3e:b4:52:a1',
                                                                                                                                            'noise_floor': -99.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446517',
                                                                                                                                            'mac_address': '0a:00:3e:b4:73:dd',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '701908',
                                                                                                                                            'mac_address': '0a:00:3e:ba:aa:bf',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '425686',
                                                                                                                                            'mac_address': '0a:00:3e:76:1f:70',
                                                                                                                                            'noise_floor': -84.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '13107200',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '3414615',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:66',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '770096',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e9:23',
                                                                                                                                            'noise_floor': -95.5,
                                                                                                                                            'rssi': -64.5,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '473960',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:5b',
                                                                                                                                            'noise_floor': -93.2,
                                                                                                                                            'rssi': -65.2,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446561',
                                                                                                                                            'mac_address': '0a:00:3e:75:9e:69',
                                                                                                                                            'noise_floor': -95.9,
                                                                                                                                            'rssi': -69.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '4446349',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e8:c7',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2784285',
                                                                                                                                            'mac_address': '0a:00:3e:76:2e:bc',
                                                                                                                                            'noise_floor': -99.9,
                                                                                                                                            'rssi': -63.9,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '655759',
                                                                                                                                            'mac_address': '0a:00:3e:75:b0:a2',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '26214400',
                                                                                                                                            'tx_modulation_rate': 170.0},
                                                                                                                                    {       'connected_time': '1025375',
                                                                                                                                            'mac_address': '0a:00:3e:76:7f:91',
                                                                                                                                            'noise_floor': -94.4,
                                                                                                                                            'rssi': -62.4,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '25316',
                                                                                                                                            'mac_address': '0a:00:3e:76:35:4e',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2792704',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:85',
                                                                                                                                            'noise_floor': -99.4,
                                                                                                                                            'rssi': -64.4,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1310268',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:f0',
                                                                                                                                            'noise_floor': -104.7,
                                                                                                                                            'rssi': -68.7,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 410.0},
                                                                                                                                    {       'connected_time': '378543',
                                                                                                                                            'mac_address': '0a:00:3e:b4:4f:00',
                                                                                                                                            'noise_floor': -95.9,
                                                                                                                                            'rssi': -62.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '534141',
                                                                                                                                            'mac_address': '0a:00:3e:75:a6:c1',
                                                                                                                                            'noise_floor': -99.8,
                                                                                                                                            'rssi': -64.8,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '100670',
                                                                                                                                            'mac_address': '0a:00:3e:76:48:9c',
                                                                                                                                            'noise_floor': -92.7,
                                                                                                                                            'rssi': -63.7,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0}],
                                                                                                                   'noise_floor': -84.0,
                                                                                                                   'polarization': 'VERTICAL'},
                                                                                                           {       'id': '2',
                                                                                                                   'links': [       {       'connected_time': '4446567',
                                                                                                                                            'mac_address': '0a:00:3e:75:db:d1',
                                                                                                                                            'noise_floor': -95.8,
                                                                                                                                            'rssi': -65.8,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446563',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:61',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '809889',
                                                                                                                                            'mac_address': '0a:00:3e:75:9e:04',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446563',
                                                                                                                                            'mac_address': '0a:00:3e:75:73:58',
                                                                                                                                            'noise_floor': -93.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '997913',
                                                                                                                                            'mac_address': '0a:00:3e:76:15:21',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1409251',
                                                                                                                                            'mac_address': '0a:00:3e:76:7e:5b',
                                                                                                                                            'noise_floor': -94.9,
                                                                                                                                            'rssi': -63.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 660.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2198867',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:c2',
                                                                                                                                            'noise_floor': -94.8,
                                                                                                                                            'rssi': -68.8,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '546452',
                                                                                                                                            'mac_address': '0a:00:3e:76:77:25',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1475863',
                                                                                                                                            'mac_address': '0a:00:3e:76:7e:e4',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '26214400',
                                                                                                                                            'tx_modulation_rate': 200.0},
                                                                                                                                    {       'connected_time': '2127294',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:c7',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '419229',
                                                                                                                                            'mac_address': '0a:00:3e:75:86:11',
                                                                                                                                            'noise_floor': -93.8,
                                                                                                                                            'rssi': -67.8,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '925287',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:fd',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '13107200',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1341404',
                                                                                                                                            'mac_address': '0a:00:3e:75:9f:23',
                                                                                                                                            'noise_floor': -103.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '954477',
                                                                                                                                            'mac_address': '0a:00:3e:75:a0:86',
                                                                                                                                            'noise_floor': -91.9,
                                                                                                                                            'rssi': -63.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '3199987',
                                                                                                                                            'mac_address': '0a:00:3e:75:a3:18',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '3661568',
                                                                                                                                            'mac_address': '0a:00:3e:75:a5:b4',
                                                                                                                                            'noise_floor': -84.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '13107200',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1237208',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:43',
                                                                                                                                            'noise_floor': -83.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '13107200',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '3624520',
                                                                                                                                            'mac_address': '0a:00:3e:76:23:e7',
                                                                                                                                            'noise_floor': -92.7,
                                                                                                                                            'rssi': -64.7,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '4446545',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:7c',
                                                                                                                                            'noise_floor': -93.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '4446555',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:e3',
                                                                                                                                            'noise_floor': -99.8,
                                                                                                                                            'rssi': -68.8,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1383777',
                                                                                                                                            'mac_address': '0a:00:3e:75:a1:9d',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1159775',
                                                                                                                                            'mac_address': '0a:00:3e:75:9d:bc',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1655118',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:77',
                                                                                                                                            'noise_floor': -102.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '234280',
                                                                                                                                            'mac_address': '0a:00:3e:75:b1:aa',
                                                                                                                                            'noise_floor': -92.5,
                                                                                                                                            'rssi': -64.5,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '633013',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:dc',
                                                                                                                                            'noise_floor': -93.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446565',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:53',
                                                                                                                                            'noise_floor': -93.7,
                                                                                                                                            'rssi': -63.7,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446564',
                                                                                                                                            'mac_address': '0a:00:3e:76:40:f0',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '803595',
                                                                                                                                            'mac_address': '0a:00:3e:76:3c:fc',
                                                                                                                                            'noise_floor': -98.9,
                                                                                                                                            'rssi': -62.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446565',
                                                                                                                                            'mac_address': '0a:00:3e:76:43:67',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '4446558',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:27',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -70.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '4446525',
                                                                                                                                            'mac_address': '0a:00:3e:b4:9e:5e',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '2454351',
                                                                                                                                            'mac_address': '0a:00:3e:ba:bf:47',
                                                                                                                                            'noise_floor': -96.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446405',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:d8',
                                                                                                                                            'noise_floor': -95.9,
                                                                                                                                            'rssi': -64.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '289083',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e5:15',
                                                                                                                                            'noise_floor': -95.9,
                                                                                                                                            'rssi': -67.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '2366620',
                                                                                                                                            'mac_address': '0a:00:3e:b4:a0:c7',
                                                                                                                                            'noise_floor': -97.7,
                                                                                                                                            'rssi': -70.7,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '1433868',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e9:31',
                                                                                                                                            'noise_floor': -104.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 40.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1368610',
                                                                                                                                            'mac_address': '0a:00:3e:b4:52:46',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1414534',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:76',
                                                                                                                                            'noise_floor': -97.9,
                                                                                                                                            'rssi': -68.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446527',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e4:f7',
                                                                                                                                            'noise_floor': -95.4,
                                                                                                                                            'rssi': -65.4,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2103699',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e7:92',
                                                                                                                                            'noise_floor': -93.5,
                                                                                                                                            'rssi': -63.5,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1890510',
                                                                                                                                            'mac_address': '0a:00:3e:ba:af:b2',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446519',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:78',
                                                                                                                                            'noise_floor': -96.4,
                                                                                                                                            'rssi': -66.4,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446522',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:65',
                                                                                                                                            'noise_floor': -93.7,
                                                                                                                                            'rssi': -66.7,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1391452',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:7a',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446516',
                                                                                                                                            'mac_address': '0a:00:3e:b4:94:3f',
                                                                                                                                            'noise_floor': -100.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '267861',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:60',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446523',
                                                                                                                                            'mac_address': '0a:00:3e:b4:75:9d',
                                                                                                                                            'noise_floor': -93.5,
                                                                                                                                            'rssi': -65.5,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446541',
                                                                                                                                            'mac_address': '0a:00:3e:75:88:e9',
                                                                                                                                            'noise_floor': -94.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '984809',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ad:3d',
                                                                                                                                            'noise_floor': -91.9,
                                                                                                                                            'rssi': -64.9,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2144316',
                                                                                                                                            'mac_address': '0a:00:3e:b4:52:a1',
                                                                                                                                            'noise_floor': -92.4,
                                                                                                                                            'rssi': -65.4,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446517',
                                                                                                                                            'mac_address': '0a:00:3e:b4:73:dd',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0},
                                                                                                                                    {       'connected_time': '701908',
                                                                                                                                            'mac_address': '0a:00:3e:ba:aa:bf',
                                                                                                                                            'noise_floor': -100.9,
                                                                                                                                            'rssi': -64.9,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '425686',
                                                                                                                                            'mac_address': '0a:00:3e:76:1f:70',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '13107200',
                                                                                                                                            'rx_modulation_rate': 400.0,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '3414615',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:66',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '770096',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e9:23',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '473960',
                                                                                                                                            'mac_address': '0a:00:3e:ba:ea:5b',
                                                                                                                                            'noise_floor': -96.7,
                                                                                                                                            'rssi': -67.7,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '4446561',
                                                                                                                                            'mac_address': '0a:00:3e:75:9e:69',
                                                                                                                                            'noise_floor': -100.3,
                                                                                                                                            'rssi': -70.3,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 400.0},
                                                                                                                                    {       'connected_time': '4446349',
                                                                                                                                            'mac_address': '0a:00:3e:ba:e8:c7',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2784285',
                                                                                                                                            'mac_address': '0a:00:3e:76:2e:bc',
                                                                                                                                            'noise_floor': -98.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '655759',
                                                                                                                                            'mac_address': '0a:00:3e:75:b0:a2',
                                                                                                                                            'noise_floor': -100.2,
                                                                                                                                            'rssi': -71.2,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '26214400',
                                                                                                                                            'tx_modulation_rate': 170.0},
                                                                                                                                    {       'connected_time': '1025375',
                                                                                                                                            'mac_address': '0a:00:3e:76:7f:91',
                                                                                                                                            'noise_floor': -97.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '25316',
                                                                                                                                            'mac_address': '0a:00:3e:76:35:4e',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '2792704',
                                                                                                                                            'mac_address': '0a:00:3e:75:8a:85',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '26214400',
                                                                                                                                            'rx_modulation_rate': 800.0,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '1310268',
                                                                                                                                            'mac_address': '0a:00:3e:75:89:f0',
                                                                                                                                            'noise_floor': -99.2,
                                                                                                                                            'rssi': -68.2,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '52428800',
                                                                                                                                            'tx_modulation_rate': 410.0},
                                                                                                                                    {       'connected_time': '378543',
                                                                                                                                            'mac_address': '0a:00:3e:b4:4f:00',
                                                                                                                                            'noise_floor': -98.3,
                                                                                                                                            'rssi': -64.3,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '534141',
                                                                                                                                            'mac_address': '0a:00:3e:75:a6:c1',
                                                                                                                                            'noise_floor': -101.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '78643200',
                                                                                                                                            'tx_modulation_rate': 600.0},
                                                                                                                                    {       'connected_time': '100670',
                                                                                                                                            'mac_address': '0a:00:3e:76:48:9c',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19660800',
                                                                                                                                            'rx_modulation_rate': 600.0,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '104857600',
                                                                                                                                            'tx_modulation_rate': 800.0}],
                                                                                                                   'noise_floor': -83.0,
                                                                                                                   'polarization': 'HORIZONTAL'}],
                                                                                        'tx_average_group_size': 4.12,
                                                                                        'tx_frutl': 99.0,
                                                                                        'tx_multiplexing_gain': 2.36,
                                                                                        'tx_power': 20}],
                                                              'sectors': [       {       'mode': 'AP'}],
                                                              'type': 6}],
                                'latitude': 0.0,
                                'longitude': 0.0,
                                'manufacturer': 'Cambium',
                                'model': 'PMP 450m',
                                'serial_number': 'M9TG0TPCJSQ9',
                                'sw_version': 'CANOPY 15.1.5 AP-DES',
                                'system_mac_address': '0a:00:3e:60:3f:60',
                                'temperature': 27.0,
                                'uptime': '15904260'},
                'peers': [       {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '745815',
                                                                       'in_octets': '2584743787',
                                                                       'in_ucast_pkts': '629845115',
                                                                       'links': [       {       'in_octets': '4200902272',
                                                                                                'in_ucast_pkts': '376295767',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2584743787',
                                                                                                'out_ucast_pkts': '629845115'}],
                                                                       'mac_address': '0a:00:3e:75:db:d1',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '4200902272',
                                                                       'out_ucast_pkts': '376295767',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446567',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446567',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:db:d1'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '1202',
                                                                       'in_octets': '2709914301',
                                                                       'in_ucast_pkts': '227322988',
                                                                       'links': [       {       'in_octets': '1802137093',
                                                                                                'in_ucast_pkts': '170886585',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2709914301',
                                                                                                'out_ucast_pkts': '227322988'}],
                                                                       'mac_address': '0a:00:3e:75:89:61',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1802137093',
                                                                       'out_ucast_pkts': '170886585',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446563',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446563',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:89:61'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '239',
                                                                       'in_octets': '2015105589',
                                                                       'in_ucast_pkts': '120266064',
                                                                       'links': [       {       'in_octets': '1745523899',
                                                                                                'in_ucast_pkts': '79324033',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2015105589',
                                                                                                'out_ucast_pkts': '120266064'}],
                                                                       'mac_address': '0a:00:3e:75:9e:04',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1745523899',
                                                                       'out_ucast_pkts': '79324033',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '809889',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '809889',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '26214400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:9e:04'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '80',
                                                                       'in_octets': '1333574172',
                                                                       'in_ucast_pkts': '173106885',
                                                                       'links': [       {       'in_octets': '1359838632',
                                                                                                'in_ucast_pkts': '104187357',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '1333574172',
                                                                                                'out_ucast_pkts': '173106885'}],
                                                                       'mac_address': '0a:00:3e:75:73:58',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1359838632',
                                                                       'out_ucast_pkts': '104187357',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446563',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446563',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:73:58'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '53777',
                                                                       'in_octets': '3257194216',
                                                                       'in_ucast_pkts': '330306084',
                                                                       'links': [       {       'in_octets': '2745458251',
                                                                                                'in_ucast_pkts': '199242806',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3257194216',
                                                                                                'out_ucast_pkts': '330306084'}],
                                                                       'mac_address': '0a:00:3e:76:15:21',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '2745458251',
                                                                       'out_ucast_pkts': '199242806',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '997913',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '997913',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '26214400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:76:15:21'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '904',
                                                                       'in_octets': '4086595371',
                                                                       'in_ucast_pkts': '92315856',
                                                                       'links': [       {       'in_octets': '3389410539',
                                                                                                'in_ucast_pkts': '32408319',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '4086595371',
                                                                                                'out_ucast_pkts': '92315856'}],
                                                                       'mac_address': '0a:00:3e:76:7e:5b',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3389410539',
                                                                       'out_ucast_pkts': '32408319',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1409251',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 660.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1409251',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 660.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:76:7e:5b'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '22',
                                                                       'in_octets': '1678233896',
                                                                       'in_ucast_pkts': '66862575',
                                                                       'links': [       {       'in_octets': '363872546',
                                                                                                'in_ucast_pkts': '36395406',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '1678233896',
                                                                                                'out_ucast_pkts': '66862575'}],
                                                                       'mac_address': '0a:00:3e:75:89:c2',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '363872546',
                                                                       'out_ucast_pkts': '36395406',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2198867',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '2198867',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:89:c2'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '28131',
                                                                       'in_octets': '453147360',
                                                                       'in_ucast_pkts': '44418700',
                                                                       'links': [       {       'in_octets': '3889575485',
                                                                                                'in_ucast_pkts': '27342661',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '453147360',
                                                                                                'out_ucast_pkts': '44418700'}],
                                                                       'mac_address': '0a:00:3e:76:77:25',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3889575485',
                                                                       'out_ucast_pkts': '27342661',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '546452',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '546452',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:76:77:25'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '9912',
                                                                       'in_octets': '915620192',
                                                                       'in_ucast_pkts': '111097629',
                                                                       'links': [       {       'in_octets': '1911300665',
                                                                                                'in_ucast_pkts': '58602544',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '915620192',
                                                                                                'out_ucast_pkts': '111097629'}],
                                                                       'mac_address': '0a:00:3e:76:7e:e4',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1911300665',
                                                                       'out_ucast_pkts': '58602544',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '26214400',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1475863',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '26214400',
                                                                                                                                                     'rx_modulation_rate': 200.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1475863',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '26214400',
                                                                                                                                                     'rx_modulation_rate': 200.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:76:7e:e4'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '3269',
                                                                       'in_octets': '3280671092',
                                                                       'in_ucast_pkts': '181168426',
                                                                       'links': [       {       'in_octets': '3734965170',
                                                                                                'in_ucast_pkts': '71094029',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3280671092',
                                                                                                'out_ucast_pkts': '181168426'}],
                                                                       'mac_address': '0a:00:3e:75:89:c7',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3734965170',
                                                                       'out_ucast_pkts': '71094029',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2127294',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '2127294',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:89:c7'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '2715089097',
                                                                       'in_ucast_pkts': '50364526',
                                                                       'links': [       {       'in_octets': '189826403',
                                                                                                'in_ucast_pkts': '21022279',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2715089097',
                                                                                                'out_ucast_pkts': '50364526'}],
                                                                       'mac_address': '0a:00:3e:75:86:11',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '189826403',
                                                                       'out_ucast_pkts': '21022279',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '419229',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '419229',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:86:11'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '1428',
                                                                       'in_octets': '2609846349',
                                                                       'in_ucast_pkts': '103629207',
                                                                       'links': [       {       'in_octets': '4199162746',
                                                                                                'in_ucast_pkts': '44587839',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2609846349',
                                                                                                'out_ucast_pkts': '103629207'}],
                                                                       'mac_address': '0a:00:3e:75:89:fd',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '4199162746',
                                                                       'out_ucast_pkts': '44587839',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '925287',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '13107200',
                                                                                                                                                     'tx_modulation_rate': 400.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '925287',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '13107200',
                                                                                                                                                     'tx_modulation_rate': 400.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '13107200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:89:fd'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '3441555227',
                                                                       'in_ucast_pkts': '222189158',
                                                                       'links': [       {       'in_octets': '3701339757',
                                                                                                'in_ucast_pkts': '118758458',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3441555227',
                                                                                                'out_ucast_pkts': '222189158'}],
                                                                       'mac_address': '0a:00:3e:75:9f:23',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3701339757',
                                                                       'out_ucast_pkts': '118758458',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1341404',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1341404',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '26214400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:9f:23'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '1142',
                                                                       'in_octets': '347164330',
                                                                       'in_ucast_pkts': '135996576',
                                                                       'links': [       {       'in_octets': '3363942760',
                                                                                                'in_ucast_pkts': '85497932',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '347164330',
                                                                                                'out_ucast_pkts': '135996576'}],
                                                                       'mac_address': '0a:00:3e:75:a0:86',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3363942760',
                                                                       'out_ucast_pkts': '85497932',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '104857600',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '954477',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '104857600',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '954477',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '104857600',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:a0:86'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '15532',
                                                                       'in_octets': '1058990868',
                                                                       'in_ucast_pkts': '474467113',
                                                                       'links': [       {       'in_octets': '2890504927',
                                                                                                'in_ucast_pkts': '172200331',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '1058990868',
                                                                                                'out_ucast_pkts': '474467113'}],
                                                                       'mac_address': '0a:00:3e:75:a3:18',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '2890504927',
                                                                       'out_ucast_pkts': '172200331',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3199987',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '3199987',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:a3:18'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '1113785',
                                                                       'in_octets': '4152376510',
                                                                       'in_ucast_pkts': '1089651218',
                                                                       'links': [       {       'in_octets': '1987524331',
                                                                                                'in_ucast_pkts': '611509221',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '4152376510',
                                                                                                'out_ucast_pkts': '1089651218'}],
                                                                       'mac_address': '0a:00:3e:75:a5:b4',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1987524331',
                                                                       'out_ucast_pkts': '611509221',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3661568',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '13107200',
                                                                                                                                                     'tx_modulation_rate': 400.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '3661568',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '13107200',
                                                                                                                                                     'tx_modulation_rate': 400.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '13107200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:a5:b4'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '3511',
                                                                       'in_octets': '82045743',
                                                                       'in_ucast_pkts': '211446513',
                                                                       'links': [       {       'in_octets': '3009801092',
                                                                                                'in_ucast_pkts': '109272436',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '82045743',
                                                                                                'out_ucast_pkts': '211446513'}],
                                                                       'mac_address': '0a:00:3e:75:89:43',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3009801092',
                                                                       'out_ucast_pkts': '109272436',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1237208',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '13107200',
                                                                                                                                                     'tx_modulation_rate': 400.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1237208',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '13107200',
                                                                                                                                                     'tx_modulation_rate': 400.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '13107200'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:89:43'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '186523',
                                                                       'in_octets': '2908890094',
                                                                       'in_ucast_pkts': '443856517',
                                                                       'links': [       {       'in_octets': '3737856497',
                                                                                                'in_ucast_pkts': '229750707',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2908890094',
                                                                                                'out_ucast_pkts': '443856517'}],
                                                                       'mac_address': '0a:00:3e:76:23:e7',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3737856497',
                                                                       'out_ucast_pkts': '229750707',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3624520',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '3624520',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:76:23:e7'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '1482',
                                                                       'in_octets': '3774132477',
                                                                       'in_ucast_pkts': '539347354',
                                                                       'links': [       {       'in_octets': '189291744',
                                                                                                'in_ucast_pkts': '300731824',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3774132477',
                                                                                                'out_ucast_pkts': '539347354'}],
                                                                       'mac_address': '0a:00:3e:75:8a:7c',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '189291744',
                                                                       'out_ucast_pkts': '300731824',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446545',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446545',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:8a:7c'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '413031',
                                                                       'in_octets': '3676738331',
                                                                       'in_ucast_pkts': '492811489',
                                                                       'links': [       {       'in_octets': '2019353252',
                                                                                                'in_ucast_pkts': '223865145',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3676738331',
                                                                                                'out_ucast_pkts': '492811489'}],
                                                                       'mac_address': '0a:00:3e:75:89:e3',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '2019353252',
                                                                       'out_ucast_pkts': '223865145',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446555',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446555',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:89:e3'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '391416',
                                                                       'in_octets': '2307486457',
                                                                       'in_ucast_pkts': '523037757',
                                                                       'links': [       {       'in_octets': '602818337',
                                                                                                'in_ucast_pkts': '302040743',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2307486457',
                                                                                                'out_ucast_pkts': '523037757'}],
                                                                       'mac_address': '0a:00:3e:75:a1:9d',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '602818337',
                                                                       'out_ucast_pkts': '302040743',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1383777',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1383777',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:a1:9d'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '33927',
                                                                       'in_octets': '2525367039',
                                                                       'in_ucast_pkts': '162272328',
                                                                       'links': [       {       'in_octets': '1591335164',
                                                                                                'in_ucast_pkts': '85747851',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2525367039',
                                                                                                'out_ucast_pkts': '162272328'}],
                                                                       'mac_address': '0a:00:3e:75:9d:bc',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1591335164',
                                                                       'out_ucast_pkts': '85747851',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1159775',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1159775',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:9d:bc'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '4338',
                                                                       'in_octets': '332715305',
                                                                       'in_ucast_pkts': '78488333',
                                                                       'links': [       {       'in_octets': '3804384279',
                                                                                                'in_ucast_pkts': '43367703',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '332715305',
                                                                                                'out_ucast_pkts': '78488333'}],
                                                                       'mac_address': '0a:00:3e:75:89:77',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3804384279',
                                                                       'out_ucast_pkts': '43367703',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1655118',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1655118',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '26214400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:89:77'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '1679597808',
                                                                       'in_ucast_pkts': '7492884',
                                                                       'links': [       {       'in_octets': '434012680',
                                                                                                'in_ucast_pkts': '3752658',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '1679597808',
                                                                                                'out_ucast_pkts': '7492884'}],
                                                                       'mac_address': '0a:00:3e:75:b1:aa',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '434012680',
                                                                       'out_ucast_pkts': '3752658',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '234280',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '234280',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:b1:aa'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '2140',
                                                                       'in_octets': '296600505',
                                                                       'in_ucast_pkts': '151615394',
                                                                       'links': [       {       'in_octets': '3923933277',
                                                                                                'in_ucast_pkts': '96115825',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '296600505',
                                                                                                'out_ucast_pkts': '151615394'}],
                                                                       'mac_address': '0a:00:3e:75:8a:dc',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3923933277',
                                                                       'out_ucast_pkts': '96115825',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '633013',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '633013',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:8a:dc'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '37402',
                                                                       'in_octets': '4208960405',
                                                                       'in_ucast_pkts': '351900815',
                                                                       'links': [       {       'in_octets': '2973449671',
                                                                                                'in_ucast_pkts': '205558777',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '4208960405',
                                                                                                'out_ucast_pkts': '351900815'}],
                                                                       'mac_address': '0a:00:3e:75:8a:53',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '2973449671',
                                                                       'out_ucast_pkts': '205558777',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446565',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446565',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:8a:53'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '62289',
                                                                       'in_octets': '319875706',
                                                                       'in_ucast_pkts': '844518613',
                                                                       'links': [       {       'in_octets': '3257662461',
                                                                                                'in_ucast_pkts': '476333659',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '319875706',
                                                                                                'out_ucast_pkts': '844518613'}],
                                                                       'mac_address': '0a:00:3e:76:40:f0',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3257662461',
                                                                       'out_ucast_pkts': '476333659',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '104857600',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446564',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '104857600',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446564',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '104857600',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:76:40:f0'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '12177',
                                                                       'in_octets': '2600898505',
                                                                       'in_ucast_pkts': '71728068',
                                                                       'links': [       {       'in_octets': '587397911',
                                                                                                'in_ucast_pkts': '42081132',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2600898505',
                                                                                                'out_ucast_pkts': '71728068'}],
                                                                       'mac_address': '0a:00:3e:76:3c:fc',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '587397911',
                                                                       'out_ucast_pkts': '42081132',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '803595',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '803595',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:76:3c:fc'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '310297',
                                                                       'in_octets': '1646886159',
                                                                       'in_ucast_pkts': '824069598',
                                                                       'links': [       {       'in_octets': '1780955673',
                                                                                                'in_ucast_pkts': '478021388',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '1646886159',
                                                                                                'out_ucast_pkts': '824069598'}],
                                                                       'mac_address': '0a:00:3e:76:43:67',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1780955673',
                                                                       'out_ucast_pkts': '478021388',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '104857600',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446565',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '104857600',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446565',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '104857600',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '26214400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:76:43:67'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '76376',
                                                                       'in_octets': '86690369',
                                                                       'in_ucast_pkts': '593277077',
                                                                       'links': [       {       'in_octets': '2490623504',
                                                                                                'in_ucast_pkts': '323183365',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '86690369',
                                                                                                'out_ucast_pkts': '593277077'}],
                                                                       'mac_address': '0a:00:3e:75:89:27',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '2490623504',
                                                                       'out_ucast_pkts': '323183365',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446558',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446558',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:89:27'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '126195',
                                                                       'in_octets': '3333235078',
                                                                       'in_ucast_pkts': '356486004',
                                                                       'links': [       {       'in_octets': '202527714',
                                                                                                'in_ucast_pkts': '196140893',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3333235078',
                                                                                                'out_ucast_pkts': '356486004'}],
                                                                       'mac_address': '0a:00:3e:b4:9e:5e',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '202527714',
                                                                       'out_ucast_pkts': '196140893',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '104857600',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446525',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '104857600',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446525',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '104857600',
                                                                                                                                                     'rx_modulation_rate': 800.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:b4:9e:5e'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '24911',
                                                                       'in_octets': '2848373924',
                                                                       'in_ucast_pkts': '272183262',
                                                                       'links': [       {       'in_octets': '20167873',
                                                                                                'in_ucast_pkts': '235347319',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '2848373924',
                                                                                                'out_ucast_pkts': '272183262'}],
                                                                       'mac_address': '0a:00:3e:ba:bf:47',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '20167873',
                                                                       'out_ucast_pkts': '235347319',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2454351',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '2454351',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:ba:bf:47'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '13570',
                                                                       'in_octets': '4122203591',
                                                                       'in_ucast_pkts': '511879284',
                                                                       'links': [       {       'in_octets': '1080899193',
                                                                                                'in_ucast_pkts': '306478852',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '4122203591',
                                                                                                'out_ucast_pkts': '511879284'}],
                                                                       'mac_address': '0a:00:3e:ba:ea:d8',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '1080899193',
                                                                       'out_ucast_pkts': '306478852',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446405',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446405',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:ba:ea:d8'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '1702',
                                                                       'in_octets': '3666208577',
                                                                       'in_ucast_pkts': '10245235',
                                                                       'links': [       {       'in_octets': '2279585034',
                                                                                                'in_ucast_pkts': '4515170',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3666208577',
                                                                                                'out_ucast_pkts': '10245235'}],
                                                                       'mac_address': '0a:00:3e:ba:e5:15',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '2279585034',
                                                                       'out_ucast_pkts': '4515170',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '289083',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '289083',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:ba:e5:15'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '367000',
                                                                       'in_octets': '3386493003',
                                                                       'in_ucast_pkts': '147479849',
                                                                       'links': [       {       'in_octets': '4124930670',
                                                                                                'in_ucast_pkts': '66145776',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3386493003',
                                                                                                'out_ucast_pkts': '147479849'}],
                                                                       'mac_address': '0a:00:3e:b4:a0:c7',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '4124930670',
                                                                       'out_ucast_pkts': '66145776',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '52428800',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2366620',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '2366620',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '52428800',
                                                                                                                                                     'rx_modulation_rate': 400.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:b4:a0:c7'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '9174',
                                                                       'in_octets': '4259567971',
                                                                       'in_ucast_pkts': '181296509',
                                                                       'links': [       {       'in_octets': '721790815',
                                                                                                'in_ucast_pkts': '101806955',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '4259567971',
                                                                                                'out_ucast_pkts': '181296509'}],
                                                                       'mac_address': '0a:00:3e:ba:e9:31',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '721790815',
                                                                       'out_ucast_pkts': '101806955',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1433868',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1433868',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '26214400',
                                                                                                                                                     'tx_modulation_rate': 800.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '26214400'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:ba:e9:31'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '92668',
                                                                       'in_octets': '816522858',
                                                                       'in_ucast_pkts': '383431075',
                                                                       'links': [       {       'in_octets': '3655871347',
                                                                                                'in_ucast_pkts': '158564650',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '816522858',
                                                                                                'out_ucast_pkts': '383431075'}],
                                                                       'mac_address': '0a:00:3e:b4:52:46',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '3655871347',
                                                                       'out_ucast_pkts': '158564650',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1368610',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1368610',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:b4:52:46'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_octets': '1747474813',
                                                                       'in_ucast_pkts': '25910015',
                                                                       'links': [       {       'in_octets': '2026032296',
                                                                                                'in_ucast_pkts': '17436762',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '1747474813',
                                                                                                'out_ucast_pkts': '25910015'}],
                                                                       'mac_address': '0a:00:3e:75:8a:76',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '2026032296',
                                                                       'out_ucast_pkts': '17436762',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1414534',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '1414534',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450b',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:75:8a:76'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '25784',
                                                                       'in_octets': '3780950787',
                                                                       'in_ucast_pkts': '572133598',
                                                                       'links': [       {       'in_octets': '820401692',
                                                                                                'in_ucast_pkts': '369584809',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3780950787',
                                                                                                'out_ucast_pkts': '572133598'}],
                                                                       'mac_address': '0a:00:3e:ba:e4:f7',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '820401692',
                                                                       'out_ucast_pkts': '369584809',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4446527',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '4446527',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:ba:e4:f7'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '7454',
                                                                       'in_octets': '3260493090',
                                                                       'in_ucast_pkts': '104378078',
                                                                       'links': [       {       'in_octets': '989811996',
                                                                                                'in_ucast_pkts': '50187623',
                                                                                                'mac_address': '1a:00:3e:60:3f:60',
                                                                                                'out_octets': '3260493090',
                                                                                                'out_ucast_pkts': '104378078'}],
                                                                       'mac_address': '0a:00:3e:ba:e7:92',
                                                                       'name': 'Canopy '
                                                                               'MultiPoint',
                                                                       'out_discards': '0',
                                                                       'out_octets': '989811996',
                                                                       'out_ucast_pkts': '50187623',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 80,
                                                                                                 'frame_duration': 2500,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5840,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78643200',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2103699',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'VERTICAL'},
                                                                                                                    {       'id': '2',
                                                                                                                            'links': [       {       'connected_time': '2103699',
                                                                                                                                                     'mac_address': '1a:00:3e:60:3f:60',
                                                                                                                                                     'rx_link_rate': '78643200',
                                                                                                                                                     'rx_modulation_rate': 600.0,
                                                                                                                                                     'tx_link_rate': '19660800',
                                                                                                                                                     'tx_modulation_rate': 600.0}],
                                                                                                                            'polarization': 'HORIZONTAL'}],
                                                                                                 'tx_link_rate': '19660800'}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'Cambium',
                                         'model': 'PMP 450',
                                         'name': 'No Site Name',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'CANOPY 15.1.5',
                                         'system_mac_address': '0a:00:3e:ba:e7:92'},
                                 {       'interfaces': [       {       'id': '1',
                                                                       'in_discards': '251514',
                                                                       'in_octets': '298268821',
                                                                       'in_ucast_pkts': '472113402',
                 