import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):
    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_0_3_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.0.3.01")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 2,
                'sw_version': 'v4.0.3',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.0.5.01")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 12,
                'sw_version': 'v4.0.5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_1_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.1.0.01")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 42,
                'sw_version': 'v4.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.0.5.01")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 105,
                'sw_version': 'v4.0.5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_1_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.1.0.01")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 63,
                'sw_version': 'v4.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_4_9_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.4.9.01")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 8,
                'sw_version': 'v4.4.9',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': 8
        }
        exp_sta_stats = {
                '18:e8:29:0b:9a:d8': {       'dev_macs': {       '18:e8:29:0c:9a:d8',
                                                                 '74:4d:28:5b:15:46'},
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:0b:9a:d8',
                                             'name': '18:e8:29:0b:9a:d8'},
                '18:e8:29:f5:80:54': {       'dev_macs': {'18:b1:69:7a:34:51'},
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:80:54',
                                             'name': '22049-Darren Patterson Christian '
                                                     'Academy'},
                '18:e8:29:f5:b0:72': {       'dev_macs': {'68:d7:9a:67:b9:2d'},
                                             'ip_address': None,
                                             'mac_address': '18:e8:29:f5:b0:72',
                                             'name': '10340-carlin-walsh-ufiberwifi'},
                '74:83:c2:f0:1e:90': {       'dev_macs': {       '48:a9:8a:5f:bc:94',
                                                                 '74:83:c2:f1:1e:90'},
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:1e:90',
                                             'name': '756289-evan-bartlett-nanog'},
                '74:83:c2:f0:b1:a4': {       'dev_macs': {       '18:fd:74:1c:bf:7a',
                                                                 '74:83:c2:f1:b1:a4'},
                                             'ip_address': None,
                                             'mac_address': '74:83:c2:f0:b1:a4',
                                             'name': '756084-anna-toll'},
                'b4:fb:e4:eb:4d:58': {       'dev_macs': {       '48:8f:5a:49:bf:9b',
                                                                 'b4:fb:e4:ec:4d:58'},
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:4d:58',
                                             'name': '10523-jay-leaver-nanog'},
                'b4:fb:e4:eb:4d:62': {       'dev_macs': {       '34:98:b5:c4:4e:11',
                                                                 'b4:fb:e4:ec:4d:62'},
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:4d:62',
                                             'name': '24017-grace-garret-nanog'},
                'b4:fb:e4:eb:50:73': {       'dev_macs': {       '48:8f:5a:82:a9:f7',
                                                                 'b4:fb:e4:ec:50:73'},
                                             'ip_address': None,
                                             'mac_address': 'b4:fb:e4:eb:50:73',
                                             'name': '20157-ellen-kelly-nanog'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
