import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestPMP320Models(DeviceTestCase):    
    def test_cambium_pmp320_pmp320_PMP_320_System_Release_e2_3_01(self):
        obj = self.run_data("cambium-pmp320.pmp320.PMP 320.System_Release_e2.3.01")
        exp_info = {
                'gps_sync': False,
                'model': 'PMP 320',
                'rf_chan_width': 10,
                'rf_dl_percent': 75,
                'rf_freq': 3695,
                'rf_tx_power': 26,
                'sta_count': 4,
                'sw_version': 'System_Release_e2.3',
                'vendor': 'Cambium'
        }
        exp_stats = {
         'dl_noise_floor': None, 'ul_noise_floor': None
        }
        exp_sta_stats = {
                '64:ed:57:30:79:88': {       'dev_macs': ['a0:04:60:a3:f8:51'],
                                             'dl_noise_floor': -61.0,
                                             'dl_rssi': -71.0,
                                             'dl_snr': -10.0,
                                             'ip_address': None,
                                             'mac_address': '64:ed:57:30:79:88',
                                             'name': None,
                                             'ul_noise_floor': -104.0,
                                             'ul_rssi': -76.0,
                                             'ul_snr': 28.0},
                '64:ed:57:30:ec:d6': {       'dev_macs': ['8c:3b:ad:ff:cc:52'],
                                             'dl_noise_floor': -61.0,
                                             'dl_rssi': -71.0,
                                             'dl_snr': -10.0,
                                             'ip_address': None,
                                             'mac_address': '64:ed:57:30:ec:d6',
                                             'name': None,
                                             'ul_noise_floor': -107.0,
                                             'ul_rssi': -79.0,
                                             'ul_snr': 28.0},
                '64:ed:57:31:37:08': {       'dev_macs': ['84:2b:2b:b3:35:47'],
                                             'dl_noise_floor': -77.0,
                                             'dl_rssi': -87.0,
                                             'dl_snr': -10.0,
                                             'ip_address': None,
                                             'mac_address': '64:ed:57:31:37:08',
                                             'name': None,
                                             'ul_noise_floor': -109.0,
                                             'ul_rssi': -84.0,
                                             'ul_snr': 25.0},
                '64:ed:57:31:95:94': {       'dev_macs': ['14:91:82:60:ce:7f'],
                                             'dl_noise_floor': -55.0,
                                             'dl_rssi': -65.0,
                                             'dl_snr': -10.0,
                                             'ip_address': None,
                                             'mac_address': '64:ed:57:31:95:94',
                                             'name': None,
                                             'ul_noise_floor': -105.0,
                                             'ul_rssi': -79.0,
                                             'ul_snr': 26.0}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '64:ed:57:20:23:92',
                                                              'name': 'Radio Interface',
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Cambium',
                                'model': 'PMP 320',
                                'sw_version': 'System_Release_e2.3',
                                'system_mac_address': '64:ed:57:20:23:92'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and exp_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_pmp320_pmp320_PMP_320_System_Release_e2_3_02(self):
        obj = self.run_data("cambium-pmp320.pmp320.PMP 320.System_Release_e2.3.02")
        exp_info = {
                'gps_sync': True,
                'model': 'PMP 320',
                'rf_chan_width': 10,
                'rf_dl_percent': 75,
                'rf_freq': 3684,
                'rf_tx_power': 20,
                'sta_count': 5,
                'sw_version': 'System_Release_e2.3',
                'vendor': 'Cambium'
        }
        exp_stats = {
         'dl_noise_floor': None, 'ul_noise_floor': None
        }
        exp_sta_stats = {
                '64:ed:57:30:64:22': {       'dev_macs': ['24:f5:a2:6d:61:22'],
                                             'dl_noise_floor': -64.0,
                                             'dl_rssi': -74.0,
                                             'dl_snr': -10.0,
                                             'ip_address': None,
                                             'mac_address': '64:ed:57:30:64:22',
                                             'name': None,
                                             'ul_noise_floor': -108.0,
                                             'ul_rssi': -77.0,
                                             'ul_snr': 31.0},
                '64:ed:57:30:96:82': {       'dev_macs': ['ec:08:6b:6a:53:81'],
                                             'dl_noise_floor': -59.0,
                                             'dl_rssi': -69.0,
                                             'dl_snr': -10.0,
                                             'ip_address': None,
                                             'mac_address': '64:ed:57:30:96:82',
                                             'name': None,
                                             'ul_noise_floor': -108.0,
                                             'ul_rssi': -79.0,
                                             'ul_snr': 29.0},
                '64:ed:57:30:99:86': {       'dev_macs': ['50:c7:bf:a9:58:ad'],
                                             'dl_noise_floor': -63.0,
                                             'dl_rssi': -73.0,
                                             'dl_snr': -10.0,
                                             'ip_address': None,
                                             'mac_address': '64:ed:57:30:99:86',
                                             'name': None,
                                             'ul_noise_floor': -103.0,
                                             'ul_rssi': -73.0,
                                             'ul_snr': 30.0},
                '64:ed:57:31:33:82': {       'dev_macs': ['20:e5:2a:03:01:74'],
                                             'dl_noise_floor': -67.0,
                                             'dl_rssi': -77.0,
                                             'dl_snr': -10.0,
                                             'ip_address': None,
                                             'mac_address': '64:ed:57:31:33:82',
                                             'name': None,
                                             'ul_noise_floor': -104.0,
                                             'ul_rssi': -74.0,
                                             'ul_snr': 30.0},
                '64:ed:57:31:3c:ba': {       'dev_macs': ['cc:40:d0:13:cc:de'],
                                             'dl_noise_floor': -62.0,
                                             'dl_rssi': -72.0,
                                             'dl_snr': -10.0,
                                             'ip_address': None,
                                             'mac_address': '64:ed:57:31:3c:ba',
                                             'name': None,
                                             'ul_noise_floor': -114.0,
                                             'ul_rssi': -88.0,
                                             'ul_snr': 26.0}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '64:ed:57:20:25:1c',
                                                              'name': 'Radio Interface',
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Cambium',
                                'model': 'PMP 320',
                                'sw_version': 'System_Release_e2.3',
                                'system_mac_address': '64:ed:57:20:25:1c'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and exp_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_pmp320_pmp320_PMP_320_System_Release_e2_3_03(self):
        obj = self.run_data("cambium-pmp320.pmp320.PMP 320.System_Release_e2.3.03")
        exp_info = {
                'gps_sync': True,
                'model': 'PMP 320',
                'rf_chan_width': 10,
                'rf_dl_percent': 75,
                'rf_freq': 3666,
                'rf_tx_power': 20,
                'sta_count': 0,
                'sw_version': 'System_Release_e2.3',
                'vendor': 'Cambium'
        }
        exp_stats = {
         'dl_noise_floor': None, 'ul_noise_floor': None
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '64:ed:57:20:02:d8',
                                                              'name': 'Radio Interface',
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Cambium',
                                'model': 'PMP 320',
                                'sw_version': 'System_Release_e2.3',
                                'system_mac_address': '64:ed:57:20:02:d8'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and exp_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
