import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestBlinqModels(DeviceTestCase):
    def test_blinq_enb_Blinq_eNB_1_3_10_1_01(self):
        obj = self.run_data("blinq.enb.Blinq eNB.1.3.10_1.01")
        exp_info = {
                'model': 'RevC05',
                'sta_count': 38,
                'sw_version': '1.3.10_1',
                'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '001015432100145': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100145',
                                           'ip_address': None,
                                           'name': '6000',
                                           'ul_rssi': None},
                '001015432100146': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100146',
                                           'ip_address': None,
                                           'name': '30000',
                                           'ul_rssi': None},
                '001015432100147': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100147',
                                           'ip_address': None,
                                           'name': '6000',
                                           'ul_rssi': None},
                '001015432100148': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100148',
                                           'ip_address': None,
                                           'name': '5000',
                                           'ul_rssi': None},
                '001015432100149': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100149',
                                           'ip_address': None,
                                           'name': '6000',
                                           'ul_rssi': None},
                '001015432100224': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100224',
                                           'ip_address': None,
                                           'name': '150000',
                                           'ul_rssi': None},
                '001015432100225': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100225',
                                           'ip_address': None,
                                           'name': '3000',
                                           'ul_rssi': None},
                '001015432100226': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100226',
                                           'ip_address': None,
                                           'name': '4000',
                                           'ul_rssi': None},
                '001015432100227': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100227',
                                           'ip_address': None,
                                           'name': '4000',
                                           'ul_rssi': None},
                '00101543210027': {       'dev_macs': None,
                                          'dl_rssi': None,
                                          'imsi': '00101543210027',
                                          'ip_address': None,
                                          'name': '10000',
                                          'ul_rssi': None},
                '999995432100099': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100099',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100100': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100100',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100101': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100101',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100102': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100102',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100103': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100103',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100104': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100104',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100105': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100105',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100106': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100106',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100107': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100107',
                                           'ip_address': None,
                                           'name': '10000',
                                           'ul_rssi': None},
                '999995432100108': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100108',
                                           'ip_address': None,
                                           'name': '10000',
                                           'ul_rssi': None},
                '999995432100109': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100109',
                                           'ip_address': None,
                                           'name': '5000',
                                           'ul_rssi': None},
                '999995432100110': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100110',
                                           'ip_address': None,
                                           'name': '5000',
                                           'ul_rssi': None},
                '999995432100111': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100111',
                                           'ip_address': None,
                                           'name': '10000',
                                           'ul_rssi': None},
                '999995432100112': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100112',
                                           'ip_address': None,
                                           'name': '10000',
                                           'ul_rssi': None},
                '999995432100113': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100113',
                                           'ip_address': None,
                                           'name': '10000',
                                           'ul_rssi': None},
                '999995432100114': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100114',
                                           'ip_address': None,
                                           'name': '10000',
                                           'ul_rssi': None},
                '999995432100115': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100115',
                                           'ip_address': None,
                                           'name': '10000',
                                           'ul_rssi': None},
                '999995432100116': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100116',
                                           'ip_address': None,
                                           'name': '10000',
                                           'ul_rssi': None},
                '999995432100117': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100117',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100118': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100118',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100119': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100119',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100120': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100120',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100121': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100121',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100122': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100122',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100123': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100123',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100124': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100124',
                                           'ip_address': None,
                                           'name': '0',
                                           'ul_rssi': None},
                '999995432100172': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100172',
                                           'ip_address': None,
                                           'name': '8000',
                                           'ul_rssi': None},
                '999995432101': {       'dev_macs': None,
                                        'dl_rssi': None,
                                        'imsi': '999995432101',
                                        'ip_address': None,
                                        'name': '100000',
                                        'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '0c:a1:38:00:04:f9',
                                                              'name': 'WLAN Interface',
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'RevC05',
                                'serial_number': '60101C5-18520010',
                                'sw_version': '1.3.10_1',
                                'system_mac_address': '0c:a1:38:00:04:f9'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_Blinq_eNB_2_0_9_1_01(self):
        obj = self.run_data("blinq.enb.Blinq eNB.2.0.9_1.01")
        exp_info = {
         'model': 'RevC05', 'sta_count': 35, 'sw_version': '2.0.9_1', 'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '001015432100145': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100145',
                                           'ip_address': '10.0.0.145',
                                           'name': 'Bruce Dresselhouse',
                                           'ul_rssi': -112.14},
                '001015432100146': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100146',
                                           'ip_address': '10.0.0.146',
                                           'name': None,
                                           'ul_rssi': -103.77},
                '001015432100147': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100147',
                                           'ip_address': '10.0.0.147',
                                           'name': 'Dave Zimmer',
                                           'ul_rssi': -96.49},
                '001015432100148': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100148',
                                           'ip_address': '10.0.0.148',
                                           'name': None,
                                           'ul_rssi': -111.52},
                '001015432100149': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100149',
                                           'ip_address': '10.0.0.149',
                                           'name': 'Barbara Haist',
                                           'ul_rssi': -96.19},
                '001015432100224': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100224',
                                           'ip_address': '10.0.0.224',
                                           'name': None,
                                           'ul_rssi': None},
                '001015432100225': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100225',
                                           'ip_address': '10.0.0.225',
                                           'name': 'Jessica Richer',
                                           'ul_rssi': -112.15},
                '001015432100226': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100226',
                                           'ip_address': '10.0.0.226',
                                           'name': 'Bryan Reynolds',
                                           'ul_rssi': -95.19},
                '001015432100227': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '001015432100227',
                                           'ip_address': '10.0.0.227',
                                           'name': 'Curt Peterfeso',
                                           'ul_rssi': -102.91},
                '999995432100107': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100107',
                                           'ip_address': '10.0.0.7',
                                           'name': 'Cindy Fischaber',
                                           'ul_rssi': None},
                '999995432100108': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100108',
                                           'ip_address': '10.0.0.8',
                                           'name': 'Darrel Bergor',
                                           'ul_rssi': -115.75},
                '999995432100109': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100109',
                                           'ip_address': '10.0.0.109',
                                           'name': 'Mark Daane',
                                           'ul_rssi': -95.89},
                '999995432100110': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100110',
                                           'ip_address': '10.0.0.10',
                                           'name': 'Jerry Richardson',
                                           'ul_rssi': -94.98},
                '999995432100111': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100111',
                                           'ip_address': '10.0.0.11',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100112': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100112',
                                           'ip_address': '10.0.0.12',
                                           'name': 'Randal Wright',
                                           'ul_rssi': -106.94},
                '999995432100113': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100113',
                                           'ip_address': '10.0.0.13',
                                           'name': 'Mike Carry',
                                           'ul_rssi': -98.13},
                '999995432100114': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100114',
                                           'ip_address': '10.0.0.14',
                                           'name': 'Judy Ligi',
                                           'ul_rssi': None},
                '999995432100115': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100115',
                                           'ip_address': '10.0.0.15',
                                           'name': 'Anthony Hicks',
                                           'ul_rssi': -100.17},
                '999995432100116': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100116',
                                           'ip_address': '10.0.0.16',
                                           'name': None,
                                           'ul_rssi': -96.95},
                '999995432100117': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100117',
                                           'ip_address': '10.0.0.17',
                                           'name': 'Thomas Steele',
                                           'ul_rssi': -96.32},
                '999995432100119': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100119',
                                           'ip_address': '10.0.0.19',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100120': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100120',
                                           'ip_address': '10.0.0.120',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100121': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100121',
                                           'ip_address': '10.0.0.121',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100122': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100122',
                                           'ip_address': '10.0.0.122',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100158': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100158',
                                           'ip_address': '10.0.0.158',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100159': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100159',
                                           'ip_address': '10.0.0.159',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100160': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100160',
                                           'ip_address': '10.0.0.160',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100161': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100161',
                                           'ip_address': '10.0.0.161',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100162': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100162',
                                           'ip_address': '10.0.0.162',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100163': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100163',
                                           'ip_address': '10.0.0.163',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100164': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100164',
                                           'ip_address': '10.0.0.164',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100165': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100165',
                                           'ip_address': '10.0.0.165',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100166': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100166',
                                           'ip_address': '10.0.0.166',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100167': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100167',
                                           'ip_address': '10.0.0.167',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100172': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100172',
                                           'ip_address': '10.0.0.172',
                                           'name': 'Eric Wheeler',
                                           'ul_rssi': -112.54}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '0c:a1:38:00:04:f9',
                                                              'name': 'WLAN Interface',
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'RevC05',
                                'serial_number': '60101C5-18520010',
                                'sw_version': '2.0.9_1',
                                'system_mac_address': '0c:a1:38:00:04:f9'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_Blinq_eNB_4_0_4_1_10_11_254_10(self):
        obj = self.run_data("blinq.enb.Blinq eNB.4.0.4_1.10_11_254_10")
        exp_info = {
                'model': 'FW-300i B48',
                'sta_count': 28,
                'sw_version': '4.0.4_1',
                'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '999995432100825': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100825',
                                           'ip_address': '10.201.12.11',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100890': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100890',
                                           'ip_address': '10.201.12.19',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100909': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100909',
                                           'ip_address': '10.201.12.10',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100940': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100940',
                                           'ip_address': '10.201.12.28',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100986': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100986',
                                           'ip_address': '10.201.12.14',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101034': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101034',
                                           'ip_address': '10.201.12.23',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101038': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101038',
                                           'ip_address': '10.201.12.29',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101045': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101045',
                                           'ip_address': '10.201.12.18',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101047': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101047',
                                           'ip_address': '10.201.12.24',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101053': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101053',
                                           'ip_address': '10.201.12.17',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101201': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101201',
                                           'ip_address': '10.201.12.27',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101224': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101224',
                                           'ip_address': '10.201.12.16',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101234': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101234',
                                           'ip_address': '10.201.12.75',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101245': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101245',
                                           'ip_address': '10.201.12.34',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102212': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102212',
                                           'ip_address': '10.201.12.30',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102213': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102213',
                                           'ip_address': '10.201.12.36',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102214': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102214',
                                           'ip_address': '10.201.12.33',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102215': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102215',
                                           'ip_address': '10.201.12.48',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102222': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102222',
                                           'ip_address': '10.201.12.12',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102223': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102223',
                                           'ip_address': '10.201.12.32',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102226': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102226',
                                           'ip_address': '10.201.12.52',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102227': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102227',
                                           'ip_address': '10.201.12.35',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105000': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105000',
                                           'ip_address': '10.201.12.13',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105003': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105003',
                                           'ip_address': '10.201.12.26',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105007': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105007',
                                           'ip_address': '10.201.12.20',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105076': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105076',
                                           'ip_address': '10.201.12.25',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105079': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105079',
                                           'ip_address': '10.201.12.31',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432107457': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432107457',
                                           'ip_address': '10.201.12.37',
                                           'name': None,
                                           'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '0c:a1:38:00:04:98',
                                                              'name': 'WLAN Interface',
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'FW-300i B48',
                                'serial_number': 'A181107455',
                                'sw_version': '4.0.4_1',
                                'system_mac_address': '0c:a1:38:00:04:98'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_Blinq_eNB_4_1_6_1_01(self):
        obj = self.run_data("blinq.enb.Blinq eNB.4.1.6_1.01")
        exp_info = {
                'model': 'X-300i B48',
                'sta_count': 110,
                'sw_version': '4.1.6_1',
                'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '999995432108256': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108256',
                                           'ip_address': '172.28.12.2',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108257': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108257',
                                           'ip_address': '172.28.12.3',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108258': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108258',
                                           'ip_address': '172.28.12.4',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108259': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108259',
                                           'ip_address': '172.28.12.5',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108260': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108260',
                                           'ip_address': '172.28.12.6',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108261': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108261',
                                           'ip_address': '172.28.12.7',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108262': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108262',
                                           'ip_address': '172.28.12.8',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108263': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108263',
                                           'ip_address': '172.28.12.9',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108264': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108264',
                                           'ip_address': '172.28.12.10',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108266': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108266',
                                           'ip_address': '172.28.12.11',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108267': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108267',
                                           'ip_address': '172.28.12.12',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108268': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108268',
                                           'ip_address': '172.28.12.13',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108269': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108269',
                                           'ip_address': '172.28.12.14',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108270': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108270',
                                           'ip_address': '172.28.12.15',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108271': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108271',
                                           'ip_address': '172.28.12.16',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108272': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108272',
                                           'ip_address': '172.28.12.17',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108273': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108273',
                                           'ip_address': '172.28.12.18',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108274': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108274',
                                           'ip_address': '172.28.12.19',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108275': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108275',
                                           'ip_address': '172.28.12.20',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108276': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108276',
                                           'ip_address': '172.28.12.21',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108277': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108277',
                                           'ip_address': '172.28.12.22',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108278': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108278',
                                           'ip_address': '172.28.12.23',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108279': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108279',
                                           'ip_address': '172.28.12.24',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108280': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108280',
                                           'ip_address': '172.28.12.25',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108281': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108281',
                                           'ip_address': '172.28.12.26',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108282': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108282',
                                           'ip_address': '172.28.12.27',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108283': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108283',
                                           'ip_address': '172.28.12.28',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108284': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108284',
                                           'ip_address': '172.28.12.29',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108285': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108285',
                                           'ip_address': '172.28.12.30',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108286': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108286',
                                           'ip_address': '172.28.12.31',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108287': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108287',
                                           'ip_address': '172.28.12.32',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108288': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108288',
                                           'ip_address': '172.28.12.33',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108289': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108289',
                                           'ip_address': '172.28.12.34',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108290': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108290',
                                           'ip_address': '172.28.12.35',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108291': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108291',
                                           'ip_address': '172.28.12.36',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108292': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108292',
                                           'ip_address': '172.28.12.37',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108293': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108293',
                                           'ip_address': '172.28.12.38',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108294': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108294',
                                           'ip_address': '172.28.12.39',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108295': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108295',
                                           'ip_address': '172.28.12.40',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108296': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108296',
                                           'ip_address': '172.28.12.41',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108297': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108297',
                                           'ip_address': '172.28.12.42',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108298': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108298',
                                           'ip_address': '172.28.12.43',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108299': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108299',
                                           'ip_address': '172.28.12.44',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108300': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108300',
                                           'ip_address': '172.28.12.45',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108301': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108301',
                                           'ip_address': '172.28.12.46',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108302': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108302',
                                           'ip_address': '172.28.12.47',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108303': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108303',
                                           'ip_address': '172.28.12.48',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108304': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108304',
                                           'ip_address': '172.28.12.49',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108305': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108305',
                                           'ip_address': '172.28.12.50',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108306': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108306',
                                           'ip_address': '172.28.12.51',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108307': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108307',
                                           'ip_address': '172.28.12.52',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108308': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108308',
                                           'ip_address': '172.28.12.53',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108309': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108309',
                                           'ip_address': '172.28.12.54',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108310': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108310',
                                           'ip_address': '172.28.12.55',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108311': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108311',
                                           'ip_address': '172.28.12.56',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108312': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108312',
                                           'ip_address': '172.28.12.57',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108313': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108313',
                                           'ip_address': '172.28.12.58',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108314': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108314',
                                           'ip_address': '172.28.12.59',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108315': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108315',
                                           'ip_address': '172.28.12.60',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108316': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108316',
                                           'ip_address': '172.28.12.61',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108317': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108317',
                                           'ip_address': '172.28.12.62',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108318': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108318',
                                           'ip_address': '172.28.12.63',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108319': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108319',
                                           'ip_address': '172.28.12.64',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108320': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108320',
                                           'ip_address': '172.28.12.65',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108321': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108321',
                                           'ip_address': '172.28.12.66',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108322': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108322',
                                           'ip_address': '172.28.12.67',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108323': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108323',
                                           'ip_address': '172.28.12.68',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108324': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108324',
                                           'ip_address': '172.28.12.69',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108325': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108325',
                                           'ip_address': '172.28.12.70',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108326': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108326',
                                           'ip_address': '172.28.12.71',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108327': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108327',
                                           'ip_address': '172.28.12.72',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108328': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108328',
                                           'ip_address': '172.28.12.73',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108329': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108329',
                                           'ip_address': '172.28.12.74',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108330': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108330',
                                           'ip_address': '172.28.12.75',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108331': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108331',
                                           'ip_address': '172.28.12.76',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108332': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108332',
                                           'ip_address': '172.28.12.77',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108333': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108333',
                                           'ip_address': '172.28.12.78',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108334': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108334',
                                           'ip_address': '172.28.12.79',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108335': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108335',
                                           'ip_address': '172.28.12.80',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108336': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108336',
                                           'ip_address': '172.28.12.81',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108337': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108337',
                                           'ip_address': '172.28.12.82',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108338': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108338',
                                           'ip_address': '172.28.12.83',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108339': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108339',
                                           'ip_address': '172.28.12.84',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108340': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108340',
                                           'ip_address': '172.28.12.85',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108341': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108341',
                                           'ip_address': '172.28.12.86',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108342': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108342',
                                           'ip_address': '172.28.12.87',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108343': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108343',
                                           'ip_address': '172.28.12.88',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108344': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108344',
                                           'ip_address': '172.28.12.89',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108345': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108345',
                                           'ip_address': '172.28.12.90',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108346': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108346',
                                           'ip_address': '172.28.12.91',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108347': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108347',
                                           'ip_address': '172.28.12.92',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108348': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108348',
                                           'ip_address': '172.28.12.93',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108349': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108349',
                                           'ip_address': '172.28.12.94',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108350': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108350',
                                           'ip_address': '172.28.12.95',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108351': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108351',
                                           'ip_address': '172.28.12.96',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108352': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108352',
                                           'ip_address': '172.28.12.97',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108353': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108353',
                                           'ip_address': '172.28.12.98',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108354': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108354',
                                           'ip_address': '172.28.12.99',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108355': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108355',
                                           'ip_address': '172.28.12.100',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108356': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108356',
                                           'ip_address': '172.28.12.101',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108357': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108357',
                                           'ip_address': '172.28.12.102',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108358': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108358',
                                           'ip_address': '172.28.12.103',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108359': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108359',
                                           'ip_address': '172.28.12.104',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108360': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108360',
                                           'ip_address': '172.28.12.105',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108361': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108361',
                                           'ip_address': '172.28.12.106',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108362': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108362',
                                           'ip_address': '172.28.12.107',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108363': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108363',
                                           'ip_address': '172.28.12.108',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108364': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108364',
                                           'ip_address': '172.28.12.109',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108365': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108365',
                                           'ip_address': '172.28.12.110',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432108400': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432108400',
                                           'ip_address': '172.28.12.111',
                                           'name': None,
                                           'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '0c:a1:38:10:00:68',
                                                              'name': 'WLAN Interface',
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'X-300i B48',
                                'serial_number': '60101D2-20481105',
                                'sw_version': '4.1.6_1',
                                'system_mac_address': '0c:a1:38:10:00:68'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_blinq_enb_FW_300i_B48_3_0_6_1_10_11_254_10(self):
        obj = self.run_data("blinq.enb.FW-300i B48.3.0.6_1.10_11_254_10")
        exp_info = {
                'model': 'FW-300i B48',
                'sta_count': 29,
                'sw_version': '3.0.6_1',
                'vendor': 'Blinq'
        }
        exp_stats = {
         
        }
        exp_sta_stats = {
                '999995432100825': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100825',
                                           'ip_address': '10.201.12.11',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100890': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100890',
                                           'ip_address': '10.201.12.19',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100909': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100909',
                                           'ip_address': '10.201.12.10',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100940': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100940',
                                           'ip_address': '10.201.12.28',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432100986': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432100986',
                                           'ip_address': '10.201.12.14',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101034': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101034',
                                           'ip_address': '10.201.12.23',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101038': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101038',
                                           'ip_address': '10.201.12.29',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101045': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101045',
                                           'ip_address': '10.201.12.18',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101047': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101047',
                                           'ip_address': '10.201.12.24',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101053': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101053',
                                           'ip_address': '10.201.12.17',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101201': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101201',
                                           'ip_address': '10.201.12.27',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101224': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101224',
                                           'ip_address': '10.201.12.16',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101234': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101234',
                                           'ip_address': '10.201.12.75',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432101245': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432101245',
                                           'ip_address': '10.201.12.34',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102212': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102212',
                                           'ip_address': '10.201.12.30',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102213': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102213',
                                           'ip_address': '10.201.12.36',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102214': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102214',
                                           'ip_address': '10.201.12.33',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102215': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102215',
                                           'ip_address': '10.201.12.48',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102222': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102222',
                                           'ip_address': '10.201.12.12',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102223': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102223',
                                           'ip_address': '10.201.12.32',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102226': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102226',
                                           'ip_address': '10.201.12.52',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432102227': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432102227',
                                           'ip_address': '10.201.12.35',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432103388': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432103388',
                                           'ip_address': '10.201.12.53',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105000': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105000',
                                           'ip_address': '10.201.12.13',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105003': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105003',
                                           'ip_address': '10.201.12.26',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105007': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105007',
                                           'ip_address': '10.201.12.20',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105076': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105076',
                                           'ip_address': '10.201.12.25',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432105079': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432105079',
                                           'ip_address': '10.201.12.31',
                                           'name': None,
                                           'ul_rssi': None},
                '999995432107457': {       'dev_macs': None,
                                           'dl_rssi': None,
                                           'imsi': '999995432107457',
                                           'ip_address': '10.201.12.37',
                                           'name': None,
                                           'ul_rssi': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'id': '1',
                                                              'mac_address': '0c:a1:38:00:04:98',
                                                              'name': 'WLAN Interface',
                                                              'sectors': [       {       'mode': 'AP'}]}],
                                'manufacturer': 'Blinq',
                                'model': 'FW-300i B48',
                                'serial_number': 'A181107455',
                                'sw_version': '3.0.6_1',
                                'system_mac_address': '0c:a1:38:00:04:98'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
