import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.0.5.01")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 105,
                'sw_version': 'v4.0.5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else getattr(obj.stations[0], 'mac_address', 'imsi')
        cur_info = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_1_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.1.0.01")
        exp_info = {
                'model': 'UFiber OLT',
                'rf_tx_power': None,
                'sta_count': 63,
                'sw_version': 'v4.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else getattr(obj.stations[0], 'mac_address', 'imsi')
        cur_info = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_0_3_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.0.3.01")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 2,
                'sw_version': 'v4.0.3',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else getattr(obj.stations[0], 'mac_address', 'imsi')
        cur_info = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_0_5_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.0.5.01")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 12,
                'sw_version': 'v4.0.5',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else getattr(obj.stations[0], 'mac_address', 'imsi')
        cur_info = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_1_0_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.1.0.01")
        exp_info = {
                'model': 'UFiber OLT4',
                'rf_tx_power': None,
                'sta_count': 42,
                'sw_version': 'v4.1.0',
                'vendor': 'Ubiquiti'
        }
        exp_stats = {
         'cpu': None
        }
        exp_sta_stats = {
         
        }
        id_field = 'mac_address' if not obj.stations else getattr(obj.stations[0], 'mac_address', 'imsi')
        cur_info = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        cur_stats = {x: getattr(obj, x) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'cpe', obj.model) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in obj.stations}
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)

